(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18261,        652]
NotebookOptionsPosition[     14323,        520]
NotebookOutlinePosition[     15771,        559]
CellTagsIndexPosition[     15686,        554]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Sets of Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSetsOfTransformationRules"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Manipulating Sets of Transformation Rules\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReplaceAll" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceAll"], "Compile" :> 
          Documentation`HelpLookup["paclet:ref/Compile"], "Hash" :> 
          Documentation`HelpLookup["paclet:ref/Hash"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ReplaceAll\"\>", 
       2->"\<\"Compile\"\>", 3->"\<\"Hash\"\>", 
       4->"\<\"SparseArray\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Time Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dispatch", "ObjectName",
 CellID->22371],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dispatch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dispatch"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["lhs", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["rhs", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["lhs", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["rhs", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates an optimized dispatch table representation of \
a list of rules. The object produced by ",
     Cell[BoxData[
      ButtonBox["Dispatch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
     " can be used to give the rules in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "/.", 
       StyleBox["rules", "TI"]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22952]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The use of ",
 Cell[BoxData[
  ButtonBox["Dispatch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
 " will never affect results that are obtained, but may make the application \
of long lists of rules much faster. "
}], "Notes",
 CellID->3544],

Cell[TextData[{
 "Lists of rules are usually scanned sequentially when you evaluate an \
expression like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "/.", 
   StyleBox["rules", "TI"]}]], "InlineFormula"],
 ". Rules such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "->", "a1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "[", "2", "]"}], "->", "a2"}]], "InlineFormula"],
 ", which cannot simultaneously apply, need not both be scanned explicitly. \
",
 Cell[BoxData[
  ButtonBox["Dispatch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
 " generates a dispatch table which uses hash codes to specify which sets of \
rules need actually be scanned for a particular input expression. "
}], "Notes",
 CellID->15744],

Cell[TextData[{
 "Lists of rules produced by assignments made with ",
 Cell[BoxData["="], "InlineFormula"],
 " and ",
 Cell[BoxData[":="], "InlineFormula"],
 " are automatically optimized with dispatch tables when appropriate. "
}], "Notes",
 CellID->4688]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13653808],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->562883030],

Cell["Create a dispatch table from a list of rules: ", "ExampleText",
 CellID->227131938],

Cell[BoxData[
 RowBox[{
  RowBox[{"rules", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "c"}], ",", 
     RowBox[{"c", "\[Rule]", "a"}], ",", 
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"e", "\[Rule]", "d"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138391359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dispatch", " ", "=", " ", 
  RowBox[{"Dispatch", "[", "rules", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->408946139],

Cell[BoxData[
 TagBox[
  RowBox[{"Dispatch", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "b"}], ",", 
      RowBox[{"b", "\[Rule]", "c"}], ",", 
      RowBox[{"c", "\[Rule]", "a"}], ",", 
      RowBox[{"d", "\[Rule]", "e"}], ",", 
      RowBox[{"e", "\[Rule]", "d"}]}], "}"}], ",", 
    TagBox[
     InterpretationBox[
      RowBox[{"-", "DispatchTables", "-"}],
      1],
     DisplayForm]}], "]"}],
  Function[BoxForm`arg, 
   ReplacePart[
    HoldComplete[
     Dispatch[ProgrammingDump`dumy]], 
    HoldComplete[BoxForm`arg], {1, 1}, {1, 1}], {HoldAllComplete}]]], "Output",\

 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96815287]
}, Open  ]],

Cell["The result after replacements is the same: ", "ExampleText",
 CellID->258340184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], " ", "/.", 
  " ", "rules"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->338017581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "a", ",", "e", ",", "d"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->98387251]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], "/.", 
  "dispatch"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->277376278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "a", ",", "e", ",", "d"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->375610840]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->383572706],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dispatch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
 " may be much faster for a long list of rules:"
}], "ExampleText",
 CellID->383795999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"rules", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "i", "]"}], "\[Rule]", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "i"}], "}"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10000"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117625788],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"x", "[", "2", "]"}], "\[Rule]", "2"}], ",", 
    RowBox[{
     RowBox[{"x", "[", "3", "]"}], "\[Rule]", "3"}], ",", 
    RowBox[{"\[LeftSkeleton]", "9994", "\[RightSkeleton]"}], ",", 
    RowBox[{
     RowBox[{"x", "[", "9998", "]"}], "\[Rule]", "292"}], ",", 
    RowBox[{
     RowBox[{"x", "[", "9999", "]"}], "\[Rule]", "4105"}], ",", 
    RowBox[{
     RowBox[{"x", "[", "10000", "]"}], "\[Rule]", "8870"}]}], "}"}],
  Short]], "Output",
 ImageSize->{576, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->3378596]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"dispatch", " ", "=", " ", 
   RowBox[{"Dispatch", "[", "rules", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26744058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "i", "]"}], " ", "/.", " ", "rules"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->391883267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6110000000000015`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->558704298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "i", "]"}], " ", "/.", " ", "dispatch"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->334175870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.2065682614424986`*^-15", ",", "Null"}], "}"}]], "Output",
 ImageSize->{147, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->328319292]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11062],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31945]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20275],

Cell[TextData[ButtonBox["Manipulating Sets of Transformation Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSetsOfTransformationRules"]], "Tutorials",
 CellID->29316]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->80210337],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->730816559]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dispatch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 30.3834162}", "context" -> "System`", 
    "keywords" -> {
     "efficiency", "hashing", "transformation rules", "hash table", 
      "table lookup", "optimization of computation"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Dispatch[{lhs_1 -> rhs_1, lhs_2 -> rhs_2, ...}] generates an optimized \
dispatch table representation of a list of rules. The object produced by \
Dispatch can be used to give the rules in expr /. rules. ", "synonyms" -> {}, 
    "title" -> "Dispatch", "type" -> "Symbol", "uri" -> "ref/Dispatch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6087, 196, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13653808]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15544, 547}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2152, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2775, 80, 46, 1, 70, "ObjectName",
 CellID->22371],
Cell[2824, 83, 1347, 42, 70, "Usage",
 CellID->22952]
}, Open  ]],
Cell[CellGroupData[{
Cell[4208, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4686, 147, 295, 9, 70, "Notes",
 CellID->3544],
Cell[4984, 158, 807, 24, 70, "Notes",
 CellID->15744],
Cell[5794, 184, 256, 7, 70, "Notes",
 CellID->4688]
}, Closed]],
Cell[CellGroupData[{
Cell[6087, 196, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13653808],
Cell[CellGroupData[{
Cell[6471, 210, 148, 5, 70, "ExampleSection",
 CellID->562883030],
Cell[6622, 217, 89, 1, 70, "ExampleText",
 CellID->227131938],
Cell[6714, 220, 363, 11, 70, "Input",
 CellID->138391359],
Cell[CellGroupData[{
Cell[7102, 235, 148, 4, 28, "Input",
 CellID->408946139],
Cell[7253, 241, 746, 26, 36, "Output",
 CellID->96815287]
}, Open  ]],
Cell[8014, 270, 86, 1, 70, "ExampleText",
 CellID->258340184],
Cell[CellGroupData[{
Cell[8125, 275, 187, 6, 70, "Input",
 CellID->338017581],
Cell[8315, 283, 232, 7, 36, "Output",
 CellID->98387251]
}, Open  ]],
Cell[CellGroupData[{
Cell[8584, 295, 180, 6, 70, "Input",
 CellID->277376278],
Cell[8767, 303, 233, 7, 36, "Output",
 CellID->375610840]
}, Open  ]],
Cell[9015, 313, 125, 3, 70, "ExampleDelimiter",
 CellID->383572706],
Cell[9143, 318, 222, 7, 70, "ExampleText",
 CellID->383795999],
Cell[CellGroupData[{
Cell[9390, 329, 418, 13, 70, "Input",
 CellID->117625788],
Cell[9811, 344, 727, 22, 36, "Output",
 CellID->3378596]
}, Open  ]],
Cell[10553, 369, 166, 5, 70, "Input",
 CellID->26744058],
Cell[CellGroupData[{
Cell[10744, 378, 307, 10, 70, "Input",
 CellID->391883267],
Cell[11054, 390, 224, 7, 36, "Output",
 CellID->558704298]
}, Open  ]],
Cell[CellGroupData[{
Cell[11315, 402, 310, 10, 70, "Input",
 CellID->334175870],
Cell[11628, 414, 230, 7, 39, "Output",
 CellID->328319292]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11919, 428, 311, 9, 70, "SeeAlsoSection",
 CellID->11062],
Cell[12233, 439, 941, 35, 70, "SeeAlso",
 CellID->31945]
}, Open  ]],
Cell[CellGroupData[{
Cell[13211, 479, 314, 9, 70, "TutorialsSection",
 CellID->20275],
Cell[13528, 490, 192, 4, 70, "Tutorials",
 CellID->29316]
}, Open  ]],
Cell[CellGroupData[{
Cell[13757, 499, 318, 9, 70, "MoreAboutSection",
 CellID->80210337],
Cell[14078, 510, 173, 3, 70, "MoreAbout",
 CellID->730816559]
}, Open  ]],
Cell[14266, 516, 27, 0, 70, "History"],
Cell[14296, 518, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

