(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10264,        365]
NotebookOptionsPosition[      7484,        273]
NotebookOutlinePosition[      8859,        312]
CellTagsIndexPosition[      8775,        307]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FullForm" :> Documentation`HelpLookup["paclet:ref/FullForm"], 
          "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "ToBoxes" :> 
          Documentation`HelpLookup["paclet:ref/ToBoxes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FullForm\"\>", 2->"\<\"ToExpression\"\>", 
       3->"\<\"ToBoxes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DisplayForm", "ObjectName",
 CellID->24886],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DisplayForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DisplayForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with low-level boxes inside ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " shown in explicit two\[Hyphen]dimensional or other form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9541]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ordinary ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " output, boxes such as ",
 Cell[BoxData[
  ButtonBox["SubscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubscriptBox"]], "InlineFormula"],
 " are shown literally. In ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " they are shown as explicit two\[Hyphen]dimensional constructs. "
}], "Notes",
 CellID->15022],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->10090]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1980269],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->732866852],

Cell["Display a box expression as formatted:", "ExampleText",
 CellID->77935726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SubscriptBox", "[", 
  RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->477266627],

Cell[BoxData[
 RowBox[{"SubscriptBox", "[", 
  RowBox[{"\<\"x\"\>", ",", "\<\"y\"\>"}], "]"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316763566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->340923382],

Cell[BoxData[
 TagBox[
  SubscriptBox["x", "y"],
  DisplayForm]], "Output",
 ImageSize->{17, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//DisplayForm=",
 CellID->325890442]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10494],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12956],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->5659],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DisplayForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 35.0085346}", "context" -> "System`", 
    "keywords" -> {
     "box display", "box interpretation", "convert from boxes", 
      "display boxes", "explicit form of expression"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DisplayForm[expr] prints with low-level boxes inside expr shown in \
explicit two-dimensional or other form. ", "synonyms" -> {"display form"}, 
    "title" -> "DisplayForm", "type" -> "Symbol", "uri" -> 
    "ref/DisplayForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4264, 140, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1980269]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8634, 300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1562, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2185, 64, 49, 1, 70, "ObjectName",
 CellID->24886],
Cell[2237, 67, 620, 18, 70, "Usage",
 CellID->9541]
}, Open  ]],
Cell[CellGroupData[{
Cell[2894, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3372, 107, 566, 18, 70, "Notes",
 CellID->15022],
Cell[3941, 127, 286, 8, 70, "Notes",
 CellID->10090]
}, Closed]],
Cell[CellGroupData[{
Cell[4264, 140, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1980269],
Cell[CellGroupData[{
Cell[4647, 154, 148, 5, 70, "ExampleSection",
 CellID->732866852],
Cell[4798, 161, 80, 1, 70, "ExampleText",
 CellID->77935726],
Cell[CellGroupData[{
Cell[4903, 166, 147, 4, 28, "Input",
 CellID->477266627],
Cell[5053, 172, 236, 7, 36, "Output",
 CellID->316763566]
}, Open  ]],
Cell[CellGroupData[{
Cell[5326, 184, 107, 3, 28, "Input",
 CellID->340923382],
Cell[5436, 189, 218, 8, 52, "Output",
 CellID->325890442]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5715, 204, 311, 9, 70, "SeeAlsoSection",
 CellID->10494],
Cell[6029, 215, 702, 26, 70, "SeeAlso",
 CellID->26257]
}, Open  ]],
Cell[CellGroupData[{
Cell[6768, 246, 314, 9, 70, "TutorialsSection",
 CellID->12956],
Cell[7085, 257, 178, 4, 70, "Tutorials",
 CellID->5659],
Cell[7266, 263, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[7427, 269, 27, 0, 70, "History"],
Cell[7457, 271, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

