(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17708,        564]
NotebookOptionsPosition[     14612,        465]
NotebookOutlinePosition[     16052,        504]
CellTagsIndexPosition[     15967,        499]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$DisplayFunction" :> 
          Documentation`HelpLookup["paclet:ref/$DisplayFunction"], "Show" :> 
          Documentation`HelpLookup["paclet:ref/Show"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$DisplayFunction\"\>", 
       2->"\<\"Show\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DisplayFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DisplayFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DisplayFunction"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics and sound functions that \
specifies a function to apply to graphics and sound objects before returning \
them."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The typical default setting is ",
 Cell[BoxData[
  RowBox[{"DisplayFunction", ":>", 
   ButtonBox["$DisplayFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$DisplayFunction"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13293],

Cell[TextData[{
 "With a notebook front end, ",
 Cell[BoxData[
  ButtonBox["$DisplayFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DisplayFunction"]], "InlineFormula"],
 " is normally ",
 Cell[BoxData[
  ButtonBox["Identity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Identity"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3775],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DisplayFunction", "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       ButtonBox["Print",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Print"], "[", "#", "]"}], ";"}], "&"}], 
    ")"}]}]], "InlineFormula"],
 " prints the graphic in a separate cell."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2762],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ", as well as functions like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ", automatically apply the function specified by the setting for ",
 Cell[BoxData[
  ButtonBox["DisplayFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayFunction"]], "InlineFormula"],
 " before returning their results."
}], "Notes",
 CellID->15634]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->414359665],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->42680382],

Cell[TextData[{
 "Display a graphic in ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " when clicked:"
}], "ExampleText",
 CellID->637693758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"DisplayFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"PopupWindow", "[", 
       RowBox[{
        RowBox[{"Button", "[", "\"\<Click here\>\"", "]"}], ",", "#"}], "]"}],
       "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142178588],

Cell[BoxData[
 ButtonBox[
  ButtonBox["\<\"Click here\"\>",
   Appearance->Automatic,
   ButtonData->"paclet:ref/Click here",
   ButtonFrame->"DialogBox",
   ButtonFunction:>{},
   Evaluator->None,
   Method->"Preemptive"],
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook[
     Graphics[{
       RGBColor[1, 0.5, 0.5], 
       Rectangle[{0, 0}]}, {DisplayFunction -> (PopupWindow[
         Button["Click here"], #]& )}]]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{60, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208788227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1646945],

Cell["Display a graphic in a new notebook:", "ExampleText",
 CellID->165046845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "CreateDocument"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->215885240],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["jcq_shm", 1, 1]], 92]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["\<\"Untitled-18\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    FrameMargins->{{4, 5}, {4, 4}}], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["jcq_shm", 1, 1]], 92],
  Editable->False]], "Output",
 ImageSize->{208, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70541786]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27465],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DisplayFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$DisplayFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Show",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Show"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23005]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3886],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DisplayFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 35.2429156}", "context" -> "System`", 
    "keywords" -> {
     "output devices for graphics", "graphics channel", "graphics pipeline", 
      "graphics device", "graphics conversion"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DisplayFunction is an option for graphics and sound functions that \
specifies a function to apply to graphics and sound objects before returning \
them.", "synonyms" -> {"display function"}, "title" -> "DisplayFunction", 
    "type" -> "Symbol", "uri" -> "ref/DisplayFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9226, 258, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->414359665]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15824, 492}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1418, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2041, 62, 4199, 83, 70, "ObjectNameGrid"],
Cell[6243, 147, 533, 15, 70, "Usage",
 CellID->9376]
}, Open  ]],
Cell[CellGroupData[{
Cell[6813, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7291, 184, 261, 9, 70, "Notes",
 CellID->13293],
Cell[7555, 195, 482, 16, 70, "Notes",
 CellID->3775],
Cell[8040, 213, 484, 16, 70, "Notes",
 CellID->2762],
Cell[8527, 231, 662, 22, 70, "Notes",
 CellID->15634]
}, Closed]],
Cell[CellGroupData[{
Cell[9226, 258, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->414359665],
Cell[CellGroupData[{
Cell[9611, 272, 147, 5, 70, "ExampleSection",
 CellID->42680382],
Cell[9761, 279, 223, 8, 70, "ExampleText",
 CellID->637693758],
Cell[CellGroupData[{
Cell[10009, 291, 471, 15, 47, "Input",
 CellID->142178588],
Cell[10483, 308, 713, 25, 46, "Output",
 CellID->208788227]
}, Open  ]],
Cell[11211, 336, 123, 3, 70, "ExampleDelimiter",
 CellID->1646945],
Cell[11337, 341, 79, 1, 70, "ExampleText",
 CellID->165046845],
Cell[CellGroupData[{
Cell[11441, 346, 307, 10, 70, "Input",
 CellID->215885240],
Cell[11751, 358, 1281, 41, 70, "Output",
 CellID->70541786]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13093, 406, 311, 9, 70, "SeeAlsoSection",
 CellID->27465],
Cell[13407, 417, 459, 17, 70, "SeeAlso",
 CellID->23005]
}, Open  ]],
Cell[CellGroupData[{
Cell[13903, 439, 313, 9, 70, "TutorialsSection",
 CellID->3886],
Cell[14219, 450, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[14360, 455, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[14532, 461, 50, 0, 70, "History"],
Cell[14585, 463, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

