(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11591,        431]
NotebookOptionsPosition[      8197,        318]
NotebookOutlinePosition[      9512,        355]
CellTagsIndexPosition[      9428,        350]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DisplayEndPacket" :> 
          Documentation`HelpLookup["paclet:ref/DisplayEndPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"DisplayEndPacket\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DisplayPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DisplayPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DisplayPacket"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet that indicates the beginning of a series of expressions related \
to a postscript graphic."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->170105719],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->1215824468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312144257],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "767", ",", "7"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163051939]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->625050465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2053461425],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75759298]
}, Open  ]],

Cell["Write an expression that generates a postscript graphic:", "ExampleText",
 CellID->316479038],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{
     RowBox[{"Off", "[", 
      RowBox[{"FrontEndObject", "::", "notavail"}], "]"}], ";", 
     RowBox[{"Get", "[", "\"\<Version5`Graphics`\>\"", "]"}], ";", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "Pi"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->216242856],

Cell[TextData[{
 "Read the ",
 Cell[BoxData[
  ButtonBox["DisplayPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayPacket"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->1400582518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1420596703],

Cell[BoxData[
 RowBox[{"DisplayPacket", "[", "\<\"\"\>", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->321265802]
}, Open  ]],

Cell["Read the series of expressions for the postscript graphic:", \
"ExampleText",
 CellID->2032750524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"LinkRead", "[", "link", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1041227580],

Cell[BoxData[
 TagBox[
  RowBox[{"DisplayPacket", "[", 
   RowBox[{"\<\"%!\\n%%Creator: Mathematica\\n%%Aspect\"\>", 
    "\[Ellipsis]", "\<\"e\\n% End of Graphics\\nMathPictureEnd\\n\"\>"}], 
   "]"}],
  Short]], "Output",
 ImageSize->{158, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//Short=",
 CellID->13950710]
}, Open  ]],

Cell[TextData[{
 "Read the ",
 Cell[BoxData[
  ButtonBox["DisplayEndPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayEndPacket"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->120716745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1775671936],

Cell[BoxData[
 RowBox[{"DisplayEndPacket", "[", "\<\"\"\>", "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->520910352]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1054932471],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DisplayEndPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayEndPacket"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DisplayPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 35.7116776}", "context" -> "", 
    "keywords" -> {"MathLink packet", "postscript graphic packet"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DisplayPacket[] is a MathLink packet that indicates the beginning of a \
series of expressions related to a postscript graphic.", 
    "synonyms" -> {"display packet"}, "title" -> "DisplayPacket", "type" -> 
    "Symbol", "uri" -> "ref/DisplayPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2585, 87, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9294, 343}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1265, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1888, 60, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1947, 63, 601, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2585, 87, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2962, 101, 148, 5, 70, "ExampleSection",
 CellID->170105719],
Cell[3113, 108, 149, 6, 70, "ExampleText",
 CellID->1215824468],
Cell[CellGroupData[{
Cell[3287, 118, 234, 7, 28, "Input",
 CellID->312144257],
Cell[3524, 127, 260, 8, 36, "Output",
 CellID->163051939]
}, Open  ]],
Cell[3799, 138, 65, 1, 70, "ExampleText",
 CellID->625050465],
Cell[CellGroupData[{
Cell[3889, 143, 108, 3, 28, "Input",
 CellID->2053461425],
Cell[4000, 148, 214, 6, 36, "Output",
 CellID->75759298]
}, Open  ]],
Cell[4229, 157, 99, 1, 70, "ExampleText",
 CellID->316479038],
Cell[4331, 160, 511, 15, 70, "Input",
 CellID->216242856],
Cell[4845, 177, 214, 8, 70, "ExampleText",
 CellID->1400582518],
Cell[CellGroupData[{
Cell[5084, 189, 108, 3, 70, "Input",
 CellID->1420596703],
Cell[5195, 194, 205, 6, 36, "Output",
 CellID->321265802]
}, Open  ]],
Cell[5415, 203, 104, 2, 70, "ExampleText",
 CellID->2032750524],
Cell[CellGroupData[{
Cell[5544, 209, 140, 4, 70, "Input",
 CellID->1041227580],
Cell[5687, 215, 361, 11, 122, "Output",
 CellID->13950710]
}, Open  ]],
Cell[6063, 229, 219, 8, 70, "ExampleText",
 CellID->120716745],
Cell[CellGroupData[{
Cell[6307, 241, 108, 3, 70, "Input",
 CellID->1775671936],
Cell[6418, 246, 208, 6, 36, "Output",
 CellID->520910352]
}, Open  ]],
Cell[6641, 255, 59, 1, 70, "ExampleText",
 CellID->1054932471],
Cell[6703, 258, 109, 3, 70, "Input",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6861, 267, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7180, 278, 216, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7433, 289, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7754, 300, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[8140, 314, 27, 0, 70, "History"],
Cell[8170, 316, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

