(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17522,        700]
NotebookOptionsPosition[     12632,        527]
NotebookOutlinePosition[     13875,        563]
CellTagsIndexPosition[     13790,        558]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TimesBy" :> Documentation`HelpLookup["paclet:ref/TimesBy"], 
          "SubtractFrom" :> 
          Documentation`HelpLookup["paclet:ref/SubtractFrom"], "Divide" :> 
          Documentation`HelpLookup["paclet:ref/Divide"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"TimesBy\"\>", 2->"\<\"SubtractFrom\"\>", 
       3->"\<\"Divide\"\>", 4->"\<\"Set\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "DivideBy ",
 StyleBox["(/=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->28660],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "/=", 
       StyleBox["c", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]divides ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " and returns the new value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24000]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DivideBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivideBy"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1030],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "/=", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   RowBox[{
    StyleBox["x", "TI"], "/", 
    StyleBox["c", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20515]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->129859551],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->249751325],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "15"}], ";"}], "\n", 
 RowBox[{"k", "/=", "3"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->340805381],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->652241460]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[2]:=",
 CellID->559954938],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->376591637]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->543191452],

Cell["Divide by a numerical value:", "ExampleText",
 CellID->1113876286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "1.5"}], ";", " ", 
  RowBox[{"x", "/=", "2.5"}], ";", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1774324750],

Cell[BoxData["0.6`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734706372]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153126013],

Cell["Divide by a symbolic value:", "ExampleText",
 CellID->838884225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "a"}], ";", 
  RowBox[{"v", "/=", "b"}], ";", "v"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698859122],

Cell[BoxData[
 FractionBox["a", "b"]], "Output",
 ImageSize->{16, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651960401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174130550],

Cell["Divide all values in a list by a scalar:", "ExampleText",
 CellID->822015323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2332824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488310300]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "/=", "2"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1729906436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", "1", ",", 
   FractionBox["3", "2"]}], "}"}]], "Output",
 ImageSize->{70, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->764011110]
}, Open  ]],

Cell["Divide all values in a list by another list:", "ExampleText",
 CellID->142182714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "/=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "20", ",", "30"}], "}"}]}], ";", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->628970065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "20"], ",", 
   FractionBox["1", "20"], ",", 
   FractionBox["1", "20"]}], "}"}]], "Output",
 ImageSize->{95, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->72276581]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->56020413],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DivideBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivideBy"]], "InlineFormula"],
 " is a short form of this assignment:"
}], "ExampleText",
 CellID->322174398],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "8"}], ";"}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"k", "/", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->13919786],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93590537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->461427463],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimesBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimesBy"]], "InlineFormula"],
 " is closely related:"
}], "ExampleText",
 CellID->311642178],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "2"}], ";"}], "\n", 
 RowBox[{"k", "/=", "2"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->70435602],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33406772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "*=", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->427238025],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->838042286]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3458200],

Cell["A variable to be divided must have an initial value:", "ExampleText",
 CellID->992262862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/=", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397421414],

Cell[BoxData[
 RowBox[{
  RowBox[{"DivideBy", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) is not a variable with a value, so its value cannot be \
changed.\"\>"}]], "Message", "MSG",
 CellID->745938128],

Cell[BoxData[
 RowBox[{"x", "/=", "2"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3290617]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17742],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimesBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimesBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubtractFrom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubtractFrom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divide",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divide"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17710],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->22361]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DivideBy (/=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 43.0087394}", "context" -> "System`", 
    "keywords" -> {"DivideBy", "fused division assignment"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "x /= c divides x by c and returns the new value of x. ", 
    "synonyms" -> {"divide by", "/="}, "title" -> "DivideBy", "type" -> 
    "Symbol", "uri" -> "ref/DivideBy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4020, 145, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->129859551]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13647, 551}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1470, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2093, 62, 102, 4, 70, "ObjectName",
 CellID->28660],
Cell[2198, 68, 632, 22, 70, "Usage",
 CellID->24000]
}, Open  ]],
Cell[CellGroupData[{
Cell[2867, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3345, 112, 313, 12, 70, "Notes",
 CellID->1030],
Cell[3661, 126, 322, 14, 70, "Notes",
 CellID->20515]
}, Closed]],
Cell[CellGroupData[{
Cell[4020, 145, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->129859551],
Cell[CellGroupData[{
Cell[4405, 159, 148, 5, 70, "ExampleSection",
 CellID->249751325],
Cell[CellGroupData[{
Cell[4578, 168, 147, 5, 47, "Input",
 CellID->340805381],
Cell[4728, 175, 158, 5, 36, "Output",
 CellID->652241460]
}, Open  ]],
Cell[CellGroupData[{
Cell[4923, 185, 70, 2, 28, "Input",
 CellID->559954938],
Cell[4996, 189, 158, 5, 36, "Output",
 CellID->376591637]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5203, 200, 220, 7, 70, "ExampleSection",
 CellID->543191452],
Cell[5426, 209, 72, 1, 70, "ExampleText",
 CellID->1113876286],
Cell[CellGroupData[{
Cell[5523, 214, 159, 5, 70, "Input",
 CellID->1774324750],
Cell[5685, 221, 161, 5, 36, "Output",
 CellID->734706372]
}, Open  ]],
Cell[5861, 229, 125, 3, 70, "ExampleDelimiter",
 CellID->153126013],
Cell[5989, 234, 70, 1, 70, "ExampleText",
 CellID->838884225],
Cell[CellGroupData[{
Cell[6084, 239, 150, 5, 70, "Input",
 CellID->1698859122],
Cell[6237, 246, 178, 6, 49, "Output",
 CellID->651960401]
}, Open  ]],
Cell[6430, 255, 125, 3, 70, "ExampleDelimiter",
 CellID->174130550],
Cell[6558, 260, 83, 1, 70, "ExampleText",
 CellID->822015323],
Cell[CellGroupData[{
Cell[6666, 265, 147, 5, 70, "Input",
 CellID->2332824],
Cell[6816, 272, 213, 7, 36, "Output",
 CellID->488310300]
}, Open  ]],
Cell[CellGroupData[{
Cell[7066, 284, 117, 4, 70, "Input",
 CellID->1729906436],
Cell[7186, 290, 257, 9, 51, "Output",
 CellID->764011110]
}, Open  ]],
Cell[7458, 302, 87, 1, 70, "ExampleText",
 CellID->142182714],
Cell[CellGroupData[{
Cell[7570, 307, 178, 6, 70, "Input",
 CellID->628970065],
Cell[7751, 315, 281, 10, 51, "Output",
 CellID->72276581]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8081, 331, 236, 7, 70, "ExampleSection",
 CellID->56020413],
Cell[8320, 340, 213, 7, 70, "ExampleText",
 CellID->322174398],
Cell[CellGroupData[{
Cell[8558, 351, 167, 6, 70, "Input",
 CellID->13919786],
Cell[8728, 359, 157, 5, 36, "Output",
 CellID->93590537]
}, Open  ]],
Cell[8900, 367, 125, 3, 70, "ExampleDelimiter",
 CellID->461427463],
Cell[9028, 372, 195, 7, 70, "ExampleText",
 CellID->311642178],
Cell[CellGroupData[{
Cell[9248, 383, 145, 5, 70, "Input",
 CellID->70435602],
Cell[9396, 390, 157, 5, 36, "Output",
 CellID->33406772]
}, Open  ]],
Cell[CellGroupData[{
Cell[9590, 400, 93, 3, 70, "Input",
 CellID->427238025],
Cell[9686, 405, 158, 5, 36, "Output",
 CellID->838042286]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9893, 416, 228, 7, 70, "ExampleSection",
 CellID->3458200],
Cell[10124, 425, 95, 1, 70, "ExampleText",
 CellID->992262862],
Cell[CellGroupData[{
Cell[10244, 430, 94, 3, 70, "Input",
 CellID->1397421414],
Cell[10341, 435, 213, 5, 70, "Message",
 CellID->745938128],
Cell[10557, 442, 179, 6, 36, "Output",
 CellID->3290617]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10797, 455, 311, 9, 70, "SeeAlsoSection",
 CellID->17742],
Cell[11111, 466, 933, 35, 70, "SeeAlso",
 CellID->20525]
}, Open  ]],
Cell[CellGroupData[{
Cell[12081, 506, 314, 9, 70, "TutorialsSection",
 CellID->17710],
Cell[12398, 517, 162, 3, 70, "Tutorials",
 CellID->22361]
}, Open  ]],
Cell[12575, 523, 27, 0, 70, "History"],
Cell[12605, 525, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

