(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32386,       1196]
NotebookOptionsPosition[     25587,        954]
NotebookOutlinePosition[     26842,        990]
CellTagsIndexPosition[     26757,        985]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mod" :> Documentation`HelpLookup["paclet:ref/Mod"], "GCD" :> 
          Documentation`HelpLookup["paclet:ref/GCD"], "Divisors" :> 
          Documentation`HelpLookup["paclet:ref/Divisors"], "Quotient" :> 
          Documentation`HelpLookup["paclet:ref/Quotient"], "CoprimeQ" :> 
          Documentation`HelpLookup["paclet:ref/CoprimeQ"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"], "EvenQ" :> 
          Documentation`HelpLookup["paclet:ref/EvenQ"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mod\"\>", 2->"\<\"GCD\"\>", 
       3->"\<\"Divisors\"\>", 4->"\<\"Quotient\"\>", 5->"\<\"CoprimeQ\"\>", 
       6->"\<\"PrimeQ\"\>", 7->"\<\"EvenQ\"\>", 
       8->"\<\"Round\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Divisible", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Divisible",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Divisible"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is divisible by ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ", and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if it is not. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " works for integers or rational numbers ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22596],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Divisible",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divisible"]], "InlineFormula"],
 " works with exact numeric quantities, as well as explicit numbers. "
}], "Notes",
 CellID->2591],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Divisible",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divisible"]], "InlineFormula"],
 " works with exact complex numbers. "
}], "Notes",
 CellID->1845],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " only if ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "/", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 " is an integer."
}], "Notes",
 CellID->1266],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"]}], "]"}], "==", "0"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26100],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Divisible",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divisible"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18605]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->530969353],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->28305936],

Cell["Test whether 10 is divisible by 3:", "ExampleText",
 CellID->5174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{"10", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5912],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1688807927]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17852],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Divisible",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divisible"]], "InlineFormula"],
 " works with numbers of any size:"
}], "ExampleText",
 CellID->11385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "100"}], "-", "1"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15217],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->503466690]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20368],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Divisible",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divisible"]], "InlineFormula"],
 " threads itself element-wise over lists:"
}], "ExampleText",
 CellID->12896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"200", ",", "201", ",", "202", ",", "203"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "False", ",", "False"}], "}"}]], "Output",\

 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679089650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Divisible", "[", 
    RowBox[{
     RowBox[{"2", "x"}], ",", "x"}], "]"}], ",", 
   RowBox[{"x", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27154],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1731647392]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22570],

Cell["Symbolic forms of numeric quantities:", "ExampleText",
 CellID->30939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{"2", "Pi"}], ",", 
   RowBox[{"Pi", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30218],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1099333200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7287],

Cell["Rational numbers:", "ExampleText",
 CellID->27645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{"3", "/", "4"}], ",", 
   RowBox[{"1", "/", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21194],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1691277259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9894],

Cell["Gaussian integers:", "ExampleText",
 CellID->11558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{"3", "+", "I"}], ",", 
   RowBox[{"2", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23150],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1203340321]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{
   RowBox[{"3", "+", "I"}], ",", 
   RowBox[{"2", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26717],

Cell[BoxData[
 RowBox[{"1", "+", "\[ImaginaryI]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1687271248]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1902],

Cell["Numeric quantities:", "ExampleText",
 CellID->18034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "6", "]"}], ",", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2168],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446306501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21795],

Cell[TextData[{
 "With symbolic inputs, ",
 Cell[BoxData[
  ButtonBox["Divisible",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divisible"]], "InlineFormula"],
 " stays unevaluated:"
}], "ExampleText",
 CellID->2064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26539],

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2060466983]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9573],

Cell["Select numbers that are divisible by 3:", "ExampleText",
 CellID->22633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], ",", 
   RowBox[{
    RowBox[{"Divisible", "[", 
     RowBox[{"#", ",", "3"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22452],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "6", ",", "9", ",", "12", ",", "15", ",", "18"}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2094775406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9499],

Cell["Highlight numbers that are divisible by 3:", "ExampleText",
 CellID->3589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"Divisible", "[", 
      RowBox[{"#", ",", "3"}], "]"}], ",", 
     RowBox[{"Framed", "[", "#", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   FrameBox["3",
    StripOnInput->False], ",", "4", ",", "5", ",", 
   FrameBox["6",
    StripOnInput->False], ",", "7", ",", "8", ",", 
   FrameBox["9",
    StripOnInput->False], ",", "10", ",", "11", ",", 
   FrameBox["12",
    StripOnInput->False], ",", "13", ",", "14", ",", 
   FrameBox["15",
    StripOnInput->False], ",", "16", ",", "17", ",", 
   FrameBox["18",
    StripOnInput->False], ",", "19", ",", "20"}], "}"}]], "Output",
 ImageSize->{508, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1043339724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3354],

Cell["Show numbers that divide exactly:", "ExampleText",
 CellID->1816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{"Divisible", "[", 
      RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "100"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21699],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1mltWxCAMhoM7cUsuYY7v7v/N0VLKJYFc/nB0pFOSjxJyocfP18/X64OI
vusvUXn/vNv/R2m953Jq4g2x/SGqKC9sV7lqGB5CodDMJMQ8j4hyWeTqlgc5
/y3CtQYxKPapOSKqPWwy1uHSfnLpFKSJhQi6bUgaOzR+CWmdU1dHb35C7DD7
HIjtQtsw1eYbR7BlOjReyKL+Z5w8Tq3IQGTsuDGzqy0BqM8gY/j1hphlJH5f
rRq19oiY7cmDbq1HqdvNOxQ7LIBIi1HDt0T8RpIvrIjDEtmapGHNH/p0oh1F
pYdwPW3bxD1UTbUZhNpX26qg1lfUm98eJrdjMM+x19KcXNy+cYPxedBZ5Ej3
J4gj+B9H5Hl3N6LtKL4uQUySOxBYmmpj0xZzNKduHlTm3RUoD/hREQ9F1wIB
WbrO6J2zqwN8RoXpltzZAxVM13gVTKzc2MsOXCG3TTsGROeA7iPMeXSNV01q
7UQRaTFqGE/CzDeljBGx7CtASlolmPSx1eRYXOuectlv//4KgQBXIIKUpaZy
BtB+oWDBfJabT+WyMncayN1RVfJ5eVWYJ0Ig9DnZj5jP55K6UMl6Ug5AMP7B
6AsW3uGDmEae6K6sJDcMHx/WaheOWOzhOEedGYdwDkBEzx86RuCumnG/FjUl
dSPDec/EeM4dlnrXxshzvUeTlP5wiGHjJiHm+ioDkejdnTauascimGWCI+58
3itGI1L9omkUz4NAxuEawtjnDwxDWWGFGP2mykHkBZBeL5Ec3lEMpgdnCOdz
KCN7ocriHzmM7jONQZSNyF+oUob3V2mMfITx/32cjHxE+QXKBSef
   "], {{0, 0}, {100, 100}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1206763513]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30498],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " unless ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "/", "m"}], TraditionalForm]], "InlineMath"],
 " is an integer:"
}], "ExampleText",
 CellID->9172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{"Pi", "^", "2"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21947],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1238800723]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{
   RowBox[{"3", "Pi"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29556],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->669793796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23208]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23503],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoprimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoprimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvenQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvenQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4592],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->693910302],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->544080217],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->62753597],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->307662751],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->413941259],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->132884483]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Divisible - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 44.1806444}", "context" -> "System`", 
    "keywords" -> {"divisibility", "divisible numbers"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Divisible[n, m] yields True if n is divisible by m, and yields False if \
it is not. ", "synonyms" -> {"Divides"}, "title" -> "Divisible", "type" -> 
    "Symbol", "uri" -> "ref/Divisible"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9296, 290, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->530969353]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26614, 978}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3208, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3831, 97, 1574, 37, 70, "ObjectNameGrid"],
Cell[5408, 136, 976, 33, 70, "Usage",
 CellID->10210]
}, Open  ]],
Cell[CellGroupData[{
Cell[6421, 174, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6899, 191, 437, 17, 70, "Notes",
 CellID->22596],
Cell[7339, 210, 235, 7, 70, "Notes",
 CellID->2591],
Cell[7577, 219, 203, 7, 70, "Notes",
 CellID->1845],
Cell[7783, 228, 519, 21, 70, "Notes",
 CellID->1266],
Cell[8305, 251, 465, 18, 70, "Notes",
 CellID->26100],
Cell[8773, 271, 486, 14, 70, "Notes",
 CellID->18605]
}, Closed]],
Cell[CellGroupData[{
Cell[9296, 290, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->530969353],
Cell[CellGroupData[{
Cell[9681, 304, 147, 5, 70, "ExampleSection",
 CellID->28305936],
Cell[9831, 311, 72, 1, 70, "ExampleText",
 CellID->5174],
Cell[CellGroupData[{
Cell[9928, 316, 124, 4, 28, "Input",
 CellID->5912],
Cell[10055, 322, 163, 5, 36, "Output",
 CellID->1688807927]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10267, 333, 216, 7, 70, "ExampleSection",
 CellID->17852],
Cell[10486, 342, 207, 7, 70, "ExampleText",
 CellID->11385],
Cell[CellGroupData[{
Cell[10718, 353, 175, 6, 70, "Input",
 CellID->15217],
Cell[10896, 361, 161, 5, 36, "Output",
 CellID->503466690]
}, Open  ]],
Cell[11072, 369, 121, 3, 70, "ExampleDelimiter",
 CellID->20368],
Cell[11196, 374, 215, 7, 70, "ExampleText",
 CellID->12896],
Cell[CellGroupData[{
Cell[11436, 385, 204, 7, 70, "Input",
 CellID->23002],
Cell[11643, 394, 241, 8, 36, "Output",
 CellID->679089650]
}, Open  ]],
Cell[11899, 405, 120, 3, 70, "ExampleDelimiter",
 CellID->2026],
Cell[CellGroupData[{
Cell[12044, 412, 250, 8, 70, "Input",
 CellID->27154],
Cell[12297, 422, 162, 5, 36, "Output",
 CellID->1731647392]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12508, 433, 239, 7, 70, "ExampleSection",
 CellID->22570],
Cell[12750, 442, 76, 1, 70, "ExampleText",
 CellID->30939],
Cell[CellGroupData[{
Cell[12851, 447, 169, 6, 70, "Input",
 CellID->30218],
Cell[13023, 455, 162, 5, 36, "Output",
 CellID->1099333200]
}, Open  ]],
Cell[13200, 463, 120, 3, 70, "ExampleDelimiter",
 CellID->7287],
Cell[13323, 468, 56, 1, 70, "ExampleText",
 CellID->27645],
Cell[CellGroupData[{
Cell[13404, 473, 172, 6, 70, "Input",
 CellID->21194],
Cell[13579, 481, 162, 5, 36, "Output",
 CellID->1691277259]
}, Open  ]],
Cell[13756, 489, 120, 3, 70, "ExampleDelimiter",
 CellID->9894],
Cell[13879, 494, 57, 1, 70, "ExampleText",
 CellID->11558],
Cell[CellGroupData[{
Cell[13961, 499, 172, 6, 70, "Input",
 CellID->23150],
Cell[14136, 507, 162, 5, 36, "Output",
 CellID->1203340321]
}, Open  ]],
Cell[CellGroupData[{
Cell[14335, 517, 171, 6, 70, "Input",
 CellID->26717],
Cell[14509, 525, 193, 6, 36, "Output",
 CellID->1687271248]
}, Open  ]],
Cell[14717, 534, 120, 3, 70, "ExampleDelimiter",
 CellID->1902],
Cell[14840, 539, 58, 1, 70, "ExampleText",
 CellID->18034],
Cell[CellGroupData[{
Cell[14923, 544, 187, 6, 70, "Input",
 CellID->2168],
Cell[15113, 552, 162, 5, 36, "Output",
 CellID->446306501]
}, Open  ]],
Cell[15290, 560, 121, 3, 70, "ExampleDelimiter",
 CellID->21795],
Cell[15414, 565, 220, 8, 70, "ExampleText",
 CellID->2064],
Cell[CellGroupData[{
Cell[15659, 577, 124, 4, 70, "Input",
 CellID->26539],
Cell[15786, 583, 218, 7, 36, "Output",
 CellID->2060466983]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16053, 596, 222, 7, 70, "ExampleSection",
 CellID->9573],
Cell[16278, 605, 78, 1, 70, "ExampleText",
 CellID->22633],
Cell[CellGroupData[{
Cell[16381, 610, 238, 8, 70, "Input",
 CellID->22452],
Cell[16622, 620, 251, 8, 36, "Output",
 CellID->2094775406]
}, Open  ]],
Cell[16888, 631, 120, 3, 70, "ExampleDelimiter",
 CellID->9499],
Cell[17011, 636, 80, 1, 70, "ExampleText",
 CellID->3589],
Cell[CellGroupData[{
Cell[17116, 641, 307, 10, 70, "Input",
 CellID->29670],
Cell[17426, 653, 630, 19, 43, "Output",
 CellID->1043339724]
}, Open  ]],
Cell[18071, 675, 120, 3, 70, "ExampleDelimiter",
 CellID->3354],
Cell[18194, 680, 71, 1, 70, "ExampleText",
 CellID->1816],
Cell[CellGroupData[{
Cell[18290, 685, 373, 12, 70, "Input",
 CellID->21699],
Cell[18666, 699, 1231, 26, 246, "Output",
 CellID->1206763513]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19946, 731, 226, 7, 70, "ExampleSection",
 CellID->30498],
Cell[20175, 740, 509, 20, 70, "ExampleText",
 CellID->9172],
Cell[CellGroupData[{
Cell[20709, 764, 150, 5, 70, "Input",
 CellID->21947],
Cell[20862, 771, 163, 5, 36, "Output",
 CellID->1238800723]
}, Open  ]],
Cell[CellGroupData[{
Cell[21062, 781, 145, 5, 70, "Input",
 CellID->29556],
Cell[21210, 788, 161, 5, 36, "Output",
 CellID->669793796]
}, Open  ]],
Cell[21386, 796, 121, 3, 70, "ExampleDelimiter",
 CellID->23208]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21556, 805, 311, 9, 70, "SeeAlsoSection",
 CellID->23503],
Cell[21870, 816, 1885, 71, 70, "SeeAlso",
 CellID->30597]
}, Open  ]],
Cell[CellGroupData[{
Cell[23792, 892, 313, 9, 70, "TutorialsSection",
 CellID->4592],
Cell[24108, 903, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[24343, 912, 319, 9, 70, "MoreAboutSection",
 CellID->693910302],
Cell[24665, 923, 145, 3, 70, "MoreAbout",
 CellID->544080217],
Cell[24813, 928, 154, 3, 70, "MoreAbout",
 CellID->62753597],
Cell[24970, 933, 162, 3, 70, "MoreAbout",
 CellID->307662751],
Cell[25135, 938, 179, 3, 70, "MoreAbout",
 CellID->413941259],
Cell[25317, 943, 198, 4, 70, "MoreAbout",
 CellID->132884483]
}, Open  ]],
Cell[25530, 950, 27, 0, 70, "History"],
Cell[25560, 952, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

