(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     94131,       2522]
NotebookOptionsPosition[     84133,       2167]
NotebookOutlinePosition[     85379,       2203]
CellTagsIndexPosition[     85293,       2198]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerPhi" :> Documentation`HelpLookup["paclet:ref/EulerPhi"], 
          "Divisors" :> Documentation`HelpLookup["paclet:ref/Divisors"], 
          "Divisible" :> Documentation`HelpLookup["paclet:ref/Divisible"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"EulerPhi\"\>", 
       2->"\<\"Divisors\"\>", 3->"\<\"Divisible\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematical Functions\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 
       3->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DivisorSigma", "ObjectName",
 CellID->18425],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DivisorSigma",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DivisorSigma"], "[", 
       RowBox[{
        StyleBox["k", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the divisor function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Sigma]", "k"], "(", "n", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20428]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", "k"], "(", "n", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is the sum of the ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["k", "TI"], "\[Null]"}]]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " powers of the divisors of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8077],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DivisorSigma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DivisorSigma"], "[", 
   RowBox[{
    StyleBox["k", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    RowBox[{
     ButtonBox["GaussianIntegers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GaussianIntegers"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " includes divisors that are Gaussian integers. "
}], "Notes",
 CellID->20725],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DivisorSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivisorSigma"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244145044],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->186168181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", "20", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294779759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "10", ",", "20"}], 
  "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205793482]
}, Open  ]],

Cell["Sum of divisors:", "ExampleText",
 CellID->33422361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"1", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->570880203],

Cell[BoxData["42"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->802480886]
}, Open  ]],

Cell["Sum of squares of divisors:", "ExampleText",
 CellID->9907780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"2", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->239194820],

Cell[BoxData["546"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127634940]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->463769113],

Cell["Plot sums of divisors:", "ExampleText",
 CellID->595141172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DivisorSigma", "[", 
     RowBox[{"1", ",", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40442224],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 3.}, {3., 4.}, {4., 7.}, {5., 6.}, {6., 12.}, {
     7., 8.}, {8., 15.}, {9., 13.}, {10., 18.}, {11., 12.}, {12., 28.}, {13., 
     14.}, {14., 24.}, {15., 24.}, {16., 31.}, {17., 18.}, {18., 39.}, {19., 
     20.}, {20., 42.}, {21., 32.}, {22., 36.}, {23., 24.}, {24., 60.}, {25., 
     31.}, {26., 42.}, {27., 40.}, {28., 56.}, {29., 30.}, {30., 72.}, {31., 
     32.}, {32., 63.}, {33., 48.}, {34., 54.}, {35., 48.}, {36., 91.}, {37., 
     38.}, {38., 60.}, {39., 56.}, {40., 90.}, {41., 42.}, {42., 96.}, {43., 
     44.}, {44., 84.}, {45., 78.}, {46., 72.}, {47., 48.}, {48., 124.}, {49., 
     57.}, {50., 93.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->{{0., 50.}, {0., 124.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9187440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23830787],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DivisorSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivisorSigma"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->187504454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17016140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "10", ",", "21", ",", "26"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259338015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366277277],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->458596738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DivisorSigma", "[", 
   RowBox[{"p", ",", "n"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30926336],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    TagBox["\[Sigma]",
     DivisorSigma], "p"], "(", "n", ")"}], TraditionalForm]], "Output",
 ImageSize->{33, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->145084778]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->178743355],

Cell["The first argument can be symbolic:", "ExampleText",
 CellID->487321686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"k", ",", " ", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179670043],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["2", 
      RowBox[{"2", " ", "k"}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["5", 
      RowBox[{"2", " ", "k"}]]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["2", "k"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["5", "k"]}], ")"}]}]]], "Output",
 ImageSize->{135, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353553482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8721639],

Cell["Include complex divisors:", "ExampleText",
 CellID->243818199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"1", ",", "100", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48360516],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "11"}], "-", 
  RowBox[{"304", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70848311]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->270318888],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GaussianIntegers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->509551953],

Cell["By default, only real divisors are included:", "ExampleText",
 CellID->238402819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"1", ",", " ", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400090465],

Cell[BoxData["217"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258726560]
}, Open  ]],

Cell["This also includes complex divisors:", "ExampleText",
 CellID->392198391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"1", ",", " ", "100", ",", " ", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->484921758],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "11"}], "-", 
  RowBox[{"304", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->796983187]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->70913132],

Cell["\<\
Plot the running average of the number of divisors with its asymptotic value:\
\
\>", "ExampleText",
 CellID->746292423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"DivisorSigma", "[", 
          RowBox[{"0", ",", "i"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "/", "n"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", "n", "]"}], "+", 
      RowBox[{"2", "EulerGamma"}], "-", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "50"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558631009],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180566804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44477750],

Cell[TextData[{
 "Find ",
 ButtonBox["perfect numbers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/PerfectNumber.html"], None}],
 ":"
}], "ExampleText",
 CellID->258368564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10000", "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"DivisorSigma", "[", 
      RowBox[{"1", ",", "#"}], "]"}], "\[Equal]", 
     RowBox[{"2", "#"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4910581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "28", ",", "496", ",", "8128"}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270721328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136824971],

Cell["Compute an iterated aliquot sum:", "ExampleText",
 CellID->173405742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DivisorSigma", "[", 
      RowBox[{"1", ",", "#"}], "]"}], "-", "#"}], "&"}], ",", "276", ",", 
   "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->871630433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "276", ",", "396", ",", "696", ",", "1104", ",", "1872", ",", "3770", ",", 
   "3790", ",", "3050", ",", "2716", ",", "2772", ",", "5964", ",", "10164", 
   ",", "19628", ",", "19684", ",", "22876", ",", "26404", ",", "30044", ",", 
   "33796", ",", "38780", ",", "54628", ",", "54684"}], "}"}]], "Output",
 ImageSize->{490, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222250227]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"10", ",", 
    RowBox[{"NestList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"DivisorSigma", "[", 
         RowBox[{"1", ",", "#"}], "]"}], "-", "#"}], "&"}], ",", "276", ",", 
      "100"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->381349237],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdyw1M1HUcx/FDUJg8ePIQIIdxHPF0HAciEKDy4fF4Fg4ODgLHMEojlFLz
OAf8m0uFGypRDBEhFpI0EnGobZR3tU6NLcUHQnOIBAxBEZwJGBXV+P6A+m2/
/fb6vfcR5u2W56/g8Xj5/9x/34UzFfpXb2jG3CFD0AcuBAzvtL5mRDbBXnXX
WOu3q8h8lHS+LeYpTcjWON31XftZyWqyHRy6qn9R1puRBXCYta01b2J2wsUG
h9q7A6ZkZ0y/CfE5FbML9Du/9+qrYHaFqj7FKnGjBdkdD3bwX4QY88me6MX0
+VHxWrIXxFUh5l4SZm/ErHxPYVDE7IPNFZ4+3e3Mvvi12DYtaIx5A8LP1fQf
dbQk+8HdY73BN1nMGzE26TQveM7sD5PAW81Viw6A6sWZwnqpNTkQJWVaoaTd
hvw61LKJQEHbK+Qg/OHS8Mhj0cHIdB6qDVx0CAr4FgNFpnbkTWjrvmok329P
3gzlqdLik4/WkbdAPNJ8LEEmIIdiZpwzOrvXkQzkVJtZhrasXzAH3Dda09jo
6UQ9DM7PBJPP7pG5MGhXWgTsKxVSD0fo9R0FWitn6uH40vDkvR8VZF4EvM2f
qp8zcxGws7zZnLWL9UjsvtN9fWqA9UiojT2DRA9Zj8Lkn6c/ChtmPQqSLfsk
ZdtF1KOhLG5cMheNx1WrBONTrMtQPCFYMifDQQeHKC7PhXoMGt2lMVw/mYtB
/8y2o9IB1mORX3Rjwv8h67HQrOlbMi8O29LrpiP1r1GPQ8Xg7arRdlfq8Ziz
Ue/h95C5eBwY6fjwvqMb9QRcGtWe0hwjcwkoL7Oe106wnogRYdGVuzJ36ok4
obr1g20cmZeE2tI1HvbMXBIq+12fOCz2rXhLFKE638T6VsxHV5dYvGQ9GQed
Wi5NGHssGMnQdOqzLSzJXDIMNO9+0iYg65JRKWw60etP5qXAtkZ17QLH9in4
uHGZuRSYtS6zLgXKadXvRS/ZXo446QFvq0JP2svxVUeJccwKMe3lyJKOdDqr
yTo5wvc/fV9o4EX7VKgLa3JbPicjFa0j/De+lkhon4qctquDfVqyLhU2ufry
1YnetE/DcUfzPG0PGWn4dLm5NMxJjtj3fCGlfRrk2bLHn/n60F6B2YpNZ4Jz
yVDg5yc3Jno0ZE6BoLp1ay8Pk3UKhLb+9tPhKF/ap4Ori5+XHyEjHeJDXQa3
9WQuHRddGg4XvLqB9umI3B7ZZfgOmZcBy+C8ocsdZGSAX6+ZLR8ncxm4+WDS
TCHyo30G9G5drS3MPOV/DSVEsRa7Kt3I3P+sU2JQNJOTlMr2mTief+XOnjS2
z8QHgUOm2Uo//A2IyZ3S
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{0., 101.}, {2.44090908206522, 19.3451545171478}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356247282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259198943],

Cell["Compare the number of divisors with the totient:", "ExampleText",
 CellID->45998215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"DivisorSigma", "[", 
      RowBox[{"0", ",", " ", "n"}], "]"}], " ", "-", " ", 
     RowBox[{"EulerPhi", "[", "n", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->664267729],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 0.}, {2., 1.}, {3., 0.}, {4., 1.}, {5., -2.}, {6., 2.}, {
     7., -4.}, {8., 0.}, {9., -3.}, {10., 0.}, {11., -8.}, {12., 2.}, {
     13., -10.}, {14., -2.}, {15., -4.}, {16., -3.}, {17., -14.}, {18., 0.}, {
     19., -16.}, {20., -2.}, {21., -8.}, {22., -6.}, {23., -20.}, {24., 0.}, {
     25., -17.}, {26., -8.}, {27., -14.}, {28., -6.}, {29., -26.}, {30., 
     0.}, {31., -28.}, {32., -10.}, {33., -16.}, {34., -12.}, {35., -20.}, {
     36., -3.}, {37., -34.}, {38., -14.}, {39., -20.}, {40., -8.}, {
     41., -38.}, {42., -4.}, {43., -40.}, {44., -14.}, {45., -18.}, {
     46., -18.}, {47., -44.}, {48., -6.}, {49., -39.}, {50., -14.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->{{0., 50.}, {-44., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104591506]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->90321260],

Cell["Generate values using the definition:", "ExampleText",
 CellID->13517250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{"Divisors", "[", "100", "]"}], "^", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392828205],

Cell[BoxData["10325569807"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->595775428]
}, Open  ]],

Cell[TextData[{
 "Compute using ",
 Cell[BoxData[
  ButtonBox["DivisorSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivisorSigma"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9187415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"5", ",", "100"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16882165],

Cell[BoxData["10325569807"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75137163]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241074909],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["DivisorSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivisorSigma"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->159730829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"DivisorSigma", "[", 
    RowBox[{"1", ",", 
     RowBox[{
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "^", "p"}], "-", "1"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "^", "p"}], "-", "1"}], ",", "Primes"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31018422],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["2", "p"]}], "+", 
  SuperscriptBox["4", "p"]}]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->713699862]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DivisorSigma", "[", 
     RowBox[{"0", ",", "n"}], "]"}], "<", 
    RowBox[{"EulerPhi", "[", "n", "]"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], " ", "&&", " ", 
    RowBox[{"n", ">", "30"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->648446794],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->569973972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->619759575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DivisorSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivisorSigma"]], "InlineFormula"],
 " is a multiplicative function:"
}], "ExampleText",
 CellID->9188010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DivisorSigma", "[", 
   RowBox[{"3", ",", "18"}], "]"}], " ", 
  RowBox[{"DivisorSigma", "[", 
   RowBox[{"3", ",", "23"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221760134],

Cell[BoxData["82900584"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135266506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"3", ",", " ", 
   RowBox[{"18", " ", "23"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20730767],

Cell[BoxData["82900584"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221247283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350943020],

Cell["Generating function:", "ExampleText",
 CellID->21109283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DivisorSigma", "[", 
     RowBox[{"k", ",", " ", "n"}], "]"}], "/", 
    RowBox[{"n", "^", "s"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "1", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->524409417],

Cell[BoxData[
 RowBox[{
  RowBox[{"Zeta", "[", "s", "]"}], " ", 
  RowBox[{"Zeta", "[", 
   RowBox[{
    RowBox[{"-", "k"}], "+", "s"}], "]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->619998872]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->376614005],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the naive definition does not give the correct result:"
}], "ExampleText",
 CellID->610807159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"2", ",", "100", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28971673],

Cell[BoxData[
 RowBox[{"6479", "-", 
  RowBox[{"6018", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24441095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{"Divisors", "[", 
    RowBox[{"100", ",", 
     RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}], "^", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564011443],

Cell[BoxData[
 RowBox[{"13671", "+", 
  RowBox[{"13586", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53247787]
}, Open  ]],

Cell[TextData[{
 "To make ",
 Cell[BoxData[
  ButtonBox["DivisorSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivisorSigma"]], "InlineFormula"],
 " ",
 "a multiplicative function, a definition involving factors is used:"
}], "ExampleText",
 CellID->59046315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "@@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#1", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#2", "+", "1"}], ")"}], "2"}], ")"}]}], "-", "1"}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#1", "^", "2"}], "-", "1"}], ")"}]}], "&"}], "@@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Select", "[", 
           RowBox[{
            RowBox[{"#1", " ", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"-", "1"}], ",", "I", ",", 
               RowBox[{"-", "I"}]}], "}"}]}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Re", "[", "#", "]"}], ">", "0"}], "&&", 
               RowBox[{
                RowBox[{"Im", "[", "#", "]"}], ">", "0"}]}], ")"}], "&"}]}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", "#2"}], "}"}], "&"}], "@@@",
       
      RowBox[{"FactorInteger", "[", 
       RowBox[{"100", ",", " ", 
        RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]}], ")"}]}], 
   ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->369137602],

Cell[BoxData[
 RowBox[{"6479", "-", 
  RowBox[{"6018", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->77023580]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->78569890],

Cell[TextData[{
 "Show the evolution of the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     UnderscriptBox["lim", 
      RowBox[{"n", "\[Rule]", "\[Infinity]"}]], "\[ThinSpace]", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        TagBox["\[Sigma]",
         DivisorSigma], "n"], "(", 
       RowBox[{"m", "+", "n"}], ")"}], "/", 
      RowBox[{
       SubscriptBox[
        TagBox["\[Sigma]",
         DivisorSigma], "n"], "(", "n", ")"}]}]}], "\[Equal]", 
    SuperscriptBox["\[ExponentialE]", "m"]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->229789279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"DivisorSigma", "[", 
         RowBox[{"n", ",", 
          RowBox[{"n", "+", "m"}]}], "]"}], "/", 
        RowBox[{"DivisorSigma", "[", 
         RowBox[{"n", ",", "n"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47920447],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmH9MXWcZx9/ec++F2x9rqrVrO51NthiN+0sTE02aJXbTVWMao3RmjTEt
rqEz0nXDH2MRq9to5nB21HUwWugKuxPaxbu0w3WSFCEjZRJYEGzTNlJQpDYl
RBhmd2uCn+d93vvjnHv4MZOp5PDe97zneb7P9/nxPu+592s7K8ru//7Oij2l
Ozd9+aGdD5btKX1405f2PsSSt8wYc5r/B9cb5nPM7P/puTk+C8fbGKMIRPiM
8HmLrMrCXOZPVje6T899bgjcr+fTy0Px8j6NuV3GmGJmRytrvKwli5FnOURi
nQzxfIlwuY8sUW7dghYzHCWgy+TTrhUHMDYuibUImFiWi0Nf///iT05nYmJ6
Y4hOgZXgc5/VpfolSJH5Ef4TT2JZnb3lp15JDdtKXcibmxfk4IU+ufmDzkfO
i69va3608sySK39+bzb4ceeJxgddacLNeDMz6a9ubeLK8s30i/Duc0ueV/N1
n2DXyXUfG9FixRweurqnLFW66+Sli9epjl/WdLfkZFaojK4fqu15sWXg3pIk
wmixDmvzQk56pUojd6JtsLtr5O4tR1AAFwVShncHqjsjTY19kYH+ceMphijW
F2D8oKK999wY+NRsOn2DFZCAZPK79gsWgyfGg/qdm+u5TEQGDxusy6OofQ5t
ZLnMahk8ILAt5j9vOUDOcbjTcpCGdAIK0RwjyaCmR9tVXs4Xu4+/T/n/Nt7/
BD8XVS09c2tA6mOB++DzxeQDViif0dEp0+pfdbK5VdkdbYvIvO/V6YnJyx39
ASvG66x+qWP/8Rvp98xLOflcj0HlTGUjj5NhT/kbO3e+vaI+GcpAu053zYnh
1BsybVlAanZyOlnymPBo8TOU8p99e1KFI711p/NQch3zVGv55fMdDqunNgUn
EM3xAtkb76WPHNwy0Nui/ScK/9YdBwbbOjF9rED6+j8u1tds7v59je7CWHrm
X4CjgEfMTWMgms+8+kRr4472lys083GCjvtNWyvhg42rQ1ca/DYuXh8pOfpt
6KBmErKagBE2UmUH6zfvO1X+LHOMjfdfEn+e9WvPpN/eUr99anIUl8wqq40g
hjCKavO2KjAIK3OyaCJ9ja+ZGPgI6SU+/MJiRjOdRrI7/c8JcEFvfm4bsf+Q
jSq+oDHSNehwcAlcvfDQRLBlPLXGZaIMcZH0lD+XKZJBcu1yX25tuxZn8m6E
BcG/7/huIpR6sezq34duzWMhMFEGxVdvxWaRDJ76LXSWBzittc+RR09UP2H1
8clhbrD8iIrjpy+FwfNVKsez+e4aebPj9H6pvC8G2K21SHjus0QWHJMNlglC
Pkte2N5w+62uN9ky8NverjqqJbmodGr49ZruhsG+tp6ztUkX2Pw3gmie7Lmx
gYr26pFLXWdSlU5WD2f7Z5m5E3p06m87WveRGMp1+K3U+Fh/YLfG0zfe3XJk
R/qdGZLW+Vo1cqH7tST5vYnpay6yCFHDMi3cr/yVHqt+c/RPTlb9n1f2nrKG
nzQnnSxFA4tw2f4/j2++r/6bB550UUw2lOCNTF/wexStruvcUdF6T9VjEFZc
/AdXukLeG4fEMv3uja3fbUp1DH/n8UZyFdVudLaWNMi0yS998cr1tvZBiJRW
tZWlHlVp+pPrZXnSRVn/0Nn1yMmtTTvZnJrDKLEmbyixa4+G6UxOzW57oLm6
83D7hbPal6K4evL4Lmih3ODzVz0kNAijYoq0770zI3XUUMJIQ8h/S8rZ4Q87
5/86RnK1l8XRwwhdBHoXhtq5PZzTLM7XxCt807JYYXXhSAE1HdqKLiknmYfm
0S1//BRRpNwp+pvsU3QpFJJE99ZUQYPFp+dBIMftf7ig+8B2u5WYo8BxF+uA
qAvc9r3RSHKAomKrCyMXq/tNb8srAxKK5t2Ts1P6Lp4gZqjAAXUaBlDUPLB4
ZyLcmahCcxGmCLK2ytxufSTHOpHPGkOYm8u0Bn0bkXpAX81FADRRwogNLnLu
YdV4nBe6otY9CkitG88OkFAMWyp2JzkupZaLl+kLPj6EkEAyIYdSA5/OVLTD
Ur/oMz5bWXacGMJFsyY04wwJu8aJ6nSWWx3qwWGuDvD7zNxinVH/KBjKRqu9
8sxTNHKZ3sWQsIhjfznns0g5OZarAyzX2YiST/d8jX2eYzR/Z9czJLur3d7j
wNt18ocyfcLeU2jO1zWWGfH0IRf0ap+fuvnVuu4QmeqbTti5VhC1osqnz3T9
ccShzU7R/6X3HJs/zgX3594aq3iyPXevrWUu2xGz1VTARbtCTnN/x8GOy/Zd
0v/mpb0zW39OmrOIvko886QLbUxcmy7Zm8y7n76GlpxOR0O11BZ9fmY2ndPi
ZCw/9TPROrKAVjaW7h55ct0/Pmwa5tWKNJ7s029DxJ3+JDv9eZ/3GjutaFsA
VhXv6QsagLoFOOEGzshUf20aunoRTrU9x0j24VC9WCA3ttdH2wZfpeeRWELx
6wX0clmyfT5GNVBTOEZm4WyeCdWNB2yutIt0bEqC41ALgwDlOrxExp5eHiEn
8DK1p0MRVhBWRVwlSuCYp0LtFgXsrrGBIqSkAc6b67eDwMbCCwJXvQAGrwU1
R7tlan/HWSEvtsOvEy9SBAwxoIAa+9pYpCBkj/10ATR91WDU3zgTBB0t1OEC
Dp4pNeYmwrLxcBkJSJofheLqfW1zDy8lMt1kjcFScbmIGHDQNRHATVThuXhg
bcQICtJ6SS4f8GUjkak33qfoS+ZTtm7UAhcEFYWEKC4XL5O8jmDNy1ozERk8
pJSW9S8qm8jDO+fN9lAfE4Gd8rk513GVgYlYFLzIR7bWNEnWbcuG882xidnn
hMDpxGy02Q0OM2Exyafj8Nm5pfTe5faegqFsZPqVTL9wqDGLSsh8Vtm1jlXC
stIyEMLLLWstMnm0KsD6JqsPfv5eXSJLqpANMjo+ZR6ec73QsVwVYKlWiLfP
Sva7Zx6y7Q3e0KWrZEqqXPtj/m+Yoiu3thPIGcMeF8nnnaQTCzlb7Ddlr6Pn
8v5DHTKtX1TD9g3pXGiIjbolRWd1xg4+UPXmOd9uWJPxkN3AaMJ7rZWKslvK
qlK87GE8vLd+2N7zRogc9W0OhUqt1R135TqMCBeT8G6rvyDTN8krRzfB/ZWP
u/5erec69KlRiUpNKJbtTzGqg2KW7yF1neC6Xx2Csh+VoYhYEWr40eEIOHPp
FuG99eMyFKNBmIHGAAGgiWGDxZ+H6txmdYg5nU6t4KZuNUJX5fP0k7bMCZS2
b+LGdyNcRo9zGSs49uNQK3fIsJLHCCGKAmqqDAoUVR+L+0L17ZtsHH0kIKoQ
8s4KRoRP4+Evq+ScvkXKPT2iRO3+UMQviE9WkpCiST0ZixTFf1C5iJ9diRF3
JPSSfKke70oO61uhFu7KVCvSXOTEQ99ElTkXb1ry5dLEmOgKF7ZMVOSEl2ra
Jm3PCod8ty8r37A1BRuVVlMOg6gorPHsQHrVNyORo5NXpXzPNZOiGrP6xNNx
iDPcEern7sze9bHVROeQiK+zFGcottaJtFsrttazcTbLraL+IqCX9IyiUPv6
zYB8O/vF1j4x8GFRY9kYi0A41kK/Hptl/wYJLWkw\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255934497]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116656074],

Cell["\<\
Fourier transform of the divisor function in the complex plane:\
\>", "ExampleText",
 CellID->564941309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Arg", "[", 
   RowBox[{"Fourier", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], "\[Equal]", "0"}], ",", "0", ",", 
        RowBox[{"DivisorSigma", "[", 
         RowBox[{"4", ",", 
          RowBox[{"x", "+", 
           RowBox[{"I", " ", "y"}]}], ",", 
          RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "128"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "128"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180423425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179099137]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7896],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27382],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->17911]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->24278],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/DivisorFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/DivisorSigma/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
DivisorSigma"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->6384373],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->440185140],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->156196348],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->151879748]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DivisorSigma - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 44.6962826}", "context" -> "System`", 
    "keywords" -> {"divisor function", "sigma"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DivisorSigma[k, n] gives the divisor function \\[Sigma]_k (n). ", 
    "synonyms" -> {"divisor sigma"}, "title" -> "DivisorSigma", "type" -> 
    "Symbol", "uri" -> "ref/DivisorSigma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5590, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->244145044]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 85150, 2191}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2308, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2931, 81, 50, 1, 70, "ObjectName",
 CellID->18425],
Cell[2984, 84, 689, 23, 70, "Usage",
 CellID->20428]
}, Open  ]],
Cell[CellGroupData[{
Cell[3710, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4188, 129, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4323, 135, 468, 19, 70, "Notes",
 CellID->8077],
Cell[4794, 156, 543, 18, 70, "Notes",
 CellID->20725],
Cell[5340, 176, 213, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5590, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244145044],
Cell[CellGroupData[{
Cell[5975, 202, 148, 5, 70, "ExampleSection",
 CellID->186168181],
Cell[CellGroupData[{
Cell[6148, 211, 105, 3, 28, "Input",
 CellID->294779759],
Cell[6256, 216, 249, 8, 36, "Output",
 CellID->205793482]
}, Open  ]],
Cell[6520, 227, 58, 1, 70, "ExampleText",
 CellID->33422361],
Cell[CellGroupData[{
Cell[6603, 232, 132, 4, 28, "Input",
 CellID->570880203],
Cell[6738, 238, 159, 5, 36, "Output",
 CellID->802480886]
}, Open  ]],
Cell[6912, 246, 68, 1, 70, "ExampleText",
 CellID->9907780],
Cell[CellGroupData[{
Cell[7005, 251, 132, 4, 70, "Input",
 CellID->239194820],
Cell[7140, 257, 160, 5, 36, "Output",
 CellID->127634940]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7349, 268, 220, 7, 70, "ExampleSection",
 CellID->463769113],
Cell[7572, 277, 65, 1, 70, "ExampleText",
 CellID->595141172],
Cell[CellGroupData[{
Cell[7662, 282, 278, 9, 70, "Input",
 CellID->40442224],
Cell[7943, 293, 1091, 25, 136, "Output",
 CellID->9187440]
}, Open  ]],
Cell[9049, 321, 124, 3, 70, "ExampleDelimiter",
 CellID->23830787],
Cell[9176, 326, 218, 7, 70, "ExampleText",
 CellID->187504454],
Cell[CellGroupData[{
Cell[9419, 337, 212, 7, 70, "Input",
 CellID->17016140],
Cell[9634, 346, 237, 7, 36, "Output",
 CellID->259338015]
}, Open  ]],
Cell[9886, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->366277277],
Cell[10014, 361, 203, 7, 70, "ExampleText",
 CellID->458596738],
Cell[CellGroupData[{
Cell[10242, 372, 169, 5, 70, "Input",
 CellID->30926336],
Cell[10414, 379, 293, 10, 53, "Output",
 CellID->145084778]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10756, 395, 243, 7, 70, "ExampleSection",
 CellID->178743355],
Cell[11002, 404, 78, 1, 70, "ExampleText",
 CellID->487321686],
Cell[CellGroupData[{
Cell[11105, 409, 137, 4, 70, "Input",
 CellID->179670043],
Cell[11245, 415, 667, 26, 62, "Output",
 CellID->353553482]
}, Open  ]],
Cell[11927, 444, 123, 3, 70, "ExampleDelimiter",
 CellID->8721639],
Cell[12053, 449, 68, 1, 70, "ExampleText",
 CellID->243818199],
Cell[CellGroupData[{
Cell[12146, 454, 190, 5, 70, "Input",
 CellID->48360516],
Cell[12339, 461, 235, 8, 36, "Output",
 CellID->70848311]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12623, 475, 222, 7, 70, "ExampleSection",
 CellID->270318888],
Cell[CellGroupData[{
Cell[12870, 486, 237, 7, 70, "ExampleSubsection",
 CellID->509551953],
Cell[13110, 495, 87, 1, 70, "ExampleText",
 CellID->238402819],
Cell[CellGroupData[{
Cell[13222, 500, 138, 4, 70, "Input",
 CellID->400090465],
Cell[13363, 506, 160, 5, 36, "Output",
 CellID->258726560]
}, Open  ]],
Cell[13538, 514, 79, 1, 70, "ExampleText",
 CellID->392198391],
Cell[CellGroupData[{
Cell[13642, 519, 196, 5, 70, "Input",
 CellID->484921758],
Cell[13841, 526, 236, 8, 36, "Output",
 CellID->796983187]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14138, 541, 226, 7, 70, "ExampleSection",
 CellID->70913132],
Cell[14367, 550, 130, 4, 70, "ExampleText",
 CellID->746292423],
Cell[CellGroupData[{
Cell[14522, 558, 726, 23, 70, "Input",
 CellID->558631009],
Cell[15251, 583, 2929, 52, 70, "Output",
 Evaluatable->False,
 CellID->180566804]
}, Open  ]],
Cell[18195, 638, 124, 3, 70, "ExampleDelimiter",
 CellID->44477750],
Cell[18322, 643, 209, 8, 70, "ExampleText",
 CellID->258368564],
Cell[CellGroupData[{
Cell[18556, 655, 301, 10, 70, "Input",
 CellID->4910581],
Cell[18860, 667, 230, 7, 36, "Output",
 CellID->270721328]
}, Open  ]],
Cell[19105, 677, 125, 3, 70, "ExampleDelimiter",
 CellID->136824971],
Cell[19233, 682, 75, 1, 70, "ExampleText",
 CellID->173405742],
Cell[CellGroupData[{
Cell[19333, 687, 257, 9, 70, "Input",
 CellID->871630433],
Cell[19593, 698, 479, 11, 54, "Output",
 CellID->222250227]
}, Open  ]],
Cell[CellGroupData[{
Cell[20109, 714, 368, 12, 70, "Input",
 CellID->381349237],
Cell[20480, 728, 1830, 38, 125, "Output",
 CellID->356247282]
}, Open  ]],
Cell[22325, 769, 125, 3, 70, "ExampleDelimiter",
 CellID->259198943],
Cell[22453, 774, 90, 1, 70, "ExampleText",
 CellID->45998215],
Cell[CellGroupData[{
Cell[22568, 779, 359, 11, 70, "Input",
 CellID->664267729],
Cell[22930, 792, 1110, 25, 121, "Output",
 CellID->104591506]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24089, 823, 236, 7, 70, "ExampleSection",
 CellID->90321260],
Cell[24328, 832, 79, 1, 70, "ExampleText",
 CellID->13517250],
Cell[CellGroupData[{
Cell[24432, 837, 162, 5, 70, "Input",
 CellID->392828205],
Cell[24597, 844, 168, 5, 36, "Output",
 CellID->595775428]
}, Open  ]],
Cell[24780, 852, 203, 8, 70, "ExampleText",
 CellID->9187415],
Cell[CellGroupData[{
Cell[25008, 864, 132, 4, 70, "Input",
 CellID->16882165],
Cell[25143, 870, 167, 5, 36, "Output",
 CellID->75137163]
}, Open  ]],
Cell[25325, 878, 125, 3, 70, "ExampleDelimiter",
 CellID->241074909],
Cell[25453, 883, 363, 13, 70, "ExampleText",
 CellID->159730829],
Cell[CellGroupData[{
Cell[25841, 900, 505, 18, 70, "Input",
 CellID->31018422],
Cell[26349, 920, 247, 9, 36, "Output",
 CellID->713699862]
}, Open  ]],
Cell[CellGroupData[{
Cell[26633, 934, 361, 11, 70, "Input",
 CellID->648446794],
Cell[26997, 947, 161, 5, 36, "Output",
 CellID->569973972]
}, Open  ]],
Cell[27173, 955, 125, 3, 70, "ExampleDelimiter",
 CellID->619759575],
Cell[27301, 960, 213, 7, 70, "ExampleText",
 CellID->9188010],
Cell[CellGroupData[{
Cell[27539, 971, 220, 7, 70, "Input",
 CellID->221760134],
Cell[27762, 980, 165, 5, 36, "Output",
 CellID->135266506]
}, Open  ]],
Cell[CellGroupData[{
Cell[27964, 990, 161, 5, 70, "Input",
 CellID->20730767],
Cell[28128, 997, 165, 5, 36, "Output",
 CellID->221247283]
}, Open  ]],
Cell[28308, 1005, 125, 3, 70, "ExampleDelimiter",
 CellID->350943020],
Cell[28436, 1010, 62, 1, 70, "ExampleText",
 CellID->21109283],
Cell[CellGroupData[{
Cell[28523, 1015, 327, 11, 70, "Input",
 CellID->524409417],
Cell[28853, 1028, 287, 10, 36, "Output",
 CellID->619998872]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29189, 1044, 230, 7, 70, "ExampleSection",
 CellID->376614005],
Cell[29422, 1053, 362, 12, 70, "ExampleText",
 CellID->610807159],
Cell[CellGroupData[{
Cell[29809, 1069, 190, 5, 70, "Input",
 CellID->28971673],
Cell[30002, 1076, 220, 7, 36, "Output",
 CellID->24441095]
}, Open  ]],
Cell[CellGroupData[{
Cell[30259, 1088, 240, 8, 70, "Input",
 CellID->564011443],
Cell[30502, 1098, 223, 7, 36, "Output",
 CellID->53247787]
}, Open  ]],
Cell[30740, 1108, 269, 9, 70, "ExampleText",
 CellID->59046315],
Cell[CellGroupData[{
Cell[31034, 1121, 1360, 45, 70, "Input",
 CellID->369137602],
Cell[32397, 1168, 220, 7, 36, "Output",
 CellID->77023580]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32666, 1181, 227, 7, 70, "ExampleSection",
 CellID->78569890],
Cell[32896, 1190, 608, 22, 70, "ExampleText",
 CellID->229789279],
Cell[CellGroupData[{
Cell[33529, 1216, 574, 18, 70, "Input",
 CellID->47920447],
Cell[34106, 1236, 3852, 67, 70, "Output",
 Evaluatable->False,
 CellID->255934497]
}, Open  ]],
Cell[37973, 1306, 125, 3, 70, "ExampleDelimiter",
 CellID->116656074],
Cell[38101, 1311, 114, 3, 70, "ExampleText",
 CellID->564941309],
Cell[CellGroupData[{
Cell[38240, 1318, 743, 22, 70, "Input",
 CellID->180423425],
Cell[38986, 1342, 41485, 684, 70, "Output",
 Evaluatable->False,
 CellID->179099137]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[80532, 2033, 310, 9, 70, "SeeAlsoSection",
 CellID->7896],
Cell[80845, 2044, 698, 26, 70, "SeeAlso",
 CellID->24255]
}, Open  ]],
Cell[CellGroupData[{
Cell[81580, 2075, 314, 9, 70, "TutorialsSection",
 CellID->27382],
Cell[81897, 2086, 198, 4, 70, "Tutorials",
 CellID->17911]
}, Open  ]],
Cell[CellGroupData[{
Cell[82132, 2095, 321, 9, 70, "RelatedLinksSection",
 CellID->24278],
Cell[82456, 2106, 186, 4, 70, "RelatedLinks"],
Cell[82645, 2112, 206, 4, 70, "RelatedLinks"],
Cell[82854, 2118, 390, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83281, 2136, 317, 9, 70, "MoreAboutSection",
 CellID->6384373],
Cell[83601, 2147, 155, 3, 70, "MoreAbout",
 CellID->440185140],
Cell[83759, 2152, 162, 3, 70, "MoreAbout",
 CellID->156196348],
Cell[83924, 2157, 137, 3, 70, "MoreAbout",
 CellID->151879748]
}, Open  ]],
Cell[84076, 2163, 27, 0, 70, "History"],
Cell[84106, 2165, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

