(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59395,       2215]
NotebookOptionsPosition[     47507,       1790]
NotebookOutlinePosition[     49319,       1835]
CellTagsIndexPosition[     49233,       1830]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Repetitive Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/RepetitiveOperations"], 
          "Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Repetitive Operations\"\>", 
       2->"\<\"Loops and Control Structures\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"For" :> Documentation`HelpLookup["paclet:ref/For"], "While" :> 
          Documentation`HelpLookup["paclet:ref/While"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"], "Fold" :> 
          Documentation`HelpLookup["paclet:ref/Fold"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"For\"\>", 2->"\<\"While\"\>", 3->"\<\"Table\"\>",
        4->"\<\"Nest\"\>", 5->"\<\"NestWhile\"\>", 
       6->"\<\"Fold\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Language Overview\"\>", 
       2->"\<\"Looping Constructs\"\>", 3->"\<\"Procedural Programming\"\>", 
       4->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Do", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Do",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Do"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TI"]], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " times. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Do",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Do"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with the variable ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " successively taking on the values ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " (in steps of ",
     Cell[BoxData["1"], "InlineFormula"],
     "). "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Do",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Do"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]starts with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], "=", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Do",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Do"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["di", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Do",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Do"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]uses the successive values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Do",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Do"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["j", "TI"], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " looping over different values of ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     ", etc. for each ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15644]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " uses the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " iteration specification. "
}], "Notes",
 CellID->30346],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " inside ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13294],

Cell[TextData[{
 "Unless an explicit ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " is used, the value returned by ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8298],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 " first evaluates ",
 Cell[BoxData[
  StyleBox["spec", "TI"]], "InlineFormula"],
 ", then localizes the variable specified, and successively assigns values to \
it, each time evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2025],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " effectively uses ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " to localize values or variables."
}], "Notes",
 CellID->14789],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"], "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["1", "TR"]]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23955]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->572346823],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->153911274],

Cell["Print the first four squares:", "ExampleText",
 CellID->8294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"n", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28560],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->11998],

Cell[BoxData["4"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->20862],

Cell[BoxData["9"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->21298],

Cell[BoxData["16"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->12232]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22947],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " goes from -3 to 5 in steps of 2:"
}], "ExampleText",
 CellID->12077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "3"}], ",", "5", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", "3"}]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->32152],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->21010],

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->21632],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1746],

Cell[BoxData["5"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->22397]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2267],

Cell[TextData[{
 "Evaluate ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "[", "x", "]"}]], "InlineFormula"],
 " twice:"
}], "ExampleText",
 CellID->18868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", "x", "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20137],

Cell[CellGroupData[{

Cell[BoxData["x"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->11577],

Cell[BoxData["x"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->15723]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27807],

Cell["The step can be negative:", "ExampleText",
 CellID->21848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10", ",", "8", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14114],

Cell[CellGroupData[{

Cell[BoxData["10"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->271],

Cell[BoxData["9"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->19418],

Cell[BoxData["8"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->20090]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18307],

Cell["The values can be symbolic:", "ExampleText",
 CellID->7129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "x", ",", 
     RowBox[{"x", "+", 
      RowBox[{"3", "y"}]}], ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23032],

Cell[CellGroupData[{

Cell[BoxData["x"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->16872],

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->26658],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"2", " ", "y"}]}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->19587],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"3", " ", "y"}]}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1695]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12615],

Cell[TextData[{
 "Loop over ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " running up to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "-", 
   StyleBox["1", "TR"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{"i", ",", "j"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", 
     RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->81899183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->255447028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->961156559],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->291854133],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->43359319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->5463003]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7487],

Cell["The body can be a procedure:", "ExampleText",
 CellID->23158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "67"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", "t", "]"}], ";", 
     RowBox[{"t", "=", 
      RowBox[{"Floor", "[", 
       RowBox[{"t", "/", "2"}], "]"}]}]}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28607],

Cell[CellGroupData[{

Cell[BoxData["67"], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->6285],

Cell[BoxData["33"], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->13784],

Cell[BoxData["16"], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->25027]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12744],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 " breaks out of ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "1"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "*=", "k"}], ";", 
     RowBox[{"Print", "[", "t", "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"t", ">", "19"}], ",", 
       RowBox[{"Break", "[", "]"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9979],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->30855],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->32317],

Cell[BoxData["6"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->25467],

Cell[BoxData["24"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->24655]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29973],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 " continues the loop, without executing the rest of the body:"
}], "ExampleText",
 CellID->8751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "1"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "*=", "k"}], ";", 
     RowBox[{"Print", "[", "t", "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"k", "<", "2"}], ",", 
       RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
     RowBox[{"t", "+=", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28943],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->30869],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->24960],

Cell[BoxData["12"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->21625],

Cell[BoxData["56"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->11734],

Cell[BoxData["290"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->6294]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2813],

Cell["Give a list of values to iterate over:", "ExampleText",
 CellID->415988775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474448901],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->206328902],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->361682414],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->58455235],

Cell[BoxData["d"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->838350566]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28451],

Cell["Generate a symbolic continued fraction:", "ExampleText",
 CellID->30875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "x"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", "t"}], ")"}]}]}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}], ";", "t"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21354],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", "x"}]]}]]}]]}]]}]]], "Output",
 ImageSize->{86, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", "#"}], ")"}]}], "&"}], ",", "x", ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->163940351],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", "x"}]]}]]}]]}]]}]]], "Output",
 ImageSize->{86, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26815686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141913098],

Cell["Build up a list of primes:", "ExampleText",
 CellID->19065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"PrimeQ", "[", 
       RowBox[{
        RowBox[{"2", "^", "n"}], "-", "1"}], "]"}], ",", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"t", ",", "n"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ";", "t"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "13", ",", "17", ",", "19", ",", 
   "31", ",", "61", ",", "89"}], "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27598]
}, Open  ]],

Cell[TextData[{
 "Alternatively use ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->163892478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PrimeQ", "[", 
        RowBox[{
         RowBox[{"2", "^", "n"}], "-", "1"}], "]"}], ",", 
       RowBox[{"Sow", "[", "n", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}], 
  "\[LeftDoubleBracket]", 
  RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16348],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "13", ",", "17", ",", "19", ",", 
   "31", ",", "61", ",", "89"}], "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->539061905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3255289],

Cell["Implement backsubstitution: ", "ExampleText",
 CellID->29060804],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"upperTriangularLinearSolve", "[", " ", 
    RowBox[{"U_", ",", " ", "v_"}], " ", "]"}], " ", ":=", 
   RowBox[{"Module", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "m", ",", "n"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", " ", "n"}], "}"}], "=", " ", 
       RowBox[{"Dimensions", "[", "U", "]"}]}], ";", " ", 
      RowBox[{"x", " ", "=", " ", 
       RowBox[{"Range", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "-", 
            RowBox[{
             RowBox[{"U", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ";;", "n"}]}], "]"}], "]"}], ".", 
             RowBox[{"x", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "+", "1"}], ";;", "n"}], "]"}], "]"}]}]}], ")"}],
           "/", 
          RowBox[{"U", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "i"}], "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      "x"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170809008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"upperTriangularLinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2"}], "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->322126823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], ",", 
   FractionBox["2", "3"]}], "}"}]], "Output",
 ImageSize->{60, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->732246616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40611918],

Cell["Implement LU triangular decomposition of matrices: ", "ExampleText",
 CellID->552320948],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"lu", "[", "A_", "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "L", ",", "U"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "n"}], "}"}], "=", 
       RowBox[{"Dimensions", "[", "A", "]"}]}], ";", 
      RowBox[{"L", "=", 
       RowBox[{"IdentityMatrix", "[", "n", "]"}]}], ";", 
      RowBox[{"U", "=", "A"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"L", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"k", ";;", "n"}], ",", "k"}], "]"}], "]"}], "=", " ", 
          RowBox[{
           RowBox[{"U", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"k", ";;", "n"}], ",", "k"}], "]"}], "]"}], "/", 
           RowBox[{"U", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "k"}], "]"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"U", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "+", "1"}], ")"}], ";;", "n"}], ",", 
             RowBox[{"k", ";;", "n"}]}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"U", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}], ";;", "n"}], ",", 
              RowBox[{"k", ";;", "n"}]}], "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"L", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], ";;", "n"}], ",", 
               RowBox[{"{", "k", "}"}]}], "]"}], "]"}], ".", 
            RowBox[{"U", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"k", ";;", "n"}]}], "]"}], "]"}]}]}]}], ";"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", 
          RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"L", ",", "U"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38010900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"l", ",", "u"}], "}"}], "=", 
  RowBox[{"lu", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7490389],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "2", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166227821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", ".", "u"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19148851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2610727]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235649929],

Cell["The selection sort algorithm:", "ExampleText",
 CellID->132466770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "=", 
  RowBox[{"RandomSample", "[", 
   RowBox[{
    RowBox[{"Range", "[", "10", "]"}], ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301778105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5", ",", "7", ",", "1", ",", "10", ",", "4", ",", "9", ",", "6", ",", "3", 
   ",", "2", ",", "8"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238791565]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
        ">", 
       RowBox[{
       "list", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}]}], ",", 
      
      RowBox[{
       RowBox[{"list", "\[LeftDoubleBracket]", 
        RowBox[{"{", 
         RowBox[{"i", ",", "j"}], "}"}], "\[RightDoubleBracket]"}], "=", 
       RowBox[{"list", "\[LeftDoubleBracket]", 
        RowBox[{"{", 
         RowBox[{"j", ",", "i"}], "}"}], "\[RightDoubleBracket]"}]}]}], "]"}],
     ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "list", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"i", "+", "1"}], ",", 
      RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], "]"}], ";", 
  "list"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81921686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->114093647]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26143],

Cell["Equivalent loops:", "ExampleText",
 CellID->58791316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461986224],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->624058131],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->10960005],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->6896573]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", "3"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"Print", "[", "i", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->260969909],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->254590076],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->270039041],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->20535986]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "1"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"i", "\[LessEqual]", "3"}], ",", 
    RowBox[{
     RowBox[{"Print", "[", "i", "]"}], ";", 
     RowBox[{"i", "++"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->483253266],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->398323111],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->67456794],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->744097112]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"Range", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->334279692],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->198986277],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->27114142],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->504193143]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8702],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["For",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/For"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["While",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/While"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fold"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11955],

Cell[TextData[ButtonBox["Repetitive Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepetitiveOperations"]], "Tutorials",
 CellID->2986],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->12788]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->37631236],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->37991909],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->98981351],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->529157914],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->345670703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Do"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Do - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 51.7433380}", "context" -> "System`", 
    "keywords" -> {
     "repetitive evaluation", "repeat evaluation", "evaluation loop", 
      "evaluation flow", "iteration", "iterative evaluation", "loop", 
      "repeat", "repeated calculation", "repeating evaluation", 
      "fixed length loop"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Do[expr, {i_max}] evaluates expr i_max times. Do[expr, {i, i_max}] \
evaluates expr with the variable i successively taking on the values 1 \
through i_max (in steps of 1). Do[expr, {i, i_min, i_max}] starts with i = \
i_min. Do[expr, {i, i_min, i_max, di}] uses steps di. Do[expr, {i, {i_1, i_2, \
...}}] uses the successive values i_1, i_2, .... Do[expr, {i, i_min, i_max}, \
{j, j_min, j_max}, ...] evaluates expr looping over different values of j, \
etc. for each i. ", "synonyms" -> {}, "title" -> "Do", "type" -> "Symbol", 
    "uri" -> "ref/Do"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16544, 511, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->572346823]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49089, 1823}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2792, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3415, 88, 4186, 83, 70, "ObjectNameGrid"],
Cell[7604, 173, 5341, 182, 70, "Usage",
 CellID->15644]
}, Open  ]],
Cell[CellGroupData[{
Cell[12982, 360, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[13460, 377, 254, 10, 70, "Notes",
 CellID->30346],
Cell[13717, 389, 671, 28, 70, "Notes",
 CellID->13294],
Cell[14391, 419, 452, 18, 70, "Notes",
 CellID->8298],
Cell[14846, 439, 508, 18, 70, "Notes",
 CellID->2025],
Cell[15357, 459, 324, 12, 70, "Notes",
 CellID->14789],
Cell[15684, 473, 823, 33, 70, "Notes",
 CellID->23955]
}, Closed]],
Cell[CellGroupData[{
Cell[16544, 511, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->572346823],
Cell[CellGroupData[{
Cell[16929, 525, 148, 5, 70, "ExampleSection",
 CellID->153911274],
Cell[17080, 532, 67, 1, 70, "ExampleText",
 CellID->8294],
Cell[CellGroupData[{
Cell[17172, 537, 224, 8, 70, "Input",
 CellID->28560],
Cell[CellGroupData[{
Cell[17421, 549, 87, 2, 70, "Print",
 CellID->11998],
Cell[17511, 553, 87, 2, 70, "Print",
 CellID->20862],
Cell[17601, 557, 87, 2, 70, "Print",
 CellID->21298],
Cell[17691, 561, 88, 2, 70, "Print",
 CellID->12232]
}, Open  ]]
}, Open  ]],
Cell[17806, 567, 121, 3, 70, "ExampleDelimiter",
 CellID->22947],
Cell[17930, 572, 144, 5, 70, "ExampleText",
 CellID->12077],
Cell[CellGroupData[{
Cell[18099, 581, 240, 8, 70, "Input",
 CellID->16233],
Cell[CellGroupData[{
Cell[18364, 593, 104, 3, 70, "Print",
 CellID->32152],
Cell[18471, 598, 104, 3, 70, "Print",
 CellID->21010],
Cell[18578, 603, 87, 2, 70, "Print",
 CellID->21632],
Cell[18668, 607, 86, 2, 70, "Print",
 CellID->1746],
Cell[18757, 611, 87, 2, 70, "Print",
 CellID->22397]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18905, 620, 215, 7, 70, "ExampleSection",
 CellID->2267],
Cell[19123, 629, 219, 9, 70, "ExampleText",
 CellID->18868],
Cell[CellGroupData[{
Cell[19367, 642, 174, 6, 70, "Input",
 CellID->20137],
Cell[CellGroupData[{
Cell[19566, 652, 87, 2, 70, "Print",
 CellID->11577],
Cell[19656, 656, 87, 2, 70, "Print",
 CellID->15723]
}, Open  ]]
}, Open  ]],
Cell[19770, 662, 121, 3, 70, "ExampleDelimiter",
 CellID->27807],
Cell[19894, 667, 64, 1, 70, "ExampleText",
 CellID->21848],
Cell[CellGroupData[{
Cell[19983, 672, 241, 8, 70, "Input",
 CellID->14114],
Cell[CellGroupData[{
Cell[20249, 684, 86, 2, 70, "Print",
 CellID->271],
Cell[20338, 688, 87, 2, 70, "Print",
 CellID->19418],
Cell[20428, 692, 87, 2, 70, "Print",
 CellID->20090]
}, Open  ]]
}, Open  ]],
Cell[20542, 698, 121, 3, 70, "ExampleDelimiter",
 CellID->18307],
Cell[20666, 703, 65, 1, 70, "ExampleText",
 CellID->7129],
Cell[CellGroupData[{
Cell[20756, 708, 267, 9, 70, "Input",
 CellID->23032],
Cell[CellGroupData[{
Cell[21048, 721, 87, 2, 70, "Print",
 CellID->16872],
Cell[21138, 725, 109, 3, 70, "Print",
 CellID->26658],
Cell[21250, 730, 132, 4, 70, "Print",
 CellID->19587],
Cell[21385, 736, 131, 4, 70, "Print",
 CellID->1695]
}, Open  ]]
}, Open  ]],
Cell[21543, 744, 121, 3, 70, "ExampleDelimiter",
 CellID->12615],
Cell[21667, 749, 384, 17, 70, "ExampleText",
 CellID->30834],
Cell[CellGroupData[{
Cell[22076, 770, 335, 12, 70, "Input",
 CellID->15754],
Cell[CellGroupData[{
Cell[22436, 786, 135, 4, 70, "Print",
 CellID->81899183],
Cell[22574, 792, 136, 4, 70, "Print",
 CellID->255447028],
Cell[22713, 798, 136, 4, 70, "Print",
 CellID->961156559],
Cell[22852, 804, 136, 4, 70, "Print",
 CellID->291854133],
Cell[22991, 810, 135, 4, 70, "Print",
 CellID->43359319],
Cell[23129, 816, 134, 4, 70, "Print",
 CellID->5463003]
}, Open  ]]
}, Open  ]],
Cell[23290, 824, 120, 3, 70, "ExampleDelimiter",
 CellID->7487],
Cell[23413, 829, 67, 1, 70, "ExampleText",
 CellID->23158],
Cell[CellGroupData[{
Cell[23505, 834, 340, 12, 70, "Input",
 CellID->28607],
Cell[CellGroupData[{
Cell[23870, 850, 87, 2, 70, "Print",
 CellID->6285],
Cell[23960, 854, 88, 2, 70, "Print",
 CellID->13784],
Cell[24051, 858, 88, 2, 70, "Print",
 CellID->25027]
}, Open  ]]
}, Open  ]],
Cell[24166, 864, 121, 3, 70, "ExampleDelimiter",
 CellID->12744],
Cell[24290, 869, 295, 12, 70, "ExampleText",
 CellID->26841],
Cell[CellGroupData[{
Cell[24610, 885, 432, 15, 70, "Input",
 CellID->9979],
Cell[CellGroupData[{
Cell[25067, 904, 87, 2, 70, "Print",
 CellID->30855],
Cell[25157, 908, 87, 2, 70, "Print",
 CellID->32317],
Cell[25247, 912, 87, 2, 70, "Print",
 CellID->25467],
Cell[25337, 916, 88, 2, 70, "Print",
 CellID->24655]
}, Open  ]]
}, Open  ]],
Cell[25452, 922, 121, 3, 70, "ExampleDelimiter",
 CellID->29973],
Cell[25576, 927, 232, 7, 70, "ExampleText",
 CellID->8751],
Cell[CellGroupData[{
Cell[25833, 938, 471, 16, 70, "Input",
 CellID->28943],
Cell[CellGroupData[{
Cell[26329, 958, 87, 2, 70, "Print",
 CellID->30869],
Cell[26419, 962, 87, 2, 70, "Print",
 CellID->24960],
Cell[26509, 966, 88, 2, 70, "Print",
 CellID->21625],
Cell[26600, 970, 88, 2, 70, "Print",
 CellID->11734],
Cell[26691, 974, 88, 2, 70, "Print",
 CellID->6294]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26840, 983, 238, 7, 70, "ExampleSection",
 CellID->2813],
Cell[27081, 992, 81, 1, 70, "ExampleText",
 CellID->415988775],
Cell[CellGroupData[{
Cell[27187, 997, 279, 10, 70, "Input",
 CellID->474448901],
Cell[CellGroupData[{
Cell[27491, 1011, 91, 2, 70, "Print",
 CellID->206328902],
Cell[27585, 1015, 91, 2, 70, "Print",
 CellID->361682414],
Cell[27679, 1019, 90, 2, 70, "Print",
 CellID->58455235],
Cell[27772, 1023, 91, 2, 70, "Print",
 CellID->838350566]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27924, 1032, 223, 7, 70, "ExampleSection",
 CellID->28451],
Cell[28150, 1041, 78, 1, 70, "ExampleText",
 CellID->30875],
Cell[CellGroupData[{
Cell[28253, 1046, 305, 11, 70, "Input",
 CellID->21354],
Cell[28561, 1059, 408, 15, 88, "Output",
 CellID->1667]
}, Open  ]],
Cell[CellGroupData[{
Cell[29006, 1079, 233, 9, 70, "Input",
 CellID->163940351],
Cell[29242, 1090, 412, 15, 88, "Output",
 CellID->26815686]
}, Open  ]],
Cell[29669, 1108, 125, 3, 70, "ExampleDelimiter",
 CellID->141913098],
Cell[29797, 1113, 65, 1, 70, "ExampleText",
 CellID->19065],
Cell[CellGroupData[{
Cell[29887, 1118, 464, 16, 70, "Input",
 CellID->30961],
Cell[30354, 1136, 293, 9, 36, "Output",
 CellID->27598]
}, Open  ]],
Cell[30662, 1148, 312, 13, 70, "ExampleText",
 CellID->163892478],
Cell[CellGroupData[{
Cell[30999, 1165, 490, 16, 70, "Input",
 CellID->16348],
Cell[31492, 1183, 297, 9, 36, "Output",
 CellID->539061905]
}, Open  ]],
Cell[31804, 1195, 123, 3, 70, "ExampleDelimiter",
 CellID->3255289],
Cell[31930, 1200, 70, 1, 70, "ExampleText",
 CellID->29060804],
Cell[32003, 1203, 1563, 45, 70, "Input",
 CellID->170809008],
Cell[CellGroupData[{
Cell[33591, 1252, 369, 12, 70, "Input",
 CellID->322126823],
Cell[33963, 1266, 267, 10, 51, "Output",
 CellID->732246616]
}, Open  ]],
Cell[34245, 1279, 124, 3, 70, "ExampleDelimiter",
 CellID->40611918],
Cell[34372, 1284, 94, 1, 70, "ExampleText",
 CellID->552320948],
Cell[34469, 1287, 2460, 71, 70, "Input",
 CellID->38010900],
Cell[CellGroupData[{
Cell[36954, 1362, 414, 14, 70, "Input",
 CellID->7490389],
Cell[37371, 1378, 746, 25, 36, "Output",
 CellID->166227821]
}, Open  ]],
Cell[CellGroupData[{
Cell[38154, 1408, 91, 3, 70, "Input",
 CellID->19148851],
Cell[38248, 1413, 389, 13, 36, "Output",
 CellID->2610727]
}, Open  ]],
Cell[38652, 1429, 125, 3, 70, "ExampleDelimiter",
 CellID->235649929],
Cell[38780, 1434, 72, 1, 70, "ExampleText",
 CellID->132466770],
Cell[CellGroupData[{
Cell[38877, 1439, 194, 6, 70, "Input",
 CellID->301778105],
Cell[39074, 1447, 292, 9, 36, "Output",
 CellID->238791565]
}, Open  ]],
Cell[CellGroupData[{
Cell[39403, 1461, 936, 29, 70, "Input",
 CellID->81921686],
Cell[40342, 1492, 292, 9, 36, "Output",
 CellID->114093647]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40683, 1507, 233, 7, 70, "ExampleSection",
 CellID->26143],
Cell[40919, 1516, 59, 1, 70, "ExampleText",
 CellID->58791316],
Cell[CellGroupData[{
Cell[41003, 1521, 203, 7, 70, "Input",
 CellID->461986224],
Cell[CellGroupData[{
Cell[41231, 1532, 91, 2, 70, "Print",
 CellID->624058131],
Cell[41325, 1536, 90, 2, 70, "Print",
 CellID->10960005],
Cell[41418, 1540, 89, 2, 70, "Print",
 CellID->6896573]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41556, 1548, 254, 8, 70, "Input",
 CellID->260969909],
Cell[CellGroupData[{
Cell[41835, 1560, 91, 2, 70, "Print",
 CellID->254590076],
Cell[41929, 1564, 91, 2, 70, "Print",
 CellID->270039041],
Cell[42023, 1568, 90, 2, 70, "Print",
 CellID->20535986]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42162, 1576, 289, 10, 70, "Input",
 CellID->483253266],
Cell[CellGroupData[{
Cell[42476, 1590, 91, 2, 70, "Print",
 CellID->398323111],
Cell[42570, 1594, 90, 2, 70, "Print",
 CellID->67456794],
Cell[42663, 1598, 91, 2, 70, "Print",
 CellID->744097112]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42803, 1606, 160, 5, 70, "Input",
 CellID->334279692],
Cell[CellGroupData[{
Cell[42988, 1615, 91, 2, 70, "Print",
 CellID->198986277],
Cell[43082, 1619, 90, 2, 70, "Print",
 CellID->27114142],
Cell[43175, 1623, 91, 2, 70, "Print",
 CellID->504193143]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43339, 1633, 310, 9, 70, "SeeAlsoSection",
 CellID->8702],
Cell[43652, 1644, 1395, 53, 70, "SeeAlso",
 CellID->21058]
}, Open  ]],
Cell[CellGroupData[{
Cell[45084, 1702, 314, 9, 70, "TutorialsSection",
 CellID->11955],
Cell[45401, 1713, 151, 3, 70, "Tutorials",
 CellID->2986],
Cell[45555, 1718, 164, 3, 70, "Tutorials",
 CellID->12788]
}, Open  ]],
Cell[CellGroupData[{
Cell[45756, 1726, 318, 9, 70, "MoreAboutSection",
 CellID->37631236],
Cell[46077, 1737, 144, 3, 70, "MoreAbout",
 CellID->37991909],
Cell[46224, 1742, 146, 3, 70, "MoreAbout",
 CellID->98981351],
Cell[46373, 1747, 155, 3, 70, "MoreAbout",
 CellID->529157914],
Cell[46531, 1752, 156, 3, 70, "MoreAbout",
 CellID->345670703]
}, Open  ]],
Cell[CellGroupData[{
Cell[46724, 1760, 305, 8, 70, "RelatedLinksSection"],
Cell[47032, 1770, 380, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[47427, 1786, 50, 0, 70, "History"],
Cell[47480, 1788, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

