(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26245,        869]
NotebookOptionsPosition[     21483,        710]
NotebookOutlinePosition[     22929,        750]
CellTagsIndexPosition[     22844,        745]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DotDashed" :> Documentation`HelpLookup["paclet:ref/DotDashed"],
           "Dashed" :> Documentation`HelpLookup["paclet:ref/Dashed"], 
          "Dashing" :> Documentation`HelpLookup["paclet:ref/Dashing"], 
          "AbsoluteDashing" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteDashing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DotDashed\"\>", 2->"\<\"Dashed\"\>",
        3->"\<\"Dashing\"\>", 
       4->"\<\"AbsoluteDashing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Dotted", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Dotted",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dotted"]], "InlineFormula"],
     " \[LineSeparator]is a graphics directive that specifies that lines \
which follow should be drawn dotted."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->375960744],

Cell["Dotted lines:", "ExampleText",
 CellID->568660478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Dotted", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->543815691],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{0, Small}], LineBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{104, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->305723807]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Dotted", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->494817468],

Cell[BoxData[
 Graphics3DBox[
  {Dashing[{0, Small}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]}]], "Output",
 ImageSize->{104, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->66120073,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV21PE0EQ3t6VFoFKW8QqsVqJjYISCK+KIgqCb+GDP6HBJvDBaJC/v9Gb
2dl279mxd9ik7c3OM8/M7s7M7Z4Nri+GPwbXl+eD3serwa+Ly/PfvdOfV9lQ
WjHGfM++3+6Z7PlP9sTfM2ttMhwOF7N/Y76KZNLsIfunwTus+ZT9ptlIKgg3
eiKjNZJSZ0DmC6w9Eu0tVftOmOZIqjqtA7RZfyDWt0maGumFo8WYfcG0JmBe
hhGnI4xJQGY/ZkcYOwXoBqM3Bb1UCr0u6C5oU5B5RcyaxN0rhV4V7mXQVkGe
ZfRTQfdBOwXyDKP7EsmzUuhl4V4FbQ1kzgrzSNBroK2DPM3orkSyUQq9JNyb
mhatTUfQO1qcOA+uChp8VcDt0G2J+00BN6+omRfut9r64t7y/tPg+1LoGYnk
A2hnQeYs45WhwVMlbhJdvFWRPitzJxGrIR1Z8ahxH7RObdxbrK+tXBUQxxe0
hr4Dlrl+47iyEAR3LJ7n/m0f9Zo6cLzOfqq+e02MfjQayId23G2jWi9kQ3ka
YluX2LBqMAd0duwouxIrWpdjowyifNyyQbe/MQvOpAEz7gp7U7yhlwqz4i5g
/qwELFpeY6w6K9ZlE2JtgxfssuW8IOqxsFFvqSq1gVHprJh/CxB7PfCi7SZ6
1b00QL4LXkIPrf/ygHEtQtyLoMeurrPOg9zK7WC8SvcBj1mse2kqq0VimPPU
kSjPu4qHSiYSs86O60kz932M/vE0EjNGZ0foHeE612BlHgC+NpEddylkXgHd
1EQmyrAksMbTSLXQGmtvvL/j2WmrUZ61LjuwjbO+EYvfgT7EhvueFLOO36HC
eTCBI7Yn8w2IAisfGcYaf/7aAwbuY9HbObb3tYn5f5yfmeq7IdFjZ96HWMJ6
1qOYsfENiR4PgSkpZPI9BTv0iXWZHVuEtRivwMj32Dbab8yZ05wvgmPGH8nK
pVE0WMv+BFS3RVXvT1ru9pFY/ba3Z4PzWHSGwZlsi3d3E8V9xg68IdzuDo3n
VVzfF4Lm7sD7lii74M8aXUZhfuAu923QnaN3uXYWIPQTRqMWrR9KJHz7Y8+J
X+0AtSSczxmF71d8s/n6X2c0zh1XcEEi2GI0rj7ujj/h7DK6JfFqpyhCcc3K
OSbfd/AtSCLfyFwfz/UI35v5DjY6TaQyesKjHZH4nmNM5S+8rF4G\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255849672],

Cell["Dotted frame:", "ExampleText",
 CellID->273114951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Dotted"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340435630],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWG0LgjAQPl9qEhX0rY/+l6A+9SOGBPpBSvP/r9uUmkMCS9u5FHa35zbh
uJfHuTOv0kvOqyzh8anktzRL7vHxWqIp8ACgwHHYA84FztQohEBdy1DKQFrV
A/6MB8WeFuta7owdmzEw6JYchSwFgAXOfNR+o1cj46XyRcnw5Q/A+ocWphRr
PNr21FHr7ciIdUDBDuaKvVjLTNusNEp9RomFXMAyspJNaTFq7cHMq/SZMRSf
fQHYM9cU4m2TV2n0mW0ecg138ar9TNPiVdYVxynvGJgZvztd/y+vUuoz2zzk
Gm7zKpVMd/Oq0YHTWSX57zvMXYM7XEq4fnpU17t+mm9Rx8X62RS8ByPsfuU=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394301079]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " to draw dotted edges:"
}], "ExampleText",
 CellID->386942407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"EdgeForm", "[", "Dotted", "]"}], ",", 
    RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425061707],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[{0, Small}]], 
   RectangleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->112703219]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "Dotted", "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->913846666],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[Dashing[{0, Small}]], CuboidBox[{0, 0, 0}]},
  Boxed->False]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->39406449,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVV2tPE0EUHdptu922W/qkYrGFIAJJRUB5lIeP+IqGiPEXNGACiQaDfPe3
6E/y/zR6753pdOZ0G6WBu809555zdrrdnZ4Mbi4+fx3cXJ4Num+uB98uLs++
d19fXVMrPaOUOqf/Ly1F7//QO/k/Hw6HBDj1Odc0YUN5qa50j0bdq94PqirF
x/Tw57VhdYR14LCYEIxYWs6w9hwHJuSopIiknXZAIy8azCYzUtIaT6iWEpFN
qilqlgkNqH1PuhugOkslQ+iCoD1AqwZ112FemOvAbEAGPtm2MFeB2UrQvCPM
FWDOU8kS866gy4C2qeQI1XkWAe14aAfQLqRlF52hbVZtGRis1RIGK64Rmodz
aAjaAqdVKhEx5wRtArruoTVAe1QKhMqUqgC6AQk5j84QC1NfoFy3qBQtWqS6
S50SderSiUB5x6Du2VUscx98OWHNQ8vUqU7p5MGLk8yCV2xn+wadtbN9cI9h
tmSZB8SsEFqe6Lj8YmKqPSpVYsbebI06palJKh7K/Dp4iYsKqR4S2iC0YDuu
+75B3dnQm3V9OVV0C3SOOvkpnRwk6U+gR6BfvyXqqx1Tp2k7WXA/NKi7Dllv
ltVCO3sM7g0PfTrB9zsZcB+ldd0z/+n17ySI5mwGvnL4DhT8+j2c8xD8juaJ
0fQYO2Y2mkC2Rp6E0J+KuTgZqh77EV+9xKh73R5oNKjUYIUCYQeQdsXkatNE
derE/ZE+HVm/Axn5TpC17GVIs2i0x4yOcV0FndhjLRCrR4yxehrSt8SJRcRM
9UAP75Vpq900CR7TROzp1+Bcd0Gz4LErkKAP7Ghq9sgkeEYTxcScKZjIQbKX
ZjJj9UNC3kKCvMcIjOt7YIWWpV31M4pJp1QiQMef7UfQycKZpOyKfyJmmIjy
+iTpBBblxMzI2S7fl05hJrBoZNCxSgFyn8BsCpLNyBQ/NT4Qc6wcg46sY2B1
LK+cwEtblJ/ZnCDZtQqz7wxTXxW8M/A+PbuODQ9xFZug+EpYAslLv+Ud0guY
1/cY3oEdOgjP6OfzPChvj1j6K2F2J7x32wRlvcNZoLrOa6OMlroHikt89srs
FGWv3wGlJUG4tkafBh11zBWLsUYdJtcE5f1rGc7uoRx5OgRkW44PuGZsSnO2
8rvB+62iZv4CTgzjHg==\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101466395],

Cell["A plot with dotted line:", "ExampleText",
 CellID->77058257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Dotted"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325230780],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWFuITWEU3nO2uRIxZxiXdHjAg0QJkaJxeUC5jREmM06YoRka40UeiFDG
g1sxCrmVy8OIeBklSqZkSqaE0iiNB1LkYUpta61/rbP3Xuc/+8w5opw6e/9r
/2ut//vX7V97r6hvbdjaVN/amKxPLG2p393QmNyTWLKrBR65BY7j3If/zkoH
xh6M6H/f8+AevBbD1YWpGFI48OjnxGB4lThK1IyLl0E+7TiFiqPdPHbNDX8x
IXPSsxsuse6Xn6bkgAMZdtL00ycfjh55THthPQbBu7dffvzox+HEPPdn9Pf3
/+rt/YbDYqJPtD1lOl+924k+feoZYMXh9JSH0H5FgXu6VF/fd6aHEX371isw
AA7Hk5ZRLL2PZgHo168/w7NBnUmir1/rZh0zI7h8e5r5ux09YBocjrFK7Rfr
Xbr4AlA7Y61cdWpXs0O7MLOwbHLLHbg6c6w6DhD98MEb3sWoCC7YBVvEzlUr
XEzPtXJtEly7mu/BDp15IdSHFZ64VcchhcfOtUHZZ34EV2NDh2HMwHVEIoZX
HB5CfZRmH3W+T5tNz3mJ1WCuS/7ruK3xOGvYGguIl7hCWVKs5HQdQT0xMDZl
i2tSB4dDjbiqQibpAuqt+pE8RgRsGiB6kld54GvPIFfo2fN5rax7/lwXDqsi
5INymjZ6IBbZvlUhD8ldSx0Xr0CY4nBIKBbaRCdz+7NBHauJhhrDdWFxBBfU
mK7nHzNznRBrQLXAYVkEFwQBo/a5EPUFq8xKok0BweFSK1c5R0MF3NH8caZp
hUD+lSk54RvJGCgs+Hwosa4UV3RFgEYF2fj1/Ai8FAUjBooSAPZXj/G+glIj
s9Aj2A6VttVC8Wn3VDbU5Z4fn+R3KDw4HKysMfovra/nTX6A46A8ehzxMSds
P2QfPKDV4mkoM+1fP9d+Mv0ahDsctymckdqCaDWfRKncjXYIFq75vnacXe5x
trH0cuvayzyuJOxBO9cZ0cVVwI3ggjORa7Gdy1RatPFlx5YxaT2ujS5M0cZB
zqB8tPybVTi7/brHev6nPeRIF1g9u0TROlumKdpegdv9p5yjEHEQl3QyYYxy
NqxK8ZnKDlx8xi4iTuhBDh7oDHNmWCfr05iszfTZ0NpmFmDVVN/AfpN6KKwK
nHNrrDoNSj+77Vy5oDSeh7PcNMim73WNUXBYHUJdKFbi9efKHuF9DXex7o/x
FIlGPnFPRnABDnjlwuEs5b31IdQLxdYsXROBp8TL3Afb35bpvIvsK3U2lBIN
vT33LzOIhjaJrbohB71Ilqr9GX0QSPw2l4u+gexP+t+B2kPz6WpjOgQIQO4U
p3oc5RwDtSHPSP9r1wIm5fPIaAGCz//aUEzYO0t7TNL7iNvz+jPnyGTBx/Ob
I6Rgff4mMIlo2BI4Hod1WRBkRknvcRjtbJ8JsnOe3xIhBU0H40mIFDTSmLvJ
HCwSRlkh/uNaSl8PAjm8zaojLlLsrzFiZX57sksNBE+l7Kx2403ICuqlCM/e
1gf43WKHVUelcDFdrrzc6EkUuo79q5uO83FKQypCmW4ijaVKKv1rk450o9ev
H2WCnD3ZnKfehHiEIyTVS3Id0SdaLviRIaWfO1/dCbfkibv9j+SkrshXuiv0
NP17q1PwG/bod5M=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->848634323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dotted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dotted"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", " ", 
     ButtonBox["Small",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Small"]}], "}"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->82643427],

Cell[CellGroupData[{

Cell[BoxData["Dotted"], "Input",
 CellLabel->"In[1]:=",
 CellID->423855823],

Cell[BoxData[
 RowBox[{"Dashing", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "Small"}], "}"}], "]"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123323484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39672239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " provide richer specification of dashing: "
}], "ExampleText",
 CellID->3146420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", 
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"0.1", "-", "r"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.03", ",", "0.05", ",", "0.08"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->487066461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{0.01, 0.09000000000000001}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.03, 0.07}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.05, 0.05}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.08, 0.020000000000000004`}], LineBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->154933809]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteDashing", "[", 
       RowBox[{"{", 
        RowBox[{"d", ",", 
         RowBox[{"15", "-", "d"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "8", ",", "12"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302616010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteDashing[{2, 13}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{5, 10}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{8, 7}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{12, 3}], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",\

 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->109723155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72811268],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dotted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dotted"]], "InlineFormula"],
 " is absolute dashing, independent of the image size:"
}], "ExampleText",
 CellID->72097842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Dotted", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->540741371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{0, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {Dashing[{0, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->70], ",", 
   GraphicsBox[
    {Dashing[{0, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{261, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49982428]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotDashed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DotDashed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->336426326],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->68404475]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dotted - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 53.6027606}", "context" -> "System`", 
    "keywords" -> {
     "dotted", "dotted lines", "dotted edges", "dotted 3D lines", 
      "dotted 2D lines", "dotted grid lines", "dotted frame", "dotted mesh", 
      "dotted contour", "dotted curve", "dotted arrow", "dotted grid", 
      "dotted gridlines"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Dotted is a graphics directive that specifies that lines which follow \
should be drawn dotted.", "synonyms" -> {}, "title" -> "Dotted", "type" -> 
    "Symbol", "uri" -> "ref/Dotted"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4177, 120, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22709, 738}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1471, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2094, 62, 1571, 37, 70, "ObjectNameGrid"],
Cell[3668, 101, 472, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4177, 120, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4554, 134, 148, 5, 70, "ExampleSection",
 CellID->375960744],
Cell[4705, 141, 56, 1, 70, "ExampleText",
 CellID->568660478],
Cell[CellGroupData[{
Cell[4786, 146, 359, 13, 28, "Input",
 CellID->543815691],
Cell[5148, 161, 274, 8, 73, "Output",
 CellID->305723807]
}, Open  ]],
Cell[CellGroupData[{
Cell[5459, 174, 381, 13, 28, "Input",
 CellID->494817468],
Cell[5843, 189, 1555, 30, 102, 101, 2, "CachedBoxData", "BoxData", "Output",
 CellID->66120073]
}, Open  ]],
Cell[7413, 222, 125, 3, 70, "ExampleDelimiter",
 CellID->255849672],
Cell[7541, 227, 56, 1, 70, "ExampleText",
 CellID->273114951],
Cell[CellGroupData[{
Cell[7622, 232, 333, 10, 28, "Input",
 CellID->340435630],
Cell[7958, 244, 578, 14, 88, "Output",
 Evaluatable->False,
 CellID->394301079]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8585, 264, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8809, 273, 208, 8, 70, "ExampleText",
 CellID->386942407],
Cell[CellGroupData[{
Cell[9042, 285, 239, 7, 70, "Input",
 CellID->425061707],
Cell[9284, 294, 307, 9, 121, "Output",
 CellID->112703219]
}, Open  ]],
Cell[CellGroupData[{
Cell[9628, 308, 290, 9, 70, "Input",
 CellID->913846666],
Cell[9921, 319, 1537, 31, 129, 114, 3, "CachedBoxData", "BoxData", "Output",
 CellID->39406449]
}, Open  ]],
Cell[11473, 353, 125, 3, 70, "ExampleDelimiter",
 CellID->101466395],
Cell[11601, 358, 66, 1, 70, "ExampleText",
 CellID->77058257],
Cell[CellGroupData[{
Cell[11692, 363, 288, 9, 70, "Input",
 CellID->325230780],
Cell[11983, 374, 1876, 35, 70, "Output",
 Evaluatable->False,
 CellID->848634323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13908, 415, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[14149, 424, 482, 18, 70, "ExampleText",
 CellID->82643427],
Cell[CellGroupData[{
Cell[14656, 446, 75, 2, 70, "Input",
 CellID->423855823],
Cell[14734, 450, 243, 8, 36, "Output",
 CellID->123323484]
}, Open  ]],
Cell[14992, 461, 124, 3, 70, "ExampleDelimiter",
 CellID->39672239],
Cell[15119, 466, 358, 12, 70, "ExampleText",
 CellID->3146420],
Cell[CellGroupData[{
Cell[15502, 482, 695, 24, 70, "Input",
 CellID->487066461],
Cell[16200, 508, 587, 17, 75, "Output",
 CellID->154933809]
}, Open  ]],
Cell[CellGroupData[{
Cell[16824, 530, 689, 24, 70, "Input",
 CellID->302616010],
Cell[17516, 556, 565, 17, 75, "Output",
 CellID->109723155]
}, Open  ]],
Cell[18096, 576, 124, 3, 70, "ExampleDelimiter",
 CellID->72811268],
Cell[18223, 581, 224, 7, 70, "ExampleText",
 CellID->72097842],
Cell[CellGroupData[{
Cell[18472, 592, 622, 21, 70, "Input",
 CellID->540741371],
Cell[19097, 615, 472, 16, 75, "Output",
 CellID->49982428]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19630, 638, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19949, 649, 955, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20941, 689, 319, 9, 70, "MoreAboutSection",
 CellID->336426326],
Cell[21263, 700, 148, 3, 70, "MoreAbout",
 CellID->68404475]
}, Open  ]],
Cell[21426, 706, 27, 0, 70, "History"],
Cell[21456, 708, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

