(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29575,       1128]
NotebookOptionsPosition[     22498,        879]
NotebookOutlinePosition[     23814,        916]
CellTagsIndexPosition[     23729,        911]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Value Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ManipulatingValueLists"], 
          "Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Manipulating Value Lists\"\>", 
       2->"\<\"Patterns and Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Set" :> Documentation`HelpLookup["paclet:ref/Set"], "UpValues" :> 
          Documentation`HelpLookup["paclet:ref/UpValues"], "Information" :> 
          Documentation`HelpLookup["paclet:ref/Information"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Set\"\>", 2->"\<\"UpValues\"\>", 
       3->"\<\"Information\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DownValues", "ObjectName",
 CellID->4836],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DownValues",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DownValues"], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of transformation rules corresponding to \
all downvalues defined for the symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4005]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can specify the downvalues for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " by making an assignment of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"DownValues", "[", 
    StyleBox["f", "TI"], "]"}], "=", 
   StyleBox["list", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8210],

Cell[TextData[{
 "The list returned by ",
 Cell[BoxData[
  ButtonBox["DownValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DownValues"]], "InlineFormula"],
 " has elements of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["HoldPattern",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldPattern"], "[", 
    StyleBox["lhs", "TI"], "]"}], ":>", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24879]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62146465],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->859337231],

Cell[TextData[{
 "Define values for a function ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->288257239],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], "=", "2"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83674149],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], "=", "3"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->117396894],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->286138672],

Cell[TextData[{
 "These are the downvalues associated with ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->335297698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->209117178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", "1", "]"}], "]"}], "\[RuleDelayed]", "2"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", "2", "]"}], "]"}], "\[RuleDelayed]", "3"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
    SuperscriptBox["x", "2"]}]}], "}"}]], "Output",
 ImageSize->{479, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->352107780]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18462],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DownValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DownValues"]], "InlineFormula"],
 " returns rules corresponding to definitions made for a symbol:"
}], "ExampleText",
 CellID->37106708],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122156078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->584247823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{173, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51813770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41549070],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DownValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DownValues"]], "InlineFormula"],
 " can be used to set the values directly:"
}], "ExampleText",
 CellID->224018317],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DownValues", "[", "g", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"g", "[", "1", "]"}], "\[RuleDelayed]", "1"}], ",", 
     RowBox[{
      RowBox[{"g", "[", "x_", "]"}], "\[RuleDelayed]", 
      RowBox[{"2", 
       RowBox[{"g", "[", 
        RowBox[{"x", "-", "1"}], "]"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196885427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "g", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->71442494],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVc1SwjAQDm1aVBAQDyAHhoPe1LfQnnyIDuMMHBwd5Fkd3yZu0t203aaT
FJGTnWk2u0n2+/L35SXfb17f8v12na+yXf6x2a4/V8/vOwjFPSGiJyHEw1xA
XUHN/PRl8EMPKGMIJ2AjsFO0tyy+RKtHfpuRukXENqPJVPXPoUjBjVn8zjNu
yXxdfFmuEhqk9mR1LppZhHbAxqcYH4NNwKZBWUbYW7ayKSZmGhpzcPolFlSG
LSxlhaVIquwE7kYzyjk20a5Yj+PMKkbOlyw+d8zNz5qypbgC/ZNyHiLqGYuH
rThlnYZzlpazKnf+sDPjQw3LHn5G6I7Quttq5zt57cDslnkSzPqCtfBVmynX
To9cvYLxqoq6UIWijtGfoSWF1SMLZSX87N+refytGqhy5fT3aHr53iV+Fmn0
vcWwrwPL4noP+OtC2cy57KRMPHMbEr0QXKn+DvnmZEhtKswQvdoZupZc8+o4
rTp3dCSuTb/bEVIeUlO6LwtVvy9GAQ++jaL3A5G/+aw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60762900]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "5", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->64749565],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->270419144]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23095],

Cell["The resulting rules are in the order given: ", "ExampleText",
 CellID->61662867],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", ">", 
     RowBox[{"-", "2"}]}]}], "]"}], ":=", 
  RowBox[{"g1", "[", "x", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", "<", "2"}]}], "]"}], ":=", 
  RowBox[{"g2", "[", "x", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->794934954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27403804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", 
      RowBox[{"x_", "/;", 
       RowBox[{"x", ">", 
        RowBox[{"-", "2"}]}]}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"g1", "[", "x", "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", 
      RowBox[{"x_", "/;", 
       RowBox[{"x", "<", "2"}]}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"g2", "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{489, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201534761]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->221993772],

Cell[BoxData[
 RowBox[{"g1", "[", "0", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->63343853]
}, Open  ]],

Cell["Now reorder the definitions: ", "ExampleText",
 CellID->77965635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DownValues", "[", "f", "]"}], "=", 
  RowBox[{"Reverse", "[", 
   RowBox[{"DownValues", "[", "f", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->50882524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", 
      RowBox[{"x_", "/;", 
       RowBox[{"x", "<", "2"}]}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"g2", "[", "x", "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", 
      RowBox[{"x_", "/;", 
       RowBox[{"x", ">", 
        RowBox[{"-", "2"}]}]}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"g1", "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{489, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->8079646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->145395411],

Cell[BoxData[
 RowBox[{"g2", "[", "0", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->682354908]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192427887],

Cell["Copy a symbol's definitions to another symbol:", "ExampleText",
 CellID->8029391],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"f", "[", 
    RowBox[{"x", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->130078382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DownValues", "[", "g", "]"}], "=", 
  RowBox[{
   RowBox[{"DownValues", "[", "f", "]"}], "/.", 
   RowBox[{"f", "\[Rule]", "g"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->218087578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"g", "[", "1", "]"}], "]"}], "\[RuleDelayed]", "1"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"g", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"2", " ", 
     RowBox[{"g", "[", 
      RowBox[{"x", "-", "1"}], "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->456051401]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "10", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12395406],

Cell[BoxData["512"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->108316909]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8938],

Cell["Values can be defined by immediate or delayed assignments:", \
"ExampleText",
 CellID->237517932],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"n", "*", 
   RowBox[{"f", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->199882610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->894639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", "1", "]"}], "]"}], "\[RuleDelayed]", "1"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"f", "[", "n_", "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"n", " ", 
     RowBox[{"f", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304608329]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375649716],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " is used to protect the rules from their own definitions:"
}], "ExampleText",
 CellID->46349163],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->276034557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93379875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{173, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256878811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "\[RuleDelayed]", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->240430453],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x_", "2"], "\[RuleDelayed]", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1223308]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68063005],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " display downvalues but do not return them as values:"
}], "ExampleText",
 CellID->172195385],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17094182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->509726874],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1U0sOgjAQHVrA8FETVixxYbyGmigrD9EQE1gYDXJ/nf5IHQMSjU3a+fW9
eW3hJLr6fBFdU4mibMWtbqp7cby2mOIeADsAwDIH9B/oqWlHiRMgxpVhOjPW
Vjd9FXifhgiXEENO8ha1Vihd1kNu8mXou71lJ2ZsQrhCk1+QfRYbKXJGUAGJ
2WtPdNKBPlJdgDZ8Q9iO8aSO3PDNST4n+pOf2FKjdvYV6/RbWX64jf+8MX3r
YNKpMhIXJO4VKTYp3Cp2v/zVAEofdD/KuXWq4OhXtwK7UWYb6f8RvCddkhDz
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->462488489]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OwnValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OwnValues"]], "InlineFormula"],
 " returns a value that can be used in a program:"
}], "ExampleText",
 CellID->257978063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14087175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["x", "3"]}], "}"}]], "Output",
 ImageSize->{173, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->316675609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145564896],

Cell["\<\
Evaluation of an expression involves applying rules for its head:\
\>", "ExampleText",
 CellID->1118000],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105555544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"f", "[", "2", "]"}], "]"}], "/.", 
  RowBox[{"DownValues", "[", "f", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53388353],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  SuperscriptBox["2", "3"], "]"}]], "Output",
 ImageSize->{59, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->841982754]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29830],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpValues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpValues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Information",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Information"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18638]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29532],

Cell[TextData[ButtonBox["Manipulating Value Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingValueLists"]], "Tutorials",
 CellID->30262],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->85463372],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->180178702]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DownValues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 16.1033366}", "context" -> "System`", 
    "keywords" -> {
     "assignments", "definitions", "evaluation", "symbol table"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DownValues[f] gives a list of transformation rules corresponding to all \
downvalues defined for the symbol f. ", "synonyms" -> {"down values"}, 
    "title" -> "DownValues", "type" -> "Symbol", "uri" -> "ref/DownValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4856, 159, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62146465]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23587, 904}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2223, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2846, 79, 47, 1, 70, "ObjectName",
 CellID->4836],
Cell[2896, 82, 615, 19, 70, "Usage",
 CellID->4005]
}, Open  ]],
Cell[CellGroupData[{
Cell[3548, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4026, 123, 331, 12, 70, "Notes",
 CellID->8210],
Cell[4360, 137, 459, 17, 70, "Notes",
 CellID->24879]
}, Closed]],
Cell[CellGroupData[{
Cell[4856, 159, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62146465],
Cell[CellGroupData[{
Cell[5240, 173, 148, 5, 70, "ExampleSection",
 CellID->859337231],
Cell[5391, 180, 131, 5, 70, "ExampleText",
 CellID->288257239],
Cell[5525, 187, 138, 5, 70, "Input",
 CellID->83674149],
Cell[5666, 194, 139, 5, 70, "Input",
 CellID->117396894],
Cell[5808, 201, 145, 5, 70, "Input",
 CellID->286138672],
Cell[5956, 208, 143, 5, 70, "ExampleText",
 CellID->335297698],
Cell[CellGroupData[{
Cell[6124, 217, 106, 3, 70, "Input",
 CellID->209117178],
Cell[6233, 222, 565, 17, 39, "Output",
 CellID->352107780]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6847, 245, 216, 7, 70, "ExampleSection",
 CellID->18462],
Cell[7066, 254, 242, 7, 70, "ExampleText",
 CellID->37106708],
Cell[7311, 263, 145, 5, 70, "Input",
 CellID->122156078],
Cell[CellGroupData[{
Cell[7481, 272, 106, 3, 70, "Input",
 CellID->584247823],
Cell[7590, 277, 311, 10, 39, "Output",
 CellID->51813770]
}, Open  ]],
Cell[7916, 290, 124, 3, 70, "ExampleDelimiter",
 CellID->41549070],
Cell[8043, 295, 221, 7, 70, "ExampleText",
 CellID->224018317],
Cell[8267, 304, 424, 14, 70, "Input",
 CellID->196885427],
Cell[CellGroupData[{
Cell[8716, 322, 105, 3, 70, "Input",
 CellID->71442494],
Cell[8824, 327, 743, 16, 70, "Output",
 Evaluatable->False,
 CellID->60762900]
}, Open  ]],
Cell[CellGroupData[{
Cell[9604, 348, 96, 3, 70, "Input",
 CellID->64749565],
Cell[9703, 353, 159, 5, 36, "Output",
 CellID->270419144]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9911, 364, 223, 7, 70, "ExampleSection",
 CellID->23095],
Cell[10137, 373, 86, 1, 70, "ExampleText",
 CellID->61662867],
Cell[10226, 376, 366, 13, 70, "Input",
 CellID->794934954],
Cell[CellGroupData[{
Cell[10617, 393, 105, 3, 70, "Input",
 CellID->27403804],
Cell[10725, 398, 620, 20, 36, "Output",
 CellID->201534761]
}, Open  ]],
Cell[CellGroupData[{
Cell[11382, 423, 97, 3, 70, "Input",
 CellID->221993772],
Cell[11482, 428, 185, 6, 36, "Output",
 CellID->63343853]
}, Open  ]],
Cell[11682, 437, 71, 1, 70, "ExampleText",
 CellID->77965635],
Cell[CellGroupData[{
Cell[11778, 442, 200, 6, 70, "Input",
 CellID->50882524],
Cell[11981, 450, 618, 20, 36, "Output",
 CellID->8079646]
}, Open  ]],
Cell[CellGroupData[{
Cell[12636, 475, 97, 3, 70, "Input",
 CellID->145395411],
Cell[12736, 480, 186, 6, 36, "Output",
 CellID->682354908]
}, Open  ]],
Cell[12937, 489, 125, 3, 70, "ExampleDelimiter",
 CellID->192427887],
Cell[13065, 494, 87, 1, 70, "ExampleText",
 CellID->8029391],
Cell[13155, 497, 276, 10, 70, "Input",
 CellID->130078382],
Cell[CellGroupData[{
Cell[13456, 511, 221, 7, 70, "Input",
 CellID->218087578],
Cell[13680, 520, 504, 16, 36, "Output",
 CellID->456051401]
}, Open  ]],
Cell[CellGroupData[{
Cell[14221, 541, 97, 3, 70, "Input",
 CellID->12395406],
Cell[14321, 546, 160, 5, 36, "Output",
 CellID->108316909]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14530, 557, 232, 7, 70, "ExampleSection",
 CellID->8938],
Cell[14765, 566, 103, 2, 70, "ExampleText",
 CellID->237517932],
Cell[14871, 570, 281, 10, 70, "Input",
 CellID->199882610],
Cell[CellGroupData[{
Cell[15177, 584, 103, 3, 70, "Input",
 CellID->894639],
Cell[15283, 589, 504, 16, 36, "Output",
 CellID->304608329]
}, Open  ]],
Cell[15802, 608, 125, 3, 70, "ExampleDelimiter",
 CellID->375649716],
Cell[15930, 613, 239, 7, 70, "ExampleText",
 CellID->46349163],
Cell[16172, 622, 145, 5, 70, "Input",
 CellID->276034557],
Cell[CellGroupData[{
Cell[16342, 631, 105, 3, 70, "Input",
 CellID->93379875],
Cell[16450, 636, 312, 10, 39, "Output",
 CellID->256878811]
}, Open  ]],
Cell[CellGroupData[{
Cell[16799, 651, 157, 5, 70, "Input",
 CellID->240430453],
Cell[16959, 658, 240, 8, 36, "Output",
 CellID->1223308]
}, Open  ]],
Cell[17214, 669, 124, 3, 70, "ExampleDelimiter",
 CellID->68063005],
Cell[17341, 674, 369, 12, 70, "ExampleText",
 CellID->172195385],
Cell[17713, 688, 144, 5, 70, "Input",
 CellID->17094182],
Cell[CellGroupData[{
Cell[17882, 697, 106, 3, 70, "Input",
 CellID->509726874],
Cell[17991, 702, 517, 13, 70, "Output",
 Evaluatable->False,
 CellID->462488489]
}, Open  ]],
Cell[18523, 718, 226, 7, 70, "ExampleText",
 CellID->257978063],
Cell[CellGroupData[{
Cell[18774, 729, 105, 3, 70, "Input",
 CellID->14087175],
Cell[18882, 734, 312, 10, 39, "Output",
 CellID->316675609]
}, Open  ]],
Cell[19209, 747, 125, 3, 70, "ExampleDelimiter",
 CellID->145564896],
Cell[19337, 752, 114, 3, 70, "ExampleText",
 CellID->1118000],
Cell[19454, 757, 145, 5, 70, "Input",
 CellID->105555544],
Cell[CellGroupData[{
Cell[19624, 766, 189, 6, 70, "Input",
 CellID->53388353],
Cell[19816, 774, 212, 7, 39, "Output",
 CellID->841982754]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20089, 788, 311, 9, 70, "SeeAlsoSection",
 CellID->29830],
Cell[20403, 799, 692, 26, 70, "SeeAlso",
 CellID->18638]
}, Open  ]],
Cell[CellGroupData[{
Cell[21132, 830, 314, 9, 70, "TutorialsSection",
 CellID->29532],
Cell[21449, 841, 157, 3, 70, "Tutorials",
 CellID->30262],
Cell[21609, 846, 178, 3, 70, "Tutorials",
 CellID->244552785]
}, Open  ]],
Cell[CellGroupData[{
Cell[21824, 854, 299, 8, 70, "MoreAboutSection"],
Cell[22126, 864, 133, 3, 70, "MoreAbout",
 CellID->85463372],
Cell[22262, 869, 141, 3, 70, "MoreAbout",
 CellID->180178702]
}, Open  ]],
Cell[22418, 875, 50, 0, 70, "History"],
Cell[22471, 877, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

