(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18543,        521]
NotebookOptionsPosition[     15293,        416]
NotebookOutlinePosition[     16726,        456]
CellTagsIndexPosition[     16641,        451]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StructuredSelection" :> 
          Documentation`HelpLookup["paclet:ref/StructuredSelection"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"StructuredSelection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DragAndDrop", "ObjectName",
 CellID->6093],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DragAndDrop",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DragAndDrop"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether to allow drag\[Hyphen]and\[Hyphen]drop editing \
on the contents of the cell. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"DragAndDrop", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", dragging an already\[Hyphen]selected region cuts the region from its \
original location, and pastes it at the location you move to. "
}], "Notes",
 CellID->14384],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DragAndDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DragAndDrop"]], "InlineFormula"],
 " is more often set as a global option in the front end, rather than as an \
option for individual cells. "
}], "Notes",
 CellID->16316]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17366118],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->208446739],

Cell[TextData[{
 "Turn ",
 Cell[BoxData[
  ButtonBox["DragAndDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DragAndDrop"]], "InlineFormula"],
 " on for the current session:"
}], "ExampleText",
 CellID->164001905],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"$FrontEndSession", ",", 
   RowBox[{"DragAndDrop", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->589913516],

Cell["Create a notebook to try drag-and-drop editing:", "ExampleText",
 CellID->27505167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"TextCell", "[", 
      RowBox[{"\"\<one two three\>\"", ",", "\"\<Text\>\""}], "]"}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->733813148],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+kua9HCraeNN26SCKaBtjGnTuya9MFVbqU3xAKKA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   "], {{0, 0}, {458, 63}}, {0, 255}],
  ImageSize->{458 0.75, 63 0.75},
  PlotRange->{{0, 458}, {0, 63}}]], "NotebookImage",
 CellID->21255383]
}, Open  ]],

Cell["Select a piece of text and drag it:", "ExampleText",
 CellID->265854829],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPlFcUhml63/gX+kua9HCraeNN26SKqahtjGnTuya9MFVbrU09gVpE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   "], {{0, 0}, {458, 63}}, {0, 255}],
  ImageSize->{458 0.75, 63 0.75},
  PlotRange->{{0, 458}, {0, 63}}]], "NotebookImage",
 CellID->582143452],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnO1Pk1cYxln2ffFf2F+yZC9fNVv8si2ZYibqFmO27NuSfTBTN53LfANf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   "], {{0, 0}, {458, 63}}, {0, 255}],
  ImageSize->{458 0.75, 63 0.75},
  PlotRange->{{0, 458}, {0, 63}}]], "NotebookImage",
 CellID->12332280],

Cell["Reset the option to its initial setting:", "ExampleText",
 CellID->203638175],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"$FrontEndSession", ",", 
   RowBox[{"DragAndDrop", "\[Rule]", "Inherited"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->273502133]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26531],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["StructuredSelection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StructuredSelection"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->7076]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20831],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->903079232],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->231025592]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DragAndDrop - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 16.4158446}", "context" -> "System`", 
    "keywords" -> {
     "drag-and-drop formula editing", "drag-and-drop math editing", 
      "drag-and-drop text editing", "drag-and-drop typesetting", 
      "editing operations"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DragAndDrop is an option for Cell which specifies whether to allow \
drag-and-drop editing on the contents of the cell. ", 
    "synonyms" -> {"drag and drop"}, "title" -> "DragAndDrop", "type" -> 
    "Symbol", "uri" -> "ref/DragAndDrop"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4301, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->17366118]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16499, 444}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1809, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2432, 75, 48, 1, 70, "ObjectName",
 CellID->6093],
Cell[2483, 78, 644, 19, 70, "Usage",
 CellID->4648]
}, Open  ]],
Cell[CellGroupData[{
Cell[3164, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3642, 119, 341, 10, 70, "Notes",
 CellID->14384],
Cell[3986, 131, 278, 8, 70, "Notes",
 CellID->16316]
}, Closed]],
Cell[CellGroupData[{
Cell[4301, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17366118],
Cell[CellGroupData[{
Cell[4685, 158, 148, 5, 70, "ExampleSection",
 CellID->208446739],
Cell[4836, 165, 221, 8, 70, "ExampleText",
 CellID->164001905],
Cell[5060, 175, 187, 5, 70, "Input",
 CellID->589913516],
Cell[5250, 182, 89, 1, 70, "ExampleText",
 CellID->27505167],
Cell[CellGroupData[{
Cell[5364, 187, 279, 9, 70, "Input",
 CellID->733813148],
Cell[5646, 198, 2494, 43, 70, "NotebookImage",
 CellID->21255383]
}, Open  ]],
Cell[8155, 244, 78, 1, 70, "ExampleText",
 CellID->265854829],
Cell[8236, 247, 2528, 44, 70, "NotebookImage",
 CellID->582143452],
Cell[10767, 293, 2559, 44, 70, "NotebookImage",
 CellID->12332280],
Cell[13329, 339, 83, 1, 70, "ExampleText",
 CellID->203638175],
Cell[13415, 342, 192, 5, 70, "Input",
 CellID->273502133]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13656, 353, 311, 9, 70, "SeeAlsoSection",
 CellID->26531],
Cell[13970, 364, 217, 6, 70, "SeeAlso",
 CellID->7076]
}, Open  ]],
Cell[CellGroupData[{
Cell[14224, 375, 314, 9, 70, "TutorialsSection",
 CellID->20831],
Cell[14541, 386, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[14765, 395, 319, 9, 70, "MoreAboutSection",
 CellID->903079232],
Cell[15087, 406, 134, 3, 70, "MoreAbout",
 CellID->231025592]
}, Open  ]],
Cell[15236, 412, 27, 0, 70, "History"],
Cell[15266, 414, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

