(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22456,        811]
NotebookOptionsPosition[     16965,        633]
NotebookOutlinePosition[     19104,        689]
CellTagsIndexPosition[     18937,        682]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Reading and Writing Mathematica Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Save" :> Documentation`HelpLookup["paclet:ref/Save"], 
          "LinkWrite" :> Documentation`HelpLookup["paclet:ref/LinkWrite"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Save\"\>", 2->"\<\"LinkWrite\"\>", 
       3->"\<\"Export\"\>", 4->"\<\"Put\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Mathematica Expressions in Files" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaExpressionsInFiles"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Files\"\>", 
       2->"\<\"Mathematica Expressions in Files\"\>", 
       3->"\<\"Package Development\"\>", 
       4->"\<\"Time Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DumpSave", "ObjectName",
 CellID->21819],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DumpSave",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DumpSave"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", ",", 
        StyleBox["symbol", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes definitions associated with a symbol to a file \
in internal ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " format. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DumpSave",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DumpSave"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", ",", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes out definitions associated with all symbols in \
the specified context. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DumpSave",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DumpSave"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["object", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["object", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes out definitions for several symbols or contexts. \
"
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DumpSave",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DumpSave"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"package\", \"TI\"]`\)]\)\>\"", ",", 
        StyleBox["objects", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]chooses the name of the output file based on the \
computer system used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16585]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 " writes out definitions in a binary format that is optimized for input by \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->10752],

Cell["\<\
Each file has a plain text header identifying its type and contents. \
\>", "Notes",
 CellID->6631],

Cell[TextData[{
 "Files written by ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 " can be read by ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31236],

Cell[TextData[{
 "Files written by ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 " can only be read on the same type of computer system on which they were \
written. "
}], "Notes",
 CellID->29413],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 " will not preserve open stream and link objects. "
}], "Notes",
 CellID->647],

Cell[TextData[{
 "Files written by ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 " conventionally have names that end with .mx. "
}], "Notes",
 CellID->21248],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DumpSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DumpSave"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"package\", \"TI\"]`\)]\)\>\"", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " writes a file with a names such as ",
 Cell[BoxData[
  StyleBox["package", "TI"]], "InlineFormula"],
 StyleBox[".mx", "InlineCode"],
 "/(value of ",
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 ")/",
 Cell[BoxData[
  StyleBox["package", "TI"]], "InlineFormula"],
 StyleBox[".mx", "InlineCode"],
 "."
}], "Notes",
 CellID->22760],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DumpSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DumpSave"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " to write out the definition for the value of a symbol ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " itself. "
}], "Notes",
 CellID->16613],

Cell[TextData[{
 "You can typically read a dump file when you start ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by using the ",
 Cell[BoxData["initfile"], "InlineFormula"],
 " command\[Hyphen]line option. "
}], "Notes",
 CellID->15555]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->182804226],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->77937924],

Cell["Save all definitions for a function in a binary file:", "ExampleText",
 CellContext->"Global`",
 CellID->381225147],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_Real", "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}]}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->399790442],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}], "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->373186838],

Cell["Set the directory to a place for temporary files:", "ExampleText",
 CellContext->"Global`",
 CellID->629248033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "$TemporaryPrefix", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->69594558],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->361081077]
}, Open  ]],

Cell[TextData[{
 "Save all definitions for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellContext->"Global`",
 CellID->228143293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DumpSave", "[", 
  RowBox[{"\"\<f.mx\>\"", ",", "f"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->27351489],

Cell[BoxData[
 RowBox[{"{", "f", "}"}]], "Output",
 CellContext->"Global`",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->214945723]
}, Open  ]],

Cell[TextData[{
 "Clear definitions for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellContext->"Global`",
 CellID->15618121],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[5]:=",
 CellID->679616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "f"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[6]:=",
 CellID->847208239],

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3384088818-1463745",
 CellID->25035606]
}, Open  ]],

Cell[TextData[{
 "Restore the definitions for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " from the file:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->29445870],

Cell[BoxData[
 RowBox[{"<<", "f.mx"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[7]:=",
 CellID->22745124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "f"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[8]:=",
 CellID->201600487],

Cell[CellGroupData[{

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3384088818-9171029",
 CellID->307393724],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_Real", "]"}], ":=", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
         RowBox[{"N", "[", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", "1"}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3384088818-9171029",
 CellID->150046938]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"3", "/", "2"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[9]:=",
 CellID->1005033238],

Cell[BoxData["3.25`"], "Output",
 CellContext->"Global`",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->256807848]
}, Open  ]],

Cell["Reset to the original directory: ", "ExampleText",
 CellID->312448703],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1854054]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26673],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30660]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2775],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->3376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->456117339],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->65350038],

Cell[TextData[ButtonBox["Mathematica Expressions in Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaExpressionsInFiles"]], "MoreAbout",
 CellID->161961850],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->87085303],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->18863907]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DumpSave - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 26.0098402}", "context" -> "System`", 
    "keywords" -> {
     "binary save", "core dump", "FASL files", "save definitions", 
      "save dump"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "DumpSave[\"file.mx\", symbol] writes definitions associated with a \
symbol to a file in internal Mathematica format. DumpSave[\"file.mx\", \" \
StyleBox[ context`]\"] writes out definitions associated with all symbols in \
the specified context. DumpSave[\"file.mx\", {object_1, object_2, ...}] \
writes out definitions for several symbols or contexts. DumpSave[\"StyleBox[ \
package`]\", objects] chooses the name of the output file based on the \
computer system used. ", "synonyms" -> {"dump save"}, "title" -> "DumpSave", 
    "type" -> "Symbol", "uri" -> "ref/DumpSave"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8808, 298, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->182804226]},
 "Info3384088818-1463745"->{
  Cell[11525, 417, 95, 2, 70, "Print",
   CellTags->"Info3384088818-1463745",
   CellID->25035606]},
 "Info3384088818-9171029"->{
  Cell[12103, 447, 96, 2, 70, "Print",
   CellTags->"Info3384088818-9171029",
   CellID->307393724],
  Cell[12202, 451, 1043, 32, 70, "Print",
   CellTags->"Info3384088818-9171029",
   CellID->150046938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18429, 664},
 {"Info3384088818-1463745", 18578, 668},
 {"Info3384088818-9171029", 18708, 672}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2530, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3153, 86, 46, 1, 70, "ObjectName",
 CellID->21819],
Cell[3202, 89, 2195, 67, 70, "Usage",
 CellID->16585]
}, Open  ]],
Cell[CellGroupData[{
Cell[5434, 161, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5912, 178, 299, 11, 70, "Notes",
 CellID->10752],
Cell[6214, 191, 109, 3, 70, "Notes",
 CellID->6631],
Cell[6326, 196, 321, 13, 70, "Notes",
 CellID->31236],
Cell[6650, 211, 273, 9, 70, "Notes",
 CellID->29413],
Cell[6926, 222, 214, 7, 70, "Notes",
 CellID->647],
Cell[7143, 231, 235, 8, 70, "Notes",
 CellID->21248],
Cell[7381, 241, 692, 25, 70, "Notes",
 CellID->22760],
Cell[8076, 268, 446, 15, 70, "Notes",
 CellID->16613],
Cell[8525, 285, 246, 8, 70, "Notes",
 CellID->15555]
}, Closed]],
Cell[CellGroupData[{
Cell[8808, 298, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->182804226],
Cell[CellGroupData[{
Cell[9193, 312, 147, 5, 70, "ExampleSection",
 CellID->77937924],
Cell[9343, 319, 121, 2, 70, "ExampleText",
 CellID->381225147],
Cell[9467, 323, 219, 8, 70, "Input",
 CellID->399790442],
Cell[9689, 333, 255, 9, 70, "Input",
 CellID->373186838],
Cell[9947, 344, 117, 2, 70, "ExampleText",
 CellID->629248033],
Cell[CellGroupData[{
Cell[10089, 350, 147, 4, 70, "Input",
 CellID->69594558],
Cell[10239, 356, 256, 7, 36, "Output",
 CellID->361081077]
}, Open  ]],
Cell[10510, 366, 171, 7, 70, "ExampleText",
 CellID->228143293],
Cell[CellGroupData[{
Cell[10706, 377, 162, 5, 70, "Input",
 CellID->27351489],
Cell[10871, 384, 205, 7, 36, "Output",
 CellID->214945723]
}, Open  ]],
Cell[11091, 394, 167, 7, 70, "ExampleText",
 CellID->15618121],
Cell[11261, 403, 123, 4, 70, "Input",
 CellID->679616],
Cell[CellGroupData[{
Cell[11409, 411, 113, 4, 70, "Input",
 CellID->847208239],
Cell[11525, 417, 95, 2, 70, "Print",
 CellTags->"Info3384088818-1463745",
 CellID->25035606]
}, Open  ]],
Cell[11635, 422, 187, 7, 70, "ExampleText",
 CellID->29445870],
Cell[11825, 431, 115, 4, 70, "Input",
 CellID->22745124],
Cell[CellGroupData[{
Cell[11965, 439, 113, 4, 70, "Input",
 CellID->201600487],
Cell[CellGroupData[{
Cell[12103, 447, 96, 2, 70, "Print",
 CellTags->"Info3384088818-9171029",
 CellID->307393724],
Cell[12202, 451, 1043, 32, 70, "Print",
 CellTags->"Info3384088818-9171029",
 CellID->150046938]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13294, 489, 146, 5, 70, "Input",
 CellID->1005033238],
Cell[13443, 496, 187, 6, 36, "Output",
 CellID->256807848]
}, Open  ]],
Cell[13645, 505, 76, 1, 70, "ExampleText",
 CellID->312448703],
Cell[13724, 508, 122, 4, 70, "Input",
 CellID->1854054]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13895, 518, 311, 9, 70, "SeeAlsoSection",
 CellID->26673],
Cell[14209, 529, 921, 35, 70, "SeeAlso",
 CellID->30660]
}, Open  ]],
Cell[CellGroupData[{
Cell[15167, 569, 313, 9, 70, "TutorialsSection",
 CellID->2775],
Cell[15483, 580, 428, 12, 70, "Tutorials",
 CellID->3376]
}, Open  ]],
Cell[CellGroupData[{
Cell[15948, 597, 319, 9, 70, "MoreAboutSection",
 CellID->456117339],
Cell[16270, 608, 121, 3, 70, "MoreAbout",
 CellID->65350038],
Cell[16394, 613, 173, 3, 70, "MoreAbout",
 CellID->161961850],
Cell[16570, 618, 148, 3, 70, "MoreAbout",
 CellID->87085303],
Cell[16721, 623, 172, 3, 70, "MoreAbout",
 CellID->18863907]
}, Open  ]],
Cell[16908, 629, 27, 0, 70, "History"],
Cell[16938, 631, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

