(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37484,       1213]
NotebookOptionsPosition[     32576,       1050]
NotebookOutlinePosition[     33978,       1089]
CellTagsIndexPosition[     33892,       1084]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"], 
          "Hierarchical Drawing of Directed Graphs" :> 
          Documentation`HelpLookup["paclet:tutorial/LayeredGraphDrawing"], 
          "Tree Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/TreeDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"General Graph Drawing\"\>", 
       2->"\<\"Hierarchical Drawing of Directed Graphs\"\>", 
       3->"\<\"Tree Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DirectedEdges" :> 
          Documentation`HelpLookup["paclet:ref/DirectedEdges"], 
          "VertexLabeling" :> 
          Documentation`HelpLookup["paclet:ref/VertexLabeling"], 
          "EdgeRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/EdgeRenderingFunction"], 
          "Arrowheads" :> 
          Documentation`HelpLookup["paclet:ref/Arrowheads"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DirectedEdges\"\>", 
       2->"\<\"VertexLabeling\"\>", 3->"\<\"EdgeRenderingFunction\"\>", 
       4->"\<\"Arrowheads\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["EdgeLabeling", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["EdgeLabeling",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
     " and related functions which specifies whether labeling specified for \
edges should be displayed by default."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EdgeLabeling", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " gives edge labels as tooltips."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EdgeLabeling", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " displays edge labels explicitly at the middle of each edge."
}], "Notes",
 CellID->847182290],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EdgeLabeling", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " does not display edge labels."
}], "Notes",
 CellID->248127219],

Cell[TextData[{
 "Any explicit setting for ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " overrides the setting for ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->200462403]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->247986485],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->128382831],

Cell["Show edge labels:", "ExampleText",
 CellID->287294084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<1\[Rule]2\>\""}], "}"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2140736384],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8675355367152218`, 0.43547689032484677`}, {
    0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
    0.9349065648054304, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"1\[Rule]2\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{1, 2}]}, LineBox[{2, 3}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"2\[Rule]4\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{2, 4}]}, LineBox[{3, 4}], 
      LineBox[{4, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8675355367152218`, 0.43547689032484677`}, {
     0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
     0.9349065648054304, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235843413]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47442898],

Cell["Show edge labels as tooltips:", "ExampleText",
 CellID->893982927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<1\[Rule]2\>\""}], "}"}], ",", 
     
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81530259],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8675355367152218`, 0.43547689032484677`}, {
    0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
    0.9349065648054304, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      TagBox[
       TooltipBox[LineBox[{1, 2}],
        "\"1\[Rule]2\""],
       Annotation[#, "1\[Rule]2", "Tooltip"]& ], LineBox[{2, 3}], 
      TagBox[
       TooltipBox[LineBox[{2, 4}],
        "\"2\[Rule]4\""],
       Annotation[#, "2\[Rule]4", "Tooltip"]& ], LineBox[{3, 4}], 
      LineBox[{4, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8675355367152218`, 0.43547689032484677`}, {
     0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
     0.9349065648054304, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->881112854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343426117],

Cell["Do not show edge labels at all:", "ExampleText",
 CellID->2092542890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<1\[Rule]2\>\""}], "}"}], ",", 
     
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1511452689],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8675355367152218`, 0.43547689032484677`}, {
    0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
    0.9349065648054304, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{2, 3}], 
      LineBox[{2, 4}], LineBox[{3, 4}], LineBox[{4, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8675355367152218`, 0.43547689032484677`}, {
     0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
     0.9349065648054304, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16799489]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " show edge labels:"
}], "ExampleText",
 CellID->1778810794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<1\[Rule]2\>\""}], "}"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}], ",", 
    RowBox[{"2", "\[Rule]", "6"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1523592485],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.22963424539783706`, 0.}, {0.9694707822196998, 
    0.7504816076574512}, {0.22937303724693014`, 1.5005436783379675`}, {0., 
    0.7502216061069953}, {1.850950256325116, 0.024373838346959498`}, {
    1.8509391546700145`, 1.4763074913313754`}}, {
     {RGBColor[0.5, 0., 0.], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"1\[Rule]2\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{1, 2}]}, LineBox[{2, 3}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"2\[Rule]4\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{2, 4}]}, LineBox[{2, 5}], 
      LineBox[{2, 6}], LineBox[{3, 4}], LineBox[{4, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.22963424539783706`, 0.}, {0.9694707822196998,
      0.7504816076574512}, {0.22937303724693014`, 1.5005436783379675`}, {0., 
     0.7502216061069953}, {1.850950256325116, 0.024373838346959498`}, {
     1.8509391546700145`, 1.4763074913313754`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36775232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132240337],

Cell["Show edge labels as tooltips:", "ExampleText",
 CellID->616230318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<1\[Rule]2\>\""}], "}"}], ",", 
     
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}], ",", 
     
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1232112956],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.22963424539783706`, 0.}, {0.9694707822196998, 
    0.7504816076574512}, {0.22937303724693014`, 1.5005436783379675`}, {0., 
    0.7502216061069953}, {1.850950256325116, 0.024373838346959498`}, {
    1.8509391546700145`, 1.4763074913313754`}}, {
     {RGBColor[0.5, 0., 0.], 
      TagBox[
       TooltipBox[LineBox[{1, 2}],
        "\"1\[Rule]2\""],
       Annotation[#, "1\[Rule]2", "Tooltip"]& ], LineBox[{2, 3}], 
      TagBox[
       TooltipBox[LineBox[{2, 4}],
        "\"2\[Rule]4\""],
       Annotation[#, "2\[Rule]4", "Tooltip"]& ], LineBox[{2, 5}], 
      LineBox[{2, 6}], LineBox[{3, 4}], LineBox[{4, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.22963424539783706`, 0.}, {0.9694707822196998,
      0.7504816076574512}, {0.22937303724693014`, 1.5005436783379675`}, {0., 
     0.7502216061069953}, {1.850950256325116, 0.024373838346959498`}, {
     1.8509391546700145`, 1.4763074913313754`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1964824692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205965497],

Cell["Do not show edge labels at all:", "ExampleText",
 CellID->1608609041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<1\[Rule]2\>\""}], "}"}], ",", 
     
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}], ",", 
     
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->903005169],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.22963424539783706`, 0.}, {0.9694707822196998, 
    0.7504816076574512}, {0.22937303724693014`, 1.5005436783379675`}, {0., 
    0.7502216061069953}, {1.850950256325116, 0.024373838346959498`}, {
    1.8509391546700145`, 1.4763074913313754`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{2, 3}], 
      LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{2, 6}], LineBox[{3, 4}], 
      LineBox[{4, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.22963424539783706`, 0.}, {0.9694707822196998,
      0.7504816076574512}, {0.22937303724693014`, 1.5005436783379675`}, {0., 
     0.7502216061069953}, {1.850950256325116, 0.024373838346959498`}, {
     1.8509391546700145`, 1.4763074913313754`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->756520168]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "An explicit setting for ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " overrides the setting for ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1037762209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<1\[Rule]2\>\""}], "}"}], ",", 
     
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}], ",", 
     
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Line", "[", "#", "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92569019],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      LineBox[{{0.22963424539783706`, 0.}, {0.9694707822196998, 
       0.7504816076574512}}], 
      LineBox[{{0.9694707822196998, 0.7504816076574512}, {
       0.22937303724693014`, 1.5005436783379675`}}], 
      LineBox[{{0.9694707822196998, 0.7504816076574512}, {0., 
       0.7502216061069953}}], 
      LineBox[{{0.9694707822196998, 0.7504816076574512}, {1.850950256325116, 
       0.024373838346959498`}}], 
      LineBox[{{0.9694707822196998, 0.7504816076574512}, {1.8509391546700145`,
        1.4763074913313754`}}], 
      LineBox[{{0.22937303724693014`, 1.5005436783379675`}, {0., 
       0.7502216061069953}}], 
      LineBox[{{0., 0.7502216061069953}, {0.22963424539783706`, 0.}}]}, 
     GraphicsComplexBox[{{0.22963424539783706`, 0.}, {0.9694707822196998, 
      0.7504816076574512}, {0.22937303724693014`, 1.5005436783379675`}, {0., 
      0.7502216061069953}, {1.850950256325116, 0.024373838346959498`}, {
      1.8509391546700145`, 1.4763074913313754`}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.22963424539783706`, 0.}, {0.9694707822196998,
      0.7504816076574512}, {0.22937303724693014`, 1.5005436783379675`}, {0., 
     0.7502216061069953}, {1.850950256325116, 0.024373838346959498`}, {
     1.8509391546700145`, 1.4763074913313754`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1689442075]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " to display edge labels for ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1359176367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<1\[Rule]2\>\""}], "}"}], ",", 
     
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}], ",", 
     
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"#3", "=!=", "None"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"#3", ",", 
            RowBox[{"Mean", "[", "#1", "]"}], ",", 
            RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}], ",", 
          RowBox[{"{", "}"}]}], "]"}], ",", 
        RowBox[{"Line", "[", "#", "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1577743680],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsGroup3DBox[{{{
       Text3DBox["\<\"1\[Rule]2\"\>", {0.01682825501091295, 
        0.2530334699926868, 0.49948713603236966`},
        Background->RGBColor[1, 1, 0]], 
       Line3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
        0.24474517434175455`, 0.9989742720647393}}]}, {{}, 
       Line3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
        0.530937494896891, 0.9494940038888471, 0.5283357973836946}}]}, {
       Text3DBox["\<\"2\[Rule]4\"\>", {0.42247204019364604`, 
        0.12237258717087728`, 0.7610668153546427},
        Background->RGBColor[1, 1, 0]], 
       Line3DBox[{{0., 0.24474517434175455`, 0.9989742720647393}, {
        0.8449440803872921, 0., 0.523159358644546}}]}, {{}, 
       Line3DBox[{{0., 0.24474517434175455`, 0.9989742720647393}, {
        0.530937494896891, 0.9494940038888471, 0.5283357973836946}}]}, {{}, 
       Line3DBox[{{0.8449440803872921, 0., 0.523159358644546}, {
        0.0336565100218259, 0.261321765643619, 0.}}]}, {{}, 
       Line3DBox[{{0.530937494896891, 0.9494940038888471, 
        0.5283357973836946}, {0.8449440803872921, 0., 0.523159358644546}}]}}, 
     GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
      0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
      0.5283357973836946}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[Point3DBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[3],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[4],
         "5"],
        Annotation[#, 5, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  ImageSize->{193., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{197, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->885175885]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectedEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedEdges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146],

Cell[TextData[ButtonBox["Hierarchical Drawing of Directed Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LayeredGraphDrawing"]], "Tutorials",
 CellID->106430589],

Cell[TextData[ButtonBox["Tree Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TreeDrawing"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EdgeLabeling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 37.7757664}", "context" -> "System`", 
    "keywords" -> {
     "labeling of graph edges", "edge labels in graph plot", 
      "edge annotation", "edge values"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EdgeLabeling is an option for GraphPlot and related functions which \
specifies whether labeling specified for edges should be displayed by \
default.", "synonyms" -> {"edge labeling"}, "title" -> "EdgeLabeling", "type" -> 
    "Symbol", "uri" -> "ref/EdgeLabeling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6439, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->247986485]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33749, 1077}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1883, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2506, 70, 1577, 37, 70, "ObjectNameGrid"],
Cell[4086, 109, 668, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4791, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5269, 150, 243, 8, 70, "Notes",
 CellID->1067943069],
Cell[5515, 160, 261, 8, 70, "Notes",
 CellID->847182290],
Cell[5779, 170, 233, 8, 70, "Notes",
 CellID->248127219],
Cell[6015, 180, 387, 13, 70, "Notes",
 CellID->200462403]
}, Closed]],
Cell[CellGroupData[{
Cell[6439, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->247986485],
Cell[CellGroupData[{
Cell[6824, 212, 148, 5, 70, "ExampleSection",
 CellID->128382831],
Cell[6975, 219, 60, 1, 70, "ExampleText",
 CellID->287294084],
Cell[CellGroupData[{
Cell[7060, 224, 480, 15, 28, "Input",
 CellID->2140736384],
Cell[7543, 241, 1945, 56, 105, "Output",
 CellID->235843413]
}, Open  ]],
Cell[9503, 300, 124, 3, 70, "ExampleDelimiter",
 CellID->47442898],
Cell[9630, 305, 72, 1, 70, "ExampleText",
 CellID->893982927],
Cell[CellGroupData[{
Cell[9727, 310, 568, 18, 70, "Input",
 CellID->81530259],
Cell[10298, 330, 1417, 44, 70, "Output",
 CellID->881112854]
}, Open  ]],
Cell[11730, 377, 125, 3, 70, "ExampleDelimiter",
 CellID->343426117],
Cell[11858, 382, 75, 1, 70, "ExampleText",
 CellID->2092542890],
Cell[CellGroupData[{
Cell[11958, 387, 566, 18, 70, "Input",
 CellID->1511452689],
Cell[12527, 407, 1200, 36, 70, "Output",
 CellID->16799489]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13776, 449, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[14000, 458, 486, 18, 70, "ExampleText",
 CellID->1778810794],
Cell[CellGroupData[{
Cell[14511, 480, 558, 16, 70, "Input",
 CellID->1523592485],
Cell[15072, 498, 2368, 66, 70, "Output",
 CellID->36775232]
}, Open  ]],
Cell[17455, 567, 125, 3, 70, "ExampleDelimiter",
 CellID->132240337],
Cell[17583, 572, 72, 1, 70, "ExampleText",
 CellID->616230318],
Cell[CellGroupData[{
Cell[17680, 577, 655, 20, 70, "Input",
 CellID->1232112956],
Cell[18338, 599, 1842, 54, 70, "Output",
 CellID->1964824692]
}, Open  ]],
Cell[20195, 656, 125, 3, 70, "ExampleDelimiter",
 CellID->205965497],
Cell[20323, 661, 75, 1, 70, "ExampleText",
 CellID->1608609041],
Cell[CellGroupData[{
Cell[20423, 666, 650, 20, 70, "Input",
 CellID->903005169],
Cell[21076, 688, 1632, 47, 70, "Output",
 CellID->756520168]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22757, 741, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[22991, 750, 393, 13, 70, "ExampleText",
 CellID->1037762209],
Cell[CellGroupData[{
Cell[23409, 767, 789, 24, 70, "Input",
 CellID->92569019],
Cell[24201, 793, 2222, 58, 70, "Output",
 CellID->1689442075]
}, Open  ]],
Cell[26438, 854, 372, 13, 70, "ExampleText",
 CellID->1359176367],
Cell[CellGroupData[{
Cell[26835, 871, 1072, 33, 70, "Input",
 CellID->1577743680],
Cell[27910, 906, 2395, 55, 70, "Output",
 CellID->885175885]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30366, 968, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[30685, 979, 997, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[31719, 1019, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[32040, 1030, 147, 3, 70, "Tutorials",
 CellID->99260146],
Cell[32190, 1035, 173, 3, 70, "Tutorials",
 CellID->106430589],
Cell[32366, 1040, 138, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[32519, 1046, 27, 0, 70, "History"],
Cell[32549, 1048, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

