(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    348320,       8683]
NotebookOptionsPosition[    330646,       8068]
NotebookOutlinePosition[    332407,       8112]
CellTagsIndexPosition[    332320,       8107]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eigenvalues and Eigenvectors" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EigenvaluesAndEigenvectors"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Eigenvalues and Eigenvectors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"], "Eigenvectors" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvectors"], "NullSpace" :> 
          Documentation`HelpLookup["paclet:ref/NullSpace"], 
          "JordanDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/JordanDecomposition"], 
          "SchurDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SchurDecomposition"], 
          "SingularValueDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueDecomposition"], 
          "QRDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/QRDecomposition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Eigenvalues\"\>", 
       2->"\<\"Eigenvectors\"\>", 3->"\<\"NullSpace\"\>", 
       4->"\<\"JordanDecomposition\"\>", 5->"\<\"SchurDecomposition\"\>", 
       6->"\<\"SingularValueDecomposition\"\>", 
       7->"\<\"QRDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Matrix Decompositions\"\>", 
       2->"\<\"Matrix Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eigensystem", "ObjectName",
 CellID->14474],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigensystem",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigensystem"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["values", "TI"], ",", 
        StyleBox["vectors", "TI"]}], "}"}]], "InlineFormula"],
     " of the eigenvalues and eigenvectors of the square matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigensystem",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigensystem"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized eigenvalues and eigenvectors of ",
     
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigensystem",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigensystem"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the eigenvalues and eigenvectors for the first ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " eigenvalues of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigensystem",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigensystem"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["a", "TI"]}], "}"}], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the first ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " generalized eigenvalues and eigenvectors."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->80]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 " finds numerical eigenvalues and eigenvectors if ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " contains approximate real or complex numbers. "
}], "Notes",
 CellID->18480],

Cell["\<\
All the non\[Hyphen]zero eigenvectors given are independent. If the number of \
eigenvectors is equal to the number of non\[Hyphen]zero eigenvalues, then \
corresponding eigenvalues and eigenvectors are given in corresponding \
positions in their respective lists. \
\>", "Notes",
 CellID->23976],

Cell[TextData[{
 "If there are more eigenvalues than independent eigenvectors, then each \
extra eigenvalue is paired with a vector of zeros. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->133667995,
  ButtonNote->"133667995"]
}], "Notes",
 CellID->13801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigensystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigensystem"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["ZeroTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZeroTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " to determine whether expressions should be assumed to be zero. The default \
setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ZeroTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZeroTest"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->857],

Cell[TextData[{
 "The eigenvalues and eigenvectors satisfy the matrix equation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ".", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["vectors", "TI"], "]"}]}], "==", 
   RowBox[{
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["vectors", "TI"], "]"}], ".", 
    RowBox[{
     ButtonBox["DiagonalMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiagonalMatrix"], "[", 
     StyleBox["values", "TI"], "]"}]}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->216849556,
  ButtonNote->"216849556"]
}], "Notes",
 CellID->30693],

Cell[TextData[{
 "Generalized eigenvalues and eigenvectors satisfy ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ".", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["vectors", "TI"], "]"}]}], "==", 
   RowBox[{"a", ".", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["vectors", "TI"], "]"}], ".", 
    RowBox[{
     ButtonBox["DiagonalMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiagonalMatrix"], "[", 
     StyleBox["values", "TI"], "]"}]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9564],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["vals", "TI"], ",", 
     StyleBox["vecs", "TI"]}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", 
    StyleBox["m", "TI"], "]"}]}]], "InlineFormula"],
 " can be used to set ",
 Cell[BoxData[
  StyleBox["vals", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["vecs", "TI"]], "InlineFormula"],
 " to be the eigenvalues and eigenvectors respectively. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->7058344,
  ButtonNote->"7058344"]
}], "Notes",
 CellID->22169],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigensystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigensystem"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to applying ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 " to each element of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigensystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigensystem"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17708],

Cell[TextData[{
 "The option settings ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " can be used to specify that explicit radicals should be generated for all \
cubics and quartics. "
}], "Notes",
 CellID->9477],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects can be used in ",
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->110528527,
  ButtonNote->"110528527"]
}], "Notes",
 CellID->11122]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43518051],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->606821195],

Cell["Symbolic eigenvalues and eigenvectors:", "ExampleText",
 CellID->253445758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "d", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"4", " ", "b", " ", "c"}], "-", 
          RowBox[{"2", " ", "a", " ", "d"}], "+", 
          SuperscriptBox["d", "2"]}]]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "d", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"4", " ", "b", " ", "c"}], "-", 
          RowBox[{"2", " ", "a", " ", "d"}], "+", 
          SuperscriptBox["d", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "a"}], "+", "d", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["a", "2"], "+", 
            RowBox[{"4", " ", "b", " ", "c"}], "-", 
            RowBox[{"2", " ", "a", " ", "d"}], "+", 
            SuperscriptBox["d", "2"]}]]}], 
         RowBox[{"2", " ", "c"}]]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "a"}], "+", "d", "-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["a", "2"], "+", 
            RowBox[{"4", " ", "b", " ", "c"}], "-", 
            RowBox[{"2", " ", "a", " ", "d"}], "+", 
            SuperscriptBox["d", "2"]}]]}], 
         RowBox[{"2", " ", "c"}]]}], ",", "1"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{497, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157811714]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20394],

Cell["Exact eigenvalues and eigenvectors:", "ExampleText",
 CellID->29909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19755],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"15", "+", 
        RowBox[{"3", " ", 
         SqrtBox["33"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"15", "-", 
        RowBox[{"3", " ", 
         SqrtBox["33"]}]}], ")"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["13", "11"]}], "+", 
        RowBox[{
         FractionBox["1", "22"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "+", 
           RowBox[{"3", " ", 
            SqrtBox["33"]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "11"]}], "+", 
        RowBox[{
         FractionBox["1", "44"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "+", 
           RowBox[{"3", " ", 
            SqrtBox["33"]}]}], ")"}]}]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["13", "11"]}], "+", 
        RowBox[{
         FractionBox["1", "22"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "-", 
           RowBox[{"3", " ", 
            SqrtBox["33"]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "11"]}], "+", 
        RowBox[{
         FractionBox["1", "44"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "-", 
           RowBox[{"3", " ", 
            SqrtBox["33"]}]}], ")"}]}]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{434, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->932519]
}, Open  ]],

Cell["Numerical value:", "ExampleText",
 CellID->765710881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109149043],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"16.116843969807043`", ",", 
     RowBox[{"-", "1.116843969807043`"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.2833494518006403`", ",", "0.6416747259003202`", ",", "1.`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2833494518006403`"}], ",", 
       RowBox[{"-", "0.14167472590032015`"}], ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", 
       RowBox[{"-", "2.`"}], ",", "1.`"}], "}"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{474, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->227588412]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427536199],

Cell["\<\
Eigenvalues and eigenvectors computed with numerical methods:\
\>", "ExampleText",
 CellID->720213348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626881757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"16.116843969807046`", ",", 
     RowBox[{"-", "1.1168439698070423`"}], ",", 
     RowBox[{"-", "8.873929900667798`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.231970687246286`"}], ",", 
       RowBox[{"-", "0.5253220933012335`"}], ",", 
       RowBox[{"-", "0.8186734993561816`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7858302387420671`"}], ",", 
       RowBox[{"-", "0.08675133925662842`"}], ",", "0.6123275602288102`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4082482904638633`", ",", 
       RowBox[{"-", "0.816496580927726`"}], ",", "0.40824829046386263`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{504, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->656894085]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12387],

Cell["\<\
Eigenvalues and eigenvectors computed with numerical methods using 20-digit \
precision:\
\>", "ExampleText",
 CellID->45209607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", "20"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30593621],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"16.11684396980704298977591720231`20.", ",", 
     RowBox[{"-", "1.11684396980704298977591720233571420947`20."}], ",", 
     "3.6215030945320295396923624443157269074`20.*^-30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.23197068724628586166084715996393166237`20."}], ",", 
       RowBox[{"-", "0.5253220933012336934319879951297077174`20."}], ",", 
       RowBox[{"-", "0.81867349935618152520312883029378605452`20."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.78583023874206710167510101490555266609`20."}], ",", 
       RowBox[{"-", "0.08675133925662845361504187871974921573`20."}], ",", 
       "0.61232756022881019444501725747092723258`20."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.40824829046386301636621401244506805368`20.", ",", 
       RowBox[{"-", "0.81649658092772603273242802490240120679`20."}], ",", 
       "0.4082482904638630163662140124560209247`20."}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{547, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60887428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->761909638],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  StyleBox["vals", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["vecs", "TI"]], "InlineFormula"],
 " to be the eigenvalues and eigenvectors respectively:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->7058344],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{"N", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175797764],

Cell[CellGroupData[{

Cell[BoxData["vals"], "Input",
 CellLabel->"In[2]:=",
 CellID->120700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16.116843969807046`", ",", 
   RowBox[{"-", "1.1168439698070423`"}], ",", 
   RowBox[{"-", "8.873929900667798`*^-16"}]}], "}"}]], "Output",
 ImageSize->{244, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299636642]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["vecs"], "Input",
 CellLabel->"In[3]:=",
 CellID->29553805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.231970687246286`"}], ",", 
     RowBox[{"-", "0.5253220933012335`"}], ",", 
     RowBox[{"-", "0.8186734993561816`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7858302387420671`"}], ",", 
     RowBox[{"-", "0.08675133925662842`"}], ",", "0.6123275602288102`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4082482904638633`", ",", 
     RowBox[{"-", "0.816496580927726`"}], ",", "0.40824829046386263`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{461, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->272027045]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6181],

Cell["Smallest two eigenvalues and eigenvectors:", "ExampleText",
 CellID->18540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"i", "+", "j", "+", "1"}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.0459549047996723`*^-12", ",", "4.426901333353528`*^-15"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.00019927809123430635`", ",", 
       RowBox[{"-", "0.005220803144240182`"}], ",", "0.048235938513528226`", 
       ",", 
       RowBox[{"-", "0.21311789445351878`"}], ",", "0.4879540135430962`", ",",
        
       RowBox[{"-", "0.5257476104881661`"}], ",", "0.04177266635949903`", ",",
        "0.4781533821763959`", ",", 
       RowBox[{"-", "0.4377144105782719`"}], ",", "0.12548933726004052`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.000018892326271833865`"}], ",", 
       "0.0006630673404566363`", ",", 
       RowBox[{"-", "0.008440050745953923`"}], ",", "0.054169186865833545`", 
       ",", 
       RowBox[{"-", "0.20006496273741275`"}], ",", "0.4513031185338781`", ",",
        
       RowBox[{"-", "0.6320193749296165`"}], ",", "0.536251721525218`", ",", 
       RowBox[{"-", "0.25242874263093357`"}], ",", "0.05058518931010284`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{557, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148900621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17349],

Cell["\<\
Eigenvalues are listed according to multiplicity along with independent \
eigenvectors:\
\>", "ExampleText",
 CellID->30461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38407845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302102435],

Cell["\<\
Zero vectors are used when there are more eigenvalues than independent \
eigenvectors:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->133667995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299491235],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188499079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60367306],

Cell["Compute generalized eigenvalues and eigenvectors:", "ExampleText",
 CellID->39774976],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "4."}], "}"}]}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9.", ",", "16."}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Eigensystem", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->20482314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.2500000000000004`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.19364916731037085`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.25000000000000033`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.19364916731037088`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8484719165348688`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.08583783620510349`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.49804348493191636`"}], "-", 
        RowBox[{"0.15709856728864385`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8484719165348688`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.08583783620510349`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.49804348493191636`"}], "+", 
        RowBox[{"0.15709856728864385`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{344, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->513626169]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32315],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sparse Arrays",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->71472088],

Cell["A block diagonal matrix:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->110528527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Band", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"ArrayPlot", "[", 
   RowBox[{"s", ",", 
    RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11740],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2zFuwjAUBmATX4DREgPZ7GzcIEztVHEFIlQBQ5WKImXMATIzcwImWJi4
Sm7AEdL3bChxSimtEEP7W8qzn5V8cTL5KcpTMp88vyTz6SgJH2fJ62Q6egsf
0hlNyZYQYsOHEjSuaGSPTVVRX4+So9zv96vVarfbCcNBbrfbWh6s1+uo1gtJ
g7Is+dKgphRF0el0+v2+MBykMUYpdcrDMBSuRRxku90ObROaA+fj8bipLpfL
4XDIQ3M2z/PcU+M4zm0TmsMhhwoVKlSoUKFChQoVKlSo91EXi0Wv1+MTjD1r
MBh4OV3lqd1uN7ZNaA6cZ1nWVKni/E51kDBHxbtLmqaVbaL1szfgHvKLtbvH
hwoVKlSoUKFChQoVKlSo91GvqDh/URuS6p2llIptO9WptbUGNI6Od3Ngs9b2
NLfA/EwtzW8ioHF06CUUKFCgQIECBQoUKP9Eue0enDQHHOoArbWnx973rSt2
9M2qw9Pyj1pFX35PUKBAgQIFChQoUKD8WaUoihvuwcuypNnTmrIsu5hTQlNe
7v3d9PmvKdF6B8qBRvI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163836414]
}, Open  ]],

Cell["Its eigenvalues and eigenvectors:", "ExampleText",
 CellID->49707881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68154384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{486, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->203531973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->239691314],

Cell["A tridiagonal matrix:", "ExampleText",
 CellID->135652336],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
       
       RowBox[{
        RowBox[{"3.", 
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}]}], "-", "2."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"250", ",", "250"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317140975],

Cell["\<\
The three eigenvalues with largest magnitude and a plot of the corresponding \
eigenvectors:\
\>", "ExampleText",
 CellID->44080672],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"val", ",", "vec"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{"s", ",", "3"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"vec", ",", 
   RowBox[{"PlotLabel", "\[Rule]", "val"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->206745217],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9XN2THMWRb6Z7pudjv6RFEsY2xj5zd08OP/geZz8sbAGW+NCiEJyQT1og
xIJYzKKVdVjCltdGRju7WrC+ZkYrtHiRQhY+XYAPIjhH2BFEKNCTXxxhnvzg
f2SuqrIqKzuzemYk8ClWM9Mz3VmZv8zKysrKqh37Dz337Iv7D808vf/ebXP7
f/TczNOv3Pv9l+bUV/EdURT9Xv0/eFekPnfUJ/P/K51OJ4r1J/MvOqNfIv7t
Rv1S/PPN9WajDn+f/G8jKsG3639o1l+Gv08a16Ivm2ffXf/zeL05Mz0bxeru
KJ4/OK2ulxqfAG3x1Lew3YJqdoOhYdtbqkcF9WLoFFW7+Oj1AytRWb1HsaJg
OR0mrau/KDYvig9OyXLk71G8URoJbYa2oriKioaC4sU+8fUgaoZOWUuxpNtu
LtZbjbH181PtU5PqsqBplJsHd0Irrfqcfh2bW5863p48VGRy1ZhcRZRrycq1
WNdQ7zjfGIfrrIyJeZk5cB2ulbA1oQfFgnpOt4tsRIm5vt44YtuJHefx9XcP
WDu4Nyj9oGEbdHjxrW0g/dWLT332lw/VL3//26e/WXm8uTgGnJZbB3deferE
jdP//cHsmc8+vKnv+PSv1/YtFhQfUVFxkrGW1PCOaKi/B7ddBD0OToy1dk2t
q7/52UOIOm332qV9reUJaDd5bf4A3L11sl0wmE7UWzl2keiX0QxiY3PAteJU
faCMA37N6SctD1o9SvdRrLXfqLdQR96KvhrEcUC/lKwVNert5ckPrs4qYWL4
HriZmm6eHINfK/r7VDFxYeth4LI98YrFrcCsyFhF7f7J9vS+awqDvU9d/ejD
z8DGLdtL46qpqGgYUdhdWNlqWpkA1d/89O/qSfXYmdM31AeFobHLImKmaa3/
QVmNsarxOUAoKht6f3rvFLTSbIy19v4H8Ag6UiLe+ONp1RrH6Cv5GCWX27uQ
5QT6ntOVNuiZubW3HgW+DUYJKErpbW37UbD7iwfOUd0nYEsAS1G0AVYI3K6d
3a5IK4YBqwSQAbsyKKcKE8oOmEtUNTSAqoLhndkXFDPQC8vY+wETwF693pPx
lSC71thiff38Y0721DfmYFetCJszSFQVEq0J28Xm68cVv1TyEvH+H/1uHswP
OE8UX1fauwFVg0cMkiuxI9OfijP11ykf4MlSyi/0GWWuYbmRfrh/VFF+0z8U
PknWs9l2C45fxBF96hP15bPo+44/9CvoBGClsdYNaHYQLcANgWUi8QvjJ4CC
cplz++pvgJetCO5isBrSP3XPjAXtsKVXhRXGQWkTYpsfv3+Mjtgp9n/lNNXr
k/VT58ZesdL7Eack7GpQIFhhY8jY3PPfXwavQvym7DlJEAOpoTAGFcFZGIOU
6S9h3s/YZ6q830uzHyiVIzsXts4L3Q8Lazd3pJd3LWCD3vL5yFEI9qBSdxSw
pS9n+ns1JFVC+SgLCoWs3qF/Q+e2lqe4uLL7F8CC1PwIazPt+Ahp/bGfqTZj
1vcNAiVAgFo/el6EOma0vbRU5+WwzjM8+L5hKClxQQ9e1hLBCmQtstY3COyK
pB3guORk/d7WC2hHesyjJu78I8FVavbufFkJTwVi3Re3HbEWWstSU6GejV/G
W9Z/pQLrRKC4kbVVFNYU9OrxyuKqteIBgWmB0QxLmQpeQE6gpGIniARt/NNe
eURRO3tyApUp8eWWNGquwQdqTqmX+Gi+bekbOiXQJswTFJRKmQMCPam/L+VL
xvWXsVSQCfrjE1M/Xfr5g+rWy6tHjYetUCxt93EQRXcSTwKjuI6vwHcrFi0H
NSfTqYUHATYYjQYEZlxXXiLta8pkFIGBOtRahfhVHYeDhSwvPEDHzTJFsmOC
Efh5k/kVL/VPxPrgWYDg9K8efPqHRxTxrRNtMofheFEFRXcFNQQ9GFG0GqLt
GquooseEEFkZ3n/99j0kbnhLEU09SUI9bYLfHCvXz76Myo+GDAsosVKTGoAe
3r7GRw3Zf7m2QLrUaitmUurv9BP6q1IIgQzqwpP6+RW4lIj3ryHSX5sLdsiO
tsC3EMmcHLfeapj1xULIh3LZK9RSuWZNO9aje7kiOx6Kb4jsHKcisTGMSEEs
xXoYi4TJA1hYXU1Nt179gf52i+s/q689cn7PXhuXDDHrS4IelmERI0MRtwJA
AsSCf1rzIBaB4baRybMS4x1KmajCgMN7F2CjZ3uN+pXXn7VxzuaO84pqjtyo
f7B6eJjJBfER2ojNH5WdN1H+++NjbwM1VMTns4rYwZYgQcUg93elHLm53x+i
PWHR9QSQW2vTdZmhDh8J06DkMLOn3s5jvLlvubX1FAIeIcFe4EYWEQV4mXEU
Lof6QcnO4N9fxd5rxi2brVjb/yLOxAcZZpV8nafUE/onbk1yYd0cgRQpU1Pn
GSfrBWrM0s34mkoMtd4BAbzGZgYZgtV8BEroDz9abMDtIL0bAUr2PbHvQQlL
2BYyE5ZugOlmQHgD6p83guwENC/TQAinHC0jUx0IfeAJg54Yx+Ms3hmNlYIy
cbQH2DWNBECuEfRTLv4vMGlqDCeIC6h0kHfVMhadJSNu/jkvo9MhiRIQlrBc
w4ynKrvGWR72oBEiKfRxPq74zIrzS+CpULKJeouPVXHWyhHYLvqz9vhxu4HK
S4i3gSQFiMnnoeG5MEV3iGiPzlRZfyM0RpyMKig7c/qGkpTLWBA69DiPejlr
KCe15IxPoHJClAmpCDkLrTCu7bwVKQ2x6yLTP39+NNgDkxwflSdV2FfGQQu9
k+FcZhyWhO4GhO74bJ3T2BSUKs7xnV4qFymHfGNYmk0MTz5n5zHbALsu9Xh+
cxdJkAoKvtHrp4r6CbrFQlCaLQzHlHGXCt1UhW6C+iQ0tgQlKmR1c3HpIQCA
SFRBiaQzjMLy3MXQ5BFphWmjyq4r7Hnem76UL4vLX+x+1spNJPF9R3ftt/aq
KQHmIdSXSoqI53A057EN7n32z6Oa2N+jxLJq/rm7C0JvoFnMgUQxTgzcP/ds
FOOk38bKWT+bkFjSPROO3hLThpoeizZqHpsUsAGM3z78ZFf91sg4EgUiO26L
GAsCcOwJpFDylpaNjGhMglOrUPuZGR3z1kW8P8B1SArT9jBHM4oUN+q1tXA/
xmE9kEAf56JbNS+HTptjdf3h6+3BZtZurqtbYIzLlS/1fYCYJSBUov4EHuqG
NLbMPVdu1J8ry5BEWfM2Nf12Y7ul7AjkIxyV4Vuc74PBKIA5vgN94cszl3r9
LopQ473wpWYs4gXeYpzHEeVAjLz927LxDIOIMmTwtBpV8OkMuR8rNvLZwpCD
O8FS8izYe0BqDya+0zkZ9dm6tzz+yxRLkWlOxLia0PsLUiPIOuYcRQTQP6Jm
JEgxeQhwnnvgqDLaKCx51aOoowSfopt4hcXZZgZTpNLkclDyYYb5IH1pbs8p
MJuMQ9eCi1hgyuYDPVoOSWL8nR6dwUDVh1P1H+usj/Pove1SRyl/Wj3fPPJQ
a/oZWP7FcN7MzpxO9DtdSdbhTHsXHUXdO/RZyHRhXE2uHbWEUTdsZZL2TkUp
a8G9O/6i5MndV56oL2szWthKafqRGnKLqvOdrc/5EfmbBnlsFD+Y3mazAnY5
w32GtTZvPwgH0Nq967Iiv1z36dRhj3YJNKOMV0ENLPwz9ElXo6YIGvqZfIK3
LWgbm0R+v+l6lTIDBcSSat6kJzGPaevXdPtHHjq354dW/n9BjbqVTmjdrw4c
WPEzJDm/M8/bVSgtcyY3CG3qvrxQ/8n+sZOqwX91FK5d2gfFTVCjZ+fzpphM
ywlrYJdO67C6tTwemed0hLZ3cuWNqZnFI4++2XjTSqaj2lORrSjJ4Hz+4E6Y
/kYyp9RtJLmd39FnUjBt/+uVr6a0dJSEmVvb9fn9weet/8C8x/+DzNSnQayr
bEBdtiYPCaszVj9fP66jlM2MzpCwCp7lrUCfgzzsD46uPXyUzOd4ptDmrrHc
y2aZ/F2Q07S1nqbORw+qH94kPGs028ceVtEQ+AvF9n2dwLjh+ivJPrgP5ntR
Z3UfaVv9/Xp6j2Z19nHiJTSisOyg3BXUNWnUwL9Q7wsfjK8qZzKYZMwfznLN
PAby8fzYCei87eXJyPMCMypQnqk1YjklU0Ga5z/l2g9emxZ8zrpDc6bfMPLQ
udPq9tfyvKlq8b32M2svzCjCPx5f4Px9zbTLoxe2xhOIiEQuLqUDkx+5vy54
vXrsCq4MjWR1ilIqtaouokdszu89gFN2DZ6vzcQsE0euB4Py+mjN1LxW2LyU
LupEhGcbR0LrrcUJqBUKZBa/ylrhrQ4KlGXGk2ft+QzJaLICoyuwbdfgFuuX
VrbrVgjnNvdCM7SqCRslce6/wVoK57x4TozNcgjn9xCMdz62DpF9BuMN2f5V
poYBI34Y57sZpzy/URM4y+wkz7DzOb/Rpa8gUFx0XPCztv/Fq+f2qZs8/9Ew
elW6YAghE5s2aR92N+OYt15jWJfZNc96/1OWW5xI6SdcAEQyWX5mZN3y8zN0
bQRnJcJG7KovWVMIZqplZjGDfTgb7mkYdETWCD3ShTce6JJl7Pgs1L83SXWm
yGttYRiW2HWvLGM4Y8qqOwKrILQeDJPZJM+Isz+x9pwE5djM0OSZ25S2l62b
CuQWOR6ejmlniK6b4wwJu4aub3P2RlYdqlQ7cnU5LNedDN8cvJnP99fBLDh5
nkY/1NBolr49eQitjcgjYkHMe4o63EJQtlGGNc/I0apF6EWDQl+813Aao1n5
cM3frroGV3q7yFhy0eR3cQ2yGJRtI8OdZ8N4LmuYXQdXiTKzrQ1B/1AkeqOr
K+G1S7sKiBGbyGYKuUYY3uE1WorrsNAZ9/N8pWIkX7KMxrqvOvs5eXbVmUvE
K3b4qMIzOhvYNY9N+OrGcFAaqGKn83r/RLc6AT/bp7oKSzbEOOGcyZrODUJX
PObk1SKDXaSjlNn6prHnXvV+fMYaZ621Q3Mhxq/l1CtwG+1W4TLKtMujV14n
MRCUPxXa9U+A/DLH37u6i8+4WbUTKyeDaK9bnQMf6wayFpZZDx8F7EkTulSU
VsLwfRqVfGTKbI0E4f2CsZFzp6y9dK2Q4CM/jfTVLEJUEENVM68kHWJ80Bo0
Gg91qxvy9VG3g0rsvq/Q0aPD1q7Cq558dAVf5uetUAsK6/yKXPvZPXrvwC+3
YhUdH/HSYORk6yGZVSBo/cvvMr3cc/DRVFZI5az6sudgLLu0sgMiUsWniW+T
d04/CmkRl2PhI2IgwjItVmhNVofVyd+a3NL6ufzc89NKqnDFnh0hCFNgAe88
85JeJDj0KLXQItzXPnE/LBuKkbWQRSK7C6JMq7io9qEa1o0XvDqQSxquipdz
Xla1ndidL6ZFmyVz1rj21sPEDn0EmM0JFWnvCq3mVYm+0cYz+gZJXRTDvXMs
bDYoCdnVMkR6VdOVsiGPmwAZUivEo3aahTl7ciIsUaCqkNf2B3cuyL1dGXvE
3R9QTw6bWs40Dg13tZXRPO0jXajtXVu9vHDk8X17DmNvNLJWGN2MdsKyhLUk
clm5+1hEtpHXt/VBG88pUPcd/88ZJ02AdmiPjJBGjOTSW9bAsgw8b/5yGwCJ
iR2a/Wj6PVtELxuEX0lEGzBjsrIduC525AyIVqS3CkvJ5xt51mdzncvfhW0z
gd0tdP867GoD2+HjxgZ2DXMrvmvS9AuSvzKb+JV50v06NYJTuOLV71TDWqtw
X8tmouQuti47W8K73IqirWFBuSSwNlgNsPFRhWSYVEHRDJ81lsPpuEjJ70kN
79ULzusyFud382V2YeftCBXZPbrzmcd9rPYdnKwSOmE+NRYY0n2qzeBu0267
rIXmw1aX2dkc3Bua4B54xUHF0cZdzoNC05UsvvP14zk7WQlq0C/Cu94p7bDE
NUEvLLHcQQr686NN/XUYC5v1uTdn19FnZNCsCWuBOGbtxP+cNUvXIHR2l0kR
MaPRoZCYazh8akBNaAGrhEFePDQjOIuvvH/id017Cojd7O/nzDyP5rF1VmLu
8KtHcP6AInZ+zOFcFfwV8qXN6MPL6ytNKPa0igTPmijaInYcsVmE3TRnVhye
OqM0DO5V7PKXvU/6RrBaev4A9A+l6Nmp5tpTi4qhmEVSOK4iXb8H1Z8o4u3c
WZQ/JUOcSpOxc9j14+0cTmwhGfxaBgXXIp3+RqVxfurJ5cBZG0XBI+iCnceS
4GZTl+uPkTuRHbbZEicPHCdE+34JT1FC6+uCjOhjgI5dRHeHtag5CmY5Y0TH
nx1kzzaRJ6GkxmYOv3xKRXIaHINQFRHq4PKd4/ZS+3w55PliOLvFn1DkEYmR
K3MojtVC66iOfa6/e8BcF+AoI9yr/7UgIjgLB0RMiXVU0uceLWWwSDUHJYhh
qJVUhfygX9V7npj6qYbAnkWVvv6Tx6zUjuyr87+AM56KeJ6Rlb/KLMK0Xoby
oiY5CgiMTJ/XpBgnhyDdm/EPI1RGez5WVG6aA4rwqRvvrwLYJeMr1Ac44Mjq
2eBUQzmBVegZSs43ju04t+jPpCpbERfriz/broJfG6mNtQrquSjGI4hcLQs5
TMmciTWIB2Xpk5d+u4YnBeHxWiAmrEYLnUKNB1TIqHvhdkWAnKkUY5tRbF7w
ZCeYZQ6jpM89fWLp+COnFna8OvcCfJidOYbi2/zMZkbTnGiV0MOueE7/viDn
cDLb77u+8vqcb7Hr77Drf2PXxmNYu/fffvsWqdwRpKLHvMRlrW0GJopcVRff
tYh71jN3DvVNw+1QYPke+2tvOo4HlwV0lZK8nios6wC77lW31qXStctTo7fT
Cs9siVa39EO1J6/hWt98XvrDMbiqwa8z2T1e164Zv/N2qHZBhMvWF/1cLkMt
9kIT0BsM3JUG8nyautu9w99FlbTQdMVSDUkVotqrdrJ8C/Qod2L/upVUH3Sp
8QhblB49McudMtk60pbxWuAgM8mjt0tb+CeOxcZ+KQsu075kiYNY1dg1q7zv
LVegEj9h9/G+cstt3IKP4f6yZ1sB/otZfd0iotyfyR07/UmL1znPbvqC2gmh
2AvVz9MWrmr3HF/yY4ycnvp5UGbS4Qm1/7CWQi0PfzEtytWwPrHmsaXG2kVp
LkIKvXM/PdLnc87/b+xxv9sBSyM1GdPKWDm64/8AcCfF2Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->362963302]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32236],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cubics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3678],

Cell["A 3\[Times]3 Vandermonde matrix:", "ExampleText",
 CellID->46680874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "^", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19640870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8", ",", "27"}], "}"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177126280]
}, Open  ]],

Cell[TextData[{
 "In general for exact 3\[Times]3 matrices the result will be given in terms \
of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->681590779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"er", "=", 
  RowBox[{"Eigensystem", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->559251542],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{568, 281},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->819086650]
}, Open  ]],

Cell[TextData[{
 "If you want the result in terms of radicals, you can use the ",
 Cell[BoxData[
  ButtonBox["Cubics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cubics"]], "InlineFormula"],
 " option:"
}], "ExampleText",
 CellID->24798682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ec", "=", 
  RowBox[{"Eigensystem", "[", 
   RowBox[{"m", ",", 
    RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->413334102],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{574, 914},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->209952518]
}, Open  ]],

Cell[TextData[{
 "Note that the result with ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects is better suited to subsequent numerical evaluation:"
}], "ExampleText",
 CellID->44452930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "er", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->145090444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "29.942767464139486`", ",", "1.8393485712117768`", ",", 
     "0.21788396464873797`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.12796634887816438`", ",", "0.35185013940766385`", ",", "1.`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.0203030913577287`"}], ",", 
       RowBox[{"-", "2.767543542178812`"}], ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.944968321426945`", ",", 
       RowBox[{"-", "4.215885544597277`"}], ",", "1.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{523, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->722225675]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "ec", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->524587683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"29.942767464139486`", "\[InvisibleSpace]", "-", 
      RowBox[{"2.220446049250313`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.8393485712117776`", "\[InvisibleSpace]", "+", 
      RowBox[{"3.552713678800501`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.21788396464874005`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.7763568394002505`*^-15", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.12796634887816438`", "\[InvisibleSpace]", "-", 
        RowBox[{"1.3386033768350818`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.35185013940766385`", "\[InvisibleSpace]", "+", 
        RowBox[{"1.3956984648875632`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
       "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3.020303091357736`"}], "-", 
        RowBox[{"2.06216725904133`*^-14", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "2.767543542178811`"}], "+", 
        RowBox[{"3.021798283651725`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
       "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"6.944968321426932`", "\[InvisibleSpace]", "+", 
        RowBox[{"1.1523594082033465`*^-14", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "4.215885544597274`"}], "-", 
        RowBox[{"1.6624938651792144`*^-15", " ", "\[ImaginaryI]"}]}], ",", 
       "1.`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{549, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->253179353]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Quartics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9810],

Cell["A 4\[Times]4 matrix:", "ExampleText",
 CellID->401134940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "^", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->621286290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "9", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8", ",", "27", ",", "64"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "16", ",", "81", ",", "256"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224115233]
}, Open  ]],

Cell[TextData[{
 "In general, for a 4\[Times]4 matrix, the result will be given in terms of \
",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->262792891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->251204608],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{461, 1398},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->315851092]
}, Open  ]],

Cell[TextData[{
 "You can get the result in terms of radicals using the ",
 Cell[BoxData[
  ButtonBox["Cubics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cubics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Quartics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartics"]], "InlineFormula"],
 " options:"
}], "ExampleText",
 CellID->1033961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"m", ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}], ",", 
   RowBox[{"Quartics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->104754260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"72", "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["56588", "3"], "+", 
          FractionBox["2710802", 
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1518483592", "+", 
               RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                SqrtBox["252717212101953"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}]], "+", 
          RowBox[{
           FractionBox["2", "3"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1518483592", "+", 
              RowBox[{"27", " ", "\[ImaginaryI]", " ", 
               SqrtBox["252717212101953"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"56588", "-", 
           FractionBox["1355401", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1518483592", "+", 
               RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                SqrtBox["252717212101953"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]], "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1518483592", "+", 
              RowBox[{"27", " ", "\[ImaginaryI]", " ", 
               SqrtBox["252717212101953"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]], "+", 
           RowBox[{"7752636", "/", 
            RowBox[{"(", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}], 
        ")"}]}]}], ",", 
     RowBox[{"72", "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["56588", "3"], "+", 
          FractionBox["2710802", 
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1518483592", "+", 
               RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                SqrtBox["252717212101953"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}]], "+", 
          RowBox[{
           FractionBox["2", "3"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1518483592", "+", 
              RowBox[{"27", " ", "\[ImaginaryI]", " ", 
               SqrtBox["252717212101953"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"56588", "-", 
           FractionBox["1355401", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1518483592", "+", 
               RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                SqrtBox["252717212101953"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]], "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1518483592", "+", 
              RowBox[{"27", " ", "\[ImaginaryI]", " ", 
               SqrtBox["252717212101953"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]], "+", 
           RowBox[{"7752636", "/", 
            RowBox[{"(", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}], 
        ")"}]}]}], ",", 
     RowBox[{"72", "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["56588", "3"], "+", 
          FractionBox["2710802", 
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1518483592", "+", 
               RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                SqrtBox["252717212101953"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}]], "+", 
          RowBox[{
           FractionBox["2", "3"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1518483592", "+", 
              RowBox[{"27", " ", "\[ImaginaryI]", " ", 
               SqrtBox["252717212101953"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"56588", "-", 
           FractionBox["1355401", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1518483592", "+", 
               RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                SqrtBox["252717212101953"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]], "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1518483592", "+", 
              RowBox[{"27", " ", "\[ImaginaryI]", " ", 
               SqrtBox["252717212101953"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]], "-", 
           RowBox[{"7752636", "/", 
            RowBox[{"(", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}], 
        ")"}]}]}], ",", 
     RowBox[{"72", "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["56588", "3"], "+", 
          FractionBox["2710802", 
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1518483592", "+", 
               RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                SqrtBox["252717212101953"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}]], "+", 
          RowBox[{
           FractionBox["2", "3"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1518483592", "+", 
              RowBox[{"27", " ", "\[ImaginaryI]", " ", 
               SqrtBox["252717212101953"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"56588", "-", 
           FractionBox["1355401", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1518483592", "+", 
               RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                SqrtBox["252717212101953"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]], "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1518483592", "+", 
              RowBox[{"27", " ", "\[ImaginaryI]", " ", 
               SqrtBox["252717212101953"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]], "-", 
           RowBox[{"7752636", "/", 
            RowBox[{"(", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["215050", "15809"]}], "+", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"4515445", " ", 
          RowBox[{"(", 
           RowBox[{"72", "+", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "+", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{
         FractionBox["1", "63236"], 
         RowBox[{"163591", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "+", 
        RowBox[{
         FractionBox["1", "379416"], 
         RowBox[{"3415", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", 
       RowBox[{
        FractionBox["179594", "15809"], "-", 
        RowBox[{
         FractionBox["1", "94854"], 
         RowBox[{"724283", " ", 
          RowBox[{"(", 
           RowBox[{"72", "+", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "+", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "+", 
        RowBox[{
         FractionBox["1", "15809"], 
         RowBox[{"11248", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "-", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"467", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["248354", "47427"]}], "+", 
        RowBox[{
         FractionBox["1", "569124"], 
         RowBox[{"698197", " ", 
          RowBox[{"(", 
           RowBox[{"72", "+", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "+", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"20603", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "+", 
        RowBox[{
         FractionBox["1", "1138248"], 
         RowBox[{"427", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["215050", "15809"]}], "+", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"4515445", " ", 
          RowBox[{"(", 
           RowBox[{"72", "+", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "+", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{
         FractionBox["1", "63236"], 
         RowBox[{"163591", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "+", 
        RowBox[{
         FractionBox["1", "379416"], 
         RowBox[{"3415", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", 
       RowBox[{
        FractionBox["179594", "15809"], "-", 
        RowBox[{
         FractionBox["1", "94854"], 
         RowBox[{"724283", " ", 
          RowBox[{"(", 
           RowBox[{"72", "+", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "+", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "+", 
        RowBox[{
         FractionBox["1", "15809"], 
         RowBox[{"11248", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "-", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"467", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["248354", "47427"]}], "+", 
        RowBox[{
         FractionBox["1", "569124"], 
         RowBox[{"698197", " ", 
          RowBox[{"(", 
           RowBox[{"72", "+", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "+", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"20603", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "+", 
        RowBox[{
         FractionBox["1", "1138248"], 
         RowBox[{"427", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "+", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["215050", "15809"]}], "+", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"4515445", " ", 
          RowBox[{"(", 
           RowBox[{"72", "-", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "-", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{
         FractionBox["1", "63236"], 
         RowBox[{"163591", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "+", 
        RowBox[{
         FractionBox["1", "379416"], 
         RowBox[{"3415", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", 
       RowBox[{
        FractionBox["179594", "15809"], "-", 
        RowBox[{
         FractionBox["1", "94854"], 
         RowBox[{"724283", " ", 
          RowBox[{"(", 
           RowBox[{"72", "-", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "-", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "+", 
        RowBox[{
         FractionBox["1", "15809"], 
         RowBox[{"11248", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "-", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"467", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["248354", "47427"]}], "+", 
        RowBox[{
         FractionBox["1", "569124"], 
         RowBox[{"698197", " ", 
          RowBox[{"(", 
           RowBox[{"72", "-", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "-", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"20603", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "+", 
        RowBox[{
         FractionBox["1", "1138248"], 
         RowBox[{"427", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "+", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["215050", "15809"]}], "+", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"4515445", " ", 
          RowBox[{"(", 
           RowBox[{"72", "-", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "-", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{
         FractionBox["1", "63236"], 
         RowBox[{"163591", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "+", 
        RowBox[{
         FractionBox["1", "379416"], 
         RowBox[{"3415", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", 
       RowBox[{
        FractionBox["179594", "15809"], "-", 
        RowBox[{
         FractionBox["1", "94854"], 
         RowBox[{"724283", " ", 
          RowBox[{"(", 
           RowBox[{"72", "-", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "-", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "+", 
        RowBox[{
         FractionBox["1", "15809"], 
         RowBox[{"11248", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "-", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"467", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["248354", "47427"]}], "+", 
        RowBox[{
         FractionBox["1", "569124"], 
         RowBox[{"698197", " ", 
          RowBox[{"(", 
           RowBox[{"72", "-", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["56588", "3"], "+", 
                FractionBox["2710802", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]], "+", 
                RowBox[{
                 FractionBox["2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"56588", "-", 
                 FractionBox["1355401", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]], "-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                  RowBox[{"1", "/", "3"}]], "-", 
                 RowBox[{"7752636", "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
               ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{
         FractionBox["1", "189708"], 
         RowBox[{"20603", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "2"]}]}], "+", 
        RowBox[{
         FractionBox["1", "1138248"], 
         RowBox[{"427", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"72", "-", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"\[Sqrt]", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox["56588", "3"], "+", 
                 FractionBox["2710802", 
                  RowBox[{"3", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                 RowBox[{
                  FractionBox["2", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]]}]}], ")"}]}]}], "-", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "6"], " ", 
                RowBox[{"(", 
                 RowBox[{"56588", "-", 
                  FractionBox["1355401", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]], "-", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                   RowBox[{"1", "/", "3"}]], "-", 
                  RowBox[{"7752636", "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["56588", "3"], "+", 
                    FractionBox["2710802", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]], "+", 
                    RowBox[{
                    FractionBox["2", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1518483592", "+", 
                    RowBox[{"27", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["252717212101953"]}]}], ")"}], 
                    RowBox[{"1", "/", "3"}]]}]}], ")"}]}], ")"}]}]}], ")"}]}],
                ")"}]}]}], ")"}], "3"]}]}]}], ",", "1"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{571, 11414},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12749420]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17382],

Cell["Here is a quadratic form in 3 dimensions:", "ExampleText",
 CellID->199318421],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{
    RowBox[{"20", " ", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"16", " ", "x", " ", "y"}], "+", 
    RowBox[{"23", " ", 
     RowBox[{"y", "^", "2"}]}], "-", 
    RowBox[{"12", " ", "x", " ", "z"}], "-", 
    RowBox[{"2", " ", "y", " ", "z"}], "+", 
    RowBox[{"17", " ", 
     RowBox[{"z", "^", "2"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50769096],

Cell[TextData[{
 "Plot the surface ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", "10"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->758218748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cp", "=", 
  RowBox[{"ContourPlot3D", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", "q", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"Contours", "\[Rule]", 
     RowBox[{"{", "10", "}"}]}], ",", 
    RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
    RowBox[{"ContourStyle", "\[Rule]", 
     RowBox[{"Opacity", "[", ".5", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->322405202],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->305305611]
}, Open  ]],

Cell[TextData[{
 "Get the symmetric matrix for the quadratic form, using ",
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->399678127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Normal", "[", 
   RowBox[{
    RowBox[{"CoefficientArrays", "[", 
     RowBox[{"q", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Symmetric", "\[Rule]", "True"}]}], "]"}], "[", 
    RowBox[{"[", "3", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11987759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", "23", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "1"}], ",", "17"}], "}"}]}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->250290074]
}, Open  ]],

Cell["Numerically compute its eigenvalues and eigenvectors:", "ExampleText",
 CellID->25918659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
  RowBox[{"Eigensystem", "[", 
   RowBox[{"N", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->41520492],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "30.433111511031253`", ",", "20.10910271539578`", ",", 
     "9.457785773572967`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.6756307264646771`", ",", 
       RowBox[{"-", "0.6935045674726079`"}], ",", 
       RowBox[{"-", "0.2501490282840278`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.3013807644323737`"}], ",", 
       RowBox[{"-", "0.5694684049562816`"}], ",", "0.7647714499029803`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6728244617186347`"}], ",", 
       RowBox[{"-", "0.44131298491113957`"}], ",", 
       RowBox[{"-", "0.5937592888215307`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{491, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->308179274]
}, Open  ]],

Cell["Show the principal axes of the ellipsoid:", "ExampleText",
 CellID->89702672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"cp", ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.015", "]"}], ",", "Green", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{
            RowBox[{"vecs", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"10", "/", 
              RowBox[{"vals", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}]}], "}"}], "]"}], ",",
         
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->648283516],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->81444130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24381150],

Cell["The Lorenz equations:", "ExampleText",
 CellID->171555756],

Cell[BoxData[
 RowBox[{
  RowBox[{"leqn", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "3"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "-", 
         RowBox[{"y", "[", "t", "]"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"x", "[", "t", "]"}]}], " ", 
        RowBox[{"z", "[", "t", "]"}]}], "+", 
       RowBox[{"26", " ", 
        RowBox[{"x", "[", "t", "]"}]}], "-", 
       RowBox[{"y", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["z", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], " ", 
        RowBox[{"y", "[", "t", "]"}]}], "-", 
       RowBox[{"z", "[", "t", "]"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64344237],

Cell["Find the Jacobian for the right-hand side of the equations:", \
"ExampleText",
 CellID->486142803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lj", "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"leqn", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}], ",", 
       RowBox[{"z", "[", "t", "]"}]}], "}"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->171156990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"26", "-", 
      RowBox[{"z", "[", "t", "]"}]}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", 
      RowBox[{"x", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], ",", 
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->331903225]
}, Open  ]],

Cell["Find the equilibrium points:", "ExampleText",
 CellID->423201667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqp", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"leqn", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"z", "'"}], "[", "t", "]"}], "\[Rule]", "0"}]}], "}"}]}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}], ",", 
      RowBox[{"z", "[", "t", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5131212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"z", "[", "t", "]"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"z", "[", "t", "]"}], "\[Rule]", "25"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
      RowBox[{"-", "5"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
      RowBox[{"-", "5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"z", "[", "t", "]"}], "\[Rule]", "25"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "\[Rule]", "5"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "\[Rule]", "5"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{438, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->276175820]
}, Open  ]],

Cell["\<\
Find the eigenvalues and eigenvectors of the Jacobian at one in the first \
octant:\
\>", "ExampleText",
 CellID->671404661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
  RowBox[{"Eigensystem", "[", 
   RowBox[{"N", "[", 
    RowBox[{"lj", "/.", 
     RowBox[{"eqp", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->40632883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.04552181409522421`", "\[InvisibleSpace]", "+", 
      RowBox[{"5.427838874508694`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.04552181409522421`", "\[InvisibleSpace]", "-", 
      RowBox[{"5.427838874508694`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"-", "5.091043628190452`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.2369660928611786`"}], "-", 
        RowBox[{"0.17972835885449412`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.08461705601081296`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.6111934694250799`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.7285789487912578`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.2369660928611786`"}], "+", 
        RowBox[{"0.17972835885449412`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.08461705601081296`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.6111934694250799`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.7285789487912578`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.784958890254864`"}], ",", "0.5471277619529602`", ",", 
       "0.2906729308177791`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{449, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->374764211]
}, Open  ]],

Cell[TextData[{
 "A function that integrates backward from a small perturbation of ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " in the direction ",
 Cell[BoxData[
  StyleBox["dir", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->385504810],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"st", "[", 
    RowBox[{"pt_", ",", "dir_"}], "]"}], ":=", 
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}], ",", 
       RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"leqn", ",", 
         RowBox[{"Thread", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"x", "[", "0", "]"}], ",", 
             RowBox[{"y", "[", "0", "]"}], ",", 
             RowBox[{"z", "[", "0", "]"}]}], "}"}], "\[Equal]", 
           RowBox[{"pt", "+", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "6"}]], "dir"}]}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"-", "4"}]}], "}"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->167073990],

Cell["\<\
Show the stable curve for the equilibrium point on the right:\
\>", "ExampleText",
 CellID->541827460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"pt", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}], ",", 
      RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", 
    RowBox[{"eqp", "[", 
     RowBox[{"[", "3", "]"}], "]"}]}]}], ";", 
  RowBox[{"dir", "=", 
   RowBox[{"vecs", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], ";", 
  RowBox[{"sr", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"st", "[", 
         RowBox[{"pt", ",", "dir"}], "]"}], ",", 
        RowBox[{"st", "[", 
         RowBox[{"pt", ",", 
          RowBox[{"-", "dir"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.015", "]"}], ",", "Red"}], "}"}], ",", 
        
        RowBox[{"{", "2", "}"}]}], "]"}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->639371031],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->156959514]
}, Open  ]],

Cell["Find the stable curve for the equilibrium point on the left:", \
"ExampleText",
 CellID->617000636],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pt", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}], ",", 
      RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", 
    RowBox[{"eqp", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{"N", "[", 
     RowBox[{"lj", "/.", 
      RowBox[{"eqp", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dir", "=", 
   RowBox[{"vecs", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], ";", 
  RowBox[{"sl", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"st", "[", 
         RowBox[{"pt", ",", "dir"}], "]"}], ",", 
        RowBox[{"st", "[", 
         RowBox[{"pt", ",", 
          RowBox[{"-", "dir"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.015", "]"}], ",", "Green"}], "}"}], 
        ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->41437070],

Cell["\<\
Show the stable curves along with a solution of the Lorenz equations:\
\>", "ExampleText",
 CellID->220488064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "[", "t", "]"}], ",", 
           RowBox[{"y", "[", "t", "]"}], ",", 
           RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", 
         RowBox[{"NDSolve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"leqn", ",", 
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "\[Equal]", "5"}], ",", 
             RowBox[{
              RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
             RowBox[{
              RowBox[{"z", "[", "0", "]"}], "\[Equal]", "25"}]}], "}"}], ",", 
           
           RowBox[{"{", 
            RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]}], "]"}], ",",
        
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}], ",", "sr", ",", 
     "sl"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "50"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->91411391],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->67304978]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20643],

Cell["Any square matrix satisfies its similarity relation: ", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->36659086],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", "m", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->227695294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"m", ".", 
    RowBox[{"Transpose", "[", "vecs", "]"}]}], "-", 
   RowBox[{
    RowBox[{"Transpose", "[", "vecs", "]"}], ".", 
    RowBox[{"DiagonalMatrix", "[", "vals", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20067965],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20847221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4610519],

Cell["\<\
Any pair of square matrices satisfies the generalized similarity relation:\
\>", "ExampleText",
 CellID->136450724],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "9"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gvals", ",", "gvecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{"N", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "a"}], "}"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->4297730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", ".", 
   RowBox[{"Transpose", "[", "gvecs", "]"}]}], "-", 
  RowBox[{"a", ".", 
   RowBox[{"Transpose", "[", "gvecs", "]"}], ".", 
   RowBox[{"DiagonalMatrix", "[", "gvals", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59117530],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1102230246251565`*^-15"}], ",", 
     RowBox[{"-", "5.551115123125783`*^-17"}], ",", 
     RowBox[{"-", "1.3322676295501878`*^-15"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1.6653345369377348`*^-16"}], ",", 
     RowBox[{"-", "8.881784197001252`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "2.220446049250313`*^-16"}], ",", 
     RowBox[{"-", "4.440892098500626`*^-16"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{520, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104235473]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->91481508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->601315847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234134221],

Cell["The eigensystem for a circulant matrix:", "ExampleText",
 CellID->509613816],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", 
        RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", " ", "vecs"}], "}"}], " ", "=", " ", 
   RowBox[{"Eigensystem", "[", "m", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->159142197],

Cell["Compute the matrix exponential using diagonalization:", "ExampleText",
 CellID->24594089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "vecs", "]"}], ".", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"Exp", "[", "vals", "]"}], "]"}], ".", 
   RowBox[{"Inverse", "[", 
    RowBox[{"Transpose", "[", "vecs", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->839401126],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.2919265817264293`", ",", "0.45464871341284113`", ",", 
     "0.7080734182735706`", ",", 
     RowBox[{"-", "0.4546487134128412`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.454648713412841`"}], ",", "0.29192658172642927`", ",", 
     "0.4546487134128407`", ",", "0.708073418273571`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7080734182735708`", ",", 
     RowBox[{"-", "0.45464871341284124`"}], ",", "0.2919265817264293`", ",", 
     "0.4546487134128412`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.454648713412841`", ",", "0.7080734182735708`", ",", 
     RowBox[{"-", "0.4546487134128407`"}], ",", "0.29192658172642916`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{298, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139404139]
}, Open  ]],

Cell[TextData[{
 "Compute the matrix exponential using ",
 Cell[BoxData[
  ButtonBox["MatrixExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixExp"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->474723371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixExp", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->664216443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.2919265817264288`", ",", "0.4546487134128408`", ",", 
     "0.7080734182735712`", ",", 
     RowBox[{"-", "0.4546487134128408`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.45464871341284085`"}], ",", "0.29192658172642877`", ",", 
     "0.45464871341284085`", ",", "0.7080734182735712`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7080734182735712`", ",", 
     RowBox[{"-", "0.45464871341284085`"}], ",", "0.2919265817264289`", ",", 
     "0.45464871341284097`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.45464871341284085`", ",", "0.7080734182735712`", ",", 
     RowBox[{"-", "0.45464871341284085`"}], ",", "0.29192658172642877`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{298, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->136187672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->413857390],

Cell["\<\
The eigenvalues and eigenvectors of a random symmetric matrix:\
\>", "ExampleText",
 CellID->90766393],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{"Transpose", "[", "r", "]"}], ".", "r"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", " ", "vecs"}], "}"}], " ", "=", " ", 
   RowBox[{"Eigensystem", "[", "r", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->35945969],

Cell["The eigenvectors are all real:", "ExampleText",
 CellID->537319792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "vals", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->188727109],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWOtLFUEUH9378JZSgmbvIpDsRVFBBJW9NCwsip6S0e1lRmWZEUURQRFB
EYhRaU9RIfrQhyL/gCDqU1/73D+ynZmzO3Nm9uy616y8cGd3Z8/5nd/5zTlz
925rsefs6QvFns6TxYU7uouXznaevLKwuasbprwyIcQn+PbMFHDuw5n6fvJ9
ONJxMYwZuFUOx3I4zpazcsIPP3J2VnD0guNM57oOjh5B8chRiAY5ZhFTj8pW
eDqSwiCRGYtaOeSoBW9Xk9KuNjFiyFFKWSaPam5JKpbSQGR17ACtbhLwX8pY
RDDd+1aMtFnUBjUQgzDBvGckRvPYOzP+os6LU2LH85Y9FnaNnvyntdLg293M
7w2zSQZxe4O7J5i9IbojVTnMh9jZB+p6eOhH48bnnR0fRDkcRQ7O4IhTOKr5
iug8jI8efskp7CkwjgB0ho2U/cvXmX8cj70O6ozRE27AacuOVzBu3tiv5ufA
Cc7DiRkb+5/0fYX59qPv4OTE8fd40nXxY9w8TMI4+vmnyLHaz3OuNzjX1UpA
ZE3W29N0MY/pmu/2LQNIR7NwaCKdWSybTqWU1ogqlcGIRKNCXCiZbb3Gl51w
JiYLLS7GyAMig7WC5VqMcAWGiFOgy0UpSrQ1LFo7z7ACkSgv1G89i9JmowAh
rDKHD/hvYv0P+6bndTa5aPQtlrr7iZepbFwv7QtezWzM3fFrHvDWVQUYLSxG
qxwqdd7RntEcdrH+O+UwlermLF/QQ3usvFs4tTxNFXWJxGri1MpQnQ6yflvl
UHA5hjnKeEdYv80cy6zunYBrG+vbKIe8jklJimOWFmrfqHC6QVMrsujr+JrP
6poPuJ1Q3sGPR/AJfwvdvVZhFg4dGLEqgRS+OKVgok8D7u+5e73W1v/a1VGn
KUTHOJFXs3XUtO1FcP9cCbjyUuHlUAO6ZOfHyW+VbzoU0g6y7Ron2kp71SHN
y+jomfUNn2Dc1V1u1yMtMXHZqsdlrKamprrZimwgVRzdv3pYH3wOpT2CIa6x
1vXEmtK/Hm+d1SsZcL9hZVpP9Ny3dwgMbrJYi8gqYmSQXtxKsHXj8rYL7Px1
gdy2WM4fo8Zvs9hz7fW29p878R4ZZI7K3mXt6ggfvQt7prrvsV61EQ31swPJ
xfjKzJVPwakP64ngPhurJpLJQ2VH3yW4/VEdsxaPsLXwEdB6STBWt1YTFlgy
j/3SdqNphJPeNIET4njES6TgU8VWce8fYLlV3htoRXNLp1Wl73Zin592Z1O+
HnKRGT2xaghr4/u3XwFHc5diTCE1DX+9xNMEKxOJtypEcnlqMXJRnrEoebJa
prcSbAliP2uVi/BKsCNoAxb7vKPnAIuRcfR8mWBlIvFW5awSLy1WnoP02iBV
aCQ//A+J2aON51ZWntobxDd+6j6xEIxSJSBY/3ilfoO+2w3RXUSq6alGQcpy
9q2ffscJoxrGg+kZR96JRHRl35rIu8PsqvNvVsY3O9FRJgdrZ1UTtS79WRP9
+HfFYaWhTfIbWfcNUujjj1HJE+NTikb/o1JE2W9n1ZJ8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5622087]
}, Open  ]],

Cell["\<\
The numerical eigenvectors are orthonormal to the precision of the \
computation:\
\>", "ExampleText",
 CellID->121893728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"vecs", ".", 
     RowBox[{"Transpose", "[", "vecs", "]"}]}], "-", 
    RowBox[{"IdentityMatrix", "[", "100", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->94613636],

Cell[BoxData["1.1102230246251565`*^-15"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->358246648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49756837],

Cell["Not all matrices have a complete set of eigenvectors: ", "ExampleText",
 CellID->93094542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44620184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565728276]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["JordanDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JordanDecomposition"]], "InlineFormula"],
 " for exact computation:"
}], "ExampleText",
 CellID->323595469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JordanDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17223237],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["1", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{241, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399849489]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SchurDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFormula"],
 " for numeric computation:"
}], "ExampleText",
 CellID->52324221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"N", "@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->205066831],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.31622776601683794`", ",", 
       RowBox[{"-", "0.9486832980505138`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9486832980505138`", ",", "0.31622776601683794`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.9999999999999996`", ",", 
       RowBox[{"-", "10.`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.9999999999999996`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11916019]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15522],

Cell["\<\
The general symbolic case very quickly gets very complicated:\
\>", "ExampleText",
 CellID->28504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Subscript", "[", 
     RowBox[{"a", ",", "##"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"1", ",", "1"}]], ",", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "2"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"2", ",", "1"}]], ",", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "2"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9357474]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25793],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{368, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146795963]
}, Open  ]],

Cell["The expression sizes increase faster than exponentially:", "ExampleText",
 CellID->31767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ByteCount", "[", 
    RowBox[{"Eigensystem", "[", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Subscript", "[", 
         RowBox[{"a", ",", "##"}], "]"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "n"}], "}"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"184", ",", "4480", ",", "66168", ",", "1767664"}], "}"}]], "Output",\

 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->762267061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->634623786],

Cell["\<\
Construct a 10,000\[Times]10,000 sparse matrix:\
\>", "ExampleText",
 CellID->136272409],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"10", "^", "4"}]}], ";", 
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"n", "/", "2"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"n", "/", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "\[Rule]", "1."}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416323974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"s", ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "1000"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "\[Equal]", "0"}], ",", "White", ",", "Black"}], "]"}], 
      "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148930334],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVmtdu21gURWXJvddxt+QaO4l7L7Hk3rsz82wEAZKHYAaZ/NYAecj/cSTr
nBG9uEljAtjxJu/StlXIexd59fTjy+dvTz++fnrKnXx/+uvL109/547//F7c
lKlKpVK/Sl99qeLPQfGn8lcmCEo/lP79LH5VlWOmtO/5X+pn8VtVecD/2Vrz
31Yr+Fj6PzT2Adm46jCXLoZHjLsvfXsxKvp7pI1lxx1yWtIZo+8x+hY5I+lq
o9l1g1wt6Rqj2XVl2+skVWt72XGFXCvpOqOvMfoSWXfXG82uC+R6STcYza5z
5AZJNxrNrlPb3iypJtvLjlPkJkk3G32G0SfIurvFaHYdI7dIutVodh0ht0q6
zWh2HSK3SbrdaHbt2/ZOSXXYXnbsI3dIutPoA4zeQ9bdXUazq4DcJeluo9mV
R+6WdI/R7NpF7pH0b0aza8e290mq1/ayYwe5V9J9Rn/A6G1k3d1vNLu2kPsl
PWA0uzaRByQ9aDS7NpAHJT1kNLvWkYckPWw0u9aQhyU9YjS7VpFHJJ01ml0r
yFlJ54xm1zJyTtKjRrNr0baPS2rM9rJjEXlM0uNGL2H0ArLunjCaXfPIE5Ke
NJpdc8iTkp4yml2zyFOSfmM0u97Z9hlJTdtedrxDnpb0jNHvMfotsu5+azS7
ZsSjRWn/u9g1Lf6SKP0+9KzwWeS4KD1rNLv89Z+X1JztZcck8pyk542ewugJ
ZN29YDS7xpEXJO2fV3aNIS9KeimofNrVsWVFUsu2lx055GVJrxg9itFZZN29
ajS7RpBXJb1mNLuGkdckvW40u4aQ1yW9YTS7/Ny5JalN28uOAeRNSW8ZPYjR
/ci6e9todvUhb0va5zrs6kXekfSHoDJT4syK46L0rtHs8jlhQVJ528uObuS8
pAtG92B0F7Lu3jOaXZ3Ie5L2OTy7OpD3JX0QVFYA4e3tyAeSPjSaXb7WOZbU
ke1lRyvykaSPjW7D6BZk3X1iNLuakU8k7WtTdjUhn0r6LKisbMPbfR19Ialz
28uOBuRzSV8Y3YjR9ci6+9JodtUhX0ravQe7apGvJH0dVKxJeHsN8rWkb4xm
l/uhO0nd2l52ZJBvJX1ndDVGp5F1973Rz10RA/comQdjnhsqXi1VNnbR8Y82
vvwrPm8ufv9dji09Qukh/6jsfWHu/rHeKFl6vMxLEo/rubQrHfsbPL58JgxJ
x/51D/KZc5+on8EXr1nEXz7EMknvDm+8lzTtIN8tye9QWkK+U91g6ncoLSE/
HW4wbyQddzRwg6k/ibSDPBq4wdRHAdpBdrvB1EcgWkIeBZOPvLSEPAK7wdRH
XlpCHvXdZJ5JOu4s5wZTn2FoB3mWc4Opz260g+xOPqvTEvLs7gZTn9VpCTmj
cIN5KGlaQs5m3GTqWUzc7M0Npp45FTCaszc3mHrWlsdodifPVmkJOWt1g5mX
NC0hZ8puMHclTUvIWbqbTD07j1uVuMHUKwLaQa5K3GDq1QjtILuTV2G0g1yN
ucHUqzDaQa4A3WBuSDpuxevmUq82aQWzyG4u9UqXVpDd2aDiHrUfCGeu9HNB
kl2gHaRlcHOp7QLtIM2GG8wlSceZHDeX2qLQCtLkuLnUBodWkN3J5op2kAbL
zaU2V7SDtGZuLmcl/ZoddIOpTV2cofTt2g6yg7+Dm0ttJvn3sTvZyPK55XPv
5lIbWb6ufN3dXL6RNN9TfM+5wdQGOs68+/tdW29+dvjZcnOpjTs/t+xOvtLA
YwaPKW4u9ZUGHq94PHODOSrpuKs6bi5zsVQ486qOH8ezkuY5gd1uLvWVJJ6P
eL5yc6mvYvFcyHOlm0t9BY3nYZ6n3WDqq3dxVy19jqCvGHK+wfmIm0t9tZJz
HXYnX6XlPIvzMDeX+iot53h58WjuIKM055cF8Wg+i43ScVfjC0HFPWoqnDnP
dnOpr8JzDs/u5LsPuH7g+sLNpb77gGsXrm3cXLZLmusmrqvcYOq7LeLuMvE1
nb7Dg+tDrh/dXOq7S7g2ZXfyXTVcF3Pd7OZS31XDNTnX7G4wGyUddweTm0t9
9xCtIO9gcleh71yi92B38h1bdC50Mm4u9R1b9D30QW4uayRN10QX5QYzdIfa
q3fluQML3RP36h2Abiu1AXztDsNf5X1V/wKLANQT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261989087]
}, Open  ]],

Cell["\<\
The eigenvector matrix is a dense matrix and too large to represent:\
\>", "ExampleText",
 CellID->67798946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryConstrained", "[", 
  RowBox[{
   RowBox[{"Eigensystem", "[", "s", "]"}], ",", 
   RowBox[{"10", "^", "8"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->180818944],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "::", "\<\"arh\"\>"}], ":", 
  " ", "\<\"Because finding \\!\\(10000\\) out of the \\!\\(10000\\) \
eigenvalues and/or eigenvectors is likely to be faster with dense matrix \
methods, the sparse input matrix will be converted.  If fewer eigenvalues \
and/or eigenvectors would be sufficient, consider restricting this number \
using the second argument to \\!\\(Eigensystem\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, \
ButtonData:>{\\\"System`\\\", \\\"Eigensystem\\\", \\\"arh\\\"}, ButtonNote \
-> \\\"Eigensystem::arh\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->50223430],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->240920472]
}, Open  ]],

Cell["\<\
Computing the few largest or smallest eigenvalues is usually possible:\
\>", "ExampleText",
 CellID->72873068],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{"s", ",", "2"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->413575801],

Cell[CellGroupData[{

Cell[BoxData["vals"], "Input",
 CellLabel->"In[5]:=",
 CellID->716054819],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"101.49620017468173`", ",", 
   RowBox[{"-", "98.49630018468173`"}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->273269372]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205389136],

Cell["\<\
When eigenvalues are closely grouped the iterative method for sparse matrices \
may not converge:\
\>", "ExampleText",
 CellID->513524535],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
       
       RowBox[{
        RowBox[{"3.", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}]}], "-", "2."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45667536],

Cell["The iteration has not converged well after 1000 iterations:", \
"ExampleText",
 CellID->42463185],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{"s", ",", "3"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"vecs", ",", 
   RowBox[{"PlotLabel", "\[Rule]", "vals"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->780940825],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigensystem", "::", "\<\"maxit2\"\>"}], ":", 
  " ", "\<\"Maximum number of iterations, \\!\\(1000\\), has been reached by \
the Arnoldi algorithm without convergence to the specified tolerance, but the \
current best computed value has been returned.  You can use method options \
with Method -> {Arnoldi, opts} to increase the basis size or the maximum \
number of iterations, reduce the tolerance, or use an estimate as a shift, \
any of which may help. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"Eigensystem\\\", \\\"maxit2\\\"}, ButtonNote -> \
\\\"Eigensystem::maxit2\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->105442843],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->418980755]
}, Open  ]],

Cell["\<\
You can give the algorithm a shift near the expected value to speed up \
convergence:\
\>", "ExampleText",
 CellID->41000637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{"s", ",", "3", ",", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Arnoldi\>\"", ",", 
        RowBox[{"Shift", "\[Rule]", 
         RowBox[{"-", "4"}]}]}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"ListPlot", "[", 
   RowBox[{"vecs", ",", 
    RowBox[{"PlotLabel", "\[Rule]", "vals"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->958108319],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->867389136]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7395],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvectors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvectors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JordanDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JordanDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27697],

Cell[TextData[ButtonBox["Eigenvalues and Eigenvectors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EigenvaluesAndEigenvectors"]], "Tutorials",
 CellID->7186]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->50263727],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->159265045],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->878745262]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eigensystem - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 40.8852210}", "context" -> "System`", 
    "keywords" -> {
     "eigen decomposition", "eigen system", "EISPACK", 
      "generalized eigen decomposition", "generalized eigen system", 
      "generalized similarity transformation", "LAPACK", 
      "linear matrix pencils", "similarity transformation"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Eigensystem[m] gives a list {values, vectors} of the eigenvalues and \
eigenvectors of the square matrix m. Eigensystem[{m, a}] gives the \
generalized eigenvalues and eigenvectors of m with respect to a. \
Eigensystem[m, k] gives the eigenvalues and eigenvectors for the first k \
eigenvalues of m. Eigensystem[{m, a}, k] gives the first k generalized \
eigenvalues and eigenvectors.", "synonyms" -> {}, "title" -> "Eigensystem", 
    "type" -> "Symbol", "uri" -> "ref/Eigensystem"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11974, 402, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->43518051]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 332177, 8100}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2720, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3343, 89, 49, 1, 70, "ObjectName",
 CellID->14474],
Cell[3395, 92, 2428, 77, 70, "Usage",
 CellID->80]
}, Open  ]],
Cell[CellGroupData[{
Cell[5860, 174, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6338, 191, 331, 10, 70, "Notes",
 CellID->18480],
Cell[6672, 203, 306, 6, 70, "Notes",
 CellID->23976],
Cell[6981, 211, 286, 8, 70, "Notes",
 CellID->13801],
Cell[7270, 221, 790, 28, 70, "Notes",
 CellID->857],
Cell[8063, 251, 799, 27, 70, "Notes",
 CellID->30693],
Cell[8865, 280, 682, 23, 70, "Notes",
 CellID->9564],
Cell[9550, 305, 587, 21, 70, "Notes",
 CellID->22169],
Cell[10140, 328, 728, 27, 70, "Notes",
 CellID->17708],
Cell[10871, 357, 620, 22, 70, "Notes",
 CellID->9477],
Cell[11494, 381, 443, 16, 70, "Notes",
 CellID->11122]
}, Closed]],
Cell[CellGroupData[{
Cell[11974, 402, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43518051],
Cell[CellGroupData[{
Cell[12358, 416, 148, 5, 70, "ExampleSection",
 CellID->606821195],
Cell[12509, 423, 81, 1, 70, "ExampleText",
 CellID->253445758],
Cell[CellGroupData[{
Cell[12615, 428, 252, 9, 28, "Input",
 CellID->18414],
Cell[12870, 439, 1815, 58, 94, "Output",
 CellID->157811714]
}, Open  ]],
Cell[14700, 500, 121, 3, 70, "ExampleDelimiter",
 CellID->20394],
Cell[14824, 505, 74, 1, 70, "ExampleText",
 CellID->29909],
Cell[CellGroupData[{
Cell[14923, 510, 343, 11, 70, "Input",
 CellID->19755],
Cell[15269, 523, 1869, 66, 111, "Output",
 CellID->932519]
}, Open  ]],
Cell[17153, 592, 59, 1, 70, "ExampleText",
 CellID->765710881],
Cell[CellGroupData[{
Cell[17237, 597, 97, 3, 70, "Input",
 CellID->109149043],
Cell[17337, 602, 730, 23, 54, "Output",
 CellID->227588412]
}, Open  ]],
Cell[18082, 628, 125, 3, 70, "ExampleDelimiter",
 CellID->427536199],
Cell[18210, 633, 112, 3, 70, "ExampleText",
 CellID->720213348],
Cell[CellGroupData[{
Cell[18347, 640, 386, 13, 70, "Input",
 CellID->626881757],
Cell[18736, 655, 925, 27, 58, "Output",
 CellID->656894085]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19710, 688, 216, 7, 70, "ExampleSection",
 CellID->12387],
Cell[19929, 697, 138, 4, 70, "ExampleText",
 CellID->45209607],
Cell[CellGroupData[{
Cell[20092, 705, 418, 14, 70, "Input",
 CellID->30593621],
Cell[20513, 721, 1210, 29, 92, "Output",
 CellID->60887428]
}, Open  ]],
Cell[21738, 753, 125, 3, 70, "ExampleDelimiter",
 CellID->761909638],
Cell[21866, 758, 296, 10, 70, "ExampleText",
 CellID->7058344],
Cell[22165, 770, 501, 17, 70, "Input",
 CellID->175797764],
Cell[CellGroupData[{
Cell[22691, 791, 70, 2, 70, "Input",
 CellID->120700],
Cell[22764, 795, 310, 9, 39, "Output",
 CellID->299636642]
}, Open  ]],
Cell[CellGroupData[{
Cell[23111, 809, 72, 2, 70, "Input",
 CellID->29553805],
Cell[23186, 813, 689, 21, 54, "Output",
 CellID->272027045]
}, Open  ]],
Cell[23890, 837, 120, 3, 70, "ExampleDelimiter",
 CellID->6181],
Cell[24013, 842, 81, 1, 70, "ExampleText",
 CellID->18540],
Cell[CellGroupData[{
Cell[24119, 847, 445, 15, 70, "Input",
 CellID->8724],
Cell[24567, 864, 1272, 33, 92, "Output",
 CellID->148900621]
}, Open  ]],
Cell[25854, 900, 121, 3, 70, "ExampleDelimiter",
 CellID->17349],
Cell[25978, 905, 134, 4, 70, "ExampleText",
 CellID->30461],
Cell[CellGroupData[{
Cell[26137, 913, 343, 11, 70, "Input",
 CellID->23627],
Cell[26483, 926, 510, 17, 36, "Output",
 CellID->38407845]
}, Open  ]],
Cell[27008, 946, 125, 3, 70, "ExampleDelimiter",
 CellID->302102435],
Cell[27136, 951, 185, 5, 70, "ExampleText",
 CellID->133667995],
Cell[CellGroupData[{
Cell[27346, 960, 347, 11, 70, "Input",
 CellID->299491235],
Cell[27696, 973, 511, 17, 36, "Output",
 CellID->188499079]
}, Open  ]],
Cell[28222, 993, 124, 3, 70, "ExampleDelimiter",
 CellID->60367306],
Cell[28349, 998, 91, 1, 70, "ExampleText",
 CellID->39774976],
Cell[CellGroupData[{
Cell[28465, 1003, 578, 21, 70, "Input",
 CellID->20482314],
Cell[29046, 1026, 1186, 32, 71, "Output",
 CellID->513626169]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30281, 1064, 239, 7, 70, "ExampleSection",
 CellID->32315],
Cell[CellGroupData[{
Cell[30545, 1075, 233, 7, 70, "ExampleSubsection",
 CellID->71472088],
Cell[30781, 1084, 115, 2, 70, "ExampleText",
 CellID->110528527],
Cell[CellGroupData[{
Cell[30921, 1090, 795, 27, 70, "Input",
 CellID->11740],
Cell[31719, 1119, 782, 17, 70, "Output",
 Evaluatable->False,
 CellID->163836414]
}, Open  ]],
Cell[32516, 1139, 75, 1, 70, "ExampleText",
 CellID->49707881],
Cell[CellGroupData[{
Cell[32616, 1144, 106, 3, 70, "Input",
 CellID->68154384],
Cell[32725, 1149, 725, 24, 36, "Output",
 CellID->203531973]
}, Open  ]],
Cell[33465, 1176, 125, 3, 70, "ExampleDelimiter",
 CellID->239691314],
Cell[33593, 1181, 64, 1, 70, "ExampleText",
 CellID->135652336],
Cell[33660, 1184, 618, 21, 70, "Input",
 CellID->317140975],
Cell[34281, 1207, 142, 4, 70, "ExampleText",
 CellID->44080672],
Cell[CellGroupData[{
Cell[34448, 1215, 356, 11, 70, "Input",
 CellID->206745217],
Cell[34807, 1228, 7459, 126, 70, "Output",
 Evaluatable->False,
 CellID->362963302]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[42327, 1361, 218, 7, 70, "ExampleSection",
 CellID->32236],
Cell[CellGroupData[{
Cell[42570, 1372, 222, 7, 70, "ExampleSubsection",
 CellID->3678],
Cell[42795, 1381, 74, 1, 70, "ExampleText",
 CellID->46680874],
Cell[CellGroupData[{
Cell[42894, 1386, 286, 10, 70, "Input",
 CellID->19640870],
Cell[43183, 1398, 392, 13, 36, "Output",
 CellID->177126280]
}, Open  ]],
Cell[43590, 1414, 263, 9, 70, "ExampleText",
 CellID->681590779],
Cell[CellGroupData[{
Cell[43878, 1427, 131, 4, 70, "Input",
 CellID->559251542],
Cell[44012, 1433, 5768, 99, 70, "Output",
 Evaluatable->False,
 CellID->819086650]
}, Open  ]],
Cell[49795, 1535, 246, 8, 70, "ExampleText",
 CellID->24798682],
Cell[CellGroupData[{
Cell[50066, 1547, 194, 6, 70, "Input",
 CellID->413334102],
Cell[50263, 1555, 15471, 258, 70, "Output",
 Evaluatable->False,
 CellID->209952518]
}, Open  ]],
Cell[65749, 1816, 260, 8, 70, "ExampleText",
 CellID->44452930],
Cell[CellGroupData[{
Cell[66034, 1828, 98, 3, 70, "Input",
 CellID->145090444],
Cell[66135, 1833, 776, 25, 54, "Output",
 CellID->722225675]
}, Open  ]],
Cell[CellGroupData[{
Cell[66948, 1863, 98, 3, 70, "Input",
 CellID->524587683],
Cell[67049, 1868, 1715, 42, 96, "Output",
 CellID->253179353]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[68813, 1916, 224, 7, 70, "ExampleSubsection",
 CellID->9810],
Cell[69040, 1925, 63, 1, 70, "ExampleText",
 CellID->401134940],
Cell[CellGroupData[{
Cell[69128, 1930, 297, 10, 70, "Input",
 CellID->621286290],
Cell[69428, 1942, 509, 16, 36, "Output",
 CellID->224115233]
}, Open  ]],
Cell[69952, 1961, 259, 9, 70, "ExampleText",
 CellID->262792891],
Cell[CellGroupData[{
Cell[70236, 1974, 107, 3, 70, "Input",
 CellID->251204608],
Cell[70346, 1979, 19900, 330, 70, "Output",
 Evaluatable->False,
 CellID->315851092]
}, Open  ]],
Cell[90261, 2312, 368, 13, 70, "ExampleText",
 CellID->1033961],
Cell[CellGroupData[{
Cell[90654, 2329, 218, 6, 70, "Input",
 CellID->104754260],
Cell[90875, 2337, 118611, 2820, 11435, "Output",
 CellID->12749420]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[209547, 5164, 223, 7, 70, "ExampleSection",
 CellID->17382],
Cell[209773, 5173, 84, 1, 70, "ExampleText",
 CellID->199318421],
Cell[209860, 5176, 436, 14, 70, "Input",
 CellID->50769096],
Cell[210299, 5192, 170, 7, 70, "ExampleText",
 CellID->758218748],
Cell[CellGroupData[{
Cell[210494, 5203, 676, 20, 70, "Input",
 CellID->322405202],
Cell[211173, 5225, 21343, 354, 70, "Output",
 Evaluatable->False,
 CellID->305305611]
}, Open  ]],
Cell[232531, 5582, 256, 8, 70, "ExampleText",
 CellID->399678127],
Cell[CellGroupData[{
Cell[232812, 5594, 369, 11, 70, "Input",
 CellID->11987759],
Cell[233184, 5607, 520, 19, 36, "Output",
 CellID->250290074]
}, Open  ]],
Cell[233719, 5629, 95, 1, 70, "ExampleText",
 CellID->25918659],
Cell[CellGroupData[{
Cell[233839, 5634, 211, 7, 70, "Input",
 CellID->41520492],
Cell[234053, 5643, 908, 28, 54, "Output",
 CellID->308179274]
}, Open  ]],
Cell[234976, 5674, 83, 1, 70, "ExampleText",
 CellID->89702672],
Cell[CellGroupData[{
Cell[235084, 5679, 851, 26, 70, "Input",
 CellID->648283516],
Cell[235938, 5707, 21891, 363, 70, "Output",
 Evaluatable->False,
 CellID->81444130]
}, Open  ]],
Cell[257844, 6073, 124, 3, 70, "ExampleDelimiter",
 CellID->24381150],
Cell[257971, 6078, 64, 1, 70, "ExampleText",
 CellID->171555756],
Cell[258038, 6081, 1155, 37, 70, "Input",
 CellID->64344237],
Cell[259196, 6120, 104, 2, 70, "ExampleText",
 CellID->486142803],
Cell[CellGroupData[{
Cell[259325, 6126, 420, 14, 70, "Input",
 CellID->171156990],
Cell[259748, 6142, 628, 22, 36, "Output",
 CellID->331903225]
}, Open  ]],
Cell[260391, 6167, 71, 1, 70, "ExampleText",
 CellID->423201667],
Cell[CellGroupData[{
Cell[260487, 6172, 681, 23, 70, "Input",
 CellID->5131212],
Cell[261171, 6197, 1016, 34, 54, "Output",
 CellID->276175820]
}, Open  ]],
Cell[262202, 6234, 134, 4, 70, "ExampleText",
 CellID->671404661],
Cell[CellGroupData[{
Cell[262361, 6242, 298, 10, 70, "Input",
 CellID->40632883],
Cell[262662, 6254, 1617, 40, 88, "Output",
 CellID->374764211]
}, Open  ]],
Cell[264294, 6297, 269, 9, 70, "ExampleText",
 CellID->385504810],
Cell[264566, 6308, 1084, 33, 70, "Input",
 CellID->167073990],
Cell[265653, 6343, 112, 3, 70, "ExampleText",
 CellID->541827460],
Cell[CellGroupData[{
Cell[265790, 6350, 1143, 37, 70, "Input",
 CellID->639371031],
Cell[266936, 6389, 2783, 50, 70, "Output",
 Evaluatable->False,
 CellID->156959514]
}, Open  ]],
Cell[269734, 6442, 105, 2, 70, "ExampleText",
 CellID->617000636],
Cell[269842, 6446, 1416, 46, 70, "Input",
 CellID->41437070],
Cell[271261, 6494, 120, 3, 70, "ExampleText",
 CellID->220488064],
Cell[CellGroupData[{
Cell[271406, 6501, 1486, 45, 70, "Input",
 CellID->91411391],
Cell[272895, 6548, 4831, 83, 70, "Output",
 Evaluatable->False,
 CellID->67304978]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[277775, 6637, 233, 7, 70, "ExampleSection",
 CellID->20643],
Cell[278011, 6646, 143, 2, 70, "ExampleText",
 CellID->36659086],
Cell[278157, 6650, 525, 18, 70, "Input",
 CellID->227695294],
Cell[CellGroupData[{
Cell[278707, 6672, 302, 9, 70, "Input",
 CellID->20067965],
Cell[279012, 6683, 390, 13, 36, "Output",
 CellID->20847221]
}, Open  ]],
Cell[279417, 6699, 123, 3, 70, "ExampleDelimiter",
 CellID->4610519],
Cell[279543, 6704, 125, 3, 70, "ExampleText",
 CellID->136450724],
Cell[279671, 6709, 927, 32, 70, "Input",
 CellID->4297730],
Cell[CellGroupData[{
Cell[280623, 6745, 275, 8, 70, "Input",
 CellID->59117530],
Cell[280901, 6755, 699, 20, 58, "Output",
 CellID->104235473]
}, Open  ]],
Cell[CellGroupData[{
Cell[281637, 6780, 99, 3, 70, "Input",
 CellID->91481508],
Cell[281739, 6785, 391, 13, 36, "Output",
 CellID->601315847]
}, Open  ]],
Cell[282145, 6801, 125, 3, 70, "ExampleDelimiter",
 CellID->234134221],
Cell[282273, 6806, 82, 1, 70, "ExampleText",
 CellID->509613816],
Cell[282358, 6809, 788, 25, 70, "Input",
 CellID->159142197],
Cell[283149, 6836, 95, 1, 70, "ExampleText",
 CellID->24594089],
Cell[CellGroupData[{
Cell[283269, 6841, 326, 9, 70, "Input",
 CellID->839401126],
Cell[283598, 6852, 901, 24, 88, "Output",
 CellID->139404139]
}, Open  ]],
Cell[284514, 6879, 222, 8, 70, "ExampleText",
 CellID->474723371],
Cell[CellGroupData[{
Cell[284761, 6891, 105, 3, 70, "Input",
 CellID->664216443],
Cell[284869, 6896, 908, 24, 88, "Output",
 CellID->136187672]
}, Open  ]],
Cell[285792, 6923, 125, 3, 70, "ExampleDelimiter",
 CellID->413857390],
Cell[285920, 6928, 112, 3, 70, "ExampleText",
 CellID->90766393],
Cell[286035, 6933, 544, 19, 70, "Input",
 CellID->35945969],
Cell[286582, 6954, 73, 1, 70, "ExampleText",
 CellID->537319792],
Cell[CellGroupData[{
Cell[286680, 6959, 107, 3, 70, "Input",
 CellID->188727109],
Cell[286790, 6964, 1780, 33, 70, "Output",
 Evaluatable->False,
 CellID->5622087]
}, Open  ]],
Cell[288585, 7000, 132, 4, 70, "ExampleText",
 CellID->121893728],
Cell[CellGroupData[{
Cell[288742, 7008, 267, 8, 70, "Input",
 CellID->94613636],
Cell[289012, 7018, 181, 5, 36, "Output",
 CellID->358246648]
}, Open  ]],
Cell[289208, 7026, 124, 3, 70, "ExampleDelimiter",
 CellID->49756837],
Cell[289335, 7031, 96, 1, 70, "ExampleText",
 CellID->93094542],
Cell[CellGroupData[{
Cell[289456, 7036, 277, 10, 70, "Input",
 CellID->44620184],
Cell[289736, 7048, 408, 15, 36, "Output",
 CellID->565728276]
}, Open  ]],
Cell[290159, 7066, 231, 8, 70, "ExampleText",
 CellID->323595469],
Cell[CellGroupData[{
Cell[290415, 7078, 285, 10, 70, "Input",
 CellID->17223237],
Cell[290703, 7090, 540, 20, 51, "Output",
 CellID->399849489]
}, Open  ]],
Cell[291258, 7113, 230, 8, 70, "ExampleText",
 CellID->52324221],
Cell[CellGroupData[{
Cell[291513, 7125, 315, 11, 70, "Input",
 CellID->205066831],
Cell[291831, 7138, 682, 23, 36, "Output",
 CellID->11916019]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[292562, 7167, 226, 7, 70, "ExampleSection",
 CellID->15522],
Cell[292791, 7176, 108, 3, 70, "ExampleText",
 CellID->28504],
Cell[CellGroupData[{
Cell[292924, 7183, 251, 9, 70, "Input",
 CellID->991],
Cell[293178, 7194, 508, 19, 36, "Output",
 CellID->9357474]
}, Open  ]],
Cell[CellGroupData[{
Cell[293723, 7218, 103, 3, 70, "Input",
 CellID->25793],
Cell[293829, 7223, 2600, 47, 70, "Output",
 Evaluatable->False,
 CellID->146795963]
}, Open  ]],
Cell[296444, 7273, 95, 1, 70, "ExampleText",
 CellID->31767],
Cell[CellGroupData[{
Cell[296564, 7278, 461, 15, 70, "Input",
 CellID->15347],
Cell[297028, 7295, 241, 8, 36, "Output",
 CellID->762267061]
}, Open  ]],
Cell[297284, 7306, 125, 3, 70, "ExampleDelimiter",
 CellID->634623786],
Cell[297412, 7311, 98, 3, 70, "ExampleText",
 CellID->136272409],
Cell[297513, 7316, 1607, 51, 70, "Input",
 CellID->416323974],
Cell[CellGroupData[{
Cell[299145, 7371, 393, 12, 70, "Input",
 CellID->148930334],
Cell[299541, 7385, 2388, 43, 70, "Output",
 Evaluatable->False,
 CellID->261989087]
}, Open  ]],
Cell[301944, 7431, 118, 3, 70, "ExampleText",
 CellID->67798946],
Cell[CellGroupData[{
Cell[302087, 7438, 200, 6, 70, "Input",
 CellID->180818944],
Cell[302290, 7446, 684, 11, 70, "Message",
 CellID->50223430],
Cell[302977, 7459, 165, 5, 36, "Output",
 CellID->240920472]
}, Open  ]],
Cell[303157, 7467, 120, 3, 70, "ExampleText",
 CellID->72873068],
Cell[303280, 7472, 229, 8, 70, "Input",
 CellID->413575801],
Cell[CellGroupData[{
Cell[303534, 7484, 73, 2, 70, "Input",
 CellID->716054819],
Cell[303610, 7488, 258, 8, 36, "Output",
 CellID->273269372]
}, Open  ]],
Cell[303883, 7499, 125, 3, 70, "ExampleDelimiter",
 CellID->205389136],
Cell[304011, 7504, 148, 4, 70, "ExampleText",
 CellID->513524535],
Cell[304162, 7510, 624, 21, 70, "Input",
 CellID->45667536],
Cell[304789, 7533, 103, 2, 70, "ExampleText",
 CellID->42463185],
Cell[CellGroupData[{
Cell[304917, 7539, 360, 11, 70, "Input",
 CellID->780940825],
Cell[305280, 7552, 756, 12, 70, "Message",
 CellID->105442843],
Cell[306039, 7566, 11493, 192, 70, "Output",
 Evaluatable->False,
 CellID->418980755]
}, Open  ]],
Cell[317547, 7761, 135, 4, 70, "ExampleText",
 CellID->41000637],
Cell[CellGroupData[{
Cell[317707, 7769, 518, 16, 70, "Input",
 CellID->958108319],
Cell[318228, 7787, 8988, 151, 70, "Output",
 Evaluatable->False,
 CellID->867389136]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[327277, 7945, 310, 9, 70, "SeeAlsoSection",
 CellID->7395],
Cell[327590, 7956, 1784, 62, 70, "SeeAlso",
 CellID->21897]
}, Open  ]],
Cell[CellGroupData[{
Cell[329411, 8023, 314, 9, 70, "TutorialsSection",
 CellID->27697],
Cell[329728, 8034, 164, 3, 70, "Tutorials",
 CellID->7186]
}, Open  ]],
Cell[CellGroupData[{
Cell[329929, 8042, 318, 9, 70, "MoreAboutSection",
 CellID->50263727],
Cell[330250, 8053, 153, 3, 70, "MoreAbout",
 CellID->159265045],
Cell[330406, 8058, 145, 3, 70, "MoreAbout",
 CellID->878745262]
}, Open  ]],
Cell[330566, 8064, 50, 0, 70, "History"],
Cell[330619, 8066, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

