(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64069,       2273]
NotebookOptionsPosition[     54000,       1912]
NotebookOutlinePosition[     55577,       1953]
CellTagsIndexPosition[     55491,       1948]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Eigenvalues and Eigenvectors" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EigenvaluesAndEigenvectors"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Eigenvalues and Eigenvectors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eigenvectors" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvectors"], "Eigensystem" :> 
          Documentation`HelpLookup["paclet:ref/Eigensystem"], 
          "SingularValueList" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueList"], 
          "CharacteristicPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/CharacteristicPolynomial"], 
          "Det" :> Documentation`HelpLookup["paclet:ref/Det"], "Tr" :> 
          Documentation`HelpLookup["paclet:ref/Tr"], 
          "PositiveDefiniteMatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/PositiveDefiniteMatrixQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Eigenvectors\"\>", 
       2->"\<\"Eigensystem\"\>", 3->"\<\"SingularValueList\"\>", 
       4->"\<\"CharacteristicPolynomial\"\>", 5->"\<\"Det\"\>", 
       6->"\<\"Tr\"\>", 
       7->"\<\"PositiveDefiniteMatrixQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Matrix Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eigenvalues", "ObjectName",
 CellID->9687],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigenvalues",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigenvalues"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the eigenvalues of the square matrix ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigenvalues",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigenvalues"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized eigenvalues of ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " with respect to ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigenvalues",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigenvalues"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the first ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " eigenvalues of ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigenvalues",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigenvalues"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["a", "TI"]}], "}"}], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the first ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " generalized eigenvalues."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->25420]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eigenvalues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvalues"]], "InlineFormula"],
 " finds numerical eigenvalues if ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " contains approximate real or complex numbers. "
}], "Notes",
 CellID->18595],

Cell["\<\
Repeated eigenvalues appear with their appropriate multiplicity. \
\>", "Notes",
 CellID->8684],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Times]",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " matrix gives a list of exactly ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " eigenvalues, not necessarily distinct. "
}], "Notes",
 CellID->4823],

Cell["\<\
If they are numeric, eigenvalues are sorted in order of decreasing absolute \
value. \
\>", "Notes",
 CellID->16311],

Cell[TextData[{
 "The eigenvalues of a matrix ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " are those ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "v"}], "\[LongEqual]", 
    RowBox[{"\[Lambda]", " ", "v"}]}], TraditionalForm]], "InlineMath"],
 " for some non\[Hyphen]zero eigenvector ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->6240],

Cell[TextData[{
 "The generalized eigenvalues of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " with respect to ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " are those ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "v"}], "\[LongEqual]", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"a", ".", "v"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->5623],

Cell[TextData[{
 "When matrices ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " have a dimension\[Hyphen]",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " shared null space, then ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " of their generalized eigenvalues will be ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22065],

Cell["\<\
Ordinary eigenvalues are always finite; generalized eigenvalues can be \
infinite. \
\>", "Notes",
 CellID->15219],

Cell[TextData[{
 "For numeric eigenvalues, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " gives the ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " that are largest in absolute value. "
}], "Notes",
 CellID->26379],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["k", "TI"]}]}], "]"}]], "InlineFormula"],
 " gives the ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " that are smallest in absolute value. "
}], "Notes",
 CellID->10912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 " is always equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{
    RowBox[{"Eigenvalues", "[", 
     StyleBox["m", "TI"], "]"}], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17271],

Cell[TextData[{
 "The option settings ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " can be used to specify that explicit radicals should be generated for all \
cubics and quartics. "
}], "Notes",
 CellID->27167],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects can be used in ",
 Cell[BoxData[
  ButtonBox["Eigenvalues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvalues"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3790]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->565550945],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->826498775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "d", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"4", " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "d"}], "+", 
        SuperscriptBox["d", "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "d", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"4", " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "d"}], "+", 
        SuperscriptBox["d", "2"]}]]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{436, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"(", GridBox[{
     {"a", "b"},
     {"c", "d"}
    }], ")"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "d", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"4", " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "d"}], "+", 
        SuperscriptBox["d", "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "d", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"4", " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "d"}], "+", 
        SuperscriptBox["d", "2"]}]]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{436, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20394],

Cell["Exact eigenvalues:", "ExampleText",
 CellID->29909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"i", "+", "j", "+", "1"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19755],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"4755", " ", "#1"}], "-", 
       RowBox[{"255600", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"378000", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"4755", " ", "#1"}], "-", 
       RowBox[{"255600", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"378000", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"4755", " ", "#1"}], "-", 
       RowBox[{"255600", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"378000", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{320, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1861],

Cell["Find approximate numerical eigenvalues:", "ExampleText",
 CellID->1632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j", "+", "1"}], ")"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6570514282975791`", ",", "0.018926310974070878`", ",", 
   "0.00021273691882607517`"}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23121]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31364],

Cell["Find eigenvalues starting with 20-digit precision:", "ExampleText",
 CellID->15947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"i", "+", "j", "+", "1"}], ")"}]}], ",", "20"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.65705142829757924543524756922801790135`20.", ",", 
   "0.01892631097407091430672667033954990259`20.", ",", 
   "0.00021273691882603073421623662290833902`20."}], "}"}]], "Output",
 ImageSize->{531, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6181],

Cell["Largest 5 eigenvalues:", "ExampleText",
 CellID->18540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"i", "+", "j", "+", "1"}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "50"}], "}"}]}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.5683498546754608`", ",", "0.3202714354653395`", ",", 
   "0.050662467016583175`", ",", "0.007285170161270228`", ",", 
   "0.0009709966020340597`"}], "}"}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17349],

Cell["Multiple eigenvalues are listed multiple times:", "ExampleText",
 CellID->30461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30001]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21520],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sparse Arrays",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}], "<", "3"}]}], "\[Rule]", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11740],

Cell[BoxData[
 GraphicsBox[{
   RasterBox[SparseArray[
    Automatic, {10, 10}, 1, {
     1, {{0, 3, 7, 12, 17, 22, 27, 32, 37, 41, 44}, {{8}, {10}, {9}, {8}, {
       7}, {10}, {9}, {8}, {7}, {9}, {10}, {6}, {6}, {5}, {7}, {9}, {8}, {
       5}, {4}, {6}, {7}, {8}, {4}, {5}, {6}, {7}, {3}, {2}, {3}, {4}, {5}, {
       6}, {1}, {2}, {3}, {4}, {5}, {2}, {3}, {4}, {1}, {1}, {2}, {3}}}, {0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}], {{0, 0}, {
    10, 10}}], 
   {GrayLevel[0.618033988749895], 
    LineBox[{{{0, 10}, {10, 10}}, {{0, 9}, {10, 9}}, {{0, 8}, {10, 8}}, {{0, 
     7}, {10, 7}}, {{0, 6}, {10, 6}}, {{0, 5}, {10, 5}}, {{0, 4}, {10, 4}}, {{
     0, 3}, {10, 3}}, {{0, 2}, {10, 2}}, {{0, 1}, {10, 1}}, {{0, 0}, {10, 
     0}}, {{0, 0}, {0, 10}}, {{1, 0}, {1, 10}}, {{2, 0}, {2, 10}}, {{3, 0}, {
     3, 10}}, {{4, 0}, {4, 10}}, {{5, 0}, {5, 10}}, {{6, 0}, {6, 10}}, {{7, 
     0}, {7, 10}}, {{8, 0}, {8, 10}}, {{9, 0}, {9, 10}}, {{10, 0}, {10, 
     10}}}]}},
  AspectRatio->Automatic,
  Frame->False,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{108, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{104., Automatic}},
 CellLabel->"Out[1]=",
 CellID->29732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"x", "-", "y"}], "]"}], "<", "3"}]}], "\[Rule]", "1"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17177],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXNtu00AQdW69haZXtQ2lJTxAQYg/oH0EUcQLfxBVoPYBgQov9BtaeKQS
Eh9AP4F+C+UF8Rkma3udzfFsZteXxE6M1Diznt2dOTtejw/jvOp+On7zrvvp
5KjbeX7a/XB8cvSx8+z9aa+pVnGcyi/HcV5uOb3vbu+b9yf+Xff+HOdB77Pa
a/oZHJ8Ex6vgWA+OjVDbqckRXK+XKj8G+QrkOsjVEY76DeRlkGsg3wf5kulv
boXAc4WYXbSj/qVGn55ttvcpGtGXWrCStWAlpazqzPc+Go4/htreCNqrwdGL
hHr/vD+bOLNB9KQ1b1lpCv99lzyFiHczgS56hLL0PA46CxOPjh9Bc96EYas/
rH/OsLWmb1Vma4KMuKJMWT9DeIUo6/QQY51eM4J9I8B8lvSTslOvnT6u6Ffx
cJ03sFATt5FrxApbvOJgDuoaklc/h2r0CsYZ5P4yR41k1JOfo6n4Hn46Lcb3
xZEgi+2TgOySie2KXHFlJNdTRjnpbssjsGmNLn+X43pwGdhiBkgm3V+LiWSm
ucLUxS2V+0d23ExxLaPYZaJYIKg+F8iMm8xjhqytPXJbINfYHuushogokVut
UgiwkWeKBRfn+cIizWhBT7l9jENGlzVXgxVYIq0Y1qsa9KLOy/Xd1I7KxwiH
gG1sjAeBtoFV0ZgQu6Uw5TacXXD7V53k0MJnwYEYlU+JOP6Sq8tAZY8ZanWM
NDfdPuOBK0V508y9N1S7GSu3D/IeyHdcP5PsQDsykwcxx4ln5UOQtxVZXA33
LK21HU9vtViJfei9B/JuoNdxB5nnA8t+gwz1W2YFdkH+YqnvYegJ1/DtdWDH
OfhzERy3Qy11vHNmjS5Abqc4CuZo+LyK8fcZZFsG/cyy/1popbxfVyEepFU2
jPoZo+9lEOFehTGuY1NFu8yNBkZ1eG5ZciC4d+l531V1pBxxyEkYdokCxbAX
CwUvyyYzHB2/KdpHxbxTkWuSea0R6zVNzDrOTz0jjxc3E+Zc6Pn7qog3Kprx
LtCKzJcmn0bZaMa5NhTNEKcJZsp1//eQR6Q45tvPP3CHpCIvbf6W2/14j+kn
T3u2qhh8N7frFRkv8yjMlo1NHpPLtMbE89jJo3M8yGUZmaZsLcrR+zx6odpj
dg3nhZkmc5yx+Zrl6nM8LHXPoLJM9J/jY1tDzguf26S16XDLVCSPwqdtxg5/
HSVvIY+SWUB+tabo0ZznuqswXcaMazZssLR2ZWzWUu00O/YC5B2QOyAje3Zo
2d/MCmQW71pawfXvWyGQUmcXsb8DcscdZC0PDfV9VvMHg9B35vxTbxTxFVlV
ySYjqyrrkx+FWup4HB+KFcR7GY6SlDXl6o6xP7K6s1qr0qhDlvpbrsJiJapD
zj8bKr0zeUKPi0Jx641N0Wm5eia9ZEPzzoYWv87YDlcdm+/vrtlWHxeJI0Wc
yOe4spo4I2Qp3z3EM6kqLjKXasI3lLXDaSCJNvXjsWRVqR6SJyCv47IqODU8
beKy5FSLXu2b5i41jRxrMep3zSqY6bXWVfEWi5fNf5Uu5c2Gsr5R7ikpfxu3
Kpfm85LyuEmrbvtWxeF1batrfX71lFmBrwzCiJFntScg3ysjR84vf5fin3cW
MxhcMfzliL8Z9rL9PYkb41GH8ax/+qP0rzh3Gn/1YV7jNXr4m8TdJm+e7t85
QA8wc5JX7I3XDc9Gc7jyvXwzvkdmjYgBvTsJJMq3xk160HUTaLse5fKNZ3vM
6Xw3Lt6T+W6umj8kjcjJeB9VfRuTQWQgF6Kei/L9LmZbM6dZJhr37cV4o9s+
r/izYF5v+3agn//bvt0nPvyKBKfyHw6Tf3g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{443, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122646083]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"x", "-", "y"}], "]"}], "<", "3"}]}], "\[Rule]", "1.0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.638628626534003`", ",", "3.6510934089371747`", ",", "2.300431311609829`",
    ",", 
   RowBox[{"-", "1.0000000000000004`"}], ",", "1.`", ",", 
   RowBox[{"-", "0.9999999999999998`"}], ",", "0.7261094450357822`", ",", 
   RowBox[{"-", "0.3772028539729576`"}], ",", "0.3381089427182134`", ",", 
   RowBox[{"-", "0.2771688808620461`"}]}], "}"}]], "Output",
 ImageSize->{563, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31662]
}, Open  ]],

Cell["The largest 5 eigenvalues:", "ExampleText",
 CellID->23409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}], "<", "3"}]}], "\[Rule]", "1.0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100"}], "}"}]}], "]"}], ",", "5"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->31702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.995216265373198`", ",", "4.980880782930823`", ",", "4.957040659305339`", 
   ",", "4.923774213513111`", ",", "4.881190689715834`"}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->7049]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14843],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cubics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "7", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7229819],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "88"}], "-", 
       RowBox[{"39", " ", "#1"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "88"}], "-", 
       RowBox[{"39", " ", "#1"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "88"}], "-", 
       RowBox[{"39", " ", "#1"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{450, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->593573036]
}, Open  ]],

Cell["\<\
Explicitly use the cubic formula to give the result in terms of radicals:\
\>", "ExampleText",
 CellID->531351261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->163660646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["3483", "2"], "-", 
        FractionBox[
         RowBox[{"27", " ", 
          SqrtBox["5665"]}], "2"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"129", "+", 
         SqrtBox["5665"]}], ")"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], ",", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["3483", "2"], "-", 
        FractionBox[
         RowBox[{"27", " ", 
          SqrtBox["5665"]}], "2"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"129", "+", 
          SqrtBox["5665"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}], ",", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["3483", "2"], "-", 
        FractionBox[
         RowBox[{"27", " ", 
          SqrtBox["5665"]}], "2"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"129", "+", 
          SqrtBox["5665"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}]}], "}"}]], "Output",
 ImageSize->{498, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94389171]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14681],

Cell["Smallest eigenvalue of a Hilbert matrix:", "ExampleText",
 CellID->12622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j", "+", "1"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "8"}], "}"}]}], "]"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"206464302080", " ", "#1"}], "+", 
      RowBox[{"222437395367303054400", " ", 
       SuperscriptBox["#1", "2"]}], "-", 
      RowBox[{"2739993394034203178876928000", " ", 
       SuperscriptBox["#1", "3"]}], "+", 
      RowBox[{"637719958052622085525146662400000", " ", 
       SuperscriptBox["#1", "4"]}], "-", 
      RowBox[{"4140819631297764573687436581273600000", " ", 
       SuperscriptBox["#1", "5"]}], "+", 
      RowBox[{"1042736529363771727358750262177792000000", " ", 
       SuperscriptBox["#1", "6"]}], "-", 
      RowBox[{"13725015268769057768348457401057280000000", " ", 
       SuperscriptBox["#1", "7"]}], "+", 
      RowBox[{"12701009683686045652926579789004800000000", " ", 
       SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], 
  "}"}]], "Output",
 ImageSize->{567, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32213]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3062],

Cell[BoxData[
 RowBox[{"{", "4.868991953139937`*^-12", "}"}]], "Output",
 ImageSize->{108, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20276],

Cell["Eigenvalues of a random matrix:", "ExampleText",
 CellID->28289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"Eigenvalues", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32062],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1FlIlFEUB/CrWWmiueZEailq7lsupU7z13ErS2dTx0koXB5Moig1ZAi/
0chIgyCzoGW0Ih8qqwfNFE18MM1op0hDM6IstGxRSjEr536EZ2AYfvzPuefe
uTOfR95eVaE5Y6zg7/vf58KrW4EXxW533WZWYMGCAuUfnlfsjrU2GUpIDvod
l7+xMpkpF9czBbqSLhhqU3m9kAHvhi9l9wxiP81VyFst3Dxl5OuBuFuFkaxv
v6akopUInIg/69LBLdD9qEieBl1Jr/1g20qeU29Dvlm0zE9ny70VDR+Dwgc7
eC5swXL/nlyHJXbcNE+HsctQVq+z4f3U5PxsOwo99RW33/FcIPMFkrNsJIXI
5/LjZ2Sm82ehwHnamFE5a7KQjZPHRjW6+mmTQeqRBasB9WTfnd8mM2KBrNet
xafiquKvpeM8J2Y5GGy7fN390ituLYbeGp966Sd4P90PyZkG1dqIc2tHLPh9
qtHYL2meC17K75/kUEMdo9B2nrDk34d68e9BILmQicqoxPfSoHk+PxN2zT36
Xb1mfB7JuzWocZ+01jiY834NWuSSEii5WebinIXB4vON6tw4Z+5Q4g0Yf9Qu
Ga504g4nDkRkf9HVMr1Y7w9l3GMbp3rRwSTfiH1dLjU5UrE/GnXaKqzZIXoT
ySMxNjY3UZQnOoI4ivQ7wQHLNE92unDbEUsQ6Djq0acSzWA5NFXX7irhnpQt
tiXW/wjwST8s1vsgcbg1tLNDPI8XsS85/zp8r/WVXgtbxe1K5nuSPAm2TY0r
fyrsTRYSEaLUN92q5mbJOHTlyOuOMvH/S+vlKL14Oq3zmVhPTdYTUtH6IG82
X8bXY9TkecFSUJ5s5y1NEefT/ZCcbUbAy4T5M9aO3FK0p+95aPAVLSN5LMwP
uLcEhIn3GUMcR/oTsH/g/FGdvQOfH48BQ+5ov0Q0zQH5ffm8zzg3o/7f/wcX
mJpg
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{273., Automatic},
  PlotRange->{{0., 100.}, {0., 6.02805550337394}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{277, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->169654085]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25538],

Cell["Characteristic polynomial:", "ExampleText",
 CellID->32427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "d", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"4", " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "d"}], "+", 
        SuperscriptBox["d", "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "d", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"4", " ", "b", " ", "c"}], "-", 
        RowBox[{"2", " ", "a", " ", "d"}], "+", 
        SuperscriptBox["d", "2"]}]]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{436, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25165],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "b"}], " ", "c"}], "+", 
  RowBox[{"a", " ", "d"}], "-", 
  RowBox[{"a", " ", "x"}], "-", 
  RowBox[{"d", " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31880]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5037],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "d", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"4", " ", "b", " ", "c"}], "-", 
          RowBox[{"2", " ", "a", " ", "d"}], "+", 
          SuperscriptBox["d", "2"]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "d", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"4", " ", "b", " ", "c"}], "-", 
          RowBox[{"2", " ", "a", " ", "d"}], "+", 
          SuperscriptBox["d", "2"]}]]}], ")"}]}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{510, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29870]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31171],

Cell["\<\
The general symbolic case very quickly gets very complicated:\
\>", "ExampleText",
 CellID->28504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11682]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25793],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "+", 
      RowBox[{"a", "[", 
       RowBox[{"2", ",", "2"}], "]"}], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"a", "[", 
          RowBox[{"1", ",", "1"}], "]"}], "2"], "+", 
        RowBox[{"4", " ", 
         RowBox[{"a", "[", 
          RowBox[{"1", ",", "2"}], "]"}], " ", 
         RowBox[{"a", "[", 
          RowBox[{"2", ",", "1"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a", "[", 
          RowBox[{"1", ",", "1"}], "]"}], " ", 
         RowBox[{"a", "[", 
          RowBox[{"2", ",", "2"}], "]"}]}], "+", 
        SuperscriptBox[
         RowBox[{"a", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "+", 
      RowBox[{"a", "[", 
       RowBox[{"2", ",", "2"}], "]"}], "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"a", "[", 
          RowBox[{"1", ",", "1"}], "]"}], "2"], "+", 
        RowBox[{"4", " ", 
         RowBox[{"a", "[", 
          RowBox[{"1", ",", "2"}], "]"}], " ", 
         RowBox[{"a", "[", 
          RowBox[{"2", ",", "1"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"a", "[", 
          RowBox[{"1", ",", "1"}], "]"}], " ", 
         RowBox[{"a", "[", 
          RowBox[{"2", ",", "2"}], "]"}]}], "+", 
        SuperscriptBox[
         RowBox[{"a", "[", 
          RowBox[{"2", ",", "2"}], "]"}], "2"]}]]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{535, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8924]
}, Open  ]],

Cell["The expression sizes increase faster than exponentially:", "ExampleText",
 CellID->31767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ByteCount", "[", 
    RowBox[{"Eigenvalues", "[", 
     RowBox[{"Array", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "n"}], "}"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"88", ",", "2016", ",", "10640", ",", "73544"}], "}"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27338],

Cell["\<\
Here is a 20\[Times]20 Hilbert matrix:\
\>", "ExampleText",
 CellID->486691258],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j", "+", "1"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411074626],

Cell["\<\
Compute the smallest eigenvalue exactly and give its numerical value:\
\>", "ExampleText",
 CellID->119020954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"m", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->691256611],

Cell[BoxData[
 RowBox[{"{", "2.6956352067066423`*^-30", "}"}]], "Output",
 ImageSize->{108, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->277326482]
}, Open  ]],

Cell["\<\
Compute the smallest eigenvalue with machine number arithmetic:\
\>", "ExampleText",
 CellID->56443799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->409521089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "6.880521472365375`*^-19"}], "}"}]], "Output",
 ImageSize->{116, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->134811422]
}, Open  ]],

Cell["\<\
The smallest eigenvalue is not significant compared to the largest:\
\>", "ExampleText",
 CellID->177504736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Eigenvalues", "[", 
     RowBox[{
      RowBox[{"N", "[", "m", "]"}], ",", "1"}], "]"}], " ", "+", " ", 
    RowBox[{"Eigenvalues", "[", 
     RowBox[{
      RowBox[{"N", "[", "m", "]"}], ",", " ", 
      RowBox[{"-", "1"}]}], "]"}]}], ")"}], " ", "-", " ", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->276988826],

Cell[BoxData[
 RowBox[{"{", "0.`", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->81472972]
}, Open  ]],

Cell["Using sufficient precision for the numerical computation:", \
"ExampleText",
 CellID->446644531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"m", ",", " ", "30"}], "]"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->179823419],

Cell[BoxData[
 RowBox[{"{", "2.69563520670664233853740683631985996789252531373`30.*^-30", 
  "}"}]], "Output",
 ImageSize->{276, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->238351583]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"GCD", ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "8"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25677],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{485, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165423754]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12390],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvectors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvectors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigensystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigensystem"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacteristicPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PositiveDefiniteMatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2208]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21049],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->16704],

Cell[TextData[ButtonBox["Eigenvalues and Eigenvectors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EigenvaluesAndEigenvectors"]], "Tutorials",
 CellID->8001]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->505102644],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->220571688],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->69666200]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Eigenvalues",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Eigenvalues"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Eigenvalues"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eigenvalues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 44.7446948}", "context" -> "System`", 
    "keywords" -> {
     "Arnoldi methods", "ARPACK", "diagonalization", "diagonalize", 
      "generalized eigenvalues", "matrices", "matrix pencils", 
      "singular eigenvalue problem"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Eigenvalues[m] gives a list of the eigenvalues of the square matrix m. \
Eigenvalues[{m, a}] gives the generalized eigenvalues of m with respect to a. \
Eigenvalues[m, k] gives the first k eigenvalues of m. Eigenvalues[{m, a}, k] \
gives the first k generalized eigenvalues.", "synonyms" -> {}, "title" -> 
    "Eigenvalues", "type" -> "Symbol", "uri" -> "ref/Eigenvalues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11228, 389, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->565550945]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55347, 1941}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2819, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3442, 90, 48, 1, 70, "ObjectName",
 CellID->9687],
Cell[3493, 93, 2193, 70, 70, "Usage",
 CellID->25420]
}, Open  ]],
Cell[CellGroupData[{
Cell[5723, 168, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6201, 185, 321, 10, 70, "Notes",
 CellID->18595],
Cell[6525, 197, 105, 3, 70, "Notes",
 CellID->8684],
Cell[6633, 202, 337, 12, 70, "Notes",
 CellID->4823],
Cell[6973, 216, 126, 4, 70, "Notes",
 CellID->16311],
Cell[7102, 222, 515, 18, 70, "Notes",
 CellID->6240],
Cell[7620, 242, 522, 19, 70, "Notes",
 CellID->5623],
Cell[8145, 263, 572, 20, 70, "Notes",
 CellID->22065],
Cell[8720, 285, 124, 4, 70, "Notes",
 CellID->15219],
Cell[8847, 291, 417, 15, 70, "Notes",
 CellID->26379],
Cell[9267, 308, 409, 15, 70, "Notes",
 CellID->10912],
Cell[9679, 325, 557, 21, 70, "Notes",
 CellID->17271],
Cell[10239, 348, 621, 22, 70, "Notes",
 CellID->27167],
Cell[10863, 372, 328, 12, 70, "Notes",
 CellID->3790]
}, Closed]],
Cell[CellGroupData[{
Cell[11228, 389, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->565550945],
Cell[CellGroupData[{
Cell[11613, 403, 148, 5, 70, "ExampleSection",
 CellID->826498775],
Cell[CellGroupData[{
Cell[11786, 412, 252, 9, 28, "Input",
 CellID->18414],
Cell[12041, 423, 820, 27, 52, "Output",
 CellID->10732]
}, Open  ]],
Cell[CellGroupData[{
Cell[12898, 455, 172, 7, 39, "Input",
 CellID->18942],
Cell[13073, 464, 820, 27, 52, "Output",
 CellID->19026]
}, Open  ]],
Cell[13908, 494, 121, 3, 70, "ExampleDelimiter",
 CellID->20394],
Cell[14032, 499, 57, 1, 70, "ExampleText",
 CellID->29909],
Cell[CellGroupData[{
Cell[14114, 504, 359, 12, 70, "Input",
 CellID->19755],
Cell[14476, 518, 1137, 38, 77, "Output",
 CellID->30293]
}, Open  ]],
Cell[15628, 559, 120, 3, 70, "ExampleDelimiter",
 CellID->1861],
Cell[15751, 564, 77, 1, 70, "ExampleText",
 CellID->1632],
Cell[CellGroupData[{
Cell[15853, 569, 392, 13, 70, "Input",
 CellID->11708],
Cell[16248, 584, 277, 9, 36, "Output",
 CellID->23121]
}, Open  ]],
Cell[16540, 596, 121, 3, 70, "ExampleDelimiter",
 CellID->31364],
Cell[16664, 601, 89, 1, 70, "ExampleText",
 CellID->15947],
Cell[CellGroupData[{
Cell[16778, 606, 420, 14, 70, "Input",
 CellID->835],
Cell[17201, 622, 350, 10, 36, "Output",
 CellID->19233]
}, Open  ]],
Cell[17566, 635, 120, 3, 70, "ExampleDelimiter",
 CellID->6181],
Cell[17689, 640, 61, 1, 70, "ExampleText",
 CellID->18540],
Cell[CellGroupData[{
Cell[17775, 645, 426, 14, 70, "Input",
 CellID->8724],
Cell[18204, 661, 337, 10, 36, "Output",
 CellID->1112]
}, Open  ]],
Cell[18556, 674, 121, 3, 70, "ExampleDelimiter",
 CellID->17349],
Cell[18680, 679, 86, 1, 70, "ExampleText",
 CellID->30461],
Cell[CellGroupData[{
Cell[18791, 684, 343, 11, 70, "Input",
 CellID->23627],
Cell[19137, 697, 209, 7, 36, "Output",
 CellID->30001]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19395, 710, 239, 7, 70, "ExampleSection",
 CellID->21520],
Cell[CellGroupData[{
Cell[19659, 721, 230, 7, 70, "ExampleSubsection",
 CellID->22981],
Cell[CellGroupData[{
Cell[19914, 732, 531, 18, 70, "Input",
 CellID->11740],
Cell[20448, 752, 1356, 28, 125, "Output",
 CellID->29732]
}, Open  ]],
Cell[CellGroupData[{
Cell[21841, 785, 462, 16, 70, "Input",
 CellID->17177],
Cell[22306, 803, 2078, 38, 70, "Output",
 Evaluatable->False,
 CellID->122646083]
}, Open  ]],
Cell[CellGroupData[{
Cell[24421, 846, 464, 16, 70, "Input",
 CellID->14944],
Cell[24888, 864, 525, 13, 36, "Output",
 CellID->31662]
}, Open  ]],
Cell[25428, 880, 65, 1, 70, "ExampleText",
 CellID->23409],
Cell[CellGroupData[{
Cell[25518, 885, 504, 18, 70, "Input",
 CellID->31702],
Cell[26025, 905, 321, 9, 36, "Output",
 CellID->7049]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26407, 921, 218, 7, 70, "ExampleSection",
 CellID->14843],
Cell[CellGroupData[{
Cell[26650, 932, 223, 7, 70, "ExampleSubsection",
 CellID->32556],
Cell[CellGroupData[{
Cell[26898, 943, 345, 11, 70, "Input",
 CellID->7229819],
Cell[27246, 956, 1021, 35, 58, "Output",
 CellID->593573036]
}, Open  ]],
Cell[28282, 994, 124, 3, 70, "ExampleText",
 CellID->531351261],
Cell[CellGroupData[{
Cell[28431, 1001, 416, 13, 70, "Input",
 CellID->163660646],
Cell[28850, 1016, 2357, 84, 146, "Output",
 CellID->94389171]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31268, 1107, 223, 7, 70, "ExampleSection",
 CellID->14681],
Cell[31494, 1116, 79, 1, 70, "ExampleText",
 CellID->12622],
Cell[CellGroupData[{
Cell[31598, 1121, 410, 14, 70, "Input",
 CellID->21188],
Cell[32011, 1137, 1024, 26, 126, "Output",
 CellID->32213]
}, Open  ]],
Cell[CellGroupData[{
Cell[33072, 1168, 92, 3, 70, "Input",
 CellID->3062],
Cell[33167, 1173, 199, 6, 39, "Output",
 CellID->14981]
}, Open  ]],
Cell[33381, 1182, 121, 3, 70, "ExampleDelimiter",
 CellID->20276],
Cell[33505, 1187, 70, 1, 70, "ExampleText",
 CellID->28289],
Cell[CellGroupData[{
Cell[33600, 1192, 375, 13, 70, "Input",
 CellID->32062],
Cell[33978, 1207, 1544, 35, 201, "Output",
 CellID->169654085]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35571, 1248, 233, 7, 70, "ExampleSection",
 CellID->25538],
Cell[35807, 1257, 65, 1, 70, "ExampleText",
 CellID->32427],
Cell[CellGroupData[{
Cell[35897, 1262, 252, 9, 70, "Input",
 CellID->31871],
Cell[36152, 1273, 820, 27, 52, "Output",
 CellID->25673]
}, Open  ]],
Cell[CellGroupData[{
Cell[37009, 1305, 294, 10, 70, "Input",
 CellID->25165],
Cell[37306, 1317, 342, 12, 36, "Output",
 CellID->31880]
}, Open  ]],
Cell[CellGroupData[{
Cell[37685, 1334, 150, 5, 70, "Input",
 CellID->5037],
Cell[37838, 1341, 972, 32, 52, "Output",
 CellID->29870]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38859, 1379, 226, 7, 70, "ExampleSection",
 CellID->31171],
Cell[39088, 1388, 108, 3, 70, "ExampleText",
 CellID->28504],
Cell[CellGroupData[{
Cell[39221, 1395, 167, 6, 70, "Input",
 CellID->991],
Cell[39391, 1403, 530, 19, 36, "Output",
 CellID->11682]
}, Open  ]],
Cell[CellGroupData[{
Cell[39958, 1427, 210, 7, 70, "Input",
 CellID->25793],
Cell[40171, 1436, 1854, 60, 84, "Output",
 CellID->8924]
}, Open  ]],
Cell[42040, 1499, 95, 1, 70, "ExampleText",
 CellID->31767],
Cell[CellGroupData[{
Cell[42160, 1504, 365, 12, 70, "Input",
 CellID->15347],
Cell[42528, 1518, 232, 7, 36, "Output",
 CellID->18217]
}, Open  ]],
Cell[42775, 1528, 121, 3, 70, "ExampleDelimiter",
 CellID->27338],
Cell[42899, 1533, 89, 3, 70, "ExampleText",
 CellID->486691258],
Cell[42991, 1538, 387, 13, 70, "Input",
 CellID->411074626],
Cell[43381, 1553, 120, 3, 70, "ExampleText",
 CellID->119020954],
Cell[CellGroupData[{
Cell[43526, 1560, 179, 6, 70, "Input",
 CellID->691256611],
Cell[43708, 1568, 204, 6, 39, "Output",
 CellID->277326482]
}, Open  ]],
Cell[43927, 1577, 113, 3, 70, "ExampleText",
 CellID->56443799],
Cell[CellGroupData[{
Cell[44065, 1584, 178, 6, 70, "Input",
 CellID->409521089],
Cell[44246, 1592, 221, 7, 39, "Output",
 CellID->134811422]
}, Open  ]],
Cell[44482, 1602, 118, 3, 70, "ExampleText",
 CellID->177504736],
Cell[CellGroupData[{
Cell[44625, 1609, 474, 15, 70, "Input",
 CellID->276988826],
Cell[45102, 1626, 181, 6, 36, "Output",
 CellID->81472972]
}, Open  ]],
Cell[45298, 1635, 102, 2, 70, "ExampleText",
 CellID->446644531],
Cell[CellGroupData[{
Cell[45425, 1641, 209, 7, 70, "Input",
 CellID->179823419],
Cell[45637, 1650, 241, 7, 39, "Output",
 CellID->238351583]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45927, 1663, 224, 7, 70, "ExampleSection",
 CellID->18453],
Cell[CellGroupData[{
Cell[46176, 1674, 212, 7, 70, "Input",
 CellID->25677],
Cell[46391, 1683, 2949, 52, 70, "Output",
 Evaluatable->False,
 CellID->165423754]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49401, 1742, 311, 9, 70, "SeeAlsoSection",
 CellID->12390],
Cell[49715, 1753, 1747, 62, 70, "SeeAlso",
 CellID->2208]
}, Open  ]],
Cell[CellGroupData[{
Cell[51499, 1820, 314, 9, 70, "TutorialsSection",
 CellID->21049],
Cell[51816, 1831, 149, 3, 70, "Tutorials",
 CellID->16704],
Cell[51968, 1836, 164, 3, 70, "Tutorials",
 CellID->8001]
}, Open  ]],
Cell[CellGroupData[{
Cell[52169, 1844, 319, 9, 70, "MoreAboutSection",
 CellID->505102644],
Cell[52491, 1855, 163, 3, 70, "MoreAbout",
 CellID->220571688],
Cell[52657, 1860, 144, 3, 70, "MoreAbout",
 CellID->69666200]
}, Open  ]],
Cell[CellGroupData[{
Cell[52838, 1868, 305, 8, 70, "RelatedLinksSection"],
Cell[53146, 1878, 367, 12, 70, "RelatedLinks"],
Cell[53516, 1892, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[53920, 1908, 50, 0, 70, "History"],
Cell[53973, 1910, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

