(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39113,       1425]
NotebookOptionsPosition[     31998,       1179]
NotebookOutlinePosition[     33482,       1219]
CellTagsIndexPosition[     33396,       1214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplifying with Assumptions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SimplifyingWithAssumptions"], "Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Simplifying with Assumptions\"\>", 
       2->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "MemberQ" :> Documentation`HelpLookup["paclet:ref/MemberQ"], 
          "IntegerQ" :> Documentation`HelpLookup["paclet:ref/IntegerQ"], 
          "Assumptions" :> Documentation`HelpLookup["paclet:ref/Assumptions"],
           "Condition" :> Documentation`HelpLookup["paclet:ref/Condition"], 
          "PatternTest" :> Documentation`HelpLookup["paclet:ref/PatternTest"],
           "Equal" :> Documentation`HelpLookup["paclet:ref/Equal"], "Less" :> 
          Documentation`HelpLookup["paclet:ref/Less"], "Divisible" :> 
          Documentation`HelpLookup["paclet:ref/Divisible"], "CoprimeQ" :> 
          Documentation`HelpLookup["paclet:ref/CoprimeQ"], "Booleans" :> 
          Documentation`HelpLookup["paclet:ref/Booleans"], "Primes" :> 
          Documentation`HelpLookup["paclet:ref/Primes"], "Exists" :> 
          Documentation`HelpLookup["paclet:ref/Exists"], "ForAll" :> 
          Documentation`HelpLookup["paclet:ref/ForAll"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Simplify\"\>", 2->"\<\"MemberQ\"\>", 
       3->"\<\"IntegerQ\"\>", 4->"\<\"Assumptions\"\>", 
       5->"\<\"Condition\"\>", 6->"\<\"PatternTest\"\>", 7->"\<\"Equal\"\>", 
       8->"\<\"Less\"\>", 9->"\<\"Divisible\"\>", 10->"\<\"CoprimeQ\"\>", 
       11->"\<\"Booleans\"\>", 12->"\<\"Primes\"\>", 13->"\<\"Exists\"\>", 
       14->"\<\"ForAll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Number Recognition\"\>", 
       2->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Element ",
 StyleBox["(\[Element])", "OperatorCharacter"]
}], "ObjectName",
 CellID->6128],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Element",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Element"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["\[Element]", "TR"], 
       StyleBox["dom", "TI"]}]], "InlineFormula"],
     " asserts that ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is an element of the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Element",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Element"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]asserts that all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are elements of ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Element",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Element"], "[", 
       RowBox[{
        StyleBox["patt", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]asserts that any expression matching the pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " is an element of ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]el\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  StyleBox["dom", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", "Element", "]"}]}], 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11686],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 " can be used to set up assumptions in ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and related functions. "
}], "Notes",
 CellID->1062],

Cell["Possible domains are: ", "Notes",
 CellID->28529],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Algebraics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Algebraics"], Cell[
    "algebraic numbers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Booleans",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Booleans"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " or ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Complexes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complexes"], Cell[
    "complex numbers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"], Cell["integers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Primes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Primes"], Cell["prime numbers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Rationals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rationals"], Cell[
    "rational numbers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"], Cell["real numbers ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->15072],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 " if possible evaluates immediately when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is numeric. "
}], "Notes",
 CellID->25489],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], "|", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], "|", 
     StyleBox["\[Ellipsis]", "TR"]}], ")"}], 
   StyleBox["\[Element]", "TR"], 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], 
   StyleBox["\[Element]", "TR"], 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->822],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], 
   StyleBox["\[Element]", "TR"], 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], "|", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], "|", 
     StyleBox["\[Ellipsis]", "TR"]}], ")"}], 
   StyleBox["\[Element]", "TR"], 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 " if its truth or falsity cannot immediately be determined. "
}], "Notes",
 CellID->431]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46038553],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->296792597],

Cell[TextData[{
 "Test whether ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " is an element of the reals:"
}], "ExampleText",
 CellID->6334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pi", " ", "\[Element]", " ", "Reals"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205387439],

Cell["Express domain membership for an expression:", "ExampleText",
 CellID->318579202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220101818],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "\[Element]", "Reals"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->504130940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37477389],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]elem\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->8119997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[Element]", "Reals"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162312622],

Cell[BoxData[
 RowBox[{"x", "\[Element]", "Reals"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87938944]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->124510472],

Cell["Test domain membership:", "ExampleText",
 CellID->760646380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "Complexes", ",", "Algebraics", ",", "Reals", ",", "Rationals", ",", 
    "Integers", ",", "Primes"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587943959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "False", ",", "False", ",", 
   "False"}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->774316759]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->617094597],

Cell["Make domain membership assumptions:", "ExampleText",
 CellID->35973599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", " ", "x"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144317606],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599550765]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"1", "-", 
     RowBox[{"Abs", "[", 
      RowBox[{"x", "+", "2"}], "]"}]}], "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214991929],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1u00AQdmI7CUT5KQJRibaEA/1BqlJaKhpoISc4IX7EBQqIqEJqDxVR
6SG3PEIElzxCjnkEHiGPkcdYvPZMvZ6dTdexQAhhKbZ3/O387e58a+dF5/z4
y2nn/OSo03h+1ukenxx9azz7ehaI3JzjOMPgd7roBPciuAt/QyGCa3TeC85u
IPwQtlx59nq93s/wmE6n96VEAkR4qDi33++DdIegDjOgthWUk/Qsta7vrLQI
MZeIDonLB808XIvk+Qb0kzgfrhIXGYgO2dcLrmus5YI8+RcaoRu144WnuK17
eo/xfFYbo6LR2HroQ8S+khnZDtFuMFMg+mKYjXa7DV1v2vipWcviKc0lenxl
ngyynvkzR9djRmu+8ZRee+b8aNIZM07RXBPJOb6g+Xab9EBk5Ex4EB3Spuyw
znpAR2QVei1rlum4t1h9JbB2V9Ej591jFt3UrHxicQ9A63vjU9UzHrVLUO8y
oFSLjtEvO118Ffyz0m2h8Yyh5svbf4llqiK5WuSslov3KtGdJ7gC4CoiZhvb
KihtJmf9IxZXUmwl8WXiXYW0eW9oTMiUaXnjhhqzoq8o4mqehxyqufLn8rIC
Wg6IHLODVrF9zcoKjn9Nyy21Q7nJ1XpgvHVryyqKzkC95q8bMoI9uIyl9wMr
v6zc+lxsWuv0lOq/ClluQttne/1nAaxSEccOh8PRaCRvfyjSGKtKu93uYDCI
pVlYYB/y+8b4VI2DR9HV8zoDSrXoGP2y08VHXICI6Rr3QY6V0fTOgfOb1uP5
2IJ6QXeH/H4zXFMz96/8irZnlzLbPx3HcLvuNJxTTuB0PSbO8bgcGusWHV+T
13SkNpiRm5+b7N6d0IY+ftTrNUDScTUz2QJB5lP4SWOka0HntxXS4zJ+q5F2
LoV3VVa6BJZusU83WensfUUdrsugeUnETOjivNR6t7TcvGVxT0DLK+NTNT88
6ilBvcyAUi06Rr/sdP0N70NbkF9+H7JF4uBR9Nvcxwwo1aJj9MtOFx9xVfCM
t0Pa+K0J8XdYbeEO1IKpdjUJXes89zRYq1jzTRxhyzWLIskpRYPeFdYLWjvR
+kOR5ITrVtrwi5Be5fXcIcvU4cqPDVfbL6/PKoKyH63HfCT8nMDKu59inHHu
YW09ELPm4qYWz2cW95u/gXjj8bgfHpPJhGqLcHuK1LnwpMVio/8HnNwvQd4v
QA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{151, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63708475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62298810],

Cell["Test domain membership using assumptions:", "ExampleText",
 CellID->233157462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "y"}], "+", 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "y"}], "]"}]}], ",", "Reals"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->591579755],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138274558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->432382969],

Cell["Specify variable domains:", "ExampleText",
 CellID->24255137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"E", "^", "x"}], "-", 
      RowBox[{"2", "x"}]}], "\[Equal]", "3"}], " ", "&&", " ", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421960511],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"3", "/", "2"}]]}]]}], "]"}]}]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"3", "/", "2"}]]}]]}]}], "]"}]}]}], 
     ")"}]}]}]}]], "Output",
 ImageSize->{485, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88045806]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"x", ">", 
     RowBox[{"10", "^", "10"}]}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"x", "|", "y"}], ",", "Integers"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155060939],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "26102926097"}], ",", 
    RowBox[{"y", "\[Rule]", "18457556052"}]}], "}"}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106634371]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "100"}], "&&", 
      RowBox[{"Element", "[", 
       RowBox[{
        RowBox[{"x", "|", "y"}], ",", "Integers"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->75449644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "14"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "8"}]}], ",", 
     RowBox[{"y", "\[Rule]", "6"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->530778129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->653682320],

Cell["Specify assumptions on objects matching a pattern:", "ExampleText",
 CellID->29288507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"2", "Pi", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "[", "2", "]"}], 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "^", "2"}], "Pi"}], "+", 
     RowBox[{"a", " ", "Pi"}]}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "[", "_", "]"}], ",", "Integers"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->321749489],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"a", " ", "\[Pi]"}], "]"}]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72276847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123465073],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->18274992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Element", "[", 
   RowBox[{"x", ",", "Reals"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156899339],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "\[Element]", 
   TagBox["\[DoubleStruckCapitalR]",
    Function[{}, Reals]]}], TraditionalForm]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->833610216]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9430481],

Cell[TextData[{
 "For a single variable, the negation of ",
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 " is automatically converted ",
 Cell[BoxData[
  ButtonBox["NotElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotElement"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->817758621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"Element", "[", 
   RowBox[{"a", ",", "Reals"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286126246],

Cell[BoxData[
 RowBox[{"a", "\[NotElement]", "Reals"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35043275]
}, Open  ]],

Cell[TextData[{
 "For multiple variables the negation of ",
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 " is not automatically simplified:"
}], "ExampleText",
 CellID->74140771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"Element", "[", 
   RowBox[{
    RowBox[{"a", "|", "b", "|", "c"}], ",", "Reals"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246688360],

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "|", "b", "|", "c"}], ")"}], "\[Element]", 
   "Reals"}]}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->173325831]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to find the representation in terms of  ",
 Cell[BoxData[
  ButtonBox["NotElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotElement"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->615168356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->71806121],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[NotElement]", "Reals"}], "||", 
  RowBox[{"b", "\[NotElement]", "Reals"}], "||", 
  RowBox[{"c", "\[NotElement]", "Reals"}]}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->267997713]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22959],

Cell[TextData[{
 "When domain membership cannot be decided the ",
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 " statement remain unevaluated:"
}], "ExampleText",
 CellID->306753271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"I", "^", "Pi"}], ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84542705],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ImaginaryI]", "\[Pi]"], "\[Element]", 
  "Algebraics"}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->934029605]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30535],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Condition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Condition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Less",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Less"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoprimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoprimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Booleans",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Booleans"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Primes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Primes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30280]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30983],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "Tutorials",
 CellID->8421],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->3341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->96644425],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->381478982],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->577279554]
}, Open  ]],

Cell["New in 4  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Element (\[Element]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 52.4480170}", "context" -> "System`", 
    "keywords" -> {
     "domains for variables", "types", "domain membership", 
      "domain assumptions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Element[x, dom] or x \\[Element] dom asserts that x is an element of the \
domain dom. Element[{x_1, x_2, ...}, dom] asserts that all the x_i are \
elements of dom. Element[patt, dom] asserts that any expression matching the \
pattern patt is an element of dom. ", "synonyms" -> {}, "title" -> "Element", 
    "type" -> "Symbol", "uri" -> "ref/Element"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11561, 374, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->46038553]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33253, 1207}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3293, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3916, 94, 108, 4, 70, "ObjectName",
 CellID->6128],
Cell[4027, 100, 2196, 73, 70, "Usage",
 CellID->617]
}, Open  ]],
Cell[CellGroupData[{
Cell[6260, 178, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6738, 195, 623, 25, 70, "Notes",
 CellID->11686],
Cell[7364, 222, 350, 12, 70, "Notes",
 CellID->1062],
Cell[7717, 236, 55, 1, 70, "Notes",
 CellID->28529],
Cell[7775, 239, 1870, 53, 70, "2ColumnTableMod",
 CellID->15072],
Cell[9648, 294, 295, 11, 70, "Notes",
 CellID->25489],
Cell[9946, 307, 761, 30, 70, "Notes",
 CellID->822],
Cell[10710, 339, 814, 30, 70, "Notes",
 CellID->431]
}, Closed]],
Cell[CellGroupData[{
Cell[11561, 374, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46038553],
Cell[CellGroupData[{
Cell[11945, 388, 148, 5, 70, "ExampleSection",
 CellID->296792597],
Cell[12096, 395, 167, 6, 70, "ExampleText",
 CellID->6334],
Cell[CellGroupData[{
Cell[12288, 405, 109, 3, 28, "Input",
 CellID->41],
Cell[12400, 410, 157, 5, 36, "Output",
 CellID->18467]
}, Open  ]],
Cell[12572, 418, 125, 3, 70, "ExampleDelimiter",
 CellID->205387439],
Cell[12700, 423, 87, 1, 70, "ExampleText",
 CellID->318579202],
Cell[CellGroupData[{
Cell[12812, 428, 154, 5, 70, "Input",
 CellID->220101818],
Cell[12969, 435, 216, 7, 36, "Output",
 CellID->504130940]
}, Open  ]],
Cell[13200, 445, 124, 3, 70, "ExampleDelimiter",
 CellID->37477389],
Cell[13327, 450, 191, 7, 70, "ExampleText",
 CellID->8119997],
Cell[CellGroupData[{
Cell[13543, 461, 105, 3, 70, "Input",
 CellID->162312622],
Cell[13651, 466, 192, 6, 36, "Output",
 CellID->87938944]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13892, 478, 220, 7, 70, "ExampleSection",
 CellID->124510472],
Cell[14115, 487, 66, 1, 70, "ExampleText",
 CellID->760646380],
Cell[CellGroupData[{
Cell[14206, 492, 342, 11, 70, "Input",
 CellID->587943959],
Cell[14551, 505, 272, 9, 36, "Output",
 CellID->774316759]
}, Open  ]],
Cell[14838, 517, 125, 3, 70, "ExampleDelimiter",
 CellID->617094597],
Cell[14966, 522, 77, 1, 70, "ExampleText",
 CellID->35973599],
Cell[CellGroupData[{
Cell[15068, 527, 249, 8, 70, "Input",
 CellID->144317606],
Cell[15320, 537, 158, 5, 36, "Output",
 CellID->599550765]
}, Open  ]],
Cell[CellGroupData[{
Cell[15515, 547, 360, 11, 70, "Input",
 CellID->214991929],
Cell[15878, 560, 1436, 28, 70, "Output",
 Evaluatable->False,
 CellID->63708475]
}, Open  ]],
Cell[17329, 591, 124, 3, 70, "ExampleDelimiter",
 CellID->62298810],
Cell[17456, 596, 84, 1, 70, "ExampleText",
 CellID->233157462],
Cell[CellGroupData[{
Cell[17565, 601, 379, 13, 70, "Input",
 CellID->591579755],
Cell[17947, 616, 161, 5, 36, "Output",
 CellID->138274558]
}, Open  ]],
Cell[18123, 624, 125, 3, 70, "ExampleDelimiter",
 CellID->432382969],
Cell[18251, 629, 67, 1, 70, "ExampleText",
 CellID->24255137],
Cell[CellGroupData[{
Cell[18343, 634, 333, 11, 70, "Input",
 CellID->421960511],
Cell[18679, 647, 1010, 35, 53, "Output",
 CellID->88045806]
}, Open  ]],
Cell[CellGroupData[{
Cell[19726, 687, 500, 17, 70, "Input",
 CellID->155060939],
Cell[20229, 706, 310, 10, 36, "Output",
 CellID->106634371]
}, Open  ]],
Cell[CellGroupData[{
Cell[20576, 721, 505, 17, 70, "Input",
 CellID->75449644],
Cell[21084, 740, 359, 13, 36, "Output",
 CellID->530778129]
}, Open  ]],
Cell[21458, 756, 125, 3, 70, "ExampleDelimiter",
 CellID->653682320],
Cell[21586, 761, 92, 1, 70, "ExampleText",
 CellID->29288507],
Cell[CellGroupData[{
Cell[21703, 766, 508, 17, 70, "Input",
 CellID->321749489],
Cell[22214, 785, 213, 7, 36, "Output",
 CellID->72276847]
}, Open  ]],
Cell[22442, 795, 125, 3, 70, "ExampleDelimiter",
 CellID->123465073],
Cell[22570, 800, 202, 7, 70, "ExampleText",
 CellID->18274992],
Cell[CellGroupData[{
Cell[22797, 811, 169, 5, 70, "Input",
 CellID->156899339],
Cell[22969, 818, 294, 9, 50, "Output",
 CellID->833610216]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23312, 833, 235, 7, 70, "ExampleSection",
 CellID->9430481],
Cell[23550, 842, 376, 13, 70, "ExampleText",
 CellID->817758621],
Cell[CellGroupData[{
Cell[23951, 859, 149, 5, 70, "Input",
 CellID->286126246],
Cell[24103, 866, 195, 6, 36, "Output",
 CellID->35043275]
}, Open  ]],
Cell[24313, 875, 251, 8, 70, "ExampleText",
 CellID->74140771],
Cell[CellGroupData[{
Cell[24589, 887, 184, 6, 70, "Input",
 CellID->246688360],
Cell[24776, 895, 275, 10, 36, "Output",
 CellID->173325831]
}, Open  ]],
Cell[25066, 908, 366, 13, 70, "ExampleText",
 CellID->615168356],
Cell[CellGroupData[{
Cell[25457, 925, 108, 3, 70, "Input",
 CellID->71806121],
Cell[25568, 930, 310, 9, 36, "Output",
 CellID->267997713]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25927, 945, 226, 7, 70, "ExampleSection",
 CellID->22959],
Cell[26156, 954, 255, 8, 70, "ExampleText",
 CellID->306753271],
Cell[CellGroupData[{
Cell[26436, 966, 159, 5, 70, "Input",
 CellID->84542705],
Cell[26598, 973, 242, 8, 36, "Output",
 CellID->934029605]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26901, 988, 311, 9, 70, "SeeAlsoSection",
 CellID->30535],
Cell[27215, 999, 3379, 125, 70, "SeeAlso",
 CellID->30280]
}, Open  ]],
Cell[CellGroupData[{
Cell[30631, 1129, 314, 9, 70, "TutorialsSection",
 CellID->30983],
Cell[30948, 1140, 164, 3, 70, "Tutorials",
 CellID->8421],
Cell[31115, 1145, 143, 3, 70, "Tutorials",
 CellID->3341]
}, Open  ]],
Cell[CellGroupData[{
Cell[31295, 1153, 318, 9, 70, "MoreAboutSection",
 CellID->96644425],
Cell[31616, 1164, 147, 3, 70, "MoreAbout",
 CellID->381478982],
Cell[31766, 1169, 137, 3, 70, "MoreAbout",
 CellID->577279554]
}, Open  ]],
Cell[31918, 1175, 50, 0, 70, "History"],
Cell[31971, 1177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

