(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    300670,       7283]
NotebookOptionsPosition[    283055,       6714]
NotebookOutlinePosition[    284689,       6757]
CellTagsIndexPosition[    284551,       6751]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticK" :> Documentation`HelpLookup["paclet:ref/EllipticK"],
           "EllipticF" :> Documentation`HelpLookup["paclet:ref/EllipticF"], 
          "EllipticPi" :> Documentation`HelpLookup["paclet:ref/EllipticPi"], 
          "JacobiZeta" :> Documentation`HelpLookup["paclet:ref/JacobiZeta"], 
          "JacobiAmplitude" :> 
          Documentation`HelpLookup["paclet:ref/JacobiAmplitude"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EllipticK\"\>", 
       2->"\<\"EllipticF\"\>", 3->"\<\"EllipticPi\"\>", 
       4->"\<\"JacobiZeta\"\>", 
       5->"\<\"JacobiAmplitude\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Integrals\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticE", "ObjectName",
 CellID->20904],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticE",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticE"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the complete elliptic integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"E", "(", "m", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticE",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticE"], "[", 
       RowBox[{
        StyleBox["\[Phi]", "TR"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the elliptic integral of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{"E", "(", 
        RowBox[{
         RowBox[{"\[Phi]", "\[VerticalSeparator]"}], "m"}], ")"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22330]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Pi]"}], "/", "2"}], "<", "\[Phi]", "<", 
    RowBox[{"\[Pi]", "/", "2"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "(", 
     RowBox[{
      RowBox[{"\[Phi]", "\[VerticalSeparator]"}], "m"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"m", " \[InvisibleSpace]", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "\[Theta]", ")"}]}]}], ")"}], 
       RowBox[{"1", "/", "2"}]], 
      RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->30807],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "(", "m", ")"}], "=", 
    RowBox[{"E", "(", 
     RowBox[{
      FractionBox["\[Pi]", "2"], "\[VerticalSeparator]", "m"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->23992],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->3890],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"], "[", 
   RowBox[{"\[Phi]", ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity running along the ray from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["csc", "2"], "(", "\[Phi]", ")"}], TraditionalForm]], 
  "InlineMath"],
 " to infinity. "
}], "Notes",
 CellID->2528],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->393940049],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132328929],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->90550353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", "0.4", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1.3993921388974326`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65099449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", "m", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWGuIVVUU3t5zro/KmppxmtRyepBamUmWWFmJZUaYKZmVSt0u5kymo/NA
fFCTypSlWVpmRIllQY8fRmIEBpEQCZEQCVFBGIT9SIKkHwPB6Vtr733P3vus
e+fOIX80MPfudfZ3vr32Wt9a+5w7t9Tdtmxlqbu9XGq9q7O0uq293NU6u6MT
l6IhSqmD+O9qURgnGPH/wSTBd/ZzIj4LAERkRYSkq4qHo9y5op7TfyqcjSqz
qjDAXDMGdKkgzDFeTaDPOJ1Rqhh415RBDA3YLsgg4syVxjowzQFvlEEUqvgc
eiSvFtfpx5n1dVh90auZgXp8pjxSni88g57aNWQPozp9zx/LLFd2veo+FoN1
/8u821ofar6bzXcY00bnuvVSus/aumrdrtIQMO6rcXUkPvdXWEJMGI/QjgeJ
H6z9f+PXHbe//x9cOnXqb92FMlEdG9gXDzAf2mPY3vvWN6YhyKu8xvZPP/7R
3naAPBpWQZFq9Ozp0/2YPXHiTzVc5NjN9ob1nx358hcayqhX2f7wg+927fyK
hiO8lfTs54d/fqb3MA3PEjl2sX38+987Vn1C3p4tonayffLkX+XHPoLv6hxv
pcosOPDJ2s5yvBSgzhVROwLUeSLqxQDV4PkTzp6fpC3E/oXncBR0expuczJJ
PNx1M3fKWkztF5wIkzYb62Yh83k2jn79K+6myDfl8mEr2x8fON7TfYiyPCoX
y3NsQ2zbtx2hYXMulr7E1CrkDe2qFp2WKM2O7bD2vOiz+UQeUBDqIlETW9g+
9u1v0ChypkaLqM1OJCieYzzlbCIrhm/P9n2BTWIwVmTpdTz69NAP6hIR9bTN
nfFonLeWnn19z1HjSavIsZFt6AYrvbv/mLpMRG1w9g6lqctF1PrE9C+jxCs8
f9Y5e6Ied2VSu2rIlqpmLduIivFlvKiS8MkqZOlhEOKC6CAZGEyoW21kdtvY
L138Pj7VVeLd4dNqON9pvYALcARBuzoXz5rE9AB4Q3qZJLJkn2Bik5vVVpeQ
C9IDP65NalWNy7rKro18kIKuE7XxpN0pylsfTVNE3AonrlS913saeiITr6ki
SxvbqGUTjxtF1OPMBhJQoVlgMM1bjecj7MnkeLrIUmYW7B/bQvjg3E0irmR9
R+EDihtuEXGPJkbfixa+hz6ibk1TVbVO3G72CK+jTxWt7NtyaWqJkzFdajNz
8SxOTEc0GZ0lslgl0i7o8kNOVBEw5OYO8b6BToNFzIOugwTrqM/OtYuFNhpI
MTYCac1JwgqxvttM6Hv0zqEilNfdYsYXME53V73Xe0Tcfc5e0GKR4rki7t7E
6BqZg4jg67wKjvziu6ja0YZ1UuaLPOxFrJUIKDa/QMTxrmJ9DkFxWPh+b705
VpFwGqWGwQMiz53O/kCFgDwo4mbZ/WExvb+HRdxMR8HAYSNLkiq1lPkdxubw
dp4FBwIADsSKnm+W5tLiDJ9Lh1TXq9irY+Hcupk54AM8Qe4MR6kqh9slrD6n
OxzwA9Gh07oscrh16V6fJnIsGxTHDSLH8iSsq/BNOjJ8U8X720UtTBGxK0Ts
ZBG7UsRO8nNqsB0VLPl5TSbvhFkj8k1kLOY9jXSJ2PEWq/VtsD3e2vyUVURN
6Vox+l0r8vFTXRFHs8aiXgi7TsReyolFO0Wt6kN2o4gbxziUKGpfP14/lVSp
wSrnGT/7UhfCMlgMXaFXVNlAHXy0zQJa8fx572CP9H68KRdXi40qIg8unAmU
0S11c5HJbzdFRBDvz2lm+kSOahXU5EcXL+Nbq95fy+Y3WFK8G2b9ZpmpxIJK
nxsbfLWamG4XlTDSV5epgh0iln8lKOJEwXGh1UWxeVnEDre+46AFL+6gZ7VX
KtjKb3Gpnzhk6X17t8gXO3lBbo2fe1LsCPes0DHDaaXDr97w1vVjQ+9ob6Y8
dOZ4sdjr+2N2vc9jfFv0WWPUkH8BMduROQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83799854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", "m", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "-", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "m"}], "8"], "-", 
   FractionBox[
    RowBox[{"3", " ", "\[Pi]", " ", 
     SuperscriptBox["m", "2"]}], "128"], "-", 
   FractionBox[
    RowBox[{"5", " ", "\[Pi]", " ", 
     SuperscriptBox["m", "3"]}], "512"], "-", 
   FractionBox[
    RowBox[{"175", " ", "\[Pi]", " ", 
     SuperscriptBox["m", "4"]}], "32768"], "-", 
   FractionBox[
    RowBox[{"441", " ", "\[Pi]", " ", 
     SuperscriptBox["m", "5"]}], "131072"], "-", 
   FractionBox[
    RowBox[{"4851", " ", "\[Pi]", " ", 
     SuperscriptBox["m", "6"]}], "2097152"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "7"],
    SeriesData[$CellContext`m, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
   Rational[1, 2] Pi, Rational[-1, 8] Pi, Rational[-3, 128] Pi, 
    Rational[-5, 512] Pi, Rational[-175, 32768] Pi, Rational[-441, 131072] Pi,
     Rational[-4851, 2097152] Pi}, 0, 7, 1],
  Editable->False]], "Output",
 ImageSize->{398, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67936579]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Complete Elliptic Integral",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["Evaluate numerically for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"3", " ", "+", 
   RowBox[{"2.5", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"1.199748843334269`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.3570974376009497`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125198723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", "3", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"0.\
475223935351017111033159114045174347335840070473488654224902229572`49.\
778603616820504", "+", 
  RowBox[{
  "1.0130180585994313264785021093311517959519892703470189130711099435773`50.\
107322497811495", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->743551779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", "0.9999999999999999990000000000", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1.00000000000000001080411033563`10.976022181249927"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->927949733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Simple exact values are generated automatically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->831756529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237756324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"{", 
   RowBox[{"0.2", ",", "0.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.489035058095853`", ",", "1.3506438810476753`", ",", 
   RowBox[{"0.6383398696992949`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.5000739389294381`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{267, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49240088]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Find series expansions at branch points:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Arg", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         RowBox[{"x", "-", "1"}], "]"}], "2"],
       SeriesData[$CellContext`x, 1, {}, 1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 1, {Complex[0, 
         Rational[1, 2]] Pi}, 1, 2, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"Log", "[", "2", "]"}]}], "+", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], "]"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"x", "-", "1"}], "]"}], "2"],
      SeriesData[$CellContext`x, 1, {}, 0, 2, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 1, {
     1, Rational[1, 4] (1 + Complex[0, 1] Pi - 4 Log[2] + 
       Log[-1 + $CellContext`x])}, 0, 2, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{368, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39028302]
}, Open  ]],

Cell["Find limits at branch cuts:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{"2", "+", 
     RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"EllipticE", "[", "2", "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->330002990]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{"2", "+", 
     RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticE", "[", "2", "]"}], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["3", "4"], "]"}]}], 
   RowBox[{"2", " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "4"], "]"}]}]]}]], "Output",
 ImageSize->{203, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->61129470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136296941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->401032626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticE", "[", "m", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92735886],

Cell[BoxData[
 FormBox[
  RowBox[{"E", "(", "m", ")"}], TraditionalForm]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->305158101]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Incomplete Elliptic Integral",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["Evaluate numerically for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{
   RowBox[{"3", " ", "+", 
    RowBox[{"2.5", " ", "I"}]}], ",", " ", 
   RowBox[{"2.3", " ", "-", 
    RowBox[{"1.5", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"3.059693600321932`", "\[InvisibleSpace]", "+", 
  RowBox[{"11.16503469114871`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109556073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{"3", ",", " ", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"1.\
0574957523372342297158360184095304674660911744269599122831762913319`49.\
97119701756182", "+", 
  RowBox[{
  "1.1981402347355922074399224922803238782272126632156515582633200640254`50.\
025426038400155", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{379, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38913718]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"2", ",", "0.9999999999999999990000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1.09070257317431832590512329699`10.661350680291996"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142631710]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Simple exact values are generated automatically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"0", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1259479]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"\[Phi]", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["\[Phi]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->114099870]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{
   RowBox[{"Pi", "/", "2"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"EllipticE", "[", "m", "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->38351229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.5", ",", "1.8"}], "}"}], ",", "m"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{"0.2`", ",", "m"}], "]"}], ",", 
   RowBox[{"EllipticE", "[", 
    RowBox[{"0.5`", ",", "m"}], "]"}], ",", 
   RowBox[{"EllipticE", "[", 
    RowBox[{"1.8`", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{389, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160272690]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{"\[Phi]", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[Phi]", "-", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["\[Phi]", "3"]}], "6"], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "m"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["\[Phi]", "5"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", "m"}], "+", 
       RowBox[{"60", " ", 
        SuperscriptBox["m", "2"]}], "-", 
       RowBox[{"45", " ", 
        SuperscriptBox["m", "3"]}]}], ")"}], " ", 
     SuperscriptBox["\[Phi]", "7"]}], "5040"], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"64", " ", "m"}], "-", 
       RowBox[{"1008", " ", 
        SuperscriptBox["m", "2"]}], "+", 
       RowBox[{"2520", " ", 
        SuperscriptBox["m", "3"]}], "-", 
       RowBox[{"1575", " ", 
        SuperscriptBox["m", "4"]}]}], ")"}], " ", 
     SuperscriptBox["\[Phi]", "9"]}], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Phi]", "]"}], "11"],
    SeriesData[$CellContext`\[Phi], 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Phi], 0, {
   1, 0, Rational[-1, 6] $CellContext`m, 0, 
    Rational[1, 120] (4 $CellContext`m - 3 $CellContext`m^2), 0, 
    Rational[1, 5040] ((-16) $CellContext`m + 60 $CellContext`m^2 - 
     45 $CellContext`m^3), 0, 
    Rational[1, 362880] (64 $CellContext`m - 1008 $CellContext`m^2 + 
     2520 $CellContext`m^3 - 1575 $CellContext`m^4)}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{345, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221799532]
}, Open  ]],

Cell["Expand in series with respect to the modulus:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{"\[Phi]", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[Phi]", "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[Phi]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "\[Phi]"}], "]"}]}], ")"}], " ", "m"}], "+", 
   RowBox[{
    FractionBox["1", "256"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", "\[Phi]"}], "+", 
      RowBox[{"8", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "\[Phi]"}], "]"}]}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "\[Phi]"}], "]"}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "3"],
    SeriesData[$CellContext`m, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 
   0, {$CellContext`\[Phi], 
    Rational[1, 8] ((-2) $CellContext`\[Phi] + Sin[2 $CellContext`\[Phi]]), 
    Rational[1, 256] ((-12) $CellContext`\[Phi] + 
     8 Sin[2 $CellContext`\[Phi]] - Sin[4 $CellContext`\[Phi]])}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{439, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->912709894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting: "
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticE", "[", 
   RowBox[{"\[Phi]", ",", "m"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"E", "(", 
   RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->412374123]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"m", "+", 
   FractionBox[
    SuperscriptBox["m", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["m", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "m", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "-", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "m"}], "8"], "-", 
   FractionBox[
    RowBox[{"11", " ", "\[Pi]", " ", 
     SuperscriptBox["m", "2"]}], "128"], "-", 
   FractionBox[
    RowBox[{"115", " ", "\[Pi]", " ", 
     SuperscriptBox["m", "3"]}], "1536"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "4"],
    SeriesData[$CellContext`m, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
   Rational[1, 2] Pi, Rational[-1, 8] Pi, Rational[-11, 128] Pi, 
    Rational[-115, 1536] Pi}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{219, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144975190]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["x", "3"], "3"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[1, 2]}, 1, 3, 1],
  Editable->False]], "Output",
 ImageSize->{87, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->389580017]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Compute elliptic integrals:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", 
   SqrtBox[
    RowBox[{" ", 
     RowBox[{
      SuperscriptBox["x", "3"], "-", "1"}]}]], 
   RowBox[{"\[DifferentialD]", " ", "x"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"7", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "3"]}]]}]], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "3"]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox["3", 
       RowBox[{"3", "/", "4"}]], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"5", "/", "6"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], " ", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["3"], " ", 
         RowBox[{"EllipticE", "[", 
          RowBox[{
           RowBox[{"ArcSin", "[", 
            FractionBox[
             SqrtBox[
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], 
                 RowBox[{"5", "/", "6"}]]}], "-", 
               RowBox[{"\[ImaginaryI]", " ", "x"}]}]], 
             SuperscriptBox["3", 
              RowBox[{"1", "/", "4"}]]], "]"}], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"1", "/", "3"}]]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"5", "/", "6"}]], " ", 
         RowBox[{"EllipticF", "[", 
          RowBox[{
           RowBox[{"ArcSin", "[", 
            FractionBox[
             SqrtBox[
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], 
                 RowBox[{"5", "/", "6"}]]}], "-", 
               RowBox[{"\[ImaginaryI]", " ", "x"}]}]], 
             SuperscriptBox["3", 
              RowBox[{"1", "/", "4"}]]], "]"}], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"1", "/", "3"}]]}], "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{451, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141842212]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"JacobiDN", "[", 
     RowBox[{"t", ",", "m"}], "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], " ", 
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], 
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"m", " ", 
     SuperscriptBox[
      RowBox[{"JacobiSN", "[", 
       RowBox[{"z", ",", "m"}], "]"}], "2"]}]}]]]], "Output",
 ImageSize->{346, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->671846524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot an incomplete elliptic integral over the complex plane:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1007514127]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Perimeter length of an ellipse:", "ExampleText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "t_", "]"}], ":=", 
   RowBox[{"a", " ", 
    RowBox[{"Cos", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "t_", "]"}], ":=", 
   RowBox[{"b", " ", 
    RowBox[{"Sin", "[", "t", "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"a", ">", "0"}], "&&", 
     RowBox[{"b", ">", "0"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"4", " ", "a", " ", 
  RowBox[{"EllipticE", "[", 
   RowBox[{"1", "-", 
    FractionBox[
     SuperscriptBox["b", "2"], 
     SuperscriptBox["a", "2"]]}], "]"}]}]], "Output",
 ImageSize->{138, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->798377476]
}, Open  ]],

Cell["Series expansion for almost equal axes lengths:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWktPFEEQbrZnHzG8BFTASCAejF58gCBG48HAmhhPKKBy2RATUIkGuehJ
4x/wH6z/Qb3KwR/WTs90sb3f1uwUOw9Idmaru7oeX1dV18zyrHW09+agdbS/
25pvHrY+7u3vfppf/3AYDukhpSqPlVJXp1X43YTfog/9rYWfDslR/8JrNVyi
w7sO73VHrzpaO7ri7jVv3l9HfFVHVx29wsixdADyXkXWfAMr7tpRfeJRtFpV
fQ+V09U7usqOBhkkPhCt5UdrsFazXCsim3nrtEjD6+j+9RReL2dA7CG3Fm30
6BorRYY753+N0BsQad6eRqnIWhsCAZac7YEYPVlekEwZetpxJ1nWDzHi4TAK
KJ/Y3NOublAV6skcxIyVUgnv90SYoMyIK+jQSbtPlfNOgq0ybbwHmAsvonGq
rjx2bDR6dMN0Krk/jjUaLcTKFyT4K6v1KM23kuY56bdYafKo5zzwkbB8m6Z/
PGvKnD4VcBTopRR0eYtHgEtWadIrg6WHTZyBtzMgyo+i78/74PnIxDlKuKLH
S85K7fioLxlj+Px52tuaGx8G7xc9Pm7diBvfMn7GbYGUDaB33KptsC6OKKxD
l4H+DvQG0DuMVEvecFrn3P1cpA0j9ArQ9vIXxuaAbsR+aeee/ao6vR7bqfQ5
ybhzpScnOhXXaTmfoK0O9A+gfwGNe9JVYXq0jido7UbEmIReSNg5oA88VwO4
+KwbY0cR86yo8RbKqsWoaG2MMKLKn3XRaM8ZXWVnZCjSepmfXdz6+PjYZcly
lCrtdtvx0VNTbUC+Zkl8WXaXsOA7GX6XueeGAPKCyxOcl+3tuOH72LPMibEE
m2J82Arat4oMipY9NzDnRkR+lYceZ+OwaHWMJtdz03lWV/GZX1cJvWnQwS8+
k7ju1F5+i/3pljmeIDP9xLnJasTuwl7+yG3z6BmgMWsj/pNntsUez2aBfwFo
tPR6yvz9gudnvJ2gmKs4P6hX7PX/M4xiv3UtZR67w7znm6zVb2E0W092KVdp
08Y7UQrrI0kLxS/7hm9g6RRLuhDpuKdD9qLeGS7L8+wipwvXgDVD9u60SAtk
b2yKR7l8O9Y8WlEUqvfGlNBhz5SiJW2vIStLsoJ7X1W8FXzUnY0tNvKoeip1
4M3KYzyp658tTJphIqhWqDZ6Q5/vcxEfCcXoemqkOzz4k4pkx/ORbgaMgPy0
8+gX+yTo9zpl647jx3Y+2Z7gqAuczEWS9ecijHMdYDZN1FtOcRLYCpxdn09P
sHqK0k64Rr1v/NSV+uyLFi+IVqHmSRG+k2cuG3/P4lflqWE9un8xuIdpNXHh
1CusfRXV+b+TqVQJljNwnvm/9FxIXYkxOmG6fyNKl4C/ucU4/QSuJ0Bvwqpt
Z/lL40d+G7iaQBM3vm9DmrcJnyxfMjZqT0sshWIm/p8kNfQfVCE9qQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{579, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->829018473]
}, Open  ]],

Cell["Compare with an approximation by Ramanujan:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Pi", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "a"}], " ", "+", " ", 
       RowBox[{"3", "b"}], " ", "-", " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"3", "b"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"3", "a"}]}], ")"}]}], "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "a", ",", "6"}], "}"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{"a", ">", "0"}]}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", "a", " ", "\[Pi]"}], "+", 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", "a"}], ")"}]}], "+", 
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "-", "a"}], ")"}], "2"]}], 
    RowBox[{"8", " ", "a"}]], "-", 
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "-", "a"}], ")"}], "3"]}], 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"]}]], "+", 
   FractionBox[
    RowBox[{"17", " ", "\[Pi]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "-", "a"}], ")"}], "4"]}], 
    RowBox[{"512", " ", 
     SuperscriptBox["a", "3"]}]], "-", 
   FractionBox[
    RowBox[{"19", " ", "\[Pi]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "-", "a"}], ")"}], "5"]}], 
    RowBox[{"1024", " ", 
     SuperscriptBox["a", "4"]}]], "+", 
   FractionBox[
    RowBox[{"177", " ", "\[Pi]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "-", "a"}], ")"}], "6"]}], 
    RowBox[{"16384", " ", 
     SuperscriptBox["a", "5"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"b", "-", "a"}], "]"}], "7"],
    SeriesData[$CellContext`b, $CellContext`a, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`b, $CellContext`a, {
   2 $CellContext`a Pi, Pi, Rational[1, 8] $CellContext`a^(-1) Pi, 
    Rational[-1, 16] $CellContext`a^(-2) Pi, 
    Rational[17, 512] $CellContext`a^(-3) Pi, 
    Rational[-19, 1024] $CellContext`a^(-4) Pi, 
    Rational[177, 16384] $CellContext`a^(-5) Pi}, 0, 7, 1],
  Editable->False]], "Output",
 ImageSize->{344, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->360560084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Arc length of a hyperbola as a function of the angle of a point on the \
hyperbola:\
\>", "ExampleText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "[", "t_", "]"}], ":=", 
  RowBox[{"a", " ", 
   RowBox[{"Cosh", "[", "t", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", "[", "t_", "]"}], ":=", 
  RowBox[{"b", " ", 
   RowBox[{"Sinh", "[", "t", "]"}]}]}]}], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"a", " "}], "b"], 
       RowBox[{"Tan", "[", "\[Phi]", "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"a", ">", "0"}], "&&", 
     RowBox[{"b", ">", "0"}], "&&", 
     RowBox[{
      RowBox[{"b", "^", "2"}], ">", 
      RowBox[{
       RowBox[{"a", "^", "2"}], 
       RowBox[{
        RowBox[{"Tan", "[", "\[Phi]", "]"}], "^", "2"}]}]}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", "b", " ", 
  RowBox[{"EllipticE", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox[
        RowBox[{"2", " ", "b"}], 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Tan", "[", "\[Phi]", "]"}]}]}]]}], "]"}]}], ",", 
    RowBox[{"1", "+", 
     FractionBox[
      SuperscriptBox["a", "2"], 
      SuperscriptBox["b", "2"]]}]}], "]"}]}]], "Output",
 ImageSize->{328, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11954532]
}, Open  ]],

Cell["Plot the arc length as a function of the angle:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "->", "2"}], ",", 
      RowBox[{"b", "->", "2"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->281280869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Vector potential of a ring current in cylindrical coordinates: \
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"z", "^", "2"}], " ", "+", " ", 
         RowBox[{"r", "^", "2"}], " ", "+", " ", 
         RowBox[{"R", "^", "2"}], " ", "-", " ", 
         RowBox[{"2", "r", " ", "R", " ", 
          RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}]}], "]"}]}], ",", "\n", 
      "                                ", 
      RowBox[{"{", 
       RowBox[{"\[CurlyPhi]", ",", " ", "0", ",", " ", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
      RowBox[{"GenerateConditions", " ", "->", " ", "False"}]}], "]"}], " ", "//",
     "FunctionExpand"}], "//", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"#", ",", 
      RowBox[{
       RowBox[{"r", ">", "0"}], "&&", 
       RowBox[{"R", ">", "0"}], "&&", 
       RowBox[{"z", ">", "0"}]}]}], "]"}], "&"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"2", " ", "r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], " ", 
        RowBox[{"EllipticE", "[", 
         FractionBox[
          RowBox[{"4", " ", "r", " ", "R"}], 
          RowBox[{
           SuperscriptBox["r", "2"], "+", 
           RowBox[{"2", " ", "r", " ", "R"}], "+", 
           SuperscriptBox["R", "2"], "+", 
           SuperscriptBox["z", "2"]}]], "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          SuperscriptBox["R", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], " ", 
        RowBox[{"EllipticK", "[", 
         FractionBox[
          RowBox[{"4", " ", "r", " ", "R"}], 
          RowBox[{
           SuperscriptBox["r", "2"], "+", 
           RowBox[{"2", " ", "r", " ", "R"}], "+", 
           SuperscriptBox["R", "2"], "+", 
           SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"r", " ", "R", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["r", "2"], "+", 
       RowBox[{"2", " ", "r", " ", "R"}], "+", 
       SuperscriptBox["R", "2"], "+", 
       SuperscriptBox["z", "2"]}]]}], ")"}]}]}]], "Output",
 ImageSize->{495, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->824640827]
}, Open  ]],

Cell["The vertical and radial components of the magnetic field: ", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bz", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "r"}], " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"r", " ", "A"}], ",", " ", "r"}], "]"}]}], " ", "//", 
   "Simplify"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "-", 
          SuperscriptBox["R", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}]}], " ", 
       RowBox[{"EllipticE", "[", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", "R"}], 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"2", " ", "r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"], "+", 
          SuperscriptBox["z", "2"]}]], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "-", 
         RowBox[{"2", " ", "r", " ", "R"}], "+", 
         SuperscriptBox["R", "2"], "+", 
         SuperscriptBox["z", "2"]}], ")"}], " ", 
       RowBox[{"EllipticK", "[", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", "R"}], 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"2", " ", "r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"], "+", 
          SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"R", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["r", "2"], "-", 
      RowBox[{"2", " ", "r", " ", "R"}], "+", 
      SuperscriptBox["R", "2"], "+", 
      SuperscriptBox["z", "2"]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["r", "2"], "+", 
      RowBox[{"2", " ", "r", " ", "R"}], "+", 
      SuperscriptBox["R", "2"], "+", 
      SuperscriptBox["z", "2"]}]]}], ")"}]}]], "Output",
 ImageSize->{370, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1316141]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Br", " ", "=", " ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"A", ",", " ", "z"}], "]"}]}], " ", "//", 
   "Simplify"}]}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", "z", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "+", 
         SuperscriptBox["R", "2"], "+", 
         SuperscriptBox["z", "2"]}], ")"}], " ", 
       RowBox[{"EllipticE", "[", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", "R"}], 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"2", " ", "r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"], "+", 
          SuperscriptBox["z", "2"]}]], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "-", 
         RowBox[{"2", " ", "r", " ", "R"}], "+", 
         SuperscriptBox["R", "2"], "+", 
         SuperscriptBox["z", "2"]}], ")"}], " ", 
       RowBox[{"EllipticK", "[", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", "R"}], 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          RowBox[{"2", " ", "r", " ", "R"}], "+", 
          SuperscriptBox["R", "2"], "+", 
          SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"r", " ", "R", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["r", "2"], "-", 
      RowBox[{"2", " ", "r", " ", "R"}], "+", 
      SuperscriptBox["R", "2"], "+", 
      SuperscriptBox["z", "2"]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["r", "2"], "+", 
      RowBox[{"2", " ", "r", " ", "R"}], "+", 
      SuperscriptBox["R", "2"], "+", 
      SuperscriptBox["z", "2"]}]]}], ")"}]}]], "Output",
 ImageSize->{370, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11750886]
}, Open  ]],

Cell["Plot magnitude of the magnetic field: ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"Br", "^", "2"}], " ", "+", " ", 
       RowBox[{"Bz", "^", "2"}]}], "]"}], "/.", 
     RowBox[{"R", "->", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}], ",", 
     RowBox[{"3", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{221, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->661454671]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Inductance of a solenoid of radius ",
 Cell[BoxData["r"], "InlineFormula"],
 " and length ",
 Cell[BoxData["a"], "InlineFormula"],
 " with fixed numbers of turns per unit length:"
}], "ExampleText",
 CellID->61793136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"2", 
   RowBox[{"r", "^", "2"}], " ", "a", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sinc", "[", 
        RowBox[{"x", "/", "2"}], "]"}], "^", "2"}], 
      RowBox[{"BesselI", "[", 
       RowBox[{"1", ",", 
        RowBox[{"x", " ", 
         RowBox[{"r", "/", "a"}]}]}], "]"}], "\n", "     ", 
      RowBox[{"BesselK", "[", 
       RowBox[{"1", ",", 
        RowBox[{"x", " ", 
         RowBox[{"r", "/", "a"}]}]}], "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"r", ">", "0"}], "&&", 
       RowBox[{"a", ">", "0"}]}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435554428],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "8"}], " ", 
     SuperscriptBox["r", "3"]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "-", 
       RowBox[{"4", " ", "a", " ", 
        SuperscriptBox["r", "2"]}]}], ")"}], " ", 
     RowBox[{"EllipticE", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["r", "2"]}], 
        SuperscriptBox["a", "2"]]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       RowBox[{"4", " ", "a", " ", 
        SuperscriptBox["r", "2"]}]}], ")"}], " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["r", "2"]}], 
        SuperscriptBox["a", "2"]]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{460, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->692244549]
}, Open  ]],

Cell["Inductance per unit length of the infinite solenoid:", "ExampleText",
 CellID->7243216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"%", "/", "a"}], ",", " ", 
   RowBox[{"a", "->", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1021045775],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  SuperscriptBox["r", "2"]}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->659927971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Calculate the surface area of a triaxial ellipsoid:", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"area", "[", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"m", "=", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], 
          RowBox[{
           SuperscriptBox["b", "2"], "(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}]]}], ",", 
        RowBox[{"\[Theta]", "=", 
         RowBox[{"ArcSin", "[", 
          SqrtBox[
           RowBox[{"1", "-", 
            FractionBox[
             SuperscriptBox["c", "2"], 
             SuperscriptBox["a", "2"]]}]], "]"}]}]}], "}"}], ",", 
      RowBox[{"2", " ", "\[Pi]", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"b", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}]], " ", 
          RowBox[{"EllipticE", "[", 
           RowBox[{"\[Theta]", ",", "m"}], "]"}]}], "+", 
         RowBox[{
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"], " "}], 
           SqrtBox[
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["c", "2"]}]]], 
          RowBox[{"EllipticF", "[", 
           RowBox[{"\[Theta]", ",", "m"}], "]"}]}]}], ")"}]}]}], "]"}], "/;", 
    
    RowBox[{"a", ">", "b", ">", "c"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:="],

Cell["The area of an ellipsoid with half axes 3, 2, 1:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "2", ",", "1."}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["48.88214630258205`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70462622]
}, Open  ]],

Cell["\<\
Calculate the area by integrating the differential surface elements:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], 
      SqrtBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], 
         SuperscriptBox["c", "2"], 
         SuperscriptBox[
          RowBox[{"Cos", "[", "\[Phi]", "]"}], "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], 
         SuperscriptBox["c", "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], 
         SuperscriptBox["b", "2"], 
         SuperscriptBox[
          RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]}]]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "->", "3"}], ",", 
       RowBox[{"b", "->", "2"}], ",", 
       RowBox[{"c", "->", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["48.8821738213866`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25021637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Parametrization of a mylar balloon (two flat sheets of plastic sewn together \
at their circumference and then inflated):\
\>", "ExampleText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"Cos", "[", "v", "]"}], 
   SqrtBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"2", "u"}], "]"}]]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"Sin", "[", "v", "]"}], 
   SqrtBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"2", "u"}], "]"}]]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  RowBox[{
   SqrtBox["2"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"ArcSin", "[", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], 
          RowBox[{"Sinh", "[", "u", "]"}]}], 
         SqrtBox[
          RowBox[{"Cosh", "[", 
           RowBox[{"2", "u"}], "]"}]]], "]"}], ",", 
       FractionBox["1", "2"]}], "]"}], "-", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"EllipticF", "[", 
       RowBox[{
        RowBox[{"ArcSin", "[", 
         FractionBox[
          RowBox[{
           SqrtBox["2"], 
           RowBox[{"Sinh", "[", "u", "]"}]}], 
          SqrtBox[
           RowBox[{"Cosh", "[", 
            RowBox[{"2", "u"}], "]"}]]], "]"}], ",", 
        FractionBox["1", "2"]}], "]"}]}]}], ")"}]}]}]}], "Input",
 CellLabel->"In[1]:="],

Cell["Plot the resulting balloon:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", 
     RowBox[{"y", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", 
     RowBox[{"z", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 270},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3608936]
}, Open  ]],

Cell["Calculate the ratio of the main curvatures:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"h", ",", "g"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "u_", "]"}], "=", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"u", ",", "v"}], "]"}], "/", 
      RowBox[{"Cos", "[", "v", "]"}]}]}], ";", 
    RowBox[{
     RowBox[{"g", "[", "u_", "]"}], "=", 
     RowBox[{"z", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], ";", "\n", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"g", "''"}], "[", "u", "]"}], 
          RowBox[{
           RowBox[{"h", "'"}], "[", "u", "]"}]}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"g", "'"}], "[", "u", "]"}], 
          RowBox[{
           RowBox[{"h", "''"}], "[", "u", "]"}]}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             RowBox[{"g", "'"}], "[", "u", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             RowBox[{"h", "'"}], "[", "u", "]"}], "2"]}], ")"}], 
         RowBox[{"3", "/", "2"}]]], ")"}], 
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         RowBox[{"g", "'"}], "[", "u", "]"}], 
        RowBox[{
         RowBox[{"h", "[", "u", "]"}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{
             RowBox[{"g", "'"}], "[", "u", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             RowBox[{"h", "'"}], "[", "u", "]"}], "2"]}]]}]], ")"}]], "//", 
     "Simplify"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->825254769]
}, Open  ]],

Cell["\<\
Express the radius of the original sheets in terms of the radius of the \
inflated balloon:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"h", ",", "g"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "u_", "]"}], "=", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"u", ",", "v"}], "]"}], "/", 
      RowBox[{"Cos", "[", "v", "]"}]}]}], ";", 
    RowBox[{
     RowBox[{"g", "[", "u_", "]"}], "=", 
     RowBox[{"z", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], ";", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"h", "'"}], "[", "u", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"g", "'"}], "[", "u", "]"}], "2"]}]], "//", "Simplify"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["5", "4"], "]"}]}], 
  RowBox[{"Gamma", "[", 
   FractionBox["3", "4"], "]"}]]], "Output",
 ImageSize->{96, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->52205740]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:="],

Cell[BoxData["1.3110287771460598`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->611001083]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Expand special cases:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticE", "[", 
   RowBox[{
    RowBox[{"ArcCsc", "[", 
     SqrtBox["m"], "]"}], ",", "m"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SqrtBox["m"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"EllipticE", "[", 
     FractionBox["1", "m"], "]"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox["1", "m"]}], ")"}], " ", 
     RowBox[{"EllipticK", "[", 
      FractionBox["1", "m"], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{290, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->730639201]
}, Open  ]],

Cell["Expand special cases under argument restrictions: ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticE", "[", 
   RowBox[{"z", ",", "1"}], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"z", ",", "1"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87782854]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"%", ",", 
   RowBox[{"0", "<", "z", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"Sin", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1520125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"EllipticE", "[", 
       RowBox[{"z", ",", "2"}], "]"}], "3"], "+", 
     RowBox[{"EllipticE", "[", 
      RowBox[{"z", ",", "2"}], "]"}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "I"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.18715821001635322`"}], "+", 
    RowBox[{"1.102055524871917`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485609629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integrals:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "\[Alpha]"], 
    RowBox[{"EllipticE", "[", "z", "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", " ", 
   SuperscriptBox["z", 
    RowBox[{"1", "+", "\[Alpha]"}]], " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"1", "+", "\[Alpha]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", "+", "\[Alpha]"}]}], "}"}], ",", "z"}], "]"}]}], 
  RowBox[{"2", "+", 
   RowBox[{"2", " ", "\[Alpha]"}]}]]], "Output",
 ImageSize->{357, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->712053030]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], 
    RowBox[{"EllipticE", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], " ", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox["m"], " ", 
         RowBox[{"Sin", "[", "z", "]"}]}], 
        SqrtBox[
         RowBox[{"2", "-", "m", "+", 
          RowBox[{"m", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"2", " ", "z"}], "]"}]}]}]]], "]"}]}], 
     SqrtBox["m"]], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Cos", "[", "z", "]"}], " ", 
     RowBox[{"EllipticE", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"4", "-", 
       RowBox[{"2", " ", "m"}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "z"}], "]"}]}]}]], " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{554, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->552817087]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{" ", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "z"}], "]"}], 
      RowBox[{"EllipticE", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", "z"}], "m"]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], 
   RowBox[{"m", " ", 
    SqrtBox[
     RowBox[{"2", "-", "m", "+", 
      RowBox[{"m", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}]]}]]}]], "Output",
 ImageSize->{189, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->570512160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Laplace transforms:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", " ", 
   RowBox[{"HypergeometricU", "[", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", "0", ",", "s"}], "]"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["s", 
    RowBox[{"3", "/", "2"}]]}]]], "Output",
 ImageSize->{193, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35488196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Limits on branch cuts:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Pi", "/", "2"}], "+", 
      RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], ",", "2"}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"EllipticE", "[", "2", "]"}]}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607755148]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Pi", "/", "2"}], "+", 
      RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], ",", "2"}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"+", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"EllipticE", "[", "2", "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20895226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " is automatically returned as a special case for some special functions:  "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", "z"}], "]"}], ",", 
   RowBox[{"MeijerG", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "2"], ",", 
         FractionBox["3", "2"]}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"{", "0", "}"}]}], "}"}], ",", 
     RowBox[{"-", "z"}]}], "]"}], ",", 
   RowBox[{"MeijerG", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         FractionBox["1", "2"]}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", "z"}], "]"}], ",", 
   RowBox[{"EllipticPi", "[", 
    RowBox[{"z", ",", 
     FractionBox["\[Pi]", "2"], ",", "z"}], "]"}], ",", 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", "z"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"EllipticE", "[", "z", "]"}]}], "\[Pi]"], ",", 
   RowBox[{
    RowBox[{"-", "4"}], " ", 
    RowBox[{"EllipticE", "[", "z", "]"}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]", " ", 
      RowBox[{"EllipticE", "[", 
       RowBox[{"1", "-", "z"}], "]"}]}], 
     SqrtBox["z"]]}], ",", 
   FractionBox[
    RowBox[{"EllipticE", "[", "z", "]"}], 
    RowBox[{"1", "-", "z"}]], ",", 
   RowBox[{"EllipticE", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{572, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->825022367]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4682],

Cell["\<\
The defining integral converges only under additional conditions:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "z"], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"m", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[LessEqual]", 
       "1"}], "||", 
      RowBox[{
       RowBox[{"Im", "[", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[NotEqual]", 
       "0"}]}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Csc", "[", "z", "]"}], "2"], "m"], "]"}], 
       "\[GreaterEqual]", "1"}], "||", 
      RowBox[{
       RowBox[{"Re", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Csc", "[", "z", "]"}], "2"], "m"], "]"}], "\[LessEqual]", 
       "0"}], "||", 
      RowBox[{
       RowBox[{"Im", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Csc", "[", "z", "]"}], "2"], "m"], "]"}], "\[NotEqual]", 
       "0"}]}], ")"}], "&&", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"m", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], "\[NotEqual]", "m"}]}], ",", 
   RowBox[{"EllipticE", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           RowBox[{"m", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[Equal]", "0"}],
          "&&", 
         RowBox[{
          RowBox[{"Re", "[", 
           RowBox[{"m", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], ">", "1"}]}], 
        ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"Csc", "[", "z", "]"}], "2"], "m"], "]"}], "\[Equal]", 
          "0"}], "&&", 
         RowBox[{"0", "<", 
          RowBox[{"Re", "[", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"Csc", "[", "z", "]"}], "2"], "m"], "]"}], "<", "1"}]}], 
        ")"}], "||", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"m", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "z"}], "]"}]}]}], "\[Equal]", "m"}]}]}]}], 
    "]"}]}], "]"}]], "Output",
 ImageSize->{503, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44111451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Different conventions exist for the second argument:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"k", "^", "2"}], " ", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], "^", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
   RowBox[{"GenerateConditions", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"z", ",", 
   SuperscriptBox["k", "2"]}], "]"}]], "Output",
 ImageSize->{112, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129664509]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"m", " ", 
         RowBox[{"t", "^", "2"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"t", "^", "2"}]}], ")"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
    RowBox[{"GenerateConditions", "->", "False"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"#", ",", 
     RowBox[{
      RowBox[{"0", "<", "m", "<", "1"}], "&&", 
      RowBox[{"0", "<", "z", "<", "1"}]}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "z", "]"}], ",", "m"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->306266697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["In traditional form the vertical separator must be used:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"E", "(", 
   RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"\[Phi]", ",", "m"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91088429]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Nested derivatives and integrals:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"EllipticE", "[", 
     RowBox[{"x", ",", "m"}], "]"}], ",", "4"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"E", "(", 
     RowBox[{"x", "\[VerticalSeparator]", "m"}], ")"}], ",", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       RowBox[{
        SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}]], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"cos", "(", "x", ")"}], " ", 
       RowBox[{"sin", "(", "x", ")"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"m", " ", 
         RowBox[{
          SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}]]]}], ",", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["cos", "2"], "(", "x", ")"}]}], 
       SqrtBox[
        RowBox[{"1", "-", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}]]]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["m", "2"], " ", 
       RowBox[{
        SuperscriptBox["sin", "2"], "(", "x", ")"}], " ", 
       RowBox[{
        SuperscriptBox["cos", "2"], "(", "x", ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], "+", 
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{
        SuperscriptBox["sin", "2"], "(", "x", ")"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"m", " ", 
         RowBox[{
          SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}]]]}], ",", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"], " ", 
        RowBox[{"sin", "(", "x", ")"}], " ", 
        RowBox[{
         SuperscriptBox["cos", "3"], "(", "x", ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"m", " ", 
           RowBox[{
            SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]]}], "-", 
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["m", "3"], " ", 
       RowBox[{
        SuperscriptBox["sin", "3"], "(", "x", ")"}], " ", 
       RowBox[{
        SuperscriptBox["cos", "3"], "(", "x", ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}], ")"}], 
       RowBox[{"5", "/", "2"}]]], "+", 
     FractionBox[
      RowBox[{"4", " ", "m", " ", 
       RowBox[{"sin", "(", "x", ")"}], " ", 
       RowBox[{"cos", "(", "x", ")"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"m", " ", 
         RowBox[{
          SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}]]], "+", 
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{
        SuperscriptBox["sin", "3"], "(", "x", ")"}], " ", 
       RowBox[{"cos", "(", "x", ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]]}]}], "}"}], TraditionalForm]], "Output",
 ImageSize->{540, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->26767970]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
     RowBox[{"EllipticE", "[", "x", "]"}], ",", "6"}], "]"}], "//", 
   "FunctionExpand"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"E", "(", "x", ")"}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["2", "3"], " ", "x", " ", 
      RowBox[{"E", "(", "x", ")"}]}], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"E", "(", "x", ")"}]}], "3"], "+", 
     RowBox[{
      FractionBox["2", "3"], " ", "x", " ", 
      RowBox[{"K", "(", "x", ")"}]}], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"K", "(", "x", ")"}]}], "3"]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["4", "15"], " ", 
      RowBox[{"E", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{
      FractionBox["8", "15"], " ", 
      RowBox[{"K", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{
      FractionBox["28", "45"], " ", 
      RowBox[{"E", "(", "x", ")"}], " ", "x"}], "-", 
     RowBox[{
      FractionBox["32", "45"], " ", 
      RowBox[{"K", "(", "x", ")"}], " ", "x"}], "-", 
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"E", "(", "x", ")"}]}], "45"], "+", 
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"K", "(", "x", ")"}]}], "45"]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["8", "105"], " ", 
      RowBox[{"E", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{
      FractionBox["8", "35"], " ", 
      RowBox[{"K", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "3"]}], "+", 
     FractionBox[
      RowBox[{"464", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "1575"], "-", 
     FractionBox[
      RowBox[{"592", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "1575"], "-", 
     RowBox[{
      FractionBox["88", "525"], " ", 
      RowBox[{"E", "(", "x", ")"}], " ", "x"}], "+", 
     FractionBox[
      RowBox[{"296", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", "x"}], "1575"], "+", 
     FractionBox[
      RowBox[{"64", " ", 
       RowBox[{"E", "(", "x", ")"}]}], "1575"], "-", 
     FractionBox[
      RowBox[{"64", " ", 
       RowBox[{"K", "(", "x", ")"}]}], "1575"]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["16", "945"], " ", 
      RowBox[{"E", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{
      FractionBox["64", "945"], " ", 
      RowBox[{"K", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "4"]}], "+", 
     FractionBox[
      RowBox[{"3104", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "3"]}], "33075"], "-", 
     FractionBox[
      RowBox[{"4352", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "3"]}], "33075"], "-", 
     FractionBox[
      RowBox[{"176", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "2205"], "+", 
     FractionBox[
      RowBox[{"1088", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "11025"], "+", 
     FractionBox[
      RowBox[{"256", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", "x"}], "6615"], "-", 
     FractionBox[
      RowBox[{"1408", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", "x"}], "33075"], "-", 
     FractionBox[
      RowBox[{"256", " ", 
       RowBox[{"E", "(", "x", ")"}]}], "33075"], "+", 
     FractionBox[
      RowBox[{"256", " ", 
       RowBox[{"K", "(", "x", ")"}]}], "33075"]}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"32", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "5"]}], "10395"], "+", 
     FractionBox[
      RowBox[{"32", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "5"]}], "2079"], "+", 
     FractionBox[
      RowBox[{"73888", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "4"]}], "3274425"], "-", 
     FractionBox[
      RowBox[{"112544", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "4"]}], "3274425"], "-", 
     FractionBox[
      RowBox[{"11936", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "3"]}], "467775"], "+", 
     FractionBox[
      RowBox[{"112544", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "3"]}], "3274425"], "+", 
     FractionBox[
      RowBox[{"6752", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "363825"], "-", 
     FractionBox[
      RowBox[{"24224", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "1091475"], "-", 
     FractionBox[
      RowBox[{"4864", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", "x"}], "654885"], "+", 
     FractionBox[
      RowBox[{"26368", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", "x"}], "3274425"], "+", 
     FractionBox[
      RowBox[{"4096", " ", 
       RowBox[{"E", "(", "x", ")"}]}], "3274425"], "-", 
     FractionBox[
      RowBox[{"4096", " ", 
       RowBox[{"K", "(", "x", ")"}]}], "3274425"]}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"64", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "6"]}], "135135"], "+", 
     FractionBox[
      RowBox[{"128", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "6"]}], "45045"], "+", 
     FractionBox[
      RowBox[{"2042048", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "5"]}], "468242775"], "-", 
     FractionBox[
      RowBox[{"3349504", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "5"]}], "468242775"], "-", 
     FractionBox[
      RowBox[{"319936", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "4"]}], "52026975"], "+", 
     FractionBox[
      RowBox[{"837376", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "4"]}], "93648555"], "+", 
     FractionBox[
      RowBox[{"2792512", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "3"]}], "468242775"], "-", 
     FractionBox[
      RowBox[{"514048", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "3"]}], "66891825"], "-", 
     FractionBox[
      RowBox[{"1677184", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "468242775"], "+", 
     FractionBox[
      RowBox[{"1954688", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "468242775"], "+", 
     FractionBox[
      RowBox[{"188416", " ", 
       RowBox[{"E", "(", "x", ")"}], " ", "x"}], "156080925"], "-", 
     FractionBox[
      RowBox[{"606208", " ", 
       RowBox[{"K", "(", "x", ")"}], " ", "x"}], "468242775"], "-", 
     FractionBox[
      RowBox[{"16384", " ", 
       RowBox[{"E", "(", "x", ")"}]}], "93648555"], "+", 
     FractionBox[
      RowBox[{"16384", " ", 
       RowBox[{"K", "(", "x", ")"}]}], "93648555"]}]}], "}"}], 
  TraditionalForm]], "Output",
 ImageSize->{560, 361},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->112878226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{"Abs", "[", 
        RowBox[{"EllipticE", "[", 
         RowBox[{
          RowBox[{"x", " ", "y"}], ",", "0.3"}], "]"}], "]"}], "]"}], ",", 
      "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "50"}], ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy9VF2S5iAIhL3JXmmPMFX7PPd/26pJQP5a0f0SY5Q0DWoEfn99//n6RUR/
75dfaSQPDdGgDl+KwPBeicahaHyQkTOHE4cAR5bcmfeNfpZEI1TsUX/WI5mg
dKZS18K8Fu28LRIli2gfvZVwi6QLmBOGzq7vqgfD3JlEQY1mZY2WjmgkDhx4
PixdjHSiUQQQ0EFKIFWG/Jwr5UfERmXLvC2y34+fhhC3XZsle5lkP1PpXHlL
zBrYj31pXkq+6ligc5ERqnmpSfsEkmD/Joitr6axOVo1cH+Yu5ErCp1DP6OQ
3DvpnACuGImZTCKDfAHIKVWkX5WRMzepOkzqRlNTuKMXnuXGGidZH3D2O1u3
1aCuYmQZbk1ijvdW+GtfW6M05dOhchfLzfUC+HonKmTJyToaRPOm3tD0PObM
GKjFjp3enr9ILG5waFz8HXBG/Iyk4kgb5igQEqCi9oEqgm+MWtMmlLJc3SZw
l+/2kzaIvncJ97KPDhrPzYnGtGWo6amdVuimhRQD6gtHFgr5twTpZ2u7FnpA
elCSu3EXFcYCWqs9xJr8Zi5BKROElMhyJI5LIp4qWiSrKOqA/SDwgfDS0zvt
rZO8cSdvRNcrefJGxr9Su+JKa+HMwhzNHHWGblrEi1pN5rJ3DEfgPTbYHKJR
BgLwvwRXH+LnAu7yTSPcGLWmjalvaSOEBKiofdybMfv6oKQijTpmRJ6JGxxJ
HQl91uzEQC2u7VhrQJi4ntp6QxuyfQEcrPuW5vB24NOhcmcvDHWa97X1HWds
hdV8QLx2o1NH3qWW9QEUDlRQAGwUubp9/knLu+3iA040hTv8mx3kpgKauvEh
sQ4mqphleHmgGf5nlOtKCKWp7Lo7LN1ca1Zvgvja9YLlYbGM7M8i6bj+P3l0
LjJC3Y099mUDDkrnyluyeUV+GkKgAbNkb8sKLBegbmyT/U7K51xJepK0AQh0
kBKgsSIceD4sXUh8jDXtp0GzskaBI8nL3Nn1XfVgSKI6gTpwixQXoCHM3xaJ
vAXruQhLZyp1LfdXjlCxR5VA25n3jUbiuCSy+QQ4nDgEOLEC5FqxIwLDV9o/
rPoXOA==
   "], {{0, 0}, {101, 101}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{225, Automatic}]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94702447]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  ButtonBox["EllipticE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticE"]], "InlineFormula"],
 " through an analytically continued Taylor series"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalF]", "[", 
   RowBox[{"n_", ",", " ", "z_"}], "]"}], "=", 
  RowBox[{
   FractionBox["\[Pi]", "2"], "  ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "n"], 
    FractionBox[
     RowBox[{
      RowBox[{"Pochhammer", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], ",", "k"}], "]"}], " ", 
      RowBox[{"Pochhammer", "[", 
       RowBox[{
        FractionBox["1", "2"], ",", "k"}], "]"}], " ", 
      SuperscriptBox["z", "k"]}], 
     SuperscriptBox[
      RowBox[{"k", "!"}], "2"]]}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"EllipticE", "[", "z", "]"}]}], "\[Pi]"], "+", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         RowBox[{"2", "+", "n"}], "]"}], "2"]}]], 
     RowBox[{
      SuperscriptBox["z", 
       RowBox[{"1", "+", "n"}]], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox["1", "2"], "+", "n"}], "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox["3", "2"], "+", "n"}], "]"}], " ", 
      RowBox[{"HypergeometricPFQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           FractionBox["1", "2"], "+", "n"}], ",", 
          RowBox[{
           FractionBox["3", "2"], "+", "n"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "+", "n"}], ",", 
          RowBox[{"2", "+", "n"}]}], "}"}], ",", "z"}], "]"}]}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{576, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->537159832]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticE", "[", 
  RowBox[{"0.6", "-", 
   RowBox[{"0.2", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"1.3069676448295744`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.10688905716405181`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40019402]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "@", 
      RowBox[{"\[ScriptCapitalF]", "[", 
       RowBox[{"n", ",", 
        RowBox[{"0.6", "-", 
         RowBox[{"0.2", "I"}]}]}], "]"}]}], ",", 
     RowBox[{"Im", "@", 
      RowBox[{"\[ScriptCapitalF]", "[", 
       RowBox[{"n", ",", 
        RowBox[{"0.6", "-", 
         RowBox[{"0.2", "I"}]}]}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWE1IVFEUvr6f0VQqQiTcJJRZLdvURhKkQqKkhbQIFyrBuEjLxo1BBIFt
DPpBUBAFNaOUUBRLGsgcLKdsBFEKDWwk0YUSKAZDwuu7PzPz5s51NEXJ9PE8
7537zvnOd86998x7Xix0Oa9dL3SVFBemny8vvOEsKb6Vfq6sHEN6HCHEj79H
BwnuLdyxP79l4RotT0HqMDiCq4FrhtCP0af0xmIHe05Vk3mdVjwN6kThnSHp
mZKuKVFX8zosOMvR1GhHFZw1qPZxyv34utBkrhkCPVNc1XWjGRAjrKvrHsSx
jxuh2QvmELyqZi/43Iia//2SpS/GaDLkKAbjwjYOqO67TY25lX1Vz765fcuB
35rka66iO/7SfqP6TounhWdrDx8NLP762uPFtNXnVHQ4Hw41vKbrPl7yS93m
ddm7xfi2OttGdVb32dHvqHKPq64u62Z7UTVKP9zinvZNYCZImuRxSdLlTiPr
6rhsNo258R/YlN7a7q7SGg2blDhw46luAxmsABDAfn2j9Kd7nSSBH4zGOgbg
gA0OZywZngPukQ/R6OoxEAR2PKFOJV4K08EHRlODX4QfCgEcnOCmAZcYzXl3
+EhvZYNBbUxYc2xOlzQp8Q+xfJfmF7jhZP8I9wZHjse5E5NG0Tl/nERngpeE
OjggEgBAdKQisO+FItIeetKWCTNkgtcohMBQkRSi0YCJEClsDBkLuzQqdD4N
FCJbiqqe13yIFGaJmkcg8fmhQbJZJCDHRIrV6TdzlNZw+J9itMtzPaO8tfFD
t1lQPfTGE+0V8bYj/+bI7w6b6UNVla1p2d7YVsGVbYxVKxVv2d7EdsQ62eX5
v/MUnxXikPfjyntJtmTbJGJ/qXfJ5vqF+8JW87P3CYcVqwtt7/Wy83hmsaeB
wPKwbxonMSGSGxuGiP6g2lNW2oWTpFKhF1x9fiarDicpoEKHkUBUv8WdoMKc
mVngyDiftgwTjWHfruwV2BrDvpzXLLB1Js7m1IvnJgTn09kxJjimUqH7/T9F
pCJl/HQqEkKZIThg7lf1ARCpaDSOeSW/lcfBWVfrFew8/ZMiksYizc8vCcwa
ZST2nRTPI4ViICVkwfMzgY0Hr3q+wgK8SasSh33XJnKQClfPhdxGXoeQK4i8
VHoeYLlOjM8hSzggN+7mHZxaXAx0K332UeEAmyeP36MOxUXtYIkgvUpr9tXl
ABimAeXD2fZiBJPrjlhNSWzOQROxgYklRLN9q0RMYLaoGoBgCw+gk3dKW/7N
iGxgCLpw8ijtWE8y8BiRUUEQGVDa8S4H+iXODiREPljh5qf6tWC6oufxt0vU
HdWDJIOWqssq/+8RpSM7sKE18K4dJT6k4wACNhayJx/XjEBVlgFiU89PSk/D
svV8k4+juPBBDcnQij5ROv2tQRiszrHR2c+8srHeQbEkadeQOhniWtH9jTeE
DfdsEvcH9lemEA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->298457742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Riemann surface of ",
 Cell[BoxData[
  RowBox[{" ", "EllipticE"}]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Im", "[", 
          RowBox[{
           RowBox[{"EllipticE", "[", 
            RowBox[{"x", "+", 
             RowBox[{"I", " ", "y"}]}], "]"}], "+", 
           RowBox[{"j", " ", "2", " ", "I", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"EllipticK", "[", 
               RowBox[{"1", "-", 
                RowBox[{"(", 
                 RowBox[{"x", " ", "+", " ", 
                  RowBox[{"I", " ", "y"}]}], ")"}]}], "]"}], "-", " ", 
              RowBox[{"EllipticE", "[", 
               RowBox[{"1", "-", 
                RowBox[{"(", 
                 RowBox[{"x", " ", "+", " ", 
                  RowBox[{"I", " ", "y"}]}], ")"}]}], "]"}]}], ")"}]}]}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "##"}], "}"}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"Opacity", "[", "0.6", "]"}], "}"}], "}"}]}], ",", 
      RowBox[{"Mesh", "->", "False"}], ",", 
      RowBox[{"BoxRatios", "->", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
      RowBox[{"MaxRecursion", "->", "5"}], ",", 
      RowBox[{"PlotRange", " ", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}]}], "]"}], "&"}], "@@@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", 
        RowBox[{"10", "^", 
         RowBox[{"-", "6"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "6"}]}], ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9nQd4HNd17yczuwuQItXtWJaLYj3bSZwwiZO4pH5J/OIWt5fml8SxZUuy
5VgxLSmyLVkSbUWyeltxSJDovZEgKtF7x2IBLACiEiAWAFEWBEiKIMV7Pn7v
nXPuvbOLwVJk8r3v4buY3dmdcs/v/M+5Z8rufumeR75334P3PPLAd+6567MP
3bP3ew985+G7/vqHD+FL1q8YhlGB/0PvMfD5/8Fn/F9x5coVfCNm+i2cevCt
r/LcPTS1cJbn9KvfjnmVnn6FX/2O69Uvx331FpzQrGHdd9996rVPOns2PNEl
DV7W5GXlPE1NXO1TTt/o3ZvVo5cenXf3qv0k8P7lvnCq9vXvap2dvE+nJ/jk
E/z+vzm9jO55x1WWfUBt6yaa8zrvq/39IS/zXbXMLe+wzL1qn7fF9Jgtds1/
3PGBqTsYw/dm19KWa/73eO0/V2t/UD2+57rW+rNtHrpT9fm9ruU9rvnfvcr6
d8TxsHtbXtf871xlW+9WfbnrGn252vq3q77cfY3977nK+req9T98XetrD9ys
em26/Pgh11o+1/xv81a+orbym653E1zzv8VL/43a129d19JfiOMb95qJrvmP
8aKfU2v+3nUt/T9Vr37f9e4O1zzbaPyV2vYnXO/udM3/Bi/9F2ppN133vuKv
/YErMhe+T/Xwj1xL3eCa/3Ve64Mx+zJUbFAf/tS19C7X/Ed5+TvUPt1xrdUd
640/ua4t/pprS7ep/vyla+ndrvmPxF1b5+TPXNfaRHBrlNys7PuM3q5cRWbP
mPU/7LDUuZUeP3slRpNXWfN/8Jp7YtYwfPhk30v24jnAJvfpzpNyrY8pyp/T
vVOrWDyJLu3eJ+cMVg3t8/Pq0Xdda31E7fMLrn06aytvu3vMGYL7Tfv6onrc
odeSlsoRJ2Yt9ievGy8u/lq9fsN1beWDqud/4+o5r+2Ra8sNuNfnHG28X+3t
S+rxxtPu9W51rcexxaMOLf9lvd/TZ4FW5fVpdMVH2eL1XW7jParvzjZ+/qKN
mzFuPq0sVxsweT5KyO1DVjhHp6nrI90j3JoH175h6RyY/62t6hEpNuY1K5M2
by2dBdw6NuOmJbWHJbkH6xp7eL+zB70UKS2WKG7bMHFya8yW+emS3nx8Xb4v
uuVo5OPbWqHeONv0LL1zb2O26XWWUn3+vO7zkuyzBye3ubZv4sRaOv+O+7hz
GxF66q6+PqOsSHDvBTfuc+3hxuvag7vW0mMWMt6ApQ22iZgl4F52LSsH4J7I
9oRr2PTeuHt0V0R/7nh9A7AhrQ3w4R7JKzfiHq3l88rO83HtdO/1Dt7rba69
uiuYP7milbyBvpF7ZNuWuRm0Z4/eMz7SUxMnnv/W3t01Do/lHsdmbJ4l+qc+
LJ+N7YPP1QcvTsxr9OE9cfvgrn8+qQiQo71LROEsmLjzm3CvCa69ynnarYy6
/94eP6HfX1SePk3cN4DinMwmexNde5bzV7f1V+Pu2V29/b729uI6uPeaSJRX
zsGOla173nGNPb877p7dtRxXoZQ1cM+ynV6PWu7F/XvJatz/Tto/jT/4KJu7
B+6Ilj2gUYoWctdfugbx4D7RyesgA9ogX6PKNoCEpgRnLpP9FN2r52D1PDUj
ASemZiI7ZHhw4rsGl3dxr4gDCdzj4uOu1D52ReebBQ1IeYl7LXMQdZg8tiyJ
YZfPwQo37BHGKXZ616rqqeq9D3vqvUZPOTOpOjpaMbt77KbO1TmZtnAGqK2D
J05/KYsRZI+rvyZOEuL018KJF/tsXVefvVfi1+nueffaH1G0Ley4V/Xaq3pq
cU9Xzrp7utvVU6/qqXmNnnJkKH+7R7TovHv8vlv10JxfA+olyvcMOLFDMuZM
ubzBucpcoX+MH+znja5+mtTP1bewr2+RB966Wu66vn7GrUHp/fAaYOP+Gp6F
NZCqwE5biq+5tM4jDPXZIPmuOA0pU8+pp7siSgTSAO59Ivbew72/OuVbnWjb
eqTjVoL7vM4HnLibXYW5yHXYYHK+Qp2skE5WzwKlCjpSoIkVOQdoARmxO6Ly
GM2/RW0n2mFdw45bnFg0VQzS47tcS+na2/COL8HUMpxcgdmYvltO3zGHnAHK
I1gEr8OSbtoG1g2aQH03ses3R5R2ZIfRnLdgR5xeu3OB7PUtLtbuXnNNkIjv
h+ZhZAHGFmFiCaaXYYbJU8/NBe49M188IzOg4Y3tOWduUpC1skHaWaX6GCeU
+7xoAVE3uetRK3w4IQ0ZbEb8evnmuBa827WUPsIwdgbnYDAMwwswugjjp2Fy
GabRB2yItsPj2KHUYy2tywS+zI0HH0zc2o4YK3xohW8NLVl7a5s1iThJcFnj
VlF8a341TsRzjumZAWNnYBYG5mAoHHXNFLvmFAuLJGWRlhw7lte1HSYrCSNi
ldSE2TJCajoPO9EC79rW3nvk5IIKCWwessW7egHwUTYC7PbPTXEtcp8x1Weh
jZvQP2hQ3wz0nITeGZDGoe5G0bjTW3RHAWO6rfM41nGkS9u4KohwQ03hMeUa
eUnZh4/0lDyWiOb50KB3ivMb49pzh2up3dqeW1Bp6JrBOQieImPQpO6TZB7O
kg7ntQ7ZMNRhOCKtMqzFNSea4lpHnjM8qxtKgtjYf2vn2H8JLvs8axfYPq/L
PndGkPbd7LLvTtdSXHP8Kr6PXUfNoXPQErRzIMZOdGDfLM1KaZ5gO0maK3CK
7UQrF9dkpsPK4wzIdGGYbpWineaq9mTkrPYk5T0LraV485yhf9SkY/UFwGb4
cJJwHVbvjmv1+1xLJWqv/iqagVJEe9AqtC2kje/X0u1xpBvekjJlpnkHy83l
dZlgVrgZZDnlSTNyljO9Fy32UHyixQlosXnmgrT4jLQ4ESc+tNhzDR3vciwm
iz7geterMwzq0pxaAuN27L50NJkbI2gnUvu1ubjM+CLgSie1oM1F1jPayc2w
lJ3kWRKwFWObYaFxZ7gZFk7MdbRzHe1cJ3vQSGkqP9W2WtfwbtTW2KXcNpvK
ZgtNNd6Hhk9xm2Q/K9vnycBYkXdPq2BG/w+H4YS2HUU+twrzEZBRjFYvnZGV
lMturjzWuBkWT86c0/abpGq034f2e9aVn/GRnnrRft9V7Ofo9DjnpfAvvr75
XJ66Jmfwn4Wmsv274tofDfJZCMyAiZ43dkd1Ps86P806X4lGuDTe0NZzBbDK
jdWNo8oGUFhz8yAD8wz9k93Sdq/Ldgsn5P8EtN+L9psu+7ma9NqvviaNkhSu
EuP6HLmFXTfRUHQ/DzMEwVH/uynYF3Wwh2FoDgZORYN9u/onY9QvCZiEwIsI
lnWj6LYouiNSCdryxHVSPeWxDTmkUj3Jzvnsg7bBp98NHxLwKAXEI0Bni+hq
Lr8Gmxe0vrflcJUXtkaFrKtH2eCk/EbDRDaGZ5wTODYEZBKeOxyNYJvYGiNb
8oOMkVl6cTgmP8wsU4ygRk5TLtzOZz3Kh7IfDmFnVaQoUiiEc4C01ilXkFaw
24l5AyJWKz6lFU3K4GCR1RdV6XyJQJ0hhgsXtp3di09JX7k1fCiIUdkY16H8
xqvQes/VaMVGVO9JohVgWiiykTCMLeiI0mKykBTHkQcJrepQIko8Oq5xM8xY
RjEqupH4eOR1kY0LgC1BEfLGIUQgnPMJiIefXhch59q0Z5jHDNksNFkr65BS
lomoOPFMcItG3Y5JjjqVerZGncG5ZyeSwpdC20UVIVGZmpRFpBgWIkJWCMjH
R2EII29Q5HPDJ8ZNWj2SjuHBCSnIVHw8zOfo8cYjxxvZ/VE25/W4ue3KqHP9
7T166QeftLFkMEyaeIbno3w8xMcj4Yyx6UzH49BBJJYcj09zRtLxtiUj6Xhz
K2hFKYhjzbd8RkWZA4dO85lIwMwfEBbrJE+Twbab3slVfOiRkgTysTY2MUNv
IqNNzGGbstRERLKZka2ZyXIRc5/X3hlXTe/S9QgGi+FFe5GcbEjPsK5KjpL5
1fJUWOcpjry+kzSWR/U0v0VP86wnwiavIn9hr61iykuyIVj53BAZEXKgGQk8
nxcUJDV8Snw9uSoG8VGC9CmGFjK0SqobsRTYBDrYukB1rism/1sE9f0VhvVv
T9h45EEgLZyYIfqfBxNBWk6EOhwxMJEkUbQmWX0kPo7OmyYWSVqxoaly2LTK
YbGRaUhtDUpAkhVCInqWo7b8AUUN2058xUdwfA4niersJhAtixRXSqSOVTci
NRIeQTMj9E+J3yGmk/s59/l8SepGFyl9jd4aQDJIyoOUrBDhknLTijPRMvME
0ZKoyEpT07oRaTmam+RYJVjz7jyGpJhMVhBVkj0gcqSZblKoGdYZZSqpM8uJ
00Hhi9EYrZ0QE6W8NZ6X7M5SgG4QrLLqxlJuhqmUR9FrIT+Dh4EYdtuuR8Qn
d5OjMTyKH+BmmDQhlIPcDKLpIc1JjDr3Ge9IMzGWZmzmI3bGDcm9IqVXpPaJ
9IDICIjMfpEZFNlBkROM5WnFoUjRaCmKNBiYCJFoeV25zqFIOzzHFLGVEzvE
aCk9bmHokfoj5b119vr47XL4PfAzGxEGCR1OPHEYWi6Go7EMvYfyFENsE0RS
R7BEqOrJrH6R0S/S+9G2tIAwdqf0iWTmmBaDEpXp6FIOlwYR02OnbEjUMPWr
jmbzFHmVE/E1lCgK/QY9yuZpskGpz4rqxgpiimy98Zhaz7xmGzH3E16T6E5F
1NM/B14k6UWSW2LaM8wnYUa4WZqfJ5Yfa+zWkhPiyKgoHBZ5QyJnkARG6AIC
wSGw5D6twL6oApGcmUOW5soqYyCG0RZy3nxSHv0PCh3XpMQop6B4pSpsmC/j
xEJVSxEaJk6IlUfnwy2snv0vskpQNa0ZOAVmYA4sZOZz1DfI5031qBGfHY4b
C7rWlOdJyiZExaSomBLlE6JsXJSOCeRYPCoKJMeB+Bwd+WWw/Awzm/QhJego
zXIockB7YhiaMQz5+ZO5IcN6KjekxmCpR4SJSAiph/V3ba6YFzcBsa6e21zd
ZEPdV0t3OGRNVR3KeO7DYyFuhg8n1yRrDfPRNK/K6iscEcUj4s2GcMmYODYu
JNbK7VhDUawY1hzViSmM1Ynqrdr0ONpU/HTNJ1ssVcPnim1F1/C8Uhl5o3jK
Lp1GxPyK99Xj4VewVYWRLN9pQYQ9Eq9sbr40dhs+CRcpY5OI3dqVhBOuRO9a
dl/1olkvAk8k3FY/jrRz1AyvIm4icEyhfMpcNumjrz1K8ZI7RAGLkw/lhyjc
FfYTCjsCR+wVEvu4UFkhRAwVdpZyWmxKiJFydkwylaOQ5BXLvEAlS1OO6tGx
ylF9kBKpmv9l4dTh6khafcQwnyKVI3O5iEHql1VmUMjmzdFeuAiymWcvbvGC
yfX7L2O8YJIb3uE+FOkPfnX79bvoK04k9M7SWWFs6KNZMJWfzH7yVfAUuEY9
2oCZi1kRU67xQXyCnpEt1jtHT4gS7R3MNZWT9AS9g6/jAjJnZ8d4JyVeotE1
WFANdIapfLAlu+Bz03ke5OeG57XSOf+RqZTj4Sel/j3xyRPF84wdM4xkb25c
lOXYum7kBYOSDTohcu6Ck81lNOg8fd0ecF8RpiXQBbLtQA9o+maQ/jHr80HN
3/7YdkgjPPTBEOWKQRr6ZCOv8Ku/lseeKBoRfvTEKHkC0ZfLDBXXE4OUg2SQ
qNzkeKLfXXHkD8bUabKG09kdh83BaDKiiLBexWTu81fMv1E6l127nNuylte2
hj6xuKoLqmqOHYIxHhSeq3jFQq+Y6xfp5NEmnOHW1h2IesMdE+6j/uv1iDqT
8pgt3cHBQT7xBDAylF/k8SaCzuFmeDlB5WnncHSYsf64Hf2B4wD5oz6MyQlH
jFh/yNRVwv6QwwX6I0P7w0SHGJ7YpMVR4XGiQvH3xMQBxwaRv+HVynA+5yZ8
BfPSC4VTWQ1rygs5IQ4Klxdo3syh//539gQlqOcwIs5e4KO8eF5wn7n7r3kB
53ukF3w4SaTchF7gO4ByQyLWAzvkEKEDgZ8y+fcjz0IH+wmFvXIyOmLEYqfh
op+Yq7InbtXN2PnAmIucgsGt9Y8eGV47jnXha1VhfWxIwZAgnZBcvUxOaF7L
a1l7IieE+tkeB1ZuP2bY+B6gDGWxBxC/Os42/x97wKOXQA/IRj7w9En+2MWQ
Vju5gWaJt4nO4GjwONHAr2K2Ro8Yd+BMAacm6ZBj7BBZOVWxQ5y85FSjGf1b
kpIs5p2xwZOtD4KU+rVPCpRPrFfJD/ikQI7i/Jr2xbOFUynVy9nsC4yJJ7Uv
towTJnrCg56wsnVmugTnLpE3cJKI7tjQDV3y/Ov2mXMXzlwEHRHWNfyRuKV2
ct8n5tRS0gWGhRMP+kFmIMwqudzYHXJe+iQh1hfeWF+QG8gfFCHGbY4/3tAB
oipZXVKpMlaOE4Okf5mXDJWVeqNHV3KsluGRP6CPSBE7RoJseU7FVMD+yN/i
D7tmGf2Ryv7IaSJ/2GVT2PlobHCplNPPY4SV3b/dG76zl5QrXmA/oEPMd/CF
+6y59MUulw8SXD4we2QM+BC3D7nvuLbu35+vIRdLyJj/NWTMRaVOFtKQ5WDs
OvB3alVH8JhgSN0yBWnmZoE8f0K1kLED8R2oZrA1lHRyGlnrrax1rom8xLZf
yMYJJyfIejfjEDYRsGFtXJJ83zJ4HPAg4rWLlIX+y5xNdTTBPJGlZprIiYWS
udSz553ZooYlW6x1jvHYWjGhBlaHbaEcWINb2DrZRLJ9mQ+RMGOwMrnoj8/W
2IVwC3hcRbQIOLVuLas+SvcpHlotJ5dovlTxJDJkgstoDYvgehDsC2/Y6+ff
QrhbqHKLUl3Z3HrO+Vrq1Xd1Gp5/fMzOQ31hI74h4cXHhFz61zTxMY9yuWKf
OyizBU3enceZ4o26MKI8ypm7TA+lmLyjaSIULexl2paUny8Pmy9UhmPztaRp
FqiTBQUqa2j1FpB6D9Qs43iZVLOcEcu3hfjyGSrKzTI7MF7UST/W9VK7Zha+
kOjoFxsy7urpjTKm3GDG0DUJ7rZPY+yMy9U5qq2ntOywxap4WMRmZm8MaV9M
xS7hWtvyc45aBIkPMvFaRRz5lo1xzcjDZZk+v+AQz0AtloWfKQv/sjwcWyeq
ol2OkESXiN9KI6Jusjqk56xoCf1wzUpGLUHPRug6HfPxq5XHsImN5J8b0LmD
asYEzZ7PyzL4l96wN86fN8wNUvr6JRoosXFmvshXB66L/pb3+Ay4i70HJ6Rs
D/L28oiYI/2ganRn3LPkIVSeyizWNt6qWBzjA1jUucN7RLxeG36lJvxiVRh5
u07LOufE8lQNqGl7t9DWuWVXAefmAzUrr5WFU2tWMhl3TgPj1kmaYMvzjQGR
g+OujysRHAORsJnZr84daMSUmrEuv6TwGsTXsCIX9bkb0+G8vBm9mvDOKuf5
hlkg2AlM/MnCkCLuxckOJGxdhTjODym1y6MinV/emzOkQiBXnnIdIrCK/CiT
HyPyh1vCSU1huzF8hEfH3JgaPV2eOsNxUZPPjVbfnLsLnUqQsopxk+MFu3oF
qXNmWUmtXUPw2XUEHvNLjlMJmkTeJ4VOCtci9/G4iDvNClDDOjQgLOwGe+Ls
+fMy0ZicYy7RTUExeTxCVbyq0tkPlvQDn5115XOuO7Z8kkDXj3zVFT3ic+nf
x7knd1jnHso55tU843V5wCDf8BhAzrpZ+aQmXMQ+sRvCB5vIFeXslrLY02w8
qppUku9Wgyn7JJuv9MhzZbL4lv4opNOW5I8bD9aSG14vm0+uWU3Xbsh23NC8
Zh+bylPjZkBGQU40z1AUmNkB4cPdmcz/Lx6wnUTv8PecuQSOC0x0gDOOKvTm
crRaoUjYEZe7c8SE3GVzZ/5EF31fPPohRd/nop+n6sdEZxbR42iLsqdwOCFM
DAkjoYyr8y3oSejEfkcmg8/mQsY5S0O8KR4KB2UtI/XP8WEifmPXcwVTB6tX
k2vXMlwOaKI0hA54Mjsk6WP2kQ7gGpzns7kZ5AUvhYIP3fDTrFBG70WZlJQf
KCEZFvpBOsEgLxjW6kVKSZyV+GgG3bAl61wrEpxjJvSF6fLFzlhfxB6jqtpH
1pM5+oiIM9NgbIWZNyTPH/jw5VeqwwVDdPKmmJ1hYu1j3FbKZSb645iu3PN1
3SMv4TnuyAmq8YAiQKUlzkc3H6hdPcgNnZBUs5qinZCFTuCBAJ2Q3URTdAL6
gJCYfPwjeXtJ9V4CziMQpR+q0zVxUv7aJZV2CDfTU8J3nx+LMna+RcRy1G5Y
PEHIEjGWAJj38+iYX9fq0bNfPl3pJOQORq+p5W09b3kTjqEyxRSFhFNSqkMj
RouzR/TpSb4Mb9yIAU95pZ/PwQSjCi8aEEWDOrsMCMRqHqxbNXY+Twl+NZnJ
Un6pI7JU0bDCPUyTlc05np56VD7hfO77aTZJOQOPEXi0IZFGszqzjVwitoRW
anjV0fDV+ca7Fuplvl9HuCEqz433qVMsPpmuYzjmqkxt+FCWVMMwxEKGaCJF
I1FBPKEPffQVUr62tBNBZverlqsTRQEDRIycJxIO1K0e1O2N8oXDtatptWuG
ieLEcY/lybUfTRKxOsxqWvMfncphAeJU0kxAkjQymll9SJPOFZBOexRNk3BS
PYc8sSHRM6RcJGpGLkmdRjg9bPu8Z3yOVLdQqW/9vEWY+5rRp081iyebxJON
SOsJnCQ+0SB+xu2xevFYnfhJrfhxrXi0Rpj/UY3vPnxcPFQlflQp9laIveVi
b5nYWyrwRR9f69iqb3m/gqSfP6S8kVCgnYA+ODpC4DFVGJwrbpReKBpW/svl
E+nSEVLJeQNqYDTRDazdhKTa1aS61eeKpg7VRg7XraVybpC3wVlSxdjkPQPe
Z4op38pkzAso9l7kbiJtw/pJVii9+2JGL/YoHSeetF6Rzo3sIz0nqFzBklb0
UdXuK31Xz8R87571V3vtV3sENsN8BSeel7vFvemh/2wTT7cJ8+lWfAUdtE+3
eJ4y0UWY0+rFT9FJdcpJBntpp9tLpeKhcvF4nfjPdvFKr+B7AnyqsudYQR/R
dSJOICpI6AjtiIoUL0UKB4tMNHxhz7hJuic3GL3agY7BkEjieMBpUv2qv2Lh
UF0kuS6iPJKpUzdj8ZFDvLEuocHRk0WeyGT9sydo4kEf/DhTOYd8Y6FreN11
HRZrl3R2Qaco4vH9stPlFzpDwHcyFY2DVTQGZuEYGDs/85D93azQa70C26u9
5Kz7M0LPtotn2gmkic4yEtBdv8DWSk16DKdG3Mi67XGMqQaBHvsJh9Wj7DH0
F3rr4SqxN8Zbj1aJpxrF813Cj4eqHULd8UKRpM6h8wFZPnuQ/IU5Cx3m+MtH
QSWdFaL38weduzMMn782YtdFDtZHkuoih+oj6B2+odZKr1vLqJOxQ0eM2jOy
ds+S8WKiUzyZyD7WIxweJnqDTnJyV1WWMjhPuT9z7It6YMsVVj5T6zk6AUd0
8xWTN8Yxtf31Q/YbAfE6tj7xWp9Ar/yyU/yyQ5jP0n87skafPN1OwWOYFEHo
E4ygVhU+OtcloEeeaKL2s0bheMMw0R/GbnTHj7U7YiPn4UqB677cI17vF48d
v6x8kT8odFajyU3oAkxb2Ir5uu4ReSaCD44xyeHQLdMeTv0YC+abdRETvWAk
oh/u0392xWJKXSStfi2tbo1o7NY+wDEWwWMjH3gd/j9B+F0X3fxTOFfhH7J3
f27GF1f9HkXfi/A9yN3wFk8Asv/swzY2Px1FvEHF7APZIZTk853UzOc6hYVO
MDzohmc6KCaeoZhAX3xAOkJGxtMcHD/XwfEUNoyKZu0D7YbHOCh+zGnskWrx
0HEVDj8qEz88cvaFLvF0w+WH8i7yHT7I20SOJuI0Eh3cWOdL6Dh9vWbFshsi
5oGGiMw6Sajzhohducjeu8XhilB7qdFCHpVXMBJ6xI8zQmmUm3FipeITX0qP
SOX2Z/fb+NzY/lnB+Gz1fUmekkm693oSkDE2fEqcP/+I/WZQyPZ9OpJ+oVtY
aK0XORsWIkbCzxJknJhIGRMm5x7ZJGeLtO6TWn9KE36iWZiI2PwZjehI+aHy
s4/xSIF8WeKXv/7zECt5V4G8shESr1Wv7K+PILcDjZGDjZGkpkhSMz1PatQU
GyIHGyhzsIHvJoq0CeSWwQgpT1sZPVGCnRcNCwmaiM0iaN4/vd9O7hHYMvv4
iPL69LlTZwfr2BSUcMMhaQrML/yHbXjsAbF/QPwgN/RSj/C+1C08LxLDbmEi
w4TniKOESGL1Ecxbn+kU2MvMHpHVI7Kx9YqcXnG4+WxOj8jF1ivy+0RBQBT1
ieKAOBIQJf3iG/8xwF585ME0w3r4B2kyYLmyMw83RQzP4eaIof/eu40MAWEU
SOLRjJDhwUeTiHiQBT5KLh6i4qrVrk1nt0OndBpKp6jhU0KEtL74qH0Ax+RB
8e95qC4c+294mRT+Uq9AWi9iB3a8qPyVwc2gzGJiRBi+rF4i48DJxQopD8fl
nQinEOH0i+J+cbRfHAuK0qAoGxDlA+K7jwzwvcesln0/SHviB2mP/yCNUXxA
M0EI2IgbBZgvrVs8mh5K6dhM7SYQKei35G7kcrhb/PF9Njacwz6BeV1sdrjY
6G+c9JZNg/mlH9uo4SGxNz/0KhpyM07MV3A8w354EICJ5lsoCjOLMKAupN1Y
1SKRfCSSWNDHmkCzg6IkSJaj2RUDQtr73YcGlP9pjx/SOUbai2ayXtBKw/sf
aaGULoGGYUODDTOZVPrH99qHuwQ2rDx7ADMRkN3bPhl3TZtv1xmn/CSu/eWf
2D8qCOHIaezAifU6nW1+rV/gaCFbOle6PYIcYaVjZ3ZkdFNouAKEBEBLkgJ8
FB6MAmPjaIBQMIEdFYOicpCAlPeLUmwBseevX9vzWf4g293Egw48kEBqFzVc
hUC0byICi3xuoe1/dK99qItDBXxIAeXYo6/iuD3ujWs9fdqcz/p95aeYGypm
AB8fKgxhHZVAA5mFT6ThXNonomu8aD1nrURpsGyUDnpFHjZUCRrMNdKNJSz2
cvZ6lTQVRRAgU4/1iZI+8b0f9qPN2v8J+AQ9ncLGPpIWSu7YJFeb5GQL7fz0
d+wkyu5p3UAWe9nirXnv2hbfqSuprz1my+Z9c4CPG33o3J1kHfrVg241M0l9
0spDzWdlaMtovb2gV+W7o5zv0H1lQVERFJXSULQSQ52tPNorSnrFC5mh5zNC
ez7zKu7413RsJ3eKZLaVLDTZkZ/6jn0Q3d2N6QgnZKnhRVPTdSNtuHUd307n
s32ebz5qpweEbL40OlYgl3KcYULpYaBqXvnXQ/5NyOS8I/9krs8jTVNs317Y
K470kfHH+jmfBcm5aHxlkNRMLu4js1/MDB3rFiXd4liPKO8Ve/6K7L+L7N+B
T36UEjrUtolbR6/uTQl98tv2gQ6R3AkU4WCmdKF3U7sAORAPzAXgJR4xNrqP
VuKTuEt7/F8ftX+RF8Lm0RRSuRk+nFDdkpAm85rhzeiO2n6wEbNaFmrhzmw5
4iGIHpHfIwp6BHIo7lMiQJeXswiqeIocXskOZdaslvYIhFDWI/BJSZeo6hP1
QbHnL182dJ6nQ9y9yaGDHQLtxx1+4h7be7gTLERhIQUzlf5J81utd5/BkNYn
uqzn7y9Eyw1v4YD4eW5INaqeEICXzCfTY/RgUW4jlfswECi9dYuDTWezOM+Z
2bSQGvm7RV63wEhACCaqwbgFFY+RgIaj+f680Bt5ITS2opdMrugT5T2iDJXQ
JUq7RXVANAZFGx0PYFffr7P/gXbxB9+y97fLsw1JHWAewv/DHWg3AknmhurA
iTelE5BNqmykDxcd952T2+lwnqXs/w2siyx5lZIuDlsIh4+WVQVCBa2XJlaq
VoU8R0WJAqOFhgGTJp70LnGg8axEphTTTSNCjhYNKqYII6dXHO2j3IB58PW8
0PF+cTxAjBDK8T5RqUmVdomSTlHRI+oConlA9AyL0Li8ceJOnUHeaBMH2ulT
8tbBdrCS2pmXhbxIOyYiogCifl/tflJJRX/3VfQ7eRFJ6yR84xGUDSIx96Fc
rH3ZIUXDTI3WZ5pGAqkmDXOY1244iyCwZXSJTMrfWTi5LadL5HSTZrARhh4K
nJcxQOpWURtVAVE7IGr6NYNesrsco4bWL8Wkn1DdK1qDom9YDI+J6ZMifErM
n5Lqea8eO/a3AjY6MmyFA21wsA1NRy4mcsHxowMOczNMxYc1lNqpNERqcEeU
R6pEPcTMxOiMeXmI1wTxwual+2M8+f0CgclGm0xA8XhwHDeJkW9/w9m0ToEt
o1NhIkomysW4I4fj6rnMUErNaglmDYwf5BIUtUEGxGpRgHoIEOoECVX1iOZ+
0RcSI2NiZlqEZyWf+TlBjO7QivE3w5vNxMjc3wImgjIPtCIJZIWkkrgdIlwE
ypPcoWIOQZlI6p3ug5WQ3N9E5b77j7/r1vMvj9gtE4ANn1h8Z3W/zDievH7x
VFYI25NZIS9WOr4UUlRKp3iz4Wxqp0hlZhhteHyH5IybEBxy+0V66On0UEGX
KOoSZZhrkA/KqJ9w1eJUS8qwkJmxuxLBIbIOiqvOQTE4KsYnxBxKakapCpmF
56S23qO15W8EbNhHfxNIhgYRxOMp1ForHGwluVlSae2O0pIpc0l+n77H3hZ9
klnce7dj5j+6jRlVV3T93kPXzzyI6slManQ0gLy4PiZwiC2FmUl4VioeEd+a
2i7S2kV6u9iXGvJXrOa0i9x2UdwtjvTQIF3WS+M0piDUGHKT0ViF+R3Dz7ih
plfU4rsIr10c76Z4DGA8joqZSRE+SZJDvaHoLAQ4P3c5HL7MDN+ts7u/Dvz1
1DhnIE5jJ9JElPuxtYDdEiWZ1Aaczdo5+zscVRTG1x5z3HYvB38XNo2wznje
PA7//LBNmtN3nDBGvhaJh2053AzrCTzwtJI1RcOkiZXSIfz1Z3GKT9upcGgX
T6aGXqtYzWwXWe0iH+mjDI1dKMQjWPjwmE9Ae1V+R6a1ARJefUCYDbjHW6p7
REWnKG0TDb2ie0gMhMTEmAhPK6BakJfn5y6F5y6GwxcMTZSODvzV4K9hVUq0
DSRSE6Eanjc1U4pxhGp4JFNSZyxVd6xuz37RJbZrlb+R+T713RMozuYJVD0C
NjyIGOHK5skLqLt5FFsqpL1YUP8sIyQbH8cd7qTDrrqzhzsEthcrVx9PDb1c
vprWJtLbRA75IBcnu/M6RX6nKOgURZ2iuEsc5eoSyysMblRqdR+xbaKzcJgP
jZ1NiBvf6BRlbaK6U7T1i94BMTLCmp0WJga94ZufvTx/6u35Uxfn5zbn596a
D5/n73NDyrKC9lcx4xpAzCZyZu1aiHk/a9cwETMxNpPaVPxzM9yE3defPTFQ
5Z97dLlb8XVeR8CE12waB/OfHrZZwUiXANPVdBIwkuZDFYLswerDfDw9ZHge
Twsh2sfSQi+Vr1rJbcLKIhFnd4gcbO20Nk7uyu8QhUi1UxzpoloVhxYchDFh
YvhLqm1B0dpPWq3uEhXtorRV1HWKjoAYGBITJ7RuZ8T8zOX52UtE9NSF+bnz
83Pn5uc27F8+TzxvR67y+zTu4+9eIB3XglQwk/UqsjolGA5br8OWyDp6dBNN
cFGk732hnOlUf0gPm2Hx5J8esuVtOEwQE4HMAQzQRJHSyQ2q5riOSUCCj6WG
UtoENkSYiY1OqGPwGx/JbhfZqFRuuW0ir10UtIuiDnGkkyq5Y500WmP2rOkR
9b0ChYlibOoVdXhM0C7KWkRVm2juFX0DYnREzE6K+Wkxf/Ly/MlL8zMX52cu
2M+8aj/zsv3MS/azL8zPrUEkApFV4nmbzq/SWlJqlfrUb+Kef7TV4LUVKWcE
LyKNivW6ab5PaXK3i6bJNBvH4H8/ZGMz1N0djDKbRt9sJUh11kAR9eIY/vzR
cKashUiUGe3CymijJ60is1VktVIN2SKMu3NaRV6bKGgTxe3iSLsoaadRvBxr
ny4alxr6SJotfaIBjy86REUrMW3sEl39YmhITI6J+Sliav9iv/203376tfmZ
8/OzZ/krVdZhNQKrqxBZhsgSRBZ53LpV10wOVxmFUqmMlybepFZwQMajaDkU
uVpV9Phb5TwYwpJe4zgQOsNCcmoE8khomhcfg5pUUHsymBjiSu8QFg7lJuZH
w5veKtJbdKMLahk4+VB2s8htEfltorCNmB1tF8eQWQcz6xFNyIyB1TCw0mZR
0y46+8R/Pmq/8jPbfsq29+1fmL4MS5dgaZO+aZi+p20dVtZgZRVWl2F1CVYX
IbJgQiTMWkBmhO2mrZq8EnMvoGd/E9jNpMODLfzNLO6sGOXl/pZHWuhd+vVG
hmZIag1j8PUf2diYmkW4duBBWEaXbp3iuaPhdCaWRvGaSvpKbRWpLdTwiAZZ
/QbNNIu0ZpHeJDKaRFazyGkReS2ioFUUt4qjbeJYO6E73iXquylUm7pFLc62
ivvvs++/1374B3YwKKZGBMwDLAhYvAyLl+D0Bf7ieeS2BsursLwMK0uwsgir
C7AahtU5WD0FkVlW3M3bFOf+1nl5vOZzsbldsbkjlg1iMWniQzYNJ6D+BPzj
XhvhZCk+HjycdxBRRW0kECLmg2UNAsJpCl0hTGkVVgpC+lhKs0hp4tYoUhtF
eiNRym4Suc0iv0UUtYijreJYq6hsFzWdYu+D9kMP2v/+ffv737Urm0VPNwwF
YGEULs4ChBGRgIW3YeEiLL5F3/9P3xoagaUVWFqC5dOwvADLYViZg5VZWJ2B
1ZOwOg2rk0zppm2U3N9hasWldLMaBd7vUBqTlBCQiXgMq36UGP3DXsxdSMjM
5BP8GhEfdRieXx4N04FIBzWTakAPMkpuFYdbqJnJzfjfhKySG4lSSoNIqRdp
DSKjQWQ1ipxGkdcoCprEN+61v32//d0HbNQPpqiRARgMQH8v9HbDQA/Mj8Cl
Gbh8CsScgDBS2oSF87C4wd8utwqnl2HpNCwtwFIYludgeRaWZ2B5GlamYGUS
ViZUlcy/E3EVRV2L1W6lKP7lDL47EUU0BvWKlAdJ1XH7hx/aDqvETD5fhKwQ
Eh7/0xGu5IRKMhJRRsgpmTkdbhKHsDWKQw3CPFQvjF8/VCcOc0uuE1/9lv23
37L/7h77H++x8+pFazd09UIgAKEgICmUUbAX+rqguwOmB2F1DCLjcH4aSV2C
8AWYPwcLG/xVfKuwuASLi3A6DEtzsDQLSydhaRqWp2B5ApbH0SpYGXMqWpW5
dm0j5v424vjEdipiH9GvS1wG80p0eGH7+x/aj2WE6EoqnW3slvkciUlcZqo6
uEhmWWFVjJHnPdRMvJIaxcEGcZCuwR+sE+YXvmkbH/nCv9pf/IZ9qFokV4vK
Nqhuh9p2aGiH1k7o6oFAH4T6IRSAAQTYBT0dEOqBk0FYGBabSOzUJZi7AOFz
ML9OX6O1sAwLi7A4D4tzsDgLp0/C6WlYmoSlCVgah6UxIrY8qs8U7Yqb492/
QxKfVoKi9ZtaX4iqnpOUBwkZntoRqBmBv/uhrRnRubZnmZHBhBKIEEM63CoO
tQgElNREXBqR54EG8fl77M990/7sv9rm/mphfLi4BY60wNEWKGmB0mYob4Gq
FqhphfpWaO2Ari6KvaE+ir3+Tuhrh65WGOmBpRFxGSnNXoJTb8HcWQiv8xcd
MqWFMCzMwsIMLE7D4iQsTsDpMVg6AUujVAM4o5dS1c5rqsqMy8lSOeu3t3Gy
iNOu2lGQqGqG4W//3f5JWghhKVRdFHp4qGoiJ+PjhzWppGbxhXvtz3/H/vy3
7c/dY++vE/trRVEbFLVCYQsUNkNhExQ1QXETHGmEkkYoa4LKJjjexKzaobuT
KAW7IdABPW3Q0wqj3bASAkBQM5dg9jyc2gAsT8OrEF6C8DzMz8H8DCxMw8Ik
LIzD4hgsnoBFogRLw/pbVm/YxsetI8nHqzlc0afkaJGPa2qSjuFmMwLVw1Ad
gh+nhdKQTQmz6dzC5kvftf/mfvuL99sHm8SBRjz8geJOKOqAonYobIOCFiho
hvwmyG+E/AYowFYPhXVwpB6O1UN5A1Q1Qn0LtLVBbycrqAOCHTDQDn0tsDAA
m+OwceLihcnzMLtO3wE+twxzp2EuDOFZCE/D/BTMT8DCGI2OCyOwOExsToec
K9dKQzu2MXJ/z3uUkbzCHX3nDxxCJ6AOCZlE6M+RUM1WQsdD8LUH7UeRExP6
yvftL2N7wP7S9+xDrJ6SPijpgaPdUKwJFbRDfivkt0BeM+Q2Qm4D5NRDTh3k
1kJuDeTXQFENHK2Fsjo43gCNTdDeSnhCXTDSBaFO6GmCsU5YCF5eGNh8Gwmd
XIeZCMwuw6kFmJuDuRmYm4bwBITHIHyCRsaFYVgIkXm7XXwSt/Fx33MSjTHS
HP/6IeUvBCIzM/IwLGRh/HE1A0EaVSH46ZuNX/2B/dV/s1EvyR2iLAhl/VAa
gGMBQBpHe6CYaRR1QoGmkdMMOY2Q3QBZ9ZBVB5k1kFkNmcchqwpyqqCgCoqP
w7FqqKqDhgboaIFgO4x1w4kuCDTDYAuMdry9NLAJSGN6HU6uwswSzM7D7Cyc
OglzkzA3DnMnIDwC4WGYH4KFIaJx4zVpuO8ekTTcdfYnHSoaSQ1SMYmK10XF
MCuHwPiDikEoHwDEUhqLpReO9EBRFxQwlvx2yEMsLZDVCJn1kF4H6TWQVg1p
VZBWCWnlkF4OWeWQWwGFFVBSBVXV0FgPXU0w1A6DrRBogs5aGGt/exWxjJ+D
yTP0HYcnF2EmDDMzMDsNsxNwagzmRmBuGMJDEB60n/w+ht7NLiq+66SSGKsR
j6QhUWwhMcwk9isSv++QIBiIIZZENxR2Qn4H5LVBriTRBBn1kFYLqdWQUgXJ
lZBcDsllkFwKqccgoxSySyG/FEoqoLoaWuooUDrqoL0GupFEK6wPvA1j52B8
jb/WfgGm5+DkDMxMwew4zI7C7DCcGoK5QQjzbRa3XpOD+3uUJYfYu2doO86v
4sTowkQYhlUdl4UjjFhVYLwUdpEq8tohpxWyJYsGSKuDlGo4XAlJFZBUBkml
kFQCSUfgcDGkHYHMI1BwDMrKobYKWmqgoxa6EUotBOog0i9g9ByMrcHEMkzO
w9QsTE/DyQmYOQEzIzAbgtlBOBWEuSDZoL9RP+GaDH6FrdafXfik1oK0XVv+
KRkSaHllCND0iiEodyIiyIYH4GgfHOmF4h42vJMNbyPDM5shvZEMT66Bw1Vw
sBzsUrCPgX0U7CI4UABJBZBcAOmFkH8ESkuhrpKsDtRDXy10VMJa4DIMn4PR
NRhfgokwTM7A1DRMj8P0KJwMwcwQzAZhtp/Gk7m+d7k04N1mv/veU2m/+9dG
+DdYrb/fa0sIRpTCMFGoclEYYAr9WyhgNBCFDqKQ1coUmiCtnigcOg4HK8Eu
gzdLwF8M/gJ4Mw/258KBHDiUA+n5kF8EZSXQVEmOD9RCZyXMtF4+G7gAIxE4
sQRjYZiYgclJmBqD6RGYHoKTAzDTD7MBptCrfx1iewS475iR1uvv93KUj1ZX
a6s/ETWZrXZMlr4nkwNwpI9NRt93Q34n5LazyS1sciMk18GhajJ5f7k2OR/8
OeDPAn8m7M+ApExIz4HCAqgqgbZK8np3JQSrLi92bF4eWoOR03BiDsanYWIC
JkZhKgTTAzAdhJMBmOkzDOMOl9et67TbdyX2V4GjGYArCZ/DARsxsBtNhGBY
jucNEykYvx3r+uJeBaGgC3LR9e1RCCn1cLgGDlaBXQ77HQhIIAP8aeBPBX8K
HEqHzGwozoeqI1BdDPVHRGvJ5dmWS+cDZyC0CCNzMDYN4+MwMQKTQzAVhOkA
TPfBTI9h6F/dfScK7rtqJAX3vST6u/I5Brx/t9eWCLA9ZmPmIwZelAIxYAwE
wUQIxm+U9GstMIYC1kJOB2khowXSmiClAQ7XQRJqoYIywJusfRJCOlov/Mng
T7rsT3o7KVVkZYqjeVBZIOqLL7cefXu0ZnOjax2GFmH4FIxOwdgYjA/DxCBM
9sNUH0z38JkA/Ws0nm2Wu++bkpbHXpWI9w0ivlgSPofEYwcaq3gkMBGD8bsV
moJKA0GthT4dEKiFTshGLbRCejOkYkDUQ1INJFXCgVJKg28Wgj+XISQLNN9v
X/K/uem3Lx48fCk34+2qgssNRW+3FF/qLb2w1h6BgUUIzcLIJIyOwlgIxgdg
IgCTPTDVTdE/0yl/5WHPR5+6qg7c9xRJGvrsrfsTKvzruHfjPJr++IHG4yMg
rVfpQFtfytaXBLdJgCMhqx3SWQLJjSSBg9VgYzo4BvtRAnmUBcj0g5f8/k3D
9L/+lnGL/80LyYc2j2Zdaiy61Fy42VJwYb09IgILMDgLoQkYGYUTQzAWhPE+
mOiGqU7yofwFhD13PyGD4CqW/wo+ksXSave9RPrO4t/Xr0uTUffD0t97pPDL
tNHkb9a98ncP5HdDHus+s42MTm2Cww2QVAcHjlMC9GPsF7HoUy+TxW9c8L9y
zv/Shv/Vc/v95zMPX6jK2ew6cqGj8Px8/dpG+2kIzsAQGjwCowMwFoDxHpjo
gskOQ/+28J67Hr+qvYnb7HVHu9vb/Pt4idJuSnwx3v7qg/ZuPub682/aMVFj
3HmwFuwqeLMM/Ed1UjuErrzgf3nD//ya//kz+OTgG2eLUs63FZzvLjoXOrYW
aVnkr1Qeh9AIjARhtI+ODsY7YaKdNnmXtOyDj+n9XIdlOpu7vymaLPKpmoiv
GL2Lci/GW5rw25v+Vzb8v4z4n16h6Ytrmfs3qjPPNWZtdOavrTcviN6TEByH
oWEYxj720uHLeAdb7fzemP/lxfg9TNjWw3i/b77HFYvvVVYYt/tT3va/cd7/
XMT/i9P+fYv+p5ftlyLFSet1GetNmWur9QsXOmYgMAYDITr5NdIDo514+EA5
YLLlQ07vXrpK73zbeneni5u7Z+/Xvb/V/+oG9yns3zfvf+Z06muRhoy15ozV
mfLFM00z0DcG/UN0CnO4Gw/zsJDnPjXf7fTpxav0ybutT++7Ev937X/d1TeO
hFvw/Z/+Q7t/3yn/vhn/vrn9zy2VHFxpSV8J5i9tNM5AzygEBmGwjw/M2+EE
9UvdC0a9emEhfq8823r1gZje0Dofc/WG1XszvrHnfU/490359037fx7OfHWp
ZP/pzszFc40nReco9A1AsA+GOmGkDUZbDPnLz7zVPR9+yulJzHWR7f3Qv/Xh
3j97/0ayad8Y7nz/M+ES/2Jd0sJ67czl9lHoDfKpwA4YboXRJlyMaZLNe379
F/LzkO7rVWbMvrf/CrjbG87+f/HlEv++E+iN4tfnaw6EF8tmResodAch0ENn
jkItMEI/O/Ab8ffvdbaoCMi9f8i194+69s46o0T1n18t9u8bT352tnr/3ETh
rGgega5+6OvmXTfbP/w6jNUZztnZPR/9hco1/IqzPcfqu1VkfsS1P/6t8F34
xrNfO4LeLnt9Npg+83bDCHT2Q28XBFthiCDjzj4Wf19qW1ELP+yy8G7XHrkH
N3zzYyiuE0dfPtlyYGqzdgTaA9DTybtr5N3VGHxGNcHZ2RX9I+nRPenfn4y7
h534xvN/X5T69ETNG1MblSOiJUCnRgMtMNiAb/3OleivhpsOJdJ+7L2Wv+ba
Mntrx547733pH47Vvj6xVjZyuSlAlzkCzTBQT938Xfa9HNLcvo9VHi2ra9W7
rrKXf3np60U1r44vFo+Ixj7obIe+JhioozVpVPA4vX7vlfi/juo+V/1+135Y
+Yn3/t7Pip4bHU0fFfV90BHdyW+rfXgd/Vxt29Qj969zyW1/5w8ffeOfjnTZ
I5dr+qC9HXobIVirYtara7lt29a1XPxtfvtTP3jlXwqqXwxtVvXR+e4e3GaN
IX893qPPEUTvKVfrbq8M3b8Sx3GccP8fPlb27OBGaQBa2qCnHoLVZN0HVX9v
dfxI/dOfVHL/fp7c0p47v5HzjcIIFlZNbdBdD/28pTtVL+UvDX/c1Sf3LyXK
Ld336QcP/2veckEfNLbiluzv/S8IlfMnQ2hL8pe49W8Sx47O7isY8k67j995
31xWH10s6Kyzv/s1CJXdqqyTvyb/h2pL7uuQcu09d37rxOM5UCfX/qoIld6o
+sGZJHoUrtZyXyXgrXj33PnPA49mQ00LdNTiVtg3tA32sPNb0vHWlZ9WxXXU
ax7V99/iNT+t1nSfV/5N3SuZoA0d+bRPrhn5N7RNY/sn+PQvCtOSfCTFv/X9
Tp/c0tr+NC/9p2p991JarX/mWGzF5B33sa7W31/y0p9y9cD9vdvuu6S15j7L
a//elfi/9quPF91ra519Me6+3Ucg7js/tba+EnftHTF2x66lNfV3cddyR7J7
vN+p1v66w5avtF+5Env3qSF/uytB9e9f+KXPXYmJIrlBRyf38BJf0Pu+j//4
znpezKi4ylRv8/s8xz7Ykpce+P/y+tZebO+l8Sv/F41iwOc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341356956]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13282],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticK"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticPi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticPi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiZeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiZeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiAmplitude",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiAmplitude"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4730]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4275],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->27409]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->21798],

Cell[TextData[{
 ButtonBox["Demonstrations with EllipticE",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=EllipticE"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EllipticIntegraloftheSecondKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticIntegrals/EllipticE/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->84414619],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->14157971],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->252930770]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticE - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 53.4949188}", "context" -> "System`", 
    "keywords" -> {"elliptic integral of second kind", "ellipticce"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EllipticE[m] gives the complete elliptic integral E(m). \
EllipticE[\\[Phi], m] gives the elliptic integral of the second kind \
E(\\[Phi] \\[VerticalSeparator] m). ", "synonyms" -> {"elliptic e"}, "title" -> 
    "EllipticE", "type" -> "Symbol", "uri" -> "ref/EllipticE"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7623, 264, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->132328929]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[236405, 5527, 124, 1, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[237195, 5560, 101, 1, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 284178, 6739},
 {"XRef-2005-4-26-23-37-1.8558342", 284335, 6743}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2381, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3004, 83, 47, 1, 70, "ObjectName",
 CellID->20904],
Cell[3054, 86, 1160, 37, 70, "Usage",
 CellID->22330]
}, Open  ]],
Cell[CellGroupData[{
Cell[4251, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4729, 145, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4852, 151, 809, 29, 70, "Notes",
 CellID->30807],
Cell[5664, 182, 276, 11, 70, "Notes",
 CellID->23992],
Cell[5943, 195, 502, 18, 70, "Notes",
 CellID->3890],
Cell[6448, 215, 456, 16, 70, "Notes",
 CellID->2528],
Cell[6907, 233, 250, 8, 70, "Notes",
 CellID->393940049],
Cell[7160, 243, 220, 7, 70, "Notes",
 CellID->31226],
Cell[7383, 252, 203, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7623, 264, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132328929],
Cell[CellGroupData[{
Cell[8008, 278, 147, 5, 70, "ExampleSection",
 CellID->90550353],
Cell[CellGroupData[{
Cell[8180, 287, 87, 2, 28, "Input"],
Cell[8270, 291, 175, 5, 36, "Output",
 CellID->65099449]
}, Open  ]],
Cell[8460, 299, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[8590, 305, 199, 6, 28, "Input"],
Cell[8792, 313, 2200, 40, 136, "Output",
 Evaluatable->False,
 CellID->83799854]
}, Open  ]],
Cell[11007, 356, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[11137, 362, 201, 6, 70, "Input"],
Cell[11341, 370, 1196, 35, 54, "Output",
 CellID->67936579]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12586, 411, 200, 6, 70, "ExampleSection"],
Cell[CellGroupData[{
Cell[12811, 421, 227, 6, 70, "ExampleSubsection"],
Cell[13041, 429, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13132, 433, 139, 4, 70, "Input"],
Cell[13274, 439, 272, 7, 36, "Output",
 CellID->125198723]
}, Open  ]],
Cell[13561, 449, 105, 2, 70, "ExampleDelimiter"],
Cell[13669, 453, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13744, 457, 138, 4, 70, "Input"],
Cell[13885, 463, 398, 11, 54, "Output",
 CellID->743551779]
}, Open  ]],
Cell[14298, 477, 105, 2, 70, "ExampleDelimiter"],
Cell[14406, 481, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14524, 487, 114, 2, 70, "Input"],
Cell[14641, 491, 207, 5, 36, "Output",
 CellID->927949733]
}, Open  ]],
Cell[14863, 499, 105, 2, 70, "ExampleDelimiter"],
Cell[14971, 503, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15067, 507, 85, 2, 70, "Input"],
Cell[15155, 511, 182, 6, 49, "Output",
 CellID->831756529]
}, Open  ]],
Cell[CellGroupData[{
Cell[15374, 522, 85, 2, 70, "Input"],
Cell[15462, 526, 158, 5, 36, "Output",
 CellID->237756324]
}, Open  ]],
Cell[15635, 534, 105, 2, 70, "ExampleDelimiter"],
Cell[15743, 538, 192, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15960, 548, 148, 4, 70, "Input"],
Cell[16111, 554, 369, 10, 36, "Output",
 CellID->49240088]
}, Open  ]],
Cell[16495, 567, 105, 2, 70, "ExampleDelimiter"],
Cell[16603, 571, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16691, 575, 201, 6, 70, "Input"],
Cell[16895, 583, 1745, 55, 82, "Output",
 CellID->39028302]
}, Open  ]],
Cell[18655, 641, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18730, 645, 288, 8, 70, "Input"],
Cell[19021, 655, 193, 6, 36, "Output",
 CellID->330002990]
}, Open  ]],
Cell[CellGroupData[{
Cell[19251, 666, 308, 9, 70, "Input"],
Cell[19562, 677, 441, 15, 70, "Output",
 CellID->61129470]
}, Open  ]],
Cell[20018, 695, 125, 3, 70, "ExampleDelimiter",
 CellID->136296941],
Cell[20146, 700, 203, 7, 70, "ExampleText",
 CellID->401032626],
Cell[CellGroupData[{
Cell[20374, 711, 142, 4, 70, "Input",
 CellID->92735886],
Cell[20519, 717, 231, 7, 50, "Output",
 CellID->305158101]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20799, 730, 229, 6, 70, "ExampleSubsection"],
Cell[21031, 738, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21122, 742, 227, 7, 70, "Input"],
Cell[21352, 751, 271, 7, 36, "Output",
 CellID->109556073]
}, Open  ]],
Cell[21638, 761, 105, 2, 70, "ExampleDelimiter"],
Cell[21746, 765, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21821, 769, 168, 5, 70, "Input"],
Cell[21992, 776, 397, 11, 54, "Output",
 CellID->38913718]
}, Open  ]],
Cell[22404, 790, 105, 2, 70, "ExampleDelimiter"],
Cell[22512, 794, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22630, 800, 137, 3, 70, "Input"],
Cell[22770, 805, 207, 5, 36, "Output",
 CellID->142631710]
}, Open  ]],
Cell[22992, 813, 105, 2, 70, "ExampleDelimiter"],
Cell[23100, 817, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23196, 821, 108, 3, 70, "Input"],
Cell[23307, 826, 156, 5, 36, "Output",
 CellID->1259479]
}, Open  ]],
Cell[CellGroupData[{
Cell[23500, 836, 113, 3, 70, "Input"],
Cell[23616, 841, 163, 5, 36, "Output",
 CellID->114099870]
}, Open  ]],
Cell[CellGroupData[{
Cell[23816, 851, 133, 4, 70, "Input"],
Cell[23952, 857, 192, 6, 36, "Output",
 CellID->38351229]
}, Open  ]],
Cell[24159, 866, 105, 2, 70, "ExampleDelimiter"],
Cell[24267, 870, 192, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24484, 880, 176, 6, 70, "Input"],
Cell[24663, 888, 409, 13, 36, "Output",
 CellID->160272690]
}, Open  ]],
Cell[25087, 904, 105, 2, 70, "ExampleDelimiter"],
Cell[25195, 908, 40, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[25260, 912, 237, 7, 70, "Input"],
Cell[25500, 921, 1801, 54, 92, "Output",
 CellID->221799532]
}, Open  ]],
Cell[27316, 978, 68, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[27409, 982, 231, 7, 70, "Input"],
Cell[27643, 991, 1254, 38, 51, "Output",
 CellID->912709894]
}, Open  ]],
Cell[28912, 1032, 105, 2, 70, "ExampleDelimiter"],
Cell[29020, 1036, 321, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[29366, 1050, 165, 5, 70, "Input"],
Cell[29534, 1057, 282, 9, 50, "Output",
 CellID->412374123]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29877, 1073, 223, 6, 70, "ExampleSection"],
Cell[30103, 1081, 193, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30321, 1091, 279, 9, 70, "Input"],
Cell[30603, 1102, 802, 25, 54, "Output",
 CellID->144975190]
}, Open  ]],
Cell[CellGroupData[{
Cell[31442, 1132, 309, 10, 70, "Input"],
Cell[31754, 1144, 496, 17, 54, "Output",
 CellID->389580017]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32299, 1167, 207, 6, 70, "ExampleSection"],
Cell[32509, 1175, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[32584, 1179, 226, 8, 70, "Input"],
Cell[32813, 1189, 2613, 86, 172, "Output",
 CellID->141842212]
}, Open  ]],
Cell[CellGroupData[{
Cell[35463, 1280, 255, 8, 70, "Input"],
Cell[35721, 1290, 552, 19, 62, "Output",
 CellID->671846524]
}, Open  ]],
Cell[36288, 1312, 105, 2, 70, "ExampleDelimiter"],
Cell[36396, 1316, 85, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[36506, 1321, 508, 17, 70, "Input"],
Cell[37017, 1340, 41311, 681, 70, "Output",
 Evaluatable->False,
 CellID->1007514127]
}, Open  ]],
Cell[78343, 2024, 105, 2, 70, "ExampleDelimiter"],
Cell[78451, 2028, 54, 0, 70, "ExampleText"],
Cell[78508, 2030, 334, 11, 70, "Input"],
Cell[CellGroupData[{
Cell[78867, 2045, 514, 18, 70, "Input"],
Cell[79384, 2065, 328, 11, 55, "Output",
 CellID->798377476]
}, Open  ]],
Cell[79727, 2079, 70, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[79822, 2083, 164, 5, 70, "Input"],
Cell[79989, 2090, 1671, 31, 70, "Output",
 Evaluatable->False,
 CellID->829018473]
}, Open  ]],
Cell[81675, 2124, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[81766, 2128, 725, 24, 70, "Input"],
Cell[82494, 2154, 1847, 58, 91, "Output",
 CellID->360560084]
}, Open  ]],
Cell[84356, 2215, 105, 2, 70, "ExampleDelimiter"],
Cell[84464, 2219, 114, 3, 70, "ExampleText"],
Cell[84581, 2224, 294, 9, 70, "Input"],
Cell[CellGroupData[{
Cell[84900, 2237, 849, 29, 70, "Input"],
Cell[85752, 2268, 718, 24, 56, "Output",
 CellID->11954532]
}, Open  ]],
Cell[86485, 2295, 70, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[86580, 2299, 320, 11, 70, "Input"],
Cell[86903, 2312, 2461, 44, 70, "Output",
 Evaluatable->False,
 CellID->281280869]
}, Open  ]],
Cell[89379, 2359, 105, 2, 70, "ExampleDelimiter"],
Cell[89487, 2363, 94, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[89606, 2369, 1026, 28, 70, "Input"],
Cell[90635, 2399, 1590, 48, 86, "Output",
 CellID->824640827]
}, Open  ]],
Cell[92240, 2450, 83, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[92348, 2455, 260, 9, 70, "Input"],
Cell[92611, 2466, 1749, 54, 116, "Output",
 CellID->1316141]
}, Open  ]],
Cell[CellGroupData[{
Cell[94397, 2525, 203, 7, 70, "Input"],
Cell[94603, 2534, 1742, 53, 116, "Output",
 CellID->11750886]
}, Open  ]],
Cell[96360, 2590, 61, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[96446, 2594, 546, 18, 70, "Input"],
Cell[96995, 2614, 34490, 569, 70, "Output",
 Evaluatable->False,
 CellID->661454671]
}, Open  ]],
Cell[131500, 3186, 105, 2, 70, "ExampleDelimiter"],
Cell[131608, 3190, 235, 7, 70, "ExampleText",
 CellID->61793136],
Cell[CellGroupData[{
Cell[131868, 3201, 800, 25, 70, "Input",
 CellID->435554428],
Cell[132671, 3228, 1036, 36, 55, "Output",
 CellID->692244549]
}, Open  ]],
Cell[133722, 3267, 93, 1, 70, "ExampleText",
 CellID->7243216],
Cell[CellGroupData[{
Cell[133840, 3272, 186, 6, 70, "Input",
 CellID->1021045775],
Cell[134029, 3280, 208, 7, 36, "Output",
 CellID->659927971]
}, Open  ]],
Cell[134252, 3290, 105, 2, 70, "ExampleDelimiter"],
Cell[134360, 3294, 74, 0, 70, "ExampleText"],
Cell[134437, 3296, 1699, 53, 70, "Input"],
Cell[136139, 3351, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[136235, 3355, 138, 4, 70, "Input"],
Cell[136376, 3361, 174, 5, 36, "Output",
 CellID->70462622]
}, Open  ]],
Cell[136565, 3369, 99, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[136689, 3375, 1259, 38, 70, "Input"],
Cell[137951, 3415, 173, 5, 36, "Output",
 CellID->25021637]
}, Open  ]],
Cell[138139, 3423, 105, 2, 70, "ExampleDelimiter"],
Cell[138247, 3427, 152, 3, 70, "ExampleText"],
Cell[138402, 3432, 1366, 48, 70, "Input"],
Cell[139771, 3482, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[139846, 3486, 564, 18, 70, "Input"],
Cell[140413, 3506, 75928, 1249, 70, "Output",
 Evaluatable->False,
 CellID->3608936]
}, Open  ]],
Cell[216356, 4758, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[216447, 4762, 1677, 56, 70, "Input"],
Cell[218127, 4820, 158, 5, 36, "Output",
 CellID->825254769]
}, Open  ]],
Cell[218300, 4828, 122, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[218447, 4835, 947, 32, 70, "Input"],
Cell[219397, 4869, 327, 12, 70, "Output",
 CellID->52205740]
}, Open  ]],
Cell[CellGroupData[{
Cell[219761, 4886, 77, 2, 70, "Input"],
Cell[219841, 4890, 176, 5, 36, "Output",
 CellID->611001083]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[220066, 4901, 217, 6, 70, "ExampleSection"],
Cell[220286, 4909, 44, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[220355, 4913, 199, 7, 70, "Input"],
Cell[220557, 4922, 493, 18, 51, "Output",
 CellID->730639201]
}, Open  ]],
Cell[221065, 4943, 73, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[221163, 4947, 146, 4, 70, "Input"],
Cell[221312, 4953, 216, 7, 36, "Output",
 CellID->87782854]
}, Open  ]],
Cell[CellGroupData[{
Cell[221565, 4965, 173, 5, 70, "Input"],
Cell[221741, 4972, 185, 6, 36, "Output",
 CellID->1520125]
}, Open  ]],
Cell[221941, 4981, 105, 2, 70, "ExampleDelimiter"],
Cell[222049, 4985, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[222150, 4989, 388, 12, 70, "Input"],
Cell[222541, 5003, 329, 11, 36, "Output",
 CellID->485609629]
}, Open  ]],
Cell[222885, 5017, 105, 2, 70, "ExampleDelimiter"],
Cell[222993, 5021, 33, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[223051, 5025, 198, 6, 70, "Input"],
Cell[223252, 5033, 669, 22, 60, "Output",
 CellID->712053030]
}, Open  ]],
Cell[CellGroupData[{
Cell[223958, 5060, 228, 7, 70, "Input"],
Cell[224189, 5069, 1037, 35, 98, "Output",
 CellID->552817087]
}, Open  ]],
Cell[CellGroupData[{
Cell[225263, 5109, 501, 17, 70, "Input"],
Cell[225767, 5128, 544, 20, 61, "Output",
 CellID->570512160]
}, Open  ]],
Cell[226326, 5151, 105, 2, 70, "ExampleDelimiter"],
Cell[226434, 5155, 42, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[226501, 5159, 182, 5, 70, "Input"],
Cell[226686, 5166, 402, 14, 61, "Output",
 CellID->35488196]
}, Open  ]],
Cell[227103, 5183, 105, 2, 70, "ExampleDelimiter"],
Cell[227211, 5187, 45, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[227281, 5191, 363, 11, 70, "Input"],
Cell[227647, 5204, 211, 7, 36, "Output",
 CellID->607755148]
}, Open  ]],
Cell[CellGroupData[{
Cell[227895, 5216, 363, 11, 70, "Input"],
Cell[228261, 5229, 192, 6, 36, "Output",
 CellID->20895226]
}, Open  ]],
Cell[228468, 5238, 105, 2, 70, "ExampleDelimiter"],
Cell[228576, 5242, 233, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[228834, 5252, 1358, 46, 70, "Input"],
Cell[230195, 5300, 693, 23, 55, "Output",
 CellID->825022367]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[230937, 5329, 225, 7, 70, "ExampleSection",
 CellID->4682],
Cell[231165, 5338, 96, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[231286, 5344, 288, 10, 70, "Input"],
Cell[231577, 5356, 2863, 94, 156, "Output",
 CellID->44111451]
}, Open  ]],
Cell[234455, 5453, 105, 2, 70, "ExampleDelimiter"],
Cell[234563, 5457, 75, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[234663, 5461, 395, 12, 70, "Input"],
Cell[235061, 5475, 242, 8, 39, "Output",
 CellID->129664509]
}, Open  ]],
Cell[CellGroupData[{
Cell[235340, 5488, 688, 22, 70, "Input"],
Cell[236031, 5512, 251, 8, 36, "Output",
 CellID->306266697]
}, Open  ]],
Cell[236297, 5523, 105, 2, 70, "ExampleDelimiter"],
Cell[236405, 5527, 124, 1, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[236554, 5532, 157, 5, 70, "Input"],
Cell[236714, 5539, 221, 7, 36, "Output",
 CellID->91088429]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[236984, 5552, 208, 6, 70, "ExampleSection"],
Cell[237195, 5560, 101, 1, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[237321, 5565, 301, 10, 70, "Input"],
Cell[237625, 5577, 3429, 110, 134, "Output",
 CellID->26767970]
}, Open  ]],
Cell[CellGroupData[{
Cell[241091, 5692, 327, 10, 70, "Input"],
Cell[241421, 5704, 7077, 208, 396, "Output",
 CellID->112878226]
}, Open  ]],
Cell[248513, 5915, 105, 2, 70, "ExampleDelimiter"],
Cell[248621, 5919, 188, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[248834, 5930, 562, 18, 70, "Input"],
Cell[249399, 5950, 1442, 30, 246, "Output",
 CellID->94702447]
}, Open  ]],
Cell[250856, 5983, 105, 2, 70, "ExampleDelimiter"],
Cell[250964, 5987, 222, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[251211, 5998, 635, 21, 70, "Input"],
Cell[251849, 6021, 1224, 40, 86, "Output",
 CellID->537159832]
}, Open  ]],
Cell[CellGroupData[{
Cell[253110, 6066, 131, 4, 70, "Input"],
Cell[253244, 6072, 273, 7, 36, "Output",
 CellID->40019402]
}, Open  ]],
Cell[CellGroupData[{
Cell[253554, 6084, 533, 17, 70, "Input"],
Cell[254090, 6103, 1693, 32, 70, "Output",
 Evaluatable->False,
 CellID->298457742]
}, Open  ]],
Cell[255798, 6138, 105, 2, 70, "ExampleDelimiter"],
Cell[255906, 6142, 127, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[256058, 6151, 2068, 61, 70, "Input"],
Cell[258129, 6214, 20940, 347, 70, "Output",
 Evaluatable->False,
 CellID->341356956]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[279130, 6568, 311, 9, 70, "SeeAlsoSection",
 CellID->13282],
Cell[279444, 6579, 1211, 44, 70, "SeeAlso",
 CellID->4730]
}, Open  ]],
Cell[CellGroupData[{
Cell[280692, 6628, 313, 9, 70, "TutorialsSection",
 CellID->4275],
Cell[281008, 6639, 192, 4, 70, "Tutorials",
 CellID->27409]
}, Open  ]],
Cell[CellGroupData[{
Cell[281237, 6648, 321, 9, 70, "RelatedLinksSection",
 CellID->21798],
Cell[281561, 6659, 363, 12, 70, "RelatedLinks"],
Cell[281927, 6673, 202, 4, 70, "RelatedLinks"],
Cell[282132, 6679, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[282368, 6688, 318, 9, 70, "MoreAboutSection",
 CellID->84414619],
Cell[282689, 6699, 146, 3, 70, "MoreAbout",
 CellID->14157971],
Cell[282838, 6704, 145, 3, 70, "MoreAbout",
 CellID->252930770]
}, Open  ]],
Cell[282998, 6710, 27, 0, 70, "History"],
Cell[283028, 6712, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

