(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    110108,       3223]
NotebookOptionsPosition[     97407,       2777]
NotebookOutlinePosition[     98689,       2814]
CellTagsIndexPosition[     98603,       2809]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticF" :> Documentation`HelpLookup["paclet:ref/EllipticF"],
           "EllipticE" :> Documentation`HelpLookup["paclet:ref/EllipticE"], 
          "EllipticPi" :> Documentation`HelpLookup["paclet:ref/EllipticPi"], 
          "JacobiZeta" :> Documentation`HelpLookup["paclet:ref/JacobiZeta"], 
          "EllipticNomeQ" :> 
          Documentation`HelpLookup["paclet:ref/EllipticNomeQ"], 
          "ArithmeticGeometricMean" :> 
          Documentation`HelpLookup["paclet:ref/ArithmeticGeometricMean"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"EllipticF\"\>", 
       2->"\<\"EllipticE\"\>", 3->"\<\"EllipticPi\"\>", 
       4->"\<\"JacobiZeta\"\>", 5->"\<\"EllipticNomeQ\"\>", 
       6->"\<\"ArithmeticGeometricMean\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Integrals\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticK", "ObjectName",
 CellID->11711],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticK"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the complete elliptic integral of the first kind \
",
     Cell[BoxData[
      FormBox[
       RowBox[{"K", "(", "m", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11829]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " is given in terms of the incomplete elliptic integral of the first kind by \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"K", 
    RowBox[{"(", "m", ")"}], "=", "F", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["\[Pi]", "2"], "\[VerticalSeparator]", "m"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->26820],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticK"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->14194],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->547364773],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29193193],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->184533108],

Cell["Evaluate numerically:", "ExampleText",
 CellID->115954865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticK", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343925964],

Cell[BoxData["1.8540746773013717`"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->789317859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->622524341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261652657],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmVuIVVUYx5ezz1yam6bjjI7OxbSbZRfLtIs5Nc5Mk44lmD7IBNMQzDyU
YVMP9VIv9VIv9ZIg+dAFsh6MxAgMIiESIiESooIwCHtIgqSHgWD3+76199r7
rLPOPnMmkGTOPuvy/y7r+/7rW2sfJ6bmZp58ampudnpqcOzw1DMzs9PPDo4e
OsxQtMQYc5LP86sM7ZiWfk7GMd/5ZzPPiKkG6Ukj1n+mgeYADfmOcnNGsHx2
FswNFOhUvGnxZnS0lPWN6asYafZkhmoi+mpaabBfUeJ84n9UU66Hr1Iqf4W8
/H/FbDHeNMaWM+s82YGqyMF6vEnGL1z489KlvyszE/Ynr30wb7UQObBAv5oT
jaaJxuuvndn7yDs7th859PQnL790Wsej89//nsisTbDNcXjtg958f/LdFOd2
oumQZ9u5b3/7/PTPx97+BjuzMyewOXnwg+fmTjHCOLNm2NO+X6VXqDQRPPv1
r1YaX5E+8Nj7NBj59NQPeGy2B6VXq/TFi39hAOyrr3xhbU8/8RGaGGGc1Jit
iccHVEpj2frTj39Yj7FDlHaNH6Nx5K2zH584j8HNQXsbVPLy5Xn0vvfuOeJr
7fGk/eHx7xjfFJSUGB53MWv1MH626+1r7q9iRUTrzTe+YiHM4RRt1kh0KyrM
f7VYq990he0F+xVxvk7zR58Mky04AkvJvCUqyZuf/6c/JJPrXxu0tE0zADMs
j8nAyPBRaGgzIBzsjfMcVD63kDHrBgSE8fCXBELnbs+G5dADOso0IKCmARET
OSGzPCg1opacFDKsGbae+fIX3O0MyozLsxnesBlefOEzIgSZWJbsxLaydUwo
knFmwYBkNawY1RWV3up+VCWYBwXW6iYKwtJSUGJfaoNg4jt/GAMuw5knu+Pq
dwClPxLImQbkdZ7gZzYmPKnK+qojTeKlMSSWOOIOOvYtUF7X1mJHyAYrtlrw
ie7eOrS4VTYhiLitlaQX9u6pqicKnCrab4T3EAMK8pQM7w7q8HPj9zXbTeQV
R8goUYY8dMdddvJnSSn5blMPiKo9q/BAIjymMgc9C+2KZZFYQD1rhsOW3xXY
penKoC9YGxzzYBB7deqD3R5kRrBDDit+dimGfUzSM8z9QX0rg9j7gtgeDaXD
ErJ7y+z2pvPEh3VQXe6uyXY/y2tUB+ujzPFHY2s9nPXvaiWcgLoQj2VtqZO3
Wl1LCCKOElTdWZVtobUM5tZCugjM5kWu5RrtWyrxNLcvUs96RUB03KGe0bjV
ZSh/W0pvmPY8ofhhV+5FtwR5YVEsD5Zz0zCbgqgbtM+lBZZLxb2pjDsbdZY9
wnaU82FjUIdFEVHSIf7cGESp5ggbxB2SWssVqJu1T3Zhq9Ta68v80bhEjOOw
NPUkNbvi3JtNDSZbDcSDWEtzg4t0/o2wVDNnt6W5T/SsryP3AlCuRGxsdq3j
ktnjr6CmH8LdBgKyWPk7Evl1LpIBfKEG3X2RPbOlOeAiGuLuljS/sFJOioEg
CywKxsE7ufn0B1F3aR8t6JL62FfGlW1ehtYGdVgU5IfkcVrpqqDgLgyXfbCm
zNI9Ogvz8UOavS6WPiv1IhGIodUA5dkY0lztYpiXbPT6YS1EgmNAoma1+Jz0
d4R/r9fTI7JXK2muCjIr9P4gXT2jIrY4dVmaPQuWzvetFq5G5F8y2+MiWi87
7Vsfm4ytJs1uF9kQO/U0lppJBMVud5ANFkUJooxIc2UBKstGGLUjTupRUtG6
ypg15PnTFdQx5K1xRQGKmMLhcpRY0ntNbh8sdxF3HG50uuJKPkrTvl2QeNKf
6fBZ7L/X+fyznnCTY9nS1LtVsLKWAvkWaaln1nawHno7KnKr5wTjRM1s+tJR
HL5R2N8loKr9YcQsc7EL/0IUls/OgmUubul9N+TFzpQbhCqT8rNuURQmypM0
lxagMg8ylFjS+7FUY1hYXYdFQa7kraizAJXtnSJUVlE7y/wZjZOdxZuf7IpO
F++F3gJGvah0uIjXdwsYTdhmPVj46T/qra8jyLfap7cfiep6Qu9uY14U2l0c
i39J9L2werL60+6iGXpfe0jRlBmKTYb2GWB1ZuwOo6wuFs/RLM22Mp7oe2Pu
LGor0JExsgiVnYpFqKyOtLmIFjFTvh/WuZHho6RRmq0uhvUx0q6ZXZhUT6un
/neS8ZRZSb81yKx8RZTh/UFUJY8nXVxqneeTZVxKz+vHdbTyf4bMkn8B8sN+
9g==\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86516982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175205033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150070755],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "x"}], "8"], "+", 
   FractionBox[
    RowBox[{"9", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "2"]}], "128"], "+", 
   FractionBox[
    RowBox[{"25", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "3"]}], "512"], "+", 
   FractionBox[
    RowBox[{"1225", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "4"]}], "32768"], "+", 
   FractionBox[
    RowBox[{"3969", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "5"]}], "131072"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Rational[1, 2] Pi, Rational[1, 8] Pi, Rational[9, 128] Pi, 
    Rational[25, 512] Pi, Rational[1225, 32768] Pi, Rational[3969, 131072] 
    Pi}, 0, 6, 1],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{347, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->659919980]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->75590303],

Cell["Evaluate numerically for complex arguments:", "ExampleText",
 CellID->69318532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticK", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31492],

Cell[BoxData[
 RowBox[{"1.155145060656933`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.9528453714670535`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299597108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->615448860],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->247833811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", 
    RowBox[{"8", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555589762],

Cell[BoxData["2.\
2572053268208536550832560045233873972354192817399994931553979790521`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->495165596]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->440257297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticK", "[", "0.999999999999999990000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156532277],

Cell[BoxData["20.95826765156927898288306073709`17.033778877060453"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134392871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->941839050],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->138084992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticK", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130294895],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392882936]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38434937],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->211380964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticK", "[", 
  RowBox[{"{", 
   RowBox[{"0.2", ",", "0.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393759725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.6596235986105279`", ",", "1.8540746773013717`", ",", 
   RowBox[{"1.419337751286513`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.348846512193269`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{260, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15786620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->269970133],

Cell["Series expansions at branch points:", "ExampleText",
 CellID->79658364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115526932],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWslu1EAQNfZ4whJCAgmETROEIEAAcWE5sIvlwnrgwC0RQiIHBALEB4AQ
8D18QD4BsVw5A1/RuD3dMz3Pr93LDDEBLM14qt1dVV1ru2puLr149PDx0ovl
B0tz158tPX20/OD53LUnz4qhbF2SpMeTJDk3mxS/RfGr/OjrRPHpg11oqvjO
i0mfi3umJl8pn4zL76y3PknlV27iK34nn+iovJ+F9a3y2SY2asCfrfjOwcyM
4ssBtvPnh69N8GnwPMWwEUbXA/zRyhHiSym+VqAe/LDmal9fjP1d8Fo5DfBF
hUFiTJOuROV9DsYPqjtawH6AbwyJDzW6i8ByXcfA7971NoCvsFU1XOxzzD8I
cOZYf2eV6W8AeA/AOwHuONZzKW8lq8YKELlBGKOA9MFM2Uau1mu4RWwmVfNw
fIvn+g1q3hiMy3nSxlLBbRVhXD9j4ROjVO4pp8kRyQX5zJuQU8uMfubqCU+u
26IfUezYtliwxVm06ZeJ1mQljmMOQVqtQY4Vt1U8fJRp2T1rcqQ0MT4xixqk
hj4e4ztVvtCTTCx2/WAObEIfzJrXkn7SCoapQAy5vzQH6KBPxnl2N7aurKwk
3UuSKGGTO0csTXQsHOCvrWZKDO1qfBpSs67cqWP5aO3JlklMainxx7r5IdJn
u8ZM9F8bodpAj8zUujHBzyk2en6ejNjZKWL0GXp9DdzTmDOvZENoywVPjpCW
K+7HWgZmY5zvysOohcnGpU7z7x+uBe1BrgwYl2k1dnxXbsYvqxEzQEMmd5Y4
6XrPGg2l1T8nswwU4plTDcp9CJ9sXA9r/TzMajf6DDCmI7ZhJyx2ZYpfqQFV
Xk16P2v0ihpE/wvBjZqeEGG1iY6D1/F/VC71NRvGmQnLKozFtq04Xf7jZ9eY
zY449IXzA6orNVhQ+rMA03pxhSrOOr4m9oJ62u6Yz8+GyCVSZXEyI+v8uiL4
fK/o2qTuu0yLvteYHjgFz3X3Y6fgXlZ2TwY8QD7EWPy7qKMmpy3ztorB3s2s
wY9P7OAy1zt22Y+9ryaN5JO6y8EzUZjQa74QPk8bY8wa4zH78ezqmzLMcR3Y
JjBh7xqlyzDxfrW0VGmRX9VdPrpaPhHqYl31OuiW4LUW1NN90e/EPu+trMYx
fso7BtgQfgPwz3LdbRitVr+OwgyZ/WQV7C2M/yin657sIYbXsP45NQ/t/Qjd
2zsrLXMUabaBJnZA8X1xobJ3P7qHAZZ6lee6To0MUEOSv/fw/DuldoBKaOG3
0JJwRmwAsctTROqN9Z4D212AdwOsc1FH8P59HFXsp+8FGHNMB2A8o3S5UEFF
XazrmimYRQgXz7Hd8W0h64L7ouytVOf+4busiP1bKWB8z2G9F99anEt6Lq3E
dXhnolaFv8vTmvkq1Aya15vueWDf7nK5eHFxUc1z1ZTC+3ghvSqOCfUe2gnR
fRY/bQ/bZ9HUqjpOkmpdrEnfdNWQ0Std830r4HFeGFtft/teLy4PoQ/Wh2ha
D39TXGQ+w04QWL+LOU2Ydck9AEM/RYTV2ibs8hxZ/e57X3bOyIH/Vww9H+4g
GjHhmnplzanStwalTpemtg254Yl5lxisvsyrO3oN7hnfqvEtA2teM4JXc3RV
Kbb6w0/0eELHs8Q8wHUdZvnzg0OjnIuNam9dF9WXUMqXONj/IOWqmP9Buvaw
oPC+jtrLJs220BfzHN5DQ07RdsL7Za69YoXjlQEzjux7zqN3qc+Cdf/aYfkx
dG/++pTUNjskMRoN2vamvRprO1hF4NWVk4R35glsbHibw4wTxzPLxraxOv5d
HbY4bk/BKJ5YkAvMUTgfswJWBn/2ZCT3oDsE42Kws3BJ9OutL8sVQl3dKmqy
7hfe6Q2l\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{558, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71278060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362758612],

Cell["Find directional limits at branch cuts:", "ExampleText",
 CellID->179112131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", 
    RowBox[{"2", "+", 
     RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->484580334],

Cell[BoxData[
 RowBox[{"EllipticK", "[", "2", "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214801926]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", 
    RowBox[{"2", "+", 
     RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->863820641],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticK", "[", "2", "]"}], "+", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "4"], "]"}]}], 
   RowBox[{"Gamma", "[", 
    FractionBox["3", "4"], "]"}]]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{213, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169755303]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->805868783],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->688364786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticK", "[", "m", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653124230],

Cell[BoxData[
 FormBox[
  RowBox[{"K", "(", "m", ")"}], TraditionalForm]], "Output",
 ImageSize->{30, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->577009195]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->156889102],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->202323385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticK", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], "-", "1", "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->586805182],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "x"}], "8"], "+", 
   FractionBox[
    RowBox[{"17", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "2"]}], "128"], "+", 
   FractionBox[
    RowBox[{"215", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "3"]}], "1536"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Rational[1, 2] Pi, Rational[1, 8] Pi, Rational[17, 128] Pi, 
    Rational[215, 1536] Pi}, 0, 4, 1],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{219, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167689203]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->252625038],

Cell["Small angle approximation to the period of a pendulum:", "ExampleText",
 CellID->300854044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"4", 
    SqrtBox[
     FractionBox["d", "g"]], 
    RowBox[{"EllipticK", "[", 
     RowBox[{"Sin", "[", 
      FractionBox["\[Alpha]", "2"], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95936719],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", 
    SqrtBox[
     FractionBox["d", "g"]], " ", "\[Pi]"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SqrtBox[
     FractionBox["d", "g"]], " ", "\[Pi]", " ", "\[Alpha]"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Alpha]", "]"}], "2"],
    SeriesData[$CellContext`\[Alpha], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Alpha], 0, {
   2 ($CellContext`d/$CellContext`g)^Rational[1, 2] Pi, 
    Rational[1, 4] ($CellContext`d/$CellContext`g)^Rational[1, 2] Pi}, 0, 2, 
   1],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{181, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110642809]
}, Open  ]],

Cell["Plot the period versus the initial angle: ", "ExampleText",
 CellID->361514431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", 
    RowBox[{"Sin", "[", 
     FractionBox["\[Alpha]", "2"], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"EllipticK", "[", "0", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270869339],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->515004513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13178298],

Cell["\<\
Vector potential due to a circular current flow, in cylindrical coordinates: \
\
\>", "ExampleText",
 CellID->93981908],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"-", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], " ", 
        RowBox[{"EllipticE", "[", 
         FractionBox[
          RowBox[{"4", " ", "r", " ", "R"}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}]], "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["r", "2"], "+", 
          SuperscriptBox["R", "2"], "+", 
          SuperscriptBox["z", "2"]}], ")"}], " ", 
        RowBox[{"EllipticK", "[", 
         FractionBox[
          RowBox[{"4", " ", "r", " ", "R"}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"r", " ", "R", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
         SuperscriptBox["z", "2"]}]]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42673896],

Cell["The components of the magnetic field: ", "ExampleText",
 CellID->395151808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bz", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"r", " ", "A"}], ",", " ", "r"}], "]"}], "/", "r"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95393517],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["r", "2"], "-", 
       SuperscriptBox["R", "2"], "+", 
       SuperscriptBox["z", "2"]}], ")"}], " ", 
     RowBox[{"EllipticE", "[", 
      FractionBox[
       RowBox[{"4", " ", "r", " ", "R"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
        SuperscriptBox["z", "2"]}]], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "-", "R"}], ")"}], "2"], "+", 
       SuperscriptBox["z", "2"]}], ")"}], " ", 
     RowBox[{"EllipticK", "[", 
      FractionBox[
       RowBox[{"4", " ", "r", " ", "R"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
        SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"R", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "-", "R"}], ")"}], "2"], "+", 
      SuperscriptBox["z", "2"]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
      SuperscriptBox["z", "2"]}]]}], ")"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{546, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->482947334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Br", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"A", ",", "z"}], "]"}]}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->261265928],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", "z", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "+", 
         SuperscriptBox["R", "2"], "+", 
         SuperscriptBox["z", "2"]}], ")"}], " ", 
       RowBox[{"EllipticE", "[", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", "R"}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
          SuperscriptBox["z", "2"]}]], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "R"}], ")"}], "2"], "+", 
         SuperscriptBox["z", "2"]}], ")"}], " ", 
       RowBox[{"EllipticK", "[", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", "R"}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
          SuperscriptBox["z", "2"]}]], "]"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"r", " ", "R", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "-", "R"}], ")"}], "2"], "+", 
      SuperscriptBox["z", "2"]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "+", "R"}], ")"}], "2"], "+", 
      SuperscriptBox["z", "2"]}]]}], ")"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{552, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43814400]
}, Open  ]],

Cell["Plot the magnitude of the magnetic field: ", "ExampleText",
 CellID->40503437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"Br", "^", "2"}], " ", "+", " ", 
       RowBox[{"Bz", "^", "2"}]}], "]"}], "/.", 
     RowBox[{"R", "->", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0.001", ",", 
     RowBox[{"3", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26996718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->363476247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195429032],

Cell[TextData[{
 "Resistance between the origin and the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "0"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " in an infinite 3D lattice of unit resistors: "
}], "ExampleText",
 CellID->86894658],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Rho]", "[", "n_", "]"}], ":=", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["\[Pi]", "2"]], 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["2", 
          RowBox[{"3", "-", 
           RowBox[{"Cos", "[", "x", "]"}]}]], ")"}], "2"], "]"}], 
      FractionBox[
       RowBox[{"2", "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"n", " ", "x"}], "]"}]}], 
       RowBox[{"3", "-", 
        RowBox[{"Cos", "[", "x", "]"}]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550778093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"\[Rho]", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", " ", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->513358890],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWE9r1EAUn82fjcWiWNxul4rswYN4qR9A6aFYQfQiiBcPLkVowVpZe/Ak
CB4K1UKhUJT2pn4Bi34AL3ry6tkvEuclk8nkzZtJMpusdmHnT/Lm9/vNvPcm
k9wbba8/2Rxtb6yNhrfHo+frG2svhqtbY37J7zDGTvh/c4Hxdsxbyf8kjnmt
lku89Pktj9cer/u8DpT+vLjvi/4ARoFBnP2yUaqVn2BfL9oKVObnV3pQhGlf
lprVvNI33rfy9AkEWKIO1BW1lrOU6bwo1paFcrrCctCAPmqOmN3LrheQSN0F
i2no65Ui9Iwz6BvveBXVweqwrmrh5mO7xizWc8/rK7kU5zkE9QLqV8vIgaIj
z8g053tI81GqxReSsiapFYgCenxhtl2oIoQgcAIF/dPHX8s33797+519IFAC
wegjRlXfwwefOcKtlSMjguqvECHBnI5lnBTHhmLtqDGamgn6eD0nxTtt/K3o
MfhSz0vMdgn1Fye8L9Qo2RUVNcR0lKVZRedqtsscl9i0dXU63G4s5ftYWXwZ
97MaewCFke1mqkJPXIehpjGm5w21n1EYWexnT4wGx+Corr1CpzPGpsNdHsl1
PJpEsPUMhPvWGNbOsFVOBWQ0axamXFD3cN8hjm3PmHTu+WnkUPMAFd8eMe8U
KT+VHJIeTq1+/viz9ezLt6+/Fav/OSL/DUuIfHOg+aZedoTIQwdE3NTPlhB5
lEK1Z0/VZ4DLPl5+7mlkdEOnnDPI4/vSCjBmkP/2LRi5P2grmv8s4t+zWOU6
9goqZxE/jXEOMe1arHImi1VXMkrQHdL6AsLcKaifg14ksWL1Te0NiZf0uxJP
mr82W89IfH0Ye6VFlLqHJ08PSy7AWzObteDLxksi7iPMhNBxP3kHOK+zWWjZ
uAHey1DMSd5aAp468kP3SrLEbrx64zGhpPrOcw2Kq1W0uKlTQ19v3DFop7+e
2HyZfKO6q8/DbWax8mHEbd7tNYZaZkdx8WsVzuYbUDyqsjbccMKVa69hjyS3
RkDurvehWK2yXu017BHo1shnC1GSPCEWGxfO6DW1fnPo/AUQoDGQ\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->511784915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32429734],

Cell["Energy for the Onsager solution of the Ising model: ", "ExampleText",
 CellID->627241776],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Beta]", "=", 
       FractionBox["1", 
        RowBox[{
         SubscriptBox["k", "B"], "T"}]]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "n", " ", "J", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"2", " ", "\[Beta]", " ", "J"}], "]"}]}], "-", 
      RowBox[{"n", " ", "J", " ", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sinh", "[", 
           RowBox[{"2", " ", "\[Beta]", " ", "J"}], "]"}], "2"], "-", "1"}], 
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"2", "\[Beta]", " ", "J"}], "]"}], 
         RowBox[{"Cosh", "[", 
          RowBox[{"2", "\[Beta]", " ", "J"}], "]"}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["2", "\[Pi]"], 
          RowBox[{"EllipticK", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", " ", 
              FractionBox[
               RowBox[{"Sinh", "[", 
                RowBox[{"2", "\[Beta]", " ", "J"}], "]"}], 
               SuperscriptBox[
                RowBox[{"Cosh", "[", 
                 RowBox[{"2", "\[Beta]", " ", "J"}], "]"}], "2"]]}], ")"}], 
            "2"], "]"}]}], "-", "1"}], ")"}]}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->495787379],

Cell["Plot of the specific heat: ", "ExampleText",
 CellID->204447387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"\[ScriptCapitalE]", ",", "T"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "->", "1"}], ",", 
       RowBox[{"J", "->", "1"}], ",", 
       RowBox[{
        SubscriptBox["k", "B"], "->", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0.1", ",", "4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->255398474],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->164987630]
}, Open  ]],

Cell["Find the critical temperature: ", "ExampleText",
 CellID->225004651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalE]", ",", "T"}], "]"}]}], "\[Equal]", "0"}], 
      ",", "T"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "B"], 
         RowBox[{"T", "/", "J"}]}], "/.", "#"}], ")"}], ">", "0"}], "&"}]}], 
   "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6721404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"T", "\[Rule]", 
    FractionBox["J", 
     RowBox[{
      RowBox[{"ArcCosh", "[", 
       SqrtBox[
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["2"]}], ")"}]}]], "]"}], " ", 
      SubscriptBox["k", "B"]}]]}], "}"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{229, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->344648991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6366349],

Cell["Calculate a singular value: ", "ExampleText",
 CellID->481257139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", 
     FractionBox[
      RowBox[{"EllipticK", "[", 
       RowBox[{"1", "-", 
        SuperscriptBox["z", "2"]}], "]"}], 
      RowBox[{"EllipticK", "[", 
       SuperscriptBox["z", "2"], "]"}]], "]"}], "\[Equal]", 
    SqrtBox["2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57546921],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "z", "\[Rule]", 
   "0.4142135623730950488016887242096980785696718753769480731766797686412`50.\
"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13125269]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"z", "/.", "%"}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", "1"}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12060213],

Cell[BoxData["0``50.38277568533786"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298525007]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->120532505],

Cell[TextData[{
 "This shows the branch cuts of the ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->340642938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"EllipticK", "[", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11044341],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175154383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302912283],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->10028690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"EllipticK", "[", "z", "]"}], "2"], "-", 
     RowBox[{"5", " ", 
      RowBox[{"EllipticK", "[", 
       RowBox[{"z", "+", "2"}], "]"}]}], "+", "z"}], "\[Equal]", "6"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56202806],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"8.886004433400624`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.714042879859386`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93059595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->719141802],

Cell["Integrals:", "ExampleText",
 CellID->140231731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "\[Alpha]"], 
    RowBox[{"EllipticK", "[", "z", "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79231244],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", " ", 
   SuperscriptBox["z", 
    RowBox[{"1", "+", "\[Alpha]"}]], " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       RowBox[{"1", "+", "\[Alpha]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", "+", "\[Alpha]"}]}], "}"}], ",", "z"}], "]"}]}], 
  RowBox[{"2", "+", 
   RowBox[{"2", " ", "\[Alpha]"}]}]]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{350, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309853612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241633713],

Cell["Laplace transforms:", "ExampleText",
 CellID->548438389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329050557],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"s", "/", "2"}]], " ", 
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", 
     FractionBox["s", "2"]}], "]"}]}], 
  RowBox[{"2", " ", 
   SqrtBox["s"]}]]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{153, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->524554174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->261884598],

Cell["Solve a differential equation:", "ExampleText",
 CellID->672227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "z"}], ")"}], " ", 
       RowBox[{
        RowBox[{"w", "''"}], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "z"}]}], ")"}], " ", 
       RowBox[{
        RowBox[{"w", "'"}], "[", "z", "]"}]}], "-", 
      RowBox[{
       RowBox[{"w", "[", "z", "]"}], "/", "4"}]}], "\[Equal]", "0"}], ",", 
    RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134535056],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"EllipticK", "[", 
        RowBox[{"1", "-", "z"}], "]"}]}], "\[Pi]"], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LegendreQ", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "z"}]}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{420, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281156648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237348161],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " is a particular case of various mathematical functions:"
}], "ExampleText",
 CellID->296844352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"LegendreP", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "z"}]}]}], "]"}], ",", 
    RowBox[{"AppellF1", "[", 
     RowBox[{
      FractionBox["1", "2"], ",", 
      FractionBox["1", "2"], ",", 
      FractionBox["1", "2"], ",", 
      FractionBox["3", "2"], ",", "1", ",", "z"}], " ", "]"}], ",", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      FractionBox["\[Pi]", "2"], ",", "z"}], "]"}], ",", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{"0", ",", 
      FractionBox["\[Pi]", "2"], ",", "z"}], "]"}], ",", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["1", "2"], ",", 
          FractionBox["1", "2"]}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "0", "}"}], ",", 
        RowBox[{"{", "0", "}"}]}], "}"}], ",", 
      RowBox[{"-", "z"}]}], "]"}]}], "}"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152326765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"EllipticK", "[", "z", "]"}]}], "\[Pi]"], ",", 
   RowBox[{"EllipticK", "[", "z", "]"}], ",", 
   RowBox[{"EllipticK", "[", "z", "]"}], ",", 
   RowBox[{"EllipticK", "[", "z", "]"}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"EllipticK", "[", "z", "]"}]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{507, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3879442]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->211185607],

Cell["\<\
Machine-precision evaluation can result in numerically inaccurate answer near \
branch cuts:\
\>", "ExampleText",
 CellID->163576095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticK", "[", " ", 
   RowBox[{"2", " ", "-", 
    RowBox[{"I", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Pi", " ", "+", " ", "1"}], ")"}], "^", "2"}], "-", 
       RowBox[{"Pi", "^", "2"}], "-", 
       RowBox[{"2", "Pi"}], "-", "1", " ", "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"Pi", "^", "4"}]}], "]"}]}], ")"}]}]}], "]"}], " ", "//", 
  " ", "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19014718],

Cell[BoxData[
 RowBox[{"1.3110287771460598`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.3110287771460598`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248500442]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EllipticK", "[", 
    RowBox[{"2", " ", "-", 
     RowBox[{"I", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Pi", " ", "+", " ", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{"Pi", "^", "2"}], "-", 
        RowBox[{"2", "Pi"}], "-", "1", " ", "-", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{"Pi", "^", "4"}]}], "]"}]}], ")"}]}]}], "]"}], " ", "//", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"#", ",", "100"}], "]"}], "&"}]}], " ", "//", " ", 
  "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->82787027],

Cell[BoxData[
 RowBox[{"1.3110287771460598`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.3110287771460598`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174194947]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132089299],

Cell["\<\
The defining integral converges only under additional conditions:\
\>", "ExampleText",
 CellID->182907285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       RowBox[{
        RowBox[{"Sin", "[", "t", "]"}], "^", "2"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116383339],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Im", "[", "m", "]"}], "\[NotEqual]", "0"}], "||", 
    RowBox[{
     RowBox[{"Re", "[", "m", "]"}], "\[LessEqual]", "1"}]}], ",", 
   FractionBox[
    RowBox[{"EllipticK", "[", 
     FractionBox["m", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}]], "]"}], 
    SqrtBox[
     RowBox[{"1", "-", "m"}]]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]]], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"m", ">", "1"}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{401, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171375005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168045732],

Cell["\<\
Different argument conventions exist that result in modified results:\
\>", "ExampleText",
 CellID->1710720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", " ", "-", " ", 
      RowBox[{
       RowBox[{"k", "^", "2"}], " ", 
       RowBox[{
        RowBox[{"Sin", "[", "t", "]"}], "^", "2"}]}]}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", 
     RowBox[{"Pi", "/", "2"}]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"k", "^", "2"}], "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248678694],

Cell[BoxData[
 FractionBox[
  RowBox[{"EllipticK", "[", 
   FractionBox[
    SuperscriptBox["k", "2"], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["k", "2"]}]], "]"}], 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["k", "2"]}]]]], "Output",
 ImageSize->{116, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35140476]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->282464056],

Cell["\<\
Probability that a random walker in a 3D cubic lattice returns to the origin: \
\
\>", "ExampleText",
 CellID->571572613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[Pi]", "2"], "72"], 
    RowBox[{"(", 
     RowBox[{"6", "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}], "+", 
      SqrtBox["6"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"EllipticK", "[", 
      RowBox[{"35", "+", 
       RowBox[{"24", " ", 
        SqrtBox["2"]}], "-", 
       RowBox[{"20", " ", 
        SqrtBox["3"]}], "-", 
       RowBox[{"14", " ", 
        SqrtBox["6"]}]}], "]"}], 
     RowBox[{"-", "2"}]]}]}], "  ", "//", "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273461019],

Cell[BoxData["0.34053732955100335`"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651604852]
}, Open  ]],

Cell["\<\
Carry out a modeling run of 1000 walks and count how many return to the \
origin: \
\>", "ExampleText",
 CellID->220883188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "11", "]"}], ";", 
   RowBox[{"Count", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"walkerPosition", "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
        RowBox[{"steps", "=", "0"}], ";", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"steps", "==", "0"}], "||", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"steps", "<", "100"}], "&&", 
             RowBox[{"walkerPosition", "=!=", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"steps", "++"}], ";", 
           RowBox[{"walkerPosition", "=", 
            RowBox[{"walkerPosition", "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "}"}], "[", 
              RowBox[{"[", 
               RowBox[{"Random", "[", 
                RowBox[{"Integer", ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], 
              "]"}]}]}]}]}], "]"}], ";", "steps"}], ",", 
       RowBox[{"{", "1000", "}"}]}], "]"}], ",", 
     RowBox[{"_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#", "<", "100"}], "&"}], ")"}]}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->109796917],

Cell[BoxData["341"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->328283765]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13888],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticPi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticPi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiZeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiZeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticNomeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticNomeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArithmeticGeometricMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArithmeticGeometricMean"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7506]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1591],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->18604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->5997],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EllipticIntegraloftheFirstKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticIntegrals/EllipticK/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
EllipticK"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->390488117],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->877716888],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->118146213],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->200406187]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticK - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 0.8388568}", "context" -> "System`", 
    "keywords" -> {
     "complete elliptic integral", "ellipticck", "elliptic integral"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EllipticK[m] gives the complete elliptic integral of the first kind \
K(m). ", "synonyms" -> {"elliptic k"}, "title" -> "EllipticK", "type" -> 
    "Symbol", "uri" -> "ref/EllipticK"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6321, 209, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->29193193]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 98461, 2802}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2688, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3311, 88, 47, 1, 70, "ObjectName",
 CellID->11711],
Cell[3361, 91, 617, 20, 70, "Usage",
 CellID->11829]
}, Open  ]],
Cell[CellGroupData[{
Cell[4015, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4493, 133, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4616, 139, 480, 17, 70, "Notes",
 CellID->26820],
Cell[5099, 158, 503, 18, 70, "Notes",
 CellID->14194],
Cell[5605, 178, 250, 8, 70, "Notes",
 CellID->547364773],
Cell[5858, 188, 220, 7, 70, "Notes",
 CellID->31226],
Cell[6081, 197, 203, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6321, 209, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29193193],
Cell[CellGroupData[{
Cell[6705, 223, 148, 5, 70, "ExampleSection",
 CellID->184533108],
Cell[6856, 230, 64, 1, 70, "ExampleText",
 CellID->115954865],
Cell[CellGroupData[{
Cell[6945, 235, 107, 3, 28, "Input",
 CellID->343925964],
Cell[7055, 240, 224, 7, 36, "Output",
 CellID->789317859]
}, Open  ]],
Cell[7294, 250, 125, 3, 70, "ExampleDelimiter",
 CellID->622524341],
Cell[CellGroupData[{
Cell[7444, 257, 240, 8, 28, "Input",
 CellID->261652657],
Cell[7687, 267, 2521, 47, 139, "Output",
 Evaluatable->False,
 CellID->86516982]
}, Open  ]],
Cell[10223, 317, 125, 3, 70, "ExampleDelimiter",
 CellID->175205033],
Cell[CellGroupData[{
Cell[10373, 324, 221, 7, 70, "Input",
 CellID->150070755],
Cell[10597, 333, 1110, 34, 54, "Output",
 CellID->659919980]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11756, 373, 219, 7, 70, "ExampleSection",
 CellID->75590303],
Cell[11978, 382, 85, 1, 70, "ExampleText",
 CellID->69318532],
Cell[CellGroupData[{
Cell[12088, 387, 126, 4, 70, "Input",
 CellID->31492],
Cell[12217, 393, 272, 7, 36, "Output",
 CellID->299597108]
}, Open  ]],
Cell[12504, 403, 125, 3, 70, "ExampleDelimiter",
 CellID->615448860],
Cell[12632, 408, 70, 1, 70, "ExampleText",
 CellID->247833811],
Cell[CellGroupData[{
Cell[12727, 413, 184, 6, 70, "Input",
 CellID->555589762],
Cell[12914, 421, 235, 7, 36, "Output",
 CellID->495165596]
}, Open  ]],
Cell[13164, 431, 113, 3, 70, "ExampleText",
 CellID->440257297],
Cell[CellGroupData[{
Cell[13302, 438, 142, 4, 70, "Input",
 CellID->156532277],
Cell[13447, 444, 209, 5, 36, "Output",
 CellID->134392871]
}, Open  ]],
Cell[13671, 452, 125, 3, 70, "ExampleDelimiter",
 CellID->941839050],
Cell[13799, 457, 91, 1, 70, "ExampleText",
 CellID->138084992],
Cell[CellGroupData[{
Cell[13915, 462, 105, 3, 70, "Input",
 CellID->130294895],
Cell[14023, 467, 230, 8, 49, "Output",
 CellID->392882936]
}, Open  ]],
Cell[14268, 478, 124, 3, 70, "ExampleDelimiter",
 CellID->38434937],
Cell[14395, 483, 212, 7, 70, "ExampleText",
 CellID->211380964],
Cell[CellGroupData[{
Cell[14632, 494, 168, 5, 70, "Input",
 CellID->393759725],
Cell[14803, 501, 415, 12, 36, "Output",
 CellID->15786620]
}, Open  ]],
Cell[15233, 516, 125, 3, 70, "ExampleDelimiter",
 CellID->269970133],
Cell[15361, 521, 77, 1, 70, "ExampleText",
 CellID->79658364],
Cell[CellGroupData[{
Cell[15463, 526, 221, 7, 70, "Input",
 CellID->115526932],
Cell[15687, 535, 2158, 41, 70, "Output",
 Evaluatable->False,
 CellID->71278060]
}, Open  ]],
Cell[17860, 579, 125, 3, 70, "ExampleDelimiter",
 CellID->362758612],
Cell[17988, 584, 82, 1, 70, "ExampleText",
 CellID->179112131],
Cell[CellGroupData[{
Cell[18095, 589, 308, 9, 70, "Input",
 CellID->484580334],
Cell[18406, 600, 241, 8, 36, "Output",
 CellID->214801926]
}, Open  ]],
Cell[CellGroupData[{
Cell[18684, 613, 328, 10, 70, "Input",
 CellID->863820641],
Cell[19015, 625, 474, 16, 70, "Output",
 CellID->169755303]
}, Open  ]],
Cell[19504, 644, 125, 3, 70, "ExampleDelimiter",
 CellID->805868783],
Cell[19632, 649, 203, 7, 70, "ExampleText",
 CellID->688364786],
Cell[CellGroupData[{
Cell[19860, 660, 143, 4, 70, "Input",
 CellID->653124230],
Cell[20006, 666, 231, 7, 50, "Output",
 CellID->577009195]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20286, 679, 243, 7, 70, "ExampleSection",
 CellID->156889102],
Cell[20532, 688, 211, 7, 70, "ExampleText",
 CellID->202323385],
Cell[CellGroupData[{
Cell[20768, 699, 223, 7, 70, "Input",
 CellID->586805182],
Cell[20994, 708, 847, 27, 54, "Output",
 CellID->167689203]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21890, 741, 227, 7, 70, "ExampleSection",
 CellID->252625038],
Cell[22120, 750, 97, 1, 70, "ExampleText",
 CellID->300854044],
Cell[CellGroupData[{
Cell[22242, 755, 355, 12, 70, "Input",
 CellID->95936719],
Cell[22600, 769, 818, 26, 60, "Output",
 CellID->110642809]
}, Open  ]],
Cell[23433, 798, 85, 1, 70, "ExampleText",
 CellID->361514431],
Cell[CellGroupData[{
Cell[23543, 803, 430, 13, 70, "Input",
 CellID->270869339],
Cell[23976, 818, 2530, 47, 70, "Output",
 Evaluatable->False,
 CellID->515004513]
}, Open  ]],
Cell[26521, 868, 124, 3, 70, "ExampleDelimiter",
 CellID->13178298],
Cell[26648, 873, 129, 4, 70, "ExampleText",
 CellID->93981908],
Cell[26780, 879, 1419, 46, 70, "Input",
 CellID->42673896],
Cell[28202, 927, 81, 1, 70, "ExampleText",
 CellID->395151808],
Cell[CellGroupData[{
Cell[28308, 932, 253, 9, 70, "Input",
 CellID->95393517],
Cell[28564, 943, 1563, 54, 86, "Output",
 CellID->482947334]
}, Open  ]],
Cell[CellGroupData[{
Cell[30164, 1002, 203, 7, 70, "Input",
 CellID->261265928],
Cell[30370, 1011, 1650, 55, 86, "Output",
 CellID->43814400]
}, Open  ]],
Cell[32035, 1069, 84, 1, 70, "ExampleText",
 CellID->40503437],
Cell[CellGroupData[{
Cell[32144, 1074, 521, 17, 70, "Input",
 CellID->26996718],
Cell[32668, 1093, 16515, 276, 70, "Output",
 Evaluatable->False,
 CellID->363476247]
}, Open  ]],
Cell[49198, 1372, 125, 3, 70, "ExampleDelimiter",
 CellID->195429032],
Cell[49326, 1377, 278, 9, 70, "ExampleText",
 CellID->86894658],
Cell[49607, 1388, 724, 24, 70, "Input",
 CellID->550778093],
Cell[CellGroupData[{
Cell[50356, 1416, 315, 10, 70, "Input",
 CellID->513358890],
Cell[50674, 1428, 1350, 27, 70, "Output",
 Evaluatable->False,
 CellID->511784915]
}, Open  ]],
Cell[52039, 1458, 124, 3, 70, "ExampleDelimiter",
 CellID->32429734],
Cell[52166, 1463, 95, 1, 70, "ExampleText",
 CellID->627241776],
Cell[52264, 1466, 1425, 42, 70, "Input",
 CellID->495787379],
Cell[53692, 1510, 70, 1, 70, "ExampleText",
 CellID->204447387],
Cell[CellGroupData[{
Cell[53787, 1515, 598, 19, 70, "Input",
 CellID->255398474],
Cell[54388, 1536, 2286, 43, 70, "Output",
 Evaluatable->False,
 CellID->164987630]
}, Open  ]],
Cell[56689, 1582, 74, 1, 70, "ExampleText",
 CellID->225004651],
Cell[CellGroupData[{
Cell[56788, 1587, 550, 20, 70, "Input",
 CellID->6721404],
Cell[57341, 1609, 551, 20, 77, "Output",
 CellID->344648991]
}, Open  ]],
Cell[57907, 1632, 123, 3, 70, "ExampleDelimiter",
 CellID->6366349],
Cell[58033, 1637, 71, 1, 70, "ExampleText",
 CellID->481257139],
Cell[CellGroupData[{
Cell[58129, 1642, 524, 17, 70, "Input",
 CellID->57546921],
Cell[58656, 1661, 338, 12, 36, "Output",
 CellID->13125269]
}, Open  ]],
Cell[CellGroupData[{
Cell[59031, 1678, 200, 8, 70, "Input",
 CellID->12060213],
Cell[59234, 1688, 225, 7, 36, "Output",
 CellID->298525007]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59508, 1701, 237, 7, 70, "ExampleSection",
 CellID->120532505],
Cell[59748, 1710, 228, 8, 70, "ExampleText",
 CellID->340642938],
Cell[CellGroupData[{
Cell[60001, 1722, 427, 14, 70, "Input",
 CellID->11044341],
Cell[60431, 1738, 16760, 279, 70, "Output",
 Evaluatable->False,
 CellID->175154383]
}, Open  ]],
Cell[77206, 2020, 125, 3, 70, "ExampleDelimiter",
 CellID->302912283],
Cell[77334, 2025, 95, 1, 70, "ExampleText",
 CellID->10028690],
Cell[CellGroupData[{
Cell[77454, 2030, 408, 13, 70, "Input",
 CellID->56202806],
Cell[77865, 2045, 375, 12, 36, "Output",
 CellID->93059595]
}, Open  ]],
Cell[78255, 2060, 125, 3, 70, "ExampleDelimiter",
 CellID->719141802],
Cell[78383, 2065, 53, 1, 70, "ExampleText",
 CellID->140231731],
Cell[CellGroupData[{
Cell[78461, 2070, 217, 7, 70, "Input",
 CellID->79231244],
Cell[78681, 2079, 693, 23, 60, "Output",
 CellID->309853612]
}, Open  ]],
Cell[79389, 2105, 125, 3, 70, "ExampleDelimiter",
 CellID->241633713],
Cell[79517, 2110, 62, 1, 70, "ExampleText",
 CellID->548438389],
Cell[CellGroupData[{
Cell[79604, 2115, 202, 6, 70, "Input",
 CellID->329050557],
Cell[79809, 2123, 461, 17, 65, "Output",
 CellID->524554174]
}, Open  ]],
Cell[80285, 2143, 125, 3, 70, "ExampleDelimiter",
 CellID->261884598],
Cell[80413, 2148, 70, 1, 70, "ExampleText",
 CellID->672227],
Cell[CellGroupData[{
Cell[80508, 2153, 651, 22, 70, "Input",
 CellID->134535056],
Cell[81162, 2177, 767, 26, 51, "Output",
 CellID->281156648]
}, Open  ]],
Cell[81944, 2206, 125, 3, 70, "ExampleDelimiter",
 CellID->237348161],
Cell[82072, 2211, 235, 7, 70, "ExampleText",
 CellID->296844352],
Cell[CellGroupData[{
Cell[82332, 2222, 1139, 37, 70, "Input",
 CellID->152326765],
Cell[83474, 2261, 543, 17, 51, "Output",
 CellID->3879442]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84066, 2284, 230, 7, 70, "ExampleSection",
 CellID->211185607],
Cell[84299, 2293, 143, 4, 70, "ExampleText",
 CellID->163576095],
Cell[CellGroupData[{
Cell[84467, 2301, 529, 17, 70, "Input",
 CellID->19014718],
Cell[84999, 2320, 321, 9, 36, "Output",
 CellID->248500442]
}, Open  ]],
Cell[CellGroupData[{
Cell[85357, 2334, 643, 21, 70, "Input",
 CellID->82787027],
Cell[86003, 2357, 321, 9, 36, "Output",
 CellID->174194947]
}, Open  ]],
Cell[86339, 2369, 125, 3, 70, "ExampleDelimiter",
 CellID->132089299],
Cell[86467, 2374, 116, 3, 70, "ExampleText",
 CellID->182907285],
Cell[CellGroupData[{
Cell[86608, 2381, 388, 13, 70, "Input",
 CellID->116383339],
Cell[86999, 2396, 954, 32, 108, "Output",
 CellID->171375005]
}, Open  ]],
Cell[87968, 2431, 125, 3, 70, "ExampleDelimiter",
 CellID->168045732],
Cell[88096, 2436, 118, 3, 70, "ExampleText",
 CellID->1710720],
Cell[CellGroupData[{
Cell[88239, 2443, 547, 17, 70, "Input",
 CellID->248678694],
Cell[88789, 2462, 397, 15, 75, "Output",
 CellID->35140476]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89235, 2483, 228, 7, 70, "ExampleSection",
 CellID->282464056],
Cell[89466, 2492, 131, 4, 70, "ExampleText",
 CellID->571572613],
Cell[CellGroupData[{
Cell[89622, 2500, 602, 22, 70, "Input",
 CellID->273461019],
Cell[90227, 2524, 225, 7, 36, "Output",
 CellID->651604852]
}, Open  ]],
Cell[90467, 2534, 133, 4, 70, "ExampleText",
 CellID->220883188],
Cell[CellGroupData[{
Cell[90625, 2542, 2132, 58, 70, "Input",
 CellID->109796917],
Cell[92760, 2602, 208, 7, 36, "Output",
 CellID->328283765]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93029, 2616, 311, 9, 70, "SeeAlsoSection",
 CellID->13888],
Cell[93343, 2627, 1482, 53, 70, "SeeAlso",
 CellID->7506]
}, Open  ]],
Cell[CellGroupData[{
Cell[94862, 2685, 313, 9, 70, "TutorialsSection",
 CellID->1591],
Cell[95178, 2696, 192, 4, 70, "Tutorials",
 CellID->18604]
}, Open  ]],
Cell[CellGroupData[{
Cell[95407, 2705, 320, 9, 70, "RelatedLinksSection",
 CellID->5997],
Cell[95730, 2716, 201, 4, 70, "RelatedLinks"],
Cell[95934, 2722, 199, 4, 70, "RelatedLinks"],
Cell[96136, 2728, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96560, 2746, 319, 9, 70, "MoreAboutSection",
 CellID->390488117],
Cell[96882, 2757, 147, 3, 70, "MoreAbout",
 CellID->877716888],
Cell[97032, 2762, 155, 3, 70, "MoreAbout",
 CellID->118146213],
Cell[97190, 2767, 145, 3, 70, "MoreAbout",
 CellID->200406187]
}, Open  ]],
Cell[97350, 2773, 27, 0, 70, "History"],
Cell[97380, 2775, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

