(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25630,        942]
NotebookOptionsPosition[     20675,        774]
NotebookOutlinePosition[     22121,        814]
CellTagsIndexPosition[     22036,        809]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Deploy" :> Documentation`HelpLookup["paclet:ref/Deploy"], 
          "Editable" :> Documentation`HelpLookup["paclet:ref/Editable"], 
          "Selectable" :> 
          Documentation`HelpLookup["paclet:ref/Selectable"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Deploy\"\>", 2->"\<\"Editable\"\>", 
       3->"\<\"Selectable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Controls Options\"\>", 
       3->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Enabled", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Enabled",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
     "\[LineSeparator]is an option for objects such as ",
     Cell[BoxData[
      ButtonBox["Slider",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
     " which specifies whether the objects should be enabled for interactive \
manipulation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->424]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"Enabled", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", objects are typically displayed dimmed. "
}], "Notes",
 CellID->18325],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Enabled", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " does not prevent changes that result from re\[Hyphen]evaluation of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->30111],

Cell[TextData[{
 "The typical default ",
 Cell[BoxData[
  RowBox[{"Enabled", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " effectively inherits from enclosing constructs. "
}], "Notes",
 CellID->129137926],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["Enabled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->514551601]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->253852695],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->260144608],

Cell[TextData[{
 "Compare enabled and disabled ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->45274876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{"Enabled", "\[Rule]", "False"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1435729129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5], ",", 
   SliderBox[0.5,
    Enabled->False]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101997145]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1771134871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"RadioButton", "[", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112136915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[1, {1}], ",", 
   RadioButtonBox[1, {1},
    Enabled->False]}], "}"}]], "Output",
 ImageSize->{68, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21614822]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1224979458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{"Range", "[", "5", "]"}], "]"}], ",", 
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"Range", "[", "5", "]"}], ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->304026817],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->"1"}, {2,"2"->"2"}, {3,"3"->"3"}, {4,"4"->"4"}, {5,"5"->
    "5"}}, 3], ",", 
   TabViewBox[{{1,"1"->"1"}, {2,"2"->"2"}, {3,"3"->"3"}, {4,"4"->"4"}, {5,"5"->
    "5"}}, 1,
    Enabled->False]}], "}"}]], "Output",
 ImageSize->{252, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->915117106]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1908740239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InputField", "[", "]"}], ",", 
   RowBox[{"InputField", "[", 
    RowBox[{"Null", ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->355170887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = Null}, 
     InputFieldBox[Dynamic[Typeset`i$$]],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#]]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = Null}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      Enabled->False],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], Enabled -> False]& ]}], "}"}]], "Output",
 ImageSize->{552, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1162858728]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26303],

Cell[TextData[{
 "Many additional controls have different look and behavior when disabled \
including ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1026547309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", "]"}], ",", 
   RowBox[{"Checkbox", "[", 
    RowBox[{"Enabled", "\[Rule]", "False"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1540587701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[False], ",", 
   CheckboxBox[False,
    Enabled->False]}], "}"}]], "Output",
 ImageSize->{56, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1311465090]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->297002365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Range", "[", "10", "]"}]}], "]"}], ",", 
   RowBox[{"PopupMenu", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->220845980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5", 6->"6", 7->"7", 8->
    "8", 9->"9", 10->"10"}], ",", 
   PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5", 6->"6", 7->"7", 8->
    "8", 9->"9", 10->"10"},
    Enabled->False]}], "}"}]], "Output",
 ImageSize->{114, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355577011]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->593177346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Button", "[", "\"\<xxx\>\"", "]"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1086477987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Enabled->False,
    Evaluator->None,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{86, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2065453796]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->61023149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"Setter", "[", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1266365624],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[1, {1}, "1"], ",", 
   SetterBox[1, {1}, "1",
    Enabled->False]}], "}"}]], "Output",
 ImageSize->{56, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1799046923]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->933236418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", "]"}], ",", 
   RowBox[{"Slider2D", "[", 
    RowBox[{"Enabled", "\[Rule]", "False"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1831403285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[{0.5, 0.5}], ",", 
   Slider2DBox[{0.5, 0.5},
    Enabled->False]}], "}"}]], "Output",
 ImageSize->{190, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->11885101]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32674834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xxx\>\"", ",", "\"\<yyyyyy\>\""}], "}"}], "]"}], ",", 
   RowBox[{"OpenerView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<xxx\>\"", ",", "\"\<yyyyyy\>\""}], "}"}], ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1557605053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneBox[
        TagBox[GridBox[{
           {
            ItemBox[
             OpenerBox[Dynamic[Typeset`var$$],
              Enabled->Automatic],
             Alignment->Top,
             StripOnInput->False], 
            ItemBox[
             StyleBox[
              
              PaneSelectorBox[{False->"\<\"xxx\"\>", True->"\<\"yyyyyy\"\>"}, 
               Dynamic[Typeset`var$$],
               Alignment->Automatic,
               ImageMargins->Automatic,
               ImageSize->Automatic],
              Deployed->False,
              StripOnInput->False],
             Background->Automatic,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
             "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0],
       Deployed->True,
       StripOnInput->False],
      OpenerView[{"xxx", "yyyyyy"}, False]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneBox[
        TagBox[GridBox[{
           {
            ItemBox[
             OpenerBox[Dynamic[Typeset`var$$],
              Enabled->False],
             Alignment->Top,
             StripOnInput->False], 
            ItemBox[
             StyleBox[
              
              PaneSelectorBox[{False->"\<\"xxx\"\>", True->"\<\"yyyyyy\"\>"}, 
               Dynamic[Typeset`var$$],
               Alignment->Automatic,
               ImageMargins->Automatic,
               ImageSize->Automatic],
              Deployed->False,
              StripOnInput->False],
             Background->Automatic,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
             "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0],
       Deployed->True,
       StripOnInput->False],
      OpenerView[{"xxx", "yyyyyy"}, False, Enabled -> False]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->842468841]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21792],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Editable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Editable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23269]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->29607166],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->286596901],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->213622298],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->60836292]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Enabled - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 18.9486954}", "context" -> "System`", 
    "keywords" -> {
     "disable controls", "disable controls elements", "turn controls off", 
      "enable controls", "disable slider", "disable tabview", 
      "disable checkbox", "disable radiobutton"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Enabled is an option for objects such as Slider which specifies whether \
the objects should be enabled for interactive manipulation. ", 
    "synonyms" -> {}, "title" -> "Enabled", "type" -> "Symbol", "uri" -> 
    "ref/Enabled"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6342, 202, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->253852695]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21893, 802}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1682, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2305, 67, 1572, 37, 70, "ObjectNameGrid"],
Cell[3880, 106, 639, 19, 70, "Usage",
 CellID->424]
}, Open  ]],
Cell[CellGroupData[{
Cell[4556, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5034, 147, 258, 9, 70, "Notes",
 CellID->18325],
Cell[5295, 158, 394, 13, 70, "Notes",
 CellID->30111],
Cell[5692, 173, 280, 9, 70, "Notes",
 CellID->129137926],
Cell[5975, 184, 330, 13, 70, "Notes",
 CellID->514551601]
}, Closed]],
Cell[CellGroupData[{
Cell[6342, 202, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->253852695],
Cell[CellGroupData[{
Cell[6727, 216, 148, 5, 70, "ExampleSection",
 CellID->260144608],
Cell[6878, 223, 207, 8, 70, "ExampleText",
 CellID->45274876],
Cell[CellGroupData[{
Cell[7110, 235, 220, 7, 28, "Input",
 CellID->1435729129],
Cell[7333, 244, 254, 10, 46, "Output",
 CellID->101997145]
}, Open  ]],
Cell[7602, 257, 185, 7, 70, "ExampleText",
 CellID->1771134871],
Cell[CellGroupData[{
Cell[7812, 268, 295, 9, 28, "Input",
 CellID->112136915],
Cell[8110, 279, 268, 10, 44, "Output",
 CellID->21614822]
}, Open  ]],
Cell[8393, 292, 177, 7, 70, "ExampleText",
 CellID->1224979458],
Cell[CellGroupData[{
Cell[8595, 303, 321, 10, 70, "Input",
 CellID->304026817],
Cell[8919, 315, 406, 12, 70, "Output",
 CellID->915117106]
}, Open  ]],
Cell[9340, 330, 183, 7, 70, "ExampleText",
 CellID->1908740239],
Cell[CellGroupData[{
Cell[9548, 341, 256, 8, 70, "Input",
 CellID->355170887],
Cell[9807, 351, 567, 20, 70, "Output",
 CellID->1162858728]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10423, 377, 216, 7, 70, "ExampleSection",
 CellID->26303],
Cell[10642, 386, 268, 9, 70, "ExampleText",
 CellID->1026547309],
Cell[CellGroupData[{
Cell[10935, 399, 224, 7, 70, "Input",
 CellID->1540587701],
Cell[11162, 408, 262, 10, 70, "Output",
 CellID->1311465090]
}, Open  ]],
Cell[11439, 421, 180, 7, 70, "ExampleText",
 CellID->297002365],
Cell[CellGroupData[{
Cell[11644, 432, 363, 11, 70, "Input",
 CellID->220845980],
Cell[12010, 445, 434, 12, 70, "Output",
 CellID->355577011]
}, Open  ]],
Cell[12459, 460, 174, 7, 70, "ExampleText",
 CellID->593177346],
Cell[CellGroupData[{
Cell[12658, 471, 271, 8, 70, "Input",
 CellID->1086477987],
Cell[12932, 481, 598, 22, 70, "Output",
 CellID->2065453796]
}, Open  ]],
Cell[13545, 506, 173, 7, 70, "ExampleText",
 CellID->61023149],
Cell[CellGroupData[{
Cell[13743, 517, 286, 9, 70, "Input",
 CellID->1266365624],
Cell[14032, 528, 270, 10, 70, "Output",
 CellID->1799046923]
}, Open  ]],
Cell[14317, 541, 178, 7, 70, "ExampleText",
 CellID->933236418],
Cell[CellGroupData[{
Cell[14520, 552, 224, 7, 70, "Input",
 CellID->1831403285],
Cell[14747, 561, 271, 10, 70, "Output",
 CellID->11885101]
}, Open  ]],
Cell[15033, 574, 181, 7, 70, "ExampleText",
 CellID->32674834],
Cell[CellGroupData[{
Cell[15239, 585, 409, 12, 70, "Input",
 CellID->1557605053],
Cell[15651, 599, 3054, 95, 70, "Output",
 CellID->842468841]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18766, 701, 311, 9, 70, "SeeAlsoSection",
 CellID->21792],
Cell[19080, 712, 696, 26, 70, "SeeAlso",
 CellID->23269]
}, Open  ]],
Cell[CellGroupData[{
Cell[19813, 743, 318, 9, 70, "MoreAboutSection",
 CellID->29607166],
Cell[20134, 754, 141, 3, 70, "MoreAbout",
 CellID->286596901],
Cell[20278, 759, 143, 3, 70, "MoreAbout",
 CellID->213622298],
Cell[20424, 764, 179, 3, 70, "MoreAbout",
 CellID->60836292]
}, Open  ]],
Cell[20618, 770, 27, 0, 70, "History"],
Cell[20648, 772, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

