(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16814,        582]
NotebookOptionsPosition[     12767,        449]
NotebookOutlinePosition[     14414,        494]
CellTagsIndexPosition[     14288,        488]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Reading and Writing Mathematica Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReadProtected" :> 
          Documentation`HelpLookup["paclet:ref/ReadProtected"], "$MachineID" :> 
          Documentation`HelpLookup["paclet:ref/$MachineID"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ReadProtected\"\>", 2->"\<\"$MachineID\"\>", 
       3->"\<\"Get\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Mathematica Expressions in Files" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaExpressionsInFiles"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Files\"\>", 
       2->"\<\"Mathematica Expressions in Files\"\>", 
       3->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Encode", "ObjectName",
 CellID->5707],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Encode",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Encode"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"dest\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes an encoded version of the file ",
     Cell[BoxData[
      StyleBox["source", "TI"]], "InlineFormula"],
     " to the file ",
     Cell[BoxData[
      StyleBox["dest", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"<<", 
       StyleBox["dest", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]decodes the file before reading its contents. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Encode",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Encode"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"dest\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"key\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]produces an encoded file which must be read in using ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Get",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Get"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"dest\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"key\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->21727]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Encoded files contain only printable ASCII characters. They begin with a \
special sequence which is recognized by ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4669],

Cell[TextData[{
 "On certain computer systems ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Encode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Encode"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"dest\", \"TI\"]\)\>\"", ",", 
    RowBox[{"MachineID", "->", "\"\<\!\(\*
StyleBox[\"ID\", \"TI\"]\)\>\""}]}], "]"}]], "InlineFormula"],
 " can be used to generate an encoded file which can be read only on a \
computer with a particular ",
 Cell[BoxData[
  ButtonBox["$MachineID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineID"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13512],

Cell[TextData[{
 "No function is provided in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to convert encoded files back to their original form. "
}], "Notes",
 CellID->11107]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->420503178],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->151844530],

Cell["\<\
Set up the name of a file that can be used as temporary storage:\
\>", "ExampleText",
 CellID->10419949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"encoded", " ", "=", " ", 
  RowBox[{"ToFileName", "[", 
   RowBox[{"$TemporaryPrefix", ",", "\"\<encoded\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->612814426],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\encoded\"\>"], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60659676]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Encode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Encode"]], "InlineFormula"],
 " the package file ",
 Cell[BoxData[
  RowBox[{"Collatz", ".", "m"}]], "InlineFormula"],
 ", putting the results in the temporary file:"
}], "ExampleText",
 CellID->206820388],

Cell[BoxData[
 RowBox[{"Encode", "[", 
  RowBox[{"\"\<ExampleData/Collatz.m\>\"", ",", "encoded"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22395396],

Cell["The file is visually unreadable:", "ExampleText",
 CellID->326841271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "encoded", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31981826],

Cell["\<\
(*!1N!*)mcm
QF9tMS QT3SUH-/j'rp5AXLLAC0X\"E_yE>Z>]rk;rDC6H&($a*i;?Mp|\"1dgYc]I'rtwrm
S=JN<-]hiv[A]I'rtw9|t`-cAro@8BD\\#yEu EA>Q1WL5ZrjtFe#\\OG1q9E9]X,9^bQA?]
e[?)JDM_1AQ^V2 9l'cMUw[SXXO?iiO1,u[ik~$<jSDz {NH-r*p*#>Z#r/N&oL8lkQ{ Q
0=Z2d:_+0^5MMg=Jti _Yc]I'rtw9|sj!g($i&YouOVN9`;JD]/fsYiPg\"]woVN:t!f$`?
qo1pp!u,WiB{CpdyoEL.W6'pX7tt)kZus=MP0N7T\\A^{kcCB?i3vA,`+1P,PsyT#s+JUg 
\\X]#;5O)Z((~I3-J_YspfkgxtN&Q ,\
\>", "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->275822651]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " to decode and load the file:"
}], "ExampleText",
 CellID->490957495],

Cell[BoxData[
 RowBox[{"Get", "[", "encoded", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->202979467],

Cell[TextData[{
 "This has loaded the definitions of the ",
 Cell[BoxData["Collatz"], "InlineFormula"],
 " package:"
}], "ExampleText",
 CellID->15182764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Collatz"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->481079669],

Cell[BoxData[
 StyleBox["\<\"Collatz[n] gives a list of the iterates in the 3n+1 \
problem,\\n        starting from n. The conjecture is that this sequence \
always\\n        terminates.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3384088567-4726071",
 CellID->319010580]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collatz", "[", "30", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->95660402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "30", ",", "15", ",", "46", ",", "23", ",", "70", ",", "35", ",", "106", 
   ",", "53", ",", "160", ",", "80", ",", "40", ",", "20", ",", "10", ",", 
   "5", ",", "16", ",", "8", ",", "4", ",", "2", ",", "1"}], "}"}]], "Output",\

 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->438038591]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28459],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadProtected",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadProtected"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineID"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15477]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8775],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->3376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->37113384],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->196911398],

Cell[TextData[ButtonBox["Mathematica Expressions in Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaExpressionsInFiles"]], "MoreAbout",
 CellID->22191825],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->137518433]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Encode - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 19.6830892}", "context" -> "System`", 
    "keywords" -> {
     "file encoding", "hide package source", "encode package source", 
      "encrypt"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Encode[\"source\", \" dest\"] writes an encoded version of the file \
source to the file dest. << dest decodes the file before reading its \
contents. Encode[\"source\", \" dest\", \" key\"] produces an encoded file \
which must be read in using Get[\"dest\", \" key\"]. ", "synonyms" -> {}, 
    "title" -> "Encode", "type" -> "Symbol", "uri" -> "ref/Encode"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6290, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->420503178]},
 "Info3384088567-4726071"->{
  Cell[9205, 315, 281, 5, 70, "Print",
   CellTags->"Info3384088567-4726071",
   CellID->319010580]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14014, 477},
 {"Info3384088567-4726071", 14163, 481}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2283, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2906, 82, 43, 1, 70, "ObjectName",
 CellID->5707],
Cell[2952, 85, 1669, 50, 70, "Usage",
 CellID->21727]
}, Open  ]],
Cell[CellGroupData[{
Cell[4658, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5136, 157, 278, 9, 70, "Notes",
 CellID->4669],
Cell[5417, 168, 649, 20, 70, "Notes",
 CellID->13512],
Cell[6069, 190, 184, 6, 70, "Notes",
 CellID->11107]
}, Closed]],
Cell[CellGroupData[{
Cell[6290, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->420503178],
Cell[CellGroupData[{
Cell[6675, 215, 148, 5, 70, "ExampleSection",
 CellID->151844530],
Cell[6826, 222, 114, 3, 70, "ExampleText",
 CellID->10419949],
Cell[CellGroupData[{
Cell[6965, 229, 198, 5, 28, "Input",
 CellID->612814426],
Cell[7166, 236, 241, 6, 36, "Output",
 CellID->60659676]
}, Open  ]],
Cell[7422, 245, 307, 10, 70, "ExampleText",
 CellID->206820388],
Cell[7732, 257, 158, 4, 70, "Input",
 CellID->22395396],
Cell[7893, 263, 75, 1, 70, "ExampleText",
 CellID->326841271],
Cell[CellGroupData[{
Cell[7993, 268, 110, 3, 70, "Input",
 CellID->31981826],
Cell[8106, 273, 493, 10, 70, "Print",
 CellID->275822651]
}, Open  ]],
Cell[8614, 286, 205, 8, 70, "ExampleText",
 CellID->490957495],
Cell[8822, 296, 105, 3, 70, "Input",
 CellID->202979467],
Cell[8930, 301, 154, 5, 70, "ExampleText",
 CellID->15182764],
Cell[CellGroupData[{
Cell[9109, 310, 93, 3, 70, "Input",
 CellID->481079669],
Cell[9205, 315, 281, 5, 70, "Print",
 CellTags->"Info3384088567-4726071",
 CellID->319010580]
}, Open  ]],
Cell[CellGroupData[{
Cell[9523, 325, 103, 3, 70, "Input",
 CellID->95660402],
Cell[9629, 330, 403, 11, 36, "Output",
 CellID->438038591]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10093, 348, 311, 9, 70, "SeeAlsoSection",
 CellID->28459],
Cell[10407, 359, 700, 26, 70, "SeeAlso",
 CellID->15477]
}, Open  ]],
Cell[CellGroupData[{
Cell[11144, 390, 313, 9, 70, "TutorialsSection",
 CellID->8775],
Cell[11460, 401, 428, 12, 70, "Tutorials",
 CellID->3376]
}, Open  ]],
Cell[CellGroupData[{
Cell[11925, 418, 318, 9, 70, "MoreAboutSection",
 CellID->37113384],
Cell[12246, 429, 122, 3, 70, "MoreAbout",
 CellID->196911398],
Cell[12371, 434, 172, 3, 70, "MoreAbout",
 CellID->22191825],
Cell[12546, 439, 149, 3, 70, "MoreAbout",
 CellID->137518433]
}, Open  ]],
Cell[12710, 445, 27, 0, 70, "History"],
Cell[12740, 447, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

