(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10734,        400]
NotebookOptionsPosition[      7856,        303]
NotebookOutlinePosition[      9104,        339]
CellTagsIndexPosition[      9020,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Read" :> Documentation`HelpLookup["paclet:ref/Read"], "Skip" :> 
          Documentation`HelpLookup["paclet:ref/Skip"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Read\"\>", 2->"\<\"Skip\"\>", 
       3->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EndOfFile", "ObjectName",
 CellID->13730],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["EndOfFile",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
     "\[LineSeparator]is a symbol returned by ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     " when it reaches the end of a file. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Subsequent calls to ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " will also give ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2168]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->593374342],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->221391027],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " after it reaches the end of a file:"
}], "ExampleText",
 CellID->829239879],

Cell[BoxData[
 RowBox[{
  RowBox[{"str", " ", "=", " ", 
   RowBox[{"OpenRead", "[", "\"\<ExampleData/textfile\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->648022005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", " ", 
   RowBox[{"{", 
    RowBox[{"String", ",", "String", ",", "String", ",", " ", "String"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1800483280],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Here is the first line of text.\"\>", 
   ",", "\<\"And the second.\"\>", 
   ",", "\<\"And the third. Here is the end.\"\>", ",", "EndOfFile"}], 
  "}"}]], "Output",
 ImageSize->{426, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55148013]
}, Open  ]],

Cell[TextData[{
 "All subsequent calls to ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " will give ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1045462637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", " ", "String"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->379340305],

Cell[BoxData["EndOfFile"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->77655719]
}, Open  ]],

Cell["Close the file: ", "ExampleText",
 CellID->29035365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->98639599],

Cell[BoxData["\<\"ExampleData/textfile\"\>"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->475888841]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15822],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22190]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15733],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->25605]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EndOfFile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 20.4018576}", "context" -> "System`", 
    "keywords" -> {"EOF", "files", "null byte", "\\0"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EndOfFile is a symbol returned by Read when it reaches the end of a \
file. ", "synonyms" -> {"end of file"}, "title" -> "EndOfFile", "type" -> 
    "Symbol", "uri" -> "ref/EndOfFile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3476, 120, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->593374342]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8877, 327}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1343, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1966, 59, 47, 1, 70, "ObjectName",
 CellID->13730],
Cell[2016, 62, 581, 18, 70, "Usage",
 CellID->16882]
}, Open  ]],
Cell[CellGroupData[{
Cell[2634, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3112, 102, 327, 13, 70, "Notes",
 CellID->2168]
}, Closed]],
Cell[CellGroupData[{
Cell[3476, 120, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->593374342],
Cell[CellGroupData[{
Cell[3861, 134, 148, 5, 70, "ExampleSection",
 CellID->221391027],
Cell[4012, 141, 340, 12, 70, "ExampleText",
 CellID->829239879],
Cell[4355, 155, 188, 6, 70, "Input",
 CellID->648022005],
Cell[CellGroupData[{
Cell[4568, 165, 230, 7, 28, "Input",
 CellID->1800483280],
Cell[4801, 174, 340, 10, 54, "Output",
 CellID->55148013]
}, Open  ]],
Cell[5156, 187, 337, 13, 70, "ExampleText",
 CellID->1045462637],
Cell[CellGroupData[{
Cell[5518, 204, 135, 4, 70, "Input",
 CellID->379340305],
Cell[5656, 210, 165, 5, 36, "Output",
 CellID->77655719]
}, Open  ]],
Cell[5836, 218, 58, 1, 70, "ExampleText",
 CellID->29035365],
Cell[CellGroupData[{
Cell[5919, 223, 102, 3, 70, "Input",
 CellID->98639599],
Cell[6024, 228, 186, 5, 36, "Output",
 CellID->475888841]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6271, 240, 311, 9, 70, "SeeAlsoSection",
 CellID->15822],
Cell[6585, 251, 696, 26, 70, "SeeAlso",
 CellID->22190]
}, Open  ]],
Cell[CellGroupData[{
Cell[7318, 282, 314, 9, 70, "TutorialsSection",
 CellID->15733],
Cell[7635, 293, 149, 3, 70, "Tutorials",
 CellID->25605]
}, Open  ]],
Cell[7799, 299, 27, 0, 70, "History"],
Cell[7829, 301, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

