(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20016,        720]
NotebookOptionsPosition[     15386,        565]
NotebookOutlinePosition[     16855,        605]
CellTagsIndexPosition[     16770,        600]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"], 
          "Setting Up Mathematica Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpMathematicaPackages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematica Packages\"\>", 
       2->"\<\"Setting Up Mathematica Packages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BeginPackage" :> 
          Documentation`HelpLookup["paclet:ref/BeginPackage"], "Begin" :> 
          Documentation`HelpLookup["paclet:ref/Begin"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BeginPackage\"\>", 
       2->"\<\"Begin\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Namespace Management\"\>", 
       2->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EndPackage", "ObjectName",
 CellID->429],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EndPackage",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EndPackage"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]restores ",
     Cell[BoxData[
      ButtonBox["$Context",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["$ContextPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
     " to their values before the preceding ",
     Cell[BoxData[
      ButtonBox["BeginPackage",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
     ", and prepends the current context to the list ",
     Cell[BoxData[
      ButtonBox["$ContextPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Every call to ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " must be balanced by an earlier call to ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5389],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " is typically used at the end of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package. "
}], "Notes",
 CellID->1968],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13542],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " resets the values of both ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16983]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19352712],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->20995937],

Cell["Commands to define a simple package:", "ExampleText",
 CellContext->"Global`",
 CellID->123700429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"originalcontext", "=", 
  RowBox[{"Context", "[", "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->1006476083],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->820623025]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"originalcpath", "=", "$ContextPath"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->256208867],

Cell[TextData[{
 "Modify the context and context path so that symbol creation and lookup use  \
",
 Cell[BoxData["square`"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellContext->"Global`",
 CellID->100740026],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", "\"\<square`\>\"", "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->209051475],

Cell["Here are the commands defining the function in the package:", \
"ExampleText",
 CellID->10197137],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"square", "::", "usage"}], "=", "\"\<square[x] gives x^2\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->303337818],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"square", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->122955943],

Cell[TextData[{
 "Restore the context, but leave ",
 Cell[BoxData["square`"], "InlineFormula"],
 " on the context path for symbol lookup:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->302447557],

Cell[BoxData[
 RowBox[{"EndPackage", "[", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[6]:=",
 CellID->636259839],

Cell["The context is now the same as the original:", "ExampleText",
 CellContext->"Global`",
 CellID->6135495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Context", "[", "]"}], " ", "===", " ", 
  "originalcontext"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[7]:=",
 CellID->189444346],

Cell[BoxData["True"], "Output",
 CellContext->"Global`",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->784895899]
}, Open  ]],

Cell[TextData[{
 "The context path is the same as the original, but with ",
 " ",
 Cell[BoxData["square`"], "InlineFormula"],
 " prepended:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->18162787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{"$ContextPath", ",", " ", "originalcpath"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[8]:=",
 CellID->56516214],

Cell[BoxData[
 RowBox[{"{", "\<\"square`\"\>", "}"}]], "Output",
 CellContext->"Global`",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->519836665]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22984],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " to start and end a package in a file:"
}], "ExampleText",
 CellID->22834368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/Collatz.m\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767735881],

Cell["\<\
BeginPackage[\"Collatz`\"]

Collatz::usage =
        \"Collatz[n] gives a list of the iterates in the 3n+1 problem,
        starting from n. The conjecture is that this sequence always
        terminates.\"

Begin[\"`Private`\"]

Collatz[1] := {1}

Collatz[n_Integer]  := Prepend[Collatz[3 n + 1], n] /; OddQ[n] && n > 0

Collatz[n_Integer] := Prepend[Collatz[n/2], n] /; EvenQ[n] && n > 0

End[ ]

EndPackage[ ]\
\>", "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->34224582]
}, Open  ]],

Cell[TextData[{
 "The package can be loaded with ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->298023655],

Cell[BoxData[
 RowBox[{"<<", "ExampleData/Collatz.m"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->361285986],

Cell["Once loaded the definitions work:", "ExampleText",
 CellID->194831791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collatz", "[", "47", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->310618805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "47", ",", "142", ",", "71", ",", "214", ",", "107", ",", "322", ",", "161",
    ",", "484", ",", "242", ",", "121", ",", "364", ",", "182", ",", "91", 
   ",", "274", ",", "137", ",", "412", ",", "206", ",", "103", ",", "310", 
   ",", "155", ",", "466", ",", "233", ",", "700", ",", "350", ",", "175", 
   ",", "526", ",", "263", ",", "790", ",", "395", ",", "1186", ",", "593", 
   ",", "1780", ",", "890", ",", "445", ",", "1336", ",", "668", ",", "334", 
   ",", "167", ",", "502", ",", "251", ",", "754", ",", "377", ",", "1132", 
   ",", "566", ",", "283", ",", "850", ",", "425", ",", "1276", ",", "638", 
   ",", "319", ",", "958", ",", "479", ",", "1438", ",", "719", ",", "2158", 
   ",", "1079", ",", "3238", ",", "1619", ",", "4858", ",", "2429", ",", 
   "7288", ",", "3644", ",", "1822", ",", "911", ",", "2734", ",", "1367", 
   ",", "4102", ",", "2051", ",", "6154", ",", "3077", ",", "9232", ",", 
   "4616", ",", "2308", ",", "1154", ",", "577", ",", "1732", ",", "866", ",",
    "433", ",", "1300", ",", "650", ",", "325", ",", "976", ",", "488", ",", 
   "244", ",", "122", ",", "61", ",", "184", ",", "92", ",", "46", ",", "23", 
   ",", "70", ",", "35", ",", "106", ",", "53", ",", "160", ",", "80", ",", 
   "40", ",", "20", ",", "10", ",", "5", ",", "16", ",", "8", ",", "4", ",", 
   "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{510, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->65551203]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11887],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BeginPackage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BeginPackage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Begin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Begin"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1842]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11637],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "Tutorials",
 CellID->10824925],

Cell[TextData[{
 ButtonBox["Setting Up ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"]
}], "Tutorials",
 CellID->31161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->461537287],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->49752103],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->127158319]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EndPackage - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 21.0112482}", "context" -> "System`", 
    "keywords" -> {
     "package", "extensibility", "contexts", "change context", "namespace", 
      "packaging functionality", "application package", 
      "encapsulating functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EndPackage[] restores $Context and $ContextPath to their values before \
the preceding BeginPackage, and prepends the current context to the list \
$ContextPath. ", "synonyms" -> {"end package"}, "title" -> "EndPackage", 
    "type" -> "Symbol", "uri" -> "ref/EndPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5910, 201, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19352712]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16628, 593}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2168, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2791, 79, 46, 1, 70, "ObjectName",
 CellID->429],
Cell[2840, 82, 1118, 34, 70, "Usage",
 CellID->29619]
}, Open  ]],
Cell[CellGroupData[{
Cell[3995, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4473, 138, 363, 13, 70, "Notes",
 CellID->5389],
Cell[4839, 153, 269, 10, 70, "Notes",
 CellID->1968],
Cell[5111, 165, 298, 12, 70, "Notes",
 CellID->13542],
Cell[5412, 179, 461, 17, 70, "Notes",
 CellID->16983]
}, Closed]],
Cell[CellGroupData[{
Cell[5910, 201, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19352712],
Cell[CellGroupData[{
Cell[6294, 215, 147, 5, 70, "ExampleSection",
 CellID->20995937],
Cell[6444, 222, 104, 2, 70, "ExampleText",
 CellID->123700429],
Cell[CellGroupData[{
Cell[6573, 228, 161, 5, 28, "Input",
 CellID->1006476083],
Cell[6737, 235, 197, 6, 36, "Output",
 CellID->820623025]
}, Open  ]],
Cell[6949, 244, 158, 5, 70, "Input",
 CellID->256208867],
Cell[7110, 251, 211, 7, 70, "ExampleText",
 CellID->100740026],
Cell[7324, 260, 165, 5, 70, "Input",
 CellID->209051475],
Cell[7492, 267, 103, 2, 70, "ExampleText",
 CellID->10197137],
Cell[7598, 271, 173, 6, 70, "Input",
 CellID->303337818],
Cell[7774, 279, 170, 6, 70, "Input",
 CellID->122955943],
Cell[7947, 287, 202, 6, 70, "ExampleText",
 CellID->302447557],
Cell[8152, 295, 126, 4, 70, "Input",
 CellID->636259839],
Cell[8281, 301, 110, 2, 70, "ExampleText",
 CellID->6135495],
Cell[CellGroupData[{
Cell[8416, 307, 175, 6, 70, "Input",
 CellID->189444346],
Cell[8594, 315, 186, 6, 36, "Output",
 CellID->784895899]
}, Open  ]],
Cell[8795, 324, 203, 7, 70, "ExampleText",
 CellID->18162787],
Cell[CellGroupData[{
Cell[9023, 335, 181, 5, 70, "Input",
 CellID->56516214],
Cell[9207, 342, 219, 7, 36, "Output",
 CellID->519836665]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9475, 355, 216, 7, 70, "ExampleSection",
 CellID->22984],
Cell[9694, 364, 364, 13, 70, "ExampleText",
 CellID->22834368],
Cell[CellGroupData[{
Cell[10083, 381, 133, 3, 70, "Input",
 CellID->767735881],
Cell[10219, 386, 500, 21, 70, "Print",
 CellID->34224582]
}, Open  ]],
Cell[10734, 410, 205, 8, 70, "ExampleText",
 CellID->298023655],
Cell[10942, 420, 108, 3, 70, "Input",
 CellID->361285986],
Cell[11053, 425, 76, 1, 70, "ExampleText",
 CellID->194831791],
Cell[CellGroupData[{
Cell[11154, 430, 104, 3, 70, "Input",
 CellID->310618805],
Cell[11261, 435, 1517, 25, 139, "Output",
 CellID->65551203]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12839, 467, 311, 9, 70, "SeeAlsoSection",
 CellID->11887],
Cell[13153, 478, 452, 17, 70, "SeeAlso",
 CellID->1842]
}, Open  ]],
Cell[CellGroupData[{
Cell[13642, 500, 314, 9, 70, "TutorialsSection",
 CellID->11637],
Cell[13959, 511, 283, 9, 70, "Tutorials",
 CellID->10824925],
Cell[14245, 522, 408, 12, 70, "Tutorials",
 CellID->31161]
}, Open  ]],
Cell[CellGroupData[{
Cell[14690, 539, 319, 9, 70, "MoreAboutSection",
 CellID->461537287],
Cell[15012, 550, 150, 3, 70, "MoreAbout",
 CellID->49752103],
Cell[15165, 555, 149, 3, 70, "MoreAbout",
 CellID->127158319]
}, Open  ]],
Cell[15329, 561, 27, 0, 70, "History"],
Cell[15359, 563, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

