(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15997,        541]
NotebookOptionsPosition[     12727,        435]
NotebookOutlinePosition[     14176,        474]
CellTagsIndexPosition[     14091,        469]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ScientificForm" :> 
          Documentation`HelpLookup["paclet:ref/ScientificForm"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ScientificForm\"\>", 
       2->"\<\"NumberForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Display of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EngineeringForm", "ObjectName",
 CellID->18859],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EngineeringForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EngineeringForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with all real numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " given in engineering notation. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EngineeringForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EngineeringForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with numbers given to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]digit precision. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17393]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
In \"engineering notation\" the exponent is always arranged to be a multiple \
of 3. \
\>", "Notes",
 CellID->16363],

Cell["The following options can be given: ", "Notes",
 CellID->30606],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DigitBlock",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitBlock"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "number of digits between breaks ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to apply to exponents ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentStep",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentStep"], "3", Cell[
    "steps by which exponents can increase", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberFormat"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function used to assemble mantissa, base, and exponent ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberMultiplier",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberMultiplier"], "\"\<\[Times]\>\"", Cell[
    "string to use to indicate multiplication ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPadding"], 
    RowBox[{"{", 
     RowBox[{"\"\<\>\"", ",", "\"\<\>\""}], "}"}], Cell[
    "strings to use for left and right padding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPoint"], "\"\<.\>\"", Cell[
    "decimal point string ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberSeparator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSeparator"], 
    RowBox[{"{", 
     RowBox[{"\"\<,\>\"", ",", " ", "\"\< \>\""}], "}"}], Cell[
    "string to insert at breaks between blocks ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberSigns",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSigns"], 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<\>\""}], "}"}], Cell[
    "strings to use for signs of negative and positive numbers ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SignPadding"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to insert padding after the sign ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->18978],

Cell[TextData[{
 "You can mix ",
 Cell[BoxData[
  ButtonBox["EngineeringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EngineeringForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->109346987]
}], "Notes",
 CellID->12641],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EngineeringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EngineeringForm"]], "InlineFormula"],
 " acts as a \"wrapper\", which affects printing, but not evaluation. "
}], "Notes",
 CellID->15458]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160782666],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->84118844],

Cell["Different numbers in the engineering notation: ", "ExampleText",
 CellID->420529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EngineeringForm", "[", 
  RowBox[{"{", 
   RowBox[{"123450000.0", ",", "0.00012345", ",", "123.45"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503332006],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"123.45\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"6\"\>"]}],
     1.2345*^8,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"123.45\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"-6\"\>"]}],
     0.00012345,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"123.45\"\>",
     123.45,
     AutoDelete->True]}], "}"}],
  EngineeringForm]], "Output",
 ImageSize->{233, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//EngineeringForm=",
 CellID->510930081]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123485214],

Cell["Using 3 digits of precision:", "ExampleText",
 CellID->26605178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EngineeringForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"123450000.0", ",", "0.00012345", ",", "123.45"}], "}"}], ",", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250656766],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"123.\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"6\"\>"]}],
     1.2345*^8,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"123.\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"-6\"\>"]}],
     0.00012345,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"123.\"\>",
     123.45,
     AutoDelete->True]}], "}"}],
  EngineeringForm[#, 3]& ]], "Output",
 ImageSize->{191, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//EngineeringForm=",
 CellID->45326833]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22357],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScientificForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScientificForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24517]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->20986]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->260443751],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->260462283]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EngineeringForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 27.6364178}", "context" -> "System`", 
    "keywords" -> {
     "engineering notation", "number formatting", "numeric formatting", 
      "number representation", "number output"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EngineeringForm[expr] prints with all real numbers in expr given in \
engineering notation. EngineeringForm[expr, n] prints with numbers given to \
n-digit precision. ", "synonyms" -> {"engineering form"}, "title" -> 
    "EngineeringForm", "type" -> "Symbol", "uri" -> "ref/EngineeringForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8231, 255, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160782666]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13948, 462}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1876, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2499, 75, 53, 1, 70, "ObjectName",
 CellID->18859],
Cell[2555, 78, 1058, 32, 70, "Usage",
 CellID->17393]
}, Open  ]],
Cell[CellGroupData[{
Cell[3650, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4128, 132, 126, 4, 70, "Notes",
 CellID->16363],
Cell[4257, 138, 69, 1, 70, "Notes",
 CellID->30606],
Cell[4329, 141, 3194, 82, 70, "3ColumnTableMod",
 CellID->18978],
Cell[7526, 225, 416, 16, 70, "Notes",
 CellID->12641],
Cell[7945, 243, 249, 7, 70, "Notes",
 CellID->15458]
}, Closed]],
Cell[CellGroupData[{
Cell[8231, 255, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160782666],
Cell[CellGroupData[{
Cell[8616, 269, 147, 5, 70, "ExampleSection",
 CellID->84118844],
Cell[8766, 276, 87, 1, 70, "ExampleText",
 CellID->420529],
Cell[CellGroupData[{
Cell[8878, 281, 195, 6, 28, "Input",
 CellID->503332006],
Cell[9076, 289, 629, 22, 53, "Output",
 CellID->510930081]
}, Open  ]],
Cell[9720, 314, 125, 3, 70, "ExampleDelimiter",
 CellID->123485214],
Cell[9848, 319, 70, 1, 70, "ExampleText",
 CellID->26605178],
Cell[CellGroupData[{
Cell[9943, 324, 221, 7, 70, "Input",
 CellID->250656766],
Cell[10167, 333, 630, 22, 53, "Output",
 CellID->45326833]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10858, 362, 311, 9, 70, "SeeAlsoSection",
 CellID->22357],
Cell[11172, 373, 467, 17, 70, "SeeAlso",
 CellID->24517]
}, Open  ]],
Cell[CellGroupData[{
Cell[11676, 395, 311, 9, 70, "TutorialsSection",
 CellID->24],
Cell[11990, 406, 160, 3, 70, "Tutorials",
 CellID->20986]
}, Open  ]],
Cell[CellGroupData[{
Cell[12187, 414, 319, 9, 70, "MoreAboutSection",
 CellID->260443751],
Cell[12509, 425, 146, 3, 70, "MoreAbout",
 CellID->260462283]
}, Open  ]],
Cell[12670, 431, 27, 0, 70, "History"],
Cell[12700, 433, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

