(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66797,       2330]
NotebookOptionsPosition[     54875,       1910]
NotebookOutlinePosition[     56196,       1948]
CellTagsIndexPosition[     56110,       1943]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseErf" :> 
          Documentation`HelpLookup["paclet:ref/InverseErf"], "Erfc" :> 
          Documentation`HelpLookup["paclet:ref/Erfc"], "Erfi" :> 
          Documentation`HelpLookup["paclet:ref/Erfi"], "ExpIntegralE" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralE"], 
          "ExpIntegralEi" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralEi"], "FresnelC" :> 
          Documentation`HelpLookup["paclet:ref/FresnelC"], "FresnelS" :> 
          Documentation`HelpLookup["paclet:ref/FresnelS"], 
          "NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"InverseErf\"\>", 2->"\<\"Erfc\"\>",
        3->"\<\"Erfi\"\>", 4->"\<\"ExpIntegralE\"\>", 
       5->"\<\"ExpIntegralEi\"\>", 6->"\<\"FresnelC\"\>", 
       7->"\<\"FresnelS\"\>", 
       8->"\<\"NormalDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Erf", "ObjectName",
 CellID->17702],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Erf",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Erf"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the error function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"erf", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Erf",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Erf"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["1", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized error function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"erf", "(", 
         SubscriptBox["z", "1"], ")"}], "-", 
        RowBox[{"erf", "(", 
         SubscriptBox["z", "0"], ")"}]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16077]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is the integral of the Gaussian distribution, given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"erf", "(", "z", ")"}], "=", 
    RowBox[{
     FractionBox["2", 
      SqrtBox["\[Pi]"]], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "z"], 
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{"-", 
         SuperscriptBox["t", "2"]}]], "d", "\[InvisibleSpace]", "t"}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->19993],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["1", "TR"]]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["2", 
     SqrtBox["\[Pi]"]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      SubscriptBox["z", "0"], 
      SubscriptBox["z", "1"]], 
     RowBox[{
      SuperscriptBox["e", 
       RowBox[{"-", 
        SuperscriptBox["t", "2"]}]], "d", "\[InvisibleSpace]", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->16135],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is an entire function of ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " with no branch cut discontinuities. "
}], "Notes",
 CellID->27040],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Erf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erf"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->377292285],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erf"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erf"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18606059],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->304798763],

Cell["Evaluate numerically:", "ExampleText",
 CellID->127959318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", "0.95", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389824926],

Cell[BoxData["0.8208908072732779`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169568334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->694841897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Erf", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417862309],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WEtoHlUUvs3Mn9g2bW21ta3GRLftwqWb+qpNmsT07yumsQimQUgW2lIj
gm50oxvd6MaC2IUP8LGoGFoKFUoLYkEsiAVRQSpIXbQIli4Cwvidc+7MvXPm
zPRPgj/JnTvnfPe7c+553DszNjU38/wLU3Oz01MDQ8enjs3MTr80MHj0OETJ
CufcPP5f2ezQz9Dj//kswzVuR9AmUHXRHXUy/rkudJ9jxKjSJNSk4d65VCEO
sVikV3766/IPf+LPbaMmuXbtH49aiyY1RnfKz7jkxo1bR1/8Gn9uOzXJxPin
j+44gT+XUNO9r/2R6N95++JXp67gcdZ0NB8JJvj2YWpXYh6xAySgmp05NTp8
8o3Xz31z7je3aokWPEJt6+bNBZCACo/+xec/ujuWyPY447C+77377bOHP4Ol
LUjIj93+2jLH7WTp1at/wyYY5+4yUU+ydGHhXxh/8sPv3QbPOcnaQbqDeL05
doileCyYR911Jmo3S1+eO33puz/y+KhDwRvTR75EW4MaZimIQEdd7XNBjbD0
rTfPnzn9M3V7SzaNqJl6TQ7JDhgG86i7ugGF1YOPictGPaW4dFzFqMBFKAKJ
dkxxrDQ5xhSHjdqj/KYjM0aBBVxgrEG1WSoJQ92e0lO3lb96TI69LMU0UkQ4
rm2vkheTXPvJx5cdVbjaDOBoKWUYj23BJpSPQliTd5Q/aV5Bq3maovagbARJ
sLo6r4yQEhNJOnhiwaGWOPl1ammBu3jhd1Y2rqmsONU8+dno/Xl0oURSRNio
Ayx97dWzfuYki7NPtEhMpGeureOA1fATzWSjDmblyqL3uhgV1r4JhQBEGOao
4NFxjhsUjF9/uR7i5plCRzXS5pWRKNqownrkPWpEn4+4e9lhMB2BKgP6vWZA
jbjb5Lk/unc5XyIbJdvmGWOMzbwuCzlA1y3+qv2xlZ845LlzD9TYtpHVG9Xs
Dyr0FuYLkVZF3KcYNvF1k481jebn8zFpzdfnx5VZeI1KWSWzSvQ6E9FfYrI8
Q9o+lksdyle/y1g18QJHUoLo89k5GUlpz5ZFiKV0JIulkzkvUiorYrOQ+tot
0nmzAui6o2v07fSLxXesl0r+v8+3XD6uDqW4p25/3b2UmkpWajyf6YIfEQwU
D8q7CAY6QgcpRZpLkFo+Gp4OeB/Lsp9PVOQS+VU5iEAXyVvFM8o2Gc8RdNjB
T7x/KdLJk6GDYyvOuvGo7mIUfnJWGK/RysmmTivLEWl7Yi2qDSKK9tuDBSK8
R4VzzoHyGsdejna3JlRxCqlBSY0Np4z9DaiwuwVU4qJ3KT+TzZGqmfY1oMJM
gqqcylhqn8pS9TTCUD276FOi3lmFN+z7e5fFE7y1GJ6ksC/sUnXj8/c1u2aE
mGo3jK+uo+YJu2+75Jkef9WjxKpw6t5jep1Ho6i0C21SrEjwpD1W3hjCSXCs
AVWckGpQ8iZTnMDkbakGhekwaRlFIHnvQl1BdaHuqMmxSnHYqNXqeUYaUMEz
NqpXrdNwgSK/rcnX2r+HDZscggqxvNtErVUzDTWgUANhHoKjBiVv+9CjcBBq
0ETdyfdYcM+1q2TbBtZiCeXDhnyNqHAwKsUKIEKwX2ARnsjyCA+1OcpPI2f4
JJViw5GvMTDuMeZY/Fcw3sO78TTYZpD4WEzURNzuWCLfZuaDQ1BXkU7yYQte
pKzj2PHf2VpoHlrEHCTYmscOxiI2nHAiGP23tRaabfxRbdfOD3xWdC3RjkPL
Ghe/iYZvlNXvmm7Ffz37rgQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126263373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->768344780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Erf", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178610415],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    SqrtBox["\[Pi]"]], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"3", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], 
    RowBox[{"5", " ", 
     SqrtBox["\[Pi]"]}]], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], 
    RowBox[{"21", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], 
    RowBox[{"108", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2 Pi^Rational[-1, 2], 0, Rational[-2, 3] Pi^Rational[-1, 2], 0, 
    Rational[1, 5] Pi^Rational[-1, 2], 0, Rational[-1, 21] Pi^Rational[-1, 2],
     0, Rational[1, 108] Pi^Rational[-1, 2]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{312, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32001075]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32264],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->801837449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{"1.5", "-", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692212353],

Cell[BoxData[
 RowBox[{"1.0783992074989337`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.027963711238656177`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328135914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96267630],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->341459284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Erf", "[", 
    RowBox[{"3", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135564340],

Cell[BoxData["0.\
9661051464753107270669762616459478586814104792576367803724845356762`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392513623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80544473],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->477423137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", "1.5000000000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109436616],

Cell[BoxData["0.9661051464753107270669762616459080107`26.901468925905565"], \
"Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101877511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156855197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erf"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->285989131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{"{", 
   RowBox[{"0.5", ",", "1.0", ",", "1.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152559488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5204998778130465`", ",", "0.8427007929497149`", ",", 
   "0.9661051464753108`"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232304274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->814768815],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->480775764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286854956],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485208026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12674324],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->353782497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->719193810],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Erf", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->634417955]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->617531883],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Erfi", "[", "x", "]"}]}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->526221517]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15410],

Cell["The two argument form gives the difference:", "ExampleText",
 CellID->356802223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Erf", "[", 
   RowBox[{"z", ",", " ", "w"}], "]"}], " ", "//", " ", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28912365],

Cell[BoxData[
 RowBox[{
  RowBox[{"Erf", "[", "w", "]"}], "-", 
  RowBox[{"Erf", "[", "z", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->583799466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1301177],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erf"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->82459882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337476288],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    SqrtBox["\[Pi]"]], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], 
    SqrtBox["\[Pi]"]], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "5"]}], 
    RowBox[{"20", " ", 
     SqrtBox["\[Pi]"]}]], "-", 
   FractionBox[
    RowBox[{"241", " ", 
     SuperscriptBox["x", "7"]}], 
    RowBox[{"840", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    RowBox[{"2777", " ", 
     SuperscriptBox["x", "9"]}], 
    RowBox[{"20160", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2 Pi^Rational[-1, 2], 0, -Pi^Rational[-1, 2], 0, Rational[11, 20] 
    Pi^Rational[-1, 2], 0, Rational[-241, 840] Pi^Rational[-1, 2], 0, 
    Rational[2777, 20160] Pi^Rational[-1, 2]}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{332, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28336513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->864415758],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->351271142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{"{", 
   RowBox[{"Infinity", ",", 
    RowBox[{"-", "Infinity"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287215045],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69607942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{
   RowBox[{"-", "Infinity"}], ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48864689],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274048625]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25202],

Cell["CDF of normal distribution:", "ExampleText",
 CellID->94684005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81418041],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"Erf", "[", 
     FractionBox["x", 
      RowBox[{
       SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}], ")"}]}]], "Output",
 ImageSize->{125, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38444634]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"\[Sigma]", "\[Rule]", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->277323216],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WE1oHVUUvnnzXl4SbWtba6siBE27caWLUqg1tjFJ/5I0bX6qQSEGIVnU
So0b60I3dlM3urEguvAH/IOKpSJUEAvSgliQFooKUkHqwiJYXASE53fOmZl7
73lnJj+vGF7u3Dn3nO+ce/5m7gxNz88+e2R6fm5munvw2PTzs3MzL3QPHD0G
UtLmnDuD/5c3OcwbmPH/mUYD13CsY0ywVMG1gmtPej+UXjer9YSlOmisEiL/
pesu8ZQedT+k7h8wEcjsNroKSZTxX667VOu9GIihdgu0/z97XFzL/annh9Pr
lluGWmb75iVoqTd8TmSWhZb2qHUJZ3MOTindE34Pyc2bC+++8z1+bjUNyScf
/3jph9/xc2tpoPVU6kEThTLhs2z/KabnaVf3Om/0veav0tB17dpfIH159ios
PP7SV09NfdTf9/bR57744P1LoN+xTB2rW7SpVXyJ0sOKyv6rLyz8C6+feuvi
5PiHM898+vnpK/C/u0/xHjARt7Oyn3/68/WT5yEOXwGNK7Y5ajvYuRJ78H59
7pd7TL5e5rtx459XXzkHz0NgU0NybZLXd7LU+W9/hbEUpY0myi6mXr/+N7gu
XvjN3WVy9TEVNkMRcW0wuR5XXHeaXP2Ka31k9UC2Ojd7Gv5y60yMwcBqisJa
k2s3UxE05CNNdTYK1x7SD18Xr7I9wLhy+Q+3JrJ2L6/Cu7CDIqrzSzD2pRqK
V1lD2u2TgIvv8V8tlqQ+JVtUvd8tLocrgoCJriOygW4D/pqsIt8wIWu1jO6y
zbJiFLrYcmTbQ1m0FxhQCewXur3P/WmseDtQ++Yb3+X9WFe+SIxksUDh0U47
o2hLbQsQTXVHnQi4PIbNNaqw6iVcHsvmOqiw2iOrZRVVMjrynhU3wTjEVAAA
hkNWwoV8RyCKucaYisxC8+FQlXChA7w4f7aYa5ypKC80g0aamX5vsopWjL6a
rRbnAa/W81VJndSztmRYKcKeew8PAnrGLVWOdkcEV0MYQv3ucIlElv15rcKj
lP2qNiO5WiPIenFvWX2ZslJhCDJCLSuHI0/WY0/61Ms5eaz6rMvoTzAd4ULQ
pN9NenqCICPUHuVJpuJRkLphMqDincOgii56Jgh1KsqX/G0LWrwfcioUUY9X
VCg68do3IbUqLRBbg6LxSE9YQ2OxBK5SOV4i6IwIEz0Nx5ozNuyTWefycsgI
6uFjZVlUmFfyh32gBA4tCyHJMgxFgFJwy5OOqxDKUYUUuYMlKInRtSWv8QKE
tySajhbIazndaypB9nmcMNsrxlNGoiNJQ9MDUSYIt4QnXm22RCJA05ESLl9m
ZVy+5mwu8YXP0uHIaulvPiLDJka7whgq4fJYNlddYe0v4fJYnous7lQY+0yM
DoVhcwmWf3rtjXKhsCKbELweQVhybQRIXXwvjxqa7mkRyb9JFCFlTwC6kvht
LCctkKa7V2zB7Xzvn+SDLSKh6FB6HimLUPb2o6OySuXIgBn9VZmf0Kdxvgi4
CHON0txvYvAZAe/79qqcM6Td07SvhAu1DIeRHTaXnHv8OWhXZO16XoW7cTig
1Z0mhnDBGOyJuB4zueQsh4MGuMieXpNLzoVyHkL5uEdNLj5j0rsBnIB4wNmP
RHbfzfwIE3KVXhO2myjMVUMuy5kaKUq1ti3PhezL3WLVyqfwGvaEDEfjxEgf
V7Yyjv4y1PwVTucmfw/owN5gD9yefwwBJtzy0ApRu2nozL9AABLp2bvjFNyM
OZ9rkG9d/FUIOwltWaI2YtiS5Qtw6JTGmHSwTOBfaMPPbaQhkQN1jraCHU20
JKdr/WmmNn9dc23/AetSLOA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163893152]
}, Open  ]],

Cell[TextData[{
 "Cumulative probabilities for values of normal random variable to lie \
between ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "n"}], " ", "\[Sigma]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"n", " ", "\[Sigma]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->54673809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", 
       RowBox[{"n", " ", "\[Sigma]"}]}], "]"}], "-", 
     RowBox[{"CDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"-", "n"}], " ", "\[Sigma]"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "4"}], "}"}]}], "]"}], " ", "//", "N"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->386351549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6826894921370859`", ",", "0.9544997361036416`", ",", 
   "0.9973002039367398`", ",", "0.9999366575163338`"}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11431102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186597466],

Cell["\<\
Solution of the heat equation for piecewise\[Hyphen]constant initial \
condition: \
\>", "ExampleText",
 CellID->264292050],

Cell[BoxData[
 RowBox[{
  RowBox[{"temp", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Eta]", "=", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "/", 
       RowBox[{"Sqrt", "[", "t", "]"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Erf", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "\[Eta]"}], "]"}], "-", 
       RowBox[{"Erf", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "\[Eta]"}], "]"}]}], ")"}], "/", 
     "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191879763],

Cell["A check that the solution fulfills the heat equation: ", "ExampleText",
 CellID->665200496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"temp", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "==", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"temp", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], "//", 
  " ", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8153766],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->357609782]
}, Open  ]],

Cell["Plot of the solution for different times: ", "ExampleText",
 CellID->338076599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"temp", "[", 
       RowBox[{"x", ",", "0.01"}], "]"}], ",", 
      RowBox[{"temp", "[", 
       RowBox[{"x", ",", "0.2"}], "]"}], ",", 
      RowBox[{"temp", "[", 
       RowBox[{"x", ",", "0.6"}], "]"}], ",", 
      RowBox[{"temp", "[", 
       RowBox[{"x", ",", "1.5"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->823661425],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylmglwldUVxz/zliy41a22nba21dq9ne7WUqS4RauxKlobN8AlVAVlsTai
DWLDKKgISghiAgk7AUOhQWyqCIJgM6AMjBapCJWCHVIqEYcoM6+/e89937m5
74s67Zvke99y7znn/s//nHvu/d5Fg0ZV3XjboFFDhww65bwRg26vGjpk5Cnn
Dh/BrdQRURQt5//3J0ec5ziz/8tzOb4LjyXmmDIt7Cc6jUOay4vd91eC56nE
Xl/2rjlGFcF1spT8l/kURYXXX3A2pILeFblkm9O2ezbQ/bWP6H1q0D5jv4s5
Fn2M3qe5dj17nW6u0tpK8Ox55/QePZMQNU8vcd9fTUTQ92Rl0OKKD7lrei+1
OMdoLZ4+bu7jQ6NU85Tro9LpD/Wvn9iXv6bJV5sbUdT65CMrmuasmv9ClH1+
wXo7Er75W/HI0tTy2kVRyaLh9fMGP9x81fj6vnfw9Km7Zj5Tt/Kl57dlN23c
bTXwbU5LzCEj13Nmbxpa1bqi7TVBwbMzxCO8Lv6I5xafTFdXN/IfmrjmL+3b
zWjLAlsy5lC8ZkkHI5h/02QeNFwwhlEsvGVqlDajSq2a84IZL59i813yTPPi
5TNnABZ3QKZh0sWg9OQjF6QNTKlF9dXc7z7U5fyTDayy12V7/7ll1xvrO9Y2
rPnzxGULhs2YNKC5rmJla/XmjoU8Oso23L/z7a2ta1fVzmuuuHdldcP29o3p
QFYfe93dfZgRbt2yN/p08Pxkey0PzemRwfMiC+OBPZ3rJrc2lle3DJ7Y0fD0
rvWvHu7+QNr2OfDOnu2vtq97bnJL02BGyREjMfu1LW27d23kaYEXrMzoROuQ
g+927nh9Nb1b51Q1TilvX16DsMMfdNvxpXes3txe07Sgcjwnn7BSXt+2b8jg
FnP6qUDqJ+31mtU77q5eaU6Ptb492HlA4Nm8cFV313uRlVu8v3MnFi5oqJz7
xEBUAum+t7dFx3veWLj5T61bn9m2b4fIyeItDKMtRq56upbmYiEeAPi2UfUo
OjbA8uREC0ePatuwfpc5PcZev9a2gQFyFNuMpq0vt2IbfxiJqVZuuvvw++t3
bWroWLjnwL883hSv3vHSxDVPDG65s6L5ptpVU9u3r+3qfldkZwASN+AS0AVm
0ZACTPy4b9tbtlVRY0NHiOVJ9pq4+GVFM9yJjrYW4HOw5A8gre8zeBd2wkuO
GCpYFe/c/9bsTU9Vtd49YEblqLZazrHdcb3Utug8uL/ttedq2ieVNw4atmws
SHNHbE5DbgiEzbBf2Aj7WqsmQTqxIwW8gJyE8EkBB2S8mIuDDMJiNQhDOFwP
ziAkerMbd28Fx4Fzb6lccMe0DXO37N1meeu8Ik+BGHMxnQEJJhChbfEo/hi+
xBoowQi19sLyRoBU/4fWTpm8btHCzRp79F827HHTX643bZiNqVDU2Qm6sSUA
BxvKrJ3Cd+yEBMDKkSE4G4ASQJEUhTYKQsOHLSPH9W6jcjrs3yePAgzbsHoa
0DoWH34fmOAAaIp77f3oOPFA/il/nIgVaXyBCASBZVleD0wlxhwWilWynYq1
2AlXcbs5LctjiXgYJhozgIerJXAMWsdqZspwzV2ekQpMRIkF9EUCqcBJxDa4
aTKLaGSWGl+7KslCKzW1Z8+BKwfOVQtJS2RWc1oqUX6oCzIBA2AIW8lBBAq8
JI6MHRZBkZ4B1snrZvKMtGCeuWx/qItEhQxnIxAAhKKgOdRIMXVDGDfSjgzB
2EymL5U4fGePhKVgkYZrcJDMQ86xo5OcnMES7AmtIpeROE28iTQSO/NVPHKT
bXBf78jheNyv7ZUbcs1kg3VmvunjWccfJ1Zi9Jme1rm85DDa0kbWMdZJjUA6
RzpH95xE2Nl5UJkWWkf1sLR1a966IiZJsQqm4E8z11s5abxZvXKCWGXRij5r
72MVTCRYSOdl+ZjtYRET/ZqJi3T8GrPJFuk8U5JnKvOMXjNiWBL7Iw2XZB7B
AotU9Hl7nxgRi0k8pYmWyWSikgkAwqB3y66pXLBz535tTyphSjKnxXnLYEr8
3Mx8eEwSiUXL1vzWw5KrAa8ksEwk7d3yJgxWTfXTNlBM5i1T5vfrW+8sDPsV
570IVmoREzFACb0/Zy36km0HpbCIcIiS7QlHCmUgThJSJwTZIkQ6myTf+JCc
xZyLr06xdp2av08O4T4noplqgJ4qCbEIV8ugDgTq3TKdg5281ZsZnMojGuG9
jpwsDzIm13/R2iVrQXCUQHStyM+kLZWieMm1Zq6s85+/6rOLw/xaqcBizW7F
AZbSXrKbiVSrKw2EAAac+Nh6163XYCOUY+KigVhF8UMloZIUS3lO4iB9xM97
rO8ygf3JtitPsgHa0h6rZdp0z0EUfoKuXXnm14XMaNw1aEsvvIOP8JTrRdmx
e+PrquWcATMo/qzJBXaHa5a088eJQZyFfhTNqIW6KhkoARRYAdcyQ1bUDmty
D7xN50fqsnwmkXeEC0GTbHO4Dgl3DATrsTXtrAOTvCnXlI4UY7GGFEkJVE31
YPcvom/Yu5KbDN+lFXUDizgTDyKFFQmTi0rVbP6/2q0SRKLWPmKBRrztb3IC
/CblA7LlR/RNex+6Q3rhvWjSfCyStGYRTZrvC20vvJPMcJ0TRAfgzB04ztQe
cq3RKTbBbfA1DP+6FfvtnGYZ4wtphdkYr5ipVLFCZ+2M42/W+y60UqsAy3dm
+XQ+kvCuqSuL8ryVPAyGlg/Rd2w7MIfnzBvSzvRjVCZu0wk+Myuz5Oyr81U6
YJMdZ3E8bj4S9YaJ37KWfNe2wAYsYW7nCv1YYbgpKOnsJ9K1pj0xsMaumL1Z
yjEtjkmxJp49+ZB9pJQQj0XfM8dsbCNXBBchJpI0R4tlOislW6KzkvTXvCP7
GAff7WRVDYuE/JJwxDfR960lPvtxKclRNGv1lQo0JVuilsbMw0nxdUZkSx1h
WGy9Ev3QPgMH7nbs6BBbHVeUu6kA9WQL1GvSXqPWysuA8+pnJ7F8kLJAPBH9
yIIHL2DHA08/QMZIJSFpdpSYHnrXrtW67V8CoaCVNIFvUxqvG7RoNCurH1it
Z9iGcOPXM69f9de5TkfAI28+OsFFqUSDzja2X0lc6fKB1dWN192waCSUs+hG
P7FM2PSPVy6dfmXjhjmmTfcH+Mas4USPziEnJI5N853Vl90wbfmm2e2couOa
5ptqltz1Y6vpTPv079vX3tl0o9QLUAgiiRZdUydr0XwuWnD+gT2dYHTt/OFT
m25gYKLlp9abRHzbulnQZtrTjWDtRqJrgEQdZbENfJj6Z42egJ11Lza3zKli
SX+Gyje7UrBx/ztvEzOXT7h+099eLgqwSNRQHGNJoFVPuqey4VaTnYtYDFo/
RH3NsZRigJKA05YZzb+aPhRSEn6SnC2/Yl+XCgdM9p9/+8gRt3T95x3ZezDZ
SyT+zHJAMqAwAZoxK9wzYzb5NJGtJf3OmcIah0BYv+I51qUIa7UInKkSS8kd
ZEmTQSrHI5eQuXHWfRV1w5jpC8Zu9ypLzRienXnWo9ezouKGLHilxBVUo37W
C5IfmUz44waF6m01zWRJTCIQi3JepZuJddj+hfOU3SPqA9gMmtL6sefmXX3N
POF4Y3n1vr1vuEwv+s+yrc0O6JolEjJQDuJxgs30xwT7niXQEu4yh9d2d+XI
2ArxZywaFMBCNmL6qh1Zyc7zrx0HvFLpy5gxBdEAYhZWrqZIu0rCKLXrfbOX
I/t3aDP5TKImrvrR2D73QaC33oz62z5QZPGUW4BdkqmMI4tInMqCiRPoTtz6
409CvURi5PD7WAiLMEL2vESeZGI80HD5HYtmDQJ+seHnFrqlc4bNrhoh+dS2
L/WrJVlRIhBDzDyRVJvYWsbsCzJx4LABMyqxncb2PROcZ/3avnHWA5eb+qSf
pxm8n6g9t/ONtygnCus0GTOoYgJjcu/ekEzpYDhfZA7uXRyt5NrUFVKxlzcO
wnAmUuM92fuQPN1SO3Jl01jr8WiAvb+irnbJlOFSW+XXEXHNC6KmXkohMkr1
rb+CW6ARFZnrNE+wDsXQS/YQAXppy7PTa8q7Dx70dUCpJ2suufXmh6kyw2i1
O2opaDLz4auWj5sg3IjOtnfnDb73sdqLN3a8WRDj0mvcmDGz7q0C3x69mBEe
vn30glnVyZkhzQz4yP2XPln+W0jh9UszRU696L6maUNJiMcHPeUtgKSm0Vfd
v3TEdOvF6BzB9vwxTVNXSMFwXEJPk3GjVHW/+7b88UVzr7/Xt+HmuvqRcyQL
hX3lPYLser7XdejRvqPNPOlpzjxV9+zjl/yBU1kY2REaD0rPeL32yoqN48+u
EW9ITxObdf3vRF5cPh8baLe71xmKEBYvnC6/p/l3lz3myygmqTxY8aAUzXGG
dm9WeuYjg4BwuuGCMSN/s9iceuNIQYxhl9a3jap3zKc8w6jYCk+a3f0sjp/n
ZO68egLc821LQ+fLKpqktBCZur9xVCBT9kjBCZzNCKQ9BdvCsQtV7rn2LuEq
c4mb5eWlWd6yonxGTMXTmGtHBdFct4YoDKVJQnatdFcgfBdYmn+OQ8wucCrP
WQoO0gx/ntw0+XT3rn8z6cBxkQwXQMzY0ydRcrBaS0tdJRWGJzkja0VdKxXl
JwWAY8AudyVlypJAj2Q9qayIfwjp65EKbNf6Vw0p8hkxK9JkLAalwtkxXJ9n
PdxQLPk6E6+yRI3vk4zYAnCYFmoW5bioF826AyZsMu/9rAUZqT45laKsh8a4
jqNRrFFnopytpLlkCIaeCet4qQHkdaPxsc3gmXhlKum9h864bid8kqqMIjca
GzeoT8JW1tuSn/AryIheRC4b9rg0guGSX0VvCUpR7QREkVs5uxEdE9lX84Sp
vNYEPqfa6iRzY4y8UTXzaWlPZGWrz9eWiddhfGB0lJ/dLGvL5G0vqM6YNKB+
Yl9ucSSNox8Q+/TE0FUpnvRsvM7kI4w6xsmW93A+DlKAeb29VaxgL5GQS8hP
Nhdk45jL2TIVmvrSdEUaZy8WnUnS4reIbt0l7XXF6ucn3T2VVvoeI1mqJLN8
e1P/iI3n5XI9dk5EWrwuLch2Io3QJwFoe11rDvCk6opRWuluQShV3u0EuwHe
KsqXqitEt+bueo9e+V9eaJ4nSUIslaarPl+arifd3licP8NsLDYGe0qeNb5U
tVxaxXzrJcfrmj4dIOdL1fe80kqWXGpbKFV3J6S9vgdWqYYJkrN0JySUFr/7
c97JBJzxbdQ9+XTA5jLnndIgCqSdRonPS307kQl6lQY2Fudt7LGTqZHsS9W7
maBXstRwZ1et8qSm44jMBe9gnMVJM282jxH6zVvVbIChyD/fwzth3hPzP/aM
q6ORa41dX5ubDAu18aH7R86yOibBUCPC1+Im+UQtcAYJva7svPgu9mSFGiTq
e5tH7drOSelt7lZ2SBzonryvx23LfJge9+ui3vRoThU9Gq2+nniWjvx9eYt3
L16Xa83/Il13Ks/xpCuzJRL0NxL5FahII+0wGo0YAAGWUJrGmWQUjV7ZAfe9
Lb9m4ujaqiW+RJ314l+yOO8F/AFosiNHaacRJdLK7V3dObWtSmEUo2LMJl1F
Eb2ZrrDKsDj8pY0vZ8jglte37TOnsgaiI4ZR44vTmfYMUjIvSw0bStC3a+Ea
TVZZOh/4vTRyk1Z2vo/P9Xopssm91Gt+L0U+uZdWKdLrgoDD4WpReumbJr+X
YpTcS/H2e6kFR+e8Ws+bWc7zWjMe7sa/4gtrOm+nXnpdmJPsVhDdCfnpyMBK
lWDf1ZtSGr0f/Q4w/O2UjYHoFzkXOyQ8SEPOcy/fPsYMYGK/yP6OF+RJjcaO
8p5ScT9sRDbuNksEI9V8Gyl821MO5rKE7yJa2vhyGjxpoR0fOtYr/q9+F+Z6
vqe8zt4t/MV+dMR/AXWjppI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6924066]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14285],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->155560784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Erf", "[", 
    RowBox[{"InverseErf", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"InverseErf", "[", 
    RowBox[{"Erf", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235951465],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseErf", "[", 
    RowBox[{"Erf", "[", "z", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198870467]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->502484359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->214257763]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->498629124],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->103124586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Erf", "[", "x", "]"}], "==", 
    RowBox[{"1", "/", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->569583064],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->457185682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"InverseErf", "[", 
     FractionBox["1", "2"], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{151, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401521870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749696791],

Cell["Integrals:", "ExampleText",
 CellID->55345685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "\[Alpha]"], 
    RowBox[{"Erf", "[", 
     SuperscriptBox["z", "\[Beta]"], "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427927290],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["z", 
     RowBox[{"1", "+", "\[Alpha]"}]], " ", 
    RowBox[{"Erf", "[", 
     SuperscriptBox["z", "\[Beta]"], "]"}]}], 
   RowBox[{"1", "+", "\[Alpha]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["z", 
     RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["z", 
       RowBox[{"2", " ", "\[Beta]"}]], ")"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
       RowBox[{"2", " ", "\[Beta]"}]]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
       RowBox[{"2", " ", "\[Beta]"}]], ",", 
      SuperscriptBox["z", 
       RowBox[{"2", " ", "\[Beta]"}]]}], "]"}]}], 
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]}]], "Output",
 ImageSize->{313, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127897715]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"z", " ", 
    RowBox[{"Exp", "[", "z", "]"}], 
    RowBox[{"Erf", "[", "z", "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7947833],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"Erf", "[", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "+", "z"}], "]"}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"z", "-", 
       SuperscriptBox["z", "2"]}]]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"1", "/", "4"}]], " ", 
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"Erf", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", "z"}], "]"}]}]}], 
   RowBox[{"2", " ", 
    SqrtBox["\[Pi]"]}]], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "z"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
   RowBox[{"Erf", "[", "z", "]"}]}]}]], "Output",
 ImageSize->{426, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104647408]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"Erf", "[", "z", "]"}], "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->169358053],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]]}]], "Output",
 ImageSize->{46, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->461615659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64323334],

Cell["Integral transforms:", "ExampleText",
 CellID->530645299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Erf", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82114979],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["s", "2"], "4"]}]], " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]]}], "s"]], "Output",
 ImageSize->{79, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107380692]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Erf", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->483318857],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     SuperscriptBox["s", "2"], "4"]], " ", 
   RowBox[{"Erfc", "[", 
    FractionBox["s", "2"], "]"}]}], "s"]], "Output",
 ImageSize->{85, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->709466933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22917512],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erf"]], "InlineFormula"],
 " appears in special cases of many mathematical functions:  "
}], "ExampleText",
 CellID->404872404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", " ", 
   RowBox[{
    RowBox[{"GammaRegularized", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      SuperscriptBox["z", "2"]}], "]"}], ",", 
    RowBox[{"HypergeometricU", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}], ",", 
      SuperscriptBox["z", "2"]}], "]"}], ",", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", "/", "2"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "0", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "}"}]}], "}"}], ",", 
      SuperscriptBox["z", "2"]}], "]"}]}], "}"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82355808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], " ", 
      SqrtBox[
       RowBox[{"\[ImaginaryI]", " ", "z"}]], " ", 
      RowBox[{"Erf", "[", "z", "]"}]}], "z"]}], ",", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["z", "2"]], " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], " ", 
        SqrtBox[
         RowBox[{"\[ImaginaryI]", " ", "z"}]], " ", 
        RowBox[{"Erf", "[", "z", "]"}]}], "z"]}], ")"}]}], ",", 
   FractionBox[
    RowBox[{
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"Erf", "[", "z", "]"}]}], "z"]}], "}"}]], "Output",
 ImageSize->{476, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->354101345]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28381],

Cell["For large arguments, intermediate values may underflow:", "ExampleText",
 CellID->381658007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Erf", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"10", "^", "6"}]}], "-", 
    RowBox[{
     RowBox[{"10.", "^", "3"}], " ", "I"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44106359],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->60217496],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"Underflow", "[", "]"}]}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27226791]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19086575],

Cell["\<\
The error function for large real-part arguments can be very close to 1:\
\>", "ExampleText",
 CellID->860499079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{"30.", "+", 
   RowBox[{
    RowBox[{"10", "^", 
     RowBox[{"-", "1"}]}], " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55849266],

Cell[BoxData[
 RowBox[{"0.\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
9975103622845530298627320723383383`408.35490692629514", "-", 
  RowBox[{
  "7.155170950793032896133422644775`15.455325455184633*^-394", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{592, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32599352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233192716],

Cell["Very large arguments can give unevaluated results:", "ExampleText",
 CellID->516161038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erf", "[", 
  RowBox[{
   RowBox[{"10.", "^", "100"}], " ", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100624028],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->431634779],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177221357]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30402],

Cell["A neat continued fraction:  ", "ExampleText",
 CellID->494724916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "10"}], "}"}], ",", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Fold", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", "#1"}], ")"}]}], "&"}], ",", 
        RowBox[{"HoldForm", "[", "n", "]"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", "1", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ")"}]}]}], "]"}]], "Input",
 GeneratedCell->False,
 CellLabel->"In[1]:=",
 CellID->122283885],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["2", 
      RowBox[{"1", "+", 
       FractionBox["3", 
        RowBox[{"1", "+", 
         FractionBox["4", 
          RowBox[{"1", "+", 
           FractionBox["5", 
            RowBox[{"1", "+", 
             FractionBox["6", 
              RowBox[{"1", "+", 
               FractionBox["7", 
                RowBox[{"1", "+", 
                 FractionBox["8", 
                  RowBox[{"1", "+", 
                   FractionBox["9", 
                    RowBox[{"1", "+", 
                    TagBox["10",
                    HoldForm]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]], "Output",
 ImageSize->{156, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46341718]
}, Open  ]],

Cell[TextData[{
 "Its limit can be expressed through ",
 Cell[BoxData[
  ButtonBox["Erf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erf"]], "InlineFormula"],
 ":  "
}], "ExampleText",
 CellID->123416312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ReleaseHold", "//@", "%"}], ",", 
    RowBox[{
     SqrtBox[
      FractionBox[
       RowBox[{"\[Pi]", " ", "\[ExponentialE]"}], "2"]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"Erf", "[", 
        FractionBox["1", 
         SqrtBox["2"]], "]"}]}], ")"}]}]}], "}"}], " ", "//", "N"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->163336594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6602420439264903`", ",", "0.6556795424187986`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46887312]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26684],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseErf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erfc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erfc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erfi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erfi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralEi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralEi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FresnelC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FresnelS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11124]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19801],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->9355]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20752],

Cell[TextData[{
 ButtonBox["Demonstrations with Erf",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Erf"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Erf.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/Erf/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Erf"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->503434496],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->313600886],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->197988283],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->419783318],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->125345853]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Erf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 37.4022928}", "context" -> "System`", 
    "keywords" -> {
     "error function", "Gaussian distribution", "statistics", "error", 
      "law of big numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Erf[z] gives the error function erf(z). Erf[z_0, z_1] gives the \
generalized error function erf(z_1) - erf(z_0). ", "synonyms" -> {}, "title" -> 
    "Erf", "type" -> "Symbol", "uri" -> "ref/Erf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8029, 271, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->18606059]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55968, 1936}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3037, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3660, 95, 41, 1, 70, "ObjectName",
 CellID->17702],
Cell[3704, 98, 1265, 42, 70, "Usage",
 CellID->16077]
}, Open  ]],
Cell[CellGroupData[{
Cell[5006, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5484, 162, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5607, 168, 658, 24, 70, "Notes",
 CellID->19993],
Cell[6268, 194, 742, 30, 70, "Notes",
 CellID->16135],
Cell[7013, 226, 333, 12, 70, "Notes",
 CellID->27040],
Cell[7349, 240, 238, 8, 70, "Notes",
 CellID->377292285],
Cell[7590, 250, 208, 7, 70, "Notes",
 CellID->31226],
Cell[7801, 259, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8029, 271, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18606059],
Cell[CellGroupData[{
Cell[8413, 285, 148, 5, 70, "ExampleSection",
 CellID->304798763],
Cell[8564, 292, 64, 1, 70, "ExampleText",
 CellID->127959318],
Cell[CellGroupData[{
Cell[8653, 297, 102, 3, 28, "Input",
 CellID->389824926],
Cell[8758, 302, 176, 5, 36, "Output",
 CellID->169568334]
}, Open  ]],
Cell[8949, 310, 125, 3, 70, "ExampleDelimiter",
 CellID->694841897],
Cell[CellGroupData[{
Cell[9099, 317, 234, 8, 28, "Input",
 CellID->417862309],
Cell[9336, 327, 2006, 37, 140, "Output",
 Evaluatable->False,
 CellID->126263373]
}, Open  ]],
Cell[11357, 367, 125, 3, 70, "ExampleDelimiter",
 CellID->768344780],
Cell[CellGroupData[{
Cell[11507, 374, 216, 7, 70, "Input",
 CellID->178610415],
Cell[11726, 383, 1112, 37, 58, "Output",
 CellID->32001075]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12887, 426, 216, 7, 70, "ExampleSection",
 CellID->32264],
Cell[13106, 435, 74, 1, 70, "ExampleText",
 CellID->801837449],
Cell[CellGroupData[{
Cell[13205, 440, 124, 4, 70, "Input",
 CellID->692212353],
Cell[13332, 446, 275, 7, 36, "Output",
 CellID->328135914]
}, Open  ]],
Cell[13622, 456, 124, 3, 70, "ExampleDelimiter",
 CellID->96267630],
Cell[13749, 461, 70, 1, 70, "ExampleText",
 CellID->341459284],
Cell[CellGroupData[{
Cell[13844, 466, 177, 6, 70, "Input",
 CellID->135564340],
Cell[14024, 474, 235, 7, 36, "Output",
 CellID->392513623]
}, Open  ]],
Cell[14274, 484, 124, 3, 70, "ExampleDelimiter",
 CellID->80544473],
Cell[14401, 489, 113, 3, 70, "ExampleText",
 CellID->477423137],
Cell[CellGroupData[{
Cell[14539, 496, 128, 3, 70, "Input",
 CellID->109436616],
Cell[14670, 501, 218, 6, 36, "Output",
 CellID->101877511]
}, Open  ]],
Cell[14903, 510, 125, 3, 70, "ExampleDelimiter",
 CellID->156855197],
Cell[15031, 515, 200, 7, 70, "ExampleText",
 CellID->285989131],
Cell[CellGroupData[{
Cell[15256, 526, 162, 5, 70, "Input",
 CellID->152559488],
Cell[15421, 533, 275, 9, 36, "Output",
 CellID->232304274]
}, Open  ]],
Cell[15711, 545, 125, 3, 70, "ExampleDelimiter",
 CellID->814768815],
Cell[15839, 550, 91, 1, 70, "ExampleText",
 CellID->480775764],
Cell[CellGroupData[{
Cell[15955, 555, 99, 3, 70, "Input",
 CellID->286854956],
Cell[16057, 560, 158, 5, 36, "Output",
 CellID->485208026]
}, Open  ]],
Cell[16230, 568, 124, 3, 70, "ExampleDelimiter",
 CellID->12674324],
Cell[16357, 573, 90, 1, 70, "ExampleText",
 CellID->353782497],
Cell[CellGroupData[{
Cell[16472, 578, 117, 4, 70, "Input",
 CellID->719193810],
Cell[16592, 584, 205, 7, 36, "Output",
 CellID->634417955]
}, Open  ]],
Cell[CellGroupData[{
Cell[16834, 596, 122, 4, 70, "Input",
 CellID->617531883],
Cell[16959, 602, 223, 7, 36, "Output",
 CellID->526221517]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17231, 615, 239, 7, 70, "ExampleSection",
 CellID->15410],
Cell[17473, 624, 86, 1, 70, "ExampleText",
 CellID->356802223],
Cell[CellGroupData[{
Cell[17584, 629, 177, 6, 70, "Input",
 CellID->28912365],
Cell[17764, 637, 241, 8, 36, "Output",
 CellID->583799466]
}, Open  ]],
Cell[18020, 648, 123, 3, 70, "ExampleDelimiter",
 CellID->1301177],
Cell[18146, 653, 200, 7, 70, "ExampleText",
 CellID->82459882],
Cell[CellGroupData[{
Cell[18371, 664, 208, 7, 70, "Input",
 CellID->337476288],
Cell[18582, 673, 1143, 38, 58, "Output",
 CellID->28336513]
}, Open  ]],
Cell[19740, 714, 125, 3, 70, "ExampleDelimiter",
 CellID->864415758],
Cell[19868, 719, 84, 1, 70, "ExampleText",
 CellID->351271142],
Cell[CellGroupData[{
Cell[19977, 724, 180, 6, 70, "Input",
 CellID->287215045],
Cell[20160, 732, 221, 8, 36, "Output",
 CellID->69607942]
}, Open  ]],
Cell[CellGroupData[{
Cell[20418, 745, 154, 5, 70, "Input",
 CellID->48864689],
Cell[20575, 752, 158, 5, 36, "Output",
 CellID->274048625]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20782, 763, 223, 7, 70, "ExampleSection",
 CellID->25202],
Cell[21008, 772, 69, 1, 70, "ExampleText",
 CellID->94684005],
Cell[CellGroupData[{
Cell[21102, 777, 199, 6, 70, "Input",
 CellID->81418041],
Cell[21304, 785, 355, 13, 58, "Output",
 CellID->38444634]
}, Open  ]],
Cell[CellGroupData[{
Cell[21696, 803, 268, 9, 70, "Input",
 CellID->277323216],
Cell[21967, 814, 2067, 38, 70, "Output",
 Evaluatable->False,
 CellID->163893152]
}, Open  ]],
Cell[24049, 855, 307, 11, 70, "ExampleText",
 CellID->54673809],
Cell[CellGroupData[{
Cell[24381, 870, 616, 19, 70, "Input",
 CellID->386351549],
Cell[25000, 891, 302, 9, 36, "Output",
 CellID->11431102]
}, Open  ]],
Cell[25317, 903, 125, 3, 70, "ExampleDelimiter",
 CellID->186597466],
Cell[25445, 908, 133, 4, 70, "ExampleText",
 CellID->264292050],
Cell[25581, 914, 686, 24, 70, "Input",
 CellID->191879763],
Cell[26270, 940, 97, 1, 70, "ExampleText",
 CellID->665200496],
Cell[CellGroupData[{
Cell[26392, 945, 370, 13, 70, "Input",
 CellID->8153766],
Cell[26765, 960, 161, 5, 36, "Output",
 CellID->357609782]
}, Open  ]],
Cell[26941, 968, 85, 1, 70, "ExampleText",
 CellID->338076599],
Cell[CellGroupData[{
Cell[27051, 973, 571, 18, 70, "Input",
 CellID->823661425],
Cell[27625, 993, 6213, 106, 70, "Output",
 Evaluatable->False,
 CellID->6924066]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33887, 1105, 233, 7, 70, "ExampleSection",
 CellID->14285],
Cell[34123, 1114, 74, 1, 70, "ExampleText",
 CellID->155560784],
Cell[CellGroupData[{
Cell[34222, 1119, 260, 8, 70, "Input",
 CellID->235951465],
Cell[34485, 1129, 274, 9, 36, "Output",
 CellID->198870467]
}, Open  ]],
Cell[CellGroupData[{
Cell[34796, 1143, 107, 3, 70, "Input",
 CellID->502484359],
Cell[34906, 1148, 203, 7, 36, "Output",
 CellID->214257763]
}, Open  ]],
Cell[35124, 1158, 125, 3, 70, "ExampleDelimiter",
 CellID->498629124],
Cell[35252, 1163, 75, 1, 70, "ExampleText",
 CellID->103124586],
Cell[CellGroupData[{
Cell[35352, 1168, 206, 7, 70, "Input",
 CellID->569583064],
Cell[35561, 1177, 453, 8, 70, "Message",
 CellID->457185682],
Cell[36017, 1187, 297, 10, 51, "Output",
 CellID->401521870]
}, Open  ]],
Cell[36329, 1200, 125, 3, 70, "ExampleDelimiter",
 CellID->749696791],
Cell[36457, 1205, 52, 1, 70, "ExampleText",
 CellID->55345685],
Cell[CellGroupData[{
Cell[36534, 1210, 245, 8, 70, "Input",
 CellID->427927290],
Cell[36782, 1220, 1088, 36, 72, "Output",
 CellID->127897715]
}, Open  ]],
Cell[CellGroupData[{
Cell[37907, 1261, 219, 7, 70, "Input",
 CellID->7947833],
Cell[38129, 1270, 1015, 36, 66, "Output",
 CellID->104647408]
}, Open  ]],
Cell[CellGroupData[{
Cell[39181, 1311, 305, 10, 70, "Input",
 CellID->169358053],
Cell[39489, 1323, 218, 8, 60, "Output",
 CellID->461615659]
}, Open  ]],
Cell[39722, 1334, 124, 3, 70, "ExampleDelimiter",
 CellID->64323334],
Cell[39849, 1339, 63, 1, 70, "ExampleText",
 CellID->530645299],
Cell[CellGroupData[{
Cell[39937, 1344, 175, 5, 70, "Input",
 CellID->82114979],
Cell[40115, 1351, 374, 13, 76, "Output",
 CellID->107380692]
}, Open  ]],
Cell[CellGroupData[{
Cell[40526, 1369, 176, 5, 70, "Input",
 CellID->483318857],
Cell[40705, 1376, 345, 12, 69, "Output",
 CellID->709466933]
}, Open  ]],
Cell[41065, 1391, 124, 3, 70, "ExampleDelimiter",
 CellID->22917512],
Cell[41192, 1396, 226, 7, 70, "ExampleText",
 CellID->404872404],
Cell[CellGroupData[{
Cell[41443, 1407, 865, 29, 70, "Input",
 CellID->82355808],
Cell[42311, 1438, 981, 34, 61, "Output",
 CellID->354101345]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43341, 1478, 226, 7, 70, "ExampleSection",
 CellID->28381],
Cell[43570, 1487, 98, 1, 70, "ExampleText",
 CellID->381658007],
Cell[CellGroupData[{
Cell[43693, 1492, 266, 10, 70, "Input",
 CellID->44106359],
Cell[43962, 1504, 357, 7, 70, "Message",
 CellID->60217496],
Cell[44322, 1513, 229, 8, 36, "Output",
 CellID->27226791]
}, Open  ]],
Cell[44566, 1524, 124, 3, 70, "ExampleDelimiter",
 CellID->19086575],
Cell[44693, 1529, 123, 3, 70, "ExampleText",
 CellID->860499079],
Cell[CellGroupData[{
Cell[44841, 1536, 194, 7, 70, "Input",
 CellID->55849266],
Cell[45038, 1545, 735, 15, 122, "Output",
 CellID->32599352]
}, Open  ]],
Cell[45788, 1563, 125, 3, 70, "ExampleDelimiter",
 CellID->233192716],
Cell[45916, 1568, 93, 1, 70, "ExampleText",
 CellID->516161038],
Cell[CellGroupData[{
Cell[46034, 1573, 150, 5, 70, "Input",
 CellID->100624028],
Cell[46187, 1580, 357, 7, 70, "Message",
 CellID->431634779],
Cell[46547, 1589, 187, 6, 36, "Output",
 CellID->177221357]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46783, 1601, 224, 7, 70, "ExampleSection",
 CellID->30402],
Cell[47010, 1610, 71, 1, 70, "ExampleText",
 CellID->494724916],
Cell[CellGroupData[{
Cell[47106, 1615, 639, 21, 70, "Input",
 CellID->122283885],
Cell[47748, 1638, 829, 27, 138, "Output",
 CellID->46341718]
}, Open  ]],
Cell[48592, 1668, 210, 8, 70, "ExampleText",
 CellID->123416312],
Cell[CellGroupData[{
Cell[48827, 1680, 429, 16, 70, "Input",
 CellID->163336594],
Cell[49259, 1698, 242, 8, 36, "Output",
 CellID->46887312]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49562, 1713, 311, 9, 70, "SeeAlsoSection",
 CellID->26684],
Cell[49876, 1724, 1947, 71, 70, "SeeAlso",
 CellID->11124]
}, Open  ]],
Cell[CellGroupData[{
Cell[51860, 1800, 314, 9, 70, "TutorialsSection",
 CellID->19801],
Cell[52177, 1811, 143, 3, 70, "Tutorials",
 CellID->9355]
}, Open  ]],
Cell[CellGroupData[{
Cell[52357, 1819, 321, 9, 70, "RelatedLinksSection",
 CellID->20752],
Cell[52681, 1830, 346, 11, 70, "RelatedLinks"],
Cell[53030, 1843, 174, 4, 70, "RelatedLinks"],
Cell[53207, 1849, 188, 4, 70, "RelatedLinks"],
Cell[53398, 1855, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53816, 1873, 319, 9, 70, "MoreAboutSection",
 CellID->503434496],
Cell[54138, 1884, 191, 4, 70, "MoreAbout",
 CellID->313600886],
Cell[54332, 1890, 165, 3, 70, "MoreAbout",
 CellID->197988283],
Cell[54500, 1895, 155, 3, 70, "MoreAbout",
 CellID->419783318],
Cell[54658, 1900, 145, 3, 70, "MoreAbout",
 CellID->125345853]
}, Open  ]],
Cell[54818, 1906, 27, 0, 70, "History"],
Cell[54848, 1908, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

