(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58129,       2049]
NotebookOptionsPosition[     47020,       1654]
NotebookOutlinePosition[     48278,       1692]
CellTagsIndexPosition[     48192,       1687]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseErfc" :> 
          Documentation`HelpLookup["paclet:ref/InverseErfc"], "Erf" :> 
          Documentation`HelpLookup["paclet:ref/Erf"], "NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"InverseErfc\"\>", 2->"\<\"Erf\"\>",
        3->"\<\"NormalDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Erfc", "ObjectName",
 CellID->26922],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Erfc",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Erfc"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the complementary error function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"erfc", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erfc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erfc"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"erfc", "(", "z", ")"}], "=", 
    RowBox[{"1", "-", 
     RowBox[{"erf", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18097],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Erfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfc"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->92441802],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfc"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfc"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29596297],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->176450243],

Cell["Evaluate numerically:", "ExampleText",
 CellID->127959318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", "0.95", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389824926],

Cell[BoxData["0.17910919272672207`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3322560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->694841897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Erfc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417862309],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WEtrXVUU3r3nPpLUNrE1aqE1seDETvwDMbXatM2jbWxrkhbBGArJQCsx
ndhJnOhEJzqxEzuoCmoHFUNFqFAsiAVpQSwUFSSFEgcGweAgIJx+a619zn7c
dU7uVbwk5+zHt9ba+9vrse8dm16YPf3K9MLczHT/gfnp12bnZl7vHzozj6Fk
kzFmCf+Ljxq0U7T4fylN8fafj9AzoTn+mF14VNF92r77o/mHVKnHvD6eZjDq
61q6rY2Kfe+w7yRCD6b6GntZS29ka/cG0jsj/MP8pmelBeldFhdK9VGv6lDC
XzjSF0hqDNLsXvt+XGWs+fymItykOvoE99fX/7l18x7+zB56JLd/+t3OV0Qj
0WGqkWwt6tfbnG8X/7/Yq6P/5uLVkUMXZl6+9O471y98+EOFOVhZ+cu6wkZ6
/us6hePeaLRvgz7ja19duTNx4hNs4Jurv66trTfZiqW2p5oX8Gh1efnPudnL
b791DVt/RsVt4z5MgSv4iHk2R5FnyuzHH93CcuBR5jlVRw/3v7h8G4aouV9F
dWeWoIuaQypqK/exkjOvfkkWD6ioLdwHO1g1nerBEpQwSU2Hor3J7I3v755d
uELNQ6qOzamNJlgCm2a4BPX5Zz++/9531NRRXZkunO/q6t9mpAQFRVBHTYci
UGemA+5N/IyqOjqj9eiojmg9YyUoeKU93TIUSPrl5z9CFIEaPIsgxKlS87Cq
Q1AwA2PFqHrEwBFGDdtT9esJZTga06MX/orkQE3RwOcfZPFGJFdR9SDAJLm2
pSfJ1wX/Bf/UPPov10F6Kshy4wXyNctNzIP0Xzz1KRy7zH4sF1cN6ePgcfzU
HA9OpGHfutT5D24gvTip+LQFBYJAU4hyOrF8bIKaz6s6EsvPscJZnwVdRyWy
pOsSFDaEbYWoxN59TIIQQCBEOuq5DnyQ1+DbJwpmJRKLZiXbqbMIlvEjF6Hc
zRKHTICEpnnBydVyOUlF+pwcjD9nPUeYmmgaF26ax4WViWhloMEy61kgKqWM
2BvQcMCvdxq+70pasRIjmg8EPp97Kyij3Ni2nI2FduRoYKJdO9aXWrUj3k73
CkmRUzmDxFY99eMKJAcotkH5WRkFTUY+Msr7oDqO9EijJ/NRisTmW6zgpX44
PJ961WXIcNxl8GA8QUFHWc88QNbDPl/Lq4YIWSmZu/7tb+fe+DonKpjLa5Iy
Jw4Szx339p+mLudP5rPEQ/ztZ9KTdRkp9mtBcfbwMpKu65i1FGdfX4erYEmw
Ss6EXn3SdQjK5TwdpcVoUX0u82W33+aKUiwnPidSxVzpFl3tEYuOnxjPe6s6
n291Z8IJXBkObWwU6gzmN5yq78ladRUZvpF4d7f4JuGjnBc0gl3yLcyr7h2q
DkEhgBBGxSi+FSYIF5BKd7fOEpS7Aeuo0UhXV7Dq0UhHV8lJOB2bS1DuXqqj
hiOeHlBRfLui2yvoplS3xZ7fVD5LvrpVleXvL94tWkfxNybK8IgTqlzdKmoo
Q9l19Kio/RkKFpFSzYMqir8V2lxHurYFe9qX+StSBNQggLerWujXEM7QYBlL
RzahE8nqYmltD/QM0LOOkJU7AtKzfP/1fd9kEaPX1EDfUzyKZdvfU2p4cD5p
IGKxIRgIvq/HnlZSuwM7eWVGXA8OnDdP0oOqAGzQ3ayGh+QxpAmsQTvbimrL
3StGW8IXeG0zrgXJ+GbxEo82/7ZlNt0HaLSW7g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->963809299]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->768344780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Erfc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178610415],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    SqrtBox["\[Pi]"]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"3", " ", 
     SqrtBox["\[Pi]"]}]], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], 
    RowBox[{"5", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], 
    RowBox[{"21", " ", 
     SqrtBox["\[Pi]"]}]], "-", 
   FractionBox[
    SuperscriptBox["x", "9"], 
    RowBox[{"108", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, (-2) Pi^Rational[-1, 2], 0, Rational[2, 3] Pi^Rational[-1, 2], 0, 
    Rational[-1, 5] Pi^Rational[-1, 2], 0, Rational[1, 21] Pi^Rational[-1, 2],
     0, Rational[-1, 108] Pi^Rational[-1, 2]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{332, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6784728]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17059],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->801837449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", 
  RowBox[{"1.5", "-", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692212353],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0783992074989337`"}], "-", 
  RowBox[{"0.027963711238656177`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327092549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96267630],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->341459284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Erfc", "[", 
    RowBox[{"3", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135564340],

Cell[BoxData["0.\
0338948535246892729330237383540521413185895207423632195501528806597`50."], \
"Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57407289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80544473],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->477423137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", "1.5000000000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109436616],

Cell[BoxData["0.0338948535246892729330237383540919893`25.446578291750793"], \
"Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249430374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156855197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfc"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->285989131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", 
  RowBox[{"{", 
   RowBox[{"0.5", ",", "1.0", ",", "1.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152559488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4795001221869535`", ",", "0.15729920705028513`", ",", 
   "0.033894853524689274`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->371100568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->814768815],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->480775764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286854956],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244300529]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->619171428],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->20281783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Erfc", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535530480],

Cell[BoxData[
 FormBox[
  RowBox[{"erfc", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->169764848]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18559],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfc"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->82459882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337476288],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    SqrtBox["\[Pi]"]], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], 
    SqrtBox["\[Pi]"]], "-", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "5"]}], 
    RowBox[{"20", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    RowBox[{"241", " ", 
     SuperscriptBox["x", "7"]}], 
    RowBox[{"840", " ", 
     SqrtBox["\[Pi]"]}]], "-", 
   FractionBox[
    RowBox[{"2777", " ", 
     SuperscriptBox["x", "9"]}], 
    RowBox[{"20160", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, (-2) Pi^Rational[-1, 2], 0, Pi^Rational[-1, 2], 0, Rational[-11, 20] 
    Pi^Rational[-1, 2], 0, Rational[241, 840] Pi^Rational[-1, 2], 0, 
    Rational[-2777, 20160] Pi^Rational[-1, 2]}, 0, 10, 1],
  Editable->False]], "Output",
 ImageSize->{352, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48900567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->864415758],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->351271142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", 
  RowBox[{"{", 
   RowBox[{"Infinity", ",", 
    RowBox[{"-", "Infinity"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287215045],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297596835]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4084],

Cell["CDF of normal distribution:", "ExampleText",
 CellID->94684005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81418041],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"Erf", "[", 
     FractionBox["x", 
      RowBox[{
       SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}], ")"}]}]], "Output",
 ImageSize->{125, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224190799]
}, Open  ]],

Cell[TextData[{
 "Probability that random value be greater than ",
 Cell[BoxData[
  RowBox[{"n", " ", 
   StyleBox["\[Sigma]", "TR"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->200481723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", "Infinity"}], "]"}], "-", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", 
      RowBox[{"n", " ", "\[Sigma]"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"\[Sigma]", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145765255],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Erfc", "[", 
   FractionBox["n", 
    SqrtBox["2"]], "]"}]}]], "Output",
 ImageSize->{89, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->389008035]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", "N"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->97655444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.15865525393145707`", ",", "0.022750131948179198`", ",", 
   "0.0013498980316300957`"}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->82979367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186597466],

Cell["\<\
Solution of the heat equation for piecewise\[Hyphen]constant initial \
condition: \
\>", "ExampleText",
 CellID->264292050],

Cell[BoxData[
 RowBox[{
  RowBox[{"temp", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Eta]", "=", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "/", 
       RowBox[{"Sqrt", "[", "t", "]"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Erfc", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "\[Eta]"}], "]"}], "-", 
       RowBox[{"Erfc", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "\[Eta]"}], "]"}]}], ")"}], "/", 
     "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191879763],

Cell["A check that the solution fulfills the heat equation: ", "ExampleText",
 CellID->665200496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"temp", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "==", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"temp", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], "//", 
  " ", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8153766],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218487579]
}, Open  ]],

Cell["Plot of the solution for different times: ", "ExampleText",
 CellID->338076599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"temp", "[", 
       RowBox[{"x", ",", "0.01"}], "]"}], ",", 
      RowBox[{"temp", "[", 
       RowBox[{"x", ",", "0.2"}], "]"}], ",", 
      RowBox[{"temp", "[", 
       RowBox[{"x", ",", "0.6"}], "]"}], ",", 
      RowBox[{"temp", "[", 
       RowBox[{"x", ",", "1.5"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->823661425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->87054757]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29709],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to convert to other functions:"
}], "ExampleText",
 CellID->211523338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Erfc", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82386814],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"Erf", "[", "x", "]"}]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230776334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->415659318],

Cell[BoxData[
 RowBox[{"Erfc", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22909842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45244312],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->155560784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Erfc", "[", 
    RowBox[{"InverseErfc", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"InverseErfc", "[", 
    RowBox[{"Erfc", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235951465],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseErfc", "[", 
    RowBox[{"Erfc", "[", "z", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8024830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->502484359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2088035]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749696791],

Cell["Integrals:", "ExampleText",
 CellID->55345685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "\[Alpha]"], 
    RowBox[{"Erfc", "[", 
     SuperscriptBox["z", "\[Beta]"], "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427927290],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["z", 
     RowBox[{"1", "+", "\[Alpha]"}]], " ", 
    RowBox[{"Erfc", "[", 
     SuperscriptBox["z", "\[Beta]"], "]"}]}], 
   RowBox[{"1", "+", "\[Alpha]"}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["z", 
     RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["z", 
       RowBox[{"2", " ", "\[Beta]"}]], ")"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
       RowBox[{"2", " ", "\[Beta]"}]]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
       RowBox[{"2", " ", "\[Beta]"}]], ",", 
      SuperscriptBox["z", 
       RowBox[{"2", " ", "\[Beta]"}]]}], "]"}]}], 
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]}]], "Output",
 ImageSize->{320, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->875194207]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"z", " ", 
    RowBox[{"Exp", "[", "z", "]"}], 
    RowBox[{"Erfc", "[", "z", "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7947833],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"1", "/", "4"}]]}], " ", 
   RowBox[{"Erf", "[", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "+", "z"}], "]"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"z", "-", 
       SuperscriptBox["z", "2"]}]]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"1", "/", "4"}]], " ", 
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"Erf", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", "z"}], "]"}]}]}], 
   RowBox[{"2", " ", 
    SqrtBox["\[Pi]"]}]], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "z"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
   RowBox[{"Erfc", "[", "z", "]"}]}]}]], "Output",
 ImageSize->{440, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->168417862]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Erfc", "[", "z", "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->169358053],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "-", 
   SqrtBox["2"]}], 
  SqrtBox["\[Pi]"]]], "Output",
 ImageSize->{52, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->188953982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->337255580],

Cell["Integral transforms:", "ExampleText",
 CellID->530645299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Erfc", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82114979],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"2", " ", "\[Pi]", " ", 
    RowBox[{"DiracDelta", "[", "s", "]"}]}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["s", "2"], "4"]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Abs", "[", "s", "]"}]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"Erfi", "[", 
           FractionBox["s", "2"], "]"}]}], ")"}]}], "+", 
       RowBox[{"s", " ", 
        RowBox[{"Erfi", "[", 
         FractionBox[
          RowBox[{"Abs", "[", "s", "]"}], "2"], "]"}]}]}], ")"}]}], 
    RowBox[{"s", " ", 
     RowBox[{"Abs", "[", "s", "]"}]}]]}], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{350, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231190584]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Erfc", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272164940],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      SuperscriptBox["s", "2"], "4"]], " ", 
    RowBox[{"Erfc", "[", 
     FractionBox["s", "2"], "]"}]}]}], "s"]], "Output",
 ImageSize->{104, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->743076632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->498629124],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->103124586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Erfc", "[", "x", "]"}], "==", 
    RowBox[{"1", "/", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->569583064],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->47231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"InverseErfc", "[", 
     FractionBox["1", "2"], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{158, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342394346]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9687],

Cell["For large arguments, intermediate values may underflow:", "ExampleText",
 CellID->381658007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Erfc", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"10", "^", "6"}]}], "-", 
    RowBox[{
     RowBox[{"10.", "^", "3"}], " ", "I"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44106359],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->404353089],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"Underflow", "[", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->596901915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19086575],

Cell["\<\
The error function for large negative real-part arguments can be very close \
to 2:\
\>", "ExampleText",
 CellID->860499079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", 
  RowBox[{
   RowBox[{"-", "30."}], "+", 
   RowBox[{
    RowBox[{"10", "^", 
     RowBox[{"-", "1"}]}], " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55849266],

Cell[BoxData[
 RowBox[{"1.\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
9975103622845530298627320723383383`408.6559369219591", "+", 
  RowBox[{
  "7.155170950793032896133422644775`15.455325455184633*^-394", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{592, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->897692212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116153264],

Cell["Very large arguments can give unevaluated results:", "ExampleText",
 CellID->516161038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfc", "[", 
  RowBox[{
   RowBox[{"10.", "^", "100"}], " ", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100624028],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->112996761],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->940087024]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6226],

Cell["A neat continued fraction:  ", "ExampleText",
 CellID->494724916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "20"}], "}"}], ",", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Fold", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", "#1"}], ")"}]}], "&"}], ",", 
        RowBox[{"HoldForm", "[", "n", "]"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", "1", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ")"}]}]}], "]"}]], "Input",
 GeneratedCell->False,
 CellLabel->"In[1]:=",
 CellID->122283885],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["2", 
      RowBox[{"1", "+", 
       FractionBox["3", 
        RowBox[{"1", "+", 
         FractionBox["4", 
          RowBox[{"1", "+", 
           FractionBox["5", 
            RowBox[{"1", "+", 
             FractionBox["6", 
              RowBox[{"1", "+", 
               FractionBox["7", 
                RowBox[{"1", "+", 
                 FractionBox["8", 
                  RowBox[{"1", "+", 
                   FractionBox["9", 
                    RowBox[{"1", "+", 
                    FractionBox["10", 
                    RowBox[{"1", "+", 
                    FractionBox["11", 
                    RowBox[{"1", "+", 
                    FractionBox["12", 
                    RowBox[{"1", "+", 
                    FractionBox["13", 
                    RowBox[{"1", "+", 
                    FractionBox["14", 
                    RowBox[{"1", "+", 
                    FractionBox["15", 
                    RowBox[{"1", "+", 
                    FractionBox["16", 
                    RowBox[{"1", "+", 
                    FractionBox["17", 
                    RowBox[{"1", "+", 
                    FractionBox["18", 
                    RowBox[{"1", "+", 
                    FractionBox["19", 
                    RowBox[{"1", "+", 
                    TagBox["20",
                    
                    HoldForm]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}\
]]}]]}]]}]]], "Output",
 ImageSize->{286, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->354183395]
}, Open  ]],

Cell[TextData[{
 "Its limit can be expressed through ",
 Cell[BoxData[
  ButtonBox["Erfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfc"]], "InlineFormula"],
 ":  "
}], "ExampleText",
 CellID->123416312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ReleaseHold", "//@", "%"}], ",", 
    RowBox[{
     SqrtBox[
      FractionBox[
       RowBox[{"\[Pi]", " ", "\[ExponentialE]"}], "2"]], " ", 
     RowBox[{"Erfc", "[", 
      FractionBox["1", 
       SqrtBox["2"]], "]"}]}]}], "}"}], " ", "//", "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->163336594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6560601422781751`", ",", "0.6556795424187986`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195584594]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16769],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseErfc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErfc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23090]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7347],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->31080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->26121],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Erfc.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/Erfc/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->71296647],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->421826134],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->353039290],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->20307719]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Erfc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 36.0116322}", "context" -> "System`", 
    "keywords" -> {
     "complementary error function", "error function", 
      "Gaussian distribution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Erfc[z] gives the complementary error function erfc(z). ", 
    "synonyms" -> {}, "title" -> "Erfc", "type" -> "Symbol", "uri" -> 
    "ref/Erfc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5327, 181, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->29596297]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48050, 1680}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2332, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2955, 82, 42, 1, 70, "ObjectName",
 CellID->26922],
Cell[3000, 85, 592, 19, 70, "Usage",
 CellID->26604]
}, Open  ]],
Cell[CellGroupData[{
Cell[3629, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4107, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4230, 132, 409, 16, 70, "Notes",
 CellID->18097],
Cell[4642, 150, 239, 8, 70, "Notes",
 CellID->92441802],
Cell[4884, 160, 210, 7, 70, "Notes",
 CellID->31226],
Cell[5097, 169, 193, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5327, 181, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29596297],
Cell[CellGroupData[{
Cell[5711, 195, 148, 5, 70, "ExampleSection",
 CellID->176450243],
Cell[5862, 202, 64, 1, 70, "ExampleText",
 CellID->127959318],
Cell[CellGroupData[{
Cell[5951, 207, 103, 3, 28, "Input",
 CellID->389824926],
Cell[6057, 212, 175, 5, 36, "Output",
 CellID->3322560]
}, Open  ]],
Cell[6247, 220, 125, 3, 70, "ExampleDelimiter",
 CellID->694841897],
Cell[CellGroupData[{
Cell[6397, 227, 235, 8, 28, "Input",
 CellID->417862309],
Cell[6635, 237, 1961, 36, 149, "Output",
 Evaluatable->False,
 CellID->963809299]
}, Open  ]],
Cell[8611, 276, 125, 3, 70, "ExampleDelimiter",
 CellID->768344780],
Cell[CellGroupData[{
Cell[8761, 283, 217, 7, 70, "Input",
 CellID->178610415],
Cell[8981, 292, 1127, 37, 58, "Output",
 CellID->6784728]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10157, 335, 216, 7, 70, "ExampleSection",
 CellID->17059],
Cell[10376, 344, 74, 1, 70, "ExampleText",
 CellID->801837449],
Cell[CellGroupData[{
Cell[10475, 349, 125, 4, 70, "Input",
 CellID->692212353],
Cell[10603, 355, 272, 8, 36, "Output",
 CellID->327092549]
}, Open  ]],
Cell[10890, 366, 124, 3, 70, "ExampleDelimiter",
 CellID->96267630],
Cell[11017, 371, 70, 1, 70, "ExampleText",
 CellID->341459284],
Cell[CellGroupData[{
Cell[11112, 376, 178, 6, 70, "Input",
 CellID->135564340],
Cell[11293, 384, 234, 7, 36, "Output",
 CellID->57407289]
}, Open  ]],
Cell[11542, 394, 124, 3, 70, "ExampleDelimiter",
 CellID->80544473],
Cell[11669, 399, 113, 3, 70, "ExampleText",
 CellID->477423137],
Cell[CellGroupData[{
Cell[11807, 406, 129, 3, 70, "Input",
 CellID->109436616],
Cell[11939, 411, 218, 6, 36, "Output",
 CellID->249430374]
}, Open  ]],
Cell[12172, 420, 125, 3, 70, "ExampleDelimiter",
 CellID->156855197],
Cell[12300, 425, 202, 7, 70, "ExampleText",
 CellID->285989131],
Cell[CellGroupData[{
Cell[12527, 436, 163, 5, 70, "Input",
 CellID->152559488],
Cell[12693, 443, 278, 9, 36, "Output",
 CellID->371100568]
}, Open  ]],
Cell[12986, 455, 125, 3, 70, "ExampleDelimiter",
 CellID->814768815],
Cell[13114, 460, 91, 1, 70, "ExampleText",
 CellID->480775764],
Cell[CellGroupData[{
Cell[13230, 465, 100, 3, 70, "Input",
 CellID->286854956],
Cell[13333, 470, 158, 5, 36, "Output",
 CellID->244300529]
}, Open  ]],
Cell[13506, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->619171428],
Cell[13634, 483, 202, 7, 70, "ExampleText",
 CellID->20281783],
Cell[CellGroupData[{
Cell[13861, 494, 142, 4, 70, "Input",
 CellID->535530480],
Cell[14006, 500, 234, 7, 50, "Output",
 CellID->169764848]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14289, 513, 239, 7, 70, "ExampleSection",
 CellID->18559],
Cell[14531, 522, 202, 7, 70, "ExampleText",
 CellID->82459882],
Cell[CellGroupData[{
Cell[14758, 533, 209, 7, 70, "Input",
 CellID->337476288],
Cell[14970, 542, 1159, 38, 58, "Output",
 CellID->48900567]
}, Open  ]],
Cell[16144, 583, 125, 3, 70, "ExampleDelimiter",
 CellID->864415758],
Cell[16272, 588, 84, 1, 70, "ExampleText",
 CellID->351271142],
Cell[CellGroupData[{
Cell[16381, 593, 181, 6, 70, "Input",
 CellID->287215045],
Cell[16565, 601, 203, 7, 36, "Output",
 CellID->297596835]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16817, 614, 222, 7, 70, "ExampleSection",
 CellID->4084],
Cell[17042, 623, 69, 1, 70, "ExampleText",
 CellID->94684005],
Cell[CellGroupData[{
Cell[17136, 628, 199, 6, 70, "Input",
 CellID->81418041],
Cell[17338, 636, 356, 13, 58, "Output",
 CellID->224190799]
}, Open  ]],
Cell[17709, 652, 198, 7, 70, "ExampleText",
 CellID->200481723],
Cell[CellGroupData[{
Cell[17932, 663, 572, 17, 70, "Input",
 CellID->145765255],
Cell[18507, 682, 268, 10, 55, "Output",
 CellID->389008035]
}, Open  ]],
Cell[CellGroupData[{
Cell[18812, 697, 211, 8, 70, "Input",
 CellID->97655444],
Cell[19026, 707, 280, 9, 36, "Output",
 CellID->82979367]
}, Open  ]],
Cell[19321, 719, 125, 3, 70, "ExampleDelimiter",
 CellID->186597466],
Cell[19449, 724, 133, 4, 70, "ExampleText",
 CellID->264292050],
Cell[19585, 730, 688, 24, 70, "Input",
 CellID->191879763],
Cell[20276, 756, 97, 1, 70, "ExampleText",
 CellID->665200496],
Cell[CellGroupData[{
Cell[20398, 761, 370, 13, 70, "Input",
 CellID->8153766],
Cell[20771, 776, 161, 5, 36, "Output",
 CellID->218487579]
}, Open  ]],
Cell[20947, 784, 85, 1, 70, "ExampleText",
 CellID->338076599],
Cell[CellGroupData[{
Cell[21057, 789, 571, 18, 70, "Input",
 CellID->823661425],
Cell[21631, 809, 6214, 106, 70, "Output",
 Evaluatable->False,
 CellID->87054757]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27894, 921, 233, 7, 70, "ExampleSection",
 CellID->29709],
Cell[28130, 930, 229, 8, 70, "ExampleText",
 CellID->211523338],
Cell[CellGroupData[{
Cell[28384, 942, 140, 4, 70, "Input",
 CellID->82386814],
Cell[28527, 948, 210, 7, 36, "Output",
 CellID->230776334]
}, Open  ]],
Cell[CellGroupData[{
Cell[28774, 960, 108, 3, 70, "Input",
 CellID->415659318],
Cell[28885, 965, 187, 6, 36, "Output",
 CellID->22909842]
}, Open  ]],
Cell[29087, 974, 124, 3, 70, "ExampleDelimiter",
 CellID->45244312],
Cell[29214, 979, 74, 1, 70, "ExampleText",
 CellID->155560784],
Cell[CellGroupData[{
Cell[29313, 984, 264, 8, 70, "Input",
 CellID->235951465],
Cell[29580, 994, 274, 9, 36, "Output",
 CellID->8024830]
}, Open  ]],
Cell[CellGroupData[{
Cell[29891, 1008, 107, 3, 70, "Input",
 CellID->502484359],
Cell[30001, 1013, 201, 7, 36, "Output",
 CellID->2088035]
}, Open  ]],
Cell[30217, 1023, 125, 3, 70, "ExampleDelimiter",
 CellID->749696791],
Cell[30345, 1028, 52, 1, 70, "ExampleText",
 CellID->55345685],
Cell[CellGroupData[{
Cell[30422, 1033, 246, 8, 70, "Input",
 CellID->427927290],
Cell[30671, 1043, 1089, 36, 72, "Output",
 CellID->875194207]
}, Open  ]],
Cell[CellGroupData[{
Cell[31797, 1084, 220, 7, 70, "Input",
 CellID->7947833],
Cell[32020, 1093, 1037, 37, 66, "Output",
 CellID->168417862]
}, Open  ]],
Cell[CellGroupData[{
Cell[33094, 1135, 252, 8, 70, "Input",
 CellID->169358053],
Cell[33349, 1145, 230, 9, 60, "Output",
 CellID->188953982]
}, Open  ]],
Cell[33594, 1157, 125, 3, 70, "ExampleDelimiter",
 CellID->337255580],
Cell[33722, 1162, 63, 1, 70, "ExampleText",
 CellID->530645299],
Cell[CellGroupData[{
Cell[33810, 1167, 176, 5, 70, "Input",
 CellID->82114979],
Cell[33989, 1174, 987, 33, 85, "Output",
 CellID->231190584]
}, Open  ]],
Cell[CellGroupData[{
Cell[35013, 1212, 177, 5, 70, "Input",
 CellID->272164940],
Cell[35193, 1219, 375, 13, 69, "Output",
 CellID->743076632]
}, Open  ]],
Cell[35583, 1235, 125, 3, 70, "ExampleDelimiter",
 CellID->498629124],
Cell[35711, 1240, 75, 1, 70, "ExampleText",
 CellID->103124586],
Cell[CellGroupData[{
Cell[35811, 1245, 207, 7, 70, "Input",
 CellID->569583064],
Cell[36021, 1254, 449, 8, 70, "Message",
 CellID->47231],
Cell[36473, 1264, 298, 10, 51, "Output",
 CellID->342394346]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36820, 1280, 225, 7, 70, "ExampleSection",
 CellID->9687],
Cell[37048, 1289, 98, 1, 70, "ExampleText",
 CellID->381658007],
Cell[CellGroupData[{
Cell[37171, 1294, 267, 10, 70, "Input",
 CellID->44106359],
Cell[37441, 1306, 358, 7, 70, "Message",
 CellID->404353089],
Cell[37802, 1315, 212, 7, 36, "Output",
 CellID->596901915]
}, Open  ]],
Cell[38029, 1325, 124, 3, 70, "ExampleDelimiter",
 CellID->19086575],
Cell[38156, 1330, 134, 4, 70, "ExampleText",
 CellID->860499079],
Cell[CellGroupData[{
Cell[38315, 1338, 214, 8, 70, "Input",
 CellID->55849266],
Cell[38532, 1348, 735, 15, 122, "Output",
 CellID->897692212]
}, Open  ]],
Cell[39282, 1366, 125, 3, 70, "ExampleDelimiter",
 CellID->116153264],
Cell[39410, 1371, 93, 1, 70, "ExampleText",
 CellID->516161038],
Cell[CellGroupData[{
Cell[39528, 1376, 151, 5, 70, "Input",
 CellID->100624028],
Cell[39682, 1383, 357, 7, 70, "Message",
 CellID->112996761],
Cell[40042, 1392, 187, 6, 36, "Output",
 CellID->940087024]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40278, 1404, 223, 7, 70, "ExampleSection",
 CellID->6226],
Cell[40504, 1413, 71, 1, 70, "ExampleText",
 CellID->494724916],
Cell[CellGroupData[{
Cell[40600, 1418, 639, 21, 70, "Input",
 CellID->122283885],
Cell[41242, 1441, 1663, 49, 238, "Output",
 CellID->354183395]
}, Open  ]],
Cell[42920, 1493, 212, 8, 70, "ExampleText",
 CellID->123416312],
Cell[CellGroupData[{
Cell[43157, 1505, 369, 13, 70, "Input",
 CellID->163336594],
Cell[43529, 1520, 243, 8, 36, "Output",
 CellID->195584594]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43833, 1535, 311, 9, 70, "SeeAlsoSection",
 CellID->16769],
Cell[44147, 1546, 712, 26, 70, "SeeAlso",
 CellID->23090]
}, Open  ]],
Cell[CellGroupData[{
Cell[44896, 1577, 313, 9, 70, "TutorialsSection",
 CellID->7347],
Cell[45212, 1588, 144, 3, 70, "Tutorials",
 CellID->31080]
}, Open  ]],
Cell[CellGroupData[{
Cell[45393, 1596, 321, 9, 70, "RelatedLinksSection",
 CellID->26121],
Cell[45717, 1607, 175, 4, 70, "RelatedLinks"],
Cell[45895, 1613, 189, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46121, 1622, 318, 9, 70, "MoreAboutSection",
 CellID->71296647],
Cell[46442, 1633, 191, 4, 70, "MoreAbout",
 CellID->421826134],
Cell[46636, 1639, 165, 3, 70, "MoreAbout",
 CellID->353039290],
Cell[46804, 1644, 144, 3, 70, "MoreAbout",
 CellID->20307719]
}, Open  ]],
Cell[46963, 1650, 27, 0, 70, "History"],
Cell[46993, 1652, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

