(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65374,       1909]
NotebookOptionsPosition[     56836,       1608]
NotebookOutlinePosition[     58102,       1646]
CellTagsIndexPosition[     58016,       1641]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Erf" :> Documentation`HelpLookup["paclet:ref/Erf"], "Erfc" :> 
          Documentation`HelpLookup["paclet:ref/Erfc"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Erf\"\>", 2->"\<\"Erfc\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Erfi", "ObjectName",
 CellID->3461],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Erfi",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Erfi"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the imaginary error function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"erf", "(", 
         RowBox[{"i", "\[InvisibleSpace]", "z"}], ")"}], "/", "i"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12230]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Erfi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfi"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->427101462],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erfi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfi"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erfi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfi"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->111916367],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->696579719],

Cell["Evaluate numerically:", "ExampleText",
 CellID->145148934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", "2.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200092395],

Cell[BoxData["130.39575501324686`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132181594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4566837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Erfi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160277689],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244172651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256455803],

Cell["Series expansion about the origin:", "ExampleText",
 CellID->186900934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Erfi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274958927],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    SqrtBox["\[Pi]"]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"3", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], 
    RowBox[{"5", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], 
    RowBox[{"21", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], 
    RowBox[{"108", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2 Pi^Rational[-1, 2], 0, Rational[2, 3] Pi^Rational[-1, 2], 0, 
    Rational[1, 5] Pi^Rational[-1, 2], 0, Rational[1, 21] Pi^Rational[-1, 2], 
    0, Rational[1, 108] Pi^Rational[-1, 2]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{312, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135893489]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9393],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->578872651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", 
  RowBox[{"1.5", "-", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208551184],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.7013604642514809`"}], "-", 
  RowBox[{"1.8468330146085425`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->510796022]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245815053],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->1033859101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Erfi", "[", 
    RowBox[{"1", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382079554],

Cell[BoxData["0.\
6149520946965109808396811856236413930513456178954035723248372392243`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137020043]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10966615],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->73638357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", "0.5000000000000000000000000000000000", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->325394274],

Cell[BoxData["0.614952094696510980839681185623641393051279048467`33.\
451721346326515"], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->420505875]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->404189143],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->107281760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19772109],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238323329]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116810855],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->197537656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240091487],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Erfi", "[", "x", "]"}]}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131991894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610996349],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Erf", "[", "x", "]"}]}]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->264152354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130599840],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erfi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfi"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->378727847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", 
  RowBox[{"{", 
   RowBox[{"0.5", ",", "1.5", ",", "2.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->542328797],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6149520946965111`", ",", "4.584733257284426`", ",", 
   "130.39575501324686`"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52188292]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21209],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Erfi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfi"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->312537900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->714385337],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Erfi", "[", "1", "]"}], "-", 
   FractionBox[
    RowBox[{"2", " ", "\[ExponentialE]", " ", "x"}], 
    SqrtBox["\[Pi]"]], "+", 
   FractionBox[
    RowBox[{"3", " ", "\[ExponentialE]", " ", 
     SuperscriptBox["x", "2"]}], 
    SqrtBox["\[Pi]"]], "-", 
   FractionBox[
    RowBox[{"13", " ", "\[ExponentialE]", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"3", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   FractionBox[
    RowBox[{"71", " ", "\[ExponentialE]", " ", 
     SuperscriptBox["x", "4"]}], 
    RowBox[{"12", " ", 
     SqrtBox["\[Pi]"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Erfi[1], (-2) E Pi^Rational[-1, 2], 3 E Pi^Rational[-1, 2], 
    Rational[-13, 3] E Pi^Rational[-1, 2], Rational[71, 12] E 
    Pi^Rational[-1, 2]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{307, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2840067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259901392],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->110201593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134589180],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601392228]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9174],

Cell["Solve a differential equation:", "ExampleText",
 CellID->750837339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["w", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["w", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], "\[Equal]", "0"}], 
     ",", 
     RowBox[{
      RowBox[{"w", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"w", "'"}], "[", "0", "]"}], "\[Equal]", 
      FractionBox["2", 
       SqrtBox["\[Pi]"]]}]}], "}"}], ",", 
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55174074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{"Erfi", "[", "z", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409143297]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->218573201],

Cell["\<\
An isothermal solution of the force\[Hyphen]free Vlasov equation: \
\>", "ExampleText",
 CellID->783408171],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "v_", ",", "t_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], 
      RowBox[{"Sin", "[", 
       RowBox[{"k", " ", 
        RowBox[{"(", 
         RowBox[{"x", " ", "-", 
          RowBox[{"v", " ", "t"}]}], ")"}]}], "]"}]}]}], ")"}], 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], " ", 
     RowBox[{"v", "^", "2"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137766098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "v", ",", "t"}], "]"}], ",", "t"}], "]"}], "+", 
   RowBox[{"v", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "v", ",", "t"}], "]"}], ",", "x"}], "]"}]}]}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->432034368],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97990579]
}, Open  ]],

Cell["\<\
Integrating over the particle velocities gives the marginal distribution for \
the particle density: \
\>", "ExampleText",
 CellID->523529329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "v", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "v1", ",", "v2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->156381689],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SqrtBox["\[Alpha]"]}]], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Erf", "[", 
          RowBox[{"v1", " ", 
           SqrtBox["\[Alpha]"]}], "]"}]}], "+", 
        RowBox[{"Erf", "[", 
         RowBox[{"v2", " ", 
          SqrtBox["\[Alpha]"]}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["k", "2"], " ", 
          SuperscriptBox["t", "2"]}], 
         RowBox[{"4", " ", "\[Alpha]"}]]}]], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Erfi", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"k", " ", "t"}], "+", 
             RowBox[{
             "2", " ", "\[ImaginaryI]", " ", "v1", " ", "\[Alpha]"}]}], 
            RowBox[{"2", " ", 
             SqrtBox["\[Alpha]"]}]], "]"}]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "x"}], "]"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"k", " ", "x"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"Erfi", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"k", " ", "t"}], "+", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "v2", " ", "\[Alpha]"}]}],
            
           RowBox[{"2", " ", 
            SqrtBox["\[Alpha]"]}]], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "x"}], "]"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"k", " ", "x"}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"Erfi", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"k", " ", "t"}], "-", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "v1", " ", "\[Alpha]"}]}],
            
           RowBox[{"2", " ", 
            SqrtBox["\[Alpha]"]}]], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "x"}], "]"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"k", " ", "x"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"Erfi", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"k", " ", "t"}], "-", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "v2", " ", "\[Alpha]"}]}],
            
           RowBox[{"2", " ", 
            SqrtBox["\[Alpha]"]}]], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"k", " ", "x"}], "]"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"k", " ", "x"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{494, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->430720749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->765922422],

Cell["\<\
A solution of the time\[Hyphen]dependent Schr\[ODoubleDot]dinger equation for \
the sudden opening of a shutter:\
\>", "ExampleText",
 CellID->495533592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", "k_", "]"}], "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"1", "/", "2"}], 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"k", " ", "x"}], "-", 
       RowBox[{
        SuperscriptBox["k", "2"], " ", 
        RowBox[{"t", "/", "2"}]}]}], ")"}]}]], 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"I", " ", 
      RowBox[{"Erfi", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", 
           RowBox[{"k", " ", "t"}]}], ")"}], "/", 
         SqrtBox[
          RowBox[{"2", " ", "t"}]]}]}], "]"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283389310],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["k", "2"], " ", "t"}], "2"]}], "+", 
      RowBox[{"k", " ", "x"}]}], ")"}]}]], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"Erfi", "[", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "k"}], " ", "t"}], "+", "x"}], ")"}]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox["t"]}]], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{287, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39227507]
}, Open  ]],

Cell["Verify correctness:", "ExampleText",
 CellID->431262263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"I", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Psi]", "[", "k", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "==", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Psi]", "[", "k", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}]}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298943440],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96024901]
}, Open  ]],

Cell["\<\
This plots the time\[Hyphen]dependent solution: \
\>", "ExampleText",
 CellID->306247606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", "1", "]"}], "[", 
      RowBox[{"x", ",", "t"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->85162568],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->222318208]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12865],

Cell["For large arguments, intermediate values may overflow:", "ExampleText",
 CellID->381658007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Erfi", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"10", "^", "6"}]}], "-", 
    RowBox[{
     RowBox[{"10.", "^", "3"}], " ", "I"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44106359],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->17046064],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455818501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19086575],

Cell["\<\
The imaginary error function for large imaginary-part arguments can be very \
close to \[ImaginaryI]:\
\>", "ExampleText",
 CellID->860499079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", 
  RowBox[{"0.1", "+", 
   RowBox[{"30", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55849266],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7.155170950793032896133422644775`15.455325455184633*^-394"}], 
  "+", 
  RowBox[{
  "0.9999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999975103622845530298627320723383383`408.35490692629514", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{592, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542179623]
}, Open  ]],

Cell["Very large arguments can give unevaluated results:", "ExampleText",
 CellID->516161038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Erfi", "[", 
  RowBox[{"10.", "^", "100"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->100624028],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->104308753],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->233080573]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7295],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erfc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erfc"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2727],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->20361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->28934],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Erfi.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/Erfi/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->294810770],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->45629053]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Erfi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 36.6522736}", "context" -> "System`", 
    "keywords" -> {
     "Dawson function", "Dawson integral", "error function", 
      "imaginary error function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Erfi[z] gives the imaginary error function erf(iz)/i. ", 
    "synonyms" -> {}, "title" -> "Erfi", "type" -> "Symbol", "uri" -> 
    "ref/Erfi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4517, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->111916367]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 57873, 1634}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1856, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2479, 75, 41, 1, 70, "ObjectName",
 CellID->3461],
Cell[2523, 78, 670, 22, 70, "Usage",
 CellID->12230]
}, Open  ]],
Cell[CellGroupData[{
Cell[3230, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3708, 122, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3831, 128, 240, 8, 70, "Notes",
 CellID->427101462],
Cell[4074, 138, 210, 7, 70, "Notes",
 CellID->31226],
Cell[4287, 147, 193, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[4517, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->111916367],
Cell[CellGroupData[{
Cell[4902, 173, 148, 5, 70, "ExampleSection",
 CellID->696579719],
Cell[5053, 180, 64, 1, 70, "ExampleText",
 CellID->145148934],
Cell[CellGroupData[{
Cell[5142, 185, 102, 3, 28, "Input",
 CellID->200092395],
Cell[5247, 190, 176, 5, 36, "Output",
 CellID->132181594]
}, Open  ]],
Cell[5438, 198, 123, 3, 70, "ExampleDelimiter",
 CellID->4566837],
Cell[CellGroupData[{
Cell[5586, 205, 235, 8, 28, "Input",
 CellID->160277689],
Cell[5824, 215, 2234, 41, 131, "Output",
 Evaluatable->False,
 CellID->244172651]
}, Open  ]],
Cell[8073, 259, 125, 3, 70, "ExampleDelimiter",
 CellID->256455803],
Cell[8201, 264, 77, 1, 70, "ExampleText",
 CellID->186900934],
Cell[CellGroupData[{
Cell[8303, 269, 217, 7, 70, "Input",
 CellID->274958927],
Cell[8523, 278, 1111, 37, 58, "Output",
 CellID->135893489]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9683, 321, 215, 7, 70, "ExampleSection",
 CellID->9393],
Cell[9901, 330, 74, 1, 70, "ExampleText",
 CellID->578872651],
Cell[CellGroupData[{
Cell[10000, 335, 125, 4, 70, "Input",
 CellID->208551184],
Cell[10128, 341, 270, 8, 36, "Output",
 CellID->510796022]
}, Open  ]],
Cell[10413, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->245815053],
Cell[10541, 357, 71, 1, 70, "ExampleText",
 CellID->1033859101],
Cell[CellGroupData[{
Cell[10637, 362, 178, 6, 70, "Input",
 CellID->382079554],
Cell[10818, 370, 235, 7, 36, "Output",
 CellID->137020043]
}, Open  ]],
Cell[11068, 380, 124, 3, 70, "ExampleDelimiter",
 CellID->10966615],
Cell[11195, 385, 112, 3, 70, "ExampleText",
 CellID->73638357],
Cell[CellGroupData[{
Cell[11332, 392, 137, 4, 70, "Input",
 CellID->325394274],
Cell[11472, 398, 229, 6, 36, "Output",
 CellID->420505875]
}, Open  ]],
Cell[11716, 407, 125, 3, 70, "ExampleDelimiter",
 CellID->404189143],
Cell[11844, 412, 91, 1, 70, "ExampleText",
 CellID->107281760],
Cell[CellGroupData[{
Cell[11960, 417, 99, 3, 70, "Input",
 CellID->19772109],
Cell[12062, 422, 158, 5, 36, "Output",
 CellID->238323329]
}, Open  ]],
Cell[12235, 430, 125, 3, 70, "ExampleDelimiter",
 CellID->116810855],
Cell[12363, 435, 90, 1, 70, "ExampleText",
 CellID->197537656],
Cell[CellGroupData[{
Cell[12478, 440, 118, 4, 70, "Input",
 CellID->240091487],
Cell[12599, 446, 206, 7, 36, "Output",
 CellID->131991894]
}, Open  ]],
Cell[CellGroupData[{
Cell[12842, 458, 123, 4, 70, "Input",
 CellID->610996349],
Cell[12968, 464, 222, 7, 36, "Output",
 CellID->264152354]
}, Open  ]],
Cell[13205, 474, 125, 3, 70, "ExampleDelimiter",
 CellID->130599840],
Cell[13333, 479, 202, 7, 70, "ExampleText",
 CellID->378727847],
Cell[CellGroupData[{
Cell[13560, 490, 163, 5, 70, "Input",
 CellID->542328797],
Cell[13726, 497, 273, 9, 36, "Output",
 CellID->52188292]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14048, 512, 239, 7, 70, "ExampleSection",
 CellID->21209],
Cell[14290, 521, 203, 7, 70, "ExampleText",
 CellID->312537900],
Cell[CellGroupData[{
Cell[14518, 532, 228, 8, 70, "Input",
 CellID->714385337],
Cell[14749, 542, 1130, 35, 58, "Output",
 CellID->2840067]
}, Open  ]],
Cell[15894, 580, 125, 3, 70, "ExampleDelimiter",
 CellID->259901392],
Cell[16022, 585, 84, 1, 70, "ExampleText",
 CellID->110201593],
Cell[CellGroupData[{
Cell[16131, 590, 181, 6, 70, "Input",
 CellID->134589180],
Cell[16315, 598, 242, 8, 36, "Output",
 CellID->601392228]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16606, 612, 222, 7, 70, "ExampleSection",
 CellID->9174],
Cell[16831, 621, 73, 1, 70, "ExampleText",
 CellID->750837339],
Cell[CellGroupData[{
Cell[16929, 626, 744, 24, 70, "Input",
 CellID->55174074],
Cell[17676, 652, 297, 10, 36, "Output",
 CellID->409143297]
}, Open  ]],
Cell[17988, 665, 125, 3, 70, "ExampleDelimiter",
 CellID->218573201],
Cell[18116, 670, 117, 3, 70, "ExampleText",
 CellID->783408171],
Cell[18236, 675, 576, 20, 70, "Input",
 CellID->137766098],
Cell[CellGroupData[{
Cell[18837, 699, 398, 14, 70, "Input",
 CellID->432034368],
Cell[19238, 715, 157, 5, 36, "Output",
 CellID->97990579]
}, Open  ]],
Cell[19410, 723, 152, 4, 70, "ExampleText",
 CellID->523529329],
Cell[CellGroupData[{
Cell[19587, 731, 253, 8, 70, "Input",
 CellID->156381689],
Cell[19843, 741, 3307, 101, 175, "Output",
 CellID->430720749]
}, Open  ]],
Cell[23165, 845, 125, 3, 70, "ExampleDelimiter",
 CellID->765922422],
Cell[23293, 850, 163, 4, 70, "ExampleText",
 CellID->495533592],
Cell[CellGroupData[{
Cell[23481, 858, 893, 31, 70, "Input",
 CellID->283389310],
Cell[24377, 891, 939, 33, 62, "Output",
 CellID->39227507]
}, Open  ]],
Cell[25331, 927, 62, 1, 70, "ExampleText",
 CellID->431262263],
Cell[CellGroupData[{
Cell[25418, 932, 532, 19, 70, "Input",
 CellID->298943440],
Cell[25953, 953, 160, 5, 36, "Output",
 CellID->96024901]
}, Open  ]],
Cell[26128, 961, 99, 3, 70, "ExampleText",
 CellID->306247606],
Cell[CellGroupData[{
Cell[26252, 968, 437, 15, 70, "Input",
 CellID->85162568],
Cell[26692, 985, 24234, 401, 70, "Output",
 Evaluatable->False,
 CellID->222318208]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50975, 1392, 233, 7, 70, "ExampleSection",
 CellID->12865],
Cell[51211, 1401, 97, 1, 70, "ExampleText",
 CellID->381658007],
Cell[CellGroupData[{
Cell[51333, 1406, 267, 10, 70, "Input",
 CellID->44106359],
Cell[51603, 1418, 356, 7, 70, "Message",
 CellID->17046064],
Cell[51962, 1427, 187, 6, 36, "Output",
 CellID->455818501]
}, Open  ]],
Cell[52164, 1436, 124, 3, 70, "ExampleDelimiter",
 CellID->19086575],
Cell[52291, 1441, 152, 4, 70, "ExampleText",
 CellID->860499079],
Cell[CellGroupData[{
Cell[52468, 1449, 149, 5, 70, "Input",
 CellID->55849266],
Cell[52620, 1456, 755, 16, 139, "Output",
 CellID->542179623]
}, Open  ]],
Cell[53390, 1475, 93, 1, 70, "ExampleText",
 CellID->516161038],
Cell[CellGroupData[{
Cell[53508, 1480, 127, 4, 70, "Input",
 CellID->100624028],
Cell[53638, 1486, 357, 7, 70, "Message",
 CellID->104308753],
Cell[53998, 1495, 187, 6, 36, "Output",
 CellID->233080573]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54246, 1508, 310, 9, 70, "SeeAlsoSection",
 CellID->7295],
Cell[54559, 1519, 431, 17, 70, "SeeAlso",
 CellID->288]
}, Open  ]],
Cell[CellGroupData[{
Cell[55027, 1541, 313, 9, 70, "TutorialsSection",
 CellID->2727],
Cell[55343, 1552, 144, 3, 70, "Tutorials",
 CellID->20361]
}, Open  ]],
Cell[CellGroupData[{
Cell[55524, 1560, 321, 9, 70, "RelatedLinksSection",
 CellID->28934],
Cell[55848, 1571, 175, 4, 70, "RelatedLinks"],
Cell[56026, 1577, 189, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56252, 1586, 319, 9, 70, "MoreAboutSection",
 CellID->294810770],
Cell[56574, 1597, 190, 4, 70, "MoreAbout",
 CellID->45629053]
}, Open  ]],
Cell[56779, 1604, 27, 0, 70, "History"],
Cell[56809, 1606, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

