(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47620,       1408]
NotebookOptionsPosition[     40689,       1170]
NotebookOutlinePosition[     42041,       1208]
CellTagsIndexPosition[     41955,       1203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolyGamma" :> Documentation`HelpLookup["paclet:ref/PolyGamma"],
           "StieltjesGamma" :> 
          Documentation`HelpLookup["paclet:ref/StieltjesGamma"], 
          "HarmonicNumber" :> 
          Documentation`HelpLookup["paclet:ref/HarmonicNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolyGamma\"\>", 
       2->"\<\"StieltjesGamma\"\>", 
       3->"\<\"HarmonicNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Mathematical Constants\"\>", 
       2->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EulerGamma", "ObjectName",
 CellID->19933],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["EulerGamma",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
     "\[LineSeparator]is Euler\[CloseCurlyQuote]s constant ",
     Cell[BoxData[
      StyleBox["\[Gamma]", "TR"]], "InlineFormula"],
     ", with numerical value ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[TildeEqual]", "0.577216"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6693]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Mathematical constant treated as numeric by ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " and as a constant by ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
 " can be evaluated to any numerical precision using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26414]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2277697],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->193865138],

Cell["Evaluate to any precision:", "ExampleText",
 CellID->23516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"EulerGamma", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31108],

Cell[BoxData["0.\
5772156649015328606065120900824024310421593359399235988057672348849`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->641523979]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31243],

Cell["Do an exact numerical computation:", "ExampleText",
 CellID->15804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"1", "/", 
   RowBox[{"EulerGamma", "^", "100"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22343],

Cell[BoxData["734833795660954410469466"], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->463818009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->412045039],

Cell[TextData[{
 "Find decimal digits ",
 Cell[BoxData["10000"], "InlineFormula"],
 " through ",
 Cell[BoxData["10050"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->574140161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealDigits", "[", 
   RowBox[{"EulerGamma", ",", "10", ",", "50", ",", 
    RowBox[{"-", 
     RowBox[{"10", "^", "4"}]}]}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411652538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5", ",", "5", ",", "5", ",", "2", ",", "1", ",", "5", ",", "9", ",", "0", 
   ",", "1", ",", "3", ",", "9", ",", "2", ",", "5", ",", "6", ",", "0", ",", 
   "3", ",", "2", ",", "0", ",", "6", ",", "1", ",", "3", ",", "7", ",", "6", 
   ",", "4", ",", "2", ",", "7", ",", "1", ",", "5", ",", "6", ",", "2", ",", 
   "8", ",", "0", ",", "1", ",", "1", ",", "8", ",", "9", ",", "7", ",", "1", 
   ",", "0", ",", "9", ",", "6", ",", "1", ",", "1", ",", "4", ",", "0", ",", 
   "0", ",", "2", ",", "3", ",", "9", ",", "1"}], "}"}]], "Output",
 ImageSize->{480, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24412946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32523273],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->81400640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerGamma", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294896841],

Cell[BoxData[
 FormBox[
  TagBox["\[DoubledGamma]",
   Function[{}, EulerGamma]], TraditionalForm]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->777713143]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "The first 20 digits of ",
 Cell[BoxData[
  StyleBox["\[Gamma]", "TR"]], "InlineFormula"],
 " in base 10:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"EulerGamma", ",", "10", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "5", ",", "7", ",", "7", ",", "2", ",", "1", ",", "5", ",", "6", ",", "6",
      ",", "4", ",", "9", ",", "0", ",", "1", ",", "5", ",", "3", ",", "2", 
     ",", "8", ",", "6", ",", "0", ",", "6", ",", "0"}], "}"}], ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455838083]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"EulerGamma", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "4", 
   ",", "3", ",", "13", ",", "5", ",", "1", ",", "1", ",", "8", ",", "1", ",",
    "2", ",", "4", ",", "1", ",", "1", ",", "40"}], "}"}]], "Output",
 ImageSize->{385, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118604940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot scaled sums of divisors:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"DivisorSigma", "[", 
      RowBox[{"1", ",", "n"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"Log", "[", "n", "]"}], "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{290, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61040150]
}, Open  ]],

Cell["Compute the asymptotic upper bound:", "ExampleText",
 CellID->26328698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Exp", "[", "EulerGamma", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227386178],

Cell[BoxData["1.781072417990198`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->991679713]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Various symbolic relations are automatically used:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "2"}], "<", "EulerGamma", "<", "1"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->869212708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->869248806],

Cell[TextData[{
 "Mathematical functions and operations often give results involving ",
 Cell[BoxData[
  StyleBox["\[Gamma]", "TR"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->18260894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     FractionBox["1", "k"]}], "-", 
    RowBox[{"Log", "[", "n", "]"}]}], ",", 
   RowBox[{"n", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1811446],

Cell[BoxData["EulerGamma"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34749791]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"s", " ", "-", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "/", "s"}], "]"}]}], ",", " ", 
   RowBox[{"s", " ", "->", " ", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119162656],

Cell[BoxData["EulerGamma"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->619162855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "2"}], "\[Infinity]"], 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], " ", 
    RowBox[{"Log", "[", "k", "]"}]}], "k"]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->270158423],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "EulerGamma", " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Log", "[", "2", "]"}], "2"]}], ")"}]}]], "Output",
 ImageSize->{218, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->400485398]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "2"}], "\[Infinity]"], 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Zeta", "[", "k", "]"}], "-", "1"}], ")"}]}], 
   RowBox[{"k", " ", 
    SuperscriptBox["2", "k"]}]]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14787389],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "EulerGamma", "-", 
    RowBox[{"4", " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", "3", "]"}]}], "+", 
    RowBox[{"Log", "[", "\[Pi]", "]"}]}], ")"}]}]], "Output",
 ImageSize->{315, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->94285224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "t", "]"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", "t"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->421148430],

Cell[BoxData[
 RowBox[{"-", "EulerGamma"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->155233393]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StieltjesGamma", "[", "0", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->110912924],

Cell[BoxData["EulerGamma"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->116542324]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "It is currently not known if ",
 Cell[BoxData[
  ButtonBox["EulerGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
 " is an algebraic number:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"EulerGamma", ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"EulerGamma", "\[Element]", "Algebraics"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38538604]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Terms in the continued fraction:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"ContinuedFraction", "[", 
    RowBox[{"EulerGamma", ",", "400"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdmEmuHEUURQNGDHPAgAGD5AshZCGU9D0O09hgwC6+wfQmMLZpbPPLprGZ
xRJyCbmEWkIsoZYQS8glIFT3fOndmoRO3ffiRfsiMp66fnJ889GU0vxISv+X
h996NsVfjv8/ZjzkaPe46U+Y/qTpY471HOUY52mVZ1Q+Y3GetfrOGD+XY5zn
TZ+sfS9Ye140+5eMXxZ/oPIV01+1dr+mkv69rpJxecP83zT9LdPfNn5HzPi8
a/rZA9eP9H9Wqf7WbPbnDpw30s+Z/p75w7T3fZXqf4Xx17itD6UzjszHh9G+
wozf+Whfz0f7dMH0C6YzDhqv03Gh/o/NH8b/oljrtF40/RNrv3H61HSY/n9m
unG6FNtbL5l+Wcz8XDZ9E5l5Pu0vrPFpZp8+j/EzrH1fYdXXYPyPo56Po16N
m3G6Yv5Xol5hta/B7PsvVCo/ZBh/4wYzP1/G+jJM/2H8YfyvWvuvRvsKaz81
s09fRftsXI0bzPr+2vxh5t/0Znr6RqXybobZTzD+xulbiw8zfqY3mPjfmb9x
hZV/Goz/97G9GSY+THzj9IPFh/E3vcHEvxY5X4v2FWb/wZyrP5o/jL9xg8nP
RaXmb4SVLzIs/wKzPsx+Mftmejc9/RR5hHVOZtMLfKT4sMZngck35t+N03WL
D5MPYO2XAtN/mP6b3sScqx2d8/lniw8zn6YXmHxv9gus9jTTu9WXbsT2jLDu
VflGtC+w7kkV1npcYPoP03+Ll27G/oww+wlW/cX0av6L6Q2m/6anW2Ld88Zb
Uc+w/AtM/81+gdXeZnqHuSf+EvURln82vYg5Ryu62r+YfbP6Osw94tfYvxGm
/7DyQxFzj6lmv4jJ8830DnMv/y3qI0w+hrUfi9lXmPUP6z7WTO/mn363+DD3
GeMCs//NfxEz7830DvN9cTvWP8Ls/9vRvsD03+wX05txN053xFof452oZ+Ni
XM1/Mb3B6l+HOf/uqp9az+PdqGeY+DDnq9kvxg1WPutWX/oj8micYdaf6RUm
Psx90/Ru/ulErO+G8STqGdZ3YYG5z8PEh5UPmtXXYb6ztlEfYPKh6RPM/MDa
zxuzL2a/Na6w9uts/ovxzvwbrPWwF5MfO7ruO6vVl+7F+ANMPrwX7SfjbLwx
/2L6Fub8NvsZ5j5h/juY88Xq25t9N15h3gnuR324H/XR9Mk4w4q/gclXsMZ/
a/7VeIY1Hwus8dkZN1jvHHurr8M6b1drb/pTpfLDAJMPxLxbTOjcD2H1b2P+
BWb9m15Nn40Xs98ZN7Pfw+Rbs19h3sn+ivoAs/5h1TeZfTbeGBfjLazxq7DG
bzb7xXhn3GCtt721v8O6T6ww74Z/x/oGWO+EIyz/yewzzPybXsx/a3o1no0X
WPt9Z/U1s9+LeUfrpq/mn/6J+gAfHcoR1nqZzD4bb2DVX2Dtvy2s86zCWg+z
+S9W/w7WedNM3xt34xXm+/mBSq3v4UG0H2HdZyfTs5hza2N6Md7Cmp9q+mzt
WWDyH6zxaua/N/9u+mqc9O7Ku/YAs/8fRvvJOBtvjAt8dCi3plfjGeY+CWv9
7WDew8x/b+3vsPLDavbp31P+D+Dnu5Q=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251958897]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Weyl\[Hyphen]type sum involving ",
 Cell[BoxData[
  ButtonBox["EulerGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
 ":  "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", 
      RowBox[{"10.", "^", "4"}], "EulerGamma", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Range", "[", "5000", "]"}], "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->970678010]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25706],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StieltjesGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StieltjesGamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HarmonicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5809]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12037],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->18551]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->17067],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#23513"], None}]], "RelatedLinks",
 CellID->193912494],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Euler-MascheroniConstant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/EulerGamma/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
EulerGamma"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->113647373],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->123051401],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->88272797]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EulerGamma - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 44.7774816}", "context" -> "System`", 
    "keywords" -> {
     "Brent-McMillan algorithm", "Euler gamma", "Euler-Mascheroni constant", 
      "Euler's constant"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EulerGamma is Euler\\[CloseCurlyQuote]s constant \\[Gamma], with \
numerical value \\[TildeEqual] 0.577216. ", "synonyms" -> {"euler gamma"}, 
    "title" -> "EulerGamma", "type" -> "Symbol", "uri" -> "ref/EulerGamma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4731, 158, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2277697]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 41814, 1196}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2162, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2785, 80, 48, 1, 70, "ObjectName",
 CellID->19933],
Cell[2836, 83, 659, 21, 70, "Usage",
 CellID->6693]
}, Open  ]],
Cell[CellGroupData[{
Cell[3532, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4010, 126, 348, 13, 70, "Notes",
 CellID->197],
Cell[4361, 141, 333, 12, 70, "Notes",
 CellID->26414]
}, Closed]],
Cell[CellGroupData[{
Cell[4731, 158, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2277697],
Cell[CellGroupData[{
Cell[5114, 172, 148, 5, 70, "ExampleSection",
 CellID->193865138],
Cell[5265, 179, 65, 1, 70, "ExampleText",
 CellID->23516],
Cell[CellGroupData[{
Cell[5355, 184, 126, 4, 28, "Input",
 CellID->31108],
Cell[5484, 190, 235, 7, 36, "Output",
 CellID->641523979]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5768, 203, 216, 7, 70, "ExampleSection",
 CellID->31243],
Cell[5987, 212, 73, 1, 70, "ExampleText",
 CellID->15804],
Cell[CellGroupData[{
Cell[6085, 217, 155, 5, 70, "Input",
 CellID->22343],
Cell[6243, 224, 182, 5, 36, "Output",
 CellID->463818009]
}, Open  ]],
Cell[6440, 232, 125, 3, 70, "ExampleDelimiter",
 CellID->412045039],
Cell[6568, 237, 182, 7, 70, "ExampleText",
 CellID->574140161],
Cell[CellGroupData[{
Cell[6775, 248, 259, 8, 70, "Input",
 CellID->411652538],
Cell[7037, 258, 710, 14, 54, "Output",
 CellID->24412946]
}, Open  ]],
Cell[7762, 275, 124, 3, 70, "ExampleDelimiter",
 CellID->32523273],
Cell[7889, 280, 202, 7, 70, "ExampleText",
 CellID->81400640],
Cell[CellGroupData[{
Cell[8116, 291, 116, 3, 70, "Input",
 CellID->294896841],
Cell[8235, 296, 257, 8, 50, "Output",
 CellID->777713143]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8541, 310, 207, 6, 70, "ExampleSection"],
Cell[8751, 318, 142, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[8918, 327, 130, 3, 70, "Input"],
Cell[9051, 332, 453, 13, 36, "Output",
 CellID->455838083]
}, Open  ]],
Cell[9519, 348, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[9649, 354, 126, 3, 70, "Input"],
Cell[9778, 359, 397, 10, 36, "Output",
 CellID->118604940]
}, Open  ]],
Cell[10190, 372, 105, 2, 70, "ExampleDelimiter"],
Cell[10298, 376, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10375, 380, 412, 13, 70, "Input"],
Cell[10790, 395, 8739, 147, 70, "Output",
 Evaluatable->False,
 CellID->61040150]
}, Open  ]],
Cell[19544, 545, 77, 1, 70, "ExampleText",
 CellID->26328698],
Cell[CellGroupData[{
Cell[19646, 550, 136, 4, 70, "Input",
 CellID->227386178],
Cell[19785, 556, 175, 5, 36, "Output",
 CellID->991679713]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20009, 567, 217, 6, 70, "ExampleSection"],
Cell[20229, 575, 73, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20327, 579, 114, 3, 70, "Input"],
Cell[20444, 584, 161, 5, 36, "Output",
 CellID->869212708]
}, Open  ]],
Cell[20620, 592, 125, 3, 70, "ExampleDelimiter",
 CellID->869248806],
Cell[20748, 597, 195, 6, 70, "ExampleText",
 CellID->18260894],
Cell[CellGroupData[{
Cell[20968, 607, 330, 11, 70, "Input",
 CellID->1811446],
Cell[21301, 620, 166, 5, 36, "Output",
 CellID->34749791]
}, Open  ]],
Cell[CellGroupData[{
Cell[21504, 630, 268, 8, 70, "Input",
 CellID->119162656],
Cell[21775, 640, 167, 5, 36, "Output",
 CellID->619162855]
}, Open  ]],
Cell[CellGroupData[{
Cell[21979, 650, 310, 11, 70, "Input",
 CellID->270158423],
Cell[22292, 663, 385, 13, 51, "Output",
 CellID->400485398]
}, Open  ]],
Cell[CellGroupData[{
Cell[22714, 681, 413, 15, 70, "Input",
 CellID->14787389],
Cell[23130, 698, 459, 15, 51, "Output",
 CellID->94285224]
}, Open  ]],
Cell[CellGroupData[{
Cell[23626, 718, 321, 11, 70, "Input",
 CellID->421148430],
Cell[23950, 731, 184, 6, 36, "Output",
 CellID->155233393]
}, Open  ]],
Cell[CellGroupData[{
Cell[24171, 742, 110, 3, 70, "Input",
 CellID->110912924],
Cell[24284, 747, 167, 5, 36, "Output",
 CellID->116542324]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24500, 758, 210, 6, 70, "ExampleSection"],
Cell[24713, 766, 219, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24957, 777, 124, 3, 70, "Input"],
Cell[25084, 782, 207, 6, 36, "Output",
 CellID->38538604]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25340, 794, 208, 6, 70, "ExampleSection"],
Cell[25551, 802, 55, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[25631, 806, 232, 6, 70, "Input"],
Cell[25866, 814, 2034, 40, 136, "Output",
 CellID->251958897]
}, Open  ]],
Cell[27915, 857, 105, 2, 70, "ExampleDelimiter"],
Cell[28023, 861, 201, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[28249, 872, 475, 15, 70, "Input"],
Cell[28727, 889, 8199, 138, 70, "Output",
 Evaluatable->False,
 CellID->970678010]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36987, 1034, 311, 9, 70, "SeeAlsoSection",
 CellID->25706],
Cell[37301, 1045, 721, 26, 70, "SeeAlso",
 CellID->5809]
}, Open  ]],
Cell[CellGroupData[{
Cell[38059, 1076, 314, 9, 70, "TutorialsSection",
 CellID->12037],
Cell[38376, 1087, 154, 3, 70, "Tutorials",
 CellID->18551]
}, Open  ]],
Cell[CellGroupData[{
Cell[38567, 1095, 321, 9, 70, "RelatedLinksSection",
 CellID->17067],
Cell[38891, 1106, 271, 6, 70, "RelatedLinks",
 CellID->193912494],
Cell[39165, 1114, 195, 4, 70, "RelatedLinks"],
Cell[39363, 1120, 192, 4, 70, "RelatedLinks"],
Cell[39558, 1126, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39983, 1144, 319, 9, 70, "MoreAboutSection",
 CellID->113647373],
Cell[40305, 1155, 155, 3, 70, "MoreAbout",
 CellID->123051401],
Cell[40463, 1160, 154, 3, 70, "MoreAbout",
 CellID->88272797]
}, Open  ]],
Cell[40632, 1166, 27, 0, 70, "History"],
Cell[40662, 1168, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

