(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27229,       1042]
NotebookOptionsPosition[     20517,        807]
NotebookOutlinePosition[     21928,        846]
CellTagsIndexPosition[     21843,        841]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Plotting" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicPlotting"], 
          "Non\[Hyphen]Standard Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/NonStandardEvaluation"], 
          "Evaluation in Iteration Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationInIterationFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Basic Plotting\"\>", 
       2->"\<\"Non\[Hyphen]Standard Evaluation\"\>", 
       3->"\<\"Evaluation in Iteration Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReleaseHold" :> 
          Documentation`HelpLookup["paclet:ref/ReleaseHold"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ReleaseHold\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Evaluate", "ObjectName",
 CellID->8923],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Evaluate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Evaluate"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]causes ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to be evaluated even if it appears as the argument of a function whose \
attributes specify that it should be held unevaluated. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26836]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to override ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ", etc. attributes of built\[Hyphen]in functions. "
}], "Notes",
 CellID->1877],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " only overrides ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ", etc. attributes when it appears directly as the head of the function \
argument that would otherwise be held. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->333366049]
}], "Notes",
 CellID->27543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9156852],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->660488728],

Cell[TextData[{
 "Evaluate inside a ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->764668455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "1"}], "]"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191925773],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"2", ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64084705]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17966],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " works for arguments of any symbol with attributes ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->64843843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Attributes", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280159727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Listable", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->789621402]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["Attributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Attributes"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to find the properties of the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->120818521],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "Plus"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22499538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Attributes", "[", "x", "]"}], ",", 
   RowBox[{"Attributes", "[", 
    RowBox[{"Evaluate", "[", "x", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->321129716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
     "Orderless", ",", "Protected"}], "}"}]}], "}"}]], "Output",
 ImageSize->{506, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->59658054]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25343],

Cell["Unprotect a system symbol to make a definition for it:", "ExampleText",
 CellID->84564791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"protected", "=", 
  RowBox[{"Unprotect", "[", "Sqrt", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->906585307],

Cell[BoxData[
 RowBox[{"{", "\<\"Sqrt\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381261637]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{"x_", "^", "2"}], "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->220282351],

Cell["Restore protection:", "ExampleText",
 CellID->150820276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", 
  RowBox[{"Evaluate", "[", "protected", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->84421882],

Cell[BoxData[
 RowBox[{"{", "\<\"Sqrt\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->618014553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189303037],

Cell["\<\
Force evaluation of the right-hand side of a delayed definition:\
\>", "ExampleText",
 CellID->71912026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693797959],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207005129]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Evaluate", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->514862557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81399932],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVc1OAkEMLjP7I4oSMUHQCxfjkygnHmJDTOBgNMhNX8mfg/p62M5Ocbbb
yS6BTXa77df5pl87LLNivXh4LNbLeTGZrornxXL+Mrl/WmHIdgDMHQD0R4Dv
G3xzN19TvAGO8WkwPPCW0dstCnYbhi4+MnStiPOqG7eqhMuLkhJyk3Bv2sl4
eyK4Mh/vo03RZgpObip48pZ5PZGXCJyC306AEZmp8E1Vl8LNWhKv5UjBazuk
YafAK6juI3narjvV1lUyyPy0Um+9Nsk5VvpLpXUjfc8b8N7m/xzwfH73qpAZ
m6YRq0jGY3lnCv9uCtqfsPMGLbnPy2qMsgvxzF1Oz2G+AVLVQOlPyHPRgJO1
fjIyzpP5ajUZWYk89W72tV/kWI3KmY6ET493l2t9/XzC+Kt9FfSL8OtAZ8g0
VJg/HPObQC6jNbwGCFU/FD5lfqqc8d25G+V/EnT+AHx2jIU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->378475291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45429138],

Cell["Build a function from an expression:", "ExampleText",
 CellID->49308339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ch", "=", 
  RowBox[{"ChebyshevT", "[", 
   RowBox[{"5", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416292669],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", "x"}], "-", 
  RowBox[{"20", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4079986]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Evaluate", "[", "ch", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95633607],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "-", 
    RowBox[{"20", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["x", "5"]}]}]}], "]"}]], "Output",
 ImageSize->{194, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139877241]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "10", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->734411215],

Cell[BoxData["1580050"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29935808]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21821],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " does not work inside functions with attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->184400228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16461691],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104342376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->684979358],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " to temporarily treat a function as if it were ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->682373314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "2", "+", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186589571],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236377383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"1", "+", "2", "+", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197078158],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->715294377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67866801],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " does not work inside ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->650884407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unevaluated", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77709259],

Cell[BoxData[
 RowBox[{"Unevaluated", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->577357814]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24533],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " works only on the first level, directly inside a held function:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->333366049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306468591],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "2"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286000131]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6427],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21903]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28086],

Cell[TextData[ButtonBox["Basic Plotting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicPlotting"]], "Tutorials",
 CellID->11286],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->28266],

Cell[TextData[ButtonBox["Evaluation in Iteration Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EvaluationInIterationFunctions"]], "Tutorials",
 CellID->531660691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Evaluate",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Evaluate"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->20189821],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->482344371],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->170338955]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Evaluate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 46.6212788}", "context" -> "System`", 
    "keywords" -> {
     "arguments", "evaluate button action", "evaluation", 
      "forcing evaluation", "overriding hold", "releasing held arguments"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Evaluate[expr] causes expr to be evaluated even if it appears as the \
argument of a function whose attributes specify that it should be held \
unevaluated. ", "synonyms" -> {}, "title" -> "Evaluate", "type" -> "Symbol", 
    "uri" -> "ref/Evaluate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4978, 161, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9156852]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21702, 834}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2215, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2838, 81, 45, 1, 70, "ObjectName",
 CellID->8923],
Cell[2886, 84, 658, 19, 70, "Usage",
 CellID->26836]
}, Open  ]],
Cell[CellGroupData[{
Cell[3581, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4059, 125, 371, 13, 70, "Notes",
 CellID->1877],
Cell[4433, 140, 508, 16, 70, "Notes",
 CellID->27543]
}, Closed]],
Cell[CellGroupData[{
Cell[4978, 161, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9156852],
Cell[CellGroupData[{
Cell[5361, 175, 148, 5, 70, "ExampleSection",
 CellID->660488728],
Cell[5512, 182, 193, 8, 70, "ExampleText",
 CellID->764668455],
Cell[CellGroupData[{
Cell[5730, 194, 208, 7, 28, "Input",
 CellID->191925773],
Cell[5941, 203, 234, 8, 36, "Output",
 CellID->64084705]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6224, 217, 216, 7, 70, "ExampleSection",
 CellID->17966],
Cell[6443, 226, 607, 22, 70, "ExampleText",
 CellID->64843843],
Cell[CellGroupData[{
Cell[7075, 252, 115, 3, 70, "Input",
 CellID->280159727],
Cell[7193, 257, 235, 7, 36, "Output",
 CellID->789621402]
}, Open  ]],
Cell[7443, 267, 552, 21, 70, "ExampleText",
 CellID->120818521],
Cell[7998, 290, 112, 4, 70, "Input",
 CellID->22499538],
Cell[CellGroupData[{
Cell[8135, 298, 228, 7, 70, "Input",
 CellID->321129716],
Cell[8366, 307, 372, 12, 36, "Output",
 CellID->59658054]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8787, 325, 223, 7, 70, "ExampleSection",
 CellID->25343],
Cell[9013, 334, 96, 1, 70, "ExampleText",
 CellID->84564791],
Cell[CellGroupData[{
Cell[9134, 339, 139, 4, 70, "Input",
 CellID->906585307],
Cell[9276, 345, 191, 6, 36, "Output",
 CellID->381261637]
}, Open  ]],
Cell[9482, 354, 149, 5, 70, "Input",
 CellID->220282351],
Cell[9634, 361, 62, 1, 70, "ExampleText",
 CellID->150820276],
Cell[CellGroupData[{
Cell[9721, 366, 145, 4, 70, "Input",
 CellID->84421882],
Cell[9869, 372, 191, 6, 36, "Output",
 CellID->618014553]
}, Open  ]],
Cell[10075, 381, 125, 3, 70, "ExampleDelimiter",
 CellID->189303037],
Cell[10203, 386, 114, 3, 70, "ExampleText",
 CellID->71912026],
Cell[CellGroupData[{
Cell[10342, 393, 174, 6, 70, "Input",
 CellID->693797959],
Cell[10519, 401, 296, 10, 36, "Output",
 CellID->207005129]
}, Open  ]],
Cell[10830, 414, 157, 5, 70, "Input",
 CellID->514862557],
Cell[CellGroupData[{
Cell[11012, 423, 105, 3, 70, "Input",
 CellID->81399932],
Cell[11120, 428, 687, 15, 70, "Output",
 Evaluatable->False,
 CellID->378475291]
}, Open  ]],
Cell[11822, 446, 124, 3, 70, "ExampleDelimiter",
 CellID->45429138],
Cell[11949, 451, 78, 1, 70, "ExampleText",
 CellID->49308339],
Cell[CellGroupData[{
Cell[12052, 456, 154, 5, 70, "Input",
 CellID->416292669],
Cell[12209, 463, 310, 11, 36, "Output",
 CellID->4079986]
}, Open  ]],
Cell[CellGroupData[{
Cell[12556, 479, 163, 5, 70, "Input",
 CellID->95633607],
Cell[12722, 486, 381, 13, 39, "Output",
 CellID->139877241]
}, Open  ]],
Cell[CellGroupData[{
Cell[13140, 504, 98, 3, 70, "Input",
 CellID->734411215],
Cell[13241, 509, 163, 5, 36, "Output",
 CellID->29935808]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13453, 520, 233, 7, 70, "ExampleSection",
 CellID->21821],
Cell[13689, 529, 363, 12, 70, "ExampleText",
 CellID->184400228],
Cell[CellGroupData[{
Cell[14077, 545, 166, 5, 70, "Input",
 CellID->16461691],
Cell[14246, 552, 256, 8, 36, "Output",
 CellID->104342376]
}, Open  ]],
Cell[14517, 563, 125, 3, 70, "ExampleDelimiter",
 CellID->684979358],
Cell[14645, 568, 362, 13, 70, "ExampleText",
 CellID->682373314],
Cell[CellGroupData[{
Cell[15032, 585, 174, 5, 70, "Input",
 CellID->186589571],
Cell[15209, 592, 158, 5, 36, "Output",
 CellID->236377383]
}, Open  ]],
Cell[CellGroupData[{
Cell[15404, 602, 135, 4, 70, "Input",
 CellID->197078158],
Cell[15542, 608, 158, 5, 36, "Output",
 CellID->715294377]
}, Open  ]],
Cell[15715, 616, 124, 3, 70, "ExampleDelimiter",
 CellID->67866801],
Cell[15842, 621, 330, 12, 70, "ExampleText",
 CellID->650884407],
Cell[CellGroupData[{
Cell[16197, 637, 165, 5, 70, "Input",
 CellID->77709259],
Cell[16365, 644, 255, 8, 36, "Output",
 CellID->577357814]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16669, 658, 226, 7, 70, "ExampleSection",
 CellID->24533],
Cell[16898, 667, 289, 8, 70, "ExampleText",
 CellID->333366049],
Cell[CellGroupData[{
Cell[17212, 679, 189, 6, 70, "Input",
 CellID->306468591],
Cell[17404, 687, 278, 9, 36, "Output",
 CellID->286000131]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17743, 703, 310, 9, 70, "SeeAlsoSection",
 CellID->6427],
Cell[18056, 714, 202, 6, 70, "SeeAlso",
 CellID->21903]
}, Open  ]],
Cell[CellGroupData[{
Cell[18295, 725, 314, 9, 70, "TutorialsSection",
 CellID->28086],
Cell[18612, 736, 138, 3, 70, "Tutorials",
 CellID->11286],
Cell[18753, 741, 163, 3, 70, "Tutorials",
 CellID->28266],
Cell[18919, 746, 178, 3, 70, "Tutorials",
 CellID->531660691]
}, Open  ]],
Cell[CellGroupData[{
Cell[19134, 754, 305, 8, 70, "RelatedLinksSection"],
Cell[19442, 764, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19840, 781, 318, 9, 70, "MoreAboutSection",
 CellID->20189821],
Cell[20161, 792, 147, 3, 70, "MoreAbout",
 CellID->482344371],
Cell[20311, 797, 134, 3, 70, "MoreAbout",
 CellID->170338955]
}, Open  ]],
Cell[20460, 803, 27, 0, 70, "History"],
Cell[20490, 805, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

