(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    947338,      19284]
NotebookOptionsPosition[    934206,      18836]
NotebookOutlinePosition[    935717,      18876]
CellTagsIndexPosition[    935629,      18871]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Monitoring and Selecting Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MonitoringAndSelectingAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Monitoring and Selecting Algorithms\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StepMonitor" :> 
          Documentation`HelpLookup["paclet:ref/StepMonitor"], "Sow" :> 
          Documentation`HelpLookup["paclet:ref/Sow"], "Monitor" :> 
          Documentation`HelpLookup["paclet:ref/Monitor"], "Print" :> 
          Documentation`HelpLookup["paclet:ref/Print"], "Trace" :> 
          Documentation`HelpLookup["paclet:ref/Trace"], "Method" :> 
          Documentation`HelpLookup["paclet:ref/Method"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StepMonitor\"\>", 2->"\<\"Sow\"\>", 
       3->"\<\"Monitor\"\>", 4->"\<\"Print\"\>", 5->"\<\"Trace\"\>", 
       6->"\<\"Method\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differential Equations" :> 
          Documentation`HelpLookup["paclet:guide/DifferentialEquations"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Differential Equations\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Tuning & Debugging\"\>", 
       4->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["EvaluationMonitor", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["EvaluationMonitor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EvaluationMonitor"]], "InlineFormula"],
     "\[LineSeparator]is an option for various numerical computation and \
plotting functions that gives an expression to evaluate whenever functions \
derived from the input are evaluated numerically. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21396]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The option setting is normally given as ",
 Cell[BoxData[
  RowBox[{"EvaluationMonitor", ":>", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 ". The ",
 Cell[BoxData[":>"], "InlineFormula"],
 " is used instead of ",
 Cell[BoxData["->"], "InlineFormula"],
 " to avoid ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " being immediately evaluated. "
}], "Notes",
 CellID->27248],

Cell[TextData[{
 "Whenever ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is evaluated, all variables in the numerical computation are assigned \
their current values. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["var", "TI"], 
        StyleBox["1", "TR"]], "=", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is effectively used. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->217061240]
}], "Notes",
 CellID->30521]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->795295379],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->733790817],

Cell["\<\
Print information with every function evaluation used to find a root:\
\>", "ExampleText",
 CellID->286228222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<x = \>\"", ",", 
      RowBox[{"x", "\"\< x^2 - 2 =\>\""}], ",", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "2"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56852686],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", 
   RowBox[{"1.`", " ", "\<\" x^2 - 2 =\"\>"}], "\[InvisibleSpace]", 
   RowBox[{"-", "1.`"}]}],
  SequenceForm["x = ", 1. " x^2 - 2 =", -1.],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->66519192],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", 
   RowBox[{"1.5`", " ", "\<\" x^2 - 2 =\"\>"}], "\[InvisibleSpace]", 
   "0.25`"}],
  SequenceForm["x = ", 1.5 " x^2 - 2 =", 0.25],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->829784082],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", 
   RowBox[{"1.4166666666666667`", " ", "\<\" x^2 - 2 =\"\>"}], 
   "\[InvisibleSpace]", "0.006944444444444642`"}],
  SequenceForm[
  "x = ", 1.4166666666666667` " x^2 - 2 =", 0.006944444444444642],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->371144467],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", 
   RowBox[{"1.4142156862745099`", " ", "\<\" x^2 - 2 =\"\>"}], 
   "\[InvisibleSpace]", "6.007304882871267`*^-6"}],
  SequenceForm[
  "x = ", 1.4142156862745099` " x^2 - 2 =", 6.007304882871267*^-6],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->320519877],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", 
   RowBox[{"1.4142135623746899`", " ", "\<\" x^2 - 2 =\"\>"}], 
   "\[InvisibleSpace]", "4.510614104447086`*^-12"}],
  SequenceForm[
  "x = ", 1.4142135623746899` " x^2 - 2 =", 4.510614104447086*^-12],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->88038901],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", 
   RowBox[{"1.4142135623730951`", " ", "\<\" x^2 - 2 =\"\>"}], 
   "\[InvisibleSpace]", "4.440892098500626`*^-16"}],
  SequenceForm[
  "x = ", 1.4142135623730951` " x^2 - 2 =", 4.440892098500626*^-16],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->106073257]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.4142135623730951`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189987514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163734253],

Cell["Count evaluations:", "ExampleText",
 CellID->47628525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"c", "++"}]}]}], "]"}], ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168840014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.4142135623730951`"}], "}"}], ",", "6"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->613391840]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41125070],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " to collect evaluation data:"
}], "ExampleText",
 CellID->255739193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"res", ",", " ", "data"}], "}"}], " ", "=", " ", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"x", "-", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}]}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->915255649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.4142135623730951`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.41421356237309515`"}], ",", "0.08578643762690485`", ",",
       "0.002453104293571595`", ",", "2.1239014147411694`*^-6", ",", 
      "1.5947243525715749`*^-12", ",", "0.`"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{571, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118730808]
}, Open  ]],

Cell["Show the superlinear convergence of the method:", "ExampleText",
 CellID->136227688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{"data", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->782334851],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV81OAjEQLuwC0YMJGn4So+HoO6jxYFYuehPR44aYwEEwyFuoJ/Fg9Ki+
gEQfwIuevHr2Rep0t6W1259lhaBGki2d6Tcz7czXdnfH7zUPj/xeq+FXql3/
uNlqnFS2Ol1QOSmE0ACedhlBH0MveAYYw7/Y7kHrwJBDJNLBwQ+loesZxgId
OpBHSONyGaGqFZEes6c6tGSGmcQe9iWcE8F52hhxV+NJCFfjidUnSyNWhci8
DtG6LlO7i6EkRjsN5Lvbt431q/Oz53AdaBHaSwC5Sps1Sd5mcqf98PT4Tn3Y
rHaVKPUsp6Gli6e/NM1yUYnV8EfALUzBjlfdjs9SPFtnNmHcnBUhnyE02w7P
toM5o102lMDn/C+xywvr1ed+UjyXK59Xoux1nfuGHYnbHwHPmW3Hs/NSnVW7
ffRkz2jzKFaRsZceh9xcY180zrMQcxZxceZof5lrSe1+Fueagczv7ZVhfpNx
MPRXr92DP2/zhvqzsym0e335oHc/t3O065fvUDVDS1h4s/pn6JgZmpNkN2Hc
eH60vBRufX2tC4IWGVml33Pm0VKsVcTj0Sr+ujNrBhTfbyYU311qVDiPWSG3
qm80olKvayZS5eg3iOxV/SaT1BNn7vTnMklPrEbyfhjljFvClF8wQPjVF7TA
J9ASPola4A9oCX/6Br+jaEvYxKdyrFwkR3G2jDMSu2+uAyn6HY1Sn2g0InM=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60973912]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->647206519],

Cell["\<\
Monitor the solution progress when solving the sine-Gordon PDE:\
\>", "ExampleText",
 CellID->129132036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[PartialD]", 
          RowBox[{"t", ",", "t"}]], 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[PartialD]", 
           RowBox[{"x", ",", "x"}]], 
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}]}], "+", 
         RowBox[{"Sin", "[", 
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}], "]"}]}]}], " ", ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}]]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", 
          RowBox[{"-", "10"}]}], "]"}], "\[Equal]", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "10"}], "]"}]}]}], "}"}], ",", "u", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sol", "=", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], ";", " ", 
        RowBox[{"time", "=", "t"}]}], ")"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{"sol", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "time"}]}], "]"}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->58124783],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10.`"}], ",", "10.`"}], "}"}]}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{402, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351875903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234396285],

Cell["Evaluations for a numerical minimization:", "ExampleText",
 CellID->121400988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"res", ",", " ", "data"}], "}"}], " ", "=", " ", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"100", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", 
          RowBox[{"Sin", "[", "x", "]"}]}], ")"}], "^", "2"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227809068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "1.`"}], ",", 
       RowBox[{"y", "\[Rule]", "0.8414709848078965`"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10.`"}], ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.9999999999999947`", ",", 
        RowBox[{"-", "8.685765708951603`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "9.101355977974794`"}], ",", 
        RowBox[{"-", "0.13800346081202863`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "7.13836618257932`"}], ",", 
        RowBox[{"-", "2.1348400223134436`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "8.93015928136696`"}], ",", 
        RowBox[{"-", "0.4144203537876127`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "8.462645014123787`"}], ",", 
        RowBox[{"-", "0.8360598779357548`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "7.334722827668506`"}], ",", 
        RowBox[{"-", "1.429098509512028`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "8.078201360249325`"}], ",", 
        RowBox[{"-", "1.0057277175462465`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "7.242472621220264`"}], ",", 
        RowBox[{"-", "1.1461538100359598`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "6.673003191991954`"}], ",", 
        RowBox[{"-", "0.5452957101714252`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5.522399774382634`"}], ",", "0.6480560347558789`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.825917880608021`"}], ",", "2.6230710087490063`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5.256161035776691`"}], ",", "0.8498068043480301`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4.652294627036067`"}], ",", "1.144439101139699`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.9834341022318904`"}], ",", "0.9719274286912918`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.5359471560616935`"}], ",", "0.4782461556739795`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.5921190882525376`"}], ",", 
        RowBox[{"-", "0.4675467073975323`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5752791630251175`"}], ",", 
        RowBox[{"-", "2.2338669251729684`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.406295221652585`"}], ",", 
        RowBox[{"-", "0.6609743715040834`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0004863675441182`"}], ",", 
        RowBox[{"-", "0.956683415150837`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.0445208815020588`"}], ",", 
        RowBox[{"-", "1.300396762748373`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.8358370941253903`"}], ",", 
        RowBox[{"-", "0.9744741014315705`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5435982472393175`"}], ",", 
        RowBox[{"-", "1.036072910861664`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.9472571708409028`"}], ",", 
        RowBox[{"-", "0.9852344246107034`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.2623803026359894`"}], ",", 
        RowBox[{"-", "0.9955532546559022`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7322536652849622`"}], ",", 
        RowBox[{"-", "0.7982055440813979`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.3486679093858323`"}], ",", 
        RowBox[{"-", "0.3917078928157897`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.44326315084124973`", ",", "0.3996231442730897`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.9999999999999998`", ",", "0.931821631913264`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"0.9999999999999998`", ",", "0.931821631913264`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"0.6064025413677326`", ",", "0.5740182310810924`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.9999999999999998`", ",", "0.893335549173496`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"0.7458232146076152`", ",", "0.6831954739780854`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.9999999999999999`", ",", "0.8652770722695711`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "0.8414709848078965`"}], "}"}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{514, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325772030]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196207697],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1PFEEQbWZmdwERAVlFEOHCgRtkvSIaAyYghhCNolwWNIIJYlauxisx
GhOj4UMPYNR40oNEE08mJkYPxqtn/8jYPd2z1fOmdmeWgLjJzmxVV716XVXd
07MTxeX5G4vF5YW5Yu+5UvHO/MLc3d7RpZJUuXVCiG35LXUI+duXv4Lvtu/L
e/y6rq6usgg+oqOK9om8elIp3EAMPo78ZqSojFsD9arlqyyygKWt1uTV2eEo
svOMdVswusn6VNbur+eqyR0/0w3QuqxVWBePsaa61J7TdHzSzmW/sivc169+
DQ+tP3r4tQIzbXX50htpNXL2RQWrAmAVTdYzkYgFwJq1sISxroT94/ufpdsf
Pn38LWYMNtY7fVWo7ul6KMiBR9pKTO0u2ruVMwC5XqxiRblejCAPMDm1MZtZ
zMeAyVsNAtY1iFXNi7CvmzpFO2gQsC4m8OZ7og+8ppWc0fLCzfdG6yhtrsxI
SuThhAjWTp+uH/tgnjq2lk8PbRitjl2ep5TIwwEE7EUv0uE9MFcXMqjja/nZ
029GmwUrB2QuZnyuPcC0BFycGlAodoDi2XWJr7mcyYFjtJ3mftzcT0CkNmCm
mKgF3wyxG1iG9T7uDzizIzGLzpimm+XE11mECDEueP5wE7m1mLk6MctDTO94
5Y3aMhR5C0PdD4d5s5hgdY9FKpacw6PGvgXyEvfsgky1wjwaAbljh1XNAW5T
hQxS/yhM19TaKTOjuSAz7Ev++ZSWKcWJM+0Cj3CltMIMcjHPdsCOnntyRgq1
jYB30Oi7rbvNI1y5efDjM8E/MfOQxZUIwzzwX6mCQfF5K7Uw3kllHdXFssFd
M2kXrXX8f8fb63hOqqy3g9yUIKN9Eota8Xf7rK9XBnX7gcDqFmgLBlmzp+63
rUlb4GKYU8P9e58NZoPlSysFfTOArb3Ggd+Ub72RZctoZYOs5UVYUxCrHsZt
L2LIe9G49poEhhOGoa7nzNW3Un9+bMs8gCch8qivd37sFpVvV9por3qIMQJM
WmD8JFv7KLpwzwTnyuGhNWFHIW5XQOZQlajRXm79HB/bfLDyJYJGHC8AxxyM
J3HWXT0NnE7V4EWxOC9aT+tG4t/mdvu9bbc91dtm+M9GdE722Sf9W3Hc6jlo
Hd9+s+BGeZbR8wLPyK7Fv87ksh/t2P4Ikh6lTuyvgkGdx1vx8UXdX9gQvSs=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28007327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299042680],

Cell[TextData[{
 "Evaluations for computing a numerical integral with ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->688285949],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"res", ",", "data"}], "}"}], "=", 
   RowBox[{"Reap", "[", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->704433178],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->30137113],

Cell[BoxData["0.3926990816987338`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171274624]
}, Open  ]],

Cell["\<\
Show a plot of the evaluation position versus evaluation number:\
\>", "ExampleText",
 CellID->310858019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63704193],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlnlwjWcUxi9J2zAokT86pqNXRGgaaitKyEFIkEQWJLnZvrsvodExqjo1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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 223.}, {0., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->123006916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228896861],

Cell[TextData[{
 "Evaluations for solving a differential equation with ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " with a extrapolation method:"
}], "ExampleText",
 CellID->114593581],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sol", ",", " ", "evals"}], "}"}], " ", "=", " ", 
   RowBox[{"Reap", "[", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
      ",", "x", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}]}], "}"}], "]"}]}], ",", " ", 
      RowBox[{"Method", "\[Rule]", "\"\<Extrapolation\>\""}]}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30324854],

Cell["\<\
A plot shows that with this method, not all evaluations are on the solution \
curve:\
\>", "ExampleText",
 CellID->92410296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"First", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}]}], "}"}], " ", "/.", " ", 
        "sol"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"evals", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"evals", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108046448],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138541913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14500021],

Cell["Count evaluations for doing a surface plot:", "ExampleText",
 CellID->40741099],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], "-", 
    RowBox[{"Sin", "[", 
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"3", " ", "y"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51728731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", " ", "=", " ", "0"}], "}"}], ",", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"c", "++"}]}], ",", " ", 
     RowBox[{"PlotLabel", "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"ToString", "[", "c", "]"}], "<>", 
       "\"\< evaluations\>\""}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->173494189],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125783555]
}, Open  ]],

Cell["\<\
When the function is evaluated, it takes fewer evaluations since symbolic \
derivatives are used:\
\>", "ExampleText",
 CellID->107009356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", " ", "=", " ", "0"}], "}"}], ",", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"c", "++"}]}], ",", " ", 
     RowBox[{"PlotLabel", "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"ToString", "[", "c", "]"}], "<>", 
       "\"\< evaluations\>\""}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->254565539],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->51462211]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->347948011],

Cell["Evaluate any expression:", "ExampleText",
 CellID->127415106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"1", "/", 
      RowBox[{"x", "^", "2"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "\[LessEqual]", "0"}], ",", 
       RowBox[{"Throw", "[", "\"\<Negative x\>\"", "]"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204276892],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.690603336283558`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.9254789289793738`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->776224274]
}, Open  ]],

Cell["With a different starting value, the computation is stopped:", \
"ExampleText",
 CellID->209132607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"1", "/", 
      RowBox[{"x", "^", "2"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "10"}], "}"}], ",", " ", 
    RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "\[LessEqual]", "0"}], ",", 
       RowBox[{"Throw", "[", "\"\<Negative x\>\"", "]"}]}], "]"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36664936],

Cell[BoxData["\<\"Negative x\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75822304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556485090],

Cell["\<\
Distinguish between function and derivative evaluations in doing a numerical \
minimization:\
\>", "ExampleText",
 CellID->658781739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sol", ",", " ", "evaldata"}], "}"}], " ", "=", " ", 
   RowBox[{"Reap", "[", 
    RowBox[{
     RowBox[{"FindMinimum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
        RowBox[{"100", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "-", 
            RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", "0"}], "]"}]}], ",", 
       RowBox[{"Gradient", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Symbolic\>\"", ",", 
          RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
           RowBox[{"Sow", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "]"}]}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Method", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Newton\>\"", ",", 
          RowBox[{"\"\<Hessian\>\"", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<Symbolic\>\"", ",", 
             RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
              RowBox[{"Sow", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "]"}]}]}], 
            "}"}]}]}], "}"}]}]}], "]"}], ",", "_", ",", "Rule"}], "]"}]}], 
  ";", "sol"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315075895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.2449211160519093`*^-30", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.9999999999999999`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.9999999999999999`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{219, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241305074]
}, Open  ]],

Cell["\<\
Show function, gradient, and Hessian evaluations in blue, yellow and red, \
respectively:\
\>", "ExampleText",
 CellID->118489135],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"colors", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"Blue", ",", " ", "Yellow", ",", "Red"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sizes", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
     RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
     RowBox[{"PointSize", "[", "0.05", "]"}]}], "}"}]}], ";", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
     RowBox[{"100", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", 
         RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"colors", "[", 
          RowBox[{"[", 
           RowBox[{"i", "+", "1"}], "]"}], "]"}], ",", 
         RowBox[{"sizes", "[", 
          RowBox[{"[", 
           RowBox[{"i", "+", "1"}], "]"}], "]"}], ",", 
         RowBox[{"Map", "[", 
          RowBox[{"Point", ",", 
           RowBox[{"i", " ", "/.", " ", "evaldata"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}]}]}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->351378906],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEfXVYlc/ztqJgd6HYCXa3roHdmNid2N3d3WJ3B3ahI6iICkoJgsShzuE0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   "], {{{}, 
     {RGBColor[0.3371380401045714, 0.13342521994899653`, 0.5908686165537552], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHnclmPax6/7up/9vp+n+yFjH1tlG0KKMRSyLyGhsdQUZSki1DTRvlJK
+9OeZJ1h7AzzDorShvEibShahJQolN7f9zl+z8f7x/W5jvu8zuu8zuU4j+V3
HOd9SMdurW9LkyRZV5IkWd1XZJKkp65Jok/SfZXuV+haLbqlrpWim+i+QvfL
dZ2nl892vf8V/YGu1aK3qayFrs9FL1DZuZko/0z3i3V9Jnql6ywXvUr3M9xu
U3+nja5D1Kli/Z4n+p2iJLlG18Eqm1meJCNU/qvKn1b794neJfqPouvrGqbf
E3JJ0q2QJFdTX9dp/m7/iiTpp+tm0acWxW/oX4uT5B7RA1Q2vSLKj8vGfYDp
PrrfWxFj36XvbFabY7nKkuR4j4X+L/O89VedZvp9legTMzGnlD+l8n/oGq7f
5yVR51zdWYTdKh+n36+kUf9K5kLjbcZ3df+bruNEN1A/F5s+jm+rD01FH6Hy
e9PoB9/6u+hqXUP0e2+1/zsWWvRSvbuoPPp9hp4fqGua6LN0P1jXLNGHqW65
rhmi39Q9r/IJer2X3jtSZR+L7lwR83azvrtWzz/XVZEJPvnY6zhaz4Z7Db7R
dbLqPKHyMeK7z+CbJMZG//8sur7q7qnrUdEL01ivv4reIXqVrqFqY6TX/O+s
o8q+1e/74SG1s1zXWL3fzzwyTdf3qrOXrj4qu0z9War7DpW/pXoH6fqrfm/T
8/d1/aTyTmnsh5/ZC6L30HWPfi9Q3b2y0Ye/6fpFzyfrmsK4df1FZV/r/oXu
7XRtEr1Y11Wid5v/N1Bf6/W0xj9O14y81le8Olb9+tF7ba3q/JLGfMEnt+va
ylzq2ii6m64togdpbgbqula/H1b9dmmMZYXuy3V9rzpfua/b6Kv2xd36VjuN
YbWer9S1W+WzNWcTVSebCT7va77aW8/HZIJnWFP4n3WtqYh61PlRe2eL+t5G
13uq/7yez0mCP2lnkXmtj/fOz8xxGnP3Kf3V1VPXCPhH7V2i6yHRVbpuFf2E
7psyMf+Vorvo/kMSc8IajtL1nMqf1TVeZTndO3q+vs7Emv8o+gfLmTW8ozpr
4AVd9dKYz+1J8Az36UnwYzPvqWXe220sG0/03nxD906qc7Tuz6idA7x/s5rf
1PKLPUKdk1X/ePNJX9Gv69lpKj9K92G6D62I39DNdZ2kOvuVBU3dF/XeXbqm
Z0JOdXabp6vs9+xNlS/SNw/Nhlw6RGWTdC/TdaTKjtBVpmuh3u1imdZSdbbq
+UxdLyDjsrG3t2Ti3ZRy1fkuE+0vEP/MqpbMVb1VWtOVuiaI3i+NPQn//FP0
vmnsx3PF2+/lQ149r3pn0w+P+8aiGPsM1T1Tv28SvVO89FpRPGtZEeUjNMbT
yuI3NPezdD2YjectTR+g62E9H69rrujZarcH6yt6SSb2AmNHniP7D2dtK2Is
s7wu7KnmZdE+3/xI13WiP9T97CT6fk4Se4B5Otu645eikIFzNR/PeQ67ap9N
q1J/tMdnmQeos7/aalERa9tI93a6rkb/lgWNLG9YEd+9IIn1b2F+YN1u8drR
Xme3eXw2ynshVzWOQbrOsc5D7nZIQj7kLRMO031+JuqMKwsddqro81X+cyb0
+oVqc2cm9PenZTFXq3U/Ep5FDuj5hrKg1+s+RO8Otr4fqPsA2wfsnRM8V8gP
5AhyAB10Evyu/rczfbx14YmeZ8pOdp2P3Q57sK/lD3KF59SjDfTMqR7vCtsr
1Ec3H+/vokPRYciuj9THD3WtQzaqrEbXA2rj05IYJ2OkP0dbV/8+G/phju2i
M3XdkERfj3LfW6UhZ64XnVP970U/nom166rrHI1ldEX8hn6qNMpr96VlHHxe
qnfXeL+v97yjF7G3+C76vR+yJA2dca7u260/Ps3E+p6lq73niPlhHlp4frBP
zrIcY66ae34uTKNOR9H3iO7t8WCXne75xGY73WPElmvu+nfpPsR78DK9t0C/
vxS9lrat13Ka2zM1nmkab1vJkzMK8fuLSs2lZMUF6E3tqfOKgp//ksZeZE5a
lMX+vFl1Buv3nboP0n0PzUt1NuxX9i51kAl1Mh0b4Bp4UG12S2L+R3kvoXcp
X6/y1rp31Tw9KLpY3+2gd7qLXqJ+Ts8HbxxTHHXGiH5Dda6znqLsVpefZblE
v7tofLfo6lkWduzmsrBlsVWxWXeip4qi7W6WP6d5jDs8b/ThRtsh2LfHqg+X
FoU9sF3z9ie1P16/F9bTN3QtFE/dVxayBpn7oWXKUZbByB5k2UzLjz8mIWOa
Wy49pTa6arzDS0OW3KC6d7kObSKL1mVifvqL/jO2NnYFdk1p8DIydrXWurfK
HvO6s+ZTsV3V57b5kHvY6eNzYasfbtmMTb5I5UsKIRexDxtaHt6o9wZVBX/s
tO2HD/Dvovg+upH5vs1zTn8yZdEn1uc2r9F7ev7fQsg21vT6TKx7viLkAHzI
fbLpQfCR6HHmO+ixSawb9Vi7y7Nhe/Xwu5Ncjt0HjTzmPd6nnXcy8V3mcB/7
BNjGJ6lfrTUnJ5WFvOqt6yzrHHQ0srS/+pwrjt/YhLdlwhbCzoTX+e7xaud8
tXO82tlUHvoJ2bfJvgRt4kP8zfJwUkU8R9ZiV9JOnyRsqY7uZ43tq36i68sW
2FPXEXpnjdblStHXi+5YHvdxmvMO/g3NGmObY5dju/V1n0dqHK9mQ36PEf1G
Nvbv7WqzQ3Xsy62i/1Id67e8EM8oZy+wfqzp/SXBP+j0iWXxbWzjFqrfvBDy
g/fvMA8gF5GP6JfBFVGffqIz6Qtycq2+c5W+OycbdjP2DnbOBvHgRl3b4XHx
898qo+9VKvtW7xREX6D3luVjzK1Er8zH+4v1bJf4smFRrA02BHwLD3PHrkMv
j9fVOom1xa5lHV4sj2eUM2cTrLuXqO1ftW8/L4prL+9rfI3p9jeWiRdGFOJ3
w7J4hg/SvxAyDl7ubd5o4Dbo4/lq5y3VmV8Im4g+oE+wG5bqm3317V0aw0rR
K3QtK40+8Rydg+7cy+28p+dfqv5B+m5T2/kjzV+MEb4aoO8M1PVgWchG7g94
rOM8XnhkclnYjR+p78NVv0a/XyqPdWT9G6u90jR8sWa6b8iErOYZfLFZ39qs
8vWZ0L2fiF6G36Xyd3XvbvoE3b/MhH/3k+2jL9i/Kr8jDbqR7kka/suRumfT
8C/aad2v09WlPGQm4/zK+gXZvimJPk9Sn+5NYkyTPK6b3Ff6SVmN60zVu3fr
+lr0Bxr70ELwykr7yLstW2h7gK4J+Eb2Q/dMw6fFn0IHnWydgpzF9sTf2a01
+ln7YYfWsVk27A9sj33Lg1/h0Z8trx5PwsaFn/AxE71zbVHgNuA16Dp8wq3W
fzxbjdwthC78H/V/gei+qnuO5um86sA88FNrcrHnGoi39isOvwC7GB5EF8A/
5da/o+Cn4vDv77FtTD9fBecpCp2Vqr2SQuy9H1wXPbpc/Hihvru1KOYDv5s5
wc7Dr8WvoB71kVuTi0L2oC+22vdljPhw/e2/NMTHtf3c1HY9+AY2fiP/7qbv
fqL+bBQ9Rt9/ul7Ygw+KzuVCd2FfY2djiw5MQhdj88wxnjE1CR2GbY4+xU7n
NzLwtDRwKnz4bsxtLvpHe6xp02zwc2vbsZRv9LfOV9+WFoIf+tqGYP8y/w3t
E1WUxFzUMF7VOVDX3WrrmGz0Bz0OdsQzdOJaf+tOlbfV/L+dDSyGOVnh/v9q
mw0f/Az1+Vb1Y5vq/lt9/7Iq+rKoKGy94bYPe2WC95iPr23v4dNvtH7h+Veu
c1EmMMrPRVdlAzPBP0QnL7ZePjMNHAy/+Iri8J0fyoSfDTb2chKYCm1OEf2I
MQpwiRtMT7Xcpg/4lfe6b2AR8BY8BgbSJhv2K324JROyiP2+JBu++QzLJsqR
k/+xLEJOvmGZ9oDoE01/l4Rdts5ypqNpdDeYAO29Inqe6EPtXzzi8f1L5V1V
dpDxhOeNz0B3sV8PxvJweWBGNfRZZfungTmANUxyO2ACYEpPJqFPNtn2GKU1
HV0duhqcYaLrP2u8gr4N9/xgCy00VkX7mWxgEfTh7DR8q8d0vc8c06ckcEj8
rf9NQjdTPjgTWBbYzIvsX8tn5qckG/gn89DLdV5SeVE2cBxw0VuN7Uzzd7b6
W3M9Luwo5pX1KnWf6BtY6FFp8D2+Dxg4/He7bcLPTA9LA/uCJy9NA5vC5r/Y
5Xck4ZPha+Fn4Xvhg+G3jXT9NUn4aZTjl+EPrva+7mMaH25ZJvxDfL+G3tvs
a3yuUfZJ8U1H2z8C48L/xbdt7j6g02dUhE5Ht+P/4uef7f3FuLB1L0jjW52T
2HM864DMLA69jt/VpyTWj/kc7LVkD07XvL6XCRu7ueUYeq2F8aiMeW+z1/QU
+wL4U8d5j2xkjVwOH8Jr8By41u3mnw89t9vct0muU7cXvjNPzvT6LhB9RRoY
LzherV+bCZnGWJd5vNjE3xSFz4POQM4h04iVUIe4wES3s8G2xCeZ8LP+nQb+
PDEJrIbyTkn4CsszoXfuMI1+b5CN+sRunpG87F0deu9VvftyGlgAa9HANHIC
edGVPZsGjdxAlzZJQw7tYTthp8ubWc/ybjPXZ46Z6/aZqNPUtlyVaeqDq4F7
Yjulpvv6Xewq1gjZ1sTvFnk/vpUE5gldYlmE/EX2nuH9SDlxE/Y2GDV7l3L4
gT1xeBr7iO+e4D7gUx+Rxn7c4TqXwk9p2HCXmD7OfcN+bOzxbq/bz6KPtb1H
neuIraQRs0Dn7u0+XJlGW+zf4Wlg0OzT+/0uex8fa7d5gD6mbrOR34UmjvBr
JnCqi10f/w68F9lb7HWkn9i68NQxnucfPV7GWJSGbXqZeZaxoI+zLkcegtn8
QfSVuu9i76eB4XR2eQ/PJ+1f5zU91v1MTFP+i99tY/m5v+eEPYhuwIciFobf
y15+wDKZucJHAlumDr4TMR3sgtnGnNE7YIRzMyF7OnhsrDV1iQM9kIlY4XLT
641B/ycTPjN35BXtrXKbnSzv8L/AsrAHBnvfveO9ls9G7PPtTMTu5lk2Ik8p
A0+rzMbcLXA/57m8dRpzSDn2xqJM2HLs5YW6xojubnqg6UWWgdjy9KF/EvGA
ozK/4Y5vuA9gOq+7nPlv6LVjz7P3wXt3uhy7lNgBuh6dhYw5zHXQZZQj94it
oPeRmV28XujlP7kceqTXFBl7lvcpbTZ3TIM+Jd5f8AlyiW8h0+7xvujofUSc
EnsVfcL61uGc8DF6rY3HgoxFz2LDvJ1EvBL7BhuEwDb223zL80M8lpYup2/g
q7xb4XW+02sNXxyR+Q2vnuSY1+NpyETsvT+aRjbelIZPhb33pu6FNOQ29h6x
JTDIeeYD1ogYIjFZYotTZF9P1vVUWcQieRd8GTyLeCUxzj6maZ9YZ31/92TT
zD/2Lbgx9ie+9/4lgQ2BMzS0H/9oGnIZ+xO+RW9f5TleZh0OFrTYvv9JHhff
6uaxYGcSh0XWoYvB45kb5uq/adgRbZPwD8DswBvHpcFzV2RCVxZ7n3YwDV9j
V2BTgD9j22DXgDPX2hJJ6GVsGGLbYN9fpqFD2XONHJfA58COAr9upfLemtcX
c4GD/iuNmDr7E3zzda8xtlMry0ZsEWQxOPC++BhpyNufvTfw8TekwXvwIHFp
4tP4OJepfononklg+V2M5x9nGY5+xAenztfW+5dbTiKD0SvI4R/S4I1HVGcf
tTk/jdwJfN83vOeRc8wdsnq2dH136fopRYENIRvAhOEncAQwkqvS8EPwQa5O
Q7fjX6Dz0RnYANhdYPb4ueBW04vC9uqUCX/z7iTeQxeiB9H/5aaXpIHTD0tC
tqEn0B2X2u6hP+Cu4OP4zODl7A34EPyP/YGP1s7tgzfiT3XU1duy8A7Lw+me
wxtZR3zHNPAZ7KDrLZ+Rl90tV9sZqyNP4OY0dA9y7FqPHf34ZBr5JOy1U8zz
7L/OafhptT5aUWAB+PgNSyM+hI+MrQoujL16tXFNbLzXzdfYhH8W3TYNu66x
v8u8gdH/VBKxc3D4GY4jN8pGnIl4JnYd+RDIimLrenyQJp5/7KUWlsn4RPhw
yD9s1x8ti4ZYliPTkXvk1YDLvKA6+2cDMyJu39z7Gtn7q+7YU+D2+ER3pmFr
vZ0GhnGTrsOzke9BDgdyFFmMLH0wDUyB/bKHePP3leL14hgf4wSTHOg6+Cbw
/XbTR1jOY1/11Xt9dI0vjpjWdpffz76uCjwTuTbDbTJ30Mg18nbI42GPsnfZ
w+iaAZYfxNDw494377M/tpoPiXc1twxCXu3wd+n7LMdLWjk2emMSZTO9dg0t
69C5nVyfcuygX1yOvUmbyMCC5qdGe7hUYxmZD4wGfAa9Ocy6kwtcCUxprOqM
zwdePdR1wLVOtfxEThIPRIbi642yH4dPR7yUvI06nQYN5o9PPsn0LY6LsZ+J
ic+0fCAPoqllOnIevcE8j03DLsUmxKbZ5TG2MY3cmOa1IGaNPkA/oCeIWU9z
+VzrxyusK9FP2Es17it9PsF6Cr3AuvIueUHs+9GWfYusx8daJiA38JWQo/Au
64WegH/hY3h1dBo8ONg6BXm7Lg2+wRYCTzvcOuYhrc/4qsAuXve+HmC+ZU3R
I+TkEEsYZ9xxqNcI+3+odRP8wPwwT9jLqXXBdI+L8fUrDZ+ctTvbPMyeQi8t
tK4ZYr7CFgLz5rvg2twHmQbrqLEOQm9s8lxNSkPf4Xds9Dqio9dIZz5eFXkM
xMLmO46FHLvBcnihZSz2KrbTXZaBL1vHopcL2dAJ8FJjjeMAxyyR2eiMoUnE
mOgnOrfcugnZSE7ITdZTjIF66IVvVd7D8v++NOyDz61Hdlj23m1dRhx6H63T
kqLACz+2bkL/drKOQkfga4O9gSfekY/YEnpqSxr5EuCWj6VhY2FfXeP+0Od7
rb/AG7Gv5lhnEXcEE7+3JPwqdDb6GsyeucLO7Og4BXh+hzRwTGLc9AVMkjwN
8qDQl+hK4jTUAcPk3sF9wqa73rrgeutNaDBDaPrc0XXoW/s02sdGRT+0N93O
NPlj4JfgmMQIyOdBd6I3sUOxd7FFyS0kTw7dhB+Ab4AtWum+MRb0Le/iF4DT
gNeA46Fjb3A74Bad3Af0G3XwE/dxm+g1MBiwmAnWZdCvuP6t1onkkIFVvux1
Yd6wV19wOT5md/MPNgN6AHsSmYMMII6DvgYTAhsCQ6Qu78BL5Ku8q+ujJHwI
fAyw4LZ+F/0OJozdgM3Q1O0jh8He+lj3oFvQMR2TyFtZ6jzMAzwWxn6J9eCl
bqOP20EPo4/BJ89wO+gp5D1yH/8IXwqfqu75Pf7WM34XPT7b42IPkldAn/Fr
9vT6Yv+Qv4aOR7+zp8D22VcH2jaBxt6ozSvLhC1AfXAb7BfsGPJFeX6k6wwU
D7fPRtmBrkNby22/I5PJGSBPlXjT0NLI6yj4qrZMQc7ghyNrXkvD30b/sJer
jKUjXylHB5XX9SEbeHs9t0MOAe0io9j/tE9ModqY/DDvR2iek1PJu+zNo3X/
g/UZuuVo9x8dd7TLsbXIxwOfoQ+HeR7wR6GxyRa6DvYYdhnvEDs71DTlYKEz
jIfid97o9SIfEBwf7LqvfTf0OHuqge3Gzq6PLUvs7WC3f4DtzDle04ZeL+I6
RxkTPto6m3E97HeoX9dX7OG5fhcemZeNfFraaeQ1hj7I35pg3uA3fm5927iT
PBb4G19+mvcp+w55ebdpeLyf+RwcDB8K/YV8BTfHpmLfUKel7QjynLAlyDX9
h+UAPtbfLbuINVBOHJP7U66D30oOE/ZMa9PYOdz5XYeTtXY5e7aV+9Ymjb6B
73HnN/qdPUmdNUnIPPqAfY6PCNYP9gXeDw0OCYbJuMDrGNclbp82oJEP7PeL
vMf3cf8ZE7kxT1v2gs9A4+Ogo9BV6BTkPL5Wb+sKaPQFPAbecY91EbmD8Pxj
Lof3elkvQpP3MtvyhLIn/G6Vv0X7lD3m9sHb8dPR3cih2ZYxYB1z3Dfk4TOW
V71Mg+8SAyJWhPxHt6CfyDXNu5/or31djs4C/3nW9NY02p/qsT/h/uD/4QfW
5Yo/6blKvHasI3IeGwj7BzsIGpmPXUbeJP4F+D84O3gb/goxGPwa8ELqYMet
dnlLv3ee32W84NroMvAzsDn8tQNdzjyAPdA+9t6//C6+DDgQeNwT1l/Exj60
niKWOd+64y63M880ew27iP012Pzf03uBWEdL9wEMH58Zfxkf/Zo07DHap85M
9xnsD514sGneLfO7Xc1LyOeJthn+5LWD38DUkFFg18RX2nlfgKFju+KjgWX0
S6LNK9yfrOuwd8jDpw5YxwCvGetFf692n7EnobEtr/ZYsDvR4dTHBiBeBBZw
n/mU/YXd3tJ6dqXn/FT3n/rQO61DTzGNzUM8AJ1OG7TVMQl7Br8d24Y6+N5j
bNuw7tg5xBBOczl+OXV2e4/zbsZ8/Zx5m3g+uRrE9DnHgG+PX8/+IpeFvbnU
NPYPdXiOPN/f74A7Iffx8fDvONMD3dY0sSt8P/wk6NXWfeTQ4lv95HbrsBLa
f8Eybb3XCB9oveeTuC5nacZ6HnZ5jMiqnZ7/2thONvY+mNgH7s9ul4NTgFfU
/vYeAac7x/ODvGCeeU49bKdx/v2Sx/qBx3WCMSX8SjBAxoWviH1GrjH4JDYA
/gu2AblCC12fuh95HjjzgZ+Gj4bP8bH3F7FmcnqxkTj3gm1FnDq1nTXPZZ+7
fI1p6nMehJwbbMvG2Wifvl2Sje/xLfzcBV4XxoKPvcRrvtQ8QF73AveTNngX
nBNbZr7nlufzXYdvHZuNcbJHiFMi9/CPob/w2N92f+gv/QYL+sl9ftx7ijVF
H5GL9FUa+Uj4euRg4a/U5i+kYbfTr03uG74p9XuY3uhyZAXnbTa4fJPbZB2o
gz8LhkGbyB/8HXAx+BQbALwV/bvN5UOsf9ATva0T0Ad1GDw0eoEcT/xDfEP8
aPpQe97HOgb9Qnvb0t/2xDbvL7673fQ29wE67zbRs7U5IGnIKHLS8HvxeXuY
Zv+W254lHk2uSLnpI01jZ4LLEefAPmRNSv4fTTlrNMb7BSyilr/SsB++s65F
z2K/prYbm9gv4HdtDot58kC3/5brZE2v8ng5M0XM95s0ZDiYBDSynTo7vPd5
D6xzmuXeDr9L+0UuL3b79It7kb9VGwt1OX2C/yabJ9d6T5GTv9b8SW7zOssK
YovktYCdEqMGkyFe/JDKZjmGCLbH/mFfzHF94obkMYH/gj+AT7Mne3rtLjNd
Ypp1nOk2waWJT850fHOEn1HOc75N3infBXOEn9mb9IH43THem+w7YspgIpeY
/1vV9TMbODhtrnTeDpj4RI+Z8eKPtTc/MefE4dA7xOKgH/V+ZFzsL+w1bD74
f4XpoZY/+9j3qXsfmdw2G+fmHrUeoQ4yqr7LscPBodFDj1hPge8jV9Fp9e0j
IK/29Xg/NL3Ocpj67At8oEX20/Ehf+fv0g9oMG3WjfUj7+lJ729sP3w7/MMl
5r22fpf39jZNfymHJ8nFusp8wtiRochB1oS1udly9WiX7+H2h3mMJ1g+w8NN
sr/53E3Mz+BT4GwDrXdWWIbTT37TDntrlWUIbS13HcpWunyL30W2wPvsAfAN
bMWc5QC6d7X34Ht+F92NjYmvjY2KDmCu4WfmG/qvtgeIyaFD8begwQDREewv
9MWS8lgb1gV7E50IFofNiW9Wh99AY9sg5z6xrFtmuqf5ZLX7hoyH19d5Xep7
jcAr5zvffoFpcvjhn8bWZWDd6EfwZ86E9ffZg4VeP9YO7LCpeY+yxuY95pl3
wQ0257WHqiTXiwMLBItEDvD8BPPwNH8LmpyxeeWBr9J2M7df3zQ8i8+If4vf
gd2Ij4e9xDgYD2eaezmfnzMBnMnYz2c95rmcnDRytMnVJld8knOj6/LiXzL2
OM753ORqj8hpX1VFO+TYggWQH8a6kH8Dtga//8cynNze7cVh63XXPFxcHb85
D0c+OHEZ8mM5I0oMjbM25H4Ra+1VqXWrDLwFbPgH48Pke26ojJzPpUVxZ57I
Md9cGe2Cq+90PjB2AbofuUS8qF51xIy66H5IZeRvEiO9KhdxUvYU2C/2GPmB
xH/ANlqTd1wd5wHInyd2TnyJeAg4PGt9WS7OKcFL7TkfUy+ekftfU4j8/7d1
f60y8pP7qb31ucjTB8Ph7AfxwpWlgYlzBoFzXcQTWXewfPQw/t0Y6+S7LX/A
xZBd4OxgIuBv5JT/YGx9i/qzql7QrOHIXKzjMNFDqyLPju+s9reYO+LKdWcw
sb/AbImncJ6CmAr5zuRUk7tG/JZy4in0/Vj3n3tjr90xLudd4sj/LIlYMn4W
fhf+F/14piTmYW/1cXs+vgG+TUyPc09DNG9T83F2fIzq9KmOd4g3gb+gB5dX
xTPKFxfiTBH5w5xj7e9zMexJYgDg/+RDkBdBfseemqc96kUs92N9p6Iq9Pur
undXmy+q3uXVEW8j1oY8YT+Sc1Wnp9EXxOSZQ/KFsPuw/7Ab8V/AXLB1iRWR
x41sORieV5tpceDf+IrgJOsrQ47Q30Xq16f52EOjiiI2yHkUzogsLo3y+aqz
gLNe+r1Y9yX14hn2FDYWNhV7jufEl8mtwu8CR2qj8e2ojHlmP5DDTf4268QZ
Lc5ndWQfVEfcHvypyO+yToeWBD/Af+wd+PFWtVlZFfgktjZ2PPb24eWxJzjL
82A+zgOTW9LR/Eac4kZ9J5OL/Czy9hknMdZzqyMHnfxzzotMqY4zI2CM2Mrg
PLu8Ftg28ArniDi3s0L1c1VhmzHXvAdWzdjQp8QHyZG8ORd5kvDXS1XBS8hY
4l7s8akqm1IV/1VAHil4E/7+Eyq7SO/OLgle+7g0+AssGlzwSvNFA/MG+DZ5
KtgEyCbWFRnOOQdiqsgK5oh8DeJe2O/Y9ODDTfSdb3Ihz6vI9cjH+9i65P/h
O4PVUB/7nxwksEV8Gc40fJIPGXx7Ic4jkU+HDL6yPHJwexTibBI5d+19rgd9
0da2IHYO5xGJOcEzYF/Ez5Cj862LPrO9Osd2JvFixsbaPWw7CzuTc1Q9C1EP
fdPOsQ/O7XG2hPMaWzTW6nqRX0HMldjrzdbvC2wr4seRLwUPgCVD42edorZn
5eMsJOXzXIczlfAic7zU9jo6mlgoMX4wn1V6t0c+dBr2Bbg8NsYV6s8dhXgH
LJz1Ag+HB9+0DYw9DA4OhgnWBV4G/3MW5vuywN2/UBtfFuI3ZzqQ+2A2YOe0
AzYO5s+a4r9AL/T68q15rkP9uf4uvuQC26Kb1M9JheAhbP+PLCfZD+gfcgQ4
g3NheZzDYR+3tWznPOVgn6l8pxBnvdD/YEeMCex9nObmjFzYb+DznEHCl2no
M2TEJYmNj3JuP3qXeA++BRgbuCE4GzGye12f/Is+1gX4FvhI6PGhWv8h9SIG
jvx+yXFc/huggfX+au8pZH4D9ev0XGAq+NPbzP8HuR/sfXiCPBTituSkVFfH
7y84i1YZPDpH39wnF7no8Ps466NbC3Gevy6mO979b47cyIedAqYB1gNGQX9b
lUc5+oa8U/LNkBfop9rYemnIDn6vy4WtwDohQzpZ79ee3y2P/AFkSmfbLbzP
e9h+r1TG2T9slhZq4/Tq+DZrNTof64Xf+YnXC3wJeYYvn+RCviBb+C+FBy1/
sBUn+gwauUbgEawdtgbnrLAL6v5DgXNGe6qNU3JhT7Lmox3nK1VZs1zIky/t
L+Ervat5Xm89CAZc33KV9Z9uvwCsY5r7jM05xe9OdZ1aPzqNPBXw3m7+vcVj
wabBngFHqcWYktBN1AFfqnCb1J9ufua7U/3dIfZTpppebx0KhjnK9Br7PuSO
YLNhv5GTgW8OLk3uRXs/H+I6YKHkKWLPg7tg54E/EIMmHwU8jbgJsX/iIOf6
ffxlcqaoQ75KjdsnrwC9X2ObHBsTWxMdN8M0+4u8o9p4Uibs0w/yoXc6ui3a
Ie4E5g6GQL4ncXTmCh+z2rqAM4HYxvDbf/Ohv9Hd2Fbrze+1Z9TS4GHWdIL3
NXgduY/EwrDZx1pGYdONMw3WAU3cbZDnh3bwiXgXrI/6vMteY0+M99qRmwEe
h50JJjfJ9ce7D9TBXxjvd/FN+Qb+KbF58sOI1+C/4sfiz4I7cQ4B3Owu08RQ
iEGTx4xfjH9EngG4faX3MH0mJvK8y8Ekltr/xacmfkP8Gt/6ZbcDj8Ef8Ab4
G23iC7/i+sR6iJuA+YNpk+PwhvmZmC/xb+LUxFigibPgcy9xTi/6jrylAUnI
GPqJXCHuQTl6EBsHW+dJ69k3LUs7maZNsNy53rPYevSBsx7YFHVndk9yv+nz
fM8XmAD75gHvo6xpbEt4c5T3FP7ucO8R6o9yHfDn0d4jxFJqz00lEVcb4G+x
R8gvrCsb6DWlneFu/233rTYn33uPsRNXHek613kPMi5wVGJmtXnmXnfGhAxB
/nR1/3mX/UXc8H7vo/tM48tDj3A59/vc/4tc73bLhxEu/0Rycnm9sC/JywCD
JibybiH+H4Ezk4Oca4Zew9/K2eeibLzL+R8BbD7870ba+w0rQ/fPMvaI70Oe
ALqZeO675lV8H7BCfBnsOmxnbGjyvvgGNHKG+zSXb5NM+FR9XlUa/kWNy8nF
g8Z/HFCXH52NPQp2zp6dlg/fD1ue/7Q4xf9rwXuT/S4+xnR/l/NVU9z+ldIz
KwpRj/zQUwvhT07Oh91cZ3Nzx5+63PPB/PD/EE/5fyvGqe5+tgG4YxNAY8O9
4/wJ7BDO6mPbY09t9tnmF/Stf+CbkVeSizO9tMv/DeDz4y+TH04ZeX3YWwuc
g8K+xU8FCxpSFW3xDP2Pj4INgC842v0n5sn+Qb+Q24XOwPfkDD2xUnQBfXnR
7VykvnxVGX4hfWF9DrCP8prH8qzqDq2O341djzrE/Ind46vW+qhFgdsg73Ol
Yd/gb12bC59rreZ+TSHsTdp7Lh9tflYInAiMCDsKfgOf5ywRugG9AE6Ezwom
Qz18F/ClseA61XH2kv9XuLY6MAbu3/j/Fsjh5X/ByOOlDfKraYdzt+gyfHZy
e8grov/bbTdQH/79xrwEPoUMw98nJw45iB/B/6HwLuuFHdHN+pGyYW4T2w+7
ry7vcInXtAt+W72oRxl1wLXIL0isE7HL8BmwzfCB8fXB0Dhn3Mt7k9w6cux6
eT+xr+gz9tfn+bDBsLk+y4fdBbZxTS72eI19W/CMQysDI8M+BpPAJsMeww5O
bTMTYy+r25/Z8HHR76wX8ZHa82X8B0ZV8MEOzz/4D3O/vW7+c4ERsHc5w82Z
f3BF7GHsYGzZ9wvx/2LYk+Av2P3wGrw73HP+bS7yU7F/B1qmoMvgCfK5+d7/
Ac7z514=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllltsVVUQhje0pafsfc7ZB4xi0CAE1Ed5QGICBYwgKJpYAbkJiqJBBKwo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         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.42458212031371406`, 0.28546685984698955`, 0.7137818496612657], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnn4XdO9xvfP70z7nH3O2UcioUEmglDtbSVVQSkPQlRRs3vFWEOF1CyJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmUVNURxt/Y3dM9vNfd7wGCkkQFlJyjSU4SFYkalcQjIChCRNZEgiYi
iiiyRAQElE0GZJuBYRFGjUmMKIJgVPQkGmVfZEAZGAQR2VcNwSOo+X35/KPO
u3VruXXvrapb9Zr2GdD5gXOCIOhSEgRpvtfFQXA9UFYaBLOZGJkPgseAGxn3
ht4U2ihgSo4xcBHj4cAkxhcA5Yy3hUHwXCoI5oO/WwyCDVEQ7EH+7UwQtIbe
DfrjrNca+kHGywpB8BLrNcoGwXvwb4H/IPyb4F8I/3F4NqFvKfyTpQ98Kvg4
+PcwPgZsBK8HXsV4MDKPw/sE8Gf4mzC3EFo1MAjdU5l7knE5MBHeD6E/i3x7
1mwI3gCoh2wIrIc2GvwpxlOB6iQIVjF3Cnv71wuC09j+X6AlZ/Mhcw2hFeFP
w7sY/dPhj5nrB/1EGetDexh4GXwUPMuwZxzyjyL7Yta6P4C+O+c12kIfVPRZ
/DDts18HzxU530F98ATIMs4By+FfBP/f0bUIuIq7Gw1UIv8Me6zAnhnAl+j+
AnsaQWsMHEL3JOiPo2sM0L7Ee57FWgNj2zoGqGB8iLl/pqxzPHgN+NPgP0fH
WfbSETxh7frANdBPoz/HetcgPwH7vmLuHPBH4W8FfnfRvtEIvCfyvYD1GftM
FbJzgI8Z/4gz+yP8E+A/Br0Nc5WxfUi+8wL6K9nbEeS/Qv9p9vdrxjcCKzLW
UQHvAPksvCNy9t0VzP0hZx+ehP4MOuag7zHxI/tM4rseBzwR+0x0FtNz9q2Z
ic9SPnYJtrbQmbLeaM6wB/zdgTcZ/xT+YdAezTu2jrGfuaxXQL4Z8hcDr4K3
Av8r9r8DzzWhfUq+NBr6XuxZBP4Q562A/QbdE5EZnvaZKlZ+CSzJOWa2wV8J
lEOrAyZD2wq+lfFHwMKidUqX9twOvBn6bmHcAXgI/V1C72UkOmeDHwZfxPhF
YDzjG5C/CV0bpJPxDGAi4+3AUPi7sp+7sX2s+KFNAB6DthM4ivzlwI0Zx/Bs
xvOReQXe3dDPQfZJ7Ekptspse3noWNMenoZ3HrA6ZZnB8J7lfPPQurOnBdCa
ATNTPpNt0G9GZ1d0nUjb9qnA+FLvQbmoFfytcs5JL4EPh39Jme9kZsE5T7lO
e0w4r5PYczFn1Rz4Bnw9a3SG/zR4KbLlkX1Je5iG/Cl4jme95hH5G3ONGf9L
+Rb+6ejrir3L0DEKfB94LVe0Avx5nYfOC3o5/ngG2cXA6ynH3BuMj6OzlvEy
dN6Prf2BYdj7CHBe6JyoXKg7GAv/E8CwUuegPPQ65QPuYxD4g+jarjtHdgDr
T2D9NZFjtxb8Bu1d8Qd9hnRAfwX6UOxZDH1iwXequxwFnM/4yYLHr7Cnleh+
D2iBvo/Q8W/G7wJLkK8BfypxDCr2jqKvN/jn6L8U+y4DDkI7AFSknNPGQL8K
+mLw9xWT4AfAc/Bei44t6L4LfC+6P1WMMG4D7IC+FxtGwH8PPH8p9Z3PRfe8
gvc2D52/T3wmOosHgTbs5xnoc6A3IUaKjL+E3hJ9zZnbH/oOdXfKkS0j2yjb
/gH/QOhvFnxXV0DPM+6vNwT5psy9VrBPyBdWQm/L+CbtCVu7MNcB3heUo+Bt
gb7ZjKuAKaV+I+tY71b4e8J7CplD0DYhc6bUOfIz8LfATzI+oZhi71vBF6R8
RgOQnYyON9BdgY5a6APAO6bt8zcXnaOVm5UzqmLnOOU25Yh6yA8GL2c/FyJ/
t84e/GTGNUUxcY2h2qK59gN9JDqHoutS6AW95QXn+hT6PoH3Xnj25fwGtA1t
o2xrWuK38GHoR3N+EwdCexZ8I7R58HQNPafxGOa+x/hXyDyH/p8wNwTeneDH
kD0B7GL8sXwy8NwZ1n8Onuq0ZUJs2xH5bC/g/O4NHQPyfZ3ZYmjDwBdJd8qx
vb3g3KcYfz6yz8hXlLMUi/fIR7KOyUrGEfIXIV8KXg/6R5Fz1w9KfbZ6c/XW
6oxHcHYDmeuJvUOYmwHvb5DvjXwa/pbsZQFzl4C3ZD9fwns7Nl2bc803F97P
oJegK0O8rIL/beifQ9sGz2fge2PHwknw9qzXofjdW8FcO8VTYt+sQ8favO9U
d6mabiK8d4Jfl/YelWuS0HernLMOfB3668A/zjg2pwFj045R3X05OsZm7QN3
sNYe5r5Ou8bQW/Mp+Ddpvzmb0bUJuDLtmmpWwTWsale9idLVL3ItKZ1PR675
VOtNR2Y9vGuBy9O2qSLymeosJzL3t4JrUNWeisEe0Eah8xHwT+DvFnlP2ots
uAX7BjLXhXEP7KsPb4Oi347uKdcmlaHfWtUox1V/w98X/rXo6Jj4jdPb1gv5
Y6ofCs4V/cA3xL4Dnf3OnGvhOaHfXtXE+9D3CDAN+hdAVHCOVG7sCj4cW+6I
7DuDgRXwvh87N2/IOHY7hT4bxbDehofgP5LzG3EAen/lnLRzxPl6f+F/B3+M
c641RxX8tqjmXMr4VWAoeDfi5T7VQnn7Xjn76RU6xhRb38K/Efv2KZ6xbQPQ
GfpVsX1ZNWs78J/FrrWagfcMHTOKFfnEJ8hezdytGfvMbuVq8HbgZ8G/Yt1v
i367r8bmfui6D8jI17ifefIVbPygzG/yUvDx4DVlrvEaMG6YuLdRzpHubOja
WGusRvcaYFXWb5ZsaRC695BNdazVhP3PSjmHnYeuxonfystYo1r2w3M1tBbg
v9De8z471SzV7HUsPFVZv0n7oe8DqvS2qB+C1iixrh8Dh5E9N3avozuaCr01
9nTOOOZuh7dz4rNRDhFtZmTfF8+FyO+NfDe3gyfwXsBcdco5pldiH5Vv3lvm
3LJJ/UzWOUa+vUE1U9Y+fif8fRK/rXrjtVf1EOodtOfmrP998IaMN2PvKmRX
AksDn+ku6DNi16KqAZYrH8eudVWTPBD7TnWXqol2sf5a5NdmbYN866K89yIf
Ww9tXdG+JJ79kX1Qvqc9bGFcU/Tbv1n9HuNpwIrAPabe0hF6/9J+U6eF7snU
i3UGJoFvKfhtUE13EP2bi9a1BdjOuLbot/1D8IPYfgBYg/7J4LNV2yR+G7TG
Lnj/E7k22gF9SuiaXLX4YPbbNXKMK7b1xp5F1+f4/E69xZz5bejqlDhW79Kb
hnzj2L6jPY1BdnTRvaJynGrN/XnnEtWcJbEC3b2cei71wueqX824J74LvE/s
3kY171Poug8dHdLOSaqNL847F6lGnpq4BlTtdwzIqdeN3QurRyxVLxk6VlXD
tId3e+Tc2g24n/FLRffCWkO9/c7IuVM9/tHIPirf1D+JBfCuZm5ZiWNIZxNA
b1DmM7qH8WbVH6rVmbsWfcs531lpv6GqHfvGPmvVkNKlmlm1snSqFxkbu3dU
T6JeXf8A1PurZ1dtcX7i2FSNsUO+GrpWUY4tgxYmrqUmpx1r9RPnAsVcFfJx
4l5yCvTD4JPAd4F3CpybW4N3LHOOnl9wj6DeQP9sXtPbDP2WMvNob5Ni/8vR
Hucwnhu799M/k5nqh2P33vonUMF+Kov2TeUc5bIZRf9rUU67Cf3vxK7t32JP
Jaz1LfjItM9YtVLf0LWxaibl1iWRazvl2BvAr09cK8tG9Vqv5/02qufqja77
Q+v+f0+fuMdSb6UzUK9YHftfknrGEN5piX1L/2jGYet44E+lrlFkWypx7ykb
+0TuIdQ7tGON2sg+J1/rXuba/UjoWl01/E71h5FjcXvWvUGTxLWmeoQT+r8V
O9aU005Db6z6O/A/hN/C+7vEsporCe2D8j39czoFf2nou1UPqFpNNb1qedVs
hwv+R6R/Q6r584l9SL6jmlK9dxC691EPrt74wdj/RtQj1xTcc6rXVE92SPVc
4r0q5zbN+83WW70afAf7rSs6VylGzqDr69i5Rf8o9ujsYteOqqlVW22MXauo
xnq56H9m+lemO1AtWxO7llJNq15xdexaVD2jerutRedK9XizkJ2d+N+P/rHV
RK5hVLuoZ+qrWE/8L0U9knqjIbH/FapHupLxbaHvVv/Y9NbPjxxLevP1r2ZO
5F5F/2xUy+2O3SuoplMtU1vwvxbVNP8DmqQCiA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5120262005228567, 0.43750849974498257`, 0.836695082768776], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgm0ldV1x78H975377vfvff7CIPM8EhLQ7SmhYhGTRRMQiwoSddS4gOx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVdURxu/MvHXue/fdR1RQEBBNGbeUhkFAISoiIBIgWoULIDuMomgU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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5900314329820104, 0.5696785221424392, 0.9100962614859219], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnu41lWVx3/wXs57/f3eVytMRS5SgALKRRsOZWWBoXGR+xkdkQMK3nCE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlwm0VWUVxw/ce8+975177zlXbaXFKBSjzGA8nLJaCgaiaMQM8gDLhEgF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.654323065786623, 0.6729772867223464, 0.9115619126929317], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2QVWUdxw/svffcu+fcc86yNg2FOrRjaoDg0ssS0rqQE8nrUmkuCoGi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwj2UUxx/8Fve+2+8XzTCpRkbZ3a4W2q4lkp2kTYRoQyrlyh+MtqmZ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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7186146985912358, 0.7762760513022536, 0.9130275638999414], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtll1olmUYx2+b7/u6Pc/73JtUGCWk5mCmrq2DluVyuo+0g9rsYxoLN20x
nU6t/NhRBRkIRVBEB5PqRCHPMs1Nt8w8kYiwkwqCosAOLMggqWXY79//Pri5
7+e6r+/rf133s2horG/XTSGEL1k1rAPVEOqyEAY490RofLeXQljD3sHaxfko
9OaGEI4h8N1c07Zz7oV+cx7CCb7PoGMb/C9xfov9A76H4XmgZBnxH4U2UfW5
tQhhGfIPlkPYAW2U9Sq877M/Bv0U56ZoGfHfg/3u+hA2zAvhmbLttOJzH/b3
o2slNkbhPwf/y/DfX2N/FWM/spe4G+SjHd7f60LoRMcT2OqGfgBdv3I3WrLP
U9iZZF3E1iF4ZuU3d7fBO4P8VNk2e3PbnWE/zd1kJYQu5DpZPchu5/sQcnfC
U2TOtfJ8gfM4/Ie5u8r+B+s3eHcq39EyY+jfyXm4bPtLon1QfF9VHeMQtAHW
JmRXq25Vx9CF7Oe58676zETXaAS+dcmf5+EdL+zDqhS/Yl8N/6fcXSo5NtVE
tr6Hdz+2z+LPKOs16I8SywloJ+F/ocZ5/KfG5/PQd1fNtw89x5ONh/Elz33u
KNlOe3C+5lOXbvbNFeuSnsZorAgnM+R1ObJfwDMP3eWqdTxZdS0ls5L9TWxv
4Vzl3Jo55tPIj80zHmrRU8e6UTGW11aMMdmXH4MJO+sT/zXof6tO8J3Hlzp8
uMLFNOcX0T9Zdn51X045G6s4b8u5u8y5Fj1L4F/MaoV2En3T6PlEPlRde9V9
HfROVg/0BfBe5vyD9BTOnfLWzr4wd66fhb6tcE+obyU3C/0I+v7N3X83OA/h
54dznDvhRb2jWjbUOd696CjBMwLtPc4ryM8eYukXvlhPIfMOelbWu56qk2Sz
Od7nJz2N3C9lNXLfD/8m4Qwf7kPHssxYex39E5n5P4I+hZ8fV4x11UR4UP/L
Zi22HoG/MXdupas/0VUr+aG4NqPn6eg7xScMCT86D6R470XH1ujvLZpD0ba6
K87dbKr5hqSzBM9gtB7hR7YU77fQv2H9UnJt1Zeqb0vZM+BH+JvLrr3oB4j1
XOGZpPmxMHqGKGbxiF+9+3bq3zfYl8JzC7K98PcVjlc4kx/yYS/3e6JnjOo4
leiv5K6fajdRMS4U+2DhnlG/CBd3Z8aGcLwqzT3VZ0Xh78XovpVzU9J9hoX4
/3NT9VeurlXdb+q1LHdvSJ/wrVzIf8lfSbPlZzDSmCU9YGRTg2uofCvvx1IP
NqQ5oJktrAgnlxD6s+qZo1wezJzPjfD0sTamGnaV3ReKbU3ZM3BjYSyOp3ib
UiyyoXyq1vJrQTR9a+aeEX0ttI5ojKxP/JoJsieMCpO3E/vFwjnZDe9Y9KxV
D0ymugyj73qd8TaWsK75IAxpBrfN9RzSnNMsugrvQ4XjWZPmi2LRvGhJmBGv
3g3l+WD0O6rZI4xvSTjXm9mT3k3hVLNEmLwj9xxRrvSexPSmKL71Cf/6L2hL
/wb72I9E40Bv+6Lomn5W+P9AtZNfp5I/+hd4vPA7LT8mUg/qTVXehGfNmsPp
nVmau8+Vzxr8fa7wO9UJfSSd9Z58nd6U6eh/FM1v4eVsyrPw+W7FGFVvtaR+
VD+o9qqv3qtSerMUj+5EF95/isbHhdzvqHIufcfTO/YXtpozx3I984xWTs9q
hkXHrzdnbr3fHc3Rtmgb0jGa3sEA/13R/mmmdkXr3xH99gsf/wEthyBO
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVWUQxz+9r3LvOeejC6KoGAq2iQhUYGF9UC1taUJitEUtrdbQojXF
2guI1TYxURMxcaELH3FRjDsT2QkChbaIkhjiCmKCJiYajbJQEiGR+MDH78//
LOZm5pvnmfnP3KaRet/EtSGEF6EidDYN4Qz0APxrpRD+qYXwSQzhSCWE7wsh
XKiG8D76g+juK4dwW81v4u/m7TfpsX8P+y7e1qK/yFs3fDv65VkIc0kIh9Gv
4+0G5PPY/4y8GnkN8mroV3LdhX2BXJ3oeyr2/xN+C/oyxV7i7V74fmz+LjhH
Gf5T6Cy2HdAA9r3YLMK+H/sm+AXyz+b5j1DfIDbbkKdLjnWQt70FxzyBvB1q
px9n0G/H9g38Z7AfgpYSLyCvy+u/OfOb+FZoA/xFfC6gvwf5K2J9VnNvf4Ie
xneCt325nMB/AZ2D71T9jdQGDVNLT0MII/h2Lzb/0TUh/Iv8MfEP5fO5Hn4p
dIxchAnn+DmFzevEOg+1Eut2aAv+H2LfSf40dS7l7Jcv8U83uGc3IbcgtyDX
yNdKrAXkL5HXE39F5p6ql+uhZdE+slUNp9FtQt5MfX+Rrx79jco3VnEvn8Tm
8bJ7+ju6y+p5yRhsJtc8+tmya5jAvwuf5UX3bBq5D3lt0d94BawNZ569ZvYM
+nHoZXKPlo3Nd4h/oGSM7kY+WXOsnchVYt0Rjb1f8CmSv7DY+VRzG7ZL8G9D
HiL+LLoPkA+X3LMf8P2x6t7fSr4F5FPE/KbonbkfflfmWurk60WewubVkr9B
u7AP55lSvhPoH+NtoOKe74d/hbfd2B5Xz7Ddn3r3dlJvC7re6Fzakeeod458
R8vu4fPIJzLPZq7sb/k6NTb0TavQtWfeXc1rGn4qs079fQj+j6pn/5Jykuvp
6O9Rvz8n/zzyRMnfPIl9PTXex7FJ0L+LPFn0jvfQvx01Y1mYnIH/NnNtwnwT
sVZE93IU+U18V2bG2hLyTWF/MjOW74RKyM+mrnUMm2bhN3r3ZP8EtjtS1y7M
HUt8g7Sv2qH5xDfq6m1Ajtg2pp6NMFSB35j4Fghj+jbtsHb36jemnrFmq5kO
k3skn59uylPE3hONNWFKt0o3SLdHN+uW6JurXdZNGcN+V/SuyP5o9M5LrxvW
nrimjtx/CP2GxLdJOTX7vdjXG4wBYW8RPf+v4pldh+226NsoDOu2X676tgpD
wspkzVgTZh6NvhG6DbqZulXHa+6n7od2STdO/dBOvQ3/VurZjZe8extT89pB
3fKtxNtaMV47ov8zdOt1M/qia1RtsulGvjExNoWhNfCPEO8F9IPoH0TfnDiW
fBoT32DNfxP6Zcg90fF13zfrXiXmFWMl8hXyf1fwDq4S9qJ3SzHadNsS3wbt
YFf0zqge/UddisaosKab35G6BuXWTlTp/Wj+f6IZCIu6weqdejiQeqaapTBx
SP83eTz9Z/apX5l1moFug3owmM9bWN2TGfvC7P9szvQQ
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7808396237018556, 0.8530700908186087, 0.9058735528989105], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlU2MjlcUx286nvep933e504jUkoVYTrGMJQgaoy0g1RSYcwIYSEj0amX
GfXRhIWVtYXWjllIF41EtFJfYeojTdlbshCSIqKV+E5I/P7536SLk3ufc849
53//55z7TOkf6hn8IIRwGGlCtlRCGMhDWMb+bRHCh8gjDONjCOOQNmzvaiFM
Yz+chbCX/eUyhIX4rMLWjexkvwD7aM5+yXcna14PYcKoENbh2yMhTztnTzcT
S/mx/8GZXzLH+Ca3fjK6z5DZfJ/CZxMyB32DWO3obpNrIvZPo7/lt4gYd9Cf
wXcU0sX3T6w/IyfZTwTPiugcR5A5meO9robQC7Z1YPsYnx58XhGnD5+1Fe/P
ozuHXEB3IjMH99DvYr2KbirYdhPjI3KtQDeZ/QixbhF/PjF2ovunyZiUp0A/
lXhTkI7cvCiX7riGs33R31/k5kZnG+i2I9vQ/YDPdnIdwraF9QpyMDMHd3Pz
cDa6ZsJ6nzvei7Z9S9xrue91E4xXor9biPmoarwDdedQ/EZm/tQPXeifR9/n
Rbq/7r4E3a81f2vtrnvfi35Vqt0S1knR8dazthbmuIv9yZr7R/hnpvqux38W
PjW4Wsq6MfWS+GqkWovvmDgfD95JpeuyB11GzNXBvbiw4viL0beWvstXii1M
6k/hLM3NhcS5atePfXbhen0uzMi83PnuZo4/iE8fPnPxuZW5DsIp3VDdesXT
OdVR3M1P+0XkHFOYS82K7qmzMzRz0X6XuMcNbAeazMfmaE42RPer6nga+2/I
X5n5PpU4v8jZv1NvrNS8FJ5X9aF8FeclNR+uu469rB3pvp3sjyLjgnvoQW5O
PiHOhOg6PYu+g/Bfx/da3RzobdhX8/sg7EXCv5r1v6pn/HfegM7ouVee4ehc
6rnvctdF/P1YmkNhfFI1Tp1bls6OYJ/e7FmWfWbNPvrWjAtDa8UzL91+/A8g
QxXX/E103YVxKBrn5cIzrPu+Id7Y6H4TxqdV41yKva10b7Wl9+d2yqU82utd
beSOqbq1p37exf770vbl6PZE+61FtzHN/g7NWTQXoXB/q7e72Q9Gv9cZ9x5I
cb5G11R3nwvT49w4hbE7Wjej9BxqflrQTY9+Y/4kTkfNfaGZ6C/N/xPs/0bH
upreDnH7AA4eRveE3iP1l/y3ln47VMOxwls1H2ey/98M/Vs0h5rBlma/43rD
1Rf6N6g3jmM/Vvc5zZ/6Uj35HnX/wMg=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEuIzmEUxt/M980/vu//vV9N5H7LMGPkHgozYhCFMYNISkPuMyOysbCy
UMoCG4UiWcxmkPt9JOwsZsmCIZdEyl3I7+n5L946t/c8z3vOec+o1o7m9j4h
hC2cHOdMIYRjaQid+RB2craVQlhYRE5C2FgZQl/kOmwzkWdjqyd2Lmcgd99X
hNCEv4y+iLsvOWMiDmy9+E6jr8C3nDMGcwHAp8j3wTyYxY+K5iDsSeTv7RfC
CWxHkWvAXAX2Zu4UuduC/gvfd2JGk29Zpbl9xPYhMcduYm+Q7wD5ejjD8f1C
f15hjGHod7nzDH0CdwbAdQ221cg/sA1Dr0dvRF8qDuhNxK+sdIy4vQZ/ct4c
14G3ljMZPkNyvjuUO0sS5/hMbH1WP9VsHv4GTluF/Ye4+5aYt4nrtQ7f2mgu
wmwWdobfLA74VkXjybYE3xPwuhPXYwS+3+izyDUR2yK9Lau/OO1I3TPVXj04
nJqDsM9yqok/gn4OeWriWg3CNj5xzZqRW6KxxPF46pnQLGiGGvEtyN6nN19I
PQPq/UP1GOxL6A1597QP+jjipyXGrAZvLGc6d9+Q4zy9q8U/HX8b/nfII/D3
5Fyzv9w/Rb5L+L6ppsiPsd3Htxvb1WgM5b6O7TL67aLvy1ZDrtqSZ0NveE8v
GlJjicMn4msL7p1mrLoMv7JnZyc5buJrzeZzP/fvkPtKdD2FIS7qkeolTm3E
tnOm4JsXnPtP0djCyOHrSl0r1Ui9W5PVTz2cRPzPfv4L8o9Ff4X+InHP1fvB
4Ndlek10TVVL1bgVeVPJvR+e8+y2lDxbminV9lp0rcR/Avnulo0lDtvxN2Lb
lu2HDmJ3R8t6/z+45MvW9b715N+Q+m8ofy+xA0r+j+JcRa450b1S/+QbHb0L
FLNDuVP/5y3YHiHPL5q7bPuJ36sdQ+4OMDupx4zoXaUZFPaD1LtAHNqjeyBu
ekNdwTMkbO2UqZq/6NlXzU6mnkHNg2ZsH/Kdkns/E/9XYr9E31dMh3zRXMXx
nvZl0djiW4G+OHq3iN+96B2kv6Q/nCf/npL3qd6k3Xer4Npqxrqo7cWyd4fm
YXw0Z3HVH9kbPZOK1w4fgl6V7TvNhOT+Je9W2frjHxm9K1Rv7fIV8HmRNwft
6l34tyaembboN+ptsg2MnkHNmnZETL3jX2b3/wOAGr/x
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8385778735021411, 0.8723242586368561, 0.8800068687295122], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlMtLVVEUxjfee7xXzzl3S6KFQebAx8VuL8vQDFOTkCBNrEkIcZuEQUJG
EQRNg2jQsFmDQIhIs4dphJZl/QVCNIke9IAclJCFSL/FdwaLtc7a3/7W2utx
6oqjg+dKnHOjSAo5GjvXj1wMnGvIOVePtJQ69y9yrtY7dwpQPuNcY6nsP+Xg
wQzw/TiQzqadq8JXmROuDb0Mrgt7DZ58iA/sPeJMYl/AfodcReq4G1Q4tw5+
jTj94CvAFfBn4Vnn+2xKHMtePM34y/D/wP8GfQj8+7R4hzLK5yt81/Cj3F7u
7UHaObsCZgG5zN0OeA4gPeTZyvldYpwPdO96crcPnY/E2QnmINILTzW+Oa8a
NKJL+P4EZwn4TdirKb1jINJbpsHUEmsnsU6gBzm7xN1OvpeNj1izxB/zqovl
YXGMx7ifePFbb2YTvPF98+Lsy6kWVoc59IwX7jd6xSvGBx5UTwyO3WfsW5Y3
do1Xv62/DdbrjOxOcvxerljP6dGRWDXuyShv60sZvgWk2/JFt+eU83704Vjv
sDgfyxXL+m9cxvMlpdytzn/xbwFXgHs6qzwsT9OFxH6W0futDjZnTRlxrnC3
2itvi9eW0Wx0JTNqNdnNeYvXmfVkJJmxjfhWQ834OHn9ChX/p9ecGY/N9Wav
mKexi8gw9kygvRmz98K3Af8I34uBemv+AXxNyfzsw97uVbtjsebAcLdD3be7
NhePktmwXWzySc/R85Fq8JDzqVD8ecMgrTZXXnNpb+5Fn8lpvx7wrglkPiuc
xbF6bgVf5VVj64P1w2pr/4PJ5J9Q4Hw8VK/TXLoRCzeMPhlrn7rxL2IvBZqD
pWS/3kaaS6v/UzhexfLPYL9I7G1edbGa2BztCsXxOtZsmT0E5rjXbk/gS8d6
+8tYeVgOtnM2fzZ7d9A1kfpjO2//DOtjM777sfb/JrrZa7Y70JWR5treav8d
e+8UmB2R+lmMtZ+2m/8Bw8GZ/g==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlMtLlWEQxif1eMzzfeeTUgODSig9ZpplSZphZREZlIW1yaBciUFRRhEE
/QUtatuiFkEXuqhdTFtoN7F/IIg2UUQXyKAEiyz6Pc4LZ2Dmm5lnZp6Z91T2
HN93LM/MupACZF1i9icya06ZtaTNLsVmVzNmfdg3kXn4Rol5gu9DvtlC7A1Z
s7ZCs3a+rSH2b7HZIeytxPfiS5WYzeKrpEAR8bMBX3gXYscU1kckB3Z14nYj
GJ/RP4HHzxqwW8DbiJwk9xcx/fi3R459nm/12HXI0XzvaTF6BXIYuxp7nNjl
WcfWDGP4Jvn2lvyH5B+knzvIM/RzyBT+b8jXfO9Z3IgT9S77CPog8jLl9a+g
z9BsZ6HjPRVW7FhnwbiL/jjj+nO+vVBu7Fzp2wT6SPC/1ozopVnvvYZ+R+jl
IjHl8DGKPVXsNVVrCzG3iG8TJ2nnaDP6psS50rf96J3gFTFvV9q5GIscS5x0
g1UbeW/qeT56U+JY4kC7/ok9lXZ+S9GnqVmNXYW8ip0TcfEGKUAfQibQ+8lv
IH594rclPM02Q34u7TP+o57Fvg/tsBO9lZh2fKfB2IO+M/b+xXEZWL/Jrwv1
c+QfSJyPuRmJrY98P2eQXdgrI9/vKaQG/XbsuuJ/ZHwmYQ0XmWW0m8h3oR0N
cMt5sfM5jv89/JeF/egdtcR+47oPvZnGxGeeu5+072KwxHOF0UF8V+K7UA9D
1L+mGwh8qdfucD/qWdw0Z33X4qiW3FWJ70I38YV+qsJ9y16Kb1mYR2+glfwa
/E34RXVF5ByLW9WcFla4L+14B/raxHvXDTxCH078LeqNbsN/I+O7Uj9LEq8h
bO2kHPtyJrw/7AF892KfTTXlW5T4bSumD98J+usFvw68B9j3Q7z2tzrynUrX
TWm3PeHetGO93Y6wT/Glt7k3xMv/HX52h3l1U+q9NfH/Ls2Qy/oOtTtx1JMN
N5Dy/7QF2O+KfT7FrCD/eonfir79B0XsoQA=
         "],
         VertexColors->None], 
        PolygonBox[{{3645, 2861, 2860, 2799, 1603}, {3433, 2820, 1640, 3697, 
         3432}, {2861, 4272, 2240, 4271, 2860}, {2813, 3433, 3432, 3683, 
         1629}},
         VertexColors->None]}]}, 
     {RGBColor[0.8963161233024266, 0.8915784264551037, 0.8541401845601136], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk8tvTWEUxbfqufe653lFNDWTqldVXFSVNpJ6BylmEiGVSJhoRAz9CQZM
DTwTfcWrHShNPKIR5k0waY1QYuBVVcRvW2fw5dtnfWs/1t77LD7Wc/BUjZkd
4szl7I/NFkVmM3z8KZtVQ7Mt4BfBZ8GPg0+Cz0/MGgtmT0tmHYH4B+Dc5VTh
91XMrmI3YB/mXolvudasG/tFzhniHuY8x/8beRakZq88zjyzXrBx+E2R/N13
2jnkfQOnpSjOO+w1+K3jtILVwL2Tqabd2F3wz2C3J9LmdU7AOxEo1yPiL0mU
y2vck+cawy6C16OxPdDtWqbRfjnXdYF7JFUdq7ibUtVVS50nY/WtjRgWK8Zb
3ifKyv8Aew45rgd6/xuJcwP7Hv5nsW+ioxG7FXsQfAWcJ9gtqTS7Xn/zObxG
Sx3YpVDamrk7EvXBsYWp8E64p7nrfEbgO2J9Xwk1Y5/vWrg7Y3Hug9/CPgdn
gHoK1DBa0py78zm6jvOxtIxxP+OMB8q3tKB5baaWTYny18MfrGgWHst1eC7v
6+eyeuu78CXUjN6DTfH9wWeOX3+mnjeDreZsAN/rfcvUtyPYR/OaewK9+54U
yVuFv7Go+fh++4yG8RvKtMsDxP8Rqp/92B9T+V6DvyvWLvm+PI60M/5PrE/V
tzbev+e+vqc/Q2l3fZ7TOZ/gdsaqy/vlmjzOL/DZVLs3Q8zeTLP1eF6Tx/RZ
LUs0L6/ldqh6tvO+raL/xmNvzeNPoW95qN4GkfS4lofEHuW8LOlf+b8r8Psy
5fa8+2L11Pv5O1VPvZ9f4U7m/+k/lYGM0Q==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk8lrFGEQxcvMak93fxMPxsxNJC7EbdQ4iTFI1CAiIhHxKgiCJwcRj/4H
CvoXuETIjIpC4iFKxF3Bs4J6SXLSRPGg4o76e1QfCqr6Vb2qevX18qPNgyc6
zGwYy2PnE7Oz2FjBbBzbGJvtJz6N/xzblpqNEJ/E31n03PeR2XzJa6arZr+C
WQTZi7LZrYrZdXIegp3CnuBP8e0M/itsDfx7E8eUcxO/N/Z65YwRtyvebwqb
hXsOm6Hf6xwzgq0j3krcBH9G7T9sO36N+a4xT4H4Hbktvi1h/kE43xD3FH2X
ZbFzq8euxDlUK75zxPnYtdB+G+hVIu6nXwNrwf+l4rM0wHvBLyTeqw98Aryb
/J851/AI2HDsu2u/cuo7NLN5J/AnE9da+Xfgu6/8vHOuIn8BvbvM510P3kh9
P2nQT+0c+Eq4jhd810twHsv5ziVy251mK6jvJmcf+L2q30qaz0TOoVppfIPc
2+CPyr7DJ/CB1PUVxxb69wXXQj3q9HpM/UvwHeA1Zr+avR/V/wDvCs7/lvgi
8UB2D9UXY9dYfNP0/ID/Mbg+2nEef4SZRhe7Jr+J/wTXUvM/oP5u8FsJlzZr
g99C9d/o1676rdTzM/F4FuuGS8n9mt1TM+5htsHU37o0303vVqffQjP0kDsb
+VsSx2bqNwXP1Q56Wx1wDGXvdyH4DppN/4ze6tPYbyFNL5N7JfsfpG89uEbS
Rm/ub+xvppblH8D/Hnmualbrf6u6dprhMPgofHX8Q9QM6Xap30IzTZK7KJtP
N5avf06z6tt/+NCJkA==
         "],
         VertexColors->None], 
        PolygonBox[{{3669, 3411, 3410, 3670, 1620}, {3137, 3338, 3337, 3525, 
         1493}, {2993, 4283, 2250, 4285, 2992}, {3338, 3136, 1492, 3523, 
         3337}, {3499, 2993, 2992, 3500, 1473}, {3411, 3120, 1479, 3508, 
         3410}},
         VertexColors->None]}]}, 
     {RGBColor[0.9411759999999999, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2743, 2737, 882}, {4283, 2993, 882}, {2762, 2738, 
         2024}, {2740, 2728, 1000}, {2758, 2759, 1589}, {3327, 3270, 1242}, {
         4076, 4075, 2026}, {3405, 3120, 1037}, {2729, 2745, 1242}, {3136, 
         3338, 1053}, {3269, 3327, 1242}, {2782, 2761, 2014}, {2735, 2741, 
         876}, {4265, 3062, 2234}, {2756, 2742, 1463}, {2794, 3623, 1589}, {
         3329, 4275, 876}, {2764, 2727, 2026}, {3385, 2975, 1385}, {2772, 
         2771, 2234}, {2776, 2735, 876}, {3097, 4274, 2241}, {2766, 2733, 
         2035}, {4092, 4091, 2036}, {3411, 3669, 1037}, {3887, 3078, 1000}, {
         2778, 2779, 2241}, {2747, 2740, 1000}, {4073, 4074, 2024}, {3079, 
         3887, 1000}, {3338, 3137, 1053}, {2773, 2774, 2235}, {3077, 4266, 
         2235}, {2769, 2770, 2233}, {4421, 4073, 2024}, {2985, 3491, 876}, {
         2737, 2765, 882}, {2734, 2782, 2014}, {3468, 3472, 11}, {3491, 3329, 
         876}, {2792, 3468, 11}, {3384, 2783, 1}, {3270, 3395, 1242}, {4065, 
         4064, 2014}, {3120, 3411, 1037}, {3137, 3423, 1053}, {2993, 3499, 
         882}, {2736, 2776, 876}, {2745, 2755, 1242}, {2975, 3889, 1385}, {
         3499, 2991, 882}, {3490, 3489, 1463}, {2785, 3384, 1}, {3059, 4264, 
         2232}, {4090, 4284, 2035}},
         VertexColors->None], 
        PolygonBox[{{4064, 3059, 2232, 2014}, {4521, 3591, 2757, 2754}, {4267,
          2856, 2732, 2775}, {2783, 4065, 2014, 1}, {2765, 2766, 2035, 882}, {
         4520, 4420, 2781, 2739}, {4276, 4524, 2777, 2780}, {2748, 2769, 2233,
          1385}, {4091, 4090, 2035, 2036}, {4284, 4283, 882, 2035}, {3889, 
         3079, 1000, 1385}, {4074, 2792, 11, 2024}, {2728, 2748, 1385, 
         1000}, {3061, 3385, 1385, 2233}, {2733, 2730, 2036, 2035}, {2726, 
         2762, 2024, 11}, {2761, 2760, 1, 2014}, {2767, 2734, 2014, 2232}},
         VertexColors->None], 
        PolygonBox[{{3395, 3394, 2749, 2729, 1242}, {4075, 4522, 2763, 2764, 
         2026}, {3591, 3269, 1242, 2755, 2757}, {3489, 4521, 2754, 2756, 
         1463}, {3398, 2985, 876, 2741, 2750}, {2856, 2794, 1589, 2759, 
         2732}, {3321, 4265, 2234, 2771, 2746}, {4264, 3321, 2746, 2767, 
         2232}, {3062, 4523, 2768, 2772, 2234}, {4275, 4276, 2780, 2736, 
         876}, {3404, 3405, 1037, 2744, 2752}, {3422, 4092, 2036, 2730, 
         2753}, {3078, 4267, 2775, 2747, 1000}, {4274, 3404, 2752, 2778, 
         2241}, {3623, 3398, 2750, 2758, 1589}, {4522, 3077, 2235, 2774, 
         2763}, {4524, 3097, 2241, 2779, 2777}, {3400, 3490, 1463, 2742, 
         2751}, {4523, 3061, 2233, 2770, 2768}, {3394, 4076, 2026, 2727, 
         2749}, {2991, 3400, 2751, 2743, 882}, {4266, 4520, 2739, 2773, 
         2235}, {3423, 3422, 2753, 2731, 1053}, {4420, 4421, 2024, 2738, 
         2781}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2785, 3384, 2783, 4065, 4064, 3059, 4264, 3321, 4265, 3062, 
         4523, 3061, 3385, 2975, 3889, 3079, 3887, 3078, 4267, 2856, 2794, 
         3623, 3398, 2985, 3491, 3329, 4275, 4276, 4524, 3097, 4274, 3404, 
         3405, 3120, 3411, 3669}],
        "225"],
       Annotation[#, 225, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3136, 3338, 3137, 3423, 3422, 4092, 4091, 4090, 4284, 4283, 
         2993, 3499, 2991, 3400, 3490, 3489, 4521, 3591, 3269, 3327, 3270, 
         3395, 3394, 4076, 4075, 4522, 3077, 4266, 4520, 4420, 4421, 4073, 
         4074, 2792, 3468, 3472}],
        "225"],
       Annotation[#, 225, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2820, 3433, 2813, 2865, 3523, 3337, 3525, 3524, 3000, 3502, 
         3115, 3420, 3114, 3403, 4285, 2992, 3500, 3113, 3401, 3663, 2807, 
         3487, 2798, 3641, 3328, 3326, 3592, 2983, 3885, 3886, 3639, 3884, 
         3883, 3473, 4025, 3263, 3620, 3264, 4026, 3073, 3469, 3076}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3063, 3604, 3064, 3863, 2971, 3862, 3060, 3860, 3058, 4263, 
         2853, 2784, 3602, 3387, 2976, 3474, 3323, 3892, 3893, 3888, 3891, 
         3890, 3399, 3643, 3642, 3397, 3096, 3330, 4272, 2861, 3645, 3644, 
         3408, 3098, 3492, 2994, 3507, 3508, 3410, 3670, 3409, 3505, 3425, 
         3529}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2788, 3993, 2786, 3605, 3603, 3867, 3866, 3322, 3871, 3872, 
         3861, 3065, 3870, 3388, 3625, 3624, 3386, 3080, 3324, 2857, 4078, 
         4077, 3627, 3081, 3894, 2986, 3903, 3904, 3901, 4273, 4271, 2860, 
         2799, 3406, 3407, 3504, 3503, 3332, 3506, 3119, 3412, 3118, 3426, 
         3002, 3955, 3141, 3688, 4101, 2814}],
        "175"],
       Annotation[#, 175, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3151, 3344, 3152, 3434, 3697, 3432, 3683, 3682, 3339, 3138, 
         3526, 3001, 3521, 3522, 3421, 3419, 3501, 3402, 3924, 3925, 3664, 
         3112, 3926, 3094, 4031, 3272, 3657, 3271, 3396, 2984, 3900, 3091, 
         3640, 4083, 4084, 3391, 2793, 3622, 3621, 3880, 3879, 3074, 4022, 
         4023, 3615, 4072, 2791, 3464, 3467}],
        "175"],
       Annotation[#, 175, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2932, 3772, 2933, 3773, 4133, 4134, 3868, 3869, 3774, 3865, 
         3864, 2854, 2787, 4066, 3606, 3874, 3873, 2977, 3475, 3476, 3390, 
         3389, 3477, 3998, 2800, 3646, 3626, 3908, 3907, 3331, 3911, 3101, 
         3902, 3100, 3910, 3413, 3414, 3117, 3932, 3116, 4286, 2863, 2808, 
         3668, 3428, 3003, 3527, 3340, 3951, 3952, 3689, 3140, 3950, 3437, 
         3438, 3157, 3439, 3702}],
        "150"],
       Annotation[#, 150, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3614, 3609, 3072, 3876, 3069, 4021, 3261, 3616, 3260, 4020, 
         3470, 3877, 3878, 3634, 3882, 3881, 2982, 3484, 3485, 3325, 2859, 
         2797, 3486, 2806, 4089, 3658, 3923, 3922, 3095, 3928, 3929, 3665, 
         3666, 3667, 3416, 3417, 3134, 3335, 3133, 3519, 3424, 3946, 3947, 
         3695, 3949, 3948, 3008, 3535, 3343, 3345, 3698, 2821, 3443, 3706, 
         3705}],
        "150"],
       Annotation[#, 150, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2830, 3448, 2826, 2872, 3349, 3544, 3543, 3012, 3962, 3154, 
         3703, 3153, 3961, 3435, 3436, 3149, 3696, 4105, 4106, 3430, 2812, 
         3681, 3336, 3334, 3520, 2999, 3930, 3931, 3927, 4282, 4281, 3488, 
         3920, 3109, 3659, 3110, 3921, 3092, 4030, 3268, 3653, 3267, 4029, 
         3392, 3393, 3089, 3635, 4081, 4082, 3471, 3619, 3618, 3617, 3262, 
         4024, 3070, 4018, 3258, 3610, 4071, 3462, 3066, 3875, 3068, 3608, 
         4070}],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2936, 3776, 2937, 3777, 4006, 4399, 4400, 4166, 4167, 2915, 
         3583, 2914, 4165, 4164, 4441, 4440, 4049, 3725, 2972, 3804, 2935, 
         3775, 2934, 3997, 3202, 3743, 4141, 3896, 3083, 3778, 3082, 3895, 
         2858, 3629, 3628, 3912, 3084, 3478, 4142, 3909, 3099, 3785, 3906, 
         3905, 2862, 2801, 3647, 3415, 2995, 3509, 3333, 3937, 3938, 3933, 
         3123, 3939, 3936, 3214, 3685, 3684, 3427, 3139, 3341, 2866, 4100, 
         4099, 3687, 3954, 3953, 3009, 3540, 3010, 3440, 3538, 3537, 3573, 
         3574, 3374, 2960}],
        "125"],
       Annotation[#, 125, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2834, 3551, 2831, 2873, 3352, 3550, 3549, 3018, 3971, 3164, 
         3710, 3163, 3444, 3013, 3967, 3161, 3704, 4107, 2824, 3441, 2819, 
         2868, 3342, 3534, 3533, 3007, 3944, 3945, 3943, 3135, 4289, 3418, 
         3942, 3130, 3677, 3131, 3498, 3497, 3662, 3661, 3660, 3276, 4034, 
         3093, 3919, 3107, 3654, 4087, 4088, 3483, 3638, 3637, 3636, 3266, 
         4028, 3075, 3899, 3088, 3630, 4079, 4080, 3465, 3613, 3612, 3611, 
         3259, 4019, 3067, 3463, 3256, 4016, 3257, 4017, 2974, 3805, 3807, 
         4451, 3806, 4452, 2790, 4069, 4511, 3201, 4337, 3994, 3996, 4461, 
         3995, 4462, 2884, 4139, 4140, 4007, 4009, 4008, 2926, 3846, 3847, 
         3843, 3845, 3844, 2789, 4258, 4259, 3848, 3850, 3849, 2928, 3852, 
         3853, 3851, 4260, 3056, 4138, 2883, 4508, 3826, 4460, 3827, 3824, 
         3033, 3825, 4068, 4067, 4419, 4418, 3200, 4135, 4136, 4137, 3569, 
         2882, 3742, 3243, 4171, 4172, 4173, 3585, 4170, 4169, 4168, 4472, 
         4471, 4442, 4125, 2973, 4216, 2939, 3584, 2938, 3367, 3034, 4269, 
         4270, 4268, 3085, 3479, 4176, 4175, 4174, 3244, 4401, 2978, 3781, 
         2944, 3779, 2943, 3780, 3035, 4278, 3103, 4277, 3102, 3493, 2917, 
         4181, 4180, 4403, 4402, 2987, 3787, 2948, 3786, 2947, 4001, 4002, 
         3747, 4143, 3935, 3122, 3791, 3121, 3934, 2864, 2809, 4093, 3671, 
         3749, 3748, 2890, 3528, 2891, 4146, 3750, 3215, 3369, 3368, 4003, 
         4004, 3700, 3699, 3686, 3155, 3963, 3346, 3347, 3701, 3972, 3156, 
         3539, 3759, 2894, 3375, 3376, 3044, 3833, 3043, 3834, 3372, 3459, 
         3378}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2909, 3581, 2910, 4411, 4412, 4010, 4012, 4011, 2927, 3768, 
         3769, 3738, 4131, 2879, 3461, 4261, 4262, 3854, 3856, 3855, 2929, 
         3600, 3601, 3363, 2913}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3193, 3991, 3194, 3992, 3356, 3357, 3191, 4330, 3192, 4331, 
         3025, 3821, 3823, 4505, 3822, 4506, 2847, 4381, 4382, 4380, 4384, 
         4383, 3239, 4388, 4389, 4385, 4387, 4386, 2848, 4391, 4392, 4390, 
         4394, 4393, 3240, 4397, 4398, 4395, 3241, 4396, 2849, 4458, 3294, 
         3242, 4470, 2911, 3582, 2912, 4334, 3196, 4332, 3195, 4333, 3564, 
         3565, 3198, 3724, 4122}],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3381, 3460, 3377, 3838, 3839, 3837, 3048, 3380, 3379, 3762, 
         3761, 3373, 2959, 3555, 3318, 3815, 3015, 4223, 3014, 4221, 4222, 
         4410, 4409, 4196, 4197, 3545, 3546, 3165, 3707, 3708, 3709, 3458, 
         3370, 3371, 3218, 3757, 4147, 4148, 3536, 2893, 3755, 3756, 3690, 
         3730, 4453, 2815, 4055, 4054, 4443, 3306, 4187, 4188, 4189, 3587, 
         2923, 4191, 4190, 4407, 4406, 3752, 3751, 3040, 3829, 2952, 3792, 
         2953, 3793, 2996, 4404, 3247, 4182, 4183, 4184, 3510, 3124, 4287, 
         3125, 4288, 3037, 3789, 2949, 3788, 2950, 3790, 2988, 3246, 4473, 
         2918, 3494, 3104, 4279, 3105, 4280, 3036, 3783, 4517, 2945, 3782, 
         2946, 3784, 2979, 4217, 2980, 4218, 2916, 3586, 4179, 4178, 4177, 
         3245, 3744, 2885, 3570, 3571, 3204, 4338, 3203, 4339, 2795, 4238, 
         4239, 4237, 4241, 4240, 2940, 3607, 3726, 4519, 3727, 3840, 2855, 
         4126, 3841, 3842, 3828, 4479, 2941, 4198, 2942, 4343, 4344, 4340, 
         4342, 4341, 2796, 4493, 3809, 4492, 3810, 3808, 2981, 3898, 3087, 
         3897, 3086, 3466, 3071, 4027, 3265, 3631, 3632, 3633, 3480, 2804, 
         4086, 3649, 3918, 3917, 3090, 4032, 4033, 3655, 3656, 2805, 3496, 
         2811, 4098, 3673, 3129, 3941, 3111, 4036, 3279, 3678, 3679, 3680, 
         3517, 3518, 3147, 3692, 3146, 3957, 3431, 4298, 3150, 3958, 3960, 
         3959, 3011, 3541, 3542, 3348, 2871, 2825, 3447, 2828, 4109, 3711, 
         3166, 3973, 3019, 3593, 3285, 3353, 3713, 3552, 3168, 3979, 3176, 
         3978, 4311, 4310}],
        "75"],
       Annotation[#, 75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2837, 4111, 2836, 2875, 4457, 4456, 3737, 3736, 3022, 3981, 
         3178, 3980, 3177, 3553, 3169, 3976, 3174, 3715, 4110, 2833, 3548, 
         2829, 3712, 3351, 3350, 3547, 3017, 3969, 3970, 3968, 3162, 4307, 
         3442, 3965, 3158, 3964, 3159, 3966, 3148, 3531, 3694, 3693, 3284, 
         4037, 3132, 3956, 3144, 3691, 4103, 4104, 3515, 3676, 3675, 3674, 
         3278, 4035, 3108, 3940, 3128, 3672, 4096, 4097, 3495, 3652, 3651, 
         3650, 3275, 3482, 3481, 3914, 3106, 3913, 3916, 3915, 2990, 3811, 
         2989, 3812, 4000, 4494, 2803, 4357, 3211, 4356, 3212, 4358, 3210, 
         4354, 4355, 4351, 4353, 4352, 2802, 4348, 4349, 4347, 3209, 4350, 
         3206, 4346, 3208, 4345, 3207, 3274, 4488, 3273, 3999, 3205, 3745, 
         3746, 2887, 3572, 2886, 4051, 4052, 4050, 3305, 4053, 3304, 4512, 
         3596, 2919, 3364, 4085, 3729, 3728, 3648, 2951, 4243, 3039, 4242, 
         3038, 3127, 4482, 3126, 3511, 2920, 4474, 3248, 2997, 3796, 2955, 
         3794, 2954, 4518, 3795, 3041, 4291, 4292, 4290, 3142, 3530, 2924, 
         4192, 4509, 3004, 4220, 4128, 3732, 4515, 3731, 3799, 2958, 4200, 
         4199, 4477, 4476, 3758, 4408, 3252, 4193, 4194, 4195, 3588, 3589, 
         3308, 4491, 3307, 2869, 2822, 3317, 3045, 3760, 3835, 4464, 2895, 
         3836, 3445, 4362, 4363, 4361, 4365, 4364, 3222, 4360, 3224, 4359, 
         3223, 3453, 3029, 4309, 3171, 4308, 3170, 3554, 2896, 4149, 4510, 
         3020, 4224, 4129, 3735, 4516, 3734, 3800, 4201, 3801, 3764, 3763, 
         2899, 3382, 4153, 4152, 3765, 3049, 4246, 4247, 4244, 3050, 4245, 
         3456, 3457, 3383, 2961}],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2851, 4124, 4123, 4336, 4335, 3197, 4432, 4433, 4120, 4121, 
         2850, 3563, 4117, 4116, 4115, 3293, 4431, 3189, 3580, 3238, 3599, 
         3320, 4378, 4379, 4162, 4163, 3579, 3236, 4377, 3237, 4374, 4376, 
         4375, 2844, 3723, 2841, 3722, 3721, 2968, 4253, 4254, 4252, 4257, 
         4256, 3055, 2877, 4255, 4130, 4229, 4228, 2967, 4210, 4212, 4211, 
         4373, 2843, 4503, 4504, 4502, 3820, 3818, 3024, 3819, 4114, 4113, 
         3187, 4316, 3354, 3987, 3188, 3984, 3986, 3985, 3452, 2846, 4119, 
         4118, 4327, 4326, 3355, 3989, 3990, 3988, 4329, 4328}],
        "50"],
       Annotation[#, 50, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2838, 4112, 4203, 4202, 4206, 4205, 4204, 3741, 4132, 4234, 
         3032, 4236, 4235, 3766, 4156, 2900, 3576, 4159, 4158, 4157, 3234, 
         3451, 3450, 4249, 3051, 4248, 4251, 4250, 3031, 4232, 3030, 4233, 
         2835, 2874, 3297, 4437, 3298, 4438, 3232, 3575, 4155, 4154, 3233, 
         4370, 3358, 4369, 3231, 4150, 4151, 2898, 3557, 4425, 4226, 4227, 
         4225, 3021, 3230, 4465, 2897, 3556, 3172, 4483, 3173, 3455, 3454, 
         4367, 3226, 4366, 3227, 4368, 3225, 3229, 4486, 3228, 3446, 3046, 
         4480, 3047, 3028, 4230, 3027, 4231, 2823, 2870, 3296, 4434, 4436, 
         4435, 3219, 3221, 4485, 3220, 2881, 3216, 4484, 3217, 3143, 3280, 
         4454, 2816, 2867, 3053, 4481, 3054, 3042, 3753, 3754, 2892, 3832, 
         3429, 4057, 4058, 4056, 4060, 4059, 3281, 3282, 4455, 2817, 3830, 
         3831, 3798, 2956, 3797, 2957, 4219, 2998, 4127, 4405, 3249, 4475, 
         2921, 3213, 4463, 2888, 3566, 3250, 4487, 3251, 2922, 4185, 4186, 
         4144, 4145, 2889, 3568, 4044, 4045, 4043, 3295, 4046, 3199, 3567, 
         3512, 3513, 3277, 4094, 4095, 2810, 3514, 2818, 4102, 3814, 3005, 
         3813, 3006, 4296, 4297, 4293, 4295, 4294, 3516, 3283, 4422, 4424, 
         4423, 3145, 4302, 4303, 4299, 4301, 4300, 3532, 3160, 4304, 4306, 
         4305, 3016, 4513, 4514, 3733, 4495, 4496, 4497, 2827, 4108, 2832, 
         4498, 4015, 3714, 3975, 3974, 3167, 3977, 3175, 3716, 3717, 3718, 
         3253, 4013, 3254, 4014, 3180, 3982, 3179, 3983, 3449, 3558, 3559, 
         3311, 3770, 3771, 2930, 3590, 2931, 4415, 4416, 4414, 3255, 4417, 
         3181, 3560, 3182, 4312, 3183, 4313, 3057, 3857, 3859, 3858, 2964, 
         3803, 2963}],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2845, 2878, 3361, 4459, 3362, 4507, 3301, 4048, 3303, 4047, 
         3302, 3360, 3359, 3300, 4469, 2908, 3595, 3291, 4490, 3292, 4430, 
         4214, 2969, 4213, 2970, 4215, 4439, 3299, 4468, 2907, 3594, 3287, 
         4489, 3288, 4426, 4208, 2965, 4207, 2966, 4209, 2901, 3365, 3366, 
         3312, 3319, 2839, 2876, 3561, 4445, 4446, 4061, 3313, 4063, 3316, 
         4062, 3315, 4448, 3314, 4447, 4450, 4449, 3184, 4314, 3185, 4315, 
         2902, 3577, 2903, 4466, 3235, 3286, 4371, 4372, 4160, 4161, 2904, 
         3578, 2905, 3309, 4444, 3310, 3598, 3597, 2925, 3052, 4467, 2906, 
         3767, 4478, 2962, 3802, 3719, 3720, 2840, 4005, 2842, 4500, 4501, 
         4499, 3817, 3816, 3023, 4041, 4042, 4038, 4040, 4039, 3562, 4428, 
         3289, 4427, 3290, 4429, 3186, 4320, 3190, 4317, 4319, 4318, 4413, 
         4322, 4323, 4321, 4325, 4324, 3026, 3739, 3740, 2880, 2852}],
        "25"],
       Annotation[#, 25, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Epilog->{{
     RGBColor[1, 0, 0], 
     PointSize[0.05], {
      PointBox[{-1., 1.}], 
      PointBox[{-0.8188316725128169, 0.6376633450256337}], 
      PointBox[{-0.578385178756401, 0.2767148986453199}], 
      PointBox[{-0.4527466106174215, 0.18919444362155008`}], 
      PointBox[{-0.3063690685941955, 0.06326224815395692}], 
      PointBox[{-0.12288901976566494`, -0.018563217139153973`}], 
      PointBox[{0.022318674727775184`, -0.02058715129849601}], 
      PointBox[{0.20971967826508892`, 0.00886320732482013}], 
      PointBox[{0.30821137051356023`, 0.08529363547187953}], 
      PointBox[{0.43019778570514916`, 0.16551807983690672`}], 
      PointBox[{0.5462374032762535, 0.28491010789193627`}], 
      PointBox[{0.6691071183414994, 0.4326073689350505}], 
      PointBox[{0.7514312032720123, 0.5578715982911779}], 
      PointBox[{0.8569603769120848, 0.7232446811081459}], 
      PointBox[{0.901282395939072, 0.8103455158590455}], 
      PointBox[{0.9721549891647511, 0.9400623984873847}], 
      PointBox[{0.9860456509756397, 0.9720930753224285}], 
      PointBox[{0.999481508936547, 0.9987827644269311}], 
      PointBox[{0.9999819324802698, 0.9999636148632517}], 
      PointBox[{0.9999999990951383, 0.999999997863874}]}}, {
     RGBColor[1, 1, 0], 
     PointSize[0.03], {
      PointBox[{-1., 1.}], 
      PointBox[{0.999999999999954, -2.999999999999908}], 
      PointBox[{-0.662519076853006, 0.32503815370601197`}], 
      PointBox[{-0.8188316725128169, 0.6376633450256337}], 
      PointBox[{-0.578385178756401, 0.2767148986453199}], 
      PointBox[{-0.4527466106174215, 0.18919444362155008`}], 
      PointBox[{-0.10327749115037554`, -0.11146242528275652`}], 
      PointBox[{-0.3063690685941955, 0.06326224815395692}], 
      PointBox[{-0.12288901976566494`, -0.018563217139153973`}], 
      PointBox[{0.022318674727775184`, -0.02058715129849601}], 
      PointBox[{0.20971967826508892`, 0.00886320732482013}], 
      PointBox[{0.30821137051356023`, 0.08529363547187953}], 
      PointBox[{0.5435038065120156, 0.24003385725496323`}], 
      PointBox[{0.43019778570514916`, 0.16551807983690672`}], 
      PointBox[{0.5462374032762535, 0.28491010789193627`}], 
      PointBox[{0.6691071183414994, 0.4326073689350505}], 
      PointBox[{0.7514312032720123, 0.5578715982911779}], 
      PointBox[{0.8569603769120848, 0.7232446811081459}], 
      PointBox[{0.901282395939072, 0.8103455158590455}], 
      PointBox[{0.9721549891647511, 0.9400623984873847}], 
      PointBox[{0.9860456509756397, 0.9720930753224285}], 
      PointBox[{0.999481508936547, 0.9987827644269311}], 
      PointBox[{0.9999819324802698, 0.9999636148632517}], 
      PointBox[{0.9999999990951383, 0.999999997863874}], 
      PointBox[{0.9999999999999999, 0.9999999999999999}]}}, {
     RGBColor[0, 0, 1], 
     PointSize[0.015], {
      PointBox[{-1., 1.}], 
      PointBox[{0.999999999999954, -2.999999999999908}], 
      PointBox[{-0.662519076853006, 0.32503815370601197`}], 
      PointBox[{-0.8188316725128169, 0.6376633450256337}], 
      PointBox[{-0.578385178756401, 0.2767148986453199}], 
      PointBox[{-0.4527466106174215, 0.18919444362155008`}], 
      PointBox[{-0.10327749115037554`, -0.11146242528275652`}], 
      PointBox[{-0.3063690685941955, 0.06326224815395692}], 
      PointBox[{-0.12288901976566494`, -0.018563217139153973`}], 
      PointBox[{0.022318674727775184`, -0.02058715129849601}], 
      PointBox[{0.20971967826508892`, 0.00886320732482013}], 
      PointBox[{0.30821137051356023`, 0.08529363547187953}], 
      PointBox[{0.5435038065120156, 0.24003385725496323`}], 
      PointBox[{0.43019778570514916`, 0.16551807983690672`}], 
      PointBox[{0.5462374032762535, 0.28491010789193627`}], 
      PointBox[{0.6691071183414994, 0.4326073689350505}], 
      PointBox[{0.7514312032720123, 0.5578715982911779}], 
      PointBox[{0.8569603769120848, 0.7232446811081459}], 
      PointBox[{0.901282395939072, 0.8103455158590455}], 
      PointBox[{0.9721549891647511, 0.9400623984873847}], 
      PointBox[{0.9860456509756397, 0.9720930753224285}], 
      PointBox[{0.999481508936547, 0.9987827644269311}], 
      PointBox[{0.9999819324802698, 0.9999636148632517}], 
      PointBox[{0.9999999990951383, 0.999999997863874}], 
      PointBox[{0.9999999999999999, 0.9999999999999999}]}}},
  Frame->True,
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->152111835]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->484065414],

Cell["\<\
Show where evaluations were done for part of a plot using a tooltip that \
indicates order:\
\>", "ExampleText",
 CellID->458685043],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", " ", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"plot", ",", " ", "evals"}], "}"}], "=", 
   RowBox[{"Reap", "[", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"e", " ", "=", " ", "0"}], "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", " ", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"Tooltip", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"f", "[", "x", "]"}]}], "}"}], "]"}], ",", 
            RowBox[{"++", "e"}]}], "]"}], "]"}]}]}], "]"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"plot", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "evals"}], "}"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->372732],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c81d8bt+d13esSUZGRmWRVcs/5oJJSXymUVEKykoSMIoUkeyaUVRmZ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      "]]}}, 
   {RGBColor[1, 0, 0], 
    TagBox[
     TooltipBox[PointBox[{-4.9999997959183675`, 1.3887972207734933`*^-11}],
      "1"],
     Annotation[#, 1, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.803713387984696, 9.514088585466253*^-11}],
      "2"],
     Annotation[#, 2, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.590916429145413, 7.024031005482047*^-10}],
      "3"],
     Annotation[#, 3, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.392221164298479, 4.185637745886867*^-9}],
      "4"],
     Annotation[#, 4, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.197423511811239, 2.2307026074354565`*^-8}],
      "5"],
     Annotation[#, 5, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.986115308418389, 1.2573173940283228`*^-7}],
      "6"],
     Annotation[#, 6, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.788908799017886, 5.825621934847497*^-7}],
      "7"],
     Annotation[#, 7, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.575191738711772, 2.8109277511643803`*^-6}],
      "8"],
     Annotation[#, 8, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.3653722907653534`, 0.000012058621756001172`}],
      "9"],
     Annotation[#, 9, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.169654536811282, 0.00004332806923586483}],
      "10"],
     Annotation[#, 10, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9574262319516, 0.0001590375981357126}],
      "11"],
     Annotation[#, 11, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.759299621084266, 0.0004936250194694024}],
      "12"],
     Annotation[#, 12, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.565070622576627, 0.0013884221801045782`}],
      "13"],
     Annotation[#, 13, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.354331073163377, 0.003915255060679678}],
      "14"],
     Annotation[#, 14, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.157693217742475, 0.009507826077378463}],
      "15"],
     Annotation[#, 15, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.9445448114159614`, 0.02279407777198095}],
      "16"],
     Annotation[#, 16, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.735294017449143, 0.04923033270815907}],
      "17"],
     Annotation[#, 17, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.5401449174746724`, 0.0932896260185104}],
      "18"],
     Annotation[#, 18, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.3284852665945908`, 0.17120851085725267`}],
      "19"],
     Annotation[#, 19, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.130927309706857, 0.27831642870351797`}],
      "20"],
     Annotation[#, 20, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.9168588019135122, 0.43143860442625936`}],
      "21"],
     Annotation[#, 21, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.7066879064798623, 0.6068899552663182}],
      "22"],
     Annotation[#, 22, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.5106187050385604, 0.7704877971385432}],
      "23"],
     Annotation[#, 23, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.2980389526916474, 0.9150036566996566}],
      "24"],
     Annotation[#, 24, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.09956089433708235, 0.9901365939528979}],
      "25"],
     Annotation[#, 25, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.09501955165778773, 0.9910119212615109}],
      "26"],
     Annotation[#, 26, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.306110548558269, 0.9105525481792557}],
      "27"],
     Annotation[#, 27, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.5030998514664022, 0.7763828938773161}],
      "28"],
     Annotation[#, 28, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.7165997052801466, 0.5983884597963015}],
      "29"],
     Annotation[#, 29, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.9262019467341961, 0.42407283996512773`}],
      "30"],
     Annotation[#, 30, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.1217024941958975`, 0.2841603789824653}],
      "31"],
     Annotation[#, 31, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.3337135925632102`, 0.16884199419451967`}],
      "32"],
     Annotation[#, 32, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.5316229969381747`, 0.09576394663653412}],
      "33"],
     Annotation[#, 33, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.7256347889534445`, 0.05090391591710936}],
      "34"],
     Annotation[#, 34, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.9361571318743254`, 0.023548234268638956`}],
      "35"],
     Annotation[#, 35, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.132577780802858, 0.010589545997314749`}],
      "36"],
     Annotation[#, 36, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.345508980637002, 0.004081003445629097}],
      "37"],
     Annotation[#, 37, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5443384864787983`, 0.0015435685024279733`}],
      "38"],
     Annotation[#, 38, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.739270379960899, 0.0005510956256853345}],
      "39"],
     Annotation[#, 39, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9507128243486114`, 0.00016547239547443304`}],
      "40"],
     Annotation[#, 40, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.148053574743976, 0.000049663449921860465`}],
      "41"],
     Annotation[#, 41, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.3619048760449513`, 0.000012343210593466787`}],
      "42"],
     Annotation[#, 42, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.5718585649862313`, 2.8786946638924452`*^-6}],
      "43"],
     Annotation[#, 43, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.767710559935164, 6.83770936583673*^-7}],
      "44"],
     Annotation[#, 44, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.9800731057897076`, 1.3193163998191543`*^-7}],
      "45"],
     Annotation[#, 45, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.178333957651903, 2.617464450724823*^-8}],
      "46"],
     Annotation[#, 46, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.3726971971544035`, 4.966846138726179*^-9}],
      "47"],
     Annotation[#, 47, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.583570987562515, 7.51369933153141*^-10}],
      "48"],
     Annotation[#, 48, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.780343083978279, 1.1902589986918073`*^-10}],
      "49"],
     Annotation[#, 49, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.9936257312996535`, 1.4801420732922718`*^-11}],
      "50"],
     Annotation[#, 50, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.9999997959183675`, 1.3887972207734933`*^-11}],
      "51"],
     Annotation[#, 51, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.901856591951532, 3.6701699719461727`*^-11}],
      "52"],
     Annotation[#, 52, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.697314908565055, 2.614527988547172*^-10}],
      "53"],
     Annotation[#, 53, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.491568796721946, 1.7316515066443708`*^-9}],
      "54"],
     Annotation[#, 54, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.294822338054859, 9.754872672877326*^-9}],
      "55"],
     Annotation[#, 55, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.091769410114814, 5.355391649575934*^-8}],
      "56"],
     Annotation[#, 56, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.8875120537181376`, 2.7328518103957796`*^-7}],
      "57"],
     Annotation[#, 57, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.682050268864829, 1.2943600142647408`*^-6}],
      "58"],
     Annotation[#, 58, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.4702820147385625`, 5.886451157617714*^-6}],
      "59"],
     Annotation[#, 59, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.2675134137883175`, 0.00002307769689335105}],
      "60"],
     Annotation[#, 60, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.063540384381441, 0.00008395079649659109}],
      "61"],
     Annotation[#, 61, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.858362926517933, 0.000282950490829144}],
      "62"],
     Annotation[#, 62, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.6621851218304466`, 0.0008357093917007622}],
      "63"],
     Annotation[#, 63, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.459700847870002, 0.0023575596041157973`}],
      "64"],
     Annotation[#, 64, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.256012145452926, 0.006160540261884874}],
      "65"],
     Annotation[#, 65, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.051119014579218, 0.014889645924741903`}],
      "66"],
     Annotation[#, 66, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.8399194144325521`, 0.03386736368032057}],
      "67"],
     Annotation[#, 67, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.6377194674619076`, 0.06841760844320603}],
      "68"],
     Annotation[#, 68, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.4343150920346317`, 0.127803700349259}],
      "69"],
     Annotation[#, 69, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.229706288150724, 0.22042945767595765`}],
      "70"],
     Annotation[#, 70, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.0238930558101846`, 0.35051317300883417`}],
      "71"],
     Annotation[#, 71, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.6086533057592114, 0.6904174622327711}],
      "72"],
     Annotation[#, 72, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.4043288288651039, 0.8491819524003076}],
      "73"],
     Annotation[#, 73, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.19879992351436487`, 0.9612493738159675}],
      "74"],
     Annotation[#, 74, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.0022706713396473052`, 0.9999948440649592}],
      "75"],
     Annotation[#, 75, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.2005650501080284, 0.9605719993278757}],
      "76"],
     Annotation[#, 76, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.40460520001233563`, 0.8489921253864281}],
      "77"],
     Annotation[#, 77, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.6098497783732744, 0.6894116321495359}],
      "78"],
     Annotation[#, 78, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.0239522204650469`, 0.3504707073847391}],
      "79"],
     Annotation[#, 79, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.227708043379554, 0.22151454188988806`}],
      "80"],
     Annotation[#, 80, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.4326682947506924`, 0.12840853181405146`}],
      "81"],
     Annotation[#, 81, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.6286288929458097`, 0.07047959307899687}],
      "82"],
     Annotation[#, 82, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.8308959604138848`, 0.035007952890562154`}],
      "83"],
     Annotation[#, 83, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.0343674563385914`, 0.015944346764439222`}],
      "84"],
     Annotation[#, 84, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.23904338071993, 0.0066488241417018215`}],
      "85"],
     Annotation[#, 85, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.4449237335579, 0.002534770793189282}],
      "86"],
     Annotation[#, 86, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.641804433219849, 0.0009311123014855809}],
      "87"],
     Annotation[#, 87, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.844991602154755, 0.00030537280498927233`}],
      "88"],
     Annotation[#, 88, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.049383199546294, 0.000091539691058842}],
      "89"],
     Annotation[#, 89, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2549792253944636`, 0.000025043662467548887`}],
      "90"],
     Annotation[#, 90, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.466881720515591, 6.026953709311394*^-6}],
      "91"],
     Annotation[#, 91, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6697845624606975`, 1.4165039418430825`*^-6}],
      "92"],
     Annotation[#, 92, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.873891832862436, 3.0375695886262295`*^-7}],
      "93"],
     Annotation[#, 93, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.079203531720806, 5.9344793018914176`*^-8}],
      "94"],
     Annotation[#, 94, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.275515577403153, 1.1510186021468564`*^-8}],
      "95"],
     Annotation[#, 95, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.478134092358459, 1.9534184475514287`*^-9}],
      "96"],
     Annotation[#, 96, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.681957035770397, 3.0196147141154576`*^-10}],
      "97"],
     Annotation[#, 97, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.886984407638966, 4.245329436094531*^-11}],
      "98"],
     Annotation[#, 98, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.996812763609011, 1.4337569377998923`*^-11}],
      "99"],
     Annotation[#, 99, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.950928193934949, 2.2631237324167032`*^-11}],
      "100"],
     Annotation[#, 100, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.750514148274876, 1.5816462847879492`*^-10}],
      "101"],
     Annotation[#, 101, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.541242612933679, 1.1055924746380699`*^-9}],
      "102"],
     Annotation[#, 102, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.343521751176668, 6.405036499975698*^-9}],
      "103"],
     Annotation[#, 103, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.144596460963027, 3.465999058744412*^-8}],
      "104"],
     Annotation[#, 104, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.936813681068263, 1.8581728970257563`*^-7}],
      "105"],
     Annotation[#, 105, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.7354795339413576`, 8.708401962643884*^-7}],
      "106"],
     Annotation[#, 106, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.522736876725167, 4.078933084510908*^-6}],
      "107"],
     Annotation[#, 107, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.316442852276835, 0.000016721868696333076`}],
      "108"],
     Annotation[#, 108, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.1165974605963616`, 0.00006048109437719433}],
      "109"],
     Annotation[#, 109, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9078945792347666`, 0.00021265256294165236`}],
      "110"],
     Annotation[#, 110, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.710742371457356, 0.000643798863491409}],
      "111"],
     Annotation[#, 111, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.5123857352233143`, 0.001814251881836205}],
      "112"],
     Annotation[#, 112, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.305171609308151, 0.004923103531019206}],
      "113"],
     Annotation[#, 113, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.1044061161608463`, 0.011932075298250657`}],
      "114"],
     Annotation[#, 114, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.8922321129242567`, 0.0278605834348692}],
      "115"],
     Annotation[#, 115, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.6865067424555251`, 0.058174684543766716`}],
      "116"],
     Annotation[#, 116, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.487230004754652, 0.10949755190116152`}],
      "117"],
     Annotation[#, 117, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.2790957773726572`, 0.19474076644731422`}],
      "118"],
     Annotation[#, 118, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.0774101827585207`, 0.31323151356242107`}],
      "119"],
     Annotation[#, 119, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.6576706061195369, 0.6488649805915586}],
      "120"],
     Annotation[#, 120, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.4574737669518322, 0.8111662537242412}],
      "121"],
     Annotation[#, 121, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.24841943810300612`, 0.940153407817935}],
      "122"],
     Annotation[#, 122, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.05091578283836483, 0.9974109404688609}],
      "123"],
     Annotation[#, 123, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.14779230088290807`, 0.9783942572089319}],
      "124"],
     Annotation[#, 124, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.3553578742853023, 0.8813687176927636}],
      "125"],
     Annotation[#, 125, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.5564748149198383, 0.7336932746593732}],
      "126"],
     Annotation[#, 126, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.9750770835996214, 0.38644129201471383`}],
      "127"],
     Annotation[#, 127, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.1747052687877257`, 0.2515955431060489}],
      "128"],
     Annotation[#, 128, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.3831909436569512`, 0.14760474987411645`}],
      "129"],
     Annotation[#, 129, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.5801259449419922`, 0.08234825588497015}],
      "130"],
     Annotation[#, 130, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.7782653746836647`, 0.04233133263924113}],
      "131"],
     Annotation[#, 131, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.9852622941064584`, 0.019423601573252933`}],
      "132"],
     Annotation[#, 132, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.1858105807613937`, 0.008414760650265184}],
      "133"],
     Annotation[#, 133, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.3952163570974507`, 0.003224229096005911}],
      "134"],
     Annotation[#, 134, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5930714598493236`, 0.0012016981519813975`}],
      "135"],
     Annotation[#, 135, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.792130991057827, 0.0004113790641891889}],
      "136"],
     Annotation[#, 136, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.0000480119474524`, 0.00012337425805221817`}],
      "137"],
     Annotation[#, 137, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.20151640006922, 0.000035367852923473625`}],
      "138"],
     Annotation[#, 138, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.414393298280271, 8.648872474018377*^-6}],
      "139"],
     Annotation[#, 139, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6208215637234646`, 2.0241740921603248`*^-6}],
      "140"],
     Annotation[#, 140, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.8208011963988, 4.5702772412883076`*^-7}],
      "141"],
     Annotation[#, 141, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.029638318755257, 8.870185985006947*^-8}],
      "142"],
     Annotation[#, 142, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.226924767527528, 1.7398306025219797`*^-8}],
      "143"],
     Annotation[#, 143, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.4254156447564315`, 3.123525113478064*^-9}],
      "144"],
     Annotation[#, 144, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.632764011666456, 4.774783068158701*^-10}],
      "145"],
     Annotation[#, 145, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.8336637458086225`, 7.128713728308301*^-11}],
      "146"],
     Annotation[#, 146, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.995219247454332, 1.4567685966326298`*^-11}],
      "147"],
     Annotation[#, 147, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.852784989968114, 5.923419284936738*^-11}],
      "148"],
     Annotation[#, 148, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.644115668855234, 4.2975306239174696`*^-10}],
      "149"],
     Annotation[#, 149, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.441894980510213, 2.6988744590122965`*^-9}],
      "150"],
     Annotation[#, 150, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.246122924933049, 1.4786371963800969`*^-8}],
      "151"],
     Annotation[#, 151, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.038942359266602, 8.228677938472097*^-8}],
      "152"],
     Annotation[#, 152, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.8382104263680117`, 3.999768057758173*^-7}],
      "153"],
     Annotation[#, 153, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.6286210037883, 1.912899528765162*^-6}],
      "154"],
     Annotation[#, 154, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.4178271527519577`, 8.448324281958729*^-6}],
      "155"],
     Annotation[#, 155, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.2185839752998, 0.0000316971810768166}],
      "156"],
     Annotation[#, 156, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.0104833081665205`, 0.00011587370050728656`}],
      "157"],
     Annotation[#, 157, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.8088312738010996`, 0.0003746444464059645}],
      "158"],
     Annotation[#, 158, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.613627872203537, 0.0010797231056674226`}],
      "159"],
     Annotation[#, 159, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.4070159605166896`, 0.003046609840776377}],
      "160"],
     Annotation[#, 160, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.2068526815977005`, 0.007671840294605251}],
      "161"],
     Annotation[#, 161, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.9978319129975897`, 0.01847508239048567}],
      "162"],
     Annotation[#, 162, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.7876067159408475`, 0.04094450069445806}],
      "163"],
     Annotation[#, 163, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.58893219246829, 0.08008189244994467}],
      "164"],
     Annotation[#, 164, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.3814001793146113`, 0.14833731318096857`}],
      "165"],
     Annotation[#, 165, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.1803167989287906`, 0.24829251154247273`}],
      "166"],
     Annotation[#, 166, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.5596360053988859, 0.7311091908211808}],
      "167"],
     Annotation[#, 167, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.35118389077837564`, 0.8839717930728209}],
      "168"],
     Annotation[#, 168, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.1491804089257236, 0.97799101666145}],
      "169"],
     Annotation[#, 169, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.04637444015907022, 0.9978517221589454}],
      "170"],
     Annotation[#, 170, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.2533377993331487, 0.9378361357766676}],
      "171"],
     Annotation[#, 171, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.072827357330472, 0.3163334062176914}],
      "172"],
     Annotation[#, 172, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.2807108179713822`, 0.19393733272987265`}],
      "173"],
     Annotation[#, 173, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.4821456458444335`, 0.1111632190859444}],
      "174"],
     Annotation[#, 174, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.677131840949627, 0.06003838256158581}],
      "175"],
     Annotation[#, 175, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.883526546144105, 0.028791581314843766`}],
      "176"],
     Annotation[#, 176, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.083472618570725, 0.013025345675175926`}],
      "177"],
     Annotation[#, 177, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.292276180678466, 0.005223800439187023}],
      "178"],
     Annotation[#, 178, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.494631110018349, 0.0019829207894039207`}],
      "179"],
     Annotation[#, 179, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.6905374065903738`, 0.0007180355078835415}],
      "180"],
     Annotation[#, 180, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.8978522132516833`, 0.00022541949941096213`}],
      "181"],
     Annotation[#, 181, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.098718387145135, 0.00006758965340076548}],
      "182"],
     Annotation[#, 182, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.3084420507197074`, 0.000017632111470268017`}],
      "183"],
     Annotation[#, 183, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.519370142750911, 4.176795627575599*^-6}],
      "184"],
     Annotation[#, 184, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.718747561197931, 9.865188300657227*^-7}],
      "185"],
     Annotation[#, 185, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.926982469326072, 2.0075284459249665`*^-7}],
      "186"],
     Annotation[#, 186, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.128768744686354, 3.950923688847888*^-8}],
      "187"],
     Annotation[#, 187, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.324106387278778, 7.57891302094983*^-9}],
      "188"],
     Annotation[#, 188, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.530852539960487, 1.2148748873063968`*^-9}],
      "189"],
     Annotation[#, 189, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.731150059874338, 1.9004107383562312`*^-10}],
      "190"],
     Annotation[#, 190, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.94030506946931, 2.5138660911889777`*^-11}],
      "191"],
     Annotation[#, 191, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.998406279763689, 1.4111016132718238`*^-11}],
      "192"],
     Annotation[#, 192, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.975463994926658, 1.7739240287206872`*^-11}],
      "193"],
     Annotation[#, 193, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.7771137681297855`, 1.2275679999809127`*^-10}],
      "194"],
     Annotation[#, 194, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.566079521039546, 8.817767653593204*^-10}],
      "195"],
     Annotation[#, 195, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.367871457737573, 5.180827360533349*^-9}],
      "196"],
     Annotation[#, 196, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.1710099863871335`, 2.7825184570615473`*^-8}],
      "197"],
     Annotation[#, 197, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.9614644947433257`, 1.5294293742724112`*^-7}],
      "198"],
     Annotation[#, 198, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.7621941664796217`, 7.127714989029364*^-7}],
      "199"],
     Annotation[#, 199, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5489643077184696`, 3.3884171688270058`*^-6}],
      "200"],
     Annotation[#, 200, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.340907571521094, 0.00001420859632607433}],
      "201"],
     Annotation[#, 201, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.143125998703822, 0.000051227142280001985`}],
      "202"],
     Annotation[#, 202, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9326604055931833`, 0.00018401430578722215`}],
      "203"],
     Annotation[#, 203, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.735020996270811, 0.0005640656852478158}],
      "204"],
     Annotation[#, 204, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.5387281788999707`, 0.0015882209852831671`}],
      "205"],
     Annotation[#, 205, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.329751341235764, 0.004393007037585721}],
      "206"],
     Annotation[#, 206, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.1310496669516605`, 0.010658765400766856`}],
      "207"],
     Annotation[#, 207, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.918388462170109, 0.025217570337956706`}],
      "208"],
     Annotation[#, 208, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.7109003799523341`, 0.05354782441304617}],
      "209"],
     Annotation[#, 209, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.5136874611146622`, 0.10113998517232568`}],
      "210"],
     Annotation[#, 210, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.303790521983624, 0.1827073246599517}],
      "211"],
     Annotation[#, 211, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.104168746232689, 0.2954698079372785}],
      "212"],
     Annotation[#, 212, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.6821792562996996, 0.6279036563580304}],
      "213"],
     Annotation[#, 213, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.4840462359951963, 0.7911238428266998}],
      "214"],
     Annotation[#, 214, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.27322919539732676`, 0.9280643617958317}],
      "215"],
     Annotation[#, 215, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.07523833858772358, 0.9943551845874147}],
      "216"],
     Annotation[#, 216, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.12140592627034791`, 0.985368694278903}],
      "217"],
     Annotation[#, 217, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.33073421142178566`, 0.8963851364223261}],
      "218"],
     Annotation[#, 218, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.5297873331931202, 0.7552740477720435}],
      "219"],
     Annotation[#, 219, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.9506395151669087, 0.4050618579754041}],
      "220"],
     Annotation[#, 220, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.1482038814918116`, 0.2675705113703857}],
      "221"],
     Annotation[#, 221, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.3584522681100806`, 0.1579632978964952}],
      "222"],
     Annotation[#, 222, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.5558744709400836`, 0.08885536270876976}],
      "223"],
     Annotation[#, 223, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.7519500818185545`, 0.04645230976222715}],
      "224"],
     Annotation[#, 224, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.9607097129903919`, 0.02139961006001727}],
      "225"],
     Annotation[#, 225, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.1591941807821255`, 0.009446419385117479}],
      "226"],
     Annotation[#, 226, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.3703626688672266`, 0.003629649535867188}],
      "227"],
     Annotation[#, 227, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5687049731640608`, 0.0013627572537496396`}],
      "228"],
     Annotation[#, 228, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.765700685509363, 0.0004764726273112633}],
      "229"],
     Annotation[#, 229, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.975380418148032, 0.00014296815673176094`}],
      "230"],
     Annotation[#, 230, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.174784987406598, 0.00004194045363506344}],
      "231"],
     Annotation[#, 231, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.388149087162611, 0.000010339342935004022`}],
      "232"],
     Annotation[#, 232, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.596340064354848, 2.4153608578454507`*^-6}],
      "233"],
     Annotation[#, 233, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.794255878166982, 5.594130829380406*^-7}],
      "234"],
     Annotation[#, 234, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.004855712272482, 1.0824493336282787`*^-7}],
      "235"],
     Annotation[#, 235, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.2026293625897155`, 2.1352573640778647`*^-8}],
      "236"],
     Annotation[#, 236, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.399056420955418, 3.9415279085970294`*^-9}],
      "237"],
     Annotation[#, 237, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.608167499614486, 5.993306273865234*^-10}],
      "238"],
     Annotation[#, 238, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.807003414893451, 9.217964029949017*^-11}],
      "239"],
     Annotation[#, 239, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.994422489376992, 1.4684097618077598`*^-11}],
      "240"],
     Annotation[#, 240, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.877320790959823, 4.665420292076542*^-11}],
      "241"],
     Annotation[#, 241, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.670715288710144, 3.3543889468520977`*^-10}],
      "242"],
     Annotation[#, 242, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.46673188861608, 2.1631642324329543`*^-9}],
      "243"],
     Annotation[#, 243, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.270472631493954, 1.2017084439890434`*^-8}],
      "244"],
     Annotation[#, 244, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.0653558846907085`, 6.642990740195139*^-8}],
      "245"],
     Annotation[#, 245, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.862861240043075, 3.308181660399745*^-7}],
      "246"],
     Annotation[#, 246, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.6553356363265648`, 1.5746482968673304`*^-6}],
      "247"],
     Annotation[#, 247, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.44405458374526, 7.056848629882699*^-6}],
      "248"],
     Annotation[#, 248, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.2430486945440586`, 0.0000270624111544358}],
      "249"],
     Annotation[#, 249, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.037011846273981, 0.00009869848566900033}],
      "250"],
     Annotation[#, 250, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.8335971001595164`, 0.00032578512293155923`}],
      "251"],
     Annotation[#, 251, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.637906497016992, 0.0009504731098146573}],
      "252"],
     Annotation[#, 252, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.4333584041933456`, 0.0026818910348715523`}],
      "253"],
     Annotation[#, 253, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.2314324135253134`, 0.006878940636596998}],
      "254"],
     Annotation[#, 254, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.024475463788404, 0.016597538072877737`}],
      "255"],
     Annotation[#, 255, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.8137630651866998`, 0.0372636686948767}],
      "256"],
     Annotation[#, 256, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.6133258299650988`, 0.0740644044691002}],
      "257"],
     Annotation[#, 257, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.4078576356746215`, 0.13778467722674528`}],
      "258"],
     Annotation[#, 258, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.2050115435397573`, 0.23408925140976952`}],
      "259"],
     Annotation[#, 259, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.5841446555790486, 0.7108989531330808}],
      "260"],
     Annotation[#, 260, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.3777563598217398, 0.8670142491024093}],
      "261"],
     Annotation[#, 261, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.17399016622004423`, 0.9701810475510124}],
      "262"],
     Annotation[#, 262, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.022051884409711456`, 0.9995138326116627}],
      "263"],
     Annotation[#, 263, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.22695142472058855`, 0.9497970496260356}],
      "264"],
     Annotation[#, 264, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.0483897888977594`, 0.3331637562169063}],
      "265"],
     Annotation[#, 265, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.254209430675468, 0.20741341655743728`}],
      "266"],
     Annotation[#, 266, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.457406970297563, 0.11954826749465694`}],
      "267"],
     Annotation[#, 267, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.6528803669477183`, 0.06508810226080163}],
      "268"],
     Annotation[#, 268, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.857211253278995, 0.03176997431061609}],
      "269"],
     Annotation[#, 269, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.058920037454658, 0.014419818691169536`}],
      "270"],
     Annotation[#, 270, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.265659780699198, 0.0058975737475456735`}],
      "271"],
     Annotation[#, 271, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.4697774217881245`, 0.0022433151866778343`}],
      "272"],
     Annotation[#, 272, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.6661709199051113`, 0.0008181479463983808}],
      "273"],
     Annotation[#, 273, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.871421907703219, 0.00026255137729953767`}],
      "274"],
     Annotation[#, 274, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.074050793345714, 0.00007870622718485909}],
      "275"],
     Annotation[#, 275, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2817106380570857`, 0.000021028651101516543`}],
      "276"],
     Annotation[#, 276, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.493125931633251, 5.020762344939663*^-6}],
      "277"],
     Annotation[#, 277, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.694266061829314, 1.1828287582204586`*^-6}],
      "278"],
     Annotation[#, 278, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.9004371510942537`, 2.4711550707794494`*^-7}],
      "279"],
     Annotation[#, 279, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.10398613820358, 4.8451515347956155`*^-8}],
      "280"],
     Annotation[#, 280, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.299810982340966, 9.345466440952296*^-9}],
      "281"],
     Annotation[#, 281, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.504493316159474, 1.5415768199105258`*^-9}],
      "282"],
     Annotation[#, 282, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.7065535478223675`, 2.396968062510212*^-10}],
      "283"],
     Annotation[#, 283, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.913644738554138, 3.2691545569774406`*^-11}],
      "284"],
     Annotation[#, 284, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.99760952168635, 1.4223850732803432`*^-11}],
      "285"],
     Annotation[#, 285, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.9263923929432405`, 2.8837571608782058`*^-11}],
      "286"],
     Annotation[#, 286, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.723914528419965, 2.0349728110119882`*^-10}],
      "287"],
     Annotation[#, 287, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.516405704827813, 1.3845086984480694`*^-9}],
      "288"],
     Annotation[#, 288, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.3191720446157635`, 7.909137099106667*^-9}],
      "289"],
     Annotation[#, 289, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.11818293553892, 4.3113455733645*^-8}],
      "290"],
     Annotation[#, 290, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.9121628673932003`, 2.2548362410667294`*^-7}],
      "291"],
     Annotation[#, 291, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.708764901403093, 1.0624456463004343`*^-6}],
      "292"],
     Annotation[#, 292, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.496509445731865, 4.903416729577355*^-6}],
      "293"],
     Annotation[#, 293, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.2919781330325764`, 0.000019656155172560513`}],
      "294"],
     Annotation[#, 294, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.0900689224889013`, 0.00007130629498498895}],
      "295"],
     Annotation[#, 295, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.88312875287635, 0.0002454465371662161}],
      "296"],
     Annotation[#, 296, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.686463746643901, 0.0007339369281212509}],
      "297"],
     Annotation[#, 297, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.4860432915466584`, 0.002069576571532754}],
      "298"],
     Annotation[#, 298, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.2805918773805383`, 0.005510503331972162}],
      "299"],
     Annotation[#, 299, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.0777625653700325`, 0.013338545491591877`}],
      "300"],
     Annotation[#, 300, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.8660757636784044`, 0.030738517909204108`}],
      "301"],
     Annotation[#, 301, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.6621131049587163`, 0.06312616262872017}],
      "302"],
     Annotation[#, 302, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.22360968080868548`, 0.9512281980325504}],
      "303"],
     Annotation[#, 303, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.026593227089006067`, 0.9992930502797811}],
      "304"],
     Annotation[#, 304, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.17417867549546823`, 0.9701173736934915}],
      "305"],
     Annotation[#, 305, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.6043774189439008`, 0.07622796396695017}],
      "306"],
     Annotation[#, 306, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.8045806675487748`, 0.03852255420572141}],
      "307"],
     Annotation[#, 307, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.009814875222525, 0.017608811784352536`}],
      "308"],
     Annotation[#, 308, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.212426980740662, 0.0074851580549385064`}],
      "309"],
     Annotation[#, 309, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.4200700453276753`, 0.0028605566955671397`}],
      "310"],
     Annotation[#, 310, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.6174379465345865`, 0.001058416448938486}],
      "311"],
     Annotation[#, 311, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.8185612966062914`, 0.00035468241208953273`}],
      "312"],
     Annotation[#, 312, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.024715605746873, 0.00010633623076462072`}],
      "313"],
     Annotation[#, 313, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2282478127318415`, 0.000029782668118665658`}],
      "314"],
     Annotation[#, 314, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.440637509397931, 7.22483276406418*^-6}],
      "315"],
     Annotation[#, 315, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.645303063092081, 1.6943109452029186`*^-6}],
      "316"],
     Annotation[#, 316, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.847346514630618, 3.728553837379295*^-7}],
      "317"],
     Annotation[#, 317, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.054420925238031, 7.259795823412648*^-8}],
      "318"],
     Annotation[#, 318, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.251220172465341, 1.4159600607321772`*^-8}],
      "319"],
     Annotation[#, 319, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.451774868557445, 2.4718487603280943`*^-9}],
      "320"],
     Annotation[#, 320, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.657360523718427, 3.799402745146773*^-10}],
      "321"],
     Annotation[#, 321, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.860324076723794, 5.5051603188280086`*^-11}],
      "322"],
     Annotation[#, 322, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.828249188976406, 7.511579716688793*^-11}],
      "323"],
     Annotation[#, 323, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.617516049000324, 5.498066402066258*^-10}],
      "324"],
     Annotation[#, 324, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.4170580724043464`, 3.3631022004186224`*^-9}],
      "325"],
     Annotation[#, 325, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.221773218372144, 1.81722686147644*^-8}],
      "326"],
     Annotation[#, 326, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.012528833842495, 1.0178657248962835`*^-7}],
      "327"],
     Annotation[#, 327, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.8135596126929485`, 4.830059234184176*^-7}],
      "328"],
     Annotation[#, 328, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.601906371250036, 2.320496219940086*^-6}],
      "329"],
     Annotation[#, 329, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.3915997217586558`, 0.000010100267264521156`}],
      "330"],
     Annotation[#, 330, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.194119256055541, 0.00003708129765072197}],
      "331"],
     Annotation[#, 331, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9839547700590603`, 0.0001358463527934927}],
      "332"],
     Annotation[#, 332, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.784065447442683, 0.00043030322832731527`}],
      "333"],
     Annotation[#, 333, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.589349247390082, 0.001225104019197755}],
      "334"],
     Annotation[#, 334, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.3806735168400333`, 0.003456127992761668}],
      "335"],
     Annotation[#, 335, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.1822729496700877`, 0.008545801007839523}],
      "336"],
     Annotation[#, 336, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.9711883622067754`, 0.02053584138288697}],
      "337"],
     Annotation[#, 337, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.12437065163140297`, 0.9846509569982554}],
      "338"],
     Annotation[#, 338, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.07069699590842898, 0.9950144043143649}],
      "339"],
     Annotation[#, 339, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.27972417394570886`, 0.9247372707003831}],
      "340"],
     Annotation[#, 340, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.108025199686791, 0.01175154870361398}],
      "341"],
     Annotation[#, 341, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.3188925806577343`, 0.004620451734540011}],
      "342"],
     Annotation[#, 342, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5194847982485737`, 0.0017505878229742782`}],
      "343"],
     Annotation[#, 343, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.714903893275636, 0.000629425443134861}],
      "344"],
     Annotation[#, 344, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9242825188001476`, 0.000193268866128197}],
      "345"],
     Annotation[#, 345, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.1233859809445557`, 0.0000579726050362264}],
      "346"],
     Annotation[#, 346, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.335173463382329, 0.000014763066087642231`}],
      "347"],
     Annotation[#, 347, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.5456143538685714`, 3.469912618334149*^-6}],
      "348"],
     Annotation[#, 348, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7432290605665477`, 8.218040930896111*^-7}],
      "349"],
     Annotation[#, 349, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.95352778755789, 1.6285884922146965`*^-7}],
      "350"],
     Annotation[#, 350, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.153551351169129, 3.217780760569629*^-8}],
      "351"],
     Annotation[#, 351, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.348401792216591, 6.139035777880659*^-9}],
      "352"],
     Annotation[#, 352, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.557211763761501, 9.560804441984228*^-10}],
      "353"],
     Annotation[#, 353, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.755746571926308, 1.5048985293237804`*^-10}],
      "354"],
     Annotation[#, 354, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.966965400384481, 1.9303295397347887`*^-11}],
      "355"],
     Annotation[#, 355, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.999203037841028, 1.399905885019641*^-11}],
      "356"],
     Annotation[#, 356, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.987731895422513, 1.569828789781999*^-11}],
      "357"],
     Annotation[#, 357, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.79041357805724, 1.0808942211622331`*^-10}],
      "358"],
     Annotation[#, 358, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.57849797509248, 7.871173973488072*^-10}],
      "359"],
     Annotation[#, 359, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.380046311018026, 4.657413030337318*^-9}],
      "360"],
     Annotation[#, 360, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.184216749099186, 2.491813953191063*^-8}],
      "361"],
     Annotation[#, 361, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.973789901580857, 1.3869255585448632`*^-7}],
      "362"],
     Annotation[#, 362, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.775551482748754, 6.445012991076194*^-7}],
      "363"],
     Annotation[#, 363, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.562078023215121, 3.086725173451123*^-6}],
      "364"],
     Annotation[#, 364, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.3531399311432235`, 0.000013091499940948195`}],
      "365"],
     Annotation[#, 365, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.156390267757552, 0.00004712063594647708}],
      "366"],
     Annotation[#, 366, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9450433187723917`, 0.0001710969591728417}],
      "367"],
     Annotation[#, 367, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7471603086775387`, 0.0005277490023753667}],
      "368"],
     Annotation[#, 368, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.551899400738299, 0.001485222700227007}],
      "369"],
     Annotation[#, 369, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.3420412071995704`, 0.004147883743119665}],
      "370"],
     Annotation[#, 370, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.144371442347068, 0.010068647584068948`}],
      "371"],
     Annotation[#, 371, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.931466636793035, 0.023979322822471012`}],
      "372"],
     Annotation[#, 372, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.7230971987007386`, 0.05135135496142834}],
      "373"],
     Annotation[#, 373, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.5269161892946674`, 0.09715253118184618}],
      "374"],
     Annotation[#, 374, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.3161378942891075`, 0.17689145965683364`}],
      "375"],
     Annotation[#, 375, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.117548027969773, 0.286816226294488}],
      "376"],
     Annotation[#, 376, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.694433581389781, 0.6174001036937221}],
      "377"],
     Annotation[#, 377, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.49733247051687834`, 0.7808754739428401}],
      "378"],
     Annotation[#, 378, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.28563407404448704`, 0.9216526845719313}],
      "379"],
     Annotation[#, 379, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.08739961646240296, 0.9923904077131035}],
      "380"],
     Annotation[#, 380, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.10821273896406783`, 0.9883582983005964}],
      "381"],
     Annotation[#, 381, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.3184223799900273, 0.9035780268022829}],
      "382"],
     Annotation[#, 382, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.5164435923297612, 0.7658920974907887}],
      "383"],
     Annotation[#, 383, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.9384207309505523, 0.4145202430697707}],
      "384"],
     Annotation[#, 384, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.1349531878438546`, 0.275789126806512}],
      "385"],
     Annotation[#, 385, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.3460829303366455`, 0.16333707717254756`}],
      "386"],
     Annotation[#, 386, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.5437487339391291`, 0.09225856512032919}],
      "387"],
     Annotation[#, 387, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.7387924353859994`, 0.04863561812098432}],
      "388"],
     Annotation[#, 388, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.9484334224323585`, 0.022451613385517665`}],
      "389"],
     Annotation[#, 389, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.1458859807924915`, 0.010003436024441393`}],
      "390"],
     Annotation[#, 390, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.357935824752114, 0.003849310053406081}],
      "391"],
     Annotation[#, 391, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5565217298214296`, 0.0014505632422411362`}],
      "392"],
     Annotation[#, 392, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.7524855327351307`, 0.0005125170352888178}],
      "393"],
     Annotation[#, 393, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9630466212483215`, 0.00015383264308446652`}],
      "394"],
     Annotation[#, 394, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.161419281075287, 0.00004564703650589748}],
      "395"],
     Annotation[#, 395, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.3750269816037815`, 0.000011298878030028203`}],
      "396"],
     Annotation[#, 396, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.5840993146705395`, 2.6372656994975085`*^-6}],
      "397"],
     Annotation[#, 397, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7809832190510733`, 6.185832200528262*^-7}],
      "398"],
     Annotation[#, 398, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.992464409031095, 1.1952120215994578`*^-7}],
      "399"],
     Annotation[#, 399, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.19048166012081, 2.3644470760874375`*^-8}],
      "400"],
     Annotation[#, 400, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.385876809054911, 4.425354785414824*^-9}],
      "401"],
     Annotation[#, 401, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.595869243588501, 6.711596329724359*^-10}],
      "402"],
     Annotation[#, 402, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.793673249435865, 1.0476480586335089`*^-10}],
      "403"],
     Annotation[#, 403, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.994024110338323, 1.4742644807377563`*^-11}],
      "404"],
     Annotation[#, 404, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.889588691455677, 4.138603662363263*^-11}],
      "405"],
     Annotation[#, 405, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.6840150986376, 2.961966736422783*^-10}],
      "406"],
     Annotation[#, 406, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.479150342669013, 1.935717472762231*^-9}],
      "407"],
     Annotation[#, 407, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.282647484774406, 1.0828660380332603`*^-8}],
      "408"],
     Annotation[#, 408, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.078562647402761, 5.965587101885007*^-8}],
      "409"],
     Annotation[#, 409, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.875186646880606, 3.0072441746752576`*^-7}],
      "410"],
     Annotation[#, 410, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.6686929525956966`, 1.427896778782363*^-6}],
      "411"],
     Annotation[#, 411, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.4571682992419115`, 6.446245760290085*^-6}],
      "412"],
     Annotation[#, 412, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.255281054166188, 0.000024994500392071076`}],
      "413"],
     Annotation[#, 413, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.050276115327711, 0.00009104247703613736}],
      "414"],
     Annotation[#, 414, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.8459800133387247`, 0.0003036598989379437}],
      "415"],
     Annotation[#, 415, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.6500458094237196`, 0.0008913772744100272}],
      "416"],
     Annotation[#, 416, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.4465296260316736`, 0.0025149377906844785`}],
      "417"],
     Annotation[#, 417, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.24372227948912, 0.006510821322716618}],
      "418"],
     Annotation[#, 418, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.037797239183811, 0.015723205697003032`}],
      "419"],
     Annotation[#, 419, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.8268412398096259`, 0.03553102873203809}],
      "420"],
     Annotation[#, 420, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.625522648713503, 0.07119562696505477}],
      "421"],
     Annotation[#, 421, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.4210863638546267`, 0.13272360732107288`}],
      "422"],
     Annotation[#, 422, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.2173589158452405`, 0.2271913352450819}],
      "423"],
     Annotation[#, 423, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.59639898066913, 0.7006885783064439}],
      "424"],
     Annotation[#, 424, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.3910425943434218, 0.8582032575908174}],
      "425"],
     Annotation[#, 425, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.18639504486720454`, 0.965853499839913}],
      "426"],
     Annotation[#, 426, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.009890606535032076, 0.9999021806869902}],
      "427"],
     Annotation[#, 427, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.21375823741430847`, 0.9553356024434345}],
      "428"],
     Annotation[#, 428, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.0361710046814032`, 0.34175869848056784`}],
      "429"],
     Annotation[#, 429, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.240958737027511, 0.21438569201759805`}],
      "430"],
     Annotation[#, 430, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.4450376325241276`, 0.12391818129683006`}],
      "431"],
     Annotation[#, 431, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.640754629946764, 0.06774018126576065}],
      "432"],
     Annotation[#, 432, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.84405360684644, 0.03335546323403091}],
      "433"],
     Annotation[#, 433, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.046643746896625, 0.015165220062891263`}],
      "434"],
     Annotation[#, 434, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.252351580709564, 0.0062630521854999295`}],
      "435"],
     Annotation[#, 435, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.4573505776730125`, 0.0023849625392230846`}],
      "436"],
     Annotation[#, 436, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.65398767656248, 0.0008729340165959237}],
      "437"],
     Annotation[#, 437, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.858206754928987, 0.0002832032121357753}],
      "438"],
     Annotation[#, 438, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.061716996446004, 0.0000848936750430346}],
      "439"],
     Annotation[#, 439, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2683449317257747`, 0.00002295261710833761}],
      "440"],
     Annotation[#, 440, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.4800038260744213`, 5.501847409478963*^-6}],
      "441"],
     Annotation[#, 441, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6820253121450057`, 1.2945979177132748`*^-6}],
      "442"],
     Annotation[#, 442, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.8871644919783446`, 2.740246454522603*^-7}],
      "443"],
     Annotation[#, 443, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.0915948349621925`, 5.363047894283093*^-8}],
      "444"],
     Annotation[#, 444, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.28766327987206, 1.037303276766883*^-8}],
      "445"],
     Annotation[#, 445, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.491313704258967, 1.7356240763059733`*^-9}],
      "446"],
     Annotation[#, 446, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.694255291796383, 2.6907452110608105`*^-10}],
      "447"],
     Annotation[#, 447, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.900314573096552, 3.726066455489247*^-11}],
      "448"],
     Annotation[#, 448, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.99721114264768, 1.4280599127325861`*^-11}],
      "449"],
     Annotation[#, 449, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.938660293439095, 2.5550467704361245`*^-11}],
      "450"],
     Annotation[#, 450, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.737214338347421, 1.7943650782154615`*^-10}],
      "451"],
     Annotation[#, 451, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.528824158880746, 1.2374063983270473`*^-9}],
      "452"],
     Annotation[#, 452, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.331346897896216, 7.118520344414312*^-9}],
      "453"],
     Annotation[#, 453, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.131389698250974, 3.866307453369499*^-8}],
      "454"],
     Annotation[#, 454, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.9244882742307317`, 2.0472295423744585`*^-7}],
      "455"],
     Annotation[#, 455, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.7221222176722253`, 9.62055396432754*^-7}],
      "456"],
     Annotation[#, 456, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5096231612285163`, 4.472984343104626*^-6}],
      "457"],
     Annotation[#, 457, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.304210492654706, 0.00001813245775022521}],
      "458"],
     Annotation[#, 458, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.1033331915426317`, 0.00006568257438395759}],
      "459"],
     Annotation[#, 459, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.895511666055558, 0.00022849692426587303`}],
      "460"],
     Annotation[#, 460, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.6986030590506287`, 0.0006874933024805924}],
      "461"],
     Annotation[#, 461, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.4992145133849863`, 0.0019380495777737902`}],
      "462"],
     Annotation[#, 462, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.2928817433443447`, 0.005209316150352862}],
      "463"],
     Annotation[#, 463, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.0910843407654394`, 0.012617964579293314`}],
      "464"],
     Annotation[#, 464, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.8791539383013305`, 0.029269199606547096`}],
      "465"],
     Annotation[#, 465, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.6743099237071206`, 0.06060888856793932}],
      "466"],
     Annotation[#, 466, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.23601455945584582`, 0.9458201235251534}],
      "467"],
     Annotation[#, 467, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.038754504963685446`, 0.998499215649888}],
      "468"],
     Annotation[#, 468, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.16098548818918815`, 0.9744166181624548}],
      "469"],
     Annotation[#, 469, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.5922516819429466`, 0.07924068451782691}],
      "470"],
     Annotation[#, 470, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.7914230211162199`, 0.040389055241356046`}],
      "471"],
     Annotation[#, 471, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.9975385846644917`, 0.01849674705500119}],
      "472"],
     Annotation[#, 472, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.1991187807510277`, 0.007937765933814312}],
      "473"],
     Annotation[#, 473, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.4076432012125633`, 0.00303742310960827}],
      "474"],
     Annotation[#, 474, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.605254703191955, 0.0011279515617900234`}],
      "475"],
     Annotation[#, 475, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.8053461438320593`, 0.00038204697461812273`}],
      "476"],
     Annotation[#, 476, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.012381808847163, 0.00011455629891013904`}],
      "477"],
     Annotation[#, 477, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2148821064005304`, 0.00003246113734767635}],
      "478"],
     Annotation[#, 478, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.4275154038391014`, 7.906211484655909*^-6}],
      "479"],
     Annotation[#, 479, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.633062313407773, 1.8521901150320603`*^-6}],
      "480"],
     Annotation[#, 480, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.834073855514709, 4.128744317580644*^-7}],
      "481"],
     Annotation[#, 481, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.042029621996644, 8.025927822581257*^-8}],
      "482"],
     Annotation[#, 482, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.239072469996435, 1.5697954716988387`*^-8}],
      "483"],
     Annotation[#, 483, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.438595256656939, 2.7791301540906345`*^-9}],
      "484"],
     Annotation[#, 484, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.645062267692442, 4.2599075543985727`*^-10}],
      "485"],
     Annotation[#, 485, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.846993911266209, 6.265673265146802*^-11}],
      "486"],
     Annotation[#, 486, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.84051708947226, 6.67140397953387*^-11}],
      "487"],
     Annotation[#, 487, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.630815858927779, 4.861735197163422*^-10}],
      "488"],
     Annotation[#, 488, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.42947652645728, 3.0132027165244423`*^-9}],
      "489"],
     Annotation[#, 489, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.233948071652597, 1.6394559852606865`*^-8}],
      "490"],
     Annotation[#, 490, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.025735596554549, 9.153475567300087*^-8}],
      "491"],
     Annotation[#, 491, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.82588501953048, 4.396019482012669*^-7}],
      "492"],
     Annotation[#, 492, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.6152636875191684`, 2.1072399858958182`*^-6}],
      "493"],
     Annotation[#, 493, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.4047134372553067`, 9.239030613004364*^-6}],
      "494"],
     Annotation[#, 494, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.2063516156776704`, 0.00003428883786749309}],
      "495"],
     Annotation[#, 495, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9972190391127906`, 0.00012548529614845046`}],
      "496"],
     Annotation[#, 496, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7964483606218913`, 0.00040157211224262583`}],
      "497"],
     Annotation[#, 497, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.6014885597968096`, 0.0011502882374473582`}],
      "498"],
     Annotation[#, 498, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.3938447386783617`, 0.0032454780104900285`}],
      "499"],
     Annotation[#, 499, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.194562815633894, 0.008098260837616042}],
      "500"],
     Annotation[#, 500, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.9845101376021825`, 0.019481684986156877`}],
      "501"],
     Annotation[#, 501, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.1367755302785633, 0.9814663543470571}],
      "502"],
     Annotation[#, 502, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.0585357180337496, 0.9965794332276398}],
      "503"],
     Annotation[#, 503, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.26653098663942876`, 0.9314257829943201}],
      "504"],
     Annotation[#, 504, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.095748909128758, 0.012373929366426976`}],
      "505"],
     Annotation[#, 505, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.3055843806681002`, 0.0049137428497495915`}],
      "506"],
     Annotation[#, 506, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5070579541334617`, 0.001863424070744395}],
      "507"],
     Annotation[#, 507, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.702720649933005, 0.0006723719244270116}],
      "508"],
     Annotation[#, 508, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9110673660259154`, 0.00020876252218007273`}],
      "509"],
     Annotation[#, 509, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.111052184044845, 0.0000626062345197387}],
      "510"],
     Annotation[#, 510, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.321807757051018, 0.000016136822674720694`}],
      "511"],
     Annotation[#, 511, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.532492248309741, 3.8076380921857013`*^-6}],
      "512"],
     Annotation[#, 512, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.730988310882239, 9.005377284899816*^-7}],
      "513"],
     Annotation[#, 513, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.940255128441981, 1.8084772154578242`*^-7}],
      "514"],
     Annotation[#, 514, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.141160047927741, 3.566105847434981*^-8}],
      "515"],
     Annotation[#, 515, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.336254089747685, 6.822092930574806*^-9}],
      "516"],
     Annotation[#, 516, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.5440321518609945`, 1.0779247229920009`*^-9}],
      "517"],
     Annotation[#, 517, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.743448315900324, 1.6913871723980677`*^-10}],
      "518"],
     Annotation[#, 518, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.953635234926896, 2.2032509677284805`*^-11}],
      "519"],
     Annotation[#, 519, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.998804658802358, 1.4054928245274455`*^-11}],
      "520"],
     Annotation[#, 520, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.963196094430804, 2.0039506379571026`*^-11}],
      "521"],
     Annotation[#, 521, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.763813958202331, 1.3936518072917932`*^-10}],
      "522"],
     Annotation[#, 522, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.553661066986613, 9.875153124552889*^-10}],
      "523"],
     Annotation[#, 523, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.355696604457121, 5.7613563641108324`*^-9}],
      "524"],
     Annotation[#, 524, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.15780322367508, 3.1060539592144876`*^-8}],
      "525"],
     Annotation[#, 525, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.9491390879057944`, 1.6860628143700662`*^-7}],
      "526"],
     Annotation[#, 526, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.7488368502104894`, 7.879921339020956*^-7}],
      "527"],
     Annotation[#, 527, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.535850592221818, 3.7183170033137236`*^-6}],
      "528"],
     Annotation[#, 528, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.3286752118989646`, 0.00001541640021290402}],
      "529"],
     Annotation[#, 529, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.1298617296500915`, 0.00005567193228582366}],
      "530"],
     Annotation[#, 530, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.920277492413975, 0.00019784619289478533`}],
      "531"],
     Annotation[#, 531, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7228816838640837`, 0.0006027038170032599}],
      "532"],
     Annotation[#, 532, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.5255569570616423`, 0.0016977729038340746`}],
      "533"],
     Annotation[#, 533, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.0630770607130442, 0.9960291890138061}],
      "534"],
     Annotation[#, 534, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.134599113576628, 0.9820462034524305}],
      "535"],
     Annotation[#, 535, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.778915838283595, 0.0004428084668005778}],
      "536"],
     Annotation[#, 536, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9877142150477423`, 0.0001328305594839962}],
      "537"],
     Annotation[#, 537, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.188150693737909, 0.00003852108339227046}],
      "538"],
     Annotation[#, 538, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.401271192721441, 9.458036766210256*^-6}],
      "539"],
     Annotation[#, 539, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6085808140391564`, 2.2114647228458777`*^-6}],
      "540"],
     Annotation[#, 540, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.8075285372828906`, 5.057246113171431*^-7}],
      "541"],
     Annotation[#, 541, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.0172470155138695`, 9.800242794290877*^-8}],
      "542"],
     Annotation[#, 542, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.214777065058621, 1.9277143679472615`*^-8}],
      "543"],
     Annotation[#, 543, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.412236032855924, 3.509378749311408*^-9}],
      "544"],
     Annotation[#, 544, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.6204657556404705`, 5.350270556267549*^-10}],
      "545"],
     Annotation[#, 545, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.820333580351036, 8.107748400379405*^-11}],
      "546"],
     Annotation[#, 546, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.865052890463969, 5.257714338595766*^-11}],
      "547"],
     Annotation[#, 547, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.6574154787826885`, 3.7974583509500093`*^-10}],
      "548"],
     Annotation[#, 548, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.454313434563146, 2.416590502794212*^-9}],
      "549"],
     Annotation[#, 549, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.258297778213501, 1.3331982782571352`*^-8}],
      "550"],
     Annotation[#, 550, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.052149121978655, 7.394734827724672*^-8}],
      "551"],
     Annotation[#, 551, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.8505358332055435`, 3.6381286712867155`*^-7}],
      "552"],
     Annotation[#, 552, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.6419783200574325`, 1.73586261485121*^-6}],
      "553"],
     Annotation[#, 553, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.4309408682486087`, 7.722632602140688*^-6}],
      "554"],
     Annotation[#, 554, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.230816334921929, 0.000029292642285903008`}],
      "555"],
     Annotation[#, 555, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.0237475772202504`, 0.00010696066469699033`}],
      "556"],
     Annotation[#, 556, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.821214186980308, 0.0003494152591361998}],
      "557"],
     Annotation[#, 557, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.6257671846102646`, 0.0010131881781128074`}],
      "558"],
     Annotation[#, 558, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.16158528757288393`, 0.9742281084619784}],
      "559"],
     Annotation[#, 559, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.034213162284390836`, 0.9988301443417746}],
      "560"],
     Annotation[#, 560, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.6783541632477426`, 0.0007665726951382033}],
      "561"],
     Annotation[#, 561, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.884637060477451, 0.00024332052017778466`}],
      "562"],
     Annotation[#, 562, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.0863845902454248`, 0.00007294755213751326}],
      "563"],
     Annotation[#, 563, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.295076344388397, 0.000019259076240257305`}],
      "564"],
     Annotation[#, 564, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.506248037192081, 4.580166080795019*^-6}],
      "565"],
     Annotation[#, 565, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7065068115136226`, 1.0803853836169181`*^-6}],
      "566"],
     Annotation[#, 566, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.913709810210163, 2.2277033623466924`*^-7}],
      "567"],
     Annotation[#, 567, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.116377441444968, 4.3759231510942436`*^-8}],
      "568"],
     Annotation[#, 568, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.311958684809872, 8.417207626464754*^-9}],
      "569"],
     Annotation[#, 569, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.51767292805998, 1.3687489562432558`*^-9}],
      "570"],
     Annotation[#, 570, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.718851803848352, 2.1346198684367087`*^-10}],
      "571"],
     Annotation[#, 571, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.926974904011724, 2.8672526834911353`*^-11}],
      "572"],
     Annotation[#, 572, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.914124492447386, 3.253777065900236*^-11}],
      "573"],
     Annotation[#, 573, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.71061471849251, 2.3070275103790445`*^-10}],
      "574"],
     Annotation[#, 574, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.5039872507748795`, 1.5486207278915184`*^-9}],
      "575"],
     Annotation[#, 575, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.306997191335311, 8.784958790866*^-9}],
      "576"],
     Annotation[#, 576, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.104976172826867, 4.805933808195319*^-8}],
      "577"],
     Annotation[#, 577, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.899837460555669, 2.4827415969077573`*^-7}],
      "578"],
     Annotation[#, 578, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.695407585133961, 1.1728929897774982`*^-6}],
      "579"],
     Annotation[#, 579, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.4833957302352134`, 5.3734208986014*^-6}],
      "580"],
     Annotation[#, 580, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.014431949214326686`, 0.9997917405308897}],
      "581"],
     Annotation[#, 581, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.860619173746527, 3.3659668467139127`*^-7}],
      "582"],
     Annotation[#, 582, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.066812228479419, 6.564780302589018*^-8}],
      "583"],
     Annotation[#, 583, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.2633678749342465`, 1.2768231858995552`*^-8}],
      "584"],
     Annotation[#, 584, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.464954480457952, 2.1977790426575416`*^-9}],
      "585"],
     Annotation[#, 585, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.669658779744411, 3.3876545564875706`*^-10}],
      "586"],
     Annotation[#, 586, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.87365424218138, 4.835237992760625*^-11}],
      "587"],
     Annotation[#, 587, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.81598128848055, 8.455019189398255*^-11}],
      "588"],
     Annotation[#, 588, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.604216239072869, 6.21548496813292*^-10}],
      "589"],
     Annotation[#, 589, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.404639618351412, 3.752475176806992*^-9}],
      "590"],
     Annotation[#, 590, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.209598365091692, 2.013676888228174*^-8}],
      "591"],
     Annotation[#, 591, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.9993220711304422`, 1.1314710749704971`*^-7}],
      "592"],
     Annotation[#, 592, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.801234205855417, 5.305341605927394*^-7}],
      "593"],
     Annotation[#, 593, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.588549054980904, 2.5544226717838217`*^-6}],
      "594"],
     Annotation[#, 594, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.11196577298424265`, 0.9875419181779777}],
      "595"],
     Annotation[#, 595, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.08285827378310837, 0.9931580201246879}],
      "596"],
     Annotation[#, 596, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.5587364594274016`, 3.161053538540876*^-6}],
      "597"],
     Annotation[#, 597, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.755469810250856, 7.497293998608773*^-7}],
      "598"],
     Annotation[#, 598, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.9668004466737985`, 1.4660766206779215`*^-7}],
      "599"],
     Annotation[#, 599, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.165942654410516, 2.902587394213506*^-8}],
      "600"],
     Annotation[#, 600, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.360549494685497, 5.522739046764597*^-9}],
      "601"],
     Annotation[#, 601, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.570391375662008, 8.47714402196536*^-10}],
      "602"],
     Annotation[#, 602, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.768044827952293, 1.3385667454306335`*^-10}],
      "603"],
     Annotation[#, 603, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.980295565842067, 1.690614546451001*^-11}],
      "604"],
     Annotation[#, 604, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.999601416879697, 1.3943407114357246`*^-11}],
      "605"],
     Annotation[#, 605, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.99386584567044, 1.4765967378070947`*^-11}],
      "606"],
     Annotation[#, 606, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.797063483020969, 1.0141317927071451`*^-10}],
      "607"],
     Annotation[#, 607, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.584707202118947, 7.435834408964263*^-10}],
      "608"],
     Annotation[#, 608, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.386133737658252, 4.415392238369407*^-9}],
      "609"],
     Annotation[#, 609, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.190820130455213, 2.3577490655810856`*^-8}],
      "610"],
     Annotation[#, 610, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.979952604999623, 1.3205824812171313`*^-7}],
      "611"],
     Annotation[#, 611, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.78223014088332, 6.127769468447931*^-7}],
      "612"],
     Annotation[#, 612, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5686348809634465`, 2.945726995914953*^-6}],
      "613"],
     Annotation[#, 613, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.3592561109542887`, 0.000012564921694975354`}],
      "614"],
     Annotation[#, 614, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.163022402284417, 0.00004518656646717216}],
      "615"],
     Annotation[#, 615, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.951234775361996, 0.0001649634375365735}],
      "616"],
     Annotation[#, 616, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7532299648809024`, 0.0005104207157269072}],
      "617"],
     Annotation[#, 617, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.558485011657463, 0.0014360692936694064`}],
      "618"],
     Annotation[#, 618, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.3481861401814736`, 0.004030043339188244}],
      "619"],
     Annotation[#, 619, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.1510323300447713`, 0.009784653550950151}],
      "620"],
     Annotation[#, 620, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.9380057241044981`, 0.023380190226916446`}],
      "621"],
     Annotation[#, 621, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.7291956080749409`, 0.050281530761419474`}],
      "622"],
     Annotation[#, 622, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.53353055338467, 0.09520565305058867}],
      "623"],
     Annotation[#, 623, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.3223115804418493`, 0.17403342234498756`}],
      "624"],
     Annotation[#, 624, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.1242376688383149`, 0.28254700975280217`}],
      "625"],
     Annotation[#, 625, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.7005607439348216, 0.612145453284821}],
      "626"],
     Annotation[#, 626, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.5039755877777194, 0.7756984783956743}],
      "627"],
     Annotation[#, 627, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.2918365133680672, 0.9183574817110781}],
      "628"],
     Annotation[#, 628, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.09348025539974265, 0.9912995120759992}],
      "629"],
     Annotation[#, 629, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.10161614531092777`, 0.9897272874855673}],
      "630"],
     Annotation[#, 630, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.31226646427414817`, 0.9070929578934217}],
      "631"],
     Annotation[#, 631, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.5097717218980817, 0.7711539817396454}],
      "632"],
     Annotation[#, 632, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.9323113388423743, 0.41928498608818976`}],
      "633"],
     Annotation[#, 633, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.128327841019876, 0.2799557520144378}],
      "634"],
     Annotation[#, 634, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.3398982614499277`, 0.16607307925313958`}],
      "635"],
     Annotation[#, 635, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.537685865438652, 0.09399837155268347}],
      "636"],
     Annotation[#, 636, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.7322136121697218`, 0.04975899646860872}],
      "637"],
     Annotation[#, 637, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.942295277153342, 0.022994253464222434`}],
      "638"],
     Annotation[#, 638, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.1392318807976745`, 0.010292775477293048`}],
      "639"],
     Annotation[#, 639, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.3517224026945582`, 0.003963617108694614}],
      "640"],
     Annotation[#, 640, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.550430108150114, 0.001496398980849713}],
      "641"],
     Annotation[#, 641, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.745877956348015, 0.0005314795955881007}],
      "642"],
     Annotation[#, 642, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9568797227984662`, 0.00015955247466255254`}],
      "643"],
     Annotation[#, 643, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.1547364279096315`, 0.000047615037651016335`}],
      "644"],
     Annotation[#, 644, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.3684659288243664`, 0.0000118100143385817}],
      "645"],
     Annotation[#, 645, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.5779789398283857`, 2.7554403434305844`*^-6}],
      "646"],
     Annotation[#, 646, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7743468894931187`, 6.503894873357351*^-7}],
      "647"],
     Annotation[#, 647, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.986268757410401, 1.25578018985372*^-7}],
      "648"],
     Annotation[#, 648, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.184407808886356, 2.487832956327594*^-8}],
      "649"],
     Annotation[#, 649, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.379287003104658, 4.688492871176319*^-9}],
      "650"],
     Annotation[#, 650, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.589720115575508, 7.101600567062996*^-10}],
      "651"],
     Annotation[#, 651, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.787008166707071, 1.1167288495920249`*^-10}],
      "652"],
     Annotation[#, 652, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.993824920818988, 1.4772004123537296`*^-11}],
      "653"],
     Annotation[#, 653, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.895722641703605, 3.8975020130412686`*^-11}],
      "654"],
     Annotation[#, 654, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.690665003601327, 2.782953444657928*^-10}],
      "655"],
     Annotation[#, 655, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.485359569695479, 1.8309141314006112`*^-9}],
      "656"],
     Annotation[#, 656, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.2887349114146325`, 1.027813369698766*^-8}],
      "657"],
     Annotation[#, 657, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.085166028758788, 5.652507553200724*^-8}],
      "658"],
     Annotation[#, 658, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.881349350299372, 2.8668758185493047`*^-7}],
      "659"],
     Annotation[#, 659, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.675371610730263, 1.3595504328276726`*^-6}],
      "660"],
     Annotation[#, 660, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.463725156990237, 6.160257599657131*^-6}],
      "661"],
     Annotation[#, 661, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.261397233977253, 0.000024017882094277545`}],
      "662"],
     Annotation[#, 662, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.056908249854576, 0.00008742860434353706}],
      "663"],
     Annotation[#, 663, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.852171469928329, 0.0002931335959845966}],
      "664"],
     Annotation[#, 664, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.6561154656270833`, 0.0008631264388800659}],
      "665"],
     Annotation[#, 665, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.453115236950838, 0.0024350831729538234`}],
      "666"],
     Annotation[#, 666, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.249867212471023, 0.006333498728793559}],
      "667"],
     Annotation[#, 667, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.0444581268815147`, 0.015301429362344746`}],
      "668"],
     Annotation[#, 668, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.833380327121089, 0.03469070747943986}],
      "669"],
     Annotation[#, 669, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.6316210580877053`, 0.06979539279495382}],
      "670"],
     Annotation[#, 670, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.4277007279446292`, 0.13024612248591605`}],
      "671"],
     Annotation[#, 671, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.2235326019979822`, 0.22379338791601572`}],
      "672"],
     Annotation[#, 672, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.6025261432141706, 0.6955601733417295}],
      "673"],
     Annotation[#, 673, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.39768571160426286`, 0.8537183630725074}],
      "674"],
     Annotation[#, 674, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.1925974841907847, 0.9635857555194645}],
      "675"],
     Annotation[#, 675, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.003809967597692385, 0.999985484252259}],
      "676"],
     Annotation[#, 676, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.2071616437611684, 0.9579919091162649}],
      "677"],
     Annotation[#, 677, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.030061612573225, 0.3461002085751118}],
      "678"],
     Annotation[#, 678, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.2343333902035325`, 0.21793053403878868`}],
      "679"],
     Annotation[#, 679, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.43885296363741, 0.1261482027445328}],
      "680"],
     Annotation[#, 680, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.6346917614462868`, 0.06909885248435736}],
      "681"],
     Annotation[#, 681, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.8374747836301624`, 0.03417319956815318}],
      "682"],
     Annotation[#, 682, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.040505601617608, 0.015550490301158676`}],
      "683"],
     Annotation[#, 683, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.245697480714747, 0.006453341793099081}],
      "684"],
     Annotation[#, 684, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.451137155615456, 0.002458820893232281}],
      "685"],
     Annotation[#, 685, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.6478960548911648`, 0.0009015874477692088}],
      "686"],
     Annotation[#, 686, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.8515991785418713`, 0.0002940920115712614}],
      "687"],
     Annotation[#, 687, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.055550097996149, 0.00008815742675254109}],
      "688"],
     Annotation[#, 688, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.261662078560119, 0.000023976424696230856`}],
      "689"],
     Annotation[#, 689, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.473442773295006, 5.758666045759348*^-6}],
      "690"],
     Annotation[#, 690, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6759049373028514`, 1.3542305725034612`*^-6}],
      "691"],
     Annotation[#, 691, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.88052816242039, 2.885207530304417*^-7}],
      "692"],
     Annotation[#, 692, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.085399183341499, 5.641749749704306*^-8}],
      "693"],
     Annotation[#, 693, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.281589428637607, 1.0927229588915022`*^-8}],
      "694"],
     Annotation[#, 694, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.484723898308713, 1.8413838712728938`*^-9}],
      "695"],
     Annotation[#, 695, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.68810616378339, 2.8505487711813587`*^-10}],
      "696"],
     Annotation[#, 696, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.893649490367759, 3.9774093423850874`*^-11}],
      "697"],
     Annotation[#, 697, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.997011953128346, 1.4309056467666418`*^-11}],
      "698"],
     Annotation[#, 698, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.9447942436870225`, 2.4047499097824448`*^-11}],
      "699"],
     Annotation[#, 699, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.743864243311148, 1.684726053353064*^-10}],
      "700"],
     Annotation[#, 700, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.535033385907212, 1.1696891452096292`*^-9}],
      "701"],
     Annotation[#, 701, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.337434324536442, 6.752611488712273*^-9}],
      "702"],
     Annotation[#, 702, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.137993079607, 3.660845080516991*^-8}],
      "703"],
     Annotation[#, 703, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.9306509776494973`, 1.9504859425958584`*^-7}],
      "704"],
     Annotation[#, 704, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.728800875806791, 9.15353075335755*^-7}],
      "705"],
     Annotation[#, 705, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5161800189768417`, 4.271600716761884*^-6}],
      "706"],
     Annotation[#, 706, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.3103266724657705`, 0.000017413536778428917`}],
      "707"],
     Annotation[#, 707, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.1099653260694966`, 0.00006303097225058741}],
      "708"],
     Annotation[#, 708, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9017031226451624`, 0.00022044088109615412`}],
      "709"],
     Annotation[#, 709, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7046727152539924`, 0.0006653119718998114}],
      "710"],
     Annotation[#, 710, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.5058001243041503`, 0.0018752106804549495`}],
      "711"],
     Annotation[#, 711, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.299026676326248, 0.005064379488504733}],
      "712"],
     Annotation[#, 712, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.097745228463143, 0.012270772748679784`}],
      "713"],
     Annotation[#, 713, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.8856930256127935`, 0.028557428421042672`}],
      "714"],
     Annotation[#, 714, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.6804083330813229`, 0.05938152274583718}],
      "715"],
     Annotation[#, 715, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.24221699877942598`, 0.9430187864925922}],
      "716"],
     Annotation[#, 716, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.04483514390102514, 0.9979918289504135}],
      "717"],
     Annotation[#, 717, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.1543888945360481, 0.9764459013570738}],
      "718"],
     Annotation[#, 718, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.5861888134424693`, 0.08078249751038118}],
      "719"],
     Annotation[#, 719, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.7848441978999423`, 0.041350580836586076`}],
      "720"],
     Annotation[#, 720, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.9914004393854752`, 0.018955224049977154`}],
      "721"],
     Annotation[#, 721, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.1924646807562107`, 0.008173146004468463}],
      "722"],
     Annotation[#, 722, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.401429779155007, 0.003129553350252521}],
      "723"],
     Annotation[#, 723, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.599163081520639, 0.0011642842897187629`}],
      "724"],
     Annotation[#, 724, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.798738567444943, 0.0003964591419815764}],
      "725"],
     Annotation[#, 725, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.0062149103973077`, 0.00011888807097769242`}],
      "726"],
     Annotation[#, 726, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2081992532348753`, 0.0000338848533094209}],
      "727"],
     Annotation[#, 727, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.4209543510596863`, 8.269564818367715*^-6}],
      "728"],
     Annotation[#, 728, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6269419385656185`, 1.9363460781196274`*^-6}],
      "729"],
     Annotation[#, 729, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.8274375259567543`, 4.3440958002645506`*^-7}],
      "730"],
     Annotation[#, 730, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.0358339703759505`, 8.437827814323154*^-8}],
      "731"],
     Annotation[#, 731, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.2329986187619815`, 1.6526886349944647`*^-8}],
      "732"],
     Annotation[#, 732, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.432005450706685, 2.946427801489225*^-9}],
      "733"],
     Annotation[#, 733, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.638913139679449, 4.5101743551680514`*^-10}],
      "734"],
     Annotation[#, 734, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.840328828537416, 6.68357386735058*^-11}],
      "735"],
     Annotation[#, 735, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.846651039720188, 6.286532973172678*^-11}],
      "736"],
     Annotation[#, 736, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.637465763891506, 4.5711381346218115`*^-10}],
      "737"],
     Annotation[#, 737, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.435685753483746, 2.8518209876764913`*^-9}],
      "738"],
     Annotation[#, 738, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.240035498292823, 1.557029309737809*^-8}],
      "739"],
     Annotation[#, 739, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.032338977910575, 8.679145778163712*^-8}],
      "740"],
     Annotation[#, 740, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.8320477229492456`, 4.1933750043443677`*^-7}],
      "741"],
     Annotation[#, 741, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.6219423456537343`, 2.0078092508580346`*^-6}],
      "742"],
     Annotation[#, 742, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.411270295003632, 8.835215811809745*^-6}],
      "743"],
     Annotation[#, 743, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.212467795488735, 0.000032968785533789986`}],
      "744"],
     Annotation[#, 744, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.0038511736396556`, 0.00012058907417050518`}],
      "745"],
     Annotation[#, 745, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.8026398172114955`, 0.0003878895417747739}],
      "746"],
     Annotation[#, 746, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.6075582160001733`, 0.0011144883594519407`}],
      "747"],
     Annotation[#, 747, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.4004303495975257`, 0.003144608552251946}],
      "748"],
     Annotation[#, 748, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.2007077486157973`, 0.007882465094218888}],
      "749"],
     Annotation[#, 749, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.9911710252998862`, 0.01897255055594403}],
      "750"],
     Annotation[#, 750, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.14297796960214343`, 0.9797648355954209}],
      "751"],
     Annotation[#, 751, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.05245507909640991, 0.9972522466807388}],
      "752"],
     Annotation[#, 752, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.25993439298628873`, 0.9346661346906442}],
      "753"],
     Annotation[#, 753, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.089610763849741, 0.012695938441832682`}],
      "754"],
     Annotation[#, 754, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.298930280673283, 0.005066624635808477}],
      "755"],
     Annotation[#, 755, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5008445320759054`, 0.001922318299597852}],
      "756"],
     Annotation[#, 756, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.6966290282616896`, 0.0006948544796902235}],
      "757"],
     Annotation[#, 757, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9044597896387994`, 0.0002169406661637885}],
      "758"],
     Annotation[#, 758, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.1048852855949898`, 0.00006505271370201354}],
      "759"],
     Annotation[#, 759, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.315124903885363, 0.00001686865944574249}],
      "760"],
     Annotation[#, 760, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.525931195530326, 3.988119283863957*^-6}],
      "761"],
     Annotation[#, 761, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.724867936040085, 9.425836757395226*^-7}],
      "762"],
     Annotation[#, 762, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.9336187988840265`, 1.9054892428973613`*^-7}],
      "763"],
     Annotation[#, 763, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.134964396307048, 3.7537306491309946`*^-8}],
      "764"],
     Annotation[#, 764, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.330180238513232, 7.190818032720953*^-9}],
      "765"],
     Annotation[#, 765, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.5374423459107405`, 1.1444026461861673`*^-9}],
      "766"],
     Annotation[#, 766, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.737299187887331, 1.792923153235626*^-10}],
      "767"],
     Annotation[#, 767, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.946970152198103, 2.3535441387448903`*^-11}],
      "768"],
     Annotation[#, 768, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.9986054692830235`, 1.4082944825258608`*^-11}],
      "769"],
     Annotation[#, 769, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.969330044678731, 1.8855035678812994`*^-11}],
      "770"],
     Annotation[#, 770, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.770463863166058, 1.3080342793781217`*^-10}],
      "771"],
     Annotation[#, 771, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.559870294013079, 9.33185514569877*^-10}],
      "772"],
     Annotation[#, 772, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.361784031097347, 5.463589017431934*^-9}],
      "773"],
     Annotation[#, 773, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.164406605031107, 2.9399670444754117`*^-8}],
      "774"],
     Annotation[#, 774, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.95530179132456, 1.6058984638252792`*^-7}],
      "775"],
     Annotation[#, 775, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.7555155083450558`, 7.494721086136385*^-7}],
      "776"],
     Annotation[#, 776, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5424074499701437`, 3.5496890793155794`*^-6}],
      "777"],
     Annotation[#, 777, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.3347913917100294`, 0.00001480073633268566}],
      "778"],
     Annotation[#, 778, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.1364938641769564`, 0.00005340566347595425}],
      "779"],
     Annotation[#, 779, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.926468949003579, 0.00019081226682479937`}],
      "780"],
     Annotation[#, 780, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7289513400674474`, 0.0005830862642384971}],
      "781"],
     Annotation[#, 781, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.5321425679808067`, 0.001642154820594336}],
      "782"],
     Annotation[#, 782, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.06915769965038389, 0.9952286318941849}],
      "783"],
     Annotation[#, 783, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.12800251992348793`, 0.9837488530895936}],
      "784"],
     Annotation[#, 784, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.772308261896479, 0.00045935230239076483`}],
      "785"],
     Annotation[#, 785, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9815473165978874`, 0.00013781141007433237`}],
      "786"],
     Annotation[#, 786, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.1814678405722536`, 0.000040196219035919806`}],
      "787"],
     Annotation[#, 787, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.394710139942026, 9.889302563045532*^-6}],
      "788"],
     Annotation[#, 788, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.602460439197002, 2.3112519374422247`*^-6}],
      "789"],
     Annotation[#, 789, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.800892207724936, 5.319152979054695*^-7}],
      "790"],
     Annotation[#, 790, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.011051363893175, 1.0300039190827545`*^-7}],
      "791"],
     Annotation[#, 791, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.208703213824169, 2.0289085774599052`*^-8}],
      "792"],
     Annotation[#, 792, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.405646226905671, 3.7193434482340512`*^-9}],
      "793"],
     Annotation[#, 793, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.614316627627478, 5.662882226734145*^-10}],
      "794"],
     Annotation[#, 794, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.813668497622244, 8.645436573135798*^-11}],
      "795"],
     Annotation[#, 795, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.871186840711896, 4.952907539267739*^-11}],
      "796"],
     Annotation[#, 796, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.664065383746417, 3.569212652961311*^-10}],
      "797"],
     Annotation[#, 797, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.4605226615896125`, 2.2864569188038384`*^-9}],
      "798"],
     Annotation[#, 798, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.264385204853728, 1.2657939687532217`*^-8}],
      "799"],
     Annotation[#, 799, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.058752503334682, 7.00909688683805*^-8}],
      "800"],
     Annotation[#, 800, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.856698536624309, 3.4693666252717205`*^-7}],
      "801"],
     Annotation[#, 801, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.6486569781919984`, 1.6533653444687076`*^-6}],
      "802"],
     Annotation[#, 802, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.437497725996934, 7.382556159586833*^-6}],
      "803"],
     Annotation[#, 803, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.236932514732994, 0.000028156506172922217`}],
      "804"],
     Annotation[#, 804, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.0303797117471154`, 0.00010275107962246519`}],
      "805"],
     Annotation[#, 805, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.827405643569912, 0.00033740631435210685`}],
      "806"],
     Annotation[#, 806, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.6318368408136283`, 0.0009813659240720232}],
      "807"],
     Annotation[#, 807, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.1677877268964641, 0.9722398737279172}],
      "808"],
     Annotation[#, 808, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.028132523347051144`, 0.9992088742352634}],
      "809"],
     Annotation[#, 809, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.672262541576427, 0.0007919699639991358}],
      "810"],
     Annotation[#, 810, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.878029484090335, 0.0002527641515578822}],
      "811"],
     Annotation[#, 811, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.0802176917955695`, 0.0000757750838200767}],
      "812"],
     Annotation[#, 812, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2883934912227413`, 0.000020125321631134165`}],
      "813"],
     Annotation[#, 813, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.4996869844126657`, 4.795613131548076*^-6}],
      "814"],
     Annotation[#, 814, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7003864366714683`, 1.1304895593451042`*^-6}],
      "815"],
     Annotation[#, 815, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.9070734806522083`, 2.3463770735818025`*^-7}],
      "816"],
     Annotation[#, 816, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.110181789824274, 4.604740878608109*^-8}],
      "817"],
     Annotation[#, 817, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.305884833575419, 8.869528488744404*^-9}],
      "818"],
     Annotation[#, 818, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.511083122109727, 1.4526578846097389`*^-9}],
      "819"],
     Annotation[#, 819, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.712702675835359, 2.2620792650825598`*^-10}],
      "820"],
     Annotation[#, 820, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.920309821282931, 3.061751952178468*^-11}],
      "821"],
     Annotation[#, 821, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.920258442695314, 3.0633003485193926`*^-11}],
      "822"],
     Annotation[#, 822, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.717264623456238, 2.1668302865007621`*^-10}],
      "823"],
     Annotation[#, 823, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.510196477801346, 1.464323803847942*^-9}],
      "824"],
     Annotation[#, 824, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.313084617975537, 8.335861874609794*^-9}],
      "825"],
     Annotation[#, 825, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.111579554182894, 4.552125713197959*^-8}],
      "826"],
     Annotation[#, 826, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.9060001639744346`, 2.3661362960159936`*^-7}],
      "827"],
     Annotation[#, 827, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.702086243268527, 1.1163539859391332`*^-6}],
      "828"],
     Annotation[#, 828, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.489952587983539, 5.133262857461422*^-6}],
      "829"],
     Annotation[#, 829, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.020512588151666376`, 0.9995793222370338}],
      "830"],
     Annotation[#, 830, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.8539828441885726`, 3.5427805596652844`*^-7}],
      "831"],
     Annotation[#, 831, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.060616576858726, 6.903812254564853*^-8}],
      "832"],
     Annotation[#, 832, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.257294023699794, 1.3446427168316449`*^-8}],
      "833"],
     Annotation[#, 833, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.458364674507699, 2.330890226458387*^-9}],
      "834"],
     Annotation[#, 834, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.6635096517314185`, 3.587762173541466*^-10}],
      "835"],
     Annotation[#, 835, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.8669891594525865`, 5.1595663987131615`*^-11}],
      "836"],
     Annotation[#, 836, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.822115238728478, 7.969650559463874*^-11}],
      "837"],
     Annotation[#, 837, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.610866144036597, 5.846038963886402*^-10}],
      "838"],
     Annotation[#, 838, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.410848845377879, 3.5525949211760863`*^-9}],
      "839"],
     Annotation[#, 839, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.215685791731918, 1.9130025995466307`*^-8}],
      "840"],
     Annotation[#, 840, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.005925452486469, 1.0732129648817123`*^-7}],
      "841"],
     Annotation[#, 841, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.807396909274183, 5.062317721767845*^-7}],
      "842"],
     Annotation[#, 842, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.59522771311547, 2.434760145506569*^-6}],
      "843"],
     Annotation[#, 843, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.11816821230782282`, 0.9861333142194658}],
      "844"],
     Annotation[#, 844, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.07677763484576867, 0.994122535062491}],
      "845"],
     Annotation[#, 845, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.5521754066479865`, 3.3120271646269184`*^-6}],
      "846"],
     Annotation[#, 846, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7493494354087016`, 7.849693309352143*^-7}],
      "847"],
     Annotation[#, 847, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.960164117115844, 1.545265617780308*^-7}],
      "848"],
     Annotation[#, 848, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.159747002789823, 3.056240655506696*^-8}],
      "849"],
     Annotation[#, 849, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.354475643451044, 5.822954083980393*^-9}],
      "850"],
     Annotation[#, 850, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.563801569711755, 9.003074789227711*^-10}],
      "851"],
     Annotation[#, 851, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.7618956999393, 1.4193517777421885`*^-10}],
      "852"],
     Annotation[#, 852, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.973630483113274, 1.8065805152869243`*^-11}],
      "853"],
     Annotation[#, 853, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.999402227360362, 1.397120582682098*^-11}],
      "854"],
     Annotation[#, 854, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.9815979451745855`, 1.6688219119926337`*^-11}],
      "855"],
     Annotation[#, 855, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.783763673093513, 1.1519498748721143`*^-10}],
      "856"],
     Annotation[#, 856, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.08131897752506327, 0.993409040182958}],
      "857"],
     Annotation[#, 857, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.800338332164658, 9.827532837380808*^-11}],
      "858"],
     Annotation[#, 858, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.88345474120775, 4.3942893084961674`*^-11}],
      "859"],
     Annotation[#, 859, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.677365193673872, 3.1522162439252887`*^-10}],
      "860"],
     Annotation[#, 860, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.015971245472371765`, 0.9997449518483724}],
      "861"],
     Annotation[#, 861, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.906979655825346, 3.490296467278205*^-11}],
      "862"],
     Annotation[#, 862, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.932526343191167, 2.7145329061727707`*^-11}],
      "863"],
     Annotation[#, 863, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.730564433383693, 1.910970200647836*^-10}],
      "864"],
     Annotation[#, 864, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.032673866026345755`, 0.9989329881413062}],
      "865"],
     Annotation[#, 865, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.853658993995001, 5.873380679086802*^-11}],
      "866"],
     Annotation[#, 866, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.624165953964051, 5.170348840042913*^-10}],
      "867"],
     Annotation[#, 867, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.06461635697108929, 0.9958334307480107}],
      "868"],
     Annotation[#, 868, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.960300317655689, 2.0623720101150677`*^-11}],
      "869"],
     Annotation[#, 869, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.05699642177570451, 0.9967566788707822}],
      "870"],
     Annotation[#, 870, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.04029380122173053, 0.9983777268930042}],
      "871"],
     Annotation[#, 871, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.008351310276986997, 0.9999302580487405}],
      "872"],
     Annotation[#, 872, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.999800606399033, 1.3915662609149274`*^-11}],
      "873"],
     Annotation[#, 873, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.996932820794404, 1.4320377177495765`*^-11}],
      "874"],
     Annotation[#, 874, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.800388435502832, 9.822806651201082*^-11}],
      "875"],
     Annotation[#, 875, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.587811815632181, 7.227069827505569*^-10}],
      "876"],
     Annotation[#, 876, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.389177450978366, 4.2990202193421685`*^-9}],
      "877"],
     Annotation[#, 877, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.194121821133226, 2.2933712428349905`*^-8}],
      "878"],
     Annotation[#, 878, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.983033956709006, 1.2885739614441677`*^-7}],
      "879"],
     Annotation[#, 879, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.7855694699506026`, 5.974852666195528*^-7}],
      "880"],
     Annotation[#, 880, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5719133098376092`, 2.877569070483862*^-6}],
      "881"],
     Annotation[#, 881, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.362314200859821, 0.000012309283978460288`}],
      "882"],
     Annotation[#, 882, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.1663384695478496`, 0.00004424804785571043}],
      "883"],
     Annotation[#, 883, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9543305036567977`, 0.000161974972592411}],
      "884"],
     Annotation[#, 884, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7562647929825843`, 0.0005019572460977997}],
      "885"],
     Annotation[#, 885, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.5617778171170453`, 0.0014120600898395877`}],
      "886"],
     Annotation[#, 886, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.3512586066724253`, 0.003972272080784781}],
      "887"],
     Annotation[#, 887, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.154362773893623, 0.009645353699107953}],
      "888"],
     Annotation[#, 888, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.9412752677602296`, 0.023085520752816547`}],
      "889"],
     Annotation[#, 889, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.7322448127620418`, 0.049753618152379296`}],
      "890"],
     Annotation[#, 890, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.5368377354296712`, 0.09424380115642314}],
      "891"],
     Annotation[#, 891, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.32539842351822, 0.1726168326464363}],
      "892"],
     Annotation[#, 892, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.1275824892725859`, 0.2804268786677838}],
      "893"],
     Annotation[#, 893, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.703624325207342, 0.6095177605020093}],
      "894"],
     Annotation[#, 894, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.5072971464081399, 0.773097277070728}],
      "895"],
     Annotation[#, 895, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.29493773302985726`, 0.9166878516509}],
      "896"],
     Annotation[#, 896, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.0965205748684125, 0.9907270401684731}],
      "897"],
     Annotation[#, 897, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.09831784848435776, 0.9903801701336088}],
      "898"],
     Annotation[#, 898, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.3091885064162086, 0.9088297168966096}],
      "899"],
     Annotation[#, 899, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.506435786682242, 0.7737726317067107}],
      "900"],
     Annotation[#, 900, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.9292566427882851, 0.4216760523637634}],
      "901"],
     Annotation[#, 901, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.1250151676078868`, 0.28205332579761516`}],
      "902"],
     Annotation[#, 902, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.3368059270065689`, 0.16745341488654739`}],
      "903"],
     Annotation[#, 903, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.5346544311884134`, 0.09487792410205832}],
      "904"],
     Annotation[#, 904, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.728924200561583, 0.05032874513304099}],
      "905"],
     Annotation[#, 905, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.9392262045138335`, 0.023269814524756367`}],
      "906"],
     Annotation[#, 906, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.135904830800266, 0.010440221855402918`}],
      "907"],
     Annotation[#, 907, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.3486156916657803`, 0.0040219208498014445`}],
      "908"],
     Annotation[#, 908, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5473842973144563`, 0.0015198148538748534`}],
      "909"],
     Annotation[#, 909, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.742574168154457, 0.0005412046510059386}],
      "910"],
     Annotation[#, 910, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9537962735735386`, 0.0001624870217111455}],
      "911"],
     Annotation[#, 911, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.1513950013268035`, 0.000048629002081839256`}],
      "912"],
     Annotation[#, 912, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.365185402434659, 0.000012073799390112745`}],
      "913"],
     Annotation[#, 913, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.5749187524073083`, 2.8164197092023855`*^-6}],
      "914"],
     Annotation[#, 914, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7710287247141414`, 6.668787160187293*^-7}],
      "915"],
     Annotation[#, 915, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.9831709316000543`, 1.287168674977238*^-7}],
      "916"],
     Annotation[#, 916, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.18137088326913, 2.55184921958285*^-8}],
      "917"],
     Annotation[#, 917, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.3759921001295305`, 4.825715319507918*^-9}],
      "918"],
     Annotation[#, 918, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.586645551569012, 7.304813498498785*^-10}],
      "919"],
     Annotation[#, 919, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.783675625342675, 1.1529206765085057`*^-10}],
      "920"],
     Annotation[#, 920, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.993725326059321, 1.478670525974278*^-11}],
      "921"],
     Annotation[#, 921, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.898789616827568, 3.782163925873228*^-11}],
      "922"],
     Annotation[#, 922, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.6939899560831915`, 2.6974563115909805`*^-10}],
      "923"],
     Annotation[#, 923, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.488464183208713, 1.7806084166339075`*^-9}],
      "924"],
     Annotation[#, 924, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.291778624734746, 1.0013178478215824`*^-8}],
      "925"],
     Annotation[#, 925, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.088467719436801, 5.50200433873158*^-8}],
      "926"],
     Annotation[#, 926, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.8844307020087547`, 2.799088342639374*^-7}],
      "927"],
     Annotation[#, 927, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.678710939797546, 1.3265696228910042`*^-6}],
      "928"],
     Annotation[#, 928, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.4670035858643997`, 6.021863082402453*^-6}],
      "929"],
     Annotation[#, 929, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.2644553238827854`, 0.00002354331689031937}],
      "930"],
     Annotation[#, 930, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.0602243171180086`, 0.00008567299686679937}],
      "931"],
     Annotation[#, 931, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.855267198223131, 0.00028799979971892573`}],
      "932"],
     Annotation[#, 932, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.659150293728765, 0.000849315111339108}],
      "933"],
     Annotation[#, 933, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.4564080424104198`, 0.0023960338507123024`}],
      "934"],
     Annotation[#, 934, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.2529396789619742`, 0.006246479855389218}],
      "935"],
     Annotation[#, 935, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.0477885707303667`, 0.015094300897444598`}],
      "936"],
     Annotation[#, 936, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.8366498707768204`, 0.034276929932517075`}],
      "937"],
     Annotation[#, 937, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.6346702627748064`, 0.0691037094019505}],
      "938"],
     Annotation[#, 938, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.4310079099896305`, 0.12902054310117606`}],
      "939"],
     Annotation[#, 939, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.226619445074353, 0.2221071706247437}],
      "940"],
     Annotation[#, 940, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.605589724486691, 0.6929905512785536}],
      "941"],
     Annotation[#, 941, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.4010072702346834, 0.8514565304153329}],
      "942"],
     Annotation[#, 942, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.1956987038525748, 0.9624261118369504}],
      "943"],
     Annotation[#, 943, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.00076964812902254, 0.999999407641933}],
      "944"],
     Annotation[#, 944, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.2038633469345984, 0.9592915226408675}],
      "945"],
     Annotation[#, 945, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.0270069165191358`, 0.34828185231245545`}],
      "946"],
     Annotation[#, 946, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.2310207167915432`, 0.21971764139267044`}],
      "947"],
     Annotation[#, 947, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.4357606291940512`, 0.12727456661027664`}],
      "948"],
     Annotation[#, 948, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.6316603271960481`, 0.06978644935710622}],
      "949"],
     Annotation[#, 949, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.8341853720220236`, 0.0345884323161901}],
      "950"],
     Annotation[#, 950, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.0374365289781, 0.015746335465892207`}],
      "951"],
     Annotation[#, 951, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.2423704307173384`, 0.006550426292977409}],
      "952"],
     Annotation[#, 952, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.448030444586678, 0.002496531132548622}],
      "953"],
     Annotation[#, 953, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.644850244055507, 0.0009162394551986716}],
      "954"],
     Annotation[#, 954, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.848295390348313, 0.0002996826038076775}],
      "955"],
     Annotation[#, 955, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.0524666487712215`, 0.00008983349632912223}],
      "956"],
     Annotation[#, 956, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.258320651977291, 0.000024504507662764007`}],
      "957"],
     Annotation[#, 957, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.4701622469052986`, 5.891346257105004*^-6}],
      "958"],
     Annotation[#, 958, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6728447498817745`, 1.3850302786343074`*^-6}],
      "959"],
     Annotation[#, 959, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.8772099976414127`, 2.960441122629537*^-7}],
      "960"],
     Annotation[#, 960, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.082301357531152, 5.786319185958736*^-8}],
      "961"],
     Annotation[#, 961, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.27855250302038, 1.1215024088413469`*^-8}],
      "962"],
     Annotation[#, 962, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.481428995333586, 1.8965946653692277`*^-9}],
      "963"],
     Annotation[#, 963, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.685031599776893, 2.933891911411367*^-10}],
      "964"],
     Annotation[#, 964, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.8903169490033624`, 4.109232047220919*^-11}],
      "965"],
     Annotation[#, 965, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.996912358368679, 1.4323305969950655`*^-11}],
      "966"],
     Annotation[#, 966, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.947861218810986, 2.3328842610646515`*^-11}],
      "967"],
     Annotation[#, 967, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.747189195793013, 1.6323907683748385`*^-10}],
      "968"],
     Annotation[#, 968, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.538137999420446, 1.1372002665232057`*^-9}],
      "969"],
     Annotation[#, 969, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.340478037856555, 6.576589118128073*^-9}],
      "970"],
     Annotation[#, 970, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.141294770285013, 3.5621288922151764`*^-8}],
      "971"],
     Annotation[#, 971, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.93373232935888, 1.9037880500372292`*^-7}],
      "972"],
     Annotation[#, 972, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.7321402048740744`, 8.928292276094123*^-7}],
      "973"],
     Annotation[#, 973, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5194584478510045`, 4.174200286512751*^-6}],
      "974"],
     Annotation[#, 974, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.313384762371303, 0.000017064358233105304`}],
      "975"],
     Annotation[#, 975, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.113281393332929, 0.00006174355044949917}],
      "976"],
     Annotation[#, 976, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.9047988509399643`, 0.00021651377981907302`}],
      "977"],
     Annotation[#, 977, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7077075433556743`, 0.0006544730562747347}],
      "978"],
     Annotation[#, 978, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.5090929297637325`, 0.00184449946645483}],
      "979"],
     Annotation[#, 979, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.3020991428171995`, 0.004993289023696029}],
      "980"],
     Annotation[#, 980, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.1010756723119943`, 0.012100373237493862`}],
      "981"],
     Annotation[#, 981, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.888962569268525, 0.02820715561262009}],
      "982"],
     Annotation[#, 982, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.683457537768424, 0.05877555266901795}],
      "983"],
     Annotation[#, 983, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.24531821844121604`, 0.9415940629829803}],
      "984"],
     Annotation[#, 984, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.04787546336969498, 0.9977105647708875}],
      "985"],
     Annotation[#, 985, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.15109059770947808`, 0.9774302269825489}],
      "986"],
     Annotation[#, 986, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.5831573791922309`, 0.08156236902494744}],
      "987"],
     Annotation[#, 987, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.7815547862918035`, 0.04183853573717811}],
      "988"],
     Annotation[#, 988, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{1.9883313667459668`, 0.01918816446789214}],
      "989"],
     Annotation[#, 989, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.189137630758802, 0.008293165257159892}],
      "990"],
     Annotation[#, 990, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.3983230681262286`, 0.0031765691790508316`}],
      "991"],
     Annotation[#, 991, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.5961172706849815`, 0.0011828542761962103`}],
      "992"],
     Annotation[#, 992, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.7954347792513854`, 0.000403854616446933}],
      "993"],
     Annotation[#, 993, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.00313146117238, 0.00012111154553671294`}],
      "994"],
     Annotation[#, 994, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2048578266520478`, 0.00003461879937025381}],
      "995"],
     Annotation[#, 995, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.4176738246699787`, 8.457183394823174*^-6}],
      "996"],
     Annotation[#, 996, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6238817511445416`, 1.9797916495820783`*^-6}],
      "997"],
     Annotation[#, 997, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.824119361177777, 4.455800642122284*^-7}],
      "998"],
     Annotation[#, 998, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.032736144565604, 8.651389399515249*^-8}],
      "999"],
     Annotation[#, 999, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.229961693144755, 1.695715572616183*^-8}],
      "1000"],
     Annotation[#, 1000, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.4287105477315585`, 3.0337173670337798`*^-9}],
      "1001"],
     Annotation[#, 1001, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.6358385756729525`, 4.640636948696637*^-10}],
      "1002"],
     Annotation[#, 1002, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.836996287173019, 6.90263305378099*^-11}],
      "1003"],
     Annotation[#, 1003, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.849718014844151, 6.102333258456748*^-11}],
      "1004"],
     Annotation[#, 1004, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.64079071637337, 4.432272608817965*^-10}],
      "1005"],
     Annotation[#, 1005, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.4387903669969795`, 2.774320673261853*^-9}],
      "1006"],
     Annotation[#, 1006, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.243079211612936, 1.5173411321046893`*^-8}],
      "1007"],
     Annotation[#, 1007, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.035640668588588, 8.451003045942715*^-8}],
      "1008"],
     Annotation[#, 1008, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.835129074658629, 4.095466505880029*^-7}],
      "1009"],
     Annotation[#, 1009, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.625281674721017, 1.959801782785151*^-6}],
      "1010"],
     Annotation[#, 1010, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.414548723877795, 8.63969749654261*^-6}],
      "1011"],
     Annotation[#, 1011, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.2155258853942676`, 0.000032327033748220436`}],
      "1012"],
     Annotation[#, 1012, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.007167240903088, 0.00011820917719521941`}],
      "1013"],
     Annotation[#, 1013, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.8057355455062973`, 0.00038121312679719735`}],
      "1014"],
     Annotation[#, 1014, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.610593044101855, 0.0010969781214045069`}],
      "1015"],
     Annotation[#, 1015, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.403723155057108, 0.0030952549353979388`}],
      "1016"],
     Annotation[#, 1016, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.203780215106749, 0.00777651304107476}],
      "1017"],
     Annotation[#, 1017, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-1.994501469148738, 0.01872237192738464}],
      "1018"],
     Annotation[#, 1018, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.1460791892639335, 0.9788869387994097}],
      "1019"],
     Annotation[#, 1019, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.049414759627740064`, 0.9975611603445833}],
      "1020"],
     Annotation[#, 1020, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.2566360961597187, 0.93625997888525}],
      "1021"],
     Annotation[#, 1021, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.086541691210233, 0.012859708480146911`}],
      "1022"],
     Annotation[#, 1022, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.2956032306758747`, 0.005144669274629135}],
      "1023"],
     Annotation[#, 1023, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.497737821047127, 0.0019524032629747174`}],
      "1024"],
     Annotation[#, 1024, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.6935832174260317`, 0.0007063564584753631}],
      "1025"],
     Annotation[#, 1025, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9011560014452416`, 0.00022114186380414128`}],
      "1026"],
     Annotation[#, 1026, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.101801836370062, 0.00006630968240734514}],
      "1027"],
     Annotation[#, 1027, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.3117834773025354`, 0.000017246353976059223`}],
      "1028"],
     Annotation[#, 1028, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.5226506691406185`, 4.081411241638256*^-6}],
      "1029"],
     Annotation[#, 1029, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7218077486190078`, 9.643100960323764*^-7}],
      "1030"],
     Annotation[#, 1030, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.9303006341050493`, 1.955865050238213*^-7}],
      "1031"],
     Annotation[#, 1031, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.131866570496701, 3.851102178904252*^-8}],
      "1032"],
     Annotation[#, 1032, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.3271433128960055`, 7.382383741082854*^-9}],
      "1033"],
     Annotation[#, 1033, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.534147442935614, 1.179125194177094*^-9}],
      "1034"],
     Annotation[#, 1034, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.734224623880834, 1.8459021728995317`*^-10}],
      "1035"],
     Annotation[#, 1035, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.943637610833706, 2.4324116060323543`*^-11}],
      "1036"],
     Annotation[#, 1036, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.998505874523357, 1.4096973631519272`*^-11}],
      "1037"],
     Annotation[#, 1037, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.9723970198026946`, 1.8288802610876455`*^-11}],
      "1038"],
     Annotation[#, 1038, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.773788815647922, 1.267176596878725*^-10}],
      "1039"],
     Annotation[#, 1039, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.562974907526312, 9.071257725220269*^-10}],
      "1040"],
     Annotation[#, 1040, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.36482774441746, 5.320379303753381*^-9}],
      "1041"],
     Annotation[#, 1041, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.1677082957091205`, 2.860190714012656*^-8}],
      "1042"],
     Annotation[#, 1042, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.958383143033943, 1.5672124690922037`*^-7}],
      "1043"],
     Annotation[#, 1043, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.758854837412339, 7.30899632154147*^-7}],
      "1044"],
     Annotation[#, 1044, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5456858788443064`, 3.4681531072913136`*^-6}],
      "1045"],
     Annotation[#, 1045, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.337849481615562, 0.000014501779935177093`}],
      "1046"],
     Annotation[#, 1046, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.1398099314403893`, 0.000052305637266915176`}],
      "1047"],
     Annotation[#, 1047, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.929564677298381, 0.00018738425712836983`}],
      "1048"],
     Annotation[#, 1048, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.7319861681691293`, 0.0005735024077458218}],
      "1049"],
     Annotation[#, 1049, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.5354353734403885`, 0.0016149802800251604`}],
      "1050"],
     Annotation[#, 1050, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.07219801911905374, 0.9948010078206242}],
      "1051"],
     Annotation[#, 1051, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.12470422309691792`, 0.9845691513897442}],
      "1052"],
     Annotation[#, 1052, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.769004473702921, 0.00046783926336597275`}],
      "1053"],
     Annotation[#, 1053, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.9784638673729598`, 0.00014036743899682142`}],
      "1054"],
     Annotation[#, 1054, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.1781264139894256`, 0.000041059533687356746`}],
      "1055"],
     Annotation[#, 1055, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.3914296135523188`, 0.0000101119281735071}],
      "1056"],
     Annotation[#, 1056, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.599400251775925, 2.362755175814282*^-6}],
      "1057"],
     Annotation[#, 1057, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.797574042945959, 5.454969561274231*^-7}],
      "1058"],
     Annotation[#, 1058, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.007953538082829, 1.0559111965033683`*^-7}],
      "1059"],
     Annotation[#, 1059, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.205666288206942, 2.081423045326747*^-8}],
      "1060"],
     Annotation[#, 1060, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.402351323930544, 3.828865930441548*^-9}],
      "1061"],
     Annotation[#, 1061, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.611242063620981, 5.825807174800795*^-10}],
      "1062"],
     Annotation[#, 1062, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.810335956257847, 8.927210846358614*^-11}],
      "1063"],
     Annotation[#, 1063, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.87425381583586, 4.80706043798451*^-11}],
      "1064"],
     Annotation[#, 1064, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.66739033622828, 3.460172278220597*^-10}],
      "1065"],
     Annotation[#, 1065, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.463627275102846, 2.2239777812746117`*^-9}],
      "1066"],
     Annotation[#, 1066, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.267428918173841, 1.2333464576780206`*^-8}],
      "1067"],
     Annotation[#, 1067, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.0620541940126955`, 6.823663303049257*^-8}],
      "1068"],
     Annotation[#, 1068, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.859779888333692, 3.387847840826625*^-7}],
      "1069"],
     Annotation[#, 1069, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.6519963072592816`, 1.6135448514361708`*^-6}],
      "1070"],
     Annotation[#, 1070, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.440776154871097, 7.217943005555533*^-6}],
      "1071"],
     Annotation[#, 1071, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.2399906046385265`, 0.00002760429674625109}],
      "1072"],
     Annotation[#, 1072, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.0336957790105483`, 0.00010070550629092824`}],
      "1073"],
     Annotation[#, 1073, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.830501371864714, 0.0003315479821999252}],
      "1074"],
     Annotation[#, 1074, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-2.63487166891531, 0.0009658048993924752}],
      "1075"],
     Annotation[#, 1075, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.17088894655825415`, 0.9712192558053134}],
      "1076"],
     Annotation[#, 1076, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.0250922038783813, 0.9993705794727843}],
      "1077"],
     Annotation[#, 1077, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.6692167307407693`, 0.0008049600125210121}],
      "1078"],
     Annotation[#, 1078, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{2.8747256958967773`, 0.0002576141006589721}],
      "1079"],
     Annotation[#, 1079, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.077134242570642, 0.00007722748455037748}],
      "1080"],
     Annotation[#, 1080, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.2850520646399133`, 0.00002057225844059588}],
      "1081"],
     Annotation[#, 1081, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.4964064580229586`, 4.906949365673406*^-6}],
      "1082"],
     Annotation[#, 1082, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.6973262492503913`, 1.1563739042877515`*^-6}],
      "1083"],
     Annotation[#, 1083, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.903755315873231, 2.407984486036168*^-7}],
      "1084"],
     Annotation[#, 1084, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.107083964013928, 4.7234622417434444`*^-8}],
      "1085"],
     Annotation[#, 1085, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.302847907958192, 9.104471968530046*^-9}],
      "1086"],
     Annotation[#, 1086, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.5077882191346, 1.496473302778565*^-9}],
      "1087"],
     Annotation[#, 1087, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.709628111828863, 2.3285691453019654`*^-10}],
      "1088"],
     Annotation[#, 1088, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.916977279918535, 3.163789290292807*^-11}],
      "1089"],
     Annotation[#, 1089, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.923325417819277, 2.972201289479776*^-11}],
      "1090"],
     Annotation[#, 1090, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.720589575938101, 2.099890048465316*^-10}],
      "1091"],
     Annotation[#, 1091, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.513301091314579, 1.4238708249869113`*^-9}],
      "1092"],
     Annotation[#, 1092, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.31612833129565, 8.119771916949342*^-9}],
      "1093"],
     Annotation[#, 1093, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.114881244860907, 4.430148410087509*^-8}],
      "1094"],
     Annotation[#, 1094, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.9090815156838175`, 2.309837913365071*^-7}],
      "1095"],
     Annotation[#, 1095, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.70542557233581, 1.0890784564478304`*^-6}],
      "1096"],
     Annotation[#, 1096, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.4932310168577017`, 5.017077640308617*^-6}],
      "1097"],
     Annotation[#, 1097, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.02355290762033622, 0.9994454143821124}],
      "1098"],
     Annotation[#, 1098, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.8506646794095953`, 3.634520454162782*^-7}],
      "1099"],
     Annotation[#, 1099, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.057518751048379, 7.079634831071357*^-8}],
      "1100"],
     Annotation[#, 1100, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.254257098082567, 1.3798534354959212`*^-8}],
      "1101"],
     Annotation[#, 1101, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.455069771532572, 2.400361060042662*^-9}],
      "1102"],
     Annotation[#, 1102, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.660435087724922, 3.692101185823665*^-10}],
      "1103"],
     Annotation[#, 1103, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.86365661808819, 5.3296220422274955`*^-11}],
      "1104"],
     Annotation[#, 1104, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.825182213852441, 7.737298735122355*^-11}],
      "1105"],
     Annotation[#, 1105, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.614191096518461, 5.6694462778894*^-10}],
      "1106"],
     Annotation[#, 1106, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.413953458891113, 3.456583590540219*^-9}],
      "1107"],
     Annotation[#, 1107, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.218729505052031, 1.8645171283434857`*^-8}],
      "1108"],
     Annotation[#, 1108, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.009227143164482, 1.0451844379315023`*^-7}],
      "1109"],
     Annotation[#, 1109, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.8104782609835657`, 4.944871967968965*^-7}],
      "1110"],
     Annotation[#, 1110, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-3.5985670421827534`, 2.3769681781309422`*^-6}],
      "1111"],
     Annotation[#, 1111, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.1212694319696129, 0.9854013339783109}],
      "1112"],
     Annotation[#, 1112, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.07373731537709882, 0.9945775630940336}],
      "1113"],
     Annotation[#, 1113, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.548894880258279, 3.3900873459956335`*^-6}],
      "1114"],
     Annotation[#, 1114, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.7462892479876246`, 8.031830995817658*^-7}],
      "1115"],
     Annotation[#, 1115, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{3.9568459523368666`, 1.586397560452178*^-7}],
      "1116"],
     Annotation[#, 1116, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.156649176979476, 3.136000818433536*^-8}],
      "1117"],
     Annotation[#, 1117, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.351438717833817, 5.978961686597663*^-9}],
      "1118"],
     Annotation[#, 1118, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.560506666736628, 9.277850312383357*^-10}],
      "1119"],
     Annotation[#, 1119, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.758821135932804, 1.4615131836232665`*^-10}],
      "1120"],
     Annotation[#, 1120, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.9702979417488775`, 1.8674509883979913`*^-11}],
      "1121"],
     Annotation[#, 1121, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.984664920298549, 1.618583939035763*^-11}],
      "1122"],
     Annotation[#, 1122, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.787088625575377, 1.1158689411610249`*^-10}],
      "1123"],
     Annotation[#, 1123, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.08435929699373312, 0.9929087712709856}],
      "1124"],
     Annotation[#, 1124, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.797005790800261, 1.0146932732374073`*^-10}],
      "1125"],
     Annotation[#, 1125, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.886521716331714, 4.264570782656231*^-11}],
      "1126"],
     Annotation[#, 1126, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.680690146155736, 3.055644957177926*^-10}],
      "1127"],
     Annotation[#, 1127, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.01293092600370192, 0.999832805131307}],
      "1128"],
     Annotation[#, 1128, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.903647114460949, 3.606295253308599*^-11}],
      "1129"],
     Annotation[#, 1129, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.9355933183151315`, 2.6336076048915645`*^-11}],
      "1130"],
     Annotation[#, 1130, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.733889385865557, 1.8517705071682282`*^-10}],
      "1131"],
     Annotation[#, 1131, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.0357141854950156, 0.9987253100626932}],
      "1132"],
     Annotation[#, 1132, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.850326452630605, 6.066424128800475*^-11}],
      "1133"],
     Annotation[#, 1133, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-4.6274909064459155`, 5.013723440224539*^-10}],
      "1134"],
     Annotation[#, 1134, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.061576037502419446`, 0.9962155706763347}],
      "1135"],
     Annotation[#, 1135, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{4.956967776291292, 2.131671657717547*^-11}],
      "1136"],
     Annotation[#, 1136, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.06003674124437436, 0.9964020777899726}],
      "1137"],
     Annotation[#, 1137, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.03725348175306068, 0.9986131406767434}],
      "1138"],
     Annotation[#, 1138, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.011391629745656842`, 0.9998702391914}],
      "1139"],
     Annotation[#, 1139, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.00685028706636223, 0.9999530746681362}],
      "1140"],
     Annotation[#, 1140, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.04179482443235529, 0.998254717430665}],
      "1141"],
     Annotation[#, 1141, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.03117284281572099, 0.9990287258631582}],
      "1142"],
     Annotation[#, 1142, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.01747226868299653, 0.9996947664203197}],
      "1143"],
     Annotation[#, 1143, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{0.01901156494104161, 0.9996386257099164}],
      "1144"],
     Annotation[#, 1144, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.02963354655767591, 0.9991222383767245}],
      "1145"],
     Annotation[#, 1145, "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{-0.005310990808317151, 0.999971793774437}],
      "1146"],
     Annotation[#, 1146, "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292114233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193603668],

Cell["\<\
Show number of evaluations required to find a root as a function of starting \
value:\
\>", "ExampleText",
 CellID->105210518],

Cell[BoxData[
 RowBox[{
  RowBox[{"evals", "[", 
   RowBox[{"sv_", "?", "NumberQ"}], "]"}], " ", ":=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", " ", "=", " ", "0"}], "}"}], ",", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "sv"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"c", "++"}]}]}], "]"}], ";", "c"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141472929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"evals", "[", "sv", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"sv", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->914315252],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW89rHFUcn+7M7Katyaaircf4F6h/gPQgVkotpYp4KAXXICQHrcT00l70
oL3US3JpQMyhUWjtIcVSESqIhWBAGpAsiApSoTQHg2DpIVBYP9/v582b2Tez
u9Ok3cymEzaz731/vc/3+2a+7ztvZo82pifee78xPTneGHttqvHhxOT4R2OH
Tk2B5O/yPO8a/s8856HdQkv/r7Va+E4en8exApYvPV9khOp5QhtFW0iVBE+a
nXiR3gjaQQe9egYv0qsbm36G3pDKjckxiDmeV3NkR5y+n9IYdSSqTv8pB1mQ
slB3JFwMdadfyUbdF2+Gt2yhSN64FtJY9jkSYUY85HwKc3sRGg3Xcm/0QQfN
3qj93GN2Q53UdLHlQ586k9o00lfGSE8cvWNBj6K8VDPfdfNdNd+jDn8kB99P
8JlPkpnQvVIWHoL6uhzCmz/9Nf/lL/x8c/lX702V3YPjZUkTKS03Pz7dg+/2
e9nrKH/qg29Xbt0x/HOf/fjd9d/y6LvX89BDjr9V/Ltt7GUGj0qvSlcoQE/e
6DxDj1D6SUfgngtRxuqOKEsr/5iSS4Io76Qy1cbGA9Pf6/Qll+yXE746/u6V
pOW5C8vPCt2/ffvfhGxSlyvQ+vp909fVAOyqRZSsBKQfVzDIB2fPfC9N1hTH
j100VjRf+8gRb7/1Nbz1npFDeHr6uh3ohxt/evuF6h85PE+q0QJndmapZa/H
kycuYaA4DhCGmxiL2G3GczMxMSK4GCXGePDluQTGCjLZi0oH0Lt3/4tRQA8B
jFGAb7IIUUAYJFgrFIpOZ23QVxSZNdkTNHoZ8TLiO9HnKPtvb47rVZVtPxrd
N5C1rYoVj2vVvXsbYGBUpftoJNEHzdU10PGBYa0C/auLTVLMKolBsZwK6wXl
w+zkxKKwDiifTghLcQUAjWHBgjeKfBgQAOfVV76wyzCWVQpgFQcdY6PB2c2O
csg+0ENJCwsJhBlbYFTktsBn4GPvgAVjQt56x9pELBzA4SWlARPaQtNaxre1
DGeizYp6VMO48PGP3/8BnZMEZF4VfPrQtibH2Bn8NHYdNQM7z4ckdnNGNLRv
q7kYp9WwODF9rajYy8SZdV8tZ6kahSQ/RUAb3XEGBY/q8ADgK+4sD0L0io6v
nN2dii+5shR3ltN7wEXP2V0QQxD22xCjAyMwaBCjBZLu/KlZVDN2fBxRKNSE
LpWFixtywgpVj4VWEr3a242aDMTZmSXrwycf32BZoj4kq7BKF3983UphSYgi
DppfLax4FbFQg8WNjQf4gAT8oOmMKC44YJ0BBAChP7Qk9t9RfxABTi79GWLc
rD9ooAvjOmLIkDE+GssotjyRTayp2u5Z272AqaIrUUShpTOhXjHc/EMbNAHG
/XXrDyxMtVibJ+twWqSWGKMWR8AHjDATYVZVVUykyYoqflZZBGT2LrdwMYvW
1zJWg46snMVBR9bp/rU4szpYa0HmE6StIIXg8WMXDVIv4P7N3IVlHP2cOFHj
8KFRF5y676UdVDHcmTH4mqtrFh/a4LXhO3niEsoR2Cc+7ksdOTxv8UGHG1fU
2fv5+ZtUIwMFHaRBgWF0l3/+m3Hr+TzOPiHmRJrax6nifBaHsT7jIs3T0WyY
WSc/3jPU/h7WUpBi+QtZxpfjqkedKt9CYq2auW6/zouALPuJe4msF7JyFncC
snIWBzVWnd4eKE7MBml96rzrohiqlF1fvw89lAto0BdUFeYZm8Vm3jwhNtQf
LjbDJzYoH9RnaHxFZXZmCXUQsaGbY6ZDIkOTxZmRivd3LC5TDRIX67k2XIYf
RPJ8AciTN3uUODmxCJVz5tlg3tmN8XFI8ybSJvCYvr1DIBivGxp7xfYJRc6Z
eqwYMnNoH8fud8y3298y1jt/7OiZTXR99zPmue5H+5jf/EJmertShyu37hAF
rMhuAlHYV1wNinjXxXf4RMFFOuY3V9euLjZ7oUjXNvbplfepM+6+LByPza77
9NHflJXs+nwzVoqAofQktmJOa/NXeSRnS/p3LPl+DTHY49hMJDW4eSud9plD
Yvtxf7N+LGxJL5p6zzRlpq8oKf2bSG/X/37X5Xs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->673608619]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235936811],

Cell["\<\
Compare evaluations required for different local minimization methods:\
\>", "ExampleText",
 CellID->594874201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"e", "=", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"method", ",", 
         RowBox[{"Norm", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"x", "-", "1"}], ",", 
             RowBox[{"y", "-", "1"}]}], "}"}], "/.", 
           RowBox[{
            RowBox[{"FindMinimum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
               RowBox[{"100", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"y", "-", 
                   RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", 
                  RowBox[{"-", "1"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", 
              RowBox[{"Method", "\[Rule]", "method"}], ",", 
              RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
               RowBox[{"e", "++"}]}]}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "e"}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"method", ",", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", "\"\<LevenbergMarquardt\>\"", ",", "\"\<Newton\>\"",
          ",", "\"\<QuasiNewton\>\"", ",", "\"\<Gradient\>\""}], "}"}]}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Method\>\"", ",", "\"\<Error\>\"", ",", "\"\<Evaluations\>\""}], 
       "}"}]}], "}"}]}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167838670],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"Method\"\>",
       HoldForm], 
      TagBox["\<\"Error\"\>",
       HoldForm], 
      TagBox["\<\"Evaluations\"\>",
       HoldForm]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "Automatic", "0.`", 
      "17"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> 
        False]& ], "\<\"LevenbergMarquardt\"\>", "0.`", "17"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "\<\"Newton\"\>", 
      "1.5700924586837752`*^-16", "25"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "\<\"QuasiNewton\"\>", 
      "1.1289725930244963`*^-10", "45"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "\<\"Gradient\"\>", 
      "1.6694651003513968`*^-9", "251"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$, 
    TableHeadings -> {{}, {"Method", "Error", "Evaluations"}}]]]], "Output",
 ImageSize->{322, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->5788114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688891567],

Cell[TextData[{
 "Compare evaluations and timing required for different ODE integration \
methods in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24971481],

Cell[BoxData[
 RowBox[{
  RowBox[{"evals", "[", "method_", "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"e", "=", "0"}], "}"}], ",", 
    RowBox[{"Timing", "[", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
            RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
        ",", "x", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"100", "\[Pi]"}]}], "}"}], ",", 
        RowBox[{"MaxSteps", "\[Rule]", "Infinity"}], ",", 
        RowBox[{"Method", "\[Rule]", "method"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"e", "++"}]}]}], "]"}], ";", "e"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48126008],

Cell[BoxData[
 RowBox[{
  RowBox[{"methods", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "Automatic", ",", "\"\<Adams\>\"", ",", "\"\<BDF\>\"", ",", 
     "\"\<ExplicitRungeKutta\>\"", ",", "\"\<ImplicitRungeKutta\>\"", ",", 
     "\"\<Extrapolation\>\""}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99922964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", "method", "}"}], ",", " ", 
       RowBox[{"evals", "[", "method", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"method", ",", " ", "methods"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Method\>\"", ",", "\"\<Timing\>\"", ",", "\"\<Evaluations\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->411642616],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"Method\"\>",
       HoldForm], 
      TagBox["\<\"Timing\"\>",
       HoldForm], 
      TagBox["\<\"Evaluations\"\>",
       HoldForm]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "Automatic", "0.532`", 
      "4489"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "\<\"Adams\"\>", 
      "0.5150000000000036`", "4489"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "\<\"BDF\"\>", 
      "1.594000000000003`", "10513"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> 
        False]& ], "\<\"ExplicitRungeKutta\"\>", "1.8440000000000019`", 
      "13411"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> 
        False]& ], "\<\"ImplicitRungeKutta\"\>", "2.8120000000000007`", 
      "20894"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> 
        False]& ], "\<\"Extrapolation\"\>", "1.219000000000003`", "10251"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$, 
    TableHeadings -> {{}, {"Method", "Timing", "Evaluations"}}]]]], "Output",
 ImageSize->{274, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->246350706]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232538888],

Cell[TextData[{
 "Steps and evaluations as a function of ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->56703436],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"se", "[", "method_", "]"}], "[", "g_", "]"}], " ", ":=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s", "=", "0"}], ",", 
      RowBox[{"e", "=", "0"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", 
           RowBox[{
            RowBox[{
             RowBox[{"x", "'"}], "[", "t", "]"}], "/", "10"}], "+", " ", 
           RowBox[{
            RowBox[{"x", "[", "t", "]"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", " ", "+", " ", 
              RowBox[{
               RowBox[{"x", "[", "t", "]"}], "^", "2"}]}], ")"}]}]}], 
          "\[Equal]", 
          RowBox[{"Sin", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ",
          
         RowBox[{
          RowBox[{
           RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
       ",", "x", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", " ", 
       RowBox[{"PrecisionGoal", "\[Rule]", "g"}], ",", 
       RowBox[{"AccuracyGoal", "\[Rule]", "g"}], ",", 
       RowBox[{"WorkingPrecision", "\[Rule]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"g", " ", ">", " ", "8"}], ",", 
          RowBox[{"2", "g"}], ",", "MachinePrecision"}], "]"}]}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"s", "++"}]}], ",", " ", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"e", "++"}]}], ",", " ", 
       RowBox[{"MaxSteps", "\[Rule]", "Infinity"}], ",", " ", 
       RowBox[{"Method", "\[Rule]", "method"}]}], "]"}], ";", 
     RowBox[{"{", 
      RowBox[{"s", ",", "e"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184235911],

Cell["Use a fixed order explicit Runge-Kutta method:", "ExampleText",
 CellID->275573270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"erk", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"{", 
      RowBox[{"g", ",", 
       RowBox[{
        RowBox[{"se", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<ExplicitRungeKutta\>\"", ",", " ", 
           RowBox[{"\"\<DifferenceOrder\>\"", "\[Rule]", "8"}]}], "}"}], 
         "]"}], "[", "g", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "0", ",", "20", ",", "2"}], "}"}]}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->261711727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "31", ",", "405"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "67", ",", "873"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "105", ",", "1367"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "191", ",", "2485"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "327", ",", "4253"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "562", ",", "7308"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "953", ",", "12391"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "1662", ",", "21608"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "2968", ",", "38586"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "5289", ",", "68759"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "9413", ",", "122371"}], "}"}]}], "}"}]], "Output",
 ImageSize->{468, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258436870]
}, Open  ]],

Cell["Use an adaptive order extrapolation method:", "ExampleText",
 CellID->453749698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ext", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"{", 
      RowBox[{"g", ",", 
       RowBox[{
        RowBox[{"se", "[", "\"\<Extrapolation\>\"", "]"}], "[", "g", "]"}]}], 
      "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "0", ",", "20", ",", "2"}], "}"}]}], "]"}]}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->349793003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "13", ",", "197"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "51", ",", "938"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "114", ",", "2518"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "128", ",", "4081"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "156", ",", "6743"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "186", ",", "9764"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "224", ",", "13390"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "232", ",", "16748"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "256", ",", "21209"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "289", ",", "27230"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "312", ",", "33235"}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->104918246]
}, Open  ]],

Cell["\<\
Compare the two methods.  Beyond a goal of about 12, adaptive order is \
clearly superior:\
\>", "ExampleText",
 CellID->28267790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"erk", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"erk", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", " ", 
     RowBox[{"ext", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"ext", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", "Red", ",", "Cyan", ",", "Blue"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->582538748],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWM1PE0EUH9oFm9AqRqNGPly4wY0bfiXrReBgOOqNNERSDqJBOJqQ2KQX
DyR6qomL3ryT9EgM3AyBA7ceOPhHmJCQcT7evpm+zk4X22qT7vbNvo95v/fm
N9N9Vt6svHxV3lxbKYfzG+U3lbWVt+HT1xtiKD/AGNsT3407TPzm4pf67nEu
7vb1gbjmxaNJuOfEPSfu90BmgVKDz4QQAksrrx4+llepzNVH2bLAyFrf1hgn
cp7IY/IyqGW8Ki8ysQF571PkcaeHfkedsGR3pg8B8alssYwG2E1mimD7mcwW
adCOxKBz2JBtl4bjI5hbyE03Jb2Xg9bLQdfZz3XXtffybTK/uhq9pUZrag4V
cf2sRm+K65ckJ9BpKJ1YXEvE0yCRg//8/F/HKxI578T7Uyatel9HdSX5wYGi
uz2oNozu7MjRarV1tNmUo8fHMNrNHIZ50mucy1774NEKlVahg1bj9DQ6O4tP
TrxaIjO+vS0z82o1m3x3V2aqtYZ4K+cn64tWX+d6hfv4gLF2fqByr/zcTWos
cxY1fteFXylqf7XDQ1m1o6Ou/LXPMzw/l3W+uIBVZLpjvadxBHtFnMe4Wk1/
rWO1KYu6qj3t9GZmvezssDkSU2sB99YU91Y4myGVK5JYJRJryfIShtJLoYBe
sOfHSGzbqtFQnB6jFa6BsQ55UnnWmfdzEptiT71MebzQuaRXlHq94fS6dUkv
gaeypmaLHbx6vWDNXhAvgVUzXqtJw0qF3Sc1s7uKh6HUKhRa2bzRkKNxnMLm
CySbJZ8WztarhbNza2nWaz1HU8b1M69a75kZIgtjwD41vy9hnvkB+0G/4oTB
L1ko9ht6x6Af9TCuFGHPfP8zGjmOVw6SeFjHXsZrX7+mE/oVB3Y+Rahyfeid
Cg5a6kM7Kq2zwJMiVbmGtCfau6AlSDSK5Jqi9XNz4ipB3auFmLm13Ocs2LEB
hoSDDC7rHqskZbRCDHxWCQRolYqJm+G3CCZeLcTErTVNsnfPe9qdLWK07LFq
yxYxclvNdcDEvT9VCSZurTmS7SLByGdlsi+R7DVXy1Vhn4CHnV4MGiWChvYi
T1b+f8oFIi8QvLrzY7Chu1vQlV+DHt0PvX7b3ggk/zMWCJp0/7y813YONnta
hBW2eVD6Chx8COc43Km09VVLKz2m2W+01TWIRbVXSbVmM2ibGmjtEaJF/7lr
q0b5e8T24ydfkzMexnQzCnAx9nWRxPZaYRcXSX3dVlUyIx83mBn4tChbGd/u
syiwLHLBKInltUKMRklsrxVi5Mak+7cfVZKTxqsTv1VJTtrq8nxRJVn+rZ96
H+3U+cpio6yxqEzf3X4kyAeIvO/8leIFK6G9XM9mhbhrqzRGqeNTe/QbT3hF
2mhJv09lA38AT5PmfQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->126972637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->509487615],

Cell["Evaluations in parameter space for a nonlinear fit:", "ExampleText",
 CellID->153970289],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.18", ",", 
       RowBox[{"-", "0.13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.84", ",", 
       RowBox[{"-", "0.06"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.24", ",", 
       RowBox[{"-", "0.63"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.67", ",", "0.93"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.65", ",", "0.92"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.99"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", 
       RowBox[{"-", "0.04"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", 
       RowBox[{"-", "0.55"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37843928],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"model", "[", 
    RowBox[{"{", 
     RowBox[{"w_", ",", "p_"}], "}"}], "]"}], " ", "=", "  ", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "0.1"}], " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"w", " ", "x"}], " ", "+", "p"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->67367124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"fit", ",", " ", 
    RowBox[{"{", "evals", "}"}]}], "}"}], " ", "=", " ", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"model", "[", 
      RowBox[{"{", 
       RowBox[{"w", ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "p"}], "}"}], ",", "x", ",", " ", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"w", ",", "p"}], "}"}], "]"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->236963337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "\[Rule]", 
      RowBox[{"-", "0.020866101917849378`"}]}], ",", 
     RowBox[{"p", "\[Rule]", "0.34132510991572085`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.6837224987546646`", ",", 
        RowBox[{"-", "0.13761442456480055`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.9772746814156097`"}], ",", "0.44561313292741034`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.061493299549043146`", ",", "0.31080011651922534`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.027639056310519314`"}], ",", "0.34316705937294495`"}],
        "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.020309448441028985`"}], ",", "0.34115712470230586`"}],
        "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.020912126633883057`"}], ",", "0.3413388892327804`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.020862295429729893`"}], ",", "0.34132396955047195`"}],
        "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.020866414226024716`"}], ",", "0.3413252034734049`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.02086607377733785`"}], ",", "0.3413251014856732`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.020866101917849378`"}], ",", "0.34132510991572085`"}],
        "}"}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{510, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->574753334]
}, Open  ]],

Cell["\<\
The evaluation points on a contour plot of the sum of squares:\
\>", "ExampleText",
 CellID->224781459],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"residual", " ", "=", " ", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "x", "}"}], ",", 
        RowBox[{"Evaluate", "[", 
         RowBox[{"model", "[", 
          RowBox[{"{", 
           RowBox[{"w", ",", "p"}], "}"}], "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"data", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "]"}], "-", 
    RowBox[{"data", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"residual", ".", "residual"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Point", "[", "evals", "]"}]}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->374183641],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0XQd4VFXanlQSCElmMjPJpCcTd9eCu6Ji9xysa1cUG7vKKmLFtWJdZa1g
W9vadS1gBdeKBVRQzE8URRCiSBCjIRpJgIQQCAnhv5s773ee97u7eXwen5dz
55ZTvl5qzvrrmHPSQ6HQgbWh0H/+r//embRy9qSVrYZxj+Aj7q/z/kuzPJ4t
eIfBC/IsXx8W7P9F1e/jgi/+D5ydUPcrF9z0n+FJVer+NYLrBv+hVj2vTuFQ
yD4zZ7+q95oMvpdxj2B8L49nC8b38vVhwfhe/n1cML6X71cuGN/L968RjO/l
59UpjO9tV9/brr63XX1vu/redvW97ep729X3tqvvbVff266+t119b7v63nb1
ve3qe9vleze8u+iib+7YJN/LuEcwvpfHswXje/n6sGB8L/8+Lhjfy/crF4zv
5fvXCMb38vPqFMb69qv17Vfr26/Wt1+tb79a3361vv1qffvV+var9e1X69uv
1rdfrW+/Wt9+tb798r0LDxl765sb0yy+l3GPYHwvj2cLxvfy9WHB+F7+fVww
vpfvVy4Y38v3rxGM7+Xn1SmM/ZxleT9nWd7PWZb3c5bl/ZxleT9nWd7PWfK9
/Pu4YN7PWZb3c5bl/ZxleT9nWd7PWfK9jEOhkhGHnNRXkyvfy7hHML6Xx7MF
43v5+rBgfC//Pi4Y38v3KxeM7+X71wjG9/Lz6hTG+c2zfH7zLJ/fPPleHs8W
zOc3T74XmM9vnuXzm2f5/OZZPr95ls9vnnwvMJ/fPPlexqHQW3c8el/N7wrl
exn3CMb38ni2YHwvXx8WjO/l38cF43v5fuWC8b18/xrB+F5+Xp3CoFdhRa/C
il6FFb0KK3oVVvQqrOhVWL6Xfx8XzPQqrOhVWNGrsKJXYUWvwvK9jD05baDw
mkM/KpLvZdwjGN/L49mC8b18fVgwvpd/HxeM7+X7lQvG9/L9awTje/l5dQqD
PscUfY4p+hxT9Dmm6HNM0eeYos8xRZ9jij7HFH2OKfocU/Q5puhzTNHnmHwv
41Ao8/Kp488/uVi+l3GPYHwvj2cLxvfy9WHB+F7+fVwwvpfvVy4Y38v3rxGM
7+Xn1SkMfpRQ/Cih+FFC8aOE4kcJxY8Sih8l5Hv593HBzI8Sih8lFD9KKH6U
UPwoId/Lz2tM8ZtFKfmsU7D/+37B/vvkWmD/+QUKxwQP3u6IEsFHDv5DmWD/
fSqtfr6//9bI84HxfB6PCMbzgfF8YDwfGN/v07NOeT5wavdbYHwvMJ7P4zHB
g3BljWD/fZKC8Xx/PXrle4HxfGB8PzDeh38fsfz7SnV9tWC8HzDeDxjz4fO3
kMX7AeN9gPE+wJh/YMw/MN6Pf18tGO8HjPny6XGGxfsB4/2AMX/AeF9gvC//
PqLGY4LxPcB4H59+DJHnAeP9Thp31e9fvyVfrv/w3Kvu/HV4WMaB8f7AeF8e
jwjG+wBjfoExv8B4/tKa3W+8fkVEng+M9wfG9wPjecB4HjDWi69PCsb7t65c
d1n+jKjcHxj3B8b78/XVgvE8/n1SXV9gt/7z5YlPXxKX5wPj+cD4HmA8n6+v
FoznA2N+84+fePrI/UtkfoGxnsB4P2C8HzDmAxjvB4z34/tVC8b7gK+xvrFI
6A/oIa7T9Bj/zvyhSehViP4yLd8/W9H7TKvpOX7J+ozmN01C73A95ov5VUSu
Z31H86cm4Q+4H+tDmn81Cf/g9y3/H/ytSehvSP0x/+mR+ef5bZf5ZX6Rrfhd
QQBr+5zml9pep/mntt9pfqr5G8aB8XucR/59Uj2/1Wh+qO1dPN4T4NfMr9IU
f+6X+2E/af6ux7X9T/N/bQ/U8oC2D2r5QPNnfp9KZS+sVr+vDtgL//t6OPuh
lj+0vRTvg/ln/gx5uNew/OvmW8sv2r6o5Rdtb9TyjLY/snxSEsC4HucP43we
nT1Sz7+2T2p5Sdsrtfyk7ZdanmL5pdVoeUbb/3i8R65n+RTXZ1otn2n7J69n
ptgb2Z7i5Dm2V0bU/SMyjv3M8ltMxtne4uRBbT/V8iHLX1UBeZHlv5qA/Mjy
XG1AnmT5sC6wPlq+0/ZKHu8JyKMs/6VZLZ9inO0fGcr+4eRVXI/zwfJmNCC/
8v3jAXkW42wvcfItxtl+kiHrw+9TpeThVvV9jWaXn7cffnfHUJk/PT96Png8
HPh+vl9UxvH9GMd6AGP++feZcj3mGxjvz/J7a0CeZ/tgv4yz/lQoz8M461Nu
XMv/uB7fD8z6V6GMa32BnxdR18fU/WMB/QLjrM8Vyn7AOM6nni+tf2j7IY/3
BPQjtkf2i76C/cL6Tqayd+YF5pP1m4KAfsL3j8vvmb45+yrGcV6AQW80xu/B
H3i+kzKO+eP3aTSsH4VCWp/DOM6Xni/W96KB79X6n7avan2Q7aOVAf1Q63Ns
j622/P416vnVAfus1je1vVbrn9p+i/fBfuL3y1TvG7V8fSRgj9X6rLbPav2W
9cmqwPxoe63Wf7X9VuvD2p6r9WM8H/uF9eN+o8fZftpvWP/MVPpyptX6LsaZ
nzn7L89HQcAerPV3bR/W+jyej/Oo9XttL9b6vrYfa/1f25NZ/281Wv9m+2so
xOM9AXsB22/71e8zA/ZlPd/a3qztDdq+rO0N2t6s7Q/a/qztERjHfuT7JwP4
v9ujm0Q/C9FfptX2B9Y3S0S/xHzqeA+tj/F4o+gvrK+6eAqWx8MB+ZXl80ol
L1cLZn6QZvl9s2T92R8P/TRL1pOvj6jxmGDMDzDbw7PUfs1V+yVX7q/98yxv
pSn5KVvhHiUfpSn5IVP5Z/MC8o+WX7Q/V8tXzK9zhb+yPT+s9Bvn79TyC/sP
OwXj+Zr/af+n5geg16yfO3+ips9MHzMVPYsF6Befzzqr6Q/b+9IC9jq2B+UK
5vlz+qiON9H6jdY/9H5g+S+s5LtoQD7FevH5c/Ifyxdp6vuzLdPf5tR5W576
/m7B/v1hL8N4QrD/PkWp89Em1wPj/v58bJT7Aw9Ox6Ttgv35zbKMCwXjecCD
95+eFOw/f1jq/G2V3wMPDjdUCx6cjlG1gnE/YLyvP/9pFu8LjOcBY36A3x18
QJlgf/0rBWN+/PMBut8tGPcHxvcAYz6Acb+DT56Ys3hKWO4HjPcHxnwD43k8
XigYz+Pr45aflxCM9zmlsLZ//NFFcj0wrgfGegBjPfTvL/xs1fqu4pj8Hhjz
C4z1Juy9/423PPrTLT/FZX2A8XtgvP8DB479Jv7vEpkvYMwXjxcKxvsB43nA
/nmsT9GjuXJegDGO8+bTw3YZx/oC++/fK9j/3hzL1+cL9u9XrMYTgXE83/++
UhnH9/DzYR9uFnoAjHHQB9wf4/g+n79tkO8DxrimFzyeLvTAlzfCMo71B8Y4
rsf7YRzz79PvzbI+wBgHvcD5wjjeBxj7BRjrAYz9o8dxf7wvjU+pCWB6n45a
S+/vnSdgjOv39/nTgOwnTe8wjv3F9C9fjVcEMK4f5FeRah5vcBjjdH/v+zCO
+Qf9w/7w+V+60D9gjON6fB/GsZ+A8X3A+H49jvthfTAOzM+Lyjgwv3+x5fdP
WH7/Yrke3+/LS9ny/sD4/n2umZqf/XihfL/mBxjH+wLjvOhx/B7vw/yiVDDe
75jdD0l/ZGJE6Ckw3gcY38vjxUL/cX+MY//S/b39rcc1//hLx/ZNO46MyvyD
P+B5GMf7AGNc8xeMY78Sf/L2K8bB3+j+3jiux/tiHPN/5Qtz2uZsi8n8M7+K
yji+DxjjuB7nj8crBWMc1+N7aLzBYYzjeqwn+BvOB/PDfDvtL1etOqahWPgl
MMZxPb6Xry8VDP6jx/n5FTKO7wXGOK7H/gyl/lg/1vx5kYofcPya/fPp/4Pf
LlL8dpEab1LxXMuF3+K57O9z/Jfjv5y/G+Osz8SEH7M/aKPwW+2vZv7ULeO4
nvllmuX7pYv9Aeur/cmsL9Qp+T+p+CP8K44fsz90mPJ/5gf8ryTvT6lR/t3a
AD+l+01x/lDYN1h/qAvoF9q/zPpAp2H+0GvYv5ir9IlcxY8qxD6D86n9fZpf
sj+r3mj7iNZP2P/WLvwH5539Z8OU/zE/pX/mCH1if1yR8C+cB/59KMTj6Zb5
W3pAf8E4nqcx86tWw7hR8aduFb/WbrR/ROs/7H8IhXA/2HPBn/h7Hb8DP8D+
4/vVBfQljON63A/nR/NDtvcXC2Z64ug/2e+nOHs99hvHY1czf/PkDabHvQH9
CuNYTx4vUPS7SNnboypezcVb43zw9S7eDe8PjOvZ/uT0Q2B+33aj7dWa/2n7
tdYf2X5dGrDva32S7csVgd/jfcAvNH9k+3u72I+xXhwP0R6wz2p5NKT+tP7K
/Ot/5Ys6fRT6Ib4Hv8f743p+X6fv6fgvrZ/iepxXto/XB+xXWr/D7/F8jmcq
DMRP0fOmJ9V4KAR+gfOh+anWJ3V8Ecaxv/l+lQF9C7+HfMrf5zDG8XvQH61f
av2Rr+8Wfob50voX+Buwjt/B/bB+Wl/C9TgfzE8rBfvz5fRJptfpyh+dLvSc
9Sv4VzOVvxnvkx/QH1lfK7TMP4uUvyIeOF/gn+C3+D3m84y9x+547QUFls9D
ocwn+B/eB9cD83hcML4f/A73Bz/D/YFxP2B8H4/Hrdb/6HnefiJ+Ol3HC9Qb
zT/ped7+xjgw+CH2s/ana30S/Jflaac/af6o/dX4PdYb/IPtPcVyf22f1P5b
rb+x/6NZ5e/UG22v1P5OrU+xv7SS9SNvPoD97+sX/yXn73WKvM30M1PoDecP
9Yo9CfSK+Y22fy4S+x/oPzD7J3ICmOOXh6nfl/4Pe+ciFQ/cLPwBGPtbY45H
Lg7YPzk+ul7F7/Yatk/2Gs1vWH9Kl/nH9Rw/26/0u37hLyy/bxSs7ZN4PrBe
b4onnp4M8Dtcz/LpRsEcj9wcsK/y/ki3ml/yeL/R/I6+t8HlB0H+w++BNX9k
/a1e7o/9Cf7F+oHT73g83Wqs+Yf2LzE/Tah40FLFP0vlepxvjTketpLjVxuC
9leNOT6gORBPCv6E9dH2V1yP9WX9NN1qzPGdWVbzX/aXZQX0T9Zn82Wc40ly
hV+xfl2k9Nu4un9CPb80gLU8AX7O/oYhSh/IEX1GY5ZHMlX8Qr/k12M/Mj/v
FIz50/EJnD/fK/IFMNuLc0SeAGb9vNjy8+qNthczf2+UcTxPY45XzFL+8hzl
v8xR8aLpAXmF/e/5yr+ZH5CP+H7FKv4yarW9m+WVdhXvWM/2Au98kb/Uw7gf
6JO2L2McWN+P4xsrlT28MqDPc3ylsz/j+zleo1jkE7bHIZ6r27C9t1vkE6wn
xrEeGnM8Q71h/bHXgL+yP7Rd+AvT63TBOJ+g19Avtb9H6798/vIF43zy9VGr
7Vc4L8CQ1/E8lo/zFa5T+7NO+ZdbVb5Vs8grwBx/llD254rUfV19LNwP9Brz
DYz5Zv3e6f1an9b1ili+yFLyR5bIB2xfdPEfrL/3GK0Pa35O+vN0Hf/WKfFx
eF/2P/YIZnnM1dPheLm4ZX9qPKCvsr23UsXLNQfq43B+RLfR/j9dH0froxw/
V2j5/nGJX+Lznq30IZcvwvws22r/JPY7+++dPqrrm3A8fpHiL0VyPd4X1+P9
WL+Nq+t7lH22O2Dv1foux9NlqXisYYH6JRzfXWhZXy6U61l/CKv94eK9WJ8v
VfZspz9jPcA/MD9av9X1RtieWBSwt+p4ZI6XjSt6HVf201CI6X0lx+9Od/Gx
mG/W/9KV/yYroM8JnRkcd3U9mB7NVfRpkdjnOB83Kvog+8+aVL7ocqFvTF/D
Qi/BD0AvgbV9kv1xjap+XbPR9kqt73H+Y05An2L/VrvR+rbOd9T6FOlHUp+j
V/gFxduJfdblTWv+q+17rO9ElX4SVf4vV78M54Ht1cVKvypm/t7g/GPYbzp+
k+PtckT+Br9kfaRU5es1q/y4TsPyebvI/8Ba/gfGfuHxLFs7tPbYBUOGyvsf
ecOje/7y1HAZB2b7gZMvOJ+rWMkjxWo8XcUL5wfkXV1PCeOQvyj+pEPVW5qi
82GqBEMeBT0D1vHIHG9coeL/KgL1iDgfIl/5d/KV/6hEMOaH4x+KA/kXeB74
O+RjYPZHJVT+RamyF5Yqetqt6i30CvbfJ6LyE8KB+AqOl06oeAyXL4H14vzg
dLYXePPL8dH5AflXY9YnXT0zfA/4FdM3p8/p/QiM78PvgdlfG1XxIdHA/LJ9
JUv59zNVvHG1ZftkleInlcreWG1Zf61mecCjT1p/ZH9Fp4rXi6r7xwRDX+L4
xsZAvCXoEe6v6R3HE5UE9ifHI5Wp+KIiZT+OKP9ntfBrtr/NlfgQGpd6FHOF
f3M8aa3wX3+8TtlbW9V89Cj/YYnwT6wn12Nw9Y6Yf/eq+Xf1QzkeRccDJgL+
KZ1vzPpjv/AT3I/tbQnhF/i9zvfV9Qt1PrGuv6jzh3U9Rs4/jlh9f85/CAfy
abX8D3kW86/r/eh6fpy/0mo43qJHxSOmqfPVb1gezhT+gvfl3zt7DMfXROV5
bD/plHp5eJ7On4Q9Bu/H+XbZil/VqXiFZIB+cf5aofADnEcej6l4gFqh/z79
rFHxBMNE/sU4+0uSih5miXzL79Mm9gfGlXJeOR90jbLHt6n4KpePwvaBMuUf
qWR/h/gHN8rvmd4nBIN/63wTyJuYX50PwvJk0mr7N+gt5ovpb6WS/6qVfFgj
mPfDEJFHRy1YNfrkr4fJ/gDG84HxfMYxOd+gj8CYX643UCkY7wuM9+X7JS3T
n2axN+N92X5QqOwJ1UJPcH+2HyQVvWkxt32x6rDR74dlfdi+XCkY+43in5cm
LX6P94N8ivnk+OUsjvfyfv/Y7Y/u+/WtRfJ7HS/F+S25Kj+6QDDeH9fjPACz
PyYuzwP/xvOYn2cpe+8w5v8N1Zwv4z1P24fB3zF/zP/blf80R/g3y2vNyj7b
LP5Gkl/EH7VB9E/Y/yBPcHxLcSCfgOPtu1LrlyH6j9bXoF9hPoExjv2J+7O/
pELxt1KOV/DGwQ/SBr+vzL5bufvvdt0rtX7e90K+wvwC4/u0vR18GO8Hewbz
p+VCH0P05+RXXM/5NxHl344oe27M8vXFAaz9wbgfzq+2j+j8QC2P6fwejhdu
VfaMPEXv85W+U6zir8qUP9bFW+H9dD4I2yMiAXsG+yNiajyh7COoh5Eu8oL2
r0IexP6DvQD0lXGa1fZb5keFYm/A92gMfoH9hXHsP2C8n8b8+3S5H+gPrge9
wDi+D+cP3weMcT6PrYJxva53o/2dfP9Oo+OnmB7kB+zVGMd8YRyY7S2RgD2X
cabybyaVPFpvWJ5sNpzP0m4436XbULyxxOdFhD5xvZEKFd9VEaBfFH/cUK3s
Oyo+64ik8kf2Bt6H3z9dxVfFAvmhXG8kIfQR+gSuh7yA8RSVDOTn8Hi34Xis
3gBm+1C60p9zVD5PrtKnCxQ/LVPjjv9iP7P/r9Fwfkunws4ehO8DvwA/B+Z6
Rs1iD9b0W9en4HzwThXPGrY6/4HjJWLK31QWiIfk+gyNKp6iUegL5pPHe4Te
gP4xPclWuEfJo5lyfsE/ND3Q9RzYvhpR57XRsL+mMXBedT0Giv/3MOePVVh9
fnW9et6f/Ybtn5lqv8WUfbRb5UNlsjwm9lNXv43l66iyf5UG/F2cb9iV2n9L
UvIB6uP8nNp/TSl61ZV6/kBqP3Wn9DXwD/gzulLzhfiiJtEH/PfLtKHV6xr+
dHhYxqOPvvzBukiRfWCQnsXsq6PH7nrOCTGRz/YfXjsj8nI8NY74wZm+/DGq
XDCuBx5cj3Gwf/6QklfaUvEtnSl9F/XN1qX8zaHU+ehJycvg31tS5294av/2
yf38/ZaeoqfrA9indyn/7zjEr6TiocclBON+mC+8X09a+KsH/oL43SLBWC9g
zA9+7+/H2Wbo3EWf7DACdr4Wc+/Lc+zQpyPyPIwP4slJC4z3mz7hqj2euDCa
un+V/d2JE1+f8n2qXlRZ0lZOnvrOO1sQTxO2H/cV1m4uT9XXj8QUrrIj/3DI
K0csiMn9IH9z/vtM2U8cT9aW4gdZMh/A/vpk8Pd78339hu1HX72sUDD2H+g7
78+2QH05zIf//qX8vR4/g745eN463H70369CMPYX9p//vlsM9hvWx6cH2Sn6
syTFX3IsztuKIybO/OfmfJE/8P64P9YX+4PW8/Fqi/OG9cb34PzhvGH/NL69
KDbtlxJ5H2DwX8jz2O8+/1hhsD7++v2Uoi/FKXn+1xS/6hN6gvnA/OD84bwB
g95gPXz5DfU50yzoD54PfRPXs/7ZlIqPcvXXWR/tV/Jzv9JPM4Wf4f1/+s0h
z5+xqkDmC+uD98N6YL6wf8B/eX67BGO/4X54f9A38Ceijx69xftAXga9AL9h
frZJ6APsDTgH2B98f+ffB73C+mI/Yz1xvrB+mA/t/+Z44ViKX7n4X+6f1GnY
X7tezsvg4221nE/IE9q/CPsu9ifoFfgJ23ecPxH0FteD/h3/f6semX5liewH
pqeVPH891XJe/f1aIucP+xXX+8+vtGxfqFH24GoZh/yN9fO/t1auxzjHpyXl
euy3/25/dv0Qdfw+26OzRH7l/jJrVH1l18+P/UuVMo7v1fZrjMNeA3mJ4582
iD2C/VNxdX1c5XslxP7B/Y86Jf6D7QubhJ5z/a0esWdz/Y4ieR7kOWDmh/1i
P+L4vapAPgHHo8WVPU7hcQk5X8Acr5kUDH2R/WW1Kl67TjB+r+PhdH80XQ+Y
7evO/o7nafu87pfG/rkeZS+JqnpyceV/SwhmejRU3o/t6TUBezzHh9cG7PPs
v6tT79MasLdwfHePsoemW45PqVL10Jy9Hu+j7fm6H5m271M/M4+fsnxaK/YU
6LsUn75UyZNSD9vFM5N9vS5N7A+cfxBV8UMuflrnV+t6IzpehOqLeOsLjHGK
Z/HkVegjwFRf1dPnOT671bB/sVHV20O+fVzWk+3L2h4SCoH/w97D9ue6QD0O
ys+S/DlX7wL0meuFbxR9DvIY5o/qw0l8c7/QG7bnRgRjfnS9N45vrVT0oVow
9qeuP4nzzvVEXb1Jzq+oVPEwuaKv43rW/5sN27syZb39+Sy0WA+8L+X/RVAv
81PD8cc6vw38Y4no15BfIC9Bfgfm+NVOA3mM5atc4Qf+/IUD8YMUj+jpJ5DH
IM/487Vd7A8cr58h8jPmj+Mt8gPjnG/Ur/Jl+gz0M4zDPgH9EvIR9hfWC9+n
6/voekScfxET/RX2FzpvnrzI+k+9yp9w9XEwX4u+XVc2L71E4ud0PTrOFwgr
+Sus/P2uHzT717F/ZhvoU5g/rL+/XgOG9csc5e/JUf7+iJK/SlU8QSnLY1Nq
2F8o9V3aVD8whym/UuITm2W/w76C74G8hP0AesT1TZz/ieNzKwL+SvZnVUj8
EegPxrm+ywbD8ZBuXPdX4fp4aXy+6sIqnqEgIP9xPHBxAHM94RIZ53jITbJe
Wn7U+Rp4P8w/5D9g7t/RJfYs0AOOx8gQ+REY1+N8QB/H/IMecD5UKn9Q6p8g
n7BO5V8WqHgsxJc6DH0e8wd9nuNZXf4g18+pVONVgfxG1veLxH8Gfk/ykNT/
Q3zEgFl80dQ3FoXzRX5jeStD7DuYb/ZnxxR/i4r8B/4AjP3C8mix8qcl1O/L
5HrMD8axn/j3lXI91pfjoyst+wsbxR4CesT1S/MD/i72x1VwvJq3X8h/52HK
35pSo+JXawLx0hzfli3PB/+B/QCY7f31Eo+G9eT6d+1Kvms3FN9R12m0P0Dz
l8N+3f7Uyn84+ZHrs1Wp+OMajlfzvh/XQ14Hxvdz/Zqkih+NKf9+o8rP7jf6
PMLeDQz7LPg3+8f7ZD9A/uf48qSqjxeT+YB8q+sxUDy7J9/y/oqyPDsd+chd
Ir/ivEP+Ivu91LueK/o+7DPAkP9gf4N/wR8fKv4FzI9/PrZJfC2977xajmfy
sPaXwJ4OfkP6gbfPIZ9gP7G+4Orpwt4E+RYY9iz8Ht/H/pi5Kl+/U74X/B38
hOOBmgzLd02qv2SzjOP84fuBdX0ujAPT/Hnzgf2D7+N4TWVvmxIX+Rryl/aH
YT3ZPpKy/4yrFPka+4H9OVo/rlf+yCViH8Z6a/0U/hPQA2CM4/zgeZTfMDkp
6wt9HZjz7zrl+1jf6FX2rnrRDzFf2N/4HmDwO+wH2FsxjvMB+QGY7Us5luNd
cjl/xzu/+L0/H6gnnSP0h9bDw/APsXzt/JfQV4ApX31Mjawn1gP6CPxd7E+L
yXoBc/5KvsqHbhF7P84HMPgD9ifkUawX9HuMc/5mSJ4Pfwrnv+QI5vr7mSp/
slDVly3k+BZPf2b/Y9Ry/qLLl4S8wvGNxVy/zdvf7C9pkv0JrO21ev8Sveoo
l/MK+U7L65yfk2PZH5Em8g74LfYH1h/+No5fdvGIoOc4H1gP8DvQW9ZHlqv6
Ks4fQP0tvHGKl2xwmOnLp4b9Pa4+Ottju8R/Bv7I8W2bZNw/j8WiXwND/sH3
czyR+l7pd7/GMH1qVvWHmsQ/GFJ/rN8WyPWcP+zyTYGxnjofn/XJFgN/JfY7
MNu7N6vnufxMzn8PifyBcepP4MkvGAfm/hnNRud/sDweV/K60wfwvizvR1W+
c5HQO2Cdr6jtwVyPZLbheO06rg+91PmngXU/LrbXRTnfY3qS7bV1NYH8a/Ar
7Bfos5gP0m+nJVL2b5fvivXA/mB9MSH6JdeXdPGfFA81Lqri36Ps711aZH87
LTFxa6PLl8f3Q37h+PYEx6uPS4g9G/QIGPwKePDxtsoet+3eYyovdvPL9cuK
lLxYxfkwDUH7KPOjMlUvxmHIlywfthtdH5TyKSetN5BfIG/AXua/fz7TS6En
y1V8susfzfHyhZblfxdHyvRkrrLnzRV5CPFVwJw/l63ydfIDmO11BTLO+XBt
Qq91/xXOV+8K2N+o3se4qMgLOC9s3+oU+xD2I8dvZyr+mSH2ZWDmpxmB/q/c
v8DZp4G5Xlaa5fjwNLFHA1M++fSiQLwIxxsllL2qVMmTpYF8Qs4valHxJS2q
vkimivfNEHrK8+Hyb8k+sdLVw/DpT0TOC+i3rvfI+RJJ7kfg6VOQb8F/yZ9m
qzn+yVazPcTbLzpeTNvftT6q6zFCHsDvOf5P9dubUqP6y9RwPOWUGnV9WNUL
dvnZWE+255cG8rW5P16n2D9Af2DvAOb87HzFn9NUvHqahX0QGPZAYN2fjPMn
+wzxYw9TP6uI6+8F+qz7e4F+gt5QPYlIoYpXzLd8/gsEg17gvEAfo3hjjx/B
HwN5heKlpZ6bk+/5/VoU7jaa/jG93GRgjwH9A8Z+pHjI2W18/ynhwH6BPQH8
F3iQvz1ean+Zsd+HD84sFv2U/QFDRd/gfAzUz3f1tiG/4zzgediv4IfYf/he
tr+kq3yidOEnvL/WCX0G9udzIFDPmv0JIcv8xMXPYlz3/9H9u1gebhH+gvXX
+4vtc/UiT/rXR9jf1BFR8YgR0SdwP4yDnnO+UJth+bBN+UvajfaH4PeYX/6e
dEvxwh3pKfrtxsG//PsND9hXtX+C443zU+cL47n2ybLdl6x+MDdl/ylK0XPX
D4DrB842Op5Y1wtm+22f+G+xXzm+tEr5azMs24ecvQLzBX8c++83yvmBfxBY
1zPj8U2qPusW4c+cr50r/hTOb3CY48WGyH5kfcjpL+CPoCe4H9ezr2T/8bhK
ka+BdT1hig+R+rjLJZ4MGM9HfC4w4v+BtT7M/utOVT92vcRzAut6SETPQq7e
EJ7H8WdRJf+5cdA7yH/+/YeIPQ/jJM8JP3H13LheUJdhe2CnYNAr8GPYN1h+
2iL2Q9iTgHF+SZ7bsdr+7f2jHxlYWSTXU3y+d25IfovE2J5vq8U+w/GSqK/s
7Dcs3+eIP5DjG1pVPfkWsc9CvmR/T4TtEx79xHqAH7C/MV38gzjPn/7j5Xcz
dhku66vr6XN+0jBVvyEcsC/q/k+6vwX3s85X8VX5ql9FTNnTHQa9o/0r9V9C
Qh8xH2zPdP1ZNL3Q9gvW16Ocb+Gth+5fpeVbrC/mH/Ij+AX0I453W67iTRdJ
Pg32E74P/hXMP9vrCuV9mJ47/sfx3Onq/Oen7A/O38b+3y0qX6NXMNefyhZ+
CXmI1z9L7NH4HqwHy8NRztfz1gPyHdaT/bP5yl5QELAncv3sQuX/S5f3x/yx
fhGyrF+E5DyB3nK8cJvh/Imw2LuwXzCO7+X4e1f/evA8tiRS+TNu/TheL03J
Jy6+j+l9yn41Impbws/+duqTrt4jx+cVKlyq9MlSOR+QL3B+fPm7yubdliiY
uYfrrwb+ies5v6VG+cNzxN4B+QnyLOQRYH7fDNGXwI+wH0gfEn8a7H0DhvPj
+gVzPGFY7OXsP2xV/YDaDPQDnCfWPzYJf+Z4/X7xV2J/YpzrB2aKf8J/f4ex
P7h+dIbYF3A9MPYP8lWAOd97uOV4pHwlT0dUvENEzif2P53fUeWKnw6V8wDM
9QdmG45PGc76/PThQr+4vnKO5f0C+1CuyC+QJyk+YnoR+2c9fo71grzC67eJ
81+kHnSO0E/MNzD3o0wLrB8w9BNfvnH5VqBH2G80X+MS8ntgih+b5ugJ7sf2
NpdvCEz80rrz7b9frewXYPg/Bu9flmT/e12Y5QGPLoHfY7/oeEnoh9hvGoO/
Qj6C/sb6p9PnEL8GrOsBa/8i+Aefj+3CP4BBb+n8j4ty/I8nr2O/g3+Q/0rq
LYVlP5J/fHqRqpedy/aLUK7QT9Bvrl9cKucH9AH3Z/3Z6ZNsf6lme5bEdy5X
+UbLJV8Y+g74E8uTVYLBHyj+S+rN9gr/1PYajt+MCMb+0fyY+W+mqmeVIfwU
6wuM74e8gvfleJ2qQD1A0jc9fYL9Nw7DHkb+R+965Lvhe+DPANb5WVp/ofgt
yVdcJP53rA/mB+cF9+f8TYcxjvUA5vj3DBWPmqHi0yMqPjCi9qPb//gesg/a
6kA/OV1vARjzC/qJ98X7Mb1x9IPyfTvc+7I8n6X86VniD0B8E+RPjtdpNZSf
7mGO13P1aUKpP673UhOor8L5ra2G83t6uL5CQyHb16e7enpMD109Pe63NEzs
G/781cr5hz0G2L9ftuSrcnx0m+pn0ybxYFz/oIzj0T36ov3/0G+Yf2WJfUj7
j0lf954P/zDGud5ci6H8Xu96rAeup/XxnkfyVFtS/MmYP6wXxvc7ePlpdz3r
5HGKb12aFH8x7C3sf4kLPWH/x6fCH8A/cR6A/fkqEPukTw/6zJnJN19+bqew
3I/iSWbVsL4+7n/V25op+g7H82E/bxd/KuQX//v6JD8f9gJgxMsAg56wvLHE
wD/m0xNtH3T1dcCPIP/g/LC/w8WXgr9zvFEp+w/LilL+uUzBsA/DX+Gvz9s+
/4qEUt+Tim+cFRZ/BucffKrqb8wV+Zn7QRXKeuF8cDxQusiDLD+k7NU9VXbe
bgsaL4nB3hPmej3j8lPrny3yDtYD9Ab2QDyf+sWMc/Fn/nqtNS9sKfz8xWud
/M/+7C2q/vdwZX9x9dbYn9Ap+RygH5yP6vI/MH+cb98v9j7qh1zn8idgH9H9
i1gfSSj7dqOqbxAKMf3vVPmpYUWPQiFdH0zXp+V6Pf1G2/coH957HsWvevIv
12fKVvVz6lQ9qKTqJ1sbqM9E9p4prh6rT29qWF6S/tRzVTzYXMlvonp+0v9k
rux/yEuQf2AfAv8Bhjymsc7P4nqApbKfIB+w/lbL/dDEP54t/ILsTR21Kt8m
Kvwf+5PlgYTl+lClgsEv6Xrv+RpzvY0mA/slvp/i0yKO3+H3lP+SW6vqDXWJ
/dJ/33xVz7Ne7bdmw/m99Ybri7Vx/O2UsOV6HMM5/t+TbxEvzfEMqXyAUcVs
b/GuB3+Afo9zxvUMO+X3xA+kXmKX5LtBPga9w/NA3+AfBH0kf6H3vTTu0T9g
yCPsL5ltKJ/Jmx/IK7ifrqfD8WgFip72C/0EfWD7WyyQD8bxyitS8i3imbal
8n1T8+rJaf55R72nX1L+GdRz2iAY45Cf/O993pwfum/6RYURsT/e/vBO9//f
/FQ848ik+H8wftp3Fx/+84muzgp+j/mA/AX5B+8LeyzsMbie4gNHQN55wv8+
WyqY9a8m2R/sPwzSI/YPuvhj0EvQO9Bfjh+uU/6qKqFn4F9M36pZHs+tlf0N
eRX7gePne0R+4/6cTeLf8uUX1GvrEfpM/ujpRWLfhfwO7O+XuMqXHjDsb6jj
eN06R98wX5reQV7E/DC/rGV6590f+I//GZ5Qy/bVebUifw7ebk7SYn9xfrKr
Z6zrGzP9m204XmeJwXmF/gP5FvkliGeH/MPxWs2BegnM3xtVf7tQiOpB9lSL
fQv7Aevty6PwH3aLfR7ri/3N+Z4unhfrozH7l0qs9q+Cn0E+5niBMsUfC2T9
YR9me1SByl/LDPArnc+h868o3iE3Yl9fvm7BpeP75PyT/96Tv33+mCH6Dveb
jKh8lhj3X/H0h50q3uzPbi2W94M+B3sO7D3+/een8idbxJ8P+Qj+HWD/e7am
9uMmqV9A9SpstWCWT/tEHqJ8rFHF6vuL5Xqsl653z/V61hnEg2P+NAa/gD4K
/d/nJ9uFX7I/xeX76nxena+r83GpHownP0D+gX4M+9Egvch0+j3Wb8auC26s
vdzFY0J/x/6n8+jRF+ijvj6ZVPEq+anznyX153A99ifVz5N8yhS/mOfyIfF+
Ov6O8od6oO/OT8UjrDa7Tdx85idzI/K9l6+6+Kk9e1L5gp4+i+/1539A9pe/
n6ps/OzNOVeWunrsHL9TL/wE6w35GvYL0rc9/v3sYzu1xSYgPxn+lg0Sfw1/
DfiR9rdT/b6eQovvg3wOeoj9Tfl8LZX2qktz9jwoC/3gVqf8653C7yieoyOi
4rOLVPx2jsqnc/GrmA+fH4XEHg37Ls4r7HWgv7r/AM6Dv/4xWV9/v3eLPu/v
vxL7/cI/L/i8Pi77S+fHkf7VUCj2JsTDwX8HDH4J/gn5DfcDPxy837RgPS3t
r+L8i9JAPyKuHzdc5gv7geqbevKmz49aJV+S6+91i3zs3y9Dxe8gPsRhXz7f
LpjiMT35EeO+vpieOr8ZMg57nf89Pxrf3u/6rVF9wZao8AvYdx4/ofXW0+6O
Sz4l5H/cf9KDO+13TRXsX+sM0ZdxLr4a5yvSsn3DgUflW7zvQ0vXTUp+iPrB
Ww2tb1mRkteaA/HFJH8+7uJ9/fUcmtKXesUfR/G0DaEU/XLxr7C38/NbDOxP
mp9QPaWOdFVPNp/tyx5/hT6A94P+AP7C+nfckn1smqMX0BdZP1hn8L3+9VHh
f/56d6bmD/7oXjP2sOWvfXdIoXwv9hPsqcSvPX7F9ZYKVLxUvopne95gP4Me
Qh/8zeB+KhP6AXqq7Y86HgnyvM+/CoV/APvxN9vEfoP5h/8f/A363h5b7+1Z
/HmJ8Af4e8AfmF+7eAWfPuek5iNH3pfyQz36A3oLevNZ/rNf7dMXFXsO1w9O
Z3rurR/OF+Qr0GfIf1x/VfNzh319JGJhPx28/47VtuumxLt/vj/Fn052GPwA
GPoSyQNT/lc9S2d/C9Ffncq/ahV7DddzbBZ/DtvTqgL2Oaov1FCt4rtcfSSM
43qf/rj6R3h/YOhvVB93epLvd8QWQ/H4U+LK3hNX8foJFT+dUPXEEyLPYj70
91N/1OlFSn+KKn05KfIPvpfrPdRyPTFvfjjezelXuJ7Gvfvr/hvcT2mT2KNg
72f7VFTV64mr+gHOfon311jXW9T1bnR+NdvLaxhPd/UV8Xvul9xidHwX1xfI
UvUSWwP2S11/UPcb+u/9yttVPGi7jCO+HvLnnDcWfbjvYf3q9/1q/8KfUyn+
HLbv5Iq9nut5dks8Mcen5cn1XE+z2+h6BHp+Ndb9pxFvCH2c+5uWc37tqPJA
vizxS9F/Xb8jjv/NUPWq2lW9qG7D+V5doi9iPqmenkevOb6rSPyJkOdhnwEG
vQF9J/lxiqu3C34M+dnXHzYY2EvxfvBXgf/zeL/YL9lf2Sn8muOFgvXYUM8B
54Ps2RKv4OqtaXse13coEfoH/Z/yl6aXsD//iJJA/A70I58+RDjeTeIF0Y8u
pPIT0lR8aKnsD67XM0T2k+7nxv0hm1L+StcfiMe7ZBz+Qb5fn/HtQ8PEvsf7
rUXs+bgf2/MzVf66xvnib4W+ouv5cP5rkvNpvO/leltN4k/HeeD6BBWib2Bc
95PjfjYDyj9fYnX9Lq7P0ms43r3PQJ6E/Yn9F02G7CMrGw3Xdy20nL8e5vjP
MWH772HPXrP2VOePpH6S3vyR/j85qfKDkhzvPL1Ezju+F5j9wdvkfLN+0SkY
/Bf7B/IK4wzx/0CfBcb5wXqDHvF+2GI4H9j1l4A+Awz7MOYP8QnYj7CfcT39
LsP+80zVL6XJkL1plOuXO/g+ueUSPzH4PrPKBOP8UP/lxlq75fM/l5WeXyR4
9kmtTS/8HvWq4kp+g71js+jfvvy+3mC9Of7M1W/C/LH812vY/jQ/dd4HJB6U
6l0c4fop4Lwg/wD69CMfHL3+6Bscf2V7Uyjgv4V+hPmEPQX6CdufNqbi2XPk
fXQ/Y+2fp/w1if9aI/Sd/UWVzF+m1Ij9FxjjoNccT18q/Av2H8wX5EtgjHP9
3DbD/ss2VW+9XfWjaFf9h+tFXsL55X5Ls4X+4/fcb7hTrof+Coz8Gj3O/UZz
lDycG+jPxvXLI1yPZlxloN8N5wu4fi4Yh/yD/aTzT6m+o3d/lp/XmJlX5fz0
/RGuHzr4AzDkQcgv2h+j+0np+o9cn7xX9R/tVfysXfxxTF/d9brfse6nRv1H
O2pVfHSS42Nya0WeA/2g+iTefFH9jwYnf8Gej3HoNxQP2VMdqDeG8wH6zfHT
ccEcX5kh9JvqwY0qV/JTltX1ySA/Id6T7FtHVHB9WImnzlHxQTlC/8HPIG/q
eEyMg5/4+lGevA8wns/6Z6VgvA/1Z2xwGO/H+SLJwDj1I+6oDeif7D8aUPEx
3Wp/dhmOR+yR/Qf+T/Zwjx5ofYntd90iP+H+XN9gk+F4wWpL/uLHXT0E7DeS
v8ReEBd5iOSxpQ6DX0Cewvlge5byd61Mk/0Ees35rW0iP+N7uP5vu+irPn9c
L/I055cWCv3W8aScf5zg+qeRUu5/42GsL+wflC82qljkR7wP9YeTeibLxT+E
+AzIb1x/z2GM6/6GVE/C07/gv8X9df0hYLwvruf4zS0ib3F/8WGqHlueYIxz
vsBwZe/KV/UKlhiShzy+w/lTkYB9lvshhFT9hhbhz+CXZA/x7g97FuYTGNez
vWRTQN9jeTzHsrwwW/Yv9C3O526ScVyv+13p+C4ebzbcv2xJAOv+sGzv2aLe
r08w1oftO/mWztO4TMk3hb6k7W2sT3Yr/t8l8WrQLyle3ns/jGN9db1P3X+A
81ddv1XIp4ifGXwdWxWgnywPdBmuH7lFMOaT6auin7NXGPgncD/WRzuNzkek
fNmGQo6XnVer/BdJkUdAjzk/s9MgHh36Gfg79hv8zcDcr7Re1XNYIvsf8jAw
9E+u/1EgGOO6niX4N+QJYH8+hgjG9UzPezhfQ+qhufxWjMN/DX6B8871npYI
v2Z65PqdYv9hvbg+Tpdhe8j6wPUac33FCkvPn+76o3J9tCKVHwH+WyTnEfI9
MPYb+A/oKeRTf39FUuvzi9gr8D6D6zPB6eOYX+5XuMGQv7+nVOIn/et/MRSP
aWP27HeOHv3aPsUq3+rtlD6ZoeIvo7Zi5n4X7dbp9Bf49zCOeBA8D/ZozGco
9eeflwqJ3+R4umx1HlCfbL6B/g15Rdcb4Hofaao+QJr48xEPAX8/4k/J/x9y
8jbkSdb3NpuixX++7LxhhbK+XP8zM0CvcT2eD/sC/Is+/14r8brwNyL+ifK5
O8pVvZE2oRfAnC/RrurBrBf6gfcHHoQ7Vks8FeQTpn8lkp8EzPJpicQ/+PNf
w/72Ka7fH+R5lsdcfz++3vUD/O/Xu/5/1D9K+gW1Cdb9+9ieFPSPUj7orLjY
q/zrXX89rm/QKf5Fjl8J+hc5P7JW1e+vlXgQ/J7yy+8vD/T/YHpfFcjHY32w
lvP5xR7rMPYT5h/j4Ieav2j9j+wvkWol31Wr+OHaQL6g7j+n9T+2D7UG9BW2
720yFI/ozQf8U5hv8l9536/zMygff2UN9+eanOR45TJXnxLxezj/yP+BPAR7
FDDke+5HHw5gts9UyvmB/YPjr1z8GvRP7ndbovpJNBmdv8fyW4uMs7+1SfLp
KF4hUqj62bp+j/7zi0TehDwEeQv8geiRJy9QPYyeKom/GHz/MTXyfGDwX6wf
+QNn1Yi+B/mP+287fx/oCdVn9Ogz4hfA/7g+Y1WgfjD0R+7Xmuof5en3iOeB
fkD8clx+yl8wROQV1ucHzF2bCq84/dvhYo8un7/q1yG7OXkN8gbmB/sX8iH4
G+Zbx89j/2G9MA5+xPJ7mwH/AH+i/rUef4L/A+8DfX7w88cnVfxRTNWzWWEQ
3+Tf/0ezbt2NNSfcHBF5lOTpcYi/yhZ6AHkF54P7YRdxfeB5wXwFzh939WT9
+XLfMwhza0U/4H5XQ8ReSOs5qpz97UtdP0ucb453Syj/2EbxZ3O9upQ/YATq
ozt7BcWbTy7i+h+5EYv5hfyg6+mSf9KbH/jvQG85Pm6r4frgW0WexPpAf4O9
SMevIl8JGPFjoGegF9BncD4hD1D9VE+ehvwMDHs74hEhryFfAxjjXO9mrUF+
r/8+iwz8Z5B3gaEfID4W+wnfD/rJ+eaFLK9MKuR6oZ6+gHhHYN1PjeIhG0IW
9APxrpQ/3RJV9eg3SrwkMMsbXTLun++wxDuDvkGf8fdjfqp+u8N+vZws0T/g
Lxlcn3jURvfIfGTnf4SF3pA8PcnV2/Hj96rs/i9ed+Nxv3F41dnvPJVzcEz2
K+w7kL8o/nBWWPJRwH9An4BhTwD9J/rl8XeO3xsm/AaY5dsiwaBHHB8eZX41
yvEjlg/aRb7l+Kg61a8xzvkiU+LCn4C53npC7Jl4Pq6HvKox6Cmup/454p92
/aPxPNA77k/tsH+ewiper5DrOze4/hWYX2DML9frigrG/Vm+dv15gHV/Z+6H
Ewqxf7Jc5VdVqX5jLt8Y8rKO79P9mTm/uUXZP1sDmPlXi9jngdme3yO/x3pA
/8XzIW/79GW72CN9HOJ67NKv19WTwDjovcaU3+ddT/l641z/ZLwPxcMsdfl9
wLge+gLn//Uo/LzheLkew/WKNhnmb5vEvoHnsTzr9Fv4gyCfY39Qv4RR5ar+
S8Lq+mVcn6nOcr/M7Yb8bVIPO1f0Ca7fVRPQJ/X+1vohx0tuUv79bGVvLFTx
qYWB/YzzgvuTfb2hUNkfq5Q/vYrrD3nfi/0AzOufpeqDZql+LEtUPvcSw/r/
MsnX9uWdCNsH5qH+UafE+7F+VCD2KfBnjmcbCPQf5nqEfQb2O+iniCcDP6P+
JCOTko/l0xMXbwn6AvsnMOw/kGch3+P3XC9nINB/juN7tkk+F+gB9RcZl2B/
/+wE21PFXtQu+hz4H/Q9rp/fL/3fMF/InwOm/ki2WuWnVjN/tNXMH63rt8v2
pE2if3N9b5X/Od31K/Hnp0TlP7l6C8Dgl4i/5PoCpYFxzicvU/UU6g3xQ29/
c32tRu6v682/rs9B9i1vPaDvgP/p/Y58K399ilU8fbHoR/heHQ+B50Efp34n
9+t4izUG+rP/NvmKX+aL/Qn+OI6PSFf8OF3FE2XI9eCfsC9h/tgf3in+Ff9+
EVUPKxKIN+T+WAmVX5+wVL9meoll+1ipylcsleuxP3A99FNcD4zroa/ieqwH
+4cq1PtUqPrk9YbinVbONhQv5c0P5ed75x/+JNg/uP54qfhz/N/3GYof9+gp
6JU/X91ij4C+AnsEnk/2CW+9Ob42nemht/4U/3FEjlwPTPWvQ7kc/1FXE+jn
jvgOzA/FO8xS9gWPXnD/cldfhelFu9i3WL6OKfla16folf4wmF/ul9sv2B9v
Vv6JJuUPbVS4R/z9Pj1Ok/MEfqn9kzqeBvMF+yr0QX/9VxvK3/LOJ+Q1YO7f
+KNcD3mG+cEmo+Nd4S/AfuL4ki5D/gZPX9bxsNjfg/e/O2k53q/NcH26Nnlf
2BvwvqAX2B/+fIY5XsbTZ5HPivPP+XGlql5kqaX56FD1iDtcfPHg+pRViL9x
cH+NiUv+OPYzxcN4mPod181P+Xs3Sj4w22Mz1H538cXgX+AXwGyfWCT2CZw3
ts8sCfRn4/2xSOIPsF5kj16a5H6fS5Pc/3pOkvMHpR8h8vcGRD7C93L923TB
/nqni33CH283rL+ulXpAwOD3oOfIrwSG/MH91LdJvDjir3HeWP4fquoxuX4u
+F7dX1n3GwR9AH2B/gl6Tv2TPYz4AKwX199cZHS+EzD4Adsr0+X7pD5F6g/7
+7/XJ3pC8t2xfzEfHF/q+tvCnojrQd+4fssWw/WXt3B/21HFKv+mx3B9lk2q
H8Im6V/N+oqrvwh7KOwlwNxvBvkd8UC/GLLfjnL9cDF/oM+Dt484+yPsZ5Tf
1lMl9QzgX6T+JJ5+DPsz+CH3j3f+bWCON94i9md/lXsN2YNn96r4iupAfQju
Z+v8b8CUf9FQJfQTmPzh3v0oP67BxYsDk/z0eHUgnw771ac/qI/dLPuL+dNm
xb82S74FsJYvIB9gvsmfNaZG9jfkM9jH8T7oH+X//hcD/wz4G8cvzw5gyN+Q
p0AfwP+AcT4hP0MeZXuXi+fHenA95Qqr412oH06oUvVj65Xzhf3F+vgWzq/x
vpfjkbewP9bThxHPBHkD9AvyPunHoYTKzy7hfmpLUf/pV7me7UcDKp5ku5rv
AVkPfzwk8hroA+dfxEVfQnwV53d0cf09jx6zftRlWL/YaJ7+96Jz258rEH6B
68GvqB6Lh3FewN+wvqAfVC/b+z7ky+L7WX4fMFSPwft+jlfMUv3RM2Uc/lbG
w0RfAMbvwT9wPfwFrC/MVvp6vaH8HW+c/O+efIX6WZAXMH+IH2f/bbHqR1HM
/WZWthqyZ0p80grB8GfgeRj3529DSv77WuKtOb66Vsl7rr+1z6+Sst8xDnsS
xrmeaZLjA8qScj7A/2DPAz9je81wqacB+RnyEuQPzpeKSn4Y9C3EW0PfAub+
w65/DeQr7DecT+hLGrM8laX6xWVb1r+yVX+PbBUfFFb5IFuMxpxf0mu6j56Y
0fKos59o+wjXG2gO+CdY32tU9MHFS4Pf4fnAlC/myZskP3Y4/gD9iJ83W/lH
MoU+IN4P8ZDA1C/Ik6+4HqruD50u+Q/AkHewfvg95H9gf9zVD8d+1/lV5A+Z
Vyv+D+x3itf26C2Ne8/nfOAhKv46N9DfE/QK54HpW5nqj1tqdf1E9vevMFR/
xcPcz9v5U0Av2P4b5noO3rpQfI2HuV/mCtEHsX663iHbz4aKvxj0mvfnMoP8
WOxnztdrM5RP6mGO32833M+j06S/tF/sp2Ojog9RvalQprIndUp9OvBP3W+P
5E2Jz3f10bGf8Xyffn0l/gzQT9QrQjwo/PX+enwv/hC2xzuM+FifHnQIhjzq
6195Ur8D94c+i+tRrwnPw3kGJvvpPHc96D3w4Ph4Z3+B/KrtkZR/Py1hsT6Q
H3GeIP/r/Ij7rsi5694XHF629sbP0ptjMn/oHwB6yfU/1qh6vq2CEe9M9d/m
ufhyX/5z+ir4CeR1YPLXNITEfwV9jf03y+T8wJ5F+9vD2N+YX7wf7Ces38UU
fYmx/PN4TOJJQK9Zn18m9hnYR7B/gMG//fUvkfhsjFN9L28+OL4nTeWDpkk9
NWDSb73zyvbMLOVvyFT80WGMkz/Uky+43sQSpb8uk/0A+wcw5C3YuzBO9R7E
vjFT6APn4/WIPgP5iOtfxfn3U1zdaOgDGMf6Uj+kSEzFs8ZEP4Y8Rfq3dz7Y
39hiOP99jaH9e/+PguEv4vVeL/WYgFn+2mBQ38x/3jrG84qlXifoKfwJ4Idc
/6FU8jWAq+3y9ANDLj6S80tcPD32C8ULePuF4wUyOX5V9t+vYt/ierYuXgj2
BarXZau5XvwkNS79JTsln4Xtt8NFnkc9CpxH+O/hb4V+R/5HW6j6Txdzvz9P
P6H+KFJvfsCgHh7WC/YU2NMgX5D/UerhuP4PHB/t4lFgL6D+KB2u3jT7K6Oy
H3A/7Bfon9zfNCb6LOmnHbXsX5rn9Ddgro/daLh/R5Pqr9Yk/Tkhn/N4v+F8
0AGprwIMfxH0Z+q3Oaqc47U9+gN9C/YBjqeOyX4B/Yd9CvUtUU8R/mXot/7v
HfblmT7z3R4LRnz0TqHEQ3D8cEzWB/QH6wfM8fhRXl/pR71c4tM4PyYs8T7A
RM+mhCX+j+PH14h8hnhPrv/8k4xzvb8+Q/HqHub6eVvF3of5AcZ6gl7ieaA3
kOdBP4A5PrU0EH9P9bI8+kv90jvKOV5C/E2bDJ+vbtWfpFPi8XU/Car/ML1C
ngd6B/sl6B3X43fxF9wvrUfuD3qFfAzEYwBzf5xKlf+9TvwzwNBfwH8wDvmd
+xN3yfWQ17n/Q4WqBw//XJbYM3W/PlwPTPVqPfpP/f7G1HD+67h81V+qmPNX
O8ot1WOS9c5U/XGRDzXccj54kapnX8Txa56+T/y7I6L8UVFVzz5qKV5tXNRy
vGNMMMsvqXg1T77BOOgV9zsuVvlPxfJ78Ce2TzgM+y/iJ6CPUD12j55SvEdH
OY97+42/t1KeD37Lz6tU9vMcS/3vPEzyfChX5Y/UcD2qMTVcv0rkGdQXr+H6
a1NqxF4LegH7C+wful48178aYjl/OF34J+wb4J+wr1B/CE8f5/iPLtXvYbb0
e/D1BVe/BvZT6h+Z6zD2E+gF6DHHCw8YrvfVLxj0GfI8MPKRIa9wv7s0Vc87
Ju8Dfkf9wW1M5Fdg5APgfFE8pPivO8W/A36OfBKyp47LFH0f8VaQL4Ahf4Cf
Qz4EfQH21z/M9bZtqdSf4/qGKf4yotJS/kOb8sd7+hTeB5jyjT39Cs+H/AIM
ewj8x3h/ilebNFTiybB+3D+2SskTDqM+86HVb544dqrDsD9APoI9BvOF/QV/
M9YD6w/5GPsD8jPLXyGhfxjH89DfB/4vzvduNFw/c4XIE8C0fzz5k8d7lXxS
w/Vrc2vZ/+lhzCfOJ9fjypD3xfmnftFlGan8zZDEF0FfZX74qcRv4/4+jom9
BfZEzAcw9Av090E8JPx7wNBPKN/z8WqOv5nkMOezzZV4A8jbWD/y13r6MOJH
oB+RvBEJSf9F6AO6ng/xp/vLVXygy18DPQD9Amb/qhuHvsvrl+R+x3OS3H9q
jrM3+fTIjeP3pK81VAfqPeO8Yj6pnldPtYpvTah8j4TSJ0s4PsPj57p+B/wp
/vsX2ZNfua7xyYVhsf8wf0L9WVfvnvuZRLm+oqcfQb+BPEnxLh6mfoOTNqh4
uXzRRyCPQX8B5n5ZBZzfMDtf9Bum74uUvWCJ6EvUn6vB9ZMADqX+OH9gpmG8
SOXLfare71PVr2KuvA/0F7wv9/cpUPHp+dw/01tf7hfm4s0hj3D/5HSpXwGM
/Qd5hepbePuB4w8yuf6sR98QrwJ7MvjF4OtMcxj0lOrxzaoJ9Ksl+8KUYL8L
igeaVyv7E9+P84zzTfVLJ7t+r6AXwBjX8dzYn6Cf8Bf4v/9FxiEfUP2wnqF2
wt8fvWvU6K0Sn8L9v11/KOivwBhHPCXmm+tFtBjO524R/Qzvz/rcj4LxvT49
+lH85xjHfuD6Eq4fFvYXMMa5nmeuPX36nPv/83+f3xXJ/sL8Aw++/viilH3e
Yb+/rYvvB31H/JvuNwj6DnmM6H9Plfg38f5cjy1d7D3AsB9gPjAO+Qr6O/Jz
0V8N/BAY47An+M/fLPwX8hH0TchDXK8xzvqtd94gfwITPfX0RfZnFrE9KBQV
jN/79rrvBPv05xvBoM/I10V/Yp+er5Z6tIPXV1TbmU2v5jz7BfS3Xqkv6r9f
2FJ9xSlhia/39bew5A/hfAFDv4G+MDg9OyJ/rMFAnyA8Jcz168T+1S/yPdXv
9+aP6s958prvvwuJPQ/1N/z94fJ3cT+qtyP8okn4C9snXfwJ9DvOt00o+09C
2YfqON51aVLs2dAvuT5ct6rP2G1yhtRuvvIc18+B68lWSfwa4jnYvpzN8QRS
HzUs8gz1bxiXYHv+vFpVb7uH4z8aCgP1xHR9CcgvOH/QxzkeMib6jJ8P7uqf
gJ9gf3C+ZUzZ82Iq/jAWsA9y/fwKsc9B/wC9hP7H9fCXSL8Enx46+zHsn7C/
w14KDHkd9nj/PFSzvd66+qH++yBeqk3ipyj/zZPf2B+TJfZfzmdEPaTsQLwg
4yjnv0n+vetfyv1GY6rfTkzmE/Fo2O+YD5wHzBfmG5jkb4l/zBR9Axj+bpaP
2gzHQ7carp+3Rug71lP3E4B/FvPL8Y7rZRz6DvVD7CgXfQXXU71wD8N/APsM
17cLWYpv7yiW/eHz5xLG3vkjeaTO5XuAXsM+AnrD+TqdgiH/o18Z5GGuv5sv
+V2Q/xH/gvPP9dK6Ddef3Kj8z11G62v0/kuTXO+2LansOz3ij8LzWT/rVue3
WewtOO/cfxv2h7DQU2CcH6qP550vig9bGWf/oMevmP7FA/ZG5idt4p+BfAv5
BvUkwG8QDwp+w/GjPUKvcd4wP1zvoNtQvYQjSlS9phJVHyGh+FdE5QtHxL8N
+g2M+SH6580P9HHMD8fLlIo8AXkcGM/nfvAR6YcGeZb7HbeoepTNKp9ktdQX
wvUk/3jyOuQd8EeqbzCvlvMXGmvF/oDzTfGt0t+jW/J/0H8G18P/BXsM5y+n
Wc5vTlP1PNJUP780jt9vCFn0l8b8wd8D/QD1WnAeQO9wHrgfdFYgnp7777p+
pZDn2Z8fxBxPnyHxlJgfynf0MNf3C1nOZ2gy7J9qMuzvXy38AfSd+jmPKpf9
CX8gx1P2Gq4vVK3yCbYo/2pC5X8XKftRkeoXn6v8SRFVL6FC1gf+HtA7jOv8
A47naRUMfgn5BvuL+uF4GNcDc7/QdBX/2iX5WeAHiN/y9V+XnwD6Q/FX0g9m
q/Rv0vkA4E+w74A/AXP+dIvh+P8Wof/wp+v6d1wv73mJpwd95f4j3Yb7a7QZ
rjdUxPXoQvmqf1Ma2wc9zPHWuSo+O0cw3pfqrXv7mfLDPHmF669Xcz7qJIdh
D+X862o5n5Bfdb4Z5BXY83X+FfgDMNffTYp9BvSa7WvNBvItzjPXw1qv+H+n
4X6WyDfPFH8F19dbIfoz6BfiN8FfoX/g/Tk+YYvUlwD/hjwF/s3598NUvcoI
y5MdETnfoM/Qd0EfKd9K6hdsFfsJ4hNZ/nf1X3k9HPb5SdhSPqwnX3I9xjDn
//VUs/13VDnrG9b1T/Ofn5T4SM4vRXxbrmDsf9ZfKlm/8+R5nG9gnG//+mXs
P+1w/Bz1PBGf6s+366/tz0+S86XHJ622n0MfB+b+fb3S9xn7hfsn9xiOx0wo
+3/Ccn64w7Bvsv3bYew3zBfmm/W7UraP21Lxb4H/Y3+C/1O9RE++Y304rvSZ
DJWPl8n2jHGZEp+N/YPfg76Rfj2rTOQLzCv3n5xtOL+iJFDPnvolevP93+0X
a5S98Sc531yPeLjqd10n5xf0jfsJBTH4N+Kpyd84ORnoL0T0tqfKnvbdxYf/
fGJc9E/IE8Dsv1on9QvZf5um9COHub7acOUfyw/EB4He4vxzfF01x9v3OP82
5Ae2r3UbrlfRbSDPQt7heg+VbD8aofpHe/It13sZYnU8MPgDMPXj8fRnxMOD
XnP8pMPIX4B9EvsN+xbnG+cf5xsY94e9EvIEMOJ5dP8wYPye9T9XDw/2Rq6/
UqX8TwOqn8T2QP4T7FWgJ2RPHJdQ8cmllvildz3l30n8/VCR/7mfbrbwV9An
jt/K5vywOtfv6/6UPUXXk0b+CPYnMPQb7h+SZrneWIjr1Xnvx/me2axPePIF
6A3OH+RHf/+4+lywR3M+aKOSj5YY7oe6XeLloW/qeBCqt9tTzfGWDQ5jfag+
xKRS1X+mhu3fY2rYH7UyLvo74uFAn0BPqb+UR1+4/0yaYNBjzrcYGuj/pvPH
uf+Mw7ie+93mqvg6jV19Juxv0j88+ZvqiXv8TPeXAX2H/ZTo/exKkbdxvrkf
VmVA/ib5zaOXbJ9JU/m+Q7j+v/c+sMfhfQiPiyr6ElX1AbaIfRHyjrbHcD+U
ZkP1NaXei4vfQb8F7AfMP+R5tresV/RpvapPuUGu536CfVKfg+JjPP2Y/Q9r
JN8I9JP5c5FFvDkw+DXXb3PxGrBv+uvRLvzan5+1Ui8BmOun/ajqY9dy/6B5
tWw/6ajl/rPzamV/wX5F+WQe3wd/xfdCnwTW9UV0PUKq5+vJLxwflLTsL643
VL/8/kWSXwnM/Q7ruJ9sm6sn7o9HOT5jepHKD3cY41Sf0KNXoL+QbznfNc7x
EZ5+QfUavPPE+Wotoq/68496Sk+o+kpPSP4l4jswv8DYn7D/wd7A9dPbpB40
6D3oM/w34P84z8DsT0sTfw7kQ+xn5LMDI37QX69+qefgz0ef6r/VJ/wWz4c8
xPlgM1V+2Fz5Hq7nXsL5xh69ovkOOezL4y7+AvSb+nd7v2f7jsP4PexBWF9N
73BeQT9wnn39PML+VG/9oQ/4+9PVL4E8xvptn9jvQG+1fY74x8o425O8/cz5
iKEQ15d43sA+i/2E9fTXt1j8reDnuh8e20uSHM/h6deUz11WJP5Hfz2HSzwA
+APXi0oP1DOAfAj+xvUdh8j3g19CPsN6QN/x58/lk+P+XP8kW81ntr16v7FT
FuYh3n+IYMgnup8W5hP8Cvor+BX0IYxDn/fXv5Pzvb39iHoF2K/Ag+8Tj9rL
rl549WWXhYWeUL3weS4/G/IexRe0uPxn7GfQI/Bztrf/qOpxtgjG73E9+DHn
P8SY/lqXDwz/NNdfchj2L8R/Yz9SPuaoYraHTXD5nNgP3F/T2bsG52+W638O
/QD7GfoD+fu858H+i/PI8dK9hv0DW4SeA4Pe++vn8h9xHoFh7wC9Bn3keLWE
Jf1+adJSfUbvfOr6E8Cwl4N/gj8Aw15D+VCjylnfEPvgZrHngV5Cnwc9hX2a
7Be22nJ9ymLJD8J8Uz8tqU+GfN5M1gc9+sLxzBmiD0D+Z/tertgPsR+xnxAv
j/2E+FHY3zl+NCH7HeuH/QwM+QL0EfofsL8fayzXi64JxFND/gL94PjgDYb6
HUi86wrxV1D98kihOn8F3I9I+v38LPoi5AXEt5L8Ny6T+3N4+hXOP+gRzi/u
R/brXKcf4/u5vkm6rC++F/YvfA/lq3nfw/lyBRIf75+HdOVvdBj7AfuP42ly
RN9ke0aP6PPgT5S/LfXW24UecD+YLWq8hPOZvfOv6/MDY351/1zsD9A/YHwP
+D3Ll13S7x78H5jyxSV/o1PyPXA99rOuL8724wFD+SFHbJN8X9gjqL/vmBqO
d5tSY3U8Bvyx/v1+Ef8wvh/0APMDfR6Y5aMuQ/51T19FvA3Wg+LPppcE6mXC
/gbM/Tab1fiPEt+J9+F+0hHVjz1iyT7cEVH0t8iyfzim+p/EhB9CH+L6Pr2G
+0fkKnkz1+p+GeSP9ORhfB/kYa6/1ybzgfWi/Aep//iznAfuL18i/TohX7F9
plMw1g/9tiD/cT+FPkPyhff9HA/Tatif1aLsdesN9Qv06BPs51hvrh/UpPqn
Nql6oGskHpv1gS6xr1I/64aQqoc223C9z9mSPwL9APwC/IjtxctUfc02sUdi
Pph+rBH7JM4P1ZP11oPt8xsM4tvBT9n+5TDkNY7PDnO9Y4/ec73n/IC/Hhjy
DuITIA+xPalM4ptxf+6nWCj0H/oR6AfkL5wfYNKXJ7txYK4fX6nofwXXMzqi
IlDvgONLHYY8w/kPA4brgQwY7d8le8DSJPcjX5oU+RTzwflzBWwf9vgv9GfM
B/mnRyYD68n1NPMt+ysKAs+HPMzyjeuXgN/jPHB/w9lG15Ngf63L34I/FvIx
7I/QV4C5HtESdf4XiT0TmPKzJd4Z/WkqxP8FfZjrcw5R/Yciqh9vmPtTeOeJ
83UT4m+GPYjlF4cxzv0yHIZ8j/0NfYr5SSiE/Yb5Z/2qXjD8J3yecwP+Aa7v
lsv9DTz6w/blDYbrE+dx/7DZKzjfIrRO7D/+fLcL5nhu6IOZ6n0zVb+SLLbf
eteTfTcUxGy/zRD/ATDuB/qF8wp6x/UsNxnKJ/DkV5ZHNhuyV0p/wmaJN4f9
DfIr8SOp1+zqF5P+My5qKd7Vux/b47oNngdM+TN1w8Q/iPMIfyCw7nfF/bpD
lvPH01S99gjHM+dGxF4AeYHttb2G+7to/rBN4gkh37A9zGHI81xfq5TzMW2p
5Ofg/GC+cX44X6tL+Sc6VXzBBtnP7O+dK/IXMORdHe+i7bnUb3O602dAL/C+
3B/E1aPW9V+4H0qVnHdgihf06A/8s/g9xXP3uPwVf36cvgN6w/13+w3bd7cZ
xHNBP6F63WNquB7SymGKvkQt+0MchvyO8w15Xetv4J/Yf0zv+pQ83GfInzm7
UuKbYJ9m/lql9M2orD/OL8c7RDm/15P/Sf/ocPoB9j/X8w3K82xf3SDyO+Rv
rmfSrOpxpnF/rylpIh+D/7B8/LyqZ9qm+mH9Yvj3mWL/Av1le1+Gylfqkvp0
0Ecg/w7ebl5tQF4k/aUsqfTTfpHfsB8h34HeI78b/Br0BJjr9WUqe5XD/n7M
SL3fdqGPoKegj5AnmP5uU/0z+0Ue4njmRuUPWSH6IN6P/ecOY/8yfRmq4kmG
cf0ej/5zPEShpXwhT36EfAVM8SwdtUq+KRR7JjD0cdQ3I3+wN5+oh4b9geux
P4gee/PD+TrLDNVL8OaT6yeUWPI3THf0G/IO/DM4vxyvELVUT3Jcper36DCu
p/oW46L8POlPtFziJbkewSZVj7xX+D+u53w5xPv8IPyc+HtHregH0M+Auf7a
EjkvXP8gk+sRjsvk+nUSH7xN5hP7H+9H95vs+odDf8F+wf6APRPrS/2HPcz1
iHulPjDLW0sMjzfJOM1XR63oR6AveL9fJ4wtOTStVOR0f3/V2IfHXfaPh0c9
Y958/YQ7av5UI+Pgn99O2/H90OuvmHuyDgm9+3OtjKeuspFLNry/9pLXxH4w
ZvGbD150z/dST+KWJy579y8XrRJ/7/5rLvp3Ts73Un/uxLO7M3NfXC39Ol4d
ctKQqbZZ4peumdT27atXNUs+8B2PXHnyVU3NpuauW65/9ipXj/7c2UO6RkxN
cPyad/8x1458b+tjm0zbr9dPHvaz0x93bDr940kfJQXj/Q895I2n1uam219O
LXn4hnbXXxbPv/lvD+91TGa2XL/xlStXH/I47CFhe+1tX+y36WDXz3PllU+f
df39uXbahZeNvOXmYP/Yj59+8Y22nXLlfpOfmnrZXr/m2QmfDTNdiTWG7Qeh
UPH6ab/m9IFfRu206667addf8sSfPL5/1wtPHOPylceNuPbBNaXDbeMb7y+c
8GOlskfU2ZH7VLxefcpwO/KQ2rpbh1RxPRjv/Y+8tWW3NycWyvvtOZC9dv7O
EXmfP/x7849vvVVk9zngh9Hj78sS+QO/n11dW9cfcfERq5479dJF61w92xei
/zrxq+9wfZqNbP4he0Rt1M6efvdzJxzk8pMf/uteH01udP1jcb8Jnf/4e+ej
MbuxpnV4yRs/SX4D3u/N7kUH/24n14+8f4/xQzvnxGR8/QnPFOxQnrBvfvPT
k8ndeiQ/Zu2Lp2xevFOc9XVv/Zf3T9m88c/FMn8T0qd/+6/bi+2yfU3i1x3z
bM1u5a/cMPM7c/VF562rH+2dxxfuOGXixEbzm+VrMj6Zm7T7//LRc3td+o15
4YmCXZ4bXmV/W7Jt+e8bfzUfJW49s6mv2l720t0ffFe11ry138Jn50yttU8O
fHZ8/LR2M7/kvTe+eDtuswd2vf3wXTaZO5bOPvSGGQnb2jL+9t3P3GRGjdnh
D8cek2ePPjd+8iVn9ZuKZw5YavsK7c4Lztnp8BP6za0XjPyxZmy5veiRaw+b
VNVvdjt3wl4lOWH78wWz7vp1cZq9evHEqjFrk/aeuuPvef+jNHt26zV3v/1B
0ra/tS53/5ZMu/f79/56z6m19uLbDnxkzb05tmrCw8s+31hof26/8shl1+XZ
88cnNxzUUm1n/POHE28ozrMVr6fvvOXuWnvSC+uqD3s1zz56Y8fCi65vNS+8
cvR5r1QX2o3nLEnLe3WTeeygNf98sLPAjrZzdnzCu9+c/V/d4Yxcj2/fubJy
5AFV9t+HLzx7hofvG7Hsree/9c7rV5f/4YyOAnvNyM2v/LRvlT3hwZLTF3wd
tieP2Daz/alse/l1My87eGaR/b+v42te35C0v+y9T2Ouh894uOaZaQ+HbGyX
4V9NPSNmj//t6jtXHOzd/xB7x7RLYrZ0wXNn7r8xaS+88897fHFtzN49/NAD
Poy3mqbbCxb2HFZsyx8d1Xz/U5vMpLP2+2bPDSX21MXH7Bf5qtCW9e1/00/t
JbbjvFvTij4usiv2OvfRSF+JvWvu59f+kFdgLzht5IjH1y405a91Tt9ycMz+
bV7OiGWXNpgTv2zZ64Zors0YcuaL9V0/mX1vf/2zH34utWtfOnLyJ6e1mNaK
c3ZY9Owys+D1galZx3SZvNc/3tj+RMTesHL8N5u+7TSXf3Zc2Tu/jdk7Xv3n
YfUHd5q0PWftc9W6Cntf9rsr8o7tNU+vrz774qMK7I3bmofPeSnDXvLd6LdO
PLffHLvXXpGdh4TtwZm3XPfxef1mxt7/PveSaNh+9/ej7o1eELH1Bx188ed3
Rm1z7PSGDxZGbN3C+X/85qaoverj3QZGHh2zn7XucnLF+1G78ulzR9x5bJmd
2Pnh70efHLd7Xj2veeHh1XbXt5uOP/LpuH185zv3iC739KXTW96bcV7c5hy9
w3MXramx+zxw9SeFE+J2/e27NCx8c6m5dEJN9LX9W8yXfdv/b+2NEfvW9z99
9MPhn5vj9pp27+JEpeI3lfaspyPvXrLzVRJvMWzjE003lcLelG3fuLJm2qYj
fzFHLr+sMnqei6d4M/2L77Z/UmMPXHXt9eMnt5qKsS/NGli8wVzwSmKfb9q3
iD5YN+Om3d4ds0n41Z0P/5i1rrLL3FkyNn/0cVHRP3Z55rvIY9elWY7nKrDn
7jRp17aqbear/il9Z3/l+svefMpuR/44tITla0//PsO82bfOO5/X/fWt2V9+
WWorco7YdPGRW+T7Ji7/16cN8XTbfvJj56/+ttS+9vSaV8+pzLTn7N5yza1f
19gVV47cUPd1hsxT4Z+3jdswJsOuenDgzkOLC+x1C7Y/895dQ+yKfd6quNbE
bMe+7/x0bPkQW/T5P/6x+7SYXdRw9uff7z7EPnHBm5edONzl/0+/evxDbZES
e/2sr80/Hhtijzj3wN/ctnuL+OMOWbV5+sKlX5sJ8d3b7n5tqD3jqOo7x5oN
Zmpnf/vUGUNt3eXZuatf7TMPPJU9dPsew+wJJ2389C8nZ9hP2v58aPWpw+xZ
xXNmfb92jdH2vDc33rL1pDUF9qONjy7+cuRQe+ba2KeLR+VLvuXi2uuOuvzQ
Qts4+oJZBywutevvbr1kciLf2795Dzx0TZn9ZtWMM1cm8mU+ll64YEL9F4W2
qvi9L+d3ZXD9S0/fiN+580PfdoTF3xU6JPuaI/LD9pOT59wVeqBc8j9qrl+w
IPb01+alK6bH7rslas/8pnTFnNXrzV4Xbnzz3iuidtFLL47++uWQyNubtn65
ccsvFfa6Kdfenvm5i7+8/+Sf8s9ZWGRvPWWfA159vc+Y33x9R/3fo3Zyf/7P
FTcluH61x78//PybxyqbonZsccEbQ6ZWWa5fUGOTq17sTH/E5dscs/yNtDF9
xXbG1cd9/f0lYbF3/fPokr3W1SZt/KKTrhuR5/qXnret/LTHJqyV+IXuuxfN
v+GjfvPQM6v/tOKaDar/aKeZP2+XS488LEvWY0nWs6d99W2u8O+vEp+9+3R4
mMSPj9865oo7Sgrk+zccv3PhwsUxe9yagfrwWBefAf/GkwtWtj800vHX+566
+h93XVYi65V23o8Lfj6rw9y1ZlLJahuV9Zl9yScTLx1eJusL+f9vi28ui/4Y
ti83nHfB3NHD7ClTvyz8eeFWs2HRv+47f2uXuXbj1jE/jMm020+K7XHa6CK7
bePqgYMez7QnXHbPQQeZIrtl+Vc1176eae+5fsJdEx/93oR+99y9388I20+P
HHZFMi3LZvztrBVvnBG2o9d++d72H2L28m1jO889KGaTA2edcdSTP5hVL128
frKnp3UecG3eq7k/msw3Xz6l5MkSu27E3POmF28y6Q1/23Pkd5+YL15sLEk7
vdQ+NCG667Sn3zOP9LWcl3VZqf1T8UU964bNNfetnjXujZ/L7BmP33T5Z5+/
b27d875fXlxaZh86eL/9bzp1jjkqYcOnXbPWFJ1+SMfZUzaYPTJPM/nHdpsd
zr/orV3WrTehxvf3zX13o2k9/e2JyzatN890zT1093lD7Unbdov88dsek/Hm
h0XbNnaZspHjPzji1nTb9mLRBXftmbClFV8O7PZQuh0+9ft444paO6J+Zztx
9yL77pgzIvNuD9u93xzy95KSYrv6sTO7u3tidvT3py6LNMfsA3OHXbT0zbBd
es/63134WrH99rmvr/j8xlJ7fe+EZzo/cPX43/i5u/y2339kej5a8UTG8qFC
L0tfLLno3Zkbpd7LO2e+Oy5n81oz++a8Yw84Nduu2DH3u+8fKfLkhar4JXnZ
9tKbLz3k/Ok/SL0A2I8OOvbXPb/7MmI/+nDfz57ZWqvio2vtiR8Wbt9hi8PN
S/r6TniyyL78u+OGtv07LPsT9sYHnrv47sfuitsnz3j2uHN2jdsH/nLiLUut
R/eiz2a9NrnbDN/yxN79T28214985OC9z023Ozf/8ZHslvVmefbnza3TBiQf
Ffbr5bef9vy+X2wSe7X9oaWxa68t5tl10ddbZoeUParI1v/txJUPHpxl7993
wSNtnZm2ZfejTqy5otCaBbddtbInYl/4ePH5LSNRjy5p9xqI/2FDTsRuffnZ
d/a7bZG58LoTb1t1XpHdWLlo/Fqplxmz362q+mpestDes2i/w/M8OTOxzy1V
U6YX2gNO2Hx3yfy40KNH9//igePr4vbb2hPnDzvZ1RfYu/6AU0c+m7S3fH5Q
c+nMEvv7vSbMvOuVpL28Z2hozPMl9u1vd9x5VvMw4Z9D7msetummdebRsr/s
tnXrN2bE2D+NHje5yD5ywJh9tzT+aDrn5Gx7qsLFf+P7/57Xa77do8X87f8+
HP7FSb3m9ORvVn5wzgaZz/MWvf33zae5+L20Ew+/4urVm6R+z4yOd5p6NqTZ
73brPebdt9Ltxt4rFqz4JN3ee1j7Lz8/553/X8788Y6jMmz2TrGfD9qz0I68
Ysuo5M2uX21m/cLqHb4K28LRPx6QvWeW0J8Lnziu5dM70+3QRX373DUhYmte
/FPPvrtn2Bf+eVJRzh4Re+cb01bedex6U//AxOfG31xkR0yyO1+6a1jiP54+
bMTk5Y0xqT/Uff5bOwxZv9Gcsse+J81/vcRO3Pvub99flG7/+NaB881+A+be
Z5rHzj0i3565yzt5Rx+Ube9vv/ftRZd4+vVpNy9/aWG2Xbp9xNFH9f5oVr9a
9tpuX/xgrvt8xpWXz/zBJAt799j3xWaxl5Z2v5fzu7kbZf8dunj09pM8ueik
EWO++KvHp8//YMQVJTdsNL9e0rVHz+qhol9Dn3pw36y/zLh8iP3onCt7Qxdt
FvkA+mikY17vs9741p67jt+2tFDVkyiyY+tO+2hhgduvL728ZmTXfE9uOnrp
sHuLXf/So7Mm9e31UtRe/a/3HpiTtlzyzx+1+73U+bdOWd+6hldH7vZVr9ln
zLfzM3aqsIcMv/qqE/611cz4Yd/ZXZPOMbD/TD3m3PI/Xx0V/R/2srP3PS/x
1vQ08WeM3PDs4tf7tos/9I8nl7z6zfoMoS9/n1BfetrLQ2zT3E+n3HnfdvPC
mLubd3x5uF38Sm9iSVmviqfvNfE3tj27ZO9C23DHGeMje1bboUe/8Ezx1S7/
Pz1UPGql9/0zYvWXjDvV9VcFP62p3evoy+bE7e8f/m1O+KLhNvLKv84c5p3X
qQvG3//K42V22Nx7zpu5PGavavjDcSMOrrYj9n976iND68W+MuGJynXHP/uV
uab/4LSac6pt1UEXTq/OCNstmVsPvX1ZtX1/1ag5rVe4+KLukVtv/KlrgTl4
zG/uv/tlF++/U/T1dd2PbzRPfVk9cUF5jsgTS/+5159WLonb1Y/scduU/V38
f/pt00a+tjyp8jlazdkr3vnylTUbzM3vJzoG0qq4Xpgn3+zRPL289oQu8/rv
nryhe3SNZX9Y3O7xm9+9ddwTvWZq+pxjjtmxWPhHbFb/3O0/RFW8R8xeuN9V
8W++g78mYVf03pdenLXVzB97pFl3cKn8fsNu+9c0ri7iejze+4ya9cc97WGZ
9v7RN/zcXtKn+q33m+PLb3uzZR3iWaP2y4nndx5/XbZtji96+MCuIs63854f
v23cpPoFrl7Wa+/m7/nKn4aJffj9Z0bUD9knT+SvFw6ZtL1ytzzZD89kNL16
6y7D7H0D7+z7SP8wsXe/Xb7qtrlHRcTeBHnt+yuHP/TGx3n2yO+emj27/a+G
8+uidsYr78/96JNC+8Qjq/7U/IHLl3p1n/1v3HjlGkP1KLzzf+05X0ZWeXpp
1im7t17z+y0qHi7NPvjaxRc1vB+R+bnqDxlXjT3J2ftPOvW8uTNWFdnqXSqe
GLla1bvw5uPgsW+2/bo0am+5KHbKrWPXSv0uPH+HG06ekb84ah97dl1F3aW9
qr5Xp0kWDNyTGBmzLed+eMVrt/cZ8Du8zxNb/nnag1NitqHz+1uXvJ5Q/WbS
7E7LT1824iPkd2bb96rXtj+xLC7y6fsNC4bcc19c5NvnP5h18/DeuNiLzvly
wwdvnV1if3P6kvhVX9cKPfP9ATU2Our9Gdd8XWJvG7/POcUf1diZxQd88uSh
C03fuw9+sceoWnvJHrcPv7pjrjk15/ZHtvw+aWftaB79ecFCs/2is75945Gk
Tbsj59OBfeaZ7ZXvPrPj8hL7WsGmY4/tbTMftOy/U8GWCvtpRs0fO85aY+be
csHrN5RV2guePLLkudAak/non/Z7/MJqO2b7xSflPL3GrP348vZ9xlfaIbNX
jrlzTZcZ0her/uHDatv9zD6TX7pzo/nb3rdmftdTbS+r+Pihm1d0mXuuv3r2
AcVxO2HHRXflLdpqzMlXXnrln+P20I5hRQ+esdU8Wn9ezrMfl9i7/r773IXe
vHcv+WpN6TNl9i8jVy37ZFymPfDY0l9vSiu3b/+h5sDdr8y0S144t/fY8Vl2
/l2P5tbvnmPfy3g+48irsuw3/1hz4K6jcuwO/V3p3VdU2L/Ov/vJuqwcu2qf
tM+O/X+yrjyuprZr12meO52xeThJVFQIRfdC5jRSUSQkkiQV0aDSQCMJhSIq
lNJISkVpUKKkeZ4HzfP8nfd737P7eR7/3b99TvbZ+x6utda1rktPCnpbSpz1
n3HAn2sbnJRfSENozE0ZfAk7WJvxKezmpQHP0c+fzg5zwNozTNdEONvQlihT
16ZyHijpCXky7tiGmilSBYGFPCDf4zq5vWwc7dpr2faogweuXXE/57eXDdLP
emcaDvBAvREP061aIqzfY7pJkB6XxkRb/6nto4CVin55mSM3vLXfIiwbQQWj
pTpU4MsNxpEV22t4ReFr9o/VWT+4YcM2/MiZraKgpSH84NQvbmBb/Cp2t1Uc
JtaH7+Ir5IaDB8X7bq6SAK2NFRdscrhBfdVpt7nVUmDZPmS5X5MblrcXDbm9
lQZFj3CDpZM80PdU/3vHrAxU5xZzn5DjBmf7glV6XxrRzhYZA9N5frhq/9ov
iiIIsRN+D19XCwCtzSDFJFAaIjxHD13J44NVv/ONTyjQQNDX7VLjVn64/MEU
3tynwZAO79H2Qj74c/JxieXdDvQkpvbG3WQ8zOvTzqAjncjXJHB3MB3XC52X
vxpXJAof1RcMTzngIdX32XzBxBj6NNDLbCVDgLfvu5PuOy6h3TriY2dXEeDr
RnvVrw/GEa+i4dkLHPRzJWUO/eSbRPued1LuDhJhVsyL6BHFD42f02uru4gg
UJmf2bZeDE687k5sbyeCXeep/myJH4i7QjJSazUZXlbOJ8yNjSPFI28POLfR
z0OxfE5W0gTSUH9QurmVDLcUKSUz5nS8bR7ZvSqTPk9T5BKlNJig6NRqwWn6
+AqRyaB2Ixv8cHikHEc/rwxDRLRevWCDEyTu2/cqyaBfJPPa9Cs3PGkdMX/8
lY7HlFMTAx7wwPJcytYM+n4QY8+iLU9/Xj+GXnh1lpOhbPqABMcPGjzqFMhY
m0iGkfG7/scVZcBoWPh1z3MqVHDYzj86LAOstZQT729T4VfivtPjxhTYu+9j
CHFsET2rjBvdUZGP9I2P+vDM4GDqBtdes9RxlHGtVy1kFAf3vctaCW/H0b7X
G522xNDxx6tFh4vXcSCt1F+0UYkTYlhjcZPiE+jPCPNN/Vd8wE3kOGDjUYgU
3qe82BEuCJHGqtzbvhShF+Za3a4PBEEpZ2tMnKwI8KTyn3eWIIA4M8mS1VoU
ljyuq59YQwaON2fWhJ6WgbkazuDBTWToVzrH/sGXAjmH3JXffKGAzuOvT6Iu
UEBY5eObR20UjD+Vz+3N8bOgDstftZaF3ck5WIV+1ykO9YeMYPVByddRbSpv
RjB+YnntQ6ugdCGMP9CT//HRz31C8LdfEgm2tjW9Ae5RZNVXs4ZoQQG26ecy
o+oTKNdlU5BdFAWSRLakHW4dR1xFC8zTSzIwMLVb3+pHH9bvNiyS0nxuRy/i
+cPuHSNO+4deCAFEAxOLU/aNoeO7dHvddnVjfl3/3e/5oY+5PaRcYRFJqr7c
zE0SxeqJEU/z9r+uxMPWosfi3ThmDD/pXl+iulUwQW734BbHTSv+wkPn0z8l
xAhj4wK746mFPUyYPneOFNepY05t6MbOoJEnRG7sPDq4rp7J0mTFPzgh6Pge
3tucIKhT1fZZVAi+HAwqHczggoom8xZf2QnE+eHoPk0CN8Q7SPGL3GxBrELT
b3rO8kFTff/voO+5SHxRZqPVOwF48mRD5YaQEtRSjE9K9BbA8G2jx8z98HJ+
DI881a8VUVASgOUMXsI9pVn0ssBjpvAKHxALQ7pC9OaQR/KjTZG2fCD3wQA8
p/hgh6RuhZ2dAMiW7MKTCPzQ82vDnatOAhh/v8XhtIqvnCBsWeVXO7CXhp3/
LbcFjkertyHhYOPgrg10/Eug6j1Gk6hOSO3n5DIBCFqBxlEvx1GF9rkrP2hE
jA/GtmXYsIlrRf/i2V22O/3RdNwzUbgdjomDuz3XTyljAiigw1+FmcSxetV/
3784CL7gKPlhTQDWklt3PgRJ/R2vlEiBTHpjhJ/3ij5XMXG9yE48AUoPXeQJ
OCiF8X0uZdbtnWheRrVrOh6P7yJCZGNTfC4JB/UNf4S5eYiQaYpr9SokYfo3
WSd+NTO3UmHPkGTP8z4S3Nn3do2jsSR2XfvPEULIHxng/P75+v4FEgxSGkoX
h2WgcDTrRMscCcJsjt/3Ep5ENaHnQrwqSPBmeLd5iuM48mCZOofrJcEXZ5su
s+EZtKPyRe66AjLouQevua6Ag/Vqj25vySeD2dGyO+ZCnKC1xptPr3LFbzjq
bL1BRCkZq29HGJo+/pNEhrfFa54HL6z4CTPWe9Bl/63dAVQ47rnv7GrBFb2q
C34XbCjpNAh5kGzun0aBby9dlCIjaXAs/NDTys8UbH6N5Y2LFV3vQOY5XbdL
S1swfgADr/ntipc4zTuK9dftkDN546A2iNWbWzYwrd+azgz5+XNm3H5jGH+f
kW96duHMB9pWViyeH36yyTk8mxMWrDRPN0xUo7/9uwVALee4tmw9B4iMPXMj
jQlg/UJnB6JfGL1jwfg7H9WOFrC08WHj7Xsvy34Z58b4bQy+ykcuDbmAcH6Q
+qbdfdZG6B94txpJDrFF+yoRoDvhXrHls0qsfyBE+1FUV0X/v/yKjzVJEn/E
0fG0sVPRh4ej6C++Gf19DEjcK9A/tuJf/OtKet3tzBX/4pgpmSNfysiQJJxp
fTpqpb/TqdPkGvvH8X/5Fb8Ie7e0nrkUffjTJnVQmojpCQxSPi6UXRhD2QdP
HJu7V4Fi3rQcku8TgsKHDi89UA8KY4pvP9koBLPmR/kD3/YgXzu/l1lB44iK
dx2rb2cB19BuuQmZBmSl/+dKVTwevhWXRS3JswGrZ4mOBw0P6zoMvj183YAK
EjY7ltLXN48im2dHPwne3TNYH36WBAcLXnMxF/SiIy+maFGfR1DXeQpv4xEh
iBv2O93QO4isIgzGbx8Sgow18WOpU0Moy6Ty3UVEBBW2KKtzu3Cg6qSoQ1EX
hpbm1GOp23DgmhsoK/tbCHbJ+22nGQhC9c8vk+6zQtDqby+meEwQllLzz3IF
CMPZX03f5e4Q4dWZRFzPXTxYdW3KVJOnQNMj8VzXJ5JA5VEw3WZIhjfPPGtP
XiaAn3WstNUnNiCXCZqkKxOBlK7wS3dYEJpGG1N4tehxjHbPgYQteBjf314y
tYV+f+M3LVmP44F5Urnr4WAn5kfVmXmXUNMqBk/V3Ct3nnqHZutChjzdxEE1
yH+rfMEztCRrTU1zZoKCqAinebFR1FVq+SrxCBP0vLJ4Jq44is5v1tvvpjCD
Jg4V7Vs+PoXe75O+EpEwg3QXVmvIqE6hH6lGeQUzPLAz7tZRuS5+oIxet2e+
zAMjZU6P3qfxY+eD5+8Cml0cHQ8myxpRRpjgtbBz8XKxEHzqv/vxYokQjGc3
HBzbJQQnhxf94aYUfENItHhECAQLJh8Z5tH3uakef7+XZJD8TbwvlEmC4K0c
/gppZKiyjNQiaOagHb22ZdR5KrSIGrfoe+KweP6/8xkH5Pt6XMYsi6jaUu5t
cx4ztOhUW5zpnkXRreEduApmSHQ3v91AnEOttRXCBswisOVw+8U0byZwsPTS
f/2CGU5qbKuWFGCF4LYXigPPCfDk/nOLDF0WbH1IrNqa9Z260p9qk5b15ZwH
D1wYEnG0CptG5CsavAPcguA7c80z8HAFqtY+9IKWjYczLF+EjlX/ROrfNz4z
/ISHSGam5P3cIyhItHPvh2sE2N3REv+LqRj9rY8lC0JDGu5nc/Dgq7RPu9+c
HhfNFT9e5hLE8mWiY581f9sJwin/b3/OUAj/0G+bQEcNtYMOMBNgKJySnyY4
hRpMBu+8zBQCFym+vsS1//YDlpOUef/LyAmZViSHfz/QiYIvpd+1XjWKnPdX
b62y70CllYHKWuqjyPNuy641Arh/6H8yw805LuS3aQ7j21Sxe/aTE+ZR8K/o
weXTf/6RH/mDImrkRePEuWBZKzV/im8Ebew7csrhGyc8Z13teJONCiGFPsZ9
ChS4/nrVdUEVKuB+HeuJGSPDjuUQq0AkiuVH42bSCk5Xi8CxmoD2/asoYOEc
eSysUwT4di4fzuShQJRJfVukCX09bki43G1GP4/k41LyrlHBxk7z4p0gMlA0
zgQ4EkUgmvndZQPuBKzfeX6I4+Nx3los/8Tu//nW93eVSAlfv0tcg+Hv1Ij5
P6WNWW/P8q3H+ElFzIvn8sYqUWdRrKvOO2ns84x4v4NcmPmnph7To4u59co6
7UMVOp4ra1OlRvuH3w8NCmhXQtFMA8Zns+CL8an2G8TuV+Tezk4T+v7GuJ/M
57P+fceHkIVOtX0gUQYU3j/ksZwewvhtm0ebTj6wHkEP5I2eDSXyYvhaWCsk
YrCUBIeTT9g/uzqFPvkH2WyfEP1Hvm0KpSuzn7EsmkJxq1W8rBamMf03Rn85
/orVuh9LCyi+o409rlUC0ktDzjrkTqOHAvdsbouv+AvH2zn24w8KAu5Hq8P4
WxyWL77Z3nn+968llJh9RLCNZcU/2Fn1lWWsuzBMm5dFHzBkhsuTNjHXdgj/
zd8yFYbR69Rb7vEr/MDNnwtz0x1w2Poa2Lna3i6aFbi8JB6yUmiY3jLj8yEq
FT0lRxn9xoKgxdU48h98wJjfT5tF6nuZObF6iJqaVv5YAwdk6N6fvFW34md8
sSQoXC5ZGv7mB0vDh5Plth1LnOCz65iYVOKK3/GudLH8KEUpLF/HeJ93W37m
xnjyYt/X9enyr7zAh/2e9kPTXVlbeSBtQa6Mr3WFT8+Yj3Hriklr+vjBZibg
gFWPDHad8fe8fGLDSN9X6rOHuc6v794vCOE5v71y22Xg0m8JpBkoiOETimj0
rlV7SfDx14mdLiFMf/v10ufX5T07ktqYSRgfjrbK/ObmRCJIEIY5EhzxWD77
v/cvDBIhd6smkknY8823MowV0CdC0dXiryNxK37ND7Uz3hcW/duPuUV+ePik
NQnOmqjyZ7Qz9F1W9NiUNgb9knq4wgd7zr0t+eqllfxciv/qETdpMkTmha4y
j5aA4L3XVndnV6HC6R2fDCcloCE8bt0v8i9UUGYVrB4vBTlEv1btzhqMX7zz
VmF5St4C6o4u26I3+m//5RjKRtstlgz9GQm4Q6wJDvjMiuHLGrcW3R+CvBje
vvhT5vNOZzq++TMXQKpqRXHu5JhneBJELTQO6Ii2o1Atr+W7rAz+Giv4BhzM
kgASzJFLSZRBQZihxs+OVVDBL5S6iuuPKLTF/nHf+qwNmdw6WqJQLQpy85Zy
e+rakOJj3iNK7j/Q99xps/PPx1BFTV/H3NFBJL/z+kjT2RFkf99M7Rc3GbhU
lXKqz42gBn+tOwFv6ee1f0RKSPEI4ovJG8lmFoJTped9fx+aRyGuSi5ND8Th
rvyGj/pds2jigZUrNUsEop6wbFXcu4wMrzbmfy+ex/rD7ZR82850zGN6sE9y
Mh6lydKAdnZvh8V9Iawes9D3rvljIBE+x3TnxitLQQz++P4fD8igIh6VWmxe
iL5sETJrLaQA2w8uNU2pYnRr8KLC4BcKyMm7RczwSYGjB3v1m9cr+mkJhhR8
gmMX6m4vUR58Tv9/oxR395fVoBwFgRu+NXjIk5Imvzz9G9tvVRM/1g186kCV
ffY/Dt6cR8kvRt7sqxpByhv0WSOtlpDDpNIRNt1RtG9o8G3Ifs5/1Cs5we7M
U49i/y5kp/D8dNb1f/szv3ss8kkssQtdjDAnzxhJw/CSV4KacSvqbFYN0bCV
BvuwdIfjl3pR4mluKaa6lf4Tv67uw2Ol9PW8+Hi3xrNWjO997vbSZeZXo2j5
SoNRuaY4bGp50yjHP4JcygUO2diJA/cFPt+KO8NIa+rO6pc3xOF5kBWnsuYE
dp4IXHpMUHQaR0l8ea+Lylf8mkWJdwtc2aXAFmcaYX16BOvfCQsjJ6m9nUS6
11YrlM8LgZlF5tV1CnNYfIbiR2bP+i0iyYSMwtgUUajNrHIaHJ5Chvk2HXdO
/NtvueU70yrKDDNcMMj00RkdRX/O/9Jl24gD+dqtx2XejKEjm7ctC5vjIMKh
BtdNYQH+mtbp3ChmENEdSp+fwIHCne2zGSo4yGNdSq2OE4EOrWEuPU5WOFNq
EpAG4mA8bPPzVRIrpGwWKiMZisNFto8tAcmscELebFUhlxQQDEOb7D+ywt33
nMabhKWgxt/wqkMGK2zbETye58IPqXZZc7hcdlh2jCn785gfFB8H9dlNsMPR
plhRLqoIOIbqPfT9yQEWJ2LaLodLAFnRwpT1Gyt2XlwVSVk7/5UVHt1KvXfb
hw8iw5z52Hx5wE11n/4IPW6z3q2juIzjBg5j+9GqXQToqZ7IoTAz+kFxQD1c
313yih8sxdS11NexwEH773NunAJYvumh35kzn4X4AMTXLl5yIMP0FV8Lf3U+
0ExiVgm7SIE9HOG9xXZ8oN/vklQVTwFJj5ST5W58UB2AywxVFYbX+UplTs18
0LTW96CPsAgs7FOYTOWk/27mVsnL68UgTatu8w1Ofmw/6x7tv0N7wgfd24vd
71LEwdZidu/GJvrfh4Mz/ksS4ClcllmhxQeHUX/zqSAJMHwUkctrw4ftz/qn
bVWqk/Cw+7ykn4RIJRbfODptivX4xAeTTQ47XDev5GcybOcJn/IEYerQc3+u
MGmoenAlXfPxij8x5yumjzeP4mHLj1zrnqQVf2JGviz92+ltk7H0+JnvLW2R
uuJXyeDLb3xwnLI9jwD8XVTfBlLpP+pNhcgVkm2jkoigz2bEyd7KDDGqG5+P
65KgjVfbXleWBXI6RYcrd5Pg57MdXeTsIXS3l6OQRYAC3+2DrdbEisDSdtc/
rc4UbD4cHbCgWf1aqQc5BiUdvpVLAY+hwE4yWQYCfOS9pZ5RYIFielJh7Yp/
Me90Mvp9acW/+HqbRDdefR4Zl+8rfk6PNwSydwpdOjOPxqyVN299h4eGLyf7
X0iTQEJ4ydIjnAJFfptFrAu44XWcwOkH1gTs/PaZNb6Zc4gAYm9sKsZiebF8
Fs8DYgTbF4beSTZ6LDZQEL91CnkYJie/OheOfrMJrLPFTaEMQx3tyA1pyMWD
7ft0BTf4Kya1vRybRBbhTVdcBAUgVf3Qyz3rFpHRTvtc/VP8EOMTey1h4yJ6
3ctWhJsnweTNepuJlySY1RqsKw3CwxUtEpmXlwpreHPAR1AEyyedktd6YcYk
Agr2eVJl41QY3eofmc0uAmk4I/u9bVRwOJxbq6MoAuMFtX8OWFLh4825C9c8
V/S0Gf1Sbv5RXAXLORh/4PenTQ2xtiNIbSBIaN8HbthlvY3m1jyNzinxxpwr
5QYJJ4vi4eQZFNiVSsuMGEf/1Ae5ySpt6kePv0gNyiGXLTr+1n+jzy9P/XXh
Kc+F4NkqUsdROr5i9OPcWHySb9Isg+kRDf6vX4PBP8f0Xe+d8PrzMAt9t+v5
+YckgvXnve5yH8tbx4TpfwpEd5Sr/WKFKFMJtXgTQVjv+6q4zoWG6XUcq2Ox
6nORxPSjxsdzrge10KCZPPlT34cKMqLRSRu/lKONtPVhi8aLyE24vPz5WVFg
KlrsfN1Mj7dzW7gEv/LDGwWBPrIGKx33CfutlV7xV1a6VelnKs0GlWdvcrCk
CsIZ9TbSy01scMZBvVF7QRDSD70LXK0iDS5mGi5eLEJwXuXVkGeyJDzIzhfJ
NyOC0tpdD66PkEDfrHTOSYIM1KH3I4QOEmTkxJU6713RG/NcvIUTCCHDsRmO
GJsdnciv9grfdv1WjB8yERSScdelDZ1on9t4JIYHanaxj3uEjSGn9ZldpwTJ
//JXNokqOFRDZAKNAPURlwwS1HLnVNz3YgKJq3cCFO+x/q33QD8XopLK5Lp2
CWLxQujuc/J7h1fwi8Fj+U5zAhUCNDMOzAhIQvjpp2GLfVT4sP/3yAHl+n/5
LxNvC+w5+2MUtex21ZRzJYBMkQL1LMcyhidU4189Cxde4VsK7et67cPGD69o
xr2nN/7bf/mtVPutGR48VCZnZ97JEgUXUoVFayQJRo5dZJOQZgHOBKfVimlM
YPm761ySGAuQnzYLUNyZYLOsp/PxQSmIk3MQnTBORtky+Rxp2VIQ9S1je/zP
D9j571Pc/uvIUAnaaPRLdaSCfn66DPgRYgWx93NL1bZu9Xw6mmniJCsUTCLv
B0yVsokccDOKqONnOols2RUfPcznAGduZ7thT1GMT8bo53qbTTP5gFvxb9uU
eEo8I/4LUvjpb6b1khu8sp6lb0tuxfrHt8q/GXfVbsH6jXUTLv64fPY1MjcY
MCn2EATemRmzUJN25GpKY029J4j1vzOel5vYnNOc2hDm11zW0D2jMz+Jrn9J
yh8faUeRAzXa693mEe/bj9UK3whYfDrHczLvpyETVDqckXjLwQb71fMOvjch
wN/82TZ03Vfl1LodK/7NZpvJX/fP8mHxz8SN8i0E+jjw9rYN8p7/9md+QhQW
1Gld8Wd+JXf7CKVQEPbw9sV1Zq3ot/7/9UoajG+QOi7cTv9+qsAHVs0o1E28
ovAyngA6Jw7X5B7MQvVhR8TnQ1b8vyaVcw+eyiBg8dJApOUdqR4ixs+q3LZ1
WZq+P5/xajhmZikMsVV3Nx0I/I8u+Py+zkwpkDqzpTfTjRWYPj+oHmyWAr+6
l+iQLSu85H4eqBktCvUHY7YbTXBAmFvLtyB+MahDHdJj8xww1PHqq7uoILys
Gvgeq/6ffqYfxoWtK/7VC38Ism/z6ffd5OZS9h0Pmg954yuZ2UCYrEWo3UqC
c/m/V4drCINz46kDlttJIGv12WxZUhhu9Pe8yHYiAUfe/oDQfSv63sp393qp
aEnCVnXv0hsXGPEUEWIkQt2NC6jARuo4bEhd8XM2FXQLC2gjQqdGapCV3yga
dOZpF/80hJZebz3k5UWFCOWx/eulRpBjN5uQMn3/fPINdp4ZL0J63hsuN53o
Qts8uNzkXvDB5wV8ndSHX1g+5oLBCevon7WYv4YJz1x+6Zt2NDTKsw64uLH5
WcctJuumIgjClISD13alIudJmam60H/7MYtF3CbZQxTWj7D2gNWaTTxfUZPD
q0+hzCt+yy589lfDud+itHNfFMoSu1FRqHfIqdqv6G9+VgbK0nO9gT/WjX4Y
CzKbHWXH6qUVMY5s/Nb8IO13pdBHsR9F2jS/P/6S72/9SiZ+8HpGEau6P4De
VOd1ns5e8WvWcfxGy3oxhqoaZi7I72X0O8yjTy6THvsDJrF6LClp1fru77No
nTfbpXc4FuhMO8PNkr+MzgWMPDPhYMHyP+ZX8Hsz963o3TLWv5tBjW2GHROI
7FHJU1LGgVdJKvNzDxZIqNOsL5lm/pffs3GFlWdoPQv2/ZYdiSkcX1b0ZKve
N+9bMqXP326xvLLrLBD6LlU8QFwIflsoGsseYIE3rjPiTvTzdTjBdzyeVwi0
FrI//adeaNVQheQ1ibDGod2FyY0IUsn1uIRbRCi4mKrk402Ea6N6I2IfRTC+
MQOftCnoLGtuo4C64/x91p+SWP6ToY/w5F703OGLK/7Q7tnqbx08GWM8nHjn
ZPGeRgXOHZt0udGK3vUJR2eD7J4Vv2gG/5lnCz9VTkIYlL56aPc3DCFRG+WF
qm42LD57qGaeOVDGBs1eEpWlL5hhlctj2c8b6XGQtcaNWj3cP/JLzDAvyqX3
9hA/NEdez3C/PIfpXzHqqdtb3yg3a1Mhk5Yc2Df3T38XAji68YabmNP3k00G
J3v0V/yobcfCnb/ZCsP5PylaRpVEcGi4Fcp1VhjuxgRJKHQRoefCUys+/S60
LrrpkngIFfTFqe3vYRQtfvCTtyePIAumDr8v9SLwRWWXEFFGCO6cORyRWCYC
CVZ3uM3XC8FXn1Pasu296IvAVrej9PUsoljCeThcBP6rP0eBX3LiHh5BIpDh
ryjj9JKC1fdyU679Trs2hx4G8STvYVnRC6IhmeiXpiJ/+yvS8abw5qoBMrDD
0FLCgfUGQ5hesejjUwqX6fPpJNNl6qTvip6ToGRnqMfRSZRYOfieR44Z0yf4
7/thguA9l8obcqcw/HOvxmB5604csK9ROZYX044W3t7x2UhfBy5/hrPMbjei
A6M3H3Za4iDmZpaRbUwj8l1swVPo4+dxtUfLgYDpLTLiH4HBKhur/+SnVlFj
tc99wfqX/zt/hCAizppmLNKD8qsqxpqMCZi+M0N/If5tX9ggfd2VatGQ6H/i
pf/xH0b36f6634bD9K598OmUaz/p8e5toXVvAnGQpG9+i99sxU97m+eQfKgr
/99+5hn8wJvftkZNnxXcWTLu/NHmx+5/aueqFnYL+n61VkyRrZ0V5m7Kdz6w
5IfWkt2GErWswDmPO/1YggsSOX6mvPTgAq8+kXerrQgwr/DcbKGT4ZeQgWoa
97IFdeLhTR2ftsn0ip7GzOjFZcnvK3oFjPXplhtWcngLEb54biFuCmXC9ERu
HeasLxT7t5+2dZiHIZ/JCIZnHFo0qzaoTyDdzuTOnTw8mB5TRPRVoyndSUx/
ltGfHn1uYkbiwDQ6y/+iY0mSjOWXGXimUW6j0jFjDpBSse6RZidg8QBvdsAN
ZhMitHaf5XG7QgX5OqJN9wEiuE9qqXLcpMLyC1dujpgV/2z9//Xn/e2HJAFg
lFK3liAMMx1Ole+N6HHyO5+9Rvp16IOHccqnY0TA/wgqx4vWoZZpr54PmiOY
vi5jf3k8duPCrN4s0n8tf+zNhQH0T/1v1eIvpnhxHCzcfdJVUEnE+tsP3u+0
fvJGBNO3UBb5oGl1lQOuzDk1zeVyQgI58NGYJCdEVvVRhTm54Jrwde1J9lbM
T4ZRL099M67UHMYJm0JsllOjRzA/BH89ayH0gQk4fyVpzrTzQV+wsAqubg7T
j2HkZ67iD+v5nhICrmjXG7PnVvwIDdpiFS4exYOtQuC3PR+EQONbK+5kMB60
H5kYpL4WgtzOunSROSLmt8bQK5sfKr9fkEABlkNa/Dg1KdhyNurqS7EixOdF
ZlE+R8L0GaQe+FHaF8Yw/sJ/72cMbao2M7yrxwnF34r5iulxMEN/8kz5U7Fk
QQIMH7J9derLMpY/lNIc7OsZYAe5bi/tzSQWTK/k4WBoAkGDvl6KMkY+WLLB
Sfzs4dEd/BDIde6bxQ420Dvu/d1EnR/TPwiZQh373PBwRvRPU0zNPGI3NDFK
o59HI/3+bqK/51EfqV44/z++4v/TT/f3n4CUD3hsf7U9d94k8QQZ8gTGxb7p
ccMcft23GPr9SJ9mDXLZxwTnnGz6RX2FgRWuepVrMUO/tq8wwUASwHxLgd4a
EnQO7rSkHZKE9uufjAe3kaBFI/zLVgkafFA9EUWxFMT40Bwmr3e9fTOH2upx
CveNhf5R38TDVtIOWsrVecRYz73sQ8SqT1QsHukzStHOuk7F9NmE2q/deECY
R1dLZ8ze60oB33cpjzO3qRi+v6WmnxD1IxUdSOxMPHpV8O9+0BJB+HBdZLPU
jQVkey/L9gmhHTHiaQbO47A/HIHz5YcPMgFHw1qkMH62zEx+LOVUG6Z3d/1/
+PAvv0f63280NC29NE6F8jZdt4b7BOw6I75girh06BFRGD6s7bt1DE+PL8yv
rulyqUU1fQdqdI/TIIyP4044rQHJ//x+v+QXG5hdc2XylulHuTVfHffZSsEv
Pov1wSFd6OXVRKeRy6KwKMzbuipjDElVujQJVUkA5UTzqa8lrBDy513kHX1J
MJMlPnUsZoXGFxWhtPM0wOW5rruozgaUzZTscyPSsKDudQMGOUEnJfiOY5AU
CFXj4ddZXjDZqc08OywNjnJUg/XSPFA6zM6JuycFkclMDr0t/FCW/OHUYxUZ
OBAZpLbvuADwTO4Sj90tAxOdz9cd2i0A5fz11lZdNJgpvBWxtxIPH/ccO6w+
QwOeDt57bAV4CBMpq8m15AHVeq3e+pP0c9Bu054nAbygZPrFeo0OAfYoQsfl
BhoI7P029yWVHgfeN+09sSwAs8ydv3/S9yV5y9RTWwl4mOxOyZ1IIoJRYs/X
iReNyDknan8Bff1lzVzV3WNPBhXapRN9LVTowV8P5tpMBo/8vVQLsjB8su5c
v6+TH0xuultGkVjhM4U7uJRVABzfixRsH2EB3S2mRgd1F9AftyM91dvwcFjX
UfL2S36oGOtaVZVEhunT7TXHv/GD78mypA3vVur+5LPlUeW+S1j/Q0tb/UDn
BBM81vrxjjYqjOnJZbz57dtoN4fIX7d9FohnB7yP2eWlKSKIdT6L/snGAWtU
Dz+7byP5Dz/OblTRIWdsF0CFQ0Ke0eu1WTC9yt889dYn6HgiC9YY/eGln8fl
5IDDekzw80OPWmDYFALTo7GyGXgQfqU1tS+OAvKLC1NuL0SxeIWRDyigNbVv
y/mEmq20JR6yCcJIACWFN4UMH87t2Zsqiofrb8RmR5vIIDH0I1NLkgU2jUoG
uZ9lhl2KAaybaCwwFXzZLW8VMyRqxEVLHuPE6rP/fTpc4MQr6//qMhfcJi53
xfZKQjxL4IgXLxEq5UyMVen426v3s1mWEhHD15kHCaHRQhSYv5CxrX8nP0xP
hsgXrWaHZavfqV4EIhBNH62Xu82Orb/g9MMaSQ1CoBCiY/YtmIjhccb59u6V
zxzRjgoePfwfpnT7kfV7m+amzXNYPIbbvCP/AnkJ03+JTDG8YEIRhN265zXv
0/hAZomc1pK+Ut9UqdyrMCH7B1UymYfXberC9BcZ/TrNY69dWvrGkIgZ66dj
GSv+EIz6zcfnjuid5wx2PjzeVvNKjWkRmch3d99mJmP7JaO/yaz1LWHwIBeW
38fXNG/blsYHvhKu2wN31aG//cyZmLbYO+76pbiiJ+vT2fYntYMPqx9f+zKw
e6cfL/b59qeqjs/xfBgeVZxY0vwsxo99Xsooal4UL4jx3Sqy1Z8fuULErjOr
WvksFghh/59+7QevUg4yaE4pe7m2jmL+E4x6uDp/uM/iBAVmHPCCcvdW/FAZ
8dLD+oG+w4pUSPuffg5jP2XEYzOe50/V8whDtq70YgVZBsNPcl4LbJfUpIFi
eun2bvsH6JPNJSL/ZhnIV9Ot4yzJRj9bVN3Uk2QgWeNzmO36aOQZmy9y5xUN
cmK2asDMJ9TxW+pKQbIA/Dj+9nXrpm50p2R1gPhnMThSa1HZE9yMCqXvOKi1
ScDgDudbEcXtqHbW5/XaUkl4tHa48JBqK8JZDBb0TkhCVfjZCivVXrTzes11
WyMRyKdeYdFoGEb2MrtfbvhMj6fP8ZY/ThhCu9ambN7pLwKRuma7fbgmUE6x
+3fdGCEYI9ttoZ9OUDbhz8xJfx7bcAa8X2twoBF3kXZgWAZKYotGfH7j4PO9
+JGvmtJAeDC4IZjIAepps4Fue2XAJOAz78897FCi9kDnxjoZUOfIjQ41ZYe0
QNt3Z9JlwKk4/SGhgw0EdHW9VMPpuFpYoZZLiRviFqXxmfsosKWo6PSmM9ww
3X6D96eLMKicErr05CU3bMSVcFzoEQaRMxy7fd9xA42n6Iibjxg0vt+fndXM
Dc5mn6nr9kjDol+Q4BUnLuDu+7nV3loa/N9y31/7lAfEXcXWp8k0IpOLs/JH
mQTAOSdNtiZWEo6c2xPXy8QHwzpXB0aYpeAEd+XOoFABcLpEUHKgSIG0ppvO
1asCEEf9rCpEnw/KyLF84ywfRH+PeLC8JA0hZ6oMnqrjQbn4grT5XT4QtTqb
oDJJhCJF/R0nWmKRqrSVe1gcCThXq0/fe3oBVfDYyzvakuGqZqm3v1sXcjVS
XKUZS4LGu3POtw52IyXh510GlmQImpF+riXbgjZ1dFyUaibB+0EL7U8eeSi0
3tbNjoUCR4WmZ2+ZlqDy/SpG5BEybLrYEd2f04NkD5/vXaxuQm/Ddf2KFPEg
Wci5+wVPEzIeUgWLjXygbttg6Kk3hAwbWzLUOnhBP899Q/OtYaS24Wz2kQdi
4DLW+YY1bBK1fKccy/hEn1/3TuK6DafQ22UlPZVlSRjW39Fa3DuJvvT8JDs1
iIFm0eBHNEgA44X8VwpZYuBGehrnTCVi+juMde65ynH+43kSFi/1G50eDl9N
AT6ZLE7cliEko7kt94U5BYTIpRdS3g9i+gUOXI/2nFUYw+rZPhPR932UZ5Fu
GvudTHp8U/nldJjYo0XUv30drdGKCPsqTHtfuy8ijX0Rp9iNr6HsVPamZ2u4
IGtb9VMTPB4MhHOJsupcYLbGZ/x5dS/Kqa5Wi6OfD6NDfraz5Bk0rh3FLu7N
BXWVa07blc2gLfl3jz27wAXX31eSLz7uRhtTH7m9uM4P1gpHdjHRDqMnZ/v4
9/jww71f4rYXd+OBr7f+nQtBED7b9R/SqsXDcLUF0yo5QRjz0TSOMOtFtrrv
G72bVvy1OiZPa3s7kMCgou5oZuQCtp8z9rNC7977qHQG65d4j3tISlHggMZv
euLzdDzBiAcZ8fLvHbMcExQOKDn1Pin5dw06zmR6kEV0DKkvWMm5ji2g89FE
FUudSWSRyZ+4I3kRtZ7cdP/40UnkqDPL2nyKGQKZ236m/JpBLTMhV51XMwP7
V/ldtWgGOb7rEDE43IMcA6bb3rHjgCxYbiAT3oeeVUV8PjHDDMurtwvI1Iyg
ybENLhy8OBBpPu59594wAhdla5dZZrBViXTdy9+DevzPiaYP4wFilja8NPdB
JLcHfR/n6M/tnhnPDw9JuPdI5EViMhEytlddjd1Bg6FPa34nFRPA5qfekbNi
NOh+GdLlmreSz77XeqH1wSIee57iuaCnEEeAzZosxIf7F9Ck6amTa49PIh7+
K0Nf2SXAOT7BsJbtMtrm33T0uZT4P/h54qDvwT1wq6UBPWXdkXr4hgSmz8iY
f3vG6jLiDnVh9ZKvGbU/aB7NGB9Q/pr30y2LXzG+3/Hn2WekEgrROrfer279
NPhbT08SaoY3OPzO6kNLRZEp3NGSf/upyUrDhGT/sLBsP3r50nP/PV1p7Doj
XlntKzL0M7QLfY28Ej/aLA1edWrdjuQR9ML1oZm3JC/IWfuV3Tg9itTQTSSZ
S4JmId78H7enMLzYOC+s47l7Epm+LW5qnqxGWlMuvns+LSB0nb+q9tAUsvZe
w+OwOIVsJki7nB5Oom/ThvvWbZtGus1qp+OSBOB++PTQPM8iemlI+HHxvCA4
LYRad+YvIJ8CGS67YQJwhE7JmM7MoIGdmWu2eZFh4El78GP7ZdS3mKHLdI4M
rcknh7/FLqN4hTGlP68W0XChXNbJdjYwECzWv71Iw/JBjOdRoTnL1trMAzcu
q1z+qiyN+Rswnv+ij9Kpy5t4YObcJR5qQgNav7A64baJIHitd8blBTWjN/eX
FJ4cEsTq9YLtmavOTQpg82ejp7aZR44A3MtfKPO2lYHc/B0Rs62CsOryBcqY
ugyIWk9pFXHiYeCmC5tcIg02LTg7ZS/T443o5ett6l/Q33pmhaj23IZL991J
kMAW9K5WrRUx+j8Y+5tooMB1G1YyKB3M8hbQqcXwirPhlnuCSckokVNy480K
ImhR2ULdX39Bcnftnsh+pMeDFqlMgxaVqKZxY2jDcRIkbXTc8oBSiq41jtUF
OpJgjwo5L/y8GJwRKdvl5k+Ew6pbxl0u0+BHRYn9nU8kOMz1bf6xJx1/pLcw
e6ev6K99Ntl6wwhW/OGP50x67g1Z4d/tY1efHfmPfoRmgcH7iHL0l38U/Z+w
tvRtB/rfc+yb8D5EkIasY6sF3OWo4GD1bGDbbh4Mj5pkBRhs2s4DL55zSms0
j2PzmZna4noskhV2PTvGdMBYCnv/jPdrUro4nlzGgo2HhJoEJqLYobs+8NY8
SQbrx2bgYVlF6v77kRzY2E6wapeYOzfWPzJd/UeQrY8DG+9ZvwXmK+jX1Rqo
ve78//AzEwDz6WO7lgUJ2PvlC7PPdhkYQ1YR1YWaLcWYvjYjP8d1fqo55uAI
iiso1vR+z43xPczzBdP1RYVAN/vHmnzVeWz/+Tn+5RDrhTnkJlD7GDzEsXyz
o05OxkQ0DqzyeTonOxj96/MoIMxxU9TllfzHl7wDvim+RFAWOKFsPEXC6q8c
3B8mJa6KQH1x0oDaDwpQmvfIHrYTwvRlGfmRaF9rkXtqv1GsQ2TLQ69CpN3m
asrj2oUK3YII7s4cENg0NiNK7UFfd0xXWe/lBEHVTS+UgruQ/xoxM6s5YYh5
8EPuRHM3Slv32p7vhAic8V/sC6nrQk+iNDMfic+hETkxVsvSSXSJtruTJj2P
yo2IRssBk0iGffh7lo4U4KJFH4sPT2D9P/k0Ng2a4gKihbJzh+ULgfj8J7ZX
l+eQ6v60hM2zZDDZvs2xzmYW1SS6nvqqTIUjwpb2zTcWML5f6CpyboncONq5
52aV+KcVvWrG9SHpL8zHvk2jrH2d2Sa2otj7UftW2yz/8g9ah84VdI4wQziE
GF4XYIGw5Qmpaz+YYXJkOs5lBgdOepTFk3I46HMPYNahSoDUhQgIz2fF+KLZ
fd5FTrF8IH7hTuEpMhv87adDBf8B8fuNMXyQ3PnEl5V+/3/7LYtCzODF67ES
/LDIMe/gNymOXcdTdS6F3xODvqFTS2L8eNA4YhInMi8Dz1R55i4nEqAmSbOc
M1kETG9rqgVbUiA+7FvhGEkS06f+uHl/471iaSz+CbjeMGcXJwPCWtupxUZU
kM6/2X9QngZ7X7qlps1QYZd3wo/ucRnY+zWxZaOIMKy9eyLBehM/TA7nO1sl
sMH+rWskDm7mB0t518XFejbo2Ghe2BciBZzyF8ovnqOCjMHzR0EpUrDHPFD1
vgkVyDbCrkkbuOHWpbk9j66s+Ove0jYovSDwGbE8ujbXXy2D8ZVeP2Zn7XAW
+Uc+VQSmljZJ+r2hgkXczqZ8IVF4/pG0Td47FxF98Wlba0WAEt8T/IySi5id
lZaCO1tRZo2Gt2OVEFRFvr3UOSkDzqlJx/M7hOD0GyvLpQw83Cec6zl0kQL+
5CZN1/d4mDr0vXSPMwWC7Z2ePF67jAzk3joxp08io+Yho85jkoBLJl0P5iJj
9fTlwIG9L96s8FNHZoluRfRzrTNF89CvliLE0KO9YisqYvgah+lR6Gg4zn7k
XUCHP8k5VF3Ag0BgVdFalQXkt7VGPtIID8VddRP+N5ihhxZy6WLYCHLNr39m
GcAMRFmVycv+I0hwa3f7b5kFdMXj6sz0Eifc/WbJnj4vALhw+e1UdgKs/pGl
XLWVjkvDKJrkOSFY262QUsWHB977q5JUS4Ug7c1h5qxCIlbPmnYIv7OZmQIu
24nhI4ZUoNgUbZb7KQHVcul6F+nzwbdeT1iOtxWV5hc9ing8irbl7bYp425G
hsuV3MEfRtEB2dO/k3OFsPoto54Uox0/bM7EhNUDeV0/XS8/uYy0O9nHjHcR
sHz/rNRmz4S9zJifWHfi8UtZNBYgJF/mOz/FBPqZdcRToZKQ+VU83z3xBwq+
ch8lmkqBRuWpcj+dhpX+Cc415bv5BcCb0tZ2W1oK6+djXDcfeL1mYl4Qtn0a
ZBa6S4/D7vGUXqJ9xvrjrqUpL8lzcsIqF2+X7TCJ1ReSPYKirwAVeDwfDPA3
r5x/UiDaprCtByX8xusdPEwAHSlxvioXNqjvto+WO0UAuywtfmsWISBXTJ07
G0uDOQX17LufCTB4T4FiFvwUMfJvwnI9ob/Pr/gHXnqauv6TjjD8hR9MhSH7
zOTw+gUiuLlqmLWFi2D9h4x6M9vZxauHNghh9cmxbRWiSl5UAJ1mNY+rXuio
U4KTy6oe7Pf+3pi3jlY4ja7uVXWL+jqG+SVcOoqrbqjBYfwY+WqdJrteHFxb
u7RlcmQJndxp/0ayHwcDzNb51IUltOuZ/uc4ThawNRYM2Lq8jHS3Cj9vMBWB
DtpXlWQ8E7zp1Nh8VQIHn8cswuTCWGBs4uymS3oiME07XizYyQKX2fx4DpFF
wJu2S1G/gAWoGrd6sqzakUFAh5fibQ7Ane7ez+Pegbw32zDFW6/4hx30KTaN
DxWCYeOY0x9S8Ji+/dJhQ8ut7UQ411h1KbCTAnOXEzI1Gongs/+rgtYABT5a
b49SwUnBOv4vsnW3yLCkSv5srykNW7fJTcjeJUPYrxai50Vp8Ajo39zkS4a8
Tx1zTgdEIGtV+w1eOr7pKzn6/p2BCLQM5vR8JFABXye03kiNH+MLlagHdn92
wMH6YZkyzYf8wH+LZaJWdg4pP7zvNscqBAOhG2unEOEfeLcNUW+u3o6PZvST
TSCLlHTnmYlhxPC3visa/EcugALNtr+Fltu4YU2moNNLx1l0IoyqsmuKG4J/
q3++930W668TIq3/MfJ2GNE81K1jOplgY68PMSd2Gkks2l3xWUcAvds2Azxs
XeiN8DF9Fc8/9HPTyEJxlBnz4zsTJcu6Zff/+ntM+WHdt4gzOqOs0DrokRRs
9xmlugYev0aPe5c3VJ8/7pOHuje+e06qx8Oj+FY484d+fxtkbDW1JhHnCSOD
dTgeyH23qnr3zwksvm3o1w3z0OSGUpHAVylfyRCIvy3x4TIHBD3Q97iwigyx
Hb+MrxtzgNrPi5EhgRLwPNnEjYtTGJxf5l7d6i4BorUp91x5hMFtJtQMRRLh
Lz1zUyK8ZP7d3IKvQzeam/Wn5gfR7dQ0wuPQWfTIDLf0gX8ITeEb81DILKLx
da6hPSRCc5vnwZpSZhhieXoaVzuKfJm4H9914ISD7gkqGX2jqGBIr231ZU7Y
P6PQle8yiwJu2YXtUBGE1HmFZK7NJLiSoOWdtn4B7VCVGI5KlgYulcOEK4NU
2GDVnz7xXBqOPVPJ1Z1e8VNKMOKfC6tn9NPwg4dEEOpNJoOXmO1uO72D6B1P
yYlqnyXUduj8dc2XRMy/6TTf8aB2VVE4mtO1P20mB3F+nrQqvCoKc9GKys0s
OVh/S3Radp/TRzJkd3c/zhNjwfaXeZHcF2v9BGFG0vCIaL8QfL+z59PtfEE4
H7+PA9ckBHqOjt+XLwnC5j1BZk05DD16CVi3V8LK6BsrxpdY827j999nCLBc
l7V/+qEk7LPUYX5RQoUAx68l1fT4VmuCury6iArVvqUyBaX8GP9jaP89+Xd6
nBASf+LtdnEu4C6/vdNJkgWrX6yXaPb3eUt/z7XbHijjmGG6venoJ1NJkHZL
z4zjJcEtb9mdq2wk4Qbegt21hYjlczfW60S88RaEIweq93jS8RrjfGHMZ1HD
k0l2lGWUZ+TS94g+X/YHxipMKFLhQXV6ZUSKOEx3qzsIJNUhP+X44+AoDhcs
e7OSF+ux+D83/gwlIo6+Psuja1qvSmF8F96nZuQxdyFwOlOv75hLx6tPquNy
RKXgIq6jdcMLKkyGlTu0rJOCPLZIgbvhVLApPq1Ud1YKHk03me12+996Bykw
VNBjO3+XCtrxd69ya0ph/ltXKjikbDfLYPWU8pJnOzXe0bBxndnapGvvOjE9
+bUjavfUTcRAL+Dn9xKLUXTyNlnEWVMUTi79OKqvMYhIO5bqZNdJYvy06h2i
R17vkYR1uuuZAu+OIu3qHR8N5STA0nzqWKHzIHor37WQ3i4F2gcNtn6aaEce
Vs8G3/NLY98/XX9jythYBhKqVC8fUO9Af0wytlGCZLDrhvE4ReNxGqjrHMSH
8nSh/iV//9IEMsTD62MNlsOYHlhFphqf58QQMnd/yn6Vm4LVn7SWdoynXRQG
u/VHcus1RrF8xkehma+hNSOI9/fLwO3KIhgfQ0krpTcojwp+F1UFpzOmsP7W
qNsurzfzjqJNHgducimJ/0OfRBJiviuFSx0ZRUXFKtp+/QRYb/twLltnCdMT
HmG5/mZUYQkp2a/G+x8mYn4Dkrx2Oro2NHjI+qCRpI2Dx22WXR/OykCBTU1F
sT4LVs+J2SKts0eJBSKybT0vDMhgePBLb6LGLFEa3C58+7RpPQeW/3CLj2De
KccBAUMycm96aaApnXglX5QDBEZXmSu5VaLEj+PB5ha8wM6BTuiKTaGTB3pe
ZJau+J+ut3zvxPyOC15fPejxKmYa8/tj/B7zzdeOJYpxg4OJ7as/NgSM/814
Hw693usnjnFjfNcZ8aXSzfHccCbWU3DAQQa6ZqkHcl5wg0X1eudFXhnYNFTC
m7SJDx40bMM30ueH/Vh3g6QOP/Z7/OsuGHLQ4waniYiafe4r/noMPP0oNSUp
V0gQuo1KR41uS8AMzfv20n563BrLfIClvhvjY2w4o+9ur88K1YrBdQ21BCyf
8TPv6z3ySTJ2nrILT+wzOE/B+Grl9QefPQ2vRluE3pVesBHF+I6MfkRLk9ci
Px0GMP+kHHMV26smU8h3cmzbpUFB+H70y/a+4wuYH5/BVHHcbTwOGPnCg5pN
J8oXObCxR6CXRmQ+N4Y/JSZTZD+HcKyMSS+zawncWL3qesLULZs0DmycdtTU
ZLGO8b4mEL6P76ZaMyM/wQa444PtXXM82OfPRqUZ/xlZGVeHCzvsFeXHvu/k
d461rEUA47tPe2+pPDK84j/k5p6vJbFFEBvf41Bv4lAQwv4/h5Q/s76fCVi/
YyxznX6TBAlcOf/IH2ESA1ma0qjMehJ0/iQdP0iQhLJw18MKfVSMX+PENedD
WsMJH0X5ymzTcfAornJSTI4Tbq07Jt9RygIBqot8DqKcGH6NIeYY/ZJfuf+3
Tqu8p17zwbv8CmPF3+PIOnWTv1kCH9Decmo4VY6i7e56Ord/84GL/+CSRqw4
Fn+nbHx3eq2NOHAP77LnSF7px7d63/LttAsRUp7EdZXyEYDCofqkwJ0INwfN
Q2QShODb7nDx/hd9iJFvGdtS22T0oB/d6ORmbb8thPnvMeqFDaeOF1hw9SLp
Xp+mhjhpWCOt0Owv2oP5yfgpCoue1J5BudlpcTcPjyG7J9tXsZ6eQRueXtLo
yBxFjUwRpSwRM8hONN0i4ikRXErGSRppo1j91sqC8ihpZBo7j4SunHArgxFk
HamXZf+8GylFe24xapjD9Bm1+Kc8vCvmUPu2XeWZjgSQirDo57g3i9WP054i
Z9UL08hMmSfghREVy4fcafTs2ddIgc4QUc0zgjPIufyJyvWNVDgyVOt/9M40
wm+6e0Q3kgqXxCrCw/PnkYHwoffH7lMxvzYGPt/m9brAa54JXOMqJIEiBLTR
7I5PX5hA0tjgyVYNIQi5lbjR6xkTDFSovLvn+w4VnO5KvafIAnzlPDtkWZjh
K/uVvXwhrFi/RMzJMmNxR1a4q/1IId6FGcMTjP4at75x+5s1HDDcESzB9l4E
ns5MzBBaOaCakJO1ulkEVt2duJXewQFHuxvNestLEUNvkRG/F2/eF17FyoPt
H6+pnpQREW5sXFmo8SW0jAfus1B5baityMdKQaNDhRu2eIntUj7fgL4W5Ggb
nubG5uvkM3vebgo35PW8Mg98No4ez1rE563ihsyG91fjlcfQfhKNf8mUG9MX
nT7ZbjhoxAOPcV33O8rm0A2p1sEuLR76+XDNasrhBxplP3jZbJIPqmKPeYUO
VaEHZ1kePf3KBz13xiiiLu2oI5vNJ+4jP7wck8gJDB5DnCInzNWbBcDd4+Zm
vbAxdOL0+VUG9LGdb1HammBWcOl71Vr8Fg/1r9bxv77GivH1GXg03X8udViZ
ANnHL+e32PKDprntlP8aAggeWXZ+1MoPj56qBfBIESDgK694xD76fqNwjbXf
ckUvvSNVVQgsV/SchyMSN5dvJGLjIrUtnNv4ScC6SedZZxUdt+zbu3hhCxHS
gmt2iRIbUOpytUSEGQMfS0DZeOGw6Ach6BhlLWs+JYHFv4LG52m6Z8Sx/BEj
H+fZdNz47H4iTLllto/4LqHENZXJO4yI4O226vPX/EWUWsquJ3eKCJ8F9vVk
VVGx/Clj/7mx84Gy7AYyjNg8eVaYMIcOvant7cgmw46gPKnCsHmkVZNVUp9F
xvgJ36ndrY0tK/lzyw0PjyR+oYLxpUPG7WQ8kO5fRK6xVOzzOnKpb189okKS
y3WHMi08hid1civNcZZ4CDh0p2z1IYa/rjQYLKclvxiiwMAEj24yGw38RkUD
BCWo4HpxwE7SkgZKcjPTqJKKPf9MJ52u9g4qRBYK0Yp30LB84Asuc/15+nrl
iZR0VY7qR2mhqdGbr1Kx/Uz5YU7klyX6vjPbrhHRxwoVl3X4csNHEYOPe2SJ
Oliyewrt3ZPjafiSB3ZnBuPvTUyjG+eTnFlu8MBtl4XAfRUs4Kv25maVrwCo
Rt9a9YBLEG6deSBpVykA1IxPnSK3hEB1SY8/6bgQls9WvMz80tdECJ5ZrMlL
vTmN9D3ItUElZOh71ClWHkICyr712+7OkuEs745rkS4kzI9YVGvzN+NKKbjP
zIX7spcKYbJn+w5cEAW+Wg0PTfr8btHUiKMdFcXmN2M//hlM1tgdyQo9JzbZ
XqpjxfpNGf1he67bLbbcx4M7e7XuIVwT+ssf914jElYM2L333f/86dTEYGij
gnpq3Hs0nZh4kVlcDH7ttX919/UHzJ96dGwo6lOQEMQpuz52rJYBySQ5gYjz
BOhtlZ2ypY9pJY+/3z1HAPnxOtMbDTLg6PuMUktfbxP5tHk/LTKGV/87H8jQ
LCX7KKt4GL0aioSzT2l/+w860cBc7pXRf+Ivht/b1Z97VeZZV/xAfQI6irK2
jaCL6dcPrnOaQd+Xj/Ze1BpBmuumL9su5iCdmvHiNyOLKH9//FRY7Vf0UNAs
cFvqIj2etp64+IKA8blxFgaysssLaNdykF+6Cx84eQsfuLEwh7SlogdarFbw
xI2NxgVRS1TgSF1kEoyQwPxzGfz3ww4NFa9+8IGiT0hwn5IU1k95wPwAb9sG
MRC4/TvheSMRbJOscM6CLFi+cVJwr748jQC8tJaiF58zsPPa5PsVbX2/EpTe
LV5rx07A4iVP6jeuqj/SWD8/o3+sOTapkLe3A8N3nhHTtcilG4t/9bopJk8Y
foP09fiWczLzgMYopgfAqv9TPKJ9BmXX/nn73E4YVPzSmbJVWDD8LBddqSHr
wgJW47YDr72Esed3vU419uFOYSweYOT7jrNy9x3jZoFTIlvZLXp70ffPPH2k
fHbMDzE+XoT5Viw7lJseUtTuH0ZFs1K3y47yQua3HcpH6LiWcb4x9jO9+tGr
piPckB8d9HGXTD5i6JUwzj+OxdgLynG88H9dfXlcjG/Ufk1pn5q9fd9UIpSS
5T4iRSklKS1IlDWkDa2SNiVCKEVEkiRRFJW0o1QiaU+b9n3/zfsyt9/3/fP5
jBnNPM99znWdc53r3DD4Ua/2qRmx+mEekVlNAvXd6L9+xL9R250fK4tCBaDs
S0pBk4UALBnTMJOn8f+rD/xWhP6LfFD20WVq8jIPtNH2uhSdJGL8+CRX1rp7
ngjOOSfoJ4d4cL+jgCDK42AmBQJJ9OmNNiTYuumnylpvKTDZWi9kaUyCaLeJ
wN3NVCBPzdl1PSXB5pW6Di4iTLw0uGDsWUPCeliJVK9yQhQJCKvfv+6ekYb1
jDaFjU5kOBZz3nSVtQyet2ThKYP+VTPXd5Ah2y5qX+tIBzoUMR3sbMHkH08y
+Q98/4U+bnJ/ZMLkH/oqRqkf+6ZRZq5Hs443FQpWTg5yyU1ifzdWPlfYFjYu
GUOFxqU7lbj6Z7G/W7OSla6R0QBqauKQSjf5l28kOrb77bhBA+W3Qpca986i
lS5mm2nn6fjzLvVfrNFPoMFZ5bf3tEK7/o8f8m8U1McdffwAHUx7qh5THw/j
/jPr/SfkxNnsY+nAtpdyfTdNHqJeVK2k0oRh/ZK+G7wJcnh+iVVPMR4LrTFX
E4Ysmxqedy7y2F9uaWtmWGWLLLCTJcL4yjvQMoOfxcnMeGPmtmyju0UnevOR
bu/uIQ8JnKUFO7Z3Ip+lke0fDKWAKMh1ag/PCGLxMf2uB6lTR0fQ68OCH36M
y0B2iO4qn/+vn7rf9Hxx06tpFOeT8oo3mAEhfWXdE+LTmK+NGLHti3DihNRn
snebD4nDK0Gl9+PbOKHAkmB4wF8CRtVif9dEcmL+wpWSue+qJg8M2kVIn9fm
BDGbF+vMRHkAZTZqu0tIwhWjOB8BTh74YPMsMKRUGiS7Z19VlHJDb0fGM8cm
OXgUYKKvKcIDPfHy+6ra2tGq1rxG3UBm/vsq/zaGbRgFHt6R4yYiAMmbNmlw
35EA033fPpQ38sETDuErkTLS0H9wMf1mOB+Un9wTp/VTGpwiex1P7uODmvyf
D4PbZYAvso2jr4AXQjei93uyZeB6SN5zuWZeeGP9Y6vhFznQU/McyDTmg7N9
99asmJYHSiDFM0qDFxTMdUNVfeShRfH78fUPeeFw4rNbu2PlQHztB7uqeAE4
TqxQbxeSh983AzPWqAhA8Xa3QvYUeZDoMSuhpRExXi0yPOKQvUCDrRv45pZf
H0NGN+9dbGinwe7M2TFDEg+EbAp69VmFDm425y7wnOUBJz0eu3hlOry+kbXB
UVAC9ytYn5fnGWjL1cKA+p6pzZsOjqPwjv6LklUMzMfXf6TPfb/HgGgB9dNR
N2WA/d2VxTkPGaDoUFgwESsDh75me8o/YsDQmLvaxQUZaBt2XqsezwCLDo6D
1AEZOEVvdjBK+NePez+r6Hr+AwNWmC65eq6ayZ81c6eiUxh4njp829PgiNsi
8NBBNm/mkBxUBiTEnzwnAms+WX/Z+7oTRfLNRCk0CABBm5fUcqgTneHZ17Wd
iXvDrO9mJv3oQcUrdB6UIUF83gqLogIfcZDglexnF9vhAfRr/+V0zWEhqBns
khOq6EeHNI9ovB8XwvHVeuiJ7WDUv2uGtuj5wBgSyPza+pP/RDU6fXV1/gNP
EkyaRxmmE8Uwnj3+Jjlhpl8UxFs+PWaPpcJKWTWlxzOi8JKnIzHWgwqbHEo5
XXTFgD2Ea/zFFAVKtcr2ndMXBmv/GdkhfhE8/9e2zGzwkHQdYgj4qGSbUYA9
eXOPY9kgzpfVGxKVj+QOoZs7yZxNthSs39tTVP7it6owaN1XFiFfHEXw+sir
8eU0EIyMy3O+z4x7HFbRlU402Fukf3uHzSTGOzYxR2bWb5tBQg33d4UycaI4
1bLENmIGVaVPhwfV8ENrVPEgoWEGz9OeONgYuiJuFhlxrSlJNOfH+mSNXU4W
p5VK0OaMNotzvwgYL4rQ+Xzzzdhg+5fGvmmg4Prx/z5fIaKwcGbmPXkDO8YX
r+6N2riPceL+0ZaEQ6SK27zwOsRSlWsnGcTW8/k32vNC1CdtedEoMqSa81rt
9+UFnUaqqp0DBfoa7neFlfPi9/8k6NoYPhaArWvPZGroTaE/+6T5ofnUlTfX
JbmxH9gfvMUDJ5e1OB4xJUIxee9aDe1H6NFd8JkZE4DHJ/2zJkIzEM/6hqrM
CiEYv93SJB3Wiah3uOctxEjgdkk287lULwpfLmczzEeC8ul2pwStn3ifdMC7
O0evvatBtMq7A1QQAusLB9Y7BX3G+5r/8I0qdG36ZoCBvRDOBy7hDqvnThCh
d9dVdQ/9CfTDvVErxpsI7yyi9fTosyhk0e6RBA8i5JXtdMrkE4KIdRPqaY+E
8PkuHNOxo4nTwDd35O5xU+b7tQkbfKqo8Gy9xYUVSXQ4ZRuZ7DZKw/429w8N
vb5eQQM6ad7SOISO5w9YfgNZTWK22eJ0qM9fYhhbNYH2mMbNBqTTIeLqi/1r
FKZQYrX3laa7//JZgHyzHeT98xfgIwzkTzxgQOK18Y99Jt/QtW99Uam5InC0
e+OzlMMNSJCyW+QBE6+nxDwVrv4xhJb7nSjfdkUEphdxpVlXjvwffD+MGgcu
Zkcx40WeeW2q23U5yL//QP6RjTAUP7vc+dKL+TpXz7WiJ5xwZxlPmaegOK5H
VP7SY9Otfoee5VcWqzbwwJAVabW1czT2U2TNA4T6Xm2/N8YDD5VEGUc8SvG8
Gt4v7NFVIHSVDzZP7Kv9vek7Yu0/tpzgftGcIQSCcQ9uSDDjcrfLyl4zKyFg
9atZ+47TcvuN7+/mgfSVol0PxUbR/k1sxJdMHvDs5vTWFDkuCEpfXcCjLwBH
f2sLTSlwwUq+dLVp5rVsN6+50CQX3Fv8u1OWiQc/+VN3XNs8hk5w8Ocldwvh
+jJdPPzLEwKrnsYB9qv73kxLCOF5qqKfJRKOHhT8/F39flMzfScVf79U6QNO
mqdp8Hlj8fIor2+ItZ8e6bx3vLljCAk3OtALd1Dx/dC9nnds01Imftr/fp32
Qh8KjVouciCYBkVa/uavF4bx/BTr3wteNsnZsoYGzk3bLkVFSsLdlV/5ZGWo
MMEr0eoXLwnms+TId0JUiFuf1MH+XRL+s3/qviSUn7ifwcZPhYWkrweMmkSx
39D+aOmcs/1UiKb+fI3SWPUSJv7ccvvygbtkONd/+FEzJw3ayfeUg+PIUBiu
PNm2cRjvA4YbR0eySijweeWJ/XzOXSj0+V0Or0v1iOUnE28XeynxoATo2GgH
T//MRPalVj2peyVAbpVovbXyS5Qz+Y10663A/9lHSITNFmlHVjB5WGFIwhnX
okG03cCjSp+Je3wlBrLvCIsDdauk0eVeJh92VshrpXWiaUHBwlWTZHhyzKzy
ti0dvPQPDiUbCWN/PpGZ+3th8Rt0LZYxd2qSA2IjdiKLITIIaD4v265Jg+je
U+t2jZHA8RpdQUmPBqx5QLsotawtK2ng02zqcp2JtyuunTH4LNKJ/uuHIQlS
NzqDri27iZJsHS+WHJQEp/tnzxkdSsT1y1MPLhpv5eQGO5KBi8tAJ2L1PwfZ
C1W2ShehichVRbq/RcDBe71h7DMC7sc4TQ1Ojp2nwqG1xk+2XueA+WRL1/21
olBd1xfVGcMBMiYRYcXUhf8zzzKPvKrJZ66EEkGj2DT3avgEisn53hbAR8Lz
JnIRil8WWf/bf3JOkmvzXuY5TFiasfBCnRPvH3ervPxc/TAnnGQfe8FHIsFZ
Va/jQsw8bR/0QG+JDwnAjjdcz50KmnJ7mn97k2CTXUjs6CkK7PBb9SBR/Ddy
PCLfbXieAhzjrx1HdXqRtpvPGe2bzPsVMB/blz6N6iz7eN3PdiHhOvkEj9Bp
9Mj3U1z2OwkwF93cnLdnBtW0yj9PnJXA+fN/42OfBFx7caO+jWcG2V8yFirz
+40Seh7kr5HmxXxy81u9emT/b56n0q172vA8H7QLpkeN7x3C8Weu7OjD9zQZ
iC13ll6cQ4UWdm73GHkZuKh1p/TqbSrIV5pHerwWATnRQ3pHVRhA3dKpzvdU
BMoW7ZOTXccAKI5/2RIugv0Q/jwPIjC4OPdolREDZr3GmqLPikDzL87b+0IZ
wNE2QCNWyML+DftDB8//QDs9VgXMhMrCf/ytmXzc85K4HMejj6hlajI4PEsO
1jhHJ7fZVaE7njeqp/XkweSYTpnmugY0/ONi9+C8HH4/i++83py8XVj1E/48
76UPbz5vbsSv77C+Y5Ze14T6PFbcoQtJwvOWqSnF+U50ydOkNq5H8v/4B0rC
jyiCJlh2onGy/of1LjL/fZ2Jf9lv35hxCGpDC0/5s8WeMeCqSvl1d/sBlNHz
TKN0VAT7t7L6UR5Ggd8c24Yw/3GTaL0RKjKM+5PrPC+ot7dPogfnjJa7/pbF
/hgs/BsfKPbzly8HXM0cGOrQlYc9NQKn+ZwWYb431+3veSB9EcRqsVVp+0rB
Fw/bbQbj3NB3j+LnMi4Fq82n1277zQ0yWsNLy/1kIL5emtsuiBv3N4eF+MVk
9/DAiwyzxz1Zcthv3XycKltYKQvdt7TklnHz4nrmxyKR9fFbeWEH4k4KdpSH
KefFSXCbGybYJuQd3Ubx/CxLLzhT47rqeBsTj30sOs9lJwNHKS6P1SMFMH//
ANqPTlQK/Ou32h+7M58sAEUH3w3kKsvh/Uqs38PGr3/0fBMf2IYoLHqbIovr
Dy1neXt9r8jD6euOfT0P+KHnhcxL7U/yYL+BsCTlMD/uN265rJZ+3V0QNm4z
jxmLGEetX1I0WoOIUBR+PTYnfRTHF9bfv6SyMcrzKhHzH/bXc+eOJgji319p
8In/XW9ByE/7yCuRLQvuc0Y7CNNCYPo9V++wl+x/938zf7/dcd4Bj+RJULz2
g3+3khzWu/0+sDF0nY08lFk4XmxaT8L+ZdXFclazB0lwbj3/04sUeZj9mOxV
cJQEl1zecW5ikwcl6lhJmyfLL5YL1txds7NNg8nv7k98JlL5gbdFSvQUhQ49
cUaX/Nbwwxtb/ty3JDos32hASF5OhsRE3Q8GqTSMj3vCLVer3qTh+t/JyAcr
KeY1qCqqxlZFXBpaVC7a9Rt/QRcTHuXlXJeBewopkY/ef0NO+76aBl4UgTH7
AzXul4eR4sWqxKq4dqR/Laqmo4eG81NtuUXAQlkL6sw+8KGkSwg28TFQpRIH
cIuOo2YVEq6nsfDQK8oi59xZAjiulo96zIxbB/SffX93hgaByhPKPhFUGFgy
EHrW659foPU2RvziMQa+/uBdKv7tgzC4nrGO/rypGs0qx3frPhAG08YuD8sN
snAoPuhpwJdmPB/yZe+uDIGBDvSsX7o27a4spOVVprpVDaLuiqgPV2/IQSP/
FhP/ty04XsSazc0snR9A4pfe/trzXBJqbVSp1LJ+JGslBSuzpOGGLCVlZ9sg
MjN/PLqXyQ/f3cpy8fzMDetIdxVf2iygZG4S7fJ9IgheKd96YqMsKBIbL/Sa
kMDzyXNPn7UlaO76ZqW5FBrGY9bryoirrtDgynHq7qq9nSjauWyP2TU6hF4d
78je1IU6xSdoYMGAngJGnbRtD5Js2EJU2cTA/Lf59cz1exLC4FixV6Ju9yAS
0G6Z1uQQBvu80p+yxrIgOTr06CyfCBi6FBW+tpAFXv2lRl8WiYAr14vWy9vl
QX/lGZpWkwhsavX/FsXkAaeHS+x1Xk+g5JSTI2+S2lCUPZcb900KSCRFmL5/
xgcc1y8KBG/ng9dB7h+ijjLPnfHi8G3xXPg8ifHk8fa1vESs+t8rR7/tHh/m
Ufvr7MXLHzHPf85a40svSZDTYCux4pMc7g//73nKkwN+bj0p2QcsXyYazLy4
uKjzzL99vT8Vd3cdk2LyibA1RyKaZOGWY5Peg1IO/Dzqjmdqlk5ww7Gr1nWv
9olDpnvzeZsBbnBu+LwQ7cDMvy7DUsD2t7/9hQrTx3N0i96z6o/SsNPS5Myx
bhFg+zHF4ykgClYrLNGjvd1Yz8ZHbcz9/HsI5cZFXV0lSIN92UV6R4WHEWeV
okKaKBXPD7CPulOeu1Jx/P/TD6CCWeK7aI1XHHCbsiZAe4EM7mDw+lIIBRzG
Nn3YR5XB+Jb1/xk4zL6c9aPBQyen9LReOdhkdLfvuLQobO/7kGCTOY28vm6w
XdNK/hvfphH1wLBMxCgZZrX1CCqHRDG/s+2/11vnJQqjn+4/Vs2igZPeQ+0p
+x8oLzN0adl5YVjIdXMJP9yEbj3j2KHnKoz5hUOSeu40bRBxrHC98fOTGPY7
6dmhdHdsUAzY0ymELAEKKA9N3Gh+X4EeUSi1Ms5UmNFLf3Rs7Qd0gPBVK9Wb
Cqv4y+vKd9Jwfy3myJGcziUk6PR4spuq34763pWK/2LyGlZ+ZsULmnvSfqGW
dqynC5Vk57hT0YrCOWPCt/yPb+Bffxwfb9G5Gx8HUBSjyVkMWH4og6huWajd
OdIUOpdjypk3ywZ1bTyuxZNEuDd18rENgQ6OpgrdRu/++g+102AJZ015V4sw
3HSr2Bb0ehhp7e2L+GrI2s84gu6e171AVecBY/n1a+4sJkNllubsVDMDJj5f
EFq/XvCvP9oi6BwuXvVNRxByXm6/LeG2CK4NSmqPbmHmmdXyWX1yf/3R1Zl8
pfystbMLGU4n976i0WkwsFe0nRhBhmY1i8xw5vPV1bjwfX80GePDg41KlyR2
TCOHxwNlm+q7/uLBaVRSY5quYioNAkGiQk80mXx9ox8jboc02NtdLtZXoIPF
LrZFGVuk4f3AB+I2Izo03RJdo54qB+HOMqWbSwRh4EWOapy8PN6HcESu4MrO
fDKETe9Ykx81gzILlmZXfZeGyy+8dKOyRSCWK/CrEofMf/td49Lwmbjt0rfn
IhD2K8HnrDM/2G5VqD4j2IiePUzJXMjmx/N/rH6YUU2O7FelBnRl3DQzJp8K
xhWaw1yvm1Fu5RZPvq9UYOnpNnbWx/A6SWG9ECufDQoYckhV9aKdqzK+OryQ
wa+z4hFl2PxQNPqN9wVk+Au5Bxa3I4WC2NkaYEBt0YZVjVVj6EdYtk7VaQbe
z8rq7zXdWbdY8ewYMjOLP2IVIAFe/UsPdj4fQ365728dUZAA7UA/ja1646jc
NY7QMC+O+SCrHykffP6tusUsGre1Ja1g3p8t5Pi0TN4JrHcrGrcX/Vg7jk5t
4AlpfyyN/Uc5P7VZnX9IgpuF6ZY71xKw/4HR2Q/ptQwCjo+2GZ68MkkE2CgU
rCSqTMP+TyEf7878jCXBsjUSJq9/8eD3m7h+MjzAw9IzKUCzahJyXsTSS7Gx
PW04OLXNhR/7rRhqqVsJNvHh+b2xnOV733vzYXxn6/k0iT3kH567/eKL2Bo+
IhgqRe+xfd2OyhIVMnMFiUDR9Fl+5FUbuvhFRDBOhgj8a471iEq1oodvC5Nf
r2HF+3YU26UnEL2UhOPPydvRNzQCiBDpTpkcz5bH+PCHrM19ITZ2qPtumpCu
RIMDcQ+O3X4uCpK7Hlr7LKPhfl/h135XI0UaMBJiBMNKRLHf1OOBu/0PhETB
a37xsSfRdEg10Vm3gy6K/fEtpNaeu/JcHmLzgt1dYunY3/EnUdqD6xId3uR/
Ojh7ewztV22yjSing9bx+NcqS8fRCo1NKVsK6UDJkKptH4lC1+Rq72cwRGHO
UkB49/4naKLOIECLmVceEvZu+/lhFOkv9Tqp9onJ0xiEo8u8x5DrUb5xsV8i
MEX8HH6jQR6c/ZYqfI4Vhu2Cjr4pLTJYXx0256haWSUD64dDONRWf8X6yuQP
ZvutnLoRW09G5L7HEnh+lXxXd7JCSQLqX7k21MX2oF0an7mdTkrA2awLe/WL
u9FtGYPCEllRzFePrawnHCOKgk7w8+NGQjP4/Lz66Wg09ZAd6zuu6XCPxN/m
wfk/We3du0NfeXE/4Kx1t7DgeV6MZzc68F/JuykAwfdG24IVueDN84q3upsF
sB5u1SWnT7OWAmBr4MDQSiVB9ApKzlq2f/OjP7a+n6l8SQb2ZWmVjuXSWC/A
+nuaToxVix+m437TFsEv2+V16BhvGWtX+NwPHUZUmUpi4ttq5D4QfWuH7TAq
TdAW8X1OwXyPNT/DGZZQEKg2jP0gn437CK25xAH+tlzEnpdCuH8c0C/ksmvx
AOq6/o7YySUI+9Zcv6I6NoAuuRp8vzDLPA/BLnolm2YRqz/K2Hnh6iKzWdT7
TTIrq5EEMp9PTByQkMfzE5+FHiVOMvnCglpxTRbzmq802OPZMBl2pKZNnLhO
w+dtI+PkSw19BhyQPZPsKCEHPB6npu1NGdAYrBujlDGHPoe9zVy5fgglybr1
LjovCmUhb/1cJLuwfnf8skyORGwnWpjXfldRKfq3/9iJxtxruS7Vy0Kq2zHV
LPlBjKc19kpVzMgMorviE9GeSjPI7IrZFE/4GNoxfx49U5/B+9n//PsZdLHZ
mj3eeQxRKM5Hd9BlYN54/b1D2oMo4e65lUEMGRhBlRcUE8YQtdLLtUBC5r/x
F2Sg6eHB+xPizPfzdcTUBcmAmWXEyNV1o3je6LHOCX0IGUVc1u6Lix1lsL8b
C38mnKNqlu+eQr7hhemD75l5/uCnbz1ac3/vrzC8sCD6ZPfOolfOwbOV6WLg
cWbztS/ukyhbc2vTvKQ4rEg0NlE9PY/nF6X8yji2HJxHJ0hJ20T0a5C6yRJv
jwcEXE+t/aaa6B5JgJqdq5VJLg2IFY9ZfHFUwduPQOSEfYszpONjZKG8xGVE
aY4DUlrViJsWBSHW85S9UH50p5oQGH9+eDUmnsXvhWF6f0HJ9zBu8DvgmlaT
x7xWTmv7dZkbaHUeMep3JGCJqH6qxHVOHL/rl749/OAqJyRFn9hCzOpAa/WI
x+4vZsV7QSjRerySP40fHr48e5yiJAgvecodD7/hx3rRoy3ndGs0+YEgVMnZ
vZyJszU/ff5mxo/j9bzQ9yM5d//tN7x9rrKbepgErr3CP7REv2N/t0Jxta+R
P8lwyJh6vEyJBDE1t+RcOsmYT7Pq1S82SC3n0mLlA1HQPdaScaSWCM+u2t6X
+CkCd7pN0t6VEcHN/UZvjakI7MxMJmx/SMT6Q8eN/NlSDEHwJPgV6b8XA/WX
D1TVRQUxP0jOPROxgi4IFVXz4YkXxOGNhO+rVhFB7I9/ZdOpTI8qIqS/m3wj
e0gSapQrOcSLiXD0TtPqObUUpFn6S0stl4lLew7syrYZxPVytcC50E5zMdij
v07pfgkFDBtdNvtvFcP17EvhWh6Unil01vH7JCGOBgVNPkvfevejtfsm1+9U
YMDWA5KW2e8H0ezJffuGBRjQ+qrNav7eEBINeRO/d+LffsBSnVTlgzMMfH9k
pESXbi5igE6zk+i7PgLEWfuqlzKvp04Hc2zL4AAZoe17j5YzcP8rwSpw+c4v
DOirUZScCuSBVwuqgtmVDFhcdNI00oUXjKSVq6Q+MuCUI/Hs8c+PEbySz5zv
EYbGeloi9zVZmJi5rvCmTRis21sXGd4Thv0Z4VZBvH2okm9xnF+hMMZfrPO1
+viS0D7T32ie7QFh+046JLGnW9JFJ/D8kVuvg9e9qXHUtPbF6vOUWZQ3xmFw
zpAL+w9pHQiqtV7MBWk8w9n7Ns5hf0/W86boM3baah0Pxgt8GwovRkXzw4pb
j68LObHDqqvlNAthfthi9UCtXosAxXdNVe8q/5svX6l+Ifhi9r9+CjupmCuI
+f1LXQav2/bIYH+pP/hWBjK+UDg6tUQgwO9t0EpF5rn5i79Z52FktLef67oI
bE4LzHjY34qGn9r13LkpgutP41fnlvUvDKDcOVOh5ypj6Lnisiul0wNYn9yi
n3ojnGMQWdzc5cRdO4xWM5527Z8dQCw9Wavm6rl7KylQd+qD4mUveRj0btAL
16BgfiCacexL5wURSFM/nFjq2oPks1fpnw0UgSchlw23DPSil3F6HScDRGDJ
945DmkxewZo/rVHQP2V+hwyNr6eqng8IAw/VoOzUfTKELvl0RbNZGOouVFId
lcQwf6tpLlG4JycGDY67JHp8/36/PgnwHxgsGXFMQy8teUIVRiVgllv9q8zb
p9h/y3Oi9HKY2QhqP3evYP/Sd8ixVH2DmvoISlr3nrPa4gO6sey7kOokSx/H
AeIyESeDQvuRro6rSYEeB9iSr4bmRPej01xp6259J4BTBdmgX3sAsfL79YBr
0TRvHmh587BsQPEzKpkrkw2P5AHP6v1Fyqcr0GS5nbjYISrGA10nRtnUv4oA
V3hO67aIz8g3uMqysl4E4726EP0bnhEi8MBLyLcuTx64DXoV1Jj386BD0uzN
a1Q8X8PKN0u416nIhrYg7Qt9HOFz8yiM/0mso8UQSpl7K7lsGwHrs6f93E91
LieAdaqzSsrBGXRc3FBw+RIC2FT5PuXbMYOqjuuKF1R2o3TZTNKHCXaI2W3q
8K27B+97+fP396K6Re4nO4fZsd/7PbLC6eknc2gAzM3fBInjfkzRecJtrvPi
kHrbnv180hxaZTR1MqeTF86BpKJgNy/Wg3UY5+mEfeYF4V0CirN6vMCaV2F9
P+uGot3rt3Jg/WUnx/XGqlFuiKY+LZHYQwJW/5R1ft9EWC5V8CJi/QNJK/tI
uj8VpA6b+rzUKEYammYftHr+zW8L3JgTq+j5N395xPaG39cMEXDMu5XnlU2A
tue/I5Qr59BqPbty+9WS4DIZPxBX+BDX73YFw1itTRKS3xxvT3Tbj768p95d
nD2Cmp2Ngz6zpSHZLUv0driNoBmz348rw/mB5R+hFCSp8/g4P3AsETWJWTWC
uKfdjTWKJlHQO/eUj3yseZBJVHBC8qKPIjewu+1bNTPGgM4nZ+2KPbih6Yfb
JnREGB5eUyB6XmT+HpnZh/lCR5Gzk95JtQEKpK5OmpzSHEOsfMCKB3uEdeY3
VVHA6ENiS4I6FcZ/e9IbxClQKVncUmdAhUNsUfePkiggPLwv9N1rBgx9FdOJ
uCWC54MGDI+Nr/USAZMV84MCTQx8Pv/wT2G4NXzalFdcBMbyXgurabPBtr7c
X+r5RNBbERFmy+Tvtd5vYsc7qJDDnb15A7cMeL82jpn/QcV62hOHl9/n/0aD
4Up/s4piYVBmpHzh8RSGDrWMU/7MPPBfvZowMIrY3C5uEYadhfeXLQ6dQsVX
X22UUaJgvUCXvMqxPglmnpcjvQ4emUKs78fCe7+rxGx9TYrQ0Pdb5+qXsObj
qhA92dprK5cM2O5Q2F7ytQwdl37YK9wkjftHLH9R1WOXDZ/e+oj5v9ftnSfy
mTziOF/MGok7MsD5MD5GtIoErYnXGxpvMfHmj5OlhdUkyGuQzd0c/f/5HP2d
T9m+VLv29dOnyN3/kGLK5DhaUm+8s4A+iJSfV7hpLptEqSqeT47pDCK1n29U
v6ZO4H3cf57/CfQEXI4wFAfR8Ezxk+ZlTPyn+9kkeMkwOqzwc1VInyhcdKfc
ckqZQjm3blVk91Fh2aTB8wsFBJg26GvUzOtCub7cthmr+aHS+dgxxonfaOD2
vMfvYT7QsdO/zdubjqKlldAdA37QlFvea61RgJ5OGgacleDH+gZ57X7azbX8
0HPtRtqJMAqcWwh2yc4XgLU1O1Iif0qCVGneDYcLLLwlBfmeE7kOXiSY/mH3
shFJ4XoQH/vAjPSFCbQ69Hon8qfg8yCWYk75uI8ClxM0V4o7dKHoT3u9c9/T
4Oa27sv5tyfQHA/h4Kb3//bVrehXUOkI/Ou3dF8EerZJ7ehw60Fgc7HFpkoE
roQ5PRfn6MH9tnMuNDs3hRmUWF3Cc/TKHCoJ2pxwvooHlGmVA7dWzSPLo3Kn
1+fxYP7Xp3MiTZzED6Np6a4P182hwtGbYfvl+eHWlafFh6fn0f3AD9xFZH64
ctM97PMAGzRukqrKEOQHbhmdGJ6GBbRti1GaFokf+z1PzltcNTXmg3hzJzXJ
ITp0Gl6XPW7IB1vVZzxEY+lAuFGzT1CPD3YMln9SWk7C/WcW3vxmUySocoQM
VmmtIg8iJYD0TtTsqhAZUp/XWgWrSgD1i5/jHUSGpOv5EpSuWaSfXvXRzpsO
QZErJd69m0d3pJQLz7vQ8feLqGUQPjHjgJiUVefA/TnkXazotzeLAb57H7gt
f8gGM+TUPbI5DMx/q21z55qYeI+oPNW6QZ8TNFTOtxQw8c3NZ9/ytB5zwYvI
WB/BGgbWC4+KXnm7qZAB+9nCyf68fPBgWnfR/+j/345pNNQLC0Dyk0dHBHP/
9WOeNVOKTHoJ+HnzJa7SdJbiAIuXRsezpPLQ3O/6HUk8HJCxd1e55UE56Ll0
M3BMk4H5zM+enfv3vBSG+FRIq8sQxv7FW+2PlFT5C2P/ETe3tTHOar1on2t5
icJ4PbqldkLorgpLD92A/dGLgn7fv7m2AUVK3erk39H3V+/zHVWa6BbHtAyi
9TlRpMDWGuzPmVESMtQ0MoL7y+dtanLoGj1ow23jg/m68tCsoShgFdWFHgaV
2290l8f8mNXPe7cpcXuZejcyXvzYUV2ZChs9ZdpIW4ZR4+72xi+8VNDuMqFa
6w7j+dqN10Vc+adGUY4gfdCLIYz56rmEuxX5T4lwZHP3Im3pOUQIvl91/CoR
FO/c3HSGMYf3LZWfO3jmtOoC2nWU80SqQDnen8TCMxvyfXZmvyHAsvfxFmBB
h+ywQ9K9fWyw+f7epzHxdKzPY/ljL6s0B1NtdiBE5qbxL2Vj8j3VD/SLPKDz
2mDBvJMNUhM/DaY68ECpekzPZiN2qI6Ulg204IHyvCNvKgfZcX/5D99nh5qn
P4OPreeBMvu5fPEQLti1Kj2g14UHepfkHfLT58b4IMiilLD/2iL8/j/PHxfs
38b/TWIXD+RPMZSz9MlwRooc7REpAIZnSekRH8nQpDXf+uyhwL/488CLJnia
H6y90z/pnZ1EHpw5/hon/s2P8ekZLU7eRoRo3YqNRHIb+hD5OItjCRH3jxfz
ip1dKsWKf4IQ4F0iceeUEJ5PtOGwzDT4KgASQRuWyzZSoXR5wta0NgF4NaE3
lL+PCp8GeD4QvwnAsuwzv07fogB7wIrK/e8FwAUZjIhqUiE1oFbvcrUAyLYt
bHny6APe38g6L8us9VYPpTPjbWtmjffZMSSsdPlNyzQVdFKe6dxwEcP1IBbf
4z8qbd46R4WDNvXFv1zYYTNbe4SvGA2mLMMyY704QONb6zXvbipMOQ0QTy7j
AGmpfRn3B6nYv8vAjCAs6sTA/W5K5tzbohk62AxJjHQsZT7fW9fx5zf80w/f
iaNHUZvp8DL+as/6G+zg5GSwxucdE4dwbLjnSuSG9c4nyz5WM0DF4AxBlEcc
VpU3/UqoYmA/pQa59V6b7zDgcoRxQoKkOPZP/3Nev6Mq7UPxP7NEcL3QkF3v
kNVbYbizavCj6FEyjDlZnvnI5HGdz5+s5iwm430Hf+opZDg6bPZg1oIdUs1j
nGrbv6JmsTbXAebztGXBIKDj0Cj6r5/YGLoamFfDlcUP7cXt1/8nTwR83pMf
HiUI6XZKFGGpWnTlqdVomy4VduWfIJ5u6EVFlymBc8+omF9R1u6SEvxIBVtf
h4I5+QG8v+Gr+TgtpHwIFfNUzew3poHFtzmfD+RhRDxjVG29mQYajl/bDnwb
QfvtC4OFhssx3/M6YeHKp16FPnMaRd7rGkUsP3q2To8DwhniuL7JwvefUgMN
7e+S4cDh+Cvwi4Lj0fU9WbpbdMRBLAq8ObwZIG44vuo7kQZCWw7e2bXpJ9pT
c/KQ+3YKnueXyEzjPW9LgeG0guUH3PuQ2JTI1gcGFEjSPv+maWYAdbVwtpXG
C0DoK1tb5UezyEfjCVu2C/P5du/l/L6OBG9WX9sebEaB6rc1hu06JOw3xKtr
5Ey0IsGEJ814IJMCKTImT9WNSODLva+Lz1Ie1KueqTlYUqA7ecEsYK88eBLG
kgK2UqB3cS5N65YosOopBvuSxHc8E4WWXwuZm1bRoC10w7rZeFEYjxk0WGdH
g9VRFyTN9aWBVW8XVH4qbrVBGig/D1hmJdHBwDV0ZzTzuqJlPibiER1Gdmdt
iTORhiXB4wHLe+igbjLqy7VFGp5seiS06wcdrKKDU5s30uCDz+qMlxJksNE2
vbyb+AtVVIk9OlFGxvGiKkekWLKDDGxSkfmCl34h5RDRg9NfyXD4pK6Edp0o
vKJ5b7xVTYXfa6on6Z9F4VvEhjAf5nlUTAgU2Z0qAS49PlZjsc9RbGqtxvoh
SQABrdKdYQHo686UsfgCSbBUMBiitl7B+0hyTbbc8FEcQjadzmtuli+gJY2Z
pZ2GQ+jJstpAh5dfUZyRjYo44gGBbOXku6ga3dT3qAg+yIPnz+q2uhXyl1Dh
xa9YjtLt8uCb2E5oZl7X79hFeH1cHlT5K4S8S6nA3rThTeVdefhYoSOaU0CF
SB0tYwdveSiclFPyKmY+/6eIlJ+5dHx+t4+Uzco9pkPBhroI3koGjme8HNl2
ewiicElVQVhC5QVizZdx1N3aPydegwL7taNflonA6xCRD1XD1Wgzj7ibUTmT
T4eJfJs4SwB/+bfPqHGzqD7LdUmWHQHea10vcaTPoucr6QeVgggw6eZluKdk
Fg0lR8VWSjB5TtJxVZP6XuQQNy89wxCBJo/jx9O7e//OkxHA+CEj9JUXk2+/
Cgj8WM6O+/Onicir6DY7CBSaB0+eZPn1zKKZjXOf5VT4oXifq8Pm3ZzQcF3g
atwtfvCyCnDu9+QAlr487PaBe+qci7BfIWte8WqGeoNNFj/Ox5dOV6s+yyGD
YvvRNz6cZUj4/UOGAvN5cln0VCTQdxDtjK8Z7TjC0tdWoPbnfNo9TSKQ6nLu
fBOvJN5P+L+/r7gkZNRORukRUpAh47GGg9cI1qs+VXw41lk8jvclKotEmxov
ZoBwqg359BsHVKVqQfXspePPC8rf/O3kBA3UEpuf/+yoRMPyLoFeinTMp1j4
YLePEHd+ySc8/x6+KTF9GtUgvT1Di2VaaZifsepfjwrZ+A3Uh9CmVT309Ytb
kf50QLDPniHkuM3d4vFZCVz/YNUDVhw1vdL7nQeEBbZK+H75jVza7fQ6hHmZ
/PKcTZhpPzqzdTaPe4yJJ9Rabpz7JgxpoQeq3+0XhkFvY07RH2J4/nTQ4fTp
uH4xSKu6uJk0w4BaCf5SC0NZeEZ4kHdJjYmLYsrs6K6ycPDT4YagvE/o86sX
P1R2yuF+WsXq7Te+zXFCy9UbRybie1GC/apvc7ac/6ffzAlDHmxdDSq/EQtf
+91f2ZTc0YNaZJyaPjgvwvO7T4uEjVYGy8CF919i97/vQ1wvyu5Vm8jA/ToL
2jvRAXTm605VFScZHI+1hpb53rwvAHo7y2UU0SCqT7/041uPODzWjjzX1DSL
WPqU9xZJ/HsOTWA9xCfN7iOS5wnw2huOXjhPwv1fC/mBwKnfDGCiYfOyZ3/3
FawSBvXEMs5G1Xl0XrTdmniVBFv8ZQ8SGv/17w7OK6x5tJcb5+NtB6nJN/dw
4/mNbJUvxilaNOh4/5wuPi6C4+/3ZWKbV92VAIkPS76HrqFByn3jTLOP4iCQ
s2lgyp8OEa4hVS+Y34e1P44sEatQ9VAO2KWUfctEGNB9LkTmeLccnv9m6YFW
8H/6FizEgFvEyWQ3+0YUH50zfEd8FoWrtu8eWVKHWP12Vj3KN9k+4O3GWby/
yeFsdFxXxQzaFdHrH8zWgljPX6rFU6/FyxdQdutmrSoP1n7xeURvzvG3LlsE
mbuGRHXXsOH9R6FO6sfOGEtAO8cLv8/RzYg1LyHZbWgZmTKILpYGVY0xeVr7
0MEAfZ4hxCtd2bx70SyiayRqqzDxHaHvYxH74lkkX9Z6teg9CVqMH8wkL5eH
K7490iEBFHiYwdP/tZoGT+NCE79doUHuRtOJY3Q63vfOOo+nuo7pjCfSYD46
04JUQ8bP764mhQ6zAGZe8rCq3Lb6O2LnSvT/upKM9RYsvKRMXBc/ueM7sk4/
8iXAXhzgV930AKMNWbr+NqL+D177q6fR59il86tCHNc3WfhDVk8pb0VBK943
t1Jz+5ctJYOIcTre+fbhabSvgbCRcnMQ7fAIOhTmMo2uyD1+2MS8vrHxsPmF
COZ98TcdC+cfwvu4Yow06yOZ+azS7LKc0ikxqO7TGZW924H5jpHUrrfSGe1/
4kWqLFz9eTzNnfl7Py5K45Zlxkd0J5JvrHsU8bkePvw9VgL3D1n16LOETN7F
lDFcHzxs4+DOGzyKfHaRj8VpSWL+1XntLqOnTxIG3RzXVkWNIJY+3jyS68P6
hRFEL007czVVBvuZ/m88vi0Dz616lh2fGkEN7ztSKBeEcb2Vxf+ll0jd0302
jno7VV42c0pgfUfQ+AF2xikp2NW4mKrgNomEyu3tLXlY+6CmEGsflL4V2dTo
5iTWu4T7tz0cZZtEOqCasviKFN5ftpP918rSnQPoJTqf4zbxFx+z9SPJHQb7
7YfZ8TyG75j691vWBMh/W2oh9m0IMXiE1y5fSsD9L5nsogG1Z5xwmzLentQt
CUvNHD/K53Nifa/WCK1p8BUniIZYb2zbLgvOjz4FJC3lhGbGpt4oC1mwOyCs
d3QJJ8QVic5kXxbEfmm6VM9nr0YlsN8e6/4UO9g8mE7kBErv4Xv0i9Lw+f5P
rsFCTkhWeyWrvIoIbqlG2/Ye5cd87O0Z7l2yBD64MFCRrPmMAvs3HCSrtbLq
1zR43tt98MKMAGzJTFWtUqbBhf2qVot7BSD6U7pU0kUaqNb7006NCgA73+M6
1WV0yAjfEJTFTQSjdG/vtwM04D6/59VtNiKu/5geaeUMXEaEZd+kD2y/zIDX
knID54EIm3NdWrhz6EBp3xodIk6ElLRsQmY1Hb4G867OlSLi+oZP9NlEwzNE
6Iu+VHqELAw7k7a3CNoQYYPQ+KVDnqLg7peetLePCOuz1YQFeMUgrtg6TYNL
EIRDkupykQQoiKddu8e8tlNVvh3xWQKeTH5U6OwlYj2vYcKE6Mk9RHjx8vZ4
hIQ0bOMNcP2tQwS/2Y8zvwlSMKC3gbDmNhH3/2Le5W9UjaSC1m2ZsFQ2Xngs
Wf6ON4gK3Ev57/Ev8MCBXwUL0sxrNksLk40OsuAoGyuz8xMZphx/NHxcL/vf
/ajmskAQztjwu5GM+9vflcoczqaR4Rb/kDjDTRb7PTCQyWGLUlko0LB4RDpM
hrz2M3ZvBmTxvArrfIs3/FTsYcYxQxFDNKXLDZMDmYYb7lJBjOjL2/uRGy77
JytFxlAxHw6MeJ6xZysdlj/qeMf5jR0W/bTqN99Ohzn6gMdvdw4oaDTcxLGR
Dk4ylStDrnWhWxs7DZ6tFIbln9vfze7oQUdV5I6aqDDvy6X54prnI9hfm3Ve
FrG/GTzRxwAprXN6h9Z8QKx6FAvvUkX8eqOahLEe41Czb/KuCGHYlHD2zMGL
cuBs3r9S2JGJWzqT1HQt5aC0rU2s1lsYahnKDiZdssC9nVNJOvvfvrLP3EJn
dnlM4Ph68PB97X3+XJBIBUnpzTN4v3tjjJS6VeoMauw4w2Z0nQyJtXfFu1ex
QXL4y/xYBzr26wkfiPwSsYsOdk9veA7msOP8mzBr9dhHhY7rbabz127KAR3M
Lu4rEHAVZsYheSkB5vWzqA4JVVdh3P+RSpbJbkPDiLNfYfwek9fwOTyS6FIb
Rg5WHLSOd1SYcObbvUdnGB2pqamuYuLa11kpvvVbhxH7vaLxq/5UUKWtXJdk
NIyKLdWc3ilxQrfKxUP+Yn2ItU+hwMHkuevKOdRdnH/kCVUINk8ZqReoz6HI
k0Vbt1oIgoxylsys5hz6rl+rfltLDOqdyu/uNxcBLsLR82lTr/7qJ0ZQ9XBU
5AEOKWhMkCgKVJ3C/cFuHflG8oo59E5O74Rt4FfU6Zt+tKJoFmUzNnJ+VKtG
Ddfa057yMeP3Pm3qtKk49NXeWLrAP49+iMZc8tEUwnreP/dLCHT4nUJft3L8
rS/wgb2373aXpXww9lOQf/Fh1n4JMqxhPDbUfySN+e0BWXjwLFoaxF+t1okK
pwHleMtp/RhpeLW38qx1EA2MvjcYelkJYn91lv+nQUijhIsHF2y95hg/K86A
hur9nbsk2fD8JufNTBvZk2y431K4rDD1Ui0XZPv4WS46N4XntwhBAq/lB34g
l2ljLmo9y9/qOwpK9DioODOE9xGtzTFIVvUcREGG7eRuLTmw3fprNlvg7/5R
XjlIGjq9f3w5GSS6tlqqiXL87RewQd+rTJ6LEhxAnFVUj/VmgzXXRAeHpmSg
68WoUWXyU7TXVcvM5CeTlxtS39hdTMf7F62rFjri33GDvZkJZVZnHB2zumut
f50bnJ0iOrN8ZcDy1eSdFxr5KN5I5vXtLTJ4fx9HNski/L4M9hdh5Wc/Pb0T
e1XeooTpxexrOvmwnvTFtfrL3FV0nI/V6SPuXKYtaG0XsXfhwwzaH1QVsiGa
Cj4NR5e7dpOxfnvFWMOQ3hQZNIRJy1QyqcDi/911A9uu+chh/4uF5fNHNlTI
Q+6iY1fTX1Fh9ugQxSldHuu7//frvmHy7VUafb9yqBh/F6h/OyvnwQkrj1NX
Pj8hAyHddWORcZwwWhiqYcglC9W9SQb9Vpy4n+J/wKWwIJ0bKl6yWWmHiIBx
xrHMviRuqLzSmOz3RgR+HdHvP/eEG/Yuup+401EUxAvTqyXecgP9Hpfc9+2i
oLDLVIWQww0GJRVCKQtCcElAtoVvmQDUjHSvWsb8O8YSdpo5rqODqdLqt9qC
NDjEa1WwKEsEVOKlrpuHicGR93o+K7wooC4YFWBxUgxib7Y9KIyj4H4vtaV1
WPmCCKi9Scs1ezqI9N9IVWgHi8CsjvnNDV0CQJLLnZvSrUO+5Uo39mwhYjzL
mqfUPDH9fTysFmX3VlUu3S0I6zeQYxtlKxHlvh0vKUsQ81VW/PDrbzIp+1CB
9ycPX1Fwl+P/gnba+Io84BTEfPW4nVxPcAAJJh4uujOsEoo+rn3qpbGNhPnx
0xL282mvheC0mOIhW4d8pPHea8l2ByH8vLH06UE2PM8lbmajJd3RP1cJCMHq
Nm3uwSVdWC8ofht4EHsnql3izl+5XQjX61h/b7bj6u+LNbuRbeJVj32Koliv
yfKfubxhpl/rchd6RD2RWvCbHTxmrxirlHEAyZFrLI0Zz//oWTnAcrWBuLYR
B9bnu3XG9TxN5ADnI6dWKZIooPzqjFmUGA3O5jnf3HaOBsqJW2ssmHHH9uPC
aQtmvCGUohJKmCys97uQHurDgLS+ym3ZubJ4PpCVnxO3fFz1yO2v/zaIgQ7Y
KYEuy09rBoXk547XvyeD7efigtOt07g+Vjujc8Z2OxVifzwRX7uGE9qzF/m+
3Uz9Gw85IdCSXHo2pgPFpNeWsUeKwH2F4fMBWeOo8VdIpwZlECVbyUbaPh1D
c0bqalwLA0jsUsNcd00nUi4sqljLfO4/7UlKKk0l/3e/GPN6w5L4CB/m9YLd
sJs3Pz9oGT8ZMVSeRtk32LR99ooB8eV7r5PTwlg/VlHtvmiAmc95UpaTjx0W
A1XJjFmuX8JY7yZfyPNeT54Arqke5U0rfqHyz+E+6oIEmOKcOycz0o6aHBvX
tIsSYJjHek3LyVZkKqTeunYFAVQifCLUTlPhWbiZ1PyvVkS4toxH6xgBik8d
66FpcWA8E+1azMY1T4DR5PAI0wsE+FPfYc0PEsDYRGqDuRcHKNvUZRH2UfH9
P3IoW3btSSqgpDBFyyIOUFVlyKb8z5z3pc1nj8pxwmeXL28/7qbCZXHq8m5B
Tjio0/Pq2NvnqOcyid+OGd8kri2PUWlOwPPBf/BNEiI8TK85PEjG+n6h7r5o
2ykqPDlzT7iVyStcnELab+kP4nrb9K5aiq7wIKqLuyiyjswPH0hCku/DR9Hm
bpPR00r8f+fzRxG7bU/SXdoEEg9v7dznzA3PbhhWdskz85lYxK71u5jxSd/l
QPBKGghuKIlfdJ3lv8aArGuHU099EYH+XvIvnd00YPX3RqZTlXQ0aVCftPv+
8NIfaO6e6EN7YRrmv6x5i73e++4WX/iBPnlN3vMfocFlxWO7ZXcz+VJl57uc
3z/R1uXcz863c8Oee7VWC0y+s615ykU1jwovOsqzEn9Nok2/eelt+hTcf9BI
OyF9MpUC9qfZDR1MyRA4xBk/+JoCejsMnpxk4rmuB2veRj8RhunqknsNCjLw
imCmWOtWgrL8Rm7lWtFB51hCYqhGMebnS++EiDTWzqCzGh2VfnEM0GsQeHBt
Jx9U3SncfoDGAXvOBHi4ABssXXqfr5l5X/7UI5n5au/Gai8mbv5PfY35/L+R
fNp8+OEMYlx9+m1JHQlKtIZMHx9vRkL7257cNZEDz0uEBplHfci9g6NifIUo
7LuicKuPbxwp1Q7UdT+RhzkXs/ePeQiwYtosV9t0DNnB8MUd14iQv9zqxJUi
Kbhyf8KYfQUJPt6/N9ngugis1tfOr8yngqv0hgsN7LIQTH1ZPaVLAVt9EV31
TDm4O7VL1nZ3L/JWyB9a/14OFDPNvy0V7EWdGTdaQ56Q4NzRbS+WHBYAv4Vl
3ZqfFoHOy87tG1fRQca5NbX7IhcIKJg+WbaCjvHy1UdxU8M2Q5ivPy4dymR8
nEIvfI0FzPeJQ5bUysVLtVnxSgbKDnfk5zJ/11t82hW/yUNou98a48MSg2hl
2KhE4kMuYNvjVlMZ34WOUmz8Na1pEJVrMiTRP4TrEQeTbc6HCXPC2cpm68ck
MYjatfKVST4HnJ03eWlGb0f17CpPCqy5offj6O2aEyWo+Ovpas85PlwPbj5/
QL+0gg+yB1JWZt/5jV4W3j7uP8CH82VjwiRlczYfDBxb3/VwTgLaLPj8zjWS
8Ovbelebqnkx4/b8I9FGYTaYFmYPHZ+ggO/wurV6bmTo28GecEpLBNDdyKFP
koPIM4u+YVnKIlhrG6w53S8A9WZn8tZqCMF31UNJlvPy8Ft/CSPCVQSIV3Nk
nbVHEMs/g1VPU4uSWKz8iAwukSOnjUUWYb42yhire/yLjvkEqz/23Tg8V+zh
IKK5cB0sfM+H8ZXi+OinsbfDWA89vpbh77dcFNcr14R85jMJJ+N67vrQzgvb
Zui4vjimTEu6GiKGz9N4Izo0FEHF+5KfPPu2fnNpI7qzW847b4AC6/Kbn5ub
taKI5QKrk19RoFk85o5fmxw80nHf++gKFRLLoMdfax7Rjh/6oHNoDDk/ns6c
GF5Ai7tfJP+SGEfGZrG+DxXZQXmvyUKt7iTKPqvSOh3HBmq5CpYFohPI2S5p
06cNTNy2dLuhmuwiWPSOQ+xLEyfWy2TUNzp9cJeGwMmX9t7LGcAn0p/EV0L4
288lgPeuBA+beTYIWftCuOPnIPqwRP/L3fRmZBwT3oJecUPV5eVLnB+I4+//
J/9MoSPnTprSNlDg2La138WmqSDttu0HjycX9nMI9HNNe36bBP4LtfE7m9pR
5JTGYTlPCsxK+IVTCtjhpNmaeUoMBYT6RbfcCyRg/05W/37PjRXjq6Mo2A9g
FVdmk0T2DMY7XO47ItRrhXA+PM71RWoonQyHqj5qpKyQwPOGhGzhe0V1I1jP
fnjFBk82UUmwvtlP4GLy+dWrhwq3JMvAaG154+l0CpBJ6fJ+1jIwdltl/fQK
Ku7vpwVoN9GKGFiPSdqvWs6dKAyWBIe4BKF65CIoVb1nrBUtfblV/mzYMNop
GL209x4n9A81dYwcrUcNN5JtiGQe/Hkb4qsKhczH8fzZ08y4drcfglBEXnOp
ZzUV7mW/JygeIYEvMeDJcg4CHEreWhj9ZhqlavUXqJBF8PMZ63v6fZ8OGdrf
PSO5BPzVi5qTIa/64BHiARG4ver02UkBWQirVS4we1aNLq7N+bJFTOa//pHM
eGQPxddPnBjAfod1CVnJK6OZefLKG/VdW3hgXer+OMuwDpTF1SObPlOLBJsb
uD2Zv7fc5U/lOWLyEBF2plyemZ+mHeL3da4aRyz8uq2Em1ubQwz7jfZ5hchG
5/DhemFavoP/NSkx6FE/XSpm9AztpvCdENYVgwe67qouni+Rkv2h9JMrF2E+
4x9xa6aom47jqcHAaRMHJi8hetusk9MgwSbT520KAeJwxMq6jLZAh7rrbwPy
mPmEFR8cQ7xeXfzJC3PeSY86LFqRiWaG8+4KImxxXpFnpv0bGXhnH/tcLg07
HA5ajxxnwJesS182u/ShpCt7zp2S4cLxqL/KWSv2AAHMHoXpF18ShJci7SPr
wziBYPk+dYT5fh06o6yPiRvWFSzcWeYwhvbuixRSM51AZ8pcvnNvlQLGtHSr
gLAo3CoxJRwYGUTpXgkfE+N5IGKgPUKdea5q4uxTvblnUJJASYhgsxRUeIl7
XCdSMD40sf3krRY7gDbfKzIWmhEFLu8TM8eaRtFcxYlr60XEIM/xizHPi1HM
Zy0ac1cv+i3EjLvWnR6Z0oDq6x0eFArBRs/8wgF7XkhxOamh9JUIVFmfR+qt
vHj/TtSdy/bGn/lxPjfWGGsOD+QHBTX/wezdM6jsesPDvad7UN4WWc8DEVxg
3NR4NMayF7HqBSx9MPrxouuoBxfuL9YlGV9440wFmSdLVtt5i4LH2tsHBO2m
UXBIcklqMRXYoxQv3FrEAQ5rtIQnO8jwRCVwd3OKANaTZtc77W9w//f9trD3
ePl8pGP9zjupu46f9AVgdEvBo1FmXPvSNnk1cC8NSuseq+5TpMHgA70DV86S
IWWnFv+K+l+oUaZxUoDJV6SD6DICNfKw4diaVU2O/HBeQ1GiNEYeKIJdFHNR
Eu5nE+ztV5iqk/D9uHC8J5qhNYp+ZTmpr5QTw/V8Vr36xJ1Qgf0+QiC02/3Y
8ehZlPJg05EogSGsF73udSsoJ0sIeMcsSj45y8LpjdGfpX2H0H6phUP1F/kx
vmLFC6F352Xd2mdQLj01OniFABhfe52UbDSLeJxv7g7LrkIXjhbE65pTsb7m
7vmw5Qp1BPh/4WCAcA==
   "], {{{}, 
     {RGBColor[0.34338305666382923`, 0.1442836171851357, 0.5996467428062408], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGtsluUZx+/37VsqPdADPb1tKWXLRg3T+GU6CosLSG1xB8MKpSiHzQJS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtI1HEQx0dxd8t2+7cL7a77ardDDzRvaQVlJeRqj0N20JOWr6hwCbqV
hyzoUt06FKSuBhUdLIIemODr4FphHSqiLCjqYEGmlj3A+gxz+ML8/jO/me98
fzP/1KHM/vZ8EakFBeDtKpGvIZGEW6RxhchHzjOc13Lu9oi0YnfzrQhfpU/k
QExkI9iO76xXJIO/MiXiCYhccIEikRucz3EuJuYL/jfcr/BZjV78O/C7AnZn
J3Y6KtKfJ+LmPBkXWSD/SuLzl4vsDZMPVJDrHvd/41sMmh0kZigpMgaO+kWm
iBnF7iX++DL79pra0yHrrQH0U+92yuwS+p8lXxP+TrgPAYHfTEKkyhFp5v4/
+CyCO/Brpt8B7hYSs47YQfj+4v5PcN5lnCeo78X/CS4X4XATLj2cny+xHsbp
NQcCSy1HCbn7qF/N3TRoILYFzi+on6N+B73uCZrWx9BjTdw4K1fV9D3ndyDM
2Yu/HF9ZzLi2gB56yYIyuGyh/rWQ1dRaNeBxwmpobj81H8LtOpx3FYrMcecy
vumIyFbsLu6PJE1z1fqI37T6DtKOadYG91bwEvsVyJKrk/iY375pbxqjPu3x
FLk7wDTvWQouwe0+NW+h97jPtP0Ts7dWjYeJ3RSz3up5rsGgzYzOimqqWmsP
yl01n4XbYc4decZRZy9bZLOmMziBnQNJl3HQWW9DI7/PZl7v/iDHbsdyxDhf
CdtsjwGfvi39zWB/9tgsV0fN1pnWXUgHbdZ0J+bJNQdqHMvZhX0Sf5XuIj08
wBY41Dk2c3fJvRC2Wk34N9Brcdi00Znphuv6uO3mGD08In4gabbWCFJ/OGlv
NQraiZ0Pmdb6xqq1zrTOsmo+Sewz0OjYDP+FXyRls6j/hG2r7Q1U+83cfUrs
k6TtvnI+g90XtlnTHdS3v5qw3nQG5nm78oT1ohp/iNjO6a7pjLro3Q0OOsZh
n/YXsX+RvpFqlSFngd80q0Pr+qjNpu7AaWpPxW0XNGYkYpyVq/6zAtQ6EbXd
/Oax2VaNVBudca1dGrfdUA7N+JsiFqtv/B/02sCO
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.44335802298814253`, 0.3181130838836253, 0.7401736522476307], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnl4l9WVx98kv5CQPSHJL7/ssSpSsU47OqWDoigCguCGAurUCgIB41IB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHeU1dURx++y7C5lCyzwyu6+xqEK5ERjAY0gCBaQoqiAJOFIWXpTJMUF
5RjBhCjKCRjMAaSolOSgwgIJCGYRhEWKLGpMDN1oELGwCFLz+fr9Y86785u5
M3PvnTv3Oy8zdOJ9E+qEENpkhVCX32mpECqgD2B+XhRCVTqEf0AB+ejGIWzO
hLA3HkLj+iG8XRzCkCR8IoQi+HmFIayIhnAd/J15IezLCWEi+p+h3xndn0I9
kR9CXoDuRexPxtck6Bjj49CbjKux2Yjx9Y3QKQthN/oXCkIog38Z+XhsNIEv
gS/E9t2lIcxpGMIvie8R5G8zvx7zT0APMF6Gzh/wNxt6mLUMQudobgi1zH80
EkKE+SOYj2r4ANvvIb8XWX/oKHwN/CDGg6EHGS8gnt3434b97SUh3MP8F5j/
DGuei69K+K/gN9ULIQ/9rfhoxv4MRf879qNDLIQn8V/eBH/ID0KE/oOPLczf
DF1g/nfMz2Gcg7174SegdJFxJ2Jaxfm0zw+hbXO+w89mr0c3DWEjvnqi8zz6
g/B3FF+D4BfBLyS+C8S7CZ0DDULoxbfejOsg78d4Md+mE99FfI4i3gj297Ff
DeEfx3cFlM38ocR7ANt9dKZs2hT8v6CzZn+fQn4am2tIqjHY2ByxT/mqwX4N
8UzBXyX8TOIpwPZufEzF9jSoDvw5bPbBfjl8N+JZwrcD9XzGimUX+o82dkzL
8f0jzuNLbFUTw05kuegcga+D/8nMn4H/Sex3F+KtYNyAnLqFte0nnpbIx6E/
HftPQMeQH4U6cR7vYyOLWHbAj4Jvz/pmYf8gPrOx1xz/85E/xhrbIT+A/GZk
Y7D3G2z9GlqD/ZeYX4uv+fj/lPFtyK9D1qmhz3Iu357P8ZkeYVyJj19g+wbk
TzFeyp51IpYE38Yynlbi2B9CXpe9XB/xWpUjupu7+Jad7ztaF347NsYxdzw0
pMQ5r1zPYHMzsjMwBxiPQD4dfl7Sa4nAX1Yuxp0Lo7F3mnEPzn8N59OV9fTV
3WM/NyLfTo1YQnzlyEeyvo7YPMr62ysn2K+W5HtrdIex5gLuz0DmfAPfEprB
+vP51oazXIS8G+OuUC2yTuT43mYEnOvcGwbVFDkHr6J/Izrd8HUNMZeUOOeU
a3OJtwp+FTG1RZZgf/6GLIv56/BdSbxvsp4vkC9Hdko5gP6tJb5buiPr0H8a
+6/DP4d+V/S7QO829Bn2YX1vwDdjL5pCHxF7LrSTWHOgRxnXg6pzfca9GbfB
fj3iTcEfZu4hqAH2ryfeTvh6g3hasPflfLuVWE/GnbvLWe+lMtdE1cIY+zOT
83o15lzMQIfZj/9AeXmusY+hOxVagq2qPOeCaopqiXKif8w1S7VKMaoWT4m5
Nqom62xaQQ/m+4z2MP8q+fEZtn7V2LlwB/R6kXPiI8bHWeMMYvsZNnqjX469
S/BH4D/RepAn8DUcfgKx3sV+9GCv5xV4/Br6nfP8rZbY8tBfyVoGsz9/x94V
5HuRr+IMNsBfink8hHj6wq8n3g+J9yj2F8Sc08rlGHRMuYCPldi6DX4W5/db
aDr8APb4e+ZegJoSS0E2uYHvfxHzUGwNgz5nfIZvHXJ9hn0ZNyDGE4xXY6ML
9lP4exPdddCn6F9iv9qiPxp+Dus9iP0PiG8rPlpzf1pBu+q6BgVy/Qnmr0Be
wX15FtsvYXM063sDeTn+2mKjO3NncR7PYqtx3LV3A3Na6z2KOrcq8XkS3+eY
P5i13qY7y3gD8z9n/vpGfivuR+f3hX4zqtOu0arNU5jTB1s70MnK955dQPdr
vo1i7n3Ye43xtdi7A/29Oa51U7kzA/Jd84qJLZsYf5Lvmj9R72vauXMR+V/x
pWLUDv8dhAmS9iHb/aEz2J4Xc63aDt2IrAXfOhP/UPSz4esk7VuYYwuyQxHf
pdPo/A5fdZPGIrpTx6LOUeWm9kC14QbVpHzXCGGZ8Xw7lWtMM5z1NGEN5YRZ
SbwtmP9hylggwZlVJ/zG620XRrmM736qkfX8Bj3D3tXybV8d14yWqjUR15qp
+FhPfOugPXmu+RXE8hXx9sDeSmJqj/58fOwqMObowHhZ1G/ddOZfjXmOdEcX
GjvtgoqKjKFke2Pad0M+xkWNoYSdpPNF0jnyQ24U2ffVjHNPMSiXO+NjbSPn
9Fj8n0g5l+cST0f0z8d8NqoR85C3izk23Yk/wb8IjQleg+7Sqajvvu7UWuzf
lHRtV46OTRnTCMvoDF5QfUf/POMq5lex1m3QMXy9C9+XWDP4eyTXNbis1GvS
WnRnViJbAR3Jdk1Rrv0l5rdcOfc/9E+W+q0Q5t3C2dRNGftuy3KtCyljKdW8
QvLh6YyxrmqGsMISdA4XGjO0JN5/p1wrRmX57DNp1wLlwBbGW6F/ov8J9s4g
75xybd+OfAaxTUS+toFr+DXwf0x4rRV6QxjPTXgvtOZrhWWSPvuZ5MQa9AfA
P1voO7la9U4YAXu3w9+Efscyv4V6M7eguxW6iL0a4q9lfBZa3dCYQLI+addu
6Qwk1n5p11Zh6MqMMaaw5fJiYzlhcmFxYbr9+DqLznDyaVmusVt+3LVFGO54
yjVZtVg1ZQ/83pSxt97obezvzdgYyTgpvIrufuydK/aZdsdeD6iqyJi6X9SY
Q1ijLfvxSsxvpN5G1diu7HeizNhMmHsiezOp1GcxJ8u198m03wrV4HdKjPGF
7YUBv2U/vkkaG2qPxqWM6YXlhXHi2Cop9VsrTJiDfH/a2FkY9Txz10aMJYRx
5zAeD9Uvcs+iXFcPo95FOb+Uvbo941opDHye2M9BVVl+o95LuIdS76Q3VrXx
6zJjKdXI6rgxo7BiA/K1FXerRXNjhx839dkox5RbOiO9TTVlzkW9UcuJ95Wk
3xL1GPcjW8Wc2cWumar1d0X8Nqnmn0E+Iupc3JbjsxOmEZbRGQrLjYz67RKm
eyvinlK9pNbUKuE7pLsjjChf96DzULDP1RG/Aar9wjRfwk9C59Zi9xyqvR9G
jb1Ug4X9p2SMVdUD3MG4R8Z3uz7fHmc8DepV7J5H2P0W5l/INYZX7zozY2yg
Hva/cfe06mXlc0SJ3zC9XbpjD6TcI6o3VE5+r72LOLfUsw5J+A3R2yGMdDji
N0tvlWra0qh7YPW+wpzZpe651GupR3uuzG++3nph7q3I10GDstwzCnt2j/mu
CYMKCz2XMNYQJqrIuOdTr6c1fyzslnFvIky2IOI7rbusnv/FpDG7sHoNa/wz
fE90Pi50DRM2a9ncuSSMJpl6GPUu0lkcNaYXlhdmUe/0Vtq9nXqoRdhbmHSv
oJon7L8p7V5EPcC38J+l3JsJc72M7mLoUKFrrt7m99PuHfVG30nsd2V8tupJ
L6N7JeneRRhsCPolGWML9SjL4/6PQP8NqGYKC11JuJcQJpKvZTH3XvK5DV/v
pP1fiHqy1ugujDrXhUmF5c/GjVWF6R9MukdSb6T/IHoxXhl1LdN/BpPhd6Td
m91NTrwed0+hXqIj9W1gqf8z0X8l6uHVqzzMt1cbumfRfw3RqHtt/eeg3G0V
M7ZQDt/J3m0ptS1h9J2lxqzCquoRd8NXl7pW6j8KYb1dcdcKYb7h+q+k1LGp
5xKWG1ZiLCRMp166Nmrsrp5asb0V938XilG1+krEWFo1O502BhX2FKbQfy3C
FMIS+s/l/0B+tu8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5433329893124559, 0.49194255058211495`, 0.8807005616890206], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeclNX1xmcL22Z7m93ZMjOAGLCgWCgiYsGKioANBVGjURFBVGKsQSxo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmAz+X2xz/DmDHmOzPGMt99G1nayFLkKktKi12WrptSiCyhqJtSWSq/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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6222622677194174, 0.6214645052402962, 0.9108310252456071], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXecVEXWhpvJoSd0T+zuiWAGFBAURVYBEwoqohhWFAUR2FUXDIC6iIoJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmAz1X3xz/UMMyYMTOa774NKZQkSkqEsmXvV1FKUpaiQnayRpFoQbay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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6957670013640883, 0.7395661592976011, 0.9125067067750318], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeclcXVx+82ti/bb9m99+6CYEssEcUWjdgwsSfGN4Io2KUJigqoKIgi
KBYwRCmKEexdUUFAxIYVRSM2sKGiNLuImPf35Xd8ff94Ps/ceaacmTkz55zf
OXPb+w0+elBhIpHYvTSRKNL7Lr3v0HOP0mPKEomyikRion631CUS3SoTif+W
JBLzc4nEE3qKOyYSz5cnEqUqc5fKv1Du8ncr3TebSExpTiS+V3q52umg/Lf0
frbS5a9Sm71bE4l7k4nEm2pzktJ3K/260gtrEokFNa7TS/n3KH+Z8u9X/V1U
f7PSi5S+ojiRKCx0P2/n3Bf1j65OJEYoPVNlu4nGO9VXoei5K9r/TO/pbYnE
nvqeUv54/b5T+dPVzsc514HWEvU/RpPyZlMi8YaelJ7P9P1zPZv0fYK+zVX/
RXq+Fi2JYqc/y6iMnr3U/gkticQstXt4QSJxnvo6V88M0bdMbb2uZ/dG0ap6
3+r7NWri0tpE4kDV+0uHRGJHlZ0t2l4WbTuUur0W5XdX+enq5zuV/1hl/qU5
ml+lcYiu2e2aY83dWSp7qMZRoDU5Pp1IHJcXLaL5ULXTQ9/2UjsJ1S3Q0yJ6
NojerzL+doH6/EbpG9Xv/nrPVJu/qJ2TmrzG65X/IGubcx/v16sPtT1MbT6r
vGf0VCt/rejcpDn6TmNbojLP66lUmQ3KX6/ne+XvXuI5psw4vR8rdP6jhZ6T
mxKeI3jyG/3eVbTuoedR5XdLqU2NfYLa/Fel+RVeXas291SZerXxkPh2o/r6
Uc8EjSufdf1Gle1e7XVvVV42699lerd1SiS2Unqqni56RqmvftXum34rNA8D
O3qNyNst+npbNKwrNx17RnnyT1C5PyjdoPQgre+pqjtQ7awQTQOU/kDjukK0
tWTdFm2T/6HyExr7aUqfVug3dV9X/nqNe62eCpVfUu5+V6u9Mq1zuZ6vNA+D
Orot2jlL78F6PlF6ncoNVfpTpSsa/W282h/S0WnKrCpw+WtFwtWaw7OjzHDx
85Jm1y3WOHupn8+UrlQ756vMdSp/rt7Don36Ghb5VY3+NrjQ/Z8dZaaVuC7t
fCI+nsY4VeZa9Ts8yl8DLXqOKHTeiCjfKp65SOkS5ecifXPC71GRz/viSI+v
9W/KztI6tmn+LlL5XpqzTlqDF/WttNnrP6XE69+12mtU1uTfpM/nLNEZ0q7f
hRrXJdpznardXnu0WdD4Wx7jGx40c5bllbe0wGO6LsbF3macpyj/96Jnh7y/
9a5yPmUm6z1Jz9FK/6mD9+4ktfeDyn6v5wKNr7/48Poow3typNONTndSvb3F
O+cmXXdJqdvcVTTfXGuaoOVh7eNTNBen6fuz9aY5rec79fNt3mt1ZanXj3Gd
UWp5gCy4WnuzQbzSV7Q83+j8dfRV5LOrm8rU69tJelpV78Yyl1WVRFLvE/Wk
lX+k8n+s8vl3imi7Qv2P0zNPbd2sNsv1nqqyczu67Lsa13utrvOwfo9WvZnq
r1ll+kSbz+n77qJ/vMY4Ur/nlrvfLno/piepeg+WeR6ZN/YB+4F9savOw/Nz
Lnd0zAey5r+ibYbyCtXeBXr6qe7pou3MUp+ZyMQn1V9fPV2KfEYsifw60XNV
yrQNq3c+e3l8gWn/RWVO19nQSefSVervGfHh+ZXee5dpjzym9E9Kf6g6CPOP
VG9r5Z2r5xjl79eg8WkMU0XPq+rrC63pOs3Pn0XL+8Xm59FFrvsxe0ry4nxN
yGbVnaG1W64+e6rsANH2svh8KvSpzDyVOajcZzXnN3WfVdvtnVxnk+p/UGx6
uqr9ESo3X2PpXmr5tJve10u2TNEzSG0vqvW5x7n4H/2eoO/vF3hOmdviEr+n
RbpO6zBPPLy92mqv9T5lf74Gz6mdPprjS0TPdqJzrPq9QvOwSePOK/99zcOK
Vv8+T33MKDT/f61xva/yx6qP6VqTXIv5YK3SJyo9R7SUq69VleabXUVHtxLz
R1K8MVFjuVL5PdTOvqLtSeSOyq4RPReq34Xq8xK1s1h5i7Smq0TfKGSevm9Q
3iTV/ZvOlfeavd/Ze8iP4UpfJ57tlXT/u+jZWc8K0b+t5uGalHmuUO0vTZnv
b1H633pKy3xOcv51KbBMRk/ZSumX9P1FeELtZMRXP4qOjRrPxo5O/yD6R6vf
A5Km8QmV+7jKZxiyd0nIX85s8jm3t9SLushd0jsqv05rer3Gd5noyWqurs/4
N/KZ/qv03kf9DM97vp5Turvm6mv1NUJ1yzTeqaq7oMpnD329prJL9fxd3/6h
eXtK8/ZagfkDPkXvGlhv3oVvflR7zyStw8DbA8QTV4j+WzWOo1usR6A/vFLl
OUd2IcOQUz8XeZ2Rieh061rd/v2q10dtDlG995osk0VmorPysvqWUv2k9s18
9Z9Wm69WuX10A3jlSvU5qtRjK631WVituTlT47qw3HmMnfPkOq31tXpeUXtb
l5lW6Fzb6LJnlpkPSqP8EvHCfqLhMuWdjX4X8/mq5uMVPUtFx2PVfrM/oQN+
vUjv/dVPDz3D1ddOlW6DuuiOC2L+j5SOPFpPhfLLGy3XmR/OJPY/e/9m9bNR
3xaV+P2Tnh9U5oZS/ybNGc75Td7Mepeh3qyk9WB04PUd/D5L83lztXV5zt7d
271X2adT9F6gcXYt9Vq+1Gj+vylrWwK+Habvg7R+d1SYn8lDFv9Z7SxX/RtU
73Y93zdaz9+k8X+rdAeN990G5y9U+z8r/7tGf3+yyWU423l/F+ntOWOyluHk
fxPtUH5hk39jl2D/MJ6ztW5Daz3OrYr8fXvRtrreZyjn560NTpO/rej8K+es
yj/bYD6ABx4R7zyqZze1daTys+prR72LKq03oNtfqH6rRNv06HfbJvc9utHp
QerrUNF1kp4Ror+s2boRelOD1rlez9Wqu1nfi7OWhSdoDvvo2Vr0HtXgvrF3
ztH37TpZp/5Z3zbp2anIcof+r8ZmVDuVKneV+ioRnStLLLOQY49XWJbVix+P
R8Yj/7O2IbEf14juL2ud7tFgmUf9xzTG46L8HK3taRnP1wMVlvHwZKda62fo
MbeK9sNVZrTo+6TB8gQa0EeaQ3+AZ+FT6qJTpRqtP43XvEystoxeVu3xM3Zk
7TzN+XQ9Axt85gwo9HtgnD+T9b5ezxfK36HWugL8gxzs32B9kvq0k1L+bU2u
j1xmLm9s8HxeV2Y+YO3Wcsbr+7gC5z0T+WNE71jln67vO5Y4n/R60fpeRdCq
/Mc7eF3op3/QjNzGpkR2Hy7dY6TyLyz1HpvQYN2P9/hIoxOS5rzFJqR8F+Wt
U90RDdaVsLNf7mA78G9ao2qt60v6PbWD3/DIR+K7PinTsL3OsJcz1nGwPfuo
nRGlXnd0OnQG9OCZ1T4nWsoto7AfkVf9Uv49WzL64azxCfqmP3SYv+v7M1nT
NFttztKzsNBvfg9QX29L1ixvs/71bsVv9DJ/R6CjKL1/rdcsX+A1Iw/bhDW5
JdZlsNbxthrrG1OKvY47FPo9Ndb01qCB87lr/B4RZ9E7erZRm7tpr3/YbDvx
G9H1mZ4pddZzx2Q9L+c2mQ84H5AfrzVYn+NZqvQRomdAudPbFHvM9MU5867a
+4faX6C6p2h+/qLfKztYxlIPOUi916LuKn0/TuWHVvmMuShpnmpt8lm0r+oW
Nfo3aXjpcf3+KmFMpTj0EzAedEvSx0YZ+O3kJuMRW3ir2DKaeQY/mIgtWGC7
Y0mjsSYwFmQ3+eTx7Z91tkuejzLM15LIRx95odG62ZZyjbZf6H9u0Pk/dU5D
F9jGoEbjG5wnpLF5eQ+O/Lv1Ho6dLBo61zqfsp11pp3c6vb5ju2FDXii5q2f
njHi4QPVR/9Sz8uXWtO1es6qNV/cGvz5qH5/obKr9RyiNke22tZD10BPQN+Y
q29rSoxjLNaa7Jf173saTR+0oQemm6y3kcc37K/hUQb6kNX3RPmeKnswdUTj
62rzCLX5U4llFzIMefeY6Hk65b0DjrixzFgieN6jpcb0jqqwPkF6Tonb+ABd
S+3M1tNYYz2PdE2p56ST2t9ONBysvFv1vJTwN9IHq/5a7fH5Ld6T4HMTQwee
V2i6SFN2VtSdXGSa4fnZkU97nIHoi5y3zYXu997AGO8MzBSbhzKc51dGO5Rp
7eC5OyXaZAyMhfMAHIIz4QTl99FTIJon6/u8aq8VZyk6DLhWOjBIdGnWJh3p
/pH/cImxSvI3BkaaVPon9fGw5urFRuNhv8p4zv49Gl0GHBU5QD4yAt5/Mfif
OvxGTz9M8rGwzTgKen6m6TdaMtEvNlx5k+3KB3VO/6D57xi2fl3Y+3wHRwND
A6MiTT0wlvLI510W7WDrXKM5GyVeXi4eO0283QGbtMnj71hvWU155HVTpfEB
cIITCvzukvCZg/zbIvsafP4sK/BeuqTR+NzFjU7TPutyIhgZGHWp00Nin44I
/h/Hmjda9xgZ+aw5MnZc9EU7faNuQanTrDU8mC0yH65ocjn6OrXWOkp7B5c9
IcrTNnn0u6PWYm+dsT2rfJYMivMEPWhc0HOYxjhK6Qc6WH++OMa1ttr5XTr8
Nmb06uPQqfSMrHZfI6M/9JlLG31WD9bcb532mTY+xs5YmddLI53p6G+/pic0
/tbGhMi/NNaCNjmzsCPWJSz3kH/IQ/LGRD74NbY9WPM1gYuxp/4oevZpNbaN
3D4mZdl9Pbh0lcv9QTy7i57nNdbllcZqwWCmizdntDhvf/HVTS3GXrAdlkeZ
RRprbSefWSuLjVOAUWyt9v6ivu5VX89pHbZvM9YKLorcA58BAwcfAcf+PUZh
ufE2eBnbAtk9SenravyNcyRdbl2lWv0/pSencieon11SPlvQvdDB/qsqm8B+
yszj34f8Q8Z1Ei2d9TxSaz3kkdBF0C2fD/2Ss5DynD+M6ala079Y4z2+3e0e
pDmZ2WJbfp728oHNxsrAqNKBX4FZgF08pfLH65wvUP17Ko1NsF/BMfbVuuwD
b2md+zYZ/2BcObU5OGccYDI6ZZX1QzCS0YGTzFGZfdQvUzRXeXekLe/aGq2X
oiMfoLb313MyOmyD156+b5Gc/LeebK1tkqaYr31b7fPA33GWxjitxbYM+2JB
rffLdq325eB3ubvG8hU+3axvT9eaF5BhG2P+D9f67KA5X6xv/9T8dVVaTW+Z
18Uxt9urvfPS1tOfjjmnndWi8Qs9g8M/wJ5kP2JnkYe/4A+ap3dUf2fR85rS
D6iP1o7WX/FXzUjYFkW23Zcw3jMvZFyRaNuo9g8R7YtV9u0oj//lrdB/bxNd
/5PzN/xOG/K2Q/m9PMpnyq1Pw5/ID84a/BGvq+7srL/BF5ko80flvaI2e+Fr
UXt36NkqzifqcjbOyRu7Abd5BDxbtCxQfqXyK/L2e8BP+1WZ508Xf7xTZn8K
sgOfGfIC/G9MrXHNBzU3/8m53BCt4wzxz/Qqy59DqiyDNqvtX/Kuc0OZz9GM
8r8Un3yhp4Pmf4Tq/VX1R+vbj+BGKn+Oyp8hes/U8wv7qdl+ETAi7ED2N7jx
k5qTE9u9R7GvqYdsxbY++/+lkbnIZGTa6SHXHs/bhsd+RzYNCh4A5wVbAVfp
Kbncudx6YYcqY9Jg2JeX+Y1uwPoNDV5CptEW7T+pthfo6VFrPAfeZ/7L66yf
oPMg7xgf+OvDKvtSzvz4gNI3JI1Bosccq/dFmvuhov1sPakO5vGyVvP5qZqn
C8R/CbWzXvU+zFvugIWzj9G18A3hQxoWPi7oha9Wq/zyvOUp/LIm+O3uSq8J
GP+1mv971N87YPii8amUcfejJTcGlodMqTZG3CV8MchJ9HP8aysb3OfTojfZ
ZhyTeoOiLnKFOQLvWqt1XqenXWW6iraCjMth+wwIW2hwuetjB+FHaqu1Lwns
mnrgkNCGvksdZDf2APL0FbU9POf1RC9Dh0M3OxEfr+bhTyrXqj4vyfvcBWPD
JgNnh+4nApfDVlvZ5m/oOW3hz4K2ZIwP22pR7Gv6Z07AQDJ19vdztrFXO0f+
/GgfrOyNUs89/okbRO+/csZT0GnRtdFrXxYNC0XnDyr/kd7zsz5f8SWzfrTx
udbt1Jz9CMg09jl7/MIGnxl/LzWf8B1eKdd++iQwc/DO/mW2Z5E5Z7a4/hql
++dMx0vKO1Hpkirrl4viHMaf+/ta+2jB8ZCL4C3gf9+3GQPk7ODNOYMOjk4w
MXAfxsoeR8ahmyJrPle9N1O2Jf9bYZwN/9q6Sscu4Ku6UrTd1u7f2OPDmqx3
o0ONC71orebpPLWVFl1DMsaswU/yHb3+4FonK++UFuOU2J77BT+znk/FmqL/
0jf9Xqcy19Ybx/sImzr8PfilyWOMvVWuV4nzyeOcJR//FfsJGrCXwXSwVd8R
nW/rqQhs+0v1NQtZmDQmjq6LvYo9jx10jtbhbD3319hnM6zKfpkjf8WPS+xT
wbcCBn556E5gMpQ9J8rPUdt7tVvnIAYFewlbCbl4ocoMKzXGR3lw0a20JnVt
jk84Q/N5T4vzwck/jb7uUt71efddFDSDOTyk8f2xzfIUPQD/KPbvbLXzdd6x
AW3am3Mz9luO09h66XmxzD7SZ1rtq2Cvsi7YYqNCJ0UvYt04g8Eu2lWvsc76
T2fR84D4fEKB5dn8MvvqeoQ+R3naWxxrPURz/lDe5/g/xWN7tvsbuMh+UZ7Y
m25Vjr85v957Ajl9Kvpei7Em9OKdqxxPgFxhHMQCDWoyRtW3yDFC2L3oql+p
z3V5y7N0sTEA4lLAoh7LG486Bb1MzwSt0d8y9lHhn+KcoTz+kcNFw99bjH/e
WGp/ABgr2EImzqKE6hW0mj6wZ2QjMuubvPFlzvhhWfunmfNXRMPIFp8/6GjI
YfQ0cFzmmnlenfNeYh8li6wTo6t/p3a+z7ocvuQuNcZAtlH/G7P+jV2EjcZ5
kG+176Fr8F2PGvNYa7SJjg2uOi3w2/NE2425qK/0R1mfqz+Bk+ds1zBf29TY
X0r8Ef4KbPxZgYWAVxyofh9NGRuvyhnjhvcHoVfrWVhhnoEHmIeXAtsFUyXG
59iI80Ev30tt/o24LOUdr+f2CuPue0f+Cs3r+3n74T8VnZ/padK3juq3Nudy
R4ieV1PGdbfGT5Wyj70OzDbSO4A/VtgeYr/h92IPYrOBpYKjdlLdh8TDf65x
jAq+Jfzw6PfkcTbRxqSwm9Bz0X2xpz/QXugj2kYRfwPWq/37cLXnDD2FecMv
SRq7htiQC6utLyOjngg5dYbGMihlu/kpjXuRngPDdnqrwnLpTrX9bsq2y06i
eeec9//lccYSw4S8wteLzHoTjDbn+vgFwNzhizc034tSPlsf1zuVMw+VVTpW
iTgl/I/fB4ZZo/beyhqjR7/eO2t5WaF0pZ7uNd7nCyM2D70XeYJ+O63a39Fr
VoueATnj1mCeq6rth+2V9dnHuTdE3ybomVZqP+G/io0/zwu8G57+o2g+tM31
P9A8rcwbwwCDRxYiB8HaHwm8HXuLM4vzqq9ouELPnerrFs3DtFbXoc8ro190
f36jG+yvvh7LGutsbrNvb1n4y5pD1ryn9kuSPq+wewpTtn3wo2FbUG4fnTld
0/Zd4KsBnwCLQG+9MmPdFbsPmw89kDd9ot+CS6yO9AjOBLX/Qql1ujGBY0Lv
kKCZeI0fahwvM7HWche//rpClyHW4yj2Y4vHfJjS6U5O76p9MCptG4XYvrNj
ToZWOI0ehR0wLuQO58e0jM+QR6ttUzFmfL7sV3zQJY2OWQL7WpO1zgF/fK51
eDrrfUhb8DLn/XyNsafavbDGMRO8iaN4SnlnNdv/wj4Ex2AekMtzI17uPn2f
2+5v5M2LuDtw57mRxmYHEwEPOVL9X5c0/gFejH8afhupfs+v8X64L2O5jkxn
DobGnAyJNPPJnDAG5Bj7lpg8cHD2/ajY++h+nBvwOT5bfqMH4sfAR4IO/0r4
SLDlv9f6TE4anwYruitjvOhuvdvz3q/os8THoLM+kDEGCv4JHrB/s9sBX8BX
uFX4UGgf2wEf4tWRv2+zsQ+OODALsAtwTDCRG2uMn+DfmhkxYOi84N3ovZS9
r8Y64BDlD835N/o7+x8b4Q32XMZ+AWwYeB0+x5bG/wqOCi34p/BXsR431BiT
p/8bgoaLm60PoQvha+CsJSZhlHjm2bT1+tHq/5KcY3snoR8yLrXXQ2s9Lml9
/PIG5x1SaLvoqPAFYPOtDbuPeOHebREzXGQcnr3MvsJvjJ0yWHzRq811ODcO
iLMD+xHMAsyhRbQ9knEMWpto/FTl51Vap6iPeMtalRmatj1NvCHfiXObnPE3
8tEvsHOQrb30vrvddBAbBuaUDn6HL+4MH8fRgWcODDuQsf5JNO/YyXHPY8I2
pAzj5yxBNx4TsRZbYi7qfRbA8x1FQ22L49vwmbBOrNG7oufejOeTmDli54hz
Yr9QFzuMGGv6xAeLTw1/AzbOl6q7d95rT1zCzcFjD2Xs46GfOzU3j+e8R5E9
G2psr/0Ve1z562usP/BGPzkGenKO2cBnsCU2iPizBuMK4BvIA+YfvY7zoV+c
Ia812ZZAF81l7bviO3Wx36kzttq+sg9VrmejfULIsqOy7pt+kfMjq3/Dxkiz
94uyLkeZNXn7GMBJNtf4TKAMfq1lMXYw37HR1/SMcQowigOIY89ZX+pVZHqI
S8dHj9zEt9tN7QxLmkd2xdZLOrYSXi4O+QVmMCNs9lfV3tKccfSxGsfrOduC
54pnJ6Ys0xfjX8tZ7yL++vmIwWZ8jJPxYluQh97LemCDYU+xj5AR+NHAWj6P
sRArclO17djeReYh+Oe8dsfJYQ+kVD6Zd1zvjRr7Da2ODXq6ybEp6MDYXp3j
rH5Vc1Wd87eqeuOXxPnxEKOI7x7cA78UthLnEGPF5sVvsGUO1M6qBtflzMGH
+XTwA/GAr2c8Ns5zYm4438erTP9m89Jy5jxlHJdY4IsiHhifXTb8lbT/ScRN
rim0PCEOE8yBGBt0A+I1iNtAx+AsrA5Me2fNzbcac0OZY6yQu8hc4g/HNTgu
sV+TcXDOvANUvkFzulDrs0Fl19fbDhpZb/wNHG5FvWMdLim0DH81YrewlbCT
iKFalXasP36SvN4fiYZr6hwfQV3mnzqvBC/urO9HpqzPMv/g6MSZnFTk2BHG
i//oiTrjdber/F16jqhzjOFWLbbjepa4TcZ4Vcaxa8zTsALPHe3gN2Mc+LaQ
fcg3+thddHyp9y4q06/Iacq/VW964IelRW6nW8LY5xV1xr0Y04q4e4ANxjzg
F0MPQQcBh+WOx40xPyvaHNtKXOuI8MXD51nlfcBeqnP8O29i3eFjcL/XImYS
Xw62IfGExKsix4mFIiaKfQpWsTbiFcAmFgcWw3nLWYuehg76VoyL9/J6x7R0
ibhjMFvk1ZWhP74nut5v85hXxnjhAc6dcwrs08QP8la00xtsNWm9BV0I/RL9
k/0JLxBL/zu1V5f3/YAf6xzfz3jxEePrhQ5iYtfFnINhMkZ839OjX/KhBZrg
N2xU/FLE0KIL35f2GoCjo3MTtza43nMH/rk6MHb0UnD2L6IM/dIONG8T91ho
G/xjbJ3xb+Ktukdf72gsmbT5gTPq40Kft9D4cdC/rcp8mvR5TcwCsQvY8tjX
tNMpYqh+DhqIAyHmA3uEeC9sVnxexH3vljHOPr/O+wJ85qu0z0TOw0/UV6e0
fYCvthjPBctNKf8P4b/7j9JvtXk8xK2DL0ATc/BlzAm8TB78vLHOdyEGR/wP
c4fOw17hrGDvtGk9H2y1brwk9gv7D73xVx84sahTU8ZbOGe+qnd88umq2zdt
LBX/G/gIMuLIVuMaYBrswXVxDl4gnh/Z5Ngj9i+4D30dqDZak15P9HTu00AP
fD8z6u5WbFrgW2jfEPRj/22f9pxzTrGn0VuI48be4Mz8KspzNvK9T5TZgtGG
P2hF8CPfz9e4+qcdd3285vu4NuuSxC6dnHL8En5m1h65TGwa8pH4Iu6B4Gum
raERA0xc67q4u0Sa94ZI19Y7FoE4hFTEJBDnjP5EjBf6M+9BkUZuDGyy7BgY
+aRfbjFmDTZHW/0jroNYrwtizqeL13bBj1jvdSCfeFTKDoh+aW9wYHb3qr3X
VH67SvdNf8SeIWOXxR00dOF/Jq0Po4+id2KPgGtOTRrbxOcNBklMYCHxd0n7
E1qafZcNP8WqpP1A2MXERTGX8A/xXWAk8BUxz8QZw3tPquz9eePoqbhnx3g3
BG/CG+x99j190+bIGC+xbOcGfo5sKQz5gn2EbMU+5d0v0sSKETMGjv1C3GdD
10Um9wtZjOyDV9nXp2mej87ZrgYTBxv/KOI03m9yvA554ObMCfXpDx0AfK13
YOmsGTQzD+whzjjON+5v3Zh3vDjr3RJ+U9Zqt05eL/wDjBEfB+PkN/YLcSzD
Ih+d/eSm38Z3cozrZtE/qdl6BBhqz4jRuky8v0nfOpY6bot88NUtMSmlxu3B
Gw7LGXNg3lfEPRHWmfVGH8d/lGn2ujMXzAkhDgtKrR9XljhuZUXMVb7ZZVgj
3isiTVzW1yFbyX8v2oEX3oyYIuyfiojhAQd9I/LJq4z8dJRPRQw+7XAPAHmG
rYFsBS9bGTw8Q3Owl8Y5p87y/eu4v4msKwt5B27Knse3Av62Ie4t8qyPmENw
Pnwq1ySMmy+JO4D43tA18M1xN+ejuJ/zf7+JB2tyX+gR5H0Q7XwUZUiDV0A/
uCW+VrAL8ojJArMjLquDdNrhSd83Y9y5Zo+du5s9MtY/wFDQ+5BxuxJDlXaM
DbobOhzf2EPU/XWNWDPaY71Za3wifM9HmeHYieLVdLPndUXMLWVbgjeQw9hC
yGXssilhBxHD+2jScbz4wzbHOrMf0ZXZs+gKU+O+D7Yv5wprznxsjDmBllzQ
STzFooipAF+BLuKx8bn1aHY/x2uu3kvaFiT+qChikIg16B7xBo1p36XkHiVn
ArIefRV7gth9YhvxpYCvgrOeW2+fCvuXOOT9IxZ5d529b2d8fwKZc3racoe4
eDBH+qVt9GzaZx3woRG7OBkfb974OHciuA+BTous4S4N5zz4zC2hT3P210b+
LfWugw4GJkuf2ML3EnvS7vr47OgLvZ2Y3CODHu6O9Au/GOPoEbH0+JSmpK3X
/iy6NukZXWt9+cfQIfHrPhwynzsrtAX9e7c7voRYEuLOGC82BTYu/aI/Dw0s
Ez2B2I3b0/bBMiZkIf59dNiNoQs9obk9tN22Gzj9Tllj9cSUHlbnuNIj62yv
EK/LXF6cNj0DpAP0b/O9Pc65iwJffUPvfjljh9Q7POqiGxwevjnud8IX2EqH
R/vItk9Z33bHZcCP7CX4ljh34t0zIcOQZex9+lmWdl/wdVGpebuv2uinZ1uN
eY3avLXN985m631bm8e2vs5tcseH79xPo8zlmoObmm3Ls5+YA+Q4OAR7ELvh
NJXfqd1nPd+oR/w2+Ct9EpfGmUpZzlX8u5zp0Mfd4qNaPH7WbcdYO2IEdm5w
DANx0f/4dd6aLLORfdjIe9Qbm0pHrBvxY8WxB5Fl+GP7Bu/VR6zolrivRrdL
m53T1rPRscknJps+wMDqW42DHVfn8ugJHVS2pM24O+crZzJ3Ocfiq89bDs4u
C3lY4v1zedhi+KrwU4F7YPejc2D74/taHf4vxnFnjAWMELrACZNxXwTbARwa
HB38anPYGvhbU6Gv0VfPiE+CT2ZFPDNxOE2isTnv+9LcKWbOwe3PyFt3R2/n
vhZ6Lro9e5X7L+C36NjYCeh7+NaZV+jpFbYSdtLviJMKHxa+LH5PDjyGdrBV
mYMlYXMN0hyvavd6c0f5mDbfU0a3wBaAhv3i3KDu/urw3Yhbw7ZD/6GdXdTG
bu3mZWKz8CkzRx+HjoTtxh3KT1usC+LTuyxv+YfvFZsf+4iYdOw5/PKLWq1T
ok8yx5sjjgt/B3zGXMH7o9Pm/5a0cQF4gv+uQG6zjrcHD8E/32hOHmwzT8NT
x0b+v5U3U89BEYdOPDr4HbKAe7z4BdijYHLs0weVfqDO9/Z4SOOPgH8PD115
gvZuSbu/oYeCr6CLYnPOCdscX8GAwB/A/PC50kcNOp2euXW2h+gDHJ74ymzc
tWR94BXWiPYejjZ5sP2Rq9z/vibugOOzuirueX8VOB3nHhjnXlnjnHsFzkua
mHHaxNdJ/Cv12AvYywsDR6LMCxGLDobXEhggWPJjgSczj/1jv8yKOzfoL/jW
8W+DWxJLNTjwhAGBLTAnC+rcH/MGDrdT2vPxWYvv6GJ/cKcRfxL26eN19iWz
12e1+z8v0JfAy3eIvQ/WhI8L7IW1PTdkPd/YG/DzeZHPuuPrxv8NdsCd+7vq
jDN0yvjOM/jRE0Enc8L+IL6TPQKvYx9h+3A3lPuY/H5O349qNZ/w+6Io8+v4
0ZMYB/gXNBGf37/eenJe7U9q9+8XRdt/Mo6TYYzwC+NEb2VsnM1lKlvR7rXs
zl5p9xiIEylI+ux6JOWYg7+GbKgMfRybe2WrzyPsXM4gzh/2CXsE2XSn+Hyb
NsuVaXqvSBmnQz/fHDo6+uimwGT2aLNvEr8ksdXgx/AX962bY03RdWaGjsT9
Ue7p/aoz8SZe60q105SyT5F7nNjVyLupyj+g2fjH0PDb4lsBJ97Ybpr6BS7K
WBjHQXEnh9h59A5iFsnrGfnExE1MO1ZsQ8hszgHmakHMF7L6ljbPyciUYyWJ
k+ThfCLmf13UvSH0QHQ78EzGODPS+6jeozn7Kz5TenWbcSzONGxd7EHuNpFH
fBo6K7FcpIltw4bED44ufkzsL3wS/O8DcSnYQcSZ4efCf0jsAD5E7hyQj31E
2eeiPPEZYGjEif0iXljU7m9gPF+3GefhvyWK23zHndiHrXKOfyD2jFi1X9sg
TXniPtAHycefztkCD+BvpA3OOmxg2iDmAZl8ZshlYkKHZvybOwHEh+NrHhXp
3tEn/dE+sUg/NxtrIv+6oIGxLol5wD7Hz4GPY17YLuhL3OvFRsCPTEzRuGLH
bGwb5aGZvBGRD25MvAixIodonmal7RvBriSf+Ld1sf7oBuBSfQLjQuZiwxNz
dblo3jvtOK9PM/6fI/DvES32caKbEO+N3U7MGHoBPA0/r4002DvY0cDAqfh/
gxFhh+LD75WzH58YvnVxxwZbjza33NeTTGhMOe7gxLi3MiTaGBdj5Dy7MHQW
zjvOIe6VgyEinxgL8UjIE+7tkrd7YEHgh92jzJfhP6AeuDT56DPYUOhx2Ji9
I9YJm5R788fn7c/H9zogYnS7aVyXp71HD2pyH7R/k/K7Z/zfA3vp3Tdpmwm7
sypsT7B+YudZI8aTDjr5T6Yp8b9MyPGTYm7BR3umrJMc0mi7bErQTb/wD/FP
o6NN/LMl8d9ZP4cuw3lIDO+giDO+PmK+0SORKfSF7ON/KdB30XXRHcExxweO
9X7gD3t18n+LXBV3p/D9ozeyVsmIX/q9xvG7Vu+blZqHFRnf4UtFPBIYCH4M
fBD4N4aFbESO8F8l8Dx7hf+/IfYa243YFuJd8HN8QWxgyv+RUI/8TVuG4w+/
OGf/9O/AGFKOK7lDZ8a6lG07YsaYL9aA++Ujko4D7Kz0mVnbx41a84a8/9+I
GKHJETNA7M8t8f8YXSOfWPQP1X4ubb8Iuih+BfRR/J+9A8fgXk5N+Ps+DHxj
i89BddvTxuuJPzoibVyX2PuL437Z0IhDQF78O+OYJ+KddhbNDcTwNZqfwfHh
7e/0/duM/xcM38CkoB98JRNYHPrnpLgLCcYIXo/+zF29ipTv662JfOzrlSnL
XWTumuiL8mAVbwVewf9glWft/8krvWOLz11wMvAy8DpkzpyQO/Av+wd8n7uQ
1OsZ9zKIYQU/JA5r54jFYjz4d+E5dCTu0k+K/zfCx4NOVRH3AQdEHmXQo/Db
pCINzkJ72BrcB8Ifhi8MbALsmL6nR9wlvAr+QHwffsgJ4fPF506cZmvcxcMn
3Bp3MzlLiCXgPMmKP/+Sc+wUWNYhgWexjw+JeAPePSMNvjI78Bz2B7Th1+T+
Ptgf9E6Ie3PL4u7RxKANjOSB8JPCE8TEE1+BTT8nbHfiLsjnnATDHhe4GToX
uhfyi7OcNOc8vpQrwgdNjNPSuAPOb+riT6mM+Ab4mrzLI5//Hzotzgpk5ntx
9xzsiHuU2KXEC7REzMDBMQ/M21Tts9szzsdfgd6FDcUeon320Z9TvlNH3+hk
70b74BL0hayGvw4OvJr5pQ/OYXwZ+DG4c4Sdh72HjcydEu6WcObgA62KOyac
Q5WRj8+3IuJLeYg1xaczLMqg25BHGc7PoVGGNHxQEnblkyn/Zxa6yNgm0wEN
/D9YQaTHxlwVRR7fwGwZ00Ehx4fF99Oj/cKoSx/FgZMQ87Llv+EKjVeS5g4L
a0C73Pfg/+Tyef+nHLoR8Yb4yIhrIL6B2Ansr1UR58D/76WC5/mfvAnxX3nI
gGTs91Lxf4d227LVele1237i/xT2jPkHD2EtsN2WRSwHODDvPSOug/+P5Ezn
PL+MGLCsY1DQnYir5RwmRpYYOn5D3yeBaeAbWRr+LO7zfBJjYU6IByKOiH72
CHqIDeIbc0Wc0QcRL8R+Z1zoYMSjPdFqfmzQOha1eb5OjboDQ9Zz7qHnYDuA
EcDD3KEcF/PG3iWGDzx2VLv9ZPjIuD9+W+x37klwJnA2fBv+A/QrfA/4Qjh/
+IYeAza7tMltsu+wRc6P2BV8OGBY4FarQt4j6/Ht14Z/H70BnQ99Dx2NNOPg
fsOEOPfu17jva/X/Ej3bZJnN3G65nxV6LHfU8D8ht/CtgGuCGU4MmuEN9K/d
QpfBfkcuMVfZiK25N3Q2ZBq6EHdqn0o7Nh9+wbcEz5ytuZ+Q9100+H1s7Ad0
ll7ha7sn45hL4upeD/8EdZkn5gu5j/3YM/TAsWrv0rz/14p7tPjj8cVDG/PA
3DN/6LusBftgXOg3zAfzguxj70IP+xFfznehpxGXjt2AvbNVjJc4oobAYNh3
xAbyHzfgKegRMwLnwqeEb4kzBzsVXAtb9WqVP7jFGAD7GR/RlNCloZM1Z+zL
wveK/tI1dAO+/Ry8nY3xwVfIHPgQuXxQnKPIa+JUuDvE3pwea8RZhJ8DHmA/
cl+Ks4Q7U/BcTeCl+K9mR5tPB/9g48Dr5IMXoYd2i7klb1bk3xpxegeHPgR/
Eee5OOW7fNhr7GXOF2j7XxncCrU=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmg11P6xz83dW/d7XuX+u7rrUhZihJafqMwIstYhl+LFkwLSqJVk0Lk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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.768594830751639, 0.8489867786437738, 0.911359209167649], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHecVdW1xw/TGGbmDtPvnZl778yABVBjj7wIaAT1JWIDFKJiAPW9JIrl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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXm8jeUWx1/DOc5xpn1O7P3us/e79z66pVJRhBuhEvc2T0oZilK34dKs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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8346070704092848, 0.8710001016111839, 0.8817857849567455], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnmUVNW1xi8N9lBd1V1Nd1dXd1V1VyECYhIVFRVlVIiIYpQhohjzcHqi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQldURxe8As8+bhWXe9+Yt88ZUUgpREJFF2dQCAbewQ1QwIKTCCEoA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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9006193100669307, 0.8930134245785939, 0.852212360745842], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnuQlXUZx1/2nD3s9Sx7OWfP2bN79hzG8oaKsAsioM1Ug2gzJWlqOup4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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnls1FUQx19td7dbuj11z3Z3S9CIKYcgLUU5EkQomCjlEquiFGIQASMR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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9411759999999999, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlktMnVUUhTdcQOAC9yGPey+gl0aTDtQKjQ5AgURbCnagrYqxAxPj0Kpx
5KCmOmhiaRMJI6sOHFAfsR0bE4sMrEbjKxqtpSOjNTE1KdXIUFxf1m46OPnP
f/599mOtdfb5x55+/sBzrRHxpUZBY7MccVXjSFtEe2fEakfEny0RJ/XeMhgx
pvmxgud1PR+XzTM3RTQ1b2vz/LT87Nf6Vo/stf7LSMTFEb8fH47YHvT63mbE
Po0NxTtUj2gM2d/MWMRHsvtH/p7S9xdrEX/LpqB9rYOOv092ezUaBa8xJ7fd
pYgJjZ2aVwciKhovKe5pxX9X42HVUx6wL/ysjyqG5m8o5yW9f9Lhug4WI17t
8ntLxsU/z0LGO6p8/1Cu//Y4Fk/yAbMNjS3N798R8Z5iXOp1bS8XjdHdquuB
WyPOKNd5ra8UjMkV2W30Otb7VX8f1zja52+s31uzX3yyr9zpvdfK5gy+HtLz
m6J94wdMqJ3Y8ARf0Yh4W7h/LptJ5XOfxnfy8YT2rXdH/CD7R/W9Z8j+usXJ
nXqvdBoDcASHxaLx+j6xQiv1xPJIzhea5huu7+o1VvAy0x8x3e+aZ/v9Tl0L
neYSHuEFH/9p3qVcfhLmc/r+Sp91AOa/dtnPdsGYUTP1kt9camNNe//S3t/a
jRvY7Eys5hNDbMEae3Ddn+u92nthzO9rwuZQ0TpfK3oN27Mlcwy21DCTdcH/
4Vu8Nq69H/YZ84nME36ns3by5zmb8x+FZ5dwL7caX3AG189K9oMNMdgP7kXl
ebBu/MAYjBpZ60LWe1x1LGk8qdiT4vDEgM8CfMP7lXbH4Ttn4HzWTL3ltC9p
vCYfpYZtJlKn+F8ueA4Oc03XQP5Ler7QcIyPhck9NWv6Wa0dbjgGuKzqea3N
Wvy2bL6m5Kdj2Of0dfk9J38ljVOq9c26c5xWPrMaUbUe8IFm0Dzfyf+AbH8e
s26w2664Xs7BW3kW0OjFsvsPdl8XrSPiYkvsU8J794Dz4Uy07fC54Hyfz544
nvWQB9yQE/mwH/2BFfhPDfjMsg521HW9p3BGiD+X/Q4NwD9ngnf4gF/O+kLq
GOyX0z9clZNf+vpkzlezPxG3oNxvq7t3UMcdecbBnvjYlbKXNrJHfVC27uAI
HLDFZjJrYR/27CWXZtZ1s3ivjroH0EtbBm9oD2zBGOzhAM3AVfeQeUA3rVXb
bYy4N3F2sV9JTXD2z6b22mvu+/SBqcwNDLhLNvOOo0+jr63U7Jnci64vD1vb
XymHq4PGbI9ymW9aG9SMDqgVTrDFJzlG5sk9xh7swQsd0FvQHTasn8jcwI9a
+MZ6Oe8FcCBf+jvY4hcb6qUvnkydU+Nm2lDnseyb5MQ789vr5huuuQ93NY3P
78pz15Bt0S1apbdc5x6fcH4p76dPZbtYM3Z7asYIfNACmuBcrCSX5E/fZQ/2
l2X/juI+WHHf4EkO9DNiE7eSeGwVbvxboB/yGs/+AAb4P5f4TCW/y6kF9I+O
6dFgic9qaphe8sWo8yQnuCQWa+u5zj3zSN1nr5I9nlrKmRt+uBMeq/sOoAeT
H3zwX3BhxOd4Uff8dt09G3zQDPH+B4sDQq4=
         "],
         VertexColors->None], 
        PolygonBox[{{7036, 5901, 2124, 3006}, {7141, 7140, 1148, 2433}, {6557,
          8510, 4608, 4610}, {8217, 6198, 3547, 4265}, {6444, 7036, 3006, 
         2065}, {8239, 8240, 4012, 1616}, {6483, 7906, 3891, 2122}, {6555, 
         5728, 2724, 2246}, {8252, 8251, 152, 4303}, {6921, 6922, 2065, 
         528}, {6258, 8286, 4336, 4338}, {8743, 5915, 1023, 5184}, {7790, 
         6656, 2246, 3755}, {5935, 8287, 4338, 1148}, {7385, 7049, 801, 
         3318}, {6768, 6557, 4610, 2752}, {6436, 6213, 1700, 2053}, {8512, 
         8511, 1267, 4608}, {7054, 5897, 2119, 3020}, {7789, 8743, 5184, 
         3547}, {6554, 6764, 2750, 2245}, {5887, 7386, 2123, 801}, {6481, 
         6215, 3711, 2119}, {6765, 6261, 2907, 2750}, {5900, 7055, 3021, 
         2123}, {7442, 6015, 3317, 3374}, {7055, 5899, 2122, 3021}, {8265, 
         8266, 4314, 1267}, {6919, 8585, 4698, 2899}, {6231, 8250, 4303, 
         1507}, {7243, 7443, 3374, 3192}, {5898, 7054, 3020, 2120}, {6215, 
         7609, 3563, 3711}, {6197, 8217, 4265, 3563}, {6963, 6553, 2245, 
         2941}, {5727, 8752, 5273, 152}, {8752, 7243, 3192, 5273}, {8286, 
         6257, 4337, 4336}, {8004, 6491, 2134, 4013}, {6924, 5770, 2752, 
         2904}, {7754, 6482, 2120, 3712}, {7383, 7754, 3712, 3317}, {5915, 
         8023, 4036, 1023}, {6485, 7384, 3318, 2124}, {8352, 6149, 1616, 
         4420}, {8264, 8263, 528, 4314}, {8003, 8004, 4013, 4012}, {7906, 
         7905, 3890, 3891}, {5871, 6240, 1754, 1700}, {6240, 6078, 1507, 
         1754}, {5914, 6963, 2941, 2134}, {8586, 8584, 2433, 4698}, {7905, 
         6373, 4420, 3890}, {6655, 7790, 3755, 4036}, {6923, 6919, 2899, 
         2903}, {6257, 6437, 2053, 4337}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5728, 6555, 6556, 6656, 7790, 6655, 8023, 5915, 8743, 7789, 
         7591, 8765, 6198, 8217, 6197, 7609, 6215, 6481, 8661, 5897, 7054, 
         5898, 8662, 6482, 7754, 7383, 8678, 6015, 7442, 7443, 7243, 8752, 
         5727, 7616, 7623, 6918, 8251, 8252, 8250, 6231, 6079, 8684, 6078, 
         6240, 5871, 8650, 6213, 6436, 8707, 6437, 6257, 8286, 6258, 8287, 
         5935, 7140, 7141, 6671, 8584, 8586, 8585, 6919, 6923}],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6261, 6765, 6764, 6554, 6553, 6963, 5914, 6491, 8004, 8003, 
         8240, 8239, 7334, 7333, 6149, 8352, 6373, 7905, 7906, 6483, 5899, 
         7055, 5900, 6484, 7386, 5887, 7049, 7385, 7384, 6485, 8663, 5901, 
         7036, 6444, 8708, 6445, 6922, 6921, 5843, 8263, 8264, 8262, 8266, 
         8265, 5957, 7095, 8511, 8512, 8510, 6557, 6768, 5770, 6924}],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5834, 7963, 8192, 8191, 6106, 7512, 6107, 7513, 7949, 7950, 
         6957, 6958, 6547, 7856, 7857, 5718, 5763, 8184, 7546, 7547, 7508, 
         7510, 7509, 5829, 7326, 7327, 7263, 7587, 8734, 5764, 7588, 7634, 
         6256, 6808, 5970, 7156, 5971, 6704, 7398, 7003, 6371, 8350, 8351, 
         7903, 7904, 5787, 8478, 5788, 6776, 6724, 7065, 7064, 6372, 8452, 
         6458, 8451, 6457, 8557, 8558, 7780, 6627, 7781, 7127, 8080, 8079, 
         8078, 6706, 8675, 8603, 8108, 6017, 8107, 6016, 8293, 6266, 8064, 
         8063, 8062, 6265, 8292, 6081, 7595, 6201, 7594, 7635, 8288, 6259, 
         8047, 5939, 8220, 6200, 8218, 6199, 8219, 6902, 5731, 6745, 6150, 
         7335, 7337, 7338, 7593, 7592, 5839, 7744, 6446, 7743, 6447, 6970, 
         6969, 7096, 6558}],
        "17.5`"],
       Annotation[#, 17.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6903, 5773, 5735, 7867, 7866, 6559, 6975, 6974, 5859, 8201, 
         6168, 8200, 6167, 8337, 8338, 8336, 6348, 8143, 6110, 7908, 7909, 
         5795, 8199, 5794, 8554, 8555, 8553, 6617, 7122, 7121, 5848, 7499, 
         7500, 7496, 7498, 7497, 7565, 5793, 8631, 6375, 5903, 7120, 6615, 
         8721, 6616, 6226, 6492, 8670, 5919, 7059, 5920, 8247, 8248, 8244, 
         8246, 8245, 5734, 5772, 6572, 6571, 7815, 6730, 7813, 6729, 7814, 
         6166, 7179, 7180, 6784, 5846, 6920, 5847, 8480, 8481, 8479, 6501, 
         6674, 8725, 6673, 6799, 6798, 8587, 6672, 8072, 8073, 5973, 8602, 
         7777, 7652, 7653, 7402, 5972, 6161, 8689, 6160, 6243, 6158, 8688, 
         6159, 5981, 6021, 8622, 5730, 6500, 8427, 8428, 8426, 8430, 8429, 
         6440, 8433, 6442, 8431, 6441, 8432, 6867, 8492, 6521, 8491, 6522, 
         6962, 6961, 8509, 6552, 7759, 7761, 7760, 6334, 7181, 7713, 7712, 
         7711, 6731, 7817, 6333, 7710, 8755, 7240, 8754, 7241, 5767, 6960}],
        "17.5`"],
       Annotation[#, 17.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5691, 6538, 6284, 6488, 8712, 8713, 5877, 6487, 5878, 6475, 
         6476, 7053, 7052, 5892, 7164, 7165, 6791, 6790, 5880, 7618, 5879, 
         7382, 7381, 7611, 7610, 6739, 8255, 6232, 8013, 8014, 8290, 8291, 
         8052, 8053, 7625, 6233, 7624, 8257, 8256, 5799, 6926, 5798}],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5719, 7545, 6140, 7511, 6141, 7550, 7551, 7549, 6143, 6862, 
         6073, 7548, 6142, 7325, 7948, 5828, 6898, 7700, 7506, 7507, 7274, 
         7901, 7902, 6821, 7277, 7276, 7275, 6105, 7702, 8619, 7703, 7701, 
         7858, 7553, 6144, 7552, 6145, 7554, 8046, 7397, 7633, 7632, 7741, 
         7029, 5969, 8071, 7401, 6703, 7799, 6520, 7081, 6624, 6626, 6625, 
         7126, 6423, 6718, 6424, 7589, 6192, 7366, 7636, 7637, 6262, 7638, 
         6511, 8716, 6512, 6490, 8669, 5912, 7030, 6498, 8714, 6499, 5936, 
         6214, 8651, 5872, 7377, 7378, 7328, 7329, 5836, 7619, 5835, 8550, 
         6608, 8549, 6609, 5938, 6705, 5937, 8680, 8681, 8679, 6018, 6241, 
         5841, 8644, 6153, 6082, 7447, 6019, 7444, 7446, 7445, 7557, 5732, 
         8193, 6151, 7556, 6152, 7597, 7598, 8222, 8221, 6202, 8750, 7964, 
         5840, 8643, 7596, 7449, 6023, 8109, 6022, 7723, 6359, 7336, 6358, 
         6966, 6335, 6971, 6972, 6965, 6964, 6869, 6980}],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5724, 7859, 7488, 6077, 7262, 6076, 7705, 6331, 7816, 6330, 
         6763, 6762, 7709, 6332, 7706, 7708, 7707, 7742, 5726, 6744, 6529, 
         8086, 8087, 8088, 7087, 5980, 7440, 7441, 7439, 7892, 7891, 5768, 
         5725, 8730, 7266, 7242, 7340, 7339, 5842, 7601, 7602, 7600, 7599, 
         7341, 6155, 6157, 8687, 6156, 6883, 6884, 6342, 8333, 6341, 6973, 
         5974, 8074, 7403, 8685, 6086, 7493, 7269, 8335, 6344, 8334, 6343, 
         6523, 8674, 5977, 6533, 8717, 6534, 6109, 8630, 5792, 6279, 8229, 
         8206, 8207, 8205, 6176, 8309, 6281, 8308, 6280, 6614, 6613, 7037, 
         6451, 7131, 6639, 6640, 8659, 5891, 7050, 7006, 8569, 8570, 8568, 
         6643, 7124, 7123, 8556, 6619, 8468, 6474, 8011, 8012, 7051, 6471, 
         6473, 8710, 6472, 6486}],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6032, 7502, 6097, 7501, 6096, 7459, 6033, 7456, 7458, 7457, 
         7571, 5743, 8446, 8447, 8445, 6454, 8448, 6453, 7039, 7979, 7355, 
         7751, 7750, 7763, 6981, 7995, 7994, 7373, 6628, 7046, 7045, 7188, 
         6736, 7192, 6738, 7193, 7194, 7191, 7190, 7187, 6378, 7820, 7821, 
         7819, 6735, 7174, 7173, 6452, 7038, 7270, 7769, 6515, 7074, 7399, 
         7400, 7147, 7148, 6689, 8727, 6688}],
        "15"],
       Annotation[#, 15, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5693, 6836, 5692, 8495, 6526, 7757, 6527, 8501, 8502, 8499, 
         6535, 8500, 5978, 8081, 6711, 8607, 6528, 8083, 8084, 8085, 7083, 
         5979, 8082, 7720, 6350, 7719, 6349, 6929, 6285, 7185, 7186, 6928, 
         6927, 6841, 5700, 8347, 6362, 7724, 6363, 8362, 8363, 8360, 6382, 
         8361, 5781, 8370, 6387, 8369, 6388, 7013, 7012, 7913, 7912, 7911, 
         8546, 8545, 7770, 8111, 6041, 8113, 8112, 7360, 7361, 5852, 8276, 
         8277, 7982, 7981, 7980, 6184, 6888, 6887, 7210, 7209, 7673, 7208, 
         7388, 7387, 5904, 6997, 6366, 8348, 6367, 8349, 6119, 6886, 5784, 
         8628, 6575, 6393, 7290, 7771, 8634, 5807, 7772, 5806, 8460, 8461, 
         8459, 8463, 8462, 6125, 8157, 8158, 7898, 7897, 5783, 7521, 7522, 
         7520, 6118, 8233, 6219, 8231, 6218, 8232, 5802, 7641, 7642, 7284, 
         7283, 7282, 6117, 7608, 6211, 8228, 6210, 6657, 5926, 7136, 5927, 
         6658, 8575, 5925, 8028, 8029, 7825, 7826, 5699, 8230, 8598, 8599, 
         8597, 6690, 8596, 6691, 7150, 7149, 5959, 8299, 8300, 8296, 8298, 
         8297, 5779, 8608, 6712, 5982, 7088, 5983, 6530, 8496, 8295, 6268, 
         8294, 6267}],
        "12.5`"],
       Annotation[#, 12.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5742, 6773, 6772, 8595, 6687, 8067, 8068, 8069, 7073, 5958, 
         8070, 7518, 6112, 8146, 6111, 8144, 8145, 8075, 8307, 8076, 8077, 
         6277, 8699, 6278, 5986, 7091, 5985, 6715, 6283, 7658, 7656, 7657, 
         7655, 7654, 7345, 6165, 8332, 6340, 7864, 7865, 6570, 8718, 6569, 
         7098, 7099, 6633, 7782, 6632, 7783, 5845, 6224, 8241, 8243, 8242, 
         6029, 7861, 7862, 7863, 8254, 8253, 7603, 7515, 7516, 7514, 6108, 
         7517, 7966, 7965, 6154, 8194, 8525, 8524, 7100, 7101, 6637, 7787, 
         6636, 7788, 5865, 7615, 5866, 7375, 7374, 8227, 8226, 6080, 8126, 
         8128, 8127, 5837, 7035, 5838, 8642, 6439, 7279, 8677, 7278, 8104, 
         8105, 8106, 7434, 7435, 7265, 8620, 5723, 5766, 6959, 8735, 8760, 
         6864, 8758, 6865, 7086, 7085, 6761, 7704, 6329, 7238, 7239, 6866, 
         6075, 7697, 6327, 7237, 7853, 5715, 5762, 7694, 7486, 7487, 7261, 
         7698, 8705, 7699, 8753, 6328}],
        "12.5`"],
       Annotation[#, 12.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5744, 7874, 8691, 6179, 8209, 6180, 6831, 6830, 5851, 7356, 
         6832, 6035, 7040, 6034, 7504, 6099, 7503, 6098, 6835, 6036, 7158, 
         7159, 6834, 6833}],
        "12.5`"],
       Annotation[#, 12.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6347, 6870, 6087, 6967, 6968, 6873, 6871, 5736, 7745, 7452, 
         7453, 7448, 6026, 7454, 6083, 7489, 6084, 7490, 6024, 8110, 6025, 
         7451, 7967, 5844, 6826, 7344, 7343, 7342, 6162, 8331, 6336, 7860, 
         5733, 8196, 6163, 8195, 8198, 8197, 6020, 7244, 7267, 8621, 5729, 
         5769, 6443, 8434, 8435, 8423, 8425, 8424, 6357, 7047, 6460, 7172, 
         6766, 6767, 6461, 6462, 6438, 7330, 7331, 7332, 6994, 7069, 7070, 
         6513, 7168, 7169, 6803, 5955, 7071, 6827, 8605, 6707, 8604, 6708, 
         7117, 7116, 7776, 6610, 7590, 6196, 7368, 7369, 6242, 5913, 6684, 
         8065, 8066, 5956, 7094, 8507, 6550, 8506, 6551, 8508, 6567, 7768, 
         6566, 7604, 7605, 7606, 7810, 7809, 6208, 8751, 7808, 7622, 6230, 
         7621, 6229, 8249, 5864, 7620, 6228, 7437, 6013, 7436, 6014, 7438, 
         7639, 7640, 6263, 8697, 6264, 6223, 8237, 6222, 8238, 5831, 8235, 
         8236, 7953, 7952, 7951, 6148, 6901, 6900, 6825, 5765, 7890, 7264, 
         8125, 6074, 8683, 7367, 7992, 7555, 6147, 8185, 6146, 6193, 8647, 
         5858, 6238, 8696, 6239, 6195, 8216, 6194, 5830, 8737, 7432, 8736, 
         7433, 7431, 7543, 7542, 7586, 7887, 7888, 7585, 8749, 7584, 7260, 
         6062, 8284, 8285, 8282, 6255, 8283, 5827, 7947, 7946, 7991, 7990, 
         5857, 8120, 8121, 8117, 8119, 8118, 8281, 5826, 7322, 7321, 7541, 
         8181, 8180, 7365, 7989, 7364, 8215, 8214, 7583, 7259, 6061, 7477, 
         6007, 7421, 7428, 7427, 7505, 5717, 7854, 7855, 8183, 8182, 6139, 
         6819, 6818, 7324, 7323, 6824, 6012, 6899, 6743}],
        "12.5`"],
       Annotation[#, 12.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5695, 6838, 5694, 7195, 6837, 6038, 6932, 6037, 7660, 7661, 
         8311, 8310, 6286, 8702, 7875, 7876, 7247, 6351, 7721, 6288, 7084, 
         6287, 6931, 6843, 5701, 7200, 6842, 6043, 6930, 6042, 7669, 7670, 
         7668, 7878, 7877, 7880, 7879, 7249, 7248, 7199, 6295, 6846, 8731, 
         6845, 7213, 7212, 7211, 7675, 7674, 7722, 6812, 6813, 6121, 8152, 
         6120, 8747, 7523, 8160, 8159, 5751, 7834, 7833, 7832, 6542, 8504, 
         6301, 6942, 7984, 7983, 6455, 8449, 7753, 7291, 7525, 7524, 7677, 
         6949, 5810, 7926, 7295, 6598, 7773, 6401, 7018, 6732, 7189, 6733, 
         8729, 6737, 6999, 6368, 8612, 6734, 7818, 8614, 8613, 6723, 8609, 
         6722, 7017, 5754, 7251, 6741, 6740, 7170, 6352, 6948, 6947, 5809, 
         8466, 6467, 8465, 6468, 8467, 6127, 8161, 8162, 7613, 7612, 8234, 
         7529, 5753, 8764, 8763, 7528, 8738, 7527, 8762, 8739, 7530, 5867, 
         7996, 6641, 8567, 6642, 7133, 7132, 5893, 6479, 8711, 6478, 6998, 
         5884, 8654, 6466, 5951, 7142, 7143, 6679, 8590, 6678, 8591, 6983, 
         6982, 5950, 8057, 8056, 6507, 7391, 5923, 6941, 6299, 8321, 6300, 
         6879, 6878, 6593, 8720, 6594, 6592, 8544, 6595, 8541, 8543, 8542, 
         6840, 7793, 7794, 7792, 7796, 7795, 6539, 6540, 8615, 5698, 6877, 
         8358, 8359, 8357, 6380, 8356, 6381, 7008, 7007, 5797, 7406, 7407, 
         7405, 8090, 8089}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5716, 7484, 7886, 7485, 7258, 6072, 7483, 7852, 7236, 7696, 
         7695, 6760, 6956, 6071, 6861, 6955, 6954, 5761, 6759, 6326, 7692, 
         6325, 7693, 6863, 5722, 8421, 6434, 8420, 6435, 8422, 6432, 7034, 
         7962, 7961, 6433, 8419, 6549, 8418, 6431, 7959, 7960, 5833, 7033, 
         5832, 7958, 7957, 6430, 8417, 6548, 8416, 6429, 7954, 7955, 7956, 
         7031, 7032, 6428, 8414, 6427, 8415, 5721, 8411, 6426, 8410, 8413, 
         8412, 6425, 8408, 8409, 8405, 8407, 8406, 5720, 8187, 8188, 8186, 
         8190, 8189, 6011, 8103, 6010, 8746, 7540, 8179, 8178, 6822, 5760, 
         8625, 7889, 6565, 8521, 6356, 6993, 7945, 7944, 6420, 8402, 6008, 
         7429, 6009, 7430, 7755, 8477, 6497, 8040, 8041, 8042, 6669, 6797, 
         6796, 7176, 6519, 6699, 6698, 8175, 6136, 8174, 8177, 8176, 6054, 
         7471, 6053, 7472, 6254, 7273, 7272, 7271, 6104, 8172, 8173, 8171, 
         6135, 8170, 8169, 7884, 8116, 8115, 6001, 7068, 6000, 6817, 6897, 
         6896, 7231, 7230, 7229, 7691, 7690, 6138, 7318, 7319, 7320, 7651, 
         7650, 5825, 8641, 7422, 8640, 7423, 8099, 8098, 6005, 7476, 6060, 
         7315, 6059, 7426, 6006, 7228, 7425, 7424, 7544, 6823}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5738, 6874, 7730, 6875, 6979, 6978, 6771, 6977, 6345, 6872, 
         7245, 7746, 7747, 7346, 7968, 7969, 6828, 6829, 6170, 8202, 6169, 
         8748, 7868, 7869, 5739, 7562, 7563, 7455, 6027, 7450, 6028, 8129, 
         8130, 7893, 8453, 5771, 8454, 8455, 8437, 6448, 8436, 6449, 8438, 
         6360, 8522, 6568, 7894, 8626, 8627, 7714, 7491, 7492, 7268, 7715, 
         7716, 6337, 6868, 6085, 7160, 6769, 6770, 6338, 7717, 6339, 7718, 
         7907, 5789, 7004, 5790, 7281, 7280, 7729, 7728, 7762, 8551, 6611, 
         7778, 6612, 8552, 6374, 8353, 8355, 8354, 5791, 7559, 7560, 7558, 
         6164, 7561, 5873, 8652, 6216, 5916, 6469, 8658, 5889, 7005, 6502, 
         8715, 6503, 5941, 6504, 6244, 8267, 6245, 8268, 6205, 7371, 7372, 
         5861, 7617, 5860, 8457, 8458, 8456, 6459, 8606, 6710, 7800, 6709, 
         7801, 7118, 7119, 7072, 6514, 7184, 6804, 6805, 6685, 7791, 6686, 
         8594, 6574, 8523, 6573, 5777, 6749, 6748}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5862, 8648, 6629, 6493, 8026, 8027, 5922, 7060, 5921, 7389, 
         7390, 7357, 7752, 7358, 7359, 7041, 7042, 6621, 7779, 6620}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5696, 7196, 6839, 6040, 6933, 6039, 7664, 7665, 7662, 6289, 
         8312, 5746, 6750, 6291, 7659, 6290, 7666, 6389, 7733, 5702, 7204, 
         7203, 7672, 7671, 6753, 6939, 6044, 6844, 6936, 6935, 5748, 7828, 
         7827, 7202, 6296, 7738, 6395, 7737, 6394, 7216, 7215, 7198, 6302, 
         7676, 6754, 7021, 7022, 6847, 8756, 8757, 8733, 8732, 6943, 5752, 
         5705, 8617, 7250, 7214, 7297, 7296, 7299, 7298, 6814, 5993, 7019, 
         5992, 7467, 6049, 7466, 6048, 6816, 5995, 7157, 5994, 6815, 6892, 
         6891, 7220, 7219, 7218, 6544, 7758, 6518, 7079, 7080, 6716, 7078, 
         7077, 6848, 7532, 7533, 7304, 7303, 7302, 6129, 8211, 8212, 8210, 
         6185, 5756, 5707, 7843, 7842, 8325, 8324, 6308, 7726, 7727, 7725, 
         7900, 7899, 5786, 8475, 8476, 6775, 6774, 7175, 6496, 6665, 8724, 
         6664, 6668, 6667, 7139, 6666, 7807, 6720, 7805, 6719, 7806, 7125, 
         7043, 7044, 6721, 6801, 5944, 8482, 8483, 7756, 6415, 8398, 6416, 
         6908, 6907, 5818, 7938, 7581, 6190, 7580, 6191, 7582, 5934, 8045, 
         6318, 8328, 7846, 7847, 5710, 6894, 5713, 7537, 7538, 7536, 6137, 
         7539, 5856, 8404, 6422, 8403, 6421, 7233, 7232, 6855, 6063, 7144, 
         8124, 8123, 8122, 6726, 8610, 7234, 6856, 6064, 6990, 6065, 6857, 
         7235, 6858, 6066, 6992, 6067, 6859, 7850, 7478, 6068, 7254, 6069, 
         7479, 7851, 7480, 6070, 7256, 7482, 7885, 7481, 5714, 6860, 7688, 
         6322, 7687, 6323, 6758, 5759, 7685, 7686, 7475, 6058, 7257, 7689, 
         8330, 6324, 7227, 7848}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5849, 7978, 8444, 8443, 6376, 7731, 6377, 7732, 6346, 7784, 
         7785, 7246, 5737, 5774, 6976, 8439, 8440, 7748, 6450, 7749, 7971, 
         7970, 8442, 8441, 6088, 7494, 6089, 7495, 7993, 7370, 8690, 6171, 
         7564, 7347, 7348, 6203, 8132, 6090, 8131, 6091, 8133, 6030, 8203, 
         6172, 7972, 7973, 7974, 6204, 8135, 6092, 8134, 6093, 8136, 6031, 
         8204, 6173, 7975, 7976, 7977, 6174, 8138, 6094, 8137, 6095, 8139, 
         5975, 6809, 5976, 7161, 6777, 6778, 6175, 6792, 5917, 7166, 5918, 
         6793, 7349, 7804, 5940, 6800, 5888, 8657, 6225, 5902, 7056, 7057, 
         6725, 6789, 5890, 8565, 8566, 8010, 8009, 8008, 6470, 6618, 8645, 
         5850, 7354, 6282, 8701, 7353, 8700, 7352, 7351, 6178, 6361, 5776, 
         6747, 6746}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5948, 8054, 8055, 8015, 8469, 8016, 8017, 6995, 6996, 6364, 
         7895, 7896, 5782, 6889, 6909, 8489, 6516, 8488, 6517, 7076, 7075, 
         5960, 8302, 6270, 8301, 6269, 6811, 5988, 6217, 8653, 5881, 6477, 
         6365, 6116, 8632, 5800, 6635, 8001, 8002, 5883, 7130, 5882, 8000, 
         7999, 8563, 8562, 7786, 8091, 8094, 8093, 8092, 7392, 7393, 5928, 
         8490, 8365, 8366, 8364, 6383, 8367, 6183, 8759, 6904, 7910, 8368, 
         6384, 8030, 5929, 8259, 6235, 8258, 6234, 6675, 8672, 5949, 7066, 
         7067, 6677, 8588, 6676, 8589, 5906, 7134, 8020, 8019, 8018, 6646, 
         6786, 5863, 8464, 8314, 8315, 8313, 8317, 8316, 6752, 6591, 8633, 
         5801, 7010, 7011, 6386, 8706, 6385, 5780, 6581, 8719, 6582, 6536, 
         8503, 6537, 7822, 7823, 7824, 5745, 6580, 8528, 8530, 8529, 6579, 
         8534, 8535, 8531, 8533, 8532, 5778, 8539, 6586, 8538, 6587, 8540, 
         6583, 8537, 6585, 8536, 6584}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6779, 7162, 5963, 6807, 7394, 7395, 7061, 7062, 6494, 8471, 
         8473, 8472, 5853, 6944, 8340, 8341, 8339, 8343, 8342, 8505, 6543, 
         7526, 6126, 7293, 7294, 7643, 7644, 7812, 7811, 6806, 6694, 5961, 
         7151, 7152, 6693, 7797, 6692, 7798, 5804, 6905, 7289, 7288, 7287, 
         6596, 7105, 7104, 5905, 6680, 8726, 6681, 6946, 6945, 6303, 6304, 
         6236, 8695, 6237, 5930, 7014, 7015, 6597, 7916, 7917, 7918, 6925, 
         5805, 6910, 6911, 6647, 8664, 5907, 7058, 5908, 8665, 6489, 6788, 
         6649, 8667, 5910, 7135, 5909, 8666, 6648, 6913, 6912, 5808, 8280, 
         6249, 8279, 6250, 6272, 8698, 6271, 8033, 8032, 8278, 8031, 8274, 
         8273, 6247, 8275, 6248, 7629, 8051, 5943, 7106, 7107, 7108, 7183, 
         7182, 6599, 7109, 7404, 8611, 6727, 8493, 8494, 6525, 7177, 6524, 
         7082, 6660, 6795, 6794, 7167, 6408, 7026, 6600, 7027, 6409, 7138, 
         6661, 6662, 8671, 5932, 7063, 7002, 8577, 8578, 8576, 6663, 8579, 
         6603, 7111, 6604, 8547, 6605, 8548, 6252, 7308, 7307, 7306, 6133, 
         7535, 6545, 8346, 6354, 8344, 6353, 8345, 6952, 7987, 7986, 7985, 
         6456, 8450, 6782, 8486, 8487, 8058, 8059, 5953, 8592, 5952, 8498, 
         6531, 8497, 6532, 7090, 7089, 5984, 7803, 6713, 7802, 6714, 7155, 
         7154, 6701, 8728, 6702, 6276, 8304, 8306, 8305, 6275, 7648, 6274, 
         7649, 6895, 5712, 6742, 6134, 7314, 7316, 7317, 7579, 7578, 5824, 
         8639, 7312, 8638, 7313, 8101, 8102, 8100, 7849}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5740, 7870, 7871, 8270, 8269, 6246, 7628, 8049, 8048, 6260, 
         8289, 8025, 8024, 8272, 8271, 7350, 7566, 8208, 7567, 7380, 7379, 
         5874, 7129, 5875, 7998, 7997, 6634, 8561, 6785, 8564, 6638, 8005, 
         8006, 8007, 7102, 6576, 8526, 6577, 8527, 6177, 7568, 7570, 7569, 
         5942, 8050, 7872, 7873, 5775, 5741}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5817, 7937, 7305, 8141, 8142, 6101, 8140, 7531, 8164, 8165, 
         7932, 7933, 7934, 6652, 8723, 6653, 6650, 8574, 6651, 8571, 8573, 
         8572, 5709, 6914, 6915, 6659, 8034, 8035, 8036, 7137, 5931, 7025, 
         8390, 6404, 8389, 6405, 6917, 6916, 5814, 8392, 6406, 8391, 6407, 
         8655, 5885, 6480, 6102, 8686, 6103, 5894, 6212, 8649, 5868, 7376, 
         8693, 6186, 7572, 7362, 7363, 5855, 7614, 5854, 8646, 6623, 6622, 
         6645, 8722, 6644, 5895, 8741, 8742, 8740, 7420, 7419, 7627, 7626, 
         7943, 5823, 8637, 6607, 7115, 7114, 5968, 8673, 6700, 8601, 8044, 
         8694, 6189, 8213, 7988, 8260, 8261, 8021, 8022, 7577, 6188, 7574, 
         7576, 7575, 6893, 6820}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6292, 6934, 5747, 6751, 6294, 7663, 6293, 7667, 6392, 7736, 
         5703, 7206, 7205, 7409, 7408, 7460, 7734, 5803, 7286, 7285, 6390, 
         6938, 6937, 5749, 7830, 7829, 8318, 6297, 8320, 8319, 8704, 8703, 
         7919, 7292, 6399, 7739, 7217, 7201, 5989, 7411, 6045, 7463, 6397, 
         8377, 6398, 8378, 6396, 8375, 8376, 8372, 8374, 8373, 6880, 5706, 
         7835, 7836, 8383, 8382, 6403, 7024, 7023, 5813, 7929, 7413, 5997, 
         8096, 5996, 8744, 7881, 7882, 8114, 6050, 8682, 7300, 7301, 5812, 
         7020, 5811, 7928, 7927, 6402, 8381, 6100, 8327, 6310, 8326, 6309, 
         6950, 6951, 6509, 8484, 6508, 8485, 6510, 8167, 6130, 8166, 6131, 
         8168, 8600, 6696, 5965, 7153, 5964, 6695, 6220, 7845, 7844, 8097, 
         5998, 8745, 8043, 5933, 7396, 6253, 7630, 7775, 7774, 8581, 6670, 
         8580, 8583, 8582, 6631, 8559, 6630, 8560, 5869, 7128, 5870, 6787, 
         6654, 8668, 5911, 7093, 6546, 6227, 8660, 5896, 6003, 8676, 6002, 
         6802, 5945, 7163, 6717, 6783, 5819, 6906, 5820, 6682, 8593, 6683, 
         7146, 7145, 5954, 8060, 8061, 7939, 7940, 5822, 6989, 8517, 8518, 
         8516, 8520, 8519, 6004, 7740, 6417, 7309, 7310, 7311, 6991, 7766, 
         6563, 7765, 6564, 7767, 6319, 7473, 6055, 7253, 7682, 7683, 6320, 
         7474, 6056, 7255, 7684, 8329, 6321, 7225, 7226, 6851, 6057, 6987, 
         6988, 6853, 6852, 5711, 6854, 7681, 6316, 7680, 6317, 6757, 5758, 
         6953, 6315}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6885, 6464, 8709, 6465, 6463, 7048, 5876, 8225, 6207, 8223, 
         6206, 8224, 6209, 7607, 6114, 8151, 6115, 7519, 5924, 8150, 6113, 
         8147, 8149, 8148, 6876, 5697, 7197, 6505, 5946, 6506, 5947, 6182, 
         8692, 6181, 5796, 6578, 6379, 7009, 6589, 6590, 6588, 7103, 7092}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7831, 7207, 5987, 7410, 7462, 7461, 8155, 6123, 8154, 6124, 
         8156, 6122, 8153, 8624, 8623, 6810, 5750, 5704, 8616, 6541, 6298, 
         6940, 7915, 7914, 6391, 8371, 7735, 7412, 8761, 5991, 8095, 5990, 
         7465, 6047, 7464, 6046, 8379, 8380, 7923, 7924, 7925, 7016, 7922, 
         7921, 7920, 6400, 6882, 6881, 7841, 7840, 7839, 6307, 8323, 6306, 
         8387, 8388, 8384, 8386, 8385, 8470, 6890, 5785, 8629, 6369, 7001, 
         7000, 5962, 7646, 7647, 7645, 6273, 8303, 5755, 7838, 7837, 8322, 
         6305, 8038, 8039, 8037, 6495, 8474, 7931, 7930, 6128, 8163, 6370, 
         6697, 5966, 7110, 6601, 6602, 6251, 6781, 6780, 7178, 6132, 7534, 
         6728, 6311, 7097, 6560, 6313, 6312, 6221, 8656, 5886, 7417, 7418, 
         7414, 7416, 7415, 7631, 5821, 8636, 6606, 7113, 7112, 5967, 6410, 
         8635, 5815, 7573, 6187, 7469, 6051, 7468, 6052, 7470, 7942, 7941, 
         8400, 8399, 6411, 8393, 6412, 8394, 6355, 7028, 6418, 7171, 6755, 
         6756, 6419, 8401, 6413, 8395, 6414, 6985, 6984, 8514, 6561, 8513, 
         6562, 8515, 5999, 8396, 8397, 7935, 7936, 5816, 6986, 7764, 7678, 
         7679, 7222, 7223, 7224, 6849, 8766, 6850, 6314, 7221, 7252, 8618, 
         5708, 5757, 7883}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointBox[{{1., 1.}, {
     1.6837224987546646`, -0.13761442456480055`}, {-0.9772746814156097, 
     0.44561313292741034`}, {0.061493299549043146`, 
     0.31080011651922534`}, {-0.027639056310519314`, 
     0.34316705937294495`}, {-0.020309448441028985`, 
     0.34115712470230586`}, {-0.020912126633883057`, 
     0.3413388892327804}, {-0.020862295429729893`, 
     0.34132396955047195`}, {-0.020866414226024716`, 
     0.3413252034734049}, {-0.02086607377733785, 
     0.3413251014856732}, {-0.020866101917849378`, 0.34132510991572085`}}]},
  Frame->True,
  PlotRange->NCache[{{0, 10}, {0, 2 Pi}}, {{0, 10}, {0, 6.283185307179586}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->98931193]
}, Open  ]],

Cell["Use a better starting value:", "ExampleText",
 CellID->426878744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"bfit", ",", " ", 
    RowBox[{"{", "bevals", "}"}]}], "}"}], " ", "=", " ", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"model", "[", 
      RowBox[{"{", 
       RowBox[{"w", ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "4"}], "}"}]}], "}"}], ",", "x", ",", " ", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"w", ",", "p"}], "}"}], "]"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->379100747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "\[Rule]", "9.413989524318383`"}], ",", 
     RowBox[{"p", "\[Rule]", "1.5809016959103723`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4.`", ",", "4.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8.845908970030887`", ",", "1.048705548875105`"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"9.209689842849516`", ",", "1.5740435210099788`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"9.410367164059767`", ",", "1.5808033354951376`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"9.41396332713259`", ",", "1.5809033117920657`"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"9.413989349945316`", ",", "1.580901714797556`"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"9.413989524318383`", ",", "1.5809016959103723`"}], "}"}]}], 
     "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{482, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->517198888]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"residual", ".", "residual"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Point", "[", "evals", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", "bevals", "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->19558978],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0XQd4VFXanlQSCElmMjPJpCcTd9eCu6Ji9xysa1cUG7vKKmLFtWJdZa1g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   "], {{{}, 
     {RGBColor[0.34338305666382923`, 0.1442836171851357, 0.5996467428062408], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGtsluUZx+/37VsqPdADPb1tKWXLRg3T+GU6CosLSG1xB8MKpSiHzQJS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtI1HEQx0dxd8t2+7cL7a77ardDDzRvaQVlJeRqj0N20JOWr6hwCbqV
hyzoUt06FKSuBhUdLIIemODr4FphHSqiLCjqYEGmlj3A+gxz+ML8/jO/me98
fzP/1KHM/vZ8EakFBeDtKpGvIZGEW6RxhchHzjOc13Lu9oi0YnfzrQhfpU/k
QExkI9iO76xXJIO/MiXiCYhccIEikRucz3EuJuYL/jfcr/BZjV78O/C7AnZn
J3Y6KtKfJ+LmPBkXWSD/SuLzl4vsDZMPVJDrHvd/41sMmh0kZigpMgaO+kWm
iBnF7iX++DL79pra0yHrrQH0U+92yuwS+p8lXxP+TrgPAYHfTEKkyhFp5v4/
+CyCO/Brpt8B7hYSs47YQfj+4v5PcN5lnCeo78X/CS4X4XATLj2cny+xHsbp
NQcCSy1HCbn7qF/N3TRoILYFzi+on6N+B73uCZrWx9BjTdw4K1fV9D3ndyDM
2Yu/HF9ZzLi2gB56yYIyuGyh/rWQ1dRaNeBxwmpobj81H8LtOpx3FYrMcecy
vumIyFbsLu6PJE1z1fqI37T6DtKOadYG91bwEvsVyJKrk/iY375pbxqjPu3x
FLk7wDTvWQouwe0+NW+h97jPtP0Ts7dWjYeJ3RSz3up5rsGgzYzOimqqWmsP
yl01n4XbYc4decZRZy9bZLOmMziBnQNJl3HQWW9DI7/PZl7v/iDHbsdyxDhf
CdtsjwGfvi39zWB/9tgsV0fN1pnWXUgHbdZ0J+bJNQdqHMvZhX0Sf5XuIj08
wBY41Dk2c3fJvRC2Wk34N9Brcdi00Znphuv6uO3mGD08In4gabbWCFJ/OGlv
NQraiZ0Pmdb6xqq1zrTOsmo+Sewz0OjYDP+FXyRls6j/hG2r7Q1U+83cfUrs
k6TtvnI+g90XtlnTHdS3v5qw3nQG5nm78oT1ohp/iNjO6a7pjLro3Q0OOsZh
n/YXsX+RvpFqlSFngd80q0Pr+qjNpu7AaWpPxW0XNGYkYpyVq/6zAtQ6EbXd
/Oax2VaNVBudca1dGrfdUA7N+JsiFqtv/B/02sCO
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.44335802298814253`, 0.3181130838836253, 0.7401736522476307], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnl4l9WVx98kv5CQPSHJL7/ssSpSsU47OqWDoigCguCGAurUCgIB41IB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHeU1dURx++y7C5lCyzwyu6+xqEK5ERjAY0gCBaQoqiAJOFIWXpTJMUF
5RjBhCjKCRjMAaSolOSgwgIJCGYRhEWKLGpMDN1oELGwCFLz+fr9Y86785u5
M3PvnTv3Oy8zdOJ9E+qEENpkhVCX32mpECqgD2B+XhRCVTqEf0AB+ejGIWzO
hLA3HkLj+iG8XRzCkCR8IoQi+HmFIayIhnAd/J15IezLCWEi+p+h3xndn0I9
kR9CXoDuRexPxtck6Bjj49CbjKux2Yjx9Y3QKQthN/oXCkIog38Z+XhsNIEv
gS/E9t2lIcxpGMIvie8R5G8zvx7zT0APMF6Gzh/wNxt6mLUMQudobgi1zH80
EkKE+SOYj2r4ANvvIb8XWX/oKHwN/CDGg6EHGS8gnt3434b97SUh3MP8F5j/
DGuei69K+K/gN9ULIQ/9rfhoxv4MRf879qNDLIQn8V/eBH/ID0KE/oOPLczf
DF1g/nfMz2Gcg7174SegdJFxJ2Jaxfm0zw+hbXO+w89mr0c3DWEjvnqi8zz6
g/B3FF+D4BfBLyS+C8S7CZ0DDULoxbfejOsg78d4Md+mE99FfI4i3gj297Ff
DeEfx3cFlM38ocR7ANt9dKZs2hT8v6CzZn+fQn4am2tIqjHY2ByxT/mqwX4N
8UzBXyX8TOIpwPZufEzF9jSoDvw5bPbBfjl8N+JZwrcD9XzGimUX+o82dkzL
8f0jzuNLbFUTw05kuegcga+D/8nMn4H/Sex3F+KtYNyAnLqFte0nnpbIx6E/
HftPQMeQH4U6cR7vYyOLWHbAj4Jvz/pmYf8gPrOx1xz/85E/xhrbIT+A/GZk
Y7D3G2z9GlqD/ZeYX4uv+fj/lPFtyK9D1qmhz3Iu357P8ZkeYVyJj19g+wbk
TzFeyp51IpYE38Yynlbi2B9CXpe9XB/xWpUjupu7+Jad7ztaF347NsYxdzw0
pMQ5r1zPYHMzsjMwBxiPQD4dfl7Sa4nAX1Yuxp0Lo7F3mnEPzn8N59OV9fTV
3WM/NyLfTo1YQnzlyEeyvo7YPMr62ysn2K+W5HtrdIex5gLuz0DmfAPfEprB
+vP51oazXIS8G+OuUC2yTuT43mYEnOvcGwbVFDkHr6J/Izrd8HUNMZeUOOeU
a3OJtwp+FTG1RZZgf/6GLIv56/BdSbxvsp4vkC9Hdko5gP6tJb5buiPr0H8a
+6/DP4d+V/S7QO829Bn2YX1vwDdjL5pCHxF7LrSTWHOgRxnXg6pzfca9GbfB
fj3iTcEfZu4hqAH2ryfeTvh6g3hasPflfLuVWE/GnbvLWe+lMtdE1cIY+zOT
83o15lzMQIfZj/9AeXmusY+hOxVagq2qPOeCaopqiXKif8w1S7VKMaoWT4m5
Nqom62xaQQ/m+4z2MP8q+fEZtn7V2LlwB/R6kXPiI8bHWeMMYvsZNnqjX469
S/BH4D/RepAn8DUcfgKx3sV+9GCv5xV4/Br6nfP8rZbY8tBfyVoGsz9/x94V
5HuRr+IMNsBfink8hHj6wq8n3g+J9yj2F8Sc08rlGHRMuYCPldi6DX4W5/db
aDr8APb4e+ZegJoSS0E2uYHvfxHzUGwNgz5nfIZvHXJ9hn0ZNyDGE4xXY6ML
9lP4exPdddCn6F9iv9qiPxp+Dus9iP0PiG8rPlpzf1pBu+q6BgVy/Qnmr0Be
wX15FtsvYXM063sDeTn+2mKjO3NncR7PYqtx3LV3A3Na6z2KOrcq8XkS3+eY
P5i13qY7y3gD8z9n/vpGfivuR+f3hX4zqtOu0arNU5jTB1s70MnK955dQPdr
vo1i7n3Ye43xtdi7A/29Oa51U7kzA/Jd84qJLZsYf5Lvmj9R72vauXMR+V/x
pWLUDv8dhAmS9iHb/aEz2J4Xc63aDt2IrAXfOhP/UPSz4esk7VuYYwuyQxHf
pdPo/A5fdZPGIrpTx6LOUeWm9kC14QbVpHzXCGGZ8Xw7lWtMM5z1NGEN5YRZ
SbwtmP9hylggwZlVJ/zG620XRrmM736qkfX8Bj3D3tXybV8d14yWqjUR15qp
+FhPfOugPXmu+RXE8hXx9sDeSmJqj/58fOwqMObowHhZ1G/ddOZfjXmOdEcX
GjvtgoqKjKFke2Pad0M+xkWNoYSdpPNF0jnyQ24U2ffVjHNPMSiXO+NjbSPn
9Fj8n0g5l+cST0f0z8d8NqoR85C3izk23Yk/wb8IjQleg+7Sqajvvu7UWuzf
lHRtV46OTRnTCMvoDF5QfUf/POMq5lex1m3QMXy9C9+XWDP4eyTXNbis1GvS
WnRnViJbAR3Jdk1Rrv0l5rdcOfc/9E+W+q0Q5t3C2dRNGftuy3KtCyljKdW8
QvLh6YyxrmqGsMISdA4XGjO0JN5/p1wrRmX57DNp1wLlwBbGW6F/ov8J9s4g
75xybd+OfAaxTUS+toFr+DXwf0x4rRV6QxjPTXgvtOZrhWWSPvuZ5MQa9AfA
P1voO7la9U4YAXu3w9+Efscyv4V6M7eguxW6iL0a4q9lfBZa3dCYQLI+addu
6Qwk1n5p11Zh6MqMMaaw5fJiYzlhcmFxYbr9+DqLznDyaVmusVt+3LVFGO54
yjVZtVg1ZQ/83pSxt97obezvzdgYyTgpvIrufuydK/aZdsdeD6iqyJi6X9SY
Q1ijLfvxSsxvpN5G1diu7HeizNhMmHsiezOp1GcxJ8u198m03wrV4HdKjPGF
7YUBv2U/vkkaG2qPxqWM6YXlhXHi2Cop9VsrTJiDfH/a2FkY9Txz10aMJYRx
5zAeD9Uvcs+iXFcPo95FOb+Uvbo941opDHye2M9BVVl+o95LuIdS76Q3VrXx
6zJjKdXI6rgxo7BiA/K1FXerRXNjhx839dkox5RbOiO9TTVlzkW9UcuJ95Wk
3xL1GPcjW8Wc2cWumar1d0X8Nqnmn0E+Iupc3JbjsxOmEZbRGQrLjYz67RKm
eyvinlK9pNbUKuE7pLsjjChf96DzULDP1RG/Aar9wjRfwk9C59Zi9xyqvR9G
jb1Ug4X9p2SMVdUD3MG4R8Z3uz7fHmc8DepV7J5H2P0W5l/INYZX7zozY2yg
Hva/cfe06mXlc0SJ3zC9XbpjD6TcI6o3VE5+r72LOLfUsw5J+A3R2yGMdDji
N0tvlWra0qh7YPW+wpzZpe651GupR3uuzG++3nph7q3I10GDstwzCnt2j/mu
CYMKCz2XMNYQJqrIuOdTr6c1fyzslnFvIky2IOI7rbusnv/FpDG7sHoNa/wz
fE90Pi50DRM2a9ncuSSMJpl6GPUu0lkcNaYXlhdmUe/0Vtq9nXqoRdhbmHSv
oJon7L8p7V5EPcC38J+l3JsJc72M7mLoUKFrrt7m99PuHfVG30nsd2V8tupJ
L6N7JeneRRhsCPolGWML9SjL4/6PQP8NqGYKC11JuJcQJpKvZTH3XvK5DV/v
pP1fiHqy1ugujDrXhUmF5c/GjVWF6R9MukdSb6T/IHoxXhl1LdN/BpPhd6Td
m91NTrwed0+hXqIj9W1gqf8z0X8l6uHVqzzMt1cbumfRfw3RqHtt/eeg3G0V
M7ZQDt/J3m0ptS1h9J2lxqzCquoRd8NXl7pW6j8KYb1dcdcKYb7h+q+k1LGp
5xKWG1ZiLCRMp166Nmrsrp5asb0V938XilG1+krEWFo1O502BhX2FKbQfy3C
FMIS+s/l/0B+tu8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5433329893124559, 0.49194255058211495`, 0.8807005616890206], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeclNX1xmcL22Z7m93ZMjOAGLCgWCgiYsGKioANBVGjURFBVGKsQSxo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmAz+X2xz/DmDHmOzPGMt99G1nayFLkKktKi12WrptSiCyhqJtSWSq/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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6222622677194174, 0.6214645052402962, 0.9108310252456071], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXecVEXWhpvJoSd0T+zuiWAGFBAURVYBEwoqohhWFAUR2FUXDIC6iIoJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmAz1X3xz/UMMyYMTOa774NKZQkSkqEsmXvV1FKUpaiQnayRpFoQbay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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6957670013640883, 0.7395661592976011, 0.9125067067750318], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeclcXVx+82ti/bb9m99+6CYEssEcUWjdgwsSfGN4Io2KUJigqoKIgi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmg11P6xz83dW/d7XuX+u7rrUhZihJafqMwIstYhl+LFkwLSqJVk0Lk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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.768594830751639, 0.8489867786437738, 0.911359209167649], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHecVdW1xw/TGGbmDtPvnZl778yABVBjj7wIaAT1JWIDFKJiAPW9JIrl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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXm8jeUWx1/DOc5xpn1O7P3us/e79z66pVJRhBuhEvc2T0oZilK34dKs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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8346070704092848, 0.8710001016111839, 0.8817857849567455], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnmUVNW1xi8N9lBd1V1Nd1dXd1V1VyECYhIVFRVlVIiIYpQhohjzcHqi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQldURxe8As8+bhWXe9+Yt88ZUUgpREJFF2dQCAbewQ1QwIKTCCEoA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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9006193100669307, 0.8930134245785939, 0.852212360745842], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnuQlXUZx1/2nD3s9Sx7OWfP2bN79hzG8oaKsAsioM1Ug2gzJWlqOup4
ydQ0lNSUCpKLgXLNgBXSSkfLRQWtIUspaAwoR7tppokWLCpqqTQZVtD3w/fZ
oT/efX/nfX+/5/f8nsv3ubxbveSLM66tSZJkt/6kuLclyZCur6aTZFtTkjzc
nCS9ejFf18fak+T1EUlyfS5JHswmybl1SXK75gxofqve1xaS5DsVr/nzqCS5
sz5JdmaS5LyuJMno3YyMaXxc1wbtt6vNvxmnqkkyqZgkHxbNsS1J8nRrkszU
+J7uJLmo2/vM7kmSs3TdKPplrVmuPbaK54zutbourE2SWVqzVmubdH9TvLxV
8e+JorlMcy4TD+mY3zEySf6u90dr32bNn5dPkn/1Jski0TxX+7zUmSQNGT+7
pcfPv8g8netrks90PVuiq18ymaO5bRp/VzwckzJ/x+v5Ko2P1NWt3+do7b06
7/2i0yK6fXq2ReOrcn5+pp49Jtopne8m0X9Iz9br6tGzaVn/Zszc7wWdN+p9
ngGNr09bNi9o336979P1H427dC/pyqZ97qPbffZx0suuqn/vGOV5zClKJv3S
1x3iZ3TOtDjX7WnTLOk8T2b8HPrzJbf7dPbF4uGgZPViyA2dYRfws0/0X0UH
ev5Ki8eLRW+i9ilpv/V6PzjK9wdE56H4zZwh7C2eTyiYP3hboWcrwwa4j5Oe
b9K57tb7e3R9VL+/0+j7/SNNYzDorND7lRWvYQ/ecZZTJY+P6BrRZnnuy4Y9
6Pd5ulYnttNrqrbVbp3xfD2fW++5/4j577d6fK72vULy+WlZetWZtzb4/rTW
HtR9ltb+SGuv1fuDonu1xoOh91Wic4Xu69qsnwvF7/U6/z909or2r+p6Vvsc
Ue/7DXX2j8+Ej/xA9+/r+jM+rLmXFz3nWI1v0fjOusP6GK2z39RovuEZO0mH
T6H3V0Jf+NyKkPns8METtHaG1v5G42dE70OifV3wOSh7mCt7+J7ofE3jm/X8
gJ4/Lzm8NMr40BX21y9bmaYznlbxu8m6T6mYbkU0JlZsn8jkV3r2c/HwzeAH
Xv4iGf5V1/dH2k+Q45f0fIHuC3VtxZ71vF16adKcetEaE766W3Ia6vE7/JZn
nPHEDslBaxdp3iit743nl2v8rs5UqbEfTAgfOTblOfj1dtntNl1rUravVPgL
9Bg/rnkjdc8E/Xekp/d1PSvaE7RvvZ6vSHl+bczB/6o5+2Cd+J+ge4/o3J/x
PGhuqTHewMPRgT2Pavy23jdJ7jvrrJtbJYvZ+LTsM5c3nvfqWVb3S0caW14P
rJuntbe2Oy5s1trbUuaBdR26bqixbz0YPvtco3ESvATHuc/R86kNvr8pOfxO
8p4pe6jNOu5AuzjC526Is5+YM/07wk6xRWyVffPB88ycf8MDPrcv/A68BDdv
lI9el/N85hIjiA9LA8+giV4atX5J2rLKxvjIEcaqVwK7bm6ynpDBSXXm9bHE
tlTXbnvCz9q67Gu/DPvGtnfKhneXbUcP6bzr2xw7BofHKeuT3+j0cclnWsG6
5T1r7kt5PBhrr2z2GmIJujtN5y3XW1/z261nbH9ByHN2i/WI3pE3Y2QODWhB
8wXJ6Ywe08TPrgj/BIcY43fQnhf2QGzhjJz11ng+O+SxIGRSm7avgBXEfGI/
uURZ8hg/2np6RfL6dpvpsxdjbBV7XJi1TRIrr8w5/kEDuxm2mbrQRSp8Cp0+
qHP8vse64xn+Ruw60Gqak2ptK7uCzvA58VlweXXWmHGq+DwBvYqX6VnLGX42
hI2BN0PBD/nMXv1emzV+cl8X40+Il9N6LGvOty7Ou0u0Ly973gyNTy+bz3bN
PaPbdkeMIQ7NqXfMOS/izrPS10c0/zn51sGM8XW35L1UNni7sP4NPZ8iPPmD
rgMp4yD4e4Hu43L2MfxrVtoxj3i9SOtGlhzvyJlaAvs26nqLnCLstj/w57Va
0/9vyrneA93O99brLINF6/Yp8Xl3t+m3yBd+U7I9b5QMHw372dPufJLcAR99
UjiyX/OPEo13K/4N7R8EfbCS2LNJ9y2iOSh5HddoTHmvwTkJ8uAZuMHZOTc2
ic7RPXY4kDJucpYnauz/+D5n/3WDzz+pYHvClsB/YjkxYJ3O9WXJekeDsY47
eFeVbiq6loEp9c7tyOvA5Gzkh8ThcSXHYnLQMeJzj2g+Ijk8rOsDzfm9aI+p
+t2SjPVMrgj+ogvOBf1T9Hyj7p/JO5clD3k4ckbi4D9F59K885/e2J9Y9gQ+
0W4+v5X27+P0bnuTa4B/a7xbZ09XjenM3RzziUXkiMQ+7HTsaNtqs3TxlZIx
Bx4eCT5O05xxo43JxE3W9kW+wzNyHux1fsgNLHsk5MB9Q9BpFP1lor80ZSyu
Bg/kU/gsvluvOUtLjpvkGdQj4BD+Ch1o92rON0vOKyY2OW6hO+wRuxzG242B
4fAFbXT7qnxubd71yiLR+JPOtl3rJ9X5PrHOekEn2GFeMmzUnEszts0PNfk9
OEBs3hm2Ax/wsFs0h0rOMeH9XdHcruebRae52/iDzh8Nu3ovxofy8BbzCb8/
y1iX6JF8HH6Iv8QndInOyQvgAT/9tGQytsv2Srxo7jA2YstPhN4n19o2qA3J
I7oDn76i+dmOw+sYUwvsG+nfjIckt3vzrsnwn9kRF7LKD48rOQ8FryYHnrDX
ybXmH2wnxyDPwS8nSHZjYl/23Ks5eyWbszqd4yEzcvkdOtf58rWP9Voe5Ahg
Hb6/PG2MuS9xbUp8ot5d12q8AYeuku1fXfV+yHxq+Bp2+1DYbpP2nSu5vaB3
Q2ljMP5JrtQWvnqe8KO51/I4FIdbLNuze4yPYGNJvB852jU2mAAewN9/w5fw
ZeTKmZHnTyTPe4quKeAJ/MQGiFFfb7Odc38qcoNf6L4l4i16Z4xNct8aY3AR
GSGf8/V7BDaifafrfAvLnrcy7RwJLCvpTEnFPDG3MXLOmrTrX9aSSxI/sL1T
JMtvF62X35acc5BvgAfVwITP54x3YN2Vmv+nonWNX4HRzbrGSw7jOmyHqbRr
b/h5oNb5HXwga86DnLeIVmODzzhW/J6g6ynqZ9EeX3J8hGZfh7GFmDYl7JA9
2As7wWYYwwPxnXhPPciz8fH8kbTXoS9yc2oJ7Bd6Uztsz9QqfcH/irTpshYM
6Q8eMrEWHMO2zmr0OZaG3R4ZtoG/gJPkXNQPYO/ClH0emeNDk2Pf+phDzgS/
/cHz5Dgvc5BTU8iKngS1NDgzNufYS77NmfdGjcD1emDLC5LnjIJjOv42NXKP
c3pt39g2c6kx6F2Afex3VMrPoEm+tDfmQHu4foCHvpAzciNPaYxcZbHsqEnj
H2r8qbKxEpzcGPZ3qE+Scz1ArQ29U4LmxvgN/9SUy6OuxLdOLdm/sCXwCXsC
q44PvLqNOFBy/Foum3q64F4EvkhOgz9SE1PDk5OTR5LHYtvLJZNlve5jwefC
0Fdr6I9ci7lXxXwwE17grT5s/rGI6dSfxHVqmsVR15Ars761xr2jqyJ/Jpbg
f8iKPGpT1HVJl/sRV0e83Fbn3P1inXFt0X2nDXq/sex6Cz+lrsIeiFPQZd3q
lHMd+Lku5pwT+Ty2SO6NDS6I3L1B8qvXdXajc8M/Fh1/yb3we/BhEXlxwVhW
1bhSdj4O7j6ft39Qi/dHnk8uQn5AbgAeUiNhD6yfFngIPhHbmqKOHhf5MOfe
HvKhBj0xzsidOcSgBbLlh6vGmwHxvKbkHGJO+AN6pCbYFXUB+dFFefP1WsF5
8H1Rl1EzEb+IFa9Hjk2uNL3b8WVP5Orsi+8Tl/ZH7orfkLPhr41R41ND/LHb
csiEPP4TvZpnQt/vRL9huKbnGfufr3PsKtjnjym6T0oswj6HIq5x7Y56HMze
HDlpq9a9W3XcGMh5Pn6HzJAv/IMNFxSNDxsj9++Pc5CPcBZwjt4WWEfc/mjv
YSzhDkZRk51csj8R63eEzqZq/zVF13k/1vu7NX6v0baHDXwQcX9F1Pifo8eQ
dy0Gv5wTnnfkXKMhz+7wr+G+yurorWA/q0L+1BCr4jmyuC3ifn/gFXh+bKzF
LzjzmqihiL/oj7iM38MDNkAvBLym30AcyET/aFPOvgcmYBv0ScFm+k7we1TE
RGIl+LAixpyXuPr5sGd6S8QndEMOSD4KD8TRY4JPZFYOuW2IfL4c+c9g5OTb
Ym/2Rf+jCraBY4IPeCCeUisSC4gB1wcOgw+M6edMjRh0IPIdYhv70u/aEn2t
u3K2LXTEmVKRhxyytZzt8h3x0CIePpuJHmr04uBxR8iIGvrcqKN3BP/M2Rw1
ETnyzUX3TO+sO6xvcptKYAd6J0fjPZi2OnTMXHLjudFnezljXsiPuGoip5oQ
vTzORc91bZwLPpAptkFfgt/9Uacyn+fMvSvm853k3h7XztS4YPCh3mzGdkHd
R61DLzUbeVlN9LsGYi90NxA06dniS9sCzx+I7ytLg/cRsfZayeaysvMgvtsM
18H03GdG34+LmgZMvDdsF7tlH87A9wjscVPECPxrZeiUPAqbwQ72h6zJwYbt
hvknhu1jz9RmowPP6fldF3Z1kjCsr+KeFrX0nZFbgz/ro7f2ftPhGo6YVB92
S03ZHr2gVaED9I6+3ohchXyhHLUMd3oMjJHrwLCP13jMWmopbOi4qK2qwTN4
B+6Bg/mRljt57F0hJ/QyP+ZTi1ErXFO2P2Fn9If2BuZwDvK6k3XucwrGfWIv
OIhP0QPLht2SI4Cj5AnUPc0RX/rCRrHPZV3uK1Gjz4ucF52eLvrTK/7udwqx
I+/85Piie2fQJW8Hw5AnvYExReeo+O/EeD4zMA2dUrs3dEbeK9s+u+j1+ehX
M5ecvavTWIHckBk2PCn2aw4MQ4/ohJ5BU6dx+Buy28VVYwBxD9nMD7s7Onwc
3lZETk69Sj+I/i21I/0y8PlHYW/ogxp3X9Qa5G+zop9GvkquvzR62nvCXodi
TEzkW+J38+7BEnfxH/JScslne51P0nNDF8w5uejvpuiAb67QJx+mr0DtTi8A
GvgedPhGBg16PvQshn2UbyafLno97zkfc6ivybuGe3/csQG+F4yPvj99Nfph
5AB8Z6I3RWwBc5ZEjbApvm+iU+TRGjkt/gFO4SN89yAvIRdZpLOe3ekexsWy
qVkFfz/8m8ZvV1yXf0E2eFfRuLA5+oDE2s1ad3HBuRZ9A+QBVtRrXaHg70Wb
Qs/kOdR+9EbIJ96K3Ave3qlE363RfQTi2KEadoR1z5w1ej+j030XMCwd35TX
Sifrez0G7/Fh/Lcj5HZHfIeCLjR51hffMvDtg9G/vUH8XqM99sfvA5nD3z76
Qv7w9XLEFOLVE9HPmRe9f/BgStTCxH3qU/IeZILsd0acGKV9vtFrXNkfuRHz
yW0vyRuD5vT6Gx583CLe5vaaV+LbnIhxYCuxivhCfT+zyznZRdTanY6H9E2p
X6hjPi46RxT9HYG++OnRG6fe4D22cVnFvV1sjR7A70q2S3D6pPDzYV8ixtEb
aY4eFN+i+ZZ/6Ht02jkZMuT7KHqkR4rO50fOfXnFZ+Nc/RXnheSELwp/DuYd
H+g/Df1fHj4l8Hmo4G+Q+BH99Z3Ra6ZPNjn6V9TX4O8HUV+DWeAV/5uAv4Ev
1D+sp1dNbbQ1+tW3ifbpXe7fDER8xi7w18vCRw/V+BEfu8X/SQV/S+c70plF
53jTGq0DetjEwwkRE7/e6e+10F0S58IGPql9zyw7VuDfYDmxe1L05dhrT9Rz
jLMF517Y/pSghXyohamxW6OPwdkvjVhHnoXd4rt/z9t/WbcycgzsG3rQwR/w
e/KC/wHVrH5D
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnls1FUQx19td7dbuj11z3Z3S9CIKYcgLUU5EkQomCjlEquiFGIQASMR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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9411759999999999, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlktMnVUUhTdcQOAC9yGPey+gl0aTDtQKjQ5AgURbCnagrYqxAxPj0Kpx
5KCmOmhiaRMJI6sOHFAfsR0bE4sMrEbjKxqtpSOjNTE1KdXIUFxf1m46OPnP
f/599mOtdfb5x55+/sBzrRHxpUZBY7MccVXjSFtEe2fEakfEny0RJ/XeMhgx
pvmxgud1PR+XzTM3RTQ1b2vz/LT87Nf6Vo/stf7LSMTFEb8fH47YHvT63mbE
Po0NxTtUj2gM2d/MWMRHsvtH/p7S9xdrEX/LpqB9rYOOv092ezUaBa8xJ7fd
pYgJjZ2aVwciKhovKe5pxX9X42HVUx6wL/ysjyqG5m8o5yW9f9Lhug4WI17t
8ntLxsU/z0LGO6p8/1Cu//Y4Fk/yAbMNjS3N798R8Z5iXOp1bS8XjdHdquuB
WyPOKNd5ra8UjMkV2W30Otb7VX8f1zja52+s31uzX3yyr9zpvdfK5gy+HtLz
m6J94wdMqJ3Y8ARf0Yh4W7h/LptJ5XOfxnfy8YT2rXdH/CD7R/W9Z8j+usXJ
nXqvdBoDcASHxaLx+j6xQiv1xPJIzhea5huu7+o1VvAy0x8x3e+aZ/v9Tl0L
neYSHuEFH/9p3qVcfhLmc/r+Sp91AOa/dtnPdsGYUTP1kt9camNNe//S3t/a
jRvY7Eys5hNDbMEae3Ddn+u92nthzO9rwuZQ0TpfK3oN27Mlcwy21DCTdcH/
4Vu8Nq69H/YZ84nME36ns3by5zmb8x+FZ5dwL7caX3AG189K9oMNMdgP7kXl
ebBu/MAYjBpZ60LWe1x1LGk8qdiT4vDEgM8CfMP7lXbH4Ttn4HzWTL3ltC9p
vCYfpYZtJlKn+F8ueA4Oc03XQP5Ler7QcIyPhck9NWv6Wa0dbjgGuKzqea3N
Wvy2bL6m5Kdj2Of0dfk9J38ljVOq9c26c5xWPrMaUbUe8IFm0Dzfyf+AbH8e
s26w2664Xs7BW3kW0OjFsvsPdl8XrSPiYkvsU8J794Dz4Uy07fC54Hyfz544
nvWQB9yQE/mwH/2BFfhPDfjMsg521HW9p3BGiD+X/Q4NwD9ngnf4gF/O+kLq
GOyX0z9clZNf+vpkzlezPxG3oNxvq7t3UMcdecbBnvjYlbKXNrJHfVC27uAI
HLDFZjJrYR/27CWXZtZ1s3ivjroH0EtbBm9oD2zBGOzhAM3AVfeQeUA3rVXb
bYy4N3F2sV9JTXD2z6b22mvu+/SBqcwNDLhLNvOOo0+jr63U7Jnci64vD1vb
XymHq4PGbI9ymW9aG9SMDqgVTrDFJzlG5sk9xh7swQsd0FvQHTasn8jcwI9a
+MZ6Oe8FcCBf+jvY4hcb6qUvnkydU+Nm2lDnseyb5MQ789vr5huuuQ93NY3P
78pz15Bt0S1apbdc5x6fcH4p76dPZbtYM3Z7asYIfNACmuBcrCSX5E/fZQ/2
l2X/juI+WHHf4EkO9DNiE7eSeGwVbvxboB/yGs/+AAb4P5f4TCW/y6kF9I+O
6dFgic9qaphe8sWo8yQnuCQWa+u5zj3zSN1nr5I9nlrKmRt+uBMeq/sOoAeT
H3zwX3BhxOd4Uff8dt09G3zQDPH+B4sDQq4=
         "],
         VertexColors->None], 
        PolygonBox[{{7036, 5901, 2124, 3006}, {7141, 7140, 1148, 2433}, {6557,
          8510, 4608, 4610}, {8217, 6198, 3547, 4265}, {6444, 7036, 3006, 
         2065}, {8239, 8240, 4012, 1616}, {6483, 7906, 3891, 2122}, {6555, 
         5728, 2724, 2246}, {8252, 8251, 152, 4303}, {6921, 6922, 2065, 
         528}, {6258, 8286, 4336, 4338}, {8743, 5915, 1023, 5184}, {7790, 
         6656, 2246, 3755}, {5935, 8287, 4338, 1148}, {7385, 7049, 801, 
         3318}, {6768, 6557, 4610, 2752}, {6436, 6213, 1700, 2053}, {8512, 
         8511, 1267, 4608}, {7054, 5897, 2119, 3020}, {7789, 8743, 5184, 
         3547}, {6554, 6764, 2750, 2245}, {5887, 7386, 2123, 801}, {6481, 
         6215, 3711, 2119}, {6765, 6261, 2907, 2750}, {5900, 7055, 3021, 
         2123}, {7442, 6015, 3317, 3374}, {7055, 5899, 2122, 3021}, {8265, 
         8266, 4314, 1267}, {6919, 8585, 4698, 2899}, {6231, 8250, 4303, 
         1507}, {7243, 7443, 3374, 3192}, {5898, 7054, 3020, 2120}, {6215, 
         7609, 3563, 3711}, {6197, 8217, 4265, 3563}, {6963, 6553, 2245, 
         2941}, {5727, 8752, 5273, 152}, {8752, 7243, 3192, 5273}, {8286, 
         6257, 4337, 4336}, {8004, 6491, 2134, 4013}, {6924, 5770, 2752, 
         2904}, {7754, 6482, 2120, 3712}, {7383, 7754, 3712, 3317}, {5915, 
         8023, 4036, 1023}, {6485, 7384, 3318, 2124}, {8352, 6149, 1616, 
         4420}, {8264, 8263, 528, 4314}, {8003, 8004, 4013, 4012}, {7906, 
         7905, 3890, 3891}, {5871, 6240, 1754, 1700}, {6240, 6078, 1507, 
         1754}, {5914, 6963, 2941, 2134}, {8586, 8584, 2433, 4698}, {7905, 
         6373, 4420, 3890}, {6655, 7790, 3755, 4036}, {6923, 6919, 2899, 
         2903}, {6257, 6437, 2053, 4337}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5728, 6555, 6556, 6656, 7790, 6655, 8023, 5915, 8743, 7789, 
         7591, 8765, 6198, 8217, 6197, 7609, 6215, 6481, 8661, 5897, 7054, 
         5898, 8662, 6482, 7754, 7383, 8678, 6015, 7442, 7443, 7243, 8752, 
         5727, 7616, 7623, 6918, 8251, 8252, 8250, 6231, 6079, 8684, 6078, 
         6240, 5871, 8650, 6213, 6436, 8707, 6437, 6257, 8286, 6258, 8287, 
         5935, 7140, 7141, 6671, 8584, 8586, 8585, 6919, 6923}],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6261, 6765, 6764, 6554, 6553, 6963, 5914, 6491, 8004, 8003, 
         8240, 8239, 7334, 7333, 6149, 8352, 6373, 7905, 7906, 6483, 5899, 
         7055, 5900, 6484, 7386, 5887, 7049, 7385, 7384, 6485, 8663, 5901, 
         7036, 6444, 8708, 6445, 6922, 6921, 5843, 8263, 8264, 8262, 8266, 
         8265, 5957, 7095, 8511, 8512, 8510, 6557, 6768, 5770, 6924}],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5834, 7963, 8192, 8191, 6106, 7512, 6107, 7513, 7949, 7950, 
         6957, 6958, 6547, 7856, 7857, 5718, 5763, 8184, 7546, 7547, 7508, 
         7510, 7509, 5829, 7326, 7327, 7263, 7587, 8734, 5764, 7588, 7634, 
         6256, 6808, 5970, 7156, 5971, 6704, 7398, 7003, 6371, 8350, 8351, 
         7903, 7904, 5787, 8478, 5788, 6776, 6724, 7065, 7064, 6372, 8452, 
         6458, 8451, 6457, 8557, 8558, 7780, 6627, 7781, 7127, 8080, 8079, 
         8078, 6706, 8675, 8603, 8108, 6017, 8107, 6016, 8293, 6266, 8064, 
         8063, 8062, 6265, 8292, 6081, 7595, 6201, 7594, 7635, 8288, 6259, 
         8047, 5939, 8220, 6200, 8218, 6199, 8219, 6902, 5731, 6745, 6150, 
         7335, 7337, 7338, 7593, 7592, 5839, 7744, 6446, 7743, 6447, 6970, 
         6969, 7096, 6558}],
        "17.5`"],
       Annotation[#, 17.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6903, 5773, 5735, 7867, 7866, 6559, 6975, 6974, 5859, 8201, 
         6168, 8200, 6167, 8337, 8338, 8336, 6348, 8143, 6110, 7908, 7909, 
         5795, 8199, 5794, 8554, 8555, 8553, 6617, 7122, 7121, 5848, 7499, 
         7500, 7496, 7498, 7497, 7565, 5793, 8631, 6375, 5903, 7120, 6615, 
         8721, 6616, 6226, 6492, 8670, 5919, 7059, 5920, 8247, 8248, 8244, 
         8246, 8245, 5734, 5772, 6572, 6571, 7815, 6730, 7813, 6729, 7814, 
         6166, 7179, 7180, 6784, 5846, 6920, 5847, 8480, 8481, 8479, 6501, 
         6674, 8725, 6673, 6799, 6798, 8587, 6672, 8072, 8073, 5973, 8602, 
         7777, 7652, 7653, 7402, 5972, 6161, 8689, 6160, 6243, 6158, 8688, 
         6159, 5981, 6021, 8622, 5730, 6500, 8427, 8428, 8426, 8430, 8429, 
         6440, 8433, 6442, 8431, 6441, 8432, 6867, 8492, 6521, 8491, 6522, 
         6962, 6961, 8509, 6552, 7759, 7761, 7760, 6334, 7181, 7713, 7712, 
         7711, 6731, 7817, 6333, 7710, 8755, 7240, 8754, 7241, 5767, 6960}],
        "17.5`"],
       Annotation[#, 17.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5691, 6538, 6284, 6488, 8712, 8713, 5877, 6487, 5878, 6475, 
         6476, 7053, 7052, 5892, 7164, 7165, 6791, 6790, 5880, 7618, 5879, 
         7382, 7381, 7611, 7610, 6739, 8255, 6232, 8013, 8014, 8290, 8291, 
         8052, 8053, 7625, 6233, 7624, 8257, 8256, 5799, 6926, 5798}],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5719, 7545, 6140, 7511, 6141, 7550, 7551, 7549, 6143, 6862, 
         6073, 7548, 6142, 7325, 7948, 5828, 6898, 7700, 7506, 7507, 7274, 
         7901, 7902, 6821, 7277, 7276, 7275, 6105, 7702, 8619, 7703, 7701, 
         7858, 7553, 6144, 7552, 6145, 7554, 8046, 7397, 7633, 7632, 7741, 
         7029, 5969, 8071, 7401, 6703, 7799, 6520, 7081, 6624, 6626, 6625, 
         7126, 6423, 6718, 6424, 7589, 6192, 7366, 7636, 7637, 6262, 7638, 
         6511, 8716, 6512, 6490, 8669, 5912, 7030, 6498, 8714, 6499, 5936, 
         6214, 8651, 5872, 7377, 7378, 7328, 7329, 5836, 7619, 5835, 8550, 
         6608, 8549, 6609, 5938, 6705, 5937, 8680, 8681, 8679, 6018, 6241, 
         5841, 8644, 6153, 6082, 7447, 6019, 7444, 7446, 7445, 7557, 5732, 
         8193, 6151, 7556, 6152, 7597, 7598, 8222, 8221, 6202, 8750, 7964, 
         5840, 8643, 7596, 7449, 6023, 8109, 6022, 7723, 6359, 7336, 6358, 
         6966, 6335, 6971, 6972, 6965, 6964, 6869, 6980}],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5724, 7859, 7488, 6077, 7262, 6076, 7705, 6331, 7816, 6330, 
         6763, 6762, 7709, 6332, 7706, 7708, 7707, 7742, 5726, 6744, 6529, 
         8086, 8087, 8088, 7087, 5980, 7440, 7441, 7439, 7892, 7891, 5768, 
         5725, 8730, 7266, 7242, 7340, 7339, 5842, 7601, 7602, 7600, 7599, 
         7341, 6155, 6157, 8687, 6156, 6883, 6884, 6342, 8333, 6341, 6973, 
         5974, 8074, 7403, 8685, 6086, 7493, 7269, 8335, 6344, 8334, 6343, 
         6523, 8674, 5977, 6533, 8717, 6534, 6109, 8630, 5792, 6279, 8229, 
         8206, 8207, 8205, 6176, 8309, 6281, 8308, 6280, 6614, 6613, 7037, 
         6451, 7131, 6639, 6640, 8659, 5891, 7050, 7006, 8569, 8570, 8568, 
         6643, 7124, 7123, 8556, 6619, 8468, 6474, 8011, 8012, 7051, 6471, 
         6473, 8710, 6472, 6486}],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6032, 7502, 6097, 7501, 6096, 7459, 6033, 7456, 7458, 7457, 
         7571, 5743, 8446, 8447, 8445, 6454, 8448, 6453, 7039, 7979, 7355, 
         7751, 7750, 7763, 6981, 7995, 7994, 7373, 6628, 7046, 7045, 7188, 
         6736, 7192, 6738, 7193, 7194, 7191, 7190, 7187, 6378, 7820, 7821, 
         7819, 6735, 7174, 7173, 6452, 7038, 7270, 7769, 6515, 7074, 7399, 
         7400, 7147, 7148, 6689, 8727, 6688}],
        "15"],
       Annotation[#, 15, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5693, 6836, 5692, 8495, 6526, 7757, 6527, 8501, 8502, 8499, 
         6535, 8500, 5978, 8081, 6711, 8607, 6528, 8083, 8084, 8085, 7083, 
         5979, 8082, 7720, 6350, 7719, 6349, 6929, 6285, 7185, 7186, 6928, 
         6927, 6841, 5700, 8347, 6362, 7724, 6363, 8362, 8363, 8360, 6382, 
         8361, 5781, 8370, 6387, 8369, 6388, 7013, 7012, 7913, 7912, 7911, 
         8546, 8545, 7770, 8111, 6041, 8113, 8112, 7360, 7361, 5852, 8276, 
         8277, 7982, 7981, 7980, 6184, 6888, 6887, 7210, 7209, 7673, 7208, 
         7388, 7387, 5904, 6997, 6366, 8348, 6367, 8349, 6119, 6886, 5784, 
         8628, 6575, 6393, 7290, 7771, 8634, 5807, 7772, 5806, 8460, 8461, 
         8459, 8463, 8462, 6125, 8157, 8158, 7898, 7897, 5783, 7521, 7522, 
         7520, 6118, 8233, 6219, 8231, 6218, 8232, 5802, 7641, 7642, 7284, 
         7283, 7282, 6117, 7608, 6211, 8228, 6210, 6657, 5926, 7136, 5927, 
         6658, 8575, 5925, 8028, 8029, 7825, 7826, 5699, 8230, 8598, 8599, 
         8597, 6690, 8596, 6691, 7150, 7149, 5959, 8299, 8300, 8296, 8298, 
         8297, 5779, 8608, 6712, 5982, 7088, 5983, 6530, 8496, 8295, 6268, 
         8294, 6267}],
        "12.5`"],
       Annotation[#, 12.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5742, 6773, 6772, 8595, 6687, 8067, 8068, 8069, 7073, 5958, 
         8070, 7518, 6112, 8146, 6111, 8144, 8145, 8075, 8307, 8076, 8077, 
         6277, 8699, 6278, 5986, 7091, 5985, 6715, 6283, 7658, 7656, 7657, 
         7655, 7654, 7345, 6165, 8332, 6340, 7864, 7865, 6570, 8718, 6569, 
         7098, 7099, 6633, 7782, 6632, 7783, 5845, 6224, 8241, 8243, 8242, 
         6029, 7861, 7862, 7863, 8254, 8253, 7603, 7515, 7516, 7514, 6108, 
         7517, 7966, 7965, 6154, 8194, 8525, 8524, 7100, 7101, 6637, 7787, 
         6636, 7788, 5865, 7615, 5866, 7375, 7374, 8227, 8226, 6080, 8126, 
         8128, 8127, 5837, 7035, 5838, 8642, 6439, 7279, 8677, 7278, 8104, 
         8105, 8106, 7434, 7435, 7265, 8620, 5723, 5766, 6959, 8735, 8760, 
         6864, 8758, 6865, 7086, 7085, 6761, 7704, 6329, 7238, 7239, 6866, 
         6075, 7697, 6327, 7237, 7853, 5715, 5762, 7694, 7486, 7487, 7261, 
         7698, 8705, 7699, 8753, 6328}],
        "12.5`"],
       Annotation[#, 12.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5744, 7874, 8691, 6179, 8209, 6180, 6831, 6830, 5851, 7356, 
         6832, 6035, 7040, 6034, 7504, 6099, 7503, 6098, 6835, 6036, 7158, 
         7159, 6834, 6833}],
        "12.5`"],
       Annotation[#, 12.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6347, 6870, 6087, 6967, 6968, 6873, 6871, 5736, 7745, 7452, 
         7453, 7448, 6026, 7454, 6083, 7489, 6084, 7490, 6024, 8110, 6025, 
         7451, 7967, 5844, 6826, 7344, 7343, 7342, 6162, 8331, 6336, 7860, 
         5733, 8196, 6163, 8195, 8198, 8197, 6020, 7244, 7267, 8621, 5729, 
         5769, 6443, 8434, 8435, 8423, 8425, 8424, 6357, 7047, 6460, 7172, 
         6766, 6767, 6461, 6462, 6438, 7330, 7331, 7332, 6994, 7069, 7070, 
         6513, 7168, 7169, 6803, 5955, 7071, 6827, 8605, 6707, 8604, 6708, 
         7117, 7116, 7776, 6610, 7590, 6196, 7368, 7369, 6242, 5913, 6684, 
         8065, 8066, 5956, 7094, 8507, 6550, 8506, 6551, 8508, 6567, 7768, 
         6566, 7604, 7605, 7606, 7810, 7809, 6208, 8751, 7808, 7622, 6230, 
         7621, 6229, 8249, 5864, 7620, 6228, 7437, 6013, 7436, 6014, 7438, 
         7639, 7640, 6263, 8697, 6264, 6223, 8237, 6222, 8238, 5831, 8235, 
         8236, 7953, 7952, 7951, 6148, 6901, 6900, 6825, 5765, 7890, 7264, 
         8125, 6074, 8683, 7367, 7992, 7555, 6147, 8185, 6146, 6193, 8647, 
         5858, 6238, 8696, 6239, 6195, 8216, 6194, 5830, 8737, 7432, 8736, 
         7433, 7431, 7543, 7542, 7586, 7887, 7888, 7585, 8749, 7584, 7260, 
         6062, 8284, 8285, 8282, 6255, 8283, 5827, 7947, 7946, 7991, 7990, 
         5857, 8120, 8121, 8117, 8119, 8118, 8281, 5826, 7322, 7321, 7541, 
         8181, 8180, 7365, 7989, 7364, 8215, 8214, 7583, 7259, 6061, 7477, 
         6007, 7421, 7428, 7427, 7505, 5717, 7854, 7855, 8183, 8182, 6139, 
         6819, 6818, 7324, 7323, 6824, 6012, 6899, 6743}],
        "12.5`"],
       Annotation[#, 12.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5695, 6838, 5694, 7195, 6837, 6038, 6932, 6037, 7660, 7661, 
         8311, 8310, 6286, 8702, 7875, 7876, 7247, 6351, 7721, 6288, 7084, 
         6287, 6931, 6843, 5701, 7200, 6842, 6043, 6930, 6042, 7669, 7670, 
         7668, 7878, 7877, 7880, 7879, 7249, 7248, 7199, 6295, 6846, 8731, 
         6845, 7213, 7212, 7211, 7675, 7674, 7722, 6812, 6813, 6121, 8152, 
         6120, 8747, 7523, 8160, 8159, 5751, 7834, 7833, 7832, 6542, 8504, 
         6301, 6942, 7984, 7983, 6455, 8449, 7753, 7291, 7525, 7524, 7677, 
         6949, 5810, 7926, 7295, 6598, 7773, 6401, 7018, 6732, 7189, 6733, 
         8729, 6737, 6999, 6368, 8612, 6734, 7818, 8614, 8613, 6723, 8609, 
         6722, 7017, 5754, 7251, 6741, 6740, 7170, 6352, 6948, 6947, 5809, 
         8466, 6467, 8465, 6468, 8467, 6127, 8161, 8162, 7613, 7612, 8234, 
         7529, 5753, 8764, 8763, 7528, 8738, 7527, 8762, 8739, 7530, 5867, 
         7996, 6641, 8567, 6642, 7133, 7132, 5893, 6479, 8711, 6478, 6998, 
         5884, 8654, 6466, 5951, 7142, 7143, 6679, 8590, 6678, 8591, 6983, 
         6982, 5950, 8057, 8056, 6507, 7391, 5923, 6941, 6299, 8321, 6300, 
         6879, 6878, 6593, 8720, 6594, 6592, 8544, 6595, 8541, 8543, 8542, 
         6840, 7793, 7794, 7792, 7796, 7795, 6539, 6540, 8615, 5698, 6877, 
         8358, 8359, 8357, 6380, 8356, 6381, 7008, 7007, 5797, 7406, 7407, 
         7405, 8090, 8089}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5716, 7484, 7886, 7485, 7258, 6072, 7483, 7852, 7236, 7696, 
         7695, 6760, 6956, 6071, 6861, 6955, 6954, 5761, 6759, 6326, 7692, 
         6325, 7693, 6863, 5722, 8421, 6434, 8420, 6435, 8422, 6432, 7034, 
         7962, 7961, 6433, 8419, 6549, 8418, 6431, 7959, 7960, 5833, 7033, 
         5832, 7958, 7957, 6430, 8417, 6548, 8416, 6429, 7954, 7955, 7956, 
         7031, 7032, 6428, 8414, 6427, 8415, 5721, 8411, 6426, 8410, 8413, 
         8412, 6425, 8408, 8409, 8405, 8407, 8406, 5720, 8187, 8188, 8186, 
         8190, 8189, 6011, 8103, 6010, 8746, 7540, 8179, 8178, 6822, 5760, 
         8625, 7889, 6565, 8521, 6356, 6993, 7945, 7944, 6420, 8402, 6008, 
         7429, 6009, 7430, 7755, 8477, 6497, 8040, 8041, 8042, 6669, 6797, 
         6796, 7176, 6519, 6699, 6698, 8175, 6136, 8174, 8177, 8176, 6054, 
         7471, 6053, 7472, 6254, 7273, 7272, 7271, 6104, 8172, 8173, 8171, 
         6135, 8170, 8169, 7884, 8116, 8115, 6001, 7068, 6000, 6817, 6897, 
         6896, 7231, 7230, 7229, 7691, 7690, 6138, 7318, 7319, 7320, 7651, 
         7650, 5825, 8641, 7422, 8640, 7423, 8099, 8098, 6005, 7476, 6060, 
         7315, 6059, 7426, 6006, 7228, 7425, 7424, 7544, 6823}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5738, 6874, 7730, 6875, 6979, 6978, 6771, 6977, 6345, 6872, 
         7245, 7746, 7747, 7346, 7968, 7969, 6828, 6829, 6170, 8202, 6169, 
         8748, 7868, 7869, 5739, 7562, 7563, 7455, 6027, 7450, 6028, 8129, 
         8130, 7893, 8453, 5771, 8454, 8455, 8437, 6448, 8436, 6449, 8438, 
         6360, 8522, 6568, 7894, 8626, 8627, 7714, 7491, 7492, 7268, 7715, 
         7716, 6337, 6868, 6085, 7160, 6769, 6770, 6338, 7717, 6339, 7718, 
         7907, 5789, 7004, 5790, 7281, 7280, 7729, 7728, 7762, 8551, 6611, 
         7778, 6612, 8552, 6374, 8353, 8355, 8354, 5791, 7559, 7560, 7558, 
         6164, 7561, 5873, 8652, 6216, 5916, 6469, 8658, 5889, 7005, 6502, 
         8715, 6503, 5941, 6504, 6244, 8267, 6245, 8268, 6205, 7371, 7372, 
         5861, 7617, 5860, 8457, 8458, 8456, 6459, 8606, 6710, 7800, 6709, 
         7801, 7118, 7119, 7072, 6514, 7184, 6804, 6805, 6685, 7791, 6686, 
         8594, 6574, 8523, 6573, 5777, 6749, 6748}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5862, 8648, 6629, 6493, 8026, 8027, 5922, 7060, 5921, 7389, 
         7390, 7357, 7752, 7358, 7359, 7041, 7042, 6621, 7779, 6620}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5696, 7196, 6839, 6040, 6933, 6039, 7664, 7665, 7662, 6289, 
         8312, 5746, 6750, 6291, 7659, 6290, 7666, 6389, 7733, 5702, 7204, 
         7203, 7672, 7671, 6753, 6939, 6044, 6844, 6936, 6935, 5748, 7828, 
         7827, 7202, 6296, 7738, 6395, 7737, 6394, 7216, 7215, 7198, 6302, 
         7676, 6754, 7021, 7022, 6847, 8756, 8757, 8733, 8732, 6943, 5752, 
         5705, 8617, 7250, 7214, 7297, 7296, 7299, 7298, 6814, 5993, 7019, 
         5992, 7467, 6049, 7466, 6048, 6816, 5995, 7157, 5994, 6815, 6892, 
         6891, 7220, 7219, 7218, 6544, 7758, 6518, 7079, 7080, 6716, 7078, 
         7077, 6848, 7532, 7533, 7304, 7303, 7302, 6129, 8211, 8212, 8210, 
         6185, 5756, 5707, 7843, 7842, 8325, 8324, 6308, 7726, 7727, 7725, 
         7900, 7899, 5786, 8475, 8476, 6775, 6774, 7175, 6496, 6665, 8724, 
         6664, 6668, 6667, 7139, 6666, 7807, 6720, 7805, 6719, 7806, 7125, 
         7043, 7044, 6721, 6801, 5944, 8482, 8483, 7756, 6415, 8398, 6416, 
         6908, 6907, 5818, 7938, 7581, 6190, 7580, 6191, 7582, 5934, 8045, 
         6318, 8328, 7846, 7847, 5710, 6894, 5713, 7537, 7538, 7536, 6137, 
         7539, 5856, 8404, 6422, 8403, 6421, 7233, 7232, 6855, 6063, 7144, 
         8124, 8123, 8122, 6726, 8610, 7234, 6856, 6064, 6990, 6065, 6857, 
         7235, 6858, 6066, 6992, 6067, 6859, 7850, 7478, 6068, 7254, 6069, 
         7479, 7851, 7480, 6070, 7256, 7482, 7885, 7481, 5714, 6860, 7688, 
         6322, 7687, 6323, 6758, 5759, 7685, 7686, 7475, 6058, 7257, 7689, 
         8330, 6324, 7227, 7848}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5849, 7978, 8444, 8443, 6376, 7731, 6377, 7732, 6346, 7784, 
         7785, 7246, 5737, 5774, 6976, 8439, 8440, 7748, 6450, 7749, 7971, 
         7970, 8442, 8441, 6088, 7494, 6089, 7495, 7993, 7370, 8690, 6171, 
         7564, 7347, 7348, 6203, 8132, 6090, 8131, 6091, 8133, 6030, 8203, 
         6172, 7972, 7973, 7974, 6204, 8135, 6092, 8134, 6093, 8136, 6031, 
         8204, 6173, 7975, 7976, 7977, 6174, 8138, 6094, 8137, 6095, 8139, 
         5975, 6809, 5976, 7161, 6777, 6778, 6175, 6792, 5917, 7166, 5918, 
         6793, 7349, 7804, 5940, 6800, 5888, 8657, 6225, 5902, 7056, 7057, 
         6725, 6789, 5890, 8565, 8566, 8010, 8009, 8008, 6470, 6618, 8645, 
         5850, 7354, 6282, 8701, 7353, 8700, 7352, 7351, 6178, 6361, 5776, 
         6747, 6746}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5948, 8054, 8055, 8015, 8469, 8016, 8017, 6995, 6996, 6364, 
         7895, 7896, 5782, 6889, 6909, 8489, 6516, 8488, 6517, 7076, 7075, 
         5960, 8302, 6270, 8301, 6269, 6811, 5988, 6217, 8653, 5881, 6477, 
         6365, 6116, 8632, 5800, 6635, 8001, 8002, 5883, 7130, 5882, 8000, 
         7999, 8563, 8562, 7786, 8091, 8094, 8093, 8092, 7392, 7393, 5928, 
         8490, 8365, 8366, 8364, 6383, 8367, 6183, 8759, 6904, 7910, 8368, 
         6384, 8030, 5929, 8259, 6235, 8258, 6234, 6675, 8672, 5949, 7066, 
         7067, 6677, 8588, 6676, 8589, 5906, 7134, 8020, 8019, 8018, 6646, 
         6786, 5863, 8464, 8314, 8315, 8313, 8317, 8316, 6752, 6591, 8633, 
         5801, 7010, 7011, 6386, 8706, 6385, 5780, 6581, 8719, 6582, 6536, 
         8503, 6537, 7822, 7823, 7824, 5745, 6580, 8528, 8530, 8529, 6579, 
         8534, 8535, 8531, 8533, 8532, 5778, 8539, 6586, 8538, 6587, 8540, 
         6583, 8537, 6585, 8536, 6584}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6779, 7162, 5963, 6807, 7394, 7395, 7061, 7062, 6494, 8471, 
         8473, 8472, 5853, 6944, 8340, 8341, 8339, 8343, 8342, 8505, 6543, 
         7526, 6126, 7293, 7294, 7643, 7644, 7812, 7811, 6806, 6694, 5961, 
         7151, 7152, 6693, 7797, 6692, 7798, 5804, 6905, 7289, 7288, 7287, 
         6596, 7105, 7104, 5905, 6680, 8726, 6681, 6946, 6945, 6303, 6304, 
         6236, 8695, 6237, 5930, 7014, 7015, 6597, 7916, 7917, 7918, 6925, 
         5805, 6910, 6911, 6647, 8664, 5907, 7058, 5908, 8665, 6489, 6788, 
         6649, 8667, 5910, 7135, 5909, 8666, 6648, 6913, 6912, 5808, 8280, 
         6249, 8279, 6250, 6272, 8698, 6271, 8033, 8032, 8278, 8031, 8274, 
         8273, 6247, 8275, 6248, 7629, 8051, 5943, 7106, 7107, 7108, 7183, 
         7182, 6599, 7109, 7404, 8611, 6727, 8493, 8494, 6525, 7177, 6524, 
         7082, 6660, 6795, 6794, 7167, 6408, 7026, 6600, 7027, 6409, 7138, 
         6661, 6662, 8671, 5932, 7063, 7002, 8577, 8578, 8576, 6663, 8579, 
         6603, 7111, 6604, 8547, 6605, 8548, 6252, 7308, 7307, 7306, 6133, 
         7535, 6545, 8346, 6354, 8344, 6353, 8345, 6952, 7987, 7986, 7985, 
         6456, 8450, 6782, 8486, 8487, 8058, 8059, 5953, 8592, 5952, 8498, 
         6531, 8497, 6532, 7090, 7089, 5984, 7803, 6713, 7802, 6714, 7155, 
         7154, 6701, 8728, 6702, 6276, 8304, 8306, 8305, 6275, 7648, 6274, 
         7649, 6895, 5712, 6742, 6134, 7314, 7316, 7317, 7579, 7578, 5824, 
         8639, 7312, 8638, 7313, 8101, 8102, 8100, 7849}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5740, 7870, 7871, 8270, 8269, 6246, 7628, 8049, 8048, 6260, 
         8289, 8025, 8024, 8272, 8271, 7350, 7566, 8208, 7567, 7380, 7379, 
         5874, 7129, 5875, 7998, 7997, 6634, 8561, 6785, 8564, 6638, 8005, 
         8006, 8007, 7102, 6576, 8526, 6577, 8527, 6177, 7568, 7570, 7569, 
         5942, 8050, 7872, 7873, 5775, 5741}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5817, 7937, 7305, 8141, 8142, 6101, 8140, 7531, 8164, 8165, 
         7932, 7933, 7934, 6652, 8723, 6653, 6650, 8574, 6651, 8571, 8573, 
         8572, 5709, 6914, 6915, 6659, 8034, 8035, 8036, 7137, 5931, 7025, 
         8390, 6404, 8389, 6405, 6917, 6916, 5814, 8392, 6406, 8391, 6407, 
         8655, 5885, 6480, 6102, 8686, 6103, 5894, 6212, 8649, 5868, 7376, 
         8693, 6186, 7572, 7362, 7363, 5855, 7614, 5854, 8646, 6623, 6622, 
         6645, 8722, 6644, 5895, 8741, 8742, 8740, 7420, 7419, 7627, 7626, 
         7943, 5823, 8637, 6607, 7115, 7114, 5968, 8673, 6700, 8601, 8044, 
         8694, 6189, 8213, 7988, 8260, 8261, 8021, 8022, 7577, 6188, 7574, 
         7576, 7575, 6893, 6820}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6292, 6934, 5747, 6751, 6294, 7663, 6293, 7667, 6392, 7736, 
         5703, 7206, 7205, 7409, 7408, 7460, 7734, 5803, 7286, 7285, 6390, 
         6938, 6937, 5749, 7830, 7829, 8318, 6297, 8320, 8319, 8704, 8703, 
         7919, 7292, 6399, 7739, 7217, 7201, 5989, 7411, 6045, 7463, 6397, 
         8377, 6398, 8378, 6396, 8375, 8376, 8372, 8374, 8373, 6880, 5706, 
         7835, 7836, 8383, 8382, 6403, 7024, 7023, 5813, 7929, 7413, 5997, 
         8096, 5996, 8744, 7881, 7882, 8114, 6050, 8682, 7300, 7301, 5812, 
         7020, 5811, 7928, 7927, 6402, 8381, 6100, 8327, 6310, 8326, 6309, 
         6950, 6951, 6509, 8484, 6508, 8485, 6510, 8167, 6130, 8166, 6131, 
         8168, 8600, 6696, 5965, 7153, 5964, 6695, 6220, 7845, 7844, 8097, 
         5998, 8745, 8043, 5933, 7396, 6253, 7630, 7775, 7774, 8581, 6670, 
         8580, 8583, 8582, 6631, 8559, 6630, 8560, 5869, 7128, 5870, 6787, 
         6654, 8668, 5911, 7093, 6546, 6227, 8660, 5896, 6003, 8676, 6002, 
         6802, 5945, 7163, 6717, 6783, 5819, 6906, 5820, 6682, 8593, 6683, 
         7146, 7145, 5954, 8060, 8061, 7939, 7940, 5822, 6989, 8517, 8518, 
         8516, 8520, 8519, 6004, 7740, 6417, 7309, 7310, 7311, 6991, 7766, 
         6563, 7765, 6564, 7767, 6319, 7473, 6055, 7253, 7682, 7683, 6320, 
         7474, 6056, 7255, 7684, 8329, 6321, 7225, 7226, 6851, 6057, 6987, 
         6988, 6853, 6852, 5711, 6854, 7681, 6316, 7680, 6317, 6757, 5758, 
         6953, 6315}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6885, 6464, 8709, 6465, 6463, 7048, 5876, 8225, 6207, 8223, 
         6206, 8224, 6209, 7607, 6114, 8151, 6115, 7519, 5924, 8150, 6113, 
         8147, 8149, 8148, 6876, 5697, 7197, 6505, 5946, 6506, 5947, 6182, 
         8692, 6181, 5796, 6578, 6379, 7009, 6589, 6590, 6588, 7103, 7092}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7831, 7207, 5987, 7410, 7462, 7461, 8155, 6123, 8154, 6124, 
         8156, 6122, 8153, 8624, 8623, 6810, 5750, 5704, 8616, 6541, 6298, 
         6940, 7915, 7914, 6391, 8371, 7735, 7412, 8761, 5991, 8095, 5990, 
         7465, 6047, 7464, 6046, 8379, 8380, 7923, 7924, 7925, 7016, 7922, 
         7921, 7920, 6400, 6882, 6881, 7841, 7840, 7839, 6307, 8323, 6306, 
         8387, 8388, 8384, 8386, 8385, 8470, 6890, 5785, 8629, 6369, 7001, 
         7000, 5962, 7646, 7647, 7645, 6273, 8303, 5755, 7838, 7837, 8322, 
         6305, 8038, 8039, 8037, 6495, 8474, 7931, 7930, 6128, 8163, 6370, 
         6697, 5966, 7110, 6601, 6602, 6251, 6781, 6780, 7178, 6132, 7534, 
         6728, 6311, 7097, 6560, 6313, 6312, 6221, 8656, 5886, 7417, 7418, 
         7414, 7416, 7415, 7631, 5821, 8636, 6606, 7113, 7112, 5967, 6410, 
         8635, 5815, 7573, 6187, 7469, 6051, 7468, 6052, 7470, 7942, 7941, 
         8400, 8399, 6411, 8393, 6412, 8394, 6355, 7028, 6418, 7171, 6755, 
         6756, 6419, 8401, 6413, 8395, 6414, 6985, 6984, 8514, 6561, 8513, 
         6562, 8515, 5999, 8396, 8397, 7935, 7936, 5816, 6986, 7764, 7678, 
         7679, 7222, 7223, 7224, 6849, 8766, 6850, 6314, 7221, 7252, 8618, 
         5708, 5757, 7883}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Epilog->{{
     RGBColor[1, 0, 0], 
     PointBox[{{1., 1.}, {
      1.6837224987546646`, -0.13761442456480055`}, {-0.9772746814156097, 
      0.44561313292741034`}, {0.061493299549043146`, 
      0.31080011651922534`}, {-0.027639056310519314`, 
      0.34316705937294495`}, {-0.020309448441028985`, 
      0.34115712470230586`}, {-0.020912126633883057`, 
      0.3413388892327804}, {-0.020862295429729893`, 
      0.34132396955047195`}, {-0.020866414226024716`, 
      0.3413252034734049}, {-0.02086607377733785, 
      0.3413251014856732}, {-0.020866101917849378`, 
      0.34132510991572085`}}]}, {
     RGBColor[0, 1, 0], 
     PointBox[{{4., 4.}, {8.845908970030887, 1.048705548875105}, {
      9.209689842849516, 1.5740435210099788`}, {9.410367164059767, 
      1.5808033354951376`}, {9.41396332713259, 1.5809033117920657`}, {
      9.413989349945316, 1.580901714797556}, {9.413989524318383, 
      1.5809016959103723`}}]}},
  Frame->True,
  PlotRange->NCache[{{0, 10}, {0, 2 Pi}}, {{0, 10}, {0, 6.283185307179586}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->343627885]
}, Open  ]],

Cell["Compare the two fits with the data:", "ExampleText",
 CellID->560287156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"model", "[", 
        RowBox[{"{", 
         RowBox[{"w", ",", "p"}], "}"}], "]"}], " ", "/.", " ", 
       RowBox[{"{", 
        RowBox[{"fit", ",", " ", "bfit"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "Red", "}"}], ",", 
        RowBox[{"{", "Green", "}"}]}], "}"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->418446544],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->188447136]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->157481521],

Cell[TextData[{
 "Evaluation done for ",
 Cell[BoxData[
  ButtonBox["EvaluationMonitor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluationMonitor"]], "InlineFormula"],
 " is scoped like ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->217061240],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67448503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<x = \>\"", ",", "x", ",", "\"\< f[x] = \>\"", ",", 
      RowBox[{"f", "[", "x", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195443571],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.`"}]}],
  SequenceForm["x = ", 1., " f[x] = ", -1.],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->37931948],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", "2.`"}],
  SequenceForm["x = ", 2., " f[x] = ", 2.],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->675840886],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.3333333333333333`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.22222222222222232`"}]}],
  SequenceForm[
  "x = ", 1.3333333333333333`, " f[x] = ", -0.22222222222222232`],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->7836740],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.419047619047619`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   "0.013696145124716175`"}],
  SequenceForm["x = ", 1.419047619047619, " f[x] = ", 0.013696145124716175`],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->182700903],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.414071510957324`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00040176189887053404`"}]}],
  SequenceForm[
  "x = ", 1.414071510957324, " f[x] = ", -0.00040176189887053404`],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->115471615],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.4142133199955025`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "6.85547298484579`*^-7"}]}],
  SequenceForm[
  "x = ", 1.4142133199955025`, " f[x] = ", -6.85547298484579*^-7],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->454156998],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.4142135623731364`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   "1.1723955140041653`*^-13"}],
  SequenceForm[
  "x = ", 1.4142135623731364`, " f[x] = ", 1.1723955140041653`*^-13],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->102881238],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.414213562373095`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.440892098500626`*^-16"}]}],
  SequenceForm[
  "x = ", 1.414213562373095, " f[x] = ", -4.440892098500626*^-16],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->39830976]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->277143674]
}, Open  ]],

Cell[TextData[{
 "This is effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " with assignments of numerical values of the variable:"
}], "ExampleText",
 CellID->218073767],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"xx_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "=", "xx"}], "}"}], ",", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<x = \>\"", ",", "x", ",", "\"\< f[x] = \>\"", ",", 
       RowBox[{"f", "[", "x", "]"}]}], "]"}], ";", 
     RowBox[{"f", "[", "x", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->154938504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"ff", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->99411101],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.`"}]}],
  SequenceForm["x = ", 1., " f[x] = ", -1.],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->446475295],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", "2.`"}],
  SequenceForm["x = ", 2., " f[x] = ", 2.],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->318466995],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.3333333333333333`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.22222222222222232`"}]}],
  SequenceForm[
  "x = ", 1.3333333333333333`, " f[x] = ", -0.22222222222222232`],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->580228200],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.419047619047619`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   "0.013696145124716175`"}],
  SequenceForm["x = ", 1.419047619047619, " f[x] = ", 0.013696145124716175`],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->44682449],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.414071510957324`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00040176189887053404`"}]}],
  SequenceForm[
  "x = ", 1.414071510957324, " f[x] = ", -0.00040176189887053404`],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->64133983],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.4142133199955025`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "6.85547298484579`*^-7"}]}],
  SequenceForm[
  "x = ", 1.4142133199955025`, " f[x] = ", -6.85547298484579*^-7],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->569613248],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.4142135623731364`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   "1.1723955140041653`*^-13"}],
  SequenceForm[
  "x = ", 1.4142135623731364`, " f[x] = ", 1.1723955140041653`*^-13],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->69572624],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "1.414213562373095`", 
   "\[InvisibleSpace]", "\<\" f[x] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.440892098500626`*^-16"}]}],
  SequenceForm[
  "x = ", 1.414213562373095, " f[x] = ", -4.440892098500626*^-16],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->533726180]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->222339000]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5048],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StepMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StepMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26076]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10996],

Cell[TextData[ButtonBox["Monitoring and Selecting Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MonitoringAndSelectingAlgorithms"]], "Tutorials",\

 CellID->22254]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->69495930],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "MoreAbout",
 CellID->102723809],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->78267051],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->214927152],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->28026495]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EvaluationMonitor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 52.3558006}", "context" -> "System`", 
    "keywords" -> {
     "collect evaluation data", "collect evaluation points", 
      "monitoring numerical evaluation", "monitoring solution progress"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EvaluationMonitor is an option for various numerical computation and \
plotting functions that gives an expression to evaluate whenever functions \
derived from the input are evaluated numerically. ", 
    "synonyms" -> {"evaluation monitor"}, "title" -> "EvaluationMonitor", 
    "type" -> "Symbol", "uri" -> "ref/EvaluationMonitor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10006, 263, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->795295379]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 935485, 18864}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2838, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3461, 92, 4201, 83, 70, "ObjectNameGrid"],
Cell[7665, 177, 581, 15, 70, "Usage",
 CellID->21396]
}, Open  ]],
Cell[CellGroupData[{
Cell[8283, 197, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8761, 214, 413, 14, 70, "Notes",
 CellID->27248],
Cell[9177, 230, 792, 28, 70, "Notes",
 CellID->30521]
}, Closed]],
Cell[CellGroupData[{
Cell[10006, 263, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->795295379],
Cell[CellGroupData[{
Cell[10391, 277, 148, 5, 70, "ExampleSection",
 CellID->733790817],
Cell[10542, 284, 120, 3, 70, "ExampleText",
 CellID->286228222],
Cell[CellGroupData[{
Cell[10687, 291, 462, 14, 70, "Input",
 CellID->56852686],
Cell[CellGroupData[{
Cell[11174, 309, 316, 8, 70, "Print",
 CellID->66519192],
Cell[11493, 319, 307, 8, 70, "Print",
 CellID->829784082],
Cell[11803, 329, 373, 9, 70, "Print",
 CellID->371144467],
Cell[12179, 340, 375, 9, 70, "Print",
 CellID->320519877],
Cell[12557, 351, 376, 9, 70, "Print",
 CellID->88038901],
Cell[12936, 362, 377, 9, 70, "Print",
 CellID->106073257]
}, Open  ]],
Cell[13328, 374, 227, 7, 36, "Output",
 CellID->189987514]
}, Open  ]],
Cell[13570, 384, 125, 3, 70, "ExampleDelimiter",
 CellID->163734253],
Cell[13698, 389, 60, 1, 70, "ExampleText",
 CellID->47628525],
Cell[CellGroupData[{
Cell[13783, 394, 493, 16, 70, "Input",
 CellID->168840014],
Cell[14279, 412, 280, 10, 36, "Output",
 CellID->613391840]
}, Open  ]],
Cell[14574, 425, 124, 3, 70, "ExampleDelimiter",
 CellID->41125070],
Cell[14701, 430, 325, 13, 70, "ExampleText",
 CellID->255739193],
Cell[CellGroupData[{
Cell[15051, 447, 523, 17, 70, "Input",
 CellID->915255649],
Cell[15577, 466, 536, 16, 39, "Output",
 CellID->118730808]
}, Open  ]],
Cell[16128, 485, 90, 1, 70, "ExampleText",
 CellID->136227688],
Cell[CellGroupData[{
Cell[16243, 490, 165, 5, 28, "Input",
 CellID->782334851],
Cell[16411, 497, 944, 20, 131, "Output",
 Evaluatable->False,
 CellID->60973912]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17404, 523, 220, 7, 70, "ExampleSection",
 CellID->647206519],
Cell[17627, 532, 114, 3, 70, "ExampleText",
 CellID->129132036],
Cell[CellGroupData[{
Cell[17766, 539, 2176, 66, 70, "Input",
 CellID->58124783],
Cell[19945, 607, 593, 21, 36, "Output",
 CellID->351875903]
}, Open  ]],
Cell[20553, 631, 125, 3, 70, "ExampleDelimiter",
 CellID->234396285],
Cell[20681, 636, 84, 1, 70, "ExampleText",
 CellID->121400988],
Cell[CellGroupData[{
Cell[20790, 641, 867, 28, 70, "Input",
 CellID->227809068],
Cell[21660, 671, 5126, 147, 224, "Output",
 CellID->325772030]
}, Open  ]],
Cell[CellGroupData[{
Cell[26823, 823, 159, 5, 70, "Input",
 CellID->196207697],
Cell[26985, 830, 1432, 28, 70, "Output",
 Evaluatable->False,
 CellID->28007327]
}, Open  ]],
Cell[28432, 861, 125, 3, 70, "ExampleDelimiter",
 CellID->299042680],
Cell[28560, 866, 239, 8, 70, "ExampleText",
 CellID->688285949],
Cell[28802, 876, 544, 17, 70, "Input",
 CellID->704433178],
Cell[CellGroupData[{
Cell[29371, 897, 71, 2, 70, "Input",
 CellID->30137113],
Cell[29445, 901, 176, 5, 36, "Output",
 CellID->171274624]
}, Open  ]],
Cell[29636, 909, 115, 3, 70, "ExampleText",
 CellID->310858019],
Cell[CellGroupData[{
Cell[29776, 916, 158, 5, 70, "Input",
 CellID->63704193],
Cell[29937, 923, 2711, 53, 142, "Output",
 CellID->123006916]
}, Open  ]],
Cell[32663, 979, 125, 3, 70, "ExampleDelimiter",
 CellID->228896861],
Cell[32791, 984, 262, 8, 70, "ExampleText",
 CellID->114593581],
Cell[33056, 994, 1141, 34, 70, "Input",
 CellID->30324854],
Cell[34200, 1030, 134, 4, 70, "ExampleText",
 CellID->92410296],
Cell[CellGroupData[{
Cell[34359, 1038, 948, 31, 70, "Input",
 CellID->108046448],
Cell[35310, 1071, 6727, 114, 70, "Output",
 Evaluatable->False,
 CellID->138541913]
}, Open  ]],
Cell[42052, 1188, 124, 3, 70, "ExampleDelimiter",
 CellID->14500021],
Cell[42179, 1193, 85, 1, 70, "ExampleText",
 CellID->40741099],
Cell[42267, 1196, 358, 12, 70, "Input",
 CellID->51728731],
Cell[CellGroupData[{
Cell[42650, 1212, 737, 22, 70, "Input",
 CellID->173494189],
Cell[43390, 1236, 20892, 347, 70, "Output",
 Evaluatable->False,
 CellID->125783555]
}, Open  ]],
Cell[64297, 1586, 148, 4, 70, "ExampleText",
 CellID->107009356],
Cell[CellGroupData[{
Cell[64470, 1594, 777, 23, 70, "Input",
 CellID->254565539],
Cell[65250, 1619, 20891, 347, 70, "Output",
 Evaluatable->False,
 CellID->51462211]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86190, 1972, 243, 7, 70, "ExampleSection",
 CellID->347948011],
Cell[86436, 1981, 67, 1, 70, "ExampleText",
 CellID->127415106],
Cell[CellGroupData[{
Cell[86528, 1986, 559, 17, 70, "Input",
 CellID->204276892],
Cell[87090, 2005, 296, 10, 36, "Output",
 CellID->776224274]
}, Open  ]],
Cell[87401, 2018, 105, 2, 70, "ExampleText",
 CellID->209132607],
Cell[CellGroupData[{
Cell[87531, 2024, 559, 17, 70, "Input",
 CellID->36664936],
Cell[88093, 2043, 174, 5, 36, "Output",
 CellID->75822304]
}, Open  ]],
Cell[88282, 2051, 125, 3, 70, "ExampleDelimiter",
 CellID->556485090],
Cell[88410, 2056, 143, 4, 70, "ExampleText",
 CellID->658781739],
Cell[CellGroupData[{
Cell[88578, 2064, 1846, 53, 70, "Input",
 CellID->315075895],
Cell[90427, 2119, 379, 12, 39, "Output",
 CellID->241305074]
}, Open  ]],
Cell[90821, 2134, 140, 4, 70, "ExampleText",
 CellID->118489135],
Cell[CellGroupData[{
Cell[90986, 2142, 1542, 47, 70, "Input",
 CellID->351378906],
Cell[92531, 2191, 128959, 2167, 70, "Output",
 CellID->152111835]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[221539, 4364, 227, 7, 70, "ExampleSection",
 CellID->484065414],
Cell[221769, 4373, 142, 4, 70, "ExampleText",
 CellID->458685043],
Cell[CellGroupData[{
Cell[221936, 4381, 1265, 39, 70, "Input",
 CellID->372732],
Cell[223204, 4422, 182436, 4997, 70, "Output",
 CellID->292114233]
}, Open  ]],
Cell[405655, 9422, 125, 3, 70, "ExampleDelimiter",
 CellID->193603668],
Cell[405783, 9427, 136, 4, 70, "ExampleText",
 CellID->105210518],
Cell[405922, 9433, 559, 17, 70, "Input",
 CellID->141472929],
Cell[CellGroupData[{
Cell[406506, 9454, 221, 7, 70, "Input",
 CellID->914315252],
Cell[406730, 9463, 2327, 42, 70, "Output",
 Evaluatable->False,
 CellID->673608619]
}, Open  ]],
Cell[409072, 9508, 125, 3, 70, "ExampleDelimiter",
 CellID->235936811],
Cell[409200, 9513, 121, 3, 70, "ExampleText",
 CellID->594874201],
Cell[CellGroupData[{
Cell[409346, 9520, 1998, 57, 70, "Input",
 CellID->167838670],
Cell[411347, 9579, 2191, 65, 132, "Output",
 CellID->5788114]
}, Open  ]],
Cell[413553, 9647, 125, 3, 70, "ExampleDelimiter",
 CellID->688891567],
Cell[413681, 9652, 263, 9, 70, "ExampleText",
 CellID->24971481],
Cell[413947, 9663, 1119, 33, 70, "Input",
 CellID->48126008],
Cell[415069, 9698, 331, 9, 70, "Input",
 CellID->99922964],
Cell[CellGroupData[{
Cell[415425, 9711, 636, 20, 70, "Input",
 CellID->411642616],
Cell[416064, 9733, 2444, 73, 138, "Output",
 CellID->246350706]
}, Open  ]],
Cell[418523, 9809, 125, 3, 70, "ExampleDelimiter",
 CellID->232538888],
Cell[418651, 9814, 494, 18, 70, "ExampleText",
 CellID->56703436],
Cell[419148, 9834, 1986, 55, 70, "Input",
 CellID->184235911],
Cell[421137, 9891, 89, 1, 70, "ExampleText",
 CellID->275573270],
Cell[CellGroupData[{
Cell[421251, 9896, 542, 17, 70, "Input",
 CellID->261711727],
Cell[421796, 9915, 1010, 29, 71, "Output",
 CellID->258436870]
}, Open  ]],
Cell[422821, 9947, 86, 1, 70, "ExampleText",
 CellID->453749698],
Cell[CellGroupData[{
Cell[422932, 9952, 408, 14, 70, "Input",
 CellID->349793003],
Cell[423343, 9968, 1005, 29, 71, "Output",
 CellID->104918246]
}, Open  ]],
Cell[424363, 10000, 140, 4, 70, "ExampleText",
 CellID->28267790],
Cell[CellGroupData[{
Cell[424528, 10008, 928, 30, 70, "Input",
 CellID->582538748],
Cell[425459, 10040, 1636, 31, 70, "Output",
 Evaluatable->False,
 CellID->126972637]
}, Open  ]],
Cell[427110, 10074, 125, 3, 70, "ExampleDelimiter",
 CellID->509487615],
Cell[427238, 10079, 94, 1, 70, "ExampleText",
 CellID->153970289],
Cell[427335, 10082, 956, 31, 70, "Input",
 CellID->37843928],
Cell[428294, 10115, 402, 14, 70, "Input",
 CellID->67367124],
Cell[CellGroupData[{
Cell[428721, 10133, 608, 18, 70, "Input",
 CellID->236963337],
Cell[429332, 10153, 1821, 55, 105, "Output",
 CellID->574753334]
}, Open  ]],
Cell[431168, 10211, 113, 3, 70, "ExampleText",
 CellID->224781459],
Cell[CellGroupData[{
Cell[431306, 10218, 1075, 33, 70, "Input",
 CellID->374183641],
Cell[432384, 10253, 241243, 3988, 70, "Output",
 CellID->98931193]
}, Open  ]],
Cell[673642, 14244, 71, 1, 70, "ExampleText",
 CellID->426878744],
Cell[CellGroupData[{
Cell[673738, 14249, 724, 22, 70, "Input",
 CellID->379100747],
Cell[674465, 14273, 1114, 34, 71, "Output",
 CellID->517198888]
}, Open  ]],
Cell[CellGroupData[{
Cell[675616, 14312, 663, 21, 70, "Input",
 CellID->19558978],
Cell[676282, 14335, 241594, 3995, 70, "Output",
 CellID->343627885]
}, Open  ]],
Cell[917891, 18333, 78, 1, 70, "ExampleText",
 CellID->560287156],
Cell[CellGroupData[{
Cell[917994, 18338, 762, 23, 70, "Input",
 CellID->418446544],
Cell[918759, 18363, 3226, 57, 70, "Output",
 Evaluatable->False,
 CellID->188447136]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[922034, 18426, 237, 7, 70, "ExampleSection",
 CellID->157481521],
Cell[922274, 18435, 403, 14, 70, "ExampleText",
 CellID->217061240],
Cell[922680, 18451, 189, 7, 70, "Input",
 CellID->67448503],
Cell[CellGroupData[{
Cell[922894, 18462, 416, 11, 70, "Input",
 CellID->195443571],
Cell[CellGroupData[{
Cell[923335, 18477, 320, 8, 70, "Print",
 CellID->37931948],
Cell[923658, 18487, 301, 7, 70, "Print",
 CellID->675840886],
Cell[923962, 18496, 390, 9, 70, "Print",
 CellID->7836740],
Cell[924355, 18507, 372, 8, 70, "Print",
 CellID->182700903],
Cell[924730, 18517, 395, 9, 70, "Print",
 CellID->115471615],
Cell[925128, 18528, 393, 9, 70, "Print",
 CellID->454156998],
Cell[925524, 18539, 384, 9, 70, "Print",
 CellID->102881238],
Cell[925911, 18550, 393, 9, 70, "Print",
 CellID->39830976]
}, Open  ]],
Cell[926319, 18562, 226, 7, 36, "Output",
 CellID->277143674]
}, Open  ]],
Cell[926560, 18572, 256, 8, 70, "ExampleText",
 CellID->218073767],
Cell[926819, 18582, 459, 14, 70, "Input",
 CellID->154938504],
Cell[CellGroupData[{
Cell[927303, 18600, 215, 7, 70, "Input",
 CellID->99411101],
Cell[CellGroupData[{
Cell[927543, 18611, 321, 8, 70, "Print",
 CellID->446475295],
Cell[927867, 18621, 301, 7, 70, "Print",
 CellID->318466995],
Cell[928171, 18630, 392, 9, 70, "Print",
 CellID->580228200],
Cell[928566, 18641, 371, 8, 70, "Print",
 CellID->44682449],
Cell[928940, 18651, 394, 9, 70, "Print",
 CellID->64133983],
Cell[929337, 18662, 393, 9, 70, "Print",
 CellID->569613248],
Cell[929733, 18673, 383, 9, 70, "Print",
 CellID->69572624],
Cell[930119, 18684, 394, 9, 70, "Print",
 CellID->533726180]
}, Open  ]],
Cell[930528, 18696, 226, 7, 36, "Output",
 CellID->222339000]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[930815, 18710, 310, 9, 70, "SeeAlsoSection",
 CellID->5048],
Cell[931128, 18721, 1409, 53, 70, "SeeAlso",
 CellID->26076]
}, Open  ]],
Cell[CellGroupData[{
Cell[932574, 18779, 314, 9, 70, "TutorialsSection",
 CellID->10996],
Cell[932891, 18790, 180, 4, 70, "Tutorials",
 CellID->22254]
}, Open  ]],
Cell[CellGroupData[{
Cell[933108, 18799, 318, 9, 70, "MoreAboutSection",
 CellID->69495930],
Cell[933429, 18810, 155, 3, 70, "MoreAbout",
 CellID->102723809],
Cell[933587, 18815, 174, 3, 70, "MoreAbout",
 CellID->78267051],
Cell[933764, 18820, 148, 3, 70, "MoreAbout",
 CellID->214927152],
Cell[933915, 18825, 196, 4, 70, "MoreAbout",
 CellID->28026495]
}, Open  ]],
Cell[934126, 18832, 50, 0, 70, "History"],
Cell[934179, 18834, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

