(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19300,        673]
NotebookOptionsPosition[     15559,        545]
NotebookOutlinePosition[     16862,        582]
CellTagsIndexPosition[     16777,        577]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SelectedNotebook"], 
          "InputNotebook" :> 
          Documentation`HelpLookup["paclet:ref/InputNotebook"], 
          "ButtonNotebook" :> 
          Documentation`HelpLookup["paclet:ref/ButtonNotebook"], "Notebooks" :> 
          Documentation`HelpLookup["paclet:ref/Notebooks"], "SelectionMove" :> 
          Documentation`HelpLookup["paclet:ref/SelectionMove"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SelectedNotebook\"\>", 
       2->"\<\"InputNotebook\"\>", 3->"\<\"ButtonNotebook\"\>", 
       4->"\<\"Notebooks\"\>", 
       5->"\<\"SelectionMove\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Programmatic Notebook & Interface Customization\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EvaluationNotebook", "ObjectName",
 CellID->4337],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EvaluationNotebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EvaluationNotebook"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the notebook in which this function is being \
evaluated. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EvaluationNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluationNotebook"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13055]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29000279],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->30552579],

Cell[TextData[{
 "Get the current ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " notebook being evaluated:"
}], "ExampleText",
 CellID->166153898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvaluationNotebook", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914699132],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["ntx_shm", 1, 1]], 17]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       TagBox[
        TooltipBox["\<\"EvaluationNotebook.nb\"\>",
         "\"C:\\\\Code\\\\CVS_HEAD\\\\Mathematica\\\\Documentation\\\\English\
\\\\System\\\\ReferencePages\\\\Symbols\\\\EvaluationNotebook.nb\""],
        Annotation[#, 
         "C:\\Code\\CVS_HEAD\\Mathematica\\Documentation\\English\\System\\\
ReferencePages\\Symbols\\EvaluationNotebook.nb", "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["ntx_shm", 1, 1]], 17],
  Editable->False]], "Output",
 ImageSize->{271, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290563923]
}, Open  ]],

Cell["Use the object for further processing:", "ExampleText",
 CellID->71588656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{
   RowBox[{"EvaluationNotebook", "[", "]"}], ",", "WindowSize"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21973443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"WindowSize", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"720", ",", "734"}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74085495]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->57762427],

Cell["\<\
Create a palette button that writes to the input notebook and then closes the \
palette:\
\>", "ExampleText",
 CellID->21884439],

Cell[BoxData[
 RowBox[{
  RowBox[{"pal", "=", 
   RowBox[{"CreatePalette", "[", 
    RowBox[{"{", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Test\>\"", ",", 
       RowBox[{
        RowBox[{"NotebookWrite", "[", 
         RowBox[{
          RowBox[{"InputNotebook", "[", "]"}], ",", "\"\<Done\>\""}], "]"}], 
        ";", 
        RowBox[{"NotebookClose", "[", " ", 
         RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}]}], "]"}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101548993]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->585063179],

Cell["\<\
The notebook that starts an evaluation might not be the input notebook:\
\>", "ExampleText",
 CellID->765026304],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", "\"\<document\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InputNotebook", "[", "]"}], ",", 
   RowBox[{"EvaluationNotebook", "[", "]"}]}], "}"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->392519421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["ntx_shm", 1, 1]], 22]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         StyleBox["\<\"Untitled-5\"\>",
          StripOnInput->False,
          FontColor->GrayLevel[0.5]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["ntx_shm", 1, 1]], 22],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["ntx_shm", 1, 1]], 17]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         TagBox[
          TooltipBox["\<\"EvaluationNotebook.nb\"\>",
           
           "\"C:\\\\Code\\\\CVS_HEAD\\\\Mathematica\\\\Documentation\\\\\
English\\\\System\\\\ReferencePages\\\\Symbols\\\\EvaluationNotebook.nb\""],
          
          Annotation[#, 
           "C:\\Code\\CVS_HEAD\\Mathematica\\Documentation\\English\\System\\\
ReferencePages\\Symbols\\EvaluationNotebook.nb", "Tooltip"]& ]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["ntx_shm", 1, 1]], 17],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{502, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305090845]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->235435168],

Cell["\<\
Moving the selection in the evaluation notebook does not change the output \
cell location:\
\>", "ExampleText",
 CellID->61122201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{
    RowBox[{"EvaluationNotebook", "[", "]"}], ",", "Previous", ",", "Cell", 
    ",", "3"}], "]"}], ";", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81575783],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238643547]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12341],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebooks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionMove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionMove"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3074],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->4979]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->27652575],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->10190108],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->84361551]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EvaluationNotebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 59.2153512}", "context" -> "System`", 
    "keywords" -> {"command notebook", "scripting notebook"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EvaluationNotebook[] gives the notebook in which this function is being \
evaluated. ", "synonyms" -> {"evaluation notebook"}, "title" -> 
    "EvaluationNotebook", "type" -> "Symbol", "uri" -> 
    "ref/EvaluationNotebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4660, 147, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->29000279]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16635, 570}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2588, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3211, 89, 55, 1, 70, "ObjectName",
 CellID->4337],
Cell[3269, 92, 503, 16, 70, "Usage",
 CellID->9765]
}, Open  ]],
Cell[CellGroupData[{
Cell[3809, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4287, 130, 336, 12, 70, "Notes",
 CellID->13055]
}, Closed]],
Cell[CellGroupData[{
Cell[4660, 147, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29000279],
Cell[CellGroupData[{
Cell[5044, 161, 147, 5, 70, "ExampleSection",
 CellID->30552579],
Cell[5194, 168, 236, 8, 70, "ExampleText",
 CellID->166153898],
Cell[CellGroupData[{
Cell[5455, 180, 109, 3, 28, "Input",
 CellID->914699132],
Cell[5567, 185, 1390, 39, 60, "Output",
 CellID->290563923]
}, Open  ]],
Cell[6972, 227, 80, 1, 70, "ExampleText",
 CellID->71588656],
Cell[CellGroupData[{
Cell[7077, 232, 178, 6, 28, "Input",
 CellID->21973443],
Cell[7258, 240, 271, 9, 36, "Output",
 CellID->74085495]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7578, 255, 226, 7, 70, "ExampleSection",
 CellID->57762427],
Cell[7807, 264, 138, 4, 70, "ExampleText",
 CellID->21884439],
Cell[7948, 270, 522, 16, 70, "Input",
 CellID->101548993]
}, Closed]],
Cell[CellGroupData[{
Cell[8507, 291, 237, 7, 70, "ExampleSection",
 CellID->585063179],
Cell[8747, 300, 122, 3, 70, "ExampleText",
 CellID->765026304],
Cell[CellGroupData[{
Cell[8894, 307, 303, 9, 70, "Input",
 CellID->392519421],
Cell[9200, 318, 2560, 75, 70, "Output",
 CellID->305090845]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11809, 399, 230, 7, 70, "ExampleSection",
 CellID->235435168],
Cell[12042, 408, 141, 4, 70, "ExampleText",
 CellID->61122201],
Cell[CellGroupData[{
Cell[12208, 416, 232, 7, 70, "Input",
 CellID->81575783],
Cell[12443, 425, 158, 5, 36, "Output",
 CellID->238643547]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12662, 437, 311, 9, 70, "SeeAlsoSection",
 CellID->12341],
Cell[12976, 448, 1236, 44, 70, "SeeAlso",
 CellID->19824]
}, Open  ]],
Cell[CellGroupData[{
Cell[14249, 497, 313, 9, 70, "TutorialsSection",
 CellID->3074],
Cell[14565, 508, 185, 4, 70, "Tutorials",
 CellID->4979]
}, Open  ]],
Cell[CellGroupData[{
Cell[14787, 517, 318, 9, 70, "MoreAboutSection",
 CellID->27652575],
Cell[15108, 528, 168, 3, 70, "MoreAbout",
 CellID->10190108],
Cell[15279, 533, 208, 5, 70, "MoreAbout",
 CellID->84361551]
}, Open  ]],
Cell[15502, 541, 27, 0, 70, "History"],
Cell[15532, 543, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

