(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21690,        828]
NotebookOptionsPosition[     16451,        643]
NotebookOutlinePosition[     17670,        679]
CellTagsIndexPosition[     17585,        674]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Types of Numbers\"\>", 
       3->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerQ" :> Documentation`HelpLookup["paclet:ref/IntegerQ"], 
          "OddQ" :> Documentation`HelpLookup["paclet:ref/OddQ"], "TrueQ" :> 
          Documentation`HelpLookup["paclet:ref/TrueQ"], "Divisible" :> 
          Documentation`HelpLookup["paclet:ref/Divisible"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerQ\"\>", 2->"\<\"OddQ\"\>", 
       3->"\<\"TrueQ\"\>", 4->"\<\"Divisible\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EvenQ", "ObjectName",
 CellID->27028],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EvenQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EvenQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is an even integer, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9303]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EvenQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvenQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " unless ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is manifestly an even integer (i.e., has head ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", and is even). "
}], "Notes",
 CellID->14120]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->11079777],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->28254589],

Cell["Test whether 8 is even:", "ExampleText",
 CellID->488273937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvenQ", "[", "8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32595936],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->648483293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->341019475],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EvenQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvenQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " for non-numeric expressions:"
}], "ExampleText",
 CellID->135536325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvenQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124118107],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127612436]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26096],

Cell["Test whether an array consists of even integers:", "ExampleText",
 CellID->1645025371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "10"}], "}"}]}], "}"}], ",", "_", ",", "EvenQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1236938919],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1016745608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "10"}], "}"}]}], "}"}], ",", "_", ",", "EvenQ"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->916054477],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->817329596]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10701],

Cell[TextData[{
 "An integer is either odd or even. Use ",
 Cell[BoxData[
  ButtonBox["OddQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OddQ"]], "InlineFormula"],
 " to check that an integer is odd:"
}], "ExampleText",
 CellID->1821314591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvenQ", "[", "3", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->602426599],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1745937435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OddQ", "[", "3", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->753917437],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->936846359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->729171824],

Cell[TextData[{
 "Even integers are divisible by ",
 Cell[BoxData["2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1649156186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvenQ", "[", "12", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1944069920],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19456335]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{"12", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->585108001],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->582553194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1319621880],

Cell[TextData[{
 "The generating function of the even integers is ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->914591599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"x", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2000542814],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"14", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"16", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"18", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"20", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, 4, 6, 8, 10, 12, 14, 16, 18, 20}, 1, 11, 
   1],
  Editable->False]], "Output",
 ImageSize->{436, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2119097466]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28363],

Cell[TextData[{
 "Expressions that represent even integers, but do not evaluate explicitly \
will still give ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1557175484],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "=", " ", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"GoldenRatio", " ", "-", " ", 
      RowBox[{"1", "/", "GoldenRatio"}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65153599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvenQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2033001876],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50222515]
}, Open  ]],

Cell["It is necessary to use symbolic simplification first:", "ExampleText",
 CellID->128736334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1155533009],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->279768609]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6985],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OddQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OddQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrueQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4375],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->11997],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->26281],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->316560093],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->119259124],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->45032575]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EvenQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 0.0434974}", "context" -> "System`", 
    "keywords" -> {"even numbers", "numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EvenQ[expr] gives True if expr is an even integer, and False otherwise. \
", "synonyms" -> {"even q"}, "title" -> "EvenQ", "type" -> "Symbol", "uri" -> 
    "ref/EvenQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5216, 166, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->11079777]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17443, 667}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2559, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3182, 86, 43, 1, 70, "ObjectName",
 CellID->27028],
Cell[3228, 89, 836, 28, 70, "Usage",
 CellID->9303]
}, Open  ]],
Cell[CellGroupData[{
Cell[4101, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4579, 139, 600, 22, 70, "Notes",
 CellID->14120]
}, Closed]],
Cell[CellGroupData[{
Cell[5216, 166, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->11079777],
Cell[CellGroupData[{
Cell[5600, 180, 147, 5, 70, "ExampleSection",
 CellID->28254589],
Cell[5750, 187, 66, 1, 70, "ExampleText",
 CellID->488273937],
Cell[CellGroupData[{
Cell[5841, 192, 100, 3, 28, "Input",
 CellID->32595936],
Cell[5944, 197, 161, 5, 36, "Output",
 CellID->648483293]
}, Open  ]],
Cell[6120, 205, 125, 3, 70, "ExampleDelimiter",
 CellID->341019475],
Cell[6248, 210, 325, 12, 70, "ExampleText",
 CellID->135536325],
Cell[CellGroupData[{
Cell[6598, 226, 101, 3, 70, "Input",
 CellID->124118107],
Cell[6702, 231, 162, 5, 36, "Output",
 CellID->127612436]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6913, 242, 223, 7, 70, "ExampleSection",
 CellID->26096],
Cell[7139, 251, 92, 1, 70, "ExampleText",
 CellID->1645025371],
Cell[CellGroupData[{
Cell[7256, 256, 299, 11, 70, "Input",
 CellID->1236938919],
Cell[7558, 269, 162, 5, 36, "Output",
 CellID->1016745608]
}, Open  ]],
Cell[CellGroupData[{
Cell[7757, 279, 298, 11, 70, "Input",
 CellID->916054477],
Cell[8058, 292, 162, 5, 36, "Output",
 CellID->817329596]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8269, 303, 233, 7, 70, "ExampleSection",
 CellID->10701],
Cell[8505, 312, 246, 8, 70, "ExampleText",
 CellID->1821314591],
Cell[CellGroupData[{
Cell[8776, 324, 101, 3, 70, "Input",
 CellID->602426599],
Cell[8880, 329, 163, 5, 36, "Output",
 CellID->1745937435]
}, Open  ]],
Cell[CellGroupData[{
Cell[9080, 339, 100, 3, 70, "Input",
 CellID->753917437],
Cell[9183, 344, 161, 5, 36, "Output",
 CellID->936846359]
}, Open  ]],
Cell[9359, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->729171824],
Cell[9487, 357, 134, 5, 70, "ExampleText",
 CellID->1649156186],
Cell[CellGroupData[{
Cell[9646, 366, 103, 3, 70, "Input",
 CellID->1944069920],
Cell[9752, 371, 160, 5, 36, "Output",
 CellID->19456335]
}, Open  ]],
Cell[CellGroupData[{
Cell[9949, 381, 129, 4, 70, "Input",
 CellID->585108001],
Cell[10081, 387, 161, 5, 36, "Output",
 CellID->582553194]
}, Open  ]],
Cell[10257, 395, 126, 3, 70, "ExampleDelimiter",
 CellID->1319621880],
Cell[10386, 400, 305, 12, 70, "ExampleText",
 CellID->914591599],
Cell[CellGroupData[{
Cell[10716, 416, 311, 11, 70, "Input",
 CellID->2000542814],
Cell[11030, 429, 1030, 34, 36, "Output",
 CellID->2119097466]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12109, 469, 226, 7, 70, "ExampleSection",
 CellID->28363],
Cell[12338, 478, 269, 9, 70, "ExampleText",
 CellID->1557175484],
Cell[12610, 489, 246, 8, 70, "Input",
 CellID->65153599],
Cell[CellGroupData[{
Cell[12881, 501, 102, 3, 70, "Input",
 CellID->2033001876],
Cell[12986, 506, 161, 5, 36, "Output",
 CellID->50222515]
}, Open  ]],
Cell[13162, 514, 96, 1, 70, "ExampleText",
 CellID->128736334],
Cell[CellGroupData[{
Cell[13283, 519, 109, 3, 70, "Input",
 CellID->1155533009],
Cell[13395, 524, 158, 5, 36, "Output",
 CellID->279768609]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13614, 536, 310, 9, 70, "SeeAlsoSection",
 CellID->6985],
Cell[13927, 547, 929, 35, 70, "SeeAlso",
 CellID->16095]
}, Open  ]],
Cell[CellGroupData[{
Cell[14893, 587, 313, 9, 70, "TutorialsSection",
 CellID->4375],
Cell[15209, 598, 170, 3, 70, "Tutorials",
 CellID->11997],
Cell[15382, 603, 141, 3, 70, "Tutorials",
 CellID->26281],
Cell[15526, 608, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[15761, 617, 319, 9, 70, "MoreAboutSection",
 CellID->316560093],
Cell[16083, 628, 145, 3, 70, "MoreAbout",
 CellID->119259124],
Cell[16231, 633, 148, 3, 70, "MoreAbout",
 CellID->45032575]
}, Open  ]],
Cell[16394, 639, 27, 0, 70, "History"],
Cell[16424, 641, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

