(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55331,       1687]
NotebookOptionsPosition[     47366,       1450]
NotebookOutlinePosition[     50350,       1511]
CellTagsIndexPosition[     50264,       1506]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mouseover" :> Documentation`HelpLookup["paclet:ref/Mouseover"],
           "Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "ClickPane" :> Documentation`HelpLookup["paclet:ref/ClickPane"], 
          "LocatorPane" :> Documentation`HelpLookup["paclet:ref/LocatorPane"],
           "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"], "MousePosition" :> 
          Documentation`HelpLookup["paclet:ref/MousePosition"], 
          "CellEventActions" :> 
          Documentation`HelpLookup["paclet:ref/CellEventActions"], 
          "NotebookEventActions" :> 
          Documentation`HelpLookup["paclet:ref/NotebookEventActions"], 
          "FrontEndEventActions" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndEventActions"], 
          "ControlActive" :> 
          Documentation`HelpLookup["paclet:ref/ControlActive"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mouseover\"\>", 2->"\<\"Button\"\>",
        3->"\<\"ClickPane\"\>", 4->"\<\"LocatorPane\"\>", 
       5->"\<\"CurrentValue\"\>", 6->"\<\"Manipulate\"\>", 
       7->"\<\"MousePosition\"\>", 8->"\<\"CellEventActions\"\>", 
       9->"\<\"NotebookEventActions\"\>", 10->"\<\"FrontEndEventActions\"\>", 
       11->"\<\"ControlActive\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Graphics Interactivity & Drawing" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsInteractivityAndDrawing"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Control Objects\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"Graphics Interactivity & Drawing\"\>", 
       5->"\<\"Low-Level Interface Control\"\>", 
       6->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       7->"\<\"Stand-Alone Interfaces\"\>", 
       8->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["EventHandler", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EventHandler",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EventHandler"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ":>", 
           SubscriptBox[
            StyleBox["action", "TI"], 
            StyleBox["1", "TR"]]}], ",", " ", 
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ":>", 
           SubscriptBox[
            StyleBox["action", "TI"], 
            StyleBox["2", "TR"]]}], ",", " ", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", evaluating ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["action", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " whenever ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     " occurs in connection with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6796]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Standard mouse-related event specifications include:", "Notes",
 CellID->13077],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<MouseDown\>\"", Cell[
    "primary mouse button depressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<MouseDown\>\"", ",", 
       StyleBox["i", "TI"]}], "}"}], Cell["", "TableText"]}], Cell[TextData[{
     "mouse button ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " depressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MouseDragged\>\"", Cell[
    "mouse moving with primary button depressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<MouseDragged\>\"", ",", 
       StyleBox["i", "TI"]}], "}"}], Cell["", "TableText"]}], Cell[TextData[{
     "mouse moving with button ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " depressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MouseMoved\>\"", Cell[TextData[{
     "mouse moves in the region defined by ",
     StyleBox["expr", "TI"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MouseUp\>\"", Cell[
    "primary mouse button released", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<MouseUp\>\"", ",", 
       StyleBox["i", "TI"]}], "}"}], Cell["", "TableText"]}], Cell[TextData[{
     "mouse button ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " released"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->1149],

Cell[TextData[{
 "For mouse events, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " handles events for which the mouse is within the rectangular region \
defined by the display of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3561],

Cell["Standard keyboard-related event specifications include:", "Notes",
 CellID->19626],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<KeyDown\>\"", Cell[
    "any key on the keyboard depressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<KeyDown\>\"", ",", "\"\<\!\(\*
StyleBox[\"x\", \"TI\"]\)\>\""}], "}"}], Cell[TextData[{
     "key ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " depressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReturnKeyDown\>\"", Cell[TextData[{
     StyleBox["Return", "KeyEvent"],
     " or ",
     StyleBox["Enter", "KeyEvent"],
     " key depressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EscapeKeyDown\>\"", Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     " key depressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LeftArrowKeyDown\>\"", Cell[
    "left arrow key depressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RightArrowKeyDown\>\"", Cell[
    "right arrow key depressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UpArrowKeyDown\>\"", Cell[
    "up arrow key depressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DownArrowKeyDown\>\"", Cell[
    "down arrow key depressed", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->17293],

Cell["Standard interface events include:", "Notes",
 CellID->14561],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<MenuCommand\>\"", ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], "}"}], Cell[
    "menu command with specified name chosen", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WindowClose\>\"", Cell[
    "closing of window requested", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->12444],

Cell[TextData[{
 "If functions like ",
 Cell[BoxData[
  ButtonBox["MousePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MousePosition"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " are evaluated in a particular ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["action", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", the values they give are those associated with the event that triggered \
that ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["action", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27443],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 " expressions are nested, events are by default shared by all the \
expressions, with the innermost expression operating first on a particular \
event. "
}], "Notes",
 CellID->12354],

Cell["The following options can be given:", "Notes",
 CellID->21691],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PassEventsDown",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PassEventsDown"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to pass events to inner event handlers", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PassEventsUp",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PassEventsUp"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to pass events to outer event handlers", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->17999],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PassEventsDown",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PassEventsDown"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", events handled by an ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 " are not also passed to built-in event handlers in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. "
}], "Notes",
 CellID->26313]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->386219704],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->194575653],

Cell["Create text that turns red when clicked:", "ExampleText",
 CellID->374163693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"col", "=", "Green"}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<text\>\"", ",", 
       RowBox[{"FontColor", "\[Rule]", 
        RowBox[{"Dynamic", "[", "col", "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseClicked\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"col", "=", "Red"}], ")"}]}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245644340],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`col$$ = RGBColor[0, 1, 0]}, 
  TagBox[
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontColor->Dynamic[$CellContext`col$$]],
   EventHandlerTag[{
    "MouseClicked" :> ($CellContext`col$$ = Red), PassEventsDown -> Automatic,
      PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->834541509]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->785765756],

Cell["\<\
Create text that toggles between red and green when clicked repeatedly:\
\>", "ExampleText",
 CellID->22654711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"col", "=", "Green"}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<text\>\"", ",", 
       RowBox[{"FontColor", "\[Rule]", 
        RowBox[{"Dynamic", "[", "col", "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseClicked\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"col", "=", 
         RowBox[{"col", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Red", "\[Rule]", "Green"}], ",", 
            RowBox[{"Green", "\[Rule]", "Red"}]}], "}"}]}]}], ")"}]}], 
      "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69425050],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`col$$ = RGBColor[0, 1, 0]}, 
  TagBox[
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontColor->Dynamic[$CellContext`col$$]],
   EventHandlerTag[{
    "MouseClicked" :> ($CellContext`col$$ = 
      ReplaceAll[$CellContext`col$$, {Red -> Green, Green -> Red}]), 
     PassEventsDown -> Automatic, PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445646373]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16765],

Cell["Create a graphic that changes color when clicked:", "ExampleText",
 CellID->132049178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"col", "=", "Green"}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"col", ",", 
          RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseClicked\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"col", "=", 
         RowBox[{"col", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Red", "\[Rule]", "Green"}], ",", 
            RowBox[{"Green", "\[Rule]", "Red"}]}], "}"}]}]}], ")"}]}], 
      "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431171395],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`col$$ = RGBColor[0, 1, 0]}, 
  TagBox[
   DynamicBox[ToBoxes[
     Graphics[{$CellContext`col$$, 
       Disk[]}, ImageSize -> Tiny], StandardForm],
    ImageSizeCache->{100., {48., 52.}}],
   EventHandlerTag[{
    "MouseClicked" :> ($CellContext`col$$ = 
      ReplaceAll[$CellContext`col$$, {Red -> Green, Green -> Red}]), 
     PassEventsDown -> Automatic, PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220749967]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->56564376],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PassEventsDown",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->96167023],

Cell["\<\
Allow events to pass down to inner event handlers, changing the color as well \
as position: \
\>", "ExampleText",
 CellID->325147207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"c", "=", "Green"}]}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"EventHandler", "[", 
      RowBox[{
       RowBox[{"Framed", "@", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", 
             RowBox[{"Disk", "[", 
              RowBox[{"p", ",", "0.2"}], "]"}]}], "}"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
         RowBox[{"(", 
          RowBox[{"c", "=", 
           RowBox[{"c", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Red", "\[Rule]", "Green"}], ",", 
              RowBox[{"Green", "\[Rule]", "Red"}]}], "}"}]}]}], ")"}]}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"p", "=", 
         RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], ")"}]}], 
      "}"}], ",", 
     RowBox[{"PassEventsDown", "\[Rule]", "True"}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->61718806],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {0.2888888888888892, 
  0.3111111111111111}, $CellContext`c$$ = RGBColor[1, 0, 0]}, 
  TagBox[
   TagBox[
    FrameBox[
     DynamicBox[ToBoxes[
       Graphics[{$CellContext`c$$, 
         Disk[$CellContext`p$$, 0.2]}, PlotRange -> 2], StandardForm],
      ImageSizeCache->{180., {88., 92.}}],
     StripOnInput->False],
    EventHandlerTag[{
     "MouseDown" :> ($CellContext`c$$ = 
       ReplaceAll[$CellContext`c$$, {Red -> Green, Green -> Red}]), 
      PassEventsDown -> Automatic, PassEventsUp -> True}]],
   EventHandlerTag[{
    "MouseDown" :> ($CellContext`p$$ = MousePosition["Graphics"]), 
     PassEventsDown -> True, PassEventsDown -> Automatic, PassEventsUp -> 
     True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97004935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->142159227],

Cell["Do not pass mouse events to the inner event handler: ", "ExampleText",
 CellID->255553096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"c", "=", "Green"}]}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"EventHandler", "[", 
      RowBox[{
       RowBox[{"Framed", "@", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", 
             RowBox[{"Disk", "[", 
              RowBox[{"p", ",", "0.2"}], "]"}]}], "}"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
         RowBox[{"(", 
          RowBox[{"c", "=", 
           RowBox[{"c", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Red", "\[Rule]", "Green"}], ",", 
              RowBox[{"Green", "\[Rule]", "Red"}]}], "}"}]}]}], ")"}]}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"p", "=", 
         RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], ")"}]}], 
      "}"}], ",", 
     RowBox[{"PassEventsDown", "\[Rule]", "False"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->489792009],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {0, 0}, $CellContext`c$$ = RGBColor[
  0, 1, 0]}, 
  TagBox[
   TagBox[
    FrameBox[
     DynamicBox[ToBoxes[
       Graphics[{$CellContext`c$$, 
         Disk[$CellContext`p$$, 0.2]}, PlotRange -> 2], StandardForm],
      ImageSizeCache->{180., {88., 92.}}],
     StripOnInput->False],
    EventHandlerTag[{
     "MouseDown" :> ($CellContext`c$$ = 
       ReplaceAll[$CellContext`c$$, {Red -> Green, Green -> Red}]), 
      PassEventsDown -> Automatic, PassEventsUp -> True}]],
   EventHandlerTag[{
    "MouseDown" :> ($CellContext`p$$ = MousePosition["Graphics"]), 
     PassEventsDown -> False, PassEventsDown -> Automatic, PassEventsUp -> 
     True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->647566096]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9697],

Cell["Automatically fit a line to a set of points: ", "ExampleText",
 CellID->591096700],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"lineFit", "[", 
    RowBox[{"points_", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xmin_", ",", "xmax_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ymin_", ",", "ymax_"}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "lf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"lf", "=", 
       RowBox[{"Function", "@@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "x", "}"}], ",", 
          RowBox[{"Fit", "[", 
           RowBox[{"points", ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "1"}], "}"}], ",", 
            RowBox[{"{", "x", "}"}]}], "]"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"xmin", ",", 
           RowBox[{"lf", "[", "xmin", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"xmax", ",", 
           RowBox[{"lf", "[", "xmax", "]"}]}], "}"}]}], "}"}], "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"l", "=", 
      RowBox[{"{", "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Point", "[", "p", "]"}], ",", "l"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ",", 
     RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"p", ",", 
          RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "p", "]"}], "\[GreaterEqual]", "2"}], ",", 
          RowBox[{"l", "=", 
           RowBox[{"lineFit", "[", 
            RowBox[{"p", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]}]}], 
         "]"}]}], ")"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->570985583],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {{-0.25083612040133807`, 
  0.13712374581939774`}, {0.123745819397993, 
  0.19063545150501648`}, {-0.6120401337792645, -0.4648829431438129}, \
{-0.5585284280936458, 0.00334448160535096}, {0.7123745819397991, 
  0.20401337792642116`}, {-0.036789297658863074`, -0.2240802675585286}, {
  0.40468227424749137`, -0.14381270903010052`}}, $CellContext`l$$ = 
  Line[{{-1, -0.2849838298653674}, {1, 0.21548082093168752`}}]}, 
  TagBox[
   DynamicBox[ToBoxes[
     Graphics[{
       Point[$CellContext`p$$], $CellContext`l$$}, PlotRange -> 1, Frame -> 
      True], StandardForm],
    ImageSizeCache->{180., {84., 88.}}],
   EventHandlerTag[{"MouseDown" :> (AppendTo[$CellContext`p$$, 
        MousePosition["Graphics"]]; 
      If[Length[$CellContext`p$$] >= 
        2, $CellContext`l$$ = $CellContext`lineFit[$CellContext`p$$, {{-1, 
          1}, {-1, 1}}]]), PassEventsDown -> Automatic, PassEventsUp -> 
     True}]],
  DynamicModuleValues:>{},
  Initialization:>($CellContext`lineFit[
     Pattern[$CellContext`points, 
      Blank[]], {{
       Pattern[$CellContext`xmin, 
        Blank[]], 
       Pattern[$CellContext`xmax, 
        Blank[]]}, {
       Pattern[$CellContext`ymin, 
        Blank[]], 
       Pattern[$CellContext`ymax, 
        Blank[]]}}] := 
   Module[{$CellContext`x, $CellContext`lf}, $CellContext`lf = 
      Apply[Function, {{$CellContext`x}, 
         Fit[$CellContext`points, {$CellContext`x, 1}, {$CellContext`x}]}]; 
     Line[{{$CellContext`xmin, 
         $CellContext`lf[$CellContext`xmin]}, {$CellContext`xmax, 
         $CellContext`lf[$CellContext`xmax]}}]])]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1816325560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3846054],

Cell["Piecewise interpolation through a set of points: ", "ExampleText",
 CellID->252599098],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"interpolationCurve", "[", 
    RowBox[{"p_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"f", "=", 
        RowBox[{"Interpolation", "[", 
         RowBox[{"p", ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "n"}]}], " ", "]"}]}]}], 
      "}"}], ",", 
     RowBox[{"First", "@", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Evaluate", "@", 
         RowBox[{"f", "[", "x", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"Min", "[", 
           RowBox[{"p", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], ",", 
          RowBox[{"Max", "[", 
           RowBox[{"p", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}]}], 
       "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134601119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "2"}], ",", 
     RowBox[{"p", "=", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"c", "=", 
      RowBox[{"{", "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Point", "[", "p", "]"}], ",", "c"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<MouseDown\>\"", " ", ":>", " ", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "=", 
         RowBox[{"Union", "[", 
          RowBox[{
           RowBox[{"Sort", "@", 
            RowBox[{"Append", "[", 
             RowBox[{"p", ",", 
              RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], 
             "]"}]}], ",", 
           RowBox[{"SameTest", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"First", "[", "#1", "]"}], "\[Equal]", 
               RowBox[{"First", "[", "#2", "]"}]}], "&"}], ")"}]}]}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "p", "]"}], " ", "\[GreaterEqual]", 
           RowBox[{"n", "+", "1"}]}], ",", 
          RowBox[{"c", "=", 
           RowBox[{"interpolationCurve", "[", 
            RowBox[{"p", ",", "n"}], "]"}]}]}], "]"}]}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46561434],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 
  2, $CellContext`p$$ = {{-0.719063545150502, -0.1571906354515052}, \
{-0.26421404682274274`, 0.1505016722408024}, {
  0.08361204013377899, -0.05016722408026777}, {0.6053511705685617, 
  0.13712374581939774`}}, $CellContext`c$$ = {{{}, {}, {
     Hue[0.67, 0.6, 0.6], 
     Line[CompressedData["
1:eJwVlHk8FAgfxkfJItGhdaRoS0U5slKE31iloQjrLFFyR9SWcrVElMZbRMqb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      "]]}}}}, 
  TagBox[
   DynamicBox[ToBoxes[
     Graphics[{
       Point[$CellContext`p$$], $CellContext`c$$}, PlotRange -> 1, Frame -> 
      True], StandardForm],
    ImageSizeCache->{180., {84., 88.}}],
   EventHandlerTag[{"MouseDown" :> ($CellContext`p$$ = Union[
         Sort[
          Append[$CellContext`p$$, 
           MousePosition["Graphics"]]], 
         SameTest -> (First[#] == First[#2]& )]; 
      If[Length[$CellContext`p$$] >= $CellContext`n$$ + 
         1, $CellContext`c$$ = \
$CellContext`interpolationCurve[$CellContext`p$$, $CellContext`n$$]]), 
     PassEventsDown -> Automatic, PassEventsUp -> True}]],
  DynamicModuleValues:>{},
  Initialization:>($CellContext`interpolationCurve[
     Pattern[$CellContext`p, 
      Blank[]], 
     Pattern[$CellContext`n, 
      Blank[]]] := 
   Module[{$CellContext`x, $CellContext`f = 
      Interpolation[$CellContext`p, InterpolationOrder -> $CellContext`n]}, 
     First[
      Plot[
       Evaluate[
        $CellContext`f[$CellContext`x]], {$CellContext`x, 
        Min[
         Part[$CellContext`p, All, 1]], 
        Max[
         Part[$CellContext`p, All, 1]]}]]])]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1525352878]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->560102251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["MousePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MousePosition"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->79242083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pos", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", "pos", "]"}], ",", "0.2"}], "]"}], "}"}], 
        ",", 
        RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"pos", "=", 
         RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], ")"}]}], 
      "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200112267],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pos$$ = {0, 0}}, 
  TagBox[
   FrameBox[
    GraphicsBox[DiskBox[Dynamic[$CellContext`pos$$], 0.2],
     PlotRange->2],
    StripOnInput->False],
   EventHandlerTag[{
    "MouseDown" :> ($CellContext`pos$$ = MousePosition["Graphics"]), 
     PassEventsDown -> Automatic, PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549139392]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22026],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mouseover",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mouseover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29273]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12079],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with EventHandler",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=EventHandler"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->196724329],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->216841065],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->674773070],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->390896503],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsInteractivityAndDrawing"]], "MoreAbout",
 CellID->247643482],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->80469977],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->28298640],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->995495521],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->73609720]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EventHandler - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 0.3560054}", "context" -> "System`", 
    "keywords" -> {
     "ACTION_EVENT", "action listener", "button-click events", 
      "button clicks", "button events", "callback", "clicked", "click events",
       "double-click event", "down arrow key", "drawing program", 
      "drawing tools", "escape key down", "event based dynamical systems", 
      "event driven programming", "event functions", "event handling", 
      "event listener", "event processing", "GUI events", "handler", 
      "interrupt handler", "KEY_ACTION", "KEY_ACTION_RELEASE", 
      "keyboard events", "keyboard interrupts", "key down events", 
      "key events", "KEY_PRESS", "key press event", "KEY_RELEASE", 
      "left arrow key", "low-level events", "menu commands", "menu events", 
      "mouse buttons", "mouse clicked", "mouseClicked", 
      "mouse double-clicked", "mouse down", "MOUSE_DOWN", "MOUSE_DRAG", 
      "mouse dragged", "mouseDragged", "MOUSE_ENTER", "mouse entered", 
      "mouseEntered", "mouse events", "MOUSE_EXIT", "mouse exited", 
      "mouseExited", "mouse motion", "MOUSE_MOVE", "mouse moved", 
      "mouseMoved", "mouse movements", "mousePressed", "mouse up", "MOUSE_UP",
       "on click", "onClick", "onDblClick", "on double click", 
      "onDoubleClick", "onEvent", "on key down", "onKeyDown", "on key press", 
      "onKeyPress", "on mouse down", "onMouseDown", "on mouse move", 
      "onMouseMove", "on mouse out", "onMouseOut", "on mouse over", 
      "onMouseOver", "on mouse up", "onMouseUp", "painting program", 
      "painting tools", "return events", "return key", "return key down", 
      "right arrow key", "up arrow key", "window close events"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EventHandler[expr, {\"SubscriptBox[ event, 1]\" :> action_1, \
\"SubscriptBox[ event, 2]\" :> action_2, ...}] displays as expr, evaluating \
action_i whenever \"SubscriptBox[ event, i]\" occurs in connection with expr. \
", "synonyms" -> {"event handler"}, "title" -> "EventHandler", "type" -> 
    "Symbol", "uri" -> "ref/EventHandler"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15955, 451, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->386219704]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50120, 1499}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4447, 92, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5070, 119, 1577, 37, 70, "ObjectNameGrid"],
Cell[6650, 158, 1498, 46, 70, "Usage",
 CellID->6796]
}, Open  ]],
Cell[CellGroupData[{
Cell[8185, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8663, 226, 85, 1, 70, "Notes",
 CellID->13077],
Cell[8751, 229, 1815, 49, 70, "2ColumnTableMod",
 CellID->1149],
Cell[10569, 280, 476, 16, 70, "Notes",
 CellID->3561],
Cell[11048, 298, 88, 1, 70, "Notes",
 CellID->19626],
Cell[11139, 301, 1564, 38, 70, "2ColumnTableMod",
 CellID->17293],
Cell[12706, 341, 67, 1, 70, "Notes",
 CellID->14561],
Cell[12776, 344, 593, 14, 70, "2ColumnTableMod",
 CellID->12444],
Cell[13372, 360, 670, 24, 70, "Notes",
 CellID->27443],
Cell[14045, 386, 336, 10, 70, "Notes",
 CellID->12354],
Cell[14384, 398, 68, 1, 70, "Notes",
 CellID->21691],
Cell[14455, 401, 862, 23, 70, "3ColumnTableMod",
 CellID->17999],
Cell[15320, 426, 598, 20, 70, "Notes",
 CellID->26313]
}, Closed]],
Cell[CellGroupData[{
Cell[15955, 451, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->386219704],
Cell[CellGroupData[{
Cell[16340, 465, 148, 5, 70, "ExampleSection",
 CellID->194575653],
Cell[16491, 472, 83, 1, 70, "ExampleText",
 CellID->374163693],
Cell[CellGroupData[{
Cell[16599, 477, 558, 17, 47, "Input",
 CellID->245644340],
Cell[17160, 496, 482, 14, 36, "Output",
 CellID->834541509]
}, Open  ]],
Cell[17657, 513, 125, 3, 70, "ExampleDelimiter",
 CellID->785765756],
Cell[17785, 518, 121, 3, 70, "ExampleText",
 CellID->22654711],
Cell[CellGroupData[{
Cell[17931, 525, 745, 22, 70, "Input",
 CellID->69425050],
Cell[18679, 549, 546, 15, 70, "Output",
 CellID->445646373]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19274, 570, 216, 7, 70, "ExampleSection",
 CellID->16765],
Cell[19493, 579, 92, 1, 70, "ExampleText",
 CellID->132049178],
Cell[CellGroupData[{
Cell[19610, 584, 834, 25, 70, "Input",
 CellID->431171395],
Cell[20447, 611, 601, 16, 70, "Output",
 CellID->220749967]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21097, 633, 221, 7, 70, "ExampleSection",
 CellID->56564376],
Cell[CellGroupData[{
Cell[21343, 644, 234, 7, 70, "ExampleSubsection",
 CellID->96167023],
Cell[21580, 653, 144, 4, 70, "ExampleText",
 CellID->325147207],
Cell[CellGroupData[{
Cell[21749, 661, 1379, 41, 70, "Input",
 CellID->61718806],
Cell[23131, 704, 913, 24, 70, "Output",
 CellID->97004935]
}, Open  ]],
Cell[24059, 731, 125, 3, 70, "ExampleDelimiter",
 CellID->142159227],
Cell[24187, 736, 96, 1, 70, "ExampleText",
 CellID->255553096],
Cell[CellGroupData[{
Cell[24308, 741, 1382, 41, 70, "Input",
 CellID->489792009],
Cell[25693, 784, 881, 24, 70, "Output",
 CellID->647566096]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26635, 815, 222, 7, 70, "ExampleSection",
 CellID->9697],
Cell[26860, 824, 88, 1, 70, "ExampleText",
 CellID->591096700],
Cell[26951, 827, 1171, 38, 70, "Input",
 CellID->26318],
Cell[CellGroupData[{
Cell[28147, 869, 1484, 43, 70, "Input",
 CellID->570985583],
Cell[29634, 914, 1788, 42, 70, "Output",
 CellID->1816325560]
}, Open  ]],
Cell[31437, 959, 123, 3, 70, "ExampleDelimiter",
 CellID->3846054],
Cell[31563, 964, 92, 1, 70, "ExampleText",
 CellID->252599098],
Cell[31658, 967, 995, 31, 70, "Input",
 CellID->134601119],
Cell[CellGroupData[{
Cell[32678, 1002, 1728, 49, 70, "Input",
 CellID->46561434],
Cell[34409, 1053, 4659, 94, 70, "Output",
 CellID->1525352878]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39117, 1153, 237, 7, 70, "ExampleSection",
 CellID->560102251],
Cell[39357, 1162, 338, 12, 70, "ExampleText",
 CellID->79242083],
Cell[CellGroupData[{
Cell[39720, 1178, 806, 25, 70, "Input",
 CellID->200112267],
Cell[40529, 1205, 512, 15, 70, "Output",
 CellID->549139392]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41102, 1227, 311, 9, 70, "SeeAlsoSection",
 CellID->22026],
Cell[41416, 1238, 2758, 98, 70, "SeeAlso",
 CellID->29273]
}, Open  ]],
Cell[CellGroupData[{
Cell[44211, 1341, 314, 9, 70, "TutorialsSection",
 CellID->12079],
Cell[44528, 1352, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[44690, 1357, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[44900, 1365, 305, 8, 70, "RelatedLinksSection"],
Cell[45208, 1375, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45614, 1392, 319, 9, 70, "MoreAboutSection",
 CellID->196724329],
Cell[45936, 1403, 158, 3, 70, "MoreAbout",
 CellID->216841065],
Cell[46097, 1408, 141, 3, 70, "MoreAbout",
 CellID->674773070],
Cell[46241, 1413, 168, 3, 70, "MoreAbout",
 CellID->390896503],
Cell[46412, 1418, 175, 3, 70, "MoreAbout",
 CellID->247643482],
Cell[46590, 1423, 162, 3, 70, "MoreAbout",
 CellID->80469977],
Cell[46755, 1428, 208, 5, 70, "MoreAbout",
 CellID->28298640],
Cell[46966, 1435, 154, 3, 70, "MoreAbout",
 CellID->995495521],
Cell[47123, 1440, 171, 3, 70, "MoreAbout",
 CellID->73609720]
}, Open  ]],
Cell[47309, 1446, 27, 0, 70, "History"],
Cell[47339, 1448, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

