(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28603,        982]
NotebookOptionsPosition[     23294,        797]
NotebookOutlinePosition[     24658,        836]
CellTagsIndexPosition[     24573,        831]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InexactNumberQ" :> 
          Documentation`HelpLookup["paclet:ref/InexactNumberQ"], "NumberQ" :> 
          Documentation`HelpLookup["paclet:ref/NumberQ"], "IntegerQ" :> 
          Documentation`HelpLookup["paclet:ref/IntegerQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InexactNumberQ\"\>", 
       2->"\<\"NumberQ\"\>", 3->"\<\"IntegerQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExactNumberQ", "ObjectName",
 CellID->15072],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExactNumberQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExactNumberQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is an exact real or complex number, and returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExactNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExactNumberQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " has head ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 ", or is a complex number whose components both have heads ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4406]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55169060],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->742866223],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExactNumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExactNumberQ"]], "InlineFormula"],
 " tests whether an object is explicitly an exact number:"
}], "ExampleText",
 CellID->716711489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", 
  RowBox[{"6", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225592494],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100781637]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", "5.6", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52990215],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->850808720]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->96585538],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1079050]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2042],

Cell["\<\
Both real and imaginary parts of a complex number must be exact:\
\>", "ExampleText",
 CellID->156958197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", 
  RowBox[{
   RowBox[{"3", "/", "4"}], "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378895524],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70062224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", 
  RowBox[{
   RowBox[{"3", "/", "4"}], "+", 
   RowBox[{"1.", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->376452595],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94405326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->763055611],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExactNumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExactNumberQ"]], "InlineFormula"],
 " is false for symbolic objects that represent numbers:"
}], "ExampleText",
 CellID->246911680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104845873],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->834812432]
}, Open  ]],

Cell[TextData[{
 "You can test these with ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->359752627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->479674703],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24583974]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1041],

Cell["\<\
Numbers are considered either exact or approximate (inexact):\
\>", "ExampleText",
 CellID->337526657],

Cell[BoxData[
 RowBox[{
  RowBox[{"numbers", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.", ",", "2`10", ",", 
     RowBox[{"3", "/", "4"}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "7"}], "]"}], "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441045006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"ExactNumberQ", "[", "x", "]"}], ",", 
       RowBox[{"InexactNumberQ", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "numbers"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<x\>\"", ",", "\"\<exact\>\"", ",", "\"\<approximate\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->472518670],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWs1u1DAQTvOz23ZLKYUKOCD1ACdASMAFtRIX1B4QR4qgvSwVUntAQOkZ
3gFehqdgOXLcN+gjmDjxsJPJl8ROs0naSLvemdjjmc/jmYmzr8anRx8+jk+P
D8ebuyfjz0fHh183dz6dxKxgwfO8afz5csuLf6v4V/KZKhW36XekvwPNTS7v
rwM3iL80Gcatb9rIS/tpftLBS6/AkLylfkMhd2D4uh3G7TLrHwG5fkyGZn7d
jtg8kWl9MY7GPIaW6bte9J82w0jOAOibG10pLSqcg48NBY1HcQQ1fQWsVH6U
lI31lNasItkltA9kPIWoSxyXgH4DgJEcJ+1CdpKfzgvLRKdwRnvemg1ulejX
R85ZZ5XukCp03VGkuUOgA48RWuhKbdSiwt1N8QrKzqxZmXYYT98rjmeLAJNy
aZa7M8dFllGEtpWBsavyNK41ssJu/eQsK7AX5QPkW5Qv5FyhN8s/cmf7BqVU
6eQyHLpDI59AbDCOo7kghOdahdybkLss5kl6Zbxfxp4X0GrCZKRm3k9Y+WYV
OOq0OmumlR6k5QwMX4+/rdIqYAfO7lKvtMsle6uqm21lX61cU26V0H2oGfYd
uefs4vpzYLVrNXADjWmoWnkIEUAVm31FYGVzpWb1rM7XFY+sLKyXtetbqpnr
QpptzsdeW7SfKL7I7Ip0d82B62peGbrYRk5fFfTQICRts89c18Ga2OTKB1b6
yhp3V0lvlbvgLkRH5qZnhbNr4ZRJFsX9LZVG2Hsqm1G2oLR2swNlgQm8K338
N+xFno9lcFpj+qdQD7/wrp0eLna/V21nu9RHJ5PJ9+TyguQrps39N7B/Md2P
DJZqdXZ2lrEqpl2s6jhHHdbWsfnsgnTpe7aIjI4HQHIX2UBGiz0l/aDJ6C8r
HO3x9tHePsLaxVBO43jch2cSzKUdxZ/YAuYNddsN1a9zW5e93F/uhrD5Ypzt
ypHLPUCyq7Vo92xYzr7UA9yaRZ4w7uo8WdKLPcCnGYTnU820dzo97AGO8/F1
myqtnfPtSxRPWjkjb6qyugxn5LLyfK3arhhRvtAS9gC//1WW1Ge/lhXd1idc
Z9KuyzfFUreLlhNt8O0im0C95hqB6azkMkROwvZA9ePtoTyDuhinqOewpeOz
06Y1b/5E1V7Dvp+z2lnS1akr1u6tqoqT533zpsl3qqk3bNMEsObj5A+VrZy3
Ya+fgpY+xOzJ/D+Or+6+WS0ZeWnlI0PTStPzgIzE1D/0slE9YPJ4K8dHjM93
qpa3AK33c74i68Yw18PlX0m47/mfGx3ickb3sh0025Ulcw4F19yLILq88pCn
RhWRT/Tm9Kgl9Eh7+B9nF8yqslIpbryyobfeVQit8H4dYsL3spQdue5JC+92
3plWXoXqNT8/v6r06WZ3YuVaMXRLIzeKrhQ9qQ6iqDoS/VHEz9TWBbyiiB6w
+zSGLJS1PsnIY/lN0C8FvQRH/RL0naTXNFVi4R89SMAO\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{224, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->22318583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->873636812],

Cell[TextData[{
 "Exact numbers have ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->208922121],

Cell[BoxData[
 RowBox[{
  RowBox[{"numbers", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.", ",", "2`10", ",", 
     RowBox[{"3", "/", "4"}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "7"}], "]"}], "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204139606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"ExactNumberQ", "[", "x", "]"}], ",", 
       RowBox[{"Precision", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "numbers"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<exact\>\"", ",", "\"\<Precision\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106801040],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWsluFDEQ9fQymYQQAggRwoVPYDkhEMsFThwBsQgpBMQiIbacWe6cEP+V
T4mAIwcznnZ115Sf2+6NtGhppttuu5bnclXZ7js7ey+fv9nZe7W7c+72h513
L1/tfjx36+2HeVU6UWqSKqXeb6n5s54/LX7myua/4rF4ys1/Sm+1+tOgNp3/
maKhlNh7rop2pn7RQBVXaov8Tu1WBN2prTf3lfl9jbXPAd3EaGP5m/s6kDOx
fKg90fPpY+43odamt8rLshWFeEyBLk7vILXcy4P3zUQZ9+LomvJRoLXbS9LG
ckptNjzIzxbiVvWuLnG44NobGo2TRH4VcJgCSWQ/iQRChqx+KPSnDn7HRYuZ
1QbZtMeSasfjWmtMG2uji1kbwr05vsQ7AzJwX5SDcZlBblLGftElP4r81zK9
Om0w/ony+9kZwLCeWtuZKlFehZqVfjSErK7z0yFb5XogveSYYTQkl3XYiiIX
sk5fJMpUFSmP1eiCpMgcXNvaJB7HI4NgiXltwNrTsHZN8NkKSu/n270WxyUa
UyMFzcpEVRmEac/Hnmxk096lHRs6U1tv+m/rwtbWGV3u6eKynCZ54L+tJflD
WeNVoHdSOpHioszxC+SER1XOtbi4dB1oUVdOlJtdnQQavIaSo6wzPkeJkjWY
C57Q0uPIFi+iZG+XB7TXIbdzrY3sPtukOS0jLZKSVlKxXua4jrUKiYGMKitW
eylVQhyykoOtoTek99covpuifDuI9ncv3UxVnnEm3l/RhSf4AXv/W69F3ukX
fCvt5SdsRVaEafCyGaLfXjkS79s4OZro/VR39cKF9ezv739eXCpd/M3L9v19
2H4oz1pQOzg4WJJmXm4izWC+c7c19y5eD3EdzovltuVjOa66m5eStn8viAb2
SjJ+GYvwe6H4mR83t3kZ+4kx5HC4luyQZ8I8U217P6Wb7R+uaTdTNvI88Urt
3w9sMgfGW3tK6DzknmE9nngMpJ9bGwFmh4W6u1co8y3MbRciK6mvjgCXfpEl
DGN2CeXOXBMkZRnvMI4BnaZIEkL97hV2wVpGwpURIDWM1VJcQ+sisl6569oE
Sdz2P/ICwT3E7Q7o8b2+vjIZvtd3Vi9nSs+gFGPI7eIyvru6Waa2atuznF9V
6xk656V7wZ4uGka3lnOivhmTlM+tlPHKlLvLWvJmmkxUybYm0hIm90B9X7kX
Pq3oPrPaSRODiPO+Je8ukWmikS1Lio+Q9C2yN3z+EYdoF4R6GZ2amNzuy4i+
RoRwiMn6+Gqi6k2eoG/M5cpTSpYDnuhcGmUGw2A6TP6HUW/qm9BuHyqX7dwz
Usxt6RS66Uq/bx9F0k86zYWYXJJOLZcis66stZwRWUV7OVrK3jzHcffbYniR
3LKcemgk8QgFs8MtQF+ut7cdzS5DCQgds7PJs7wzGmU5G5p9W8WobFokZN4q
z+yPQRnGkBXWn/s+1sOc68r95GHPETrIMNjpQd8ydTlTiJdluJOGOBlKD9Py
3AFzeRDEzX8maooPdduzT8MrW6hxCPPdiaqEofHGGZjlhC9f75Hvp++GO6/d
lvzuBf8oLo2XzP8932RFWi1uK6PRWFdMFyFmPN7JlUZgVtesS+S+4ZjWKWEc
eETjOU1I48NeLWDNPLMilFG3mRvSAhxqY8nReevzFWq1ni8VNHhU4ZmwYXzE
0X6oPPpSJT3T6VNwNHC0/abj8tYbi97m0brlyV+1Ty5U\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{259, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->887220965]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->462449979],

Cell[TextData[{
 "Exact numbers have ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->51656093],

Cell[BoxData[
 RowBox[{
  RowBox[{"numbers", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.", ",", "2`10", ",", 
     RowBox[{"3", "/", "4"}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "7"}], "]"}], "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614358491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"ExactNumberQ", "[", "x", "]"}], ",", 
       RowBox[{"Head", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "numbers"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<exact\>\"", ",", "\"\<Head\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->367494095],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdW0tuFDEQ7fRnPkkI+ZJBASUIwgHYgsSOrFgSxGczREjJAgEhazgAl4Al
EhcAliyzyFFyBNOeds24q5/ddk/3TIeR0p7yt+rZflVtT54Oz47fvhuenRwN
9w5Ohx+OT44+7T15f5pmRQtBEJynfx8HQfpdpN9Gf+dCpGn2TOQzkrmjT/At
fUhxD5Z+Z/IurBWpPuI0DVWaBFk9mT+qEGSfSIl6SvW6rN+OypdpN00XtfoJ
6DdMxViNL9MlTS8q77J2oRITlca8XNnUg5bL0iAZy6pZpNp0gD2F1qW9JcYx
9LYxk3ErHWEpXwMzWWzF+8Z6cmuWzbWsuRPtcF2oDUcinshB0Bdo7vhs9EG/
HYA0b8f1QfrRbmhqRjoFm1eQVo3iLu0L1S6thra3nSLbr2Uz4o88jR0DHXT2
SsjexpEmfjIjTOy7DPTNrw2bRVibMDCzcw/gaO/NkUsKudMiHQKWcuPgsIBh
NU7RrUdocK7BGPJRMNOSl0TrmrwoHysOJl55iZWTlw5VmilPxRJb3W+aYgR9
Hnz9KteoHjTxWCswdxvm8nU5gLVuslo3oOU6+rTrKEYJFa76LNFsrqqUrzjZ
T0fly/Y7qv1AyQOoxd+Z5tYZg5bFkI9Enr0JVx7zSYzWxXziR76/3fzXY4CI
TUZsuAFHam/M5hdbOSFUGtduIN1bFFlVi36qYyMz12aCSXkMZGIBYk0eqyCr
6Q3WdR9Ma3vzUQmfy+tM7ipsORqkHXn6rET33oT3OsB7VrECt26VyQcFlDi6
dyG67v5adk7+t8fKH4rMZ9wX7fO75Bt/w1K+h37BWrSzcB+6LDH9Y9QjNJa6
6eFj9xvhHgOsanVzlmmrX+cmtOonPaJTqwWoYzbexcXFl9EniEaPVFblz2F9
szytt8f8XxjFo0c33rehc3l5mUMnlX3QcfP0OeZwQ8EtyqsflaPKVpMP109P
67QqEvgsxd2OSl7ZZ21XsnS8q4qrxOLNsdUU5b0GrT28MLROZztiJ91Hc/Yz
nRFgzTlDHxYQcfO4/D36jtPoPP6Ve1963HvKXh6vkweOnGwxez03v6bL2EfO
1uf75PKYm1ZMPGW6JfzucfoC+2BiKdTHbaNF5vsaH35pb+4Ws3lGdzqlb0B8
RDxDfI4XW4DovObEcKtj9TXTYM9r9VuAXL3YExau9zo6w5hiGIwll3stQKIe
LMdMXP/dTq0xMp4X7pO7LUC1mTWO4jd4x2OMGE29+PjW/4hDSuNVfO/Dz8bM
fo9mpK4YS7/3kadZidJGyrtQizZEnW6x6DMxrxgS+Q2p0SHIvzpxF6/1qpI1
845YdK2pl+Z9PdLiantJF1xn7V+gTo1zMp3ItJ1Lfygst2HpTyZvGu2NlL36
7rCdj6+pOlln9KGO9X0Wg5RY3ed2nJ+PVTn55u9jlnPBLstVZR3YAt3cFt6o
6rSzVAMPSy1jWU5G5m4tOuNzt5JORM1981bTWuV70oRsC4218W1/4T7Z2N5+
v+5mpfuJ9YiHcr/n5DyjcxD5DMRFxDK8zIdZXuS1AbjtM5l7m304Gun+UmQn
0/vKpgewto31z4PxHM/W0xTmiGZSemHTb55MNw4UixfvR2PWSqa3zDOYmyse
sRZ/U2RhTMwVPm+zbmxZyC2PPDjDlvCHhY9xNNas9nr8QL8VqK6nHpv7aGRY
LdjK6dYMs8PuX9yYWrPJug8jTeZMS29ChCJ+k+CROWdb+cT78bPTHG6yWjuw
r68C8QNF2xka2X8zBQv/AMZUFHM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{203, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->663130107]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371728959],

Cell[TextData[{
 "A function equivalent to ",
 Cell[BoxData[
  ButtonBox["ExactNumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExactNumberQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->370177670],

Cell[BoxData[
 RowBox[{
  RowBox[{"enq", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"NumberQ", "[", "#", "]"}], "&&", 
      RowBox[{"(", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"#", ",", 
         RowBox[{"_Integer", "|", "_Rational", "|", 
          RowBox[{"Complex", "[", 
           RowBox[{
            RowBox[{"_Integer", "|", "_Rational"}], ",", 
            RowBox[{"_Integer", "|", "_Rational"}]}], "]"}]}]}], "]"}], 
       ")"}]}], ")"}], "&"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4966309],

Cell[BoxData[
 RowBox[{
  RowBox[{"numbers", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.", ",", "2`10", ",", 
     RowBox[{"3", "/", "4"}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "7"}], "]"}], "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56767047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"ExactNumberQ", "[", "x", "]"}], "===", 
       RowBox[{"enq", "[", "x", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "numbers"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->587789134],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "True"},
    {"1.`", "True"},
    {"2.`10.", "True"},
    {
     FractionBox["3", "4"], "True"},
    {
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "\[ImaginaryI]"}]}], "True"},
    {
     RowBox[{"3.1415926535897932385`7.", "+", 
      RowBox[{"8", " ", "\[ImaginaryI]"}]}], "True"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$2286]]]], "Output",
 ImageSize->{127, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->363460411]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22757],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InexactNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InexactNumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7016]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->647220570],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->16935986]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExactNumberQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 1.3404056}", "context" -> "System`", 
    "keywords" -> {
     "Gaussian integers", "Gaussian rationals", "integers", "rationals", 
      "testing exact numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExactNumberQ[expr] returns True if expr is an exact real or complex \
number, and returns False otherwise.", "synonyms" -> {"exact number q"}, 
    "title" -> "ExactNumberQ", "type" -> "Symbol", "uri" -> 
    "ref/ExactNumberQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4488, 156, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->55169060]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24431, 824}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1394, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2017, 61, 50, 1, 70, "ObjectName",
 CellID->15072],
Cell[2070, 64, 877, 28, 70, "Usage",
 CellID->19019]
}, Open  ]],
Cell[CellGroupData[{
Cell[2984, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3462, 114, 989, 37, 70, "Notes",
 CellID->4406]
}, Closed]],
Cell[CellGroupData[{
Cell[4488, 156, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55169060],
Cell[CellGroupData[{
Cell[4872, 170, 148, 5, 70, "ExampleSection",
 CellID->742866223],
Cell[5023, 177, 240, 7, 70, "ExampleText",
 CellID->716711489],
Cell[CellGroupData[{
Cell[5288, 188, 131, 4, 28, "Input",
 CellID->225592494],
Cell[5422, 194, 161, 5, 36, "Output",
 CellID->100781637]
}, Open  ]],
Cell[CellGroupData[{
Cell[5620, 204, 109, 3, 28, "Input",
 CellID->52990215],
Cell[5732, 209, 162, 5, 36, "Output",
 CellID->850808720]
}, Open  ]],
Cell[CellGroupData[{
Cell[5931, 219, 107, 3, 28, "Input",
 CellID->96585538],
Cell[6041, 224, 160, 5, 36, "Output",
 CellID->1079050]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6250, 235, 215, 7, 70, "ExampleSection",
 CellID->2042],
Cell[6468, 244, 115, 3, 70, "ExampleText",
 CellID->156958197],
Cell[CellGroupData[{
Cell[6608, 251, 155, 5, 70, "Input",
 CellID->378895524],
Cell[6766, 258, 160, 5, 36, "Output",
 CellID->70062224]
}, Open  ]],
Cell[CellGroupData[{
Cell[6963, 268, 180, 6, 70, "Input",
 CellID->376452595],
Cell[7146, 276, 161, 5, 36, "Output",
 CellID->94405326]
}, Open  ]],
Cell[7322, 284, 125, 3, 70, "ExampleDelimiter",
 CellID->763055611],
Cell[7450, 289, 239, 7, 70, "ExampleText",
 CellID->246911680],
Cell[CellGroupData[{
Cell[7714, 300, 109, 3, 70, "Input",
 CellID->104845873],
Cell[7826, 305, 162, 5, 36, "Output",
 CellID->834812432]
}, Open  ]],
Cell[8003, 313, 207, 8, 70, "ExampleText",
 CellID->359752627],
Cell[CellGroupData[{
Cell[8235, 325, 105, 3, 70, "Input",
 CellID->479674703],
Cell[8343, 330, 160, 5, 36, "Output",
 CellID->24583974]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8552, 341, 232, 7, 70, "ExampleSection",
 CellID->1041],
Cell[8787, 350, 112, 3, 70, "ExampleText",
 CellID->337526657],
Cell[8902, 355, 412, 13, 70, "Input",
 CellID->441045006],
Cell[CellGroupData[{
Cell[9339, 372, 632, 20, 70, "Input",
 CellID->472518670],
Cell[9974, 394, 1731, 32, 70, "Output",
 Evaluatable->False,
 CellID->22318583]
}, Open  ]],
Cell[11720, 429, 125, 3, 70, "ExampleDelimiter",
 CellID->873636812],
Cell[11848, 434, 284, 11, 70, "ExampleText",
 CellID->208922121],
Cell[12135, 447, 412, 13, 70, "Input",
 CellID->204139606],
Cell[CellGroupData[{
Cell[12572, 464, 617, 19, 70, "Input",
 CellID->106801040],
Cell[13192, 485, 1976, 36, 70, "Output",
 Evaluatable->False,
 CellID->887220965]
}, Open  ]],
Cell[15183, 524, 125, 3, 70, "ExampleDelimiter",
 CellID->462449979],
Cell[15311, 529, 569, 23, 70, "ExampleText",
 CellID->51656093],
Cell[15883, 554, 412, 13, 70, "Input",
 CellID->614358491],
Cell[CellGroupData[{
Cell[16320, 571, 607, 19, 70, "Input",
 CellID->367494095],
Cell[16930, 592, 2021, 37, 70, "Output",
 Evaluatable->False,
 CellID->663130107]
}, Open  ]],
Cell[18966, 632, 125, 3, 70, "ExampleDelimiter",
 CellID->371728959],
Cell[19094, 637, 216, 8, 70, "ExampleText",
 CellID->370177670],
Cell[19313, 647, 546, 17, 70, "Input",
 CellID->4966309],
Cell[19862, 666, 411, 13, 70, "Input",
 CellID->56767047],
Cell[CellGroupData[{
Cell[20298, 683, 377, 12, 70, "Input",
 CellID->587789134],
Cell[20678, 697, 946, 30, 132, "Output",
 CellID->363460411]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21685, 734, 311, 9, 70, "SeeAlsoSection",
 CellID->22757],
Cell[21999, 745, 705, 26, 70, "SeeAlso",
 CellID->7016]
}, Open  ]],
Cell[CellGroupData[{
Cell[22741, 776, 319, 9, 70, "MoreAboutSection",
 CellID->647220570],
Cell[23063, 787, 159, 3, 70, "MoreAbout",
 CellID->16935986]
}, Open  ]],
Cell[23237, 793, 27, 0, 70, "History"],
Cell[23267, 795, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

