(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    176680,       3318]
NotebookOptionsPosition[    171950,       3169]
NotebookOutlinePosition[    173469,       3209]
CellTagsIndexPosition[    173382,       3204]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExclusionsStyle" :> 
          Documentation`HelpLookup["paclet:ref/ExclusionsStyle"], 
          "RegionFunction" :> 
          Documentation`HelpLookup["paclet:ref/RegionFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExclusionsStyle\"\>", 
       2->"\<\"RegionFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>", 
       3->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Exclusions", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Exclusions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
     " \[LineSeparator]is an option that specifies where to exclude in \
regions used by functions like ",
     Cell[BoxData[
      ButtonBox["Plot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Plot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["NIntegrate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->352143394],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["exclude nothing", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "exclude subregions associated with discontinuities", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "exclude specific points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"]}], Cell[
    "exclude a subregion defined by an equation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["lhs", "TI"], 
        StyleBox["1", "TR"]], "\[Equal]", 
       SubscriptBox[
        StyleBox["rhs", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["lhs", "TI"], 
        StyleBox["2", "TR"]], "\[Equal]", 
       SubscriptBox[
        StyleBox["rhs", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "exclude several subregions defined by equations", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["lhs", "TI"], 
          StyleBox["1", "TR"]], "\[Equal]", 
         SubscriptBox[
          StyleBox["rhs", "TI"], 
          StyleBox["1", "TR"]]}], ",", 
        SubscriptBox[
         StyleBox["ineqs", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "exclude subregions defined by equations and inequalities", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->340711823],

Cell[TextData[{
 "For a region defined by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " variables, excluded subregions must be of dimension ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "-", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->288269927],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Exclusions", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " excludes all subregions where discontinuities are found in functions being \
plotted. The discontinuities can involve either finite or infinite jumps in \
function values."
}], "Notes",
 CellID->8667924],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Exclusions", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["lhs", "TI"], 
         StyleBox["1", "TR"]], "==", 
        SubscriptBox[
         StyleBox["rhs", "TI"], 
         StyleBox["1", "TR"]]}], ",", 
       SubscriptBox[
        StyleBox["ineqs", "TI"], 
        StyleBox["1", "TR"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " excludes subregions defined by a single equation and any combination of \
inequalities."
}], "Notes",
 CellID->691302691],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Exclusions", "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["lhs", "TI"], 
         StyleBox["1", "TR"]], "==", 
        SubscriptBox[
         StyleBox["rhs", "TI"], 
         StyleBox["1", "TR"]]}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " excludes both subregions found automatically and specified explicitly."
}], "Notes",
 CellID->196691343],

Cell[TextData[{
 "For plotting functions, ",
 Cell[BoxData[
  ButtonBox["ExclusionsStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExclusionsStyle"]], "InlineFormula"],
 " specifies how to draw excluded subregions and their boundaries."
}], "Notes",
 CellID->27960227]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43612914],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->55719805],

Cell["Exclude portions of a surface where it has jumps:", "ExampleText",
 CellID->814696846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->968992524],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14148121]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1586744455],

Cell["Leave the surface entirely connected:", "ExampleText",
 CellID->650960603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ")"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1413156803],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxdmnlcVdUahsHMNE0LtRyoRNFLeimHe511H00scwhsuA7VNSq1lDS7mlRc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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmXe812UVx79flOEiNjJEpiCXveGKLC9bhoCAoMJFBGUjKHsIaJlpaZlb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        "]]]}, {}, {}, {}}, 
    Line3DBox[{346, 1, 327, 232, 16, 31, 46, 61, 76, 91, 239, 351, 106, 373, 
     255, 365, 121, 265, 136, 151, 166, 181, 196, 267, 366, 211, 344, 286, 
     212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 269, 
     367, 225, 345, 287, 210, 195, 180, 165, 150, 135, 120, 105, 90, 75, 60, 
     45, 30, 234, 347, 15, 342, 271, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 
     2, 270, 346}]},
   VertexNormals->CompressedData["
1:eJx1WXk8lVvUliSRITNJhiIZujRKzkaZo8yVSsoYKUkRmYo0m0WROWROqQyb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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-2, 2}, {-2, 2}, {-1.5537739740300374`, 1.5537739740300374`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2071297475,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1374414956],

Cell["Exclude portions of a curve where it has jumps:", "ExampleText",
 CellID->254157450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279288267],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->545187267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1875666248],

Cell["Exclude a fixed set of points:", "ExampleText",
 CellID->1410175823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"u", ",", 
        RowBox[{"Pi", "/", "10"}]}], "]"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"u", ",", 
        RowBox[{"Pi", "/", "10"}]}], "]"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"2", "Pi"}], ",", 
      RowBox[{"Pi", "/", "10"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1195528869],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69033012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1131938350],

Cell["Specify where the function is discontinuous:", "ExampleText",
 CellID->2020927786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"x", " ", "y"}], "]"}], "\[Equal]", "0"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439189180],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNnHl01UWWx0FUbLeDYARGUDDA4IY4feKIjFYQEUREoIXjxoCItizRVlGU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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHfcl+MXx+/1JSsVQoMKUTIToVBG+dkpI9GQFA0SGqgULaOMjEIlGZlF
9gwhWSmzJEWSKCslfp/3cz7fF39cz33u873u677mOZ8z7qdulz5temdJksze
NElyXd9R4X5rldtF9EyT5GPRd4vuLvoj0fuo1FWpp7Je/Ekql+m36rouEG8b
lXtFXy7e56KPF32G6Hmidy2S5A+Vd0Vvp6LXJpV4RnXe03UTlbPS4G+rcqro
Nmn07R79OVWlne4HqHwh3s4qO+rZL3WtozIojb7trfKPSmuV01X+VmmlcppK
ojrH6nKGyuuid1LpL3q82n5f9K4qv6jNdioXi75EZQf9vpvKXPEW6lpd5Q/R
v6v00++70w+VGir1k6i/o+doW4+1dxo0/TtRz52j+/dFd9P1vDTm/Frxu4o+
N43nt1DZUuVW3a/WtanKzaJ/1PUglZ9UDlY5RmWy+Ot1PZK5Ev2nri1VHlab
43S/SvQDoq8RvVR0ofFO0/0w3U/U/Y0qY1VG6P4bXRupdFadq9IYU1fRQzzW
BVrDJqUkmarn7xVvg3hHqbwpemfWR/R9uv6l69EqE0Wv07WFyvt6ZpGuu6i8
J3qeymLRP+g6WeUC1e2SxtiZx1PE21blQ/qk925U+Ur0LyrNVf6nMk59u13P
/Mp8iz5X9e/U/U2i79D1N/HXqBzqPfGzyiHeE2tVmiWxJzZ6LtupvKXn6qgM
5Fywr1QGiZ6pNi9Q++/q/gLdt2fPsk66P1PX7irPiL4wiWdniq6i0i0JHnU7
qJyvNh4Sv6Ryl8rJ4nVUeVB0oXIC50HXU3XtojKFs8CaqEwSfYqunVhTzofK
8aIzXY9zn6qKPl/Xy9hHaex37qul0cfLVWZ5DKzXVqIv9rt4B/RFKpXF76vr
uZ67fzxvrXyujnG9Tv95rrPb6eMx8dsT7HH2uujH02i3q99L27yjt8o5fqan
5+lslW1Up0cS53SU6GW67qXyqOjN0zjj03WtlMba7abrEF2vZw9pvbZXmSfe
C5zBNN4zUfvoFO3hi7QO9cUbKt4NKjty5nW9WqWG6H66DqMdzwP1XhNdO405
fEXXWmnMc01dL9V1uMr2nk/6UT2NORqs8rH6MlplP/EeVtksDbl0p3ij8uhz
4zTO4wSV59KYC/bey6K3S2Ne0zT2PntuU9FtvUY9zGMPfCB+Q5VrRH+k654q
14pukEYfx6nspHc+qTn4VLyFKnupjKSfujZSGSF6jzTmAPmwexpzQ//2T2PO
7kzibCF30Q9bq82H1OaNnGPRZ4u+TnSmOb9Pv89QOVx0SfPfWvxX9Huq0oq9
rOsT+v0llV90/5iuL6gUqp+jP9TegSovqN4a/X69rruqfCH6U10/UTlU9Neq
217tz9T9bqr/jK5LWQfRfVQ+E72p6nwm/iHICPF+zaNvzdKY+wdU3hDvapVN
VG+D+EepTPcZZJ9ybk9SO2OL0IOpzxryhHPJOhzns8m6sGZ/qq111h3T1PZ9
Kp+Kf2Qa73xKZT0yXOUh0V3V9gMqv+v+JdW9Qc/+Jvp70V8ydpVZ7u+D7BPd
/6Pfj0lDPiBPzvJvjAt5/53a6675eS4LWYu+Qd7OVZtv5yFz381C530i/rvi
jRC9vcrxevaGIvRjA13/LEI+n2y99gHjFf28rm+pVBV9UhrruIXozVWeFr2l
rseJ/4zo10VXVjlB9631riqiT0yjT+gf9G9HvedelZ/S6O/u/g29iq6tq3K5
nr1MpYXqDFYblVSOFb2S+ULWqs6L4v0o+jCVH1Saq9zN2qQx96+pzPY6MK8r
jH/mJ4Fz0OV1ktDbNXWtnPyrs9HX32eh18FLYChwEVhlofsJHrg/DVmK7HrQ
egB5Bw95gHz9LgndtK/KzdZx6DL0F3IX3Y/+au3zt8bPodu+NY/ziMxc7vp1
zeOsfpCFPkb/gqnAUej9v4zfwFjgK3AV8naRn2UMv3iP0z90ODp5vyR0MHsc
3QxWAbeADZb7nfTtELCi5cu3Hh/tfMneVrkGOahyXR5zsEj1DkhDXi3R9UCV
m5l3/b4lddPAOOAi8A9trND1sCTaoD36M15752jt+XMsm8BEYCTwFVgKrJJY
nzCnI1VvlywwELgJXATuQi+j49DH26ntrsYbnDF0PDoVPYae6ZXEuvb0b+jx
Tknob/Q+9U5KAkeBl9D36NV2XmOw3HrXB0eB65A54L0N7gNYC+yCDkAm9fG7
wXLoSnAj77zIvyGH0BPdvSaHel321tzsq7JB45meB/4D85V0zfPAigfp94NV
Ut1X5ZwaY92dBsZjLOg19DK6HlwE7kAmop/PdT/RWV083unWg+ABdDp4BbzU
3nPZw3uNtSlj+sRylr2GzOX3GtZN6G8ww+UeYy3rO3Qz+rr2f3RiI+8lsFB/
vwuMhD6n3+AW8Bs4AGwwNAkc0F1z9FIaeAIdPdDrC/Yb4H6D/cBhvHd360qe
B0sMSQIfoFvRpfS7ofc4fT0iD31zdBpYFPw5ij2Rh2xHV3IWF/n8UDhL8J5U
nZ4qF2aBycGx6HRwC/YOGABsAB64KQn8A+6gT3fYDgJD3WbchE2ErQS2Bw+A
H8ACYIK/9Y69VPqngXkGe5+BtcAqV1JH7WxU+TyLsaJ/Jrigk9BbyOYH/VtN
1a2RBx7h3MPjfeAisAbzONp46XbRh4ENSqHHd89DRhykstiyAtmODGli+T8h
D7wFfjlE14FZ6FbwFVjtKtVZI/7P6OU89PAs97We7i9W/c/pm+jGeeijWnlg
JvATOJC5Yc8cLf5RKn+L11TXg/LALfvloYMOT0M3oYPQ9eh9MAb68dc08AiY
CewDfgIbgYEeR2Ykob/QY9M9j/QTvQXGARNN5eypv70sz/tYzqOPlqjOVypt
VP6nOien4QP4WXRDP9M2DT2GfTpJ9eqLfxpzlAUmAr8NsZ5Ff4KjSqJfTkLX
o99fT0Lnz/5P/6DRs2AusB7julF1iiww4B4qPfxusAM4Ajzxlfht3IdvdD1V
5UzL8pvSkOfoauqgr19Q+y+qzDQNfgI7gaGgmeMOafgf8F2cnYZdjl/iBNVp
79/mau7ra49NEO9a0fVEnyS6o+vjE1iq+93dn68Zu8rpon/UtYHKhaL31nWg
1wKMA06aI/ootVmpFPinbxo6GRv5ojTOeD2vHViijsp+em5kGjrpStdH/56f
BpYElzyg8e2pepeK9yt4OYu2r/AeQKefqDqNxN+BOfWcf4YsEb1MpVMafVjo
/vAsOgWc8JaenZMHbhtt/sEu6Ht0Stss5pd+d3Q74B/wPvieNb06Cyx4fBpY
6h3vt/bu+xLkmujhzKvoSzRXW2mu6tG255N52Je1ScO/8Y/osyyXvlAfr80D
o+yp5/ZS+S0L3bfc87DY8gF5OM/2Aeervuhd87AdbksDJ6CXj1Abicr3vgeT
gb3KOIyx18hCJ6Kv9xd9A2dd9COih6bx7KZq+8Ms8Mpot4++PiCL/cy+7uSx
QzcWPVb0D6LbaR4GqIzhnGSBDfEDjE8Dd4FnNlf7m+VR50DVmaDrH0ngT3Q0
WBNsBJ4Dgz1mPvr3B2RwFvIfXYteRvce6/roXvTxWvNaeezwzvN4Gf+H7tth
fgaMiE00Ng+6ud+91vN3i/jVVOZjQ1j3oV+7eM8zts5eazAffQMDgGvAE+Co
tsm/dhfvZH6wx+CdaX57zxX1wahT08BUtHGLafDktDQw2WluF6wFPsOPgU8D
vMHe2Og5r5UFZgObgXHAOuCeJlm0+6OfBw+1dfvgH3isOc8ix1gr7AJ8QTWz
wH6neG/97HPWzfuB38CZ1MdnAhbF7oPHOBk7vEf8rvOSf3EY4+2cBK7t4nmA
pv+sAe2wr851n8FpHbX3O6vsqXVqqjpzvU4X6r46ujALDAWWAoeBdfD1gJ2e
SgOfgbfAqWAocPKTaehO9CbvqOx5O9fPdvHaben92N3tg9NmeC36eYxbu599
3Q5rdL6f5bkhSeCwoUngM3Aa/aXeju4nbdbws+zP77xXwTfgBLA0shc++Avf
A76D+72Pv/VzC7KoX+H/yQIXgTFeTGPsYCTwH+8a5j7TN+aMZ8BVQzyH0GUc
TzvM31D3mTZ6ZNFuPc9LVZ9lznUVr/sCn2n68EYamHCE52Q39/P2PGhwIfMC
hmaenk4DB/b3Ou7k9aXU9hzuqGef0Dve0/1Bur6dBgZ91lfw8Ry3Ay6dncaz
4NJX08DBw70fqvi9H5qPfD4Y3Z4GfqU+fQPPgwvB2WBM5rGm2wHTb+N1Zy62
8NxQZw/P29V+dqjns77nvGcWc4SdAAYF+5YxegOv141uh9+v97M3eFx7um+n
pKHX0G+Ls4htzE0CO6APwRtnSpbfVcS89fGZ2sdt7e+1aC7+12ng2pWa5wUq
u6g8LX5tlX3F/zKN+ne6b43dBjgaPH2X57OJx/KVaXByX8/tgX6eZ8HpDfSO
w/TbN37mAI+3ofiXm78ijf0PDr1c4ygkH3bTb4eKTrEbOc+6nqeyj7En86BL
cpf+TMwDwx+uZ75No/5feYwHn16idv7BJ5BGn5t7LKtMg4Ev8/yAiY8Qvdo0
Y2jmMfUT/xPRTdOIL4FxwRuXZOGXwHZoKXotbbBPs/An4Yt8Vu8f4P7tK/rV
LPrzUx7jx4fXXHQzlT9ErzMPzNspjxgMmIQ+g/PB/E3Ev0L8n3XfSvTRognE
Xek+YOvVyeIKXtpfdQZ5bL9pTi7UfM7RfSPx+4Pb2Pfi9xX/GN1vZmwO3v4r
DUyOfdFK/K2M0Y/Us0NFb+R30a1Fb63yKna/+7Nc9DKVN/Pw5Z3k/hyr36pl
cc8ex47gkeFZ2BWneI3bmN/W817FvFNNf53HfNHXlthN7g/xx7aug68P/xtY
HaxNbLGa6NuywOvcc6bwQ4LJp+RhS3Q3HwzKeSPWhA1Rlf7kgdWJLS42n3eB
WTv4XcTssA02S8IewC4gXtkuj1gpmP9Z/KkqWxaBczu6D++5HfoJPsdvWCsJ
26ab916HPOJe+Du3y8KfiC+xoWUcMgRZiw1flrXQyMwz9Ozpfn5yHn5YcDux
s866bp7EO3k3dgFxy/Pdh639W9mHSfyROOaOvq/h37u5/lrbERd7XojXsiZ3
ZGEPMe/Yjvg9sTHf11zcWITtMxI/cRE223xdR9uHjH2DjYF9sSoLfyv127od
5m11FvboTknYP+yBul6jPn7Xl6b5faHbrJeErdXLdVZm4Z/FztnU/Wcd8XX3
dR8+Vb+GlyI+iv2En75BEvZRP89D+zxi37Rzt+1i9s89Wdie7DfsE+LH+K7f
c/u7ij47j/Xmtwfz8J/gb70/C1sdemMWfjhkRcc8Yq3YQvfnETOAvk+807OI
O1yahazFV3BkFucc+YK9iW8Xew07B18udg/20kDzsduw6/i9Wx7xGuyTL82n
Tl0/y9ziNwb3gHnw00Jjez7EHlQZnIZvHt8h/vlHxDsvjzYfzsO3ONS/XeX5
eSwPGw8fI3bf1brukYQ9hF10sPsM/scHi613jelN8vBHYiPhp8QuODAJGwS/
5BFJ2InU31N0jzzi4tQHi1/rdrCp8Zlif632u5p6fkal/9q1ozxXy9y3cp0R
nqvpWdiejAVcjg8X3D4jDzsQfzX2EH5TcDU2ErZSiyTsPnzZ2B3YevipWybh
5x7rOp3Mb+I9P8B7u7OfZezYEDe5HewOfPHYOF1MM17GfovrbDB9lMeOTxxb
hv6PdR9GZeE7p68/uQ5jx34a7/rYc8QpsLO2sR2HbxzbCBsJWxl7lLEfnsQ8
UB/bsJrOXdVS1Menjv2D7YOPHF95R++H2/yux7KIo1OPOcQ/jq2NTTTRc4UN
zrMneVzjPcZDjQHw1633GjFG/Lb4gnt4TiZ7fng3Mb9OSRT8+J2TiNdgS2Mb
YvdN8Vqv97Nt3A7+/bJteq/7AI3vvmxT3udxYWtiE2IPYqtNc/u0M9VtYs8R
28Omw1ab6vaxdbBLsVmwgbCFwPzYheQbYBtizxFz6uD2p/tdxH0G+oxUMr+r
n33Qa0H9h93m5qZPM43vvoyvoU83/zHXr2K6m9t5xO0XHgtnAf85dsIAP3u/
29na4+rqdvCtX2r+DI8XPjYDNiBt0BZ+g6quz3truD51aro+7WAfYM+gW7Fx
ZrkPXLnH3tnZNPyyr5/9spOfpU7ZzuG92OyTvCfp5xN+L3YbvmbsL2xmfBzE
97k+Z5o6+NB7e1xPeA63NR+b8Tk/y7vGZBGTwPa7wFfqVPe7sBexk4h/gCVq
my7bdmCM4W6fuAb2eE+/g7Hiw345Dz82+Ah9B3YC/4DD0NGPZ5FPgd2CT4C8
mdFJxPvwjd+ShJ2B7YEd95Se7WV/AXOInQWeaWR6hOf89f/M/xzzmec3vRY7
mx7ptXjddbC9ZrtNbEbiPcR6yHfAJiWe0tN86mDzzHcd8DE+a/zVqeTSd3nE
L4hNA2Kf02VH8XcoBUZtkUfMBnrvPPwi2Aj40IinXJeEPQ2Nfd3Q8zDO/fzA
69LQNPODjT7P+wR7GnqM6893nVdsLxATYk7e9jxgd7/lMWLTLXZ95n+R38s8
L/B4L8kjFwA7jjrYV9hWvfPIoUBWPpWFXUquSO08Yh7wZ+na13bon2B4+0/f
1/W9POxSEg0Xum+Hmr5V9Bmavw6l8LFyFt7yfj5bc/tSEbYM9uByXaeI38t7
ifUlp2OB91X/PGL/zPle3icjfb7meh5YX2xD7FxyAKDvScLuW+J52COPGBLz
8GwWtiK+36dt/0I3d32ebe65os1+eeSl0OcDPM/M4RtZ2HKsEbYW2IycB+IR
Q/OIQXTSWKcWYQMSr+A34hTnijfUuR8/6jqtCP7gPPIbsDFfy8IWfDiJGBWx
tIfct5XuAzYo9im2eTPT+Knucv2Jvq70s1fZtuW9tEOcCfsajEl/wZnYxfjw
HxW9yPiX3E5suq3jmFTYY9g/yAfwNrYX9gI5n2BvbIgRGtMzpbALWN85XsPe
Pqd7p2GPr/G7rsgjx4W5GmD+ZPGvzCOXCJv54Dxic9DYqPQTm/VqveutImxL
fAU/eO1eysKPQUyOusQneBe2KDYp9vuwPOxs4l5js7CtiXsRC9tU5ZUkbHSe
fd4yk0l4NglMvsHrfpT3ADKG2OJ607N8/7TrrPdaDPKzzP/SPOxk3otfY7X5
xOCw818VPVu/v5ZHHO55XVtkEaMkV+g7rztrusrtP5eHr4SxH2U+ba7NI/65
zvXoG/urbhYxOuJ2v3sP8y7iWMSziNXhr8gsJ4ntUf9xXwvTr+fRV+aTfYIe
IU+YPC58PvhqSkXEMdlvb2fhiyDexDnCd1ERWyzCXwEfu5AcHfbVLVnk1GJP
j8vC30GcaaivrAX+jCrue8V+zMIefCePWB95UGfmYWND35yFv6Oqx1fFY7xQ
fehfRH7Ue97f9AH9Dw4AE4INwYjgN3A7uTVlmwy6ThI2BHYIts5WtheIGY00
H7y9kPNSRMzunDzsSd57Qh55ZfC3KCJOjey9OI+8N2jwPP0Bk4CLa5gGP0OD
k8GutdxnfDf4cPDr4N+p5vUljr2zz0g/veu2UuTKnJmF3YtNh223i+maqvNB
EXFQcn25Ep+9NYu4b13PZx2fHdacvD7WHVsaHw7+kvb259ROIiccHIIfdTu1
vV0pngHboPfRp/gP8EeQx46voLrnuZf52E2Fbc+vRW+tdnZSaZhEfjuxUeKh
tcX7pIh75ANjxx9IPkYd7wFywvEXEH/FZofGb4A9j41PPnwPvwsbDXsUO3Zp
EjYoNHYZ9hx2O36LTvYPgMkHmo+NSQ4DZ+SOJM4Be/uNJHx2nIU3k9CNYC/0
I3gBDISOG6JxzC5CLuyVh37F14pORjcje7EdsUWxfbAXsSGxF8eZTyzyI7cJ
HsEWI754YhJ2JPWxcbAdsWNbJpEXCk3ssr/fOyUJ3AheBCsig46wbDtf6zm4
iBwJsNgWPu+cfWjk5OwkfoP/kdr8ACyZBYZZbNm+xDq7rP+h0d111PZSlWbs
W73ryiJ8wpdY109KIncUGp8wubLURR+Bi5grMMxq9xn9W9nzTxwf/Mu4yrgG
TAZGAweA2cjPRD8c7f0zPouzBpscV3Qe/mdyCPBPqnvJ4XnoLvKC0AnolbI+
OdIyraplVIU/1vTbScg89gnz91YW+gt9Uck0eZLt/C70+NvuM9gJvx5+RfyZ
yEN8i5tb57a0HECGn2D5d4X1ziNJ4DX2IXgT3wEyrUUSPkP8qvhU2/tZwur4
co83/V0W7yK/FLsD31oV9wd/I7mmd2ZB0w4+WtrE17s8iz5ThzkGKzPPP2WB
NZAJQ421yA8py6/dfGbP8BnE54ZPCn/UPsQ8izjLiflLRDYU76ki/HG9/Cy+
Snwg+DKwnckZQiaPT8K/h48IOQM+xW4i1oMvg/rE6PG34MM6QvSsLOpwRvCR
8p7alm/4SRdYhnS2bME/1MnndJz5P/os4wMq+7e6WOaMUt8/LuK7F+RMB8sc
cv/OsowiJ4TfyQcmr4DvLH5PIp8Z3yhysimxnSJk6Urza3mMfbyXds6DZrwV
+imLuBU2H/YYthgxRPLXdklDzvT0/kEHT/B+wMbF5i3brNBXJP/awMRAsYt7
mP+U+rZZKfJMsDupg40MRrgrC983uc/4ZrcXf6LfBY0fkbVYZ5nWzXt4omn0
Krki2AvIkNqmkb3oJPyz91kOY49hiy02jVxCRl1iObPANLKaXLjeljn4b/B3
IWMnmMY3A14GN4/wWYNGhnN+eRY7CB8p+wGf4aPE5YrAWuTQdsxCJpOjj+/3
ANHH5oFrye9CJoOND7fMGWT5Q27bFZZjD6u914u4B3tf6bM/U7y3i8gdRw7d
bFlEzg+YDJlE7vyJzp9vZf4bXhcw3Fauf5P54AVww4tJyFLeBe4m7kYuX8s0
Yg7HOu7wTR64GXvpMF+RdciYayxnkLvEq1LLc8YIBn7d8/BKEvl72BvEAqer
7TlFvG9v8yerzn3ivVJEHI78QK7I8LP0kilF6BTehaw/2X1A3p1heXaH5Rhx
4DMcCwYbMWawMzqObx7AR2/q99VF5LJhO3a2/YiNBg87DXuWtUPfofuwee42
9uCMgzN/MB+dO9R7gNykR7Pw9yJ/kNvQYFHO03U+U9CcsfJZHGP+CR4Xc4tt
gr2EnkFeES/DHjzR40WWk8sHH5kMfmS/EB85xs+ip970PLDu4zTWk4uINRB3
IFf7KvdxlPsMHhnt83Ke+YzjNj33fBH7nm9QNvF3KJV1/Vv8/VW/uuhtisgv
JVY4JYtv04j5EHdhrxKv4VtH5Dx5idQD0z6YRbwG7DfFfHxl5Gotcr4WZ/cx
962R/QbskwPN53wjP561DMHGfcF7rKF9NZxH7NYXvb493D/kMHEo4qZVLP+J
d6AXkOXEJ9A7w81HR2R5fLODHCBGQ45a4yTirrQD9p7mZ4lrnO55QAfxO+8D
p/P7NLfP75Nch3gVc4KubOP6VbwnX/Tew0+CXY/c4DuPH4qwW9+1jcN+6CXe
07Z9uEdWEzPFD4WfCtnbwTqRPYYMxN+H/Oyu514rwod5ShF7iP0zrIjf4LfW
9fEi1vocXa+yD6qLrg/Z99JT1+ts69E2frFPrd+g0XHYXORk3JaEn4p1XGrZ
zv1BHjfrh3xFNuxg+XC5+awpzz3jPXCFfl9eBL7FHzgjC/nwfBZjB4uCN8HT
ZUwBDWbgOzieQZ/O8PNjjBNYd/QCe5k9XcY+93tvk0tJ3sJS0YfaBzLTcpgz
iT2PDQ+fc8QaspbIZr7rwW6v7Cv3+EOudB3W+jv7mqYl8R0u+Un4SNEX4Fds
TvzY8PGF8r0J8VRiqcSO+YaFWOTsLHxh4PBD3Ca6gHwJ+OisxX6+4luVLOK+
4JndSvEtE7iirujdi8CNfNu0h/lzXX+XJHJjuQcPL/Rv8Nlfa72XhnnMjJfv
ntcVgavJPZ3n/j+md633u/hO8WOPETyC/kP3zVCdA4vAM9/mkZdPXibft5Jb
SRyN/FFo4mh8K0S+IzG4f/TcvkX8jjDerwjZPkv03kWcx8dFNy5CtvM9Bzl/
x1tHsO7gwKNUZ3/XaWL/G3of/xo+t7LfC/pRr8kHXpfFvmd+iBXDh1e9CDmL
jCU/qFkRdmjXUuT0kwv0o961Ko/vJmeKf1ARuLFTKfKKqJ+R+1/EN5VPiG5S
BH7+qwiZjjxvVIrvh8kBJnb2kcdI7Inxgs+Jz7/nvhF/YS3Ah+Qs4KPEZtjO
60JuBPnPrDHfqZEL9KX3G/kA+EOR+evNx+e2mdqoVERO04Y8fiNvaEAe+VB8
i0gO+JFF2I9Pij6isF2WBf4mr+Ni8VuYj48BvwN5CReU4rtKziA5NYstY7Gf
sKPIBVnh9xHLwKDkSm4VOSvkr5PHwjjRx+hifHLw51kPoueww2rqXbVUluh+
NX3PI+cJe2u5+0kuyjKfEb4doD9zfVaW+dwt87igb/d76UMbvwt9Sr7JWp8X
1miNaXJC+FYBe+vePO6RV+SPkHMP9iv7m5Dn2CLYJOjJyebTPnVXmG7gZ+e7
HWwt9NetecjQXaz7Vrl9+OS8bu/3/+R5I1YDj7NMDtIKt0MeDfkn2ETfuz+1
PMZfPQ/k5pCj86n5/D8C8mS4rnGdduZD93P9WpZtyBf2+dQ86F2NDXgfepw5
W+1+YsvuUQp7tqHnE/677g/zjT+A7xmQXeB7cD/yDRtip1LsDfqA7xHMwzdB
5K7QJrbgfqWwB5n/P71XwQX418Aq68yHbmQ++IrcmL8sf/CB/e02kUnoJHJj
NpgPjd1K/S+Mczb+pw40mORE+0g/cx3aWWrZSS4+shSbHtueHJRH88gtaWK8
BM1YwI5gJvASuSvknYCvDkCWlkKuYo/Dp318fvgZh5lXMn+a+V+7PyXXwVbD
Ziu/cxP3gT5Wcj+R681KIduRYeRaIMfA73x3jZx/Ig8a2+7xPHIveLaqaex3
dMJh/pYBmx7bHoxKvgp5Jy2SuFb2eNFFx5VCHzEP8MlpwbeHjw9MgY9nK/Ox
l7f0s7xzc7/3IdeHTz4Iuud416F/8PCF4EO5079X9bOMdRuPl//5UM18+r/t
f+ps62fn5/FNHLHmtur/oaWYR741qOL6vIvvOdEd6JBWpaDRAzyHLvjd8rbi
e23V6e1vdoj1cC7QicTJuUfvE0vEBgPLgeugvzFWxA8CbiSOir8AjPeJ7/cy
/ocPDx8kObjgRuJa2JbYC2U78yfr4sbmg3fAPdiyxIDgg7UGmQ8W4iw3cZ/B
sfg3wckfuw/0h3fu7veezDdPpdC/YNs6eeBb+oafdKmx7W6u38xtlv+3AN/0
gVHx6+DfAbvin8DHwe8n51Fnb9etaRqsiuydZ3pHy+GX3X9sXuIR2OfY5vjm
DzJNTj7xJGJJzXwPjS2F3QW2J1aPDT85CZ80PnHizdj08Ikpk3fMs+hx/BP4
I/BF4L8FA7DW5dgS/iVicdi9xA/JDYCPb3as+a8moe/R++CcQboOzOO+v/vG
OhKb41tBMC04ApxBDI/+H+g6azx+cFdL8+G96vpgkmfyGCdjxM99dilsJWII
zA8Y4FvPBZiKNW/gvcq+xebE3nzONHxi9vi8mnqv1vceWOLn2fPEzak3KQnf
ETkSzAP783DvQ3J9jzDNPDFfG123heuXfTd/mN/SdS7VOC5T+V8eWIV8FPAD
fplDPHb0Fzm++M/JkSVXdgvjDepjJ1K/udt/1c8S++Z/LDRzO/iQW/m84BPC
R0bcl/gPcSAwcCuffergb4aPz5k8anJHwIrEDFubT12eYR/xnuZ+1+d5xPjh
4e9v+Z/5IVe7Yo9p3JfYn8mYiFHik8d+bWUbdq75jBv77qw8MBLzcarnBFsM
nx3yozc+PM65990p3nuc5ZN9Hi9WnStL8Rty5WDLFvy4fB+LLxc7hXwQbEzO
UVPvyYPB0aWo007X01Tq6rezxG9TCplCzOeqUuw35MBJlhvobfQ3tj9jOtPj
ZRyMh9gFsUFihOCdoWrj6lKMeZL5YDDiM+S4I7eXeB7mup02npNGfhc44QL8
ecxzHrieK9gee25AKXARfSP+2sB4m77hq366FGNmvPgGkLP4B1oW4Y9m7ZCH
PS3TwIzgSXQO+VHw+V9D6B981ugg/Na9zJ/v+jyL3id/F/8t+bbQ+POwEYhH
4oMhZkXsqiL3MYv4IhiJ/+/EM+TsTnV9xoLfhRgzPnB8Qhfk4Rcaob6PVOme
R04T342T41TxTXYe36pwhU/eU8X3KOZTB5rY5Si1MboU7SKLiGtSF98lsZkZ
xgm8B/zD/2KBj/8B3xXxVHAXfoUhecjhfcwf7n7d7r494PGCJxkn/9+AHGTO
O/ku+B+QwwNMN/MZRCbcoj7eWop3fGP+k0nYu8TAkL3kHxHXnJLEdyLco4PI
gyL+Tk4U+oU631qH4iciBoL9OqYUNix14aNbyafu7Dlv6XdxTj/JQ1/QT36n
Hv7Pbl5H9sC55jf2fuhqPjx+G2wdeoXP70zvDc4acdQ+7sPfnhP01Z/mT02C
x3zt474Mcn9auE30ch+PnXbwWeC7IK8NfY7txH4n/5f/4YXvgutY01y5J6eY
/+lxYx5YF1yI7wMc27SIM8b5usbP8o0e/x9gTB7zyX5h35CjAs7nWfKO8VcN
816iLs/gi+BbYdraz/uNOvi3eD/9wJ/AN3/X+V3kUmHHgw3ILapXhMx+Ttdn
i/BNv6DrhCLOOr7n2+1/5j3X+V1vFBGbZ/6wp7Gr+d8+/H6963xvfjP38QbP
Fd+B4SvBT4KPhfr0EczEnI/xfF7j+vyvlWs9Fmx2bHXsdP4n0kSfzWXmY8tj
v2LHlnMxoJGl2PTY9vgE8Knc7LnlfE9wO+BrcDY2Cmd/ouf5Qu8BZBcyBN8f
fj/8fOO9T77yejD2+n4Xspo27nI7d2r9JyCPuNf1DpURefwfDHjISeqPcn8W
5SETuKdN8kjQHYu8B5AV7EnGcpzfi08HmT/Me2mm9cU97k81jxE7YpHr0+b1
6ssNpX/zI/t6LcBR5BlM8tnkGwlkEt928N0+shpc/bTr9PR4GAvyDZsTuTfS
fPYVeSuTS2Hn0g5x6z183omRXGVdQPvYL9jK2Nj4e7F57/d79zJ/T8t84gHo
EXTOU+4DOoj/hYcNyP8A4NswvgsjfgrmAG/8kkfcDTmJvKyQm1nwvjG/p9us
7mfJu0Jvsn7Yrtit2I7YotiSxGOpgz7CjmYesJexN6nTIgn7EVt3jLEWOV7g
Lr47YSyNLTOnmwa/v+o64DVwG75rMBr88rdvc1wHOUJ+Hf/jAt5b5oOFsLWw
xcBOYHd8+/x/r2leC842dZC3/P8Jcg/QdeSPUP9h6xH0BzriEfeTvUE/eRe+
9A6ery62U6jfwriUmCXyCtzN/gGTI4PYA4M9D494Td9xO9tb1vH/zhgf19mm
ya9jnOQUwaP9Vzz2N81f7PqvuM4b7gO/M/9zkn/XnjgghTxG7CNkGPJof8vt
j30GF5hGhiMPwcTIPf43C/fIxsHmP2l5Mt97if/hQO4xOpfr+6bJi+N+vLEN
saWKnD0/A5/YI/xLrIt5Fh2NHPrC/SQnktzII31OOcvYRKzL2Z5PbDRygrG5
+J9krCvYgHXinvyxzz0W+s+ZZK/wjR54BB2PPuX3T13nAe8l6iLvmSP0asU1
Dxmz0Hzm7cM8dDn6l7gx8WPiR/CgiSMjCxd5ztEVYHdk1ErTtI8P/gfXQVZD
7+rrKtdhnZf7LCAbwdbgaeQAuaSs91fmIzPb+D5Pwl/9lfnsH/bTa17/VX4v
1x/9Lvq10uPFFkDmbOs1Yi+h53p6P6BfGO+HHnsfzwljH+2xowuIQ+EfxyeO
rY2uxRZb4HfxXnTv9957Fd/+5mGPr/Dz04yLVpheVUROADb9L0XkSeB34TvR
LfytKDmumxSBqciL5f/7kDM7RL9XFv+0PP7fSd8iYuPgZGII6LLx4tcQf3ge
7/3b/afwP5ew67n+Zfpa1a+i+ufrfmfR1xSRg0DOPu+9N4nYxM8e4/6l+B5y
mjHJGu/Fn01TB3xFHjBYvbXqDywijt2cuEzJflVdvyxCn1QRXbUIeU5MhP6B
LbcXv1sReJv5X+/26Ru4k/k5oIgYT8X/MNF1Wim+P8AvNdO+qT6uz3kn3sI7
aH9KKf7HGf5gflvn8ZK7emkR+V/8n8l1ftdY8bfV/aV55JZeVkQuz0bPM20y
Dz9ZDkBv8P160/S/mp5tX4QfrPwbWJHv47cvIl/jJtHjSoGjG+j6URH2+qc+
O5z9W4v4ny/oNfbcP25nU8eVKuJHRdyzNzbx3socc6pkPnsLHutFGxi87A38
W/94n2DLIyuRh/WLyBnCz8/YN3N7fJfA/6bET3JPEf+/AJ9ea+uMN60joCtb
xtImspT4KrFP4p7EFYlBElukL6njUly5Z6zHliIOWs9YblPHB3uId14RcWn+
lxT/fwq9/LtpxrhGv/9cRHyYtWWN/7A8Ym6R5Wstp5hn8tp/dTvIiJLP5gzz
mb/fvOfRj7TF/+eCjwxI3efyOWFvsBa528l93jPzCvMzrxd5YkvdH/p4r8bY
pohYBN9M8/83iQc9WUReMr4K4oHEC4kJDkQmlAKHfi/+iiJyBB4Qr0MRvsDF
7IUi/OVPFJGfTezroiLyDJCTG3Tdqgj8P6OIHEdiX3yDQj4EuRDkzw4qwj9E
/ju5EehT8tPJ1cBX8zl7s4i8GL7pIa8Cv+tjReRb4Kf6VteXi9BRfdTPX4uw
6SfhXy8ilkVcZZZjK8fremcR+UeDkRulwFz34AssIh64soj/cwrW7if+I0X4
bc8pxXdH4KObi8gFARe1FW9ZEXb5PF3fLSIHcHIR88Kc/B8ALXwn
         "]], PolygonBox[CompressedData["
1:eJwtlnnUVlMYxe/73nOwVItKGlZU31c0qpBmpVHDlwZKmiNNNGlSCc0aadCc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         "]]}]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJztfHlUjtsbdpQIZapMmYeMmSpl6CZKQhSKJEM6MqWB0CSlkEQkogzJUKYo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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1116857738,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExclusionsStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExclusionsStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Exclusions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Exclusions"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->84999413],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->115690447],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->471753317],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->169174122],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->164661128]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exclusions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 38.5444830}", "context" -> "System`", 
    "keywords" -> {
     "singular points", "singular curves", "discontinuity points", 
      "discontinuity curves", "exclusion points", "exclusion curves", 
      "branch cuts", "branch cut points", "branch cut curves", "pole points", 
      "pole curves", "jump points", "jump curves"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Exclusions is an option that specifies where to exclude in regions used \
by functions like Plot, Plot3D and NIntegrate.", "synonyms" -> {}, "title" -> 
    "Exclusions", "type" -> "Symbol", "uri" -> "ref/Exclusions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10251, 318, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->43612914]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 173239, 3197}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1931, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2554, 72, 1575, 37, 70, "ObjectNameGrid"],
Cell[4132, 111, 905, 29, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5074, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5552, 162, 73, 1, 70, "Notes",
 CellID->352143394],
Cell[5628, 165, 2349, 68, 70, "2ColumnTableMod",
 CellID->340711823],
Cell[7980, 235, 285, 10, 70, "Notes",
 CellID->288269927],
Cell[8268, 247, 379, 10, 70, "Notes",
 CellID->8667924],
Cell[8650, 259, 619, 21, 70, "Notes",
 CellID->691302691],
Cell[9272, 282, 662, 21, 70, "Notes",
 CellID->196691343],
Cell[9937, 305, 277, 8, 70, "Notes",
 CellID->27960227]
}, Closed]],
Cell[CellGroupData[{
Cell[10251, 318, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43612914],
Cell[CellGroupData[{
Cell[10635, 332, 147, 5, 70, "ExampleSection",
 CellID->55719805],
Cell[10785, 339, 92, 1, 70, "ExampleText",
 CellID->814696846],
Cell[CellGroupData[{
Cell[10902, 344, 516, 17, 28, "Input",
 CellID->968992524],
Cell[11421, 363, 22639, 375, 173, "Output",
 Evaluatable->False,
 CellID->14148121]
}, Open  ]],
Cell[34075, 741, 126, 3, 70, "ExampleDelimiter",
 CellID->1586744455],
Cell[34204, 746, 80, 1, 70, "ExampleText",
 CellID->650960603],
Cell[CellGroupData[{
Cell[34309, 751, 538, 17, 70, "Input",
 CellID->1413156803],
Cell[34850, 770, 41253, 688, 172, 20102, 337, "CachedBoxData", "BoxData", \
"Output",
 CellID->2071297475]
}, Open  ]],
Cell[76118, 1461, 126, 3, 70, "ExampleDelimiter",
 CellID->1374414956],
Cell[76247, 1466, 90, 1, 70, "ExampleText",
 CellID->254157450],
Cell[CellGroupData[{
Cell[76362, 1471, 308, 9, 28, "Input",
 CellID->279288267],
Cell[76673, 1482, 5353, 92, 183, "Output",
 Evaluatable->False,
 CellID->545187267]
}, Open  ]],
Cell[82041, 1577, 126, 3, 70, "ExampleDelimiter",
 CellID->1875666248],
Cell[82170, 1582, 74, 1, 70, "ExampleText",
 CellID->1410175823],
Cell[CellGroupData[{
Cell[82269, 1587, 746, 24, 47, "Input",
 CellID->1195528869],
Cell[83018, 1613, 8935, 151, 198, "Output",
 Evaluatable->False,
 CellID->69033012]
}, Open  ]],
Cell[91968, 1767, 126, 3, 70, "ExampleDelimiter",
 CellID->1131938350],
Cell[92097, 1772, 88, 1, 70, "ExampleText",
 CellID->2020927786],
Cell[CellGroupData[{
Cell[92210, 1777, 594, 19, 70, "Input",
 CellID->439189180],
Cell[92807, 1798, 76440, 1267, 204, 38128, 635, "CachedBoxData", "BoxData", \
"Output",
 CellID->1116857738]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[169308, 3072, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[169627, 3083, 481, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[170145, 3105, 305, 8, 70, "RelatedLinksSection"],
Cell[170453, 3115, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170855, 3132, 318, 9, 70, "MoreAboutSection",
 CellID->84999413],
Cell[171176, 3143, 143, 3, 70, "MoreAbout",
 CellID->115690447],
Cell[171322, 3148, 174, 3, 70, "MoreAbout",
 CellID->471753317],
Cell[171499, 3153, 197, 4, 70, "MoreAbout",
 CellID->169174122],
Cell[171699, 3159, 179, 3, 70, "MoreAbout",
 CellID->164661128]
}, Open  ]],
Cell[171893, 3165, 27, 0, 70, "History"],
Cell[171923, 3167, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

