(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    115718,       3152]
NotebookOptionsPosition[    104767,       2753]
NotebookOutlinePosition[    106039,       2789]
CellTagsIndexPosition[    105952,       2784]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpIntegralEi" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralEi"], "Erf" :> 
          Documentation`HelpLookup["paclet:ref/Erf"], "LogIntegral" :> 
          Documentation`HelpLookup["paclet:ref/LogIntegral"], "SinIntegral" :> 
          Documentation`HelpLookup["paclet:ref/SinIntegral"], "CosIntegral" :> 
          Documentation`HelpLookup["paclet:ref/CosIntegral"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExpIntegralEi\"\>", 
       2->"\<\"Erf\"\>", 3->"\<\"LogIntegral\"\>", 4->"\<\"SinIntegral\"\>", 
       5->"\<\"CosIntegral\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExpIntegralE", "ObjectName",
 CellID->17252],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExpIntegralE",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExpIntegralE"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the exponential integral function ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["E", "TI"], 
        StyleBox["n", "TI"]], 
       RowBox[{"(", 
        StyleBox["z", "TI"], ")"}]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["E", "TI"], 
    StyleBox["n", "TI"]], 
   RowBox[{"(", 
    StyleBox["z", "TI"], ")"}], "=", 
   SubsuperscriptBox["\[Integral]", "1", "\[Infinity]"], 
   SuperscriptBox[
    StyleBox["e", "TI"], 
    RowBox[{"-", 
     StyleBox["z", "TI"], 
     StyleBox["t", "TI"]}]], "/", 
   SuperscriptBox[
    StyleBox["t", "TI"], 
    StyleBox["n", "TI"]], "\[DifferentialD]", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30633],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpIntegralE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralE"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4202],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ExpIntegralE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->448295045],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42293670],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->40827151],

Cell["Evaluate numerically:", "ExampleText",
 CellID->14361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{"3", ",", " ", "5.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6380],

Cell[BoxData["0.0004987707676755094`"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ExpIntegralE", "[", 
      RowBox[{"n", ",", " ", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18361],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86173873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"n", ",", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27988],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "n"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "-", "n"}], "]"}], "x"], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "x", "]"}], "6"],
       SeriesData[x, 0, {}, -1, 6, 1],
       Editable->False]}],
     SeriesData[x, 0, {
       Gamma[1 - n]}, -1, 6, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"1", "-", "n"}]]}], "+", 
     FractionBox["x", 
      RowBox[{"2", "-", "n"}]], "-", 
     FractionBox[
      SuperscriptBox["x", "2"], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", "n"}], ")"}]}]], "+", 
     FractionBox[
      SuperscriptBox["x", "3"], 
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", "n"}], ")"}]}]], "-", 
     FractionBox[
      SuperscriptBox["x", "4"], 
      RowBox[{"24", " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", "n"}], ")"}]}]], "+", 
     FractionBox[
      SuperscriptBox["x", "5"], 
      RowBox[{"120", " ", 
       RowBox[{"(", 
        RowBox[{"6", "-", "n"}], ")"}]}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "6"],
      SeriesData[x, 0, {}, 0, 6, 1],
      Editable->False]}],
    SeriesData[
    x, 0, {(-1)/(1 - n), (2 - n)^(-1), Rational[-1, 2]/(3 - n), 
      Rational[1, 6]/(4 - n), Rational[-1, 24]/(5 - n), Rational[1, 120]/(6 - 
      n)}, 0, 6, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{444, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16891]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7196],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->19750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"3", ",", 
     RowBox[{"22", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21064],

Cell[BoxData["0.\
02352065664827650000783171991176462591531261051651894241561399983526801232494`\
50."], "Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26578]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->12112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{"3", ",", "2.20000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7088],

Cell[BoxData["0.0235206566482765000078317307020998594905569276842016884656`20.\
002222285073866"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15479]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23842],

Cell["Complex arguments:", "ExampleText",
 CellID->5137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"ExpIntegralE", "[", 
   RowBox[{
    RowBox[{"1", "+", "I"}], ",", 
    RowBox[{"2", "+", 
     RowBox[{"3", "I"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32416],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.018943830508373883`"}], "+", 
  RowBox[{"0.020443770102829883`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16971]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6388],

Cell["Infinite arguments give exact results:", "ExampleText",
 CellID->27881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{"0", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29289],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17523],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFormula"],
 " threads element-wise over lists and arrays:"
}], "ExampleText",
 CellID->28846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{"0", ",", " ", 
   RowBox[{"{", 
    RowBox[{"2.", ",", "3.", ",", "5.", ",", "7.", ",", "11."}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.06766764161830635`", ",", "0.016595689455954646`", ",", 
   "0.0013475893998170934`", ",", "0.00013026885222207376`", ",", 
   "1.5183364354768783`*^-6"}], "}"}]], "Output",
 ImageSize->{421, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13180]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->9898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{"2", ",", 
   RowBox[{"1", "+", "x", "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->607],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"2", ",", "1"}], "]"}], "-", 
   RowBox[{
    RowBox[{"ExpIntegralE", "[", 
     RowBox[{"1", ",", "1"}], "]"}], " ", "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "\[ExponentialE]"}]], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"ExpIntegralE", "[", 
        RowBox[{"1", ",", "1"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "\[ExponentialE]"}]], "-", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"ExpIntegralE", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    ExpIntegralE[2, 1], -ExpIntegralE[1, 1], Rational[1, 2]/E + 
    Rational[-1, 2] ExpIntegralE[1, 1], Rational[1, 2]/E + 
    Rational[-1, 6] ExpIntegralE[-1, 1]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{479, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25395]
}, Open  ]],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->5516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11768],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "z"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", "z"], "-", 
     RowBox[{"n", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", 
        SuperscriptBox["n", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "3"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "n"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["n", "2"]}], "-", 
        SuperscriptBox["n", "3"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "4"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "n"}], "+", 
        RowBox[{"11", " ", 
         SuperscriptBox["n", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["n", "3"]}], "+", 
        SuperscriptBox["n", "4"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "5"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], "6"],
      SeriesData[$CellContext`z, 
       DirectedInfinity[1], {}, 1, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {
     1, -$CellContext`n, $CellContext`n + $CellContext`n^2, (-2) \
$CellContext`n - 3 $CellContext`n^2 - $CellContext`n^3, 6 $CellContext`n + 
      11 $CellContext`n^2 + 6 $CellContext`n^3 + $CellContext`n^4}, 1, 6, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{571, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3195]
}, Open  ]],

Cell["Give the result for an arbitrary symbolic direction:", "ExampleText",
 CellID->5898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"DirectedInfinity", "[", "w", "]"}], ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27850],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{378, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->34358002]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30959],

Cell["Plot over the complex plane:", "ExampleText",
 CellID->19492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ExpIntegralE", "[", 
     RowBox[{
      RowBox[{"-", "3"}], ",", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32585],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725572980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28694],

Cell["\<\
Solution of the heat equation for piecewise\[Hyphen]constant initial \
conditions: \
\>", "ExampleText",
 CellID->17293],

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"T0", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "x1"}], ")"}], " ", 
       RowBox[{"ExpIntegralE", "[", 
        RowBox[{
         FractionBox["1", "2"], ",", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "x1"}], ")"}], "2"], 
          RowBox[{"4", " ", "\[Alpha]", " ", "t", " "}]]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "x"}], "+", "x2"}], ")"}], " ", 
       RowBox[{"ExpIntegralE", "[", 
        RowBox[{
         FractionBox["1", "2"], ",", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "x2"}], ")"}], "2"], 
          RowBox[{"4", "\[Alpha]", " ", "t", " "}]]}], "]"}]}]}], ")"}]}], 
   RowBox[{"4", " ", 
    SqrtBox["\[Pi]"], " ", 
    SqrtBox[
     RowBox[{"\[Alpha]", " ", "t", " "}]]}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11955],

Cell["Check that the solution satisfies the heat equation: ", "ExampleText",
 CellID->20431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "==", 
   RowBox[{"\[Alpha]", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}]}], " ", "//",
   " ", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19262],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26967]
}, Open  ]],

Cell["Plot the solution for different times: ", "ExampleText",
 CellID->6092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"x", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}]}], "]"}], ",", 
       RowBox[{"T", "[", 
        RowBox[{"x", ",", "0.5"}], "]"}], ",", 
       RowBox[{"T", "[", 
        RowBox[{"x", ",", "1"}], "]"}], ",", 
       RowBox[{"T", "[", 
        RowBox[{"x", ",", "2"}], "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1", "->", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{"x2", "->", "1"}], ",", 
       RowBox[{"T0", "->", "1"}], ",", 
       RowBox[{"\[Alpha]", "->", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1121],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->559356760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2982],

Cell["Calculate a classic asymptotic series:", "ExampleText",
 CellID->8566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", "z"}], "]"}], "  ", 
    RowBox[{"ExpIntegralE", "[", 
     RowBox[{"1", ",", 
      RowBox[{"1", "/", "z"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "12"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22746],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "-", 
   SuperscriptBox["z", "2"], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "3"]}], "-", 
   RowBox[{"6", " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{"24", " ", 
    SuperscriptBox["z", "5"]}], "-", 
   RowBox[{"120", " ", 
    SuperscriptBox["z", "6"]}], "+", 
   RowBox[{"720", " ", 
    SuperscriptBox["z", "7"]}], "-", 
   RowBox[{"5040", " ", 
    SuperscriptBox["z", "8"]}], "+", 
   RowBox[{"40320", " ", 
    SuperscriptBox["z", "9"]}], "-", 
   RowBox[{"362880", " ", 
    SuperscriptBox["z", "10"]}], "+", 
   RowBox[{"3628800", " ", 
    SuperscriptBox["z", "11"]}], "-", 
   RowBox[{"39916800", " ", 
    SuperscriptBox["z", "12"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "13"],
    SeriesData[$CellContext`z, 0, {}, 1, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, -1, 2, -6, 24, -120, 720, -5040, 
   40320, -362880, 3628800, -39916800}, 1, 13, 1],
  Editable->False]], "Output",
 ImageSize->{372, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299955590]
}, Open  ]],

Cell["\<\
Plot the difference of a truncated series and the exponential integral sum:\
\>", "ExampleText",
 CellID->5669],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]", "[", 
   RowBox[{"z_", ",", "o_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", "n"}], " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "!"}], 
       RowBox[{
        RowBox[{"(", "z", ")"}], "^", "n"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "o"}], "}"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", "z"}], "]"}], "  ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "z"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"Abs", "[", 
        RowBox[{"\[Delta]", "[", 
         RowBox[{"z", ",", "o"}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"o", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0.1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30808],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->249601993]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22001],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify exponential integrals:"
}], "ExampleText",
 CellID->19780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"3", ",", "z"}], "]"}], "+", 
   RowBox[{
    RowBox[{"z", "/", "2"}], 
    RowBox[{"ExpIntegralE", "[", 
     RowBox[{"2", ",", "z"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5928],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "z"}]], "2"]], "Output",
 ImageSize->{26, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13574],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express special cases in simpler functions:"
}], "ExampleText",
 CellID->2624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"FunctionExpand", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ExpIntegralE", "[", 
       RowBox[{
        RowBox[{"5", "/", "2"}], ",", "z"}], "]"}], ",", " ", 
      RowBox[{"ExpIntegralE", "[", 
       RowBox[{"4", ",", "z"}], "]"}], ",", " ", 
      RowBox[{"ExpIntegralE", "[", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "z"}], "]"}]}], "}"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "z"}]], " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"4", " ", "z"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", "z"], " ", 
       SqrtBox["\[Pi]"], " ", 
       SuperscriptBox["z", 
        RowBox[{"3", "/", "2"}]]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", "z"], " ", 
       SqrtBox["\[Pi]"], " ", 
       SuperscriptBox["z", 
        RowBox[{"3", "/", "2"}]], " ", 
       RowBox[{"Erf", "[", 
        SqrtBox["z"], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "z"}]], " ", 
    RowBox[{"(", 
     RowBox[{"4", "-", 
      RowBox[{"2", " ", "z"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", "z"], " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"ExpIntegralEi", "[", 
        RowBox[{"-", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "z"], " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"-", 
         FractionBox["1", "z"]}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "z"], " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"-", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", "z"], " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"Log", "[", "z", "]"}]}]}], ")"}]}], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "z"}]], " ", 
     RowBox[{"(", 
      RowBox[{"24", "+", 
       RowBox[{"24", " ", "z"}], "+", 
       RowBox[{"12", " ", 
        SuperscriptBox["z", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "3"]}], "+", 
       SuperscriptBox["z", "4"]}], ")"}]}], 
    SuperscriptBox["z", "5"]]}], "}"}]], "Output",
 ImageSize->{571, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18690],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->15416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ExpIntegralE", "[", 
      RowBox[{"1", ",", "z"}], "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"ExpIntegralE", "[", 
       RowBox[{"2", ",", 
        RowBox[{"z", "+", "2"}]}], "]"}]}], "+", "z"}], "\[Equal]", "2"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "1.9546740959063138`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9084],

Cell["Generate from integrals, sums, and differential equations:", \
"ExampleText",
 CellID->9658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "z"}], " ", "t"}], "]"}], " ", 
    RowBox[{"t", "^", 
     RowBox[{"-", "n"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"z", ">", "0"}], "&&", 
     RowBox[{"n", "<", "1"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4163],

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{"n", ",", "z"}], "]"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23368]
}, Open  ]],

Cell[CellGroupData[{

Cell["FullSimplify[n! z^(-n-1) Exp[-z] Sum[z^k/k!, {k, 0, n}]]", "Input",
 CellLabel->"In[2]:=",
 CellID->32517],

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{
   RowBox[{"-", "n"}], ",", "z"}], "]"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22363]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Nu]", "+", "1", "-", "x"}], ")"}], 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], " ", "//", " ", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "2", "]"}], "-", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"-", "\[Nu]"}]], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"ExpIntegralE", "[", 
       RowBox[{
        RowBox[{"1", "+", "\[Nu]"}], ",", 
        RowBox[{"-", "x"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{319, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17062],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFormula"],
 " appears as special cases of hypergeometric functions: "
}], "ExampleText",
 CellID->30041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", "-", "\[Nu]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", "-", "\[Nu]"}], "}"}], ",", 
      RowBox[{"-", "z"}]}], "]"}], ",", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "\[Nu]", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "0", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Nu]", "-", "1"}], "}"}]}], "}"}], ",", "z"}], "]"}]}], 
   "}"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7306],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}], " ", 
     RowBox[{"ExpIntegralE", "[", 
      RowBox[{"\[Nu]", ",", "z"}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["z", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"2", "-", "\[Nu]"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ExpIntegralE", "[", 
      RowBox[{"\[Nu]", ",", "z"}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["z", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "-", "\[Nu]"}], "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{573, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22922],

Cell["Integrals:", "ExampleText",
 CellID->127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"\[Nu]", ",", " ", "z"}], "]"}], ",", " ", "z"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->29414],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ExpIntegralE", "[", 
   RowBox[{
    RowBox[{"1", "+", "\[Nu]"}], ",", "z"}], "]"}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13047],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->9801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "ExpIntegralE", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5778],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "Protected", ",", 
   "ReadProtected"}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29033]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"ExpIntegralE", "[", 
   RowBox[{"2", ",", 
    RowBox[{"2", "+", "E"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32387],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23625]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23018],

Cell["\<\
Large arguments can give results too large to be computed explicitly:\
\>", "ExampleText",
 CellID->27034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{"2", ",", 
   RowBox[{"-", 
    RowBox[{"10.", "^", "10"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30852],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->348894891],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->650630610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23240],

Cell["\<\
Machine number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->19122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralE", "[", 
  RowBox[{"2", ",", 
   RowBox[{"10.", "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28549],

Cell[BoxData["5.0658373142905056619318173319417314`15.954589770191005*^-438"],\
 "Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->489689800]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17798],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133636963]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18996],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     ButtonBox["E",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/E"], 
     StyleBox["n", "TI"]], 
    RowBox[{"(", 
     StyleBox["z", "TI"], ")"}]}], TraditionalForm]],
  GeneratedCell->False,
  CellAutoOverwrite->False],
 " is not automatically interpreted as an exponential integral:"
}], "ExampleText",
 CellID->17693],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["E", "n"], "(", "z", ")"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[1]:=",
 CellID->13461],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ExponentialE]", "n"], "[", "z", "]"}]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12167]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17370],

Cell[TextData[{
 "Plot the Riemann surface of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["E", 
     RowBox[{"1", "/", "2"}]], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->19360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", "=", 
     RowBox[{"10", "^", 
      RowBox[{"-", "8"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
          RowBox[{"r", " ", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
          RowBox[{"Re", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Sqrt", "[", "Pi", "]"}], 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"Erf", "[", 
                 RowBox[{
                  RowBox[{"Sqrt", "[", "r", "]"}], " ", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", " ", 
                    RowBox[{"\[Phi]", "/", "2"}]}], "]"}]}], "]"}]}], ")"}]}],
              ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Sqrt", "[", "r", "]"}], " ", 
              RowBox[{"Exp", "[", 
               RowBox[{"I", " ", 
                RowBox[{"\[Phi]", "/", "2"}]}], "]"}]}], ")"}]}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "\[Epsilon]", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Phi]", ",", 
          RowBox[{"k", " ", "Pi", " ", "\[Epsilon]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "Pi"}], " ", "-", 
           "\[Epsilon]"}]}], "}"}], ",", " ", 
        RowBox[{"PlotRange", " ", "->", " ", 
         RowBox[{"{", 
          RowBox[{"All", ",", " ", "All", ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "5"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25213],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{136, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->447249587]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1529],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralEi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralEi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SinIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CosIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CosIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28632]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7951],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->13526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->2316],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ExpIntegralE.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/ExpIntegralE/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->614200569],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->980777554],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->920100]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpIntegralE - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 48.6853676}", "context" -> "System`", 
    "keywords" -> {"en-function", "expint", "exponential integral"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ExpIntegralE[n, z] gives the exponential integral function E_n (z). ", 
    "synonyms" -> {"exp integral e"}, "title" -> "ExpIntegralE", "type" -> 
    "Symbol", "uri" -> "ref/ExpIntegralE"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6206, 212, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->42293670]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 105810, 2777}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2362, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2985, 82, 50, 1, 70, "ObjectName",
 CellID->17252],
Cell[3038, 85, 749, 25, 70, "Usage",
 CellID->14073]
}, Open  ]],
Cell[CellGroupData[{
Cell[3824, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4302, 132, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4425, 138, 521, 20, 70, "Notes",
 CellID->30633],
Cell[4949, 160, 520, 19, 70, "Notes",
 CellID->4202],
Cell[5472, 181, 256, 8, 70, "Notes",
 CellID->448295045],
Cell[5731, 191, 226, 7, 70, "Notes",
 CellID->31226],
Cell[5960, 200, 209, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6206, 212, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42293670],
Cell[CellGroupData[{
Cell[6590, 226, 147, 5, 70, "ExampleSection",
 CellID->40827151],
Cell[6740, 233, 60, 1, 70, "ExampleText",
 CellID->14361],
Cell[CellGroupData[{
Cell[6825, 238, 133, 4, 28, "Input",
 CellID->6380],
Cell[6961, 244, 175, 5, 36, "Output",
 CellID->19357]
}, Open  ]],
Cell[7151, 252, 121, 3, 70, "ExampleDelimiter",
 CellID->12860],
Cell[CellGroupData[{
Cell[7297, 259, 363, 12, 28, "Input",
 CellID->18361],
Cell[7663, 273, 4746, 82, 165, "Output",
 Evaluatable->False,
 CellID->86173873]
}, Open  ]],
Cell[12424, 358, 121, 3, 70, "ExampleDelimiter",
 CellID->22356],
Cell[CellGroupData[{
Cell[12570, 365, 250, 8, 70, "Input",
 CellID->27988],
Cell[12823, 375, 1762, 60, 86, "Output",
 CellID->16891]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14634, 441, 215, 7, 70, "ExampleSection",
 CellID->7196],
Cell[14852, 450, 66, 1, 70, "ExampleText",
 CellID->19750],
Cell[CellGroupData[{
Cell[14943, 455, 210, 7, 70, "Input",
 CellID->21064],
Cell[15156, 464, 241, 7, 36, "Output",
 CellID->26578]
}, Open  ]],
Cell[15412, 474, 109, 3, 70, "ExampleText",
 CellID->12112],
Cell[CellGroupData[{
Cell[15546, 481, 150, 4, 70, "Input",
 CellID->7088],
Cell[15699, 487, 235, 6, 36, "Output",
 CellID->15479]
}, Open  ]],
Cell[15949, 496, 121, 3, 70, "ExampleDelimiter",
 CellID->23842],
Cell[16073, 501, 56, 1, 70, "ExampleText",
 CellID->5137],
Cell[CellGroupData[{
Cell[16154, 506, 227, 8, 70, "Input",
 CellID->32416],
Cell[16384, 516, 270, 8, 36, "Output",
 CellID->16971]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16703, 530, 238, 7, 70, "ExampleSection",
 CellID->6388],
Cell[16944, 539, 77, 1, 70, "ExampleText",
 CellID->27881],
Cell[CellGroupData[{
Cell[17046, 544, 134, 4, 70, "Input",
 CellID->29289],
Cell[17183, 550, 152, 5, 36, "Output",
 CellID->573]
}, Open  ]],
Cell[17350, 558, 121, 3, 70, "ExampleDelimiter",
 CellID->17523],
Cell[17474, 563, 225, 7, 70, "ExampleText",
 CellID->28846],
Cell[CellGroupData[{
Cell[17724, 574, 220, 7, 70, "Input",
 CellID->31639],
Cell[17947, 583, 345, 10, 39, "Output",
 CellID->13180]
}, Open  ]],
Cell[18307, 596, 121, 3, 70, "ExampleDelimiter",
 CellID->11168],
Cell[18431, 601, 212, 7, 70, "ExampleText",
 CellID->9898],
Cell[CellGroupData[{
Cell[18668, 612, 276, 9, 70, "Input",
 CellID->607],
Cell[18947, 623, 1377, 43, 68, "Output",
 CellID->25395]
}, Open  ]],
Cell[20339, 669, 67, 1, 70, "ExampleText",
 CellID->5516],
Cell[CellGroupData[{
Cell[20431, 674, 252, 8, 70, "Input",
 CellID->11768],
Cell[20686, 684, 1867, 59, 52, "Output",
 CellID->3195]
}, Open  ]],
Cell[22568, 746, 90, 1, 70, "ExampleText",
 CellID->5898],
Cell[CellGroupData[{
Cell[22683, 751, 294, 10, 70, "Input",
 CellID->27850],
Cell[22980, 763, 2432, 44, 70, "Output",
 Evaluatable->False,
 CellID->34358002]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25461, 813, 223, 7, 70, "ExampleSection",
 CellID->30959],
Cell[25687, 822, 67, 1, 70, "ExampleText",
 CellID->19492],
Cell[CellGroupData[{
Cell[25779, 827, 465, 16, 70, "Input",
 CellID->32585],
Cell[26247, 845, 22917, 380, 70, "Output",
 Evaluatable->False,
 CellID->725572980]
}, Open  ]],
Cell[49179, 1228, 121, 3, 70, "ExampleDelimiter",
 CellID->28694],
Cell[49303, 1233, 130, 4, 70, "ExampleText",
 CellID->17293],
Cell[49436, 1239, 1094, 36, 70, "Input",
 CellID->11955],
Cell[50533, 1277, 92, 1, 70, "ExampleText",
 CellID->20431],
Cell[CellGroupData[{
Cell[50650, 1282, 406, 14, 70, "Input",
 CellID->19262],
Cell[51059, 1298, 157, 5, 36, "Output",
 CellID->26967]
}, Open  ]],
Cell[51231, 1306, 77, 1, 70, "ExampleText",
 CellID->6092],
Cell[CellGroupData[{
Cell[51333, 1311, 863, 28, 70, "Input",
 CellID->1121],
Cell[52199, 1341, 5515, 94, 70, "Output",
 Evaluatable->False,
 CellID->559356760]
}, Open  ]],
Cell[57729, 1438, 120, 3, 70, "ExampleDelimiter",
 CellID->2982],
Cell[57852, 1443, 76, 1, 70, "ExampleText",
 CellID->8566],
Cell[CellGroupData[{
Cell[57953, 1448, 428, 14, 70, "Input",
 CellID->22746],
Cell[58384, 1464, 1162, 36, 54, "Output",
 CellID->299955590]
}, Open  ]],
Cell[59561, 1503, 121, 3, 70, "ExampleText",
 CellID->5669],
Cell[59685, 1508, 741, 26, 70, "Input",
 CellID->17155],
Cell[CellGroupData[{
Cell[60451, 1538, 471, 15, 70, "Input",
 CellID->30808],
Cell[60925, 1555, 6455, 110, 70, "Output",
 Evaluatable->False,
 CellID->249601993]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67429, 1671, 233, 7, 70, "ExampleSection",
 CellID->22001],
Cell[67665, 1680, 225, 8, 70, "ExampleText",
 CellID->19780],
Cell[CellGroupData[{
Cell[67915, 1692, 302, 10, 70, "Input",
 CellID->5928],
Cell[68220, 1704, 230, 8, 52, "Output",
 CellID->8018]
}, Open  ]],
Cell[68465, 1715, 121, 3, 70, "ExampleDelimiter",
 CellID->13574],
Cell[68589, 1720, 240, 8, 70, "ExampleText",
 CellID->2624],
Cell[CellGroupData[{
Cell[68854, 1732, 496, 16, 70, "Input",
 CellID->9408],
Cell[69353, 1750, 2231, 68, 117, "Output",
 CellID->12068]
}, Open  ]],
Cell[71599, 1821, 121, 3, 70, "ExampleDelimiter",
 CellID->18690],
Cell[71723, 1826, 92, 1, 70, "ExampleText",
 CellID->15416],
Cell[CellGroupData[{
Cell[71840, 1831, 441, 15, 70, "Input",
 CellID->7251],
Cell[72284, 1848, 222, 7, 36, "Output",
 CellID->6717]
}, Open  ]],
Cell[72521, 1858, 120, 3, 70, "ExampleDelimiter",
 CellID->9084],
Cell[72644, 1863, 98, 2, 70, "ExampleText",
 CellID->9658],
Cell[CellGroupData[{
Cell[72767, 1869, 467, 16, 70, "Input",
 CellID->4163],
Cell[73237, 1887, 216, 7, 36, "Output",
 CellID->23368]
}, Open  ]],
Cell[CellGroupData[{
Cell[73490, 1899, 112, 2, 70, "Input",
 CellID->32517],
Cell[73605, 1903, 235, 8, 36, "Output",
 CellID->22363]
}, Open  ]],
Cell[CellGroupData[{
Cell[73877, 1916, 503, 17, 70, "Input",
 CellID->19940],
Cell[74383, 1935, 567, 19, 39, "Output",
 CellID->19742]
}, Open  ]],
Cell[74965, 1957, 121, 3, 70, "ExampleDelimiter",
 CellID->17062],
Cell[75089, 1962, 236, 7, 70, "ExampleText",
 CellID->30041],
Cell[CellGroupData[{
Cell[75350, 1973, 703, 24, 70, "Input",
 CellID->7306],
Cell[76056, 1999, 863, 30, 39, "Output",
 CellID->15753]
}, Open  ]],
Cell[76934, 2032, 121, 3, 70, "ExampleDelimiter",
 CellID->22922],
Cell[77058, 2037, 47, 1, 70, "ExampleText",
 CellID->127],
Cell[CellGroupData[{
Cell[77130, 2042, 205, 7, 70, "Input",
 CellID->29414],
Cell[77338, 2051, 263, 9, 36, "Output",
 CellID->7501]
}, Open  ]],
Cell[77616, 2063, 121, 3, 70, "ExampleDelimiter",
 CellID->13047],
Cell[77740, 2068, 203, 7, 70, "ExampleText",
 CellID->9801],
Cell[CellGroupData[{
Cell[77968, 2079, 112, 3, 70, "Input",
 CellID->5778],
Cell[78083, 2084, 268, 9, 36, "Output",
 CellID->29033]
}, Open  ]],
Cell[CellGroupData[{
Cell[78388, 2098, 188, 6, 70, "Input",
 CellID->32387],
Cell[78579, 2106, 157, 5, 36, "Output",
 CellID->23625]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[78785, 2117, 226, 7, 70, "ExampleSection",
 CellID->23018],
Cell[79014, 2126, 116, 3, 70, "ExampleText",
 CellID->27034],
Cell[CellGroupData[{
Cell[79155, 2133, 174, 6, 70, "Input",
 CellID->30852],
Cell[79332, 2141, 357, 7, 70, "Message",
 CellID->348894891],
Cell[79692, 2150, 187, 6, 36, "Output",
 CellID->650630610]
}, Open  ]],
Cell[79894, 2159, 121, 3, 70, "ExampleDelimiter",
 CellID->23240],
Cell[80018, 2164, 109, 3, 70, "ExampleText",
 CellID->19122],
Cell[CellGroupData[{
Cell[80152, 2171, 153, 5, 70, "Input",
 CellID->28549],
Cell[80308, 2178, 221, 6, 36, "Output",
 CellID->489689800]
}, Open  ]],
Cell[CellGroupData[{
Cell[80566, 2189, 106, 3, 70, "Input",
 CellID->17798],
Cell[80675, 2194, 162, 5, 36, "Output",
 CellID->133636963]
}, Open  ]],
Cell[80852, 2202, 121, 3, 70, "ExampleDelimiter",
 CellID->18996],
Cell[80976, 2207, 553, 21, 70, "ExampleText",
 CellID->17693],
Cell[CellGroupData[{
Cell[81554, 2232, 195, 7, 70, "Input",
 CellID->13461],
Cell[81752, 2241, 217, 7, 36, "Output",
 CellID->12167]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82018, 2254, 224, 7, 70, "ExampleSection",
 CellID->17370],
Cell[82245, 2263, 234, 10, 70, "ExampleText",
 CellID->19360],
Cell[CellGroupData[{
Cell[82504, 2277, 2094, 59, 70, "Input",
 CellID->25213],
Cell[84601, 2338, 16581, 276, 70, "Output",
 Evaluatable->False,
 CellID->447249587]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[101243, 2621, 310, 9, 70, "SeeAlsoSection",
 CellID->1529],
Cell[101556, 2632, 1204, 44, 70, "SeeAlso",
 CellID->28632]
}, Open  ]],
Cell[CellGroupData[{
Cell[102797, 2681, 313, 9, 70, "TutorialsSection",
 CellID->7951],
Cell[103113, 2692, 144, 3, 70, "Tutorials",
 CellID->13526]
}, Open  ]],
Cell[CellGroupData[{
Cell[103294, 2700, 320, 9, 70, "RelatedLinksSection",
 CellID->2316],
Cell[103617, 2711, 183, 4, 70, "RelatedLinks"],
Cell[103803, 2717, 197, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104037, 2726, 319, 9, 70, "MoreAboutSection",
 CellID->614200569],
Cell[104359, 2737, 191, 4, 70, "MoreAbout",
 CellID->980777554],
Cell[104553, 2743, 142, 3, 70, "MoreAbout",
 CellID->920100]
}, Open  ]],
Cell[104710, 2749, 27, 0, 70, "History"],
Cell[104740, 2751, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

