(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77493,       2433]
NotebookOptionsPosition[     66639,       2044]
NotebookOutlinePosition[     67918,       2080]
CellTagsIndexPosition[     67832,       2075]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpIntegralE" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralE"], "Erf" :> 
          Documentation`HelpLookup["paclet:ref/Erf"], "LogIntegral" :> 
          Documentation`HelpLookup["paclet:ref/LogIntegral"], "SinIntegral" :> 
          Documentation`HelpLookup["paclet:ref/SinIntegral"], "CosIntegral" :> 
          Documentation`HelpLookup["paclet:ref/CosIntegral"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExpIntegralE\"\>", 2->"\<\"Erf\"\>",
        3->"\<\"LogIntegral\"\>", 4->"\<\"SinIntegral\"\>", 
       5->"\<\"CosIntegral\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExpIntegralEi", "ObjectName",
 CellID->22781],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExpIntegralEi",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExpIntegralEi"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the exponential integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Ei", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13917]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Ei", "(", "z", ")"}], "=", 
    RowBox[{"-", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "z"}], "\[Infinity]"], 
      RowBox[{
       RowBox[{
        SuperscriptBox["e", 
         RowBox[{"-", "t"}]], "/", "t"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where the principal value of the integral is taken. "
}], "Notes",
 CellID->11131],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpIntegralEi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralEi"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3661],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->622366915],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->84481350],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->82093591]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->603430863],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->627859047],

Cell["Evaluate numerically:", "ExampleText",
 CellID->11280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", "1.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29287],

Cell[BoxData["4.249867557487933`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441564777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14449],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFmVuMXVMYx7ezz5nTmc60VTXGfYoUdW3qrlKUVlU1RRVVzEy1Mx1Uxnjh
hRdeeOGFRPTBJXF5qEgqkkpEE9FESEQTQSIjER6IhHhoIjl+3/etvdfa66zT
M42GZmbPXmt9l/93XWuvrh+ZHn/w4ZHpibGR4TVTI4+OT4w9Nrx61xRT+TFZ
ls3w+/xQxnuLN/2dabX4OyXPXMb6L3uonK0x+bCOHpVn/dChvz/a9z2T+z/5
weYnI96a0s3M/L51y1vM7nrk/cPRffnFT1CEdGM860zU3N9c+Uq6TBAZvolA
oqzUVSLwnn5qH8PNm940iTudHbb+wd5vnn3mY4Y3rnoltf7O21+9+MKnDFde
83Jn5LXdr34uPFmOR9z8Tu+nBiIQZCh+/vkPh9jWUA8I1vAQfqqsPfnEh3jW
/IHNlTU3lWWOKFxzavSfCA/W8o0bXvvtt7/Ud6AOuTDRfOecYmu75NkDC4y2
jDZ0Bqv5d9/+Ojb6rnpDvQC2ihdMxoHPfnx8eq/JAB4gQw2m1Fb//PPQurW7
/aogzRq2xpNY4WeLhEPw/HP739tz0CMwD0QImqgHRCnHuXCyzJ+8yLCmBaOk
dD42SsXVV2aAoSlJLdaTlexV6HVbN0/WnDZF7nw1Uck/rYg55mtHoPzmxUmf
i40SiUvWWqDNKi/A7ebNXyElNmBJ1Re63pgY33Pw619KDDabew8Z7kdUFmEj
eEZrkfDes0hoFeUW/6J+AhtefunAG69/WaEtfRDTuuIOaY09QetaUEhr4S9o
S5/nPqDjAXVpmVH1lJL5R/JTAhPey0FF5G3UVvEhtQUuTW1rIbXHnVdwe53j
PjukIwFd6kU7WtxzA7t2BFze52kujyHkMss6cxEaAuS5dhYIqQhAWJ20cXm7
Qi7fTRqtoGMH9mxvFblc1mAgO48Qe+qsbg1SfNaJz3cr4wv3qcJOSf+eJDcA
sVjkG7fGq8GYmkB3y+pMNOelXd7jDwY8VgJOeAKt8VLq1mYqvDjVE3bk9Z3f
eHdE+VFLWGmSfLfdppzbi2hTiLI99bq49UQSPbX0/b5ItlHbLiavY0qt2KSr
IFv8muISadsCao8vrQMFxEOkmY5tUeTnOvxzdN6anLyOlhkRIuqPdDSj3Dau
0SI/mBUfDURcsa6RgMvbk+byuoxLn1IBbuecF3H1RlIfUK4HnCcXOOv7ItlG
db/OknRQyuuCSHZfZIfSZ/dFXMcmubxPjevewmeUCKZkx0Vccx1io94S4JXd
f5Gzo7/ITublHKZYsnt0lh7MJijxOD6SbVy+F21VrrvkWYceRDRvhIpv80SN
DRQxcF1Ibck2t1wXwU7BGPsh7q4DBXZXWSZlk5KCjVnaEcviv3rZUaryZGgZ
wGaPtfKqvspuVxJmsQYzcc6iLnjmO48b/8aCn3AjGIMGZ8Gv9qARPotCtkFJ
6XgI4YfMGeoix7KOOiam0tPvVjm3yLOBn0BIgdM/RceJLd+N5O9C5bUvDXnV
mGZr5dlj3z34AnaEIOrMSLNx+76rEc3WqGaAE3A6GJqJTrYk4rX8tXOkvN6p
vKvk2USzsbPN4U6yRvbNcyIJFh9fuZoJ2bUqgcxHLmscc7yE85IS0AaJYDQJ
KwIJLIABxwJUKC5yfhssOAkRlNkdytlsBSfKcIfndUlRLVhGnuJvPTnKVxMz
gs4+6oTtgojftFnti7aFDkUe0OmZld+lh8Gg9K5PRrt1Pdwkh+VPL5qIv2HF
CWQB3pBja0J6XPFLo/EJLdfTkCW1u6BNZzPiiKPdjrJmf3JnvLM/78p3kvyZ
AwrSnrwmzQgin4VEmVwtzzeHRRfbNxTZN/+o2dc9WlpJ/WYPKYtJgMAYTCJm
vDNDAVD+vbOyq1b4yNkjGTfvP7RHdrJsHnCxhwQEPe0FHDT40iSqhnkIANfu
6+KsHNdRbNVAR864UxyRNY2QTp412d56KHMw80OWmTk17MmaZB9DJlmil0Ir
O/NgEluo6/xofHLLdwnp9f1dJcRZ3MnKpvOKbhulGXQD18XEjprcVfUwZ4sE
zgwZdryFjBj1KQFquWbrj+jPbVV3LCt3PSPJvZZpA5P6OLiZut/Rn9ZynRoH
y/WU7ottt3+n65iscjvZzUkq7Yuy34FVOvbaJNViHQPHPpizm5RK8H9Txd92
TvbjOK/i9SOlP9ryutHbvaJ53a4Wu1n8bxE0jopfF/7Hfoz12TeZXaPKWa73
f/Hasi5jO8vRY9zJPdZ6RStVF2e3fKXLVef1JVVxbsly5mmHYvm1SRlLA81y
27YySaXdu44m2hHbO2l4TZLO9ge6CJUqHXNFBdFFKoUWBiL7srgqKeViHXMw
clKuTFIta5N2eZJueSTtsgqmS9ukXJKUclkhBT/JuXV5kkoRyJmUgzKFituX
JenUopzujDT59ry4gunqwtv0TmAB7sKkFPWufCFhmWHXvUBvulJfjRoz6SGl
GRrXtv+biL+HVgZW8cPLubPiu04n7UuSPETx2R35ZHh9gQ9iS8cls9JzQ4HP
NlD8ddas+FbrJPWGMnoqDj+j9F/qfkr3HeklLmqLK1HTHU7uAImapdrpyait
Uzq5+B3fYzlyapJuvdJZjhAw3HJyku7WIltIAfPaSRVcGwPv2J38UFLObUU2
lbgGk3R3FLjsKxZci5J0m4JoQkpTOC5Jt7nwG43FLleOreC/p/BXeY8wPyln
S5BtFs2BJN3WIoqAkn2hP0l1X+FVREGIV/sqqEbavKo9u+O98WjgXVgQ3FPm
WvjFGfPZ7SHqcYC8NmaV2fZ/YA9Fs3JSkmF6darEXz2xTpc4xe7HdTTT9syO
+QdUTjpa\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->172914946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4389],

Cell["Series expansion around the branch point at the origin:", "ExampleText",
 CellID->20227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1848],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"EulerGamma", "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "18"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "96"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "600"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {EulerGamma + Log[$CellContext`x], 1, 
    Rational[1, 4], 
    Rational[1, 18], 
    Rational[1, 96], 
    Rational[1, 600]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{337, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378343411]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", "<", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31197899],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"EulerGamma", "-", 
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "18"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "96"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "600"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   EulerGamma + Complex[0, -1] Pi + Log[$CellContext`x], 1, 
    Rational[1, 4], 
    Rational[1, 18], 
    Rational[1, 96], 
    Rational[1, 600]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{369, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->492963306]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24842],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->14023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26326],

Cell[BoxData["4.\
9542343560018901633795051302270352755180535624200420334753036164964`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92221162]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->33],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", "2.0000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30874],

Cell[BoxData["4.95423435600189016337950512968497169677`22.03049277857537"], \
"Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->688978876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3466],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->7438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.4420922851926514`", ",", "3.301285449129798`", ",", 
   "4.249867557487933`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449215904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22625],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " can take complex number inputs:"
}], "ExampleText",
 CellID->32546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", 
  RowBox[{"2.", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1615],

Cell[BoxData[
 RowBox[{"4.069980947893926`", "\[InvisibleSpace]", "+", 
  RowBox[{"3.400943969800122`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->709028930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2918],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->15747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12579],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->400807005]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8923],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->71159599]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->599688893],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->396730214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpIntegralEi", "[", "x", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56902515],

Cell[BoxData[
 FormBox[
  RowBox[{"Ei", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->217626855]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8294],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->23042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", 
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8191],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "1", "]"}], "+", 
   RowBox[{"\[ExponentialE]", " ", "x"}], "+", 
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   FractionBox[
    RowBox[{"5", " ", "\[ExponentialE]", " ", 
     SuperscriptBox["x", "3"]}], "18"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    ExpIntegralEi[1], E, Rational[1, 2] E, Rational[5, 18] E}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{281, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145618676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3700],

Cell["Find series expansions at infinity:", "ExampleText",
 CellID->576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13812],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", "x"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "x"], ")"}], "2"], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], "4"],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 1, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {1, 1, 2}, 1, 4, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{192, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->453201160]
}, Open  ]],

Cell["Give the result for an arbitrary symbolic direction:", "ExampleText",
 CellID->3324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"DirectedInfinity", "[", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15627],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Arg", "[", "x", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{"Arg", "[", "x", "]"}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{"\[Pi]", "+", 
      RowBox[{"Arg", "[", "x", "]"}]}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox["1", "x"], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], "2"],
       SeriesData[$CellContext`x, 
        DirectedInfinity[], {}, 1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[], {1}, 1, 2, 1],
     Editable->False], ")"}]}]}]], "Output",
 ImageSize->{521, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->366183123]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31942],

Cell[TextData[{
 "Compute a classical asymptotic series with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["k", "TI"], "!"}]], "InlineFormula"],
 " coefficients:"
}], "ExampleText",
 CellID->561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Exp", "[", 
      RowBox[{"1", "/", "z"}], "]"}]}], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "z"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21339],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "-", 
   SuperscriptBox["z", "2"], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "3"]}], "-", 
   RowBox[{"6", " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{"24", " ", 
    SuperscriptBox["z", "5"]}], "-", 
   RowBox[{"120", " ", 
    SuperscriptBox["z", "6"]}], "+", 
   RowBox[{"720", " ", 
    SuperscriptBox["z", "7"]}], "-", 
   RowBox[{"5040", " ", 
    SuperscriptBox["z", "8"]}], "+", 
   RowBox[{"40320", " ", 
    SuperscriptBox["z", "9"]}], "-", 
   RowBox[{"362880", " ", 
    SuperscriptBox["z", "10"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "11"],
    SeriesData[$CellContext`z, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, -1, 2, -6, 24, -120, 720, -5040, 
   40320, -362880}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{497, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->416283592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27678],

Cell["Plot the imaginary part in the complex plane:", "ExampleText",
 CellID->12646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25926],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243956584]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14545],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing exponential integrals:"
}], "ExampleText",
 CellID->2911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", "z", "]"}], "+", 
      RowBox[{"Log", "[", 
       FractionBox["1", "z"], "]"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16207],

Cell[BoxData[
 RowBox[{
  RowBox[{"CoshIntegral", "[", "z", "]"}], "+", 
  RowBox[{"SinhIntegral", "[", "z", "]"}]}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328459542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6103],

Cell["Find the numerical root:", "ExampleText",
 CellID->22540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ExpIntegralEi", "[", "z", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.3725074107813666`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78224818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28270],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " from integrals, sums:"
}], "ExampleText",
 CellID->11767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"E", "^", "t"}], "-", "1"}], ")"}], "/", "t"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280442702],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "EulerGamma"}], "+", 
  RowBox[{"ExpIntegralEi", "[", "z", "]"}], "-", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{261, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141788968]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], "\[Infinity]"], 
   FractionBox[
    SuperscriptBox["z", "k"], 
    RowBox[{"k", " ", 
     RowBox[{"k", "!"}]}]]}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12095],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "EulerGamma"}], "+", 
  RowBox[{"ExpIntegralEi", "[", "z", "]"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", 
      FractionBox["1", "z"], "]"}], "-", 
     RowBox[{"Log", "[", "z", "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{348, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->767934693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26011],

Cell["Calculate limits:", "ExampleText",
 CellID->15026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"2", 
      RowBox[{"ExpIntegralEi", "[", 
       RowBox[{"-", "x"}], "]"}]}], "]"}], "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16680],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"2", " ", "EulerGamma"}]]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67206214]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17522],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " from a differential equation:"
}], "ExampleText",
 CellID->10651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{
       SuperscriptBox["w", 
        TagBox[
         RowBox[{"(", "3", ")"}],
         Derivative],
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"z", " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",",
    "w", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "3", "]"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"C", "[", "1", "]"}], " ", 
           RowBox[{"ExpIntegralEi", "[", 
            RowBox[{"-", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"C", "[", "2", "]"}], " ", 
           RowBox[{"ExpIntegralEi", "[", "z", "]"}]}]}], ")"}]}]}]}], "]"}]}],
    "}"}], "}"}]], "Output",
 ImageSize->{543, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320987791]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8514],

Cell["Calculate Wronskian:", "ExampleText",
 CellID->22095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"#1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "#2"}], "}"}]}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"ExpIntegralEi", "[", "x", "]"}], ",", 
      RowBox[{"ExpIntegralEi", "[", 
       RowBox[{"-", "x"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30487],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["2", 
   SuperscriptBox["x", "2"]]}]], "Output",
 ImageSize->{29, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211321807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4431],

Cell["Integrals:", "ExampleText",
 CellID->31121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["z", "\[Alpha]"], 
   RowBox[{"ExpIntegralEi", "[", 
    SuperscriptBox["z", "\[Beta]"], "]"}], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19287],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["z", 
    RowBox[{"1", "+", "\[Alpha]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ExpIntegralEi", "[", 
      SuperscriptBox["z", "\[Beta]"], "]"}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         SuperscriptBox["z", "\[Beta]"]}], ")"}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"1", "+", "\[Alpha]"}], "\[Beta]"]}]], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "+", "\[Alpha]"}], "\[Beta]"], ",", 
        RowBox[{"-", 
         SuperscriptBox["z", "\[Beta]"]}]}], "]"}]}]}], ")"}]}], 
  RowBox[{"1", "+", "\[Alpha]"}]]], "Output",
 ImageSize->{338, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46383545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29350],

Cell["Integral transforms:", "ExampleText",
 CellID->7883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "t", "]"}], ",", "t", ",", "s", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"s", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11310],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "s"}], "]"}], "s"]}]], "Output",
 ImageSize->{86, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103256692]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->444],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " can take large values for moderate\[Hyphen]size arguments:"
}], "ExampleText",
 CellID->11869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "I", "]"}], " ", "10000."}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27976],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.0765707952563251348484513047659`15.211384796177818*^3066"}],
   "+", 
  RowBox[{
  "8.3597023536010536452813560402542`15.954589770191005*^3066", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{365, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9243492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24406],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " has a special value on the negative real axis, not obtained as a limit \
from either side:"
}], "ExampleText",
 CellID->28700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"ExpIntegralEi", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"10", "^", 
         RowBox[{"-", "10"}]}]}], "I"}], ",", "0", ",", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], " ", "I"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.21938393439552029`"}], "-", 
    RowBox[{"3.141592653553005`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"-", "0.21938393439552029`"}], ",", 
   RowBox[{
    RowBox[{"-", "0.21938393439552029`"}], "+", 
    RowBox[{"3.141592653553005`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{377, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->719089484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23806],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->30429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"10", "^", "60"}]}], " ", "I"}], "]"}], "+", " ", 
    RowBox[{"I", " ", "Pi"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23424],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(\[ImaginaryI]\\\\ \[Pi]\\)\\) + \
\\(\\(ExpIntegralEi[\\(\\(\\(\\(-\
1000000000000000000000000000000000000000000000000000000000000\\)\\)\\\\ \
\[ImaginaryI]\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->155049721],

Cell[BoxData[
 RowBox[{"8.3038976521934266466406179`10.474314166381525*^-61", "-", 
  RowBox[{
  "5.5718294830815822772967135`8.753003917212746*^-61", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220231188]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpIntegralEi", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"10", "^", "60"}]}], " ", "I"}], "]"}], "+", " ", 
      RowBox[{"I", " ", "Pi"}]}], ",", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25327],

Cell[BoxData[
 RowBox[{"8.30389765219342664664061785421328757`20.06979698557126*^-61", "-", 
  
  RowBox[{
  "5.57182948248566708972916420591398993`19.89651281485372*^-61", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{404, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->841956348]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31618],

Cell["Nested integrals:", "ExampleText",
 CellID->28923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"ExpIntegralEi", "[", " ", "x", "]"}], ",", "4"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"ExpIntegralEi", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox["x", "2"]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"ExpIntegralEi", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", "x"]}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "x", "+", 
         SuperscriptBox["x", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["x", "3"], " ", 
       RowBox[{"ExpIntegralEi", "[", "x", "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", "x"]}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", 
         RowBox[{"2", " ", "x"}], "+", 
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["x", "3"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["x", "4"], " ", 
       RowBox[{"ExpIntegralEi", "[", "x", "]"}]}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{586, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220298724]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26888],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SinIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CosIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CosIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18169]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31431],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->32053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->19020],

Cell[TextData[{
 ButtonBox["Demonstrations with ExpIntegralEi",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ExpIntegralEi"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ExpIntegralEi.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/ExpIntegralEi/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ExpIntegralEi"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->512013270],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->38539691],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->507395666]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpIntegralEi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 47.7790944}", "context" -> "System`", 
    "keywords" -> {"ei", "exp integral", "expint", "exponential integral"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ExpIntegralEi[z] gives the exponential integral function Ei(z). ", 
    "synonyms" -> {"exp integral ei"}, "title" -> "ExpIntegralEi", "type" -> 
    "Symbol", "uri" -> "ref/ExpIntegralEi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5998, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->603430863]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 67689, 2068}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2359, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2982, 82, 51, 1, 70, "ObjectName",
 CellID->22781],
Cell[3036, 85, 609, 19, 70, "Usage",
 CellID->13917]
}, Open  ]],
Cell[CellGroupData[{
Cell[3682, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4160, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4283, 132, 487, 17, 70, "Notes",
 CellID->11131],
Cell[4773, 151, 476, 17, 70, "Notes",
 CellID->3661],
Cell[5252, 170, 258, 8, 70, "Notes",
 CellID->622366915],
Cell[5513, 180, 231, 7, 70, "Notes",
 CellID->84481350],
Cell[5747, 189, 214, 7, 70, "Notes",
 CellID->82093591]
}, Closed]],
Cell[CellGroupData[{
Cell[5998, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->603430863],
Cell[CellGroupData[{
Cell[6383, 215, 148, 5, 70, "ExampleSection",
 CellID->627859047],
Cell[6534, 222, 60, 1, 70, "ExampleText",
 CellID->11280],
Cell[CellGroupData[{
Cell[6619, 227, 107, 3, 28, "Input",
 CellID->29287],
Cell[6729, 232, 175, 5, 36, "Output",
 CellID->441564777]
}, Open  ]],
Cell[6919, 240, 121, 3, 70, "ExampleDelimiter",
 CellID->30627],
Cell[CellGroupData[{
Cell[7065, 247, 240, 8, 28, "Input",
 CellID->14449],
Cell[7308, 257, 3140, 56, 162, "Output",
 Evaluatable->False,
 CellID->172914946]
}, Open  ]],
Cell[10463, 316, 120, 3, 70, "ExampleDelimiter",
 CellID->4389],
Cell[10586, 321, 94, 1, 70, "ExampleText",
 CellID->20227],
Cell[CellGroupData[{
Cell[10705, 326, 295, 9, 70, "Input",
 CellID->1848],
Cell[11003, 337, 877, 29, 54, "Output",
 CellID->378343411]
}, Open  ]],
Cell[CellGroupData[{
Cell[11917, 371, 299, 9, 70, "Input",
 CellID->31197899],
Cell[12219, 382, 953, 31, 54, "Output",
 CellID->492963306]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13221, 419, 216, 7, 70, "ExampleSection",
 CellID->24842],
Cell[13440, 428, 66, 1, 70, "ExampleText",
 CellID->14023],
Cell[CellGroupData[{
Cell[13531, 433, 158, 5, 70, "Input",
 CellID->26326],
Cell[13692, 440, 234, 7, 36, "Output",
 CellID->92221162]
}, Open  ]],
Cell[13941, 450, 106, 3, 70, "ExampleText",
 CellID->33],
Cell[CellGroupData[{
Cell[14072, 457, 128, 3, 70, "Input",
 CellID->30874],
Cell[14203, 462, 218, 6, 36, "Output",
 CellID->688978876]
}, Open  ]],
Cell[14436, 471, 120, 3, 70, "ExampleDelimiter",
 CellID->3466],
Cell[14559, 476, 215, 7, 70, "ExampleText",
 CellID->7438],
Cell[CellGroupData[{
Cell[14799, 487, 167, 5, 70, "Input",
 CellID->7189],
Cell[14969, 494, 273, 9, 36, "Output",
 CellID->449215904]
}, Open  ]],
Cell[15257, 506, 121, 3, 70, "ExampleDelimiter",
 CellID->22625],
Cell[15381, 511, 215, 7, 70, "ExampleText",
 CellID->32546],
Cell[CellGroupData[{
Cell[15621, 522, 128, 4, 70, "Input",
 CellID->1615],
Cell[15752, 528, 271, 7, 36, "Output",
 CellID->709028930]
}, Open  ]],
Cell[16038, 538, 120, 3, 70, "ExampleDelimiter",
 CellID->2918],
Cell[16161, 543, 87, 1, 70, "ExampleText",
 CellID->15747],
Cell[CellGroupData[{
Cell[16273, 548, 105, 3, 70, "Input",
 CellID->12579],
Cell[16381, 553, 185, 6, 36, "Output",
 CellID->400807005]
}, Open  ]],
Cell[CellGroupData[{
Cell[16603, 564, 111, 3, 70, "Input",
 CellID->8923],
Cell[16717, 569, 167, 5, 36, "Output",
 CellID->71159599]
}, Open  ]],
Cell[16899, 577, 125, 3, 70, "ExampleDelimiter",
 CellID->599688893],
Cell[17027, 582, 203, 7, 70, "ExampleText",
 CellID->396730214],
Cell[CellGroupData[{
Cell[17255, 593, 149, 5, 70, "Input",
 CellID->56902515],
Cell[17407, 600, 232, 7, 50, "Output",
 CellID->217626855]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17688, 613, 238, 7, 70, "ExampleSection",
 CellID->8294],
Cell[17929, 622, 215, 7, 70, "ExampleText",
 CellID->23042],
Cell[CellGroupData[{
Cell[18169, 633, 308, 10, 70, "Input",
 CellID->8191],
Cell[18480, 645, 774, 23, 54, "Output",
 CellID->145618676]
}, Open  ]],
Cell[19269, 671, 120, 3, 70, "ExampleDelimiter",
 CellID->3700],
Cell[19392, 676, 72, 1, 70, "ExampleText",
 CellID->576],
Cell[CellGroupData[{
Cell[19489, 681, 228, 7, 70, "Input",
 CellID->13812],
Cell[19720, 690, 835, 28, 52, "Output",
 CellID->453201160]
}, Open  ]],
Cell[20570, 721, 90, 1, 70, "ExampleText",
 CellID->3324],
Cell[CellGroupData[{
Cell[20685, 726, 265, 9, 70, "Input",
 CellID->15627],
Cell[20953, 737, 1253, 40, 53, "Output",
 CellID->366183123]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22255, 783, 223, 7, 70, "ExampleSection",
 CellID->31942],
Cell[22481, 792, 190, 7, 70, "ExampleText",
 CellID->561],
Cell[CellGroupData[{
Cell[22696, 803, 450, 15, 70, "Input",
 CellID->21339],
Cell[23149, 820, 1007, 32, 36, "Output",
 CellID->416283592]
}, Open  ]],
Cell[24171, 855, 121, 3, 70, "ExampleDelimiter",
 CellID->27678],
Cell[24295, 860, 84, 1, 70, "ExampleText",
 CellID->12646],
Cell[CellGroupData[{
Cell[24404, 865, 416, 14, 70, "Input",
 CellID->25926],
Cell[24823, 881, 20977, 348, 70, "Output",
 Evaluatable->False,
 CellID->243956584]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45849, 1235, 233, 7, 70, "ExampleSection",
 CellID->14545],
Cell[46085, 1244, 247, 8, 70, "ExampleText",
 CellID->2911],
Cell[CellGroupData[{
Cell[46357, 1256, 355, 12, 70, "Input",
 CellID->16207],
Cell[46715, 1270, 259, 8, 36, "Output",
 CellID->328459542]
}, Open  ]],
Cell[46989, 1281, 120, 3, 70, "ExampleDelimiter",
 CellID->6103],
Cell[47112, 1286, 63, 1, 70, "ExampleText",
 CellID->22540],
Cell[CellGroupData[{
Cell[47200, 1291, 245, 8, 70, "Input",
 CellID->32718],
Cell[47448, 1301, 226, 7, 36, "Output",
 CellID->78224818]
}, Open  ]],
Cell[47689, 1311, 121, 3, 70, "ExampleDelimiter",
 CellID->28270],
Cell[47813, 1316, 217, 8, 70, "ExampleText",
 CellID->11767],
Cell[CellGroupData[{
Cell[48055, 1328, 364, 12, 70, "Input",
 CellID->280442702],
Cell[48422, 1342, 288, 9, 36, "Output",
 CellID->141788968]
}, Open  ]],
Cell[CellGroupData[{
Cell[48747, 1356, 288, 10, 70, "Input",
 CellID->12095],
Cell[49038, 1368, 443, 15, 51, "Output",
 CellID->767934693]
}, Open  ]],
Cell[49496, 1386, 121, 3, 70, "ExampleDelimiter",
 CellID->26011],
Cell[49620, 1391, 56, 1, 70, "ExampleText",
 CellID->15026],
Cell[CellGroupData[{
Cell[49701, 1396, 319, 11, 70, "Input",
 CellID->16680],
Cell[50023, 1409, 226, 7, 36, "Output",
 CellID->67206214]
}, Open  ]],
Cell[50264, 1419, 121, 3, 70, "ExampleDelimiter",
 CellID->17522],
Cell[50388, 1424, 225, 8, 70, "ExampleText",
 CellID->10651],
Cell[CellGroupData[{
Cell[50638, 1436, 649, 22, 70, "Input",
 CellID->609],
Cell[51290, 1460, 774, 25, 51, "Output",
 CellID->320987791]
}, Open  ]],
Cell[52079, 1488, 120, 3, 70, "ExampleDelimiter",
 CellID->8514],
Cell[52202, 1493, 59, 1, 70, "ExampleText",
 CellID->22095],
Cell[CellGroupData[{
Cell[52286, 1498, 531, 17, 70, "Input",
 CellID->30487],
Cell[52820, 1517, 221, 8, 52, "Output",
 CellID->211321807]
}, Open  ]],
Cell[53056, 1528, 120, 3, 70, "ExampleDelimiter",
 CellID->4431],
Cell[53179, 1533, 49, 1, 70, "ExampleText",
 CellID->31121],
Cell[CellGroupData[{
Cell[53253, 1538, 255, 8, 70, "Input",
 CellID->19287],
Cell[53511, 1548, 845, 28, 70, "Output",
 CellID->46383545]
}, Open  ]],
Cell[54371, 1579, 121, 3, 70, "ExampleDelimiter",
 CellID->29350],
Cell[54495, 1584, 58, 1, 70, "ExampleText",
 CellID->7883],
Cell[CellGroupData[{
Cell[54578, 1589, 257, 7, 70, "Input",
 CellID->11310],
Cell[54838, 1598, 273, 10, 51, "Output",
 CellID->103256692]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55160, 1614, 224, 7, 70, "ExampleSection",
 CellID->444],
Cell[55387, 1623, 242, 7, 70, "ExampleText",
 CellID->11869],
Cell[CellGroupData[{
Cell[55654, 1634, 170, 5, 70, "Input",
 CellID->27976],
Cell[55827, 1641, 356, 11, 36, "Output",
 CellID->9243492]
}, Open  ]],
Cell[56198, 1655, 121, 3, 70, "ExampleDelimiter",
 CellID->24406],
Cell[56322, 1660, 274, 8, 70, "ExampleText",
 CellID->28700],
Cell[CellGroupData[{
Cell[56621, 1672, 419, 15, 70, "Input",
 CellID->4515],
Cell[57043, 1689, 488, 15, 36, "Output",
 CellID->719089484]
}, Open  ]],
Cell[57546, 1707, 121, 3, 70, "ExampleDelimiter",
 CellID->23806],
Cell[57670, 1712, 234, 8, 70, "ExampleText",
 CellID->30429],
Cell[CellGroupData[{
Cell[57929, 1724, 292, 10, 70, "Input",
 CellID->23424],
Cell[58224, 1736, 590, 11, 70, "Message",
 CellID->155049721],
Cell[58817, 1749, 322, 9, 36, "Output",
 CellID->220231188]
}, Open  ]],
Cell[CellGroupData[{
Cell[59176, 1763, 430, 14, 70, "Input",
 CellID->25327],
Cell[59609, 1779, 344, 10, 36, "Output",
 CellID->841956348]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60002, 1795, 224, 7, 70, "ExampleSection",
 CellID->31618],
Cell[60229, 1804, 56, 1, 70, "ExampleText",
 CellID->28923],
Cell[CellGroupData[{
Cell[60310, 1809, 288, 10, 70, "Input",
 CellID->11203],
Cell[60601, 1821, 1680, 55, 81, "Output",
 CellID->220298724]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62342, 1883, 311, 9, 70, "SeeAlsoSection",
 CellID->26888],
Cell[62656, 1894, 1202, 44, 70, "SeeAlso",
 CellID->18169]
}, Open  ]],
Cell[CellGroupData[{
Cell[63895, 1943, 314, 9, 70, "TutorialsSection",
 CellID->31431],
Cell[64212, 1954, 144, 3, 70, "Tutorials",
 CellID->32053]
}, Open  ]],
Cell[CellGroupData[{
Cell[64393, 1962, 321, 9, 70, "RelatedLinksSection",
 CellID->19020],
Cell[64717, 1973, 371, 12, 70, "RelatedLinks"],
Cell[65091, 1987, 184, 4, 70, "RelatedLinks"],
Cell[65278, 1993, 198, 4, 70, "RelatedLinks"],
Cell[65479, 1999, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65907, 2017, 319, 9, 70, "MoreAboutSection",
 CellID->512013270],
Cell[66229, 2028, 190, 4, 70, "MoreAbout",
 CellID->38539691],
Cell[66422, 2034, 145, 3, 70, "MoreAbout",
 CellID->507395666]
}, Open  ]],
Cell[66582, 2040, 27, 0, 70, "History"],
Cell[66612, 2042, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

