(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43244,       1568]
NotebookOptionsPosition[     35065,       1285]
NotebookOutlinePosition[     36507,       1323]
CellTagsIndexPosition[     36421,       1318]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Discrete Distributions\"\>", 
       2->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CentralMoment" :> 
          Documentation`HelpLookup["paclet:ref/CentralMoment"], "Mean" :> 
          Documentation`HelpLookup["paclet:ref/Mean"], "Variance" :> 
          Documentation`HelpLookup["paclet:ref/Variance"], "Skewness" :> 
          Documentation`HelpLookup["paclet:ref/Skewness"], "Kurtosis" :> 
          Documentation`HelpLookup["paclet:ref/Kurtosis"], 
          "CharacteristicFunction" :> 
          Documentation`HelpLookup["paclet:ref/CharacteristicFunction"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"CentralMoment\"\>", 
       2->"\<\"Mean\"\>", 3->"\<\"Variance\"\>", 4->"\<\"Skewness\"\>", 
       5->"\<\"Kurtosis\"\>", 6->"\<\"CharacteristicFunction\"\>", 
       7->"\<\"Integrate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"Statistical Distributions\"\>", 
       3->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       6->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExpectedValue", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExpectedValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExpectedValue"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["dist", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the expected value of the pure function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " with respect to the symbolic distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExpectedValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExpectedValue"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["dist", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the expected value of the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " with respect to the symbolic distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3338]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For a continuous distribution ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 ", the expected value of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      StyleBox["f", "TI"], "(", 
      StyleBox["x", "TI"], ")"}], " ", 
     RowBox[{
      StyleBox["p", "TI"], "(", 
      StyleBox["x", "TI"], ")"}], 
     RowBox[{"\[DifferentialD]", 
      StyleBox["x", "TI"]}]}]}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p", "TI"], "(", 
    StyleBox["x", "TI"], ")"}], TraditionalForm]], "InlineMath"],
 " is the probability density function of ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 " and the integral is taken over the domain of ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->946609506],

Cell[TextData[{
 "For a discrete distribution ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 ", the expected value of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["\[Sum]", "TI"], 
    RowBox[{
     RowBox[{
      StyleBox["f", "TI"], "(", 
      StyleBox["x", "TI"], ")"}], " ", 
     RowBox[{
      StyleBox["p", "TI"], "(", 
      StyleBox["x", "TI"], ")"}]}]}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p", "TI"], "(", 
    StyleBox["x", "TI"], ")"}], TraditionalForm]], "InlineMath"],
 " is the probability mass function of ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 " and summation is over the domain of ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->499729950],

Cell["The following option can be given: ", "Notes",
 CellID->28908],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Assumptions"], 
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[
    "assumptions to make about parameters ", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2479172]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128800641],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->39533191],

Cell[TextData[{
 "Find the expected value of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "4"], TraditionalForm]], "InlineMath"],
 " in a Poisson distribution:"
}], "ExampleText",
 CellID->229912737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], ",", 
   RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118009070],

Cell[BoxData[
 RowBox[{"\[Mu]", "+", 
  RowBox[{"7", " ", 
   SuperscriptBox["\[Mu]", "2"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["\[Mu]", "3"]}], "+", 
  SuperscriptBox["\[Mu]", "4"]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->863413446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6264413],

Cell["Use a pure function:", "ExampleText",
 CellID->57896856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "^", "4"}], "&"}], ",", 
   RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361710915],

Cell[BoxData[
 RowBox[{"\[Mu]", "+", 
  RowBox[{"7", " ", 
   SuperscriptBox["\[Mu]", "2"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["\[Mu]", "3"]}], "+", 
  SuperscriptBox["\[Mu]", "4"]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126202982]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16274],

Cell["Compute the expected value of any function:", "ExampleText",
 CellID->297807881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"Abs", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3982804],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SqrtBox[
      FractionBox["2", "\[Pi]"]]}], "-", 
    RowBox[{"5", " ", 
     SqrtBox["\[ExponentialE]"], " ", 
     RowBox[{"Erfc", "[", 
      FractionBox["1", 
       SqrtBox["2"]], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{198, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548429258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->294076702],

Cell["Do the computation numerically:", "ExampleText",
 CellID->401804277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"Abs", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "1."}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425429202],

Cell[BoxData["0.44425847248527583`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90355780]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64315683],

Cell["Obtain expectations with conditions:", "ExampleText",
 CellID->64045289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162593845],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "<", 
    RowBox[{"Re", "[", "n", "]"}], "<", "1"}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"]}], ")"}], " ", 
    RowBox[{"Sec", "[", 
     FractionBox[
      RowBox[{"n", " ", "\[Pi]"}], "2"], "]"}]}], ",", 
   RowBox[{"ExpectedValue", "[", 
    RowBox[{
     SuperscriptBox["x", "n"], ",", 
     RowBox[{"CauchyDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x", ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"!", 
       RowBox[{
        RowBox[{"-", "1"}], "<", 
        RowBox[{"Re", "[", "n", "]"}], "<", "1"}]}]}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{529, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31231496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "n", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->607996792],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "n"]}], ")"}], " ", 
  RowBox[{"Sec", "[", 
   FractionBox[
    RowBox[{"n", " ", "\[Pi]"}], "2"], "]"}]}]], "Output",
 ImageSize->{147, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192805979]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32698399],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->68359544],

Cell["Obtain results correct for given assumptions on symbols: ", \
"ExampleText",
 CellID->513409952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35208379],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["k", "\[Alpha]"], " ", "\[Alpha]", " ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"\[Alpha]", ">", 
     RowBox[{"Re", "[", "n", "]"}]}], ",", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["k", 
       RowBox[{"n", "-", "\[Alpha]"}]], 
      RowBox[{"n", "-", "\[Alpha]"}]]}], ",", 
    RowBox[{"ExpectedValue", "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["k", 
         RowBox[{"-", "\[Alpha]"}]], " ", 
        SuperscriptBox["x", "n"]}], "\[Alpha]"], ",", 
      RowBox[{"ParetoDistribution", "[", 
       RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "x", ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"\[Alpha]", "\[LessEqual]", 
        RowBox[{"Re", "[", "n", "]"}]}]}]}], "]"}]}], "]"}]}]], "Output",
 ImageSize->{522, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4721532]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Alpha]", ">", "n"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->420545487],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["k", "n"], " ", "\[Alpha]"}], 
   RowBox[{"n", "-", "\[Alpha]"}]]}]], "Output",
 ImageSize->{43, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->184856558]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21135],

Cell["Obtain the raw moments of a distribution:", "ExampleText",
 CellID->5128738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"n", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378088085],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", "n"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", "+", 
     FractionBox["\[Nu]", "2"]}], "]"}]}], 
  RowBox[{"Gamma", "[", 
   FractionBox["\[Nu]", "2"], "]"}]]], "Output",
 ImageSize->{103, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83120021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90125477],

Cell["\<\
Construct a mixture density, here a Poisson\[Hyphen]inverse Gaussian mixture:\
\
\>", "ExampleText",
 CellID->197390056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}], ",", "k"}], "]"}], 
   ",", 
   RowBox[{"InverseGaussianDistribution", "[", 
    RowBox[{"m", ",", "\[Lambda]"}], "]"}], ",", "\[Mu]", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"k", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->391246382],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox["\[Lambda]", "m"]], " ", 
   SuperscriptBox["m", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "+", "k"}]], " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SqrtBox["\[Lambda]"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Lambda]", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["m", "2"]}], "+", "\[Lambda]"}]], ")"}], 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "k"}]}], ")"}]}]], " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], "-", "k"}], ",", 
     FractionBox[
      SqrtBox[
       RowBox[{"\[Lambda]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["m", "2"]}], "+", "\[Lambda]"}], ")"}]}]], "m"]}], 
    "]"}]}], 
  RowBox[{"k", "!"}]]], "Output",
 ImageSize->{390, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4756793]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24828],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 " of a function is the integral or sum of that function times the ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->301259266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22100871],

Cell[BoxData[
 FractionBox["6", 
  SuperscriptBox["\[Lambda]", "3"]]], "Output",
 ImageSize->{21, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307161901]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], " ", 
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Lambda]", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->681923683],

Cell[BoxData[
 FractionBox["6", 
  SuperscriptBox["\[Lambda]", "3"]]], "Output",
 ImageSize->{21, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161036806]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "k", "]"}], ",", 
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"n", ",", "p"}], "]"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->422822880],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], "n"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"\[ExponentialE]", " ", "p"}], 
      RowBox[{"1", "-", "p"}]]}], ")"}], "n"]}]], "Output",
 ImageSize->{123, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->335678637]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "k", "]"}], " ", 
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"BinomialDistribution", "[", 
       RowBox[{"n", ",", "p"}], "]"}], ",", "k"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->309247236],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], "n"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"\[ExponentialE]", " ", "p"}], 
      RowBox[{"1", "-", "p"}]]}], ")"}], "n"]}]], "Output",
 ImageSize->{123, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->25550632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->274673166],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{"i", "\[InvisibleSpace]", "t", "\[InvisibleSpace]", "x"}]], 
   TraditionalForm]], "InlineMath"],
 " for real ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["CharacteristicFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacteristicFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->132165859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", "t", " ", "x"}], "]"}], ",", 
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"Element", "[", 
     RowBox[{"t", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->707810790],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[Alpha]"}]], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[Beta]"}]}], "]"}]}]], "Output",\

 ImageSize->{131, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306015071]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10323416],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[Alpha]"}]], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[Beta]"}]}], "]"}]}]], "Output",\

 ImageSize->{131, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4083682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177923447],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 " of a constant is the constant:"
}], "ExampleText",
 CellID->490515771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{"5", ",", 
   RowBox[{"BetaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580353118],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156522075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->820774602],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 " of a random variable is the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->132469126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{"x", ",", 
   RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395951940],

Cell[BoxData["\[Nu]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174302022]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->418974],

Cell[BoxData["\[Nu]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->95939238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185658241],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 " of the squared difference from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->129386802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "\[Nu]"}], ")"}], "^", "2"}], ",", 
   RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->309542871],

Cell[BoxData[
 RowBox[{"2", " ", "\[Nu]"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45597555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->440918251],

Cell[BoxData[
 RowBox[{"2", " ", "\[Nu]"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2293143]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23117],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CentralMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CentralMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skewness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skewness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Kurtosis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Kurtosis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacteristicFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6723],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->12144492],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->593894619],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->418134476],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->91722227],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->14305753],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->572717451]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpectedValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 46.1228020}", "context" -> "System`", 
    "keywords" -> {"expectation", "statistical expectation"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExpectedValue[f, dist] gives the expected value of the pure function f \
with respect to the symbolic distribution dist. ExpectedValue[f, dist, x] \
gives the expected value of the function f of x with respect to the symbolic \
distribution dist.", "synonyms" -> {"expected value"}, "title" -> 
    "ExpectedValue", "type" -> "Symbol", "uri" -> "ref/ExpectedValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10168, 301, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->128800641]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36277, 1311}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3524, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4147, 102, 1578, 37, 70, "ObjectNameGrid"],
Cell[5728, 141, 1423, 44, 70, "Usage",
 CellID->3338]
}, Open  ]],
Cell[CellGroupData[{
Cell[7188, 190, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7666, 207, 951, 34, 70, "Notes",
 CellID->946609506],
Cell[8620, 243, 889, 33, 70, "Notes",
 CellID->499729950],
Cell[9512, 278, 68, 1, 70, "Notes",
 CellID->28908],
Cell[9583, 281, 548, 15, 70, "3ColumnTableMod",
 CellID->2479172]
}, Closed]],
Cell[CellGroupData[{
Cell[10168, 301, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128800641],
Cell[CellGroupData[{
Cell[10553, 315, 147, 5, 70, "ExampleSection",
 CellID->39533191],
Cell[10703, 322, 206, 7, 70, "ExampleText",
 CellID->229912737],
Cell[CellGroupData[{
Cell[10934, 333, 220, 7, 28, "Input",
 CellID->118009070],
Cell[11157, 342, 337, 11, 36, "Output",
 CellID->863413446]
}, Open  ]],
Cell[11509, 356, 123, 3, 70, "ExampleDelimiter",
 CellID->6264413],
Cell[11635, 361, 62, 1, 70, "ExampleText",
 CellID->57896856],
Cell[CellGroupData[{
Cell[11722, 366, 227, 7, 70, "Input",
 CellID->361710915],
Cell[11952, 375, 337, 11, 36, "Output",
 CellID->126202982]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12338, 392, 216, 7, 70, "ExampleSection",
 CellID->16274],
Cell[12557, 401, 86, 1, 70, "ExampleText",
 CellID->297807881],
Cell[CellGroupData[{
Cell[12668, 406, 347, 11, 70, "Input",
 CellID->3982804],
Cell[13018, 419, 455, 17, 63, "Output",
 CellID->548429258]
}, Open  ]],
Cell[13488, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->294076702],
Cell[13616, 444, 74, 1, 70, "ExampleText",
 CellID->401804277],
Cell[CellGroupData[{
Cell[13715, 449, 350, 11, 70, "Input",
 CellID->425429202],
Cell[14068, 462, 176, 5, 36, "Output",
 CellID->90355780]
}, Open  ]],
Cell[14259, 470, 124, 3, 70, "ExampleDelimiter",
 CellID->64315683],
Cell[14386, 475, 78, 1, 70, "ExampleText",
 CellID->64045289],
Cell[CellGroupData[{
Cell[14489, 480, 237, 7, 70, "Input",
 CellID->162593845],
Cell[14729, 489, 931, 31, 73, "Output",
 CellID->31231496]
}, Open  ]],
Cell[CellGroupData[{
Cell[15697, 525, 343, 10, 70, "Input",
 CellID->607996792],
Cell[16043, 537, 414, 15, 51, "Output",
 CellID->192805979]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16506, 558, 221, 7, 70, "ExampleSection",
 CellID->32698399],
Cell[CellGroupData[{
Cell[16752, 569, 231, 7, 70, "ExampleSubsection",
 CellID->68359544],
Cell[16986, 578, 102, 2, 70, "ExampleText",
 CellID->513409952],
Cell[CellGroupData[{
Cell[17113, 584, 243, 7, 70, "Input",
 CellID->35208379],
Cell[17359, 593, 943, 28, 85, "Output",
 CellID->4721532]
}, Open  ]],
Cell[CellGroupData[{
Cell[18339, 626, 326, 9, 70, "Input",
 CellID->420545487],
Cell[18668, 637, 284, 10, 52, "Output",
 CellID->184856558]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19013, 654, 223, 7, 70, "ExampleSection",
 CellID->21135],
Cell[19239, 663, 82, 1, 70, "ExampleText",
 CellID->5128738],
Cell[CellGroupData[{
Cell[19346, 668, 294, 8, 70, "Input",
 CellID->378088085],
Cell[19643, 678, 370, 13, 68, "Output",
 CellID->83120021]
}, Open  ]],
Cell[20028, 694, 124, 3, 70, "ExampleDelimiter",
 CellID->90125477],
Cell[20155, 699, 130, 4, 70, "ExampleText",
 CellID->197390056],
Cell[CellGroupData[{
Cell[20310, 707, 422, 12, 70, "Input",
 CellID->391246382],
Cell[20735, 721, 1136, 41, 85, "Output",
 CellID->4756793]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21920, 768, 233, 7, 70, "ExampleSection",
 CellID->24828],
Cell[22156, 777, 367, 12, 70, "ExampleText",
 CellID->301259266],
Cell[CellGroupData[{
Cell[22548, 793, 227, 7, 70, "Input",
 CellID->22100871],
Cell[22778, 802, 210, 7, 52, "Output",
 CellID->307161901]
}, Open  ]],
Cell[CellGroupData[{
Cell[23025, 814, 452, 14, 70, "Input",
 CellID->681923683],
Cell[23480, 830, 210, 7, 52, "Output",
 CellID->161036806]
}, Open  ]],
Cell[CellGroupData[{
Cell[23727, 842, 246, 7, 70, "Input",
 CellID->422822880],
Cell[23976, 851, 419, 15, 53, "Output",
 CellID->335678637]
}, Open  ]],
Cell[CellGroupData[{
Cell[24432, 871, 374, 12, 70, "Input",
 CellID->309247236],
Cell[24809, 885, 418, 15, 53, "Output",
 CellID->25550632]
}, Open  ]],
Cell[25242, 903, 125, 3, 70, "ExampleDelimiter",
 CellID->274673166],
Cell[25370, 908, 589, 21, 70, "ExampleText",
 CellID->132165859],
Cell[CellGroupData[{
Cell[25984, 933, 408, 11, 70, "Input",
 CellID->707810790],
Cell[26395, 946, 383, 12, 38, "Output",
 CellID->306015071]
}, Open  ]],
Cell[CellGroupData[{
Cell[26815, 963, 224, 6, 70, "Input",
 CellID->10323416],
Cell[27042, 971, 381, 12, 38, "Output",
 CellID->4083682]
}, Open  ]],
Cell[27438, 986, 125, 3, 70, "ExampleDelimiter",
 CellID->177923447],
Cell[27566, 991, 218, 7, 70, "ExampleText",
 CellID->490515771],
Cell[CellGroupData[{
Cell[27809, 1002, 224, 6, 70, "Input",
 CellID->580353118],
Cell[28036, 1010, 158, 5, 36, "Output",
 CellID->156522075]
}, Open  ]],
Cell[28209, 1018, 125, 3, 70, "ExampleDelimiter",
 CellID->820774602],
Cell[28337, 1023, 333, 12, 70, "ExampleText",
 CellID->132469126],
Cell[CellGroupData[{
Cell[28695, 1039, 198, 6, 70, "Input",
 CellID->395951940],
Cell[28896, 1047, 162, 5, 36, "Output",
 CellID->174302022]
}, Open  ]],
Cell[CellGroupData[{
Cell[29095, 1057, 149, 4, 70, "Input",
 CellID->418974],
Cell[29247, 1063, 161, 5, 36, "Output",
 CellID->95939238]
}, Open  ]],
Cell[29423, 1071, 125, 3, 70, "ExampleDelimiter",
 CellID->185658241],
Cell[29551, 1076, 472, 17, 70, "ExampleText",
 CellID->129386802],
Cell[CellGroupData[{
Cell[30048, 1097, 277, 9, 70, "Input",
 CellID->309542871],
Cell[30328, 1108, 183, 6, 36, "Output",
 CellID->45597555]
}, Open  ]],
Cell[CellGroupData[{
Cell[30548, 1119, 156, 4, 70, "Input",
 CellID->440918251],
Cell[30707, 1125, 182, 6, 36, "Output",
 CellID->2293143]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30950, 1138, 311, 9, 70, "SeeAlsoSection",
 CellID->23117],
Cell[31264, 1149, 1706, 62, 70, "SeeAlso",
 CellID->943]
}, Open  ]],
Cell[CellGroupData[{
Cell[33007, 1216, 313, 9, 70, "TutorialsSection",
 CellID->6723],
Cell[33323, 1227, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[33479, 1232, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[33673, 1240, 299, 8, 70, "MoreAboutSection"],
Cell[33975, 1250, 154, 3, 70, "MoreAbout",
 CellID->12144492],
Cell[34132, 1255, 161, 3, 70, "MoreAbout",
 CellID->593894619],
Cell[34296, 1260, 185, 3, 70, "MoreAbout",
 CellID->418134476],
Cell[34484, 1265, 178, 3, 70, "MoreAbout",
 CellID->91722227],
Cell[34665, 1270, 174, 3, 70, "MoreAbout",
 CellID->14305753],
Cell[34842, 1275, 151, 3, 70, "MoreAbout",
 CellID->572717451]
}, Open  ]],
Cell[35008, 1281, 27, 0, 70, "History"],
Cell[35038, 1283, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

