(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30425,       1185]
NotebookOptionsPosition[     23240,        932]
NotebookOutlinePosition[     24631,        970]
CellTagsIndexPosition[     24546,        965]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Picking Out Pieces of Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"], 
          "Finding the Structure of a Polynomial" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingTheStructureOfAPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Picking Out Pieces of Algebraic Expressions\"\>", 
       2->"\<\"Finding the Structure of a Polynomial\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Coefficient" :> 
          Documentation`HelpLookup["paclet:ref/Coefficient"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"], "IntegerExponent" :> 
          Documentation`HelpLookup["paclet:ref/IntegerExponent"], 
          "CountRoots" :> Documentation`HelpLookup["paclet:ref/CountRoots"], 
          "NumberFieldSignature" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldSignature"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Coefficient\"\>", 
       2->"\<\"Cases\"\>", 3->"\<\"IntegerExponent\"\>", 
       4->"\<\"CountRoots\"\>", 
       5->"\<\"NumberFieldSignature\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Formula Manipulation\"\>", 
       2->"\<\"Polynomial Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exponent", "ObjectName",
 CellID->16595],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Exponent",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Exponent"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the maximum power with which ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " appears in the expanded form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Exponent",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Exponent"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " to the set of exponents with which ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " appears in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default taken for ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4975],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " can be a product of terms. "
}], "Notes",
 CellID->26925],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 " works whether or not ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is explicitly given in expanded form. "
}], "Notes",
 CellID->23745],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exponent"], "[", 
   RowBox[{"0", ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->395],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exponent"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the list of exponents for each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["form", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->350123436]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210716582],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->71682144],

Cell[TextData[{
 "Find the highest exponent of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->160430812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "3"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521855461],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72018539]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15629],

Cell["The degree of a polynomial:", "ExampleText",
 CellID->402387291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], "^", "3"}], "+", "1"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247301540],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41553318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->295517372],

Cell["Exponents may be rational numbers or symbolic expressions:", \
"ExampleText",
 CellID->234800020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Sqrt", "[", "x", "]"}]}], "+", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86221692],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   RowBox[{"1", "+", "n"}]}], "]"}]], "Output",
 ImageSize->{88, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408346179]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343631022],

Cell["The lowest exponent in a polynomial:", "ExampleText",
 CellID->361688139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], "^", "3"}], "-", "1"}], 
   ",", "x", ",", "Min"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203615753],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131131993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159589155],

Cell[TextData[{
 "The list of all exponents with which ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " appears:"
}], "ExampleText",
 CellID->52166245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "3"}]}]}], ",", "x", ",", "List"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104467886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->719734337]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3905],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6838],

Cell["The degree of a polynomial over the integers modulo 2:", "ExampleText",
 CellID->444559410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "-", "x", "+", "1"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5324303],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66250083]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18459],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trig"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 " recognizes dependencies between trigonometric functions:"
}], "ExampleText",
 CellID->113637308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19915346],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10589814]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21909],

Cell["Compute the leading coefficient:", "ExampleText",
 CellID->49570672],

Cell[BoxData[
 RowBox[{
  RowBox[{"LeadingCoefficient", "[", 
   RowBox[{"poly_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"Coefficient", "[", 
   RowBox[{"poly", ",", "x", ",", 
    RowBox[{"Exponent", "[", 
     RowBox[{"poly", ",", "x"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144643179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeadingCoefficient", "[", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"3", "x"}], "+", 
    RowBox[{"17", 
     RowBox[{"x", "^", "5"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37254470],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90514690]
}, Open  ]],

Cell["Compute the leading term:", "ExampleText",
 CellID->338456788],

Cell[BoxData[
 RowBox[{
  RowBox[{"LeadingTerm", "[", 
   RowBox[{"poly_", ",", "x_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", "=", 
      RowBox[{"Exponent", "[", 
       RowBox[{"poly", ",", "x"}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{"poly", ",", "x", ",", "n"}], "]"}], 
     RowBox[{"x", "^", "n"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->401110702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeadingTerm", "[", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"3", "x"}], "+", 
    RowBox[{"17", 
     RowBox[{"x", "^", "5"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->454636351],

Cell[BoxData[
 RowBox[{"17", " ", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->44278012]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3732],

Cell["\<\
The number of complex roots of a polynomial is equal to its degree:\
\>", "ExampleText",
 CellID->28884748],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "5"}], "-", 
    RowBox[{"2", "x"}], "+", "3"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462815262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5754354],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23477303]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to find the roots:"
}], "ExampleText",
 CellID->215857546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"x", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->199190552],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->460747419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->617888822],

Cell[TextData[{
 "Length of the ",
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " of a polynomial is one more than its degree:"
}], "ExampleText",
 CellID->244178820],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", "x"}], "-", "1"}], ")"}], "^", "7"}], "-", "3"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57436703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->477986880],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60198941]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"CoefficientList", "[", 
   RowBox[{"f", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->258378683],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->360253684]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20696],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 " is purely syntactical, it does not attempt to recognize zero \
coefficients:"
}], "ExampleText",
 CellID->381008763],

Cell[BoxData[{
 RowBox[{
  RowBox[{"zero", "=", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "+", 
    RowBox[{"Sqrt", "[", "3", "]"}], "-", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"zero", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "x", "+", "1"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->133867098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->163769279],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->255412968]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{"RootReduce", "[", "f", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->135225671],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->824611]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21696],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CountRoots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountRoots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldSignature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldSignature"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30799],

Cell[TextData[ButtonBox["Picking Out Pieces of Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]], "Tutorials",
 CellID->31121],

Cell[TextData[ButtonBox["Finding the Structure of a Polynomial",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingTheStructureOfAPolynomial"]], "Tutorials",\

 CellID->17999]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->448957838],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->485969428],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->49602996]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exponent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 56.1230580}", "context" -> "System`", 
    "keywords" -> {
     "leading coefficient", "leading term", "polynomial degree", "powers"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Exponent[expr, form] gives the maximum power with which form appears in \
the expanded form of expr. Exponent[expr, form, h] applies h to the set of \
exponents with which form appears in expr. ", "synonyms" -> {}, "title" -> 
    "Exponent", "type" -> "Symbol", "uri" -> "ref/Exponent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6972, 236, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->210716582]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24403, 958}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2647, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3270, 88, 46, 1, 70, "ObjectName",
 CellID->16595],
Cell[3319, 91, 1365, 44, 70, "Usage",
 CellID->25716]
}, Open  ]],
Cell[CellGroupData[{
Cell[4721, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5199, 157, 251, 11, 70, "Notes",
 CellID->4975],
Cell[5453, 170, 136, 5, 70, "Notes",
 CellID->26925],
Cell[5592, 177, 293, 10, 70, "Notes",
 CellID->23745],
Cell[5888, 189, 392, 16, 70, "Notes",
 CellID->395],
Cell[6283, 207, 652, 24, 70, "Notes",
 CellID->350123436]
}, Closed]],
Cell[CellGroupData[{
Cell[6972, 236, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210716582],
Cell[CellGroupData[{
Cell[7357, 250, 147, 5, 70, "ExampleSection",
 CellID->71682144],
Cell[7507, 257, 157, 6, 70, "ExampleText",
 CellID->160430812],
Cell[CellGroupData[{
Cell[7689, 267, 237, 8, 28, "Input",
 CellID->521855461],
Cell[7929, 277, 157, 5, 36, "Output",
 CellID->72018539]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8135, 288, 216, 7, 70, "ExampleSection",
 CellID->15629],
Cell[8354, 297, 70, 1, 70, "ExampleText",
 CellID->402387291],
Cell[CellGroupData[{
Cell[8449, 302, 261, 10, 70, "Input",
 CellID->247301540],
Cell[8713, 314, 157, 5, 36, "Output",
 CellID->41553318]
}, Open  ]],
Cell[8885, 322, 125, 3, 70, "ExampleDelimiter",
 CellID->295517372],
Cell[9013, 327, 103, 2, 70, "ExampleText",
 CellID->234800020],
Cell[CellGroupData[{
Cell[9141, 333, 300, 11, 70, "Input",
 CellID->86221692],
Cell[9444, 346, 256, 9, 51, "Output",
 CellID->408346179]
}, Open  ]],
Cell[9715, 358, 125, 3, 70, "ExampleDelimiter",
 CellID->343631022],
Cell[9843, 363, 79, 1, 70, "ExampleText",
 CellID->361688139],
Cell[CellGroupData[{
Cell[9947, 368, 273, 10, 70, "Input",
 CellID->203615753],
Cell[10223, 380, 158, 5, 36, "Output",
 CellID->131131993]
}, Open  ]],
Cell[10396, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->159589155],
Cell[10524, 393, 172, 6, 70, "ExampleText",
 CellID->52166245],
Cell[CellGroupData[{
Cell[10721, 403, 250, 8, 70, "Input",
 CellID->104467886],
Cell[10974, 413, 213, 7, 36, "Output",
 CellID->719734337]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11236, 426, 217, 7, 70, "ExampleSection",
 CellID->3905],
Cell[CellGroupData[{
Cell[11478, 437, 223, 7, 70, "ExampleSubsection",
 CellID->6838],
Cell[11704, 446, 97, 1, 70, "ExampleText",
 CellID->444559410],
Cell[CellGroupData[{
Cell[11826, 451, 251, 8, 70, "Input",
 CellID->5324303],
Cell[12080, 461, 157, 5, 36, "Output",
 CellID->66250083]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12286, 472, 221, 7, 70, "ExampleSubsection",
 CellID->18459],
Cell[12510, 481, 465, 17, 70, "ExampleText",
 CellID->113637308],
Cell[CellGroupData[{
Cell[13000, 502, 234, 7, 70, "Input",
 CellID->19915346],
Cell[13237, 511, 174, 6, 36, "Output",
 CellID->10589814]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13472, 524, 223, 7, 70, "ExampleSection",
 CellID->21909],
Cell[13698, 533, 74, 1, 70, "ExampleText",
 CellID->49570672],
Cell[13775, 536, 308, 9, 70, "Input",
 CellID->144643179],
Cell[CellGroupData[{
Cell[14108, 549, 237, 8, 70, "Input",
 CellID->37254470],
Cell[14348, 559, 158, 5, 36, "Output",
 CellID->90514690]
}, Open  ]],
Cell[14521, 567, 68, 1, 70, "ExampleText",
 CellID->338456788],
Cell[14592, 570, 486, 15, 70, "Input",
 CellID->401110702],
Cell[CellGroupData[{
Cell[15103, 589, 231, 8, 70, "Input",
 CellID->454636351],
Cell[15337, 599, 204, 7, 36, "Output",
 CellID->44278012]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15590, 612, 232, 7, 70, "ExampleSection",
 CellID->3732],
Cell[15825, 621, 117, 3, 70, "ExampleText",
 CellID->28884748],
Cell[15945, 626, 242, 9, 70, "Input",
 CellID->462815262],
Cell[CellGroupData[{
Cell[16212, 639, 125, 4, 70, "Input",
 CellID->5754354],
Cell[16340, 645, 157, 5, 36, "Output",
 CellID->23477303]
}, Open  ]],
Cell[16512, 653, 199, 8, 70, "ExampleText",
 CellID->215857546],
Cell[CellGroupData[{
Cell[16736, 665, 217, 7, 70, "Input",
 CellID->199190552],
Cell[16956, 674, 158, 5, 36, "Output",
 CellID->460747419]
}, Open  ]],
Cell[17129, 682, 125, 3, 70, "ExampleDelimiter",
 CellID->617888822],
Cell[17257, 687, 255, 8, 70, "ExampleText",
 CellID->244178820],
Cell[17515, 697, 275, 11, 70, "Input",
 CellID->57436703],
Cell[CellGroupData[{
Cell[17815, 712, 127, 4, 70, "Input",
 CellID->477986880],
Cell[17945, 718, 158, 5, 36, "Output",
 CellID->60198941]
}, Open  ]],
Cell[CellGroupData[{
Cell[18140, 728, 168, 5, 70, "Input",
 CellID->258378683],
Cell[18311, 735, 159, 5, 36, "Output",
 CellID->360253684]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18519, 746, 226, 7, 70, "ExampleSection",
 CellID->20696],
Cell[18748, 755, 254, 8, 70, "ExampleText",
 CellID->381008763],
Cell[19005, 765, 471, 16, 70, "Input",
 CellID->133867098],
Cell[CellGroupData[{
Cell[19501, 785, 127, 4, 70, "Input",
 CellID->163769279],
Cell[19631, 791, 158, 5, 36, "Output",
 CellID->255412968]
}, Open  ]],
Cell[CellGroupData[{
Cell[19826, 801, 165, 5, 70, "Input",
 CellID->135225671],
Cell[19994, 808, 155, 5, 36, "Output",
 CellID->824611]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20210, 820, 311, 9, 70, "SeeAlsoSection",
 CellID->21696],
Cell[20524, 831, 1228, 44, 70, "SeeAlso",
 CellID->17958]
}, Open  ]],
Cell[CellGroupData[{
Cell[21789, 880, 314, 9, 70, "TutorialsSection",
 CellID->30799],
Cell[22106, 891, 195, 4, 70, "Tutorials",
 CellID->31121],
Cell[22304, 897, 182, 4, 70, "Tutorials",
 CellID->17999]
}, Open  ]],
Cell[CellGroupData[{
Cell[22523, 906, 319, 9, 70, "MoreAboutSection",
 CellID->448957838],
Cell[22845, 917, 151, 3, 70, "MoreAbout",
 CellID->485969428],
Cell[22999, 922, 146, 3, 70, "MoreAbout",
 CellID->49602996]
}, Open  ]],
Cell[23160, 928, 50, 0, 70, "History"],
Cell[23213, 930, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

