(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15707,        551]
NotebookOptionsPosition[     12424,        443]
NotebookOutlinePosition[     13862,        482]
CellTagsIndexPosition[     13777,        477]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExponentStep" :> 
          Documentation`HelpLookup["paclet:ref/ExponentStep"], "NumberFormat" :> 
          Documentation`HelpLookup["paclet:ref/NumberFormat"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExponentStep\"\>", 
       2->"\<\"NumberFormat\"\>", 
       3->"\<\"NumberForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExponentFunction", "ObjectName",
 CellID->9639],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ExponentFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which determines the exponent to use in printing \
approximate real numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 " first find the exponent that would make exactly one digit appear to the \
left of the decimal point when the number is printed in scientific notation. \
Then they take this exponent and apply the function specified by ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " to it. If the value obtained from this function is an integer, it is used \
as the exponent of the number. If it is ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ", then the number is printed without scientific notation. "
}], "Notes",
 CellID->31081],

Cell[TextData[{
 "The argument provided for the function specified by ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " is always an integer. "
}], "Notes",
 CellID->11064],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 ", the default setting for ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " never modifies the exponent, but returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " for machine numbers with exponents between ",
 Cell[BoxData[
  RowBox[{"-", "5"}]], "InlineFormula"],
 " and ",
 Cell[BoxData["5"], "InlineFormula"],
 ", and for high\[Hyphen]precision numbers where insignificant zeros would \
have to be inserted if the number were not printed in scientific notation. "
}], "Notes",
 CellID->21896],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["ScientificForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScientificForm"]], "InlineFormula"],
 ", the default setting for ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " only for real numbers with single-digit integer parts. "
}], "Notes",
 CellID->1933],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["EngineeringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EngineeringForm"]], "InlineFormula"],
 ", the default setting for ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " returns an exponent that is a multiple of 3. "
}], "Notes",
 CellID->19984],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 ", the default setting for ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " always returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22150]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->397655480],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->121393788],

Cell[TextData[{
 "Compute approximate powers of ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->366167851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"N", "[", 
   RowBox[{"E", "^", 
    RowBox[{"Range", "[", 
     RowBox[{"10", ",", "50", ",", "10"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->680311399],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "22026.465794806718`", ",", "4.851651954097903`*^8", ",", 
   "1.0686474581524463`*^13", ",", "2.3538526683702`*^17", ",", 
   "5.184705528587072`*^21"}], "}"}]], "Output",
 ImageSize->{448, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84366191]
}, Open  ]],

Cell["Default formatting to 5 digits:", "ExampleText",
 CellID->9190778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"p", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->489307867],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"22026.\"\>",
     22026.465794806718`,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"4.8517\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"8\"\>"]}],
     4.851651954097903*^8,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"1.0686\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"13\"\>"]}],
     1.0686474581524463`*^13,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"2.3539\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"17\"\>"]}],
     2.3538526683702*^17,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"5.1847\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"21\"\>"]}],
     5.184705528587072*^21,
     AutoDelete->True]}], "}"}],
  NumberForm[#, 5]& ]], "Output",
 ImageSize->{411, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//NumberForm=",
 CellID->1444035]
}, Open  ]],

Cell["Restrict exponents to multiples of 3:", "ExampleText",
 CellID->39958351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"p", ",", "5", ",", 
   RowBox[{"ExponentFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"Quotient", "[", 
        RowBox[{"#", ",", "3"}], "]"}]}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->151076572],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"22.026\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"3\"\>"]}],
     22026.465794806718`,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"485.17\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"6\"\>"]}],
     4.851651954097903*^8,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"10.686\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"12\"\>"]}],
     1.0686474581524463`*^13,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"235.39\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"15\"\>"]}],
     2.3538526683702*^17,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"5.1847\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"21\"\>"]}],
     5.184705528587072*^21,
     AutoDelete->True]}], "}"}],
  NumberForm[#, 5, ExponentFunction -> (3 Quotient[#, 3]& )]& ]], "Output",
 ImageSize->{442, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//NumberForm=",
 CellID->1028279785]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7309],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExponentStep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentStep"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFormat"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5145],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->21933]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExponentFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 54.5448926}", "context" -> "System`", 
    "keywords" -> {
     "exponent representation", "number formatting", "numeric formatting", 
      "number output", "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExponentFunction is an option for NumberForm and related functions which \
determines the exponent to use in printing approximate real numbers. ", 
    "synonyms" -> {"exponent function"}, "title" -> "ExponentFunction", 
    "type" -> "Symbol", "uri" -> "ref/ExponentFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6660, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->397655480]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13634, 470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1420, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2043, 62, 53, 1, 70, "ObjectName",
 CellID->9639],
Cell[2099, 65, 663, 19, 70, "Usage",
 CellID->8474]
}, Open  ]],
Cell[CellGroupData[{
Cell[2799, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3277, 106, 841, 21, 70, "Notes",
 CellID->31081],
Cell[4121, 129, 263, 8, 70, "Notes",
 CellID->11064],
Cell[4387, 139, 806, 24, 70, "Notes",
 CellID->21896],
Cell[5196, 165, 533, 18, 70, "Notes",
 CellID->1933],
Cell[5732, 185, 401, 13, 70, "Notes",
 CellID->19984],
Cell[6136, 200, 487, 18, 70, "Notes",
 CellID->22150]
}, Closed]],
Cell[CellGroupData[{
Cell[6660, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->397655480],
Cell[CellGroupData[{
Cell[7045, 237, 148, 5, 70, "ExampleSection",
 CellID->121393788],
Cell[7196, 244, 172, 6, 70, "ExampleText",
 CellID->366167851],
Cell[CellGroupData[{
Cell[7393, 254, 217, 7, 28, "Input",
 CellID->680311399],
Cell[7613, 263, 344, 10, 39, "Output",
 CellID->84366191]
}, Open  ]],
Cell[7972, 276, 72, 1, 70, "ExampleText",
 CellID->9190778],
Cell[CellGroupData[{
Cell[8069, 281, 129, 4, 28, "Input",
 CellID->489307867],
Cell[8201, 287, 998, 32, 53, "Output",
 CellID->1444035]
}, Open  ]],
Cell[9214, 322, 79, 1, 70, "ExampleText",
 CellID->39958351],
Cell[CellGroupData[{
Cell[9318, 327, 316, 10, 70, "Input",
 CellID->151076572],
Cell[9637, 339, 1113, 34, 53, "Output",
 CellID->1028279785]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10811, 380, 310, 9, 70, "SeeAlsoSection",
 CellID->7309],
Cell[11124, 391, 715, 26, 70, "SeeAlso",
 CellID->5361]
}, Open  ]],
Cell[CellGroupData[{
Cell[11876, 422, 313, 9, 70, "TutorialsSection",
 CellID->5145],
Cell[12192, 433, 160, 3, 70, "Tutorials",
 CellID->21933]
}, Open  ]],
Cell[12367, 439, 27, 0, 70, "History"],
Cell[12397, 441, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

