(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8785,        318]
NotebookOptionsPosition[      6095,        232]
NotebookOutlinePosition[      7521,        271]
CellTagsIndexPosition[      7437,        266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ExponentFunction" :> 
         Documentation`HelpLookup["paclet:ref/ExponentFunction"], 
         "EngineeringForm" :> 
         Documentation`HelpLookup["paclet:ref/EngineeringForm"], "NumberForm" :> 
         Documentation`HelpLookup["paclet:ref/NumberForm"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"ExponentFunction\"\>", 
      2->"\<\"EngineeringForm\"\>", 
      3->"\<\"NumberForm\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExponentStep", "ObjectName",
 CellID->32540],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ExponentStep",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ExponentStep"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which determines in what steps exponents are \
taken to increase when scientific notation is used."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11887]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ExponentStep", "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 ", all exponents given will be multiples of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531230576],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->81029026],

Cell["Default formatting to 10 digits:", "ExampleText",
 CellID->9190778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"1234567890.", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->489307867],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"1.23456789\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"9\"\>"]}],
   1.23456789*^9,
   AutoDelete->True],
  NumberForm[#, 10]& ]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->214567783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->706770784],

Cell["Restrict exponents to multiples of 6:", "ExampleText",
 CellID->39958351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"1234567890.", ",", "10", ",", 
   RowBox[{"ExponentStep", "\[Rule]", "6"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151076572],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"1234.56789\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"6\"\>"]}],
   1.23456789*^9,
   AutoDelete->True],
  NumberForm[#, 10, ExponentStep -> 6]& ]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->10382418]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23040],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExponentFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EngineeringForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EngineeringForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1582]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExponentStep - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 56.5761946}", "context" -> "System`", 
    "keywords" -> {
     "number display", "number formatting", "numeric formatting", 
      "number output", "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExponentStep is an option for NumberForm and related functions which \
determines in what steps exponents are taken to increase when scientific \
notation is used.", "synonyms" -> {"exponent step"}, "title" -> 
    "ExponentStep", "type" -> "Symbol", "uri" -> "ref/ExponentStep"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2988, 105, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->531230576]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7294, 259}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 825, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1448, 46, 50, 1, 70, "ObjectName",
 CellID->32540],
Cell[1501, 49, 678, 19, 70, "Usage",
 CellID->11887]
}, Open  ]],
Cell[CellGroupData[{
Cell[2216, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2694, 90, 257, 10, 70, "Notes",
 CellID->22226]
}, Closed]],
Cell[CellGroupData[{
Cell[2988, 105, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531230576],
Cell[CellGroupData[{
Cell[3373, 119, 147, 5, 70, "ExampleSection",
 CellID->81029026],
Cell[3523, 126, 73, 1, 70, "ExampleText",
 CellID->9190778],
Cell[CellGroupData[{
Cell[3621, 131, 140, 4, 28, "Input",
 CellID->489307867],
Cell[3764, 137, 348, 12, 50, "Output",
 CellID->214567783]
}, Open  ]],
Cell[4127, 152, 125, 3, 70, "ExampleDelimiter",
 CellID->706770784],
Cell[4255, 157, 79, 1, 70, "ExampleText",
 CellID->39958351],
Cell[CellGroupData[{
Cell[4359, 162, 191, 5, 70, "Input",
 CellID->151076572],
Cell[4553, 169, 366, 12, 50, "Output",
 CellID->10382418]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4980, 188, 311, 9, 70, "SeeAlsoSection",
 CellID->23040],
Cell[5294, 199, 729, 26, 70, "SeeAlso",
 CellID->1582]
}, Open  ]],
Cell[6038, 228, 27, 0, 70, "History"],
Cell[6068, 230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

