(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    122429,       2806]
NotebookOptionsPosition[    114705,       2533]
NotebookOutlinePosition[    116073,       2571]
CellTagsIndexPosition[    115986,       2566]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GammaDistribution" :> 
          Documentation`HelpLookup["paclet:ref/GammaDistribution"], 
          "LaplaceDistribution" :> 
          Documentation`HelpLookup["paclet:ref/LaplaceDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GammaDistribution\"\>", 
       2->"\<\"LaplaceDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExponentialDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExponentialDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExponentialDistribution"], "[", 
       StyleBox["\[Lambda]", "TR"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an exponential distribution with scale \
inversely proportional to parameter ",
     Cell[BoxData[
      FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in an exponential distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Lambda]"}], "\[InvisibleSpace]", "x"}]], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", and is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", "0"}], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21862,
  ButtonNote->"21862"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->4712],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2645,
  ButtonNote->"2645"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->345793326],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->81183387],

Cell["The mean and variance of an exponential distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->2645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->3394],

Cell[BoxData[
 FractionBox["1", "\[Lambda]"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198286768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->19645],

Cell[BoxData[
 FractionBox["1", 
  SuperscriptBox["\[Lambda]", "2"]]], "Output",
 ImageSize->{21, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299080568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->21862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32072],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "x"}], " ", "\[Lambda]"}]], " ", "\[Lambda]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396721599]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", "1", "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2480],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns803scx3H3xKrNOhJl0/FIVunqODun+nyj00mbnQ4T042tKDnKOiP9
IkdOzpyzOOJYcxld6DZS6eS249JqLiOtdKGH6ziRRnIqyc63P96P9+P538uJ
f8h3n4mRkREH7/PnxvMtVu0lNizK82gwGPRwV0tnB9B5oCR2soTjejDcU56k
0w/A0n2UipcDesitkdDM6bFwxE3oP6jRQ8R60U/vaGL4odqVszBHD9qP+zNG
aWdh/qYKmZCphxkdvS4jtMvACdSGlMW8hoJGedQwrRxK/Jzs15qMQHGJuCPC
rREqhemehXOHIAzazr4SaqHawEpi5g5CpM6171bxM3hieYW5KkIHVk5JLl1f
d0OSPmnad3MfnCY3MQqC+4CUfybCKKYH+B3cf0ybBwCdKs2uFXRBlCqJf8hl
CDL/3k+K8uqE0sMkPzvvEaCzMwNe5z+DAuLg0MqAUWiXjpUJSE8gUT7149tX
YzAQpI3TdT0CI203qjo2DlF29XHcsYew+OfQo1zGBPQ8p7J3kNqgfyJru3X1
f6C0YLYFDbbAVl14XHrUe2jODVudeb8JOP1pSx0dJyFmgU+ek3kDDNXzE9SK
j1DinuOmKL0HbpT2hV57PoFDdHn4xvC7YAUTIZ3j01Bc9SnyenwdfD8S9G6R
vxH6d8DxC7u8Gnhat9c4aJkx2mx97XHscDWU/XZ3N33CGMV/aZjrQa+EUHNR
d0uLCXq7VaufEtwBgZAoI8lMUcaJwG12trdhRdjSFnaIGWJcuuoxPPMWtNos
sxYxzdFadbnCxvIGVBYnZi8ztUBb2kuO2QZcB8KYsa35hQVa40BKsd+jAKvO
Y1sib81AL1ODn08Kr4Cu0ClDftwSdTNatx6aKoKMJfPNyv1notJzwf3a9IuQ
Jgu9H0K3QiY5Os3xlPMQlLGrhTRohXylviqTqgJ4v+niB7nSGlmSeY8evZJD
n87zaF0yCXGfbJFwR3Pg3PpVDpqQWUihfTxvkZkMFL+KKGHLZyNxjI/shSQL
kv0FLNOJ2WiqPobZvysT3DsLLidr5qCy5Dsn6MwzIHXNVmhYZET+pep3Zfif
cKJGImWVk1F1PG3lSp9U8HHwv9joTEGyGxWzzrv9ARsj7++giCnomzg7Yb5E
DPIFfOfmCQo63Mn97tzkKXCuL/qLs8MG0Slid1FrEqQtr2M8VNogx+ueOba9
iRA6btbWwKAilWpOb+B0AvBL39DFqVS0OrDJJVITD+pGy5NVU1Tko/Iu0pQQ
EOHVk9aAraJfZR/BJleV57Vj5/PWjNthByrCK0axRdw7XnuLCRhMbR5z/kRF
+8wz3kxeI8DCPy1Ygp1glZq85AoBXl3zNuyepiL+9tjTSRcIGAgYZR3EVtqW
BDKwUx6oeUexN62zdn5wnoCHtbGidOz+oq+UDtj8Cx3X7mHzpDyjmwUEJByQ
O6wwUFFDZnNlTx4Bzr0xruuwPw6ESpOx1UHbPLyxeSEu0cuxyWxjPwF2Vp29
e2wuAXI3QUoWNqOlsYacQ4Bn0bfSC9j1hszC29m4jza3sBQ7cV2yZCe2G0VV
24QtVnfsviTDfeLc1qfYfmTw5mBHm0S/0GGzuOq1b88SYE9wht9g30yLcZJh
K8cXfzBgN9Wy5yDs/wEsKk4W
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0, 5}, {0., 0.9999998979591889}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->553975255]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3542],

Cell["\<\
Generate a set of pseudorandom numbers that are exponentially distributed:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->29608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "1", "]"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6959541425902025`", ",", "0.5426136811908007`", ",", 
   "0.31264209759910044`", ",", "0.0926211802745608`", ",", 
   "0.19081903541322287`"}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148651893]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6125],

Cell["Properties based on higher-order moments:", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->20134],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306285942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->18382],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291185303]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20736],

Cell["Third moment of an exponential distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->27478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17939],

Cell[BoxData[
 FractionBox["6", 
  SuperscriptBox["\[Lambda]", "3"]]], "Output",
 ImageSize->{21, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218201216]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18721],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of an exponential distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->31426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10663],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "q"}], "]"}], "\[Lambda]"]}]], "Output",
 ImageSize->{78, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112465210]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25981],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->29591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", 
      RowBox[{"1", "/", "2"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25867],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns01GkYwPFB1HE7RiVMzExjsxRKW7YTnheFIkc069IpDI1I2S4j00hW
WrRh1plitJplUYSyq5hdTZnCuJdLa1fJbcp1flMapFr7zh/PeZ7Pef750lnx
AUc1SSSSHx71Lkxm6WyN+skVn8SWKJ7r016abxAtBkhpq7xiKCGw3Cy5RKNx
gdRfoNhjEgOFj7Oo2rRMSGme8GTqcyHOhXNigSoEVMnnVC5mQO+nYwIltRyG
k+puVz7Ph5WDo9azVDHQeG2j5Wm3oahNdGqa2goZLJV9mKIOqu9mDsbZ/wtr
tj9QsataIBqeC2dOj8GPpGMLV5uewUm5zVht9SQEKO5cLbTuB116mvXrb5Ww
SJvXDD3zD2QbtdsWhc/BxKOBjcvkV8AaPPhIq2Mehp2tHal+w3CqKY0Vb70E
O0rauV5DI1DzvX6g6d4voAzZ3pfhMAZFvONTW4JI6Nq2lV91ccchVfT5wIcZ
DZQVYOJmwJcDqXcYNZzXQrIzlo3M9Dew8Sw78aCtNuIbz4f0cN/CuCrvO72H
OshfUuNj4zkB++SxF3JPrUJZpuw/zA0nwW+cv8nSUheN1sfl10kmYeoJK0VW
pYcE74NrBYFTYE9+YeERZoC4xQdK4+VToAuqiJdzhqiPj8YDw6fBazZ0YQPT
CHl61i9xB6ZhQBqlEbqZjPKS9zXx3WfgfsbTIzQVGfEp4RYfb8wAW5sz3NVl
jIqva7NS5mYg8jTvvn7BamSo/KBydpkFh+hNXb4Ra9CnK7pCafIsdBtv1uPs
XIuWmr0rvkhm4a/q1BubtUyQk3bFFgvVLPA0bP07Xpmg/a5hQYa2CtB9ed77
ZO06pLEQEvAsWAHyMrpAlGSKAgwC9XamKEDwtdkKMdMM9avEjT1lCuAXsFsi
aOYIldG3BbcoIFRwuEv/rTnivajohXEFLO4u/SiSUFCK0+EQIYmAMbl7ojR9
PdojvnbogikBxS5bKZ0RFijygBsx5EBA1WUOOdrOEu0W2K3+2YOAdGakj5bK
Eg27fTNkxCRg+8ui8vROKpLu0vy8g01Avs2Nqk4fGlqkFOtVnCXg4uOsfB8x
DWmnArSnErCfwixts6KjHWtbz+zJIcDtZMshciYd6d10Sm4VEiBaz7LqUNFR
duVUwtoSAqye3Lrud2gDahi02SStJIBvJ7XtkWxASJVdeq6WAPbciuettgw0
+fjcLzoNBLBq3tMycxjIP+Ye46iUAFnbqksNnxmIE1cT9auMgDiPEX4rtqSc
bVaEbdQgvvkCe7/QrEvt4KrYP5XYQTmJTr9hv83peGf1hYFUf5vrlmHrMPnh
WdjTI8rqO9ger9e5HvmPgQINxuYfYL8JUvocx+4t8rtTh33lmSwkETt9si6s
HrunkcvJxb6Xe0kmxmaVDFY2Y3f7LgsbsFNiRBSHZQbqY2c4S7GtRs/ZOGM7
OnYr1ZaF+jvtxXapWV36RN3vqxEYic1ru2bQhC2yj7yShx0VmzzUgu1+a1d+
CTap7/dcmbqPuqasBjv93bhnK7Y9uamxHTve2/1um7ovs7B7APv1Dyci27ET
NBNeybGD4q+v68A25/lNv1f/jR62qy2Z2/hxGTuJPXKxE/t/ifpnIg==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0, 10}, {0., 0.9932620523133688}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298703914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259224347],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", 
     RowBox[{"1", "/", "10"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17668],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxkXQVUVk0TprEVsbu7RVQU5yqKit3Ygdjd3X52oWIXoKIYiGIA0iEG3d0N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   "], {{{}, 
     {RGBColor[0.3372603901985486, 0.13363795371994458`, 0.5910405944118994], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2lsVVUQPn3v9tx370OwC4WgSCu4IUvLYjAtKP4QKKUCMVCFSGijlk3R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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVlUQx8+3cO93v9sWgVKwUKAUBEvZxBiMGI0PQqGttDEUFGNoowIF
t+gL7uDaQDcQFQpIjFRxXwApoFJRXFBLyyLirqCSqKjxQYyJv/F/Hv65M2fO
mTln1ltcd1PNjUnnXCtIg5bIuWbwB/RtKefaoFvBP/AbEs7tDZwrCp17mu8U
MA66AKyB7gRjoQeAJujt4DzOTga5nC9GX07MuUj01D7O9WSc6wVzuMQJ9lRm
nbsLrOIy14J29nei7zpsv4C+TfAH4B+Efw1+A3wX/M3wL8GPge4PVkJvAwdB
P/hLElorhR4I2qB3gunYagxley72yuFngFPwe7jjfdDHQ729P/ynnHkLPAwe
AsuRL0Bez/1XpyXrC/+I39MGXcR78zlbAFrgh8D3gx4A1nJ+C2uLOfssmACd
a+/j7B6wH+TAP8B3Fgh470r4SujJ+K8JuhB97QnFqAT+S2TrwYvgE5AX6q4r
wLsghr+f70zTif0KMDepGJyLLB+0INsBzkH3aIBZV5hSbK5BviCpGC2DrgIl
0H+xtgX5PFDJ/t2sjUDWhZ7zwTNgGPwpvm+CJcg/4JtlbTnfKnAEW0cj5V5f
dHzEWoS8hu8V4GMQhqKrwXxsXQ3ms3dpWr6cA78oLZ8G6ApBGXdbllCsLgAT
AsUsA/02dAWYHehsB2sNaelI8/A+sXLjIvaXWv6h7w3utwr/58IvAldytgP9
ozj7NfRG8DJIsjdl+Z5Ujp5gbSh7FqZVQ7+S+7+BP5FXIH/U3mY5AZ0CJ73P
zFcd0O/4mFosy0Ehsp/47ga17BmHrVKQgz+KUrL1s88lszka/lurI/AqaIef
jb06ZPXgdvhyy4G07rSRt+0P5btX2D8xVA+Y4mNYjjwPXIwvJlq+IP+e75Pg
ddANzmKtMVBNmO7ruV91SjaK4Y+x/gTYajmBriX4YzD2au0s/OlQ9GXY+MG/
2d76VKBcnATKAuXknZHubHc1n1tsh4TaazG+N1IPsd5hOXED/GnszUvoTvWR
YmKxqIIvgx8fyZfWwywXD/hcsZw8ieyxrGp3X0Jv/dDncqOvtX0+VlZzFtsV
WfUKi/GhQDVrtWo9qSeQT8wX1kPHoH9spNqzmNZy9t9QtWU5anf/PaPaszec
jWwweJyzmwP5cmlGdzOfjkDXatuDvkFgGHwP2As9EEzHNzFYn5BPj7H3Hmw2
pdVjZsTKect1q6G7kU0DZ5z2FKOrF3SlZMN62fu+d1lPK4MfBNZC7wKjONvA
/iipHjISuiTS3aznjA/1ps0+x61XhbF6n/WsqdAXxpoleeyfZrkYqzath1vv
GR6qdqwHLYyV85brVrPWq67KqndYzzqM7UORdFmN3xJpxthsKcBeA/TiWLVp
OX85uuoi5Uo6rbcPj9TrzQf2NpthNrvsjdb7m0PNEpsBNpt+9L3RZlQ38oOR
Zo/N4FtD2TDddyQVq6GRZofFrJnYzoxVe/lOsajKanZaTEZy9jiydeB50JLR
GdtrMf4m0Azv9D3hb2RnMnqrzdwC6O6sbP8CvxX+uYxo67lZmw2ReqPNZJtV
7/nZYjOrhrPVYJJTj/nO58Au3yMuhZ4Vq7Ztz1HfQ6x3WA5/HuifYrt/wxeB
ZtQOP+O+CjTTd/qe+1mgf4BtvqccDtSTrRfbP8qRQD3Qep/lYG8gH/3vm0Cz
ujVULdjM/g9pqg2U
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.42494917059564585`, 0.2861050611598338, 0.7142977832356981], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuw1VUVx3/nnnPuOb/fSeofCC5XUC5gWqBc5CkWMzAiIC+FTC4I4QVM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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmeMVVUUhe/MezP3nfsU8YcgJfQiKJ2hKBiMhCoWSkRgZIShD0PAgGZE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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.512637950992743, 0.4385721685997229, 0.8375549720594968], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuwllUVxt/ve7+P93JylOliBNiNhBHDJlAroDxeRxFqIGzS5kDeuIxg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmIllUUxu/3faPvd98xIlrMlKIwkRaLytzLLbNUCk2jBWfQHBdMU8ko
UZtMyyi0XGd0ZnJD01Y30pk0ctRAswgN09xzCQ1yG/9w6/fwzB8HzvOec889
99xznvvePWh031HZEMIipAD5Ig0hkw9hC+An5Df0BUkIlTj9gcwBz0Za4vt1
JoRh6IOwtwCvBI+MIdxLjOas7Z8L4Q3so5Fm2LYjs9CnYZ+HvYp48/EvQ5rj
24wYjdBvQBLwB/gPRF+DzAePYU0Je3VEfgcPY/1nxPsL+66cc5yG7WWkU0F9
DPaamjo37dm7MIQ+yBJ8t/JtBOuP4z+gYQhDlQ96F+J9gy1FKlhbx7c1rF1d
4LMuxD455zNH9PeQYfX5HsH+OXhKzjGugZcTYxNrX2KPQ9gOIhsyPsNAbN/h
U4Y+Fp9qbDXIQHAZ8YvIbyuyg9z2Ij/jOxH7PegTiNEJfBjcOuc7US26Ig/l
XJNb0W9DuuM/A//X0dsQ75YGIbyIvZV8kRPYm7J+I/kUYj+ccc0/RZ+D/W30
Cnz6Ye+PDCXXG/GpRK/Cp2twjX7BtxjcF99JrDmHvp4c+6LX8e0yuDpxb1wB
L8D/QGLficgI8EV8XiF2P/Bc8GxkccY5fMJ+FUn93ux3DN8ycCtsJ4lXjf1f
vp1F/xP7OdZ2w/4c+fXA53vwRsVDb4xPNu+eV6/XIpXYBuM/BFspPh+Bb471
tQOfTX1HuhvVUGe/CD6Tcw2ugH9IXFud7wz4q8R7/weejG+D6Lsr4dt59IDP
j+x9GnwNXJS6Fw4g70fPhHprOPbi6JnQLPQCz8D3JPHXZ9zTHRLPmGbr4Ybu
vet821zgHpwFPg3eiP9jrF9GrKXITRl/64jeHsmj34e9Cv048WLGPV0LnhSd
+5dITeIz66wDwL3Bw6Pvrgn7HQS3FifkPDMb2L8m9d2ox9ozi8WJZ3+36one
E/9Hc+7pHuhLkOnoj+TMLRfY71LWHHMd2+bUtTqqeQC3JcZOfO9HyhP3iHpD
M3Ep8UxrltciT0bfue76Aa0hn0XRsz+LfBbiezExdy0VZ2CbiozQfCPj0d9E
VgTPrHKvTFxbneFv9q7g27vop0S0qXNWruPBI/EdVWhuUI82wX4H0pjcLuMz
Dt9afMZkPPPiqo81AwXmrNLoO9FdiIPGst+q1L3cUj1L7LOJuW4k659FX43P
uqz3SLEPAReB9yOLiXUMn28znqm24gvwDvFLznufSDx7ymEPawfnvXYf0g5b
CfhV9DuD70IcIu7QnRSr9nzrgz6O9Z3Zv0uha609q/GtQR7Muqbd2f+p6LdH
MZuyvhfrJwRzinLrEN2rynELeGz0bKtmr6l3ib8g6zOqlztH37V6+iT46eje
0gwMVS0Sc6E4Zz+2fdFvnThBtVsLLs+5hitS11y11gzvQt+G7MS2G3kr8Uxo
FkrBa7Qeuaq7YY9SbP2Q9thnYh+P/k7ed68z/qP6pe49vRnPyJbaVzW6C3wo
dWzF/BW8O++72IPU5t2z6lW9IeJGcZK4SBx5nvjlqXtjG+tXai/szwf/A5zP
m8PF3Zq5U/jPTP1WinP0tlelniW98Xp7p0dzpd7gDehXdd6sOVdnnRLNZTrz
bPDR+vnUP8B6bOuia6MeEXdVYl+eNYdplj5kv7ICz5S4Qf8E+hcQR1yI5lRx
qThZscuj3xbtUcbac4nPqpjTot9w8atmel40J4mL9CZuz/sN1turO52beKY1
y+I0ne1yPf/pjI3QN6We7SPEfJx47aJnJxGnYu9G/OvEL8yaa5+I5ipxbhv0
eYl9VyG3g5tE36Xe1BdSc7y4XW/wdPDeaF/VpE7cmHdsvaHq1aLot0I9q7td
lnduumP9e2gmNYv6B1FuLVJzuXL8H7HPaEM=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5906611223912589, 0.5706902578101597, 0.9101106164649829], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1slWcZxt9z3vf0nPdQWAVm5h9sUcM2iib4Bx1MB4yiMp2rTkExiyVu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsV1UQxu+/91/vPZeWNgoGHwxqIkLRBB8EtIpQVxatEn0gMYJAIZhQ
jMpmUCOKKCQmbC4toaXQWqAFFcUHaEGNCiRG0AgIyFLcWuoCYVWD/r58Pkxy
5nwzc86dM/PNvXbijLHVBVEUrUTySHEWRUXIZSgJsi2Jon7o17OemouiV9GL
A3gcRV9g/zjYeOQcegX4DazPp1F0kaD98ClAzyEXwf9CKvF9CBnK+kb8G8BW
I33xPc5eMb6NSAv+h/Hfw/oe7G8GK8KmkvMHYN8f7Hn8m8DjzLHHol+D/iGy
Bf+CwijqwH4ReA329yN9wY6gR2A5pA58JPG3EvtypDPzN+juReB9sJ+NzCPe
KfZqsK/A/n1seyCXsP0XGQZ2BzZlqWPIVzm7F9v7kJNgt3BsEXgb+EGwQ8iv
6KPBB3P/XsQbCraXM6pjx7wTbDjSif8A/EvBS5DTOd+pnPWV4MXKP/an0IcQ
sw/YGvamEmsYso/1NPYKwVqx+RLbXchb6G+mfovNxCzvEUWTsS9D3883HJMv
+GF85xNjIWd9xd5r2A5ibxH668G1UBT77r2C1/qGNegPo+/K+Y1HE2sBsgTf
VvBXwF5GPo5cU03Bd9ZdF6OPCt7TWjk6DjYC/Sb5InNZz0HW4T8BvQF8Cd+3
hm+7mvOeAPsgcW3+ibzA2S8ixcR/DP0u8InoO/AdhKzA90f23mDdTIyB5GME
0k0uFrBXF5wj5UZvMgrfbchnrDeAXwLfrh6I3ROKVYL98ELHrEKfHFy7lehd
me+kuxRj8yTYNGQe+AViLgWrTVz7qrnpYG2Je1FvfBr/NvZqsO+N/w7WM5Hx
xH439rdNQSYU+Btn6q74dPBtg4mxGf0j7Gtj98xu9CriT2G9B+kNdsX/76ka
ewZ8U+baKcP/U9Ytis/5x9nbmvoOOls5WZn5TfQW74HfHZxz5Vo9XYt9DTIE
/zZs3sb2Z/SuAr/xbPSjmXtVOWnA953EvbdQOUaPsf+c2L+jzwBrz9xb47E/
B3Y2dS7FSV3qJWQ3/iI+vc0J9N45v9FPrJdnfvsDxDuKfnvi3t2L3q1eDuaq
DmRjZg4S9+wUB2C7HL2e2N+Cb0afjM0ssJXo9ehj8G/P+cxm5Sq497XXrtrH
fi72ddifZN2NzMm7ZltUH4nvviw2t/YUp+XNsf3RB6auJXHkgdQ9p147gs/5
4JwpV3/E7u2D6unYPa637JmZ+/Wm6t3W4LPUw6q19uBeU811cZel2K/FvlF8
j/8G9KeJtQ/78+B16NPRd6I/GJxj5fZW5AfW+1Nzz9foT7E+g8+mvH0ag89Q
7EXKuXIfXCvitPlgjyLleXNKJ+sjwW8lDhD3n0hcK5oBzeJ+zvgu5zuu0uxK
fLdm9PWqtdR31wwSF9YHc404UbX6W/Dbq2aH9/CM0WwRR+jutcTYmPc36C23
szcu9ptq1hwLrg3NnFLifYLNsbx7cmrmGtDb682fxXZbMJc/h/4I2Pep31Kc
N1L9DL4e/LpC987qYK5SD1Vwv0mZa+8f8KrMHCTuUU1qFmpmalZqJm4J5kxx
pTihPnXNqFbWFXh25FPXumaI7l6Suvf1DZptmuGa3ZpxV6W+g87WzFKtnOQb
mvKumTPEPhuce72J/j00czVr9Q9SAlYaPFs1c5Tbs4m5RDn+Bdu1wbWhGVut
f4vUXKicR5k5QVwgTl6ReqZplqlHL+h9M3+bOEGz6xv2ZsTmvFnBb6Dci1OV
a3G+uF45b8nMieJCcdAD4KsT17b+cRajjxPHxo65IzMHi3vVsy9h+3fmt9MM
FPfelrgXxMGDM89czVrV+CHWkxL/C6hnl4GvSvzvopz+BynaWVY=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6551326664556568, 0.6742780897237014, 0.9115803690945815], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mG1sltUZx+8+9/P0ue+7HRUEobhNMIZNqTHxw4o4GRIqCW4TJrKXZB9k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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm1MUGUUxy9c4N77YER8MC1r060XI9fWh0QsrSZzK0sywK1vES2UTTQr
UtzaapmtXOa0PlQbJE4kTdEZZSt68a20Nl8IsZkatBQBl70stbTff/8+nO38
7/k/5znPec45zx1f2zhnQW4URSuRPORgiKKrkQA4j8xKo2g5shrSh3EUncui
aD32ndgGwHPAW5G16Adyoqgd7gakCl/HwF/ALQL3ozfh4zD4EFIBHoWP6UkU
vYW9FVsfPqoy7yHf05B6uEPykR9FpfC/UnzwB1jfyZp2uMP4WAn3daQc2+9w
RsMfg0xGXwHnTrh3s74N3ApnJvF9DL6C/kcwdx4+d+NrPngZtvX468Lexfr3
0HfiIx9bHvIP+F9kCvbuzNxr8VGCvg/ZDn4Vf4NwS+GMYu1y5DP0L7G3Y98F
7kAfYc83wauQp4LPrLPWs34d+oXEsXYhg/DngSuI/0TssyoG7a0zl6Dv5tsv
cH9FjsMvhz8J/nH2+wFbL/Jnnu/gtO4rc+6GsLeA2+GXYutFfsY2DVzG+h44
N7B2HHI968chPeg7WLMQ+1/gKeAryM3EshV+Mfpi1jdGrqld4Ofgl+G7H1wG
vqkwip6Gv4pve8F7kNrIZxibuiZVi88ie4inmm+3wO/E/+zEd6S7mZhn3/uC
z649bkWfGGzTHVQlvgPl/gSyCX+bkamxc3oxcc6V60+QcvRi7Bn26eC/sZ8G
/wTekedeuMS3/tg9sZSzNINfwXddAbUKtwhJY/u4C3617pO9GsBHiaUvdSx3
IAvgdie++7HgJfCPgBepnvB/EfuFzL31DPZK5Rb8GPZJ2Avw1VhoWx+cTayP
U9/lYvWw6hd8FLwZfBv4hdS1eTvrq/FVg9yDv6nE2IT+OdIGbsY+gt6JTMjx
mbegz1cMuZ4BDfhr5ltt7B4qxvfXwb2vnlUuvkt8duXkfWxn+bYf20fwJ8A/
xbdP4ecgzeBlqfVH4FwOvhPdhWpsSeYYFdvjsWtjL3hb7Bo5lnqGaXadzHXv
XpO69tTDucpPcC40o9TrdUhl7J5Xbd8YXOuq8YdkU09hGw3/YfQZ5HsMd90N
3s7Zngiu1coc21oTc8VZCP9y6lmjOzsC97rUvaOeVG+NB8f57rEW1p4BDxPf
5Ni1dyZz76sGa7D/mPpsHcT3GrZDiXupgm9XaXYGz8rfclybqhnVimr0cOIa
U20pZ+rVptRc9ewAuDf17FgReza0BNe+ZkQ+ti3BtaWa0uwvCJ6NegM2wu8E
H4B/X+xe14zQbFDPv4R9buLZrDdmP+vrNYPRDyJvp45Be+uN+IDzvZu6NjUz
NUufz3z3mqlng2tataw3Q7nbiP2N2Dk8GVxTqiXluAH9HP5Xx97zW7jfID2R
e64m9czRrNFMn5v5TDrLvbHflu8Tz3q9MS+iv5y6l9Xjj+ptSPyWqaeG0E9l
nqUb8twrSzPfnXrmSeKrC64d1WBH4j211/1ar/dOPnPdMzOxlwS/pZqZwzpf
oWdPEZwH4D6YebZrhs+AfymzL72Byk0/0hv/nyPsszLXmt5U5UZvlN4m5WhE
uU3tWz26KPXM1KzUDGhL/E+gfwHNiNmZ33i97eqZQfUi39bIF/x3UudEudCZ
1iXmyKaZfJ79ylLPQs0grW0NnhXysRZ9TXDv6QzbVFvBs0819x+yzzfD
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7196042105200549, 0.7778659216372431, 0.9130501217241801], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1lsVVUUve297937zmNWf0rLVPiDIhElVCJKgYLRxBSBhERJxA8FhDIZ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlV1M12UUx3///x/4Pb+HtQTrBkMS6iroZW25FZPkJaytizLRXKutumig
AYabkjbN1oXoRevCm24qa6kFagZ1E5sLLU1XgFbaRVYWq4WalCiofb77dnG2
c57zPec5z3l5zoJnOx9/MZ8kyRaoCGoKSXIpJkllcZJUQS1pkkTkhwtJshz9
otIkGc6SpAKj39E3o2uBGpC35pJkDHwDmAl0byDPxV838nrhkYfA7gr2NcaF
J8Bv4KwP/gB3tKH7Ev+l8IuwWY1uMbQW241gdsJfxuYY8m70a5Cbou/ejP4O
+Dp8lHP/Xch78DUJ/iD698H/gP4W9DPorkB3wp/nbBhdGfQu8jvQI8T3LTar
se0k/pUlSbKMswH87YXqiW8J8iy229D3oL83b9ur6KcK9rEC++7o2B4E8xjy
qui31CPXRsesWO+GFsIvB/MZtqvwMYi/Gs6q0a3hbDG6t4Lfcrbg3J3k7KWC
c1hLLDPIx4l9Bzn4FGxdtO9N2C8ltjaoAXwNmA507VAP/HOc9UbXRLXYis2t
yBvw8Sr3VSFXIy8QFTmmm+DnQjfCz4H6uP817N/MOycZugBN5NwDs9y9Emop
OEdPiMemosQxN2P7dnBtL6L/BNuPoR/RfaM3gH0FTB/6dmxWYD+TGXsaTDHY
Eqhf+UFuBfsR/vYj34B9Cfxe9EeLXNOD2PZmfvsu6B/VqtS+52HTD/7m6Lc9
n9jXIeTfiuxTvX44c6+q569k7hn1yt/46wbfnrpX1LON2E5Hz5Z6+gL485l7
bQL8F+jKgmNfh88O+Bewr0/cwx3wjamxXei3YTueetYeQr6K/aPBvXgI+hf5
geC3qMfXw5/mbJb4W7E5ktmHbAfxeQ7dJjDP5DxD21Uv5KGCe2wd/CiYi9hv
xOZn9TJnS5V78N9H3yHf02Buh/+FsxRdBlXCz4eG9OlAW4j9dTD35N3ze9R7
0bVu5r4PkZ8khqaCe0a9VxN8l3qwH/0Rzv6AX4L+lN4Hncnbp96yOXi29ab7
4afAX8/7DwvIXdRwbd49pl58L/VsqCe7uLsT2k5s18CMqT56f845UO/PC36r
ZmAntn8in8v7j1iWeWY1q5q5AfinOGst+E/dnbqH1bt1UC/3vwzNKfad1fiq
Us7wXcTZNNjLmXvrQsE6zahmU5gIfhB5FH4c+gu+Vu8vts/JzH+E/oYd2H8d
3FPqpVHo1+g/Q39FADMQPAPqfc3w58Ezo1kZybs2qplqpRq1pcZIpxrsx9++
6Ldp5o7CfxW9C1SzRrDDwb06n/vuI7aFpf57tFOU6/Lo2VXOr4O9FlwL1VC5
VA+o9sppGpwj5eYYNh8En4nXn9ATnCPlRjWfVC9i/3TOOVLusuDdpBweRh7R
vOc88+X4LoNiwTvqZPRMaBYuFbnXbwvOnXr+J/2Vwb2uP7Rc+y16tuVTu1Y5
0Nu1c8eRv4v2NZVzbGeia68YNWtno2dJM6de25e5luq5U9E7Q7tCO05/sXaQ
do/+ZP2d2kHaPfpD9ZbjqXeN3jSSesdrt2snnMBfRfg/FvCVwTtUu1N/yH/w
+hcJ
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7818898450952222, 0.8534203116691564, 0.9054030546558199], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV0tsVVUUve/2vr7beyelFaQgQi2giYIUExhAUYpEWiOkhVZ+EqgRBvxp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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEmMjVEQhW///dr73/030m2KMWYLs2gLU0wxxfTErAmCBVrjtUWjG00Q
zYKFlZWVKU0Qc1hJTLETMS2EiCHBQsdCh+/kLE5SVaeq7r1Vdavv+u3F2iSE
sBbkwJA0hN1ZCPcxVoDjyC1gQEUId+DrYgjbwWXkRgI6w+0CazqE8KcshBX5
EGrQN1TY5wj5joJqcu2HLyHX4rMc7h36B3L1x5bAN4M6uB3ErybfRnyWIS8F
VXDHwN9CCO3gIvJ74pvwL4KJ+Ldg+0i+AeQrR74HpiH/wbaYuw5C70quLmAO
sZXYRsE3oj9MfMYlcq0sOPdIcAbuOD6ndRZnTCfXNLCE2KWghP8sMA6uifhO
uiuYhH85/HLknqB34jvq7XXoqzq4BsPJNQKMwXc0OAT3CJ8m5G34TIWbAoo5
v6EQXSPVRg07kbnGqm09/g/hfuJTRf23lDn3AfUg8Rk70XdE91Jv2En8dWJu
J+7hULhh0bXrqHorH/X4XB7CXfx/IU/FNjfY1oDvHt0R7hTnPVN++AZiv2Ob
wNkHM/eml+qDnsfnH7HfdH/yvcw7dib8AviT+DfnPDPNyBNTx6pHizLPnGZN
NW9NnVO5riWu9eHMtVPNO3FW52juNzGrOGsTfAP1ecIbJsOtB6WcZ+Ip8hMw
HvkLtlfIPVLHNpLjNXpP9Db0W+g16M+j3/oVWw3viehl6F/QZ3DeefxbE9tu
whVSz75sV5GvgM3c5Ru2t9EzpVlqx/9K3mcot2aqLbrH6m0P3nAD/Xr0rL7A
vx35seLRB8J3Re8SPetV4AXcLvSDOdf4XOoeq7f6U9XUZiy4QOxFUK/7RNdK
MYvhipl3w6HEvR+X2VczoNmtjd4NmuFB5C9l9s1pByAfAN3xP0vO1rxrplqp
5vvgRhJTmXgH9dN+iK61dsRv9Sb125VDb32Q+m/rzX2In5/6L2gHadbS6L+i
mdPbZkT/Xb3xL/K81LXSjkuRr0XXUn90G/LW6LvqD9YTPzj1W/RnFui8zL3T
zKuX3aJrrZ72Qn8TPTuamR/6X6n/lv7kQmKz6F1RzXlDtBtS7xrN6PDUO0K7
QX96BPrezLtQNdJuagGzE++oKuTH0bOrHboueqY0S5rxgfCfonetduR/X0y0
vw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8397896674175642, 0.8727283596182575, 0.8794639861413306], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV8tv1VUQ/t3r/f3uzT1LENSYKBupKx/YtL5oNUaLt7SlJZTS1hYo0EYt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllMlvjlEUxm+/9Hu/m/fdGYuYNtTCrDG3iKFmNRRt0TZRFbQ1dEpqiE7m
WRALGrEnqQQLYcXC9AewsWDDH2Ajfk+exUme55xzz73nnmFqY+v2llwIoR4p
Rs4WQjifhXAkCeERvDeGcAHeBm8pCmEZfA58KG+fWvAkpAFeAf+ZhtBNjH6C
pug+w0di3wD+wwXTOD8T/gB+AP/R8BHw9fB98P3gC+jucH4VfDe8h3g3ectS
+EDmN+ktLfDn0TF0dpgzvdjf4X8M+1F027BdR3cX20LkNPgl9kbsTdj7sF9C
dxLcia6N97YgHeBzxc51eXQs5XweXIYchl8i3l5ivYW/B69EV4//AWRRzncq
1+nY6xPnPA/8OPPZUch37hoD34ztH/d9JV4HugHwIHIW2yvO3Cb/ZmLMgs+J
fvtDznwAB3Sl4E/EawcPE6O6yHf+JVZr6lym4DOI/TVnhjjWmvjt8pFNOejv
zuBzKPEfzgOvwecE/Ck+UzLXSLU5CJ+BrRP+hrMF5D74Krq7+j98vhDvGroO
8GV0DdzViGzhPe28YSy4JHXt/mJ/iO/86L9RzC5sncjH4D/pw96P7Mu7Rt3g
LmQPeCe6i5lrqloe587Z8AXRf/cI+wrwXHRP8u7pUngJfBu8Af6Ruz4hbdzV
zJ3t4JOp395X7L8+lRrrzyfAqzP3Zk3etaqBlyeu2Qn1FrIp75qol3vgBxP3
tGpRl3l2VBP1lt6st6rH5kbfodiqyWTlnrnXyvif2dE9oV5QTM3SFqQs8Uwp
t+3qx8Q5TgXfQroT9+hO8LjMtVuMrov3nco8m73Bf1UR3Sv6M/XCO+RDzj2x
I/MZ+eqO8tQzr1nfhOzCPj5zbZZgnwGui+6Nnrx3xeaC79bOeAFu4nySc03v
4V+Lf6V6C7mq/KJz144ohTch6xL77AVP1PvzrsEe5V/wLlPPKPav1LtJd8i3
PHqX6ExF6pnULKpHb2aeSc2i/ky9fQ3ZmHOPb8V+vOBe0Z/XgQ9lzk09q13T
kbm3tHNGgTPi/y7yTqwteIY1u8phbfTMada0k8aCx6SeDe2IKnhlwbOjntoa
PZOaRc3YN/iV6L/6gdzAVhW9+1Qz7erV0bOhnf2s4JqpVur5/1HArR8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8976894897399063, 0.8920364075673585, 0.8535249176268414], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVktvlVUUPfej596Te8YMNFFk1N7bgbHAVCWlhhAItGrioz5SsDyayIBi
Wx/RWNJWQouPtgiWxKAIzAqNiTqgvZ0RLdd0QqJNDJjof3DkWqx1UwYnZ3/7
7L3P3ms/zrd94GTfu0UI4TesLVgflUO4AMZ0KYTLMYQFfB8BfQm8A1gXQP9U
Fn8W8s0g3l3sf2DNg/4T+44UwjcZNiB3Ospuy2YEPQeZXtO0X0D2Dejsxx3t
oF8B3Q36LtbuQna7qiHsBb8T3wPQ64vS7QDdjvU9bE7jbBvWFdA3cH4d6wxk
eqDXBbs1nI2XtC9CZgZ7h+lR8J+yLn072CY/Getl+/kc7DyTJbcAme+CcOCd
J0vSJX7dxvBFyM9C/gPorxbS4z1HoTuItQb5zrJi4F1PQvb1LJ8YUx1rPgi3
Wll3Po7zl7FSIb2ada/hbLSs+O7gbA/oJcYCHz7POiNGtHsVex/4X4H/Pr4P
VEIYw5oA/wnwXs2Kifd1WO8Q8HhgXM4XysNYaRO7m0F2yaP8cBQGK0E5PFdS
vCeck1ug38I9b2N1445jUftt8A+DN4DVg+8fomJadk6JZQP07/D3iyy7G0G2
WYf0h3dS/gxi/Cwrz8z5jHNdLxQDfd2ThDsxfzYp/m3OE/N50/KUvWocMvyY
BP1mUu3ud29s2AfGRl3WB+ti1nTNuSau49CdyKrZNdCfVOTTsvuKdsaNL3nU
63St73NPsOeIcdMx74Sdp2Fzq2tt2vXM3P5TVX7bXVOMpeV30/jRf/bv8agc
LtnuonHYUVUfMvcj2EexptqUX+7MBWuEGBGf96rKE/nML+ueNLGkDdpnj56K
wox88ng3a5+1Rl87nI9F+3bLeF4x1vSNNlZMj7TJhwnn66DpI1nzhf25t6z5
Qiwvem/hyfOm5xljIzbs12XnpemcrHj+cTZuWH7NGDYL4UvZWtzEqR85qmXd
x5n0QlJt0se6e5m9czo+Moejaog8njXc7+wN9kuP52zDuCw4f4PA/8eK8Hg4
x2yn7lqac02ST3ooah6wPwdtn3GOlHXfbeM8bKw/LKsnKX/K85Y+RNvkzGRc
96PyuAuxfppUn7R9zb3NuliPm3eu+66zWT3Mvv0Z+8f4bhSa/b22z3q777n0
H+L9taL5xx5ueC7/At3JrBncn/VN+m/nnnl/mHPn6x5sbMn6ngT9TtZcv4h9
qqL38LUsn3gH477h2Pf53WItsG5XXbv0azXJt/msO1o1csl9yJ64476YhuzX
Wf4dxd5fUc1OZc0O9vaXoLdn9Rb9+ivJ1r9V5Z55Z26uu2eIBbGfdd8wZ+yX
deNO/Dmf2WP04Zxzs+aePO43b9g9y3j5zgxZfoRvbNL7PGRbS9Y7YR/WPQeY
X+7HTM9B96WkmhoFPYZ12HVa99xrJL3l7BfOYJ7zHeSb/HzSzOP82+UaY262
PvI2c6f/rJcHnuGt3mZfzyThTszp75Brm/lkD7N/z8P+oaSeYJ33xs3/GdYl
58zZpLphzXCu76xqtrNGey3zLex0Jf1PMRbGQX8eIw5Ztv4Hb4o5zA==
         "],
         VertexColors->None], 
        PolygonBox[{{2943, 2100, 533, 705}, {2857, 2919, 1608, 586}, {2900, 
         1869, 134, 1362}, {2819, 2142, 588, 719}, {2089, 2841, 1362, 1634}, {
         2953, 2116, 552, 654}, {2907, 2908, 706, 552}, {2136, 2966, 719, 
         579}, {2119, 2253, 655, 554}, {2937, 2842, 520, 1635}, {2098, 2970, 
         1692, 1720}, {2971, 1977, 356, 1693}, {2854, 2135, 1661, 1397}, {
         2624, 2792, 1291, 1104}, {2951, 2111, 544, 706}, {1977, 2935, 1634, 
         356}, {2850, 2130, 1658, 1387}, {2964, 2243, 193, 1659}, {2612, 2611,
          555, 655}, {2243, 2915, 1605, 193}, {2792, 2936, 1635, 1291}, {2249,
          2817, 1321, 718}, {2960, 1994, 387, 1656}, {2817, 2679, 1160, 
         1321}, {2269, 2190, 665, 739}, {2128, 2867, 1447, 1655}, {2132, 2868,
          1449, 1660}, {2120, 2810, 713, 555}, {2950, 2110, 543, 653}, {2968, 
         2140, 586, 665}, {1973, 2624, 1104, 1143}, {2849, 2911, 1603, 
         1384}, {2970, 2099, 1693, 1692}, {1917, 2976, 1720, 148}, {2112, 
         2952, 653, 544}, {2914, 2854, 1397, 1605}, {2118, 2954, 654, 553}, {
         2790, 2791, 1143, 134}, {2242, 2913, 1604, 713}, {2917, 2916, 579, 
         663}, {2680, 2678, 396, 1160}, {2868, 2131, 1659, 1449}, {2912, 1925,
          190, 1603}, {2271, 2270, 589, 666}, {2905, 2906, 705, 543}, {2867, 
         2129, 1656, 1447}, {2178, 1917, 148, 533}, {2963, 2185, 388, 1658}, {
         2961, 2962, 1384, 396}, {2135, 2186, 663, 1661}, {1994, 2241, 553, 
         387}, {1884, 2249, 718, 1608}, {2913, 2850, 1387, 1604}, {2141, 2969,
          666, 588}, {2185, 2965, 1660, 388}, {1925, 2959, 1655, 190}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1323, 1322, 221}, {210, 231, 209}, {240, 232, 231}, {
         2243, 2964, 714}, {398, 570, 194}, {2131, 2868, 570}, {578, 398, 
         208}, {231, 232, 223}, {244, 240, 236}, {236, 240, 231}, {2966, 2136,
          1662}, {569, 389, 194}, {2915, 2243, 714}, {231, 223, 209}, {240, 
         244, 224}, {248, 240, 224}, {2253, 2119, 723}, {2810, 2120, 1313}, {
         194, 389, 195}, {240, 248, 232}, {1559, 1399, 208}, {1399, 1400, 
         208}, {1662, 1400, 408}, {2270, 2271, 740}, {2185, 2963, 662}, {1550,
          1399, 222}, {578, 714, 398}, {1559, 1558, 1398}, {222, 1398, 223}, {
         236, 231, 210}, {714, 570, 398}, {1398, 209, 223}, {1558, 398, 
         209}, {662, 569, 194}, {570, 662, 194}, {1400, 1399, 408}, {194, 210,
          209}, {2969, 2141, 1665}, {1079, 1080, 180}, {1665, 1323, 221}, {
         1550, 1551, 408}, {1558, 1559, 208}, {1322, 1550, 222}, {1323, 1551, 
         1322}, {389, 1078, 195}, {2965, 2185, 662}, {2916, 2917, 1606}, {
         1399, 1550, 408}, {1399, 1559, 1398}, {1400, 1606, 208}, {2611, 2612,
          1080}, {1313, 1079, 389}, {1078, 1079, 180}, {2130, 2850, 569}, {
         2868, 2132, 570}, {1079, 1078, 389}, {210, 194, 195}, {2142, 2819, 
         1324}, {1551, 1550, 1322}, {1323, 1324, 408}, {1399, 1398, 222}, {
         1551, 1323, 408}, {2186, 2135, 578}, {2913, 2242, 569}, {2850, 2913, 
         569}, {2854, 2914, 578}, {398, 1558, 208}, {2135, 2854, 578}, {1398, 
         1558, 209}, {398, 194, 209}},
         VertexColors->None], 
        PolygonBox[{{2818, 2142, 1324, 1323}, {1920, 2253, 723, 180}, {2141, 
         2818, 1323, 1665}, {2007, 2966, 1662, 408}, {2136, 2855, 1400, 
         1662}, {2612, 1920, 180, 1080}, {2914, 2915, 714, 578}, {2855, 2916, 
         1606, 1400}, {2271, 1928, 221, 740}, {2917, 1927, 208, 1606}, {1995, 
         2810, 1313, 389}, {2610, 2611, 1080, 1079}, {2963, 2130, 569, 662}, {
         2120, 2610, 1079, 1313}, {1927, 2186, 578, 208}, {2132, 2965, 662, 
         570}, {2819, 2007, 408, 1324}, {2964, 2131, 570, 714}, {2242, 1995, 
         389, 569}, {1928, 2969, 1665, 221}},
         VertexColors->None]}]}}, {{}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2119, 2253, 1920, 2612, 2611, 2610, 2120, 2810, 1995, 2242, 
         2913, 2850, 2130, 2963, 2185, 2965, 2132, 2868, 2131, 2964, 2243, 
         2915, 2914, 2854, 2135, 2186, 1927, 2917, 2916, 2855, 2136, 2966, 
         2007, 2819, 2142, 2818, 2141, 2969, 1928, 2271, 2270}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2269, 2190, 2189, 2968, 2140, 2857, 2919, 1884, 2249, 2817, 
         2679, 2680, 2678, 2000, 2961, 2962, 2849, 2911, 2912, 1925, 2959, 
         2128, 2867, 2129, 2960, 1994, 2241, 2117, 2866, 2118, 2954, 2180, 
         2953, 2116, 2846, 2907, 2908, 2234, 2951, 2111, 2865, 2112, 2952, 
         2179, 2950, 2110, 2845, 2905, 2906, 2233, 2943, 2100, 2863, 2101, 
         2178, 1917, 2976, 2098, 2970, 2099, 2971, 1977, 2935, 2089, 2841, 
         2900, 1869, 1913, 2790, 2791, 2662, 1973, 2624, 2792, 2936, 2937, 
         2842, 2901}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2268, 2188, 2187, 2967, 2139, 2856, 2918, 1883, 2248, 2816, 
         2676, 2677, 2675, 1999, 2958, 2127, 2848, 2910, 2184, 2183, 2957, 
         2126, 2847, 2909, 1881, 2240, 2809, 2671, 2672, 2670, 1990, 2948, 
         2949, 2844, 2904, 1874, 1919, 2946, 2108, 2864, 2109, 2947, 1985, 
         2942, 2097, 2843, 2902, 2903, 1916, 2940, 2095, 2862, 2096, 2941, 
         1976, 2934, 2088, 2840, 2898, 2899, 1912, 2932, 2086, 2861, 2087, 
         2933, 1972, 2930, 2931, 2837, 2897, 1864, 1908, 2780, 2657, 2658, 
         2623, 2781, 2838, 2839, 2582, 2583, 2584, 2224, 2225, 2069, 2834, 
         2894, 2895, 1905, 2764, 2765, 2653, 1968, 2622, 2766, 2835, 2836, 
         2571, 2896}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2138, 2445, 2006, 2684, 2005, 2682, 2683, 2871, 2870, 2869, 
         2629, 2628, 2627, 2674, 2673, 1880, 1924, 2955, 2956, 2812, 2125, 
         2813, 1993, 2239, 2114, 2807, 2115, 2808, 2626, 2625, 2669, 2668, 
         1873, 1918, 2944, 2945, 2805, 2107, 2806, 1984, 2800, 2094, 2606, 
         2607, 2177, 2176, 2799, 2093, 2603, 2604, 2605, 2232, 2788, 2084, 
         2787, 2085, 2789, 2173, 2786, 2083, 2593, 2594, 2595, 2230, 2778, 
         2076, 2777, 2077, 2779, 2169, 2776, 2075, 2579, 2580, 2581, 2222, 
         2223, 2068, 2567, 2568, 2569, 1904, 2929, 2067, 2761, 2763, 2762, 
         1966, 2396, 1967, 2397, 2570, 1861, 2217, 2743, 2057, 2742, 2058, 
         2164, 1902, 2928, 2056, 2739, 2741, 2740, 1963, 2393, 1964, 2394, 
         2556, 2557, 2210, 2211, 2044, 2544, 2545, 1858, 1899, 2252}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2251, 1896, 2155, 2031, 2474, 2030, 2475, 2204, 1857, 2389, 
         2390, 2387, 1957, 2885, 2388, 2543, 2725, 2043, 2860, 2542, 2481, 
         2283, 1956, 2386, 2480, 2479, 1898, 2161, 2042, 2723, 2041, 2724, 
         2209, 1860, 2555, 2392, 1962, 2391, 1961, 2737, 2738, 2736, 2054, 
         2927, 1901, 2554, 2553, 2552, 2055, 2216, 2215, 2566, 2565, 2564, 
         2065, 2756, 2166, 2760, 2066, 2757, 2759, 2758, 2221, 1863, 2578, 
         2577, 2771, 2770, 2168, 2774, 2775, 2772, 2074, 2773, 2229, 2590, 
         2589, 2588, 2081, 2784, 2171, 2172, 2592, 2591, 2082, 2785, 1975, 
         2798, 2092, 2797, 2939, 2938, 1915, 1872, 2415, 2416, 2302, 2303, 
         2804, 2106, 2803, 2105, 2495, 2878, 1989, 2666, 2667, 2427, 2426, 
         2498, 2238, 1878, 2267, 2266, 2124, 2182, 1923, 1879, 2615, 2440, 
         1998, 2321, 2322, 2504, 2134, 2502, 2133, 2503, 2879, 2003, 2681, 
         2004, 2444, 2506, 2505}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2137, 2443, 2002, 2324, 2001, 2616, 2853, 2617, 2815, 2814, 
         2618, 2320, 2319, 2318, 1997, 2439, 2614, 1877, 1922, 2181, 2123, 
         2264, 2265, 1876, 2237, 2497, 2424, 2425, 2423, 2494, 2493, 2802, 
         2104, 2414, 1983, 2665, 1982, 2663, 2664, 2796, 2795, 2602, 2175, 
         2174, 2794, 2091, 2600, 2601, 1871, 2231, 2487, 2404, 2405, 2661, 
         2660, 1971, 2659, 2882, 2073, 2769, 2575, 2576, 1907, 2167, 2072, 
         2572, 2573, 2574, 2220, 2754, 2063, 2753, 2064, 2755, 2165, 2752, 
         2062, 2561, 2562, 2563, 2214, 2734, 2052, 2733, 2053, 2735, 2163, 
         2732, 2051, 2550, 2551, 2208, 1960, 2720, 2040, 2536, 2537, 2538, 
         1897, 2476, 2477, 2385, 1955, 2282, 2478, 2721, 2722, 2539, 2540, 
         2541, 2202, 2203, 2028, 2529, 2530, 1854, 1895, 2470, 2378, 2379, 
         2280, 2471, 2472, 2029, 2380, 1952, 2281, 2473, 2531, 2831, 2532, 
         2709, 2708, 2533, 2382, 2884, 1953, 2381, 2384, 2383, 1855, 2198, 
         2199, 2020, 2263, 2525, 1850, 1893, 2250}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1849, 2150, 2146, 2371, 2372, 2373, 2256, 1947, 2194, 2524, 
         2370, 1946, 2275, 1945, 2466, 2019, 2698, 2018, 2880, 2881, 2859, 
         2465, 2278, 1944, 2369, 2017, 2464, 1892, 2875, 2463, 2277, 2368, 
         2367, 2462, 1891, 2523, 2522, 2262, 2016, 2197, 2196, 1853, 2528, 
         2377, 1951, 2376, 1950, 2707, 2027, 2706, 2026, 2469, 2468, 2279, 
         2375, 2374, 2467, 1894, 1852, 2527, 2526, 2025, 2705, 1954, 2716, 
         2037, 2715, 2036, 2160, 2159, 2719, 2039, 2717, 2038, 2718, 2207, 
         2549, 2548, 2547, 2048, 2728, 2162, 2731, 2050, 2729, 2049, 2730, 
         2212, 2213, 2061, 2749, 2060, 2750, 1903, 2560, 2559, 2751, 2558, 
         2655, 2654, 1969, 2656, 1970, 2401, 2486, 2485, 2227, 2228, 2080, 
         2782, 2079, 2783, 1911, 1868, 2409, 2410, 2293, 2294, 2295, 2599, 
         2793, 2090, 2883, 2598, 1980, 2300, 1981, 2413, 2103, 2801, 2491, 
         2492, 2420, 2422, 2421, 2496, 2235, 2236, 2122, 2499, 2121, 2811, 
         1921, 1875, 2435, 2436, 2316, 2317, 1926, 1882, 2441, 2442, 2323, 
         2325, 2326, 2619}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1929, 2825, 2148, 2824, 2149, 2826, 2147, 2261, 2260, 2255, 
         2329, 2328, 2327, 2144, 2509, 2013, 2459, 2458, 2274, 1940, 2356, 
         2457, 2456, 1888, 2874, 2455, 2273, 2351, 2350, 2451, 1887, 2151, 
         2012, 2452, 2454, 2453, 2193, 1848, 2365, 2366, 2362, 2364, 2363, 
         1847, 2360, 2361, 2358, 1943, 2359, 2521, 2520, 2697, 2696, 2461, 
         2276, 1942, 2357, 2014, 2460, 1890, 2152, 2015, 2693, 2695, 2694, 
         2195, 1851, 2644, 2645, 2643, 1949, 2701, 2022, 2700, 2021, 2154, 
         2153, 2704, 2024, 2702, 2023, 2703, 2201, 2893, 2892, 2833, 2033, 
         2925, 2158, 2714, 2035, 2712, 2034, 2713, 2205, 2206, 2047, 2727, 
         2046, 2926, 1900, 1859, 2546, 2395, 1965, 2284, 2285, 2747, 2748, 
         2745, 2059, 2746, 2482, 2483, 2398, 2400, 2399, 2484, 2226, 1866, 
         2586, 2585, 2078, 2170, 1910, 1867, 2587, 2408, 1974, 2290, 2291, 
         2292, 2597, 2412, 1979, 2299, 2301, 2489, 2490, 2488, 2102, 2418, 
         1987, 2305, 1988, 2419, 2113, 2429, 1992, 2309, 2431, 2430, 2500, 
         2433, 2434, 2313, 2438, 2851, 2437, 2501, 2244, 2852, 2245, 2143, 
         2247, 2886, 2246, 2254}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1845, 2518, 2519, 2446, 2448, 2447, 1933, 2512, 2513, 2511, 
         2633, 2632, 1931, 2876, 2877, 2858, 2508, 2507, 2517, 2516, 1844, 
         2872, 2873, 2828, 2355, 2352, 2354, 2353, 1843, 2348, 2349, 2345, 
         2347, 2346, 1842, 2343, 2344, 2340, 2342, 2341, 1841, 2338, 2339, 
         2336, 1939, 2337, 2515, 2335, 1938, 2333, 1937, 2334, 2514, 2332, 
         1936, 2331, 1935, 2689, 2011, 2688, 2010, 2450, 2449, 2272, 1934, 
         2330, 2009, 2687, 1886, 2686, 2620, 2638, 2637, 2685, 1885, 1840, 
         2887, 2827, 2008, 2192, 2191, 2890, 2889, 2830, 2923, 2922, 2692, 
         2621, 1941, 2639, 2691, 2690, 1889, 1846, 2888, 2829, 2921, 2920, 
         1948, 2640, 2642, 2641, 2699, 2200, 1856, 2891, 2832, 2032, 2924, 
         2156, 2157, 2535, 2534, 2711, 2710, 1958, 2646, 1959, 2647, 2045, 
         2726, 2649, 2650, 2648, 2652, 2651, 2744, 2218, 2219, 2071, 2767, 
         2070, 2768, 1906, 1862, 2402, 2403, 2286, 2287, 1909, 1865, 2406, 
         2407, 2288, 2289, 1914, 1870, 2596, 2411, 2972, 1978, 2296, 2297, 
         2298, 2608, 2417, 2973, 1986, 2304, 2306, 2307, 2609, 2428, 2974, 
         1991, 2308, 2310, 2311, 2613, 2432, 2975, 1996, 2312, 2314, 2315, 
         2510, 2820, 2821, 2630, 2631, 1930, 2257, 2258, 2259, 2145, 2634, 
         2635, 2636, 2823, 2822, 1932}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{0, 1}, {
      Rational[1, 10], 3}}, {{0, 1}, {0.1, 3}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12886709]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->119],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", 
     RowBox[{"\[Lambda]", ">", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6915],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292319906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17929],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], ",", 
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4715],

Cell[BoxData[
 FractionBox["24", 
  SuperscriptBox["\[Lambda]", "4"]]], "Output",
 ImageSize->{23, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392823655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"CharacteristicFunction", "[", 
      RowBox[{
       RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "t"}],
       "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "4"}], "}"}]}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"t", "->", "0"}], "}"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12536],

Cell[BoxData[
 FractionBox["24", 
  SuperscriptBox["\[Lambda]", "4"]]], "Output",
 ImageSize->{23, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->475967213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["GammaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24241],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "x"}], " ", "\[Lambda]"}]], " ", "\[Lambda]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329486375]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"1", ",", 
     RowBox[{"1", "/", "\[Lambda]"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13452],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "x"}], " ", "\[Lambda]"}]], " ", "\[Lambda]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->441999921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34754496],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 " is related to ",
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " through a power:"
}], "ExampleText",
 CellID->306560643],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Lambda]", " ", "x"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "a"}], ")"}]}], "/", "\[Lambda]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->746327207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"WeibullDistribution", "[", 
     RowBox[{"a", ",", 
      RowBox[{"1", "/", "\[Lambda]"}]}], "]"}], ",", "y"}], "]"}], 
  RowBox[{"D", "[", 
   RowBox[{"y", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->811178942],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", " ", "\[Lambda]"}], ")"}], 
       FractionBox["1", "a"]], ")"}], "a"]}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["1", "\[Lambda]"], ")"}], 
   RowBox[{"-", "a"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", " ", "\[Lambda]"}], ")"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    FractionBox["1", "a"]}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", " ", "\[Lambda]"}], ")"}], 
      FractionBox["1", "a"]], "\[Lambda]"], ")"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "a"}]]}]], "Output",
 ImageSize->{240, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->341173841]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerExpand", "[", "%", "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9976307],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "x"}], " ", "\[Lambda]"}]], " ", "\[Lambda]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->68868539]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->580910229],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "x"}], " ", "\[Lambda]"}]], " ", "\[Lambda]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->93006289]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12448],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->5227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExponentialDistribution", "[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11798],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExponentialDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-1\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->201431440],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExponentialDistribution", "[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{236, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38647943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->295204584],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    RowBox[{"3", "+", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "10"], "-", 
  FractionBox["\[ImaginaryI]", "10"]}]], "Output",
 ImageSize->{53, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17931903]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1717],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LaplaceDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaplaceDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8692]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13037],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->19640746]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExponentialDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 54.8574006}", "context" -> "System`", 
    "keywords" -> {"waiting time distribution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExponentialDistribution[\\[Lambda]] represents an exponential \
distribution with scale inversely proportional to parameter \\[Lambda].", 
    "synonyms" -> {"exponential distribution"}, "title" -> 
    "ExponentialDistribution", "type" -> "Symbol", "uri" -> 
    "ref/ExponentialDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7267, 232, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->345793326]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 115843, 2559}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1988, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2611, 78, 1588, 37, 70, "ObjectNameGrid"],
Cell[4202, 117, 659, 19, 70, "Usage",
 CellID->18718]
}, Open  ]],
Cell[CellGroupData[{
Cell[4898, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5376, 158, 697, 25, 70, "Notes",
 CellID->429991538],
Cell[6076, 185, 445, 14, 70, "Notes",
 CellID->4712],
Cell[6524, 201, 706, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7267, 232, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->345793326],
Cell[CellGroupData[{
Cell[7652, 246, 147, 5, 70, "ExampleSection",
 CellID->81183387],
Cell[7802, 253, 276, 6, 70, "ExampleText",
 CellID->2645],
Cell[CellGroupData[{
Cell[8103, 263, 155, 5, 28, "Input",
 CellID->3394],
Cell[8261, 270, 186, 6, 51, "Output",
 CellID->198286768]
}, Open  ]],
Cell[CellGroupData[{
Cell[8484, 281, 160, 5, 28, "Input",
 CellID->19645],
Cell[8647, 288, 210, 7, 52, "Output",
 CellID->299080568]
}, Open  ]],
Cell[8872, 298, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[8994, 303, 253, 6, 70, "ExampleText",
 CellID->21862],
Cell[CellGroupData[{
Cell[9272, 313, 180, 6, 70, "Input",
 CellID->32072],
Cell[9455, 321, 278, 9, 36, "Output",
 CellID->396721599]
}, Open  ]],
Cell[CellGroupData[{
Cell[9770, 335, 290, 10, 70, "Input",
 CellID->2480],
Cell[10063, 347, 2200, 46, 169, "Output",
 CellID->553975255]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12312, 399, 215, 7, 70, "ExampleSection",
 CellID->3542],
Cell[12530, 408, 258, 7, 70, "ExampleText",
 CellID->29608],
Cell[CellGroupData[{
Cell[12813, 419, 179, 6, 70, "Input",
 CellID->19203],
Cell[12995, 427, 337, 10, 36, "Output",
 CellID->148651893]
}, Open  ]],
Cell[13347, 440, 120, 3, 70, "ExampleDelimiter",
 CellID->6125],
Cell[13470, 445, 83, 1, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[13578, 450, 160, 5, 70, "Input",
 CellID->20134],
Cell[13741, 457, 158, 5, 36, "Output",
 CellID->306285942]
}, Open  ]],
Cell[CellGroupData[{
Cell[13936, 467, 160, 5, 70, "Input",
 CellID->18382],
Cell[14099, 474, 158, 5, 36, "Output",
 CellID->291185303]
}, Open  ]],
Cell[14272, 482, 121, 3, 70, "ExampleDelimiter",
 CellID->20736],
Cell[14396, 487, 220, 5, 70, "ExampleText",
 CellID->27478],
Cell[CellGroupData[{
Cell[14641, 496, 224, 7, 70, "Input",
 CellID->17939],
Cell[14868, 505, 210, 7, 52, "Output",
 CellID->218201216]
}, Open  ]],
Cell[15093, 515, 121, 3, 70, "ExampleDelimiter",
 CellID->18721],
Cell[15217, 520, 380, 13, 70, "ExampleText",
 CellID->31426],
Cell[CellGroupData[{
Cell[15622, 537, 185, 6, 70, "Input",
 CellID->10663],
Cell[15810, 545, 260, 9, 51, "Output",
 CellID->112465210]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16119, 560, 223, 7, 70, "ExampleSection",
 CellID->25981],
Cell[16345, 569, 112, 3, 70, "ExampleText",
 CellID->29591],
Cell[CellGroupData[{
Cell[16482, 576, 315, 10, 70, "Input",
 CellID->25867],
Cell[16800, 588, 2172, 45, 169, "Output",
 CellID->298703914]
}, Open  ]],
Cell[18987, 636, 125, 3, 70, "ExampleDelimiter",
 CellID->259224347],
Cell[19115, 641, 363, 13, 70, "ExampleText",
 CellID->24643],
Cell[CellGroupData[{
Cell[19503, 658, 411, 13, 70, "Input",
 CellID->17668],
Cell[19917, 673, 83058, 1387, 70, "Output",
 CellID->12886709]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[103024, 2066, 231, 7, 70, "ExampleSection",
 CellID->119],
Cell[103258, 2075, 228, 5, 70, "ExampleText",
 CellID->1623],
Cell[CellGroupData[{
Cell[103511, 2084, 418, 13, 70, "Input",
 CellID->6915],
Cell[103932, 2099, 158, 5, 36, "Output",
 CellID->292319906]
}, Open  ]],
Cell[104105, 2107, 121, 3, 70, "ExampleDelimiter",
 CellID->17929],
Cell[104229, 2112, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[104488, 2122, 223, 7, 70, "Input",
 CellID->4715],
Cell[104714, 2131, 211, 7, 52, "Output",
 CellID->392823655]
}, Open  ]],
Cell[CellGroupData[{
Cell[104962, 2143, 426, 14, 70, "Input",
 CellID->12536],
Cell[105391, 2159, 211, 7, 52, "Output",
 CellID->475967213]
}, Open  ]],
Cell[105617, 2169, 121, 3, 70, "ExampleDelimiter",
 CellID->27759],
Cell[105741, 2174, 503, 16, 70, "ExampleText",
 CellID->700],
Cell[CellGroupData[{
Cell[106269, 2194, 180, 6, 70, "Input",
 CellID->24241],
Cell[106452, 2202, 278, 9, 36, "Output",
 CellID->329486375]
}, Open  ]],
Cell[CellGroupData[{
Cell[106767, 2216, 222, 7, 70, "Input",
 CellID->13452],
Cell[106992, 2225, 278, 9, 36, "Output",
 CellID->441999921]
}, Open  ]],
Cell[107285, 2237, 124, 3, 70, "ExampleDelimiter",
 CellID->34754496],
Cell[107412, 2242, 385, 12, 70, "ExampleText",
 CellID->306560643],
Cell[107800, 2256, 283, 11, 70, "Input",
 CellID->746327207],
Cell[CellGroupData[{
Cell[108108, 2271, 302, 10, 70, "Input",
 CellID->811178942],
Cell[108413, 2283, 913, 33, 74, "Output",
 CellID->341173841]
}, Open  ]],
Cell[CellGroupData[{
Cell[109363, 2321, 136, 4, 70, "Input",
 CellID->9976307],
Cell[109502, 2327, 277, 9, 36, "Output",
 CellID->68868539]
}, Open  ]],
Cell[CellGroupData[{
Cell[109816, 2341, 184, 6, 70, "Input",
 CellID->580910229],
Cell[110003, 2349, 277, 9, 36, "Output",
 CellID->93006289]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110329, 2364, 327, 9, 70, "ExampleSection",
 CellID->12448],
Cell[110659, 2375, 468, 14, 70, "ExampleText",
 CellID->5227],
Cell[CellGroupData[{
Cell[111152, 2393, 165, 5, 70, "Input",
 CellID->11798],
Cell[111320, 2400, 204, 5, 70, "Message",
 CellID->201431440],
Cell[111527, 2407, 257, 8, 36, "Output",
 CellID->38647943]
}, Open  ]],
Cell[111799, 2418, 125, 3, 70, "ExampleDelimiter",
 CellID->295204584],
Cell[111927, 2423, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[112233, 2435, 265, 8, 70, "Input",
 CellID->25838],
Cell[112501, 2445, 235, 8, 51, "Output",
 CellID->17931903]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112797, 2460, 310, 9, 70, "SeeAlsoSection",
 CellID->1717],
Cell[113110, 2471, 490, 17, 70, "SeeAlso",
 CellID->8692]
}, Open  ]],
Cell[CellGroupData[{
Cell[113637, 2493, 314, 9, 70, "TutorialsSection",
 CellID->13037],
Cell[113954, 2504, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[114148, 2512, 299, 8, 70, "MoreAboutSection"],
Cell[114450, 2522, 183, 4, 70, "MoreAbout",
 CellID->19640746]
}, Open  ]],
Cell[114648, 2529, 27, 0, 70, "History"],
Cell[114678, 2531, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

