(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42270,       1243]
NotebookOptionsPosition[     35395,       1055]
NotebookOutlinePosition[     38664,       1120]
CellTagsIndexPosition[     38578,       1115]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing and Exporting Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingAndExportingData"], 
          "Importing and Exporting Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingAndExportingFiles"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing and Exporting Data\"\>", 
       2->"\<\"Importing and Exporting Files\"\>", 
       3->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "ExportString" :> 
          Documentation`HelpLookup["paclet:ref/ExportString"], 
          "$ExportFormats" :> 
          Documentation`HelpLookup["paclet:ref/$ExportFormats"], "Write" :> 
          Documentation`HelpLookup["paclet:ref/Write"], "BinaryWrite" :> 
          Documentation`HelpLookup["paclet:ref/BinaryWrite"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"], "MathMLForm" :> 
          Documentation`HelpLookup["paclet:ref/MathMLForm"], "Rasterize" :> 
          Documentation`HelpLookup["paclet:ref/Rasterize"], "DumpSave" :> 
          Documentation`HelpLookup["paclet:ref/DumpSave"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Import\"\>", 
       2->"\<\"ExportString\"\>", 3->"\<\"$ExportFormats\"\>", 
       4->"\<\"Write\"\>", 5->"\<\"BinaryWrite\"\>", 6->"\<\"Put\"\>", 
       7->"\<\"MathMLForm\"\>", 8->"\<\"Rasterize\"\>", 
       9->"\<\"DumpSave\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Importing & Exporting in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ImportingAndExportingInNotebooks"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"], 
          "Sound and Sonification" :> 
          Documentation`HelpLookup["paclet:guide/SoundAndSonification"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Creating Web Pages\"\>", 3->"\<\"External Operations\"\>", 
       4->"\<\"Files\"\>", 5->"\<\"Graphics Importing & Exporting\"\>", 
       6->"\<\"Image Processing\"\>", 7->"\<\"Importing & Exporting\"\>", 
       8->"\<\"Importing & Exporting in Notebooks\"\>", 
       9->"\<\"Signal Processing\"\>", 10->"\<\"Sound and Sonification\"\>", 
       11->"\<\"XML Import & Export\"\>", 
       12->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       13->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Export", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Export",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Export"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\)\>\"", ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]exports data to a file, converting it to the format \
corresponding to the file extension ",
     Cell[BoxData[
      StyleBox["ext", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Export",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Export"], "[", 
       RowBox[{
        StyleBox["file", "TI"], ",", 
        StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]exports data in the specified format."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Export",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Export"], "[", 
       RowBox[{
        StyleBox["file", "TI"], ",", 
        StyleBox["exprs", "TI"], ",", 
        StyleBox["elems", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]exports data by treating ",
     Cell[BoxData[
      StyleBox["exprs", "TI"]], "InlineFormula"],
     " as elements specified by ",
     Cell[BoxData[
      StyleBox["elems", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16614]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " handles a large number of formats, each typically with many different \
possible elements. The possible formats are given in the list ",
 Cell[BoxData[
  ButtonBox["$ExportFormats",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ExportFormats"]], "InlineFormula"],
 ", and in the \"",
 ButtonBox["Listing of All Formats\".",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82144976],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " attempts to render ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in the appropriate format for the file. Among the possible forms for ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is normally the form that would be obtained from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->475159908],

Cell["There are four common types of element specifications:", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->279843971],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     "data representation specifications (e.g. ",
     Cell[BoxData["\"\<RawData\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
     ") "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     "format specifications (e.g. ",
     Cell[BoxData[
      ButtonBox["\"\<GIF\>\"",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["\"\<GZIP\>\"",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/format/GZIP"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["\"\<XLS\>\"",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/format/XLS"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     "options, properties and settings (e.g. ",
     Cell[BoxData[
      ButtonBox["ImageSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
     ",",
     Cell[BoxData[
      RowBox[{"  ", 
       ButtonBox["SampleRate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SampleRate"]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     "metadata information (e.g. ",
     Cell[BoxData["\"\<Comments\>\""], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "1ColumnTableMod",
 CellID->35068049],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{
    StyleBox["file", "TI"], ",", 
    StyleBox["exprs", "TI"], ",", 
    StyleBox["elems", "TI"]}], "]"}]], "InlineFormula"],
 " the elements can have the following basic forms: "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->383619521],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", Cell[
    "use the default element for the specified format", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox["elem", "TI"], Cell[
    "export a single element assuming the default format", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
      StyleBox["elem", "TI"]}], "}"}], Cell[
    "export an element assuming the specified format", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"comp\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "use also compression formats ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"comp\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     " (e.g. \"GZIP\")"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["12", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], Cell[TextData[{
     "export the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " as subelements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox[
        RowBox[{"1", "i"}], "TI"]]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->405487078],

Cell["Forms of elements often supported include:", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15573885],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Data\>\"", Cell[
    "give data in a generic form (list, string, etc.)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Graphics\>\"", Cell[TextData[{
     "give graphics or geometry as a ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Graphics3D\>\"", Cell[TextData[{
     "give 3D graphics or geometry as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Sound\>\"", Cell[TextData[{
     "give sound as a ",
     Cell[BoxData[
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Grid\>\"", Cell[TextData[{
     "give a grid of data as a list or a ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     ", etc."
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Rules\>\"", Cell[
    "give explicit rules for elements to export", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->937754380],

Cell[TextData[{
 "With the ",
 Cell[BoxData["\"\<Rules\>\""], "InlineFormula"],
 " element specification, the rules in ",
 Cell[BoxData[
  StyleBox["exprs", "TI"]], "InlineFormula"],
 " can have the following basic forms:"
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->371779467],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     StyleBox["elem", "TI"], "\[Rule]", 
     StyleBox["val", "TI"]}], Cell[
    "a value for a single element", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "\[Rule]", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "\[Rule]", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "values for several elements", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     SubscriptBox[
      StyleBox["elem", "TI"], 
      StyleBox["1", "TR"]], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["11", "TR"]], "\[Rule]", 
        SubscriptBox[
         StyleBox["val", "TI"], 
         StyleBox["11", "TR"]]}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[
    "values for subelements", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->297710153],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<!\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports data to a pipe. "
}], "Notes",
 CellID->49],

Cell[TextData[{
 "Many options can be given using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{
    StyleBox["file", "TI"], ",", 
    StyleBox["exprs", "TI"], ",", 
    StyleBox["elems", "TI"], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->207689931],

Cell["\<\
The names of options specific to particular formats and elements are normally \
strings.\
\>", "Notes",
 CellID->29903365],

Cell[TextData[{
 "Typical general options include ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SampleRate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SampleRate"]], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->649159396]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->172797900],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->5709173],

Cell["Export a plot as a GIF:", "ExampleText",
 CellID->75014804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.gif\>\"", ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352284339],

Cell[BoxData["\<\"test.gif\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233193267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297836785],

Cell["Export a formula as a GIF:", "ExampleText",
 CellID->146633265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.gif\>\"", ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "4"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37878014],

Cell[BoxData["\<\"test.gif\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47627946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->441020188],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFV1lLw0AQnuaot0W8Kni+1OPBE3zyzetJ8NkLioj2QRSt4J+T/rS42Z1N
1y/TJNJUA3Uy9zezs5v1otl+enhutlv3zdXzt+brU+v+ffXs5U2J/ApRJSCi
xTqp90i96V/8hOpH1IjflGhfUV/RW6YniZZC6xFpGdFBTP1Eqn1c/ljbrYN0
V/2pKvaKqcmwAVY7YsZrUXqq6aYUIejyRDcpifHckjyZJ+6Fy59m9GSvkO86
dzfuoKfoHVOj/WBtyNIG022QrzANtNcnVOEB38ioUrJfkfR0CdLpyMyNz9hi
LIHF5NiNst0QyH2uwXNrcfRLBeN7PeIHOfHlqmZSk+KJqy1LMcc48BLGn9lC
sFguFQ/yiCfMxWO6pheFzONb1u90Oiw70grFs5fPa1QFuwDs0v3op1o7GVhD
6Mi9BFVa/7dokXdRSCgz5hd22aCmt1f/lkvEkDexA+uOG2twO7sULGXt6kch
rj15PYJdn9OPiSj79MXqf5MLY03m5JKrm86pYD4HMfpj1rqI4pAxjjFd47pn
mB9nWo+6X3pXb/uz4Naqo7q5xoD/0lYjHMssv30iHjv3O2vpcLIl7aPXojtL
OZ23d4RrpuaWM2pTJjGkVZb3g7i2fXwfsvfFLPB4z+3WE/aqAM6qsrDb2xPG
LIbYnY9e0bOQx/rgH7Ems9bHfNi5zboJlzUhWIPtCJ5y0v3W7ktP8IGTPcre
jcWw4jlYS/UAu1QDHk+f4j2KUU8pOsTUPSnnop//MZ0bMJVvANGVWg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{260, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->449375462]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27076],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExportString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ExportFormats",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ExportFormats"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Write",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Write"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathMLForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DumpSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DumpSave"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12396]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20634],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "Tutorials",
 CellID->6195],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "Tutorials",
 CellID->15343],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->149826251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->784691696],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->170923291],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout",
 CellID->229971971],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->36909345],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->459729997],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout",
 CellID->17329708],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->230408184],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->119308977],

Cell[TextData[ButtonBox["Importing & Exporting in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExportingInNotebooks"]], "MoreAbout",
 CellID->445501709],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->109641266],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "MoreAbout",
 CellID->117612183],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout",
 CellID->47674869],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->831218382],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->567804141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Export"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Export - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 56.9980804}", "context" -> "System`", 
    "keywords" -> {
     "export filters", "AIFF format", "animations", "arrays", "audio", 
      "AU format", "AutoCAD format", "AVI", "biomedical image format", 
      "bitmap graphics formats", "BMP", "CAD", "comma-separated values", 
      "computer-aided design", "conversions", "CSV format", "data", 
      "desktop publishing", "DICOM", "DIF format", "drawing format", 
      "draw programs", "DXF format", "encapsulated PostScript", "EPS", "EPSF",
       "EPSI", "EPSTIFF", "Excel format", "exporting graphics", 
      "exporting sounds", "ExpressionML", "external data", "files", 
      "FITS format", "flexible Image Transport System", "foreign data", 
      "geometry data", "GIF", "HDF", "hierarchical Data Format", "images", 
      "interchange format", "JFIF", "JPEG", "lines of text", "lists", 
      "lithography", "Lotus 1-2-3 format", "Macintosh PICT", "MAT format", 
      "matrices", "matrix Market format", "medical imaging", 
      "Metafile format", "MGF graphics format", "Microsoft metafile format", 
      "Microsoft wave format", "MTX format", "mu law format", "NotebookML", 
      "output", "paint programs", "PBM graphics format", "PCX", 
      "PGM graphics format", "PICT", "pictures", "Pixmap graphics format", 
      "PNG", "PNM graphics format", "portable anymap format", 
      "portable bitmap format", "portable graymap format", 
      "portable pixmap format", "PPM graphics format", "radiology formats", 
      "raster conversion", "scalable vector graphics", "SND format", 
      "solid object modeling", "sounds", "spreadsheets", "stereo-lithography",
       "STL format", "strings", "SVG", "SymbolicXML", "tables", 
      "tabular data", "three-dimensional graphics", "TIFF", "TSV format", 
      "WAV format", "web", "Windows metafile format", "WMF", "writing", 
      "X Windows graphics format", "XBitmap format", "XLS format", "XML"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Export[\"file. ext\", expr] exports data to a file, converting it to the \
format corresponding to the file extension ext. Export[file, expr, \" \
format\"] exports data in the specified format. Export[file, exprs, elems] \
exports data by treating exprs as elements specified by elems.", 
    "synonyms" -> {}, "title" -> "Export", "type" -> "Symbol", "uri" -> 
    "ref/Export"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[25757, 711, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->172797900]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38434, 1108}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4957, 102, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5580, 129, 4190, 83, 70, "ObjectNameGrid"],
Cell[9773, 214, 1682, 52, 70, "Usage",
 CellID->16614]
}, Open  ]],
Cell[CellGroupData[{
Cell[11492, 271, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11970, 288, 696, 19, 70, "Notes",
 CellID->82144976],
Cell[12669, 309, 822, 26, 70, "Notes",
 CellID->475159908],
Cell[13494, 337, 221, 4, 70, "Notes",
 CellID->279843971],
Cell[13718, 343, 1511, 46, 70, "1ColumnTableMod",
 CellID->35068049],
Cell[15232, 391, 494, 16, 70, "Notes",
 CellID->383619521],
Cell[15729, 409, 3100, 84, 70, "2ColumnTableMod",
 CellID->405487078],
Cell[18832, 495, 208, 4, 70, "Notes",
 CellID->15573885],
Cell[19043, 501, 2656, 66, 70, "2ColumnTableMod",
 CellID->937754380],
Cell[21702, 569, 385, 11, 70, "Notes",
 CellID->371779467],
Cell[22090, 582, 2000, 58, 70, "2ColumnTableMod",
 CellID->297710153],
Cell[24093, 642, 348, 12, 70, "Notes",
 CellID->49],
Cell[24444, 656, 378, 14, 70, "Notes",
 CellID->207689931],
Cell[24825, 672, 132, 4, 70, "Notes",
 CellID->29903365],
Cell[24960, 678, 760, 28, 70, "Notes",
 CellID->649159396]
}, Closed]],
Cell[CellGroupData[{
Cell[25757, 711, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->172797900],
Cell[CellGroupData[{
Cell[26142, 725, 146, 5, 70, "ExampleSection",
 CellID->5709173],
Cell[26291, 732, 65, 1, 70, "ExampleText",
 CellID->75014804],
Cell[CellGroupData[{
Cell[26381, 737, 294, 9, 28, "Input",
 CellID->352284339],
Cell[26678, 748, 173, 5, 36, "Output",
 CellID->233193267]
}, Open  ]],
Cell[26866, 756, 125, 3, 70, "ExampleDelimiter",
 CellID->297836785],
Cell[26994, 761, 69, 1, 70, "ExampleText",
 CellID->146633265],
Cell[CellGroupData[{
Cell[27088, 766, 314, 11, 70, "Input",
 CellID->37878014],
Cell[27405, 779, 172, 5, 36, "Output",
 CellID->47627946]
}, Open  ]],
Cell[CellGroupData[{
Cell[27614, 789, 102, 3, 28, "Input",
 CellID->441020188],
Cell[27719, 794, 1000, 20, 49, "Output",
 Evaluatable->False,
 CellID->449375462]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28780, 821, 311, 9, 70, "SeeAlsoSection",
 CellID->27076],
Cell[29094, 832, 2178, 80, 70, "SeeAlso",
 CellID->12396]
}, Open  ]],
Cell[CellGroupData[{
Cell[31309, 917, 314, 9, 70, "TutorialsSection",
 CellID->20634],
Cell[31626, 928, 163, 3, 70, "Tutorials",
 CellID->6195],
Cell[31792, 933, 166, 3, 70, "Tutorials",
 CellID->15343],
Cell[31961, 938, 170, 3, 70, "Tutorials",
 CellID->149826251]
}, Open  ]],
Cell[CellGroupData[{
Cell[32168, 946, 319, 9, 70, "MoreAboutSection",
 CellID->784691696],
Cell[32490, 957, 173, 3, 70, "MoreAbout",
 CellID->170923291],
Cell[32666, 962, 146, 3, 70, "MoreAbout",
 CellID->229971971],
Cell[32815, 967, 148, 3, 70, "MoreAbout",
 CellID->36909345],
Cell[32966, 972, 122, 3, 70, "MoreAbout",
 CellID->459729997],
Cell[33091, 977, 170, 3, 70, "MoreAbout",
 CellID->17329708],
Cell[33264, 982, 143, 3, 70, "MoreAbout",
 CellID->230408184],
Cell[33410, 987, 154, 3, 70, "MoreAbout",
 CellID->119308977],
Cell[33567, 992, 178, 3, 70, "MoreAbout",
 CellID->445501709],
Cell[33748, 997, 145, 3, 70, "MoreAbout",
 CellID->109641266],
Cell[33896, 1002, 154, 3, 70, "MoreAbout",
 CellID->117612183],
Cell[34053, 1007, 148, 3, 70, "MoreAbout",
 CellID->47674869],
Cell[34204, 1012, 185, 3, 70, "MoreAbout",
 CellID->831218382],
Cell[34392, 1017, 179, 3, 70, "MoreAbout",
 CellID->567804141]
}, Open  ]],
Cell[CellGroupData[{
Cell[34608, 1025, 305, 8, 70, "RelatedLinksSection"],
Cell[34916, 1035, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[35315, 1051, 50, 0, 70, "History"],
Cell[35368, 1053, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

