(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26088,        769]
NotebookOptionsPosition[     21743,        628]
NotebookOutlinePosition[     23221,        667]
CellTagsIndexPosition[     23136,        662]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing and Exporting Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingAndExportingData"], 
          "Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"], 
          "Importing and Exporting Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingAndExportingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing and Exporting Data\"\>", 
       2->"\<\"Importing Graphics and Sounds\"\>", 
       3->"\<\"Exporting Graphics and Sounds\"\>", 
       4->"\<\"Importing and Exporting Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "ImportString" :> 
          Documentation`HelpLookup["paclet:ref/ImportString"], "Rasterize" :> 
          Documentation`HelpLookup["paclet:ref/Rasterize"], "Compress" :> 
          Documentation`HelpLookup["paclet:ref/Compress"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Export\"\>", 
       2->"\<\"ImportString\"\>", 3->"\<\"Rasterize\"\>", 
       4->"\<\"Compress\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"], 
          "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"Converting between Expressions & Strings\"\>", 
       3->"\<\"Importing & Exporting\"\>", 4->"\<\"String Manipulation\"\>", 
       5->"\<\"String Operations\"\>", 
       6->"\<\"XML Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExportString", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExportString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExportString"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a string corresponding to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " exported in the specified format. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExportString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExportString"], "[", 
       RowBox[{
        StyleBox["rules", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", "\"\<Rules\>\""}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives explicit rules for different elements of the data \
to be exported. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExportString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExportString"], "[", 
       RowBox[{
        StyleBox["exprs", "TI"], ",", 
        StyleBox["elems", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a string by treating ",
     Cell[BoxData[
      StyleBox["exprs", "TI"]], "InlineFormula"],
     " as elements specified by ",
     Cell[BoxData[
      StyleBox["elems", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " handles a large number of formats, each typically with many different \
possible elements. The possible formats are given in the list ",
 Cell[BoxData[
  ButtonBox["$ExportFormats",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ExportFormats"]], "InlineFormula"],
 ", and in the \"",
 ButtonBox["Listing of All Formats\".",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82144976],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " works just like ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ", with the same element specifications and options."
}], "Notes",
 CellID->27840],

Cell["\<\
Many graphics, sound and binary formats yield strings containing \
non\[Hyphen]printable characters. \
\>", "Notes",
 CellID->12798]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109724190],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->188696957],

Cell["Export in MathML format:", "ExampleText",
 CellID->82257823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "\"\<MathML\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->639010064],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<semantics>\\n  <mrow>\\n   <mi>x</mi>\\n   <mo>+</mo>\\n   <mi>y</mi>\\n  \
</mrow>\\n  <annotation-xml encoding='MathML-Content'>\\n   <apply>\\n    \
<plus/>\\n    <ci>x</ci>\\n    <ci>y</ci>\\n   </apply>\\n  </annotation-xml>\
\\n </semantics>\\n</math>\"\>"], "Output",
 ImageSize->{347, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291924703]
}, Open  ]],

Cell["Show explicitly as a string:", "ExampleText",
 CellID->165315362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->380184645],

Cell["\<\
\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <semantics>\\n  <mrow>\
\\n   \\
<mi>x</mi>\\n   <mo>+</mo>\\n   <mi>y</mi>\\n  </mrow>\\n  <annotation-xml \\
encoding='MathML-Content'>\\n   <apply>\\n    <plus/>\\n    <ci>x</ci>\\n    \
\\
<ci>y</ci>\\n   </apply>\\n  </annotation-xml>\\n </semantics>\\n</math>\"\
\>", "Output",
 ImageSize->{560, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->643864632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2130465],

Cell["Export a graphic in SVG format:", "ExampleText",
 CellID->271292998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Disk", "[", "]"}], "]"}], ",", "\"\<SVG\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115813604],

Cell[BoxData["\<\"<!DOCTYPE svg PUBLIC \\\"-//W3C//DTD SVG 1.1//EN\\\" \
\\\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\\">\\n<svg \
version='1.1' xmlns='http://www.w3.org/2000/svg' \
xmlns:xlink='http://www.w3.org/1999/xlink'>\\n<g \
transform='translate(-74.000000, -13.000000)'>\\n<g \
transform='matrix(1.000000, 0.000000, 0.000000, 1.000000, 0.000000, \
0.000000)' clip-path='url(#cp1)'>\\n<clipPath id='cp1'><polygon \
points='-3.35544e+007,-3.35544e+007 -3.35544e+007,3.35544e+007 \
3.35544e+007,3.35544e+007 3.35544e+007,-3.35544e+007 ' /></clipPath>\\n<rect \
fill='rgb(100%,100%,100%)' stroke='none' x='74' y='13' width='360' \
height='359' />\\n</g>\\n<g transform='matrix(1.000000, 0.000000, 0.000000, \
1.000000, 0.000000, 0.000000)' clip-path='url(#cp2)'>\\n<clipPath \
id='cp2'><polygon points='74,13 74,372 434,372 434,13 ' \
/></clipPath>\\n<ellipse fill='rgb(0%,0%,0%)' opacity='1' stroke='none' \
cx='254' cy='192' rx='172.313' ry='172.313' \
/>\\n</g>\\n</g>\\n<defs>\\n</defs>\\n</svg>\"\>"], "Output",
 ImageSize->{557, 390},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135558478]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->220296288],

Cell["\<\
Many formats give strings containing non-printable characters:\
\>", "ExampleText",
 CellID->319659636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Disk", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}], ",", "\"\<GIF\>\""}], 
   "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->748093459],

Cell["\<\
\"GIF89a\\n\.0f\[CapitalADoubleDot]\\b\\b\\b\.18\.18\.18(((@@@HHHPPPXXXhhhppp\
\.7f\.7f\.7f\.87\.87\.87\.97\.97\.97\.9f\.9f\.9f\[CenterDot]\[CenterDot]\
\[CenterDot]\[DownQuestion]\[DownQuestion]\[DownQuestion]\[CapitalCCedilla]\
\[CapitalCCedilla]\[CapitalCCedilla]\[Times]\[Times]\[Times]\[YDoubleDot]\
\[YDoubleDot]\[YDoubleDot]\\
,\\n\.0f\.052\[NonBreakingSpace]$\.8edi\.9eh\.aa\[Cent]\.91r(\.10\
\[CapitalUGrave]\.04@\\r,bD\[CapitalUHat]\[OTilde]#%\\
<\.9bAR\\b\[CapitalODoubleDot]\.06\.12\.84\.11P\.908\.96\\f\.91\.92\[Times]\
\.1c5\\b\.02\.02N\.12\.02;\"\
\>", "Output",
 ImageSize->{483, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->49368728]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->292260160],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<GIF89a\\n\\.00\\.0f\\.00\\[CapitalADoubleDot]\\.00\\.00\\.00\\.00\\.\
00\\.08\\.08\\.08\\.18\\.18\\.18(((@@@HHHPPPXXXhhhppp\\.7f\\.7f\\.7f\\.87\\.\
87\\.87\\.97\\.97\\.97\\.9f\\.9f\\.9f\\[CenterDot]\\[CenterDot]\\[CenterDot]\\\
[DownQuestion]\\[DownQuestion]\\[DownQuestion]\\[CapitalCCedilla]\\[\
CapitalCCedilla]\\[CapitalCCedilla]\\[Times]\\[Times]\\[Times]\\[YDoubleDot]\\\
[YDoubleDot]\\[YDoubleDot]\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\\
.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.\
00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00\\.00,\\.00\\.\
00\\.00\\.00\\n\\.00\\.0f\\.00\\.00\\.052\\[NonBreakingSpace]$\\.8edi\\.9eh\\.\
aa\\[Cent]\\.91r(\\.10\\[CapitalUGrave]\\.04@\\r,bD\\[CapitalUHat]\\[OTilde]#%\
<\\.9bAR\\.08\\[CapitalODoubleDot]\\.06\\.12\\.84\\.11P\\.908\\.96\\f\\.91\\.\
92\\[Times]\\.1c5\\.08\\.02\\.02N\\.12\\.02\\.00;\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{585, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->1974940]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14514],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compress",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18178]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6441],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "Tutorials",
 CellID->12912],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "Tutorials",
 CellID->509]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->152811793],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->126522681],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->406086325],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->117160265],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->4417665],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->404985463],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout",
 CellID->260105029]
}, Open  ]],

Cell["New in 4  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExportString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 58.0449822}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExportString[expr, \" format\"] generates a string corresponding to expr \
exported in the specified format. ExportString[rules, {\"format\", \
\"Rules\"}] gives explicit rules for different elements of the data to be \
exported. ExportString[exprs, elems] generates a string by treating exprs as \
elements specified by elems.", "synonyms" -> {"export string"}, "title" -> 
    "ExportString", "type" -> "Symbol", "uri" -> "ref/ExportString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11736, 306, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->109724190]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22992, 655}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3432, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4055, 103, 4196, 83, 70, "ObjectNameGrid"],
Cell[8254, 188, 1711, 52, 70, "Usage",
 CellID->24022]
}, Open  ]],
Cell[CellGroupData[{
Cell[10002, 245, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10480, 262, 708, 19, 70, "Notes",
 CellID->82144976],
Cell[11191, 283, 363, 12, 70, "Notes",
 CellID->27840],
Cell[11557, 297, 142, 4, 70, "Notes",
 CellID->12798]
}, Closed]],
Cell[CellGroupData[{
Cell[11736, 306, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109724190],
Cell[CellGroupData[{
Cell[12121, 320, 148, 5, 70, "ExampleSection",
 CellID->188696957],
Cell[12272, 327, 66, 1, 70, "ExampleText",
 CellID->82257823],
Cell[CellGroupData[{
Cell[12363, 332, 168, 5, 28, "Input",
 CellID->639010064],
Cell[12534, 339, 480, 9, 292, "Output",
 CellID->291924703]
}, Open  ]],
Cell[13029, 351, 71, 1, 70, "ExampleText",
 CellID->165315362],
Cell[CellGroupData[{
Cell[13125, 356, 105, 3, 70, "Input",
 CellID->380184645],
Cell[13233, 361, 490, 12, 98, "Output",
 CellID->643864632]
}, Open  ]],
Cell[13738, 376, 123, 3, 70, "ExampleDelimiter",
 CellID->2130465],
Cell[13864, 381, 74, 1, 70, "ExampleText",
 CellID->271292998],
Cell[CellGroupData[{
Cell[13963, 386, 205, 6, 70, "Input",
 CellID->115813604],
Cell[14171, 394, 1162, 20, 411, "Output",
 CellID->135558478]
}, Open  ]],
Cell[15348, 417, 125, 3, 70, "ExampleDelimiter",
 CellID->220296288],
Cell[15476, 422, 113, 3, 70, "ExampleText",
 CellID->319659636],
Cell[CellGroupData[{
Cell[15614, 429, 313, 10, 70, "Input",
 CellID->748093459],
Cell[15930, 441, 728, 15, 82, "Output",
 CellID->49368728]
}, Open  ]],
Cell[CellGroupData[{
Cell[16695, 461, 104, 3, 70, "Input",
 CellID->292260160],
Cell[16802, 466, 1202, 23, 204, "Output",
 CellID->1974940]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18065, 496, 311, 9, 70, "SeeAlsoSection",
 CellID->14514],
Cell[18379, 507, 947, 35, 70, "SeeAlso",
 CellID->18178]
}, Open  ]],
Cell[CellGroupData[{
Cell[19363, 547, 313, 9, 70, "TutorialsSection",
 CellID->6441],
Cell[19679, 558, 164, 3, 70, "Tutorials",
 CellID->12912],
Cell[19846, 563, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[20014, 568, 170, 3, 70, "Tutorials",
 CellID->503348882],
Cell[20187, 573, 164, 3, 70, "Tutorials",
 CellID->509]
}, Open  ]],
Cell[CellGroupData[{
Cell[20388, 581, 319, 9, 70, "MoreAboutSection",
 CellID->152811793],
Cell[20710, 592, 151, 3, 70, "MoreAbout",
 CellID->126522681],
Cell[20864, 597, 193, 4, 70, "MoreAbout",
 CellID->406086325],
Cell[21060, 603, 154, 3, 70, "MoreAbout",
 CellID->117160265],
Cell[21217, 608, 147, 3, 70, "MoreAbout",
 CellID->4417665],
Cell[21367, 613, 145, 3, 70, "MoreAbout",
 CellID->404985463],
Cell[21515, 618, 133, 3, 70, "MoreAbout",
 CellID->260105029]
}, Open  ]],
Cell[21663, 624, 50, 0, 70, "History"],
Cell[21716, 626, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

