(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44126,       1272]
NotebookOptionsPosition[     38892,       1098]
NotebookOutlinePosition[     40352,       1137]
CellTagsIndexPosition[     40266,       1132]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TextCell" :> Documentation`HelpLookup["paclet:ref/TextCell"], 
          "CellGroup" :> Documentation`HelpLookup["paclet:ref/CellGroup"], 
          "CellPrint" :> Documentation`HelpLookup["paclet:ref/CellPrint"], 
          "Print" :> Documentation`HelpLookup["paclet:ref/Print"], "Cell" :> 
          Documentation`HelpLookup["paclet:ref/Cell"], "CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TextCell\"\>", 
       2->"\<\"CellGroup\"\>", 3->"\<\"CellPrint\"\>", 4->"\<\"Print\"\>", 
       5->"\<\"Cell\"\>", 6->"\<\"CreateDocument\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Cell Styling Options\"\>", 
       2->"\<\"Document Generation\"\>", 
       3->"\<\"Toolbars\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExpressionCell", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExpressionCell",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExpressionCell"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an expression cell that can appear in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebook.  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExpressionCell",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExpressionCell"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an expression cell with the specified style."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Expression cells can contain any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, including graphics and dynamic objects."
}], "Notes",
 CellID->15146],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 " can appear anywhere in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression."
}], "Notes",
 CellID->3857],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellPrint"], "[", 
   RowBox[{"ExpressionCell", "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is normally effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21225],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpressionCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpressionCell"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " by default formats ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in the current default output format type, typically ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10216],

Cell[TextData[{
 "Typical possible styles for expression cells include ",
 Cell[BoxData["\"\<Input\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Output\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Section\>\""], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->27079],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 " can have any of the many options of ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 ", including for example:"
}], "Notes",
 CellID->14912],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], Cell[
    "how to align the contents of the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], Cell[
    "the color of the background for the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CellBaseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellBaseline"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CellFrame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellFrame"], Cell[
    "whether to draw a frame around the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CellTags",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellTags"], Cell[
    "tags for the cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], Cell[
    "whether to allow the contents of the cell to be edited ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FontSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontSize"], Cell[
    "the default size of text in the cell ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->15495],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpressionCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpressionCell"], "[", 
   ButtonBox["Null",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Null"], "]"}]], "InlineFormula"],
 " gives an empty expression cell."
}], "Notes",
 CellID->70241067]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->230542878],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->248541946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionCell", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "\[Equal]", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1041111766],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", 
    RowBox[{"-", "1"}]}]]],
  ExpressionCell[$CellContext`x^2 == -1]]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236212147]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->215489448],

Cell["\<\
2D and 3D graphics as well as formulas can be part of the content: \
\>", "ExampleText",
 CellID->103112804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionCell", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Disk", "[", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523095382],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   GraphicsBox[DiskBox[{0, 0}]]]],
  ExpressionCell[
   Graphics[
    Disk[{0, 0}]]]]], "Output",
 ImageSize->{104, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->225092633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionCell", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"Sphere", "[", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->147370350],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   Graphics3DBox[SphereBox[{0, 0, 0}],
    ImageSize->{97., Automatic}]],
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  ExpressionCell[
   Graphics3D[
    Sphere[{0, 0, 0}]]]]], "Output",
 ImageSize->{101, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->218437770]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionCell", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}], "^", "3"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->556441217],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWEtTwjAQTkvLS7AzPhC42INe0OEi/gU9edULlw7jDBwcHeQH6C+vSZtA
+3XzaLEzNN3Nt7vf7iYp8JLs1u8fyW6zSuLnbfK13qy+46fPLVe1PMa8H8ZY
NGb8OeVP2Udcv/zD2AO/B1x1I8dLOb6CXsn3mdWjuLeUp5TdgjwC+c2Cx/m7
LIrPFT5/EuMAEG1+E2Io53W4jqMd4mx+XPmc8DHkY7shj1Da6/Logr5vwWM8
5V+XD/rX4ZU+w+duD5P8GhJ4Fu5licq0QdFwKHlSPFzsu9Ie43c0ele/AxKH
Xa7Lsk3iqTVBo9SKa+qjyoxmRHVfz+gYH/l6Ku5uAemBbZBWu6n6YcJ3AU/t
1qJe5+eUyCVU9SRXCRWd2rO6qEU7au+6Zi0eTdmZ+OnOtl6pZ1gbY+9Kaw/j
GfOp7k6oiBmh8x1RnqyrttRhY04uOZqZu1YJ9S4VMHO3MXF9F5TOiVJEt7NM
b3/MyUNlR0cZWCslIgQ1GNJvCC2bin2/nn2VUeUd7B6bfodX6l1CyBODHU4N
NV6ALc6LUUwHcsyXrbrOLNZ7q7BopYxOtbN1mKnTGM/Bto5LKYNAWp8T0fTM
Q4MV9e1PedNGITmp2agg+3twH3wNydWCu2xCovD3xLiR7ynI839kFDXi7WU4
PHkjWVdcMROpRy8UF8p+KvXzmv4jx7h+SvX9GuQFyFcW/NJiP7P4y2uM37Vi
kBcgjyz4pcV+ZvHXIjsfp+ZcseKIr1sruoPiMf93gHl/Ciog2w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{384, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->254973588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145783274],

Cell["An expression cell can appear within a text cell:", "ExampleText",
 CellID->142975216],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<The equation \>\"", ",", 
       RowBox[{"ExpressionCell", "[", 
        RowBox[{"TraditionalForm", "[", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "\[Equal]", 
          RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
       "\"\< has 2 solutions.\>\""}], "}"}], "]"}], ",", "\"\<Text\>\""}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->447302345],

Cell[TextData[{
 "The equation ",
 Cell[BoxData[
  FormBox[
   TagBox[
    FormBox[
     RowBox[{
      SuperscriptBox["x", "2"], "\[LongEqual]", 
      RowBox[{"-", "1"}]}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], TraditionalForm]]],
 " has 2 solutions."
}], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->433310136],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524412],

Cell["Use different named styles:", "ExampleText",
 CellID->110107347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ExpressionCell", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ",", "s"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Input\>\"", ",", "\"\<Output\>\"", ",", "\"\<Section\>\"", ",", 
       "\"\<Title\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216355215],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[Cell[BoxData[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]], "Input"],
    ExpressionCell[1 + $CellContext`x + $CellContext`x^2, "Input"]], ",", 
   InterpretationBox[Cell[BoxData[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]], "Output"],
    ExpressionCell[1 + $CellContext`x + $CellContext`x^2, "Output"]], ",", 
   InterpretationBox[Cell[BoxData[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]], "Section"],
    ExpressionCell[1 + $CellContext`x + $CellContext`x^2, "Section"]], ",", 
   InterpretationBox[Cell[BoxData[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]], "Title"],
    ExpressionCell[1 + $CellContext`x + $CellContext`x^2, "Title"]]}], 
  "}"}]], "Output",
 ImageSize->{318, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->606806613]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19],

Cell["\<\
A simple function that produces a document as an answer using expression and \
text cells:\
\>", "ExampleText",
 CellID->572428943],

Cell[BoxData[
 RowBox[{
  RowBox[{"documentSolve", "[", " ", 
   RowBox[{"eqns_", ",", "vars_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"DocumentNotebook", "@", 
   RowBox[{"TextCell", "[", 
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<The equation \>\"", ",", " ", 
        RowBox[{"ExpressionCell", "[", 
         RowBox[{"TraditionalForm", "[", "eqns", "]"}], "]"}], ",", " ", 
        "\"\< has the following solutions: \>\"", ",", " ", 
        RowBox[{"ExpressionCell", "[", 
         RowBox[{"Row", "[", 
          RowBox[{
           RowBox[{"vars", "/.", 
            RowBox[{"NSolve", "[", 
             RowBox[{"eqns", ",", "vars"}], "]"}]}], ",", "\"\<, \>\""}], 
          "]"}], "]"}]}], "}"}], "]"}], ",", "\"\<Text\>\""}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247294538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"documentSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "+", "x"}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112586200],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        StyleBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         DynamicUpdating->True],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookPut[
            Notebook[{
              Cell[
               TextData[{"The equation ", 
                 Cell[
                  BoxData[
                   FormBox[
                    TagBox[
                    FormBox[
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["x", "3"], "+", "x"}], "\[LongEqual]", 
                    "1"}], TraditionalForm], TraditionalForm, Editable -> 
                    True], TraditionalForm]]], 
                 " has the following solutions: ", 
                 Cell[
                  BoxData[
                   FormBox[
                    InterpretationBox[
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "0.34116390191400964`"}], "-", 
                    RowBox[{"1.161541399997252`", " ", "\[ImaginaryI]"}]}], 
                    ", ", 
                    RowBox[{
                    RowBox[{"-", "0.34116390191400964`"}], "+", 
                    RowBox[{"1.161541399997252`", " ", "\[ImaginaryI]"}]}], 
                    ", ", "0.6823278038280193`"}], 
                    Row[{
                    Complex[-0.34116390191400964`, -1.161541399997252], 
                    Complex[-0.34116390191400964`, 1.161541399997252], 
                    0.6823278038280193}, ", "]], StandardForm]]]}], 
               "Text"]}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[TextData[{
          "The equation ",
          Cell[BoxData[
           FormBox[
            TagBox[
             FormBox[
              RowBox[{
               RowBox[{
                SuperscriptBox["x", "3"], "+", "x"}], "\[LongEqual]", "1"}],
              TraditionalForm],
             TraditionalForm,
             Editable->True], TraditionalForm]]],
          " has the following solutions: ",
          Cell[BoxData[
           InterpretationBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "0.34116390191400964`"}], "-", 
              RowBox[{"1.161541399997252`", " ", "\[ImaginaryI]"}]}], ",", 
             " ", 
             RowBox[{
              RowBox[{"-", "0.34116390191400964`"}], "+", 
              RowBox[{"1.161541399997252`", " ", "\[ImaginaryI]"}]}], ",", 
             " ", "0.6823278038280193`"}],
            Row[{
              Complex[-0.34116390191400964`, -1.161541399997252], 
              Complex[-0.34116390191400964`, 1.161541399997252], 
              0.6823278038280193}, ", "]]]]
         }], "Text"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  DocumentNotebook[
   TextCell[
    Row[{"The equation ", 
      ExpressionCell[
       TraditionalForm[$CellContext`x + $CellContext`x^3 == 1]], 
      " has the following solutions: ", 
      ExpressionCell[
       Row[{
         Complex[-0.34116390191400964`, -1.161541399997252], 
         Complex[-0.34116390191400964`, 1.161541399997252], 
         0.6823278038280193}, ", "]]}], "Text"]]]], "Output",
 ImageSize->{384, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->800866441]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10602],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TextCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextCell"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 " format contents differently:"
}], "ExampleText",
 CellID->87185551],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"TextCell", "[", 
     RowBox[{"\"\<abcde\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
    RowBox[{"ExpressionCell", "[", 
     RowBox[{"\"\<abcde\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216900429],

Cell["abcde", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->725310838],

Cell[BoxData["\"\<abcde\>\""], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->629834323],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->494115327],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " is used for low-level descriptions, including forms that are not complete \
expressions:"
}], "ExampleText",
 CellID->171350148],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<a\>\"", ",", "\"\<=\>\""}], "}"}], "]"}], "]"}], ",", 
    "\"\<Input\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222738207],

Cell[BoxData[
 RowBox[{"a", "="}]], "Input",
 CellAutoOverwrite->True,
 CellLabel->"In[2]:=",
 CellID->219885053]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14240],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellPrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30220]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->371719201],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout",
 CellID->111818749],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->4209518],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->52560667]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpressionCell - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 58.4981188}", "context" -> "System`", 
    "keywords" -> {
     "document generation", "graphics 3D cell", "graphics cell", 
      "non-text cell", "report generation", "typeset cell"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExpressionCell[expr] gives an expression cell that can appear in a \
Mathematica notebook. ExpressionCell[expr, \" style\"] gives an expression \
cell with the specified style.", "synonyms" -> {"expression cell"}, "title" -> 
    "ExpressionCell", "type" -> "Symbol", "uri" -> "ref/ExpressionCell"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9890, 306, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->230542878]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40123, 1125}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1893, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2516, 67, 1579, 37, 70, "ObjectNameGrid"],
Cell[4098, 106, 978, 29, 70, "Usage",
 CellID->18341]
}, Open  ]],
Cell[CellGroupData[{
Cell[5113, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5591, 157, 188, 6, 70, "Notes",
 CellID->15146],
Cell[5782, 165, 278, 11, 70, "Notes",
 CellID->3857],
Cell[6063, 178, 478, 17, 70, "Notes",
 CellID->21225],
Cell[6544, 197, 505, 17, 70, "Notes",
 CellID->10216],
Cell[7052, 216, 279, 9, 70, "Notes",
 CellID->27079],
Cell[7334, 227, 356, 12, 70, "Notes",
 CellID->14912],
Cell[7693, 241, 1836, 47, 70, "2ColumnTableMod",
 CellID->15495],
Cell[9532, 290, 321, 11, 70, "Notes",
 CellID->70241067]
}, Closed]],
Cell[CellGroupData[{
Cell[9890, 306, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->230542878],
Cell[CellGroupData[{
Cell[10275, 320, 148, 5, 70, "ExampleSection",
 CellID->248541946],
Cell[CellGroupData[{
Cell[10448, 329, 184, 6, 28, "Input",
 CellID->1041111766],
Cell[10635, 337, 313, 10, 36, "Output",
 CellID->236212147]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10997, 353, 220, 7, 70, "ExampleSection",
 CellID->215489448],
Cell[11220, 362, 118, 3, 70, "ExampleText",
 CellID->103112804],
Cell[CellGroupData[{
Cell[11363, 369, 172, 5, 70, "Input",
 CellID->523095382],
Cell[11538, 376, 328, 11, 123, "Output",
 CellID->225092633]
}, Open  ]],
Cell[CellGroupData[{
Cell[11903, 392, 176, 5, 70, "Input",
 CellID->147370350],
Cell[12082, 399, 12656, 215, 128, "Output",
 CellID->218437770]
}, Open  ]],
Cell[CellGroupData[{
Cell[24775, 619, 231, 8, 70, "Input",
 CellID->556441217],
Cell[25009, 629, 996, 20, 70, "Output",
 Evaluatable->False,
 CellID->254973588]
}, Open  ]],
Cell[26020, 652, 125, 3, 70, "ExampleDelimiter",
 CellID->145783274],
Cell[26148, 657, 92, 1, 70, "ExampleText",
 CellID->142975216],
Cell[26243, 660, 514, 15, 70, "Input",
 CellID->447302345],
Cell[26760, 677, 360, 16, 70, "Text",
 CellID->433310136],
Cell[27123, 695, 122, 3, 70, "ExampleDelimiter",
 CellID->524412],
Cell[27248, 700, 70, 1, 70, "ExampleText",
 CellID->110107347],
Cell[CellGroupData[{
Cell[27343, 705, 447, 15, 70, "Input",
 CellID->216355215],
Cell[27793, 722, 949, 24, 47, "Output",
 CellID->606806613]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28791, 752, 220, 7, 70, "ExampleSection",
 CellID->19],
Cell[29014, 761, 141, 4, 70, "ExampleText",
 CellID->572428943],
Cell[29158, 767, 850, 22, 70, "Input",
 CellID->247294538],
Cell[CellGroupData[{
Cell[30033, 793, 218, 8, 70, "Input",
 CellID->112586200],
Cell[30254, 803, 3985, 107, 70, "Output",
 CellID->800866441]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34288, 916, 233, 7, 70, "ExampleSection",
 CellID->10602],
Cell[34524, 925, 346, 12, 70, "ExampleText",
 CellID->87185551],
Cell[34873, 939, 333, 10, 70, "Input",
 CellID->216900429],
Cell[35209, 951, 89, 3, 70, "Text",
 CellID->725310838],
Cell[35301, 956, 106, 3, 70, "Text",
 CellID->629834323],
Cell[35410, 961, 125, 3, 70, "ExampleDelimiter",
 CellID->494115327],
Cell[35538, 966, 258, 8, 70, "ExampleText",
 CellID->171350148],
Cell[35799, 976, 320, 10, 70, "Input",
 CellID->222738207],
Cell[36122, 988, 113, 4, 70, "Input",
 CellID->219885053]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36284, 998, 311, 9, 70, "SeeAlsoSection",
 CellID->14240],
Cell[36598, 1009, 1433, 53, 70, "SeeAlso",
 CellID->30220]
}, Open  ]],
Cell[CellGroupData[{
Cell[38068, 1067, 319, 9, 70, "MoreAboutSection",
 CellID->371719201],
Cell[38390, 1078, 150, 3, 70, "MoreAbout",
 CellID->111818749],
Cell[38543, 1083, 147, 3, 70, "MoreAbout",
 CellID->4209518],
Cell[38693, 1088, 127, 3, 70, "MoreAbout",
 CellID->52560667]
}, Open  ]],
Cell[38835, 1094, 27, 0, 70, "History"],
Cell[38865, 1096, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

