(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17621,        656]
NotebookOptionsPosition[     13657,        523]
NotebookOutlinePosition[     15060,        562]
CellTagsIndexPosition[     14975,        557]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GCD" :> Documentation`HelpLookup["paclet:ref/GCD"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], 
          "HermiteDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/HermiteDecomposition"], 
          "PolynomialExtendedGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialExtendedGCD"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GCD\"\>", 
       2->"\<\"Reduce\"\>", 3->"\<\"HermiteDecomposition\"\>", 
       4->"\<\"PolynomialExtendedGCD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Theoretic Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumberTheoreticFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Number Theoretic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExtendedGCD", "ObjectName",
 CellID->15499],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExtendedGCD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExtendedGCD"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the extended greatest common divisor of the \
integers ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27612]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExtendedGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExtendedGCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " returns a list ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"g", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["r", "1"], ",", 
       SubscriptBox["r", "2"], ",", "\[Ellipsis]"}], "}"}]}], "}"}], 
   TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["r", "1"], 
      SubscriptBox["n", "1"]}], "+", 
     RowBox[{
      SubscriptBox["r", "2"], 
      SubscriptBox["n", "2"]}], "+", "\[Ellipsis]"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->3380],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExtendedGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtendedGCD"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99387556],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->173795701],

Cell[TextData[{
 "The extended greatest common divisor of ",
 Cell[BoxData["2"], "InlineFormula"],
 " and ",
 Cell[BoxData["3"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1029306650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "}"}], "=", 
  RowBox[{"ExtendedGCD", "[", 
   RowBox[{"2", ",", " ", "3"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->844688828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63970570]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", "a"}], "+", 
   RowBox[{"3", "b"}]}], "\[Equal]", "g"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->313290230],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110666121]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226748950],

Cell["Compute the extended GCD of several integers: ", "ExampleText",
 CellID->72086941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}], "=", 
  RowBox[{"ExtendedGCD", "[", 
   RowBox[{"6", ",", "15", ",", "30"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643120644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->559639]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"6", "a"}], "+", 
   RowBox[{"15", "b"}], "+", 
   RowBox[{"30", "c"}]}], "\[Equal]", "g"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->225283741],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59368217]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13789],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExtendedGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtendedGCD"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->1086988593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExtendedGCD", "[", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373897522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402028825]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28545],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HermiteDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermiteDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialExtendedGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialExtendedGCD"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2595]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3249],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->19725]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->30125],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/GreatestCommonDivisor.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/ExtendedGCD/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ExtendedGCD"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->328998691],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->6108532]
}, Open  ]],

Cell["New in 1  |  Last modified in 4.2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExtendedGCD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 4.2795168}", "context" -> "System`", 
    "keywords" -> {
     "egcd", "extended Euclidean algorithm", "extended GCD", 
      "Aryabhatta's identity", "Bezout identity", "Diophantine identity", 
      "Diophantine equation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExtendedGCD[n_1, n_2, ...] gives the extended greatest common divisor of \
the integers n_i. ", "synonyms" -> {"extended GCD"}, "title" -> "ExtendedGCD",
     "type" -> "Symbol", "uri" -> "ref/ExtendedGCD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6018, 209, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->99387556]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14833, 550}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2215, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2838, 81, 49, 1, 70, "ObjectName",
 CellID->15499],
Cell[2890, 84, 845, 28, 70, "Usage",
 CellID->27612]
}, Open  ]],
Cell[CellGroupData[{
Cell[3772, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4250, 134, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4385, 140, 1382, 55, 70, "Notes",
 CellID->3380],
Cell[5770, 197, 211, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6018, 209, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99387556],
Cell[CellGroupData[{
Cell[6402, 223, 148, 5, 70, "ExampleSection",
 CellID->173795701],
Cell[6553, 230, 191, 7, 70, "ExampleText",
 CellID->1029306650],
Cell[CellGroupData[{
Cell[6769, 241, 257, 9, 28, "Input",
 CellID->844688828],
Cell[7029, 252, 272, 10, 36, "Output",
 CellID->63970570]
}, Open  ]],
Cell[CellGroupData[{
Cell[7338, 267, 160, 6, 28, "Input",
 CellID->313290230],
Cell[7501, 275, 161, 5, 36, "Output",
 CellID->110666121]
}, Open  ]],
Cell[7677, 283, 125, 3, 70, "ExampleDelimiter",
 CellID->226748950],
Cell[7805, 288, 88, 1, 70, "ExampleText",
 CellID->72086941],
Cell[CellGroupData[{
Cell[7918, 293, 274, 9, 70, "Input",
 CellID->643120644],
Cell[8195, 304, 281, 10, 36, "Output",
 CellID->559639]
}, Open  ]],
Cell[CellGroupData[{
Cell[8513, 319, 191, 7, 70, "Input",
 CellID->225283741],
Cell[8707, 328, 160, 5, 36, "Output",
 CellID->59368217]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8916, 339, 216, 7, 70, "ExampleSection",
 CellID->13789],
Cell[9135, 348, 217, 7, 70, "ExampleText",
 CellID->1086988593],
Cell[CellGroupData[{
Cell[9377, 359, 180, 6, 70, "Input",
 CellID->373897522],
Cell[9560, 367, 431, 16, 36, "Output",
 CellID->402028825]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10052, 390, 311, 9, 70, "SeeAlsoSection",
 CellID->28545],
Cell[10366, 401, 976, 35, 70, "SeeAlso",
 CellID->2595]
}, Open  ]],
Cell[CellGroupData[{
Cell[11379, 441, 313, 9, 70, "TutorialsSection",
 CellID->3249],
Cell[11695, 452, 198, 4, 70, "Tutorials",
 CellID->19725]
}, Open  ]],
Cell[CellGroupData[{
Cell[11930, 461, 321, 9, 70, "RelatedLinksSection",
 CellID->30125],
Cell[12254, 472, 192, 4, 70, "RelatedLinks"],
Cell[12449, 478, 200, 4, 70, "RelatedLinks"],
Cell[12652, 484, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13078, 502, 319, 9, 70, "MoreAboutSection",
 CellID->328998691],
Cell[13400, 513, 160, 3, 70, "MoreAbout",
 CellID->6108532]
}, Open  ]],
Cell[13575, 519, 52, 0, 70, "History"],
Cell[13630, 521, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

