(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20280,        735]
NotebookOptionsPosition[     15935,        591]
NotebookOutlinePosition[     17375,        630]
CellTagsIndexPosition[     17290,        625]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Lists by Their Indices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Part" :> Documentation`HelpLookup["paclet:ref/Part"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Part\"\>", 2->"\<\"Take\"\>", 
       3->"\<\"PadLeft\"\>", 4->"\<\"ReplacePart\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Evaluation Control\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Parts of Expressions\"\>", 
       5->"\<\"Parts of Matrices\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Extract", "ObjectName",
 CellID->8508],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Extract",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extract"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]extracts the part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at the position specified by ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Extract",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extract"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["list", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["list", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]extracts a list of parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Extract",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extract"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]extracts parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", wrapping each of them with head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " before evaluation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6652]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17427],

Cell[TextData[{
 "The position specifications used by ",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 " have the same form as those returned by ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ", and used in functions such as ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->698],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    ButtonBox["Hold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hold"]}], "]"}]], "InlineFormula"],
 " to extract parts without evaluation. "
}], "Notes",
 CellID->25129],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " extracts parts in the corresponding ordinary array. "
}], "Notes",
 CellID->15138]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14571462],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->13451251],

Cell["Extract the second part from an expression:", "ExampleText",
 CellID->48653107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193137912],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->594524554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->435737],

Cell["Extract a part nested in an expression:", "ExampleText",
 CellID->55068769],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", " ", "=", " ", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", "[", "3", "]"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->628940255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{"e", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15933473],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63686635]
}, Open  ]],

Cell["Extract parts from multiple positions:", "ExampleText",
 CellID->587516266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{"e", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58453005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->388287617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->693810481],

Cell[TextData[{
 "Extract the parts given by ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->226172305],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", " ", "=", " ", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", "[", "3", "]"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->602870109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{"Position", "[", 
   RowBox[{"e", ",", "_Integer"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156520741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->611697471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{"e", ",", "p"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->181586244],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79246503]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27166],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15548]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11800],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->28803]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Extract",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Extract"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->5865571],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->134851885],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->49258217],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->732308],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->305842016],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->708923370]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Extract - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 5.3264186}", "context" -> "System`", 
    "keywords" -> {
     "parts", "unevaluated expressions", "positions", "indices"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Extract[expr, list] extracts the part of expr at the position specified \
by list. Extract[expr, {list_1, list_2, ...}] extracts a list of parts of \
expr. Extract[expr, list, h] extracts parts of expr, wrapping each of them \
with head h before evaluation. ", "synonyms" -> {}, "title" -> "Extract", 
    "type" -> "Symbol", "uri" -> "ref/Extract"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8122, 270, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14571462]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17148, 618}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2618, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3241, 87, 44, 1, 70, "ObjectName",
 CellID->8508],
Cell[3288, 90, 1960, 63, 70, "Usage",
 CellID->6652]
}, Open  ]],
Cell[CellGroupData[{
Cell[5285, 158, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5763, 175, 692, 26, 70, "Notes",
 CellID->17427],
Cell[6458, 203, 656, 23, 70, "Notes",
 CellID->698],
Cell[7117, 228, 419, 15, 70, "Notes",
 CellID->25129],
Cell[7539, 245, 546, 20, 70, "Notes",
 CellID->15138]
}, Closed]],
Cell[CellGroupData[{
Cell[8122, 270, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14571462],
Cell[CellGroupData[{
Cell[8506, 284, 147, 5, 70, "ExampleSection",
 CellID->13451251],
Cell[8656, 291, 85, 1, 70, "ExampleText",
 CellID->48653107],
Cell[CellGroupData[{
Cell[8766, 296, 219, 7, 28, "Input",
 CellID->193137912],
Cell[8988, 305, 158, 5, 36, "Output",
 CellID->594524554]
}, Open  ]],
Cell[9161, 313, 122, 3, 70, "ExampleDelimiter",
 CellID->435737],
Cell[9286, 318, 81, 1, 70, "ExampleText",
 CellID->55068769],
Cell[9370, 321, 290, 10, 70, "Input",
 CellID->628940255],
Cell[CellGroupData[{
Cell[9685, 335, 174, 6, 70, "Input",
 CellID->15933473],
Cell[9862, 343, 157, 5, 36, "Output",
 CellID->63686635]
}, Open  ]],
Cell[10034, 351, 81, 1, 70, "ExampleText",
 CellID->587516266],
Cell[CellGroupData[{
Cell[10140, 356, 290, 10, 70, "Input",
 CellID->58453005],
Cell[10433, 368, 203, 7, 36, "Output",
 CellID->388287617]
}, Open  ]],
Cell[10651, 378, 125, 3, 70, "ExampleDelimiter",
 CellID->693810481],
Cell[10779, 383, 210, 8, 70, "ExampleText",
 CellID->226172305],
Cell[10992, 393, 290, 10, 70, "Input",
 CellID->602870109],
Cell[CellGroupData[{
Cell[11307, 407, 168, 5, 70, "Input",
 CellID->156520741],
Cell[11478, 414, 371, 13, 36, "Output",
 CellID->611697471]
}, Open  ]],
Cell[CellGroupData[{
Cell[11886, 432, 126, 4, 70, "Input",
 CellID->181586244],
Cell[12015, 438, 212, 7, 36, "Output",
 CellID->79246503]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12288, 452, 311, 9, 70, "SeeAlsoSection",
 CellID->27166],
Cell[12602, 463, 929, 35, 70, "SeeAlso",
 CellID->15548]
}, Open  ]],
Cell[CellGroupData[{
Cell[13568, 503, 314, 9, 70, "TutorialsSection",
 CellID->11800],
Cell[13885, 514, 179, 4, 70, "Tutorials",
 CellID->28803]
}, Open  ]],
Cell[CellGroupData[{
Cell[14101, 523, 305, 8, 70, "RelatedLinksSection"],
Cell[14409, 533, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14805, 550, 317, 9, 70, "MoreAboutSection",
 CellID->5865571],
Cell[15125, 561, 144, 3, 70, "MoreAbout",
 CellID->134851885],
Cell[15272, 566, 146, 3, 70, "MoreAbout",
 CellID->49258217],
Cell[15421, 571, 142, 3, 70, "MoreAbout",
 CellID->732308],
Cell[15566, 576, 150, 3, 70, "MoreAbout",
 CellID->305842016],
Cell[15719, 581, 144, 3, 70, "MoreAbout",
 CellID->708923370]
}, Open  ]],
Cell[15878, 587, 27, 0, 70, "History"],
Cell[15908, 589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

