(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    113817,       2385]
NotebookOptionsPosition[    108556,       2215]
NotebookOutlinePosition[    110174,       2256]
CellTagsIndexPosition[    110087,       2251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EdgeForm" :> 
          Documentation`HelpLookup["paclet:ref/EdgeForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EdgeForm\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Polygons" :> Documentation`HelpLookup["paclet:guide/Polygons"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Directives\"\>", 
       2->"\<\"Polygons\"\>", 
       3->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FaceForm", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FaceForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FaceForm"], "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that faces of \
polygons and other filled graphics objects are to be drawn using the graphics \
directive or list of directives ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FaceForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FaceForm"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["gback", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that the front faces of \
three\[Hyphen]dimensional polygons should be drawn with directives ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ", and the backs with directives ",
     Cell[BoxData[
      StyleBox["gback", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19227]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FaceForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceForm"], "[", "]"}]], "InlineFormula"],
 " draws no faces. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23292],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " works in both 2D and 3D. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29706],

Cell[TextData[{
 "Color, opacity and surface color directives can be used in ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19841],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " applies to ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Disk",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Disk"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Rectangle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rectangle"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5932],

Cell[TextData[{
 "In three dimensions, specifications given outside of ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " apply to both front and back faces of polygons. "
}], "Notes",
 CellID->11309],

Cell["\<\
The front face of a polygon is defined to be the one for which the corners as \
you specify them are in counterclockwise order (right\[Hyphen]hand rule). \
\>", "Notes",
 CellID->31379],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FaceForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceForm"], "[", 
   RowBox[{
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], ",", 
    StyleBox["gback", "TI"]}], "]"}]], "InlineFormula"],
 " specifies that front faces should not be drawn. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31955]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->312031899],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->683718520],

Cell["Specify the style of edges and faces:", "ExampleText",
 CellID->19169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}], ",", 
    RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], FaceForm[RGBColor[
   1, 0.5, 0.5]], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5590535]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}], ",", 
     RowBox[{"FaceForm", "[", 
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5415735],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], FaceForm[{RGBColor[
   1, 0.5, 0.5], Opacity[0.8]}], CuboidBox[{0, 0, 0}]},
  Boxed->False]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->788131601,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286535092],

Cell["Specify different properties for front and back of faces:", \
"ExampleText",
 CellID->261029909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", 
      RowBox[{"Yellow", ",", "Blue"}], "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400585771],

Cell[BoxData[
 Graphics3DBox[
  {FaceForm[RGBColor[1, 1, 0], RGBColor[0, 0, 1]], CuboidBox[{0, 0, 0}]},
  PlotRange->NCache[{{
      Rational[-1, 4], 
      Rational[5, 4]}, {
      Rational[1, 4], 
      Rational[5, 4]}, {
      Rational[-1, 4], 
      Rational[5, 4]}}, {{-0.25, 1.25}, {0.25, 1.25}, {-0.25, 
    1.25}}]]], "Output",
 ImageSize->{184, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222326089,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztm/tyGzUUxreO7cRx4tiJc7FzbZomDUmT3gil9xvphbbAAJ0yUKahZGiZ
dgql3Gcwr1KegVfgBXgfD+gcfWvL32rtTeyBf5pJNpZ19DtH0tGRdqW9s/Py
8e6znZdPHu0sXH+x883jJ4++W9h+/sJ81XcgCII/zd9fU4H5/I/5pH9/1uv1
IPjdXNO7u7vHNPWbuaZMKoX/9ttfzbXPpNKSkg/mv7kGm5r7M2T7vbk/oOwg
5W5o7kuUHZZU2uZagaOa/y1Kj8TkP0f5UUllGvnQsa4yT8Eot5H5GpxJx0r5
mKL0qkp/BWKFcvsofUSld8GeSST9BdhzlJum9IpKPwT7IOVmKL2s0g/APpRI
+lOwlyk3S+nDKn0f7COJpO+Bvd5BekmlPwR7g3L7Ka31Cj4A+3gi6btgn6Tc
AUovqvRtsLcSSd8E+zTl5iitvRdcB/ss5Q5SekGlr4F9PpH0FbCld1JBYCRM
BIDEGJXIU3peCRed/k0rof4qsJCEhPOODf2mYMoAyiQ5RGkdBcEZR3cOJd0a
lKjUMKVnlXLa0T9kyvYRpZiI8iZskfE3YsqmiTJCpQqU1igQnHRsKXkobAtT
ppVyzLGlbMpm9miLpWw4tkyYslmicCmmVpWy5thS2TdlFbYIZcaU7ScK9wm3
k0ZkjV+hLXOm7ABR2MvYf6aUsuTYsggK18Jf8qCjf8mjn8fHKKV1FtJRE+pf
MWVzROGR7qfMOLasmrKDROFYxGN5QilVx5b1BBQe1+NKmYQt0j+bpmyeKBxF
/ZRxx5bjpuwQUTjOj/uo2lqhLac8FLaFKdpO6n+hLVum7PAebbEUHgvieW8b
RoFoPDtO+DxAfTSFWf6cKTtiKFyb+JLuGk3mjgsguHbweoFXTaUmrWXNJr54
2VCKxOO1zRSli01eZP0mI/6qIZWIyaurNsw26z3pn+0EdF4Jao9GohXXU6Ru
GuYo0dmKZHTuFYly7xrmmNAzDTrajVejBS+TPU786G4sc5akh71MHhO2VQJd
TMiv8MvCTzf4RjgZm/2c2XfMZdxpbbFaZkEZL9qptmgMnaOc3iUFwQtXw+1Q
Q4v1YeRjvxny6tHI3hw5Upa0SL9OUD3K0MF95tfBc1CaNNwyl8lQA1qlCA3c
DlYDz6quRoGzBvH8KdXQSpIks/waGqNXyB4NNzwacnXnjrKjBpHqJ+p1l4oV
cBZUnoPjqQNE3W6xVZfW6pCS5Fkjnpoj6js+6m70zjUfSxwk4rWQmLZEC51O
zMt7eJMJeeyzwhsm3tWQl2nwUO9qYmaBmFd6wBwh5uUeMIvEvOTtm+S8EvEu
dskbJd6FRL4zGMsbI975/5HHq2+JjWXinZF7VZPohjlOTFllStJwa/vlSt0n
iXsC3EyX3CniboA70CW3Qtw3wM2H3Mg4YnYull0l9jLYhR6wp4m9CHZpj2ye
c8U3Zog9B3a5B+xZYlfBNn5Tq3Tsx3juHHEnwK12yZ0n7ii4s11yF4hbAHeh
C674xSJxB8E95OXyan0glnuIuFlwl7vkLhE3Be7qHri8Opf2PWy4slRe7wEH
9tXk92jI6zgGXjOTMDdiYwr3Ub+XKT60/B8xO/uR5fGdaPE1r+c88cWg74+/
NXC8kmeALWzzu3+2xJ6MoPssXNATEf4skbKJ+RIzc8QfT+SvVgffiZc8OiTe
D5OOchc6pB4rpEPmqhLpGOuxDplnx0nHaI91mDVgrUo6Sj3WYdYjtTnSUeyx
DnPfUTvoq0fbMZecb+4La4d9dWjh87jIJOabe+7aKvFHEvIznjHB/Jy5bBC/
0EO+WRPVThB/uGPciOfzmDbrmdoW8Yf2yW+0f7rJD2pniJ5P5KEdNAjPcAV9
lviy9yRFeM+UnwXEa5D14xWiZlxqW9+P5x403G3iCsruHFqmz1v0yXDkibz0
ptyh3DRE+XoopNgqR+yKp0w7lBTZN7hvqtxd3zA0qWE2jgp5XuvFU8uOrYNe
atB4BpycWnJsLXj8iZ/Bd6ZKf4+AKl+PEVX3WVueu7N/xnOHDPc6rJ30cHlP
hveT4sk5kOXrGSKLl3baqdL8iJS0cNYhLxBZ998jOzTeE0tedsppjyXPuG23
X8W7i/Fa3JhzFTU50kEbc/jpuF/bKGm7gLqtc+wgbdyjvCft1zZG2s6gbsdJ
G8fT/Wkr2/4KtlCnN0kLn5fhOMp7/n4tE1SnY6iTzkWZhjbEW75X450Rq8M/
qpo61qFDesuO7FABP6NgfsrLrxB/BS3mzkzyw0/y+JyHn14l+iFYv90T+jR6
eR4233J7uR49D8JnY/zUWbK5Apvfa9CtnO/ZZmf6HNHLsF3o+oSV5L378RHq
PFGLjs3iJOwLvPfppy6gfYdBuwsaRzO28YDS3N3jJbIvi1rfRa15tmP7osTD
REyRjfNE4J23KFHOvYhNd0BYohK8XxIlyPkSXcTYoax23QJtlUqz90Rp87An
g17YRlsd3TMpPPGUpza7CNv4XChHkiixUnf3jFujuhA7nQYNia1zltSW54kt
1JrPgArxgEkKKUoLzzJNoe1OwK6LROlvSynAplmyaQ20a0TLtqXlYdMi0VZQ
wxt7ovXDtmWiLcK220TLtKWlYdsa0WZB+4Bo6Sit9XSGSWyi7Stg3CNGX4Qh
iMapY4yfMlrnUyqdalufU460zC9F2PB5GxuaHi7aldCsk8nMg/GojSXRNcLx
Vg7aJItaPdaucXNFN1qj7j+13ef0kfzIx6etWhrW8LMLPi/eOA2E9HMnv2kJ
PxnkCPSDt9QA7GfpH/G9leLo9Qalf2pp3TzKstT3dTsarBTPHiuU/rbejKzN
04Es9QxSdseK1w48OzyBtD0nxesXfr/gS3ORbrfnAkfrzfOJrtRDMO2JU175
LlD6M0jbc8PhmVCWug8pe46czynyfffHkLan9/k+jGft91Er+7ZEBRaw1G0w
NdZEGKzjBqTtuzMzYLLUNUhp9Aj4TRG+H7oE6bdUOjxVzFLnIKUzT8Dvk/CK
6i3UXWcY+7ZDm/XsSbB1BlHvSIXe4EhtQkpnBqx4WmcnN70GaY38upoRJkut
QOp9leJ3U3iNs4hafaTS4Vl0lpoD8xOVWqNcnvurkH6g0vy+C8eaCUjvqPTR
evTNqrA3RMrG+03K5XvIcF5/otLHwGSpHOr+TKVOyDUSqcNZ+IXKuG/MSG4a
uRofdUbJmtQvmgoO/AuzRXse\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->237841905],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " to specify styling for polygons generated by plot functions:"
}], "ExampleText",
 CellID->75230683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", " ", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"ContourShading", "\[Rule]", 
    RowBox[{"FaceForm", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->757485853],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsnQWcVkX79/feJKVBShoEQUBSag6IpIS0gEiDtCgooJR0S4mk0iUdC6zM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   "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2978, 3193, 3124, 2668, 3340, 3341, 3288, 3289, 4012, 4013, 
         4014, 2596, 3660, 2955, 3955, 2956, 3555, 2709, 3084, 2682, 2796, 
         2947, 2806, 4030, 2694, 2807, 2742, 4037, 2743, 3049, 2800, 4026, 
         2685, 3086, 2686, 4027, 2801, 2949, 2811, 4033, 2697, 2812, 3755, 
         3756, 3345, 2746, 3397, 3292, 3293, 3661, 3562, 2961, 3561, 2962, 
         3563, 2960, 3565, 3566, 3564, 3957, 3956, 2669, 3185, 3343, 3342}],
        "7.5`"],
       Annotation[#, 7.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2610, 3113, 2605, 2642, 3305, 3304, 2756, 3401, 3671, 3670, 
         2873, 4085, 3879, 2753, 3775, 2752, 4046, 3502, 4047, 2870, 4082, 
         3543, 2923, 3918, 2924, 3919, 2922, 2959, 4050, 2958, 3027, 2775, 
         4039, 2776, 2703, 2963, 2866, 4045, 2867, 3117, 3116, 2598, 2640, 
         3065, 3030, 3346, 3347, 2700, 3189, 2701, 3081, 3082, 3044, 3080, 
         3079, 3954, 3913, 3914, 3912, 3916, 3915, 2920, 3996, 3006, 3995, 
         3005, 3493, 2860, 3391, 2738, 3771, 2737, 3770, 4081, 2855, 3855, 
         3653, 3281, 3280, 3279, 3387, 3386, 2587, 2631, 3123}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2845, 3121, 2628, 3633, 3632, 3221, 3474, 3473, 2726, 3768, 
         2727, 3379, 3486, 3485, 3104, 3229, 3228, 3227, 2854, 3062, 2635, 
         3652, 3651, 3853, 3854, 3650, 4009, 3649, 2735, 3769, 2736, 3390, 
         3492, 3491, 3107, 3659, 3658, 3657, 2863, 3063, 2638, 2595, 3108, 
         3109, 3046, 3064, 2639, 2597, 3395, 3396, 3290, 3291, 2641, 2600, 
         3125, 3126, 2980, 3570, 2979, 3571, 3128, 3876, 3877, 3501, 4076, 
         2750, 3774, 2751, 3573, 3574, 3572, 3668, 3669, 3136, 4061, 3137, 
         2885, 3514, 2884, 3515, 3111, 3884, 3885, 3518, 3779, 2759, 3780, 
         2760, 3585, 3586, 3241, 3242, 3243, 3146, 3256, 3255}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2907, 3265, 2908, 3158, 3157, 3259, 3258, 3257, 2993, 3590, 
         2889, 3527, 2897, 3251, 3691, 2616, 4017, 2609, 3680, 3679, 3582, 
         3584, 3583, 2758, 3777, 3778, 3517, 3516, 3883, 3138, 3510, 3511, 
         3509, 3513, 3512, 2872, 3966, 3967, 3965, 2981, 3135, 3921, 3922, 
         3920, 3924, 3923, 2655, 3358, 3359, 3357, 3427, 3426, 3602, 3999, 
         3014, 3601, 3015, 3603, 3013, 3017, 4057, 3016, 2654, 2783, 4042, 
         2784, 2774, 3789, 3791, 3790, 2602, 3115, 2599, 4015, 2865, 2678, 
         3432, 3433, 3430, 2782, 3431, 3606, 3025, 2689, 3188, 2690, 2792, 
         4044, 2791, 3355, 2710, 3354, 3356, 4065, 4067, 4066, 2675, 3807, 
         2676, 3748, 3747, 2788, 3806, 3074, 3075, 2786, 3435, 3439, 3438, 
         2673, 3207, 3208, 3078, 3076, 3077, 3206, 3205, 2672, 3436, 3437, 
         3434, 2785, 3073, 3072, 3805, 2787, 3745, 3746, 2674, 3953, 3541, 
         3424, 3425, 3324, 3325, 3326, 2789, 4043, 2790, 2688, 3187, 2687, 
         2957, 3716, 3715, 2781, 3798, 3799, 3429, 3428, 2677, 2862, 4010, 
         2593, 2637, 2780, 3796, 3797, 3788, 2773, 3803, 3804, 3800, 3802, 
         3801, 3106, 3597, 3598, 3596, 3600, 3599, 2976, 2977, 4011, 2594, 
         3423, 3350, 3351, 3349, 3353, 3352, 3894, 3861, 3862, 3655, 3656, 
         2592, 3105, 3849, 3850, 3848, 3852, 3851, 3061, 3846, 3847, 3647, 
         3648, 2590, 3103, 3484, 3377, 3378, 3767, 3766, 2725, 3629, 4008, 
         3630, 3472, 3631, 2584, 2627, 3833, 3834, 3470, 2844, 3471, 2723, 
         3460, 2834, 3219, 3622, 3623, 2622, 3054, 2833, 3217, 3621}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz3EYx/EfUtpsUyY7YEQrp9oFZhfE1CyJ+rtgthVrFGUHblzYweHC
mBJCysbI+UI7yJimbS2HUduEIobkdOd8SLy+F+//53k+z+f5fvv9f78pJeWx
smFRFI3ykxQfRYdGR9EYujshik7GRdFOmqCvpaPph8QoWsCfRqfioHwif5d5
E38/TdXvoyn0p0wu/7M6HfX8NHqAptvNMZ+PbIxIiqLhOIZCsyJskM3Tl9It
tCr0zhuy32d+H0dxmDeAXpl+OhE3ZZ/qO8LzyOwKZ/KbeTd48e7Mcc4VXja9
TOfThfx59JJ+Dr1I59I4/gm77eG5nPULv1GDQpkf9K3ZTlqL9+rt9JS9RjSg
h1fBK0cxvuMbvmKjWQ2qscx5r9z5kP8AyeojvG73/wm76mT1TNmxdAZdzstA
nnsWybeoH8s+QYpMKsZjtuw584/qVpkO+Ta6OLwTXhom4Lz+E71udkumneby
suxP5GdgEm7yX7jjJYawQnZ6+E/Vq9QxZMpl2/tC9+rr8M+8J7xv2cnObdDf
0TfS0+F/wyyzq7wL4f2H78reftSj1HydeWT3nlmbXLl+D7+MdvJaeOvVO3iv
9c/1b+hiZPK6wjcb3qP+D3Jx29nd/O3hOcJ/iyXBR6u6xKzKTnX4/njvwvuR
HYc+/SmZZzL9+kEM4Li+Se4M7pqfpRdwHllma3gVdlfTSroxfPsoNSvkFaEA
W83W0jyzOnpR/zd8qzSftxSb3bcJzeqV/F7zfDqSdzU8A78N1xBDJb8CneoC
80H5GH1Ei2kXf5v5f92qkrs=
         "]],
        RowBox[{"-", "2.5`"}]],
       Annotation[#, -2.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0ltMj2EcwPG3YauEzSGJjYYLQi7ElWHkfKpIzlttuCpi5cxmI8xpszlT
0cFh3HBpM6coNqzmXDGKC1MX2Jw/z8X3//2dnud53+f9p+QVZhXERFGU4Ce+
axTt6BZFXblXQhT1xCEcxAHEqm/W/8LbOY638DZsRZKZvvFRNEqchhEol48M
cfcoOhr61vwQ71V7IC/TTxUnqpfyHtSqD+dh2I1JZjr029BXLxGjUWKfYtwX
v9NLFt/gCz2i6BWf55dcyW+4n34S7pl/HfYSX+cK/UYu5wZO05/ozHZxH3wz
15u/c4yZCMn6GZynPoXzOd+6PCzR+2t2kNofHsgZamPF6RiDFLV/XKPexfqh
8s48hGeoDcB4/fHe/6q4wb6NKJdX4Fy4H7Nl/JarrG3iaj4Zvguf4o28GZuw
Fc1qr7mFT+MsGuVneL9zPopb8QHr7b0WRViHDXhu7pXeCz6GE2iQH+eD1n8S
f0YbOsx/RYm4GO3iGlzEVEzHNAzWS7f+kvgKLuOmvT54349oRaa7SA13Eu5X
vBi5qLJup/UTeBdX81L1ZViOyearUIn+8qnhW4hjnJFvvxXilShV38e/wzcL
7xXeCbHWxOG9+YXyAr0cLuRfar/xE6vNrArf1p7N+rPUmng2z8RczEG6/nzO
xDxkIwtj1R9Y/xC1qEcdxqkv1M/BAtTJF/GacAdcL8/lR3wnnOO5boezeAk/
Vv/ive6KWzxPtvyeeIbaYfkRdLLXtfD/4/n8TD+Xn/Aifhqe0/yCcPfyW1xk
9j9JiJOT
         "]],
        RowBox[{"-", "5"}]],
       Annotation[#, -5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1NdL11EYx/Fv0IBsWNRFXUTaoAFtqNR2UBfZor23qa2rrLShZZZku9S0
yyaYVtCAougPKMsIWrR3aanRHq9z8fZ9nuf5nPM9v6/+jFu0evKqBlEUjfSj
bdMoatUsitpwl+ZR1BWdUKruzPcwsmUUjUKtXB1mmj3Rn8F/Y6LoDk62iKJT
OI2dMlvN3si8xUu8xivMMptutlluE0Y4dzj26x3iw2GNgziAmfLTzDbKZmGY
3lDs0zunPo9ynEUFnmKqWSZvwBmUIT+c755V4Rmc4dy12Kt/IzxP74/1F73P
mOOulepYzuA1Mvkyq3knz5CZx0PUCzmJF3Av/ST5eM+MQ0c00W8b3jF6qnug
O2pQHWxex/X4jFp8QXv5ds7qb90Pv/ELdfJH3KsEhShGETrIF6MIhYiXq8dY
ZyTal4AkuTL1HfMqtHLv1ohFN9kxnMJbZLORgy3qSv1svmvvXGdU8Tyu5Tpc
Md/GX5GLq+p6zrHnA19Ur+cYz1zHF9Tv+R2+45o6j39iB66rf/A2+2v4sjqL
m9ufyZfU1fwJ1dY1+IT76kp3fsB59t7W2855etuRi1R1sv4A7sjxiMMVe545
/zleYILsRAy2TkCifLnPnMAVPFQv274cfFP/wHcMN++n1x+90Rd9MFo+N9wn
vCvsCJ8ZY+R38x7sQpm6gMfJJ+NMeC5X4CzGh/uE9y+zzmxueLc8nzM41Xy3
exeE74B6gf55fuhumdyQ95jtRZrsAd6PfVgU/p7D70ZuMS8J3w39Q1jqmeny
y7hQfRjLzJfig3wKL0eRfjFS5FbIL+cS9ZHwPPNUfJRP5xUo1T8afi9yK+XT
uLE7NsJjPEIT80yzE3wcx1DpjH/hHPlVzhmEwRiIRCRgmvls+2/J1Nh/03q9
vVPUt6wnhf9H+A8Sybrm
         "]],
        RowBox[{"-", "7.5`"}]],
       Annotation[#, -7.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2821, 3449, 2822, 3088, 3087, 2579, 3615, 3362, 2715, 3361, 
         2714, 3814, 3815, 3811, 3813, 3812, 2619, 3614, 3613, 3612, 2820, 
         3816, 2719, 3821, 2835, 3818, 3820, 3819, 2623, 2582, 3624, 3376, 
         2724, 3273, 3274, 3477, 3478, 3475, 2846, 3476, 3100, 3101, 2851, 
         3226, 3644}],
        RowBox[{"-", "10"}]],
       Annotation[#, -10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2877, 3508, 2878, 3132, 3131, 3880, 2876, 3505, 3507, 3506, 
         2757, 3306, 3307, 3308, 3678, 2606, 3114, 2611, 3682, 3681, 2987, 
         3978, 2890, 3979, 2988, 3683, 3684, 3685, 3147, 2617, 3693, 3692, 
         3893, 3892, 2766, 3310, 3530, 3531, 3533, 3532, 3151, 3152, 2901, 
         3262, 3695}],
        RowBox[{"-", "10"}]],
       Annotation[#, -10, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2607, 3112, 3886, 3519, 3520, 3782, 3781, 2761, 3521, 2891, 
         3244, 3245, 3246, 2931, 3545, 3544, 3260, 2899, 3528, 2892, 3529, 
         2900, 3261, 3694}],
        RowBox[{"-", "12.5`"}]],
       Annotation[#, -12.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2818, 3447, 2819, 3448, 2713, 3445, 2815, 3809, 2814, 4080, 
         3700, 3701, 3268, 3267, 3212, 2816, 3446, 2718, 3764, 3765, 3368, 
         3367, 3461, 3097, 3122}],
        RowBox[{"-", "12.5`"}]],
       Annotation[#, -12.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2994, 3194, 3021, 3023, 3022, 3186, 2932, 3175, 3009, 3546, 
         2934, 3330, 3331, 3176, 2933, 3998, 3011, 3997, 3010}],
        RowBox[{"-", "15"}]],
       Annotation[#, -15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3335, 3336, 3182, 3339, 3338, 3337, 2940, 3550, 2998, 3168, 
         2911, 3169, 3000, 2999, 2817, 3810, 4055, 2975, 4084, 4054}],
        RowBox[{"-", "15"}]],
       Annotation[#, -15, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202467676]
}, Open  ]],

Cell["Color the inside and outside differently: ", "ExampleText",
 CellID->55848482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Phi]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Phi]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"3", 
      RowBox[{"Pi", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".2", "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"FaceForm", "[", 
     RowBox[{"Blue", ",", "Orange"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->433891042],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290588178]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->162343844],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FaceForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceForm"], "[", "]"}]], "InlineFormula"],
 " is used to specify that the front faces should not be drawn: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->31955]
}], "ExampleText",
 CellID->175591759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Red", "]"}], ",", "White", ",", 
      RowBox[{"Rectangle", "[", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Red", "]"}], ",", 
      RowBox[{"FaceForm", "[", "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243619351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {GrayLevel[1], EdgeForm[RGBColor[1, 0, 0]], RectangleBox[{0, 0}], 
     RectangleBox[{0.5, 0.5}]}], ",", 
   GraphicsBox[
    {EdgeForm[RGBColor[1, 0, 0]], FaceForm[None], RectangleBox[{0, 0}], 
     RectangleBox[{0.5, 0.5}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->14293433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257687347],

Cell[TextData[{
 "You can use a different style for front and back faces, including ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->37709688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Phi]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Phi]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"3", 
      RowBox[{"Pi", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.1", "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"FaceForm", "[", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Blue"}], "]"}], ",", 
      "Orange"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74264606],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18034962]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23927],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11435],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FaceForm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FaceForm"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->407395702],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->207789844],

Cell[TextData[ButtonBox["Polygons",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Polygons"]], "MoreAbout",
 CellID->566419214],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->3912829]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FaceForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 7.4983492}", "context" -> "System`", 
    "keywords" -> {
     "filling of cuboid", "filling of cylinder", "filling of disks", 
      "filling of polygons", "filling of sphere", "filling of rectangle"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FaceForm[g] is a graphics directive which specifies that faces of \
polygons and other filled graphics objects are to be drawn using the graphics \
directive or list of directives g. FaceForm[g, gback] specifies that the \
front faces of three-dimensional polygons should be drawn with directives g, \
and the backs with directives gback. ", "synonyms" -> {"face form"}, "title" -> 
    "FaceForm", "type" -> "Symbol", "uri" -> "ref/FaceForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11429, 326, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->312031899]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 109943, 2244}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2143, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2766, 81, 4192, 83, 70, "ObjectNameGrid"],
Cell[6961, 166, 1291, 38, 70, "Usage",
 CellID->19227]
}, Open  ]],
Cell[CellGroupData[{
Cell[8289, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8767, 226, 340, 11, 70, "Notes",
 CellID->23292],
Cell[9110, 239, 323, 10, 70, "Notes",
 CellID->29706],
Cell[9436, 251, 233, 8, 70, "Notes",
 CellID->19841],
Cell[9672, 261, 689, 25, 70, "Notes",
 CellID->5932],
Cell[10364, 288, 274, 8, 70, "Notes",
 CellID->11309],
Cell[10641, 298, 195, 4, 70, "Notes",
 CellID->31379],
Cell[10839, 304, 553, 17, 70, "Notes",
 CellID->31955]
}, Closed]],
Cell[CellGroupData[{
Cell[11429, 326, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->312031899],
Cell[CellGroupData[{
Cell[11814, 340, 148, 5, 70, "ExampleSection",
 CellID->683718520],
Cell[11965, 347, 76, 1, 70, "ExampleText",
 CellID->19169],
Cell[CellGroupData[{
Cell[12066, 352, 319, 10, 28, "Input",
 CellID->41],
Cell[12388, 364, 328, 9, 171, "Output",
 CellID->5590535]
}, Open  ]],
Cell[CellGroupData[{
Cell[12753, 378, 493, 15, 70, "Input",
 CellID->5415735],
Cell[13249, 395, 2650, 49, 184, 185, 4, "CachedBoxData", "BoxData", "Output",
 CellID->788131601]
}, Open  ]],
Cell[15914, 447, 125, 3, 70, "ExampleDelimiter",
 CellID->286535092],
Cell[16042, 452, 102, 2, 70, "ExampleText",
 CellID->261029909],
Cell[CellGroupData[{
Cell[16169, 458, 770, 26, 70, "Input",
 CellID->400585771],
Cell[16942, 486, 3783, 71, 218, 335, 10, "CachedBoxData", "BoxData", "Output",
 
 CellID->222326089]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20774, 563, 227, 7, 70, "ExampleSection",
 CellID->237841905],
Cell[21004, 572, 246, 8, 70, "ExampleText",
 CellID->75230683],
Cell[CellGroupData[{
Cell[21275, 584, 464, 15, 70, "Input",
 CellID->757485853],
Cell[21742, 601, 42238, 725, 70, "Output",
 CellID->202467676]
}, Open  ]],
Cell[63995, 1329, 84, 1, 70, "ExampleText",
 CellID->55848482],
Cell[CellGroupData[{
Cell[64104, 1334, 830, 24, 70, "Input",
 CellID->433891042],
Cell[64937, 1360, 18834, 313, 70, "Output",
 Evaluatable->False,
 CellID->290588178]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83820, 1679, 237, 7, 70, "ExampleSection",
 CellID->162343844],
Cell[84060, 1688, 348, 11, 70, "ExampleText",
 CellID->175591759],
Cell[CellGroupData[{
Cell[84433, 1703, 751, 23, 70, "Input",
 CellID->243619351],
Cell[85187, 1728, 490, 14, 123, "Output",
 CellID->14293433]
}, Open  ]],
Cell[85692, 1745, 125, 3, 70, "ExampleDelimiter",
 CellID->257687347],
Cell[85820, 1750, 367, 13, 70, "ExampleText",
 CellID->37709688],
Cell[CellGroupData[{
Cell[86212, 1767, 947, 28, 70, "Input",
 CellID->74264606],
Cell[87162, 1797, 18634, 310, 70, "Output",
 Evaluatable->False,
 CellID->18034962]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[105857, 2114, 311, 9, 70, "SeeAlsoSection",
 CellID->23927],
Cell[106171, 2125, 196, 6, 70, "SeeAlso",
 CellID->15765]
}, Open  ]],
Cell[CellGroupData[{
Cell[106404, 2136, 314, 9, 70, "TutorialsSection",
 CellID->11435],
Cell[106721, 2147, 197, 4, 70, "Tutorials",
 CellID->815154705]
}, Open  ]],
Cell[CellGroupData[{
Cell[106955, 2156, 305, 8, 70, "RelatedLinksSection"],
Cell[107263, 2166, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107661, 2183, 319, 9, 70, "MoreAboutSection",
 CellID->407395702],
Cell[107983, 2194, 149, 3, 70, "MoreAbout",
 CellID->207789844],
Cell[108135, 2199, 128, 3, 70, "MoreAbout",
 CellID->566419214],
Cell[108266, 2204, 195, 4, 70, "MoreAbout",
 CellID->3912829]
}, Open  ]],
Cell[108476, 2211, 50, 0, 70, "History"],
Cell[108529, 2213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

