(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61890,       2186]
NotebookOptionsPosition[     51476,       1822]
NotebookOutlinePosition[     53163,       1865]
CellTagsIndexPosition[     53077,       1860]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transforming Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformingAlgebraicExpressions"], 
          "Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Structural Operations on Rational Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnRationalExpressions"], 
          "Structural Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnPolynomials"], 
          "Polynomials Modulo Primes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PolynomialsModuloPrimes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Transforming Algebraic Expressions\"\>", 
       2->"\<\"Putting Expressions into Different Forms\"\>", 
       3->"\<\"Structural Operations on Rational Expressions\"\>", 
       4->"\<\"Structural Operations on Polynomials\"\>", 
       5->"\<\"Polynomials Modulo Primes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorList" :> 
          Documentation`HelpLookup["paclet:ref/FactorList"], "FactorTerms" :> 
          Documentation`HelpLookup["paclet:ref/FactorTerms"], 
          "FactorSquareFree" :> 
          Documentation`HelpLookup["paclet:ref/FactorSquareFree"], 
          "SquareFreeQ" :> Documentation`HelpLookup["paclet:ref/SquareFreeQ"],
           "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], "Expand" :> 
          Documentation`HelpLookup["paclet:ref/Expand"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "TrigFactor" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactor"], "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FactorList\"\>", 
       2->"\<\"FactorTerms\"\>", 3->"\<\"FactorSquareFree\"\>", 
       4->"\<\"SquareFreeQ\"\>", 5->"\<\"Solve\"\>", 6->"\<\"Expand\"\>", 
       7->"\<\"Simplify\"\>", 8->"\<\"FactorInteger\"\>", 
       9->"\<\"TrigFactor\"\>", 
       10->"\<\"FullSimplify\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60AlgebraicComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Formula Manipulation\"\>", 3->"\<\"Polynomial Algebra\"\>", 
       4->"\<\"Polynomial Factoring & Decomposition\"\>", 
       5->"\<\"Precollege Education\"\>", 6->"\<\"Rational Functions\"\>", 
       7->"\<\"New in 6.0: Symbolic Computation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Factor", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Factor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Factor"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]factors a polynomial over the integers. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Factor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Factor"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        RowBox[{
         ButtonBox["Modulus",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Modulus"], "->", 
         StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]factors a polynomial modulo a prime ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Factor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Factor"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        RowBox[{
         ButtonBox["Extension",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Extension"], "->", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]factors a polynomial allowing coefficients that are \
rational combinations of the algebraic numbers ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->741]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " applies only to the top algebraic level in an expression. You may have to \
use ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ", or apply ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " again, to reach other levels. "
}], "Notes",
 CellID->29781],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    RowBox[{
     ButtonBox["GaussianIntegers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GaussianIntegers"], "->", "True"}]}], "]"}]], 
  "InlineFormula"],
 " factors allowing Gaussian integer coefficients. "
}], "Notes",
 CellID->461],

Cell[TextData[{
 "If any coefficients in ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " are complex numbers, factoring is done allowing Gaussian integer \
coefficients. "
}], "Notes",
 CellID->766],

Cell[TextData[{
 "The exponents of variables need not be positive integers. ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " can deal with exponents that are linear combinations of symbolic \
expressions. "
}], "Notes",
 CellID->21962],

Cell[TextData[{
 "When given a rational expression, ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " effectively first calls ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 ", then factors numerator and denominator. "
}], "Notes",
 CellID->8378],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", "None"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"], "[", 
   StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
 " will treat algebraic number coefficients in ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " like independent variables. "
}], "Notes",
 CellID->25249],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", "Automatic"}]}], "]"}]], 
  "InlineFormula"],
 " will extend the domain of coefficients to include any algebraic numbers \
that appear in ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27925,
  ButtonNote->"27925"]
}], "Notes",
 CellID->11961],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3311679],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->477350876],

Cell["Factor polynomials:", "ExampleText",
 CellID->82685710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}], "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17667],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43038172]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "10"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->959],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output",
 ImageSize->{334, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3645048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "10"}], "-", 
   RowBox[{"y", "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25968],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "-", "y"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"x", "+", "y"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "4"], "-", 
    RowBox[{
     SuperscriptBox["x", "3"], " ", "y"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"x", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    SuperscriptBox["y", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "4"], "+", 
    RowBox[{
     SuperscriptBox["x", "3"], " ", "y"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"x", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    SuperscriptBox["y", "4"]}], ")"}]}]], "Output",
 ImageSize->{420, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->294627278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31030],

Cell["Factor modulo 2:", "ExampleText",
 CellID->11991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "10"}], "-", "1"}], ",", 
   RowBox[{"Modulus", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30298],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"], "+", 
     SuperscriptBox["x", "4"]}], ")"}], "2"]}]], "Output",
 ImageSize->{175, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403817355]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11535],

Cell["A univariate polynomial:", "ExampleText",
 CellID->242436578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"6", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"11", "x"}], "-", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6972226],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311288625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606606440],

Cell["A multivariate polynomial:", "ExampleText",
 CellID->242121446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"x", "^", "3"}], " ", "y"}], "-", 
   RowBox[{"2", 
    RowBox[{"a", "^", "2"}], "x", " ", "y"}], "-", 
   RowBox[{"3", 
    RowBox[{"a", "^", "2"}], 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"3", 
    RowBox[{"a", "^", "4"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->685335161],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "-", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"]}], "-", 
    RowBox[{"2", " ", "x", " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{168, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197145494]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137525866],

Cell["A rational function:", "ExampleText",
 CellID->250609994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"2", 
       RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->582901814],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"2", " ", "y"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "y"}]}], ")"}]}]]], "Output",
 ImageSize->{144, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290904731]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9565],

Cell["Some non-polynomial expressions can be factored: ", "ExampleText",
 CellID->31455328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"2", "s"}], ")"}]}], "+", 
   RowBox[{"2", 
    RowBox[{"x", "^", "s"}]}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20735],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "s"]}], ")"}], "2"]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625804650]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "/", "3"}], "s"}], ")"}]}], "+", 
   RowBox[{"2", 
    RowBox[{"x", "^", "s"}]}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->169756312],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", 
     RowBox[{"s", "/", "3"}]]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SuperscriptBox["x", 
     RowBox[{"s", "/", "3"}]], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"2", " ", "s"}], "/", "3"}]]}]}], ")"}]}]], "Output",
 ImageSize->{172, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->466952138]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"2", "s"}], "]"}], "+", 
   RowBox[{"2", 
    RowBox[{"Exp", "[", "s", "]"}]}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->855788669],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["\[ExponentialE]", "s"]}], ")"}], "2"]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->233074348]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28543],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Extension",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26223],

Cell["Factor over algebraic number fields:", "ExampleText",
 CellID->8503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", " ", 
   RowBox[{"Extension", " ", "->", " ", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7976],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      SqrtBox["2"], " ", "x"}], "-", 
     SuperscriptBox["x", "2"]}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     SqrtBox["2"], " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{208, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61445814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], ",", "I"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->19102],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], 
   ")"}]}]], "Output",
 ImageSize->{436, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66232981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1472],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " automatically extends to a field that covers the coefficients:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"2", "+", 
   RowBox[{"2", 
    RowBox[{"Sqrt", "[", "2", "]"}], "x"}], "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20089],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"2", " ", 
   SqrtBox["2"], " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{93, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5303012]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "2", "]"}], "x"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"Extension", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6669],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{67, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->885966697]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GaussianIntegers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->160439818],

Cell["Factor over Gaussian integers:", "ExampleText",
 CellID->520967426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", " ", "+", " ", 
    RowBox[{"x", "^", "2"}]}], ",", " ", 
   RowBox[{"GaussianIntegers", " ", "->", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32901353],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73780853]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", " ", "+", " ", 
    RowBox[{"x", "^", "2"}]}], ",", " ", 
   RowBox[{"Extension", " ", "->", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->544366111],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->440352437]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->435291713],

Cell["Factor over finite fields:", "ExampleText",
 CellID->225502292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"5", "+", 
   RowBox[{"x", "^", "12"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151353667],

Cell[BoxData[
 RowBox[{"5", "+", 
  SuperscriptBox["x", "12"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12280837]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"5", "+", 
    RowBox[{"x", "^", "12"}]}], ",", 
   RowBox[{"Modulus", "->", "7"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49860741],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    SuperscriptBox["x", "3"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", 
    SuperscriptBox["x", "3"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    SuperscriptBox["x", "6"]}], ")"}]}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34204440]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18082488],

Cell["Factor a trigonometric expression:", "ExampleText",
 CellID->47505639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51431388],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["x", "2"], "-", 
    FractionBox["y", "2"]}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["x", "2"], "+", 
    FractionBox["y", "2"]}], "]"}]}]], "Output",
 ImageSize->{157, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191312290]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29979],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "50"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11536],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["x", "10"], "-", 
    SuperscriptBox["x", "15"], "+", 
    SuperscriptBox["x", "20"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["x", "10"], "+", 
    SuperscriptBox["x", "15"], "+", 
    SuperscriptBox["x", "20"]}], ")"}]}]], "Output",
 ImageSize->{406, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165730245]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Factor", "[", 
   RowBox[{
    RowBox[{"x", "^", "50"}], "-", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28714],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "50"]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140655131]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80768718],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorList"]], "InlineFormula"],
 " gives a list of factors:"
}], "ExampleText",
 CellID->289317600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"x", "^", "8"}], "+", 
   RowBox[{"11", 
    RowBox[{"x", "^", "7"}]}], "+", 
   RowBox[{"43", 
    RowBox[{"x", "^", "6"}]}], "+", 
   RowBox[{"59", 
    RowBox[{"x", "^", "5"}]}], "-", 
   RowBox[{"35", 
    RowBox[{"x", "^", "4"}]}], "-", 
   RowBox[{"151", 
    RowBox[{"x", "^", "3"}]}], "-", 
   RowBox[{"63", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"81", "x"}], "+", "54"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271634407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93026919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291191028],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorSquareFree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFormula"],
 " only pulls out multiple factors:"
}], "ExampleText",
 CellID->57323525],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "9"}], "+", 
    RowBox[{"9", 
     RowBox[{"x", "^", "8"}]}], "+", 
    RowBox[{"21", 
     RowBox[{"x", "^", "7"}]}], "-", 
    RowBox[{"27", 
     RowBox[{"x", "^", "6"}]}], "-", 
    RowBox[{"153", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"81", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"239", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"207", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"108", "x"}], "-", "108"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42129648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->851500563],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "3"]}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->173280057]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFree", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->848171248],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "Output",
 ImageSize->{170, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->103343392]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30208],

Cell[TextData[{
 "The first factoring of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "n"], "-", "1"}], TraditionalForm]], "InlineMath"],
 " where a ",
 Cell[BoxData["2"], "InlineFormula"],
 " appears as a coefficient:"
}], "ExampleText",
 CellID->23891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "105"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16326],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{508, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96810472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"x", "^", "n"}], "-", "1"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "200"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26214],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxtlktOFUEUhiuOHDpw4MBBe2OMMcb4fivlA5+ICCIqAi2C4Mgt1FLuUmro
MnoJLkGN5zM5X7wJOXz3r/88qqv79qnd76v7R0opP37//Yl/Pz8X4p/6/3hU
fEzfH5d+QutOSh+kz5TvtPQz8p9VnXPSz8t/QXxRfV+S/7LyX5F+Vfo15b8u
viH/zYjsw62IzH9b/jviu6p/T/nvK/+C9Jr9DSb/g8xNXB5GnIUOk/+R/OLy
OPfXYPyL0helP1H/4vJU9WH8zyLGOWsw+/9c+WH6fyEdJv9L9Q/jX5K+JP2V
+ofJvxwx7oO2LP21/DD7sxIx7su6ovVw9Ndh8r/J+SqMH8YP41/N/dfVrDc4
8nWY/tdUfy2vbzD1Yeq/jRjXv8LxPGgw9WH86+p/Pa9v4i4u73J/FWZ+OPJ3
GP9GRObfyHoTd3F5r/5h6sORv4vLh4iz8MP4YfZfevmY9SpuMP3D+DfV/2bW
G0x9mPk/ReT6w/hh/DD+rYjsv7ht5fVdXLYjxu9QheP507bz+i4uO6q/k/UG
c35g9m+MGPMNcPir9BFmf+DIP5e/iyflK59VH478VfoovcHUh6kvnsRlN2K8
Fwy7Wa/iEeb6iudw9Nfh6G+SXr5EZH6Y6yl9hLm+MPPD1Nf6SVz2sn/Yy3qF
4/4YYfYfZn6Y+0X5JvnLfsQ4/wMc57/CzA+z/+I5zPzyT1pfvkaM+QaY+cUj
zPxwvCfOpXeY+spXDrI+HGS9Sh+lN5j5tb6LJ5j9P4wY78nDYdYrzPwwz2d4
FvXl7zDnX3r59k//Bea89hA=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 2.},
  PlotRange->{{0., 200.}, {2., 18.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258368670]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14404],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorTerms",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorTerms"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorSquareFree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorSquareFree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SquareFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquareFreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2802]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26421],

Cell[TextData[ButtonBox["Transforming Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TransformingAlgebraicExpressions"]], "Tutorials",\

 CellID->12518],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->24085],

Cell[TextData[ButtonBox["Structural Operations on Rational Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnRationalExpressions"]], "Tutorials",
 CellID->77317866],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "Tutorials",
 CellID->19637],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "Tutorials",
 CellID->180770870]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->8059],

Cell[TextData[{
 ButtonBox["Demonstrations with Factor",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Factor"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#30145"], None}]], "RelatedLinks",
 CellID->1962],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Factor"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1021092414],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->102358574],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->53363810],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->393299465],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->144833627],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->880274266],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->195490743],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->515362443]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Factor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 17.5298560}", "context" -> "System`", 
    "keywords" -> {
     "Cantor-Zassenhaus algorithm", "factoring", 
      "factoring over extension fields", "Hensel lifting", "irreducibility", 
      "modular factorization", "polynomial factorization", "prime elements", 
      "Trager's algorithm", "UFD", "unique factorization domain", 
      "Wang's algorithm"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Factor[poly] factors a polynomial over the integers. Factor[poly, \
Modulus -> p] factors a polynomial modulo a prime p. Factor[poly, Extension \
-> {a_1, a_2, ...}] factors a polynomial allowing coefficients that are \
rational combinations of the algebraic numbers a_i. ", "synonyms" -> {}, 
    "title" -> "Factor", "type" -> "Symbol", "uri" -> "ref/Factor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15386, 423, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3311679]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52935, 1853}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4594, 92, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5217, 119, 4190, 83, 70, "ObjectNameGrid"],
Cell[9410, 204, 1975, 63, 70, "Usage",
 CellID->741]
}, Open  ]],
Cell[CellGroupData[{
Cell[11422, 272, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11900, 289, 520, 18, 70, "Notes",
 CellID->29781],
Cell[12423, 309, 427, 15, 70, "Notes",
 CellID->461],
Cell[12853, 326, 216, 7, 70, "Notes",
 CellID->766],
Cell[13072, 335, 307, 9, 70, "Notes",
 CellID->21962],
Cell[13382, 346, 392, 13, 70, "Notes",
 CellID->8378],
Cell[13777, 361, 544, 19, 70, "Notes",
 CellID->25249],
Cell[14324, 382, 634, 23, 70, "Notes",
 CellID->11961],
Cell[14961, 407, 388, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[15386, 423, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3311679],
Cell[CellGroupData[{
Cell[15769, 437, 148, 5, 70, "ExampleSection",
 CellID->477350876],
Cell[15920, 444, 61, 1, 70, "ExampleText",
 CellID->82685710],
Cell[CellGroupData[{
Cell[16006, 449, 174, 6, 28, "Input",
 CellID->17667],
Cell[16183, 457, 227, 8, 36, "Output",
 CellID->43038172]
}, Open  ]],
Cell[CellGroupData[{
Cell[16447, 470, 144, 5, 28, "Input",
 CellID->959],
Cell[16594, 477, 623, 21, 39, "Output",
 CellID->3645048]
}, Open  ]],
Cell[CellGroupData[{
Cell[17254, 503, 171, 6, 28, "Input",
 CellID->25968],
Cell[17428, 511, 919, 32, 39, "Output",
 CellID->294627278]
}, Open  ]],
Cell[18362, 546, 121, 3, 70, "ExampleDelimiter",
 CellID->31030],
Cell[18486, 551, 55, 1, 70, "ExampleText",
 CellID->11991],
Cell[CellGroupData[{
Cell[18566, 556, 202, 7, 70, "Input",
 CellID->30298],
Cell[18771, 565, 438, 15, 41, "Output",
 CellID->403817355]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19258, 586, 216, 7, 70, "ExampleSection",
 CellID->11535],
Cell[19477, 595, 67, 1, 70, "ExampleText",
 CellID->242436578],
Cell[CellGroupData[{
Cell[19569, 600, 231, 8, 70, "Input",
 CellID->6972226],
Cell[19803, 610, 392, 15, 36, "Output",
 CellID->311288625]
}, Open  ]],
Cell[20210, 628, 125, 3, 70, "ExampleDelimiter",
 CellID->606606440],
Cell[20338, 633, 69, 1, 70, "ExampleText",
 CellID->242121446],
Cell[CellGroupData[{
Cell[20432, 638, 376, 13, 70, "Input",
 CellID->685335161],
Cell[20811, 653, 419, 15, 39, "Output",
 CellID->197145494]
}, Open  ]],
Cell[21245, 671, 125, 3, 70, "ExampleDelimiter",
 CellID->137525866],
Cell[21373, 676, 63, 1, 70, "ExampleText",
 CellID->250609994],
Cell[CellGroupData[{
Cell[21461, 681, 608, 23, 70, "Input",
 CellID->582901814],
Cell[22072, 706, 553, 21, 53, "Output",
 CellID->290904731]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22674, 733, 238, 7, 70, "ExampleSection",
 CellID->9565],
Cell[22915, 742, 91, 1, 70, "ExampleText",
 CellID->31455328],
Cell[CellGroupData[{
Cell[23031, 747, 245, 9, 70, "Input",
 CellID->20735],
Cell[23279, 758, 254, 9, 36, "Output",
 CellID->625804650]
}, Open  ]],
Cell[CellGroupData[{
Cell[23570, 772, 276, 10, 70, "Input",
 CellID->169756312],
Cell[23849, 784, 496, 18, 39, "Output",
 CellID->466952138]
}, Open  ]],
Cell[CellGroupData[{
Cell[24382, 807, 237, 8, 70, "Input",
 CellID->855788669],
Cell[24622, 817, 268, 9, 36, "Output",
 CellID->233074348]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24939, 832, 218, 7, 70, "ExampleSection",
 CellID->28543],
Cell[CellGroupData[{
Cell[25182, 843, 226, 7, 70, "ExampleSubsection",
 CellID->26223],
Cell[25411, 852, 74, 1, 70, "ExampleText",
 CellID->8503],
Cell[CellGroupData[{
Cell[25510, 857, 250, 8, 70, "Input",
 CellID->7976],
Cell[25763, 867, 470, 18, 43, "Output",
 CellID->61445814]
}, Open  ]],
Cell[CellGroupData[{
Cell[26270, 890, 291, 11, 70, "Input",
 CellID->19102],
Cell[26564, 903, 839, 32, 51, "Output",
 CellID->66232981]
}, Open  ]],
Cell[27418, 938, 120, 3, 70, "ExampleDelimiter",
 CellID->1472],
Cell[27541, 943, 399, 12, 70, "ExampleText",
 CellID->27925],
Cell[CellGroupData[{
Cell[27965, 959, 212, 7, 70, "Input",
 CellID->20089],
Cell[28180, 968, 258, 9, 38, "Output",
 CellID->5303012]
}, Open  ]],
Cell[CellGroupData[{
Cell[28475, 982, 279, 9, 70, "Input",
 CellID->6669],
Cell[28757, 993, 242, 9, 44, "Output",
 CellID->885966697]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29048, 1008, 237, 7, 70, "ExampleSubsection",
 CellID->160439818],
Cell[29288, 1017, 73, 1, 70, "ExampleText",
 CellID->520967426],
Cell[CellGroupData[{
Cell[29386, 1022, 241, 7, 70, "Input",
 CellID->32901353],
Cell[29630, 1031, 317, 11, 36, "Output",
 CellID->73780853]
}, Open  ]],
Cell[CellGroupData[{
Cell[29984, 1047, 227, 7, 70, "Input",
 CellID->544366111],
Cell[30214, 1056, 318, 11, 36, "Output",
 CellID->440352437]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30581, 1073, 228, 7, 70, "ExampleSubsection",
 CellID->435291713],
Cell[30812, 1082, 69, 1, 70, "ExampleText",
 CellID->225502292],
Cell[CellGroupData[{
Cell[30906, 1087, 150, 5, 70, "Input",
 CellID->151353667],
Cell[31059, 1094, 204, 7, 36, "Output",
 CellID->12280837]
}, Open  ]],
Cell[CellGroupData[{
Cell[31300, 1106, 205, 7, 70, "Input",
 CellID->49860741],
Cell[31508, 1115, 409, 15, 39, "Output",
 CellID->34204440]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31966, 1136, 224, 7, 70, "ExampleSubsection",
 CellID->18082488],
Cell[32193, 1145, 76, 1, 70, "ExampleText",
 CellID->47505639],
Cell[CellGroupData[{
Cell[32294, 1150, 248, 8, 70, "Input",
 CellID->51431388],
Cell[32545, 1160, 391, 14, 49, "Output",
 CellID->191312290]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[32997, 1181, 233, 7, 70, "ExampleSection",
 CellID->29979],
Cell[33233, 1190, 321, 12, 70, "ExampleText",
 CellID->27222],
Cell[CellGroupData[{
Cell[33579, 1206, 146, 5, 70, "Input",
 CellID->11536],
Cell[33728, 1213, 1013, 33, 58, "Output",
 CellID->165730245]
}, Open  ]],
Cell[CellGroupData[{
Cell[34778, 1251, 181, 6, 70, "Input",
 CellID->28714],
Cell[34962, 1259, 223, 8, 36, "Output",
 CellID->140655131]
}, Open  ]],
Cell[35200, 1270, 124, 3, 70, "ExampleDelimiter",
 CellID->80768718],
Cell[35327, 1275, 206, 7, 70, "ExampleText",
 CellID->289317600],
Cell[CellGroupData[{
Cell[35558, 1286, 515, 18, 70, "Input",
 CellID->271634407],
Cell[36076, 1306, 604, 22, 36, "Output",
 CellID->93026919]
}, Open  ]],
Cell[36695, 1331, 125, 3, 70, "ExampleDelimiter",
 CellID->291191028],
Cell[36823, 1336, 225, 7, 70, "ExampleText",
 CellID->57323525],
Cell[37051, 1345, 593, 21, 70, "Input",
 CellID->42129648],
Cell[CellGroupData[{
Cell[37669, 1370, 102, 3, 70, "Input",
 CellID->851500563],
Cell[37774, 1375, 565, 21, 36, "Output",
 CellID->173280057]
}, Open  ]],
Cell[CellGroupData[{
Cell[38376, 1401, 112, 3, 70, "Input",
 CellID->848171248],
Cell[38491, 1406, 478, 18, 41, "Output",
 CellID->103343392]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39018, 1430, 224, 7, 70, "ExampleSection",
 CellID->30208],
Cell[39245, 1439, 274, 10, 70, "ExampleText",
 CellID->23891],
Cell[CellGroupData[{
Cell[39544, 1453, 147, 5, 70, "Input",
 CellID->16326],
Cell[39694, 1460, 2956, 53, 70, "Output",
 Evaluatable->False,
 CellID->96810472]
}, Open  ]],
Cell[42665, 1516, 121, 3, 70, "ExampleDelimiter",
 CellID->16728],
Cell[CellGroupData[{
Cell[42811, 1523, 339, 11, 70, "Input",
 CellID->26214],
Cell[43153, 1536, 1285, 30, 137, "Output",
 CellID->258368670]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44499, 1573, 311, 9, 70, "SeeAlsoSection",
 CellID->14404],
Cell[44813, 1584, 2454, 89, 70, "SeeAlso",
 CellID->2802]
}, Open  ]],
Cell[CellGroupData[{
Cell[47304, 1678, 314, 9, 70, "TutorialsSection",
 CellID->26421],
Cell[47621, 1689, 179, 4, 70, "Tutorials",
 CellID->12518],
Cell[47803, 1695, 190, 4, 70, "Tutorials",
 CellID->24085],
Cell[47996, 1701, 203, 4, 70, "Tutorials",
 CellID->77317866],
Cell[48202, 1707, 183, 4, 70, "Tutorials",
 CellID->19637],
Cell[48388, 1713, 163, 3, 70, "Tutorials",
 CellID->180770870]
}, Open  ]],
Cell[CellGroupData[{
Cell[48588, 1721, 320, 9, 70, "RelatedLinksSection",
 CellID->8059],
Cell[48911, 1732, 357, 12, 70, "RelatedLinks"],
Cell[49271, 1746, 253, 5, 70, "RelatedLinks",
 CellID->1962],
Cell[49527, 1753, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49948, 1771, 320, 9, 70, "MoreAboutSection",
 CellID->1021092414],
Cell[50271, 1782, 161, 3, 70, "MoreAbout",
 CellID->102358574],
Cell[50435, 1787, 150, 3, 70, "MoreAbout",
 CellID->53363810],
Cell[50588, 1792, 147, 3, 70, "MoreAbout",
 CellID->393299465],
Cell[50738, 1797, 167, 3, 70, "MoreAbout",
 CellID->144833627],
Cell[50908, 1802, 151, 3, 70, "MoreAbout",
 CellID->880274266],
Cell[51062, 1807, 147, 3, 70, "MoreAbout",
 CellID->195490743],
Cell[51212, 1812, 169, 3, 70, "MoreAbout",
 CellID->515362443]
}, Open  ]],
Cell[51396, 1818, 50, 0, 70, "History"],
Cell[51449, 1820, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

