(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37504,       1480]
NotebookOptionsPosition[     29280,       1185]
NotebookOutlinePosition[     30651,       1224]
CellTagsIndexPosition[     30565,       1219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorSquareFree" :> 
          Documentation`HelpLookup["paclet:ref/FactorSquareFree"], 
          "FactorList" :> Documentation`HelpLookup["paclet:ref/FactorList"], 
          "FactorTermsList" :> 
          Documentation`HelpLookup["paclet:ref/FactorTermsList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FactorSquareFree\"\>", 
       2->"\<\"FactorList\"\>", 
       3->"\<\"FactorTermsList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Factoring & Decomposition\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FactorSquareFreeList", "ObjectName",
 CellID->18947],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FactorSquareFreeList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FactorSquareFreeList"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of square\[Hyphen]free factors of a \
polynomial, together with their exponents. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30678]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->44846452],

Cell["List square-free factors of a polynomial:", "ExampleText",
 CellID->73605572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"x", "^", "5"}], "-", 
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"x", "^", "2"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      SuperscriptBox["x", "3"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->620527157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6818],

Cell["List irreducible factors of a polynomial:", "ExampleText",
 CellID->340879707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"x", "^", "5"}], "-", 
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"x", "^", "2"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10884],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{300, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140619784]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11535],

Cell["A univariate polynomial:", "ExampleText",
 CellID->242436578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], "-", 
   RowBox[{"9", 
    RowBox[{"x", "^", "3"}]}], "+", 
   RowBox[{"29", 
    RowBox[{"x", "^", "2"}]}], "-", 
   RowBox[{"39", "x"}], "+", "18"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6972226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "-", 
      RowBox[{"3", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{240, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177768457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606606440],

Cell["A multivariate polynomial:", "ExampleText",
 CellID->242121446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"x", "^", "5"}], "-", 
   RowBox[{
    RowBox[{"x", "^", "3"}], 
    RowBox[{"y", "^", "2"}]}], "-", 
   RowBox[{
    RowBox[{"x", "^", "2"}], 
    RowBox[{"y", "^", "3"}]}], "+", 
   RowBox[{"y", "^", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->685335161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"2", " ", "x", " ", 
       SuperscriptBox["y", "2"]}], "+", 
      SuperscriptBox["y", "3"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{299, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->666330721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137525866],

Cell["A rational function:", "ExampleText",
 CellID->250609994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"x", "^", "2"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->582901814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["y", "2"]}]}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{304, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41416729]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26367],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Extension",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4121],

Cell["\<\
By default algebraic number coefficients are treated as independent \
variables:\
\>", "ExampleText",
 CellID->367222654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"2", 
    RowBox[{"Sqrt", "[", "2", "]"}], "x"}], "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->532318586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{190, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156117918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6512979],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " algebraic dependencies between coefficients are recognized:"
}], "ExampleText",
 CellID->200276468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "2", "]"}], "x"}], "+", "2"}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->621074522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox["2"], "+", "x"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{145, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->865705777]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29805],

Cell["Find square-free factors over the integers modulo 2:", "ExampleText",
 CellID->136667834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159056695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59836314]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32506],

Cell["List multiple factors in a trigonometric expression:", "ExampleText",
 CellID->425343965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", "x"}], "]"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->715596512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188807775]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11931],

Cell["Remove root multiplicities:", "ExampleText",
 CellID->9132693],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "9"}], "+", 
    RowBox[{"9", 
     RowBox[{"x", "^", "8"}]}], "+", 
    RowBox[{"21", 
     RowBox[{"x", "^", "7"}]}], "-", 
    RowBox[{"27", 
     RowBox[{"x", "^", "6"}]}], "-", 
    RowBox[{"153", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"81", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"239", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"207", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"108", "x"}], "-", "108"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124699302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rtsf", "=", 
  RowBox[{"x", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148987918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->390526221]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Times", "@@", 
   RowBox[{"First", "/@", 
    RowBox[{"FactorSquareFreeList", "[", "f", "]"}]}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->381490521],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"3", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{159, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27126256]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rtsg", "=", 
  RowBox[{"x", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"g", "\[Equal]", "0"}], ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->129308075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}], ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->350062937]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rtsg", "===", 
  RowBox[{"Union", "[", "rtsf", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1712738],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->478752]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25351],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorSquareFreeList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFreeList"]], "InlineFormula"],
 " gives a list of square-free factors:"
}], "ExampleText",
 CellID->57323525],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "9"}], "+", 
    RowBox[{"9", 
     RowBox[{"x", "^", "8"}]}], "+", 
    RowBox[{"21", 
     RowBox[{"x", "^", "7"}]}], "-", 
    RowBox[{"27", 
     RowBox[{"x", "^", "6"}]}], "-", 
    RowBox[{"153", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"81", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"239", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"207", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"108", "x"}], "-", "108"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42129648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->848171248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      SuperscriptBox["x", "2"]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{294, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248722278]
}, Open  ]],

Cell["This multiplies the factors together:", "ExampleText",
 CellID->156932469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "@@", 
  RowBox[{"Power", "@@@", "%"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->199469494],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "Output",
 ImageSize->{170, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->84288378]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorSquareFree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFormula"],
 " gives a product of factors:"
}], "ExampleText",
 CellID->18880447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFree", "[", 
  RowBox[{
   RowBox[{"x", "^", "8"}], "+", 
   RowBox[{"11", 
    RowBox[{"x", "^", "7"}]}], "+", 
   RowBox[{"43", 
    RowBox[{"x", "^", "6"}]}], "+", 
   RowBox[{"59", 
    RowBox[{"x", "^", "5"}]}], "-", 
   RowBox[{"35", 
    RowBox[{"x", "^", "4"}]}], "-", 
   RowBox[{"151", 
    RowBox[{"x", "^", "3"}]}], "-", 
   RowBox[{"63", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"81", "x"}], "+", "54"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->333991352],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "3"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "Output",
 ImageSize->{157, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->546223488]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " combines all the factors back together:"
}], "ExampleText",
 CellID->38308230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4415914],

Cell[BoxData[
 RowBox[{"54", "+", 
  RowBox[{"81", " ", "x"}], "-", 
  RowBox[{"63", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"151", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"35", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"59", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"43", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"11", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  SuperscriptBox["x", "8"]}]], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->89783943]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorList"]], "InlineFormula"],
 " gives a list of irreducible factors:"
}], "ExampleText",
 CellID->313938186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", "f", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->851500563],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{423, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->299591258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302812401],

Cell[TextData[{
 "A univariate polynomial has multiple factors if an only if its ",
 Cell[BoxData[
  ButtonBox["Discriminant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Discriminant"]], "InlineFormula"],
 " is zero:"
}], "ExampleText",
 CellID->399952287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Discriminant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", 
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"x", "^", "2"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453958394],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76121571]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"x", "^", "5"}], "-", 
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"x", "^", "2"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->671796515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      SuperscriptBox["x", "3"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->511596791]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Discriminant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", 
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"x", "^", "2"}], "-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48901133],

Cell[BoxData["7684"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->619607231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"x", "^", "5"}], "-", 
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"x", "^", "2"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->731249562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "5"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{191, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->177692604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->676304820],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " gives a list of prime factors of an integer:"
}], "ExampleText",
 CellID->107302986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "1234567", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6910716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"127", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9721", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->703808470]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "@@", 
  RowBox[{"Power", "@@@", "%"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45160120],

Cell[BoxData["1234567"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17249104]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15086],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorSquareFree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorSquareFree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorTermsList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorTermsList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7319]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25048],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->17361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->382784426],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->333083045]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FactorSquareFreeList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 18.3892530}", "context" -> "System`", 
    "keywords" -> {
     "multiple factors", "polynomial factors", "square-free factoring"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FactorSquareFreeList[poly] gives a list of square-free factors of a \
polynomial, together with their exponents. ", 
    "synonyms" -> {"factor square-free list"}, "title" -> 
    "FactorSquareFreeList", "type" -> "Symbol", "uri" -> 
    "ref/FactorSquareFreeList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3380, 104, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30430, 1212}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2096, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2719, 80, 58, 1, 70, "ObjectName",
 CellID->18947],
Cell[2780, 83, 563, 16, 70, "Usage",
 CellID->30678]
}, Open  ]],
Cell[CellGroupData[{
Cell[3380, 104, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3757, 118, 147, 5, 70, "ExampleSection",
 CellID->44846452],
Cell[3907, 125, 83, 1, 70, "ExampleText",
 CellID->73605572],
Cell[CellGroupData[{
Cell[4015, 130, 227, 7, 28, "Input",
 CellID->17656],
Cell[4245, 139, 566, 20, 39, "Output",
 CellID->620527157]
}, Open  ]],
Cell[4826, 162, 120, 3, 70, "ExampleDelimiter",
 CellID->6818],
Cell[4949, 167, 84, 1, 70, "ExampleText",
 CellID->340879707],
Cell[CellGroupData[{
Cell[5058, 172, 217, 7, 28, "Input",
 CellID->10884],
Cell[5278, 181, 558, 20, 39, "Output",
 CellID->140619784]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5885, 207, 216, 7, 70, "ExampleSection",
 CellID->11535],
Cell[6104, 216, 67, 1, 70, "ExampleText",
 CellID->242436578],
Cell[CellGroupData[{
Cell[6196, 221, 301, 10, 70, "Input",
 CellID->6972226],
Cell[6500, 233, 500, 18, 39, "Output",
 CellID->177768457]
}, Open  ]],
Cell[7015, 254, 125, 3, 70, "ExampleDelimiter",
 CellID->606606440],
Cell[7143, 259, 69, 1, 70, "ExampleText",
 CellID->242121446],
Cell[CellGroupData[{
Cell[7237, 264, 345, 12, 70, "Input",
 CellID->685335161],
Cell[7585, 278, 621, 21, 39, "Output",
 CellID->666330721]
}, Open  ]],
Cell[8221, 302, 125, 3, 70, "ExampleDelimiter",
 CellID->137525866],
Cell[8349, 307, 63, 1, 70, "ExampleText",
 CellID->250609994],
Cell[CellGroupData[{
Cell[8437, 312, 599, 22, 70, "Input",
 CellID->582901814],
Cell[9039, 336, 624, 23, 39, "Output",
 CellID->41416729]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9712, 365, 218, 7, 70, "ExampleSection",
 CellID->26367],
Cell[CellGroupData[{
Cell[9955, 376, 225, 7, 70, "ExampleSubsection",
 CellID->4121],
Cell[10183, 385, 131, 4, 70, "ExampleText",
 CellID->367222654],
Cell[CellGroupData[{
Cell[10339, 393, 230, 7, 70, "Input",
 CellID->532318586],
Cell[10572, 402, 420, 15, 43, "Output",
 CellID->156117918]
}, Open  ]],
Cell[11007, 420, 123, 3, 70, "ExampleDelimiter",
 CellID->6512979],
Cell[11133, 425, 362, 12, 70, "ExampleText",
 CellID->200276468],
Cell[CellGroupData[{
Cell[11520, 441, 303, 9, 70, "Input",
 CellID->621074522],
Cell[11826, 452, 344, 13, 43, "Output",
 CellID->865705777]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12219, 471, 224, 7, 70, "ExampleSubsection",
 CellID->29805],
Cell[12446, 480, 95, 1, 70, "ExampleText",
 CellID->136667834],
Cell[CellGroupData[{
Cell[12566, 485, 224, 7, 70, "Input",
 CellID->159056695],
Cell[12793, 494, 327, 12, 36, "Output",
 CellID->59836314]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13169, 512, 221, 7, 70, "ExampleSubsection",
 CellID->32506],
Cell[13393, 521, 95, 1, 70, "ExampleText",
 CellID->425343965],
Cell[CellGroupData[{
Cell[13513, 526, 252, 8, 70, "Input",
 CellID->715596512],
Cell[13768, 536, 335, 12, 36, "Output",
 CellID->188807775]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14164, 555, 223, 7, 70, "ExampleSection",
 CellID->11931],
Cell[14390, 564, 68, 1, 70, "ExampleText",
 CellID->9132693],
Cell[14461, 567, 594, 21, 70, "Input",
 CellID->124699302],
Cell[CellGroupData[{
Cell[15080, 592, 210, 7, 70, "Input",
 CellID->148987918],
Cell[15293, 601, 388, 13, 36, "Output",
 CellID->390526221]
}, Open  ]],
Cell[CellGroupData[{
Cell[15718, 619, 198, 6, 70, "Input",
 CellID->381490521],
Cell[15919, 627, 423, 16, 39, "Output",
 CellID->27126256]
}, Open  ]],
Cell[CellGroupData[{
Cell[16379, 648, 210, 7, 70, "Input",
 CellID->129308075],
Cell[16592, 657, 291, 10, 36, "Output",
 CellID->350062937]
}, Open  ]],
Cell[CellGroupData[{
Cell[16920, 672, 130, 4, 70, "Input",
 CellID->1712738],
Cell[17053, 678, 158, 5, 36, "Output",
 CellID->478752]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17260, 689, 233, 7, 70, "ExampleSection",
 CellID->25351],
Cell[17496, 698, 237, 7, 70, "ExampleText",
 CellID->57323525],
Cell[17736, 707, 593, 21, 70, "Input",
 CellID->42129648],
Cell[CellGroupData[{
Cell[18354, 732, 116, 3, 70, "Input",
 CellID->848171248],
Cell[18473, 737, 598, 22, 39, "Output",
 CellID->248722278]
}, Open  ]],
Cell[19086, 762, 80, 1, 70, "ExampleText",
 CellID->156932469],
Cell[CellGroupData[{
Cell[19191, 767, 126, 4, 70, "Input",
 CellID->199469494],
Cell[19320, 773, 477, 18, 41, "Output",
 CellID->84288378]
}, Open  ]],
Cell[19812, 794, 220, 7, 70, "ExampleText",
 CellID->18880447],
Cell[CellGroupData[{
Cell[20057, 805, 521, 18, 70, "Input",
 CellID->333991352],
Cell[20581, 825, 432, 16, 41, "Output",
 CellID->546223488]
}, Open  ]],
Cell[21028, 844, 212, 7, 70, "ExampleText",
 CellID->38308230],
Cell[CellGroupData[{
Cell[21265, 855, 100, 3, 70, "Input",
 CellID->4415914],
Cell[21368, 860, 594, 20, 36, "Output",
 CellID->89783943]
}, Open  ]],
Cell[21977, 883, 218, 7, 70, "ExampleText",
 CellID->313938186],
Cell[CellGroupData[{
Cell[22220, 894, 106, 3, 70, "Input",
 CellID->851500563],
Cell[22329, 899, 712, 26, 36, "Output",
 CellID->299591258]
}, Open  ]],
Cell[23056, 928, 125, 3, 70, "ExampleDelimiter",
 CellID->302812401],
Cell[23184, 933, 262, 8, 70, "ExampleText",
 CellID->399952287],
Cell[CellGroupData[{
Cell[23471, 945, 250, 8, 70, "Input",
 CellID->453958394],
Cell[23724, 955, 157, 5, 36, "Output",
 CellID->76121571]
}, Open  ]],
Cell[CellGroupData[{
Cell[23918, 965, 231, 7, 70, "Input",
 CellID->671796515],
Cell[24152, 974, 566, 20, 39, "Output",
 CellID->511596791]
}, Open  ]],
Cell[CellGroupData[{
Cell[24755, 999, 249, 8, 70, "Input",
 CellID->48901133],
Cell[25007, 1009, 161, 5, 36, "Output",
 CellID->619607231]
}, Open  ]],
Cell[CellGroupData[{
Cell[25205, 1019, 231, 7, 70, "Input",
 CellID->731249562],
Cell[25439, 1028, 454, 16, 39, "Output",
 CellID->177692604]
}, Open  ]],
Cell[25908, 1047, 125, 3, 70, "ExampleDelimiter",
 CellID->676304820],
Cell[26036, 1052, 232, 7, 70, "ExampleText",
 CellID->107302986],
Cell[CellGroupData[{
Cell[26293, 1063, 113, 3, 70, "Input",
 CellID->6910716],
Cell[26409, 1068, 307, 11, 36, "Output",
 CellID->703808470]
}, Open  ]],
Cell[CellGroupData[{
Cell[26753, 1084, 125, 4, 70, "Input",
 CellID->45160120],
Cell[26881, 1090, 163, 5, 36, "Output",
 CellID->17249104]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27105, 1102, 311, 9, 70, "SeeAlsoSection",
 CellID->15086],
Cell[27419, 1113, 729, 26, 70, "SeeAlso",
 CellID->7319]
}, Open  ]],
Cell[CellGroupData[{
Cell[28185, 1144, 314, 9, 70, "TutorialsSection",
 CellID->25048],
Cell[28502, 1155, 180, 4, 70, "Tutorials",
 CellID->17361]
}, Open  ]],
Cell[CellGroupData[{
Cell[28719, 1164, 319, 9, 70, "MoreAboutSection",
 CellID->382784426],
Cell[29041, 1175, 167, 3, 70, "MoreAbout",
 CellID->333083045]
}, Open  ]],
Cell[29223, 1181, 27, 0, 70, "History"],
Cell[29253, 1183, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

