(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28028,        979]
NotebookOptionsPosition[     22631,        795]
NotebookOutlinePosition[     24125,        835]
CellTagsIndexPosition[     24040,        830]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Structural Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Structural Operations on Polynomials\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Factor" :> Documentation`HelpLookup["paclet:ref/Factor"], 
          "FactorTermsList" :> 
          Documentation`HelpLookup["paclet:ref/FactorTermsList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Factor\"\>", 
       2->"\<\"FactorTermsList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Factoring & Decomposition\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FactorTerms", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FactorTerms",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FactorTerms"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]pulls out any overall numerical factor in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FactorTerms",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FactorTerms"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pulls out any overall factor in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " that does not depend on ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FactorTerms",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FactorTerms"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pulls out any overall factor in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " that does not depend on any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->19039]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FactorTerms",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorTerms"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " extracts the content of ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16449],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 " automatically threads over lists in ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 ", as well as equations, inequalities and logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->535065566],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->102395436],

Cell["\<\
Pull out an overall numerical factor, but do no further factoring:\
\>", "ExampleText",
 CellID->12716641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{"3", "+", 
   RowBox[{"6", "x"}], "+", 
   RowBox[{"3", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45294692],

Cell[BoxData[
 RowBox[{"3", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{90, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1383072]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1632],

Cell["Define a larger polynomial:", "ExampleText",
 CellID->86884324],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"2", "a", " ", 
     RowBox[{"x", "^", "2"}], "y"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}], "y"}], "+", 
    RowBox[{"4", "a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"a", "^", "2"}], 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"4", "a", " ", 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"a", "^", "2"}], "y"}], "+", 
    RowBox[{"2", "a", " ", "y"}], "-", 
    RowBox[{"6", "y"}], "-", 
    RowBox[{"12", "a"}], "-", "12"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342528313],

Cell["Pull out an overall numerical factor:", "ExampleText",
 CellID->490293787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->797617060],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "6"}], "-", 
    RowBox[{"6", " ", "a"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"a", " ", "y"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "y"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["y", "2"]}]}], ")"}]}]], "Output",
 ImageSize->{433, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41246419]
}, Open  ]],

Cell[TextData[{
 "Pull out factors that do not depend on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->472727191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->199710368],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", "a"}], "+", "y", "+", 
    RowBox[{"a", " ", "y"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"2", " ", "a", " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{211, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22020616]
}, Open  ]],

Cell[TextData[{
 "Pull out factors that do not depend on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and then factors that do not depend on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->219394186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->68862429],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "a"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "y"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"2", " ", "a", " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{195, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->205332416]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->421010266],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25151],

Cell["Pull out overall numerical factor over integers modulo 7:", \
"ExampleText",
 CellID->291345657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "x"}], "+", "10"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289837268],

Cell[BoxData[
 RowBox[{"3", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148008020]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20668],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " distributes the common factor over the terms, effectively reverting ",
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27652305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{
   RowBox[{"14", "x"}], "+", 
   RowBox[{"21", "y"}], "+", 
   RowBox[{"35", "x", " ", "y"}], "+", "63"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89863915],

Cell[BoxData[
 RowBox[{"7", " ", 
  RowBox[{"(", 
   RowBox[{"9", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"5", " ", "x", " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429723721]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127130933],

Cell[BoxData[
 RowBox[{"63", "+", 
  RowBox[{"14", " ", "x"}], "+", 
  RowBox[{"21", " ", "y"}], "+", 
  RowBox[{"35", " ", "x", " ", "y"}]}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2553058]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2370329],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorTermsList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTermsList"]], "InlineFormula"],
 " gives a list of factors:"
}], "ExampleText",
 CellID->226667290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", 
  RowBox[{
   RowBox[{"14", "x"}], "+", 
   RowBox[{"21", "y"}], "+", 
   RowBox[{"35", "x", " ", "y"}], "+", "63"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33710373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"9", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"5", " ", "x", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136344679]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->618912857],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " performs a complete factorization:"
}], "ExampleText",
 CellID->326884617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{"x", "^", "3"}]}], "-", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159360220],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "3"]}], ")"}]}]], "Output",
 ImageSize->{68, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->814330394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6341319],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{132, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->302588564]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21183],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorTermsList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorTermsList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27446]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16970],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->312],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "Tutorials",
 CellID->22208]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->76169885],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->339670726]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FactorTerms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 20.5768090}", "context" -> "System`", 
    "keywords" -> {
     "common factors", "content", "numerical factors", "overall factors"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FactorTerms[poly] pulls out any overall numerical factor in poly. \
FactorTerms[poly, x] pulls out any overall factor in poly that does not \
depend on x. FactorTerms[poly, {x_1, x_2, ...}] pulls out any overall factor \
in poly that does not depend on any of the x_i. ", 
    "synonyms" -> {"factor terms"}, "title" -> "FactorTerms", "type" -> 
    "Symbol", "uri" -> "ref/FactorTerms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10400, 287, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->535065566]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23896, 823}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2166, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2789, 81, 4195, 83, 70, "ObjectNameGrid"],
Cell[6987, 166, 1949, 62, 70, "Usage",
 CellID->19039]
}, Open  ]],
Cell[CellGroupData[{
Cell[8973, 233, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9451, 250, 444, 17, 70, "Notes",
 CellID->16449],
Cell[9898, 269, 465, 13, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[10400, 287, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->535065566],
Cell[CellGroupData[{
Cell[10785, 301, 148, 5, 70, "ExampleSection",
 CellID->102395436],
Cell[10936, 308, 116, 3, 70, "ExampleText",
 CellID->12716641],
Cell[CellGroupData[{
Cell[11077, 315, 202, 7, 28, "Input",
 CellID->45294692],
Cell[11282, 324, 286, 10, 39, "Output",
 CellID->1383072]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11617, 340, 215, 7, 70, "ExampleSection",
 CellID->1632],
Cell[11835, 349, 69, 1, 70, "ExampleText",
 CellID->86884324],
Cell[11907, 352, 694, 23, 70, "Input",
 CellID->342528313],
Cell[12604, 377, 80, 1, 70, "ExampleText",
 CellID->490293787],
Cell[CellGroupData[{
Cell[12709, 382, 107, 3, 70, "Input",
 CellID->797617060],
Cell[12819, 387, 853, 27, 39, "Output",
 CellID->41246419]
}, Open  ]],
Cell[13687, 417, 160, 6, 70, "ExampleText",
 CellID->472727191],
Cell[CellGroupData[{
Cell[13872, 427, 130, 4, 70, "Input",
 CellID->199710368],
Cell[14005, 433, 445, 15, 39, "Output",
 CellID->22020616]
}, Open  ]],
Cell[14465, 451, 329, 12, 70, "ExampleText",
 CellID->219394186],
Cell[CellGroupData[{
Cell[14819, 467, 178, 6, 70, "Input",
 CellID->68862429],
Cell[15000, 475, 433, 15, 39, "Output",
 CellID->205332416]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15482, 496, 222, 7, 70, "ExampleSection",
 CellID->421010266],
Cell[CellGroupData[{
Cell[15729, 507, 224, 7, 70, "ExampleSubsection",
 CellID->25151],
Cell[15956, 516, 102, 2, 70, "ExampleText",
 CellID->291345657],
Cell[CellGroupData[{
Cell[16083, 522, 211, 7, 70, "Input",
 CellID->289837268],
Cell[16297, 531, 227, 8, 36, "Output",
 CellID->148008020]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16585, 546, 233, 7, 70, "ExampleSection",
 CellID->20668],
Cell[16821, 555, 372, 12, 70, "ExampleText",
 CellID->27652305],
Cell[CellGroupData[{
Cell[17218, 571, 220, 7, 70, "Input",
 CellID->89863915],
Cell[17441, 580, 333, 11, 36, "Output",
 CellID->429723721]
}, Open  ]],
Cell[CellGroupData[{
Cell[17811, 596, 102, 3, 70, "Input",
 CellID->127130933],
Cell[17916, 601, 282, 9, 36, "Output",
 CellID->2553058]
}, Open  ]],
Cell[18213, 613, 123, 3, 70, "ExampleDelimiter",
 CellID->2370329],
Cell[18339, 618, 216, 7, 70, "ExampleText",
 CellID->226667290],
Cell[CellGroupData[{
Cell[18580, 629, 224, 7, 70, "Input",
 CellID->33710373],
Cell[18807, 638, 333, 11, 36, "Output",
 CellID->136344679]
}, Open  ]],
Cell[19155, 652, 125, 3, 70, "ExampleDelimiter",
 CellID->618912857],
Cell[19283, 657, 208, 7, 70, "ExampleText",
 CellID->326884617],
Cell[CellGroupData[{
Cell[19516, 668, 174, 6, 70, "Input",
 CellID->159360220],
Cell[19693, 676, 273, 10, 39, "Output",
 CellID->814330394]
}, Open  ]],
Cell[CellGroupData[{
Cell[20003, 691, 100, 3, 70, "Input",
 CellID->6341319],
Cell[20106, 696, 341, 12, 39, "Output",
 CellID->302588564]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20508, 715, 311, 9, 70, "SeeAlsoSection",
 CellID->21183],
Cell[20822, 726, 461, 17, 70, "SeeAlso",
 CellID->27446]
}, Open  ]],
Cell[CellGroupData[{
Cell[21320, 748, 314, 9, 70, "TutorialsSection",
 CellID->16970],
Cell[21637, 759, 188, 4, 70, "Tutorials",
 CellID->312],
Cell[21828, 765, 183, 4, 70, "Tutorials",
 CellID->22208]
}, Open  ]],
Cell[CellGroupData[{
Cell[22048, 774, 318, 9, 70, "MoreAboutSection",
 CellID->76169885],
Cell[22369, 785, 167, 3, 70, "MoreAbout",
 CellID->339670726]
}, Open  ]],
Cell[22551, 791, 50, 0, 70, "History"],
Cell[22604, 793, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

